/*------------------------------------------------------------------------------*
 * File Name: BatchProcess.h													*
 * Creation: Feb 28, 2011														*
 * Purpose: Analysis Batch Processing											*
 * Copyright (c) OriginLab Corp. 2011 2012										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Folger 09/14/2011 ORG-3787-S1 BATCH_PROCESS_INTERMEDIATE_BOOK_NAME_LT_ACCESS*
 *	Folger 09/15/2011 ORG-3805-P1 SPECIFY_ROW_FAILED_TO_WORK_IN_BATCH_PROCESS	*
 *	Folger 12/09/2011 ORG-4566-P1 BATCH_PROCESS_FAILED_WHEN_COPY_COL_SOURCE_SAME_AS_DEST
 *	Folger 07/04/2012 ORG-6071-S1 BATCH_PROCESS_SUPPORT_COPY_YERR				*
 *	Folger 07/09/2012 ORG-6159-P1 BATCH_PROCESS_FAILED_TO_RUN_WKS_SCRIPT_AFTER_IMPORT
 *	Folger 07/31/2012 ORG-6398-S1 BATCH_PROCESSING_INDEX_LT_SUPPORT				*
 *------------------------------------------------------------------------------*/

class BatchProcessingBase
{
public:
	BatchProcessingBase();
	~BatchProcessingBase();
	
	LPCSTR				lpcszAnalysisTemplate;
	LPCSTR				lpcszFillSheet;
	LPCSTR				lpcszAppend;
	Worksheet			wksSummary;
	BOOL				bAppendByRows;
	BOOL				bClearSummarySheetBeforeAppend;
	BOOL				bDeleteTempateWindowsAfterAppend;
	LPCSTR				lpcszScriptAfterEachProcess;
	LPCSTR				lpcszScriptAtTheEnd;
	int					nRowStart;
	BOOL				bAppendLabelRows;
	LPCSTR				lpcszLabel;
	
	virtual		int		Execute();
	
protected:
	void				BeforeExecute();	
	void				AfterExecute();	
	virtual	BOOL		PrepareProcessing(int ii, int nSize, LPCSTR lpcszTip);
	int					AppendSummary(int ii);

	int					GetLabelType();	

	WorksheetPage		m_wksPage;
	Worksheet			m_wksImport;
	
	BOOL				m_bUseActivePage;
	BOOL				m_bNeedAppend;
	
	progressBox*		m_ppb;
	BOOL				m_pbHide;
	
	vector<string>		m_vsBooks;
	
	int					m_nActiveSheet;
	int					m_nLabelType;

	///------ Folger 07/31/2012 ORG-6398-S1 BATCH_PROCESSING_INDEX_LT_SUPPORT
	string				ProcessingIndex() { return "I"; }
	void				SetProcessingIndex(double index) { LT_set_var(ProcessingIndex(), index); }
///------ End BATCH_PROCESSING_INDEX_LT_SUPPORT
	
private:
	virtual	void		MakeLabelType();
	virtual	string		GetDataIdentifier(int ii);

	void				ExecuteAllDirtyOperations();
	void				ClearLabtalkStrVariable();

	DWORD				AppendCtrl();
	///------ Folger 09/14/2011 ORG-3787-S1 BATCH_PROCESS_INTERMEDIATE_BOOK_NAME_LT_ACCESS
	string				ProcessingLTBookName()		{ return LT_SYS_STR_PREFIX "BATCHBOOK"; }
	///------ End BATCH_PROCESS_INTERMEDIATE_BOOK_NAME_LT_ACCESS

	///------ Folger 07/31/2012 ORG-6398-S1 BATCH_PROCESSING_INDEX_LT_SUPPORT
	LTVarTempChange*	m_pIndexTempChange;
	///------ End BATCH_PROCESSING_INDEX_LT_SUPPORT
};

class BatchProcessingOnFiles : public BatchProcessingBase
{
public:
	BatchProcessingOnFiles();
	~BatchProcessingOnFiles();

	BOOL				bUseLastImportSettings;
	StringArray*		psaFiles;
	LPCSTR				lpcszImportXF;
	LPCSTR				lpcszTheme;
	LPCSTR				lpcszFilter;
	LPCSTR				lpcszScript;
	LPCSTR				lpcszCol;
	
	virtual		int		Execute();

protected:
	virtual	BOOL		PrepareProcessing(int ii, int nSize, LPCSTR lpcszTip);
	
private:
	virtual	void		MakeLabelType();
	virtual	string		GetDataIdentifier(int ii);

	void				PrepareThemeAndFilter(TreeNode& trFilter);

	///------ Folger 07/09/2012 ORG-6159-P1 BATCH_PROCESS_FAILED_TO_RUN_WKS_SCRIPT_AFTER_IMPORT
	void CheckRunScriptAfterImport();
	///------ End BATCH_PROCESS_FAILED_TO_RUN_WKS_SCRIPT_AFTER_IMPORT

	Array<Column&>		m_arrSrcCols;
};

class BatchProcessingOnXYRange : public BatchProcessingBase
{
public:
	///------ Folger 12/09/2011 ORG-4566-P1 BATCH_PROCESS_FAILED_WHEN_COPY_COL_SOURCE_SAME_AS_DEST
	~BatchProcessingOnXYRange();
	///------ End BATCH_PROCESS_FAILED_WHEN_COPY_COL_SOURCE_SAME_AS_DEST
	XYRange				iy;
	
	virtual		int		Execute();
	
private:
	XYRange				GetXYRange(int ii);	
	virtual	void		MakeLabelType();
	virtual	string		GetDataIdentifier(int ii);
	
	DWORD				DataRules();
	///------ Folger 07/04/2012 ORG-6071-S1 BATCH_PROCESS_SUPPORT_COPY_YERR
	//BOOL				CheckTargetColumns(Column& col1, Column& col2);
	BOOL				CheckTargetColumns(Column& col1, Column& col2, Column& col3);
	///------ End BATCH_PROCESS_SUPPORT_COPY_YERR

	void				CopyXYColumns(Column& colDesX, Column& colDesY, Column& colSrcX, Column& colSrcY, int nTargetType
						///------ Folger 09/15/2011 ORG-3805-P1 SPECIFY_ROW_FAILED_TO_WORK_IN_BATCH_PROCESS
						, int nR1, int nR2
						///------ End SPECIFY_ROW_FAILED_TO_WORK_IN_BATCH_PROCESS
						///------ Folger 07/04/2012 ORG-6071-S1 BATCH_PROCESS_SUPPORT_COPY_YERR
						, Column& colDesYErr
						, Column& colSrcYErr
						///------ End BATCH_PROCESS_SUPPORT_COPY_YERR
						);

	///------ Folger 12/09/2011 ORG-4566-P1 BATCH_PROCESS_FAILED_WHEN_COPY_COL_SOURCE_SAME_AS_DEST
	bool				CopyCol(Column& colSrc, Column& colDes, int nR1, int nR2, vectorbase** ppv);
	void				CheckRestoreXYData(Column& colDesX, Column& colDesY);
	void				RestoreData(Column& col, vectorbase& vData);
	vectorbase*			m_pVX;
	vectorbase*			m_pVY;
	vectorbase*			m_pVYErr; ///------ Folger 07/04/2012 ORG-6071-S1 BATCH_PROCESS_SUPPORT_COPY_YERR
	///------ End BATCH_PROCESS_FAILED_WHEN_COPY_COL_SOURCE_SAME_AS_DEST
};

class TemplateSheetsInfo
{
public:
	vector<string>		vsSheetNames;
	vector<bool>		vbHasSheetTheme;
	vector<bool>		vbExcluded;
	vector<string>		vsLabels;
	vector<string>		vsCols;
	Tree				trFilter;

	void				Init(LPCSTR lpcszName, LPCSTR lpcszXFName);

private:
	BOOL				UpdateSheetFilterIndices(vector<int>& vnIndices, Worksheet& wks);
	void				UpdateLabelInfo(Worksheet& wks);
	void				UpdateColumnInfo(Worksheet& wks);

	BOOL				CheckAddXYRangeInfo(vector<string>& vsCols, DataRange& dr);
	BOOL				CheckAddXYZRangeInfo(vector<string>& vsCols, DataRange& dr);
	BOOL				CheckAddNormalRangeInfo(vector<string>& vsCols, DataRange& dr);
};

#define ITEM_SEPARATOR					'|'
#define	STR_ITEM_SEPARATOR				"|"
#define FILE_LIST_SEPARATOR				'\n'
#define STR_PATH_FINAL_BACKSLASH		"\\"

#define	STR_EMPTY_COMBO					" " STR_ITEM_SEPARATOR

TemplateSheetsInfo&		get_template_sheets_info(LPCSTR lpcszName = NULL, LPCSTR lpcszXFName = NULL);
string					init_xf_theme_list(TreeNode& trGetN, LPCSTR lpcszMethod = NULL, LPCSTR lpcszFillSheet = NULL);
bool					init_import_wizard_filter_list(TreeNode& trGetN, LPCSTR fname = NULL);
void					check_append_pipe_char(string& str);
