/*--------------------------------------------------------------------------------------*
 * File Name: AxesDlg.h																	*
 * Creation : 																			*
 * Purpose: OriginC Source H file														*
 * Copyright (c) Originlab Corp.	2006												*
 * All Rights Reserved																	*
 * 																						*
 * Modification Log:																	*
 * Jasmine 09/13/2011 ORG-3297 SELECT_RELATIVE_NODES_TO_APPLY_SETTINGS_TO_MULTIP_AXES	*
 *	RVD 9/21/2011 ORG-3732-s1 SPIDER_INDIVIDUAL_SCALE									*
 *	Bill 10/19/2011 ORG-3747-P2 DETECT_UNDEFINE_CHANGE									*
 * Iris 6/21/2012 ORG-5991-S2 EXCHANGE_YAXIS_LEFT_AND_RIGHT_BRANCH						*
 * Iris 6/21/2012 ORG-5991-S4 MOVE_SPECIAL_TICK_LABEL_OUTSIDE_LABELS_BRANCH				*
 * Iris 9/14/2012 ORG-6834-P1 FIX_LOG_SCALE_TYPE_INCREMENT_ISSUES						*
 *	Folger 09/19/2012 QA-1291-P2 NEW_AXES_DLG_SHOULD_OPEN_CORRECT_HELP					*
 *--------------------------------------------------------------------------------------*/
#ifndef AXES_DLG_H
#define AXES_DLG_H

#define WM_USER_ON_EDIT_TREE_CHANGED 		(WM_USER + 1001)
#define WM_USER_ON_TREE_VIEW_SELECT_CHANGED	(WM_USER + 1002)		///Jasmine 09/13/2011 ORG-3297 SELECT_RELATIVE_NODES_TO_APPLY_SETTINGS_TO_MULTIP_AXES	

/// Iris 6/04/2012 ORG-5528-S4 SET_3DGL_AXES_DLG_DEFAULT_LAYOUT
//#define STR_AXES_DLG_NAME							"Spider Axes Dialog"
#define STR_SPIDER_AXES_DLG_NAME					"Spider Axes Dialog"
#define STR_3DGL_AXES_DLG_NAME						"3DGL Axes Dialog"
#define STR_2DGL_AXES_DLG_NAME						"2d Axes Dialog"
///End SET_3DGL_AXES_DLG_DEFAULT_LAYOUT
#define STR_REG_SELECTED_OBJ_DATAID								"SelectedObjectDataID"
#define STR_REG_IS_USE_SAME_OPTIONS_FOR_ALL_AXES				"IsUseSameOptionsForAllAxes"
/// Iris 7/19/2012 ORG-5991-P13 SAVE_SAME_OPTIONS_TO_GRAPH_NOT_REGISTRY
//#define STR_REG_IS_USE_SAME_OPTIONS_FOR_BOTH_DIRECTIONS_3DGL	"IsUseSameOptionsForBothDirectionsIn3DGL" /// Iris 6/07/2012 ORG-5528-P10 SAVE_SAME_OPTIONS_FOR_BOTH_DIRECTIONS_TO_REGISTRY
#define STR_AXES_DLG_SETTINGS						"AxesDlgSettings"
#define STR_USE_SAME_OPTIOINS						"UseSameOptions"
///End SAVE_SAME_OPTIONS_TO_GRAPH_NOT_REGISTRY

#define	ID_NEW_AXES					OTID_NEWAXES
#define	ID_NEW_AXIS					OTID_NEWAXIS
#define	TAG_NEW_AXES				NewAxes
#define STR_NEW_AXES				"NewAxes"
#define STR_NEW_AXIS				"NewAxis"

#define ID_AXES						OTID_AXES
#define	ID_AXIS						OTID_AXIS
#define	TAG_AXES					Axes
#define STR_AXES					"Axes"
#define STR_AXIS					"Axis"

#define OTID_RADIAL_AXIS			OTID_NEWAXIS - 1

/// Iris 4/28/2012 ORG-5528-S1 AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
typedef struct tagCustomOptions
{
	bool bIncAdditionalLines; // Line branch if include Additional lines
	bool bIncAxisPosition; // Line branch if include Position and Offset control	
	bool bIncTitleShow; // if contains Show checkbox in Title sub branch
	bool bIncTitleText; // if contains Text edit box in Title sub branch
	/// Iris 6/13/2012 ORG-5991 MOVE_TICKS_AND_LINE_BRANCH_INTO_AXIS_FORMAT_BRANCH
	//bool bTickSettingsInScale; // if include Increment Value, Major tick count etc. in Scale branch		
	//bool bIncFirstTick; 
	///End MOVE_TICKS_AND_LINE_BRANCH_INTO_AXIS_FORMAT_BRANCH
	bool bIncBreak;	// if contains Break branch under eack axis
}CustomOptions;

typedef struct tagThemeUpdateInfo
{
	TreeNode trEditNode;
	TreeNode trEditBranch;		
	bool bNeedToUpdateTheme;
	bool bNeedToUpdateGUI;	
	bool bShowListContent;
}ThemeUpdateInfo;
///End AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH

/// Iris 8/10/2012 ORG-6463-S3 MOVE_PRIMARY_AND_SECONDARY_SHOW_PROPERTY_TO_PROPERTY_BRANCH
enum 
{
	SHOW_PRIMARY_ONLY_UNDEFINED = -1, // means the status not set ready, all logic keep the original.
	SHOW_PRIMARY_ONLY_UNCHECKED,
	SHOW_PRIMARY_ONLY_CHECKED,	
};
///End MOVE_PRIMARY_AND_SECONDARY_SHOW_PROPERTY_TO_PROPERTY_BRANCH

class AxesTreeView : public GridTreeControl
{
public:
	void Init()
	{
		SetAllowSelection(true);
		SetSelection(flexSelectionListBox);
		m_flx.Editable = flexEDNone;	
	}
};


class AxesControlSplitter : public TreeDynaSplitter
{
public:
	AxesControlSplitter();
	~AxesControlSplitter();

	/// Iris 6/04/2012 ORG-5528-S4 SET_3DGL_AXES_DLG_DEFAULT_LAYOUT
	virtual string GetDlgName() { ASSERT(false); return ""; }
	///End SET_3DGL_AXES_DLG_DEFAULT_LAYOUT
	
	/// Iris 6/07/2012 ORG-5528-P10 SAVE_SAME_OPTIONS_FOR_BOTH_DIRECTIONS_TO_REGISTRY
	/// Iris 7/19/2012 ORG-5991-P13 SAVE_SAME_OPTIONS_TO_GRAPH_NOT_REGISTRY
	//string CheckGetIsUseSameOptionsForBothDirectionsSettings();	
	virtual void SaveSettingsBeforeDialogClose() {}
	///End SAVE_SAME_OPTIONS_TO_GRAPH_NOT_REGISTRY
	///End SAVE_SAME_OPTIONS_FOR_BOTH_DIRECTIONS_TO_REGISTRY
	
	bool Apply(bool bFromApplyButton);
	/// Iris 9/13/2012 ORG-6821 FIX_DBCLICK_ON_AXES_TO_OPEN_AXES_DLG_GO_TO_INCORRECT_AXIS_BRANCH
	//virtual void SetDefaultAxis(int nAxis) { m_nDefaultAxis = nAxis; }	
	virtual void SetDefaultAxis(int nDim, int nAxisIndex) { m_nDefaultAxis = nAxisIndex; }
	///End FIX_DBCLICK_ON_AXES_TO_OPEN_AXES_DLG_GO_TO_INCORRECT_AXIS_BRANCH
	void SetLayerType(int nLayerType) { m_nLayerType = nLayerType; }
	void SetDefaultObjectType(int nObjectType) { m_nDefaultObjectType = nObjectType; }
	void SetLastTimeSelectedObjectDataID(int nDataID) { m_nLastTimeSelectedNodeDataID = nDataID; }
	bool IsUseLastTimeSelected() { return m_bUseLastTimeSelected; } /// Iris 6/13/2012 ORG-5930-P3 NOT_USE_LAST_TIME_SELECTED_OBJ_FOR_3D_GRAPH
	void SetDlgOptions(DWORD dwOptions) { m_dwDlgOptions = dwOptions; }  /// Iris 6/08/2012 ORG-5930-P2 OPEN_AXIS_DIALOG_WHEN_SELECT_FROM_FORMAT_AXIS_TITLE
	
	//int  GetSelectedNodeDataID();
	void SetIsControlForAllAxes(bool bForAll) { m_bForAll = bForAll; }
	/// Iris 7/19/2012 ORG-5991-P13 SAVE_SAME_OPTIONS_TO_GRAPH_NOT_REGISTRY
	//void SetIsUseSameOptionsForBothDirectionsSettings(LPCSTR lpcszSettings) { m_strSameOptionsForBothSettings = lpcszSettings; }
	///End SAVE_SAME_OPTIONS_TO_GRAPH_NOT_REGISTRY
	void UpdateOnApplyForAllChanged();
	void SetEditTreeChange() { m_bEditTreeChanged = true; } /// Iris 8/14/2012 ORG-6463-S4 CHANGE_SUB_AXIS_NAMING_RULE
	bool IsEditTreeChanged() { return m_bEditTreeChanged; }	
	///Jasmine 09/13/2011 ORG-3297 SELECT_RELATIVE_NODES_TO_APPLY_SETTINGS_TO_MULTIP_AXES	
	BOOL OnShowMenu(UINT nResIDCtrl, int nx, int ny);			
	bool IsSelectAxisSubNode();
	void SelectRelativeNodes();
	///End SELECT_RELATIVE_NODES_TO_APPLY_SETTINGS_TO_MULTIP_AXES
	
	/// RVD 9/21/2011 ORG-3732-s1 SPIDER_INDIVIDUAL_SCALE
//	void	SetAutoscaleAxesIndependently(BOOL bSet);
//	BOOL	IsAutoscaleAxesIndependently();
	/// end SPIDER_INDIVIDUAL_SCALE	
	
	/// Iris 5/21/2012 ORG-5528-S6 REMOVE_SAME_OPTIONS_FOR_ALL_BUTTON_FOR_2D_AND_3DGL_GRAPH
	virtual bool IsEnableForAll() { return false; }
	///End REMOVE_SAME_OPTIONS_FOR_ALL_BUTTON_FOR_2D_AND_3DGL_GRAPH
	
	/// Iris 8/06/2012 ORG-5991-S7 DB_CLICK_TO_OPEN_CLOSE_BRANCH
	virtual bool HasShowPrimaryOnlyCheckbox() { return false; }
	virtual int GetShowPrimaryAxesOnlyStatus() { return SHOW_PRIMARY_ONLY_UNDEFINED; }
	virtual bool IsShowPrimaryAxesOnly() { return false; }
	/// Iris 8/08/2012 ORG-6463-S3 ADD_AXIS_SHOW_PROPERTY_IN_AXIS_ROOT_BRANCH
	//virtual void SetShowPrimaryAxesOnly(bool bIs, bool bUpdateTheme, bool bUpdateListTree) { ; } 
	virtual void SetShowPrimaryAxesOnly(bool bIs, int nEvent, TreeNode* ptrGetN = NULL) { ; } 
	///End ADD_AXIS_SHOW_PROPERTY_IN_AXIS_ROOT_BRANCH
	///End DB_CLICK_TO_OPEN_CLOSE_BRANCH
	
protected:
	DECLARE_MESSAGE_MAP

	BOOL OnInitSplitter();
	void OnBeforeTreeViewSelection(Control ctrl, long nOldRow, long nOldCol, long nNewRow, long nNewCol, BOOL* pbCancle);
	void OnTreeViewSelectChange(Control ctrl);
	void OnTreeViewDBClick(Control ctrl); /// Iris 8/06/2012 ORG-5991-S7 DB_CLICK_TO_OPEN_CLOSE_BRANCH
	void OnEditRowChange(Control ctrl);
	void OnEditTreeBeforeEdit(Control cntrl, int nRow, int nCol, BOOL* pCancel);
	void OnUndefineChange(int nRow, int nCol);	/// Bill 10/19/2011 ORG-3747-P2 DETECT_UNDEFINE_CHANGE
	void OnEditTreeAfterValueChange(int nRow, DWORD lParam);
	
protected:
	/// Iris 8/06/2012 ORG-6463-S1 ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
	// tree view display properties
	DWORD GetListTreeDisplayCtrl();
	virtual int GetStopLevel() { return LEVEL_AXIS_PROPERTY_BRANCH; }	
	///End ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
	
	// new 	
	virtual int GetRepeatIndex(bool bMajor, int nAxis = -1) { return bMajor ? 1 : 2; }		
	
	virtual void GetAxisPropertyCustomOptions() { ASSERT(false); }
	
	virtual void ConstructScaleBranchNodes(TreeNode& trAxis);
	virtual void ConstructTickValuesPropertyNodes(TreeNode& trScale); /// Iris 6/13/2012 ORG-5991 MOVE_TICKS_AND_LINE_BRANCH_INTO_AXIS_FORMAT_BRANCH
	
	virtual void ConstructGridsBranchNodes(TreeNode& trBranch, int nAxis = -1);
	virtual void ConstructGridPropertyNodes(TreeNode& trGridBranch, bool bMajor);
	
	virtual void ConstructLineBranchNodes(TreeNode& trBranch, int nAxis = -1);
	virtual void ConstructLinePropertyNodes(TreeNode& trBranch, int nAxis = -1);
	
	virtual void ConstructTitleBranchNodes(TreeNode& trBranch, int nAxis = -1);
	virtual void ConstructTitlePropertyNodes(TreeNode& trBranch, int nAxis = -1);
	
	virtual void ConstructTicksBranchNodes(TreeNode& trBranch, int nAxis = -1);
	virtual void ConstructTicksMajorMinorBranchNodes(TreeNode& trBranch, int nAxis = -1);
	virtual void ConstructTicksPropertyNodes(TreeNode& trBranch, bool bMajor);	
	
	virtual void ConstructLabelsBranchNodes(TreeNode& trAxis, int nAxis = -1) {}
	
	TreeNode 	AddAxisSubBranchNode(TreeNode& trParent, int nBaseID, int nAxis = -1, int nSub = 0, string* pstrSubAxisName = NULL);
	int 	    GetAxisIndex(TreeNode& trEditNode, int nListSelRow = -1);	
	int			GetPrimarySecondaryAxisIndex(int nAxis, bool bIsPrimary); /// Iris 8/06/2012 ORG-6463-S1 ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
	int  		GetSubAxisIndex(TreeNode& trEditNode, int* pnBaseID = NULL);		
	int			GetSubAxisBranchOrder(TreeNode& trEditNode); /// Iris 7/13/2012 ORG-5991-P9 FIX_PROPERTY_IN_YAXIS_NOT_BE_CHANGED_WHEN_APPLY_CHANGES_WITH_SELECT_OTHERS
	virtual void CopyValuesFromThemeToGetN(TreeNode& trThemeAxes, TreeNode& trGetN);
	virtual void CopyValuesFromThemeToGetNForOneAxis(TreeNode& trGetN, int nAxis, TreeNode& trThemeOneAxis, TreeNode& trGetNOneAxis);
	
	virtual bool IsExchangeYAxisSubAxis() { return false; }
	virtual string GetAxisSubBranchLabel(int nAxis, int nSubAxis = -1) { return ""; }	
	bool		IsXYY3DBarGraph();
	
	// old functions
	void 		ConstructAllAxesPropertyNodes(TreeNode& trBranch, int nNumAngulars);	
	virtual void ApplyOtherPropertiesToThemeTree(TreeNode& trEditNode, TreeNode& trListTreeSelectedNode) {}
	
	/// Iris 8/06/2012 ORG-6463-S1 ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
	virtual int GetOutsideAxisBranchNodeDataIDs(vector<int>& vnBranchDataID) { vnBranchDataID.RemoveAll(); return 0; }
	virtual void SetRowSelection(int nDataID, int nAxis = -1);
	///End ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
	
	/// Iris 5/03/2012 ORG-5528-S1 AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH, changed the following functions from private to protected.
	// to update theme tree and relative GUI tree nodes once one control changed on dialog.
	virtual void 	UpdateOnAfterValueChange(int nRow, ThemeUpdateInfo& stThemeUpdateInfo);
	/// Iris 9/14/2012 ORG-6834-P1 FIX_LOG_SCALE_TYPE_INCREMENT_ISSUES
	//void UpdateControlsByScaleTypeChange(TreeNode& trGetNOneAxis, int nAxis = -1);		
	void UpdateControlsByScaleTypeChange(TreeNode& trGetNOneAxis, int nAxis = -1, bool bInit = true);
	///End FIX_LOG_SCALE_TYPE_INCREMENT_ISSUES
	/// Iris 9/18/2012 ORG-6834-P2 CHANGE_TO_LOG_SCALE_TYPE_CAUSE_RUNTIME_ERROR_IN_RADAR_AXES_DLG
	//void UpdateControlsByIncrementByChange(TreeNode& trBranch);
	virtual void UpdateControlsByIncrementByChange(TreeNode& trBranch) {}
	///End CHANGE_TO_LOG_SCALE_TYPE_CAUSE_RUNTIME_ERROR_IN_RADAR_AXES_DLG
	void ConvertIncrementValueAndTicksCount(TreeNode& trBranch, TreeNode& trScale, int nEditNodeID = -1);
	
	TreeNode GetThemeAxisNode(int nAxis);// -1 for Axes.All
	/// Iris 6/06/2012 ORG-5528-S3 TO_DISABLE_LINE_TITLE_TICKLABEL_SHOW_WHEN_AUTO_SHOW_HIDE_SELECTED
	//TreeNode GetGetNAxisNode(int nAxis);
	TreeNode GetGetNAxisNode(int nAxis, TreeNode *ptrGetN = NULL);
	///End TO_DISABLE_LINE_TITLE_TICKLABEL_SHOW_WHEN_AUTO_SHOW_HIDE_SELECTED
	
	/// Iris 6/13/2012 ORG-5991 MOVE_TICKS_AND_LINE_BRANCH_INTO_AXIS_FORMAT_BRANCH
	//virtual TreeNode GetTicksCountParentNode(TreeNode& trGetNOneAxis, int nSubAxisIndex, int nAxis, bool bMajor) { TreeNode trJunk; return trJunk; }	
	virtual TreeNode GetTicksCountParentNode(TreeNode& trGetNOneAxis, bool bMajor) { TreeNode trJunk; return trJunk; }
	///End MOVE_TICKS_AND_LINE_BRANCH_INTO_AXIS_FORMAT_BRANCH
	
	virtual TreeNode GetGetNGridsNode(int nAxis = -1);	
	virtual bool	GetChangedAxisIndices(TreeNode& trEditNode);
	int GetColletionMemberBranchNode(int nBaseID, int nSubAxisIndex, int nAxis = -1);
	/// Iris 7/23/2012 ORG-6319-P1 FIX_AXES_DLG_RUNTIME_ERROR_IN_JOS
	//bool IsMajor(TreeNode& trBranch);	
	bool IsMajor(TreeNode& trBranch, int nParentID = -1);	
	///End FIX_AXES_DLG_RUNTIME_ERROR_IN_JOS
	///End AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH	
	
	/// Iris 7/12/2012 ORG-5991-P8 UPDATE_UNDEFINED_STATUS_AFTER_CHANGE_VALUE_WITH_SELECTED_MULTI_AXES
	void UpdateDynaControlOnChange();
	void UpdateGetNTreeOnSelection(bool bRefreshGUI = true, bool bKeepBranchStatus = false);
	///End UPDATE_UNDEFINED_STATUS_AFTER_CHANGE_VALUE_WITH_SELECTED_MULTI_AXES
	
	/// Iris 8/01/2012 ORG-6371-S1 ADD_USE_SAME_OPTIONS_FOR_BOTH_ON_EACH_AXIS_ROOT_NODE
	bool AddUseSameOptionsForBoth(TreeNode& trBranch, int nAxis);	
	void CheckSetBranchEnableStatusOnUseSameOptionsForBoth(int nAxis, TreeNode& trGetNAxis, TreeNode& trEditNodeBranch, bool bIsCheck);
	void SetSecondaryAxisBranchEnableStatusWithIfUseSameOptionsForBoth(int nAxis, TreeNode& trGetNAxis, TreeNode& trPropertyBranch, bool bCheckUpdateAxisBranch = false, bool bOnlyCheckLeafNode = false);
	void CheckSetAxisBranchUseSameOptionCheckStatus(TreeNode& trGetNAxis);
	///End ADD_USE_SAME_OPTIONS_FOR_BOTH_ON_EACH_AXIS_ROOT_NODE
		
	/// Iris 8/06/2012 ORG-6463-S1 ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX	
	BOOL ApplyThemeTree(TreeNode& trTheme, bool bUpdateThemeIDs = false);	
	///End ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX	
	
	/// Iris 9/14/2012 ORG-6837-P1 TO_DISABLE_SUB_PROPERTIES_NODES_WHEN_SHOW_IS_UNCHECKED
	void DisablePropertiesNodeWhenShowNodeUnchecked(TreeNode& trGetN, int nChangedShowID = -1);	
	///End TO_DISABLE_SUB_PROPERTIES_NODES_WHEN_SHOW_IS_UNCHECKED
	
	/// Iris 9/20/2012 ORG-6892-P1 IMPROVE_DISABLE_SUB_AXIS_BRANCH_CODES
	void DisableSubAxisBranchWhenShowNodeUnchecked(TreeNode& trPropertyBranch, TreeNode& trShow, int nAxis, bool bIsPrimary);
	///End IMPROVE_DISABLE_SUB_AXIS_BRANCH_CODES
	
private:
	/// Iris 4/27/2012 ORG-5528-S1 AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
	//void constructSpiderPlotGetN(TreeNode& trGetN, int nNumAngulars);
	virtual void constructGetNTrees(TreeNode& trGetN, int nNumAxes) { ASSERT(false); } // should not go to here
	///End AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
	//void constructAllAxesPropertyNodes(TreeNode& trBranch, int nNumAngulars);
	/// Iris 4/27/2012 ORG-5528-S1 AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
	//void constructOneAxisPropertyNodes(TreeNode& trAxis);
	virtual void ConstructOneAxisPropertyNodes(TreeNode& trAxis, int nAxis) { ASSERT(false); } // should not go to here
	///End AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
	//void constructGridPropertyNodes(TreeNode& trGridBranch, bool bMajor);
	//void constructTicksPropertyNodes(TreeNode& trBranch);
	/// Iris 9/28/2011 ORG-3747-S2 COMBINE_TICKLABEL_SHOW_OPPOSITE_AS_ONE_DROPDOWN
	//void constructLabelsPropertyNodes(TreeNode& trBranch, bool bMajor);
	///End COMBINE_TICKLABEL_SHOW_OPPOSITE_AS_ONE_DROPDOWN	
	
	void updateAxesTree(bool bInitTime);
	void expandedRow(int nRow);	
	void setDefaultSelection();
	/// Iris 8/06/2012 ORG-6463-S1 ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
	//void setSelection(int nDataID);
	///End ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
	int getRowByDataID(int nDataID, int nAxisRow = -1);
	
	int  getRepeatID(const TreeNode& trN);
	bool isOneGourpIDs(int nRepeatID1, int nRepeatID2);
	bool isBranchWithRepeatNodes(int nRepeatID);
	int  getRepeatIDFromParent(const TreeNode& trN);
	bool combineSelectedTreeNodes(TreeNode& trGetN);	
	
	void applyIsUseSameOptionsForBothDirectionsSettings(); /// Iris 6/07/2012 ORG-5528-P10 SAVE_SAME_OPTIONS_FOR_BOTH_DIRECTIONS_TO_REGISTRY
	BOOL	applyChangeToTempGraph(int nRowChanged);	
	void	checkUpdateGetNFromTempGraph();	
	//TreeNode getThemeAxisNode(int nAxis);// -1 for Axes.All
	//TreeNode getGetNAxisNode(int nAxis);
	//TreeNode getGetNGridsNode();
	bool	applyAxisPropertyToThemeTree(TreeNode& trThemeAxis, TreeNode& trGetNAxis);		
	/// Iris 09/06/2011 ORG-3297-P2 FIX_SHOW_LABEL_FOR_ALL_AXES_NOT_WORK
	//void 	setThemeTickLabelShowForAllAxes(TreeNode& trGetNLabels, TreeNode& trGetNLabelBranch);
	void 	setThemeTickLabelShowForAllAxes(TreeNode& trGetNAxis, TreeNode& trGetNLabels, TreeNode& trGetNLabelBranch);
	///End FIX_SHOW_LABEL_FOR_ALL_AXES_NOT_WORK
	void	copySameOptionsForSecondAxis();
	
	/// Iris 7/18/2012 ORG-5991-P10 FIX_PROPERTIES_IN_AXIS_FORMAT_NOT_WORK_WHEN_USE_SAME_OPTIONS_CHECKED_WITH_MULTI_AXES_SELECTED
	void 	copyGetNChangedValuesByID(TreeNode& trEdit, TreeNode& trDestPropertyBranch, int nEditAxis);
	///End FIX_PROPERTIES_IN_AXIS_FORMAT_NOT_WORK_WHEN_USE_SAME_OPTIONS_CHECKED_WITH_MULTI_AXES_SELECTED
	
	void 	removeNodesNotInTheme(); /// Iris 6/13/2012 ORG-5991 MOVE_TICKS_AND_LINE_BRANCH_INTO_AXIS_FORMAT_BRANCH	
	void	checkCreateTitleObject(); /// Iris 8/22/2012 CHECK_CREATE_TITLE_OBJ
	BOOL	applyTheme();	
	BOOL 	getTheme(TreeNode& trTheme);	
	
	/// Iris 4/27/2012 ORG-5528-S1 AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
	virtual TreeNode getThemeAxesNode() { ASSERT(false); TreeNode trJunk; return trJunk; }
	virtual string getThemeAxesNodeTagname() { ASSERT(false); return ""; }	
	virtual int getThemeAxesNodeID() { ASSERT(false); return 0; }
	virtual string getAxisLabelName(int nAxis, const GraphLayer& glParent) { ASSERT(false); return ""; }
	virtual string getAxisSubBranchName(int nAxis, int nSubAxis = -1, bool bLabel = false) { return ""; }
		
	string	getAxisNodeName(int nAxis, BOOL bTheme = FALSE);
	virtual string 	getThemeAxisNodeName(int nAxis) { ASSERT(false); return ""; }	
	virtual int getThemeAxisNodeID() { ASSERT(false); return 0; }
	///End AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH

	BOOL	constructGetN(TreeNode& trGetN);
	void 	setScaleValuesDivideFactor(TreeNode& trGetNOneAxis, int nAxis, int nSubAxis); /// Iris 7/19/2012 ORG-6246-P1 SETUP_SCALE_DISPLAY_VALUE_ON_AFTER_DIVIDE_FACTOR_CHANGE
	/// Iris 7/27/2012 ORG-6242-P1 SETUP_DATE_TIME_FORMAT_ON_SCALE_VALUE_CONTROLS
	void	setScaleValueDisplayTypeWithTickLabelType(TreeNode& trGetNOneAxis, int nAxis);
	///End SETUP_DATE_TIME_FORMAT_ON_SCALE_VALUE_CONTROLS
	/// Iris 11/11/2011 ORG-4268-S2 FIX_SCALE_NOT_DISABLE_WHEN_DIG_REOPEN
	//void 	updateGetNScaleAfterCopyValuesFromTheme(TreeNode& trGetNScale); /// Iris 11/04/2011 ORG-4017-P1 NEED_REFRESH_INCREMENT_VAL_AFTER_CHANGED_FROM_TO
	virtual void 	updateGetNScaleAfterCopyValuesFromTheme(TreeNode& trGetN, TreeNode& trGetNOneAxis, int nAxis);
	///End FIX_SCALE_NOT_DISABLE_WHEN_DIG_REOPEN	
	/// Iris 09/06/2011 ORG-3297-P3 FIX_GRID_FORMAT_FAIL_TO_WORK_WHEN_SELECT_MAJORGRIDLINE_IN_LEFT_PANEL
	//void 	updateChangeFromGetNTreeToListTree(int nEditRow);
	void 	updateChangeFromGetNTreeToListTree(int nEditRow, TreeNode& trListTreeSelectedNode);
	///End FIX_GRID_FORMAT_FAIL_TO_WORK_WHEN_SELECT_MAJORGRIDLINE_IN_LEFT_PANEL
	/// Iris 5/03/2012 ORG-5528-S1 AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
	//bool	getChangedAxisIndices(TreeNode& trEditNode);	
	///End bool	getChangedAxisIndices(TreeNode& trEditNode);
	/// Iris 11/04/2011 ORG-4017-P1 NEED_REFRESH_INCREMENT_VAL_AFTER_CHANGED_FROM_TO
	//void 	initIncrementValue(TreeNode& trThemeAxes);
	///End NEED_REFRESH_INCREMENT_VAL_AFTER_CHANGED_FROM_TO
	
	/// Iris 5/03/2012 ORG-5528-S1 AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
	//void 	updateOnAfterValueChange(int nRow, bool& nNeedApply);
	///End AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
	
	/// Iris 11/11/2011 ORG-4268-S2 FIX_SCALE_NOT_DISABLE_WHEN_DIG_REOPEN
	//void	disableScaleOptions(TreeNode* ptrScaleBranch = NULL); /// Iris 10/31/2011 ORG-4268-S2 DISENABLE_SCALE_BRANCH
	//void	disableScaleOptions(TreeNode& trGetN, TreeNode* ptrScaleBranch = NULL);
	///End FIX_SCALE_NOT_DISABLE_WHEN_DIG_REOPEN
	
	/// Iris 11/03/2011 ORG-4268-S4 ADD_ONLY_SHOW_TICK_LABEL_ON_1ST_AXIS_CHECKBOX
	//void 	setOnlyOneTickLabelFor1stAxisInitStatus(TreeNode& trN);
	/// Iris 11/09/2011 ORG-4268-P1 FIX_ONLY_SHOW_TICK_LABELS_FOR_1ST_AXIS_NOT_WORKED_FOR_MINOR_TICK_LABEL
	//bool	checkSetOnlyOneTickLabelFor1stAxis(int nDataID);
	bool	checkSetOnlyOneTickLabelFor1stAxis();
	///End FIX_ONLY_SHOW_TICK_LABELS_FOR_1ST_AXIS_NOT_WORKED_FOR_MINOR_TICK_LABEL
	///End ADD_ONLY_SHOW_TICK_LABEL_ON_1ST_AXIS_CHECKBOX
	
	/// Iris 6/04/2012 ORG-5528-S4 SET_3DGL_AXES_DLG_DEFAULT_LAYOUT
	virtual bool IsTitlePositionBranchOpen() { return true; }
	virtual bool IsMinorTicskBranchOpen() { return true; }
	///End SET_3DGL_AXES_DLG_DEFAULT_LAYOUT
	
//private:	
protected:
	AxesTreeView	m_AxesGridTree;
	Tree			m_trTheme;
		
	bool			m_bForAll;
	bool			m_bForBothBySelection; /// Iris 7/20/2012 ORG-6270-S1 IMPROVE_TICK_LABELS_BRANCH_SPEED
	/// Iris 7/19/2012 ORG-5991-P13 SAVE_SAME_OPTIONS_TO_GRAPH_NOT_REGISTRY
	//string			m_strSameOptionsForBothSettings; /// Iris 6/07/2012 ORG-5528-P10 SAVE_SAME_OPTIONS_FOR_BOTH_DIRECTIONS_TO_REGISTRY
	///End SAVE_SAME_OPTIONS_TO_GRAPH_NOT_REGISTRY
	int				m_nRepeatID;
	bool			m_bSelectedGroup;
//	bool			m_bAutoscaleIndependently;	/// RVD 9/21/2011 ORG-3732-s1 SPIDER_INDIVIDUAL_SCALE
	
	int				m_nNumAxes;
	int				m_nDefaultAxis;
	int				m_nDefaultSecondaryAxis; /// Iris 7/19/2012 ORG-6246-P1 SETUP_SCALE_DISPLAY_VALUE_ON_AFTER_DIVIDE_FACTOR_CHANGE
	int				m_nLayerType;
	int				m_nDefaultObjectType;
	DWORD			m_dwDlgOptions; /// Iris 6/08/2012 ORG-5930-P2 OPEN_AXIS_DIALOG_WHEN_SELECT_FROM_FORMAT_AXIS_TITLE
	
	bool			m_bEditTreeChanged;
	vector<uint> 	m_vnChangedAxes;
	/// Iris 11/10/2011 ORG4268-P2 UNCHECK_RESCALE_EACH_AXIS_INDEP_NOT_WORKED
	//bool			m_bIsIndependentlyRescale; /// Iris 10/31/2011 ORG-4268-S1 NEED_DO_RESCALE_WHEN_INDEPDENTLY_RESCALE_CHECKED
	//bool			m_bRescaleIndependentlyChanged;
	bool			m_nRescaleAfterApplyTheme;
	///End UNCHECK_RESCALE_EACH_AXIS_INDEP_NOT_WORKED
	
	int				m_nLastTimeSelectedNodeDataID;
	bool			m_bUseLastTimeSelected; /// Iris 6/13/2012 ORG-5930-P3 NOT_USE_LAST_TIME_SELECTED_OBJ_FOR_3D_GRAPH
	
	bool			m_bIsShowPrimaryAxesOnlyChanged; /// Iris 8/16/2012 ORG-6463-P4 FIX_CHANGE_ANY_ONE_CAUSE_Y_TOP_AXES_HIDE
	GraphLayer		m_gl;
	
	CustomOptions	m_stOptions;	
};

/// Iris 4/27/2012 ORG-5528-S1 AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
class SpiderPlotAxesControlSplitter : public AxesControlSplitter
{
public:
	SpiderPlotAxesControlSplitter()
	{
		m_bUseLastTimeSelected = true; /// Iris 6/13/2012 ORG-5930-P3 NOT_USE_LAST_TIME_SELECTED_OBJ_FOR_3D_GRAPH
	}
	
	~SpiderPlotAxesControlSplitter() {}
	
	/// Iris 5/21/2012 ORG-5528-S6 REMOVE_SAME_OPTIONS_FOR_ALL_BUTTON_FOR_2D_AND_3DGL_GRAPH
	//virtual 
	bool IsEnableForAll() { return true; }
	///End REMOVE_SAME_OPTIONS_FOR_ALL_BUTTON_FOR_2D_AND_3DGL_GRAPH
	
	/// Iris 6/04/2012 ORG-5528-S4 SET_3DGL_AXES_DLG_DEFAULT_LAYOUT
	// virtual
	string GetDlgName() { return STR_SPIDER_AXES_DLG_NAME; }
	///End SET_3DGL_AXES_DLG_DEFAULT_LAYOUT
	
protected:		
	//virtual 
	void GetAxisPropertyCustomOptions();

	//virtual 
	void ConstructOneAxisPropertyNodes(TreeNode& trAxis, int nAxis);
	
	//virtual 
	void ConstructLabelsBranchNodes(TreeNode& trAxis, int nAxis = -1);
	
	//virtual 
	void CopyValuesFromThemeToGetNForOneAxis(TreeNode& trGetN, int nAxis, TreeNode& trThemeOneAxis, TreeNode& trGetNOneAxis);
	
	//virtual 
	void ApplyOtherPropertiesToThemeTree(TreeNode& trEditNode, TreeNode& trListTreeSelectedNode);
	
	//virtual 
	/// Iris 6/13/2012 ORG-5991 MOVE_TICKS_AND_LINE_BRANCH_INTO_AXIS_FORMAT_BRANCH
	//TreeNode GetTicksCountParentNode(TreeNode& trGetNOneAxis, int nSubAxisIndex, int nAxis, bool bMajor);
	TreeNode GetTicksCountParentNode(TreeNode& trGetNOneAxis, bool bMajor);
	///End MOVE_TICKS_AND_LINE_BRANCH_INTO_AXIS_FORMAT_BRANCH
		
	// virtual
	void UpdateOnAfterValueChange(int nRow, ThemeUpdateInfo& stThemeUpdateInfo);	
	
	//virtual 
	int GetOutsideAxisBranchNodeDataIDs(vector<int>& vnBranchDataID); /// Iris 8/06/2012 ORG-6463-S1 ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
	
	/// Iris 9/18/2012 ORG-6834-P2 CHANGE_TO_LOG_SCALE_TYPE_CAUSE_RUNTIME_ERROR_IN_RADAR_AXES_DLG
	//virtual 
	void UpdateControlsByIncrementByChange(TreeNode& trBranch);
	///End CHANGE_TO_LOG_SCALE_TYPE_CAUSE_RUNTIME_ERROR_IN_RADAR_AXES_DLG
	
private:
	// virtual
	void constructGetNTrees(TreeNode& trGetN, int nNumAxes);
	
	//virtual 
	TreeNode getThemeAxesNode();
	
	//virtual 
	string getThemeAxesNodeTagname() { return STR_NEW_AXES; }	
	
	//virtual 
	string 	getThemeAxisNodeName(int nAxis);
	
	//virtual 
	int getThemeAxesNodeID() { return OTID_NEWAXES; }
	int getThemeAxisNodeID() { return OTID_NEWAXIS; }
	
	//virtual 
	string getAxisLabelName(int nAxis, const GraphLayer& glParent);
	
	//virtual 
	void 	updateGetNScaleAfterCopyValuesFromTheme(TreeNode& trGetN, TreeNode& trGetNOneAxis, int nAxis);
	void	disableScaleOptions(TreeNode& trGetN, TreeNode* ptrScaleBranch = NULL);
	
	void 	initHide1stTickLabelGetN(TreeNode& trGetN); /// Iris 11/04/2011 ORG-4268-S3 ADD_HIDE_1ST_TICK_LABELS_CHECKBOX
	void 	setOnlyOneTickLabelFor1stAxisInitStatus(TreeNode& trN);	
	void 	applyShowHide1stTickLabelOnEachAxis(TreeNode& trEditNode); /// Iris 11/04/2011 ORG-4268-S3 ADD_HIDE_1ST_TICK_LABELS_CHECKBOX
};

class GeneralPlotAxesControlSplitter : public AxesControlSplitter
{
public:
	GeneralPlotAxesControlSplitter()
	{
		m_bUseLastTimeSelected = false; /// Iris 6/13/2012 ORG-5930-P3 NOT_USE_LAST_TIME_SELECTED_OBJ_FOR_3D_GRAPH
	}
	~GeneralPlotAxesControlSplitter() {}
	
	//virtual 
	// for general 2D/3D graph, the axis order is X1, X2, Y1, Y2, Z1, Z2, so need /2.
	/// Iris 7/19/2012 ORG-6246-P1 SETUP_SCALE_DISPLAY_VALUE_ON_AFTER_DIVIDE_FACTOR_CHANGE
	//void SetDefaultAxis(int nAxis) { m_nDefaultAxis = nAxis / 2; }	
	/// Iris 9/13/2012 ORG-6821 FIX_DBCLICK_ON_AXES_TO_OPEN_AXES_DLG_GO_TO_INCORRECT_AXIS_BRANCH
	//void SetDefaultAxis(int nAxis) { m_nDefaultAxis = nAxis / 2; m_nDefaultSecondaryAxis = nAxis % 2; }
	void SetDefaultAxis(int nDim, int nAxisIndex) { m_nDefaultAxis = nDim; m_nDefaultSecondaryAxis = nAxisIndex; }
	///End FIX_DBCLICK_ON_AXES_TO_OPEN_AXES_DLG_GO_TO_INCORRECT_AXIS_BRANCH
	///End SETUP_SCALE_DISPLAY_VALUE_ON_AFTER_DIVIDE_FACTOR_CHANGE
	
	/// Iris 6/04/2012 ORG-5528-S4 SET_3DGL_AXES_DLG_DEFAULT_LAYOUT
	// virtual
	string GetDlgName() { return STR_2DGL_AXES_DLG_NAME; }
	///End SET_3DGL_AXES_DLG_DEFAULT_LAYOUT
	
	/// Iris 7/19/2012 ORG-5991-P13 SAVE_SAME_OPTIONS_TO_GRAPH_NOT_REGISTRY
	//virtual 
	void SaveSettingsBeforeDialogClose();
	///End SAVE_SAME_OPTIONS_TO_GRAPH_NOT_REGISTRY
	
protected:
	//virtual 
	int GetStopLevel() { return LEVEL_SUB_AXIS_BRANCH; } /// Iris 8/06/2012 ORG-6463-S1 ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
	
	//virtual 
	void GetAxisPropertyCustomOptions();
	
	//virtual 
	int GetRepeatIndex(bool bMajor, int nAxis = -1);// { return bMajor ? 2 : 1; } // compare with Radar plot, the order is inverse	
	
	//virtual 
	void ConstructOneAxisPropertyNodes(TreeNode& trAxis, int nAxis);		
	
	/// Iris 6/13/2012 ORG-5991 MOVE_TICKS_AND_LINE_BRANCH_INTO_AXIS_FORMAT_BRANCH	
	// virtual
	void ConstructTickValuesPropertyNodes(TreeNode& trScale); /// Iris 6/13/2012 ORG-5991 MOVE_TICKS_AND_LINE_BRANCH_INTO_AXIS_FORMAT_BRANCH
	void ConstructAxisFormatBranchNodes(TreeNode& trAxis, int nAxis);
	void ConstructAxisFormatPropertyNodes(TreeNode& trBranch, int nAxis, int nSub);
	///End MOVE_TICKS_AND_LINE_BRANCH_INTO_AXIS_FORMAT_BRANCH
	
	// virtual
	void ConstructTicksPropertyNodes(TreeNode& trBranch, bool bMajor);		
	
	//virtual 
	void ConstructLabelsBranchNodes(TreeNode& trBranch, int nAxis = -1);
	
	/// Iris 6/21/2012 ORG-5991-S4 MOVE_SPECIAL_TICK_LABEL_OUTSIDE_LABELS_BRANCH
	//virtual
	void ConstructSpecialLabelsBranchNodes(TreeNode& trAxis, int nAxis = -1);	
	void ConstructSpecialLabelPropertyNodes(TreeNode& trBranch, int nAxis = -1);
	///End MOVE_SPECIAL_TICK_LABEL_OUTSIDE_LABELS_BRANCH
	
	//virtual 
	void CopyValuesFromThemeToGetNForOneAxis(TreeNode& trGetN, int nAxis, TreeNode& trThemeOneAxis, TreeNode& trGetNOneAxis);
		
	// virtual
	void UpdateOnAfterValueChange(int nRow, ThemeUpdateInfo& stThemeUpdateInfo);
	
	//virtual 	
	bool	GetChangedAxisIndices(TreeNode& trEditNode);		
	
	//virtual 
	TreeNode GetGetNGridsNode(int nAxis = -1);	
	
	//virtual 
	string GetAxisSubBranchLabel(int nAxis, int nSubAxis = -1);	
	
	//virtual 
	/// Iris 6/13/2012 ORG-5991 MOVE_TICKS_AND_LINE_BRANCH_INTO_AXIS_FORMAT_BRANCH
	//TreeNode GetTicksCountParentNode(TreeNode& trGetNOneAxis, int nSubAxisIndex, int nAxis, bool bMajor);	
	TreeNode GetTicksCountParentNode(TreeNode& trGetNOneAxis, bool bMajor);	
	///End MOVE_TICKS_AND_LINE_BRANCH_INTO_AXIS_FORMAT_BRANCH
	
	/// Iris 8/06/2012 ORG-6463-S1 ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
	///// Iris 6/06/2012 ORG-5528-S3 TO_DISABLE_LINE_TITLE_TICKLABEL_SHOW_WHEN_AUTO_SHOW_HIDE_SELECTED
	//void UpdateShowEnableStatusOnAutoShowHide(TreeNode *ptrGetN = NULL); 
	/////End TO_DISABLE_LINE_TITLE_TICKLABEL_SHOW_WHEN_AUTO_SHOW_HIDE_SELECTED
	///End ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
	
	/// Iris 8/08/2012 ORG-6463-S3 ADD_AXIS_SHOW_PROPERTY_IN_AXIS_ROOT_BRANCH	
	TreeNode GetPrimarySecondaryAxisNode(TreeNode& trParent, int nAxis, bool bIsPrimary, bool bIsGetN);	
	TreeNode GetPropertyBranchShowNode(TreeNode& trBranch, int nAxis, bool bIsPrimary, int nShowID, bool bGetNTree, bool bIsMinor = false);
	void UpdateSubAxisShowNodeStatus(TreeNode &trBranch, int nAxis, bool bIsPrimary, int nShowID, int nCheck, bool bGetNTree);
	// apply show settings from root axis to each property branch
	void UpdatePropertyBranchShowNodeFromAxisBranch(TreeNode& trGetNAxis, int nAxis, bool bIsPrimary, int nCheck, bool bUpdateTheme);
	// update show settings from each property branch to root axis
	void UpdateAxisBranchShowNodeFromPropertyBranch(TreeNode& trGetNAxis, int nAxis, bool bIsPrimary);		
	///End ADD_AXIS_SHOW_PROPERTY_IN_AXIS_ROOT_BRANCH
	
	/// Iris 8/10/2012 ORG-6463-S3 MOVE_PRIMARY_AND_SECONDARY_SHOW_PROPERTY_TO_PROPERTY_BRANCH	
	// nForPrimary = -1 for both primary and secondary axis, 0 only for secondary axis, 1 only for primary axis. 
	void CheckMoveShowControl(TreeNode& trBranch, int nAxis, int nSubAxis, LPCSTR lpcszOldName, LPCSTR lpcszOldLabel, int nOldID, LPCSTR lpcszNewLabel, bool bIsPrimary, bool bIsMinor = false);
	void CheckMoveShowControlForAllAxes(TreeNode* ptrGetN = NULL);
	///End MOVE_PRIMARY_AND_SECONDARY_SHOW_PROPERTY_TO_PROPERTY_BRANCH
	
	/// Iris 8/14/2012 ORG-6463-S4 CHANGE_SUB_AXIS_NAMING_RULE
	virtual bool IsBottomTopAxis(int nAxis) { return AXIS_X == nAxis; }
	///End CHANGE_SUB_AXIS_NAMING_RULE	
	
	/// Iris 8/22/2012 ORG-6463-P6 IMPROVE_AXIS_POSITION_REFER_AXIS	
	virtual int GetAutoHideStatus() { return AXISAUTOHIDE_INTERNAL; }
	///End IMPROVE_AXIS_POSITION_REFER_AXIS
	
	/// Iris 9/18/2012 ORG-6834-P2 CHANGE_TO_LOG_SCALE_TYPE_CAUSE_RUNTIME_ERROR_IN_RADAR_AXES_DLG
	//virtual 
	void UpdateControlsByIncrementByChange(TreeNode& trBranch);
	///End CHANGE_TO_LOG_SCALE_TYPE_CAUSE_RUNTIME_ERROR_IN_RADAR_AXES_DLG
	
private:
	// virtual
	void constructGetNTrees(TreeNode& trGetN, int nNumAxes);	
	
	//virtual 
	string getThemeAxesNodeTagname() { return STR_AXES; }
	
	//virtual 
	TreeNode getThemeAxesNode();
	
	//virtual 
	string 	getThemeAxisNodeName(int nAxis);
	
	//virtual 
	int getThemeAxesNodeID() { return OTID_AXES; }
	int getThemeAxisNodeID() { return OTID_AXIS; }
	
	//virtual 
	string getAxisLabelName(int nAxis, const GraphLayer& glParent);
	
	// virtual
	string getAxisSubBranchName(int nAxis, int nSubAxis = -1, bool bLabel = false);		
	
	void constructTicksLabelPropertyNodes(TreeNode& trBranch, int nAxis);
	
	void constructBreakNodes(TreeNode& trBranch);
	
	void copyValuesFromThemeScaleToGetNTicks(TreeNode& trThemeScale, TreeNode& trGetNSubTicks, bool bMajor);	
	
	//virtual 
	void 	updateGetNScaleAfterCopyValuesFromTheme(TreeNode& trGetN, TreeNode& trGetNOneAxis, int nAxis);
	void 	convertIncrementByWithDatasetString(TreeNode& trBranch, bool bMajor);
	bool	isInThemeScale(int nEditNodeDataID);	
	
	/// Iris 6/06/2012 ORG-5528-S3 TO_DISABLE_LINE_TITLE_TICKLABEL_SHOW_WHEN_AUTO_SHOW_HIDE_SELECTED
	//void updateShowEnableStatusOnAutoShowHide(); /// Iris 5/22/2012 ORG-5528-S3 ADD_AUTO_SHOWHIDE_CHECKBOX
	///End TO_DISABLE_LINE_TITLE_TICKLABEL_SHOW_WHEN_AUTO_SHOW_HIDE_SELECTED
	
	/// Iris 6/04/2012 ORG-5528-S4 SET_3DGL_AXES_DLG_DEFAULT_LAYOUT
	//virtual 
	bool IsTitlePositionBranchOpen() { return false; }
	//virtual 
	bool IsMinorTicskBranchOpen() { return false; }
	///End SET_3DGL_AXES_DLG_DEFAULT_LAYOUT
	
	/// Iris 8/15/2012 ORG-6463-S3 MOVE_PRIMARY_AND_SECONDARY_SHOW_PROPERTY_TO_PROPERTY_BRANCH	
	void moveShowControlToPropertyBranch(TreeNode& trSubAxis, LPCSTR lpcszSubAxisShowName, TreeNode& trBranch, TreeNode& trInsertBefore, int nAxis, int nSubAxis, LPCSTR lpcszOldName, LPCSTR lpcszOldLabel, int nOldID, LPCSTR lpcszNewLabel, bool bIsForPrimary, bool bIsMinor = false);	
	void moveShowControlToSubAxisBranch(TreeNode& trSubAxis, LPCSTR lpcszSubAxisShowName, TreeNode& trBranch, int nAxis, LPCSTR lpcszOldName, LPCSTR lpcszOldLabel, int nOldID, bool bIsForPrimary, bool bIsMinor = false);
	///End MOVE_PRIMARY_AND_SECONDARY_SHOW_PROPERTY_TO_PROPERTY_BRANCH
	
	// to set the same check/uncheck status of Show for secondary axis with first axis when Use Same Option for Bottom and To is checked.
	void onAxisShowChange(TreeNode& trEditNode);
	void setSecondAxisShowOnFirst(TreeNode& trEditBranch);
	void onPropertyShowChange(TreeNode& trEditNode);
	void setSecondPropertyShowOnFirst(TreeNode& trEditBranch);
};

class GL3DPlotAxesControlSplitter : public GeneralPlotAxesControlSplitter
{
public:
	/// Iris 8/08/2012 ORG-6463-S3 ADD_AXIS_SHOW_PROPERTY_IN_AXIS_ROOT_BRANCH
	GL3DPlotAxesControlSplitter()
	{
		m_nShowPrimaryAxesOnly = SHOW_PRIMARY_ONLY_UNDEFINED;
	}
	///End ADD_AXIS_SHOW_PROPERTY_IN_AXIS_ROOT_BRANCH
	
	/// Iris 6/04/2012 ORG-5528-S4 SET_3DGL_AXES_DLG_DEFAULT_LAYOUT
	// virtual
	string GetDlgName() { return STR_3DGL_AXES_DLG_NAME; }
	///End SET_3DGL_AXES_DLG_DEFAULT_LAYOUT
	
	/// Iris 8/06/2012 ORG-6463-S1 ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
	//virtual 
	bool HasShowPrimaryOnlyCheckbox() { return true; }
	//virtual 
	int GetShowPrimaryAxesOnlyStatus() { return m_nShowPrimaryAxesOnly; }
	//virtual 
	bool IsShowPrimaryAxesOnly() { return SHOW_PRIMARY_ONLY_CHECKED == m_nShowPrimaryAxesOnly; }	
	//virtual
	/// Iris 8/08/2012 ORG-6463-S3 ADD_AXIS_SHOW_PROPERTY_IN_AXIS_ROOT_BRANCH
	//void (bool bIs, bool bUpdateTheme, bool bUpdateListTree);
	void SetShowPrimaryAxesOnly(bool bIs, int nEvent, TreeNode* ptrGetN = NULL);
	///End ADD_AXIS_SHOW_PROPERTY_IN_AXIS_ROOT_BRANCH
	///End ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
	
protected:
	/// Iris 8/06/2012 ORG-6463-S1 ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
	//virtual 
	int GetStopLevel() { return IsShowPrimaryAxesOnly() ? LEVEL_AXIS_PROPERTY_BRANCH : LEVEL_SUB_AXIS_BRANCH; }
	///End ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
		
	//virtual 
	void GetAxisPropertyCustomOptions();	
	
	/// Iris 6/21/2012 ORG-5991-S2 EXCHANGE_YAXIS_LEFT_AND_RIGHT_BRANCH
	//virtual 
	void ConstructOneAxisPropertyNodes(TreeNode& trAxis, int nAxis);	
	///End EXCHANGE_YAXIS_LEFT_AND_RIGHT_BRANCH
	
	/// Iris 8/06/2012 ORG-6463-S1 ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
	/*
	/// Iris 5/22/2012 ORG-5528-S3 ADD_AUTO_SHOWHIDE_CHECKBOX
	//virtual 
	void ApplyOtherPropertiesToThemeTree(TreeNode& trEditNode, TreeNode& trListTreeSelectedNode);	
	*/
	///End ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
	
	//virtual 
	void CopyValuesFromThemeToGetN(TreeNode& trThemeAxes, TreeNode& trGetN);
	///End ADD_AUTO_SHOWHIDE_CHECKBOX		
	
	/// Iris 6/25/2012 ORG-5991-P7 FIX_SEL_BOTH_XY_AXES_CANNOT_DISPLAY_UNDEFINE_STATUS
	//virtual 
	bool IsExchangeYAxisSubAxis();
	///End FIX_SEL_BOTH_XY_AXES_CANNOT_DISPLAY_UNDEFINE_STATUS
	
	//virtual 
	void CopyValuesFromThemeToGetNForOneAxis(TreeNode& trGetN, int nAxis, TreeNode& trThemeOneAxis, TreeNode& trGetNOneAxis);
	
	/// Iris 8/14/2012 ORG-6463-S4 CHANGE_SUB_AXIS_NAMING_RULE
	//virtual 
	bool IsBottomTopAxis(int nAxis);
	///End CHANGE_SUB_AXIS_NAMING_RULE
	
	/// Iris 8/22/2012 ORG-6463-P6 IMPROVE_AXIS_POSITION_REFER_AXIS	
	//virtual 
	int GetAutoHideStatus();
	///End IMPROVE_AXIS_POSITION_REFER_AXIS	
	
private:
	// virtual
	void constructGetNTrees(TreeNode& trGetN, int nNumAxes);
	
	/// Iris 6/21/2012 ORG-5991-S2 EXCHANGE_YAXIS_LEFT_AND_RIGHT_BRANCH
	void exchangeAxisBranchFirstAndSecondSubBranch(TreeNode& trBranch, LPCSTR lpcszSubAxisLabel);
	///End EXCHANGE_YAXIS_LEFT_AND_RIGHT_BRANCH
	
	/// Iris 8/02/2012 ORG-5991-S6 CHANGE_SUB_AXIS_LABEL_FOR_3DGL_GRAPH
	// virtual
	string getAxisSubBranchName(int nAxis, int nSubAxis = -1, bool bLabel = false);		
	///End CHANGE_SUB_AXIS_LABEL_FOR_3DGL_GRAPH
	
private:
	/// Iris 8/06/2012 ORG-6463-S1 ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
	int 			m_nShowPrimaryAxesOnly;	
	///End ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
};
///End AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH

class AxesDlg : public ResizeDialog
{
public:
	/// Iris 4/27/2012 ORG-5528-S1 AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
	//AxesDlg(int nAxisIndex = 0, int nObjectType = -1) : ResizeDialog(IDD_AXES_DLG, "ODlg8")
	/// Iris 6/08/2012 ORG-5930-P2 OPEN_AXIS_DIALOG_WHEN_SELECT_FROM_FORMAT_AXIS_TITLE
	//AxesDlg(int nAxisIndex = 0, int nObjectType = -1, int nLayerType = OKAXISDLGLAYERTYPE_SPIDER) : ResizeDialog(IDD_AXES_DLG, "ODlg8")
	/// Iris 9/13/2012 ORG-6821 FIX_DBCLICK_ON_AXES_TO_OPEN_AXES_DLG_GO_TO_INCORRECT_AXIS_BRANCH
	//AxesDlg(int nAxisIndex = 0, int nObjectType = -1, int nLayerType = OKAXISDLGLAYERTYPE_SPIDER, DWORD dwCntrl = 0) : ResizeDialog(IDD_AXES_DLG, "ODlg8")
	AxesDlg(int nDim = 0, int nAxisIndex = 0, int nObjectType = -1, int nLayerType = OKAXISDLGLAYERTYPE_SPIDER, DWORD dwCntrl = 0) : ResizeDialog(IDD_AXES_DLG, "ODlg8")
	///End FIX_DBCLICK_ON_AXES_TO_OPEN_AXES_DLG_GO_TO_INCORRECT_AXIS_BRANCH
	///End OPEN_AXIS_DIALOG_WHEN_SELECT_FROM_FORMAT_AXIS_TITLE
	///End AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
	{
		m_nLayerType = nLayerType;
		m_pSplitter = getSplitterPointer();
		
		if( NULL != m_pSplitter )
		{
			/// Iris 4/27/2012 ORG-5528-S1 AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH						
			m_pSplitter->SetLayerType(nLayerType);
			///End AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
			
			/// Iris 4/27/2012 ORG-5528-S1 AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
			//m_splitter.SetDefaultAxis(nAxisIndex);
			/// Iris 9/13/2012 ORG-6821 FIX_DBCLICK_ON_AXES_TO_OPEN_AXES_DLG_GO_TO_INCORRECT_AXIS_BRANCH
			//m_pSplitter->SetDefaultAxis(nAxisIndex);
			m_pSplitter->SetDefaultAxis(nDim, nAxisIndex);
			///End FIX_DBCLICK_ON_AXES_TO_OPEN_AXES_DLG_GO_TO_INCORRECT_AXIS_BRANCH
			///End AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
			
			if( nObjectType < 0 )
			{
				/// Iris 6/04/2012 ORG-5528-S4 SET_3DGL_AXES_DLG_DEFAULT_LAYOUT
				//nObjectType = LoadSetting(STR_REG_SELECTED_OBJ_DATAID, -1, STR_AXES_DLG_NAME);
				nObjectType = LoadSetting(STR_REG_SELECTED_OBJ_DATAID, -1, m_pSplitter->GetDlgName());
				///End SET_3DGL_AXES_DLG_DEFAULT_LAYOUT
			}
			/// Iris 4/27/2012 ORG-5528-S1 AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
			//m_splitter.SetDefaultObjectType(nObjectType);
			m_pSplitter->SetDefaultObjectType(nObjectType);
			///End AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
			
			/// Iris 6/08/2012 ORG-5930-P2 OPEN_AXIS_DIALOG_WHEN_SELECT_FROM_FORMAT_AXIS_TITLE
			m_pSplitter->SetDlgOptions(dwCntrl);
			///End OPEN_AXIS_DIALOG_WHEN_SELECT_FROM_FORMAT_AXIS_TITLE
		}
	}
	~AxesDlg()
	{
		if( NULL != m_pSplitter )
		{
			delete(m_pSplitter);
			m_pSplitter = NULL;
		}
	}

	int DoModalEx(HWND hWndParent = NULL)
	{		
		InitMsgMap();
		int nRet = ResizeDialog::DoModal(hWndParent);		
		return nRet;
	}
	
protected:
EVENTS_BEGIN
	ON_INIT(OnInitDialog) 
	ON_READY(OnReady)
	ON_SIZE(OnDlgResize)
	ON_RESTORESIZE(OnRestoreSize) /// Iris 6/04/2012 ORG-5528-S4 SET_3DGL_AXES_DLG_DEFAULT_LAYOUT
	ON_BN_CLICKED(IDC_CHECK_IS_FOR_ALL_AXES, OnApplyForAllCheck)	
//	ON_BN_CLICKED(IDC_CHECK_AUTOSCALE_INDEPENDENTLY, OnApplyAutoscaleIndependently)	/// RVD 9/21/2011 ORG-3732-s1 SPIDER_INDIVIDUAL_SCALE	
	ON_USER_MSG(WM_USER_ON_EDIT_TREE_CHANGED, OnEditTreeChanged)
	///Jasmine 09/13/2011 ORG-3297 SELECT_RELATIVE_NODES_TO_APPLY_SETTINGS_TO_MULTIP_AXES	
	ON_USER_MSG(WM_USER_ON_TREE_VIEW_SELECT_CHANGED, OnTreeViewSelectChanged)
	ON_BN_CLICKED(IDC_SEL_RELATIVE_BTN, OnSelRelative)		
	///End SELECT_RELATIVE_NODES_TO_APPLY_SETTINGS_TO_MULTIP_AXES
	ON_BN_CLICKED(IDC_CHECK_SHOW_PRIMARY_ONLY, OnShowPrimaryAxesOnlyCheck) /// Iris 8/06/2012 ORG-6463-S1 ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
	ON_DESTROY(OnDestroy)
	ON_BN_CLICKED(IDC_APPLY, OnApply)
	ON_OK(OnOK)	
	///------ Folger 09/19/2012 QA-1291-P2 NEW_AXES_DLG_SHOULD_OPEN_CORRECT_HELP
	ON_HELPINFO(OnHelp)
	///------ End NEW_AXES_DLG_SHOULD_OPEN_CORRECT_HELP

EVENTS_END

	BOOL OnInitDialog();
	BOOL OnReady();
	BOOL OnDlgResize(int nType, int cx, int cy);
	BOOL OnRestoreSize(ODWP dwSizeInfo); /// Iris 6/04/2012 ORG-5528-S4 SET_3DGL_AXES_DLG_DEFAULT_LAYOUT
	BOOL OnApplyForAllCheck(Control ctrl);
//	BOOL OnApplyAutoscaleIndependently(Control ctrl);	/// RVD 9/21/2011 ORG-3732-s1 SPIDER_INDIVIDUAL_SCALE	
	void OnEditTreeChanged(DWORD wParam, DWORD lParam);
	///Jasmine 09/13/2011 ORG-3297 SELECT_RELATIVE_NODES_TO_APPLY_SETTINGS_TO_MULTIP_AXES	
	void OnTreeViewSelectChanged(DWORD wParam, DWORD lParam);
	BOOL OnSelRelative(Control ctrl);
	///End SELECT_RELATIVE_NODES_TO_APPLY_SETTINGS_TO_MULTIP_AXES
	BOOL OnShowPrimaryAxesOnlyCheck(Control ctrl); /// Iris 8/06/2012 ORG-6463-S1 ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
	BOOL OnDestroy();
	BOOL OnApply(Control ctrl);
	BOOL OnOK();
	///------ Folger 09/19/2012 QA-1291-P2 NEW_AXES_DLG_SHOULD_OPEN_CORRECT_HELP
	BOOL OnHelp(int &nHelpID, int nIdCtrlFocus);
	///------ End NEW_AXES_DLG_SHOULD_OPEN_CORRECT_HELP
	
	/// Iris 4/27/2012 ORG-5528-S1 AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
private:
	AxesControlSplitter*	getSplitterPointer();
	///End AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
	
	/// Iris 8/14/2012 ORG-6463-S4 CHANGE_SUB_AXIS_NAMING_RULE
	void	enableApplyButton(bool bEnable = true);
	///End CHANGE_SUB_AXIS_NAMING_RULE
	
private:
	/// Iris 4/27/2012 ORG-5528-S1 AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
	//AxesControlSplitter		m_splitter;	
	AxesControlSplitter		*m_pSplitter;	
	int						m_nLayerType;
	///End AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
	
	Button					m_btnShowPrimaryAxesOnly; /// Iris 8/06/2012 ORG-6463-S1 ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
}; 





#endif //AXES_DLG_H
