/*--------------------------------------------------------------------------------------*
 * File Name:				 															*
 * Creation: 																			*
 * Purpose: OriginC Source C file														*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010				*
 * All Rights Reserved																	*
 * 																						*
 * Modification Log:																	*
 * Iris 09/06/2011 ORG-3297-P1 FIX_LABEL_COLOR_CHANGED_WITH_LINE_COLOR_BUT_GUI_NOT_CHANGE
 * Iris 09/06/2011 ORG-3297-P2 FIX_SHOW_LABEL_FOR_ALL_AXES_NOT_WORK						*
 * Iris 09/06/2011 ORG-3297-P3 FIX_GRID_FORMAT_FAIL_TO_WORK_WHEN_SELECT_MAJORGRIDLINE_IN_LEFT_PANEL
 * Jasmine 09/08/2011 ORG-3747-S1 ADD_POSITION_CONTROL_FOR_TICK_LABELS					*
 * Jasmine 09/09/2011 ORG-3297-S1 SHOW_AXIS_TITLE_TO_INDICATE_AXIS						*
 * Jasmine 09/13/2011 ORG-3297-S6 HIDE_SUBNODE_TO_SAVE_PLACE							*
 * Jasmine 09/13/2011 ORG-3297 USER_MAY_SHOW_OTHER_AXIS									*
 * Jasmine 09/13/2011 ORG-3297 SELECT_RELATIVE_NODES_TO_APPLY_SETTINGS_TO_MULTIP_AXES	*
 * Jasmine 09/15/2011 ORG-3297-S6 SIMPLIFY_AND_REMOVE_RIGHT_TREE_FOR_LOW_LEVEL_TN_ON_LEFT
 * Iris 9/19/2011 ORG-3819-S2 ADD_MORE_TICK_LABEL_PROPERTIES							*
 * Iris 9/20/2011 APPLY_FOR_ALL_SHOULD_NOT_EFFECT_EACH_AXIS_SETTINGS					*
 * Iris 9/20/2011 ORG-3747-S1 ADD_OPPOSITE_CONTROL_FOR_TICK_LABELS						*
 * Iris 9/20/2011 ORG-3819-P4 FIX_MINOR_TICK_LABEL_SHOW_NOT_WORK						*
 *	RVD 9/21/2011 ORG-3685-p1 FIX_OLD_AXIS_UpdateThemeIDs								*
 * Iris 9/23/2011 ORG-3819-S1 SUPPORT_CUSTOM_DECIMAL_IN_SPIDER_PLOT_MORE				*
 * Iris 9/29/2011 ORG-3921-P1 FIX_BAD_INIT_VALUE_FOR_LOG_TYPE_SCALE						*
 * Iris 9/29/2011 ORG-3819-S1 IMPROVE_CUSTOM_DECIAL_CONTROL								*
 * RVD 9/21/2011 ORG-3732-s1 SPIDER_INDIVIDUAL_SCALE									*
 * CPY 10/04/2011 ORG-3732-s1 SPIDER_INDIVIDUAL_SCALE_SHOULD_BE_INSIDE_TREE				*
 * Iris 10/09/2011 UPDATED_AFTER_ROMAN_CHANGE_ABOUT_SPIDER_THEME_IMPROVE				*
 * Bill 10/19/2011 ORG-3747-P2 DETECT_UNDEFINE_CHANGE									*
 * Iris 10/20/2011 ORG-3747-P2 IMPROVE_UNDEFINE_CHANGE									*
 * Iris 10/24/2011 ORG-3747-P2 IMPROVE_UNDEFINE_CHANGE_MORE								*
 * Kenny 10/24/2011 ORG-4114-P2 SPIDER_PLOT_AXES_RESCALE_MODE							*
 * Iris 10/31/2011 ORG-4268-S1 NEED_DO_RESCALE_WHEN_INDEPDENTLY_RESCALE_CHECKED			*
 * Iris 11/07/2011 ONLY_KEEP_LINEAR_AND_LOG10_IN_SCALE_TYPE_LIST						*
 *	RVD 11/7/2011 ORG-4017-p1 INC_AXIS_MAJOR_TICKS_ASSERT								*
 * Iris 11/08/2011 ORG-3921-P5 FIX_INCORRECT_FROM_VALUE_FOR_LOG_SCALE_TYPE				*
 * Iris 11/08/2011 ORG-3921-P6 DISABLE_INCREMENT_VALUE_FOR_LOG_SCALE_TYPE				*
 * Iris 11/10/2011 ORG-3962-S2 IMPROVE_CUSTOM_DECIMAL_CONTROL							*
 * Iris 11/11/2011 ORG-3962-P4 FIX_SET_CUSTOM_FORMAT_RUNTIME_ERROR						*
 * Iris 12/15/2011 ORG-4597-P1 AFTER_DO_INDEP_RESCALE_NOT_UPDATE_EACH_AXIS_SCALE_FROM_TO*
 * Iris 2/06/2012 ORG-4218-P1 SUPPORT_TICK_LABEL_FORMAT_TYPE							*
 * Iris 5/04/2012 ORG-5528-S1 FIX_TITLES_BRANCH_FAILED_TO_SELECT_OTHERS_IN_GENERAL_GRAPH*
 * Iris 5/15/2012 MAKE_MINOR_GRIDS_WORK_BOTH_FOR_RADAR_AND_GENERAL_GRAPH				*
 * Iris 5/17/2012 ORG-5719-P1 FIX_FAIL_TO_CHANGE_TICK_LABEL_TYPE						*
 * Iris 5/17/2012 ORG-5719-P1 CHANGED_DATASET_CONTROL_FROM_INTERACTIVE_TO_STRLIST		*
 * Iris 5/21/2012 ORG-5528-S6 REMOVE_SAME_OPTIONS_FOR_ALL_BUTTON_FOR_2D_AND_3DGL_GRAPH	*
 * Iris 5/22/2012 ORG-5528-S3 ADD_AUTO_SHOWHIDE_CHECKBOX								*
 * Iris 5/25/2012 ORG-4218-P6 ONLY_SHOW_DIVIDE_BY_FACTOR_FOR_NUMERIC_AND_COLUMN_TICK_TYPE
 * Iris 5/25/2012 ORG-4218-P7 SHOULD_NOT_SUPPORT_INDEXED_DATASET_TICK_LABEL_TYPE_IN_AXES_DLG_FOR_RADAR
 * Iris 6/01/2012 ORG-5528-P1 FIX_TICK_LABEL_FONT_FAIL_TO_WORK							*
 * Iris 6/04/2012 ORG-5528-S4 SET_3DGL_AXES_DLG_DEFAULT_LAYOUT							*
 * Folger 06/07/2012 ORG-5930-P2 OPEN_AXIS_DIALOG_WHEN_SELECT_FROM_FORMAT_AXIS_TITLE	*
 * Iris 6/08/2012 ORG-5930-P2 OPEN_AXIS_DIALOG_WHEN_SELECT_FROM_FORMAT_AXIS_TITLE		*
 * Iris 6/19/2012 ORG-5991-P5 FIX_CHANGE_RIGHT_TITLE_BUT_APPLY_CHANGE_TO_LEFT_TITLE		*
 * Iris 6/21/2012 ORG-5991-S2 EXCHANGE_YAXIS_LEFT_AND_RIGHT_BRANCH						*
 * Iris 6/21/2012 ORG-5991-S4 MOVE_SPECIAL_TICK_LABEL_OUTSIDE_LABELS_BRANCH				*
 * Iris 6/26/2012 ORG-5991-P2 ALLOW_MINOR_LABEL_SHOW_CAN_BE_CHANGE						*
 * Iris 6/27/2012 ORG-5528 ADD_ACTUAL_FONT_SIZE_IN_AXES_DLG								*
 * Iris 7/06/2012 TO_FIX_NOT_CHANGED_TOPAXIS_WITH_MODIFICATION_OF_BOTTOMAXIS_EVEN_USE_SAME_OPTIONS_BOX_IS_CHECKED
 * Iris 7/12/2012 ORG-5991-P8 UPDATE_UNDEFINED_STATUS_AFTER_CHANGE_VALUE_WITH_SELECTED_MULTI_AXES
 * Iris 7/13/2012 ORG-5991-P9 FIX_PROPERTY_IN_YAXIS_NOT_BE_CHANGED_WHEN_APPLY_CHANGES_WITH_SELECT_OTHERS
 * Iris 7/17/2012 ORG-5991-P11 FIX_SHOW_PROPERTY_OF_TOP_AXIS_NOT_WORK					*
 * Iris 7/24/2012 ORG-6243-P1 DISABLE_FIRST_TICK_WHEN_TICKS_FROM_DATASET				*
 * Iris 7/25/2012 ORG-5991-P12 AXIS_AUTO_SHOWHIDE_EFFECTED_ALL_AXES						*
 * Iris 7/30/2012 ORG-6371_P1 FIX_SECONDARY_AXIS_DEFAULT_IS_DISABLE						*
 * Iris 8/02/2012 ORG-5991-P15 FIX_SELECT_OTHERS_BASED_ON_Y_SUB_AXIS_FAILED				*
 * Kyle 08/24/2012 ORG-6629-P1 MAKE_LABEL_DATASET_DROPDOWN_EDITABLE						*
 *	Sophy 9/10/2012 ORG-6751-P1 MORE_CHECK_ON_SET_DATETIME_PICKER_DISPLAY_FORMAT		*
 * Iris 9/14/2012 ORG-6834-P1 FIX_LOG_SCALE_TYPE_INCREMENT_ISSUES						*
 * Iris 9/14/2012 ORG-6837-P1 TO_DISABLE_SUB_PROPERTIES_NODES_WHEN_SHOW_IS_UNCHECKED	*
 *	Folger 09/19/2012 QA-1291-P2 NEW_AXES_DLG_SHOULD_OPEN_CORRECT_HELP					*
 * Iris 9/19/2012 ORG-6463-P7 KEEP_ORIGINAL_SETTINGS_WHEN_SWITCH_TO_USE_ONE_AXIS_FOR_EACH_DIRECTOR
 * Iris 9/19/2012 ORG-6880-P1 FIX_HINT_DISPLAY_AS_EDITABLE								*
 * Iris 9/24/2012 ORG-6463-P8 FIX_NOT_REMEMBERED_USE_SAME_FOR_BOTH_CHECK_STATUS_IN_SUB_AXIS_BRANCH
 * Iris 9/27/2012 ORG-6996-P1 FIX_CUSTOM_FORMAT_MISSED_AFTER_SHOW_MINRO_LABEL			*
 * Iris 9/28/2012 ORG-7019-P1 FIX_CANNOT_HIDE_MAJOR_TICK_LABELS							*
 *	Folger 10/09/2012 ORG-7080-P1 DATE_TIME_CUSTOM_DISPLAY_FAILED_TO_SHOW_IN_AXESDLG	*
 * Iris 10/15/2012 ORG-7148-P1 FIX_RUNTIME_TIME_WHEN_UNCHECK_USE_SAME_OPTIONS_FOR_BOTTOM_AND_TOP
 *--------------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
////////////////////////////////////////////////////////////////////////////////////

//#pragma labtalk(0) // to disable OC functions for LT calling.

////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.
#include <..\OriginLab\DialogEx.h>
#include "SplitterControl.h"
#include "DynaSplitter.h"
#include <GetNBox.h>
#include "AxesDlg.h"

// the following marcos must be defined before including okThemeID.h
#define MAKEDWORD(a, b)      ((LONG)(((WORD)(a)) | ((DWORD)((WORD)(b))) << 16)) /// okThemeID.h used this define, so define it before the file.
#define	MAKEDWORD_FROM_HIGHEST_BYTE(_by)	MAKEDWORD(0, MAKEWORD(0, (_by)))
#include "okThemeID.h" 

////////////////////////////////////////////////////////////////////////////////////
// Define your marcos here.
/// Iris 9/28/2011 ORG-3962-S1 IMPROVE_AXIS_DLG_GUI
//#define LEVEL_RADIAL_AXIS				1
//#define LEVEL_AXIS						2
//#define LEVEL_GRIDS						LEVEL_AXIS
//#define LEVEL_AXIS_PROPERTY_BRANCH		3
/// Iris 7/20/2012 ORG-6270-S1 IMPROVE_TICK_LABELS_BRANCH_SPEED
/*
#define LEVEL_AXIS						0
#define LEVEL_GRIDS						0
#define LEVEL_AXIS_PROPERTY_BRANCH		1
*/
enum
{
	LEVEL_AXIS = 0,
	LEVEL_GRIDS = LEVEL_AXIS,
	LEVEL_AXIS_PROPERTY_BRANCH, // 1
	LEVEL_SUB_AXIS_BRANCH, // 2
	
	LEVEL_LAST_ITEM,
};
///End IMPROVE_TICK_LABELS_BRANCH_SPEED
///End IMPROVE_AXIS_DLG_GUI

/// Iris 11/08/2011 ORG-3921-P5 FIX_INCORRECT_FROM_VALUE_FOR_LOG_SCALE_TYPE
//#define MIN_LOG_VALUE					6.5E-12 /// Iris 9/29/2011 ORG-3921-P1 FIX_BAD_INIT_VALUE_FOR_LOG_TYPE_SCALE
#define MIN_LOG_VALUE					1E-11
///End FIX_INCORRECT_FROM_VALUE_FOR_LOG_SCALE_TYPE

/// Iris 9/20/2012 ORG-6892-P1 IMPROVE_DISABLE_SUB_AXIS_BRANCH_CODES
#define STR_DISABLE_BY_USE_SAME_OPTIONS_ATTRIB			"DisableByUseSame"
#define STR_DISABLE_BY_SHOW_ATTRIB						"DisableByShow"
///End IMPROVE_DISABLE_SUB_AXIS_BRANCH_CODES

enum
{
	LABEL_NONE = 0,
	//LABEL_FIRST_AXIS_ONLY,	///Jasmine 09/13/2011 ORG-3297 USER_MAY_SHOW_OTHER_AXIS
	LABEL_ALL_AXES
};

/// Iris 9/28/2011 ORG-3747-S2 COMBINE_TICKLABEL_SHOW_OPPOSITE_AS_ONE_DROPDOWN
enum
{
	TICK_LABEL_SHOW_NONE,
	TICK_LABEL_SHOW_BEFORE_AXIS,
	TICK_LABEL_SHOW_AFTER_AXIS
};
///End COMBINE_TICKLABEL_SHOW_OPPOSITE_AS_ONE_DROPDOWN

/// Iris 8/08/2012 ORG-6463-S3 ADD_AXIS_SHOW_PROPERTY_IN_AXIS_ROOT_BRANCH
enum
{
	SET_PRIMARY_ONLY_ON_AFTER_COPY_VAL_FROM_THEME,
	SET_PRIMARY_ONLY_ON_BUTTON_EVENT,
};
///End ADD_AXIS_SHOW_PROPERTY_IN_AXIS_ROOT_BRANCH

/// Iris 4/27/2012 ORG-5528-S1 AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
enum
{
	AXIS_X,
	AXIS_Y,
	AXIS_Z
};

enum
{
	SUB_AXIS_FIRST = 0,
	SUB_AXIS_SECOND,
	
	SUB_AXIS_COUNT
};
enum
{
	TICK_POS_NORMAL = 0,
	TICK_POS_PRECENT,
	TICK_POS_AT_VAL
};

enum
{
	SET_MAJOR_TICKS_BY_INCREMENT,
	SET_MAJOR_TICKS_BY_COUNT,
	SET_MAJOR_TICKS_BY_DATASET
};

enum
{	
	SPECIAL_LABELS_AUTO,
	SPECIAL_LABELS_HIDE,
	SPECIAL_LABELS_SHOW,	
	SPECIAL_LABELS_MANUAL
};

enum
{
	SPECIAL_LABEL_POS_BEGIN,
	SPECIAL_LABEL_POS_END,
	SPECIAL_LABEL_POS_CUSTOM,
	
	SPECIAL_LABEL_POS_ITEM_COUNT
};

enum
{	
	SET_MINOR_TICKS_BY_COUNT,
	SET_MINOR_TICKS_BY_DATASET
};
#define STR_POSITION_TYPE_ATTRIB			"PositionType"
///End AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH	
#define STR_SCALE_TYPE_ATTRIB				"ScaleType"				/// Iris 9/14/2012 ORG-6834-P1 FIX_LOG_SCALE_TYPE_INCREMENT_ISSUES	
#define	STR_MAJOR_TICKS_COUNT_LABEL			"MajorTicksCount"
#define	STR_INC_VALUE_LABEL					"IncValue"
////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.
#define ID_HIDE_1ST_TICK_LABELS					OTID_AXES_COUNT - 4  /// Iris 11/04/2011 ORG-4268-S3 ADD_HIDE_1ST_TICK_LABEL_CHECKBOX
#define ID_ONLY_SHOW_TICK_LABELS_FOR_1ST_AXIS	OTID_AXES_COUNT - 3	 /// Iris 11/03/2011 ORG-4268-S4 ADD_ONLY_SHOW_TICK_LABEL_ON_1ST_AXIS_CHECKBOX
#define OTID_START_POSITION			OTID_AXES_COUNT - 2
//---- CPY 10/04/2011 ORG-3732-s1 SPIDER_INDIVIDUAL_SCALE_SHOULD_BE_INSIDE_TREE
//#define OTID_CATEGORY_AXIS			OTID_AXES_COUNT - 1
#define IDBRANCH_MISC					OTID_AXES_COUNT - 1//0x2000
#define GETN_MARK_STOP_BRANCH			GETN_OPTION_SPECIALVALS("Junk")
//---- end SPIDER_INDIVIDUAL_SCALE_SHOULD_BE_INSIDE_TREE
/// RVD 9/21/2011 ORG-3685-p1 FIX_OLD_AXIS_UpdateThemeIDs
//#define	ID_AXES						OTID_AXES
//#define	ID_AXIS						OTID_AXIS
//#define	STR_AXES				"Axes"
//#define	STR_AXIS				"Axis"
//#define	TAG_AXES					Axes
//#define	TAG_AXIS					Axis
//#define	TAG_ALLAXES					All

/// Iris 4/27/2012 ORG-5528-S1 AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
//#define	ID_AXES						OTID_NEWAXES
//#define	ID_AXIS						OTID_NEWAXIS
//#define	TAG_AXES					NewAxes
//#define	TAG_AXIS					NewAxis
//#define	STR_AXES					"NewAxes"
//#define	STR_AXIS					"NewAxis"
///End AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
#define	TAG_ALLAXES					All//AllNewAxes CPY 10/04/2011 ORG-3732-s1 SPIDER_INDIVIDUAL_SCALE_SHOULD_BE_INSIDE_TREE, changed to All from AllNewAxes 
/// end FIX_OLD_AXIS_UpdateThemeIDs
/// Iris 4/27/2012 ORG-5528-S1 AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
//#define OTID_RADIAL_AXIS			(ID_AXES - 1)
///End AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH

#define MAJOR_TICK_LABEL_SHOW_NODE(trAxis)					trAxis.Labels.MajorLabels.ShowEx
/// Iris 11/09/2011 ORG-4268-P1 FIX_ONLY_SHOW_TICK_LABELS_FOR_1ST_AXIS_NOT_WORKED_FOR_MINOR_TICK_LABEL
// if trAxis.Labels.MinorLabels is invalid, then return an invalid node
#define MINOR_TICK_LABEL_SHOW_NODE(trAxis)					trAxis.Labels.MinorLabels ? trAxis.Labels.MinorLabels.GetNode("Show") : trAxis.Labels.MinorLabels
//End FIX_ONLY_SHOW_TICK_LABELS_FOR_1ST_AXIS_NOT_WORKED_FOR_MINOR_TICK_LABEL
#define E_STR_CUSTOM_DEFAULT_FORMAT			".2"		/// Iris 11/10/2011 ORG-3962-S2 IMPROVE_CUSTOM_DECIMAL_CONTROL

#define ID_USER_DEFINED_BEGIN					0xF000 + 1
#define ID_MAX_SPECIAL_TICKS_NUM				50	

#define USE_SAME_OPTIONS_FOR_BOTH_DEFAULT_VAL	0

///Sophy 8/3/2012 ORG-2639-P8 SHOW_BUILDIN_FORMAT_IN_CUSTOM_DISPLAY_FORMAT_LIST
#define	STR_AXIS_LABEL_CUSTOM_DISPLAY_LIST	"|*3|.4|2.2|P*3|S.4|E.3|L.2"
///end SHOW_BUILDIN_FORMAT_IN_CUSTOM_DISPLAY_FORMAT_LIST

/// Iris 8/08/2012 ORG-6463-S3 MOVE_PRIMARY_AND_SECONDARY_SHOW_PROPERTY_TO_PROPERTY_BRANCH
#define STR_ORIGINAL_SHOW_NODE_ID_ATTRIB		"OriginalID"
///End MOVE_PRIMARY_AND_SECONDARY_SHOW_PROPERTY_TO_PROPERTY_BRANCH

/// Iris 7/13/2012 ORG-5991-P9 FIX_PROPERTY_IN_YAXIS_NOT_BE_CHANGED_WHEN_APPLY_CHANGES_WITH_SELECT_OTHERS
//#define _CHECK_CONVERT_SUB_AXIS_INDEX(_SUB_AXIS)		_check_convert_sub_branch_index_to_sub_axis_index_for_3D(nAxis, _SUB_AXIS, IsExchangeYAxisSubAxis())
#define _CHECK_CONVERT_SUB_AXIS_INDEX(_AXIS, _SUB_AXIS_BRANCH_ORDER)		_check_convert_sub_branch_index_to_sub_axis_index_for_3D(_AXIS, _SUB_AXIS_BRANCH_ORDER, IsExchangeYAxisSubAxis())
///End FIX_PROPERTY_IN_YAXIS_NOT_BE_CHANGED_WHEN_APPLY_CHANGES_WITH_SELECT_OTHERS			

enum
{
	//Iris: please do NOT change the order 
	ID_SAME_FOR_BOTTOM_AND_TOP = ID_USER_DEFINED_BEGIN,
	ID_AXIS_MINOR_TICKS_INCBY,
	ID_AXIS_POSITION_DATE_TYPE_OFFSET,
	ID_AXIS_POSITION_TIME_TYPE_OFFSET,
	/// Iris 6/13/2012 ORG-5991 MOVE_TICKS_AND_LINE_BRANCH_INTO_AXIS_FORMAT_BRANCH
	ID_AXIS_FORMATS,	
	ID_AXIS_LINE,
	///End MOVE_TICKS_AND_LINE_BRANCH_INTO_AXIS_FORMAT_BRANCH
	/// Iris 6/25/2012 ORG-5991-P7 FIX_SEL_BOTH_XY_AXES_CANNOT_DISPLAY_UNDEFINE_STATUS
	ID_AXIS_FIRST_SHOW,
	ID_AXIS_SECOND_SHOW,
	///End FIX_SEL_BOTH_XY_AXES_CANNOT_DISPLAY_UNDEFINE_STATUS
	/// Iris 6/21/2012 ORG-5991-S4 MOVE_SPECIAL_TICK_LABEL_OUTSIDE_LABELS_BRANCH
	ID_AXIS_SPECIALTICK, 
	ID_AXIS_SPECIALTICK_BEGIN,
	ID_AXIS_SPECIALTICK_BEGIN_LABEL,
	ID_AXIS_SPECIALTICK_END,
	ID_AXIS_SPECIALTICK_END_LABEL,
	ID_AXIS_SPECIALTICK_SPECIAL_BEGIN, // we support any number of special ticks, this is begin
	ID_AXIS_SPECIALTICK_SPECIAL_BEGIN_VALUE,
	ID_AXIS_SPECIALTICK_SPECIAL_BEGIN_LABEL,	
	ID_AXIS_SPECIALTICK_SPECIAL_END = ID_AXIS_SPECIALTICK_SPECIAL_BEGIN + ID_MAX_SPECIAL_TICKS_NUM -1, 
	ID_AXIS_SPECIALTICK_SPECIAL_END_VALUE,
	ID_AXIS_SPECIALTICK_SPECIAL_END_LABEL,
	///End MOVE_SPECIAL_TICK_LABEL_OUTSIDE_LABELS_BRANCH
	
	/// Iris 8/08/2012 ORG-6463-S3 ADD_AXIS_SHOW_PROPERTY_IN_AXIS_ROOT_BRANCH
	ID_SHOW_PRIMARY_AXIS,
	ID_SHOW_SECONDARY_AXIS,
	///End ADD_AXIS_SHOW_PROPERTY_IN_AXIS_ROOT_BRANCH
	
	/// Iris 8/10/2012 ORG-6463-S3 MOVE_PRIMARY_AND_SECONDARY_SHOW_PROPERTY_TO_PROPERTY_BRANCH
	ID_PROPERTY_SHOW_BEGIN,
	ID_PRIMARY_SHOW = ID_PROPERTY_SHOW_BEGIN,
	ID_SECONDARY_SHOW,
	
	ID_PRIMARY_MINOR_SHOW,
	ID_SECONDARY_MINOR_SHOW,
	ID_PROPERTY_SHOW_END = ID_SECONDARY_MINOR_SHOW,
	///End MOVE_PRIMARY_AND_SECONDARY_SHOW_PROPERTY_TO_PROPERTY_BRANCH
	
	ID_USER_DEFINED_END
};

#define ADD_AXIS_SUB_BRANCH(_BASE_ID, _PROPERTY_FUNC) int nSub = 0;\	
	while(true)\
	{\		
		TreeNode trSubBranch;\
		string strOneSubAxisName;\
		trSubBranch = AddAxisSubBranchNode(_tmpSubNode, _BASE_ID, nAxis, nSub, &strOneSubAxisName);\		
		if( 0 == nSub || trSubBranch )\
		{\
			TreeNode _tmpNode = trSubBranch.IsValid() ? trSubBranch : _tmpSubNode; TreeNode _tmpSubNode; string _strTemp;\
			_tmpNode.SetAttribute(STR_SPECIALVALS_ATTRIB, "Junk");\			
			_PROPERTY_FUNC; nSub++;\
		}\
		else { break; }\ 
	}
	/// Iris 7/30/2012 ORG-6371_P1 FIX_SECONDARY_AXIS_DEFAULT_IS_DISABLE
	// removed from above marco 'ADD_AXIS_SUB_BRANCH'
	//if( 1 == _CHECK_CONVERT_SUB_AXIS_INDEX(nAxis, nSub) ) _tmpNode.Enable = 0;\   
	///End FIX_SECONDARY_AXIS_DEFAULT_IS_DISABLE
	
static int _get_collection_member_branch_id(int nID, int nLayerType, int nRepeatID, int nAxis = -1)
{
	if( 0 == nID )
		return 0;
	
	int id;
	if( OKAXISDLGLAYERTYPE_SPIDER == nLayerType )
	{
		id = THEME_COLL_MEMBER_BRANCH(nID, nRepeatID);	
	}
	else
	{
		ASSERT(nAxis >= 0);
		int nAxisLT = nAxis + 1;		
		id = THEME_AXIS_MEMBER_BRANCH(nID, nAxisLT, nRepeatID);	
	}
	return id;
}

static void _set_collection_member_branch_id(TreeNode& trBranch, int nID, int nLayerType, int nRepeatID, int nAxis = -1, bool bDataID = true)
{
	int id = _get_collection_member_branch_id(nID, nLayerType, nRepeatID, nAxis);
	if( 0 == id )
		return;
		
	if( bDataID )
		trBranch.DataID = id;
	else
		trBranch.ID = id;
}

/// Iris 5/10/2012 FIX_NODES_WITH_LARGE_REPEAT_ID_COPY_VAL_BY_ID_FAILED
static int _check_get_8bits_repeat_id(int nRepeatID)
{	
	return (int)(nRepeatID & 0x0F);
}
///End FIX_NODES_WITH_LARGE_REPEAT_ID_COPY_VAL_BY_ID_FAILED

static void _set_collection_member_branch_id_with_repeat_id(TreeNode& trBranch, int nID, int nLayerType, int nRepeatID, int nAxis = -1, bool bDataID = true) 
{
	_set_collection_member_branch_id(trBranch, nID, nLayerType, nRepeatID, nAxis, bDataID);	
	
	if( 0 != nID )
	{
		/// Iris 5/10/2012 FIX_NODES_WITH_LARGE_REPEAT_ID_COPY_VAL_BY_ID_FAILED
		//trBranch.SetAttribute(STR_REPEAT_ID_ATTRIB, nRepeatID);
		trBranch.SetAttribute(STR_REPEAT_ID_ATTRIB, _check_get_8bits_repeat_id(nRepeatID));
		///End FIX_NODES_WITH_LARGE_REPEAT_ID_COPY_VAL_BY_ID_FAILED
	}
}

static void _set_collection_branch_id(TreeNode& trBranch, int nID, bool bDataID = true)
{
	int id = THEME_COLL_BRANCH(nID);
	if( bDataID )
		trBranch.DataID = id;
	else
		trBranch.ID = id;
}

static void _set_change_bit(TreeNode& trN)
{
	if( trN )
		trN.SetAttribute(STR_CHANGED_ATTRIB, 1);
}

static void _set_value_with_change_bit(TreeNode& trN, int nVal)
{
	if( trN )
	{
		trN.nVal = nVal;
		_set_change_bit(trN);
	}
}

static void _set_value_with_change_bit(TreeNode& trN, double dVal)
{
	if( trN )
	{
		trN.dVal = dVal;
		_set_change_bit(trN);
	}
}
static void _set_value_with_change_bit(TreeNode& trN, LPCSTR lpcszVal)
{
	if( trN )
	{
		trN.strVal = lpcszVal;
		_set_change_bit(trN);
	}
}

static void _set_value_with_change_bit(TreeNode& trN, vector<int>& vn)
{
	if( trN )
	{
		trN.nVals = vn;
		_set_change_bit(trN);
	}
}

/// Iris 8/14/2012 ORG-6463-S4 CHANGE_SUB_AXIS_NAMING_RULE
static string _get_sub_label_str(LPCSTR lpcszLabels, int index)
{
	string str(lpcszLabels);
	return str.GetToken(index, '|');
}
///End CHANGE_SUB_AXIS_NAMING_RULE

static TreeNode _get_sub_branch_by_index(TreeNode& trBranch, int nIndex)
{
	int nn = 0;
	foreach(TreeNode trSub in trBranch.Children)
	{
		if( trSub.GetNodeCount() > 0  )
		{
			if( nn == nIndex )
				return trSub;
			else
				nn++;
		}
	}
	
	ASSERT(false);
	TreeNode trJunk;
	return trJunk;
}

#define GETN_ID_COLLECTION_MEMBER_BRANCH_EX(_ID, _LAYER_TYPE, _REPEAT_ID, _AXIS) 				_set_collection_member_branch_id(_tmpNode, _ID, _LAYER_TYPE, _REPEAT_ID, _AXIS);
#define GETN_ID_COLLECTION_MEMBER_REPEAT_BRANCH_EX(_ID, _LAYER_TYPE, _REPEAT_ID, _AXIS) 		_set_collection_member_branch_id_with_repeat_id(_tmpNode, _ID, _LAYER_TYPE, _REPEAT_ID, _AXIS);
#define GETN_ID_COLLECTION_BRANCH_EX(_ID)														_set_collection_branch_id(_tmpNode, _ID);

#define STR_AXIS_LABEL					_L("Axis")
#define STR_AXES_LABEL					_L("Axes")
#define STR_RADIAL_AXIS_LABEL			_L("Radial Axis")
#define STR_GRIDS_LABEL					_L("Grids")
#define STR_MAJOR_GRIDS_LABEL			_L("Major Grid Lines")
#define STR_MINOR_GRIDS_LABEL			_L("Minor Grid Lines")
#define STR_ADDITIONAL_LINES_LABEL		_L("Additional Lines")
#define STR_OPPOSITE_LABEL				_L("Opposite")

/// Iris 8/08/2012 ORG-6463-S2 RENAME_AXIS_FORMAT_BRANCH
//#define STR_AXIS_FORMAT_LABEL			_L("Axis Format")
#define STR_AXIS_LINE_AND_TICKS_LABEL	_L("Line and Ticks")
///End RENAME_AXIS_FORMAT_BRANCH
#define STR_LINE_LABEL					_L("Line")
#define STR_SHOW_LABEL					_L("Show")
/// Iris 8/02/2012 ORG-5991-S5 REARRANGE_TICK_LABEL_CONTROLS
#define STR_SHOW_MAJOR_LABELS_LABEL		_L("Show Major Labels")
#define STR_SHOW_MINOR_LABELS_LABEL		_L("Show Minor Labels")
///End REARRANGE_TICK_LABEL_CONTROLS
#define STR_TEXT_LABEL					_L("Text")
#define STR_TYPE_LABEL					_L("Type")
#define STR_STYLE_LABEL					_L("Style")
#define STR_COLOR_LABEL					_L("Color")
#define STR_THICKNESS_LABEL				_L("Thickness")
#define STR_WIDTH_LABEL					_L("Width")
#define STR_AXIS_POSITION_LABEL			_L("Axis Position")
//#define STR_OFFSET_LABEL				_L("Offset")
#define STR_PERCENT_VALUE_LABEL			_L("Percent/Value")
#define STR_X_SUB_AXIS_E_LABELS			"Bottom|Top"
#define STR_Y_SUB_AXIS_E_LABELS			"Left|Right"
#define STR_Z_SUB_AXIS_E_LABELS			"Front|Back"
#define STR_X_SUB_AXIS_LABELS			_L(STR_X_SUB_AXIS_E_LABELS)
#define STR_Y_SUB_AXIS_LABELS			_L(STR_Y_SUB_AXIS_E_LABELS)
#define STR_Z_SUB_AXIS_LABELS			_L(STR_Z_SUB_AXIS_E_LABELS)
/// Iris 8/02/2012 ORG-5991-S6 CHANGE_SUB_AXIS_LABEL_FOR_3DGL_GRAPH
/// Iris 8/14/2012 ORG-6463-S4 CHANGE_SUB_AXIS_NAMING_RULE
//#define STR_3D_SUB_AXIS_LABELS			_L("Primary|Secondary")
#define STR_3D_BOTTOM_TOP_SUB_AXIS_LABELS		_L("Bottom|Top")
#define STR_3D_LEFT_RIGHT_SUB_AXIS_LABELS		_L("Left|Right")
///End CHANGE_SUB_AXIS_NAMING_RULE
///End CHANGE_SUB_AXIS_LABEL_FOR_3DGL_GRAPH
#define STR_AXIS_PER_POSITION_LABEL		_L("% From")
#define STR_AXIS_AT_POSITION_LABEL		_L("At Position =")
#define STR_MINOR_LABELS_ON_MAJOR_TICKS_LABEL _L("Minor Labels on Major Ticks")
#define STR_OFFSET_MAJOR_BY_LABEL		_L("Offset Major by (%)")
#define STR_LABELS_STAY_WITH_AXIS		_L("Labels Stay with Axis") 
#define STR_PLUS_SIGN_LABEL				_L("Plus Sign")
#define STR_MINUS_SIGN_LABEL			_L("Minus Sign")

#define STR_TITLE_LABEL					_L("Title")

#define STR_POSITION_LABEL				_L("Position")
#define STR_XOFFSET_LABEL				_L("X Offset")
#define STR_YOFFSET_LABEL				_L("Y Offset")

#define STR_FONT_LABEL					_L("Font")
#define STR_FONT_SIZE_LABEL				_L("Size")
#define STR_ACTUAL_SIZE_LABEL			_L("Actual Size")
#define STR_DISPLAY_LABEL				_L("Display")
#define STR_CUSTOM_DISPLAY_LABEL		_L("Custom Display")
#define STR_DATASET_NAME_LABEL			_L("Dataset Name")
/// Iris 9/19/2011 ORG-3819-S2 ADD_MORE_TICK_LABEL_PROPERTIES
#define STR_FONT_BOLD_LABEL				_L("Bold")
#define STR_DIVIDE_BY_FACTOR_LABEL		_L("Divide by Factor")
#define STR_PREFIX_LABEL				_L("Prefix")
#define STR_SUFFIX_LABEL				_L("Suffix")
/// Iris 11/10/2011 ORG-3962-S2 IMPROVE_CUSTOM_DECIMAL_CONTROL
//#define STR_CUSTOM_DECIMAL_LABEL		_L("Custom Decimal")
#define STR_CUSTOM_FORMAT_LABEL			_L("Custom Format")
///End IMPROVE_CUSTOM_DECIMAL_CONTROL
#define STR_DECIMAL_PLACES_LABEL		_L("Decimal Places")
///End ADD_MORE_TICK_LABEL_PROPERTIES

#define STR_SCALE_LABEL					_L("Scale")
#define STR_FROM_LABEL					_L("From")
#define STR_TO_LABEL					_L("To")
#define STR_INCREMENTBY_LABEL			_L("Increment By")
#define STR_RESCALE_MODE				_L("Rescale")	/// Kenny 10/24/2011 ORG-4114-P2 SPIDER_PLOT_AXES_RESCALE_MODE
#define STR_VALUE_LABEL					_L("Value")
#define STR_MAJOR_TICK_COUNT_LABEL		_L("Major Tick Count")
#define STR_MINOR_TICK_COUNT_LABEL		_L("Minor Tick Count")

#define STR_TICKS_LABEL					_L("Ticks")
#define STR_COUNT_LABEL					_L("Count")
#define STR_DATASET_LABEL				_L("Dataset")
#define STR_FIRST_TICK_LABEL			_L("First Tick")
#define STR_MAJOR_TICKS_LABEL			_L("Major Ticks")
#define STR_MINOR_TICKS_LABEL			_L("Minor Ticks")
#define STR_LENGTH_LABEL				_L("Length")
#define STR_TICK_LENGTH_LABEL			_L("Tick Length")
	
#define STR_TICK_LABELS_LABEL			_L("Tick Labels")
#define STR_MAJOR_TICK_LABELS_LABEL		_L("Major Labels")
#define STR_MINOR_TICK_LABELS_LABEL		_L("Minor Labels")
#define STR_SPECIAL_TICK_LABELS_LABEL	_L("Special Tick Labels")
#define STR_AXIS_BEGIN_LABEL			_L("Axis Begin")
#define STR_AXIS_END_LABEL				_L("Axis End")
#define STR_SPECIAL_LABEL				_L("Special")
#define STR_AT_AXIS_VALUE_LABEL			_L("At Axis Value")
#define STR_LABEL						_L("Label")
#define STR_TICK_TO_LABEL				_L("Tick to Label")
#define STR_SPECIAL_TICKS_TYPE_LIST		_L("Auto|Hide|Show|Manual")

#define STR_CATEGORY_AXIS_LABEL			_L("Category Axis")
#define STR_START_POSITION_LABEL		_L("Start Position")
#define STR_DIRECTION_LABEL				_L("Direction")
#define STR_ANGLE_LABEL					_L("Angle")
#define STR_ROTATE_LABEL				_L("Rotate")

/// Iris 9/28/2011 ORG-3962-S1 IMPROVE_AXIS_DLG_GUI
#define STR_ORIENTATION_LABEL		 	_L("Orientation")
#define STR_FORMAT_LABEL				_L("Format")
#define STR_OFFSET_IN_POINT_SIZE_LABEL	_L("Offset in % Point Size")
#define STR_HORIZONTAL_LABEL			_L("Horizontal")
#define STR_VERTICAL_LABEL				_L("Vertical")
///End IMPROVE_AXIS_DLG_GUI
//--- CPY 10/04/2011 ORG-3732-s1 SPIDER_INDIVIDUAL_SCALE_SHOULD_BE_INSIDE_TREE
//---- Iris 7/31/2012 Howard suggested use full word as label since there are enough size to display
//#define STR_MISC_BRANCH_LABEL			_L("Misc")
#define STR_MISC_BRANCH_LABEL			_L("Miscellaneous")
//----
#define STR_ONLY_SHOW_TICK_LABELS_FOR_1ST_AXIS_LABEL	_L("Only Show Tick Labels on 1st Axis")
#define STR_HIDE_1ST_TICK_LABELS_LABEL					_L("Hide 1st Tick Labels on Each Axis")
#define STR_INDEP_SCALES				_L("Rescale Each Axis Independently") 
//---

/// Iris 8/06/2012 ORG-6463-S1 ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
//#define	STR_AUTO_SHOW_LABEL				_L("Auto Show/Hide Axes")
///End ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
#define STR_SAME_OPTIONS_FOR_BOTH		_L("Use Same Options for %s and %s")
/// Iris 8/08/2012 ORG-6463-S3 ADD_AXIS_SHOW_PROPERTY_IN_AXIS_ROOT_BRANCH
#define STR_SHOW_PRIMARY_AXIS_LABEL		_L("Show Primary Axis")
#define STR_SHOW_SECONDARY_AXIS_LABEL	_L("Show Secondary Axis")
///End ADD_AXIS_SHOW_PROPERTY_IN_AXIS_ROOT_BRANCH
/// Iris 8/10/2012 ORG-6463-S3 MOVE_PRIMARY_AND_SECONDARY_SHOW_PROPERTY_TO_PROPERTY_BRANCH
/// Iris 8/15/2012 ORG-6463-S3 IMPROVE_SHOW_CHECKBOX_LABEL
//#define STR_PRIMARY_SHOW_LABEL			_L("Primary Show")
//#define STR_SECONDARY_SHOW_LABEL		_L("Secondary Show")
#define STR_SHOW_BOTTOM_TOP_AXIS_LABEL		_L("Show Bottom Axis|Show Top Axis")
#define STR_SHOW_LEFT_RIGHT_AXIS_LABEL		_L("Show Left Axis|Show Right Axis")

#define STR_SHOW_TITLE_LABEL				_L("Show Title on %s Axis")
#define STR_SHOW_AXIS_LINE_LABEL			_L("Show Line and Ticks on %s Axis")
#define STR_SHOW_MAJOR_LABEL_LABEL			_L("Show Major Labels on %s Axis")
#define STR_SHOW_MINOR_LABEL_LABEL			_L("Show Minor Labels on %s Axis")
///End IMPROVE_SHOW_CHECKBOX_LABEL
///End MOVE_PRIMARY_AND_SECONDARY_SHOW_PROPERTY_TO_PROPERTY_BRANCH

#define STR_BREAK_LABEL					_L("Break")
#define STR_BREAK_REGION_LABEL			_L("Break Region")
#define STR_REGION_FROM_LABEL			_L("Region From")
#define STR_REGION_TO_LABEL				_L("Region To")
#define STR_PRECENT_OF_AXIS_LENGTH  	_L("% of Axis Length")
#define STR_LOG_SCALE_AFTER_LABEL		_L("Log10 Scale After Break")
#define STR_SCALE_INCREMENT_LABEL		_L("Scale Increment")
#define STR_BEFORE_LABEL				_L("Before")
#define STR_AFTER_LABEL					_L("After")

static bool _is_log_type(int nScaleType)
{
	return (SCALE_TYPE_LOG10 == nScaleType || SCALE_TYPE_LN == nScaleType || SCALE_TYPE_LOG2 == nScaleType);
}

static void _copy_combo_from_theme_tree(TreeNode& trGetNNode)
{
	Tree trThemeTemp;
	trThemeTemp.List.ID = trGetNNode.DataID;
	Tree trGetNTemp;
	trGetNTemp.List.ID = trGetNNode.DataID;
	
	MakeGetNTreeFromThemeTree(&trGetNTemp, &trThemeTemp);
	
	string strCombo;
	if( trGetNTemp.List.GetAttribute(STR_COMBO_ATTRIB, strCombo) )
		trGetNNode.SetAttribute(STR_COMBO_ATTRIB, strCombo);
}
#define GETN_ADD_COMBO					_copy_combo_from_theme_tree(_tmpSubNode);

static int _get_base_id(int nThemeID)
{
	WORD wdLo = LOWORD((DWORD)nThemeID);
	return (int)wdLo;
}

// return true means repeat id is existed
static int _get_type_byte(int nThemeID)
{
	WORD wdHi = HIWORD((DWORD)nThemeID);
	byte byHi = HIBYTE(wdHi);
	return (int)byHi;
}

static bool _get_repeatid_from_themeid(int nThemeID, int& nRepeatID)
{	
	if( _get_type_byte(nThemeID) & OTC_INDEX )
	{
		WORD wdHi = HIWORD((DWORD)nThemeID);
		byte byLo = LOBYTE(wdHi);
		/// Iris 5/10/2012 FIX_NODES_WITH_LARGE_REPEAT_ID_COPY_VAL_BY_ID_FAILED
		//nRepeatID = byLo; 
		nRepeatID = _check_get_8bits_repeat_id(byLo); // only get last 4 bits
		///End FIX_NODES_WITH_LARGE_REPEAT_ID_COPY_VAL_BY_ID_FAILED
		return true;
	}
	nRepeatID = 0;
	return false;	
}

static void _remove_invalid_branch_node_and_convert_themeid_to_dataid(TreeNode& tr)
{
	ASSERT(tr.IsValid());
	
	int nThemeID;
	string strVal;
	if( !tr.GetAttribute(STR_ID_ATTRIB, strVal) )
		return;			
	//tr.RemoveAttribute(STR_ID_ATTRIB);
	
	nThemeID = atoi(strVal);
	int nRepeatID;
	if( _get_repeatid_from_themeid(nThemeID, nRepeatID) )
		tr.SetAttribute(STR_REPEAT_ID_ATTRIB, nRepeatID);
	tr.SetAttribute(STR_DATAID_ATTRIB, nThemeID);	
	
	if( 0 == tr.GetNodeCount()  ) // is a collection node but no children, it is an invalid branch node
	{
		int nTypeID = _get_type_byte(nThemeID);
		//if( nTypeID & OTC_COLLECTION || nTypeID & OTC_INDEX )
		if( 0 != nTypeID )
		{
			//printf("%s(%x)\n", tr.tagName, nThemeID);
			TreeNode trParent = tr.Parent();
			tr.Remove();
			if( 0 == trParent.GetNodeCount() )
				trParent.Remove();
		}
	}
	else
	{
		foreach(TreeNode trN in tr.Children)
		{
			_remove_invalid_branch_node_and_convert_themeid_to_dataid(trN);
		}
	}
}

// the following _tree_* function need to be moved to octreeUtils.h 
static void _tree_copy_attrib(TreeNode& tr, LPCSTR lpcszSrcAttrib, LPCSTR lpcszDestAttrib)
{
	string strVal;
	if( tr.GetAttribute(lpcszSrcAttrib, strVal) )
		tr.SetAttribute(lpcszDestAttrib, strVal);
	
	if( 0 != tr.GetNodeCount() )
	{
		foreach(TreeNode trN in tr.Children)
			_tree_copy_attrib(trN, lpcszSrcAttrib, lpcszDestAttrib);
	}
}

static void _copy_special_tick_label_settings_from_theme_to_GetN(const TreeNode& trThemeSpecialTicks, TreeNode& trGetNSpecialTicks)
{
	if( !trThemeSpecialTicks || !trGetNSpecialTicks )
		return;
	
	vector<int> vnTypes;
	vector vValues;
	vector<string> vsLabels;
	vnTypes = trThemeSpecialTicks.Types.nVals;
	vValues = trThemeSpecialTicks.Values.dVals;
	vsLabels = trThemeSpecialTicks.Labels.strVals;	
	ASSERT( vnTypes.GetSize() == vValues.GetSize() && vnTypes.GetSize() == vsLabels.GetSize() );
		
	if( vnTypes.GetSize() > 0 && vnTypes.GetSize() == vValues.GetSize() && vnTypes.GetSize() == vsLabels.GetSize() )
	{
		for(int index = 0; index < vnTypes.GetSize(); ++index)
		{
			int nPos = vnTypes[index] & SAT_POS_MASK;
			bool bHide = vnTypes[index] & SAT_HIDE;	
			bool bMunual = vnTypes[index] & SAT_LABEL;				
			
			// Special Type
			TreeNode trSpecialType = _get_GetN_special_sub_node(trGetNSpecialTicks, nPos, true);
			ASSERT( trSpecialType );			
			if( trSpecialType )
			{
				if( bMunual )
				{
					trSpecialType.nVal = SPECIAL_LABELS_MANUAL;
					if( SAT_POS_VALUE == nPos )
					{
						trGetNSpecialTicks.SpecialValue.strVal = ftoa(vValues[index]);
					}
				}
				else if( bHide )
				{
					trSpecialType.nVal = SPECIAL_LABELS_HIDE;
				}
				else 
				{
					trSpecialType.nVal = SPECIAL_LABELS_SHOW;
				}
			}
			
			// Special Label			
			TreeNode trSpecialLabel = _get_GetN_special_sub_node(trGetNSpecialTicks, nPos, false);
			ASSERT( trSpecialLabel );
			if( trSpecialLabel )
			{
				trSpecialLabel.strVal = vsLabels[index];
			}
						
		}
	}
}

static TreeNode _get_GetN_special_sub_node(const TreeNode& trGetNSpecialTicks, int nPos, bool bType)
{
	switch(nPos)
	{
	case SAT_POS_BEGIN:
		if( bType )
			return trGetNSpecialTicks.Begin;
		else
			return trGetNSpecialTicks.BeginLabel;
		
	case SAT_POS_END:
		if( bType )
			return trGetNSpecialTicks.End;
		else
			return trGetNSpecialTicks.EndLabel;
		
	default:
		if( bType )
			return trGetNSpecialTicks.Special;
		else
			return trGetNSpecialTicks.SpecialLabel;
	}
	TreeNode trJunk;
	return trJunk;
}

static void _copy_special_tick_label_settings_from_GetN_to_theme(const TreeNode& trGetNSpecialTicks, TreeNode& trThemeSpecialTicks)
{
	if( !trGetNSpecialTicks || !trThemeSpecialTicks )
		return;
	
	vector<int> vnTypes;
	vector vValues;
	vector<string> vsLabels;	
	_get_GetN_one_special_tick_settings(SPECIAL_LABEL_POS_BEGIN, trGetNSpecialTicks.Begin, trGetNSpecialTicks.BeginLabel, vnTypes, vValues, vsLabels);	
	double dVal = trGetNSpecialTicks.SpecialValue.dVal;
	_get_GetN_one_special_tick_settings(SPECIAL_LABEL_POS_CUSTOM, trGetNSpecialTicks.Special, trGetNSpecialTicks.SpecialLabel, vnTypes, vValues, vsLabels, &dVal);
	_get_GetN_one_special_tick_settings(SPECIAL_LABEL_POS_END, trGetNSpecialTicks.End, trGetNSpecialTicks.EndLabel, vnTypes, vValues, vsLabels);
		
	trThemeSpecialTicks.Types.nVals = vnTypes;
	_set_change_bit(trThemeSpecialTicks.Types);
	trThemeSpecialTicks.Values.dVals = vValues;
	_set_change_bit(trThemeSpecialTicks.Values);
	trThemeSpecialTicks.Labels.strVals = vsLabels;
	_set_change_bit(trThemeSpecialTicks.Labels);
}

static void _get_GetN_one_special_tick_settings(int nPos, TreeNode& trType, TreeNode& trLabel, vector<int>& vnTypes, vector& vValues, vector<string>& vsLabels, double* pdVal = NULL)
{
	if( trType.nVal == SPECIAL_LABELS_AUTO )
		return;	
	
	int nType = 0;
	double dVal = NANUM;
	string strLabel = trLabel.strVal;	
	
	if( trType.nVal == SPECIAL_LABELS_HIDE )
		nType |= SAT_HIDE;
	else if( trType.nVal == SPECIAL_LABELS_MANUAL )
	{			
		nType |= SAT_LABEL;			
	}	
		
	switch(nPos)
	{
	case SPECIAL_LABEL_POS_BEGIN:
		nType |= SAT_POS_BEGIN;
		break;
		
	case SPECIAL_LABEL_POS_END:
		nType |= SAT_POS_END;
		break;
		
	case SPECIAL_LABEL_POS_CUSTOM:
		if( NULL != pdVal )
			dVal = *pdVal;
		nType |= SAT_POS_VALUE;
		break;
		
	default:
		break;			
	}
	
	vnTypes.Add(nType);
	vValues.Add(dVal);
	vsLabels.Add(strLabel);
}

static void _special_tick_label_type_list_event(TreeNode& trSpecialLabels)
{
	trSpecialLabels.BeginLabel.Enable = trSpecialLabels.Begin.nVal == SPECIAL_LABELS_MANUAL;
	trSpecialLabels.EndLabel.Enable = trSpecialLabels.End.nVal == SPECIAL_LABELS_MANUAL;
	trSpecialLabels.SpecialLabel.Enable = trSpecialLabels.Special.nVal == SPECIAL_LABELS_MANUAL;
}

/// Iris 6/21/2012 ORG-5991-S4 MOVE_SPECIAL_TICK_LABEL_OUTSIDE_LABELS_BRANCH
//static void _construct_special_tick_labels_gui(TreeNode& trBranch)
//{
	//GETN_USE(trBranch)
	//
	//GETN_BEGIN_BRANCH(SpecialLabels, STR_SPECIAL_TICK_LABELS_LABEL) GETN_ID(OTID_AXIS_SPECIALTICKS)
		//GETN_LIST(Begin, STR_AXIS_BEGIN_LABEL, 0, STR_SPECIAL_TICKS_TYPE_LIST)
		//GETN_STR(BeginLabel, STR_LABEL, "")
		//
		//GETN_LIST(End, STR_AXIS_END_LABEL, 0, STR_SPECIAL_TICKS_TYPE_LIST)
		//GETN_STR(EndLabel, STR_LABEL, "")
		//
		//GETN_LIST(Special, STR_SPECIAL_LABEL, 0, STR_SPECIAL_TICKS_TYPE_LIST)
		//GETN_STR(SpecialValue, STR_AT_AXIS_VALUE_LABEL, "")
		//GETN_STR(SpecialLabel, STR_LABEL, "")
	//GETN_END_BRANCH(SpecialLabels)
//}
///End MOVE_SPECIAL_TICK_LABEL_OUTSIDE_LABELS_BRANCH

/// Iris 4/27/2012 ORG-5528-S1 AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
//static string _get_axis_node_name(int nAxis, BOOL bTheme = FALSE)
string	AxesControlSplitter::getAxisNodeName(int nAxis, BOOL bTheme/* = FALSE*/)
///End AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
{
	/// RVD 9/21/2011 ORG-3685-p1 FIX_OLD_AXIS_UpdateThemeIDs
	if( bTheme )
	{
		/// Iris 4/27/2012 ORG-5528-S1 AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
		//return STR_AXIS + (nAxis + 1 );			
		return getThemeAxisNodeName(nAxis);
		///End AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
	}
	/// end FIX_OLD_AXIS_UpdateThemeIDs	
	return "Axis" + (nAxis + 1 );	
}

///Jasmine 09/09/2011 ORG-3297-S1 SHOW_AXIS_TITLE_TO_INDICATE_AXIS
//static string _get_axis_label_name(int nAxis)
//{
	//if( nAxis >= 0 )
		//return STR_AXIS_LABEL + (nAxis + 1 );
	//else
		//return _L("Axes");
//}
/// Iris 4/27/2012 ORG-5528-S1 AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
//static string _get_axis_label_name(int nAxis, const GraphLayer& glParent)
//{
	//string strName = _L("Axes");
	//if( nAxis >= 0 )
		//strName = STR_AXIS_LABEL + (nAxis + 1 );
	//
	//string strAxisName = "XB";
	//if(nAxis > 0)
		//strAxisName += nAxis;
	//GraphObject grObject = glParent.GraphObjects(strAxisName);
	//if(grObject && nAxis >= 0)
	//{
		//int nObjType;
		//string strObjectType = grObject.GetObjectType();
		//if(strObjectType.CompareNoCase("Text")  == 0)
		//{
			//strName += " - " + grObject.DisplayText;
		//}
	//}
	//
	//return strName;
//}
///End AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
///End SHOW_AXIS_TITLE_TO_INDICATE_AXIS

static string _get_axis_object_name(int nObjectType)
{
	switch(nObjectType)
	{
	case OKAXISDLG_SCALE:
		return STR_SCALE_LABEL;
		
	case OKAXISDLG_LABELSTYLE:
		return STR_TICK_LABELS_LABEL;
		
	case OKAXISDLG_GRIDLINE:
		return STR_GRIDS_LABEL;	
		
	/// Iris 6/08/2012 ORG-5930-P2 OPEN_AXIS_DIALOG_WHEN_SELECT_FROM_FORMAT_AXIS_TITLE
	case OKAXISDLG_TITLE:
		return STR_TITLE_LABEL;
	///End OPEN_AXIS_DIALOG_WHEN_SELECT_FROM_FORMAT_AXIS_TITLE
	}
	return "";
}

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
////////////////////// AxesControlSplitter ///////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
BEGIN_MESSAGE_MAP_DERIV(AxesControlSplitter, TreeDynaSplitter)
	ON_INIT(OnInitSplitter)
	ON_CONTEXTMENU(OnShowMenu)		///Jasmine 09/13/2011 ORG-3297 SELECT_RELATIVE_NODES_TO_APPLY_SETTINGS_TO_MULTIP_AXES	
	ON_GRID_BEFORE_ROW_COL_CHANGE(GetMainPaneID(), OnBeforeTreeViewSelection)
	ON_GRID_SEL_CHANGE(GetMainPaneID(), OnTreeViewSelectChange)	
	ON_GRID_DBLCLICK(GetMainPaneID(), OnTreeViewDBClick) /// Iris 8/06/2012 ORG-5991-S7 DB_CLICK_TO_OPEN_CLOSE_BRANCH
	ON_USER_MSG(WM_USER_TREEEDITOR_VALUE_CHANGE, OnEditTreeAfterValueChange)
	ON_USER_MSG(WM_USER_TREEEDITOR_UNDEFINE_CHANGE, OnUndefineChange) /// Bill 10/19/2011 ORG-3747-P2 DETECT_UNDEFINE_CHANGE
END_MESSAGE_MAP_DERIV

AxesControlSplitter::AxesControlSplitter() 
{
	//m_bAutoscaleIndependently = FALSE;	/// RVD 9/21/2011 ORG-3732-s1 SPIDER_INDIVIDUAL_SCALE
	/// Iris 11/10/2011 ORG4268-P2 UNCHECK_RESCALE_EACH_AXIS_INDEP_NOT_WORKED
	//m_bIsIndependentlyRescale = false; /// Iris 10/31/2011 ORG-4268-S1 NEED_DO_RESCALE_WHEN_INDEPDENTLY_RESCALE_CHECKED
	///End UNCHECK_RESCALE_EACH_AXIS_INDEP_NOT_WORKED	
}

AxesControlSplitter::~AxesControlSplitter()
{
}	

/// Iris 4/27/2012 ORG-5528-S1 AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
//void AxesControlSplitter::constructSpiderPlotGetN(TreeNode& trGetN, int nNumAngulars)
//{
	//GETN_USE(trGetN)
	//
	///// Iris 9/28/2011 ORG-3962-S1 IMPROVE_AXIS_DLG_GUI
	////GETN_BEGIN_BRANCH(Axes, STR_AXIS_LABEL) GETN_ID(ID_AXES)
	/////End IMPROVE_AXIS_DLG_GUI
	////--- CPY 10/04/2011 ORG-3732-s1 SPIDER_INDIVIDUAL_SCALE_SHOULD_BE_INSIDE_TREE
	///*
	///// Iris 9/28/2011 ORG-3962-S1 IMPROVE_AXIS_DLG_GUI
	//GETN_BEGIN_BRANCH(StartPosition, STR_ORIENTATION_LABEL) GETN_ID(OTID_START_POSITION)
		//GETN_LIST(CCW, STR_DIRECTION_LABEL, 0, _L("Clockwise|Counter-Clockwise")) GETN_ID(OTID_AXES_CCW)
		//GETN_COMBO(Angle, STR_ANGLE_LABEL, 90, "|0|45|90|180|270|360") GETN_ID(OTID_AXIS_ANGLE) 
	//GETN_END_BRANCH(StartPosition)
	/////End IMPROVE_AXIS_DLG_GUI
	//*/
	////--- end SPIDER_INDIVIDUAL_SCALE_SHOULD_BE_INSIDE_TREE
		////GETN_BEGIN_BRANCH(RadialAxis, STR_RADIAL_AXIS_LABEL) GETN_ID(OTID_RADIAL_AXIS) /// Iris 9/28/2011 ORG-3962-S1 IMPROVE_AXIS_DLG_GUI
		    //// Grids
			//GETN_BEGIN_BRANCH(Grids, STR_GRIDS_LABEL) GETN_ID_COLLECTION_BRANCH_EX(OTID_AXIS_GRIDS) GETN_MARK_STOP_BRANCH			
				//GETN_BEGIN_BRANCH(MajorGrids, STR_MAJOR_GRIDS_LABEL) GETN_ID_COLLECTION_MEMBER_REPEAT_BRANCH_EX(OTID_AXIS_GRID, 1) 
				//GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
					//constructGridPropertyNodes(_tmpNode, true);
				//GETN_END_BRANCH(MajorGrids)
				//
				//GETN_BEGIN_BRANCH(MinorGrids, STR_MINOR_GRIDS_LABEL) GETN_ID_COLLECTION_MEMBER_REPEAT_BRANCH_EX(OTID_AXIS_GRID, 2)
				//GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
					//constructGridPropertyNodes(_tmpNode, false);
				//GETN_END_BRANCH(MinorGrids)				
			//GETN_END_BRANCH(Grids)
			//
			//// AxisN
			//constructAllAxesPropertyNodes(_tmpNode, nNumAngulars);				
		////GETN_END_BRANCH(RadialAxis) /// Iris 9/28/2011 ORG-3962-S1 IMPROVE_AXIS_DLG_GUI
		//
		////--- CPY 10/04/2011 ORG-3732-s1 SPIDER_INDIVIDUAL_SCALE_SHOULD_BE_INSIDE_TREE
		//// GETN_OPTION_SPECIALVALS("Junk") = GETN_MARK_STOP_BRANCH, will just add an attribute STR_SPECIALVALS_ATTRIB which we will use to indicate stop tree at that branch
		//GETN_BEGIN_BRANCH(Misc, STR_MISC_BRANCH_LABEL) GETN_ID(IDBRANCH_MISC) GETN_MARK_STOP_BRANCH
			//GETN_CHECK(IndepScales, STR_INDEP_SCALES, 0) GETN_ID(OTID_AXES_INDIVIDUALSCALE)
			///// Iris 11/03/2011 ORG-4268-S4 ADD_ONLY_SHOW_TICK_LABEL_ON_1ST_AXIS_CHECKBOX
			//GETN_CHECK(TickLabelFor1stAxis, STR_ONLY_SHOW_TICK_LABELS_FOR_1ST_AXIS_LABEL, 1) GETN_ID(ID_ONLY_SHOW_TICK_LABELS_FOR_1ST_AXIS)
			//setOnlyOneTickLabelFor1stAxisInitStatus(_tmpSubNode);
			//if( !m_bForAll )
				//_tmpSubNode.Enable = false;
			/////End ADD_ONLY_SHOW_TICK_LABEL_ON_1ST_AXIS_CHECKBOX			
			//GETN_CHECK(Hide1stTickLabels, STR_HIDE_1ST_TICK_LABELS_LABEL, 0) GETN_ID(ID_HIDE_1ST_TICK_LABELS) /// Iris 11/04/2011 ORG-4268-S3 ADD_HIDE_1ST_TICK_LABEL_CHECKBOX
			//
			//GETN_BEGIN_BRANCH(StartPosition, STR_ORIENTATION_LABEL) GETN_ID(OTID_START_POSITION) GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
				//GETN_LIST(CCW, STR_DIRECTION_LABEL, 0, _L("Clockwise|Counter-Clockwise")) GETN_ID(OTID_AXES_CCW)
				//GETN_COMBO(Angle, STR_ANGLE_LABEL, 90, "|0|45|90|180|270|360") GETN_ID(OTID_AXIS_ANGLE) 
			//GETN_END_BRANCH(StartPosition)
		//GETN_END_BRANCH(Misc)
		////--- end SPIDER_INDIVIDUAL_SCALE_SHOULD_BE_INSIDE_TREE
		//
		///// Iris 9/28/2011 ORG-3962-S1 IMPROVE_AXIS_DLG_GUI
		///*
		//GETN_BEGIN_BRANCH(CategoryAxis, STR_CATEGORY_AXIS_LABEL) GETN_ID(OTID_CATEGORY_AXIS)
			//GETN_BEGIN_BRANCH(StartPosition, STR_START_POSITION_LABEL) GETN_ID(OTID_START_POSITION)
				//GETN_LIST(CCW, STR_DIRECTION_LABEL, 0, _L("Clockwise|Counter-Clockwise")) GETN_ID(OTID_AXES_CCW)
				//GETN_COMBO(Angle, STR_ANGLE_LABEL, 90, "|0|45|90|180|270|360") GETN_ID(OTID_AXIS_ANGLE) 
			//GETN_END_BRANCH(StartPosition)				
		//GETN_END_BRANCH(CategoryAxis)
		//*/
		/////End IMPROVE_AXIS_DLG_GUI
//
	////GETN_END_BRANCH(Axes) /// Iris 9/28/2011 ORG-3962-S1 IMPROVE_AXIS_DLG_GUI
//}
///End AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH

/// Iris 8/06/2012 ORG-6463-S1 ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
DWORD AxesControlSplitter::GetListTreeDisplayCtrl() 
{ 
	DWORD dwCtrl = ATRN_SKIP_LEAFS|ATRN_LOOP_MARDED_NODE_ONLY;
	int nStopLevel = GetStopLevel();
	if( -1 != nStopLevel )
		dwCtrl |= ATRN_STOP_LEVEL | nStopLevel;
	return dwCtrl;
}
///End ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX

void AxesControlSplitter::ConstructAllAxesPropertyNodes(TreeNode& trBranch, int nNumAngulars)
{
	bool bForAllAxes = false;
	int nRealNumAngulars = nNumAngulars;
	if( nNumAngulars == -1 )
	{
		bForAllAxes = true;
		nRealNumAngulars = 1;
	}
	
	for(int nAngular = 0; nAngular < nRealNumAngulars; nAngular++)
	{
		int nAngularLT = nAngular + 1;
		/// Iris 4/27/2012 ORG-5528-S1 AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
		//TreeNode trAxis = trBranch.AddNode(_get_axis_node_name(nAngular), TRGP_BRANCH);	
		TreeNode trAxis = trBranch.AddNode(getAxisNodeName(nAngular), TRGP_BRANCH);	
		///End AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
		
		int nn = bForAllAxes ? -1 : nAngular;
		/// Iris 4/27/2012 ORG-5528-S1 AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
		//trAxis.SetAttribute(STR_LABEL_ATTRIB, _get_axis_label_name(nn, m_gl));
		trAxis.SetAttribute(STR_LABEL_ATTRIB, getAxisLabelName(nn, m_gl));
		///End AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
		
		/// Iris 7/20/2012 ORG-6270-S1 IMPROVE_TICK_LABELS_BRANCH_SPEED
		trAxis.SetAttribute(STR_SPECIALVALS_ATTRIB, "junk");
		///End IMPROVE_TICK_LABELS_BRANCH_SPEED
		
		/// Iris 10/09/2011 UPDATED_AFTER_ROMAN_CHANGE_ABOUT_SPIDER_THEME_IMPROVE
		//if( !bForAllAxes )
		///End UPDATED_AFTER_ROMAN_CHANGE_ABOUT_SPIDER_THEME_IMPROVE
		{			
			/// Iris 4/27/2012 ORG-5528-S1 AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
			//_set_collection_member_branch_id_with_repeat_id(trAxis, ID_AXIS, nAngularLT);
			_set_collection_member_branch_id_with_repeat_id(trAxis, getThemeAxisNodeID(), 0, nAngularLT);
			///End AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
		}
		/// Iris 10/09/2011 UPDATED_AFTER_ROMAN_CHANGE_ABOUT_SPIDER_THEME_IMPROVE
		//else
		//{
			//trAxis.DataID = ID_AXIS;
		//}
		///End UPDATED_AFTER_ROMAN_CHANGE_ABOUT_SPIDER_THEME_IMPROVE
		
		/// Iris 4/27/2012 ORG-5528-S1 AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
		//ConstructOneAxisPropertyNodes(trAxis);
		ConstructOneAxisPropertyNodes(trAxis, nAngular);
		///End AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
	}
}

/// Iris 11/07/2011 ONLY_KEEP_LINEAR_AND_LOG10_IN_SCALE_TYPE_LIST
static void _temp_remove_complex_log_scale_type(TreeNode& trScaleType)
{
	if( !trScaleType )
		return;
	
	string strTypes;
	if( !trScaleType.GetAttribute(STR_COMBO_ATTRIB, strTypes) )
		return;
	
	vector<string> vsTypes;
	strTypes.GetTokens(vsTypes, '|');
	
	vsTypes.SetSize(2);
	strTypes.SetTokens(vsTypes, '|');
	trScaleType.SetAttribute(STR_COMBO_ATTRIB, strTypes);
}
///End ONLY_KEEP_LINEAR_AND_LOG10_IN_SCALE_TYPE_LIST

/// Iris 2/06/2012 ORG-4218-P1 SUPPORT_TICK_LABEL_FORMAT_TYPE
enum
{
	TICK_TYPE_NUMERIC = 0,
	TICK_TYPE_DATASET,
	TICK_TYPE_TIME,
	TICK_TYPE_DATE,
	TICK_TYPE_MONTH,
	TICK_TYPE_WEEK_DAY,	
	TICK_TYPE_COLUMN,
	TICK_TYPE_INDEXED_DATASET,
	TICK_TYPE_CATEGORICAL,	
	TICK_TYPE_INDEXED_STRING,
	
	TICK_TYPE_LAST_ITEM
};

//static const vector<uint> s_vnGUITypes = {RADAR_TICK_TYPE_NUMERIC, RADAR_TICK_TYPE_TIME, RADAR_TICK_TYPE_DATE, RADAR_TICK_TYPE_MONTH, RADAR_TICK_TYPE_WEEK_DAY, RADAR_TICK_TYPE_INDEXED_STRING};

//static int _convert_ticklabel_gui_type(int nGUIType)
//{
	//vector<uint> vnIndex;
	//if( s_vnGUITypes.Find(vnIndex, nGUIType) > 0 && vnIndex.GetSize() > 0 )
	//{
		//return s_vnTypes[vnIndex[0]];
	//}
	//ASSERT(false);
	//return OULABEL_NUMERIC;
//}
//
//static int _convert_ticklabel_theme_type(int nThemeType)
//{
	//vector<uint> vnIndex;
	//if( s_vnTypes.Find(vnIndex, nThemeType) > 0 && vnIndex.GetSize() > 0 )
	//{
		//return s_vnGUITypes[vnIndex[0]];
	//}
	//ASSERT(false);
	//return TICK_TYPE_NUMERIC;	
//}

static void _update_tick_label_type_list(TreeNode& trType)
{
	const vector<uint> vnNotSupport = {
		TICK_TYPE_DATASET,
		TICK_TYPE_COLUMN,	
		/// Iris 5/25/2012 ORG-4218-P7 SHOULD_NOT_SUPPORT_INDEXED_DATASET_TICK_LABEL_TYPE_IN_AXES_DLG_FOR_RADAR
		/*
		TICK_TYPE_CATEGORICAL,
		TICK_TYPE_INDEXED_STRING
		
		*/
		TICK_TYPE_INDEXED_DATASET,
		TICK_TYPE_CATEGORICAL
		///End SHOULD_NOT_SUPPORT_INDEXED_DATASET_TICK_LABEL_TYPE_IN_AXES_DLG_FOR_RADAR
	};
	
	string strCombo;
	trType.GetAttribute(STR_COMBO_ATTRIB, strCombo);
	vector<string> vsTypes;
	strCombo.GetTokens(vsTypes, '|');
	
	/// Iris 5/25/2012 ORG-4218-P7 SHOULD_NOT_SUPPORT_INDEXED_DATASET_TICK_LABEL_TYPE_IN_AXES_DLG_FOR_RADAR
	vector<int> vnTypes;
	vnTypes.Data(0, TICK_TYPE_LAST_ITEM - 1, 1);
	///End SHOULD_NOT_SUPPORT_INDEXED_DATASET_TICK_LABEL_TYPE_IN_AXES_DLG_FOR_RADAR
	
	for(int index = vnNotSupport.GetSize() - 1; index >= 0; --index)
	{
		vsTypes.RemoveAt(vnNotSupport[index]);
		vnTypes.RemoveAt(vnNotSupport[index]); /// Iris 5/25/2012 ORG-4218-P7 SHOULD_NOT_SUPPORT_INDEXED_DATASET_TICK_LABEL_TYPE_IN_AXES_DLG_FOR_RADAR
	}		
	strCombo.SetTokens(vsTypes, '|');
	trType.SetAttribute(STR_COMBO_ATTRIB, strCombo);
	/// Iris 5/25/2012 ORG-4218-P7 SHOULD_NOT_SUPPORT_INDEXED_DATASET_TICK_LABEL_TYPE_IN_AXES_DLG_FOR_RADAR
	//trType.SetAttribute(STR_INTMAP_ATTRIB, "0|2|3|4|5|7");
	vector<string> vsTypeMap;
	convert_int_vector_to_string_vector(vnTypes, vsTypeMap);	
	string strTypeMap;
	strTypeMap.SetTokens(vsTypeMap, '|');
	trType.SetAttribute(STR_INTMAP_ATTRIB, strTypeMap);
	///End SHOULD_NOT_SUPPORT_INDEXED_DATASET_TICK_LABEL_TYPE_IN_AXES_DLG_FOR_RADAR
}

///------ Folger 10/09/2012 ORG-7080-P1 DATE_TIME_CUSTOM_DISPLAY_FAILED_TO_SHOW_IN_AXESDLG
//static void _custom_display_show_hide(TreeNode& trDisplay, TreeNode& trCustomDisplay)
static void _custom_display_show_hide(TreeNode& trDisplay, TreeNode& trCustomDisplay, int nCustom)
///------ End DATE_TIME_CUSTOM_DISPLAY_FAILED_TO_SHOW_IN_AXESDLG
{
	if( trDisplay && trCustomDisplay )
	{
		///------ Folger 10/09/2012 ORG-7080-P1 DATE_TIME_CUSTOM_DISPLAY_FAILED_TO_SHOW_IN_AXESDLG
		//string strCombo;
		//trDisplay.GetAttribute(STR_COMBO_ATTRIB, strCombo);
		//string strSel = strCombo.GetToken(trDisplay.nVal, '|');
		//
		//trCustomDisplay.Show = (trDisplay.Show && 0 == strSel.CompareNoCase(STR_CUSTOM_DISPLAY_LABEL));
		trCustomDisplay.Show = trDisplay.Show && trDisplay.nVal == nCustom;
		///------ End DATE_TIME_CUSTOM_DISPLAY_FAILED_TO_SHOW_IN_AXESDLG
	}
}

static bool _ticklabel_type_event(TreeNode& trBranch, TreeNode& trType, TreeNode* ptrDisplay = NULL)
{
	if( !trBranch || !trType )
		return false;	
	
	TreeNode trNumericDisplay = trBranch.NumericDisplay;
	TreeNode trDatasetNameDisplay = trBranch.DatasetName;
	TreeNode trMonthDisplay = trBranch.MonthDisplay;
	TreeNode trDayDisplay = trBranch.DayDisplay;
	TreeNode trTimeDisplay = trBranch.TimeDisplay;
	TreeNode trDateDisplay = trBranch.DateDisplay;	
	TreeNode trTextDisplay = trBranch.TextDisplay;
	/// Iris 5/21/2012 ORG-4218-P5 ADD_DATETIME_CUSTOM_FORMAT_CONTROL
	TreeNode trDateCustomDisplay = trBranch.DateCustomDisplay;
	TreeNode trTimeCustomDisplay = trBranch.TimeCustomDisplay;
	///End ADD_DATETIME_CUSTOM_FORMAT_CONTROL
	
	if( !trNumericDisplay || !trMonthDisplay || !trDayDisplay || !trTimeDisplay || !trDateDisplay || !trTextDisplay )
		return false;
	
	if( trDatasetNameDisplay )
		trDatasetNameDisplay.Show = false;	
	
	/// Iris 5/25/2012 ORG-4218-P6 ONLY_SHOW_DIVIDE_BY_FACTOR_FOR_NUMERIC_AND_COLUMN_TICK_TYPE
	bool bNumericType = (TICK_TYPE_NUMERIC == trType.nVal || TICK_TYPE_COLUMN == trType.nVal);
	TreeNode trDivideByFactor = _get_GetN_node_by_id(trBranch, OTID_AXIS_LABEL_DIVIDE_BY_FACTOR, true);
	if( trDivideByFactor )
		trDivideByFactor.Show = bNumericType;
	TreeNode trCustomDecimal = _get_GetN_node_by_id(trBranch, OTID_AXIS_LABEL_MANUAL_DEC, true);
	if( trCustomDecimal )
	{
		trCustomDecimal.Show = bNumericType;
		
		//---- Iris 9/27/2012 to fix when change tick label type to Date/Time, the hits is not hidden.
		int nCheck;		
		if( trBranch.hits && trCustomDecimal.GetAttribute(STR_ATTRIB_DYNACONTROL_USE_CHECK, nCheck) )
			trBranch.hits.Show = trCustomDecimal.Show && 1 == nCheck;
		//----
	}
	///End ONLY_SHOW_DIVIDE_BY_FACTOR_FOR_NUMERIC_AND_COLUMN_TICK_TYPE
		
	TreeNode trDisplay;
	int nType = trType.nVal;	
	switch(nType)
	{
	case TICK_TYPE_NUMERIC:	
		trDisplay = trNumericDisplay;
		
		trMonthDisplay.Show = 
		trDayDisplay.Show = 
		trTimeDisplay.Show = 
		trDateDisplay.Show = 		
		trTextDisplay.Show = 		
		false;		
		break;
		
	case TICK_TYPE_DATASET:
	case TICK_TYPE_INDEXED_DATASET:
	case TICK_TYPE_CATEGORICAL:	
		trDisplay = trDatasetNameDisplay;
		
		trNumericDisplay.Show = 
		trMonthDisplay.Show = 
		trDayDisplay.Show = 
		trTimeDisplay.Show = 
		trDateDisplay.Show = 		
		trTextDisplay.Show = 		
		false;
		break;
		
	case TICK_TYPE_TIME:		
		trDisplay = trTimeDisplay;	
		trTimeDisplay.Show = true;
		
		trNumericDisplay.Show =
		trMonthDisplay.Show = 
		trDayDisplay.Show = 
		trDateDisplay.Show = 		
		trTextDisplay.Show = 		
		false;				
		
		break;
		
	case TICK_TYPE_DATE:		
		trDisplay = trDateDisplay;	
		trDateDisplay.Show = true;
		
		trNumericDisplay.Show =
		trMonthDisplay.Show = 
		trDayDisplay.Show = 
		trTimeDisplay.Show = 		
		trTextDisplay.Show = 
		false;			
		
		break;
		
	case TICK_TYPE_MONTH:		
		trDisplay = trMonthDisplay;
		
		trNumericDisplay.Show =		
		trDayDisplay.Show = 
		trTimeDisplay.Show = 
		trDateDisplay.Show = 		
		trTextDisplay.Show = 		
		false;			
		break;
		
	case TICK_TYPE_WEEK_DAY:		
		trDisplay = trDayDisplay;
		
		trNumericDisplay.Show =
		trMonthDisplay.Show = 		
		trTimeDisplay.Show = 
		trDateDisplay.Show = 		
		trTextDisplay.Show = 		
		false;			
		break;	
		
	case TICK_TYPE_COLUMN:				
		trNumericDisplay.Show = 
		trMonthDisplay.Show = 
		trDayDisplay.Show = 
		trTimeDisplay.Show = 
		trDateDisplay.Show = 		
		trTextDisplay.Show = 		
		false;
		break;
		
	case TICK_TYPE_INDEXED_STRING:
		trDisplay = trTextDisplay;
		
		trNumericDisplay.Show =
		trDayDisplay.Show =
		trMonthDisplay.Show = 		
		trTimeDisplay.Show = 
		trDateDisplay.Show = 		
		false;			
		break;		
	}	
		
	if( trDisplay )
	{
		if( NULL != ptrDisplay )
			*ptrDisplay = trDisplay;
		trDisplay.Show = true;			
	}	
	
	/// Iris 5/21/2012 ORG-4218-P5 ADD_DATETIME_CUSTOM_FORMAT_CONTROL		
	///------ Folger 10/09/2012 ORG-7080-P1 DATE_TIME_CUSTOM_DISPLAY_FAILED_TO_SHOW_IN_AXESDLG
	//_custom_display_show_hide(trDateDisplay, trDateCustomDisplay);
	//_custom_display_show_hide(trTimeDisplay, trTimeCustomDisplay);	
	_custom_display_show_hide(trDateDisplay, trDateCustomDisplay, LDF_OBJ_CUSTOM);
	_custom_display_show_hide(trTimeDisplay, trTimeCustomDisplay, LTF_OBJ_CUSTOM);
	///------ End DATE_TIME_CUSTOM_DISPLAY_FAILED_TO_SHOW_IN_AXESDLG
	///End ADD_DATETIME_CUSTOM_FORMAT_CONTROL
		
	return true;
}

static void _update_dataset_list(TreeNode& tr)
{	
	string strNames = okutil_get_dataset_list();
	///Kyle 08/24/2012 ORG-6629-P1 MAKE_LABEL_DATASET_DROPDOWN_EDITABLE
	///// Iris 6/29/2012 ORG-5528-P20 FIX_EMPTY_DROPDOWN_LIST_DISPLAY_AS_EDITBOX
	//if( strNames.IsEmpty() )
	//	strNames = "|";
	/////End FIX_EMPTY_DROPDOWN_LIST_DISPLAY_AS_EDITBOX
	strNames = "|" + strNames;
	///End MAKE_LABEL_DATASET_DROPDOWN_EDITABLE
	tr.SetAttribute(STR_COMBO_ATTRIB, strNames); 
	tr.strVal = "";	
}
///End SUPPORT_TICK_LABEL_FORMAT_TYPE

/// Iris 8/22/2012 ORG-6463-P6 IMPROVE_AXIS_POSITION_REFER_AXIS	
//virtual 
int GL3DPlotAxesControlSplitter::GetAutoHideStatus()
{
	AXISAUTOHIDESTATUS nAutoHideStatus = AXISAUTOHIDE_INTERNAL;
	
	if( SHOW_PRIMARY_ONLY_CHECKED == GetShowPrimaryAxesOnlyStatus() )
		nAutoHideStatus = AXISAUTOHIDE_ON;
	else if( SHOW_PRIMARY_ONLY_UNCHECKED == GetShowPrimaryAxesOnlyStatus() )
		nAutoHideStatus = AXISAUTOHIDE_OFF;		
	
	return nAutoHideStatus;
}
///End IMPROVE_AXIS_POSITION_REFER_AXIS

/// Iris 6/01/2012 ORG-5528-P3 FIX_LINE_OFFSET_DEFAULT_SHOULD_BE_HIDDEN
/// Iris 8/22/2012 ORG-6463-P6 IMPROVE_AXIS_POSITION_REFER_AXIS
//static void _update_position_offset_show_hide(TreeNode& trLineBranch, GraphLayer& gl, AxisObject& ao)
static void _update_position_offset_show_hide(TreeNode& trLineBranch, GraphLayer& gl, AxisObject& ao, int nAutoHideStatus = AXISAUTOHIDE_INTERNAL)
///End IMPROVE_AXIS_POSITION_REFER_AXIS
{	
	if( trLineBranch && trLineBranch.Position && trLineBranch.Offset && ao)
	{
		/// Iris 8/22/2012 ORG-6463-P6 IMPROVE_AXIS_POSITION_REFER_AXIS
		//int nRelativeAxis = ao.Get2ndDimAxis();		
		int nRelativeAxis = ao.Get2ndDimAxis(nAutoHideStatus);
		///End IMPROVE_AXIS_POSITION_REFER_AXIS
		
		AxisObject aoRelativeLabel;
		int nRelativeAxisType = OULABEL_NUMERIC;
		if( _get_axis_object(aoRelativeLabel, gl, nRelativeAxis, AXISOBJPOS_LABEL_FIRST) )// always use the first sub axis here 	
		{
			string str;
			int nFormat;
			aoRelativeLabel.GetTypeFormatEtc(nRelativeAxisType, &str, &nFormat);	
			
			/// Iris 7/26/2012 ORG-6424-P4 FIX_DATE_TYPE_POSSION_OFFSET_NOT_WORK
			if( OULABEL_NUMERIC != nRelativeAxisType )
			{
				TreeNode trDateOrTimeOffset = OULABEL_DATE == nRelativeAxisType ? trLineBranch.DateOffset : trLineBranch.TimeOffset;
				if( trDateOrTimeOffset )
				{
					string strFormat = OULABEL_DATE == nRelativeAxisType ? get_date_format_str(nFormat) : get_time_format_str(nFormat);				
					trDateOrTimeOffset.SetAttribute(STR_ATTRIB_DATE_TIME_CUSTOM_FORMAT, strFormat); // set GetN control display format
					trDateOrTimeOffset.dVal = trLineBranch.Offset.dVal;
				}
			}
			///End FIX_DATE_TYPE_POSSION_OFFSET_NOT_WORK
		}
		
		trLineBranch.Offset.Show = TICK_POS_PRECENT == trLineBranch.Position.nVal || TICK_POS_AT_VAL == trLineBranch.Position.nVal && OULABEL_DATE != nRelativeAxisType && OULABEL_TIME != nRelativeAxisType;
		trLineBranch.DateOffset.Show = TICK_POS_AT_VAL == trLineBranch.Position.nVal && OULABEL_DATE == nRelativeAxisType;
		trLineBranch.TimeOffset.Show = TICK_POS_AT_VAL == trLineBranch.Position.nVal && OULABEL_TIME == nRelativeAxisType;			
	}
}
///End FIX_LINE_OFFSET_DEFAULT_SHOULD_BE_HIDDEN

static bool _get_axis_object(AxisObject& ao, GraphLayer& gl, int nAxis, int nAxisObject)
{
	Axis axis;
	switch(nAxis)
	{
	case AXIS_X:
		axis = gl.XAxis;
		break;
		
	case AXIS_Y:
		axis = gl.YAxis;
		break;
		
	case AXIS_Z:
		axis = gl.ZAxis;
		break;	
		
	default:
		ASSERT(false);
		break;
	}
	if( !axis )
		return false;	
					
	if( axis )
	{								
		ao = axis.AxisObjects(nAxisObject);
	}	
	return ao.IsValid();
}

/// Iris 4/27/2012 ORG-5528-S1 AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
//void AxesControlSplitter::ConstructOneAxisPropertyNodes(TreeNode& trAxis)
//{
	//GETN_USE(trAxis)
	//
	//// Title
	//{
		//GETN_BEGIN_BRANCH(Title, STR_TITLE_LABEL) GETN_ID(OTID_AXIS_TITLE)
			//GETN_CHECK(Show, STR_SHOW_LABEL, 1) GETN_ID(OTID_LABEL_SHOW)
			//GETN_COLOR(Color, STR_COLOR_LABEL, 0) GETN_ID(OTID_LABEL_COLOR) GETN_COLOR_CHOICE_OPTIONS(COLORLIST_SINGLE|COLORLIST_CUSTOM|COLORLIST_AUTO)
			//GETN_COMBO(Angle, STR_ANGLE_LABEL, 0, "|0|45|90|180|270") GETN_ID(OTID_LABEL_ANGLE)
			//
			//GETN_BEGIN_BRANCH(Dimension, STR_DIMENSION_LABEL) GETN_ID(OTID_LABEL_DIMENSION)
			//GETN_OPTION_BRANCH(GETNBRANCH_OPEN)	///Jasmine 09/15/2011 ORG-3297 EXPAND_AXIS_PROPERTY_BRANCH_SUBNODE
				//GETN_NUM(XOffset, STR_XOFFSET_LABEL, 0) GETN_ID(OTID_AXIS_TITLE_DIMENSION_XOFFSET)
				//GETN_NUM(YOffset, STR_YOFFSET_LABEL, 0) GETN_ID(OTID_AXIS_TITLE_DIMENSION_YOFFSET)
			//GETN_END_BRANCH(Dimension)
			//
			//GETN_BEGIN_BRANCH(Font, STR_FONT_LABEL) GETN_ID(OTID_LABEL_FONT)
			//GETN_OPTION_BRANCH(GETNBRANCH_OPEN)	///Jasmine 09/15/2011 ORG-3297 EXPAND_AXIS_PROPERTY_BRANCH_SUBNODE
				//GETN_FONT(Face, STR_FONT_LABEL, 0 )GETN_ID(OTID_LABEL_FONT_FACE)
				//GETN_COMBO(Size, STR_FONT_SIZE_LABEL, 26, "|8|9|10|11|12|14|16|18|20|22|24|26|28|36|48|72") GETN_ID(OTID_LABEL_FONT_SIZE)		
			//GETN_END_BRANCH(Font)				
		//GETN_END_BRANCH(Title)
	//}
	//
	//// Line
	//{
		//GETN_BEGIN_BRANCH(Line, STR_LINE_LABEL) GETN_ID(OTID_AXIS_LINE)		
			//GETN_CHECK(Show, STR_SHOW_LABEL, 1) GETN_ID(OTID_AXIS_TICK_SHOW)
			//GETN_COLOR(Color, STR_COLOR_LABEL, 0) GETN_ID(OTID_AXIS_TICK_COLOR) GETN_COLOR_CHOICE_OPTIONS(COLORLIST_SINGLE|COLORLIST_CUSTOM)
			//vector vWidths = {0.2, 0.5, 1, 1.5, 2, 3, 4, 5};
			//GETN_COMBO(Width, STR_WIDTH_LABEL, 1.0, construct_double_combo_list(vWidths, "*2*", true)) GETN_ID(OTID_AXIS_TICK_WIDTH)	
		//GETN_END_BRANCH(Line)	
	//}
	//
	//// Scale
	//{
		//GETN_BEGIN_BRANCH(Scale, STR_SCALE_LABEL) GETN_ID(OTID_AXIS_SCALE)
			//GETN_NUM(From, STR_FROM_LABEL, 0) GETN_ID(OTID_AXIS_SCALE_FROM)
			//GETN_NUM(To, STR_TO_LABEL, 0) GETN_ID(OTID_AXIS_SCALE_TO)
			//GETN_LIST(Type, STR_TYPE_LABEL, 0, "") GETN_ID(OTID_AXIS_SCALE_TYPE) GETN_ADD_COMBO			
			//_temp_remove_complex_log_scale_type(_tmpSubNode); /// Iris 11/07/2011 ONLY_KEEP_LINEAR_AND_LOG10_IN_SCALE_TYPE_LIST
			//
			///// Kenny 10/24/2011 ORG-4114-P2 SPIDER_PLOT_AXES_RESCALE_MODE
			//GETN_LIST(Rescale, STR_RESCALE_MODE, AXIS_RESCALE_AUTO, "") GETN_ID(OTID_AXIS_SCALE_RESCALE) GETN_ADD_COMBO
			///// End SPIDER_PLOT_AXES_RESCALE_MODE
			///// Iris 8/18/2011 ORG-3297 IMPROVE_INCREMENT_BY_CONTROLS
			///*
			//GETN_LIST(IncrementBy, STR_INCREMENTBY_LABEL, 0, "") GETN_ID(OTID_AXIS_SCALE_INCBY) GETN_ADD_COMBO
			//GETN_NUM(Value, STR_VALUE_LABEL, 0) GETN_ID(OTID_AXIS_SCALE_INC_VALUE)
			//GETN_NUM(MajorTickCount, STR_MAJOR_TICK_COUNT_LABEL, 0) GETN_ID(OTID_AXIS_SCALE_MAJOR_COUNT)
			//*/
			//GETN_RADIO_INDEX_EX(IncrementBy, STR_MAJOR_TICKS_LABEL, 0, _L("By Increment|By # of Majors")) GETN_ID(OTID_AXIS_SCALE_INCBY)
			//GETN_NUM(Value, " ", 0) GETN_ID(OTID_AXIS_SCALE_INC_VALUE)
			//GETN_NUM(MajorTicksCount, " ", 0) GETN_ID(OTID_AXIS_SCALE_MAJOR_COUNT) _tmpSubNode.Show = false; /// Iris 8/19/2011 COMBINE_INCVALUE_AND_MAJORTICKSCOUNT_AS_ONE_CONTROL
			/////End IMPROVE_INCREMENT_BY_CONTROLS
			//GETN_NUM(MinorTicksCount, STR_MINOR_TICK_COUNT_LABEL, 1) GETN_ID(OTID_AXIS_SCALE_MINOR_COUNT)		
		//GETN_END_BRANCH(Scale)	
	//}	
			//
	////Ticks
	//{
		//GETN_BEGIN_BRANCH(Ticks, STR_TICKS_LABEL) GETN_ID_COLLECTION_BRANCH_EX(OTID_AXIS_TICKS)
			//GETN_BEGIN_BRANCH(MajorTicks, STR_MAJOR_TICKS_LABEL) GETN_ID_COLLECTION_MEMBER_REPEAT_BRANCH_EX(OTID_AXIS_TICK, 1)
			//GETN_OPTION_BRANCH(GETNBRANCH_OPEN)	///Jasmine 09/15/2011 ORG-3297 EXPAND_AXIS_PROPERTY_BRANCH_SUBNODE
				//constructTicksPropertyNodes(_tmpNode);
			//GETN_END_BRANCH(MajorTicks)
			//
			//GETN_BEGIN_BRANCH(MinorTicks, STR_MINOR_TICKS_LABEL) GETN_ID_COLLECTION_MEMBER_REPEAT_BRANCH_EX(OTID_AXIS_TICK, 2)
			//GETN_OPTION_BRANCH(GETNBRANCH_OPEN)	///Jasmine 09/15/2011 ORG-3297 EXPAND_AXIS_PROPERTY_BRANCH_SUBNODE
				//constructTicksPropertyNodes(_tmpNode);
			//GETN_END_BRANCH(MinorTicks)		
		//GETN_END_BRANCH(Ticks)	
	//}
//
	//// Labels
	//{
		//GETN_BEGIN_BRANCH(Labels, STR_TICK_LABELS_LABEL) GETN_ID_COLLECTION_BRANCH_EX(OTID_AXIS_LABELS)		
			//
			//GETN_BEGIN_BRANCH(MajorLabels, STR_MAJOR_TICK_LABELS_LABEL) GETN_ID_COLLECTION_MEMBER_REPEAT_BRANCH_EX(OTID_AXIS_LABEL, 1)	
			//GETN_OPTION_BRANCH(GETNBRANCH_OPEN)	///Jasmine 09/15/2011 ORG-3297 EXPAND_AXIS_PROPERTY_BRANCH_SUBNODE
				///// Iris 9/28/2011 ORG-3747-S2 COMBINE_TICKLABEL_SHOW_OPPOSITE_AS_ONE_DROPDOWN
				///*
				//constructLabelsPropertyNodes(_tmpNode, true);	
				//
				///// Iris 9/19/2011 ORG-3819-S2 ADD_MORE_TICK_LABEL_PROPERTIES
				//GETN_CHECK(CustomDecimal, STR_CUSTOM_DECIMAL_LABEL, 0)	GETN_ID(OTID_AXIS_LABEL_MANUAL_DEC)
				//GETN_STR(DecimalPlaces, STR_DECIMAL_PLACES_LABEL, "")	GETN_ID(OTID_AXIS_LABEL_DEC_DIGITS)
				/////End ADD_MORE_TICK_LABEL_PROPERTIES
				//*/
				///// Iris 10/12/2011 ORG-3747-S2 COMBINE_TICKLABEL_SHOW_OPPOSITE_AS_ONE_DROPDOWN
				////GETN_LIST(Show, STR_SHOW_LABEL, 0, "None|Before Axis|After Axis") GETN_ID(OTID_AXIS_LABEL_SHOW)
				//GETN_LIST(ShowEx, STR_SHOW_LABEL, 0, _L("None|Before Axis|After Axis")) GETN_ID(OTID_AXIS_LABEL_SHOWLABEL)
				/////End COMBINE_TICKLABEL_SHOW_OPPOSITE_AS_ONE_DROPDOWN
				/////End COMBINE_TICKLABEL_SHOW_OPPOSITE_AS_ONE_DROPDOWN
				//
			    //// put here even this color for both major and minor label since easy copy value by id with repeat id from theme tree to GetN tree
			    ///// Iris 09/06/2011 ORG-3297-P1 FIX_LABEL_COLOR_CHANGED_WITH_LINE_COLOR_BUT_GUI_NOT_CHANGE
				////GETN_COLOR(Color, STR_COLOR_LABEL, 0) GETN_ID(OTID_AXIS_LABEL_COLOR) GETN_COLOR_CHOICE_OPTIONS(COLORLIST_SINGLE|COLORLIST_CUSTOM)
				//GETN_COLOR(Color, STR_COLOR_LABEL, INDEX_COLOR_AUTOMATIC) GETN_ID(OTID_AXIS_LABEL_COLOR) GETN_COLOR_CHOICE_OPTIONS(COLORLIST_SINGLE|COLORLIST_CUSTOM|COLORLIST_AUTO)
				/////End FIX_LABEL_COLOR_CHANGED_WITH_LINE_COLOR_BUT_GUI_NOT_CHANGE
				//
				///// Iris 2/06/2012 ORG-4218-P1 SUPPORT_TICK_LABEL_FORMAT_TYPE
				//GETN_LIST(Type, STR_TYPE_LABEL, 0, "") GETN_ID(OTID_AXIS_LABEL_TYPE) GETN_ADD_COMBO _update_tick_label_type_list(_tmpSubNode); 
				//GETN_LIST(NumericDisplay, STR_DISPLAY_LABEL, 0, "") GETN_ID(OTID_AXIS_LABEL_NUMERIC) GETN_ADD_COMBO
				//GETN_LIST(MonthDisplay, STR_DISPLAY_LABEL, 0, "") GETN_ID(OTID_AXIS_LABEL_MONTH) GETN_ADD_COMBO
				//GETN_LIST(DayDisplay, STR_DISPLAY_LABEL, 0, "") GETN_ID(OTID_AXIS_LABEL_DAY) GETN_ADD_COMBO
				//GETN_LIST(TimeDisplay, STR_DISPLAY_LABEL, 0, "") GETN_ID(OTID_AXIS_LABEL_TIME) GETN_ADD_COMBO
				//GETN_LIST(DateDisplay, STR_DISPLAY_LABEL, 0, "") GETN_ID(OTID_AXIS_LABEL_DATE) GETN_ADD_COMBO				
				//GETN_STR(TextDisplay, STR_DISPLAY_LABEL, "")	GETN_ID(OTID_AXIS_LABEL_STRING)				
				/////End SUPPORT_TICK_LABEL_FORMAT_TYPE
				//
				///// Iris 9/19/2011 ORG-3819-S2 ADD_MORE_TICK_LABEL_PROPERTIES
				//GETN_BEGIN_BRANCH(Font, STR_FONT_LABEL) GETN_ID(OTID_AXIS_LABEL_FONT)
				//GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
					//GETN_FONT(Face, STR_FONT_LABEL, 0)GETN_ID(OTID_AXIS_LABEL_FONT_FACE)
					//GETN_COMBO(Size, STR_FONT_SIZE_LABEL, 18, "|8|9|10|11|12|14|16|18|20|22|24|26|28|36|48|72") GETN_ID(OTID_AXIS_LABEL_FONT_SIZE)		
					//GETN_CHECK(Bold, STR_FONT_BOLD_LABEL, 0) GETN_ID(OTID_AXIS_LABEL_FONT_BOLD)
				//GETN_END_BRANCH(Font)	
				//
				///// Iris 9/28/2011 ORG-3962-S1 IMPROVE_AXIS_DLG_GUI
				//GETN_BEGIN_BRANCH(Format, STR_FORMAT_LABEL)	
					//GETN_ID(-1) /// Iris 11/10/2011 ORG-3962-P3 FIX_CONTROLS_IN_FORMAT_AND_OFFSET_BRANCH_NOT_WORKED, this branch not existed in theme tree, set id as -1, in order to remove it before apply format
					///// Iris 10/13/2011 ORG-3962-S1 IMPROVE_CUSTOM_DECIMAL_CONTROLS
					////GETN_CHECK(CustomDecimal, STR_CUSTOM_DECIMAL_LABEL, 0)	GETN_ID(OTID_AXIS_LABEL_MANUAL_DEC)
					////GETN_STRLIST(DecimalPlaces, STR_DECIMAL_PLACES_LABEL, "", "|1|2|3|4|5|6") GETN_ID(OTID_AXIS_LABEL_DEC_DIGITS)
					////GETN_CURRENT_SUBNODE.Enable = false; /// Iris 9/29/2011 ORG-3819-S1 IMPROVE_CUSTOM_DECIAL_CONTROL
					///// Iris 11/10/2011 ORG-3962-S2 IMPROVE_CUSTOM_DECIMAL_CONTROL
					////GETN_STRLIST(CustomDecimal, STR_CUSTOM_DECIMAL_LABEL, "", "|1|2|3|4|5|6") GETN_ID(OTID_AXIS_LABEL_MANUAL_DEC) GETN_ADD_LEFT_CHECK(0)
					////GETN_STRLIST(DecimalPlaces, STR_DECIMAL_PLACES_LABEL, "", "|1|2|3|4|5|6") GETN_ID(OTID_AXIS_LABEL_DEC_DIGITS) GETN_CURRENT_SUBNODE.Show = false;
					//GETN_STR(hits, _L("*nn is to specify the number of significant digits, .nn is to specify the number of decimal places \nExample: *2 ( two significant digits), .3 ( three decimal places)"), "") GETN_HINT 
					//GETN_STRLIST(CustomDecimal, STR_CUSTOM_FORMAT_LABEL, E_STR_CUSTOM_DEFAULT_FORMAT, "|*3|*4|.2|.3|.4") GETN_ID(OTID_AXIS_LABEL_MANUAL_DEC) GETN_ADD_LEFT_CHECK(0)
					/////End IMPROVE_CUSTOM_DECIMAL_CONTROL
					/////End IMPROVE_CUSTOM_DECIMAL_CONTROLS
				/////End IMPROVE_AXIS_DLG_GUI
				//
					//GETN_STR(DivideByFactor, STR_DIVIDE_BY_FACTOR_LABEL, "")	GETN_ID(OTID_AXIS_LABEL_DIVIDE_BY_FACTOR)
					//GETN_STR(Prefix, STR_PREFIX_LABEL, "")						GETN_ID(OTID_AXIS_LABEL_PREFIX)
					//GETN_STR(Suffix, STR_SUFFIX_LABEL, "")						GETN_ID(OTID_AXIS_LABEL_SUFFIX)
					/////End ADD_MORE_TICK_LABEL_PROPERTIES
				//GETN_END_BRANCH(Format) ///End IMPROVE_AXIS_DLG_GUI	
				//
				///// Iris 9/28/2011 ORG-3962-S1 IMPROVE_AXIS_DLG_GUI, move to below
				////GETN_COMBO(Angle, STR_ANGLE_LABEL, 0, "|0|45|60|90|180|270") GETN_ID(OTID_AXIS_LABEL_ANGLE)
				/////End IMPROVE_AXIS_DLG_GUI
				//
				//GETN_BEGIN_BRANCH(Offset, STR_OFFSET_LABEL) /// Iris 9/28/2011 ORG-3962-S1 IMPROVE_AXIS_DLG_GUI
					//GETN_ID(-1) /// Iris 11/10/2011 ORG-3962-P3 FIX_CONTROLS_IN_FORMAT_AND_OFFSET_BRANCH_NOT_WORKED, this branch not existed in theme tree, set id as -1, in order to remove it before apply format
					/////Jasmine 09/08/2011 ORG-3747-S1 ADD_POSITION_CONTROL_FOR_TICK_LABELS
					//GETN_NUM(XOffset,	STR_XOFFSET_LABEL, 0) 				GETN_ID(OTID_AXIS_LABEL_XOFFSET)
					//GETN_NUM(YOffset,	STR_YOFFSET_LABEL, 0)	 			GETN_ID(OTID_AXIS_LABEL_YOFFSET)
					/////End ADD_POSITION_CONTROL_FOR_TICK_LABELS	
				//GETN_END_BRANCH(Offset) /// Iris 9/28/2011 ORG-3962-S1 IMPROVE_AXIS_DLG_GUI
				//
				///// Iris 9/28/2011 ORG-3962-S1 IMPROVE_AXIS_DLG_GUI
				///*
				///// Iris 9/20/2011 ORG-3747-S1 ADD_OPPOSITE_CONTROL_FOR_TICK_LABELS
				//GETN_CHECK(Opposite, STR_OPPOSITE_LABEL, 0)				GETN_ID(OTID_AXIS_LABEL_OPPOSITE)
				/////End ADD_OPPOSITE_CONTROL_FOR_TICK_LABELS
				//*/
				//GETN_COMBO(Angle, STR_ANGLE_LABEL, 0, "|0|45|60|90|180|270") GETN_ID(OTID_AXIS_LABEL_ANGLE)
				/////End IMPROVE_AXIS_DLG_GUI
	//
			//GETN_END_BRANCH(MajorLabels)
			//
			//GETN_BEGIN_BRANCH(MinorLabels, STR_MINOR_TICK_LABELS_LABEL) GETN_ID_COLLECTION_MEMBER_REPEAT_BRANCH_EX(OTID_AXIS_LABEL, 2)
			//GETN_OPTION_BRANCH(GETNBRANCH_OPEN)	///Jasmine 09/15/2011 ORG-3297 EXPAND_AXIS_PROPERTY_BRANCH_SUBNODE
				///// Iris 10/12/2011 ORG-3747-S2 COMBINE_TICKLABEL_SHOW_OPPOSITE_AS_ONE_DROPDOWN
				////constructLabelsPropertyNodes(_tmpNode, false);
				//GETN_CHECK(Show, STR_SHOW_LABEL, 0) GETN_ID(OTID_AXIS_LABEL_SHOW)
				/////End COMBINE_TICKLABEL_SHOW_OPPOSITE_AS_ONE_DROPDOWN
			//GETN_END_BRANCH(MinorLabels)		
			//
		//GETN_END_BRANCH(Labels)	
	//}
//}
void AxesControlSplitter::ConstructScaleBranchNodes(TreeNode& trAxis)
{
	GETN_USE(trAxis)
	
	// Scale
	{
		GETN_BEGIN_BRANCH(Scale, STR_SCALE_LABEL) GETN_ID(OTID_AXIS_SCALE) 
			GETN_MARK_STOP_BRANCH /// Iris 7/20/2012 ORG-6270-S1 IMPROVE_TICK_LABELS_BRANCH_SPEED
			GETN_NUM(From, STR_FROM_LABEL, 0) GETN_ID(OTID_AXIS_SCALE_FROM)
			GETN_NUM(To, STR_TO_LABEL, 0) GETN_ID(OTID_AXIS_SCALE_TO)
			GETN_LIST(Type, STR_TYPE_LABEL, 0, "") GETN_ID(OTID_AXIS_SCALE_TYPE) GETN_ADD_COMBO			
			/// Iris 7/11/2012 FIX_ONLY_TWO_SCALE_TYPE_FOR_3DGL_GRAPH
			// only need to remove complex log scale type for Radar plot and keep all for other graph
			//_temp_remove_complex_log_scale_type(_tmpSubNode); /// Iris 11/07/2011 ONLY_KEEP_LINEAR_AND_LOG10_IN_SCALE_TYPE_LIST
			///End FIX_ONLY_TWO_SCALE_TYPE_FOR_3DGL_GRAPH
			
			/// Kenny 10/24/2011 ORG-4114-P2 SPIDER_PLOT_AXES_RESCALE_MODE
			GETN_LIST(Rescale, STR_RESCALE_MODE, AXIS_RESCALE_AUTO, "") GETN_ID(OTID_AXIS_SCALE_RESCALE) GETN_ADD_COMBO
			/// End SPIDER_PLOT_AXES_RESCALE_MODE
			/// Iris 8/18/2011 ORG-3297 IMPROVE_INCREMENT_BY_CONTROLS
			/*
			GETN_LIST(IncrementBy, STR_INCREMENTBY_LABEL, 0, "") GETN_ID(OTID_AXIS_SCALE_INCBY) GETN_ADD_COMBO
			GETN_NUM(Value, STR_VALUE_LABEL, 0) GETN_ID(OTID_AXIS_SCALE_INC_VALUE)
			GETN_NUM(MajorTickCount, STR_MAJOR_TICK_COUNT_LABEL, 0) GETN_ID(OTID_AXIS_SCALE_MAJOR_COUNT)
			*/
			
			/// Iris 6/13/2012 ORG-5991 MOVE_TICKS_AND_LINE_BRANCH_INTO_AXIS_FORMAT_BRANCH
			/*
			if( m_stOptions.bTickSettingsInScale )
			{				
				GETN_RADIO_INDEX_EX(IncrementBy, STR_MAJOR_TICKS_LABEL, 0, _L("By Increment|By # of Majors")) GETN_ID(OTID_AXIS_SCALE_INCBY)
				GETN_NUM(Value, " ", 0) GETN_ID(OTID_AXIS_SCALE_INC_VALUE)
				GETN_NUM(MajorTicksCount, " ", 0) GETN_ID(OTID_AXIS_SCALE_MAJOR_COUNT) _tmpSubNode.Show = false; /// Iris 8/19/2011 COMBINE_INCVALUE_AND_MAJORTICKSCOUNT_AS_ONE_CONTROL
				///End IMPROVE_INCREMENT_BY_CONTROLS
				GETN_NUM(MinorTicksCount, STR_MINOR_TICK_COUNT_LABEL, 1) GETN_ID(OTID_AXIS_SCALE_MINOR_COUNT)					
			}
			*/
			ConstructTickValuesPropertyNodes(trAxis.Scale);
			///End MOVE_TICKS_AND_LINE_BRANCH_INTO_AXIS_FORMAT_BRANCH
		GETN_END_BRANCH(Scale)	
	}
}

/// Iris 6/13/2012 ORG-5991 MOVE_TICKS_AND_LINE_BRANCH_INTO_AXIS_FORMAT_BRANCH
void AxesControlSplitter::ConstructTickValuesPropertyNodes(TreeNode& trScale)
{
	GETN_USE(trScale)
	
	GETN_RADIO_INDEX_EX(IncrementBy, STR_MAJOR_TICKS_LABEL, 0, _L("By Increment|By # of Majors")) GETN_ID(OTID_AXIS_SCALE_INCBY)
	GETN_NUM(Value, " ", 0) GETN_ID(OTID_AXIS_SCALE_INC_VALUE)
	GETN_NUM(MajorTicksCount, " ", 0) GETN_ID(OTID_AXIS_SCALE_MAJOR_COUNT) _tmpSubNode.Show = false; /// Iris 8/19/2011 COMBINE_INCVALUE_AND_MAJORTICKSCOUNT_AS_ONE_CONTROL	
	GETN_NUM(MinorTicksCount, STR_MINOR_TICK_COUNT_LABEL, 1) GETN_ID(OTID_AXIS_SCALE_MINOR_COUNT)						
}
///End MOVE_TICKS_AND_LINE_BRANCH_INTO_AXIS_FORMAT_BRANCH

void AxesControlSplitter::ConstructTicksBranchNodes(TreeNode& trBranch, int nAxis/* = -1*/)
{
	GETN_USE(trBranch)
	
	GETN_BEGIN_BRANCH(Ticks, STR_TICKS_LABEL) GETN_ID_COLLECTION_BRANCH_EX(OTID_AXIS_TICKS)
		GETN_MARK_STOP_BRANCH /// Iris 7/20/2012 ORG-6270-S1 IMPROVE_TICK_LABELS_BRANCH_SPEED
	GETN_END_BRANCH(Ticks)	
	
	ADD_AXIS_SUB_BRANCH(OTID_AXIS_TICK, ConstructTicksMajorMinorBranchNodes(_tmpNode, nAxis))		
}

void AxesControlSplitter::ConstructTicksMajorMinorBranchNodes(TreeNode& trBranch, int nAxis/* = -1*/)
{
	GETN_USE(trBranch)
	
	GETN_BEGIN_BRANCH(MajorTicks, STR_MAJOR_TICKS_LABEL) 
	GETN_OPTION_BRANCH(GETNBRANCH_OPEN)	///Jasmine 09/15/2011 ORG-3297 EXPAND_AXIS_PROPERTY_BRANCH_SUBNODE
	if( -1 == nAxis ) // Iris 5/10/2012: not set DataID for general (2D/3D..) graph since there are not Major/Minor branch in theme tree
		GETN_ID_COLLECTION_MEMBER_REPEAT_BRANCH_EX(OTID_AXIS_TICK, m_nLayerType, GetRepeatIndex(true), nAxis)
	
		ConstructTicksPropertyNodes(_tmpNode, true);
	GETN_END_BRANCH(MajorTicks)
	
	GETN_BEGIN_BRANCH(MinorTicks, STR_MINOR_TICKS_LABEL) 
	/// Iris 6/04/2012 ORG-5528-S4 SET_3DGL_AXES_DLG_DEFAULT_LAYOUT
	if( IsMinorTicskBranchOpen() )
	{
		GETN_OPTION_BRANCH(GETNBRANCH_OPEN)	///Jasmine 09/15/2011 ORG-3297 EXPAND_AXIS_PROPERTY_BRANCH_SUBNODE
	}
	///End SET_3DGL_AXES_DLG_DEFAULT_LAYOUT
	if( -1 == nAxis ) // Iris 5/10/2012: not set DataID for general (2D/3D..) graph since there are not Major/Minor branch in theme tree
		GETN_ID_COLLECTION_MEMBER_REPEAT_BRANCH_EX(OTID_AXIS_TICK, m_nLayerType, GetRepeatIndex(false), nAxis)
	
		ConstructTicksPropertyNodes(_tmpNode, false);
	GETN_END_BRANCH(MinorTicks)		
}

int AxesControlSplitter::GetSubAxisIndex(TreeNode& trEditNode, int* pnBaseID)
{	
	//TreeNode trCollBranch = trEditNode.Parent(); // trCollBranch should be BottomLabels/TopLabels...
	TreeNode trCollBranch = trEditNode;
	while( trCollBranch )
	{
		if( trCollBranch.DataID > 0 && IS_THEME_COLL_MEMBER(trCollBranch.DataID) )
			break;
		trCollBranch = trCollBranch.Parent();
	}
	
	if( trCollBranch )
	{
		if( NULL != pnBaseID )
		{
			*pnBaseID = _get_base_id( trCollBranch.DataID );		
		}
		
		/// Iris 8/06/2012 ORG-6463-S1 ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
		if( IsShowPrimaryAxesOnly() )		
		{
			int nAxis = GetAxisIndex(trEditNode);
			return GetPrimarySecondaryAxisIndex(nAxis, true);
		}
		///End ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
	
		WORD wdHi = HIWORD((DWORD)trCollBranch.DataID);
		int nLTSubAxis = wdHi & 0x0F;
		return (nLTSubAxis - 1);
	}
}

/// Iris 7/13/2012 ORG-5991-P9 FIX_PROPERTY_IN_YAXIS_NOT_BE_CHANGED_WHEN_APPLY_CHANGES_WITH_SELECT_OTHERS
enum
{
	SUB_AXIS_TOP_BRANCH = 0,
	SUB_AXIS_BOTTOM_BRANCH
};

int			AxesControlSplitter::GetSubAxisBranchOrder(TreeNode& trEditNode)
{
	int nAxis = GetAxisIndex(trEditNode);
	int nSubAxis = GetSubAxisIndex(trEditNode);
	
	if( AXIS_Y != nAxis )
	{
		return 0 == nSubAxis ? SUB_AXIS_TOP_BRANCH : SUB_AXIS_BOTTOM_BRANCH;
	}
	else
	{
		bool bExchangeForY = IsExchangeYAxisSubAxis(); // default show Right axis (second axis) for 3D gl as top branch
		if( 1 == nSubAxis ) 
			return bExchangeForY ? SUB_AXIS_TOP_BRANCH : SUB_AXIS_BOTTOM_BRANCH;
		else 
			return bExchangeForY ? SUB_AXIS_BOTTOM_BRANCH : SUB_AXIS_TOP_BRANCH;
	}	
}
///End FIX_PROPERTY_IN_YAXIS_NOT_BE_CHANGED_WHEN_APPLY_CHANGES_WITH_SELECT_OTHERS

/// Iris 8/01/2012 ORG-6371-S1 ADD_USE_SAME_OPTIONS_FOR_BOTH_ON_EACH_AXIS_ROOT_NODE
bool		AxesControlSplitter::AddUseSameOptionsForBoth(TreeNode& trParent, int nAxis)
{
	if( !trParent )
		return false;
	
	TreeNode trSame = trParent.AddNode("SameForBoth", TRGP_CHECK);
	/// Iris 6/21/2012 ORG-5991-S3 SET_SAME_OPTIONS_FOR_BOTTOM_AND_TOP_AS_DEFAULT_CHECKED
	//trSame.nVal = 0; // default unchecked
	/// Iris 7/27/2012 ORG-6371 SET_SAME_OPTIONS_FOR_BOTTOM_AND_TOP_AS_DEFAULT_UNCHECKED
	//trSame.nVal = 1; // default checked, suggestion from Greg
	trSame.nVal = USE_SAME_OPTIONS_FOR_BOTH_DEFAULT_VAL; // default unchecked, suggestion from Show/Easwar/Greg
	///End SET_SAME_OPTIONS_FOR_BOTTOM_AND_TOP_AS_DEFAULT_UNCHECKED
	///End SET_SAME_OPTIONS_FOR_BOTTOM_AND_TOP_AS_DEFAULT_CHECKED
	
	/// Iris 8/02/2012 ORG-5991-S6 CHANGE_SUB_AXIS_LABEL_FOR_3DGL_GRAPH
	/*
	string strSubAxisLabels = getAxisSubBranchName(nAxis);	
	int nSubAxisFirst = 0, nSubAxisSecond = 1;
	if( AXIS_Y == nAxis && IsExchangeYAxisSubAxis() )
	{
		nSubAxisFirst = 1;
		nSubAxisSecond = 0;
	}	
	*/
	string strSubAxisLabels = GetAxisSubBranchLabel(nAxis);
	int nSubAxisFirst = 0, nSubAxisSecond = 1;
	///End CHANGE_SUB_AXIS_LABEL_FOR_3DGL_GRAPH
	
	string strLabel;
	strLabel.Format(STR_SAME_OPTIONS_FOR_BOTH, strSubAxisLabels.GetToken(nSubAxisFirst, '|'), strSubAxisLabels.GetToken(nSubAxisSecond, '|'));
	trSame.SetAttribute(STR_LABEL_ATTRIB, strLabel);
	trSame.DataID = ID_SAME_FOR_BOTTOM_AND_TOP;	
	
	return true;
}

void 	AxesControlSplitter::CheckSetBranchEnableStatusOnUseSameOptionsForBoth(int nAxis, TreeNode& trGetNAxis, TreeNode& trEditNodeBranch, bool bIsCheck)
{
	ASSERT( trGetNAxis && trEditNodeBranch );
	
	if( _is_axis_branch_node(trEditNodeBranch) ) // if the checkbox directly under Axis branch, need to apply check/unchecked status to all other use same options checkbox in sub property branch
	{
		int nSubAxis = 0;
		foreach(TreeNode trPropertyBranch in trGetNAxis.Children)
		{			
			if( trPropertyBranch.GetNodeCount() > 0 )
			{
				// In list tree, copy the check/uncheck status to the Use Same Options checkbox in sub property branch
				TreeNode trUseSameOptions = _get_GetN_node_by_id(trPropertyBranch, ID_SAME_FOR_BOTTOM_AND_TOP);
				if( trUseSameOptions )
				{
					trUseSameOptions.nVal = bIsCheck;								
					SetSecondaryAxisBranchEnableStatusWithIfUseSameOptionsForBoth(nAxis, trGetNAxis, trPropertyBranch, false);
				}
				
				// In current GetN tree, copy the check/uncheck status to the Use Same Options checkbox in sub property branch
				// since we will copy all nodes from GetN tree to list tree in updateChangeFromGetNTreeToListTree
				//TreeNode trSubInEditTree = trEditNodeBranch.GetNode(trPropertyBranch.tagName);
				//trUseSameOptions = _get_GetN_node_by_id(trSubInEditTree, ID_SAME_FOR_BOTTOM_AND_TOP);
				//if( trSubInEditTree && trUseSameOptions )
				//{
					//trUseSameOptions.nVal = bIsCheck;
					//SetSecondaryAxisBranchEnableStatusWithIfUseSameOptionsForBoth(trGetNAxis, trSubInEditTree, false);
				//}
			}
			else if( ID_SAME_FOR_BOTTOM_AND_TOP == trPropertyBranch.DataID )
			{
				trPropertyBranch.nVal = bIsCheck;
			}
			else if( trPropertyBranch.ID == ONODETYPE_SEPARATOR )
			{
				TreeNode trFirstShow = trPropertyBranch.NextNode;
				if( trFirstShow && ( ID_SHOW_PRIMARY_AXIS == trFirstShow.DataID || ID_SHOW_SECONDARY_AXIS == trFirstShow.DataID ) )
				{
					TreeNode trSecondShow = trFirstShow.NextNode;
					if( trSecondShow && ( ID_SHOW_PRIMARY_AXIS == trFirstShow.DataID || ID_SHOW_SECONDARY_AXIS == trFirstShow.DataID ) )
					{
						trSecondShow.Enable = !bIsCheck;
						
						TreeNode trGetNNode = trEditNodeBranch.GetNode(trSecondShow.tagName);
						ASSERT(trGetNNode);
						if( trGetNNode )
							trGetNNode.Enable = !bIsCheck;
					}
				}
			}
		}
	}
	else
	{				
		TreeNode trEditBranchInOneAxis = _get_GetN_node_by_id(trGetNAxis, trEditNodeBranch.DataID, true);
		SetSecondaryAxisBranchEnableStatusWithIfUseSameOptionsForBoth(nAxis, trGetNAxis, trEditBranchInOneAxis, true);
				
		SetSecondaryAxisBranchEnableStatusWithIfUseSameOptionsForBoth(nAxis, trGetNAxis, trEditNodeBranch, false, true);		
	}	
}

// to set the secondary axis display as display if use same options is checked, else display as enable. 
void 	AxesControlSplitter::SetSecondaryAxisBranchEnableStatusWithIfUseSameOptionsForBoth(int nAxis, TreeNode& trGetNAxis, TreeNode& trPropertyBranch, bool bCheckUpdateAxisBranch, bool bOnlyCheckLeafNode)
{	
	if( !trPropertyBranch )
		return;
	
	TreeNode trUseSameOptions = _get_GetN_node_by_id(trPropertyBranch, ID_SAME_FOR_BOTTOM_AND_TOP);
	if( !trUseSameOptions )
		return;
		
	int nCollIndex = 0, nPrimarySecondarShowIndex = 0;								
	foreach(TreeNode trSub in trPropertyBranch.Children)
	{	
		const bool bEnable = 0 == trUseSameOptions.nVal;
		
		if( trSub.GetNodeCount() > 0 && !bOnlyCheckLeafNode )
		{
			if( 0 == nCollIndex )
			{
				nCollIndex++;								
			}
			else
			{	
				/// Iris 9/20/2012 ORG-6892-P1 IMPROVE_DISABLE_SUB_AXIS_BRANCH_CODES
				//_set_enable_attribute(trSub, bEnable, false);				
				int nVal;
				if( bEnable && trSub.GetAttribute(STR_DISABLE_BY_SHOW_ATTRIB, nVal) )
				{				
					if( trSub.GetAttribute(STR_DISABLE_BY_USE_SAME_OPTIONS_ATTRIB, nVal) )
						trSub.RemoveAttribute(STR_DISABLE_BY_USE_SAME_OPTIONS_ATTRIB);					
				}
				else
				{
					_set_enable_attribute(trSub, bEnable, false);
					
					if( !bEnable )
						trSub.SetAttribute(STR_DISABLE_BY_USE_SAME_OPTIONS_ATTRIB, 1);
					else
						trSub.RemoveAttribute(STR_DISABLE_BY_USE_SAME_OPTIONS_ATTRIB);
				}	
				///End IMPROVE_DISABLE_SUB_AXIS_BRANCH_CODES
			}
		}
		else if( trSub.ID == ONODETYPE_SEPARATOR )
		{			
			TreeNode trFirstShow = trSub.NextNode;
			if( trFirstShow )
			{
				/* the order is:
				bottom major
				bottom minor (optional)
				top major
				top minor (optional)
				*/
				
				int nNextNodeID = trFirstShow.NextNode.DataID;
				if( nNextNodeID == ID_PRIMARY_MINOR_SHOW || nNextNodeID == ID_SECONDARY_MINOR_SHOW ) // if has minor show checkbox
				{
					TreeNode trFirstMinorShow = trFirstShow.NextNode;
					trFirstMinorShow.Enable = trFirstShow.nVal;
					
					TreeNode trSecondShow = trFirstMinorShow.NextNode;
					if( trSecondShow )
						trSecondShow.Enable = bEnable;
					if( trSecondShow.NextNode ) // minor
						trSecondShow.NextNode.Enable = bEnable && trSecondShow.nVal;
				}
				else
				{
					trFirstShow.NextNode.Enable = bEnable;
				}
			}
		}
	}
	
	// set the Use Same Options under Axis branch as undefined if the status of Use Same Option under property branch is not consistent.
	if( bCheckUpdateAxisBranch )
	{	
		CheckSetAxisBranchUseSameOptionCheckStatus(trGetNAxis);
	}
}

void 	AxesControlSplitter::CheckSetAxisBranchUseSameOptionCheckStatus(TreeNode& trGetNAxis)
{
	int nCheck = -1;
	TreeNode trAxisBranchUseSameOptions = _get_GetN_node_by_id(trGetNAxis, ID_SAME_FOR_BOTTOM_AND_TOP, false);
	if( trAxisBranchUseSameOptions )
	{
		foreach(TreeNode trPropertyBranch in trGetNAxis.Children)
		{							
			TreeNode trPropertyBranchUseSameOptions = _get_GetN_node_by_id(trPropertyBranch, ID_SAME_FOR_BOTTOM_AND_TOP, false);
			if( trPropertyBranchUseSameOptions )
			{
				trAxisBranchUseSameOptions.RemoveAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED);
				if( -1 == nCheck )
				{
					nCheck = trPropertyBranchUseSameOptions.nVal;
				}
				else if( nCheck != trPropertyBranchUseSameOptions.nVal )
				{
					trAxisBranchUseSameOptions.SetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, 1);
					return;
				}
			}							
		}
		//---- Iris 9/24/2012 to fix when checked all Use Same Options for Bottom and Top in sub axis branch, but the status of the checkbox in axis branch still is unchecked.
		trAxisBranchUseSameOptions.nVal = nCheck;
		//----
	}	
}
///End ADD_USE_SAME_OPTIONS_FOR_BOTH_ON_EACH_AXIS_ROOT_NODE

TreeNode 	AxesControlSplitter::AddAxisSubBranchNode(TreeNode& trParent, int nBaseID, int nAxis/* = -1*/, int nSub/* = 0*/, string* pstrSubAxisName/* = NULL*/)
{	
	TreeNode trSubBranch;
	/// Iris 8/02/2012 ORG-5991-S6 CHANGE_SUB_AXIS_LABEL_FOR_3DGL_GRAPH
	/*
	string strSubAxisNames = getAxisSubBranchName(nAxis);
	if( strSubAxisNames.IsEmpty() )
		return trSubBranch;
	
	int nSubBranchCount = strSubAxisNames.GetNumTokens('|');
	if( 0 == nSubBranchCount )
		return trSubBranch;
	
	string strOneSubAxisName = strSubAxisNames.GetToken(nSub, '|');
	*/
	string strOneSubAxisName = getAxisSubBranchName(nAxis, nSub);
	string strOneSubAxisLabel = GetAxisSubBranchLabel(nAxis, nSub);
	///End CHANGE_SUB_AXIS_LABEL_FOR_3DGL_GRAPH
	if( strOneSubAxisName.IsEmpty() || strOneSubAxisLabel.IsEmpty() )
		return trSubBranch;	
	
	// add a checkbox to set the same for both sub axis 
	if( 0 == nSub )
	{	
		/// Iris 8/01/2012 ORG-6371-S1 ADD_USE_SAME_OPTIONS_FOR_BOTH_ON_EACH_AXIS_ROOT_NODE
		/*
		TreeNode trSame = trParent.AddNode("SameForBoth", TRGP_CHECK);
		/// Iris 6/21/2012 ORG-5991-S3 SET_SAME_OPTIONS_FOR_BOTTOM_AND_TOP_AS_DEFAULT_CHECKED
		//trSame.nVal = 0; // default unchecked
		/// Iris 7/27/2012 ORG-6371 SET_SAME_OPTIONS_FOR_BOTTOM_AND_TOP_AS_DEFAULT_UNCHECKED
		//trSame.nVal = 1; // default checked, suggestion from Greg
		trSame.nVal = 0; // default unchecked, suggestion from Show/Easwar/Greg
		///End SET_SAME_OPTIONS_FOR_BOTTOM_AND_TOP_AS_DEFAULT_UNCHECKED
		///End SET_SAME_OPTIONS_FOR_BOTTOM_AND_TOP_AS_DEFAULT_CHECKED
		
		string strLabel;
		strLabel.Format(STR_SAME_OPTIONS_FOR_BOTH, strOneSubAxisLabel, strSubAxisNames.GetToken(nSub + 1, '|'));
		trSame.SetAttribute(STR_LABEL_ATTRIB, strLabel);
		trSame.DataID = ID_SAME_FOR_BOTTOM_AND_TOP;
		*/
		AddUseSameOptionsForBoth(trParent, nAxis);
		///End ADD_USE_SAME_OPTIONS_FOR_BOTH_ON_EACH_AXIS_ROOT_NODE
	}
	
	trSubBranch = trParent.AddNode(strOneSubAxisName, TRGP_BRANCH);
	trSubBranch.SetAttribute(STR_ATTRIB_BRANCH, GETNBRANCH_OPEN);
	//trSubBranch.SetAttribute(STR_LABEL_ATTRIB, strOneSubAxisLabel + " " + _L("Axis"));
	trSubBranch.SetAttribute(STR_LABEL_ATTRIB, strOneSubAxisLabel);
	_set_collection_member_branch_id_with_repeat_id(trSubBranch, nBaseID, m_nLayerType, GetRepeatIndex(nSub, nAxis), nAxis);			
	
	
	if( NULL != pstrSubAxisName )
		*pstrSubAxisName = strOneSubAxisName;
	
	return trSubBranch;
}	

void AxesControlSplitter::ConstructLineBranchNodes(TreeNode& trBranch, int nAxis/* = -1*/)
{
	GETN_USE(trBranch)
	
	GETN_BEGIN_BRANCH(Line, STR_LINE_LABEL) GETN_ID(OTID_AXIS_LINE)	GETN_OPTION_BRANCH(GETNBRANCH_OPEN)	
		GETN_MARK_STOP_BRANCH /// Iris 7/20/2012 ORG-6270-S1 IMPROVE_TICK_LABELS_BRANCH_SPEED
	GETN_END_BRANCH(Line)		

	ADD_AXIS_SUB_BRANCH(OTID_AXIS_TICK, ConstructLinePropertyNodes(_tmpNode, nAxis))	
}

void AxesControlSplitter::ConstructLinePropertyNodes(TreeNode& trBranch, int nAxis/* = -1*/)
{
	GETN_USE(trBranch) GETN_OPTION_BRANCH(GETNBRANCH_OPEN)	
	
	GETN_CHECK(Show, STR_SHOW_LABEL, 1) GETN_ID(OTID_AXIS_TICK_SHOW)
	GETN_COLOR(Color, STR_COLOR_LABEL, 0) GETN_ID(OTID_AXIS_TICK_COLOR) GETN_COLOR_CHOICE_OPTIONS(COLORLIST_SINGLE|COLORLIST_CUSTOM)
	vector vWidths = {0.2, 0.5, 1, 1.5, 2, 3, 4, 5};
	GETN_COMBO(Width, STR_THICKNESS_LABEL, 1.0, construct_double_combo_list(vWidths, "*2*", true)) GETN_ID(OTID_AXIS_TICK_WIDTH)	
		
	/// Iris 6/13/2012 ORG-5991 MOVE_TICKS_AND_LINE_BRANCH_INTO_AXIS_FORMAT_BRANCH
	//if( m_stOptions.bIncAxisPosition )
	//{				
		//string strOneSubAxisName = trBranch.tagName;
		//string strList;
		//strList = strOneSubAxisName;
		//strList += "|" + STR_AXIS_PER_POSITION_LABEL + " " + strOneSubAxisName;
		//strList += "|" + STR_AXIS_AT_POSITION_LABEL;
		//GETN_LIST(Position, STR_AXIS_POSITION_LABEL, 0, strList) GETN_ID(OTID_AXIS_TICK_POSITION)		
		//GETN_NUM(Offset, STR_OFFSET_LABEL, 0) GETN_ID(OTID_AXIS_TICK_OFFSET) GETN_OPTION_NUM_FORMAT("*")	
	//}		
	///End MOVE_TICKS_AND_LINE_BRANCH_INTO_AXIS_FORMAT_BRANCH
}

void AxesControlSplitter::ConstructTitleBranchNodes(TreeNode& trBranch, int nAxis/* = -1*/)
{
	GETN_USE(trBranch)
	
	GETN_BEGIN_BRANCH(Titles, STR_TITLE_LABEL) 	
		if( -1 == nAxis )
		{
			GETN_ID(OTID_AXIS_TITLE)
		}
		else
		{
			GETN_ID_COLLECTION_BRANCH_EX(OTID_AXIS_TITLES)
		}
		GETN_MARK_STOP_BRANCH /// Iris 7/20/2012 ORG-6270-S1 IMPROVE_TICK_LABELS_BRANCH_SPEED
	GETN_END_BRANCH(Titles)	
	
	ADD_AXIS_SUB_BRANCH(OTID_AXIS_TITLE, ConstructTitlePropertyNodes(_tmpNode, nAxis))
}
			
void AxesControlSplitter::ConstructTitlePropertyNodes(TreeNode& trBranch, int nAxis/* = -1*/)
{		
	GETN_USE(trBranch)
	
	if( m_stOptions.bIncTitleShow )
	{
		GETN_CHECK(Show, STR_SHOW_LABEL, 1) GETN_ID(OTID_LABEL_SHOW)
	}
	if( m_stOptions.bIncTitleText )
	{
		GETN_STR(Text, STR_TEXT_LABEL, "") GETN_ID(OTID_LABEL_TEXT)
	}
	
	GETN_COLOR(Color, STR_COLOR_LABEL, 0) GETN_ID(OTID_LABEL_COLOR) GETN_COLOR_CHOICE_OPTIONS(COLORLIST_SINGLE|COLORLIST_CUSTOM|COLORLIST_AUTO)
	GETN_COMBO(Angle, STR_ANGLE_LABEL, 0, "|0|45|90|180|270") GETN_ID(OTID_LABEL_ANGLE)
	
	GETN_BEGIN_BRANCH(Font, STR_FONT_LABEL) GETN_ID(OTID_LABEL_FONT)
	GETN_OPTION_BRANCH(GETNBRANCH_OPEN)	///Jasmine 09/15/2011 ORG-3297 EXPAND_AXIS_PROPERTY_BRANCH_SUBNODE
		GETN_FONT(Face, STR_FONT_LABEL, 0 )GETN_ID(OTID_LABEL_FONT_FACE)
		GETN_COMBO(Size, STR_FONT_SIZE_LABEL, 26, "|8|9|10|11|12|14|16|18|20|22|24|26|28|36|48|72") GETN_ID(OTID_LABEL_FONT_SIZE)		
	GETN_END_BRANCH(Font)				
	
	GETN_BEGIN_BRANCH(Dimension, STR_POSITION_LABEL) GETN_ID(OTID_LABEL_DIMENSION)	
	/// Iris 6/04/2012 ORG-5528-S4 SET_3DGL_AXES_DLG_DEFAULT_LAYOUT
	if( IsTitlePositionBranchOpen() )
	{
		GETN_OPTION_BRANCH(GETNBRANCH_OPEN)	///Jasmine 09/15/2011 ORG-3297 EXPAND_AXIS_PROPERTY_BRANCH_SUBNODE
	}
	///End SET_3DGL_AXES_DLG_DEFAULT_LAYOUT
		GETN_NUM(XOffset, STR_XOFFSET_LABEL, 0) GETN_ID(OTID_AXIS_TITLE_DIMENSION_XOFFSET)
		GETN_NUM(YOffset, STR_YOFFSET_LABEL, 0) GETN_ID(OTID_AXIS_TITLE_DIMENSION_YOFFSET)
	GETN_END_BRANCH(Dimension)		
}
	
void AxesControlSplitter::ConstructGridsBranchNodes(TreeNode& trBranch, int nAxis)
{
	GETN_USE(trBranch)
	
	// Grids	
	GETN_BEGIN_BRANCH(Grids, STR_GRIDS_LABEL) GETN_ID_COLLECTION_BRANCH_EX(OTID_AXIS_GRIDS)
		GETN_MARK_STOP_BRANCH /// Iris 7/20/2012 ORG-6270-S1 IMPROVE_TICK_LABELS_BRANCH_SPEED
	
		bool bMajor = true;
		GETN_BEGIN_BRANCH(MajorGrids, STR_MAJOR_GRIDS_LABEL) GETN_ID_COLLECTION_MEMBER_REPEAT_BRANCH_EX(OTID_AXIS_GRID, m_nLayerType, GetRepeatIndex(bMajor, nAxis), nAxis) 		
		GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
			ConstructGridPropertyNodes(_tmpNode, bMajor);
		GETN_END_BRANCH(MajorGrids)
		
		bMajor = false;
		GETN_BEGIN_BRANCH(MinorGrids, STR_MINOR_GRIDS_LABEL) GETN_ID_COLLECTION_MEMBER_REPEAT_BRANCH_EX(OTID_AXIS_GRID, m_nLayerType, GetRepeatIndex(bMajor, nAxis), nAxis)
		GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
			ConstructGridPropertyNodes(_tmpNode, bMajor);
		GETN_END_BRANCH(MinorGrids)	
		
		
		if( m_stOptions.bIncAdditionalLines )
		{
			GETN_BEGIN_BRANCH(Additional, STR_ADDITIONAL_LINES_LABEL) GETN_ID(OTID_AXIS_ADDITIONAL) 		
			GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
				GETN_CHECK(Opposite, STR_OPPOSITE_LABEL, 0) GETN_ID(OTID_AXIS_ADDITIONAL_OPPOSITE_LINE)
				
				GETN_CHECK(ZeroLine, "", 0) GETN_ID(OTID_AXIS_ADDITIONAL_ZERO_LINE)	
				string strAxisLabel, strLabel;
				trBranch.GetAttribute(STR_LABEL_ATTRIB, strAxisLabel);								
				strLabel.Format("%s = 0", strAxisLabel.GetToken(0));
				_tmpSubNode.SetAttribute(STR_LABEL_ATTRIB, strLabel);	
		
			GETN_END_BRANCH(Additional)
		}
		
	GETN_END_BRANCH(Grids)		
}

///End AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH

void AxesControlSplitter::ConstructGridPropertyNodes(TreeNode& trGridBranch, bool bMajor)
{
	GETN_USE(trGridBranch) 
	
	GETN_CHECK(Show, STR_SHOW_LABEL, bMajor ? 1 : 0) GETN_ID(OTID_AXIS_GRID_SHOW)
	GETN_COLOR(Color, STR_COLOR_LABEL, bMajor ? SYSCOLOR_GRAY : SYSCOLOR_LTGRAY) GETN_ID(OTID_AXIS_GRID_COLOR)
	GETN_LIST(Style, STR_STYLE_LABEL, bMajor ? 0 : 1, "") GETN_ID(OTID_AXIS_GRID_STYLE) GETN_ADD_COMBO
	
	vector vWidths = {0.5, 1, 1.5, 2, 3, 4, 5};
	GETN_COMBO(Width, STR_THICKNESS_LABEL, bMajor ? 0.5 : 0.3, construct_double_combo_list(vWidths, "*2*", true)) GETN_ID(OTID_AXIS_GRID_WIDTH)
}

// virtual
void AxesControlSplitter::ConstructTicksPropertyNodes(TreeNode& trBranch, bool bMajor)
{
	GETN_USE(trBranch)		
				
	GETN_LIST(Type, STR_TYPE_LABEL, 0, "") GETN_ID(OTID_AXIS_TICK_TYPE) GETN_ADD_COMBO
		
	vector vLengths = {3, 5, 8, 10, 15};
	GETN_COMBO(Length, STR_LENGTH_LABEL, 0, construct_double_combo_list(vLengths, "*", true)) GETN_ID(OTID_AXIS_TICK_LENGTH)	
}

/// Iris 9/28/2011 ORG-3747-S2 COMBINE_TICKLABEL_SHOW_OPPOSITE_AS_ONE_DROPDOWN
/*
void AxesControlSplitter::constructLabelsPropertyNodes(TreeNode& trBranch, bool bMajor)
{
	GETN_USE(trBranch)

	///Jasmine 09/13/2011 ORG-3297 USER_MAY_SHOW_OTHER_AXIS
	///// Iris 8/18/2011 ORG-3297 SUPPORT_MORE_CHOICE_FOR_TICKLABEL_SHOW
	//if( !m_bForAll )
	//{
		//GETN_CHECK(Show, STR_SHOW_LABEL, 0) GETN_ID(OTID_AXIS_LABEL_SHOW)
	//}
	//else
	//{
		//GETN_LIST(Show, STR_SHOW_LABEL, bMajor? 1 : 0, _L("None|First Axis Only|All Axes")) GETN_ID(OTID_AXIS_LABEL_SHOW)
	//}
	/////End SUPPORT_MORE_CHOICE_FOR_TICKLABEL_SHOW
	GETN_CHECK(Show, STR_SHOW_LABEL, 0) GETN_ID(OTID_AXIS_LABEL_SHOW)
	///End USER_MAY_SHOW_OTHER_AXIS
	
	//GETN_COMBO(Size, STR_FONT_SIZE_LABEL, 18, "|8|9|10|11|12|14|16|18|20|22|24|28|36|48|72") GETN_ID(OTID_AXIS_LABEL_FONT_SIZE)
	//GETN_CHECK(Bold, STR_FONT_BOLD_LABEL, 0) GETN_ID(OTID_AXIS_LABEL_FONT_BOLD)
	//GETN_CHECK(Italic, STR_FONT_ITALIC_LABEL, 0) GETN_ID(OTID_AXIS_LABEL_FONT_ITALIC)
	//GETN_CHECK(Underline, STR_FONT_UNDERLINE_LABEL, 0) GETN_ID(OTID_AXIS_LABEL_FONT_UNDERLINE)
}
*/
///End COMBINE_TICKLABEL_SHOW_OPPOSITE_AS_ONE_DROPDOWN

BOOL AxesControlSplitter::OnInitSplitter()
{
	TreeDynaSplitter::OnInitSplitter(&m_AxesGridTree);
	m_AxesGridTree.Init();	
	
	m_gl = Project.ActiveLayer();
	if( !m_gl )
		return FALSE;

	SetReady();///Jasmine 09/13/2011 ORG-3297 SELECT_RELATIVE_NODES_TO_APPLY_SETTINGS_TO_MULTIP_AXES	
	updateAxesTree(true);
	
	//SetReady();///Jasmine 09/13/2011 ORG-3297 SELECT_RELATIVE_NODES_TO_APPLY_SETTINGS_TO_MULTIP_AXES	
	return true;
}

/// Iris 7/19/2012 ORG-5991-P13 SAVE_SAME_OPTIONS_TO_GRAPH_NOT_REGISTRY
/*
/// Iris 6/07/2012 ORG-5528-P10 SAVE_SAME_OPTIONS_FOR_BOTH_DIRECTIONS_TO_REGISTRY
string AxesControlSplitter::CheckGetIsUseSameOptionsForBothDirectionsSettings()
{
	string strSettings; // format is ID1=nChecked,ID2=unchecked...
	
	for(int nAxis = 0; nAxis < m_nNumAxes; ++nAxis)
	{
		TreeNode trAxis = GetGetNAxisNode(nAxis);
		if( trAxis )
		{
			strSettings += "{";
			foreach(TreeNode trPropertyBranch in trAxis.Children)
			{
				TreeNode trSameOptions = _get_GetN_node_by_id(trPropertyBranch, ID_SAME_FOR_BOTTOM_AND_TOP, true);
				if( trSameOptions )
				{
					string str;
					str.Format("%d=%d", trPropertyBranch.DataID, trSameOptions.nVal);
					strSettings += str + ",";
				}
			}
			strSettings.TrimRight(',');
			strSettings += "},";
		}
	}	
	
	strSettings.TrimRight(',');
	return strSettings;	
}
*/
///End SAVE_SAME_OPTIONS_TO_GRAPH_NOT_REGISTRY

void AxesControlSplitter::applyIsUseSameOptionsForBothDirectionsSettings()
{
	/// Iris 7/19/2012 ORG-5991-P13 SAVE_SAME_OPTIONS_TO_GRAPH_NOT_REGISTRY
	string strSameOptionsForBothSettings;
	GraphPage gp = m_gl.GetPage();
	Tree tr;
	if( gp.GetBinaryStorage(STR_AXES_DLG_SETTINGS, tr) )		
	{
		TreeNode trUseSameOptions = tr.GetNode(STR_USE_SAME_OPTIOINS);
		if( trUseSameOptions && !trUseSameOptions.IsEmpty() )
		{				
			strSameOptionsForBothSettings = trUseSameOptions.strVal;
		}
	}	
	///End SAVE_SAME_OPTIONS_TO_GRAPH_NOT_REGISTRY
	
	if( strSameOptionsForBothSettings.IsEmpty() )
		return;	
		
	const char chAxisBegin = '{';
	const char chAxisEnd = '}';	
	int	nAxisBeginPos = strSameOptionsForBothSettings.Find(chAxisBegin);
	int nAxisEndPos = strSameOptionsForBothSettings.Find(chAxisEnd);	
	
	int nAxis = 0;
	while( nAxisBeginPos >= 0 && nAxisBeginPos < strSameOptionsForBothSettings.GetLength() && nAxisEndPos >= 0 && nAxisEndPos < strSameOptionsForBothSettings.GetLength() )
	{
		TreeNode trAxis = GetGetNAxisNode(nAxis);
		ASSERT(trAxis);
		if( !trAxis )
			continue;
		
		nAxisBeginPos++; // begin from the char after - '{'
		nAxisEndPos--; // end to the char before - '}'
		string strOneAxisSettings;		
		strOneAxisSettings = strSameOptionsForBothSettings.Mid(nAxisBeginPos, nAxisEndPos - nAxisBeginPos + 1);
		
		// to find the related nocdes and apply settings
		vector<string> vsOneAxisSettings;
		strOneAxisSettings.GetTokens(vsOneAxisSettings, ',');
		for(int nn = 0; nn < vsOneAxisSettings.GetSize(); ++nn)
		{
			int nBranchID, nCheck;
			if( 2 == sscanf(vsOneAxisSettings[nn], "%d=%d", &nBranchID, &nCheck) )
			{				
				///// Iris 8/01/2012 ORG-6371-S1 ADD_USE_SAME_OPTIONS_FOR_BOTH_ON_EACH_AXIS_ROOT_NODE					 
				//if( trAxis.DataID == nBranchID )
				//{
					//if( trAxis.SameForBoth )
						//trAxis.SameForBoth.nVal = nCheck;						
				//}
				//else
				//{
				/////End ADD_USE_SAME_OPTIONS_FOR_BOTH_ON_EACH_AXIS_ROOT_NODE
					//TreeNode trPropertyBranch = _get_GetN_node_by_id(trAxis, nBranchID, false);										
					//ASSERT(trPropertyBranch);
					//if( trPropertyBranch )
					//{
						//int nStatus = -1; // -1 for none, 0 for unchecked, 1 for checked 
						//int nSubBranchIndex = 0;
						//foreach(TreeNode trSubBranch in trPropertyBranch.Children)
						//{
							//if( trSubBranch.DataID == ID_SAME_FOR_BOTTOM_AND_TOP )								
							//{
								//trSubBranch.nVal = nStatus = nCheck;								
							//}							
							//else if( trSubBranch.GetNodeCount() > 0 ) // only setup Enable/Disable for sub axis branch (ex. Bottom and Top branch) 
							//{		
								///// Iris 7/20/2012 ORG-6270-S1 IMPROVE_TICK_LABELS_BRANCH_SPEED
								///*
								//if(0 != nSubBranchIndex && -1 != nStatus)
									//{									
										//trSubBranch.Enable = (0 == nStatus);									
									//}
								//*/
								//if(0 != nSubBranchIndex) // set the secondary axis branch as disable if checked
								//{																	
									//_set_enable_attribute(trSubBranch, 0 == nCheck, false);
								//}
								/////End IMPROVE_TICK_LABELS_BRANCH_SPEED
								//nSubBranchIndex++;
							//}
						//}
					//}
				//}	
				TreeNode trParent = trAxis.DataID == nBranchID ? trAxis : _get_GetN_node_by_id(trAxis, nBranchID, true);				
				ASSERT( trParent );
				if( trParent )
				{
					/// Iris 9/24/2012 ORG-6463-P8 FIX_NOT_REMEMBERED_USE_SAME_FOR_BOTH_CHECK_STATUS_IN_SUB_AXIS_BRANCH
					TreeNode trSameOptions = _get_GetN_node_by_id(trParent, ID_SAME_FOR_BOTTOM_AND_TOP, true);
					ASSERT( trSameOptions );
					if( trSameOptions )
					{
						trSameOptions.nVal = nCheck;
					}	
					///End FIX_NOT_REMEMBERED_USE_SAME_FOR_BOTH_CHECK_STATUS_IN_SUB_AXIS_BRANCH
					
					CheckSetBranchEnableStatusOnUseSameOptionsForBoth(nAxis, trAxis, trParent, nCheck);								
				}
			}
			else
			{
				error_report("fail to found correct settings for Same Options for Both Directions");
			}
		}
		
		/// Iris 8/01/2012 ORG-6371-S1 ADD_USE_SAME_OPTIONS_FOR_BOTH_ON_EACH_AXIS_ROOT_NODE
		CheckSetAxisBranchUseSameOptionCheckStatus(trAxis);
		///End ADD_USE_SAME_OPTIONS_FOR_BOTH_ON_EACH_AXIS_ROOT_NODE
		
		// to find the settings string for next axis 
		nAxisBeginPos = strSameOptionsForBothSettings.Find(chAxisBegin, nAxisEndPos + 1);
		if( nAxisBeginPos >= 0 )
		{
			nAxisEndPos = strSameOptionsForBothSettings.Find(chAxisEnd, nAxisBeginPos);
			if( nAxisEndPos >= 0 )
				nAxis++;
		}
	}	
}
///End SAVE_SAME_OPTIONS_FOR_BOTH_DIRECTIONS_TO_REGISTRY

/// Iris 11/04/2011 ORG-4017-P1 NEED_REFRESH_INCREMENT_VAL_AFTER_CHANGED_FROM_TO
//bool AxesControlSplitter::Apply()
bool AxesControlSplitter::Apply(bool bFromApplyButton)
///End NEED_REFRESH_INCREMENT_VAL_AFTER_CHANGED_FROM_TO
{
	bool bRet = false;
	if( m_bEditTreeChanged )
	{		
		/// Iris 11/04/2011 ORG-4017-P1 NEED_REFRESH_INCREMENT_VAL_AFTER_CHANGED_FROM_TO
		//return applyTheme();
		if( applyTheme() )
		{
			/// Iris 7/12/2012 ORG-5991-P8 UPDATE_UNDEFINED_STATUS_AFTER_CHANGE_VALUE_WITH_SELECTED_MULTI_AXES
			//if( bFromApplyButton )
				///// Iris 5/10/2012 FIX_BREAK_PROPERTIES_FAIL_TO_REFRESH_IN_2D_GRAPH
				//// need to refresh the right GetN tree from the left list tree, then update dyna control
				////NiceUpdateDynaControl(true, GETNEVENT_ON_CHANGE_UPDATE_GUI, false, DYNACONTROL_UPDATE_VALUE);				
				//ShowListContent(-1, true, false);
				/////End FIX_BREAK_PROPERTIES_FAIL_TO_REFRESH_IN_2D_GRAPH
			///End UPDATE_UNDEFINED_STATUS_AFTER_CHANGE_VALUE_WITH_SELECTED_MULTI_AXES
			bRet = true;
		}
		///End NEED_REFRESH_INCREMENT_VAL_AFTER_CHANGED_FROM_TO
		
		// clean up the changed status
		m_bEditTreeChanged = false;
		m_vnChangedAxes.RemoveAll();		
		//---- Iris 5/10/2012 changed attribute remained in list tree will do apply format again, so need to remove all chagned attribtes after apply theme wherever apply successfully or not. 
		TreeNode trList = GetListTree();
		octree_remove_attribute(&trList, STR_CHANGED_ATTRIB);		
		//----
		/// Iris 9/27/2012 ORG-6996-P1 FIX_CUSTOM_FORMAT_MISSED_AFTER_SHOW_MINRO_LABEL
		// the change bit on the right GetN tree also need to be removed after apply theme, else the change bit will keep and apply theme again and again. 
		TreeNode tr = GetTree();
		octree_remove_attribute(&tr, STR_CHANGED_ATTRIB);		
		///End FIX_CUSTOM_FORMAT_MISSED_AFTER_SHOW_MINRO_LABEL
	}
	return bRet;
}



/// Iris 11/09/2011 ORG-4268-P1 FIX_ONLY_SHOW_TICK_LABELS_FOR_1ST_AXIS_NOT_WORKED_FOR_MINOR_TICK_LABEL
//bool	AxesControlSplitter::checkSetOnlyOneTickLabelFor1stAxis(int nDataID)
bool	AxesControlSplitter::checkSetOnlyOneTickLabelFor1stAxis()
///End FIX_ONLY_SHOW_TICK_LABELS_FOR_1ST_AXIS_NOT_WORKED_FOR_MINOR_TICK_LABEL
{	
	TreeNode trOnly1stAxisShowTickLabel = _get_GetN_node_by_id(GetListTree(), ID_ONLY_SHOW_TICK_LABELS_FOR_1ST_AXIS, true);
	if ( m_bForAll && trOnly1stAxisShowTickLabel )
	{
		TreeNode trGetNAxis = GetGetNAxisNode(0);
		/// Iris 11/09/2011 ORG-4268-P1 FIX_ONLY_SHOW_TICK_LABELS_FOR_1ST_AXIS_NOT_WORKED_FOR_MINOR_TICK_LABEL
		//TreeNode trGetNShow = MAJOR_TICK_LABEL_SHOW_NODE(trGetNAxis);
		TreeNode trGetNMajorTickLabelShow = MAJOR_TICK_LABEL_SHOW_NODE(trGetNAxis);
		TreeNode trGetNMinorTickLabelShow = MINOR_TICK_LABEL_SHOW_NODE(trGetNAxis);
		///End FIX_ONLY_SHOW_TICK_LABELS_FOR_1ST_AXIS_NOT_WORKED_FOR_MINOR_TICK_LABEL
		
		for(int nAxis = 0; nAxis < m_nNumAxes; nAxis++)
		{
			TreeNode trThemeAxis = GetThemeAxisNode(nAxis);
			/// Iris 11/09/2011 ORG-4268-P1 FIX_ONLY_SHOW_TICK_LABELS_FOR_1ST_AXIS_NOT_WORKED_FOR_MINOR_TICK_LABEL
			/*
			TreeNode trThemeShow = MAJOR_TICK_LABEL_SHOW_NODE(trThemeAxis);			
			if( trOnly1stAxisShowTickLabel.nVal )
			{
				if( TICK_LABEL_SHOW_NONE == trGetNShow.nVal && ID_ONLY_SHOW_TICK_LABELS_FOR_1ST_AXIS == nDataID )
					trGetNShow.nVal = TICK_LABEL_SHOW_BEFORE_AXIS;
				trThemeShow.nVal = 0 != nAxis ? 0 : trGetNShow.nVal;
			}
			else
			{
				trThemeShow.nVal = trGetNShow.nVal;
			}
			trThemeShow.SetAttribute(STR_CHANGED_ATTRIB, 1);
			*/
			TreeNode trThemeMajorTickLabelShow = MAJOR_TICK_LABEL_SHOW_NODE(trThemeAxis);
			TreeNode trThemeMinorTickLabelShow = MINOR_TICK_LABEL_SHOW_NODE(trThemeAxis);
			
			// if theme node is not existed, then add show node firstly
			if( !trThemeMajorTickLabelShow )
				MAJOR_TICK_LABEL_SHOW_NODE(trThemeAxis).nVal = trGetNMajorTickLabelShow.nVal;
			if( !trThemeMinorTickLabelShow )
			{
				TreeNode trShow = trThemeAxis.Labels.MinorLabels.AddNode("Show");
				trShow.nVal = trGetNMinorTickLabelShow.nVal;
			}
			
			if( trOnly1stAxisShowTickLabel.nVal )
			{
				//if( ID_ONLY_SHOW_TICK_LABELS_FOR_1ST_AXIS == nDataID )
				//{
					//if( trGetNMajorTickLabelShow && TICK_LABEL_SHOW_NONE == trGetNMajorTickLabelShow.nVal )
						//trGetNMajorTickLabelShow.nVal = TICK_LABEL_SHOW_BEFORE_AXIS;
					//if( trGetNMinorTickLabelShow && 0 == trGetNMinorTickLabelShow.nVal )
						//trGetNMinorTickLabelShow.nVal = 1;
				//}					
				trThemeMajorTickLabelShow.nVal = 0 != nAxis ? 0 : trGetNMajorTickLabelShow.nVal;
				trThemeMinorTickLabelShow.nVal = 0 != nAxis ? 0 : trGetNMinorTickLabelShow.nVal;
			}
			else
			{
				trThemeMajorTickLabelShow.nVal = trGetNMajorTickLabelShow.nVal;
				trThemeMinorTickLabelShow.nVal = trGetNMinorTickLabelShow.nVal;
			}			
			_set_change_bit(trThemeMajorTickLabelShow);
			_set_change_bit(trThemeMinorTickLabelShow);
			///End FIX_ONLY_SHOW_TICK_LABELS_FOR_1ST_AXIS_NOT_WORKED_FOR_MINOR_TICK_LABEL
		}	
		return true;
	}
	return false;
}
///End ADD_ONLY_SHOW_TICK_LABEL_ON_1ST_AXIS_CHECKBOX

static void _tree_check_copy_values_by_id(TreeNode& trSrc, TreeNode& trDest, bool bAddChangedAttrib)
{	
	foreach(TreeNode trSrcSub in trSrc.Children)
	{
		TreeNode trDestSub = _get_theme_node_by_id(trDest, trSrcSub.ID, false);		
		if( trDestSub )
		{
			if( 0 == trSrcSub.GetNodeCount() && 0 == trDestSub.GetNodeCount() )
			{				
				if( trDestSub.strVal != trSrcSub.strVal )
				{
					trDestSub.strVal == trSrcSub.strVal;
					if( bAddChangedAttrib )						
						_set_change_bit(trDestSub);
				}	
			}
			else
			{
				_tree_check_copy_values_by_id(trSrcSub, trDestSub, bAddChangedAttrib);
			}
		}
	}
}

/// Iris 7/18/2012 ORG-5991-P10 FIX_PROPERTIES_IN_AXIS_FORMAT_NOT_WORK_WHEN_USE_SAME_OPTIONS_CHECKED_WITH_MULTI_AXES_SELECTED
void 	AxesControlSplitter::copyGetNChangedValuesByID(TreeNode& trEdit, TreeNode& trDestPropertyBranch, int nEditAxis)
{
	int nSubAxisIndex = 0;	
	
	foreach(TreeNode trDestSubBranch in trDestPropertyBranch.Children) // trDestPropertyBranch is AxesFormat, trDestSubBranch is Bottom/Top level
	{		
		TreeNode trEditSubBranch;
		
		int nSubBranchID = -1;			
		if( trDestSubBranch.GetAttribute(STR_DATAID_ATTRIB, nSubBranchID) ) // if Bottom/Top branch not DataID
		{			
			if( trDestSubBranch.GetNodeCount() > 0 )
			{				
				/// Iris 7/13/2012 ORG-5991-P9 FIX_PROPERTY_IN_YAXIS_NOT_BE_CHANGED_WHEN_APPLY_CHANGES_WITH_SELECT_OTHERS
				//int nSubBranchID = GetColletionMemberBranchNode(_get_base_id(trSubBranch.DataID), _CHECK_CONVERT_SUB_AXIS_INDEX(nSubAxisIndex), nAxis);
				nSubBranchID = GetColletionMemberBranchNode(_get_base_id(nSubBranchID), _CHECK_CONVERT_SUB_AXIS_INDEX(nEditAxis, nSubAxisIndex), nEditAxis);
				///End FIX_PROPERTY_IN_YAXIS_NOT_BE_CHANGED_WHEN_APPLY_CHANGES_WITH_SELECT_OTHERS			
			}
					
			trEditSubBranch = _get_GetN_node_by_id(trEdit, nSubBranchID);				
		}
		else // when there is NOT DataID in tDestSubBranch, then get sub node from trEdit by tagName
		{				
			string strSubBranchName;
			if( trDestSubBranch.GetNodeCount() > 0 )
			{
				// is Bottom/Top sub branch node
				strSubBranchName = getAxisSubBranchName(nEditAxis).GetToken( _CHECK_CONVERT_SUB_AXIS_INDEX(nEditAxis, nSubAxisIndex), '|')
			}
			else
			{
				// is Use Same Options for both node
				strSubBranchName = trDestSubBranch.tagName;
			}
			
			trEditSubBranch = trEdit.GetNode(strSubBranchName);
		}
		
		if( trEditSubBranch )		
		{		
			if( nSubBranchID > 0 )
			{
				/// Iris 7/12/2012 ORG-5991-P8 UPDATE_UNDEFINED_STATUS_AFTER_CHANGE_VALUE_WITH_SELECTED_MULTI_AXES
				//int num = octree_copy_values_by_id(&trEditSub, &trSubBranch, false, STR_DATAID_ATTRIB, STR_DATAID_ATTRIB);					
				//num = octree_copy_atts_by_id(&trEditSub, &trSubBranch, STR_CHANGED_ATTRIB, STR_DATAID_ATTRIB, STR_DATAID_ATTRIB);				
				_copy_values_for_changed_nodes(trEditSubBranch, trDestSubBranch, true); // only to copy value for the changed node
				///End UPDATE_UNDEFINED_STATUS_AFTER_CHANGE_VALUE_WITH_SELECTED_MULTI_AXES				
			}
			else
			{
				foreach(TreeNode trDestSubProperty in trDestSubBranch.Children)
				{
					TreeNode trEditSubProperty = trEditSubBranch.GetNode( trDestSubProperty.tagName );
					if( trEditSubProperty )
						_copy_values_for_changed_nodes(trEditSubProperty, trDestSubProperty, true);
				}
			}
		}	
		
		if( trDestSubBranch.GetNodeCount() > 0 )
			nSubAxisIndex++;	
	}		
}
///End FIX_PROPERTIES_IN_AXIS_FORMAT_NOT_WORK_WHEN_USE_SAME_OPTIONS_CHECKED_WITH_MULTI_AXES_SELECTED

void	AxesControlSplitter::copySameOptionsForSecondAxis()
{	
	/// Iris 7/30/2012 ORG-6371-P2 FIX_CHANGED_ONE_AXIS_EFFECTED_ALL_OTHER_AXES
	TreeNode trAutoShowHide = GetListTree().Misc.AutoHide;
	bool bCopyShowPropertyEx = trAutoShowHide && 0 == trAutoShowHide.nVal && m_vnChangedAxes.GetSize() < m_nNumAxes;
	vector<uint> vnChangedAxesEx;	
	if( bCopyShowPropertyEx )
		vnChangedAxesEx.Data(0, m_nNumAxes - 1, 1);
	else
		vnChangedAxesEx = m_vnChangedAxes;
	///End FIX_CHANGED_ONE_AXIS_EFFECTED_ALL_OTHER_AXES	
	
	// when checked Same Option for "Bottom" and "Top", need to apply properties from "Bottom" branch to "Top" branch
	// here "Bottom" and "Top" will be replace with Left/Right for Y axis, or Front/Back for Z axis.
	/// Iris 7/30/2012 ORG-6371-P2 FIX_CHANGED_ONE_AXIS_EFFECTED_ALL_OTHER_AXES
	/*
	for(int nn = 0; nn < m_vnChangedAxes.GetSize(); nn++)
	{	
		int nAxis = m_vnChangedAxes[nn];
	*/
	for(int nn = 0; nn < vnChangedAxesEx.GetSize(); nn++)
	{
		int nAxis = vnChangedAxesEx[nn];
		bool bOnlyCopyShowProperty = false;
		vector<uint> vn;
		if( 0 == m_vnChangedAxes.GetSize() || m_vnChangedAxes.Find(MATREPL_TEST_EQUAL, nAxis, vn) < 0 )
			bOnlyCopyShowProperty = true;
	///End FIX_CHANGED_ONE_AXIS_EFFECTED_ALL_OTHER_AXES
		TreeNode trThemeAxis = GetThemeAxisNode(nAxis);
		TreeNode trGetNAxis = GetGetNAxisNode(nAxis);
				
		foreach(TreeNode trGetNPropertyBranch in trGetNAxis.Children)
		{			
			TreeNode trSameOptions = _get_GetN_node_by_id(trGetNPropertyBranch, ID_SAME_FOR_BOTTOM_AND_TOP, false);									
			/// Iris 7/20/2012 ORG-6270-S1 IMPROVE_TICK_LABELS_BRANCH_SPEED
			//if( trSameOptions && trSameOptions.nVal )
			vector<uint> vnRows;
			m_AxesGridTree.GetSelRows(vnRows);
			if( trSameOptions && 
				(	1 == trSameOptions.nVal 
					|| SUB_AXIS_COUNT == vnRows.GetSize() && m_bForBothBySelection
					/// Iris 8/06/2012 ORG-6463-S1 ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
					/// Iris 8/14/2012 ORG-6463-P2 IMPROVE_SHOW_PRIMARY_AXES_ONLY
					// will do this copy to share same settings for both sub axes in ApplyFormat method in low level
					//|| IsShowPrimaryAxesOnly()
					///End IMPROVE_SHOW_PRIMARY_AXES_ONLY
					///End ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
				) 
			)
			///End IMPROVE_TICK_LABELS_BRANCH_SPEED
			{				
				TreeNode trGetNBottom, trGetNTop, trThemeDest;
				
				// to get the first axis (the top one, Bottom for X...) branch from GetN tree
				{						
					int nCollIndex = 0;
					foreach(TreeNode trGetNPropertySub in trGetNPropertyBranch.Children)
					{						
						if( trGetNPropertySub.GetNodeCount() > 0 )
						{
							if( 0 == nCollIndex )
							{
								nCollIndex++;
								trGetNBottom = trGetNPropertySub;
							}
							else							
							{
								trGetNTop = trGetNPropertySub; // TopTitles branch is not in theme tree, so need to copy treenodes from GetN firstly, and then copy values from Bottom
							}															
						}
					}	
				}
								
				// to get the second (the bottom one, Top for X...) branch from theme tree	
				//int nPropertyBranchThemeID = OTID_AXIS_LINE == trGetNPropertyBranch.DataID ? OTID_AXIS_TICKS : _get_base_id(trGetNPropertyBranch.DataID);				
				int nGetNPropertyBranchID = _get_base_id(trGetNPropertyBranch.DataID);				
				int nThemePropertyBranchID = nGetNPropertyBranchID;
				if( ID_AXIS_FORMATS == nGetNPropertyBranchID )
					nThemePropertyBranchID = OTID_AXIS_TICKS;
				/// Iris 6/21/2012 ORG-5991-S4 MOVE_SPECIAL_TICK_LABEL_OUTSIDE_LABELS_BRANCH
				if( OTID_AXIS_SPECIALTICKS == nGetNPropertyBranchID )
					nThemePropertyBranchID = OTID_AXIS_LABELS;
				///End MOVE_SPECIAL_TICK_LABEL_OUTSIDE_LABELS_BRANCH
				TreeNode trThemePropertyBranch = _tree_get_branch_node_by_base_id(trThemeAxis, nThemePropertyBranchID, true); // to find out the related theme property branch node, for example, Ticks, Labels...
				ASSERT(trThemePropertyBranch);				
				if( trThemePropertyBranch )
				{
					/// Iris 6/26/2012 ORG-5528-P22 NOT_EXCHANGE_LEFT_RIGHT_SUBAXIS_FOR_YAXIS_IN_XYY_3DBAR_PLOT
					int nDestIndex = AXIS_Y == nAxis && IsExchangeYAxisSubAxis() ? 0 : 1;
					///End NOT_EXCHANGE_LEFT_RIGHT_SUBAXIS_FOR_YAXIS_IN_XYY_3DBAR_PLOT
					int nCollIndex = 0;
					foreach(TreeNode trThemePropertySub in trThemePropertyBranch.Children)
					{
						if( trThemePropertySub.DataID > 0 && IS_THEME_COLL_MEMBER(trThemePropertySub.DataID) )
						{
							/// Iris 6/26/2012 ORG-5528-P22 NOT_EXCHANGE_LEFT_RIGHT_SUBAXIS_FOR_YAXIS_IN_XYY_3DBAR_PLOT
							//if( nDestIndex != nCollIndex )
							/// Iris 7/06/2012 TO_FIX_NOT_CHANGED_TOPAXIS_WITH_MODIFICATION_OF_BOTTOMAXIS_EVEN_USE_SAME_OPTIONS_BOX_IS_CHECKED
							// should not use hard code - 0 to find the target theme sub axis (bottom/top, left/right...) 
							//if( 0 != nCollIndex )
							if( nDestIndex != nCollIndex )
							///End TO_FIX_NOT_CHANGED_TOPAXIS_WITH_MODIFICATION_OF_BOTTOMAXIS_EVEN_USE_SAME_OPTIONS_BOX_IS_CHECKED
							///End NOT_EXCHANGE_LEFT_RIGHT_SUBAXIS_FOR_YAXIS_IN_XYY_3DBAR_PLOT
							{
								nCollIndex++;
							}
							else							
							{
								trThemeDest = trThemePropertySub;
								break;
							}	
						}
					}				
				}				
				
				if( trGetNBottom && trThemeDest )
				{
					/// Iris 7/30/2012 ORG-6371-P2 FIX_CHANGED_ONE_AXIS_EFFECTED_ALL_OTHER_AXES
					if( bOnlyCopyShowProperty )
					{
						vector<uint> vnGetNShowIDs, vnThemeShowIDs;
						switch( nGetNPropertyBranchID )
						{
						case ID_AXIS_FORMATS:
							vnGetNShowIDs.Add(ID_AXIS_FIRST_SHOW);
							vnThemeShowIDs.Add(OTID_AXIS_TICK_SHOW);
							break;
							
						case OTID_AXIS_LABELS:
							vnGetNShowIDs.Add(OTID_AXIS_LABEL_SHOW);
							vnThemeShowIDs.Add(OTID_AXIS_LABEL_SHOW);
							vnGetNShowIDs.Add(OTID_AXIS_LABEL_SHOW_MINOR);
							vnThemeShowIDs.Add(OTID_AXIS_LABEL_SHOW_MINOR);	
							
							break;
							
						case OTID_AXIS_TITLES:
							vnGetNShowIDs.Add(OTID_TITLE_SHOW);
							vnThemeShowIDs.Add(OTID_TITLE_SHOW);							
							break;
							
						case OTID_AXIS_SPECIALTICKS:
							// no Show node under this property branch
							break;
							
						default:
							ASSERT(false);
							break;
						}	
						
						for(int index = 0; index < vnGetNShowIDs.GetSize(); ++index)
						{
							TreeNode trGetNShow = _get_GetN_node_by_id(trGetNBottom, vnGetNShowIDs[index], true);
							TreeNode trThemeShow = _get_GetN_node_by_id(trThemeDest, vnThemeShowIDs[index], true);
							if( trGetNShow && trThemeShow )
							{
								_set_value_with_change_bit(trThemeShow, trGetNShow.nVal);
							}
						}
					}
					else
					///End FIX_CHANGED_ONE_AXIS_EFFECTED_ALL_OTHER_AXES
					{
						/// Iris 6/21/2012 ORG-5991-S4 MOVE_SPECIAL_TICK_LABEL_OUTSIDE_LABELS_BRANCH
						if( OTID_AXIS_SPECIALTICKS == nGetNPropertyBranchID && trThemeDest.SpecialTicks )
						{
							_copy_special_tick_label_settings_from_GetN_to_theme(trGetNBottom, trThemeDest.SpecialTicks);
						}					
						else					
						{						
							Tree trSrcCopy;
							trSrcCopy.Replace(trGetNBottom);
							octree_set_attribute_to_all_nodes(&trSrcCopy, STR_CHANGED_ATTRIB, "1");
							octree_delete_nodes_by_attribute(&trSrcCopy, STR_SHOW_ATTRIB, 0); // no need to copy the hidden controls					
							
							TreeNode trJunk;						
							_copy_changed_nodes(trSrcCopy, trThemeDest, trJunk);	
						}
						
						if( OTID_AXIS_LABELS == nGetNPropertyBranchID )
						{
							_copy_custom_decimal_from_GetN_to_theme(trGetNBottom, trThemeDest);
						}
					}
				}
			}
		}
	}		
}

/// Iris 6/13/2012 ORG-5991 MOVE_TICKS_AND_LINE_BRANCH_INTO_AXIS_FORMAT_BRANCH
void 	AxesControlSplitter::removeNodesNotInTheme()
{
	/// Iris 9/28/2011 ORG-3962-S1 IMPROVE_AXIS_DLG_GUI
	int nInvalidNodeID = -1;
	TreeNode trGetBranchNotInTheme;
	while( (trGetBranchNotInTheme = _get_theme_node_by_id(m_trTheme, nInvalidNodeID, true)) && trGetBranchNotInTheme.GetNodeCount() ) // if found and it is a branch
	{
		TreeNode trParentBranch = trGetBranchNotInTheme.Parent();
		ASSERT( trParentBranch && trParentBranch.ID != nInvalidNodeID );
		
		if( trParentBranch && trParentBranch.ID != nInvalidNodeID )
		{
			// copy the sub node from trGetBranchNotInTheme to trParentBranch, and then remove trGetBranchNotInTheme
			foreach(TreeNode trN in trGetBranchNotInTheme.Children)
			{
				TreeNode trNew = trParentBranch.AddNode(trN.tagName, trN.ID);
				if( trN.GetNodeCount() == 0 )
					trNew.strVal = trN.strVal;
			}
			trGetBranchNotInTheme.Remove();
		}
	}
	///End IMPROVE_AXIS_DLG_GUI	
		
	// some GetN nodes copied into theme tree by _copy_changed_nodes function, before apply theme need to delete theme
	for(int nID = ID_USER_DEFINED_BEGIN; nID <= ID_USER_DEFINED_END; ++nID)
	{
		TreeNode trN = _get_theme_node_by_id(m_trTheme, nID, true);
		if( trN )
			trN.Remove();
	}
}
///End MOVE_TICKS_AND_LINE_BRANCH_INTO_AXIS_FORMAT_BRANCH

/// Iris 8/22/2012 CHECK_CREATE_TITLE_OBJ
void	AxesControlSplitter::checkCreateTitleObject()
{
	for(int nAxis = 0; nAxis < m_nNumAxes; ++nAxis)
	{
		TreeNode trThemeAxisNode = GetThemeAxisNode(nAxis);
		if( trThemeAxisNode && trThemeAxisNode.Titles )
		{
			string strDefaultTitle;
			switch(nAxis)
			{
			case AXIS_X:
				strDefaultTitle = STR_X_DEFAULT_TITLE;
				break;
				
			case AXIS_Y:
				strDefaultTitle = STR_Y_DEFAULT_TITLE;
				break;
			
			case AXIS_Z:
				strDefaultTitle = STR_Z_DEFAULT_TITLE;
				break;
				
			default:
				ASSERT(false);
				break;
			}
					
			
			for(int nSubAxis = 0; nSubAxis < SUB_AXIS_COUNT; ++nSubAxis)
			{	
				TreeNode trSubTitle;
				if( IsShowPrimaryAxesOnly() || 0 == nSubAxis )
					trSubTitle = trThemeAxisNode.Titles.FirstNode;
				else
					trSubTitle = trThemeAxisNode.Titles.FirstNode.NextNode;
				
				if( trSubTitle )
				{
					TreeNode trTitleShow = trSubTitle.GetNode("Show");						
					if( trTitleShow && trTitleShow.nVal )
					{
						AxisObject ao;
						if( _get_axis_object(ao, m_gl, nAxis, 0 == nSubAxis ? AXISOBJPOS_AXIS_FIRST : AXISOBJPOS_AXIS_SECOND) && ao )
						{					
							GraphObject goTitle = ao.GetTitleObject(strDefaultTitle); // check and create a title object
							ASSERT(goTitle);							
						}				
					}
				}
			}
		}
	}
}
///End CHECK_CREATE_TITLE_OBJ

/// Iris 8/06/2012 ORG-6463-S1 ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
BOOL	AxesControlSplitter::ApplyThemeTree(TreeNode& trTheme, bool bUpdateThemeIDs/* = false*/)
{	
	if( bUpdateThemeIDs )
	{
		int nRet = m_gl.UpdateThemeIDs(trTheme.Root);		
		if( 0 != nRet )
			return false;
	}
	return m_gl.ApplyFormat(STYLE_RELATIVE | STYLE_REPAINT | STYLE_NO_CLEANUP, trTheme);
}
///End ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX

BOOL	AxesControlSplitter::applyTheme()
{	
	// when "Use Same Options for Bottom and Top" is checked, need to copy options from Bottom to Top.	
	copySameOptionsForSecondAxis();
	octree_delete_nodes_by_attribute(&m_trTheme, STR_ID_ATTRIB, ID_SAME_FOR_BOTTOM_AND_TOP, TRUE);	
	
	// remove the tree node that user did not change
	/// Iris 9/19/2012 ORG-6463-P7 KEEP_ORIGINAL_SETTINGS_WHEN_SWITCH_TO_USE_ONE_AXIS_FOR_EACH_DIRECTOR
	/// Iris 9/28/2012 ORG-7019-P1 FIX_CANNOT_HIDE_MAJOR_TICK_LABELS
	// if not changed the "Use one Axis.. " checkbox, and keep it is checked, the settings of secondary axis also should be removed,
	// else the settings in primary axis will be overlay from the setting of the secondary axis.
	//if( m_bIsShowPrimaryAxesOnlyChanged && IsShowPrimaryAxesOnly() )
	if( IsShowPrimaryAxesOnly() )
	///End FIX_CANNOT_HIDE_MAJOR_TICK_LABELS
	{		
		foreach(TreeNode trAxis in m_trTheme.Root.Axes.Children)
		{
			// the two settings will separated do apply below
			if( m_bIsShowPrimaryAxesOnlyChanged )
			{
				if( trAxis.AutoHide )
					trAxis.AutoHide.Remove();
				if( trAxis.ShareFirstAxis )
					trAxis.ShareFirstAxis.Remove();
			}
			
			vector<string> vsBranchNames = {"Ticks", "Labels", "Titles"};
			for(int index = 0; index < vsBranchNames.GetSize(); ++index)
			{
				TreeNode trBranch = trAxis.GetNode( vsBranchNames[index] );
				if( trBranch )
				{
					// to remove the object of the secondary axis
					TreeNode trFirst = trBranch.FirstNode;
					if( trFirst && trFirst.NextNode )
					{
						trFirst.NextNode.Remove();
					}
				}
			}			
		}
		
		/// Iris 9/28/2012 ORG-7019-P1 FIX_CANNOT_HIDE_MAJOR_TICK_LABELS
		if( !m_bIsShowPrimaryAxesOnlyChanged )
		{
			octree_delete_nodes_by_missing_attribute(&m_trTheme, STR_CHANGED_ATTRIB, true, true, false);
			ASSERT(m_trTheme.GetNodeCount());	
		}
		///End FIX_CANNOT_HIDE_MAJOR_TICK_LABELS
	}	
	else	
	///End KEEP_ORIGINAL_SETTINGS_WHEN_SWITCH_TO_USE_ONE_AXIS_FOR_EACH_DIRECTOR
	{
		octree_delete_nodes_by_missing_attribute(&m_trTheme, STR_CHANGED_ATTRIB, true, true, false);
		ASSERT(m_trTheme.GetNodeCount());	
	}
	
	/// Iris 5/10/2012 FIX_SECOND_AXIS_FORMAT_NOT_UPDATED_ON_GUI_AFTER_APPLY_FORMAT_WITH_SAME_OPTIONS_CHECKED
	///// Iris 5/09/2012 BREAK_PROPERTIES_NOT_AUTO_REFRESH_AFTER_ENABLE_BREAK
	//bool bScaleChanged = _get_theme_node_by_id(m_trTheme, OTID_AXIS_SCALE, true).IsValid();
	//bool bBreakEnableChanged = _get_theme_node_by_id(m_trTheme, OTID_AXIS_BREAK_ENABLE, true).IsValid(); // break enable change need to refresh other break properties nodes from there to GetN.
	/////End BREAK_PROPERTIES_NOT_AUTO_REFRESH_AFTER_ENABLE_BREAK
	///End FIX_SECOND_AXIS_FORMAT_NOT_UPDATED_ON_GUI_AFTER_APPLY_FORMAT_WITH_SAME_OPTIONS_CHECKED
		
	/// Iris 6/13/2012 ORG-5991 MOVE_TICKS_AND_LINE_BRANCH_INTO_AXIS_FORMAT_BRANCH
	removeNodesNotInTheme();
	///End MOVE_TICKS_AND_LINE_BRANCH_INTO_AXIS_FORMAT_BRANCH
	
	/// Iris 8/22/2012 CHECK_CREATE_TITLE_OBJ
	checkCreateTitleObject();
	///End CHECK_CREATE_TITLE_OBJ
	
	/// Iris 8/14/2012 ORG-6463-P2 IMPROVE_SHOW_PRIMARY_AXES_ONLY
	// Kyle said need to apply auto hide and share first axis settings before other settings.			
	/// Iris 8/16/2012 ORG-6463-P4 FIX_CHANGE_ANY_ONE_CAUSE_Y_TOP_AXES_HIDE
	if( m_bIsShowPrimaryAxesOnlyChanged )
	///End FIX_CHANGE_ANY_ONE_CAUSE_Y_TOP_AXES_HIDE
	{
		Tree trThemeTemp;
		trThemeTemp.Root.Axes.X.AutoHide.nVal = IsShowPrimaryAxesOnly();
		trThemeTemp.Root.Axes.X.ShareFirstAxis.nVal = IsShowPrimaryAxesOnly();	
		bool bRet = ApplyThemeTree(trThemeTemp, true);
		ASSERT( bRet );	
				
		/// Iris 8/16/2012 ORG-6463-P4 FIX_CHANGE_ANY_ONE_CAUSE_Y_TOP_AXES_HIDE
		m_bIsShowPrimaryAxesOnlyChanged = false;
		///End FIX_CHANGE_ANY_ONE_CAUSE_Y_TOP_AXES_HIDE
	}	
	///End IMPROVE_SHOW_PRIMARY_AXES_ONLY	
	
	//----CPY 8/15/2011 SPIDER_AXES_DLG_MESSING_UP_PLOT
	//	return gl.ApplyFormat(m_trTheme, TRUE, TRUE);
	/// Iris 11/04/2011 ORG-4017-P1 NEED_REFRESH_INCREMENT_VAL_AFTER_CHANGED_FROM_TO
	// STYLE_REPAINT bit will cause the refresh order issue
	//bool bRet = m_gl.ApplyFormat(STYLE_RELATIVE | STYLE_REPAINT | STYLE_NO_CLEANUP, m_trTheme); 
	/// Iris 6/08/2012 ORG-4017-P1 FIX_CHANGED_SCALE_TO_VAL_INCREMENT_VAL_NOT_AUTO_UPDATE_ON_AXES_DLG
	// RVD: if only To is set and increment is left out to be set automatically on refresh,
	// then need to wait to finish draw before GetFormat() is called	
	//bool bRet = m_gl.ApplyFormat(STYLE_RELATIVE | STYLE_NO_CLEANUP, m_trTheme); 	
	//m_gl.GetPage().Refresh(true);	
	/// Iris 8/06/2012 ORG-6463-S1 ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
	//bool bRet = m_gl.ApplyFormat(STYLE_RELATIVE | STYLE_REPAINT | STYLE_NO_CLEANUP, m_trTheme); 
	bool bRet = ApplyThemeTree(m_trTheme, false);
	///End ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
	LT_execute("doc -uwf;"); 
	///End FIX_CHANGED_SCALE_TO_VAL_INCREMENT_VAL_NOT_AUTO_UPDATE_ON_AXES_DLG	
	///End NEED_REFRESH_INCREMENT_VAL_AFTER_CHANGED_FROM_TO
	ASSERT(bRet);
	//---
	
	/// Iris 10/31/2011 ORG-4268-S1 NEED_DO_RESCALE_WHEN_INDEPDENTLY_RESCALE_CHECKED
	/// Iris 11/10/2011 ORG4268-P2 UNCHECK_RESCALE_EACH_AXIS_INDEP_NOT_WORKED
	/*
	if( m_bIsIndependentlyRescale )
		m_gl.Rescale();
	*/
	/// Iris 5/17/2012 ORG-5528-S5 MOVE_TICKS_COUNT_NODES_TO_TICKS_BRANCH_FOR_GL_GRAPH
	/*
	if( m_bRescaleIndependentlyChanged )
	{
		m_gl.Rescale();
		m_bRescaleIndependentlyChanged = false; // clear this status after do rescale
	}
	*/
	if( m_nRescaleAfterApplyTheme )
	{
		m_gl.Rescale();
		m_nRescaleAfterApplyTheme = false;
	}
	///End MOVE_TICKS_COUNT_NODES_TO_TICKS_BRANCH_FOR_GL_GRAPH
	///End UNCHECK_RESCALE_EACH_AXIS_INDEP_NOT_WORKED
	///End NEED_DO_RESCALE_WHEN_INDEPDENTLY_RESCALE_CHECKED
		
	getTheme(m_trTheme);	
	
	/// Iris 5/10/2012 FIX_SECOND_AXIS_FORMAT_NOT_UPDATED_ON_GUI_AFTER_APPLY_FORMAT_WITH_SAME_OPTIONS_CHECKED
	///// Iris 11/04/2011 ORG-4017-P1 NEED_REFRESH_INCREMENT_VAL_AFTER_CHANGED_FROM_TO
	//// refresh the increment value in scale branch of the changed axes when changed scale.from or to
	//if( bRet && m_vnChangedAxes.GetSize() > 0 )
	//{
		//for(int index = 0; index < m_vnChangedAxes.GetSize(); index++)
		//{
			//int nAxis = m_vnChangedAxes[index];
			//nAxis = nAxis < 0 ? 0 : nAxis; // if nAxis == -1, means set options for all axes, the settings all are same in each axis, so get theme settings from 1st axis here.
			//TreeNode trThemeAxis = GetThemeAxisNode(nAxis);
			//TreeNode trGetNAxis = GetGetNAxisNode(nAxis);
			//ASSERT( trGetNAxis );
			//
			//// Refresh Scale branch
			///// Iris 5/09/2012 BREAK_PROPERTIES_NOT_AUTO_REFRESH_AFTER_ENABLE_BREAK
			//if( bScaleChanged )
			/////End BREAK_PROPERTIES_NOT_AUTO_REFRESH_AFTER_ENABLE_BREAK
			//{
				//TreeNode trThemeScale = _get_theme_node_by_id(trThemeAxis, OTID_AXIS_SCALE, true); // if scale branch changed
				//if( trThemeScale )			
				//{
					//// update list tree									
					//if( trGetNAxis && trGetNAxis.Scale )
					//{
						//octree_copy_values_by_id(&trThemeScale, &trGetNAxis, false, STR_ID_ATTRIB, STR_DATAID_ATTRIB);
					//}
					//
					///// Iris 5/09/2012 BREAK_PROPERTIES_NOT_AUTO_REFRESH_AFTER_ENABLE_BREAK
					///*
					//// update GetN tree once time
					//if(0 == index)
					//{
						//TreeNode trDisplay = GetTree();
						//if( trDisplay.DataID == OTID_AXIS_SCALE ) // if selected Scale branch currectly
						//{
							//octree_copy_values_by_id(&trThemeScale, &trDisplay, false, STR_ID_ATTRIB, STR_DATAID_ATTRIB);
						//}
					//}
					//*/
					/////End BREAK_PROPERTIES_NOT_AUTO_REFRESH_AFTER_ENABLE_BREAK
				//}
			//}
			//
			///// Iris 5/09/2012 BREAK_PROPERTIES_NOT_AUTO_REFRESH_AFTER_ENABLE_BREAK
			//// Refresh Break Branch
			//if( bBreakEnableChanged )
			//{
				//TreeNode trThemeBreakBranch = _get_theme_node_by_id(trThemeAxis, OTID_AXIS_BREAK, true);
				//TreeNode trGetNBreakBranch = _get_GetN_node_by_id(trGetNAxis, OTID_AXIS_BREAK, true);
				//if( trThemeBreakBranch )
				//{
					//octree_copy_values_by_id(&trThemeBreakBranch, &trGetNBreakBranch, false, STR_ID_ATTRIB, STR_DATAID_ATTRIB);
				//}				
			//}
			/////End BREAK_PROPERTIES_NOT_AUTO_REFRESH_AFTER_ENABLE_BREAK
		//}
	//}
	/////End NEED_REFRESH_INCREMENT_VAL_AFTER_CHANGED_FROM_TO
	TreeNode trThemeAxes = getThemeAxesNode();
	TreeNode trGetN = GetListTree();
	CopyValuesFromThemeToGetN(trThemeAxes, trGetN);			
	///End FIX_SECOND_AXIS_FORMAT_NOT_UPDATED_ON_GUI_AFTER_APPLY_FORMAT_WITH_SAME_OPTIONS_CHECKED
	
	UpdateGetNTreeOnSelection(true, true); /// Iris 7/12/2012 ORG-5991-P8 UPDATE_UNDEFINED_STATUS_AFTER_CHANGE_VALUE_WITH_SELECTED_MULTI_AXES
	
	return bRet;	
}

BOOL AxesControlSplitter::getTheme(TreeNode& trTheme)
{	
	trTheme = m_gl.GetFormat(FPB_ALL, /*FOB_AXIS | FOB_SCALE*/FOB_ALL, TRUE, TRUE);	
	
	/// RVD 11/7/2011 ORG-4017-p1 INC_AXIS_MAJOR_TICKS_ASSERT
	//error_report("Inc Val = " + (string)trTheme.Root.NewAxes.NewAxis1.Scale.Value.dVal);
	/// end INC_AXIS_MAJOR_TICKS_ASSERT
	
	/// Iris 11/04/2011 ORG-4017-P1 NEED_REFRESH_INCREMENT_VAL_AFTER_CHANGED_FROM_TO
	foreach(TreeNode trN in m_trTheme.Root.Children)
	{		
		/// Iris 4/27/2012 ORG-5528-S1 AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
		//if( 0 != strcmp(trN.tagName, STR_AXES) )		
		if( 0 != strcmp(trN.tagName, getThemeAxesNodeTagname()) )
		///End AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
			trN.Remove();
	}
	/// Iris 4/27/2012 ORG-5528-S1 AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
	//TreeNode trThemeAxes = m_trTheme.Root.TAG_AXES;
	TreeNode trThemeAxes = getThemeAxesNode();
	//End AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
	_remove_invalid_branch_node_and_convert_themeid_to_dataid(trThemeAxes);
	///End NEED_REFRESH_INCREMENT_VAL_AFTER_CHANGED_FROM_TO
	
	//initIncrementValue(trTheme.Root.TAG_AXES);
	
	
	/// RVD 9/21/2011 ORG-3732-s1 SPIDER_INDIVIDUAL_SCALE
//	TreeNode trIndividualRescale = _get_theme_node_by_id(trTheme, OTID_AXES_INDIVIDUALSCALE, true);
//	m_bAutoscaleIndependently =  trIndividualRescale ? trIndividualRescale.nVal : FALSE;
	/// end SPIDER_INDIVIDUAL_SCALE
	
	return true;
}

/// Iris 11/04/2011 ORG-4017-P1 NEED_REFRESH_INCREMENT_VAL_AFTER_CHANGED_FROM_TO
/*
void AxesControlSplitter::initIncrementValue(TreeNode& trThemeAxes)
{
	Scale s(m_gl.Y);
	if( !s )
		return;
	
	/// Iris 10/09/2011 UPDATED_AFTER_ROMAN_CHANGE_ABOUT_SPIDER_THEME_IMPROVE
	//if( !trThemeAxes.TAG_ALLAXES.Scale )
		//trThemeAxes.TAG_ALLAXES.Scale.ID = OTID_AXIS_SCALE;
	//TreeNode trScale = trThemeAxes.TAG_ALLAXES.Scale;
	
	TreeNodeCollection trAxisColl(trThemeAxes, STR_AXIS);
	foreach(TreeNode trThemeAxis in trAxisColl)
	{
		if( !trThemeAxis.Scale )
			trThemeAxis.Scale.ID = OTID_AXIS_SCALE;
		TreeNode trScale = trThemeAxis.Scale;
	///End UPDATED_AFTER_ROMAN_CHANGE_ABOUT_SPIDER_THEME_IMPROVE
	
		if( !trScale.Value )
		{
			trScale.Value.ID = OTID_AXIS_SCALE_INC_VALUE;
		}
		if( trScale.Value.IsEmpty() || is_equal(0, trScale.Value.dVal) )
		{
			trScale.Value.dVal = s.Inc;
		}
		
		if( !trScale.MajorTicksCount )
		{
			trScale.MajorTicksCount.ID = OTID_AXIS_SCALE_MAJOR_COUNT;
		}
		if( trScale.MajorTicksCount.IsEmpty() )
		{
			trScale.MajorTicksCount.nVal = nint(fabs(s.To - s.From) / s.Inc) + 1;	
		}
		
		if( !trScale.IncrementBy )
		{
			trScale.IncrementBy.ID = OTID_AXIS_SCALE_INCBY;		
		}	
		if( trScale.IncrementBy.IsEmpty() )
		{
			trScale.IncrementBy.nVal = 0;
		}
	} /// Iris 10/09/2011 UPDATED_AFTER_ROMAN_CHANGE_ABOUT_SPIDER_THEME_IMPROVE
}
*/
///End NEED_REFRESH_INCREMENT_VAL_AFTER_CHANGED_FROM_TO

BOOL	AxesControlSplitter::constructGetN(TreeNode& trGetN)
{
	getTheme(m_trTheme);
	/// Iris 11/04/2011 ORG-4017-P1 NEED_REFRESH_INCREMENT_VAL_AFTER_CHANGED_FROM_TO
	/*
	foreach(TreeNode trN in m_trTheme.Root.Children)
	{
		if( 0 != strcmp(trN.tagName, STR_AXES) )
			trN.Remove();
	}
	TreeNode trThemeAxes = m_trTheme.Root.TAG_AXES;
	_remove_invalid_branch_node_and_convert_themeid_to_dataid(trThemeAxes);
	*/
	/// Iris 4/27/2012 ORG-5528-S1 AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
	//TreeNode trThemeAxes = m_trTheme.Root.TAG_AXES;
	TreeNode trThemeAxes = getThemeAxesNode();
	///End AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
	///End NEED_REFRESH_INCREMENT_VAL_AFTER_CHANGED_FROM_TO
	
	/// Iris 10/09/2011 UPDATED_AFTER_ROMAN_CHANGE_ABOUT_SPIDER_THEME_IMPROVE
	/*
	if( !trThemeAxes.TAG_ALLAXES.Count )
		return false;
	m_nNumAxes = trThemeAxes.TAG_ALLAXES.Count.nVal;
	*/
	/// Iris 4/27/2012 ORG-5528-S1 AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
	//TreeNodeCollection trColl(trThemeAxes, STR_AXIS);
	//m_nNumAxes = trColl.Count();
	m_nNumAxes = trThemeAxes.GetNodeCount();
	///End AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
	if( 0 == m_nNumAxes )
		return false;
	///End UPDATED_AFTER_ROMAN_CHANGE_ABOUT_SPIDER_THEME_IMPROVE
	int nNumAxes = m_bForAll ? -1 : m_nNumAxes;
	/// Iris 4/27/2012 ORG-5528-S1 AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
	//constructSpiderPlotGetN(trGetN, nNumAxes);
	GetAxisPropertyCustomOptions();
	constructGetNTrees(trGetN, nNumAxes);
	///End AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH

	// copy value from Theme tree to GetN tree
	/// Iris 9/28/2011 ORG-3962-S1 IMPROVE_AXIS_DLG_GUI
	//tree_copy_values_by_id(trThemeAxes.TAG_ALLAXES, trGetN.Axes.CategoryAxis);	
	//tree_copy_values_by_id(trThemeAxes.TAG_ALLAXES.Grids, trGetN.Axes.RadialAxis.Grids);
	//---- CPY 10/04/2011 ORG-3732-s1 SPIDER_INDIVIDUAL_SCALE_SHOULD_BE_INSIDE_TREE
	//tree_copy_values_by_id(trThemeAxes.TAG_ALLAXES, trGetN.StartPosition);
	/// Iris 10/09/2011 UPDATED_AFTER_ROMAN_CHANGE_ABOUT_SPIDER_THEME_IMPROVE
	/*
	tree_copy_values_by_id(trThemeAxes.TAG_ALLAXES, trGetN.Misc);
	//----
	tree_copy_values_by_id(trThemeAxes.TAG_ALLAXES.Grids, trGetN.Grids);	
	*/	
	///End UPDATED_AFTER_ROMAN_CHANGE_ABOUT_SPIDER_THEME_IMPROVE
	///End IMPROVE_AXIS_DLG_GUI	
	CopyValuesFromThemeToGetN(trThemeAxes, trGetN);	
	
	return TRUE;
}

/// Iris 7/19/2012 ORG-6246-P1 SETUP_SCALE_DISPLAY_VALUE_ON_AFTER_DIVIDE_FACTOR_CHANGE
void AxesControlSplitter::setScaleValuesDivideFactor(TreeNode& trGetNOneAxis, int nAxis, int nSubAxis)
{
	TreeNode trScale = trGetNOneAxis.Scale;
	TreeNode trLabels = trGetNOneAxis.Labels;
	string strSubBranchName = getAxisSubBranchName(nAxis).GetToken(nSubAxis, '|');
	if( !strSubBranchName.IsEmpty() ) // Radar plot has not sub axis, so the name is empty.
	{
		trLabels = trLabels.GetNode(strSubBranchName);
	}
	if( !trLabels || !trScale )
	{
		error_report("fail to find tick label or scale branch");
		return;
	}
	
	TreeNode trDivideFactor = trLabels.MajorLabels.DivideByFactor;
	if( trDivideFactor && trDivideFactor.Show )
	{
		string strFactor = trDivideFactor.strVal;
		trScale.From.SetAttribute(STR_DYNA_DIVIDED_BY_FACTOR_ATTRIB, strFactor);
		trScale.To.SetAttribute(STR_DYNA_DIVIDED_BY_FACTOR_ATTRIB, strFactor);
		if( trScale.MajorTicks.Value )
			trScale.MajorTicks.Value.SetAttribute(STR_DYNA_DIVIDED_BY_FACTOR_ATTRIB, strFactor);
	}	
}

/// Iris 7/27/2012 ORG-6242-P1 SETUP_DATE_TIME_FORMAT_ON_SCALE_VALUE_CONTROLS
void AxesControlSplitter::setScaleValueDisplayTypeWithTickLabelType(TreeNode& trGetNOneAxis, int nAxis)
{	
	int nPrimaryAxisIndex = 0;	
	TreeNode trLabels = trGetNOneAxis.Labels.GetNode(getAxisSubBranchName(nAxis, _CHECK_CONVERT_SUB_AXIS_INDEX(nAxis, nPrimaryAxisIndex), false));
	if( !trLabels )
		trLabels = trGetNOneAxis.Labels;
	if( trLabels )		
	{
		TreeNode trMajorLabels = trLabels.MajorLabels;
		TreeNode trScale = trGetNOneAxis.Scale;
		ASSERT( trMajorLabels && trScale );
		
		if( trMajorLabels && trMajorLabels.Type && trScale )
		{
			int nType = trMajorLabels.Type.nVal;			
			
			bool bDate;
			string strFormat;				
			bool bDateTimePicker = OULABEL_TIME == nType || OULABEL_DATE == nType;			
			if( bDateTimePicker )
			{
				bDate = (OULABEL_DATE == nType);
				///Sophy 9/10/2012 ORG-6751-P1 MORE_CHECK_ON_SET_DATETIME_PICKER_DISPLAY_FORMAT
				//int nFormat = bDate ? trMajorLabels.DateDisplay.nVal : trMajorLabels.TimeDisplay.nVal;
				//strFormat = bDate ? get_date_format_str(nFormat) : get_time_format_str(nFormat);				
				if ( OULABEL_DATE == nType )
				{
					int nFormat = trMajorLabels.DateDisplay.nVal;
					if ( LDF_OBJ_CUSTOM == nFormat )
					{
						strFormat = trMajorLabels.DateCustomDisplay.strVal;
					}
					else
					{
						strFormat = get_date_format_str(nFormat);
					}
					if ( strFormat.IsEmpty() )	//not valid for CDateTimeCtrl, need to switch to simple Labtalk style
					{
						strFormat = "D" + (nFormat);
						bDateTimePicker = false;
					}
				}
				else	//time
				{
					int nFormat = trMajorLabels.TimeDisplay.nVal;
					if ( LTF_OBJ_CUSTOM == nFormat )
					{
						strFormat = trMajorLabels.TimeCustomDisplay.strVal;
					}
					else
					{
						strFormat = get_time_format_str(nFormat);
					}
					if ( strFormat.IsEmpty() ) //not valid for CDateTimeCtrl, need to switch to simple Labtalk style
					{
						strFormat = "T" + (nFormat);
						bDateTimePicker = false;
					}
				}
				///end MORE_CHECK_ON_SET_DATETIME_PICKER_DISPLAY_FORMAT
			}				
			set_node_datetime_picker(trScale.From, strFormat, bDate, bDateTimePicker);
			set_node_datetime_picker(trScale.To, strFormat, bDate, bDateTimePicker);			
			
			// setup display type for increment value control
			string strIncFormat;			
			if( OULABEL_TIME == nType || OULABEL_DATE == nType || OULABEL_MONTH == nType || OULABEL_DAYOFWEEK == nType )
				strIncFormat = "D4096";
			TreeNode trIncVal = trScale.Value ? trScale.Value : trScale.MajorTicks.Value;
			set_node_datetime_picker(trIncVal, strIncFormat, false, false);			
		}
	}	
}
///End SETUP_DATE_TIME_FORMAT_ON_SCALE_VALUE_CONTROLS

void AxesControlSplitter::updateGetNScaleAfterCopyValuesFromTheme(TreeNode& trGetN, TreeNode& trGetNOneAxis, int nAxis)
{	
	setScaleValuesDivideFactor(trGetNOneAxis, nAxis, m_nDefaultSecondaryAxis);
	
	/// Iris 7/27/2012 ORG-6242-P1 SETUP_DATE_TIME_FORMAT_ON_SCALE_VALUE_CONTROLS
	// to set scale value format with the tick label type	
	setScaleValueDisplayTypeWithTickLabelType(trGetNOneAxis, nAxis);	
	///End SETUP_DATE_TIME_FORMAT_ON_SCALE_VALUE_CONTROLS
}
///End SETUP_SCALE_DISPLAY_VALUE_ON_AFTER_DIVIDE_FACTOR_CHANGE

void AxesControlSplitter::CopyValuesFromThemeToGetN(TreeNode& trThemeAxes, TreeNode& trGetN)
{
	// copy values from theme Axes.TAG_ALLAXES and AxisN branch
	/// Iris 9/28/2011 ORG-3962-S1 IMPROVE_AXIS_DLG_GUI
	//TreeNodeCollection trGetNAxesColl(trGetN.Axes.RadialAxis, "Axis");
	TreeNodeCollection trGetNAxesColl(trGetN, "Axis");
	///End IMPROVE_AXIS_DLG_GUI
	
	int nAxis = 0; /// Iris 10/09/2011 UPDATED_AFTER_ROMAN_CHANGE_ABOUT_SPIDER_THEME_IMPROVE
	foreach(TreeNode trGetNOneAxis in trGetNAxesColl)
	{
		/// Iris 10/09/2011 UPDATED_AFTER_ROMAN_CHANGE_ABOUT_SPIDER_THEME_IMPROVE
		// if m_bForAll is true, just copy values from NewAxis1 to GetN controls
		/*
		tree_copy_values_by_id(trThemeAxes.TAG_ALLAXES, trGetNOneAxis);
		
		if( !m_bForAll )
		{
			TreeNode trThemeOneAxis = _get_theme_node_by_id(trThemeAxes, trGetNOneAxis.DataID);
			tree_copy_values_by_id(trThemeOneAxis, trGetNOneAxis);
		}
		*/			
		TreeNode trThemeOneAxis = _get_theme_node_by_id(trThemeAxes, trGetNOneAxis.DataID);
		ASSERT(trThemeOneAxis);
		
		CopyValuesFromThemeToGetNForOneAxis(trGetN, nAxis, trThemeOneAxis, trGetNOneAxis);
		
		updateGetNScaleAfterCopyValuesFromTheme(trGetN, trGetNOneAxis, nAxis);
		
		nAxis++; /// Iris 10/09/2011 UPDATED_AFTER_ROMAN_CHANGE_ABOUT_SPIDER_THEME_IMPROVE
	}	
}

//virtual 
void AxesControlSplitter::CopyValuesFromThemeToGetNForOneAxis(TreeNode& trGetN, int nAxis, TreeNode& trThemeOneAxis, TreeNode& trGetNOneAxis)
{	
	tree_copy_values_by_id(trThemeOneAxis, trGetNOneAxis);	
	
	/// Iris 6/06/2012 ORG-5528-P17 SUPPORT_CUSTOM_DECIMAL_IN_3DGL_GRAPH
	//TreeNode trThemeCustomDecimal = _get_theme_node_by_id(trThemeOneAxis.Labels, OTID_AXIS_LABEL_MANUAL_DEC, true);
	//TreeNode trGetNCustomDecimal = _get_GetN_node_by_id(trGetNOneAxis.Labels, OTID_AXIS_LABEL_MANUAL_DEC, true);
	bool bFinished = false;
	for(int nSubAxis = 0; nSubAxis < SUB_AXIS_COUNT; ++nSubAxis)
	{			
		/// Iris 7/13/2012 ORG-5991-P9 FIX_PROPERTY_IN_YAXIS_NOT_BE_CHANGED_WHEN_APPLY_CHANGES_WITH_SELECT_OTHERS
		//TreeNode trThemeSubBranch = _get_GetN_node_by_id(trThemeOneAxis.Labels, GetColletionMemberBranchNode(OTID_AXIS_LABEL, _CHECK_CONVERT_SUB_AXIS_INDEX(nSubAxis), nAxis), false);
		//TreeNode trGetNSubBranch = _get_GetN_node_by_id(trGetNOneAxis.Labels, GetColletionMemberBranchNode(OTID_AXIS_LABEL, _CHECK_CONVERT_SUB_AXIS_INDEX(nSubAxis), nAxis), false);
		TreeNode trThemeSubBranch = _get_GetN_node_by_id(trThemeOneAxis.Labels, GetColletionMemberBranchNode(OTID_AXIS_LABEL, _CHECK_CONVERT_SUB_AXIS_INDEX(nAxis, nSubAxis), nAxis), false);
		TreeNode trGetNSubBranch = _get_GetN_node_by_id(trGetNOneAxis.Labels, GetColletionMemberBranchNode(OTID_AXIS_LABEL, _CHECK_CONVERT_SUB_AXIS_INDEX(nAxis, nSubAxis), nAxis), false);
		///End FIX_PROPERTY_IN_YAXIS_NOT_BE_CHANGED_WHEN_APPLY_CHANGES_WITH_SELECT_OTHERS
		
		if( !trGetNSubBranch )
		{		
			bFinished = true; // not sub axis (ex, bottom/top) in this graph, so only copy once time.
			trThemeSubBranch = trThemeOneAxis.Labels;
			trGetNSubBranch = trGetNOneAxis.Labels;
		}	
		TreeNode trThemeCustomDecimal = _get_theme_node_by_id(trThemeSubBranch, OTID_AXIS_LABEL_MANUAL_DEC, true);
		TreeNode trGetNCustomDecimal = _get_GetN_node_by_id(trGetNSubBranch, OTID_AXIS_LABEL_MANUAL_DEC, true);
	///End SUPPORT_CUSTOM_DECIMAL_IN_3DGL_GRAPH
	
		if( !trThemeCustomDecimal || !trGetNCustomDecimal )
		{
			bFinished = true;
		}
		else
		{
			if( !trThemeCustomDecimal.IsEmpty() )
			{
				trGetNCustomDecimal.SetAttribute(STR_ATTRIB_DYNACONTROL_USE_CHECK, trThemeCustomDecimal.nVal);
				/// Iris 8/01/2012 ORG-5991-P14 IMPORVE_CUSTOM_DECIMAL_CONTROL_DISPLAY
				if( trGetNCustomDecimal.Parent().hits )
					trGetNCustomDecimal.Parent().hits.Show = trThemeCustomDecimal.nVal;
				///End IMPORVE_CUSTOM_DECIMAL_CONTROL_DISPLAY
			}
					
			/// Iris 6/06/2012 ORG-5528-P17 SUPPORT_CUSTOM_DECIMAL_IN_3DGL_GRAPH
			//TreeNode trThemeCustomFormat = trThemeOneAxis.Labels.MajorLabels.CustomFormat;	
			TreeNode trThemeCustomFormat = _get_theme_node_by_id(trThemeSubBranch, OTID_AXIS_LABEL_CUSTOM_FORMAT, true);	
			///End SUPPORT_CUSTOM_DECIMAL_IN_3DGL_GRAPH
			if( trThemeCustomFormat && !trThemeCustomFormat.IsEmpty() )
			{
				
				trGetNCustomDecimal.strVal = trThemeCustomFormat.strVal;
			}
			else
			{
				trGetNCustomDecimal.strVal = E_STR_CUSTOM_DEFAULT_FORMAT;
			}		
		}
		
		/// Iris 6/06/2012 ORG-5528-P17 SUPPORT_CUSTOM_DECIMAL_IN_3DGL_GRAPH
		if( bFinished )
			break;
		///End SUPPORT_CUSTOM_DECIMAL_IN_3DGL_GRAPH
	}
	
	/// Iris 09/06/2011 ORG-3297-P1 FIX_LABEL_COLOR_CHANGED_WITH_LINE_COLOR_BUT_GUI_NOT_CHANGE
	// copy color from line.color to labels.majorlabels.color
	_set_label_auto_color_by_line_color(trGetNOneAxis.Line.Color, trGetNOneAxis.Labels.MajorLabels.Color);
	///End FIX_LABEL_COLOR_CHANGED_WITH_LINE_COLOR_BUT_GUI_NOT_CHANGE	
}

int AxesControlSplitter::getRepeatID(const TreeNode& trN)
{
	/// Iris 7/20/2012 ORG-6270-S1 IMPROVE_TICK_LABELS_BRANCH_SPEED
	//int nRepeatID = HIWORD(trN.ID);
	int nRepeatID = HIWORD(trN.DataID);
	///End IMPROVE_TICK_LABELS_BRANCH_SPEED
	return nRepeatID;
}

void AxesControlSplitter::OnBeforeTreeViewSelection(Control ctrl, long nOldRow, long nOldCol, long nNewRow, long nNewCol, BOOL* pbCancel)
{
	/// Iris 7/20/2012 ORG-6270-S1 IMPROVE_TICK_LABELS_BRANCH_SPEED
	// clear the old status
	m_bForBothBySelection = false;
	
	if( -1 == GetSelectedRow() )		
	{			
		return;
	}	 
	///End IMPROVE_TICK_LABELS_BRANCH_SPEED
	
	TreeNode trRow = GetTreeNode(nNewRow);
	/// Iris 9/21/2012 ORG-6910-P1 FIX_SEL_MULTIPLE_ROWS_ISSUE
	TreeNode trOldRow = GetTreeNode(nOldRow);
	///End FIX_SEL_MULTIPLE_ROWS_ISSUE
	*pbCancel = false;
	string strDebug;
	if( trRow )
	{
		int nRepeatID = getRepeatID(trRow);		
		int nParentRepeatID = getRepeatIDFromParent(trRow);		
		
		if( 0 == nRepeatID && 0 == nParentRepeatID )
		{		
			strDebug = "No repeat id."; 
			DEBUG_MSG(strDebug);		
				
			if( CNTRL_DOWN || trRow.FirstNode.FirstNode.IsValid() ) // only allow to select the last level branch node 
			{
				*pbCancel = true;				
			}	
			else
			{
				m_nRepeatID = 0;
			}
		}
		else // if has repeat id
		{
			/// Iris 9/21/2012 ORG-6910-P1 FIX_SEL_MULTIPLE_ROWS_ISSUE
			//if( CNTRL_DOWN && nOldRow >= m_AxesGridTree.GetRowOffset() && m_AxesGridTree.GetRowOutlineLevel(nOldRow) != m_AxesGridTree.GetRowOutlineLevel(nNewRow) )
			int nOldRowLevel = m_AxesGridTree.GetRowOutlineLevel(nOldRow);
			int nNewRowLevel = m_AxesGridTree.GetRowOutlineLevel(nNewRow);
			if( CNTRL_DOWN && nOldRow >= m_AxesGridTree.GetRowOffset() && nOldRowLevel != nNewRowLevel )
			///End FIX_SEL_MULTIPLE_ROWS_ISSUE			
			{
				*pbCancel = true;
				
				strDebug = "*pbCancel = true; Selectd the different level";
				DEBUG_MSG(strDebug);
			}
			/// Iris 7/20/2012 ORG-6270-S1 IMPROVE_TICK_LABELS_BRANCH_SPEED
			//else if( isBranchWithRepeatNodes( nRepeatID ) ) // if is the branch of repeat node
			//{
				//*pbCancel = true;
				//
				//strDebug.Format("*pbCancel = true; Clicked on branch node, nRepeatID = %d", nRepeatID);
				//DEBUG_MSG(strDebug);
			//}
			///End IMPROVE_TICK_LABELS_BRANCH_SPEED
			else // selected the same level
			{	
				/// Iris 9/21/2012 ORG-6910-P1 FIX_SEL_MULTIPLE_ROWS_ISSUE
				/*
				if( CNTRL_DOWN )
				{
					if( !isOneGourpIDs(m_nRepeatID, nRepeatID) )
					{
						*pbCancel = true;
						
						strDebug.Format("*pbCancel = true; Ctrl down & !same group, nRepeatID = %d", nRepeatID);
						DEBUG_MSG(strDebug);
					}
				*/
				if( CNTRL_DOWN && nOldRowLevel == nNewRowLevel )
				{
					TreeNode trOldParent = GetTreeNode(m_AxesGridTree.GetParent(nOldRow));
					TreeNode trNewParent = GetTreeNode(m_AxesGridTree.GetParent(nNewRow));
					
					if( LEVEL_AXIS_PROPERTY_BRANCH == nNewRowLevel && trOldRow && _get_base_id(trOldRow.DataID) != _get_base_id(trRow.DataID) )
					{
						*pbCancel = true;
						
						strDebug.Format("*pbCancel = true; property branch level & Ctrl down & same level & diff property branch");
						DEBUG_MSG(strDebug);
					}
					else if( LEVEL_SUB_AXIS_BRANCH == nNewRowLevel && trOldParent && trNewParent && _get_base_id(trOldParent.DataID) != _get_base_id(trNewParent.DataID) )
					{
						*pbCancel = true;
						
						strDebug.Format("*pbCancel = true; sub axis branch level & Ctrl down & same level & diff property branch");
						DEBUG_MSG(strDebug);
					}
					///End FIX_SEL_MULTIPLE_ROWS_ISSUE
					else
					{						
						strDebug.Format("Ctrl down & same group, nRepeatID = %d", nRepeatID);
						DEBUG_MSG(strDebug);
					}				
				}
				else
				{
					m_nRepeatID = nRepeatID;
					
					strDebug.Format("!Ctrl down, nRepeatID = %d", nRepeatID);
					DEBUG_MSG(strDebug);
				}
			}
		}
		
		/// Iris 7/20/2012 ORG-6270-S1 IMPROVE_TICK_LABELS_BRANCH_SPEED
		if( !(*pbCancel) ) // if allow to select the current row
		{		
			TreeNode trParent = trRow.Parent();
			if( trParent && trParent.SameForBoth && 0 == trParent.SameForBoth.nVal )			
			{
				m_bForBothBySelection = true;
			}			
		}
		///End IMPROVE_TICK_LABELS_BRANCH_SPEED
	}			
}

void AxesControlSplitter::OnTreeViewSelectChange(Control ctrl)
{	
	///Jasmine 09/13/2011 ORG-3297 SELECT_RELATIVE_NODES_TO_APPLY_SETTINGS_TO_MULTIP_AXES	
	if( !IsReady() )
		return;
	///End SELECT_RELATIVE_NODES_TO_APPLY_SETTINGS_TO_MULTIP_AXES
		
	/// Iris 7/12/2012 ORG-5991-P8 UPDATE_UNDEFINED_STATUS_AFTER_CHANGE_VALUE_WITH_SELECTED_MULTI_AXES
	/*
	GETN_TREE(trNewGetN)
	combineSelectedTreeNodes(trNewGetN);	

	// to update tree view
	if( trNewGetN )	
	{
		if( !trNewGetN.FirstNode )
		{
			GETN_TREE(trEmptyGetN)
			GETN_STR(hits, "Empty", "Tips") GETN_HINT 
			trNewGetN.Replace(trEmptyGetN.Clone());
		}
		
		SetInputTree(trNewGetN);		
		UpdateDynaControl(true, GETNEVENT_ON_CHANGE_UPDATE_GUI);	
	}
	*/
	UpdateGetNTreeOnSelection();
	///End UPDATE_UNDEFINED_STATUS_AFTER_CHANGE_VALUE_WITH_SELECTED_MULTI_AXES
	
	///Jasmine 09/13/2011 ORG-3297 SELECT_RELATIVE_NODES_TO_APPLY_SETTINGS_TO_MULTIP_AXES	
	Window Wnd = GetParent();
	if(Wnd)
		Wnd.PostMessage(WM_USER_ON_TREE_VIEW_SELECT_CHANGED);
	///End SELECT_RELATIVE_NODES_TO_APPLY_SETTINGS_TO_MULTIP_AXES
}

/// Iris 8/06/2012 ORG-5991-S7 DB_CLICK_TO_OPEN_CLOSE_BRANCH
void AxesControlSplitter::OnTreeViewDBClick(Control ctrl)
{
	if( !IsReady() )
		return;	
	
	int nSelRow = m_AxesGridTree.GetSelectedRow();
	if( nSelRow >= m_AxesGridTree.GetRowOffset() )
	{
		TreeNode trRow = GetTreeNode(nSelRow);
		string strAttrib;
		if( trRow.GetNodeCount() > 0 && trRow.GetAttribute(STR_SPECIALVALS_ATTRIB, strAttrib) ) // is a stop level in tree
		{			
			int nStatus = flexOutlineExpanded;
			if( flexOutlineExpanded == m_AxesGridTree.GetIsCollapsed(nSelRow) )
				nStatus = flexOutlineCollapsed;
			m_AxesGridTree.SetIsCollapsed(nSelRow, nStatus);
		}
	}
}
///End DB_CLICK_TO_OPEN_CLOSE_BRANCH

static void _set_change_bit_for_ticks_subbranch(TreeNode& trMajorOrMinor)
{	
	_set_change_bit(trMajorOrMinor);
	
	/// Iris 6/04/2012 ORG-5528-P4 FIX_FAIL_TO_SHOW_MINOR_GRIDS
	/*
	foreach(TreeNode trSubNode in trMajorOrMinor.Children)
	{
		trSubNode.SetAttribute(STR_CHANGED_ATTRIB, 1);	
	}
	*/	
	_set_change_bit(trMajorOrMinor.Type); // for radar plot node
	_set_change_bit(trMajorOrMinor.Major);
	_set_change_bit(trMajorOrMinor.Length);	
	_set_change_bit(trMajorOrMinor.Minor);
	_set_change_bit(trMajorOrMinor.MinorLength);	
	///End FIX_FAIL_TO_SHOW_MINOR_GRIDS
}

///// Iris 6/04/2012 ORG-5528-P4 FIX_FAIL_TO_SHOW_MINOR_GRIDS
////static void _update_controls_by_ticks_property_change(TreeNode& trThemeAxis, TreeNode& trGetNAxis, bool bMajor, bool bGridsChange)
//static void _update_controls_by_ticks_property_change(TreeNode& trThemeAxis, TreeNode& trGetNAxis, TreeNode& trTicksSubBranch, bool bMajor, bool bGridsChange)
/////End FIX_FAIL_TO_SHOW_MINOR_GRIDS
//{		
	//_set_change_bit(trGetNAxis.Ticks);
	//TreeNode trMajorOrMinor = bMajor ? trGetNAxis.Ticks.MajorTicks : trGetNAxis.Ticks.MinorTicks;	
	//if( !trMajorOrMinor )	
	//{
		//foreach(TreeNode trSubBranch in trGetNAxis.Ticks.Children)
		//{
			//if( trSubBranch.GetNodeCount() > 0 )
			//{
				//trMajorOrMinor = bMajor ? trSubBranch.MajorTicks : trSubBranch.MinorTicks;
				//if( trMajorOrMinor ) // just set change bit for first sub axis, for example, BottomTicks, LeftTicks...
				//{
					//_set_change_bit_for_ticks_subbranch(trMajorOrMinor);
					//break;
				//}
			//}
		//}
	//}
	//else
	//{
		//_set_change_bit_for_ticks_subbranch(trMajorOrMinor);
	//}		
	////_copy_changed_node(trGetNAxis.Ticks, trThemeAxis.Ticks);
	//Tree trJunk;
	//_copy_changed_nodes(trGetNAxis.Ticks, trThemeAxis.Ticks, trJunk);
	//
	//if( !bMajor ) // need to change and copy Scale.MinorTicksCount if Grids properties changed else after apply format no change display.
	//{
		///// Iris 6/04/2012 ORG-5528-P4 FIX_FAIL_TO_SHOW_MINOR_GRIDS
		///*
		//if( bGridsChange && trGetNAxis.Scale.MinorTicksCount.nVal == 0 )
			//trGetNAxis.Scale.MinorTicksCount.nVal = 1;
		//trGetNAxis.Scale.SetAttribute(STR_CHANGED_ATTRIB, 1);		
		//trGetNAxis.Scale.MinorTicksCount.SetAttribute(STR_CHANGED_ATTRIB, 1);
		//_copy_changed_node(trGetNAxis.Scale, trThemeAxis);
		//*/
		//ASSERT(trTicksSubBranch);
		//if( trTicksSubBranch && trTicksSubBranch.MinorTicksCount )
		//{
			//if( bGridsChange && trTicksSubBranch.MinorTicksCount.nVal == 0)
				//trTicksSubBranch.MinorTicksCount.nVal = 1;	
						//
			//_set_change_bit(trTicksSubBranch);
			//_set_change_bit(trTicksSubBranch.MinorTicksCount);
			////_copy_changed_node(trTicksSubBranch, trThemeAxis.Scale);
			//Tree trJunk;
			//_copy_changed_nodes(trTicksSubBranch, trThemeAxis.Scale, trJunk);
		//}
		//else
		//{
			//error_report("Fail to find MinorTicksCount node");
		//}		
		/////End FIX_FAIL_TO_SHOW_MINOR_GRIDS
	//}
//}

/// Iris 10/13/2011 ORG-3962-S1 IMPROVE_CUSTOM_DECIMAL_CONTROLS
/*
/// Iris 9/29/2011 ORG-3819-S1 IMPROVE_CUSTOM_DECIAL_CONTROL
static void _enable_tick_label_decimal_places_control(TreeNode& trFormat)
{
	if( trFormat && trFormat.CustomDecimal && trFormat.DecimalPlaces )
	{
		trFormat.DecimalPlaces.Enable = ( 1 == trFormat.CustomDecimal.nVal );
	}
}
///End IMPROVE_CUSTOM_DECIAL_CONTROL
*/
///End IMPROVE_CUSTOM_DECIMAL_CONTROLS

/// Iris 6/27/2012 ORG-5528 ADD_ACTUAL_FONT_SIZE_IN_AXES_DLG
static void _update_tick_label_actual_size(GraphLayer& gl, const TreeNode& trFontSize, TreeNode& trActualSize)
{
	int		nScaleMode;
	double	dFixedFactor;
	BOOL bRet = gl.GetScaleElements(nScaleMode, dFixedFactor);
	ASSERT( bRet );
	
	if( bRet )
	{
		int nFontSize = trFontSize.nVal;
		double dActualSize = nFontSize;
		if( 1 == nScaleMode )
		{
			dActualSize = round(nFontSize * dFixedFactor, 1);
		}
		
		trActualSize.strVal = STR_ACTUAL_SIZE_LABEL + " (" + ftoa(dActualSize) + ")";	
	}
}
///End ADD_ACTUAL_FONT_SIZE_IN_AXES_DLG

/// Iris 09/06/2011 ORG-3297-P1 FIX_LABEL_COLOR_CHANGED_WITH_LINE_COLOR_BUT_GUI_NOT_CHANGE
static void _set_label_auto_color_by_line_color(TreeNode& trLineColor, TreeNode& trLabelColor)
{
	if( trLineColor && trLabelColor && trLabelColor.nVal == INDEX_COLOR_AUTOMATIC )
	{
		trLabelColor.SetAttribute(STR_ATTRIB_AUTO_COLOR, trLineColor.nVal);
	}
}
///End FIX_LABEL_COLOR_CHANGED_WITH_LINE_COLOR_BUT_GUI_NOT_CHANGE

/// Iris 8/19/2011 COMBINE_INCVALUE_AND_MAJORTICKSCOUNT_AS_ONE_CONTROL
/*
static void _update_controls_by_scale_increment_value_change(TreeNode& trScale, bool bConvertFromValue, bool bInit)
{
	if( !bInit )
		trScale.IncrementBy.SetAttribute(STR_CHANGED_ATTRIB, 1);
	
	double from = trScale.From.dVal;
	double to = trScale.To.dVal;
	double inc = trScale.Value.dVal;
	int nScaleType = trScale.Type.nVal;
	double dLinearFrom = real_inv_space(from, nScaleType);
	double dLinearTo = real_inv_space(to, nScaleType);		
	double dLinearInc = real_inv_space(inc, nScaleType);	

	if( bConvertFromValue ) // update MajorTicksCount according to Value
	{
		trScale.MajorTicksCount.nVal = nint( fabs( (dLinearTo - dLinearFrom) / dLinearInc ) ) + 1;				
	}
	else // update Vlaue according to MajorTicksCount
	{
		double dCount = trScale.MajorTicksCount.nVal;
		trScale.Value.dVal = real_space( fabs( (dLinearTo - dLinearFrom) / (dCount - 1) ), nScaleType);		
	}			
}
*/
/// Iris 5/17/2012 ORG-5528-S5 MOVE_TICKS_COUNT_NODES_TO_TICKS_BRANCH_FOR_GL_GRAPH
/*
static void _update_controls_by_scale_increment_value_change(TreeNode& trScale)
{
	if( 0 != trScale.IncrementBy.nVal )
	{
		trScale.MajorTicksCount.nVal = trScale.Value.dVal;
		trScale.MajorTicksCount.SetAttribute(STR_CHANGED_ATTRIB, 1);
	}
}

static void _update_increment_value_to_swtich_incvalue_and_tickscount(TreeNode& trScale, bool bConvertToValue)
{	
	double from = trScale.From.dVal;
	double to = trScale.To.dVal;
	int nScaleType = trScale.Type.nVal;
	double dLinearFrom = real_inv_space(from, nScaleType);
	double dLinearTo = real_inv_space(to, nScaleType);		
		
	if( bConvertToValue )
	{
		int nMajorTicksCount = trScale.Value.nVal;			
		double dInc = real_space( fabs( (dLinearTo - dLinearFrom) / (nMajorTicksCount - 1) ), nScaleType);
		trScale.Value.SetAttribute(STR_INC_VALUE_LABEL, dInc);
	}
	else
	{
		double inc = trScale.Value.dVal;
		double dLinearInc = real_inv_space(inc, nScaleType);		
		int nCount = nint( fabs( (dLinearTo - dLinearFrom) / dLinearInc ) ) + 1;
		trScale.Value.SetAttribute(STR_MAJOR_TICKS_COUNT_LABEL, nCount);		
	}
}
*/
static double _convert_incvalue_and_tickscount(double dInput, double from, double to, int nScaleType, bool bConvertToValue)
{
	double dLinearFrom = real_inv_space(from, nScaleType);
	double dLinearTo = real_inv_space(to, nScaleType);		
	
	double dResult;
	if( bConvertToValue )
	{
		int nMajorTicksCount = dInput;			
		dResult = real_space( fabs( (dLinearTo - dLinearFrom) / (nMajorTicksCount - 1) ), nScaleType);		
	}
	else
	{
		double inc = dInput;
		double dLinearInc = real_inv_space(inc, nScaleType);		
		int nCount = nint( fabs( (dLinearTo - dLinearFrom) / dLinearInc ) ) + 1;
		dResult = nCount;
	}
	return dResult;		
}
///End MOVE_TICKS_COUNT_NODES_TO_TICKS_BRANCH_FOR_GL_GRAPH

static void _check_correct_scale_value_for_log_type(TreeNode& trN)
{
	if( !trN || trN.IsEmpty() )
		return;
	
	double dVal = trN.dVal;
	if( dVal <= 0 )
	{
		trN.dVal = MIN_LOG_VALUE;		
		_set_change_bit(trN);
	}
}

/// Iris 5/17/2012 ORG-5528-S5 MOVE_TICKS_COUNT_NODES_TO_TICKS_BRANCH_FOR_GL_GRAPH
//static void _update_controls_by_scale_type_change(TreeNode& trScale)
//{	
	//int nScaleType = trScale.Type.nVal;	
	//
	//bool bLogType = _is_log_type(nScaleType);
	//if( trScale.IncrementBy )
		//trScale.IncrementBy.Enable = !bLogType;
	///// Iris 11/08/2011 ORG-3921-P6 DISABLE_INCREMENT_VALUE_FOR_LOG_SCALE_TYPE
	//if( trScale.Value )
		//trScale.Value.Enable = !bLogType;
	/////End DISABLE_INCREMENT_VALUE_FOR_LOG_SCALE_TYPE
	//
	///// Iris 9/29/2011 ORG-3921-P1 FIX_BAD_INIT_VALUE_FOR_LOG_TYPE_SCALE
	////if( bLogType && 0 != trScale.IncrementBy.nVal )
	//if( bLogType )		
	//{
		//if( trScale.IncrementBy && 0 != trScale.IncrementBy.nVal )		
		//{
	/////End FIX_BAD_INIT_VALUE_FOR_LOG_TYPE_SCALE
			//trScale.IncrementBy.nVal = 0;		
			//trScale.IncrementBy.SetAttribute(STR_CHANGED_ATTRIB, 1);
			//
			//_update_controls_by_scale_increment_by_change(trScale);
		//}
		//
		///// Iris 9/29/2011 ORG-3921-P1 FIX_BAD_INIT_VALUE_FOR_LOG_TYPE_SCALE		
		//_check_correct_scale_value_for_log_type( trScale.From );
		//_check_correct_scale_value_for_log_type( trScale.To );
		/////End FIX_BAD_INIT_VALUE_FOR_LOG_TYPE_SCALE
	//}
	/////End COMBINE_INCVALUE_AND_MAJORTICKSCOUNT_AS_ONE_CONTROL	
//}
//
//static void _update_controls_by_scale_increment_by_change(TreeNode& trScale)
//{
	///// Iris 8/19/2011 COMBINE_INCVALUE_AND_MAJORTICKSCOUNT_AS_ONE_CONTROL
	///*
	//if( trScale && trScale.IncrementBy && trScale.Value && trScale.MajorTicksCount )
	//{
		//trScale.Value.Show = ( 0 == trScale.IncrementBy.nVal );
		//trScale.MajorTicksCount.Show = ( 1 == trScale.IncrementBy.nVal );
	//}
	//*/
	//bool bConvertToValue = (0 == trScale.IncrementBy.nVal);
	//_update_increment_value_to_swtich_incvalue_and_tickscount(trScale, bConvertToValue);
	//
	//string strValAttrib = (0 == trScale.IncrementBy.nVal) ? STR_INC_VALUE_LABEL : STR_MAJOR_TICKS_COUNT_LABEL;
	//double dNewVal;
	//if( trScale.Value.GetAttribute(strValAttrib, dNewVal) )
	//{
		//trScale.Value.dVal = dNewVal;
		//trScale.Value.SetAttribute(STR_CHANGED_ATTRIB, 1);
	//}
	//else
		//error_report("Error, cannot find IncValue attribute");	
	//
	//if( !bConvertToValue )
	//{
		//trScale.MajorTicksCount.nVal = dNewVal;
		//trScale.MajorTicksCount.SetAttribute(STR_CHANGED_ATTRIB, 1);
	//}
	/////End COMBINE_INCVALUE_AND_MAJORTICKSCOUNT_AS_ONE_CONTROL
//}
/// Iris 9/14/2012 ORG-6834-P1 FIX_LOG_SCALE_TYPE_INCREMENT_ISSUES
//void AxesControlSplitter::UpdateControlsByScaleTypeChange(TreeNode& trGetNOneAxis, int nAxis)
void AxesControlSplitter::UpdateControlsByScaleTypeChange(TreeNode& trGetNOneAxis, int nAxis, bool bInit)
///End FIX_LOG_SCALE_TYPE_INCREMENT_ISSUES
{	
	TreeNode trScale = trGetNOneAxis.Scale;
	if( !trScale || !trScale.Type )
		return;	
		
	int nScaleType = trScale.Type.nVal;		
	bool bLogType = _is_log_type(nScaleType);
	/// Iris 9/14/2012 ORG-6834-P1 FIX_LOG_SCALE_TYPE_INCREMENT_ISSUES
	//if( bLogType )
	if( bLogType && !bInit )
	///End FIX_LOG_SCALE_TYPE_INCREMENT_ISSUES
	{
		_check_correct_scale_value_for_log_type( trScale.From );
		_check_correct_scale_value_for_log_type( trScale.To );	
	}
		
	/// Iris 9/14/2012 ORG-6834-P1 FIX_LOG_SCALE_TYPE_INCREMENT_ISSUES	
	/// Iris 9/18/2012 ORG-6834-P2 FIX_LOG_SCALE_TYPE_INCREMENT_ISSUES_MORE
	TreeNode trBranch = GetTicksCountParentNode(trGetNOneAxis, true);
	///End FIX_LOG_SCALE_TYPE_INCREMENT_ISSUES_MORE
	if( !bInit )
	{
		int nOldScaleType;
		/// Iris 9/18/2012 ORG-6834-P2 CHANGE_TO_LOG_SCALE_TYPE_CAUSE_RUNTIME_ERROR_IN_RADAR_AXES_DLG
		//if( trScale.MajorTicks.Value.GetAttribute(STR_SCALE_TYPE_ATTRIB, nOldScaleType) && nOldScaleType != nScaleType )
		if( trBranch.Value.GetAttribute(STR_SCALE_TYPE_ATTRIB, nOldScaleType) && nOldScaleType != nScaleType )
		///End CHANGE_TO_LOG_SCALE_TYPE_CAUSE_RUNTIME_ERROR_IN_RADAR_AXES_DLG
		{
			if( !_is_log_type(nOldScaleType) && _is_log_type(nScaleType) ) // to following the rule with the old Axes dialog.
			{
				/// Iris 9/18/2012 ORG-6834-P2 CHANGE_TO_LOG_SCALE_TYPE_CAUSE_RUNTIME_ERROR_IN_RADAR_AXES_DLG
				/*
				int nVal = nint( real_space(trScale.MajorTicks.Value.dVal, nScaleType) );
				_set_value_with_change_bit(trScale.MajorTicks.Value, nVal);
				*/
				int nVal = nint( real_space(trBranch.Value.dVal, nScaleType) );
				if( nVal < 1 )
					nVal = 1;
				_set_value_with_change_bit(trBranch.Value, nVal);
				///End CHANGE_TO_LOG_SCALE_TYPE_CAUSE_RUNTIME_ERROR_IN_RADAR_AXES_DLG
			}
		}
	}
	/// Iris 9/18/2012 ORG-6834-P2 CHANGE_TO_LOG_SCALE_TYPE_CAUSE_RUNTIME_ERROR_IN_RADAR_AXES_DLG
	//trScale.MajorTicks.Value.SetAttribute(STR_SCALE_TYPE_ATTRIB, nScaleType);
	trBranch.Value.SetAttribute(STR_SCALE_TYPE_ATTRIB, nScaleType);
	///End CHANGE_TO_LOG_SCALE_TYPE_CAUSE_RUNTIME_ERROR_IN_RADAR_AXES_DLG
	///End FIX_LOG_SCALE_TYPE_INCREMENT_ISSUES
	
	for(int nSubAxisIndex = 0; nSubAxisIndex < SUB_AXIS_COUNT; ++nSubAxisIndex)
	{		
		/// Iris 6/13/2012 ORG-5991 MOVE_TICKS_AND_LINE_BRANCH_INTO_AXIS_FORMAT_BRANCH
		//TreeNode trBranch = GetTicksCountParentNode(trGetNOneAxis, nAxis, nSubAxisIndex, true);
		/// Iris 9/18/2012 ORG-6834-P2 CHANGE_TO_LOG_SCALE_TYPE_CAUSE_RUNTIME_ERROR_IN_RADAR_AXES_DLG
		//TreeNode trBranch = GetTicksCountParentNode(trGetNOneAxis, true);
		///End CHANGE_TO_LOG_SCALE_TYPE_CAUSE_RUNTIME_ERROR_IN_RADAR_AXES_DLG
		///End MOVE_TICKS_AND_LINE_BRANCH_INTO_AXIS_FORMAT_BRANCH
		ASSERT(trBranch);
		if( !trBranch )
			break;
		
		if( trBranch.IncrementBy && trBranch.Value )
		{
			trBranch.IncrementBy.Enable = !bLogType;		
			
			if( bLogType )		
			{
				/// Iris 9/14/2012 ORG-6834-P1 FIX_LOG_SCALE_TYPE_INCREMENT_ISSUES
				//if( 0 != trBranch.IncrementBy.nVal && trBranch.IncrementBy.Enable )		
				if( 0 != trBranch.IncrementBy.nVal )
				///End FIX_LOG_SCALE_TYPE_INCREMENT_ISSUES
				{						
					_set_value_with_change_bit(trBranch.IncrementBy, 0);
										
					UpdateControlsByIncrementByChange(trBranch);
				}			
			}			
		}	
		
		// if ticks count settings under Scale branch, there is no sub axis (Major/Minor)..
		if( OTID_AXIS_SCALE == trBranch.DataID )
			break;
	}
}

/// Iris 9/18/2012 ORG-6834-P2 CHANGE_TO_LOG_SCALE_TYPE_CAUSE_RUNTIME_ERROR_IN_RADAR_AXES_DLG
/*
void AxesControlSplitter::UpdateControlsByIncrementByChange(TreeNode& trBranch)
{
	/// Iris 7/23/2012 ORG-6319-P1 FIX_AXES_DLG_RUNTIME_ERROR_IN_JOS
	//bool bMajor = IsMajor(trBranch, trParent.DataID);
	TreeNode trParent = trBranch.Parent();
	bool bMajor = IsMajor(trBranch, trParent.DataID);
	///End FIX_AXES_DLG_RUNTIME_ERROR_IN_JOS
	
	TreeNode trIncBy = trBranch.IncrementBy;
	ASSERT(trIncBy);
	if( !trIncBy )
		return;
	
	int nDatasetID = bMajor ? OTID_AXIS_SCALE_USER_MAJOR_TICKS : OTID_AXIS_SCALE_USER_MINOR_TICKS;
	int nTicksCountID = bMajor ? OTID_AXIS_SCALE_MAJOR_COUNT : OTID_AXIS_SCALE_MINOR_COUNT;
	TreeNode trGetNDataset = _get_GetN_node_by_id(trBranch, nDatasetID);
	TreeNode trGetNTicksCount = _get_GetN_node_by_id(trBranch, nTicksCountID);
	
	if( trBranch.Value )
		trBranch.Value.Show = false;
	if( trGetNTicksCount )
		trGetNTicksCount.Show = false;
	if( trGetNDataset )
		trGetNDataset.Show = false;	
		
	if( bMajor )
	{
		/// Iris 7/24/2012 ORG-6243-P1 DISABLE_FIRST_TICK_WHEN_TICKS_FROM_DATASET
		bool bEnableFirstTick = true;
		/// End DISABLE_FIRST_TICK_WHEN_TICKS_FROM_DATASET
		switch(trIncBy.nVal)
		{
		case SET_MAJOR_TICKS_BY_INCREMENT:	
				trBranch.Value.Show = true;	
			break;
			
		case SET_MAJOR_TICKS_BY_COUNT:
				trGetNTicksCount.Show = true;
			break;
			
		case SET_MAJOR_TICKS_BY_DATASET:
				trGetNDataset.Show = true;	
				/// Iris 7/24/2012 ORG-6243-P1 DISABLE_FIRST_TICK_WHEN_TICKS_FROM_DATASET
				bEnableFirstTick = false;
				///End DISABLE_FIRST_TICK_WHEN_TICKS_FROM_DATASET
			break;
		}
		
		/// Iris 7/24/2012 ORG-6243-P1 DISABLE_FIRST_TICK_WHEN_TICKS_FROM_DATASET
		if( trBranch.FirstTick )
			trBranch.FirstTick.Enable = bEnableFirstTick;
		///End DISABLE_FIRST_TICK_WHEN_TICKS_FROM_DATASET
	}	
	else
	{
		switch(trIncBy.nVal)
		{			
		case SET_MINOR_TICKS_BY_COUNT:
				trGetNTicksCount.Show = true;
			break;
			
		case SET_MINOR_TICKS_BY_DATASET:
				trGetNDataset.Show = true;	
			break;
		}
	}
}
*/
///End CHANGE_TO_LOG_SCALE_TYPE_CAUSE_RUNTIME_ERROR_IN_RADAR_AXES_DLG

void AxesControlSplitter::ConvertIncrementValueAndTicksCount(TreeNode& trBranch, TreeNode& trScale, int nEditNodeID/* = -1*/)
{	
	/// Iris 9/14/2012 ORG-6834-P1 FIX_LOG_SCALE_TYPE_INCREMENT_ISSUES
	bool bInit = nEditNodeID <= 0 ;
	///End FIX_LOG_SCALE_TYPE_INCREMENT_ISSUES
	
	if( trBranch && trBranch.Value && trBranch.MajorTicksCount && trScale )
	{	
		bool bConvertToValue;
		/// Iris 9/14/2012 ORG-6834-P1 FIX_LOG_SCALE_TYPE_INCREMENT_ISSUES
		//if( nEditNodeID > 0 )
		if( !bInit )
		///End FIX_LOG_SCALE_TYPE_INCREMENT_ISSUES
		{
			if( OTID_AXIS_SCALE_INC_VALUE == nEditNodeID )
				bConvertToValue = false;
			else if( OTID_AXIS_SCALE_MAJOR_COUNT == nEditNodeID )
				bConvertToValue = true;
			else
				return;
				
		}
		else // nEditNodeID <= 0 means come from dialog init, not from change event.
		{								
			if( SET_MAJOR_TICKS_BY_COUNT == trBranch.IncrementBy.nVal )			
			{
				bConvertToValue = true;			
			}
			else if( SET_MAJOR_TICKS_BY_INCREMENT == trBranch.IncrementBy.nVal )		
			{
				bConvertToValue = false;			
			}
			else
			{
				return; // no need
			}	
		
		}
		
		TreeNode trInput = bConvertToValue ? trBranch.MajorTicksCount : trBranch.Value;
		TreeNode trResult = bConvertToValue ? trBranch.Value : trBranch.MajorTicksCount;		
		
		double dInput = trInput.dVal;
		double from = trScale.From.dVal;
		double to = trScale.To.dVal;
		int nScaleType = trScale.Type.nVal;		
		trResult.dVal = _convert_incvalue_and_tickscount(trInput.dVal, from, to, nScaleType, bConvertToValue);		
		/// Iris 9/14/2012 ORG-6834-P1 FIX_LOG_SCALE_TYPE_INCREMENT_ISSUES
		if( !bInit )
		///End FIX_LOG_SCALE_TYPE_INCREMENT_ISSUES
		{
			_set_change_bit(trResult);		
		}
	}
		
}
///End MOVE_TICKS_COUNT_NODES_TO_TICKS_BRANCH_FOR_GL_GRAPH

/// Iris 5/03/2012 ORG-5528-S1 AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
//void AxesControlSplitter::updateOnAfterValueChange(int nRow, bool& bNeedToUpdateTheme)
// virtual
void AxesControlSplitter::UpdateOnAfterValueChange(int nRow, ThemeUpdateInfo& stThemeUpdateInfo)
///End AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
{
	TreeNode	trEditNode = tree_get_node(GetTree(), nRow);
	TreeNode	trEditBranch = trEditNode.Parent();	
	int			nDataID = trEditNode.DataID;	
	
	bool		bNeedToUpdateTheme = true;		
	bool 		bNeedToUpdateGUI = false; // to update dyna control with GetN tree
	bool		bShowListContent = false; // get the content from left list tree to refresh right GetN tree	
	
	switch(nDataID)
	{	
	case OTID_AXIS_SCALE_INCBY:	
	case ID_AXIS_MINOR_TICKS_INCBY:
		{	
			/// Iris 5/17/2012 ORG-5528-S5 MOVE_TICKS_COUNT_NODES_TO_TICKS_BRANCH_FOR_GL_GRAPH
			//_update_controls_by_scale_increment_by_change(trEditBranch);			
			UpdateControlsByIncrementByChange(trEditBranch);
			///End MOVE_TICKS_COUNT_NODES_TO_TICKS_BRANCH_FOR_GL_GRAPH			
			bNeedToUpdateGUI = true;						
		}		
		break;
		
	/// Iris 9/29/2011 ORG-3921-P1 FIX_BAD_INIT_VALUE_FOR_LOG_TYPE_SCALE
	case OTID_AXIS_SCALE_FROM:
	case OTID_AXIS_SCALE_TO:
		{
			if( _is_log_type(trEditBranch.Type.nVal) )
				_check_correct_scale_value_for_log_type(trEditNode);
		}
		break;	
	///End FIX_BAD_INIT_VALUE_FOR_LOG_TYPE_SCALE
		
	case OTID_AXIS_SCALE_TYPE:
		{
			/// Iris 5/17/2012 ORG-5528-S5 MOVE_TICKS_COUNT_NODES_TO_TICKS_BRANCH_FOR_GL_GRAPH
			//_update_controls_by_scale_type_change(trEditBranch);
			for(int nn = 0; nn < m_vnChangedAxes.GetSize(); ++nn)
			{
				int nAxis = m_vnChangedAxes[nn];
				TreeNode trGetNOneAxis = GetGetNAxisNode(nAxis);
				/// Iris 9/14/2012 ORG-6834-P1 FIX_LOG_SCALE_TYPE_INCREMENT_ISSUES
				//UpdateControlsByScaleTypeChange(trGetNOneAxis, nAxis);
				UpdateControlsByScaleTypeChange(trGetNOneAxis, nAxis, false);
				///End FIX_LOG_SCALE_TYPE_INCREMENT_ISSUES
			}
			///End MOVE_TICKS_COUNT_NODES_TO_TICKS_BRANCH_FOR_GL_GRAPH
			bShowListContent = true;
			bNeedToUpdateGUI = true;			
		}
		break;
		
		/// Iris 8/19/2011 COMBINE_INCVALUE_AND_MAJORTICKSCOUNT_AS_ONE_CONTROL
		/*
	case OTID_AXIS_SCALE_INC_VALUE:
	case OTID_AXIS_SCALE_MAJOR_COUNT: 
		{			
			_update_controls_by_scale_increment_value_change(trEditBranch, trEditBranch.Value.Show, false);
			bNeedToUpdateGUI = true;
		}		
		break;
		*/
		/// Iris 5/17/2012 ORG-5528-S5 MOVE_TICKS_COUNT_NODES_TO_TICKS_BRANCH_FOR_GL_GRAPH
		/*
	case OTID_AXIS_SCALE_INC_VALUE:
		{			
			_update_controls_by_scale_increment_value_change(trEditBranch);			
			bNeedToUpdateGUI = true;			
		}		
		break;
		*/
	case OTID_AXIS_SCALE_INC_VALUE:
	case OTID_AXIS_SCALE_MAJOR_COUNT: 
		{
			// if updated inc value or tick count for Major Ticks
			for(int nn = 0; nn < m_vnChangedAxes.GetSize(); ++nn)
			{
				int nAxis = m_vnChangedAxes[nn];
				TreeNode trGetNOneAxis = GetGetNAxisNode(nAxis);			
				TreeNode trScale = trGetNOneAxis.Scale;						
				/// Iris 6/13/2012 ORG-5991 MOVE_TICKS_AND_LINE_BRANCH_INTO_AXIS_FORMAT_BRANCH
				//int nSubAxisIndex = GetSubAxisIndex(trEditNode);
				//TreeNode trGetNEditBranch = GetTicksCountParentNode(trGetNOneAxis, nAxis, nSubAxisIndex, true);
				TreeNode trGetNEditBranch = GetTicksCountParentNode(trGetNOneAxis, true);
				///End MOVE_TICKS_AND_LINE_BRANCH_INTO_AXIS_FORMAT_BRANCH
				ConvertIncrementValueAndTicksCount(trGetNEditBranch, trScale, nDataID);
			}
			bShowListContent = true;
			bNeedToUpdateGUI = true;
		}
		break;
		///End MOVE_TICKS_COUNT_NODES_TO_TICKS_BRANCH_FOR_GL_GRAPH
		///End COMBINE_INCVALUE_AND_MAJORTICKSCOUNT_AS_ONE_CONTROL
				
	case OTID_AXIS_SCALE_MINOR_COUNT:
	case OTID_AXIS_TICK_TYPE:		
	case OTID_AXIS_TICK_LENGTH:			
		//{		
			//// when change one control need to apply the related changes from GetN to Theme
			//for(int nn = 0; nn < m_vnChangedAxes.GetSize(); nn++)
			//{
				//int nAxis = m_vnChangedAxes[nn];
				//TreeNode trThemeAxis = GetThemeAxisNode(nAxis);
				//TreeNode trGetNAxis = GetGetNAxisNode(nAxis);
				//
				//if( trThemeAxis && trGetNAxis ) /// Iris 10/09/2011 UPDATED_AFTER_ROMAN_CHANGE_ABOUT_SPIDER_THEME_IMPROVE
				//{
					//bool bMajor = true;
					//if( nDataID == OTID_AXIS_SCALE_MINOR_COUNT )
						//bMajor = false;
					//else if( nDataID == OTID_AXIS_TICK_TYPE || nDataID == OTID_AXIS_TICK_LENGTH )
					//{						
						//bMajor = IsMajor(trEditBranch);
					//}		
										//
					//TreeNode trTicksSubBranch = GetTicksCountParentNode(trGetNAxis, bMajor);					
					//_update_controls_by_ticks_property_change(trThemeAxis, trGetNAxis, trTicksSubBranch, bMajor, false);					
					//bNeedToUpdateTheme = false;
				//}
			//}			
		//}
		break;
		
	case OTID_AXIS_GRID_SHOW:
	/// Iris 9/14/2012 ORG-6837-P1 TO_DISABLE_SUB_PROPERTIES_NODES_WHEN_SHOW_IS_UNCHECKED	
	/*	
	case OTID_AXIS_GRID_COLOR:
	case OTID_AXIS_GRID_STYLE:
	case OTID_AXIS_GRID_WIDTH:	
	*/
	DisablePropertiesNodeWhenShowNodeUnchecked(GetTree(), nDataID);
	bNeedToUpdateGUI = true;
	///End TO_DISABLE_SUB_PROPERTIES_NODES_WHEN_SHOW_IS_UNCHECKED
		///// Iris 5/15/2012 MAKE_MINOR_GRIDS_WORK_BOTH_FOR_RADAR_AND_GENERAL_GRAPH
		////if( trEditBranch.DataID == THEME_COLL_MEMBER_BRANCH(OTID_AXIS_GRID, 2) ) // is minor grid				
		///// Iris 6/04/2012 ORG-5528-P4 FIX_FAIL_TO_SHOW_MINOR_GRIDS
		////if( GetRepeatIndex(false) - 1 == GetSubAxisIndex(trEditNode) ) // false means minor grid
		//bool bIsMajor = IsMajor(trEditBranch);
		//if( !bIsMajor ) // the following only work on minor gird since the default value major already be OK.
		/////End FIX_FAIL_TO_SHOW_MINOR_GRIDS
		/////End MAKE_MINOR_GRIDS_WORK_BOTH_FOR_RADAR_AND_GENERAL_GRAPH
		//{
			//bool bDone = false;
			//for(int nn = 0; 0 == m_vnChangedAxes.GetSize() && !bDone || nn < m_vnChangedAxes.GetSize(); ++nn) // 0 == m_vnChangedAxes.GetSize() for Radar plot since this graph only one Grids branch for all axes
			//{
				//bDone = true;
				//int nAxis = 0 == m_vnChangedAxes.GetSize() ? 0 : m_vnChangedAxes[nn];			
				//
				//// before set Minor grid show need to make Scale.MinorTicksCount != 0 and MinorTick is show
				//TreeNode trThemeAxis = GetThemeAxisNode(nAxis); // Axes.All			
				//TreeNode trGetNAxis = GetGetNAxisNode(nAxis);	
				//
				//if( trThemeAxis && trGetNAxis )
				//{
					///// Iris 6/04/2012 ORG-5528-P4 FIX_FAIL_TO_SHOW_MINOR_GRIDS
					////_update_controls_by_ticks_property_change(trThemeAxis, trGetNAxis, false, true);
					///// Iris 6/13/2012 ORG-5991 MOVE_TICKS_AND_LINE_BRANCH_INTO_AXIS_FORMAT_BRANCH
					////TreeNode trTicksSubBranch = GetTicksCountParentNode(trGetNAxis, nAxis, GetSubAxisIndex(trEditNode), bIsMajor);
					//TreeNode trTicksSubBranch = GetTicksCountParentNode(trGetNAxis, bIsMajor);
					/////End MOVE_TICKS_AND_LINE_BRANCH_INTO_AXIS_FORMAT_BRANCH
					//_update_controls_by_ticks_property_change(trThemeAxis, trGetNAxis, trTicksSubBranch, bIsMajor, true);					
					/////End FIX_FAIL_TO_SHOW_MINOR_GRIDS
				//}
				//else
				//{
					//error_report("invalid Theme/GetN Axis node found.");					
				//}							
								//
				//if( OTID_AXIS_GRID_SHOW == trEditNode.DataID )
				//{
					//_set_change_bit(trEditBranch);
					//_set_change_bit(trEditBranch.Color);
					//_set_change_bit(trEditBranch.Style);
					//_set_change_bit(trEditBranch.Width);					
				//}				
			//}
		//}
		break;
	
	/// Iris 9/20/2011 APPLY_FOR_ALL_SHOULD_NOT_EFFECT_EACH_AXIS_SETTINGS
	/*
	/// Iris 8/18/2011 ORG-3297 SUPPORT_MORE_CHOICE_FOR_TICKLABEL_SHOW		
	case OTID_AXIS_LABEL_SHOW:
		if( m_bForAll )
		{
			nNeedApply = false;
			
			/// Iris 09/06/2011 ORG-3297-P2 FIX_SHOW_LABEL_FOR_ALL_AXES_NOT_WORK, all axes
			//TreeNode trGetNLabels = GetGetNAxisNode(0).Labels; // all axes labels
			TreeNode trGetNAxis = GetGetNAxisNode(0); 
			TreeNode trGetNLabels = trGetNAxis.Labels;
			///End FIX_SHOW_LABEL_FOR_ALL_AXES_NOT_WORK
			TreeNode trGetNLabelSubBranch = _get_GetN_node_by_id(trGetNLabels, trEditNode.Parent().DataID);			
			if( trGetNLabels && trGetNLabelSubBranch )
			{
				trGetNLabels.SetAttribute(STR_CHANGED_ATTRIB, 1);
				trGetNLabelSubBranch.SetAttribute(STR_CHANGED_ATTRIB, 1);
				
				/// Iris 09/06/2011 ORG-3297-P2 FIX_SHOW_LABEL_FOR_ALL_AXES_NOT_WORK
				//setThemeTickLabelShowForAllAxes(trGetNLabels, trGetNLabelSubBranch);
				setThemeTickLabelShowForAllAxes(trGetNAxis, trGetNLabels, trGetNLabelSubBranch);
				///End FIX_SHOW_LABEL_FOR_ALL_AXES_NOT_WORK
			}
		}
		break;
	///End SUPPORT_MORE_CHOICE_FOR_TICKLABEL_SHOW
	*/
	///End APPLY_FOR_ALL_SHOULD_NOT_EFFECT_EACH_AXIS_SETTINGS
	
	/// Iris 9/20/2011 ORG-3819-P4 FIX_MINOR_TICK_LABEL_SHOW_NOT_WORK
	/// Iris 11/09/2011 ORG-4268-P1 FIX_ONLY_SHOW_TICK_LABELS_FOR_1ST_AXIS_NOT_WORKED_FOR_MINOR_TICK_LABEL
	case ID_ONLY_SHOW_TICK_LABELS_FOR_1ST_AXIS:
	case OTID_AXIS_LABEL_SHOWLABEL:	
	///End FIX_ONLY_SHOW_TICK_LABELS_FOR_1ST_AXIS_NOT_WORKED_FOR_MINOR_TICK_LABEL
	case OTID_AXIS_LABEL_SHOW:		
		if( trEditBranch.DataID == THEME_COLL_MEMBER_BRANCH(OTID_AXIS_LABEL, 2) ) // is minor tick label branch
		{
			int nOldVal;
			if( trEditNode.GetAttribute(STR_CHANGED_ATTRIB, nOldVal) && 0 == nOldVal ) // to show, but the default value of MinorTicksCount is 0, so need to set as 1.
			{
				for(int nn = 0; nn < m_vnChangedAxes.GetSize(); nn++)
				{
					int nAxis = m_vnChangedAxes[nn];
					TreeNode trThemeAxis = GetThemeAxisNode(nAxis);
					TreeNode trGetNAxis = GetGetNAxisNode(nAxis);
										
					_set_change_bit(trGetNAxis.Scale);
					if( 0 == trGetNAxis.Scale.MinorTicksCount.nVal )
						trGetNAxis.Scale.MinorTicksCount.nVal = 1;					
					_set_change_bit(trGetNAxis.Scale.MinorTicksCount);
					//_copy_changed_node(trGetNAxis.Scale, trThemeAxis);
					Tree trJunk;
					_copy_changed_nodes(trGetNAxis.Scale, trThemeAxis, trJunk);
				}
			}
		}
		
		/// Iris 11/09/2011 ORG-4268-P1 FIX_ONLY_SHOW_TICK_LABELS_FOR_1ST_AXIS_NOT_WORKED_FOR_MINOR_TICK_LABEL
		if( checkSetOnlyOneTickLabelFor1stAxis() )			
			bNeedToUpdateTheme = false; // no need copy change from GetN to theme again.			
		///End FIX_ONLY_SHOW_TICK_LABELS_FOR_1ST_AXIS_NOT_WORKED_FOR_MINOR_TICK_LABEL		
		break;
	///End FIX_MINOR_TICK_LABEL_SHOW_NOT_WORK
	
	/// Iris 09/06/2011 ORG-3297-P1 FIX_LABEL_COLOR_CHANGED_WITH_LINE_COLOR_BUT_GUI_NOT_CHANGE
	case OTID_AXIS_TICK_COLOR:		
		int nAxis = GetAxisIndex(trEditNode);
		TreeNode trAxis = GetGetNAxisNode(nAxis);
		ASSERT(trAxis);		
		
		_set_label_auto_color_by_line_color(trEditNode, trAxis.Labels.MajorLabels.Color);		
		
		break;
	///End FIX_LABEL_COLOR_CHANGED_WITH_LINE_COLOR_BUT_GUI_NOT_CHANGE
	
	/// Iris 10/13/2011 ORG-3962-S1 IMPROVE_CUSTOM_DECIMAL_CONTROLS
	///// Iris 9/23/2011 ORG-3819-S1 SUPPORT_CUSTOM_DECIMAL_IN_SPIDER_PLOT_MORE
	//case OTID_AXIS_LABEL_MANUAL_DEC:
		//{
			//// update the left tree
			//for(int nn = 0; nn < m_vnChangedAxes.GetSize(); nn++)
			//{
				//int nAxis = m_vnChangedAxes[nn];
				//TreeNode trGetNAxis = GetGetNAxisNode(nAxis);
				//
				//if( trGetNAxis )
				//{
					///// Iris 9/29/2011 ORG-3819-S1 IMPROVE_CUSTOM_DECIAL_CONTROL
					///*
					//TreeNode trCustomDecimal = trGetNAxis.Labels.MajorLabels.CustomDecimal;
					//TreeNode trDecimalPlaces = trGetNAxis.Labels.MajorLabels.DecimalPlaces;
					//if( trCustomDecimal && !trCustomDecimal.IsEmpty() && trDecimalPlaces )
					//{
						//trDecimalPlaces.Enable = (1 == trCustomDecimal.nVal);						
						//bNeedToUpdateGUI = true;
						//dwUpdateBits |= DYNACONTROL_UPDATE_ENABLE;
					//}
					//*/
					////_enable_tick_label_decimal_places_control(trGetNAxis.Labels.MajorLabels.Format);
					/////End IMPROVE_CUSTOM_DECIAL_CONTROL
				//}
			//}
			//
			///// Iris 9/29/2011 ORG-3819-S1 IMPROVE_CUSTOM_DECIAL_CONTROL
			//// update the right GetN tree
			//_enable_tick_label_decimal_places_control(trEditBranch);
			//bNeedToUpdateGUI = true;
			//dwUpdateBits |= DYNACONTROL_UPDATE_ENABLE;
			/////End IMPROVE_CUSTOM_DECIAL_CONTROL
		//}
		//break;
	/////End SUPPORT_CUSTOM_DECIMAL_IN_SPIDER_PLOT_MORE
	///End IMPROVE_CUSTOM_DECIMAL_CONTROLS
	
	//case OTID_AXES_INDIVIDUALSCALE:
	//case OTID_AXES_CCW:
	//case OTID_AXIS_ANGLE:
		//TreeNode trThemeAxis = GetThemeAxisNode(-1);
		//TreeNode trThemeEditNode = tree_get_node_by_nodeid(trThemeAxis, trEditNode.DataID);
		//ASSERT(trThemeEditNode);
		//if( trThemeEditNode && trThemeEditNode.GetNodeCount() == 0 )
		//{
			//trThemeEditNode.strVal = trEditNode.strVal;
			//trThemeEditNode.SetAttribute(STR_CHANGED_ATTRIB, 1);
		//}
		//break;
	
	/// Iris 10/13/2011 ORG-3962-S1 IMPROVE_CUSTOM_DECIMAL_CONTROLS			
	case OTID_AXIS_LABEL_MANUAL_DEC:
		for(int nn = 0; nn < m_vnChangedAxes.GetSize(); nn++)
		{
			int nAxis = m_vnChangedAxes[nn];
			TreeNode trThemeAxis = GetThemeAxisNode(nAxis);
			TreeNode trGetNAxis = GetGetNAxisNode(nAxis);			
			
			int nCheck;
			TreeNode trCustomDecimal = trGetNAxis.Labels.MajorLabels.Format.CustomDecimal;				
			/// Iris 6/06/2012 ORG-5528-P17 SUPPORT_CUSTOM_DECIMAL_IN_3DGL_GRAPH
			if( !trCustomDecimal )
				break;
			///End SUPPORT_CUSTOM_DECIMAL_IN_3DGL_GRAPH			
			trCustomDecimal.GetAttribute(STR_ATTRIB_DYNACONTROL_USE_CHECK, nCheck);
						
			// if there is no labels property in All branch, copy from NewAxis1 branch
			TreeNode trThemeCustomDecimal = trThemeAxis.Labels.MajorLabels.CustomDecimal;
			if( !trThemeCustomDecimal && -1 == nAxis ) // All branch
			{
				TreeNode trThemeAxis1 = GetThemeAxisNode(0);
				/// Iris 11/11/2011 ORG-3962-P4 FIX_SET_CUSTOM_FORMAT_RUNTIME_ERROR
				/*
				TreeNode trLabels = trThemeAxis.AddNode("Labels");
				trLabels.Replace(trThemeAxis1.Labels.Clone());
				trThemeCustomDecimal = trThemeAxis.Labels.MajorLabels.CustomDecimal;
				*/
				if( !trThemeAxis.Labels )
				{
					trThemeAxis.AddNode("Labels", trGetNAxis.Labels.DataID);
				}				
				if( !trThemeAxis.Labels.MajorLabels )
				{
					trThemeAxis.Labels.AddNode("MajorLabels", trGetNAxis.Labels.MajorLabels.DataID);					
				}				
				trThemeCustomDecimal = trThemeAxis.Labels.MajorLabels.AddNode("CustomDecimal", trCustomDecimal.DataID);
				///End FIX_SET_CUSTOM_FORMAT_RUNTIME_ERROR
			}
			
			if( trThemeCustomDecimal.IsEmpty() || trThemeCustomDecimal.nVal != nCheck )
			{				
				_set_value_with_change_bit(trThemeCustomDecimal, nCheck);
			}
			
			if( !trCustomDecimal.IsEmpty() )
			{
				/// Iris 11/10/2011 ORG-3962-S2 IMPROVE_CUSTOM_DECIMAL_CONTROL
				/*
				TreeNode trThemeDecimalPlaces = trThemeAxis.Labels.MajorLabels.DecimalPlaces;
				if( !trThemeDecimalPlaces )
				{
					trThemeAxis.Labels.MajorLabels.DecimalPlaces.ID = OTID_AXIS_LABEL_DEC_DIGITS;
					trThemeDecimalPlaces = trThemeAxis.Labels.MajorLabels.DecimalPlaces;
				}
				
				trThemeDecimalPlaces.strVal = trCustomDecimal.strVal;
				trThemeDecimalPlaces.SetAttribute(STR_CHANGED_ATTRIB, 1);				
				*/
				TreeNode trThemeCustomFormat = trThemeAxis.Labels.MajorLabels.CustomFormat;
				if( !trThemeCustomFormat )
				{
					trThemeAxis.Labels.MajorLabels.CustomFormat.ID = OTID_AXIS_LABEL_CUSTOM_FORMAT;
					trThemeCustomFormat = trThemeAxis.Labels.MajorLabels.CustomFormat;
				}				
				trThemeCustomFormat.strVal = trCustomDecimal.strVal;
				if( trThemeCustomFormat.strVal.Find(',') >= 0 )
					trThemeCustomFormat.strVal.Replace(',', '.'); 				
				_set_change_bit(trThemeCustomFormat);
				///End IMPROVE_CUSTOM_DECIMAL_CONTROL
			}			
		}
		bNeedToUpdateTheme = false; // no need copy change from GetN to theme again.		
		/// Iris 11/10/2011 ORG-3962-S2 IMPROVE_CUSTOM_DECIMAL_CONTROL		
		trEditNode.RemoveAttribute(STR_CHANGED_ATTRIB); // remove changed attribute from GUI tree to avoid apply the change in next time				
		///End IMPROVE_CUSTOM_DECIMAL_CONTROL
		break;
	///End IMPROVE_CUSTOM_DECIMAL_CONTROLS	
	
	/// Iris 11/09/2011 ORG-4268-P1 FIX_ONLY_SHOW_TICK_LABELS_FOR_1ST_AXIS_NOT_WORKED_FOR_MINOR_TICK_LABEL
	/*
	/// Iris 11/03/2011 ORG-4268-S4 ADD_ONLY_SHOW_TICK_LABEL_ON_1ST_AXIS_CHECKBOX
	case ID_ONLY_SHOW_TICK_LABELS_FOR_1ST_AXIS:
	case OTID_AXIS_LABEL_SHOWLABEL:
		if( checkSetOnlyOneTickLabelFor1stAxis(nDataID) )
			bNeedToUpdateTheme = false; // no need copy change from GetN to theme again.
		break;
	///End ADD_ONLY_SHOW_TICK_LABEL_ON_1ST_AXIS_CHECKBOX
	*/
	///End FIX_ONLY_SHOW_TICK_LABELS_FOR_1ST_AXIS_NOT_WORKED_FOR_MINOR_TICK_LABEL
		
	/// Iris 2/06/2012 ORG-4218-P1 SUPPORT_TICK_LABEL_FORMAT_TYPE
	case OTID_AXIS_LABEL_TYPE:
	/// Iris 5/21/2012 ORG-4218-P5 ADD_DATETIME_CUSTOM_FORMAT_CONTROL
	case OTID_AXIS_LABEL_DATE:
	case OTID_AXIS_LABEL_TIME:
	case OTID_AXIS_LABEL_DATE_CUSTOM_DISPLAY:
	case OTID_AXIS_LABEL_TIME_CUSTOM_DISPLAY:
	///End ADD_DATETIME_CUSTOM_FORMAT_CONTROL
		TreeNode trDisplay;
		_ticklabel_type_event(trEditBranch, trEditBranch.Type, &trDisplay);		
		_set_change_bit(trDisplay);
		
		for(int nn = 0; nn < m_vnChangedAxes.GetSize(); ++nn)
		{
			int nAxis = m_vnChangedAxes[nn];
			TreeNode trGetNOneAxis = GetGetNAxisNode(nAxis);
			setScaleValueDisplayTypeWithTickLabelType(trGetNOneAxis, nAxis);
		}
		bNeedToUpdateGUI = true;		
		break;
	///End SUPPORT_TICK_LABEL_FORMAT_TYPE
		
	/// Iris 7/19/2012 ORG-6246-P1 SETUP_SCALE_DISPLAY_VALUE_ON_AFTER_DIVIDE_FACTOR_CHANGE
	case OTID_AXIS_LABEL_DIVIDE_BY_FACTOR:
		for(int nn = 0; nn < m_vnChangedAxes.GetSize(); ++nn)
		{
			int nAxis = m_vnChangedAxes[nn];
			int nSubAxis = GetSubAxisIndex(trEditNode);
			TreeNode trGetNOneAxis = GetGetNAxisNode(nAxis);
			setScaleValuesDivideFactor(trGetNOneAxis, nAxis, nSubAxis);
		}
		break;
	///End SETUP_SCALE_DISPLAY_VALUE_ON_AFTER_DIVIDE_FACTOR_CHANGE
	
	default:
		break;
	}
	
	/// Iris 5/03/2012 ORG-5528-S1 AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
	/*
	if( bNeedToUpdateGUI )
	{	
		/// Iris 9/29/2011 ORG-3819-S1 IMPROVE_CUSTOM_DECIAL_CONTROL
		//UpdateDynaControl(false, GETNEVENT_ON_CHANGE_UPDATE_GUI, false, dwUpdateBits);
		NiceUpdateDynaControl(true, GETNEVENT_ON_CHANGE_UPDATE_GUI, false, dwUpdateBits);
		///End IMPROVE_CUSTOM_DECIAL_CONTROL
	}
	*/
	stThemeUpdateInfo.bNeedToUpdateTheme = bNeedToUpdateTheme;	
	stThemeUpdateInfo.bNeedToUpdateGUI = bNeedToUpdateGUI;
	stThemeUpdateInfo.bShowListContent = bShowListContent;
	stThemeUpdateInfo.trEditNode = trEditNode;
	stThemeUpdateInfo.trEditBranch = trEditBranch;
	///End AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
}

/// Iris 09/06/2011 ORG-3297-P2 FIX_SHOW_LABEL_FOR_ALL_AXES_NOT_WORK
//void AxesControlSplitter::setThemeTickLabelShowForAllAxes(TreeNode& trGetNLabels, TreeNode& trGetNLabelSubBranch)
void AxesControlSplitter::setThemeTickLabelShowForAllAxes(TreeNode& trGetNAxis, TreeNode& trGetNLabels, TreeNode& trGetNLabelSubBranch)
///End FIX_SHOW_LABEL_FOR_ALL_AXES_NOT_WORK
{			
	TreeNode trGetNShow = trGetNLabelSubBranch.GetNode("Show");
	int nShow = trGetNShow.nVal;
	
	for(int nAxis = 0; nAxis < m_nNumAxes; nAxis++)
	{
		switch(nShow)
		{
		case LABEL_NONE:
			trGetNShow.nVal = 0;
			break;
			
		///Jasmine 09/13/2011 ORG-3297 USER_MAY_SHOW_OTHER_AXIS	
		//case LABEL_FIRST_AXIS_ONLY:
			//{
				//if(0 == nAxis)
					//trGetNShow.nVal = 1;
				//else
					//trGetNShow.nVal = 0;
				//break;
			//}
		///End USER_MAY_SHOW_OTHER_AXIS
		
		case LABEL_ALL_AXES:
			trGetNShow.nVal = 1;
			break;
		}		
		
		TreeNode trThemeAxis = GetThemeAxisNode(nAxis);
		/// Iris 09/06/2011 ORG-3297-P2 FIX_SHOW_LABEL_FOR_ALL_AXES_NOT_WORK
		/*
		if( trThemeAxis && trThemeAxis.Labels )
		{							
			_copy_changed_node(trGetNLabels, trThemeAxis.Labels);
		}
		*/
		TreeNode trJunk;
		//_copy_sub_nodes(trGetNAxis, trThemeAxis, trJunk);
		_copy_changed_nodes(trGetNAxis, trThemeAxis, trJunk);
		///End FIX_SHOW_LABEL_FOR_ALL_AXES_NOT_WORK
	}
	
	trGetNShow.nVal = nShow;
}

/// Iris 09/06/2011 ORG-3297-P3 FIX_GRID_FORMAT_FAIL_TO_WORK_WHEN_SELECT_MAJORGRIDLINE_IN_LEFT_PANEL
//void AxesControlSplitter::updateChangeFromGetNTreeToListTree(int nEditRow)
void AxesControlSplitter::updateChangeFromGetNTreeToListTree(int nEditRow, TreeNode& trListTreeSelectedNode)
///End FIX_GRID_FORMAT_FAIL_TO_WORK_WHEN_SELECT_MAJORGRIDLINE_IN_LEFT_PANEL
{
	TreeNode	trEdit = GetTree(); // the right GetN tree
	TreeNode	trEditNode = tree_get_node(trEdit, nEditRow);
	
	vector<uint> vnSelRows;
	if( !m_AxesGridTree.GetSelRows(vnSelRows) ) // get the selected rows from left tree view
	{
		ASSERT(0);
		return;
	}
	int 		n1stSelRow = vnSelRows[0];	
	
	/// Iris 8/01/2012 ORG-6270-S1 TO_REMOVE_HIDDEN_NODE_FROM_GETN_TO_IMPROVE_SPEED_OF_DYNATREE_REFRESH
	// apply changes from right GetN tree to left tree view and mark Change attribute for changed node	
	//if( 1 == vnSelRows.GetSize() )
	//{
		///// Iris 09/06/2011 ORG-3297-P3 FIX_GRID_FORMAT_FAIL_TO_WORK_WHEN_SELECT_MAJORGRIDLINE_IN_LEFT_PANEL
		///*
		//TreeNode trRow = GetTreeNode( n1stSelRow );
		//trRow.Replace( trEdit.Clone() );
		//*/
		//trListTreeSelectedNode = GetTreeNode( n1stSelRow );
		//trListTreeSelectedNode.Replace( trEdit.Clone() );		
		/////End FIX_GRID_FORMAT_FAIL_TO_WORK_WHEN_SELECT_MAJORGRIDLINE_IN_LEFT_PANEL
	//}
	//else
	//{
	///End TO_REMOVE_HIDDEN_NODE_FROM_GETN_TO_IMPROVE_SPEED_OF_DYNATREE_REFRESH	
		for(int index = 0; index < vnSelRows.GetSize(); index++)
		{
			TreeNode trRow = GetTreeNode(vnSelRows[index]);			
			/// Iris 09/06/2011 ORG-3297-P3 FIX_GRID_FORMAT_FAIL_TO_WORK_WHEN_SELECT_MAJORGRIDLINE_IN_LEFT_PANEL
			if( 0 == index )
				trListTreeSelectedNode = trRow; // just return the first selcted branch for multiple selection case
			///End FIX_GRID_FORMAT_FAIL_TO_WORK_WHEN_SELECT_MAJORGRIDLINE_IN_LEFT_PANEL		
			
			///Iris 6/25/2012 ORG-5991-S2 EXCHANGE_YAXIS_LEFT_AND_RIGHT_BRANCH_MORE
			// after exchange Right/Left sub branch for 3D Y axis, cannot simply copy values by dataid, need to get sub axis branch by GetColletionMemberBranchNode
			// this function do exchange for 3D Y axis to find sub axis branch.
			if( !trRow.SameForBoth )			
			{		
				/// Iris 7/12/2012 ORG-5991-P8 UPDATE_UNDEFINED_STATUS_AFTER_CHANGE_VALUE_WITH_SELECTED_MULTI_AXES
				//int num = octree_copy_values_by_id(&trEdit, &trRow, false, STR_DATAID_ATTRIB, STR_DATAID_ATTRIB);				
				//num = octree_copy_atts_by_id(&trEdit, &trRow, STR_CHANGED_ATTRIB, STR_DATAID_ATTRIB, STR_DATAID_ATTRIB);			
				_copy_values_for_changed_nodes(trEdit, trRow, true); // only to copy value for the changed node
				///End UPDATE_UNDEFINED_STATUS_AFTER_CHANGE_VALUE_WITH_SELECTED_MULTI_AXES
			}			
			else
			{		
				/// Iris 8/06/2012 ORG-6463-S1 ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
				// only primary axis can be edited, so only copy the primary axis barnch
				if( IsShowPrimaryAxesOnly() )
				{					
					int nAxis = GetAxisIndex(trRow, vnSelRows[index]);
					ASSERT( nAxis >= 0 && nAxis < m_nNumAxes );
					
					if( nAxis >= 0 && nAxis < m_nNumAxes )
					{
						int nPrimaryAxis = GetPrimarySecondaryAxisIndex(nAxis, true);
						TreeNode trPrimaryAxis = trRow.GetNode( getAxisSubBranchName(nAxis, nPrimaryAxis) );
						if( trPrimaryAxis )
						{							
							_copy_values_for_changed_nodes(trEdit, trPrimaryAxis, true);
						}
					}					
				}
				else
				{
				///End ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
				
				/// Iris 7/18/2012 ORG-5991-P10 FIX_PROPERTIES_IN_AXIS_FORMAT_NOT_WORK_WHEN_USE_SAME_OPTIONS_CHECKED_WITH_MULTI_AXES_SELECTED
				/*
				int nSubAxisIndex = 0;
				foreach(TreeNode trSubBranch in trRow.Children)
				{				
					TreeNode trEditSub;					
					if( trSubBranch.GetNodeCount() > 0 )
					{
						int nAxis = GetAxisIndex(trSubBranch);						
						/// Iris 7/13/2012 ORG-5991-P9 FIX_PROPERTY_IN_YAXIS_NOT_BE_CHANGED_WHEN_APPLY_CHANGES_WITH_SELECT_OTHERS
						//int nSubBranchID = GetColletionMemberBranchNode(_get_base_id(trSubBranch.DataID), _CHECK_CONVERT_SUB_AXIS_INDEX(nSubAxisIndex), nAxis);
						int nSubBranchID = GetColletionMemberBranchNode(_get_base_id(trSubBranch.DataID), _CHECK_CONVERT_SUB_AXIS_INDEX(nAxis, nSubAxisIndex), nAxis);
						///End FIX_PROPERTY_IN_YAXIS_NOT_BE_CHANGED_WHEN_APPLY_CHANGES_WITH_SELECT_OTHERS
						trEditSub = _get_GetN_node_by_id(trEdit, nSubBranchID);
						nSubAxisIndex++;
					}
					else
					{					
						trEditSub = _get_GetN_node_by_id(trEdit, trSubBranch.DataID);
					}						
					
					/// Iris 7/12/2012 ORG-5991-P8 UPDATE_UNDEFINED_STATUS_AFTER_CHANGE_VALUE_WITH_SELECTED_MULTI_AXES
					//int num = octree_copy_values_by_id(&trEditSub, &trSubBranch, false, STR_DATAID_ATTRIB, STR_DATAID_ATTRIB);					
					//num = octree_copy_atts_by_id(&trEditSub, &trSubBranch, STR_CHANGED_ATTRIB, STR_DATAID_ATTRIB, STR_DATAID_ATTRIB);				
					_copy_values_for_changed_nodes(trEditSub, trSubBranch, true); // only to copy value for the changed node
					///End UPDATE_UNDEFINED_STATUS_AFTER_CHANGE_VALUE_WITH_SELECTED_MULTI_AXES
				}
				*/
					int nEditAxis = GetAxisIndex(trRow, n1stSelRow);				
					copyGetNChangedValuesByID(trEdit, trRow, nEditAxis);
					///End FIX_PROPERTIES_IN_AXIS_FORMAT_NOT_WORK_WHEN_USE_SAME_OPTIONS_CHECKED_WITH_MULTI_AXES_SELECTED
				}
			}
			///End EXCHANGE_YAXIS_LEFT_AND_RIGHT_BRANCH_MORE
		}
	/// Iris 8/01/2012 ORG-6270-S1 TO_REMOVE_HIDDEN_NODE_FROM_GETN_TO_IMPROVE_SPEED_OF_DYNATREE_REFRESH
	//}
	///End TO_REMOVE_HIDDEN_NODE_FROM_GETN_TO_IMPROVE_SPEED_OF_DYNATREE_REFRESH
}

// to get the index of the changed axes
bool AxesControlSplitter::GetChangedAxisIndices(TreeNode& trEditNode)
{		
	bool bIsAxesPropertyChanged = true;	
	/// Iris 11/04/2011 ORG-4017-P1 NEED_REFRESH_INCREMENT_VAL_AFTER_CHANGED_FROM_TO
	//m_vnChangedAxes.RemoveAll();	
	///End NEED_REFRESH_INCREMENT_VAL_AFTER_CHANGED_FROM_TO
	vector<uint> vnRows;
	m_AxesGridTree.GetSelRows(vnRows);
	
	for(int index = 0; index < vnRows.GetSize(); index++)
	{
		int nAxis = GetAxisIndex(trEditNode, vnRows[index]); // return -1 if the changed node not belong to axes
		if( nAxis >= 0 )
		{		
			if( m_bForAll )
				nAxis = -1;
			/// Iris 11/04/2011 ORG-4017-P1 NEED_REFRESH_INCREMENT_VAL_AFTER_CHANGED_FROM_TO
			//m_vnChangedAxes.Add(nAxis);
			if( -1 == nAxis )
			{
				m_vnChangedAxes.RemoveAll();
				m_vnChangedAxes.Add(nAxis);
				return bIsAxesPropertyChanged;
			}
			else
			{
				vector<uint> vn;
				if( m_vnChangedAxes.Find(MATREPL_TEST_EQUAL, nAxis, vn) <= 0 ) // if not in list
					m_vnChangedAxes.Add(nAxis);
			}
			///End NEED_REFRESH_INCREMENT_VAL_AFTER_CHANGED_FROM_TO
		}
		else
			bIsAxesPropertyChanged = false;
	}	
	return bIsAxesPropertyChanged;
}

// for Major/Minor case, nSubAxisIndex = 0 for Minor, = 1 for Major;
// for Bottom/Top case, nSubAxisIndex = 0 for Bottom (first sub axis for X), = 1 for Top (second sub axis for X).
// For Radar, nAxis always is -1.
int AxesControlSplitter::GetColletionMemberBranchNode(int nBaseID, int nSubAxisIndex, int nAxis/* = -1*/)
{
	return _get_collection_member_branch_id(nBaseID, m_nLayerType, nSubAxisIndex + 1, nAxis);
}

bool AxesControlSplitter::IsMajor(TreeNode& trBranch, int nParentID/* = -1*/)
{
	bool bMajor = false;
	int nRepeat;
	if( trBranch.GetAttribute(STR_REPEAT_ID_ATTRIB, nRepeat) )							
	{
		bMajor = (GetRepeatIndex(true) == nRepeat);
		return bMajor;
	}
	/// Iris 7/23/2012 ORG-6319-P1 FIX_AXES_DLG_RUNTIME_ERROR_IN_JOS
	/*
	else
	{
		string strLabel;
		if( trBranch.GetAttribute(STR_LABEL_ATTRIB, strLabel) && 0 == strLabel.Find(_L("Major")) )		
			bMajor = true;
	}
	*/
	else if( nParentID > 0 )
	{	
		string strMajorLabel;
		switch( nParentID )
		{
		case OTID_AXIS_GRIDS:		
			strMajorLabel = STR_MAJOR_GRIDS_LABEL;
			break;
			
		case OTID_AXIS_LABELS:
		case OTID_AXIS_LABEL:
			strMajorLabel = STR_MAJOR_TICK_LABELS_LABEL;
			break;		
			
		case OTID_AXIS_SCALE:
			strMajorLabel = STR_MAJOR_TICKS_LABEL;
			break;
		
		default:
			break;
		}
		
		string strLabel;
		if( trBranch.GetAttribute(STR_LABEL_ATTRIB, strLabel) && !strLabel.IsEmpty() )		
		{
			return ( 0 == strLabel.CompareNoCase(strMajorLabel) );
		}		
	}
	
	ASSERT(false);
	return error_report("Fail to check is major branch or not.");	
	///End FIX_AXES_DLG_RUNTIME_ERROR_IN_JOS
}

/// Iris 7/12/2012 ORG-5991-P8 UPDATE_UNDEFINED_STATUS_AFTER_CHANGE_VALUE_WITH_SELECTED_MULTI_AXES
void AxesControlSplitter::UpdateDynaControlOnChange()
{
	NiceUpdateDynaControl(true, GETNEVENT_ON_CHANGE_UPDATE_GUI, false, 0);		
}

void AxesControlSplitter::UpdateGetNTreeOnSelection(bool bRefreshGUI/* = true*/, bool bKeepBranchStatus/* = false*/)
{	
	GETN_TREE(trNewGetN)
	combineSelectedTreeNodes(trNewGetN);	

	// to update tree view
	if( trNewGetN )	
	{
		// to save the status of branch open/close from old GetN
		vector<byte> vbBranchCollapsed;
		bool bOnlyTopLevelIsBranch = false;
		int nBranchStatus;
		if( bKeepBranchStatus )
		{
			nBranchStatus = TREE_CTRL_VAR.GetCollapsed(vbBranchCollapsed, bOnlyTopLevelIsBranch);
		}
	
		if( !trNewGetN.FirstNode )
		{
			GETN_TREE(trEmptyGetN)
			GETN_STR(hits, "Empty", "Tips") GETN_HINT 
			trNewGetN.Replace(trEmptyGetN.Clone());
		}		
		
		SetInputTree(trNewGetN);
		
		if( bRefreshGUI )
		{			
			UpdateDynaControlOnChange();			
			
			// to apply the status of branch open/close to keep same as old GetN
			if( bKeepBranchStatus && nBranchStatus > 0 )
			{
				/// Iris 9/13/2012 ORG-6823-P1 FIX_AXES_DLG_REFRESH_ISSUE
				//TREE_CTRL_VAR.SetRedraw(FALSE);
				///End FIX_AXES_DLG_REFRESH_ISSUE
				TREE_CTRL_VAR.SetCollapsed(vbBranchCollapsed, bOnlyTopLevelIsBranch);
				/// Iris 9/13/2012 ORG-6823-P1 FIX_AXES_DLG_REFRESH_ISSUE
				//TREE_CTRL_VAR.SetRedraw(TRUE);
				///End FIX_AXES_DLG_REFRESH_ISSUE				
			}	
		}
	}	
}
///End UPDATE_UNDEFINED_STATUS_AFTER_CHANGE_VALUE_WITH_SELECTED_MULTI_AXES

/// Iris 09/06/2011 ORG-3297-P3 FIX_GRID_FORMAT_FAIL_TO_WORK_WHEN_SELECT_MAJORGRIDLINE_IN_LEFT_PANEL
// nSubBranchIndex, 0 = Bottom, 1 = Top for X; 0 = Left, 1 = Right for Y.
static TreeNode _tree_get_branch_node_by_base_id(TreeNode& tr, int nBaseID, bool bRecursive, int nRepeatIndex = -1)
{
	if( tr.GetNodeCount() > 0 && nBaseID == _get_base_id( tr.DataID ) ) // only check branch node
	{
		if( nRepeatIndex <= 0 )
			return tr;	
		else
		{			
			int nn = _get_enum_index_from_repeat_id(tr);
			if( nRepeatIndex == nn )
				return tr;
		}
	}		
	
	if( bRecursive )
	{
		foreach(TreeNode trN in tr.Children)
		{				
			TreeNode trFind = _tree_get_branch_node_by_base_id(trN, nBaseID, bRecursive, nRepeatIndex);
			if( trFind )
				return trFind;
		}
		
	}
	TreeNode trJunk;
	return trJunk; // if not found	
}
///End FIX_GRID_FORMAT_FAIL_TO_WORK_WHEN_SELECT_MAJORGRIDLINE_IN_LEFT_PANEL

/// Bill 10/19/2011 ORG-3747-P2 DETECT_UNDEFINE_CHANGE
void AxesControlSplitter::OnUndefineChange(int nRow, int nCol)
{
	/// Iris 10/20/2011 ORG-3747-P2 IMPROVE_UNDEFINE_CHANGE
	OnEditTreeAfterValueChange(nRow, 0);
	///End IMPROVE_UNDEFINE_CHANGE
}
/// End DETECT_UNDEFINE_CHANGE

void AxesControlSplitter::OnEditTreeAfterValueChange(int nRow, DWORD lParam)
{	
	if( !IsReady() )
		return;
	m_bEditTreeChanged = true;	

	TreeNode	trEditNode = tree_get_node(GetTree(), nRow);
	/// Iris 10/24/2011 ORG-3747-P2 IMPROVE_UNDEFINE_CHANGE_MORE
	//----- Iris 5/10/2012 the value of changed attribute is not useful, and sometime we need to find node by attribute with value, so need to keep the changed value is 1
	//string 		strOldVal;
	//if( !trEditNode.GetAttribute(STR_CHANGED_ATTRIB, strOldVal) )		
		_set_change_bit(trEditNode);
	//-----
	///End IMPROVE_UNDEFINE_CHANGE_MORE
	
	/// Iris 7/18/2012 ORG-5991-P10 FIX_PROPERTIES_IN_AXIS_FORMAT_NOT_WORK_WHEN_USE_SAME_OPTIONS_CHECKED_WITH_MULTI_AXES_SELECTED
	// moved from below
	bool bIsAxesPropertyChanged = GetChangedAxisIndices(trEditNode);
	///End FIX_PROPERTIES_IN_AXIS_FORMAT_NOT_WORK_WHEN_USE_SAME_OPTIONS_CHECKED_WITH_MULTI_AXES_SELECTED
	
	/// Iris 09/06/2011 ORG-3297-P3 FIX_GRID_FORMAT_FAIL_TO_WORK_WHEN_SELECT_MAJORGRIDLINE_IN_LEFT_PANEL
	// need call this method to update changes from right GetN Tree to left list tree
	TreeNode trListTreeSelectedNode;
	updateChangeFromGetNTreeToListTree(nRow, trListTreeSelectedNode);
	///End FIX_GRID_FORMAT_FAIL_TO_WORK_WHEN_SELECT_MAJORGRIDLINE_IN_LEFT_PANEL
	
	/// Iris 7/18/2012 ORG-5991-P10 FIX_PROPERTIES_IN_AXIS_FORMAT_NOT_WORK_WHEN_USE_SAME_OPTIONS_CHECKED_WITH_MULTI_AXES_SELECTED
	//bool bIsAxesPropertyChanged = GetChangedAxisIndices(trEditNode);
	///End FIX_PROPERTIES_IN_AXIS_FORMAT_NOT_WORK_WHEN_USE_SAME_OPTIONS_CHECKED_WITH_MULTI_AXES_SELECTED
	
	/// Iris 5/03/2012 ORG-5528-S1 AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
	//bool bNeedToUpdateTheme = false;	
	//updateOnAfterValueChange(nRow, bNeedToUpdateTheme); // keep put this function before applyAxisPropertyToThemeTree, since it will set changed attribute	
	ThemeUpdateInfo stUpdateThemeInfo;
	stUpdateThemeInfo.bNeedToUpdateTheme = false;
	UpdateOnAfterValueChange(nRow, stUpdateThemeInfo);
	if( stUpdateThemeInfo.bShowListContent )
	{
		/// Iris 7/12/2012 ORG-5991-P8 UPDATE_UNDEFINED_STATUS_AFTER_CHANGE_VALUE_WITH_SELECTED_MULTI_AXES
		//ShowListContent(-1, true, false);		
		UpdateGetNTreeOnSelection(false);
		///End UPDATE_UNDEFINED_STATUS_AFTER_CHANGE_VALUE_WITH_SELECTED_MULTI_AXES
	}
	/// Iris 7/12/2012 ORG-5991-P8 UPDATE_UNDEFINED_STATUS_AFTER_CHANGE_VALUE_WITH_SELECTED_MULTI_AXES
	/*
	if( stUpdateThemeInfo.bNeedToUpdateGUI )
	{		
		NiceUpdateDynaControl(true, GETNEVENT_ON_CHANGE_UPDATE_GUI, false, 0);		
	}
	*/
	if( stUpdateThemeInfo.bNeedToUpdateGUI || stUpdateThemeInfo.bShowListContent )
	{				
		UpdateDynaControlOnChange();
	}
	///End UPDATE_UNDEFINED_STATUS_AFTER_CHANGE_VALUE_WITH_SELECTED_MULTI_AXES
	
	bool bNeedToUpdateTheme = stUpdateThemeInfo.bNeedToUpdateTheme;
	///End AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
	
	/// Iris 09/06/2011 ORG-3297-P3 FIX_GRID_FORMAT_FAIL_TO_WORK_WHEN_SELECT_MAJORGRIDLINE_IN_LEFT_PANEL
	//updateChangeFromGetNTreeToListTree(nRow);
	updateChangeFromGetNTreeToListTree(nRow, trListTreeSelectedNode);
	///End FIX_GRID_FORMAT_FAIL_TO_WORK_WHEN_SELECT_MAJORGRIDLINE_IN_LEFT_PANEL
	
	// apply changes from dialog GetN tree to Theme tree
	if( bNeedToUpdateTheme )
	{
		if( bIsAxesPropertyChanged ) // the change is Axis related
		{
			ASSERT(m_vnChangedAxes.GetSize() > 0);
			for(int nn = 0; nn < m_vnChangedAxes.GetSize(); nn++)
			{
				TreeNode trThemeAxis = GetThemeAxisNode(m_vnChangedAxes[nn]);
				TreeNode trGetNAxis = GetGetNAxisNode(m_vnChangedAxes[nn]);
				applyAxisPropertyToThemeTree(trThemeAxis, trGetNAxis);
			}			
		}
		else
		{
			/// Iris 5/16/2012 ORG-5528-S3 ADD_AUTO_SHOWHIDE_AXES_FOR_GL_GRAPH
			// move into SpiderPlotAxesControlSplitter::ApplyOtherPropertiesToThemeTree function
			//vector<int> vnBranchDataID = {
				//OTID_AXIS_GRIDS,
				//IDBRANCH_MISC,//IDBRANCH_START_POSITION,
				//0
			//};
			//
			///// Iris 09/06/2011 ORG-3297-P3 FIX_GRID_FORMAT_FAIL_TO_WORK_WHEN_SELECT_MAJORGRIDLINE_IN_LEFT_PANEL
			///*
			//TreeNode trGetN = trEditNode;
			//while( trGetN.Parent() )
			//{
				//trGetN = trGetN.Parent();
				//
				//vector<uint> vn;
				//if( vnBranchDataID.Find(MATREPL_TEST_EQUAL, _get_base_id(trGetN.DataID), vn) > 0 )
					//break;					
			//}
			//*/
			//int nLevel = m_AxesGridTree.GetRowOutlineLevel(m_AxesGridTree.GetSelectedRow());
			//TreeNode trGetN = trListTreeSelectedNode;
			//
			//if( nLevel > LEVEL_GRIDS ) // get parent 
			//{			
				//while( trGetN )
				//{			
					//vector<uint> vn;
					//if( vnBranchDataID.Find(MATREPL_TEST_EQUAL, _get_base_id(trGetN.DataID), vn) > 0 )
						//break;					
					//
					//trGetN = trGetN.Parent();				
				//}
			//}
			//else if ( nLevel < LEVEL_GRIDS )
			//{
				//for(int nn = 0; nn < vnBranchDataID.GetSize(); nn++)
				//{
					//if( vnBranchDataID[nn] > 0 )
					//{
						//TreeNode trTemp = _tree_get_branch_node_by_base_id(trGetN, vnBranchDataID[nn], true);
						//if( trTemp )
						//{
							//trGetN = trTemp;
							//break;
						//}
					//}
				//}
			//}
			/////End FIX_GRID_FORMAT_FAIL_TO_WORK_WHEN_SELECT_MAJORGRIDLINE_IN_LEFT_PANEL
			//
			//if( trGetN && trGetN.DataID > 0 )
			//{
				//bool bNeedCopy = true; /// Iris 10/11/2011 UPDATED_AFTER_ROMAN_CHANGE_ABOUT_SPIDER_THEME_IMPROVE
				//TreeNode trThemeAxes = GetThemeAxisNode(-1); 
				//TreeNode trTheme;
				//switch(_get_base_id(trGetN.DataID))
				//{
				//case OTID_AXIS_GRIDS:
					//trTheme = tree_check_get_node(trThemeAxes, "Grids", THEME_COLL_BRANCH(OTID_AXIS_GRIDS));
//
					//break;
				//case IDBRANCH_MISC://OTID_START_POSITION:
					///// Iris 10/11/2011 UPDATED_AFTER_ROMAN_CHANGE_ABOUT_SPIDER_THEME_IMPROVE
					//// After Roman changed theme tree, the property nodes in All branch need OC level to construct,
					//// and the struct is diff in theme and GUI, no Start Position branch in theme.
					////trTheme = trThemeAxes;						
					//bNeedCopy = false; 
					///// Iris 11/04/2011 ORG-4268-S3 ADD_HIDE_1ST_TICK_LABELS_CHECKBOX
					//if( trEditNode.DataID == ID_HIDE_1ST_TICK_LABELS )
					//{
						//applyShowHide1stTickLabelOnEachAxis(trEditNode);
					//}
					/////End ADD_HIDE_1ST_TICK_LABELS_CHECKBOX
					//else
					//{
						//string strChange;
						//if( trEditNode.GetAttribute(STR_CHANGED_ATTRIB, strChange) )
						//{
							//TreeNode trTheme = tree_check_get_node(trThemeAxes, trEditNode.tagName, trEditNode.DataID, STR_CHANGED_ATTRIB, strChange);
							//trTheme.strVal = trEditNode.strVal;
						//}
					//}
					/////End UPDATED_AFTER_ROMAN_CHANGE_ABOUT_SPIDER_THEME_IMPROVE					
					//break;			
				//}
								//
				//if( bNeedCopy ) /// Iris 10/11/2011 UPDATED_AFTER_ROMAN_CHANGE_ABOUT_SPIDER_THEME_IMPROVE
				//{
					//TreeNode trJunk;
					//_copy_sub_nodes(trGetN, trTheme, trJunk); 
				//}				
			//}
			ApplyOtherPropertiesToThemeTree(trEditNode, trListTreeSelectedNode);
			///End ADD_AUTO_SHOWHIDE_AXES_FOR_GL_GRAPH
		}
	}
	
	// to set Apply button Enable status
	Window Wnd = GetParent();
	if(Wnd)
		Wnd.PostMessage(WM_USER_ON_EDIT_TREE_CHANGED);
}

bool AxesControlSplitter::applyAxisPropertyToThemeTree(TreeNode& trThemeAxis, TreeNode& trGetNAxis)
{	
/*
	TreeNode trGetNPropertyBranch = trEditNode.Parent();
	
	// to find the edit node to theme axis tree
	// if branch like Axis1.Line, not a repeat branch
	// repeat branch like Axis1.MajorTicks
	TreeNode trThemePropertyNode, trThemePropertyBranch;
	if( trGetNPropertyBranch )
	{
		trThemePropertyNode = _get_theme_node_by_id(trThemeAxis, trEditNode.DataID, true);		
		
		if( trThemePropertyNode && trGetNPropertyBranch.DataID > 0 && IS_THEME_COLL_MEMBER(trGetNPropertyBranch.DataID) )		
		{
			trThemePropertyBranch = trThemePropertyNode.Parent();
			while( trThemePropertyNode && trThemePropertyBranch && trThemePropertyBranch.DataID != trGetNPropertyBranch.DataID )
			{
				trThemePropertyBranch = trThemePropertyNode.Parent();
				trThemePropertyBranch = trThemePropertyBranch.NextNode; // go to the next branch node
				trThemePropertyNode = _get_theme_node_by_id(trThemePropertyBranch, trEditNode.DataID, true);				
			}
		}		
	}
	if( trThemePropertyNode )
	{
		trThemePropertyNode.strVal = trEditNode.strVal;
		trThemePropertyNode.SetAttribute(STR_CHANGED_ATTRIB, 1); // no need?
		return true;
	}	
	
	// if cannot find the edit node, move up to the previous level to find the parent in axis theme tree
	while ( trGetNPropertyBranch && trGetNPropertyBranch.DataID > 0 && !trThemePropertyBranch ) 
	{
		trGetNPropertyBranch.SetAttribute(STR_CHANGED_ATTRIB, 1); // set change attribute, let _copy_changed_node work
		trThemePropertyBranch = _get_theme_node_by_id(trThemeAxis, trGetNPropertyBranch.DataID, true);
		if( trThemePropertyBranch )
			break;
		
		if( !trGetNPropertyBranch.Parent() || trGetNPropertyBranch.Parent().DataID < 0 )
			break;
		trGetNPropertyBranch = trGetNPropertyBranch.Parent();		
	}	
	// if cannot find the property node/branch according to right panel GetN tree, then find it according to left panel tree view
	if( trGetNPropertyBranch && !trThemePropertyBranch && trGetNPropertyBranch.DataID != trThemeAxis.DataID ) 
	{
		int nLevel = m_AxesGridTree.GetRowOutlineLevel(nSelRow);
		int nTempRow = nSelRow;
		int nNodeDataID = trSelRow.DataID;		
		//while( nLevel > LEVEL_AXIS + 1)
		//if( trGetNPropertyBranch.DataID <= 0 )
			trGetNPropertyBranch = GetTreeNode(nSelRow);
		while( nLevel >= LEVEL_AXIS )
		{			
			trGetNPropertyBranch.SetAttribute(STR_CHANGED_ATTRIB, 1);
		
			int nParentRow = m_AxesGridTree.GetParent(nTempRow);
			trGetNPropertyBranch = GetTreeNode(nParentRow);
			if( !trGetNPropertyBranch )
				ASSERT(false);
			if( trGetNPropertyBranch )
			{
				trGetNPropertyBranch.SetAttribute(STR_CHANGED_ATTRIB, 1);
				nTempRow = nParentRow;
				nLevel--;
			}
			
			trThemePropertyBranch = _get_theme_node_by_id(trThemeAxis, trGetNPropertyBranch.DataID);
			if( trThemePropertyBranch )
				break;						
		}		
	}
	
	// copy the branch & leaf nodes that marked with Change attribute from GetN tree to Theme tree
	if( trThemePropertyBranch )
	{
		_copy_changed_node(trGetNPropertyBranch, trThemePropertyBranch);
	}
	else
	{
		_copy_changed_node(trGetNPropertyBranch, trThemeAxis);
	}
	*/		
	TreeNode trJunk;
	//_copy_sub_nodes(trGetNAxis, trThemeAxis, trJunk);	
	_copy_changed_nodes(trGetNAxis, trThemeAxis, trJunk);	
	
	//TreeNode trGUIType = _get_GetN_node_by_id(trGetNAxis, OTID_AXIS_LABEL_TYPE, true);
	//TreeNode trType = _get_theme_node_by_id(trThemeAxis, OTID_AXIS_LABEL_TYPE, true);
	//if( trGUIType && trType )
		//trType.nVal = _convert_ticklabel_gui_type(trGUIType.nVal);
	return true;	
}

static TreeNode _get_theme_node_by_id(TreeNode& trTheme, int nID, bool bRecursive = false)
{	
	return tree_get_node_by_id(trTheme, nID, bRecursive); 
}

static TreeNode _get_GetN_node_by_id(TreeNode& trGetN, int nDataID, bool bRecursive = false)
{
	return tree_get_node_by_dataid(trGetN, nDataID, bRecursive); 
}

static bool _is_user_defined_ID(int nID)
{
	return nID >= ID_USER_DEFINED_BEGIN;
}

/// Iris 7/12/2012 ORG-5991-P8 UPDATE_UNDEFINED_STATUS_AFTER_CHANGE_VALUE_WITH_SELECTED_MULTI_AXES
static void _copy_values_for_changed_nodes(const TreeNode& trSource, TreeNode& trDest, bool bCopyChangeAttrib = true)
{
	if( !trSource || !trDest )
		return;
	
	/// Iris 7/18/2012 ORG-5991-P10 FIX_PROPERTIES_IN_AXIS_FORMAT_NOT_WORK_WHEN_USE_SAME_OPTIONS_CHECKED_WITH_MULTI_AXES_SELECTED
	// octree_copy_values_by_id not take care left tree node.	
	if( 0 == trSource.GetNodeCount() && 0 == trDest.GetNodeCount() )
	{
		int nOld;
		if( trSource.DataID > 0 && trSource.DataID == trDest.DataID )
		{	
			int nShow;
			if( trSource.GetAttribute(STR_SHOW_ATTRIB, nShow) )
				trDest.SetAttribute(STR_SHOW_ATTRIB, nShow);
			
			string strVal;
			if( trSource.GetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, strVal) )
				trDest.SetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, strVal);
			
			if( trSource.GetAttribute(STR_CHANGED_ATTRIB, nOld) )
				_set_value_with_change_bit(trDest, trSource.strVal);
			return;
		}
	}
	///End FIX_PROPERTIES_IN_AXIS_FORMAT_NOT_WORK_WHEN_USE_SAME_OPTIONS_CHECKED_WITH_MULTI_AXES_SELECTED
	
	Tree trSourceTemp;
	trSourceTemp.Replace(trSource.Clone());
	int num = -1;
	num = octree_copy_atts_by_id(&trSourceTemp, &trDest, STR_SHOW_ATTRIB, STR_DATAID_ATTRIB, STR_DATAID_ATTRIB);	
	
	// to copy the values for changed nodes
	octree_delete_nodes_by_missing_attribute(&trSourceTemp, STR_CHANGED_ATTRIB, true, false, false);		
	num = octree_copy_values_by_id(&trSourceTemp, &trDest, false, STR_DATAID_ATTRIB, STR_DATAID_ATTRIB);				
	num = octree_copy_atts_by_id(&trSourceTemp, &trDest, STR_CHANGED_ATTRIB, STR_DATAID_ATTRIB, STR_DATAID_ATTRIB);	
	
}
///End UPDATE_UNDEFINED_STATUS_AFTER_CHANGE_VALUE_WITH_SELECTED_MULTI_AXES

/// Iris 7/12/2012 ORG-6198-P1 FIX_CUSTOM_DECIMAL_CANNOT_USE_SAME_OPTIONS_FOR_BOTTOM_AND_TOP_TO_SET_BOTH
static void _copy_custom_decimal_from_GetN_to_theme(TreeNode& trGetNCollBranch, TreeNode& trThemeCollBranch)
{
	bool bMajor = true;
	TreeNode trGetNCustomDecimal = bMajor ? trGetNCollBranch.MajorLabels.CustomDecimal : trGetNCollBranch.MinorLabels.CustomDecimal;
	if( trGetNCollBranch && trGetNCustomDecimal )
	{			
		int nCheck = -1;
		if( trGetNCustomDecimal.GetAttribute(STR_ATTRIB_DYNACONTROL_USE_CHECK, nCheck) )
		{	
			// CustomDecimal node
			TreeNode trThemeCustomDecimal = trThemeCollBranch.CustomDecimal;
			if( !trThemeCustomDecimal )
			{
				trThemeCollBranch.CustomDecimal.ID = OTID_AXIS_LABEL_MANUAL_DEC;
				trThemeCustomDecimal = trThemeCollBranch.CustomDecimal
			}
			else
			{
				if( nCheck != trThemeCollBranch.CustomDecimal.nVal )
				{										
					_set_value_with_change_bit(trThemeCollBranch.CustomDecimal, nCheck);				
				}
			}
			
			// CustomFormat node
			TreeNode trThemeCustomFormat = trThemeCollBranch.CustomFormat;
			if( !trThemeCustomFormat )
			{
				trThemeCollBranch.CustomFormat.ID = OTID_AXIS_LABEL_CUSTOM_FORMAT;
				trThemeCustomFormat = trThemeCollBranch.CustomFormat;				
			}				
			if( trThemeCustomFormat.IsEmpty() || trThemeCustomFormat.strVal != trGetNCustomDecimal.strVal )
			{							
				_set_value_with_change_bit(trThemeCustomFormat, trGetNCustomDecimal.strVal);
			}
			
			if( trThemeCustomFormat.strVal.Find(',') >= 0 )
				trThemeCustomFormat.strVal.Replace(',', '.'); 					
		}		
	}	
}
///End FIX_CUSTOM_DECIMAL_CANNOT_USE_SAME_OPTIONS_FOR_BOTTOM_AND_TOP_TO_SET_BOTH

//static void _copy_sub_nodes(const TreeNode& trGetN, TreeNode& trTheme, TreeNode& trTempGetN)
static void _copy_changed_nodes(const TreeNode& trGetN, TreeNode& trTheme, TreeNode& trTempGetN)
{
	ASSERT(trTheme);
	if( !trTheme )
		return;
	
	Tree tr;
	if( trGetN )
	{
		tr.Replace(trGetN.Clone());
		octree_delete_nodes_by_missing_attribute(&tr, STR_CHANGED_ATTRIB, true, false, false);
		trTempGetN = tr;	
		
		/// Iris 7/19/2012 ORG-5991-P12 USE_SAME_OPTIONS_FAIL_TO_WORK_ON_LINE_SHOW_AND_TICK_LABELS_SHOW
		TreeNode trSrcShow = _get_GetN_node_by_id(trTempGetN, ID_AXIS_FIRST_SHOW, true);
		if( !trSrcShow )
			trSrcShow = _get_GetN_node_by_id(trTempGetN, ID_AXIS_SECOND_SHOW, true);
		if( trSrcShow )
			trSrcShow.DataID = OTID_AXIS_TICK_SHOW;		
		///End USE_SAME_OPTIONS_FAIL_TO_WORK_ON_LINE_SHOW_AND_TICK_LABELS_SHOW
	} 
		
	foreach(TreeNode trGetNSub in trTempGetN.Children)	
	{	
		TreeNode trThemeSub;
		
		/// Iris 6/19/2012 ORG-5991-P5 FIX_CHANGE_RIGHT_TITLE_BUT_APPLY_CHANGE_TO_LEFT_TITLE
		//if( _is_user_defined_ID(trGetNSub.DataID) || trGetNSub.DataID <= 0 )
		WORD dwGetNBaseDataID = _get_base_id(trGetNSub.DataID);		
		if( _is_user_defined_ID(dwGetNBaseDataID) || trGetNSub.DataID <= 0 )
		///End FIX_CHANGE_RIGHT_TITLE_BUT_APPLY_CHANGE_TO_LEFT_TITLE
		{
			trThemeSub = trTheme;
		}
		else
		{		
			/// Iris 4/27/2012 ORG-5528-S1 AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
			//TreeNode trThemeSub = _get_theme_node_by_id(trTheme, trGetNSub.DataID);
			/*
			make change to let the following two cases work:
				case 1. in Rader plot theme tree
				Title (0x00000052)			
					->Color (0x00000075)
					
				case 2. in normal plot theme tree
				Titles (0x40000052)
					->Bottom Title (0x21110053)
						->Color (0x00000075)
			*/					
			trThemeSub = _get_theme_node_by_id(trTheme, trGetNSub.DataID);
			
			/// Iris 6/01/2012 ORG-5528-P1 FIX_TICK_LABEL_FONT_FAIL_TO_WORK
			if( !trThemeSub && trTempGetN.DataID > 0 )
			{
				WORD dwHi = HIWORD((DWORD)trGetNSub.DataID); // NOT collection branch or sub axis branch node, like Font(ID: 0x0000004c) node, the high word is 0.
				if( 0 == dwHi )
				{
					trThemeSub = _get_theme_node_by_id(trTheme, trGetNSub.DataID, true);					
				}				
			}
			///End FIX_TICK_LABEL_FONT_FAIL_TO_WORK
			
			/// Iris 9/26/2012 ORG-6970-P1 FIX_RADAR_CUSTOMIZE_TICK_LABELS_FAILED
			// Tested ORG-5991-P5, not reopen this problem after commented out the following.
			/*
			if( !trThemeSub )
			{				
				/// Iris 6/19/2012 ORG-5991-P5 FIX_CHANGE_RIGHT_TITLE_BUT_APPLY_CHANGE_TO_LEFT_TITLE
				//WORD dwBaseID = _get_base_id(trGetNSub.DataID);
				//ASSERT(dwBaseID > 0);
				//
				//if( dwBaseID > 0 )
				if( dwGetNBaseDataID > 0 )
				///End FIX_CHANGE_RIGHT_TITLE_BUT_APPLY_CHANGE_TO_LEFT_TITLE
				{
					int nRepeatID = 0;
					trGetNSub.GetAttribute(STR_REPEAT_ID_ATTRIB, nRepeatID); // repeat ID is 1 based.
					if( nRepeatID > 0 ) // is branch node
					{
						/// Iris 6/19/2012 ORG-5991-P5 FIX_CHANGE_RIGHT_TITLE_BUT_APPLY_CHANGE_TO_LEFT_TITLE
						//trThemeSub = _tree_get_branch_node_by_base_id(trTheme, dwBaseID, true, nRepeatID);
						trThemeSub = _tree_get_branch_node_by_base_id(trTheme, dwGetNBaseDataID, true, nRepeatID);
						///End FIX_CHANGE_RIGHT_TITLE_BUT_APPLY_CHANGE_TO_LEFT_TITLE
						
						if( !trThemeSub && trGetNSub.GetNodeCount() > 0 // if getn node is a branch, and cannot find this branch in theme, then to find the property node in theme
							/// Iris 8/22/2012 CHECK_CREATE_TITLE_OBJ
							// Title object cannot deleted with Del key. In theme tree, we will not give the total Titles->LeftTitle branch tree if deleted Y title.
							&& OTID_AXIS_TITLE != dwGetNBaseDataID ) 					
							///End CHECK_CREATE_TITLE_OBJ
						{
							trThemeSub = trTheme;
						}						
					}					
				}
			}			
			*/
			///End FIX_RADAR_CUSTOMIZE_TICK_LABELS_FAILED
			///End AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH		
			
		
			if( !trThemeSub )
			{
				trThemeSub = trTheme.AddNode("tmp");
				trThemeSub.Replace(trGetNSub.Clone(), false, false, true);
				/// Iris 11/04/2011 ORG-4268-S3 ADD_HIDE_1ST_TICK_LABELS_CHECKBOX
				//trThemeSub.ID = trGetNSub.DataID;			
				int nID;
				if( trGetNSub.GetAttribute(STR_DATAID_ATTRIB, nID) )
				{				
					trThemeSub.ID = nID;
				}
				else if( trGetNSub.GetAttribute(STR_ID_ATTRIB, nID) )
				{
					trThemeSub.ID = nID;
				}
				else
				{
					ASSERT(0);
				}
				///End ADD_HIDE_1ST_TICK_LABELS_CHECKBOX
			}
		
			if( trThemeSub )
			{			
				_set_change_bit(trThemeSub);
				if( 0 == trGetNSub.GetNodeCount() )
				{	
					ASSERT( 0 == trThemeSub.GetNodeCount() );
					if( 0 == trThemeSub.GetNodeCount() )
					{
						trThemeSub.strVal = trGetNSub.strVal; 
					}
				}
			}
		}
		
		if( trGetNSub.GetNodeCount() > 0 )
		{				
			TreeNode trJunk;
			//_copy_sub_nodes(trJunk, trThemeSub, trGetNSub);
			_copy_changed_nodes(trJunk, trThemeSub, trGetNSub);
		}
	}
}

static bool _copy_value_by_base_id_and_repeat_id(const TreeNode trSrc, TreeNode trDest)
{	
	if( !trSrc || !trDest )
		return false;
	
	if( trSrc.DataID != trDest.DataID )
	{
		if( _get_base_id(trSrc.DataID) != _get_base_id(trDest.DataID) )
			return false; 
	}	
	
	if( trSrc.GetNodeCount() > 0 )
	{
		foreach(TreeNode trSrcSub in trSrc.Children)
		{
			TreeNode trDestSub = _get_subnode_by_base_id_and_enum_id(trSrcSub, trDest);				
			_copy_value_by_base_id_and_repeat_id(trSrcSub, trDestSub ? trDestSub : trDest);
		}
	}
	else
	{
		ASSERT(0 == trDest.GetNodeCount());
		if( 0 == trDest.GetNodeCount() )
		{
			trDest.strVal = trSrc.strVal;
		}
	}
		
	return true;
}

static TreeNode _get_subnode_by_base_id_and_enum_id(const TreeNode trSrc, TreeNode trDest)
{
	int nBaseID = _get_base_id(trSrc.DataID);
	int nRepeatID = _get_enum_index_from_repeat_id(trSrc);	
	
	foreach(TreeNode trDestSub in trDest.Children)
	{
		int nDestRepeatID = _get_enum_index_from_repeat_id(trDestSub);	
		if( nBaseID == _get_base_id(trDestSub.DataID) && nDestRepeatID == nRepeatID )
			return trDestSub;
	}
	
	TreeNode trJunk;
	return trJunk; /// not found
}

static int _get_enum_index_from_repeat_id(const TreeNode trN)
{
	int nRepeatID = -1;
	if( !trN.GetAttribute(STR_REPEAT_ID_ATTRIB, nRepeatID) || nRepeatID < 0 )
		return -1;
	
	return 0x0F & (WORD)nRepeatID;
}

//static void _copy_changed_node(const TreeNode& trGetN, TreeNode& trTheme)
//{
	//if( !trGetN || !trTheme )
	//{
		//error_report("Found invalid input treenode in _copy_changed_node");
		//return;
	//}
	//
	//TreeNode trThemeSub;
	//if( trTheme.ID != trGetN.DataID )
	//{
		//int nChanged;
		//if( trGetN.GetAttribute(STR_CHANGED_ATTRIB, nChanged) ) 
		//{
			///// Iris 6/04/2012 ORG-5528-P4 FIX_FAIL_TO_SHOW_MINOR_GRIDS
			////trThemeSub = _get_theme_node_by_id(trTheme, trGetN.DataID, false);			
			//if( trGetN.DataID > 0 )
			//{
				//trThemeSub = _get_theme_node_by_id(trTheme, trGetN.DataID, false);
			//}
			//else
			//{
				//// There is NO DataID in Minor Ticks, Major Ticks branch node.
				//trThemeSub = trTheme; // continue to check sub nodes
			//}
			/////End FIX_FAIL_TO_SHOW_MINOR_GRIDS
			//
			//if( !trThemeSub )
			//{
				//trThemeSub = tree_check_get_node(trTheme, trGetN.tagName, trGetN.DataID);
				//trThemeSub.DataID = trGetN.DataID;
			//}
			//trThemeSub.SetAttribute(STR_CHANGED_ATTRIB, 1);
		//}
		//else
		//{
			//return;
		//}
	//}
	//else
	//{
		//trThemeSub = trTheme; // continue to check sub nodes
	//}	
//
	//// continue to check sub nodes
	//if( trThemeSub )	 
	//{
		//if( 0 == trGetN.GetNodeCount() ) // copy value for leaf node
		//{
			//ASSERT( 0 == trThemeSub.GetNodeCount() );
			//if( 0 == trThemeSub.GetNodeCount() )
				//trThemeSub.strVal = trGetN.strVal;
		//}
		//else
		//{
			//foreach(TreeNode trGetNSub in trGetN.Children)
			//{
				//_copy_changed_node(trGetNSub, trThemeSub);
			//}
		//}
	//}	
//}

TreeNode AxesControlSplitter::GetThemeAxisNode(int nAxis)
{
	TreeNode trAxis;
	/// Iris 4/27/2012 ORG-5528-S1 AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
	//TreeNode trAxes = m_trTheme.Root.TAG_AXES;
	TreeNode trAxes = getThemeAxesNode();
	///End AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
	
	/// Iris 10/15/2012 ORG-7148-P1 FIX_RUNTIME_TIME_WHEN_UNCHECK_USE_SAME_OPTIONS_FOR_BOTTOM_AND_TOP
	if( !trAxes )
		return trAxis;
	///End FIX_RUNTIME_TIME_WHEN_UNCHECK_USE_SAME_OPTIONS_FOR_BOTTOM_AND_TOP
		
	if( nAxis < 0 )	
	{
		/// Iris 10/09/2011 UPDATED_AFTER_ROMAN_CHANGE_ABOUT_SPIDER_THEME_IMPROVE
		trAxis = trAxes.TAG_ALLAXES;
		if( !trAxis )
		{
			/// Iris 4/27/2012 ORG-5528-S1 AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
			//trAxis = trAxes.AddNode("All", THEME_ALL_BRANCH(ID_AXIS));
			trAxis = trAxes.AddNode("All", THEME_ALL_BRANCH(getThemeAxisNodeID()));
			///End AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
		}
		return trAxis;
		///End UPDATED_AFTER_ROMAN_CHANGE_ABOUT_SPIDER_THEME_IMPROVE
	}
	else
	{
		/// RVD 9/21/2011 ORG-3685-p1 FIX_OLD_AXIS_UpdateThemeIDs
		/*
		switch(nAxis)
		{
		case 0:
			trAxis = trAxes.X;
			break;
			
		case 1:
			trAxis = trAxes.Y;
			break;
			
		case 2:
			trAxis = trAxes.Z;
			break;
			
		default:
			trAxis = trAxes.GetNode(_get_axis_node_name(nAxis));
			break;
		}
		*/
		/// Iris 4/27/2012 ORG-5528-S1 AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
		//trAxis = trAxes.GetNode(_get_axis_node_name(nAxis, TRUE));
		trAxis = trAxes.GetNode(getAxisNodeName(nAxis, TRUE));
		///End AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
		/// end FIX_OLD_AXIS_UpdateThemeIDs
	}
	return trAxis;
}

/// Iris 6/06/2012 ORG-5528-S3 TO_DISABLE_LINE_TITLE_TICKLABEL_SHOW_WHEN_AUTO_SHOW_HIDE_SELECTED
//TreeNode AxesControlSplitter::GetGetNAxisNode(int nAxis)
TreeNode AxesControlSplitter::GetGetNAxisNode(int nAxis, TreeNode *ptrGetN)
///End TO_DISABLE_LINE_TITLE_TICKLABEL_SHOW_WHEN_AUTO_SHOW_HIDE_SELECTED
{
	/// Iris 6/06/2012 ORG-5528-S3 TO_DISABLE_LINE_TITLE_TICKLABEL_SHOW_WHEN_AUTO_SHOW_HIDE_SELECTED
	//TreeNode tr = GetListTree();
	TreeNode tr = ptrGetN != NULL ? *ptrGetN : GetListTree();
	///End TO_DISABLE_LINE_TITLE_TICKLABEL_SHOW_WHEN_AUTO_SHOW_HIDE_SELECTED
	
	TreeNode trAxis;
	if( !tr )
		return trAxis; // when list tree not ready
		
	//TreeNode trAxes = tr.Axes.RadialAxis; /// Iris 9/28/2011 ORG-3962-S1 IMPROVE_AXIS_DLG_GUI	
	/// Iris 10/09/2011 UPDATED_AFTER_ROMAN_CHANGE_ABOUT_SPIDER_THEME_IMPROVE
	/*
	if( nAxis < 0 )
		nAxis = 0;
	*/
	if( m_bForAll )
		nAxis = 0;	
	///End UPDATED_AFTER_ROMAN_CHANGE_ABOUT_SPIDER_THEME_IMPROVE
	
	/// Iris 9/28/2011 ORG-3962-S1 IMPROVE_AXIS_DLG_GUI
	//TreeNode trAxis = trAxes.GetNode(_get_axis_node_name(nAxis));
	/// Iris 4/27/2012 ORG-5528-S1 AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
	//trAxis = tr.GetNode(_get_axis_node_name(nAxis));
	trAxis = tr.GetNode(getAxisNodeName(nAxis));
	///End AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
	///End IMPROVE_AXIS_DLG_GUI
	return trAxis;
}

// virtual
TreeNode AxesControlSplitter::GetGetNGridsNode(int nAxis/* = -1*/)
{
	TreeNode tr = GetListTree();	
	/// Iris 9/28/2011 ORG-3962-S1 IMPROVE_AXIS_DLG_GUI
	//return tr.Axes.RadialAxis.Grids;	
	return tr.Grids;
	///End IMPROVE_AXIS_DLG_GUI
}

static int _get_axis_index(LPCSTR lpcszAxisLabel)
{
	char czPrefix[20];
	int nNum = string_to_prefix_end_number(czPrefix, lpcszAxisLabel) - 1;		
	if( 0 == strcmp(czPrefix, "Axis") )
	{
		return nNum;
	}
	else
	{
		return -1;
	}
}

int AxesControlSplitter::GetAxisIndex(TreeNode& trEditNode, int nListSelRow)
{
	if( nListSelRow < 0 )
		nListSelRow = m_AxesGridTree.GetSelectedRow();
	int nLevel = m_AxesGridTree.GetRowOutlineLevel(nListSelRow);
	
	if( nLevel >= LEVEL_AXIS )
	{
		int nTempRow = nListSelRow, nParentRow;
		while( nLevel > LEVEL_AXIS )
		{			
			nParentRow = m_AxesGridTree.GetParent(nTempRow);
			nLevel = m_AxesGridTree.GetRowOutlineLevel(nParentRow);
			nTempRow = nParentRow;		
		}
		
		TreeNode trAxis = GetTreeNode(nTempRow);
		if( trAxis )
		{
			char czPrefix[20];
			return string_to_prefix_end_number(czPrefix, trAxis.tagName) - 1;		
		}
	}
	else
	{
		TreeNode trN = trEditNode;
		while( trN.Parent() )
		{
			/// Iris 7/20/2012 ORG-6270-S1 IMPROVE_TICK_LABELS_BRANCH_SPEED
			/*
			char czPrefix[20];
			int nNum = string_to_prefix_end_number(czPrefix, trN.Parent().tagName) - 1;		
			if( 0 == strcmp(czPrefix, "Axis") )
			{
				return nNum;
			}
			*/
			int nNum;
			if( (nNum = _get_axis_index(trN.Parent().tagName) ) >= 0 )
				return nNum;
			///End IMPROVE_TICK_LABELS_BRANCH_SPEED
			trN = trN.Parent();
		}
	}
	return -1;
}

bool AxesControlSplitter::IsXYY3DBarGraph()
{
	bool bIsXYY3DBar = false;
	if( m_gl )
	{		
		DWORD dw = m_gl.GetSystemParam(GLI_PCD_BITS);	
		if( O_GET_NBITS(dw, MASK_PCD_LAYER_BITS) == PCD_LAYER_3D_XYY )
			bIsXYY3DBar = true;			
	}
	return bIsXYY3DBar;
}

/// Iris 8/06/2012 ORG-6463-S1 ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
int AxesControlSplitter::GetPrimarySecondaryAxisIndex(int nAxis, bool bIsPrimary)
{
	/// Iris 8/20/2012 ORG-6463-P5 EXCHANGE_PRIMARY_AXIS_AND_SECONDARY_AXIS_FOR_Y
	//if( AXIS_Y == nAxis && !IsXYY3DBarGraph() )
	//	return bIsPrimary ? 1 : 0;
	///End EXCHANGE_PRIMARY_AXIS_AND_SECONDARY_AXIS_FOR_Y
	return bIsPrimary ? 0 : 1; 
}
///End ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX

void AxesControlSplitter::UpdateOnApplyForAllChanged()
{
	updateAxesTree(false);		
	m_bEditTreeChanged = false; // reset this status after reconstruct GetN
	m_vnChangedAxes.RemoveAll();
}

///Jasmine 09/13/2011 ORG-3297 SELECT_RELATIVE_NODES_TO_APPLY_SETTINGS_TO_MULTIP_AXES	
#define		ID_AXES_TREE_MENU_SEL_ALL		0x0001

BOOL AxesControlSplitter::OnShowMenu(UINT nResIDCtrl, int nx, int ny)
{
	if(GetMainPaneID() != nResIDCtrl)
		return TRUE;
		
	int nClickRow, nClickCol;
	m_AxesGridTree.GetMouseCell(nClickRow, nClickCol);
	if(0 <= nClickRow && GetSelectedRow() != nClickRow)
		m_AxesGridTree.SelRow(nClickRow);
	
	if(-1 == nClickRow || -1 == nClickCol)
		return FALSE;
	
	if( !IsSelectAxisSubNode() )
		return FALSE;
	
	Menu myMenu;
	myMenu.Add(_L("Select Others"), ID_AXES_TREE_MENU_SEL_ALL);
	
	int		nCmd = 0;
	myMenu.TrackPopupMenu(0, nx, ny, GetSafeHwnd(), &nCmd);
	switch ( nCmd )
	{
	case ID_AXES_TREE_MENU_SEL_ALL:	
		SelectRelativeNodes();
		break;
		
	default:
		break;
	}
	
	return TRUE;
}

bool AxesControlSplitter::IsSelectAxisSubNode()
{
	if(m_bForAll)
		return FALSE;
	
	vector<uint> vnSelRows;
	if(!m_AxesGridTree.GetSelRows(vnSelRows) || vnSelRows.GetSize() > 1)
		return FALSE;
	
	
	int 		nLevel	= m_AxesGridTree.GetRowOutlineLevel( vnSelRows[0] );	
	TreeNode 	trRow	= GetTreeNode( vnSelRows[0] );		
	TreeNode	trAxis;	
	switch(nLevel)
	{
	///Jasmine 09/15/2011 ORG-3297-S6 SIMPLIFY_AND_REMOVE_RIGHT_TREE_FOR_LOW_LEVEL_TN_ON_LEFT
	//case LEVEL_AXIS:
		//trAxis = trRow;
		//break;
	///End SIMPLIFY_AND_REMOVE_RIGHT_TREE_FOR_LOW_LEVEL_TN_ON_LEFT
	case LEVEL_AXIS_PROPERTY_BRANCH:
		trAxis = trRow.Parent();
		break;
	
	/// Iris 7/20/2012 ORG-6270-S1 IMPROVE_TICK_LABELS_BRANCH_SPEED
	case LEVEL_SUB_AXIS_BRANCH:
		TreeNode trPropertyBranch = trRow.Parent();
		if( trPropertyBranch )
			trAxis = trPropertyBranch.Parent();
		break;
	///End IMPROVE_TICK_LABELS_BRANCH_SPEED
	
	default:
		//ASSERT(nLevel < LEVEL_AXIS);///Jasmine 09/15/2011 ORG-3297-S6 SIMPLIFY_AND_REMOVE_RIGHT_TREE_FOR_LOW_LEVEL_TN_ON_LEFT
		return FALSE;
	}
	if(!trAxis || trAxis.tagName.Find("Axis") != 0)
		return FALSE;
	
	return TRUE;
}

void AxesControlSplitter::SelectRelativeNodes()
{	
	vector<uint> vnSelRows;
	if(!m_AxesGridTree.GetSelRows(vnSelRows) || vnSelRows.GetSize() < 1)
		return;
	int			nLevel	= m_AxesGridTree.GetRowOutlineLevel( vnSelRows[0] );
	TreeNode 	trNode	= GetTreeNode( vnSelRows[0] );

	
	vector<uint> vnRows;
	
	string strLabel;
	trNode.GetAttribute(STR_LABEL_ATTRIB, strLabel);
	
	/// Iris 7/20/2012 ORG-6270-S1 IMPROVE_TICK_LABELS_BRANCH_SPEED		
	int nSubAxis = -1;
	TreeNode trPropertyBranch = trNode.Parent();
	string strPropertyBranchLabel;	
	if( LEVEL_SUB_AXIS_BRANCH == nLevel )
	{
		// the label of sub axis for 3D graph XYZ axis all are Primary/Secondary, so use the below way to get sub axis index now
		string strLabel;
		trNode.GetAttribute(STR_LABEL_ATTRIB, strLabel);		
		nSubAxis = 0 == strLabel.CompareNoCase( GetAxisSubBranchLabel(0, 0) ) ? 0 : 1;
		
		if( trPropertyBranch )	
			trPropertyBranch.GetAttribute(STR_LABEL_ATTRIB, strPropertyBranchLabel); // get the label of the parent of selected node	
	}
	///End IMPROVE_TICK_LABELS_BRANCH_SPEED
		
	TreeNode trList = GetListTree();
	/// Iris 9/28/2011 ORG-3962-S1 IMPROVE_AXIS_DLG_GUI
	//TreeNodeCollection trAxesColl(trList.Axes.RadialAxis, "Axis");
	TreeNodeCollection trAxesColl(trList, "Axis");
	///End IMPROVE_AXIS_DLG_GUI
	foreach(TreeNode trOneAxis in trAxesColl)
	{
		string strAxis;
		trOneAxis.GetAttribute(STR_LABEL_ATTRIB, strAxis);
		int nAxisRow = m_AxesGridTree.FindRow(strAxis); 
		if(nAxisRow < 0)
			continue;
		int nRow = nAxisRow;

		if(LEVEL_AXIS_PROPERTY_BRANCH == nLevel)		
		{
			int nFind = m_AxesGridTree.FindRow(strLabel, 0, true, true, nAxisRow); 
			//if( nFind <= nAxisRow || nFind > nAxisRow+trOneAxis.GetNodeCount() )
			if( nFind < 0 ) // not found
				continue;
			
			nRow = nFind;
			expandedRow(nRow);
		}
		/// Iris 7/20/2012 ORG-6270-S1 IMPROVE_TICK_LABELS_BRANCH_SPEED
		else if(LEVEL_SUB_AXIS_BRANCH == nLevel)
		{		
			if( trPropertyBranch )
			{			
				int nPropertyBranchRow = m_AxesGridTree.FindRow(strPropertyBranchLabel, 0, true, true, nAxisRow); 
				if( nPropertyBranchRow < 0 ) // not found
					continue;
				
				//expandedRow(nPropertyBranchRow);
				int nAxis = _get_axis_index(trOneAxis.tagName);
				/// Iris 8/02/2012 ORG-5991-P15 FIX_SELECT_OTHERS_BASED_ON_Y_SUB_AXIS_FAILED
				//int nFind = m_AxesGridTree.FindRow(GetAxisSubBranchLabel(nAxis, _CHECK_CONVERT_SUB_AXIS_INDEX(nAxis, nSubAxis)), 0, true, true, nPropertyBranchRow); 
				int nFind = m_AxesGridTree.FindRow(GetAxisSubBranchLabel(nAxis, nSubAxis), 0, true, true, nPropertyBranchRow); 
				///End FIX_SELECT_OTHERS_BASED_ON_Y_SUB_AXIS_FAILED
				if( nFind < 0 ) // not found
					continue;
				
				nRow = nFind;
				expandedRow(nRow);	
			}
		}			
		///End IMPROVE_TICK_LABELS_BRANCH_SPEED
		
		vnRows.Add(nRow);
	}
	
	SetReady(false);
	m_AxesGridTree.SelRows(vnRows);
	SetReady(true);
	/// Iris 7/12/2012 ORG-5991-P8 UPDATE_UNDEFINED_STATUS_AFTER_CHANGE_VALUE_WITH_SELECTED_MULTI_AXES
	//Control ctrl;
	//OnTreeViewSelectChange(ctrl);
	UpdateGetNTreeOnSelection(true);
	///End UPDATE_UNDEFINED_STATUS_AFTER_CHANGE_VALUE_WITH_SELECTED_MULTI_AXES
}
///End SELECT_RELATIVE_NODES_TO_APPLY_SETTINGS_TO_MULTIP_AXES

void AxesControlSplitter::setDefaultSelection()
{
	//---- CPY 10/04/2011 ORG-3732-s1 SPIDER_INDIVIDUAL_SCALE_SHOULD_BE_INSIDE_TREE
	//m_AxesGridTree.SetAllCollapsed();
	m_AxesGridTree.SetAllCollapsed(m_bForAll?false:true);
	//----
	
	// to set the default axis selection
	if( m_nDefaultAxis < 0 || m_nDefaultAxis >= m_nNumAxes )
		m_nDefaultAxis = 0; // the first axis
	int nActiveAxis = m_nDefaultAxis;
	if( m_bForAll )
		nActiveAxis = -1; // the Axes node	
	
	/// Iris 4/27/2012 ORG-5528-S1 AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
	//string strRowLable = (m_nDefaultObjectType == OKAXISDLG_GRIDLINE) ? _get_axis_object_name(OKAXISDLG_GRIDLINE) : _get_axis_label_name(nActiveAxis, m_gl);	
	string strRowLable = (m_nDefaultObjectType == OKAXISDLG_GRIDLINE) ? _get_axis_object_name(OKAXISDLG_GRIDLINE) : getAxisLabelName(nActiveAxis, m_gl);	
	///End AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
	int nRow = m_AxesGridTree.FindRow(strRowLable); // to find out AxisN(or Axes) branch or Grids branch
	if( nRow >= 0 )
	{
		// to find the default object in axis branch
		/*
		if( m_nDefaultObjectType >= 0 && m_nDefaultObjectType != OKAXISDLG_GRIDLINE)
		{				
			int nObjectRow = m_AxesGridTree.FindRow(_get_axis_object_name(m_nDefaultObjectType), 0, false, true, nRow);
			if( nObjectRow >= 0 )
				nRow = nObjectRow;
		}
		*/
		if( m_nDefaultObjectType >= 0 && m_nDefaultObjectType != OKAXISDLG_GRIDLINE)
		{
			/// Iris 6/08/2012 ORG-5930-P2 OPEN_AXIS_DIALOG_WHEN_SELECT_FROM_FORMAT_AXIS_TITLE
			//if( /*m_bForAll && */m_nDefaultObjectType == OKAXISDLG_SCALE && 0 != m_nLastTimeSelectedNodeDataID )
			/// Iris 6/13/2012 ORG-5930-P3 NOT_USE_LAST_TIME_SELECTED_OBJ_FOR_3D_GRAPH
			//if( (NEWAXESDLGCNTRL_FROM_DBCLICK & m_dwDlgOptions) && (m_nDefaultObjectType == OKAXISDLG_SCALE) && 0 != m_nLastTimeSelectedNodeDataID )
			if( m_bUseLastTimeSelected && (NEWAXESDLGCNTRL_FROM_DBCLICK & m_dwDlgOptions) && (m_nDefaultObjectType == OKAXISDLG_SCALE) && 0 != m_nLastTimeSelectedNodeDataID )
			///End NOT_USE_LAST_TIME_SELECTED_OBJ_FOR_3D_GRAPH
			///End OPEN_AXIS_DIALOG_WHEN_SELECT_FROM_FORMAT_AXIS_TITLE
			{				
				int nSelRow = getRowByDataID(m_nLastTimeSelectedNodeDataID, nRow);
				if( nSelRow > 0 )
					nRow = nSelRow;
			}
			else			
			{
				int nObjectRow = m_AxesGridTree.FindRow(_get_axis_object_name(m_nDefaultObjectType), 0, false, true, nRow);
				if( nObjectRow >= 0 )
					nRow = nObjectRow;
			}
		}		
		
		/// Iris 7/20/2012 ORG-6270-S1 IMPROVE_TICK_LABELS_BRANCH_SPEED
		// go to the secondary axis
		if( m_nDefaultSecondaryAxis >= 0 && nRow >= 0 )
		{
			TreeNode trRow = GetTreeNode(nRow);
			if( octree_count_items_by_attribute(&trRow, STR_SPECIALVALS_ATTRIB, NULL, false, false) > 0 )
			{
				/// Iris 8/02/2012 ORG-5991-S6 CHANGE_SUB_AXIS_LABEL_FOR_3DGL_GRAPH
				//int nSecondaryAxisRow = m_AxesGridTree.FindRow(getAxisSubBranchName(nActiveAxis, m_nDefaultSecondaryAxis, true), 0, false, true, nRow);
				int nSubAxis = AXIS_Y == nActiveAxis && IsExchangeYAxisSubAxis() ? !(bool)m_nDefaultSecondaryAxis : m_nDefaultSecondaryAxis;
				string strSubAxisBranchLabel = GetAxisSubBranchLabel(nActiveAxis, nSubAxis);
				int nSecondaryAxisRow = m_AxesGridTree.FindRow(strSubAxisBranchLabel, 0, false, true, nRow);
				///End CHANGE_SUB_AXIS_LABEL_FOR_3DGL_GRAPH
				if( nSecondaryAxisRow >= 0 && nSecondaryAxisRow <= nRow + trRow.GetNodeCount() )
					nRow = nSecondaryAxisRow;
			}
		}
		///End IMPROVE_TICK_LABELS_BRANCH_SPEED
		
		expandedRow(nRow);
		SelectRow(nRow);
	}		
}

void AxesControlSplitter::expandedRow(int nRow)
{
	int nTempRow = nRow, nParent = -1;
	while( (nParent = m_AxesGridTree.GetParent(nTempRow)) >= 0 )
	{
		m_AxesGridTree.SetIsCollapsed(nParent, flexOutlineExpanded);
		nTempRow = nParent;
	}	
}

void AxesControlSplitter::SetRowSelection(int nDataID, int nAxis)
{
	//---- CPY 10/04/2011 ORG-3732-s1 SPIDER_INDIVIDUAL_SCALE_SHOULD_BE_INSIDE_TREE
	//m_AxesGridTree.SetAllCollapsed();
	m_AxesGridTree.SetAllCollapsed(m_bForAll?false:true);
	//----
	
	/// Iris 8/06/2012 ORG-6463-S1 ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
	/*
		int nAxisRow = -1;
	if( !m_bForAll )
	{
		/// Iris 4/27/2012 ORG-5528-S1 AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
		//nAxisRow = m_AxesGridTree.FindRow(_get_axis_label_name(m_nDefaultAxis, m_gl)); 
		nAxisRow = m_AxesGridTree.FindRow(getAxisLabelName(m_nDefaultAxis, m_gl));
		///End AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
		
		// Iris: exist bug, need to check...
		if( OTID_RADIAL_AXIS != nDataID )
		{
			int nRow = getRowByDataID(THEME_COLL_BRANCH(OTID_AXIS_GRIDS));
			if( nRow >= 0 )
				expandedRow(nRow);
		}	
	}
	*/
	int nBaseID = _get_base_id(nDataID);
	
	vector<int> vnBranchIDsOutsideAxes;
	vector<uint> vn;
	if( GetOutsideAxisBranchNodeDataIDs(vnBranchIDsOutsideAxes) > 0 && vnBranchIDsOutsideAxes.Find(MATREPL_TEST_EQUAL, nBaseID, vn) > 0 )
	{
		int nRow = getRowByDataID(THEME_COLL_BRANCH(nBaseID));
		if( nRow >= 0 )
		{
			expandedRow(nRow);
			SelectRow(nRow);
			return;
		}
	}
	
	int nAxisRow = -1;
	if( !m_bForAll )
	{
		if( nAxis < 0 )
			nAxis = 0;
		nAxisRow = m_AxesGridTree.FindRow(getAxisLabelName(nAxis, m_gl));				
	}
	///End ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
	
	int nRow = getRowByDataID(nDataID, nAxisRow);
	if( nRow >= 0 )
	{
		expandedRow(nRow);
		SelectRow(nRow);
	}
}

int AxesControlSplitter::getRowByDataID(int nDataID, int nAxisRow)
{
	TreeNode tr;
	tr = GetListTree();
	
	TreeNode trNode = _get_GetN_node_by_id(tr, nDataID, true);
	if( trNode )
	{
		string strLabel;
		if( trNode.GetAttribute(STR_LABEL_ATTRIB, strLabel) )
		{
			int nRow = m_AxesGridTree.FindRow(strLabel, 0, false, true, nAxisRow);
			if( nRow > 0 )
				return nRow;
		}
	}
	return -1;
}
void AxesControlSplitter::updateAxesTree(bool bInitTime)
{	
   	Tree 		trGetN;   	
    bool bRet = constructGetN(trGetN);
    ASSERT(bRet);	
	
    // to save the currect selection
    int nSelNodeDataID = -1;
    int nSelRowAxisIndex = -1; /// Iris 8/06/2012 ORG-6463-S1 ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
    if( !bInitTime )
    {
    	nSelNodeDataID = GetRowID(); 
    	/// Iris 8/06/2012 ORG-6463-S1 ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
    	nSelRowAxisIndex = GetAxisIndex(NULL);
    	///End ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
    }
    
    // update GetN tree to dialog
    ///Jasmine 09/13/2011 ORG-3297-S6 HIDE_SUBNODE_TO_SAVE_PLACE
	//ShowList(trGetN.Clone(), ATRN_SKIP_LEAFS); // to update m_trsplitter tree	
	/// Iris 9/28/2011 ORG-3962-S1 IMPROVE_AXIS_DLG_GUI
	//ShowList(trGetN.Clone(), ATRN_SKIP_LEAFS|ATRN_STOP_LEVEL|3);
	//---- CPY 10/04/2011 ORG-3732-s1 SPIDER_INDIVIDUAL_SCALE_SHOULD_BE_INSIDE_TREE	
	//ShowList(trGetN.Clone(), ATRN_SKIP_LEAFS|ATRN_STOP_LEVEL|1);
	/// Iris 7/20/2012 ORG-6270-S1 IMPROVE_TICK_LABELS_BRANCH_SPEED
	//ShowList(trGetN.Clone(), ATRN_SKIP_LEAFS|ATRN_STOP_LEVEL|1, STR_SPECIALVALS_ATTRIB);
	/// Iris 8/06/2012 ORG-6463-S1 ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
	//ShowList(trGetN.Clone(), ATRN_SKIP_LEAFS|ATRN_LOOP_MARDED_NODE_ONLY, STR_SPECIALVALS_ATTRIB);	
	ShowList(trGetN.Clone(), GetListTreeDisplayCtrl(), STR_SPECIALVALS_ATTRIB);
	///End ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
	///End IMPROVE_TICK_LABELS_BRANCH_SPEED
	//----
	///End IMPROVE_AXIS_DLG_GUI
	///End HIDE_SUBNODE_TO_SAVE_PLACE		
	
	// set branch open and row selection status
	if( bInitTime )
	{
		applyIsUseSameOptionsForBothDirectionsSettings();
		setDefaultSelection();	
	}
	else
	{
		/// Iris 8/06/2012 ORG-6463-S1 ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
		//setSelection(nSelNodeDataID);
		SetRowSelection(nSelNodeDataID, nSelRowAxisIndex);
		///End ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
	}
	/// Iris 7/20/2012 ORG-6270-S1 IMPROVE_TICK_LABELS_BRANCH_SPEED
	UpdateTreeViewEnableSettings(GetListTree());
	///End IMPROVE_TICK_LABELS_BRANCH_SPEED
}

bool AxesControlSplitter::isOneGourpIDs(int nRepeatID1, int nRepeatID2)
{	
	if( nRepeatID1 == nRepeatID2 )
		return true;
	
	if( HIBYTE(nRepeatID1) == HIBYTE(nRepeatID2) )
		return true;
	return false;
}

bool AxesControlSplitter::isBranchWithRepeatNodes(int nRepeatID)
{
	return (nRepeatID == 0x4000);
}

int AxesControlSplitter::getRepeatIDFromParent(const TreeNode& trN)
{
	TreeNode trTemp = trN;
	TreeNode trParent = trTemp.Parent();
	int nRepeatID = 0;
	
	if( trParent.IsValid() )
	{
		if( 0 != (nRepeatID = getRepeatID(trParent)) )
			return nRepeatID;
		trTemp = trParent;
	}
	return nRepeatID;
}

/// Iris 7/20/2012 ORG-6270-S1 IMPROVE_TICK_LABELS_BRANCH_SPEED
static bool _is_axis_branch_node(TreeNode& trN)
{
	if( trN )
	{
		string strName = trN.tagName;
		
		char szBuffer[MAXLINE];
		int nn = string_to_prefix_end_number(szBuffer, strName);
		if( nn >= 1 && 0 == _stricmp(szBuffer, STR_AXIS) )
			return true;
	}
	return false;
}
///End IMPROVE_TICK_LABELS_BRANCH_SPEED

bool AxesControlSplitter::combineSelectedTreeNodes(TreeNode& trGetN)
{	
	vector<uint> vnRows;
	if( !m_AxesGridTree.GetSelRows(vnRows) )
		return false;	
		
	if( 1 == vnRows.GetSize() )
	{		
		TreeNode trRow = GetTreeNode(vnRows[0]);
		if( trRow )
		{
			/// Iris 7/20/2012 ORG-6270-S1 IMPROVE_TICK_LABELS_BRANCH_SPEED
			// no need to display the whole axis branch in right GetN tree view
			/// Iris 8/01/2012 ORG-6371-S1 ADD_USE_SAME_OPTIONS_FOR_BOTH_ON_EACH_AXIS_ROOT_NODE
			//if( _is_axis_branch_node(trRow) )			
				//return true;			
			///End ADD_USE_SAME_OPTIONS_FOR_BOTH_ON_EACH_AXIS_ROOT_NODE
			///End IMPROVE_TICK_LABELS_BRANCH_SPEED
			
			/// Iris 9/28/2011 ORG-3962-S1 IMPROVE_AXIS_DLG_GUI
			/*
			///Jasmine 09/15/2011 ORG-3297-S6 SIMPLIFY_AND_REMOVE_RIGHT_TREE_FOR_LOW_LEVEL_TN_ON_LEFT
			bool bShowEmpty = false;
			int nLevel = m_AxesGridTree.GetRowOutlineLevel( vnRows[0] );
			if(nLevel <= LEVEL_RADIAL_AXIS)
				bShowEmpty = true;
			else if(nLevel >= LEVEL_AXIS_PROPERTY_BRANCH)
				bShowEmpty = false;
			else if(nLevel == LEVEL_AXIS)
			{
				bShowEmpty = (trRow.tagName.Compare("StartPosition") != 0);
			}			
 
			if(bShowEmpty)
			{
				TreeNode trJunk = trGetN.AddNode();
				trJunk.Show = false;
			}
			else
			///End SIMPLIFY_AND_REMOVE_RIGHT_TREE_FOR_LOW_LEVEL_TN_ON_LEFT
			*/
			///End IMPROVE_AXIS_DLG_GUI
			/// Iris 7/20/2012 ORG-6270-S1 IMPROVE_TICK_LABELS_BRANCH_SPEED
				//trGetN = trRow;		
			//return true;		
			trGetN.Replace(trRow);
			///End IMPROVE_TICK_LABELS_BRANCH_SPEED			
		}
	}
	else
	{		
		Tree trGetNTemp;
		int nOldRow = -1;  /// Iris 9/21/2012 ORG-6910-P1 FIX_SEL_MULTIPLE_ROWS_ISSUE
		for(int index = 0; index < vnRows.GetSize(); index++)
		{			
			TreeNode trRow = GetTreeNode(vnRows[index]); 
			/// Iris 8/01/2012 ORG-6371-S1 ADD_USE_SAME_OPTIONS_FOR_BOTH_ON_EACH_AXIS_ROOT_NODE
			///// Iris 7/20/2012 ORG-6270-S1 IMPROVE_TICK_LABELS_BRANCH_SPEED			
			//// no need to display the whole axis branch in right GetN tree view
			//if( _is_axis_branch_node(trRow) )
				//return true;
			/////End IMPROVE_TICK_LABELS_BRANCH_SPEED
			///End ADD_USE_SAME_OPTIONS_FOR_BOTH_ON_EACH_AXIS_ROOT_NODE
						
			if( 0 == index )
			{
				trGetNTemp.Replace( trRow.Clone() );
				/// Iris 9/21/2012 ORG-6910-P1 FIX_SEL_MULTIPLE_ROWS_ISSUE
				nOldRow = vnRows[index];
				///End FIX_SEL_MULTIPLE_ROWS_ISSUE
			}
			else
			{
				/// Iris 9/21/2012 ORG-6910-P1 FIX_SEL_MULTIPLE_ROWS_ISSUE
				if( m_AxesGridTree.GetRowOutlineLevel(nOldRow) != m_AxesGridTree.GetRowOutlineLevel(vnRows[index]) 
					|| m_AxesGridTree.GetRowOutlineLevel(nOldRow) == m_AxesGridTree.GetRowOutlineLevel(vnRows[index]) && _get_base_id(trGetNTemp.DataID) != _get_base_id(trRow.DataID) )
				{					
					trGetNTemp.Reset();
					break;
				}
				///End FIX_SEL_MULTIPLE_ROWS_ISSUE
					
				Tree trRowCopy;
				trRowCopy = trRow.Clone();
				const string strCompAttributeName = "NodeToCompare";
				octree_set_attribute_to_all_nodes(&trRowCopy, strCompAttributeName, "1");
				
				Tree trSameNodes;
				/// Iris 5/04/2012 ORG-5528-S1 FIX_TITLES_BRANCH_FAILED_TO_SELECT_OTHERS_IN_GENERAL_GRAPH
				//int	nDiff = trSameNodes.CreateDiff(trGetNTemp, trRowCopy, TRDIFF_CHK_ATTRIB);
				/* for general 2D/3D graph, 
				for X, Titles sub branch are:
					Bottom
					Top
				for Y, Titles sub branch are:
					Left
					Right
				for Z, Titles sub branch are:
					Front
					Back
				the sub branch tagName is diff, so add TRDIFF_BY_NODE_INDEX bit to compare by node order, else by tagName.
				*/
				const DWORD dwCompCntrl = TRDIFF_BY_NODE_INDEX;
				int	nDiff = trSameNodes.CreateDiff(trGetNTemp, trRowCopy, TRDIFF_CHK_ATTRIB|dwCompCntrl);
				///End FIX_TITLES_BRANCH_FAILED_TO_SELECT_OTHERS_IN_GENERAL_GRAPH
				
				if( nDiff > 0 && trSameNodes.FirstNode ) // if existed the same treenodes, just with the different atrribute - since "NodeToCompare" attribute only eixsts in trRowCopy
				{
					// compare again to check the different value and set the control as undefined values.
					Tree trDiffValues;
					/// Iris 5/04/2012 ORG-5528-S1 FIX_TITLES_BRANCH_FAILED_TO_SELECT_OTHERS_IN_GENERAL_GRAPH
					//nDiff = trDiffValues.CreateDiff(trSameNodes, trRow);
					nDiff = trDiffValues.CreateDiff(trSameNodes, trRow, dwCompCntrl);
					///End FIX_TITLES_BRANCH_FAILED_TO_SELECT_OTHERS_IN_GENERAL_GRAPH
					
					if( nDiff > 0 )
					{						
						octree_set_attribute_to_all_nodes(&trDiffValues, STR_ATTRIB_DYNACONTROL_UNDEFINED, "1");						
						int nRet = octree_copy_atts_by_id(&trDiffValues, &trSameNodes, STR_ATTRIB_DYNACONTROL_UNDEFINED, STR_DATAID_ATTRIB, STR_DATAID_ATTRIB);
					}
					
					TreeNode trCustomDecimalInRow = _get_GetN_node_by_id(trRowCopy, OTID_AXIS_LABEL_MANUAL_DEC, true);
					TreeNode trCustomDecimalInSameNodes = _get_GetN_node_by_id(trSameNodes, OTID_AXIS_LABEL_MANUAL_DEC, true);
					int nCheck1, nCheck2;
					if( trCustomDecimalInRow && trCustomDecimalInSameNodes 
						&& trCustomDecimalInRow.GetAttribute(STR_ATTRIB_DYNACONTROL_USE_CHECK, nCheck1) 
						&& trCustomDecimalInSameNodes.GetAttribute(STR_ATTRIB_DYNACONTROL_USE_CHECK, nCheck2) 
						&& nCheck1 != nCheck2 
					  )
					{
						// Iris, doing, wait for ORG-6453
						trCustomDecimalInSameNodes.SetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, "1");
					}
					
					trGetNTemp.Replace( trSameNodes.Clone() );
				}	
				else // no same nodes
				{
					trGetNTemp.Reset();
				}
				
				/// Iris 9/21/2012 ORG-6910-P1 FIX_SEL_MULTIPLE_ROWS_ISSUE
				nOldRow = vnRows[index];
				///End FIX_SEL_MULTIPLE_ROWS_ISSUE
			}
		}
		
		if( trGetNTemp )
		{
			trGetN.Replace(trGetNTemp.Clone());
			/// Iris 7/20/2012 ORG-6270-S1 IMPROVE_TICK_LABELS_BRANCH_SPEED
			//return true;
			///End IMPROVE_TICK_LABELS_BRANCH_SPEED
		}
	}	
	
	/// Iris 9/21/2012 ORG-6910-P1 FIX_SEL_MULTIPLE_ROWS_ISSUE
	if( 0 == trGetN.GetNodeCount() )
		return true;
	///End FIX_SEL_MULTIPLE_ROWS_ISSUE
	
	/// Iris 7/20/2012 ORG-6270-S1 IMPROVE_TICK_LABELS_BRANCH_SPEED
	//return false;
	// only show "Use Same Options for Bottom and Top" checkbox
	TreeNode trSameOptions = _get_GetN_node_by_id(trGetN, ID_SAME_FOR_BOTTOM_AND_TOP, false);
	if( trSameOptions )
	{
		/// Iris 8/06/2012 ORG-6463-S1 ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
		if( IsShowPrimaryAxesOnly() )
		{
			if( _is_axis_branch_node(trGetN) ) // if selected Axis branch 
			{
				foreach(TreeNode trSub in trGetN.Children)
				{
					if( trSub.GetNodeCount() > 0 
						|| trSub.DataID == ID_SAME_FOR_BOTTOM_AND_TOP
						|| trSub.ID == ONODETYPE_SEPARATOR 
					  )
					{
						trSub.Remove();
					}
				}
				return true;
			}
			else // only show properties under Primary branch 
			{				
				int nAxis = GetAxisIndex(trGetN);
				int nPrimaryAxis = GetPrimarySecondaryAxisIndex(nAxis, true);
				if( nPrimaryAxis >= 0 )
				{
					TreeNode trPrimaryAxis = trGetN.GetNode(getAxisSubBranchName(nAxis, nPrimaryAxis));
					if( trPrimaryAxis )
						trGetN = trPrimaryAxis;
				}
			}
		}
		else
		{
		///End ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
		
			foreach(TreeNode trSub in trGetN.Children)
			{
				/// Iris 8/08/2012 ORG-6463-S3 ADD_AXIS_SHOW_PROPERTY_IN_AXIS_ROOT_BRANCH
				//if( trSub.DataID != ID_SAME_FOR_BOTTOM_AND_TOP )
				if( trSub.GetNodeCount() > 0 )
				///End ADD_AXIS_SHOW_PROPERTY_IN_AXIS_ROOT_BRANCH
				{
					/// Iris 8/01/2012 ORG-6270-S1 TO_REMOVE_HIDDEN_NODE_FROM_GETN_TO_IMPROVE_SPEED_OF_DYNATREE_REFRESH
					//trSub.Show = false;
					trSub.Remove();
					///End TO_REMOVE_HIDDEN_NODE_FROM_GETN_TO_IMPROVE_SPEED_OF_DYNATREE_REFRESH
				}			
			}
		/// Iris 8/06/2012 ORG-6463-S1 ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
		}
		///End ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX		
	}
	
	/// Iris 9/14/2012 ORG-6837-P1 DISABLE_NODES_WHEN_SHOW_CHECKBOX_IS_UNCHECK
	DisablePropertiesNodeWhenShowNodeUnchecked(trGetN);
	///End DISABLE_NODES_WHEN_SHOW_CHECKBOX_IS_UNCHECK	
	
	// if "Use Same Options for Bottom and Top" checkbox is checked and selected Top branch, 
	// should disable all sub nodes to not allow editing.
	int nGetNEnable;
	/// Iris 8/01/2012 ORG-6371-S1 ADD_USE_SAME_OPTIONS_FOR_BOTH_ON_EACH_AXIS_ROOT_NODE
	//if( trGetN.GetAttribute(STR_ENABLE_ATTRIB, nGetNEnable) )
	if( trGetN.GetAttribute(STR_ENABLE_ATTRIB, nGetNEnable) && !_is_axis_branch_node(trGetN) )
	///End ADD_USE_SAME_OPTIONS_FOR_BOTH_ON_EACH_AXIS_ROOT_NODE
	{
		_set_enable_attribute(trGetN, nGetNEnable, true);
	}	
	return true;
	///End IMPROVE_TICK_LABELS_BRANCH_SPEED	
}

/// Iris 9/14/2012 ORG-6837-P1 DISABLE_NODES_WHEN_SHOW_CHECKBOX_IS_UNCHECK
void AxesControlSplitter::DisablePropertiesNodeWhenShowNodeUnchecked(TreeNode& trGetN, int nChangedShowID)
{
	const vector<uint> vnShowIDs = {
		OTID_AXIS_LABEL_SHOW, // major tick label show				
		OTID_LABEL_SHOW, // title show
		OTID_AXIS_GRID_SHOW, // grid line show
		ID_AXIS_FIRST_SHOW, // first axis show
		ID_AXIS_SECOND_SHOW // second axis show
	};	
	
	int nShowID;
	TreeNode trShow;
	if( -1 == nChangedShowID )
	{
		for(int index = 0; index < vnShowIDs.GetSize(); ++index)
		{
			trShow = _get_GetN_node_by_id(trGetN, vnShowIDs[index], true);
			if( trShow )
			{
				nShowID = vnShowIDs[index];
				break;
			}
		}
	}
	else // call the function from Show checkbox event
	{
		nShowID = nChangedShowID;
		trShow = _get_GetN_node_by_id(trGetN, nShowID, true);
	}
	
	if( !trShow )
		return;
	
	// when uncheck/check Show, at this moment the undefined attribute still not be removed, so when enter this function from Show checkbox event,
	// then no need to check undefined attribute, only check the value of checkbox.
	bool bCheckUndefinedAttrib = nChangedShowID == -1;
	
	if( IsShowPrimaryAxesOnly() || // Show checkbox directly under property branch, for example, Tick Labels, Line and Ticks
		OTID_AXIS_GRID_SHOW == nShowID ) 
	{			
		if( OTID_AXIS_GRID_SHOW == nShowID )
		{					
			foreach(TreeNode trSubGrids in trGetN.Children)
			{
				trShow = _get_GetN_node_by_id(trSubGrids, nShowID, false);
				if( trShow )
				{
					_set_enable_attribute_by_show_node(trSubGrids, trShow, bCheckUndefinedAttrib);
				}
			}					
		}
		else
		{	
			_set_enable_attribute_by_show_node(trGetN, trShow, bCheckUndefinedAttrib);
		}		
	}
	else // Show checkbox under sub axis branch, for example, Bottom, Top
	{
		// do nothing here for this case. check/uncheck Show checkbox will directly enable/disable Bottom/Top branch. 
		// Once setup the enable status for branch, the enable status of sub nodes will follow to keep consitent. 
		// see DisableSubAxisBranchWhenShowNodeUnchecked function below.
	}	
}

/// Iris 9/20/2012 ORG-6892-P1 IMPROVE_DISABLE_SUB_AXIS_BRANCH_CODES
void AxesControlSplitter::DisableSubAxisBranchWhenShowNodeUnchecked(TreeNode& trPropertyBranch, TreeNode& trShow, int nAxis, bool bIsPrimary)
{	
	// to enable/disable Bottom/Top branch refer to the Show check/uncheck status
	ASSERT( trPropertyBranch && trShow );
	if( trPropertyBranch && trShow )
	{
		string strName = getAxisSubBranchName(nAxis, bIsPrimary ? 0 : 1);
		TreeNode trSubAxisBranch = trPropertyBranch.GetNode(strName);		
		
		if( trSubAxisBranch ) // some branch not sub axis, ex. Grids
		{
			int nEnable;
			if( trShow.nVal && trSubAxisBranch.GetAttribute(STR_DISABLE_BY_USE_SAME_OPTIONS_ATTRIB, nEnable) )
			{				
				if( trSubAxisBranch.GetAttribute(STR_DISABLE_BY_SHOW_ATTRIB, nEnable) )
					trSubAxisBranch.RemoveAttribute(STR_DISABLE_BY_SHOW_ATTRIB);					
			}
			else
			{
				_set_enable_attribute_by_show_node(trSubAxisBranch, trShow, false, false);
				
				if( 0 == trShow.nVal )
					trSubAxisBranch.SetAttribute(STR_DISABLE_BY_SHOW_ATTRIB, 1);
				else
					trSubAxisBranch.RemoveAttribute(STR_DISABLE_BY_SHOW_ATTRIB);
			}
		}				
	}	
}
///End IMPROVE_DISABLE_SUB_AXIS_BRANCH_CODES

static void _set_enable_attribute_by_show_node(TreeNode& trGetN, TreeNode& trShow, bool bCheckUndefinedAttrib = false, bool bRecursive = true, bool bSkipShowNode = true)
{
	if( trGetN && trShow )
	{		
		int nUndefined;		
		int nEnable = trShow.nVal || bCheckUndefinedAttrib && trShow.GetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, nUndefined);		
		_set_enable_attribute(trGetN, nEnable, bRecursive);			
		
		if( bSkipShowNode )
		{
			_set_enable_attribute(trShow, 1, false); // Show checkbox always shoule be enable									
		}
	}
}
///End DISABLE_NODES_WHEN_SHOW_CHECKBOX_IS_UNCHECK

/// Iris 7/20/2012 ORG-6270-S1 IMPROVE_TICK_LABELS_BRANCH_SPEED
static void _set_enable_attribute(TreeNode& tr, int nEnable, bool bRecursive)
{
	if( bRecursive && tr.GetNodeCount() > 0 )
	{
		foreach(TreeNode trN in tr.Children)
		{
			_set_enable_attribute(trN, nEnable, bRecursive);
		}
	}
	else
	{
		/// Iris 9/19/2012 ORG-6880-P1 FIX_HINT_DISPLAY_AS_EDITABLE
		int nOld;
		if( !tr.GetAttribute(STR_ENABLE_ATTRIB, nOld) || nOld <= 1 )		
		///End FIX_HINT_DISPLAY_AS_EDITABLE
		{
			if( 1 == nEnable )
				tr.RemoveAttribute(STR_ENABLE_ATTRIB);
			else
				tr.Enable = nEnable;
		}
	}
}
///End IMPROVE_TICK_LABELS_BRANCH_SPEED

/*
int AxesControlSplitter::GetSelectedNodeDataID()
{
	int nRow = m_AxesGridTree.GetSelectedRow();
	TreeNode trRow = GetTreeNode(nRow);
	
	int nLevel = m_AxesGridTree.GetRowOutlineLevel(nRow);
	if( LEVEL_AXIS == nLevel && trRow.DataID == THEME_COLL_BRANCH(OTID_AXIS_GRIDS) )
	{
		return OKAXISDLG_GRIDLINE;
	}
	
	if( nLevel > LEVEL_AXIS_PROPERTY_BRANCH )
	{
		while ( nLevel > LEVEL_AXIS_PROPERTY_BRANCH )
		{
			nRow = m_AxesGridTree.GetParent(nRow);
			nLevel--;
		}
		trRow = GetTreeNode(nRow);
	}
	
	if( LEVEL_AXIS_PROPERTY_BRANCH == nLevel )
	{
		if( trRow.DataID == OTID_AXIS_SCALE )
			return OKAXISDLG_SCALE;
		if( trRow.DataID == THEME_COLL_BRANCH(OTID_AXIS_LABELS) )
			return OKAXISDLG_LABELSTYLE;
	}
	return -1;
}
*/
//---- CPY 10/04/2011 ORG-3732-s1 SPIDER_INDIVIDUAL_SCALE_SHOULD_BE_INSIDE_TREE
/*
/// RVD 9/21/2011 ORG-3732-s1 SPIDER_INDIVIDUAL_SCALE
void	AxesControlSplitter::SetAutoscaleAxesIndependently(BOOL bSet)
{
	m_bAutoscaleIndependently = bSet;
	m_bEditTreeChanged = TRUE;
}

BOOL	AxesControlSplitter::IsAutoscaleAxesIndependently()
{
	return m_bAutoscaleIndependently;
}
/// end SPIDER_INDIVIDUAL_SCALE
*/
//---- end SPIDER_INDIVIDUAL_SCALE_SHOULD_BE_INSIDE_TREE


//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////// SpiderPlotAxesControlSplitter ///////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

/// Iris 4/27/2012 ORG-5528-S1 AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
// virtual
void SpiderPlotAxesControlSplitter::constructGetNTrees(TreeNode& trGetN, int nNumAxes)
///End AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
{
	GETN_USE(trGetN)
	
	/// Iris 9/28/2011 ORG-3962-S1 IMPROVE_AXIS_DLG_GUI
	//GETN_BEGIN_BRANCH(Axes, STR_AXIS_LABEL) GETN_ID(ID_AXES)
	///End IMPROVE_AXIS_DLG_GUI
	//--- CPY 10/04/2011 ORG-3732-s1 SPIDER_INDIVIDUAL_SCALE_SHOULD_BE_INSIDE_TREE
	/*
	/// Iris 9/28/2011 ORG-3962-S1 IMPROVE_AXIS_DLG_GUI
	GETN_BEGIN_BRANCH(StartPosition, STR_ORIENTATION_LABEL) GETN_ID(OTID_START_POSITION)
		GETN_LIST(CCW, STR_DIRECTION_LABEL, 0, _L("Clockwise|Counter-Clockwise")) GETN_ID(OTID_AXES_CCW)
		GETN_COMBO(Angle, STR_ANGLE_LABEL, 90, "|0|45|90|180|270|360") GETN_ID(OTID_AXIS_ANGLE) 
	GETN_END_BRANCH(StartPosition)
	///End IMPROVE_AXIS_DLG_GUI
	*/
	//--- end SPIDER_INDIVIDUAL_SCALE_SHOULD_BE_INSIDE_TREE
		//GETN_BEGIN_BRANCH(RadialAxis, STR_RADIAL_AXIS_LABEL) GETN_ID(OTID_RADIAL_AXIS) /// Iris 9/28/2011 ORG-3962-S1 IMPROVE_AXIS_DLG_GUI
		
		/// Iris 4/27/2012 ORG-5528-S1 AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
		    //// Grids
			//GETN_BEGIN_BRANCH(Grids, STR_GRIDS_LABEL) GETN_ID_COLLECTION_BRANCH_EX(OTID_AXIS_GRIDS) GETN_MARK_STOP_BRANCH			
				//GETN_BEGIN_BRANCH(MajorGrids, STR_MAJOR_GRIDS_LABEL) GETN_ID_COLLECTION_MEMBER_REPEAT_BRANCH_EX(OTID_AXIS_GRID, 1) 
				//GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
					//constructGridPropertyNodes(_tmpNode, true);
				//GETN_END_BRANCH(MajorGrids)
				//
				//GETN_BEGIN_BRANCH(MinorGrids, STR_MINOR_GRIDS_LABEL) GETN_ID_COLLECTION_MEMBER_REPEAT_BRANCH_EX(OTID_AXIS_GRID, 2)
				//GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
					//constructGridPropertyNodes(_tmpNode, false);
				//GETN_END_BRANCH(MinorGrids)				
			//GETN_END_BRANCH(Grids)
		///End AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
		ConstructGridsBranchNodes(trGetN);
			
			// AxisN
			ConstructAllAxesPropertyNodes(_tmpNode, nNumAxes);			
		//GETN_END_BRANCH(RadialAxis) /// Iris 9/28/2011 ORG-3962-S1 IMPROVE_AXIS_DLG_GUI
		
		//--- CPY 10/04/2011 ORG-3732-s1 SPIDER_INDIVIDUAL_SCALE_SHOULD_BE_INSIDE_TREE
		// GETN_OPTION_SPECIALVALS("Junk") = GETN_MARK_STOP_BRANCH, will just add an attribute STR_SPECIALVALS_ATTRIB which we will use to indicate stop tree at that branch
		GETN_BEGIN_BRANCH(Misc, STR_MISC_BRANCH_LABEL) GETN_ID(IDBRANCH_MISC) GETN_MARK_STOP_BRANCH
			GETN_CHECK(IndepScales, STR_INDEP_SCALES, 0) GETN_ID(OTID_AXES_INDIVIDUALSCALE)
			/// Iris 11/03/2011 ORG-4268-S4 ADD_ONLY_SHOW_TICK_LABEL_ON_1ST_AXIS_CHECKBOX
			GETN_CHECK(TickLabelFor1stAxis, STR_ONLY_SHOW_TICK_LABELS_FOR_1ST_AXIS_LABEL, 1) GETN_ID(ID_ONLY_SHOW_TICK_LABELS_FOR_1ST_AXIS)
			setOnlyOneTickLabelFor1stAxisInitStatus(_tmpSubNode);
			if( !m_bForAll )
				_tmpSubNode.Enable = false;
			///End ADD_ONLY_SHOW_TICK_LABEL_ON_1ST_AXIS_CHECKBOX			
			GETN_CHECK(Hide1stTickLabels, STR_HIDE_1ST_TICK_LABELS_LABEL, 0) GETN_ID(ID_HIDE_1ST_TICK_LABELS) /// Iris 11/04/2011 ORG-4268-S3 ADD_HIDE_1ST_TICK_LABEL_CHECKBOX
			
			GETN_BEGIN_BRANCH(StartPosition, STR_ORIENTATION_LABEL) GETN_ID(OTID_START_POSITION) GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
				GETN_LIST(CCW, STR_DIRECTION_LABEL, 0, _L("Clockwise|Counter-Clockwise")) GETN_ID(OTID_AXES_CCW)
				GETN_COMBO(Angle, STR_ANGLE_LABEL, 90, "|0|45|90|180|270|360") GETN_ID(OTID_AXIS_ANGLE) 
			GETN_END_BRANCH(StartPosition)
		GETN_END_BRANCH(Misc)
		//--- end SPIDER_INDIVIDUAL_SCALE_SHOULD_BE_INSIDE_TREE
		
		/// Iris 9/28/2011 ORG-3962-S1 IMPROVE_AXIS_DLG_GUI
		/*
		GETN_BEGIN_BRANCH(CategoryAxis, STR_CATEGORY_AXIS_LABEL) GETN_ID(OTID_CATEGORY_AXIS)
			GETN_BEGIN_BRANCH(StartPosition, STR_START_POSITION_LABEL) GETN_ID(OTID_START_POSITION)
				GETN_LIST(CCW, STR_DIRECTION_LABEL, 0, _L("Clockwise|Counter-Clockwise")) GETN_ID(OTID_AXES_CCW)
				GETN_COMBO(Angle, STR_ANGLE_LABEL, 90, "|0|45|90|180|270|360") GETN_ID(OTID_AXIS_ANGLE) 
			GETN_END_BRANCH(StartPosition)				
		GETN_END_BRANCH(CategoryAxis)
		*/
		///End IMPROVE_AXIS_DLG_GUI

	//GETN_END_BRANCH(Axes) /// Iris 9/28/2011 ORG-3962-S1 IMPROVE_AXIS_DLG_GUI
}

// virtual
void SpiderPlotAxesControlSplitter::GetAxisPropertyCustomOptions()
{	
	m_stOptions.bIncAdditionalLines = false;
	/// Iris 6/13/2012 ORG-5991 MOVE_TICKS_AND_LINE_BRANCH_INTO_AXIS_FORMAT_BRANCH
	//m_stOptions.bIncAxisPosition = false;	
	//m_stOptions.bTickSettingsInScale = true;	
	//m_stOptions.bIncFirstTick = false;
	///End MOVE_TICKS_AND_LINE_BRANCH_INTO_AXIS_FORMAT_BRANCH
	m_stOptions.bIncTitleShow = true;
	m_stOptions.bIncTitleText = false;	
	m_stOptions.bIncBreak = false;	
}

// virtual
/// Iris 4/27/2012 ORG-5528-S1 AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
//void SpiderPlotAxesControlSplitter::ConstructOneAxisPropertyNodes(TreeNode& trAxis)
void SpiderPlotAxesControlSplitter::ConstructOneAxisPropertyNodes(TreeNode& trAxis, int nAxis)
///End AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
{	
	GETN_USE(trAxis)
	
	// Title
	/// Iris 4/28/2012 ORG-5528-S1 AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
	//{
		//GETN_BEGIN_BRANCH(Title, STR_TITLE_LABEL) GETN_ID(OTID_AXIS_TITLE)
			//GETN_CHECK(Show, STR_SHOW_LABEL, 1) GETN_ID(OTID_LABEL_SHOW)
			//GETN_COLOR(Color, STR_COLOR_LABEL, 0) GETN_ID(OTID_LABEL_COLOR) GETN_COLOR_CHOICE_OPTIONS(COLORLIST_SINGLE|COLORLIST_CUSTOM|COLORLIST_AUTO)
			//GETN_COMBO(Angle, STR_ANGLE_LABEL, 0, "|0|45|90|180|270") GETN_ID(OTID_LABEL_ANGLE)
			//
			//GETN_BEGIN_BRANCH(Dimension, STR_DIMENSION_LABEL) GETN_ID(OTID_LABEL_DIMENSION)
			//GETN_OPTION_BRANCH(GETNBRANCH_OPEN)	///Jasmine 09/15/2011 ORG-3297 EXPAND_AXIS_PROPERTY_BRANCH_SUBNODE
				//GETN_NUM(XOffset, STR_XOFFSET_LABEL, 0) GETN_ID(OTID_AXIS_TITLE_DIMENSION_XOFFSET)
				//GETN_NUM(YOffset, STR_YOFFSET_LABEL, 0) GETN_ID(OTID_AXIS_TITLE_DIMENSION_YOFFSET)
			//GETN_END_BRANCH(Dimension)
			//
			//GETN_BEGIN_BRANCH(Font, STR_FONT_LABEL) GETN_ID(OTID_LABEL_FONT)
			//GETN_OPTION_BRANCH(GETNBRANCH_OPEN)	///Jasmine 09/15/2011 ORG-3297 EXPAND_AXIS_PROPERTY_BRANCH_SUBNODE
				//GETN_FONT(Face, STR_FONT_LABEL, 0 )GETN_ID(OTID_LABEL_FONT_FACE)
				//GETN_COMBO(Size, STR_FONT_SIZE_LABEL, 26, "|8|9|10|11|12|14|16|18|20|22|24|26|28|36|48|72") GETN_ID(OTID_LABEL_FONT_SIZE)		
			//GETN_END_BRANCH(Font)				
		//GETN_END_BRANCH(Title)
	//}		
	ConstructTitleBranchNodes(trAxis);
	///End AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
	
	// Line	
	/// Iris 4/28/2012 ORG-5528-S1 AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
	//{
		//GETN_BEGIN_BRANCH(Line, STR_LINE_LABEL) GETN_ID(OTID_AXIS_LINE)		
			//GETN_CHECK(Show, STR_SHOW_LABEL, 1) GETN_ID(OTID_AXIS_TICK_SHOW)
			//GETN_COLOR(Color, STR_COLOR_LABEL, 0) GETN_ID(OTID_AXIS_TICK_COLOR) GETN_COLOR_CHOICE_OPTIONS(COLORLIST_SINGLE|COLORLIST_CUSTOM)
			//vector vWidths = {0.2, 0.5, 1, 1.5, 2, 3, 4, 5};
			//GETN_COMBO(Width, STR_WIDTH_LABEL, 1.0, construct_double_combo_list(vWidths, "*2*", true)) GETN_ID(OTID_AXIS_TICK_WIDTH)	
		//GETN_END_BRANCH(Line)	
	//}
	
	ConstructLineBranchNodes(trAxis);
	///End AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
		
	// Scale
	/// Iris 4/27/2012 ORG-5528-S1 AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
	//{
		//GETN_BEGIN_BRANCH(Scale, STR_SCALE_LABEL) GETN_ID(OTID_AXIS_SCALE)
			//GETN_NUM(From, STR_FROM_LABEL, 0) GETN_ID(OTID_AXIS_SCALE_FROM)
			//GETN_NUM(To, STR_TO_LABEL, 0) GETN_ID(OTID_AXIS_SCALE_TO)
			//GETN_LIST(Type, STR_TYPE_LABEL, 0, "") GETN_ID(OTID_AXIS_SCALE_TYPE) GETN_ADD_COMBO			
			//_temp_remove_complex_log_scale_type(_tmpSubNode); /// Iris 11/07/2011 ONLY_KEEP_LINEAR_AND_LOG10_IN_SCALE_TYPE_LIST
			//
			///// Kenny 10/24/2011 ORG-4114-P2 SPIDER_PLOT_AXES_RESCALE_MODE
			//GETN_LIST(Rescale, STR_RESCALE_MODE, AXIS_RESCALE_AUTO, "") GETN_ID(OTID_AXIS_SCALE_RESCALE) GETN_ADD_COMBO
			///// End SPIDER_PLOT_AXES_RESCALE_MODE
			///// Iris 8/18/2011 ORG-3297 IMPROVE_INCREMENT_BY_CONTROLS
			///*
			//GETN_LIST(IncrementBy, STR_INCREMENTBY_LABEL, 0, "") GETN_ID(OTID_AXIS_SCALE_INCBY) GETN_ADD_COMBO
			//GETN_NUM(Value, STR_VALUE_LABEL, 0) GETN_ID(OTID_AXIS_SCALE_INC_VALUE)
			//GETN_NUM(MajorTickCount, STR_MAJOR_TICK_COUNT_LABEL, 0) GETN_ID(OTID_AXIS_SCALE_MAJOR_COUNT)
			//*/
			//GETN_RADIO_INDEX_EX(IncrementBy, STR_MAJOR_TICKS_LABEL, 0, _L("By Increment|By # of Majors")) GETN_ID(OTID_AXIS_SCALE_INCBY)
			//GETN_NUM(Value, " ", 0) GETN_ID(OTID_AXIS_SCALE_INC_VALUE)
			//GETN_NUM(MajorTicksCount, " ", 0) GETN_ID(OTID_AXIS_SCALE_MAJOR_COUNT) _tmpSubNode.Show = false; /// Iris 8/19/2011 COMBINE_INCVALUE_AND_MAJORTICKSCOUNT_AS_ONE_CONTROL
			/////End IMPROVE_INCREMENT_BY_CONTROLS
			//GETN_NUM(MinorTicksCount, STR_MINOR_TICK_COUNT_LABEL, 1) GETN_ID(OTID_AXIS_SCALE_MINOR_COUNT)		
		//GETN_END_BRANCH(Scale)	
	//}	
	ConstructScaleBranchNodes(trAxis);
	/// Iris 7/11/2012 FIX_ONLY_TWO_SCALE_TYPE_FOR_3DGL_GRAPH
	if( trAxis.Scale.Type )
		_temp_remove_complex_log_scale_type(trAxis.Scale.Type);
	///End FIX_ONLY_TWO_SCALE_TYPE_FOR_3DGL_GRAPH
	///End AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
			
	//Ticks
	/// Iris 4/28/2012 ORG-5528-S1 AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
	//{
		//GETN_BEGIN_BRANCH(Ticks, STR_TICKS_LABEL) GETN_ID_COLLECTION_BRANCH_EX(OTID_AXIS_TICKS)			
			//GETN_BEGIN_BRANCH(MajorTicks, STR_MAJOR_TICKS_LABEL) GETN_ID_COLLECTION_MEMBER_REPEAT_BRANCH_EX(OTID_AXIS_TICK, m_nLayerType, GetRepeatIndex(true), nAxis)
			//GETN_OPTION_BRANCH(GETNBRANCH_OPEN)	///Jasmine 09/15/2011 ORG-3297 EXPAND_AXIS_PROPERTY_BRANCH_SUBNODE
				//constructTicksPropertyNodes(_tmpNode);
			//GETN_END_BRANCH(MajorTicks)
			//
			//GETN_BEGIN_BRANCH(MinorTicks, STR_MINOR_TICKS_LABEL) GETN_ID_COLLECTION_MEMBER_REPEAT_BRANCH_EX(OTID_AXIS_TICK, m_nLayerType, GetRepeatIndex(false), nAxis)
			//GETN_OPTION_BRANCH(GETNBRANCH_OPEN)	///Jasmine 09/15/2011 ORG-3297 EXPAND_AXIS_PROPERTY_BRANCH_SUBNODE
				//constructTicksPropertyNodes(_tmpNode);
			//GETN_END_BRANCH(MinorTicks)		
		//GETN_END_BRANCH(Ticks)	
	//}
	ConstructTicksBranchNodes(trAxis);
	///End AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH

	// Labels
	ConstructLabelsBranchNodes(trAxis);
}

//virtual 
void SpiderPlotAxesControlSplitter::ConstructLabelsBranchNodes(TreeNode& trAxis, int nAxis/* = -1*/)
{
	GETN_USE(trAxis)
	
	GETN_BEGIN_BRANCH(Labels, STR_TICK_LABELS_LABEL) GETN_ID_COLLECTION_BRANCH_EX(OTID_AXIS_LABELS)	
		GETN_MARK_STOP_BRANCH /// Iris 7/20/2012 ORG-6270-S1 IMPROVE_TICK_LABELS_BRANCH_SPEED
			
		GETN_BEGIN_BRANCH(MajorLabels, STR_MAJOR_TICK_LABELS_LABEL) GETN_ID_COLLECTION_MEMBER_REPEAT_BRANCH_EX(OTID_AXIS_LABEL, m_nLayerType, GetRepeatIndex(true), nAxis)	
		GETN_OPTION_BRANCH(GETNBRANCH_OPEN)	///Jasmine 09/15/2011 ORG-3297 EXPAND_AXIS_PROPERTY_BRANCH_SUBNODE
			/// Iris 9/28/2011 ORG-3747-S2 COMBINE_TICKLABEL_SHOW_OPPOSITE_AS_ONE_DROPDOWN
			/*
			constructLabelsPropertyNodes(_tmpNode, true);	
			
			/// Iris 9/19/2011 ORG-3819-S2 ADD_MORE_TICK_LABEL_PROPERTIES
			GETN_CHECK(CustomDecimal, STR_CUSTOM_DECIMAL_LABEL, 0)	GETN_ID(OTID_AXIS_LABEL_MANUAL_DEC)
			GETN_STR(DecimalPlaces, STR_DECIMAL_PLACES_LABEL, "")	GETN_ID(OTID_AXIS_LABEL_DEC_DIGITS)
			///End ADD_MORE_TICK_LABEL_PROPERTIES
			*/
			/// Iris 10/12/2011 ORG-3747-S2 COMBINE_TICKLABEL_SHOW_OPPOSITE_AS_ONE_DROPDOWN
			//GETN_LIST(Show, STR_SHOW_LABEL, 0, "None|Before Axis|After Axis") GETN_ID(OTID_AXIS_LABEL_SHOW)
			GETN_LIST(ShowEx, STR_SHOW_LABEL, 0, _L("None|Before Axis|After Axis")) GETN_ID(OTID_AXIS_LABEL_SHOWLABEL)
			///End COMBINE_TICKLABEL_SHOW_OPPOSITE_AS_ONE_DROPDOWN
			///End COMBINE_TICKLABEL_SHOW_OPPOSITE_AS_ONE_DROPDOWN
			
			// put here even this color for both major and minor label since easy copy value by id with repeat id from theme tree to GetN tree
			/// Iris 09/06/2011 ORG-3297-P1 FIX_LABEL_COLOR_CHANGED_WITH_LINE_COLOR_BUT_GUI_NOT_CHANGE
			//GETN_COLOR(Color, STR_COLOR_LABEL, 0) GETN_ID(OTID_AXIS_LABEL_COLOR) GETN_COLOR_CHOICE_OPTIONS(COLORLIST_SINGLE|COLORLIST_CUSTOM)
			GETN_COLOR(Color, STR_COLOR_LABEL, INDEX_COLOR_AUTOMATIC) GETN_ID(OTID_AXIS_LABEL_COLOR) GETN_COLOR_CHOICE_OPTIONS(COLORLIST_SINGLE|COLORLIST_CUSTOM|COLORLIST_AUTO)
			///End FIX_LABEL_COLOR_CHANGED_WITH_LINE_COLOR_BUT_GUI_NOT_CHANGE
			
			/// Iris 2/06/2012 ORG-4218-P1 SUPPORT_TICK_LABEL_FORMAT_TYPE
			GETN_LIST(Type, STR_TYPE_LABEL, 0, "") GETN_ID(OTID_AXIS_LABEL_TYPE) GETN_ADD_COMBO _update_tick_label_type_list(_tmpSubNode); 				
			GETN_LIST(NumericDisplay, STR_DISPLAY_LABEL, 0, "") GETN_ID(OTID_AXIS_LABEL_NUMERIC) GETN_ADD_COMBO
			GETN_LIST(MonthDisplay, STR_DISPLAY_LABEL, 0, "") GETN_ID(OTID_AXIS_LABEL_MONTH) GETN_ADD_COMBO
			GETN_LIST(DayDisplay, STR_DISPLAY_LABEL, 0, "") GETN_ID(OTID_AXIS_LABEL_DAY) GETN_ADD_COMBO
			GETN_LIST(TimeDisplay, STR_DISPLAY_LABEL, 0, "") GETN_ID(OTID_AXIS_LABEL_TIME) GETN_ADD_COMBO
			GETN_LIST(DateDisplay, STR_DISPLAY_LABEL, 0, "") GETN_ID(OTID_AXIS_LABEL_DATE) GETN_ADD_COMBO				
			GETN_STR(TextDisplay, STR_DISPLAY_LABEL, "")	GETN_ID(OTID_AXIS_LABEL_STRING)			
			/// Iris 5/21/2012 ORG-4218-P5 ADD_DATETIME_CUSTOM_FORMAT_CONTROL
			GETN_STRLIST(DateCustomDisplay, STR_CUSTOM_DISPLAY_LABEL, "", "") GETN_ID(OTID_AXIS_LABEL_DATE_CUSTOM_DISPLAY) GETN_ADD_COMBO 
			GETN_STRLIST(TimeCustomDisplay, STR_CUSTOM_DISPLAY_LABEL, "", "") GETN_ID(OTID_AXIS_LABEL_TIME_CUSTOM_DISPLAY) GETN_ADD_COMBO
			///End ADD_DATETIME_CUSTOM_FORMAT_CONTROL
			///End SUPPORT_TICK_LABEL_FORMAT_TYPE
			
			/// Iris 9/19/2011 ORG-3819-S2 ADD_MORE_TICK_LABEL_PROPERTIES
			GETN_BEGIN_BRANCH(Font, STR_FONT_LABEL) GETN_ID(OTID_AXIS_LABEL_FONT)
			GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
				GETN_FONT(Face, STR_FONT_LABEL, 0)GETN_ID(OTID_AXIS_LABEL_FONT_FACE)
				GETN_COMBO(Size, STR_FONT_SIZE_LABEL, 18, "|8|9|10|11|12|14|16|18|20|22|24|26|28|36|48|72") GETN_ID(OTID_AXIS_LABEL_FONT_SIZE)		
				GETN_CHECK(Bold, STR_FONT_BOLD_LABEL, 0) GETN_ID(OTID_AXIS_LABEL_FONT_BOLD)
			GETN_END_BRANCH(Font)	
			
			/// Iris 9/28/2011 ORG-3962-S1 IMPROVE_AXIS_DLG_GUI
			GETN_BEGIN_BRANCH(Format, STR_FORMAT_LABEL)	
				GETN_ID(-1) /// Iris 11/10/2011 ORG-3962-P3 FIX_CONTROLS_IN_FORMAT_AND_OFFSET_BRANCH_NOT_WORKED, this branch not existed in theme tree, set id as -1, in order to remove it before apply format
				/// Iris 10/13/2011 ORG-3962-S1 IMPROVE_CUSTOM_DECIMAL_CONTROLS
				//GETN_CHECK(CustomDecimal, STR_CUSTOM_DECIMAL_LABEL, 0)	GETN_ID(OTID_AXIS_LABEL_MANUAL_DEC)
				//GETN_STRLIST(DecimalPlaces, STR_DECIMAL_PLACES_LABEL, "", "|1|2|3|4|5|6") GETN_ID(OTID_AXIS_LABEL_DEC_DIGITS)
				//GETN_CURRENT_SUBNODE.Enable = false; /// Iris 9/29/2011 ORG-3819-S1 IMPROVE_CUSTOM_DECIAL_CONTROL
				/// Iris 11/10/2011 ORG-3962-S2 IMPROVE_CUSTOM_DECIMAL_CONTROL
				//GETN_STRLIST(CustomDecimal, STR_CUSTOM_DECIMAL_LABEL, "", "|1|2|3|4|5|6") GETN_ID(OTID_AXIS_LABEL_MANUAL_DEC) GETN_ADD_LEFT_CHECK(0)
				//GETN_STRLIST(DecimalPlaces, STR_DECIMAL_PLACES_LABEL, "", "|1|2|3|4|5|6") GETN_ID(OTID_AXIS_LABEL_DEC_DIGITS) GETN_CURRENT_SUBNODE.Show = false;
				/// Iris 8/01/2012 ORG-5991-P14 IMPORVE_CUSTOM_DECIMAL_CONTROL_DISPLAY
				// re-order the two controls
				/*
				GETN_STR(hits, _L("*nn is to specify the number of significant digits, .nn is to specify the number of decimal places \nExample: *2 ( two significant digits), .3 ( three decimal places)"), "") GETN_HINT 
				GETN_STRLIST(CustomDecimal, STR_CUSTOM_FORMAT_LABEL, E_STR_CUSTOM_DEFAULT_FORMAT, "|*3|*4|.2|.3|.4") GETN_ID(OTID_AXIS_LABEL_MANUAL_DEC) GETN_ADD_LEFT_CHECK(0)
				*/
				///Sophy 8/3/2012 ORG-2639-P8 SHOW_BUILDIN_FORMAT_IN_CUSTOM_DISPLAY_FORMAT_LIST
				//GETN_STRLIST(CustomDecimal, STR_CUSTOM_FORMAT_LABEL, E_STR_CUSTOM_DEFAULT_FORMAT, "|*3|*4|.2|.3|.4") GETN_ID(OTID_AXIS_LABEL_MANUAL_DEC) GETN_ADD_LEFT_CHECK(0)
				GETN_STRLIST(CustomDecimal, STR_CUSTOM_FORMAT_LABEL, E_STR_CUSTOM_DEFAULT_FORMAT, STR_AXIS_LABEL_CUSTOM_DISPLAY_LIST) GETN_ID(OTID_AXIS_LABEL_MANUAL_DEC) GETN_ADD_LEFT_CHECK(0)
				///end SHOW_BUILDIN_FORMAT_IN_CUSTOM_DISPLAY_FORMAT_LIST
				GETN_STR(hits, _L("*nn is to specify the number of significant digits, .nn is to specify the number of decimal places \nExample: *2 ( two significant digits), .3 ( three decimal places)"), "") GETN_HINT 
				_tmpSubNode.Show = false;
				///End IMPORVE_CUSTOM_DECIMAL_CONTROL_DISPLAY
				///End IMPROVE_CUSTOM_DECIMAL_CONTROL
				///End IMPROVE_CUSTOM_DECIMAL_CONTROLS
			///End IMPROVE_AXIS_DLG_GUI
			
				GETN_STR(DivideByFactor, STR_DIVIDE_BY_FACTOR_LABEL, "")	GETN_ID(OTID_AXIS_LABEL_DIVIDE_BY_FACTOR)
				GETN_STR(Prefix, STR_PREFIX_LABEL, "")						GETN_ID(OTID_AXIS_LABEL_PREFIX)
				GETN_STR(Suffix, STR_SUFFIX_LABEL, "")						GETN_ID(OTID_AXIS_LABEL_SUFFIX)
				///End ADD_MORE_TICK_LABEL_PROPERTIES
			GETN_END_BRANCH(Format) ///End IMPROVE_AXIS_DLG_GUI	
			
			/// Iris 9/28/2011 ORG-3962-S1 IMPROVE_AXIS_DLG_GUI, move to below
			//GETN_COMBO(Angle, STR_ANGLE_LABEL, 0, "|0|45|60|90|180|270") GETN_ID(OTID_AXIS_LABEL_ANGLE)
			///End IMPROVE_AXIS_DLG_GUI
			
			GETN_BEGIN_BRANCH(Offset, STR_OFFSET_IN_POINT_SIZE_LABEL) /// Iris 9/28/2011 ORG-3962-S1 IMPROVE_AXIS_DLG_GUI
				GETN_ID(-1) /// Iris 11/10/2011 ORG-3962-P3 FIX_CONTROLS_IN_FORMAT_AND_OFFSET_BRANCH_NOT_WORKED, this branch not existed in theme tree, set id as -1, in order to remove it before apply format
				///Jasmine 09/08/2011 ORG-3747-S1 ADD_POSITION_CONTROL_FOR_TICK_LABELS
				GETN_NUM(XOffset,	STR_XOFFSET_LABEL, 0) 				GETN_ID(OTID_AXIS_LABEL_XOFFSET)
				GETN_NUM(YOffset,	STR_YOFFSET_LABEL, 0)	 			GETN_ID(OTID_AXIS_LABEL_YOFFSET)
				///End ADD_POSITION_CONTROL_FOR_TICK_LABELS	
			GETN_END_BRANCH(Offset) /// Iris 9/28/2011 ORG-3962-S1 IMPROVE_AXIS_DLG_GUI
			
			/// Iris 9/28/2011 ORG-3962-S1 IMPROVE_AXIS_DLG_GUI
			/*
			/// Iris 9/20/2011 ORG-3747-S1 ADD_OPPOSITE_CONTROL_FOR_TICK_LABELS
			GETN_CHECK(Opposite, STR_OPPOSITE_LABEL, 0)				GETN_ID(OTID_AXIS_LABEL_OPPOSITE)
			///End ADD_OPPOSITE_CONTROL_FOR_TICK_LABELS
			*/
			GETN_COMBO(Angle, STR_ANGLE_LABEL, 0, "|0|45|60|90|180|270") GETN_ID(OTID_AXIS_LABEL_ANGLE)
			///End IMPROVE_AXIS_DLG_GUI

		GETN_END_BRANCH(MajorLabels)
		
		GETN_BEGIN_BRANCH(MinorLabels, STR_MINOR_TICK_LABELS_LABEL) GETN_ID_COLLECTION_MEMBER_REPEAT_BRANCH_EX(OTID_AXIS_LABEL, m_nLayerType, GetRepeatIndex(false), nAxis)
		GETN_OPTION_BRANCH(GETNBRANCH_OPEN)	///Jasmine 09/15/2011 ORG-3297 EXPAND_AXIS_PROPERTY_BRANCH_SUBNODE
			/// Iris 10/12/2011 ORG-3747-S2 COMBINE_TICKLABEL_SHOW_OPPOSITE_AS_ONE_DROPDOWN
			//constructLabelsPropertyNodes(_tmpNode, false);
			GETN_CHECK(Show, STR_SHOW_LABEL, 0) GETN_ID(OTID_AXIS_LABEL_SHOW)
			///End COMBINE_TICKLABEL_SHOW_OPPOSITE_AS_ONE_DROPDOWN
		GETN_END_BRANCH(MinorLabels)		
		
		
	GETN_END_BRANCH(Labels)		
}

//virtual 
TreeNode SpiderPlotAxesControlSplitter::getThemeAxesNode()
{
	return m_trTheme.Root.TAG_NEW_AXES;
}

//virtual 
string 	SpiderPlotAxesControlSplitter::getThemeAxisNodeName(int nAxis)
{		
	//return STR_AXIS + (nAxis + 1 );
	string str;
	str.Format("%s%d", STR_NEW_AXIS, nAxis + 1);
	return str;
}

string	SpiderPlotAxesControlSplitter::getAxisLabelName(int nAxis, const GraphLayer& glParent)
{
	string strName = STR_AXES_LABEL;
	if( nAxis >= 0 )
		strName = STR_AXIS_LABEL + (nAxis + 1 );
	
	string strAxisName = "XB";
	if(nAxis > 0)
		strAxisName += nAxis;
	GraphObject grObject = glParent.GraphObjects(strAxisName);
	if(grObject && nAxis >= 0)
	{
		int nObjType;
		string strObjectType = grObject.GetObjectType();
		if(strObjectType.CompareNoCase("Text")  == 0)
		{
			strName += " - " + grObject.DisplayText;
		}
	}
	
	return strName;
}


//virtual 
void SpiderPlotAxesControlSplitter::CopyValuesFromThemeToGetNForOneAxis(TreeNode& trGetN, int nAxis, TreeNode& trThemeOneAxis, TreeNode& trGetNOneAxis)
{
	AxesControlSplitter::CopyValuesFromThemeToGetNForOneAxis(trGetN, nAxis, trThemeOneAxis, trGetNOneAxis);
	
	if( 0 == nAxis )
	{
		if( trGetN.Misc )
			tree_copy_values_by_id(trThemeOneAxis, trGetN.Misc);
		
		if( trThemeOneAxis.Grids && trGetN.Grids )
			_copy_value_by_base_id_and_repeat_id(trThemeOneAxis.Grids, trGetN.Grids);
		
		initHide1stTickLabelGetN(trGetN); /// Iris 11/04/2011 ORG-4268-S3 ADD_HIDE_1ST_TICK_LABELS_CHECKBOX
	}	
	
	// setup label type display nodes according to label type
	foreach(TreeNode trSubBranch in trGetNOneAxis.Labels.Children) // Major / Minor
	{				
		TreeNode trGetNLabelType = _get_GetN_node_by_id(trSubBranch, OTID_AXIS_LABEL_TYPE, true);
		if( trGetNLabelType )
		{			
			_ticklabel_type_event(trSubBranch, trGetNLabelType);
		}				
	}		
}

/// Iris 8/06/2012 ORG-6463-S1 ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
// virtual 
int SpiderPlotAxesControlSplitter::GetOutsideAxisBranchNodeDataIDs(vector<int>& vnBranchDataIDs)
{
	vector<int> vn = {
					OTID_AXIS_GRIDS,
					IDBRANCH_MISC					
				};
	vnBranchDataIDs = vn;
	return vnBranchDataIDs.GetSize();
}
///End ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX

/// Iris 9/18/2012 ORG-6834-P2 CHANGE_TO_LOG_SCALE_TYPE_CAUSE_RUNTIME_ERROR_IN_RADAR_AXES_DLG	
// virtual
void SpiderPlotAxesControlSplitter::UpdateControlsByIncrementByChange(TreeNode& trBranch)
{	
	TreeNode trIncBy = trBranch.IncrementBy;
	TreeNode trValue = trBranch.Value;
	TreeNode trCount = trBranch.MajorTicksCount;
	ASSERT(trIncBy && trValue && trCount );
	if( !trIncBy || !trValue || !trCount )
		return;	
	
	trValue.Show = (0 == trBranch.IncrementBy.nVal);	
	trCount.Show = (1 == trBranch.IncrementBy.nVal);		
}
///End CHANGE_TO_LOG_SCALE_TYPE_CAUSE_RUNTIME_ERROR_IN_RADAR_AXES_DLG

//virtual 
void SpiderPlotAxesControlSplitter::ApplyOtherPropertiesToThemeTree(TreeNode& trEditNode, TreeNode& trListTreeSelectedNode)
{
	/// Iris 8/06/2012 ORG-6463-S1 ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
	/*
	vector<int> vnBranchDataID = {
					OTID_AXIS_GRIDS,
					IDBRANCH_MISC,//IDBRANCH_START_POSITION,
					0
				};
	*/
	vector<int> vnBranchDataID;
	GetOutsideAxisBranchNodeDataIDs(vnBranchDataID);
	///End ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
	
	/// Iris 09/06/2011 ORG-3297-P3 FIX_GRID_FORMAT_FAIL_TO_WORK_WHEN_SELECT_MAJORGRIDLINE_IN_LEFT_PANEL
	/*
	TreeNode trGetN = trEditNode;
	while( trGetN.Parent() )
	{
		trGetN = trGetN.Parent();
		
		vector<uint> vn;
		if( vnBranchDataID.Find(MATREPL_TEST_EQUAL, _get_base_id(trGetN.DataID), vn) > 0 )
			break;					
	}
	*/
	int nLevel = m_AxesGridTree.GetRowOutlineLevel(m_AxesGridTree.GetSelectedRow());
	TreeNode trGetN = trListTreeSelectedNode;
	
	if( nLevel > LEVEL_GRIDS ) // get parent 
	{			
		while( trGetN )
		{			
			vector<uint> vn;
			if( vnBranchDataID.Find(MATREPL_TEST_EQUAL, _get_base_id(trGetN.DataID), vn) > 0 )
				break;					
			
			trGetN = trGetN.Parent();				
		}
	}
	else if ( nLevel < LEVEL_GRIDS )
	{
		for(int nn = 0; nn < vnBranchDataID.GetSize(); nn++)
		{
			if( vnBranchDataID[nn] > 0 )
			{
				TreeNode trTemp = _tree_get_branch_node_by_base_id(trGetN, vnBranchDataID[nn], true);
				if( trTemp )
				{
					trGetN = trTemp;
					break;
				}
			}
		}
	}
	///End FIX_GRID_FORMAT_FAIL_TO_WORK_WHEN_SELECT_MAJORGRIDLINE_IN_LEFT_PANEL
	
	if( trGetN && trGetN.DataID > 0 )
	{
		bool bNeedCopy = true; /// Iris 10/11/2011 UPDATED_AFTER_ROMAN_CHANGE_ABOUT_SPIDER_THEME_IMPROVE
		TreeNode trThemeAxes = GetThemeAxisNode(-1); 
		TreeNode trTheme;
		switch(_get_base_id(trGetN.DataID))
		{
		case OTID_AXIS_GRIDS:
			trTheme = tree_check_get_node(trThemeAxes, "Grids", THEME_COLL_BRANCH(OTID_AXIS_GRIDS));

			break;
		case IDBRANCH_MISC://OTID_START_POSITION:
			/// Iris 10/11/2011 UPDATED_AFTER_ROMAN_CHANGE_ABOUT_SPIDER_THEME_IMPROVE
			// After Roman changed theme tree, the property nodes in All branch need OC level to construct,
			// and the struct is diff in theme and GUI, no Start Position branch in theme.
			//trTheme = trThemeAxes;						
			bNeedCopy = false; 
			/// Iris 11/04/2011 ORG-4268-S3 ADD_HIDE_1ST_TICK_LABELS_CHECKBOX
			if( trEditNode.DataID == ID_HIDE_1ST_TICK_LABELS )
			{
				applyShowHide1stTickLabelOnEachAxis(trEditNode);
			}
			///End ADD_HIDE_1ST_TICK_LABELS_CHECKBOX
			else
			{
				string strChange;
				if( trEditNode.GetAttribute(STR_CHANGED_ATTRIB, strChange) )
				{
					TreeNode trTheme = tree_check_get_node(trThemeAxes, trEditNode.tagName, trEditNode.DataID, STR_CHANGED_ATTRIB, strChange);
					trTheme.strVal = trEditNode.strVal;
				}
			}
			///End UPDATED_AFTER_ROMAN_CHANGE_ABOUT_SPIDER_THEME_IMPROVE					
			break;			
		}
						
		if( bNeedCopy ) /// Iris 10/11/2011 UPDATED_AFTER_ROMAN_CHANGE_ABOUT_SPIDER_THEME_IMPROVE
		{
			TreeNode trJunk;
			//_copy_sub_nodes(trGetN, trTheme, trJunk); 
			_copy_changed_nodes(trGetN, trTheme, trJunk); 
		}				
	}	
}

/// Iris 11/04/2011 ORG-4017-P1 NEED_REFRESH_INCREMENT_VAL_AFTER_CHANGED_FROM_TO
/// Iris 11/11/2011 ORG-4268-S2 FIX_SCALE_NOT_DISABLE_WHEN_DIG_REOPEN
//void 	AxesControlSplitter::updateGetNScaleAfterCopyValuesFromTheme(TreeNode& trGetNScale)
// virtual
void	SpiderPlotAxesControlSplitter::updateGetNScaleAfterCopyValuesFromTheme(TreeNode& trList, TreeNode& trGetNOneAxis, int nAxis)
///End FIX_SCALE_NOT_DISABLE_WHEN_DIG_REOPEN
{
	/// Iris 7/19/2012 ORG-6246-P1 SETUP_SCALE_DISPLAY_VALUE_ON_AFTER_DIVIDE_FACTOR_CHANGE
	AxesControlSplitter::updateGetNScaleAfterCopyValuesFromTheme(trList, trGetNOneAxis, nAxis);
	///End SETUP_SCALE_DISPLAY_VALUE_ON_AFTER_DIVIDE_FACTOR_CHANGE
	
	/// Iris 5/17/2012 ORG-5528-S5 MOVE_TICKS_COUNT_NODES_TO_TICKS_BRANCH_FOR_GL_GRAPH	
	/*
	if( trGetNScale.IncrementBy && trGetNScale.Value && trGetNScale.MajorTicksCount && 1 == trGetNScale.IncrementBy.nVal )
	{
		trGetNScale.Value.SetAttribute(STR_INC_VALUE_LABEL, trGetNScale.Value.dVal);
		trGetNScale.Value.dVal = trGetNScale.MajorTicksCount.nVal;
	}	
	*/	
	///End MOVE_TICKS_COUNT_NODES_TO_TICKS_BRANCH_FOR_GL_GRAPH
	
	TreeNode trGetNScale = trGetNOneAxis.Scale;
	ASSERT(trList && trGetNScale);
	if( trList && trGetNScale )
	{
		ConvertIncrementValueAndTicksCount(trGetNScale, trGetNScale);
		
		/// Iris 11/11/2011 ORG-4268-S2 FIX_SCALE_NOT_DISABLE_WHEN_DIG_REOPEN
		//disableScaleOptions(&trGetNScale); /// Iris 11/10/2011 ORG-4268-S2 RESCALE_EACH_AXIS_INDEP_CHECKED_BUT_SCALE_STILL_CAN_BE_EDIT
		disableScaleOptions(trList, &trGetNScale);
		///End FIX_SCALE_NOT_DISABLE_WHEN_DIG_REOPEN
	}
	
	/// Iris 5/17/2012 ORG-5528-S5 MOVE_TICKS_COUNT_NODES_TO_TICKS_BRANCH_FOR_GL_GRAPH
	//_update_controls_by_scale_type_change(trGetNScale); /// Iris 9/29/2011 ORG-3921-P1 FIX_BAD_INIT_VALUE_FOR_LOG_TYPE_SCALE	
	UpdateControlsByScaleTypeChange(trGetNOneAxis, nAxis);
	///End MOVE_TICKS_COUNT_NODES_TO_TICKS_BRANCH_FOR_GL_GRAPH
}
///End NEED_REFRESH_INCREMENT_VAL_AFTER_CHANGED_FROM_TO
	

/// Iris 10/31/2011 ORG-4268-S2 DISENABLE_SCALE_BRANCH
/// Iris 11/11/2011 ORG-4268-S2 FIX_SCALE_NOT_DISABLE_WHEN_DIG_REOPEN
//void AxesControlSplitter::disableScaleOptions(TreeNode* ptrScaleBranch)
void SpiderPlotAxesControlSplitter::disableScaleOptions(TreeNode& tr, TreeNode* ptrScaleBranch)
///End FIX_SCALE_NOT_DISABLE_WHEN_DIG_REOPEN
{	
	if( !tr.Misc.IndepScales )
		return;
	
	TreeNode trGetNScale;	
	if( ptrScaleBranch )
		trGetNScale = *ptrScaleBranch;
	if( !trGetNScale )	
	{
		TreeNode trGetNAxis = GetGetNAxisNode(0);
		if( trGetNAxis )
			trGetNScale = trGetNAxis.Scale;
	}
	
	if( trGetNScale )
	{
		/// Iris 11/10/2011 ORG4268-P2 UNCHECK_RESCALE_EACH_AXIS_INDEP_NOT_WORKED
		//int nEnable = (!m_bForAll || !m_bIsIndependentlyRescale);	
		/// Iris 11/11/2011 ORG-4268-S2 FIX_SCALE_NOT_DISABLE_WHEN_DIG_REOPEN
		/*
		Tree tr;
		tr = GetListTree();
		*/
		/// Iris 4/27/2012 ORG-5528-S1 AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
		//ASSERT( tr.Misc.IndepScales );
		///End AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
		///End FIX_SCALE_NOT_DISABLE_WHEN_DIG_REOPEN		
		bool bIsIndependentlyRescale = tr.Misc.IndepScales.nVal;		
		int nEnable = (!m_bForAll || !bIsIndependentlyRescale);	
		///End UNCHECK_RESCALE_EACH_AXIS_INDEP_NOT_WORKED
		/// Iris 9/18/2012 ORG-6834-P2 CHANGE_TO_LOG_SCALE_TYPE_CAUSE_RUNTIME_ERROR_IN_RADAR_AXES_DLG
		//tree_set_attribute_to_all_nodes(trGetNScale, STR_ENABLE_ATTRIB, (string)nEnable);
		if( nEnable )
			trGetNScale.RemoveAttribute(STR_ENABLE_ATTRIB);
		else
			trGetNScale.Enable = nEnable;
		///End CHANGE_TO_LOG_SCALE_TYPE_CAUSE_RUNTIME_ERROR_IN_RADAR_AXES_DLG
	}
}
///End DISENABLE_SCALE_BRANCH

/// Iris 11/04/2011 ORG-4268-S3 ADD_HIDE_1ST_TICK_LABEL_CHECKBOX
void SpiderPlotAxesControlSplitter::applyShowHide1stTickLabelOnEachAxis(TreeNode& trEditNode)
{
	vector<int> vv;	
	if( trEditNode.nVal )
	{
		vv.SetSize(1);
		vv[0] = SAT_HIDE;
	}
	
	m_trTheme.Root.NewAxes.All.SpecialTicks.ID = OTID_AXIS_SPECIALTICKS;
	m_trTheme.Root.NewAxes.All.SpecialTicks.Types.ID = OTID_AXIS_SPECIALTICKS_TYPES;
	_set_value_with_change_bit(m_trTheme.Root.NewAxes.All.SpecialTicks.Types, vv);		
}
///End ADD_HIDE_1ST_TICK_LABEL_CHECKBOX
	
/// Iris 11/04/2011 ORG-4268-S3 ADD_HIDE_1ST_TICK_LABELS_CHECKBOX
void SpiderPlotAxesControlSplitter::initHide1stTickLabelGetN(TreeNode& trGetN)
{
	/// Iris 4/27/2012 ORG-5528-S1 AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
	//TreeNode trTypes = m_trTheme.Root.TAG_AXES.NewAxis1.SpecialTicks.Types;	
	TreeNode trTypes = getThemeAxesNode().NewAxis1.SpecialTicks.Types;	
	///End AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
	if( trTypes && !trTypes.IsEmpty() )
	{
		vector<int> vnTypes;
		vnTypes = trTypes.nVals;
		if( vnTypes.GetSize() > 0 && vnTypes[0] == SAT_HIDE )
			trGetN.Misc.Hide1stTickLabels.nVal = 1;	
	}
}
///End ADD_HIDE_1ST_TICK_LABELS_CHECKBOX

/// Iris 11/03/2011 ORG-4268-S4 ADD_ONLY_SHOW_TICK_LABEL_ON_1ST_AXIS_CHECKBOX
void	SpiderPlotAxesControlSplitter::setOnlyOneTickLabelFor1stAxisInitStatus(TreeNode& trN)
{
	TreeNode trThemeAxis;
	if( trN && (trThemeAxis = GetThemeAxisNode(0)) ) // get 1st axis branch from theme node	
	{
		/// Iris 11/09/2011 ORG-4268-P1 FIX_ONLY_SHOW_TICK_LABELS_FOR_1ST_AXIS_NOT_WORKED_FOR_MINOR_TICK_LABEL
		/*
		TreeNode trShow = MAJOR_TICK_LABEL_SHOW_NODE(trThemeAxis);
		if( trShow )
		{
			if( trShow.nVal == TICK_LABEL_SHOW_NONE ) // if tick label of 1st axis not show, keep this node is unchecked
			{
				trN.nVal = 0;
				return;
			}
			else
			{
				for(int nAxis = 1; nAxis < m_nNumAxes; nAxis++)
				{
					trThemeAxis = GetThemeAxisNode(nAxis);
					if( trThemeAxis )
					{
						trShow = MAJOR_TICK_LABEL_SHOW_NODE(trThemeAxis);
						if( trShow.nVal != TICK_LABEL_SHOW_NONE )
						{
							trN.nVal = 0;
							return;
						}
					}
				}
				trN.nVal = 1;
			}
		}
		*/		
		// check if there are tick labels (major or minor) show on 1st axis, if not any show, will set checkbox as uncheck
		TreeNode trMajorShow = MAJOR_TICK_LABEL_SHOW_NODE(trThemeAxis);
		TreeNode trMinorShow = MINOR_TICK_LABEL_SHOW_NODE(trThemeAxis);
		if( trMajorShow && trMajorShow.nVal == TICK_LABEL_SHOW_NONE && trMinorShow && trMinorShow.nVal == 0 ) 
		{
			trN.nVal = 0;
			return;
		}
		
		// check all other axes, if there is any tick labels show, will set checkbox as uncheck; else as checked
		for(int nAxis = 1; nAxis < m_nNumAxes; nAxis++)
		{
			trThemeAxis = GetThemeAxisNode(nAxis);
			if( trThemeAxis )
			{
				trMajorShow = MAJOR_TICK_LABEL_SHOW_NODE(trThemeAxis);
				trMinorShow = MINOR_TICK_LABEL_SHOW_NODE(trThemeAxis);
				if( trMajorShow && trMajorShow.nVal != TICK_LABEL_SHOW_NONE || trMinorShow && trMinorShow.nVal == 1 )
				{
					trN.nVal = 0;
					return;
				}
			}
		}		
		trN.nVal = 1;
		///End FIX_ONLY_SHOW_TICK_LABELS_FOR_1ST_AXIS_NOT_WORKED_FOR_MINOR_TICK_LABEL
	}
}

// virtual
/// Iris 6/13/2012 ORG-5991 MOVE_TICKS_AND_LINE_BRANCH_INTO_AXIS_FORMAT_BRANCH
//TreeNode SpiderPlotAxesControlSplitter::GetTicksCountParentNode(TreeNode& trGetNOneAxis, int nAxis, int nSubAxisIndex, bool bMajor)
TreeNode SpiderPlotAxesControlSplitter::GetTicksCountParentNode(TreeNode& trGetNOneAxis, bool bMajor)
///End MOVE_TICKS_AND_LINE_BRANCH_INTO_AXIS_FORMAT_BRANCH
{
	ASSERT(trGetNOneAxis.Scale);
	return trGetNOneAxis.Scale;
}

// virtual
void SpiderPlotAxesControlSplitter::UpdateOnAfterValueChange(int nRow, ThemeUpdateInfo& stThemeUpdateInfo)
{
	AxesControlSplitter::UpdateOnAfterValueChange(nRow, stThemeUpdateInfo);
	if( !stThemeUpdateInfo.trEditNode || stThemeUpdateInfo.trEditNode.DataID <= 0 )
		return;
	
	switch(stThemeUpdateInfo.trEditNode.DataID)
	{		
	/// Iris 10/31/2011 ORG-4268-S1 NEED_DO_RESCALE_WHEN_INDEPDENTLY_RESCALE_CHECKED
	case OTID_AXES_INDIVIDUALSCALE:
		/// Iris 11/10/2011 ORG4268-P2 UNCHECK_RESCALE_EACH_AXIS_INDEP_NOT_WORKED
		//m_bIsIndependentlyRescale = trEditNode.nVal;
		//m_bRescaleIndependentlyChanged = true;
		m_nRescaleAfterApplyTheme = true;
		///End UNCHECK_RESCALE_EACH_AXIS_INDEP_NOT_WORKED
		
		/// Iris 12/15/2011 ORG-4597-P1 AFTER_DO_INDEP_RESCALE_NOT_UPDATE_EACH_AXIS_SCALE_FROM_TO
		m_vnChangedAxes.Data(0, m_nNumAxes-1, 1); 
		///End AFTER_DO_INDEP_RESCALE_NOT_UPDATE_EACH_AXIS_SCALE_FROM_TO
		
		/// Iris 11/11/2011 ORG-4268-S2 FIX_SCALE_NOT_DISABLE_WHEN_DIG_REOPEN
		//disableScaleOptions(); /// Iris 10/31/2011 ORG-4268-S2 DISENABLE_SCALE_BRANCH
		disableScaleOptions(GetListTree()); /// Iris 10/31/2011 ORG-4268-S2 DISENABLE_SCALE_BRANCH
		///End FIX_SCALE_NOT_DISABLE_WHEN_DIG_REOPEN
		break;
	///End NEED_DO_RESCALE_WHEN_INDEPDENTLY_RESCALE_CHECKED		
	}
}
	
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////// GeneralPlotAxesControlSplitter //////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

/// Iris 8/01/2012 ORG-6371-S1 ADD_USE_SAME_OPTIONS_FOR_BOTH_ON_EACH_AXIS_ROOT_NODE
static string _get_one_same_options_setting(TreeNode& trBranch, TreeNode& trSameOptions)
{	
	string str;
	if( trSameOptions )
	{			
		str.Format("%d=%d", trBranch.DataID, trSameOptions.nVal);
		str += ",";		
	}	
	return str;
}
///End ADD_USE_SAME_OPTIONS_FOR_BOTH_ON_EACH_AXIS_ROOT_NODE

/// Iris 7/19/2012 ORG-5991-P13 SAVE_SAME_OPTIONS_TO_GRAPH_NOT_REGISTRY
void GeneralPlotAxesControlSplitter::SaveSettingsBeforeDialogClose()
{
	string strSettings; // format is ID1=nChecked,ID2=unchecked...
	
	for(int nAxis = 0; nAxis < m_nNumAxes; ++nAxis)
	{
		TreeNode trAxis = GetGetNAxisNode(nAxis);
		if( trAxis )
		{
			strSettings += "{";	
			
			/// Iris 8/01/2012 ORG-6371-S1 ADD_USE_SAME_OPTIONS_FOR_BOTH_ON_EACH_AXIS_ROOT_NODE
			TreeNode trSameOptions = trAxis.SameForBoth;
			if( trSameOptions )
				strSettings += _get_one_same_options_setting(trAxis, trSameOptions);
			///End ADD_USE_SAME_OPTIONS_FOR_BOTH_ON_EACH_AXIS_ROOT_NODE
			
			foreach(TreeNode trPropertyBranch in trAxis.Children)
			{
				/// Iris 8/01/2012 ORG-6371-S1 ADD_USE_SAME_OPTIONS_FOR_BOTH_ON_EACH_AXIS_ROOT_NODE
				/*
				TreeNode trSameOptions = _get_GetN_node_by_id(trPropertyBranch, ID_SAME_FOR_BOTTOM_AND_TOP, true);
				if( trSameOptions )
				{
					string str;
					str.Format("%d=%d", trPropertyBranch.DataID, trSameOptions.nVal);
					strSettings += str + ",";
				}
				*/
				trSameOptions = _get_GetN_node_by_id(trPropertyBranch, ID_SAME_FOR_BOTTOM_AND_TOP, true);
				if( trSameOptions )
					strSettings += _get_one_same_options_setting(trPropertyBranch, trSameOptions);
				///End ADD_USE_SAME_OPTIONS_FOR_BOTH_ON_EACH_AXIS_ROOT_NODE
			}
			strSettings.TrimRight(',');
			strSettings += "},";
		}
	}	
	strSettings.TrimRight(',');			
	
	GraphPage gp = m_gl.GetPage();
	Tree tr;
	gp.GetBinaryStorage(STR_AXES_DLG_SETTINGS, tr);
	TreeNode trUseSameOptions = tree_check_get_node(tr, STR_USE_SAME_OPTIOINS);
	trUseSameOptions.strVal = strSettings;	
	gp.PutBinaryStorage(STR_AXES_DLG_SETTINGS, tr);
}
///End SAVE_SAME_OPTIONS_TO_GRAPH_NOT_REGISTRY

// virtual
void GeneralPlotAxesControlSplitter::constructGetNTrees(TreeNode& trGetN, int nNumAxes)
{	
	GETN_USE(trGetN)
	
	ConstructAllAxesPropertyNodes(_tmpNode, nNumAxes);	
}

//virtual 
void GeneralPlotAxesControlSplitter::ConstructOneAxisPropertyNodes(TreeNode& trAxis, int nAxis)
{
	/// Iris 8/01/2012 ORG-6371-S1 ADD_USE_SAME_OPTIONS_FOR_BOTH_ON_EACH_AXIS_ROOT_NODE
	AddUseSameOptionsForBoth(trAxis, nAxis);
	///End ADD_USE_SAME_OPTIONS_FOR_BOTH_ON_EACH_AXIS_ROOT_NODE
	
	/// Iris 8/02/2012 ORG-5991-S5 REORDER_PROPERTY_BRANCH_IN_LEFT_PANEL
	/*
	// Line	
	/// Iris 6/13/2012 ORG-5991 MOVE_TICKS_AND_LINE_BRANCH_INTO_AXIS_FORMAT_BRANCH	
	//ConstructLineBranchNodes(trAxis, nAxis);
	ConstructAxisFormatBranchNodes(trAxis, nAxis);
	///End MOVE_TICKS_AND_LINE_BRANCH_INTO_AXIS_FORMAT_BRANCH
	
	// Scale	
	ConstructScaleBranchNodes(trAxis);
	
	// Title	
	ConstructTitleBranchNodes(trAxis, nAxis); 
	
	// Ticks	
	/// Iris 6/13/2012 ORG-5991 MOVE_TICKS_AND_LINE_BRANCH_INTO_AXIS_FORMAT_BRANCH	
	//ConstructTicksBranchNodes(trAxis, nAxis);
	///End MOVE_TICKS_AND_LINE_BRANCH_INTO_AXIS_FORMAT_BRANCH
	
	// Ticks Label
	ConstructLabelsBranchNodes(trAxis, nAxis);	
	
	/// Iris 6/21/2012 ORG-5991-S4 MOVE_SPECIAL_TICK_LABEL_OUTSIDE_LABELS_BRANCH
	// Special Ticks Label
	ConstructSpecialLabelsBranchNodes(trAxis, nAxis);	
	///End MOVE_SPECIAL_TICK_LABEL_OUTSIDE_LABELS_BRANCH
	
	// Grids	
	ConstructGridsBranchNodes(trAxis, nAxis);	
	*/
	// Scale	
	ConstructScaleBranchNodes(trAxis);
	
	// Ticks Label
	ConstructLabelsBranchNodes(trAxis, nAxis);
	
	// Title	
	ConstructTitleBranchNodes(trAxis, nAxis); 
	
	// Grids	
	ConstructGridsBranchNodes(trAxis, nAxis);	
	
	// AxisFormat
	ConstructAxisFormatBranchNodes(trAxis, nAxis);
	
	// Special Ticks Label
	ConstructSpecialLabelsBranchNodes(trAxis, nAxis);	
	///End REORDER_PROPERTY_BRANCH_IN_LEFT_PANEL
	
	// Break
	if( m_stOptions.bIncBreak )
	{
		constructBreakNodes(trAxis);
	}	
}

/// Iris 6/13/2012 ORG-5991 MOVE_TICKS_AND_LINE_BRANCH_INTO_AXIS_FORMAT_BRANCH
void GeneralPlotAxesControlSplitter::ConstructTickValuesPropertyNodes(TreeNode& trScale)
{	
	GETN_USE(trScale)
	 
	GETN_BEGIN_BRANCH(MajorTicks, STR_MAJOR_TICKS_LABEL)  
	GETN_OPTION_BRANCH(GETNBRANCH_OPEN)	
	
		GETN_LIST(IncrementBy, STR_TYPE_LABEL, 0, _L("By Increment|By Counts|By Dataset")) GETN_ID(OTID_AXIS_SCALE_INCBY)	
		GETN_NUM(Value, STR_VALUE_LABEL, 0) GETN_ID(OTID_AXIS_SCALE_INC_VALUE)	
		GETN_NUM(MajorTicksCount, STR_COUNT_LABEL, 0) GETN_ID(OTID_AXIS_SCALE_MAJOR_COUNT) _tmpSubNode.Show = false; /// Iris 8/19/2011 COMBINE_INCVALUE_AND_MAJORTICKSCOUNT_AS_ONE_CONTROL			
		GETN_STRLIST(MajorTicksFromDataset, STR_DATASET_LABEL, "", "") GETN_ID(OTID_AXIS_SCALE_USER_MAJOR_TICKS) _tmpSubNode.Show = false;
			_update_dataset_list(_tmpSubNode);	
		
		GETN_STR(FirstTick, STR_FIRST_TICK_LABEL, "") GETN_ID(OTID_AXIS_SCALE_FIRST_TICK)
	GETN_END_BRANCH(MajorTicks)
	
	GETN_BEGIN_BRANCH(MinorTicks, STR_MINOR_TICKS_LABEL) 
	GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
	
		GETN_LIST(IncrementBy, STR_TYPE_LABEL, 0, _L("By Counts|By Dataset")) GETN_ID(ID_AXIS_MINOR_TICKS_INCBY)
		GETN_NUM(MinorTicksCount, STR_COUNT_LABEL, 1) GETN_ID(OTID_AXIS_SCALE_MINOR_COUNT)				
		GETN_STRLIST(MinorTicksFromDataset, STR_DATASET_LABEL, "", "") GETN_ID(OTID_AXIS_SCALE_USER_MINOR_TICKS) _tmpSubNode.Show = false;		
			_update_dataset_list(_tmpSubNode);
	GETN_END_BRANCH(MinorTicks)
}
///End MOVE_TICKS_AND_LINE_BRANCH_INTO_AXIS_FORMAT_BRANCH

void GeneralPlotAxesControlSplitter::ConstructAxisFormatBranchNodes(TreeNode& trAxis, int nAxis)
{
	GETN_USE(trAxis)
	
	/// Iris 8/08/2012 ORG-6463-S2 RENAME_AXIS_FORMAT_BRANCH
	//GETN_BEGIN_BRANCH(AxisFormat, STR_AXIS_FORMAT_LABEL)
	GETN_BEGIN_BRANCH(AxisFormat, STR_AXIS_LINE_AND_TICKS_LABEL)
	///End RENAME_AXIS_FORMAT_BRANCH
	
		GETN_MARK_STOP_BRANCH /// Iris 7/20/2012 ORG-6270-S1 IMPROVE_TICK_LABELS_BRANCH_SPEED
		GETN_ID_COLLECTION_BRANCH_EX(ID_AXIS_FORMATS)		
	GETN_END_BRANCH(AxisFormat)	
	
	ADD_AXIS_SUB_BRANCH(0, ConstructAxisFormatPropertyNodes(_tmpNode, nAxis, nSub))		
}

void GeneralPlotAxesControlSplitter::ConstructAxisFormatPropertyNodes(TreeNode& trBranch, int nAxis, int nSub)
{
	GETN_USE(trBranch)
		
	/// Iris 6/25/2012 ORG-5991-P7 FIX_SEL_BOTH_XY_AXES_CANNOT_DISPLAY_UNDEFINE_STATUS
	//GETN_CHECK(Show, STR_SHOW_LABEL, 1) GETN_ID(OTID_AXIS_TICK_SHOW)
	//_tmpSubNode.SetAttribute(STR_REPEAT_ID_ATTRIB, nSub + 1);	
	GETN_CHECK(Show, STR_SHOW_LABEL, 1)
	if( 0 == nSub )
		GETN_ID(ID_AXIS_FIRST_SHOW)
	else 
		GETN_ID(ID_AXIS_SECOND_SHOW)
	///End FIX_SEL_BOTH_XY_AXES_CANNOT_DISPLAY_UNDEFINE_STATUS
	
	// Line
	GETN_BEGIN_BRANCH(Line, STR_LINE_LABEL) GETN_ID_COLLECTION_MEMBER_REPEAT_BRANCH_EX(ID_AXIS_LINE, m_nLayerType, GetRepeatIndex(nSub, nAxis), nAxis)	
	GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
		GETN_COLOR(Color, STR_COLOR_LABEL, 0) GETN_ID(OTID_AXIS_TICK_COLOR) GETN_COLOR_CHOICE_OPTIONS(COLORLIST_SINGLE|COLORLIST_CUSTOM)
		vector vWidths = {0.2, 0.5, 1, 1.5, 2, 3, 4, 5};
		GETN_COMBO(Width, STR_THICKNESS_LABEL, 1.0, construct_double_combo_list(vWidths, "*2*", true)) GETN_ID(OTID_AXIS_TICK_WIDTH)	
			
		// axis line Position and Offset
		/// Iris 8/20/2012 ORG-6463-S6 UPDATE_AXIS_POSITION_CHOICE 
		//string strOneSubAxisName = trBranch.tagName;
		string strOneSubAxisName;
		trBranch.GetAttribute(STR_LABEL_ATTRIB, strOneSubAxisName);
		///End UPDATE_AXIS_POSITION_CHOICE
		string strList;
		strList = strOneSubAxisName;
		strList += "|" + STR_AXIS_PER_POSITION_LABEL + " " + strOneSubAxisName;
		strList += "|" + STR_AXIS_AT_POSITION_LABEL;
		GETN_LIST(Position, STR_AXIS_POSITION_LABEL, 0, strList) GETN_ID(OTID_AXIS_TICK_POSITION)
				
		GETN_NUM(Offset, STR_PERCENT_VALUE_LABEL, 0) GETN_ID(OTID_AXIS_TICK_OFFSET) GETN_OPTION_NUM_FORMAT("*")
				
		GETN_DATE(DateOffset, STR_PERCENT_VALUE_LABEL, 0) GETN_ID(ID_AXIS_POSITION_DATE_TYPE_OFFSET)
		_tmpSubNode.Show = false;
				
		GETN_TIME(TimeOffset, STR_PERCENT_VALUE_LABEL, 0) GETN_ID(ID_AXIS_POSITION_TIME_TYPE_OFFSET)
		_tmpSubNode.Show = false;
		
	GETN_END_BRANCH(Line)
	
	// Ticks
	GETN_BEGIN_BRANCH(Ticks, STR_TICKS_LABEL) GETN_ID_COLLECTION_MEMBER_REPEAT_BRANCH_EX(OTID_AXIS_TICK, m_nLayerType, GetRepeatIndex(nSub, nAxis), nAxis)	
	GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
		ConstructTicksPropertyNodes(trBranch.Ticks, true);		
		ConstructTicksPropertyNodes(trBranch.Ticks, false);
	GETN_END_BRANCH(Ticks)
}

int GeneralPlotAxesControlSplitter::GetRepeatIndex(bool bMajor, int nAxis/* = -1*/)
{ 
	int RepeatIndex = 0;	
	RepeatIndex = bMajor ? 2 : 1; // compare with Radar plot, the order is inverse 
	
	if( nAxis >= 0 )
	{
		DWORD dw = nAxis + 1;
		dw <<= 4;		
		RepeatIndex |= dw;
	}
	return RepeatIndex;
} 

//virtual 
TreeNode GeneralPlotAxesControlSplitter::getThemeAxesNode()
{
	return m_trTheme.Root.TAG_AXES;
}

//virtual 
string GeneralPlotAxesControlSplitter::getThemeAxisNodeName(int nAxis)
{
	const vector<string> vsAxisName = {"X", "Y", "Z"};
	if( nAxis >= 0 && nAxis < vsAxisName.GetSize() )
		return vsAxisName[nAxis];
	
	ASSERT(false);
	return "";	
}

string GeneralPlotAxesControlSplitter::getAxisLabelName(int nAxis, const GraphLayer& glParent)
{
	if( nAxis < 0 )
		return STR_AXES_LABEL;
	return getThemeAxisNodeName(nAxis) + " " + STR_AXIS_LABEL;
}

// virtual
string GeneralPlotAxesControlSplitter::getAxisSubBranchName(int nAxis, int nSubAxis, bool bLabel)
{
	string str;
	switch(nAxis)
	{
	case AXIS_X:
		 str = bLabel ? STR_X_SUB_AXIS_LABELS : STR_X_SUB_AXIS_E_LABELS;
		 break;
		 
	case AXIS_Y:
		 str = bLabel ? STR_Y_SUB_AXIS_LABELS : STR_Y_SUB_AXIS_E_LABELS;
		 break;
	
	case AXIS_Z:
		 str = bLabel ? STR_Z_SUB_AXIS_LABELS : STR_Z_SUB_AXIS_E_LABELS;
		 break;
		 
	default:
		ASSERT(false);
		break;
	}
	
	if( nSubAxis >= 0 )
	{
		str = str.GetToken(nSubAxis, '|');
	}	
	return str;
}

string GeneralPlotAxesControlSplitter::GetAxisSubBranchLabel(int nAxis, int nSubAxis)
{
	return getAxisSubBranchName(nAxis, nSubAxis, true);
}

// virtual
void GeneralPlotAxesControlSplitter::GetAxisPropertyCustomOptions()
{		
	m_stOptions.bIncAdditionalLines = true;
	/// Iris 6/13/2012 ORG-5991 MOVE_TICKS_AND_LINE_BRANCH_INTO_AXIS_FORMAT_BRANCH
	//m_stOptions.bIncAxisPosition = true;	
	//m_stOptions.bTickSettingsInScale = false;
	//m_stOptions.bIncFirstTick = true;	
	///End MOVE_TICKS_AND_LINE_BRANCH_INTO_AXIS_FORMAT_BRANCH
	
	/// Iris 6/06/2012 ORG-5528-S7 ADD_SHOW_CHECKBOX_FOR_TITLES
	//m_stOptions.bIncTitleShow = false;
	m_stOptions.bIncTitleShow = true;
	///End ADD_SHOW_CHECKBOX_FOR_TITLES
	m_stOptions.bIncTitleText = true;	
	m_stOptions.bIncBreak = true;	
}

// virtual
void GeneralPlotAxesControlSplitter::ConstructTicksPropertyNodes(TreeNode& trBranch, bool bMajor)
{
	/// Iris 6/13/2012 ORG-5991 MOVE_TICKS_AND_LINE_BRANCH_INTO_AXIS_FORMAT_BRANCH
	/*
	GETN_USE(trBranch)	
	
	GETN_RADIO_INDEX_EX(IncrementBy, "", 0, "") 
	string strRadioLabel = _L("By Count|By Dataset");
	if( bMajor )
		strRadioLabel = _L("By Increment") + "|" + strRadioLabel;	
	_tmpSubNode.SetAttribute(STR_COMBO_ATTRIB, strRadioLabel);
	int nID = bMajor ? OTID_AXIS_SCALE_INCBY : ID_AXIS_MINOR_TICKS_INCBY;
	_tmpSubNode.SetAttribute(STR_DATAID_ATTRIB, nID); // for Minor, no IncrementBy node in theme tree, so no need to add ID for it.
	
	/// Iris 5/17/2012 ORG-5528-S5 MOVE_TICKS_COUNT_NODES_TO_TICKS_BRANCH_FOR_GL_GRAPH
	if( bMajor )
	{	
		GETN_NUM(Value, STR_VALUE_LABEL, 0) GETN_ID(OTID_AXIS_SCALE_INC_VALUE)
		GETN_NUM(MajorTicksCount, STR_COUNT_LABEL, 0) GETN_ID(OTID_AXIS_SCALE_MAJOR_COUNT) _tmpSubNode.Show = false;			
		GETN_STRLIST(MajorTicksFromDataset, STR_DATASET_LABEL, "", "") GETN_ID(OTID_AXIS_SCALE_USER_MAJOR_TICKS) _tmpSubNode.Show = false;
			_update_dataset_list(_tmpSubNode);			
	}
	else
	{
		GETN_NUM(MinorTicksCount, STR_COUNT_LABEL, 1) GETN_ID(OTID_AXIS_SCALE_MINOR_COUNT) _tmpSubNode.Show = false;				
		GETN_STRLIST(MinorTicksFromDataset, STR_DATASET_LABEL, "", "") GETN_ID(OTID_AXIS_SCALE_USER_MINOR_TICKS) _tmpSubNode.Show = false;		
			_update_dataset_list(_tmpSubNode);		
	}
	GETN_SEPARATOR_LINE	
	
	if( bMajor )
	{
		if( m_stOptions.bIncFirstTick )
		{			
			GETN_STR(FirstTick, STR_FIRST_TICK_LABEL, "") GETN_ID(OTID_AXIS_SCALE_FIRST_TICK)
		}
	}
	///End MOVE_TICKS_COUNT_NODES_TO_TICKS_BRANCH_FOR_GL_GRAPH	
	
	AxesControlSplitter::ConstructTicksPropertyNodes(trBranch, bMajor);
	
	if( trBranch.Type )
	{
		TreeNode trNewType = trBranch.InsertNode(trBranch.Type, bMajor ? "Major" : "Minor");
		trNewType.Replace(trBranch.Type, false, true, false);
		trNewType.DataID = bMajor ? OTID_AXIS_TICK_MAJOR : OTID_AXIS_TICK_MINOR;
		trNewType.SetAttribute(STR_LABEL_ATTRIB, bMajor ? STR_MAJOR_TICKS_LABEL : STR_MINOR_TICKS_LABEL);
		trBranch.Type.Remove();	
	}	
	if( trBranch.Length )
		trBranch.Length.SetAttribute(STR_LABEL_ATTRIB, STR_TICK_LENGTH_LABEL);
	*/
	vector vLengths = {3, 5, 8, 10, 15};
	string strLengthCombo = construct_double_combo_list(vLengths, "*", true);
	
	GETN_USE(trBranch)		
	if( bMajor )
	{
		GETN_LIST(Major, STR_MAJOR_TICKS_LABEL, 0, "") GETN_ID(OTID_AXIS_TICK_MAJOR) GETN_ADD_COMBO		
		GETN_COMBO(Length, STR_LENGTH_LABEL, 0, strLengthCombo) GETN_ID(OTID_AXIS_TICK_LENGTH)			
	}
	else
	{
		GETN_LIST(Minor, STR_MINOR_TICKS_LABEL, 0, "") GETN_ID(OTID_AXIS_TICK_MINOR) GETN_ADD_COMBO		
		GETN_COMBO(MinorLength, STR_LENGTH_LABEL, 0, strLengthCombo) GETN_ID(OTID_AXIS_TICK_MINOR_LENGTH)	
	}
	///End MOVE_TICKS_AND_LINE_BRANCH_INTO_AXIS_FORMAT_BRANCH
}

// virtual
void GeneralPlotAxesControlSplitter::ConstructLabelsBranchNodes(TreeNode& trBranch, int nAxis)
{
	GETN_USE(trBranch)	

	GETN_BEGIN_BRANCH(Labels, STR_TICK_LABELS_LABEL) GETN_ID_COLLECTION_BRANCH_EX(OTID_AXIS_LABELS)	
		GETN_MARK_STOP_BRANCH /// Iris 7/20/2012 ORG-6270-S1 IMPROVE_TICK_LABELS_BRANCH_SPEED
	GETN_END_BRANCH(Labels)	
	
	ADD_AXIS_SUB_BRANCH(OTID_AXIS_LABEL, constructTicksLabelPropertyNodes(_tmpNode, nAxis))	
}

void GeneralPlotAxesControlSplitter::constructTicksLabelPropertyNodes(TreeNode& trBranch, int nAxis)
{
	GETN_USE(trBranch)	
	
	/// Iris 8/08/2012 ORG-6463-S3 ADD_AXIS_SHOW_PROPERTY_IN_AXIS_ROOT_BRANCH	
	GETN_CHECK(ShowMajor, STR_SHOW_MAJOR_LABELS_LABEL, 1) GETN_ID(OTID_AXIS_LABEL_SHOW)
	GETN_CHECK(ShowMinor, STR_SHOW_MINOR_LABELS_LABEL, 0) GETN_ID(OTID_AXIS_LABEL_SHOW_MINOR)		
	///End ADD_AXIS_SHOW_PROPERTY_IN_AXIS_ROOT_BRANCH
	
	/// Iris 8/02/2012 ORG-5991-S5 REARRANGE_TICK_LABEL_CONTROLS
	//GETN_BEGIN_BRANCH(MajorLabels, STR_MAJOR_TICK_LABELS_LABEL) GETN_ID(-1) //GETN_ID_COLLECTION_MEMBER_REPEAT_BRANCH_EX(OTID_AXIS_LABEL, m_nLayerType, GetRepeatIndex(true), nAxis)	
	GETN_BEGIN_BRANCH(MajorLabels, STR_DISPLAY_LABEL) GETN_ID(-1)
	///End REARRANGE_TICK_LABEL_CONTROLS
	GETN_OPTION_BRANCH(GETNBRANCH_OPEN)			
		GETN_LIST(Type, STR_TYPE_LABEL, 0, "") GETN_ID(OTID_AXIS_LABEL_TYPE) GETN_ADD_COMBO 		
		/// Iris 5/17/2012 ORG-5719-P1 CHANGED_DATASET_CONTROL_FROM_INTERACTIVE_TO_STRLIST
		//GETN_INTERACTIVE(DatasetName, STR_DATASET_NAME_LABEL, "") GETN_ID(OTID_AXIS_LABEL_DATASET_NAME) 
		GETN_STRLIST(DatasetName, STR_DATASET_NAME_LABEL, "", "") GETN_ID(OTID_AXIS_LABEL_DATASET_NAME) 
			//_tmpSubNode.SetAttribute(STR_COMBO_ATTRIB, okutil_get_dataset_list());
			_update_dataset_list(_tmpSubNode);
		///End CHANGED_DATASET_CONTROL_FROM_INTERACTIVE_TO_STRLIST
		GETN_LIST(NumericDisplay, STR_DISPLAY_LABEL, 0, "") GETN_ID(OTID_AXIS_LABEL_NUMERIC) GETN_ADD_COMBO
		GETN_LIST(MonthDisplay, STR_DISPLAY_LABEL, 0, "") GETN_ID(OTID_AXIS_LABEL_MONTH) GETN_ADD_COMBO
		GETN_LIST(DayDisplay, STR_DISPLAY_LABEL, 0, "") GETN_ID(OTID_AXIS_LABEL_DAY) GETN_ADD_COMBO
		GETN_LIST(TimeDisplay, STR_DISPLAY_LABEL, 0, "") GETN_ID(OTID_AXIS_LABEL_TIME) GETN_ADD_COMBO
		GETN_LIST(DateDisplay, STR_DISPLAY_LABEL, 0, "") GETN_ID(OTID_AXIS_LABEL_DATE) GETN_ADD_COMBO				
		GETN_STR(TextDisplay, STR_DISPLAY_LABEL, "")	GETN_ID(OTID_AXIS_LABEL_STRING)				
		/// Iris 5/21/2012 ORG-4218-P5 ADD_DATETIME_CUSTOM_FORMAT_CONTROL
		GETN_STRLIST(DateCustomDisplay, STR_CUSTOM_DISPLAY_LABEL, "", "") GETN_ID(OTID_AXIS_LABEL_DATE_CUSTOM_DISPLAY) GETN_ADD_COMBO 
		GETN_STRLIST(TimeCustomDisplay, STR_CUSTOM_DISPLAY_LABEL, "", "") GETN_ID(OTID_AXIS_LABEL_TIME_CUSTOM_DISPLAY) GETN_ADD_COMBO
		///End ADD_DATETIME_CUSTOM_FORMAT_CONTROL
				
		/// Iris 8/01/2012 ORG-5991-P14 IMPORVE_CUSTOM_DECIMAL_CONTROL_DISPLAY
		// re-order the two controls
		//GETN_STR(hits, _L("*nn is to specify the number of significant digits, .nn is to specify the number of decimal places \nExample: *2 ( two significant digits), .3 ( three decimal places)"), "") GETN_HINT 
		//GETN_STRLIST(CustomDecimal, STR_CUSTOM_FORMAT_LABEL, E_STR_CUSTOM_DEFAULT_FORMAT, "|*3|*4|.2|.3|.4") GETN_ID(OTID_AXIS_LABEL_MANUAL_DEC) GETN_ADD_LEFT_CHECK(0)
		///Sophy 8/3/2012 ORG-2639-P8 SHOW_BUILDIN_FORMAT_IN_CUSTOM_DISPLAY_FORMAT_LIST
		//GETN_STRLIST(CustomDecimal, STR_CUSTOM_FORMAT_LABEL, E_STR_CUSTOM_DEFAULT_FORMAT, "|*3|*4|.2|.3|.4") GETN_ID(OTID_AXIS_LABEL_MANUAL_DEC) GETN_ADD_LEFT_CHECK(0)
		GETN_STRLIST(CustomDecimal, STR_CUSTOM_FORMAT_LABEL, E_STR_CUSTOM_DEFAULT_FORMAT, STR_AXIS_LABEL_CUSTOM_DISPLAY_LIST) GETN_ID(OTID_AXIS_LABEL_MANUAL_DEC) GETN_ADD_LEFT_CHECK(0)
		///end SHOW_BUILDIN_FORMAT_IN_CUSTOM_DISPLAY_FORMAT_LIST
		GETN_STR(hits, _L("*nn is to specify the number of significant digits, .nn is to specify the number of decimal places \nExample: *2 ( two significant digits), .3 ( three decimal places)"), "") GETN_HINT 
		_tmpSubNode.Show = false;
		///End IMPORVE_CUSTOM_DECIMAL_CONTROL_DISPLAY
		GETN_STR(DivideByFactor, STR_DIVIDE_BY_FACTOR_LABEL, "")	GETN_ID(OTID_AXIS_LABEL_DIVIDE_BY_FACTOR)
		GETN_STR(Prefix, STR_PREFIX_LABEL, "")						GETN_ID(OTID_AXIS_LABEL_PREFIX)
		GETN_STR(Suffix, STR_SUFFIX_LABEL, "")						GETN_ID(OTID_AXIS_LABEL_SUFFIX)				
	GETN_END_BRANCH(MajorLabels)
	
	/// Iris 8/08/2012 ORG-6463-S3 ADD_AXIS_SHOW_PROPERTY_IN_AXIS_ROOT_BRANCH
	// move to the top of the branch
	//GETN_CHECK(ShowMajor, STR_SHOW_MAJOR_LABELS_LABEL, 1) GETN_ID(OTID_AXIS_LABEL_SHOW)
	//GETN_CHECK(ShowMinor, STR_SHOW_MINOR_LABELS_LABEL, 0) GETN_ID(OTID_AXIS_LABEL_SHOW_MINOR)		
	///End ADD_AXIS_SHOW_PROPERTY_IN_AXIS_ROOT_BRANCH
	
	// Format
	GETN_BEGIN_BRANCH(Format, STR_FORMAT_LABEL)	
		GETN_ID(-1) /// Iris 11/10/2011 ORG-3962-P3 FIX_CONTROLS_IN_FORMAT_AND_OFFSET_BRANCH_NOT_WORKED, this branch not existed in theme tree, set id as -1, in order to remove it before apply format
		GETN_COLOR(Color, STR_COLOR_LABEL, INDEX_COLOR_AUTOMATIC) GETN_ID(OTID_AXIS_LABEL_COLOR) GETN_COLOR_CHOICE_OPTIONS(COLORLIST_SINGLE|COLORLIST_CUSTOM|COLORLIST_AUTO)
		/// Iris 6/06/2012 ORG-5528-P9 REMOVE_DOT_FROM_TICKLABEL_ROTATE_CONTROL
		//GETN_STR(Angle, STR_ROTATE_LABEL, "") GETN_ID(OTID_AXIS_LABEL_ANGLE)
		GETN_NUM(Angle, STR_ROTATE_LABEL, 0) GETN_ID(OTID_AXIS_LABEL_ANGLE)
		///End REMOVE_DOT_FROM_TICKLABEL_ROTATE_CONTROL
		
		// Font
		GETN_BEGIN_BRANCH(Font, STR_FONT_LABEL) GETN_ID(OTID_AXIS_LABEL_FONT)
		GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
			GETN_FONT(Face, STR_FONT_LABEL, 0)GETN_ID(OTID_AXIS_LABEL_FONT_FACE)
			GETN_COMBO(Size, STR_FONT_SIZE_LABEL, 18, "|8|9|10|11|12|14|16|18|20|22|24|26|28|36|48|72") GETN_ID(OTID_AXIS_LABEL_FONT_SIZE)			
			GETN_STR(ActualSize, "", "") GETN_READ_ONLY_COLOR /// Iris 6/27/2012 ORG-5528 ADD_ACTUAL_FONT_SIZE_IN_AXES_DLG
			GETN_CHECK(Bold, STR_FONT_BOLD_LABEL, 0) GETN_ID(OTID_AXIS_LABEL_FONT_BOLD)
		GETN_END_BRANCH(Font)		
		
		GETN_CHECK(ShowPlus, STR_PLUS_SIGN_LABEL, 0) GETN_ID(OTID_AXIS_LABEL_SHOW_PLUS)
		GETN_CHECK(ShowMinus, STR_MINUS_SIGN_LABEL, 0) GETN_ID(OTID_AXIS_LABEL_SHOW_MINUS)
	GETN_END_BRANCH(Format)		
	
	
	GETN_BEGIN_BRANCH(Misc, STR_MISC_BRANCH_LABEL) GETN_ID(-1)
		GETN_LIST(TickToLabel, STR_TICK_TO_LABEL, 0, "") GETN_ID(OTID_AXIS_LABEL_ALIGN) GETN_ADD_COMBO
		
		GETN_BEGIN_BRANCH(Offset, STR_OFFSET_IN_POINT_SIZE_LABEL)
		GETN_ID(-1) /// Iris 11/10/2011 ORG-3962-P3 FIX_CONTROLS_IN_FORMAT_AND_OFFSET_BRANCH_NOT_WORKED, this branch not existed in theme tree, set id as -1, in order to remove it before apply format				
			GETN_NUM(XOffset,	STR_HORIZONTAL_LABEL, 0)			GETN_ID(OTID_AXIS_LABEL_XOFFSET)
			GETN_NUM(YOffset,	STR_VERTICAL_LABEL, 0)	 			GETN_ID(OTID_AXIS_LABEL_YOFFSET)				
		GETN_END_BRANCH(Offset)	
		
		GETN_CHECK(LabelsStayWithAxis, STR_LABELS_STAY_WITH_AXIS, 1) GETN_ID(OTID_AXIS_LABEL_STAY_WITH_TICKS)
		GETN_CHECK(MinorOnMajor, STR_MINOR_LABELS_ON_MAJOR_TICKS_LABEL, 0) GETN_ID(OTID_AXIS_LABEL_MINOR_ON_MAJOR)
		GETN_STR(MajorOffset, STR_OFFSET_MAJOR_BY_LABEL, "") GETN_ID(OTID_AXIS_LABEL_MAJOR_OFFSET)				
	GETN_END_BRANCH(Misc)
}

/// Iris 6/21/2012 ORG-5991-S4 MOVE_SPECIAL_TICK_LABEL_OUTSIDE_LABELS_BRANCH
void GeneralPlotAxesControlSplitter::ConstructSpecialLabelsBranchNodes(TreeNode& trAxis, int nAxis/* = -1*/)
{
	GETN_USE(trAxis)
	
	GETN_BEGIN_BRANCH(SpecialLabels, STR_SPECIAL_TICK_LABELS_LABEL) GETN_ID(OTID_AXIS_SPECIALTICKS)	
		GETN_MARK_STOP_BRANCH /// Iris 7/20/2012 ORG-6270-S1 IMPROVE_TICK_LABELS_BRANCH_SPEED
	GETN_END_BRANCH(SpecialLabels)
	
	ADD_AXIS_SUB_BRANCH(ID_AXIS_SPECIALTICK, ConstructSpecialLabelPropertyNodes(_tmpNode, nAxis))
}

void GeneralPlotAxesControlSplitter::ConstructSpecialLabelPropertyNodes(TreeNode& trBranch, int nAxis/* = -1*/)
{
	GETN_USE(trBranch)	
	
	GETN_LIST(Begin, STR_AXIS_BEGIN_LABEL, 0, STR_SPECIAL_TICKS_TYPE_LIST) GETN_ID(ID_AXIS_SPECIALTICK_BEGIN)
	GETN_STR(BeginLabel, STR_LABEL, "") GETN_ID(ID_AXIS_SPECIALTICK_BEGIN_LABEL)
	
	GETN_LIST(End, STR_AXIS_END_LABEL, 0, STR_SPECIAL_TICKS_TYPE_LIST) GETN_ID(ID_AXIS_SPECIALTICK_END)
	GETN_STR(EndLabel, STR_LABEL, "") GETN_ID(ID_AXIS_SPECIALTICK_END_LABEL)
	
	GETN_LIST(Special, STR_SPECIAL_LABEL, 0, STR_SPECIAL_TICKS_TYPE_LIST) GETN_ID(ID_AXIS_SPECIALTICK_SPECIAL_BEGIN)
	GETN_STR(SpecialValue, STR_AT_AXIS_VALUE_LABEL, "") GETN_ID(ID_AXIS_SPECIALTICK_SPECIAL_BEGIN_VALUE)
	GETN_STR(SpecialLabel, STR_LABEL, "") GETN_ID(ID_AXIS_SPECIALTICK_SPECIAL_BEGIN_LABEL)
}
///End MOVE_SPECIAL_TICK_LABEL_OUTSIDE_LABELS_BRANCH

void GeneralPlotAxesControlSplitter::constructBreakNodes(TreeNode& trBranch)
{
	GETN_USE(trBranch)
	
	GETN_BEGIN_BRANCH(Break, STR_BREAK_LABEL) GETN_ID(OTID_AXIS_BREAK)
		GETN_MARK_STOP_BRANCH /// Iris 7/20/2012 ORG-6270-S1 IMPROVE_TICK_LABELS_BRANCH_SPEED
		
		GETN_CHECK(SHOW, STR_SHOW_LABEL, 0) GETN_ID(OTID_AXIS_BREAK_ENABLE)
		
		GETN_BEGIN_BRANCH(BreakRegion, STR_BREAK_REGION_LABEL) //GETN_ID(-1)
		GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
			GETN_NUM(RegionFrom, STR_REGION_FROM_LABEL, 0) 			GETN_ID(OTID_AXIS_BREAK_REGION_FROM)
			GETN_NUM(RegionTo, STR_REGION_TO_LABEL, 0) 				GETN_ID(OTID_AXIS_BREAK_REGION_TO)
			GETN_NUM(Position, STR_PRECENT_OF_AXIS_LENGTH, 0) 		GETN_ID(OTID_AXIS_BREAK_POSITION)
		GETN_END_BRANCH(BreakRegion)
	
		GETN_CHECK(LogScaleAfter, STR_LOG_SCALE_AFTER_LABEL, 0) 	GETN_ID(OTID_AXIS_BREAK_LOG_SCALE_AFTER)
		
		GETN_BEGIN_BRANCH(ScaleInc, STR_SCALE_INCREMENT_LABEL) 		//GETN_ID(-1)
		GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
			GETN_NUM(ScaleIncBefore, STR_BEFORE_LABEL, 1) 			GETN_ID(OTID_AXIS_BREAK_SCALE_INC_BEFORE)
			GETN_NUM(ScaleIncAfter, STR_AFTER_LABEL, 1) 			GETN_ID(OTID_AXIS_BREAK_SCALE_INC_AFTER)
		GETN_END_BRANCH(ScaleInc)
		
		GETN_BEGIN_BRANCH(MinorTicks, STR_MINOR_TICKS_LABEL) 		//GETN_ID(-1)	
		GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
			GETN_NUM(NumTicksBefore, STR_BEFORE_LABEL, 1) 			GETN_ID(OTID_AXIS_BREAK_NUM_TICKS_BEFORE)
			GETN_NUM(NumTicksAfter, STR_AFTER_LABEL, 1) 			GETN_ID(OTID_AXIS_BREAK_NUM_TICKS_AFTER)
		GETN_END_BRANCH(MinorTicks)
		
	GETN_END_BRANCH(Break)
}


// virtual
/// Iris 6/13/2012 ORG-5991 MOVE_TICKS_AND_LINE_BRANCH_INTO_AXIS_FORMAT_BRANCH
//TreeNode GeneralPlotAxesControlSplitter::GetTicksCountParentNode(TreeNode& trGetNOneAxis, int nAxis, int nSubAxisIndex, bool bMajor)
TreeNode GeneralPlotAxesControlSplitter::GetTicksCountParentNode(TreeNode& trGetNOneAxis, bool bMajor)
///End MOVE_TICKS_AND_LINE_BRANCH_INTO_AXIS_FORMAT_BRANCH
{
	/// Iris 6/13/2012 ORG-5991 MOVE_TICKS_AND_LINE_BRANCH_INTO_AXIS_FORMAT_BRANCH
	/*
	ASSERT(trGetNOneAxis.Ticks);
	if( trGetNOneAxis.Ticks )
	{	
		int nBranchID = GetColletionMemberBranchNode(OTID_AXIS_TICK, nSubAxisIndex, nAxis);
		TreeNode trCollBranch = _get_GetN_node_by_id(trGetNOneAxis.Ticks, nBranchID);
		if( trCollBranch )
		{
			if( bMajor )
				return trCollBranch.MajorTicks;
			else
				return trCollBranch.MinorTicks;
		}
	}
	TreeNode trJunk; // error, not found node
	return trJunk;
	*/
	
	if( bMajor )
		return trGetNOneAxis.Scale.MajorTicks;
	else
		return trGetNOneAxis.Scale.MinorTicks;	
	///End MOVE_TICKS_AND_LINE_BRANCH_INTO_AXIS_FORMAT_BRANCH
}

//void GeneralPlotAxesControlSplitter::copyValuesFromThemeScaleToGetNTicks(TreeNode& trThemeScale, TreeNode& trGetNSubTicks, bool bMajor)
//{
	//// copy values from trTheme.Scale branch to GetN.Ticks.BottomTicks.Major/Minor, and GetN.Ticks.TopTicks.Major/Minor branchs
	//int nDatasetID = bMajor ? OTID_AXIS_SCALE_USER_MAJOR_TICKS : OTID_AXIS_SCALE_USER_MINOR_TICKS;
	//int nTicksCountID = bMajor ? OTID_AXIS_SCALE_MAJOR_COUNT : OTID_AXIS_SCALE_MINOR_COUNT;
	//TreeNode trGetNDataset = _get_GetN_node_by_id(trGetNSubTicks, nDatasetID);
	//TreeNode trGetNTicksCount = _get_GetN_node_by_id(trGetNSubTicks, nTicksCountID);		
	//
	//TreeNode trThemeDataset = _get_theme_node_by_id(trThemeScale, nDatasetID);
	//if( trThemeDataset && !trThemeDataset.IsEmpty() )
	//{
		//trGetNSubTicks.IncrementBy.nVal = bMajor ? SET_MAJOR_TICKS_BY_DATASET : SET_MINOR_TICKS_BY_DATASET;					
		//trGetNDataset.strVal = trThemeDataset.strVal;		
	//}		
	//else
	//{
		//if( !bMajor )
		//{
			//trGetNSubTicks.IncrementBy.nVal = SET_MINOR_TICKS_BY_COUNT;			
		//}
		//else
		//{
			//// copy Increment By		
			//trGetNSubTicks.IncrementBy.nVal = trThemeScale.IncrementBy ? trThemeScale.IncrementBy.nVal : 0;			
				//
			//// Value, copy value
			//if( trThemeScale.Value && trGetNSubTicks.Value )
			//{
				//trGetNSubTicks.Value.dVal = trThemeScale.Value.dVal;			
			//}	
				//
		//}
		//
		//// Count, copy value
		//TreeNode trThemeTicksCount = _get_theme_node_by_id(trThemeScale, nTicksCountID);
		//if( trThemeTicksCount )
		//{
			//trGetNTicksCount.nVal = trThemeTicksCount.nVal;			
		//}											
	//}				
//}

//virtual 
void GeneralPlotAxesControlSplitter::updateGetNScaleAfterCopyValuesFromTheme(TreeNode& trGetN, TreeNode& trGetNOneAxis, int nAxis)
{
	/// Iris 7/19/2012 ORG-6246-P1 SETUP_SCALE_DISPLAY_VALUE_ON_AFTER_DIVIDE_FACTOR_CHANGE
	AxesControlSplitter::updateGetNScaleAfterCopyValuesFromTheme(trGetN, trGetNOneAxis, nAxis);
	///End SETUP_SCALE_DISPLAY_VALUE_ON_AFTER_DIVIDE_FACTOR_CHANGE
	
	/// Iris 6/13/2012 ORG-5991 MOVE_TICKS_AND_LINE_BRANCH_INTO_AXIS_FORMAT_BRANCH
	/*
	TreeNode trScale = trGetNOneAxis.Scale;
	foreach(TreeNode trBranch in trGetNOneAxis.Ticks.Children)
	{
		if( trBranch.GetNodeCount() > 0 && trBranch.DataID > 0 && IS_THEME_COLL_MEMBER(trBranch.DataID) ) // bottom/top branch
		{
	*/
	TreeNode trBranch, trScale;
	trBranch = trScale = trGetNOneAxis.Scale;
	///End MOVE_TICKS_AND_LINE_BRANCH_INTO_AXIS_FORMAT_BRANCH
	
	TreeNode trMajorSubBranch = trBranch.MajorTicks;			
	if( trMajorSubBranch )
	{				
		ConvertIncrementValueAndTicksCount(trMajorSubBranch, trScale);
		convertIncrementByWithDatasetString(trMajorSubBranch, true);
		UpdateControlsByIncrementByChange(trMajorSubBranch); // udpate controls show/hide with InrementBy
	}
	
	TreeNode trMinorSubBranch = trBranch.MinorTicks;
	if( trMinorSubBranch )
	{
		convertIncrementByWithDatasetString(trMinorSubBranch, false);
		UpdateControlsByIncrementByChange(trMinorSubBranch); // udpate controls show/hide with InrementBy
	}
	
	/// Iris 6/13/2012 ORG-5991 MOVE_TICKS_AND_LINE_BRANCH_INTO_AXIS_FORMAT_BRANCH
	/*
		}
	}
	*/
	///End MOVE_TICKS_AND_LINE_BRANCH_INTO_AXIS_FORMAT_BRANCH
	UpdateControlsByScaleTypeChange(trGetNOneAxis, nAxis);	
}

void GeneralPlotAxesControlSplitter::convertIncrementByWithDatasetString(TreeNode& trBranch, bool bMajor)
{	
	if( trBranch && trBranch.IncrementBy )
	{
		TreeNode trDataset = bMajor ? trBranch.MajorTicksFromDataset : 	trBranch.MinorTicksFromDataset;	
		if( trDataset && !trDataset.strVal.IsEmpty() )
		{
			trBranch.IncrementBy.nVal = bMajor ? SET_MAJOR_TICKS_BY_DATASET : SET_MINOR_TICKS_BY_DATASET;
		}			
	}
}

bool GeneralPlotAxesControlSplitter::isInThemeScale(int nEditNodeDataID)
{
	return ( 
		OTID_AXIS_SCALE_INCBY == nEditNodeDataID
		|| OTID_AXIS_SCALE_INC_VALUE == nEditNodeDataID
		|| OTID_AXIS_SCALE_MAJOR_COUNT == nEditNodeDataID
		|| OTID_AXIS_SCALE_MINOR_COUNT == nEditNodeDataID
		|| OTID_AXIS_SCALE_USER_MAJOR_TICKS == nEditNodeDataID
		|| OTID_AXIS_SCALE_USER_MINOR_TICKS == nEditNodeDataID
		|| OTID_AXIS_SCALE_FIRST_TICK == nEditNodeDataID		
	);	
}
///End MOVE_TICKS_COUNT_NODES_TO_TICKS_BRANCH_FOR_GL_GRAPH

//virtual 
void GeneralPlotAxesControlSplitter::CopyValuesFromThemeToGetNForOneAxis(TreeNode& trGetN, int nAxis, TreeNode& trThemeOneAxis, TreeNode& trGetNOneAxis)
{
	AxesControlSplitter::CopyValuesFromThemeToGetNForOneAxis(trGetN, nAxis, trThemeOneAxis, trGetNOneAxis);
	
	// copy settings for Axis Position and Offset 
	/// Iris 6/01/2012 ORG-5528-P3 FIX_LINE_OFFSET_DEFAULT_SHOULD_BE_HIDDEN
	/// Iris 6/13/2012 ORG-5991 MOVE_TICKS_AND_LINE_BRANCH_INTO_AXIS_FORMAT_BRANCH
	//foreach(TreeNode trSubBranch in trGetNOneAxis.Line.Children)
	foreach(TreeNode trSubBranch in trGetNOneAxis.AxisFormat.Children)
	///End MOVE_TICKS_AND_LINE_BRANCH_INTO_AXIS_FORMAT_BRANCH
	{
		if( trSubBranch.GetNodeCount() > 0 ) // sub axis branch
		{
			TreeNode trLineBranch = trSubBranch.Line;
			if( trLineBranch.Offset && trLineBranch.Position )
			{
				trLineBranch.Offset.SetAttribute(STR_POSITION_TYPE_ATTRIB, trLineBranch.Position.nVal);
				if( trLineBranch.DateOffset )
					trLineBranch.DateOffset.strVal = trLineBranch.Offset.strVal;
				if( trLineBranch.TimeOffset )
					trLineBranch.TimeOffset.strVal = trLineBranch.Offset.strVal;
				
				int nSubAxis = GetSubAxisIndex(trLineBranch);
				AxisObject ao;
				if( _get_axis_object(ao, m_gl, nAxis, 0 == nSubAxis ? AXISOBJPOS_AXIS_FIRST : AXISOBJPOS_AXIS_SECOND) )
				{
					/// Iris 8/22/2012 ORG-6463-P6 IMPROVE_AXIS_POSITION_REFER_AXIS
					//_update_position_offset_show_hide(trLineBranch, m_gl, ao);
					_update_position_offset_show_hide(trLineBranch, m_gl, ao, GetAutoHideStatus());
					///End IMPROVE_AXIS_POSITION_REFER_AXIS
				}
			}
		}
	}
	///End FIX_LINE_OFFSET_DEFAULT_SHOULD_BE_HIDDEN	
	
	// copy settings for the Type/Length of Major/Minor Ticks 
	/// Iris 6/13/2012 ORG-5991 MOVE_TICKS_AND_LINE_BRANCH_INTO_AXIS_FORMAT_BRANCH
	//if( trGetNOneAxis.Line && trThemeOneAxis.Ticks )
	if( trGetNOneAxis.AxisFormat && trThemeOneAxis.Ticks )
	///End MOVE_TICKS_AND_LINE_BRANCH_INTO_AXIS_FORMAT_BRANCH
	{
		int nSubAxisIndex = 0;					
			
		while( true )
		{
			/// Iris 7/13/2012 ORG-5991-P9 FIX_PROPERTY_IN_YAXIS_NOT_BE_CHANGED_WHEN_APPLY_CHANGES_WITH_SELECT_OTHERS
			//int nID = GetColletionMemberBranchNode(OTID_AXIS_TICK, _CHECK_CONVERT_SUB_AXIS_INDEX(nSubAxisIndex), nAxis);			
			int nID = GetColletionMemberBranchNode(OTID_AXIS_TICK, _CHECK_CONVERT_SUB_AXIS_INDEX(nAxis, nSubAxisIndex), nAxis);
			///End FIX_PROPERTY_IN_YAXIS_NOT_BE_CHANGED_WHEN_APPLY_CHANGES_WITH_SELECT_OTHERS
			TreeNode trThemeTickBranch = _get_theme_node_by_id(trThemeOneAxis.Ticks, nID, false);
			TreeNode trGetNTickBranch = _get_GetN_node_by_id(trGetNOneAxis.AxisFormat, nID, true);
			if( trThemeTickBranch && trGetNTickBranch )
			{					
				ASSERT(trThemeTickBranch.ID == trGetNTickBranch.DataID);
				tree_copy_values_by_id(trThemeTickBranch, trGetNTickBranch);
				
				// copy axis Show property
				/// Iris 6/25/2012 ORG-5991-P7 FIX_SEL_BOTH_XY_AXES_CANNOT_DISPLAY_UNDEFINE_STATUS
				/*
				int nBranchIndex = 0;				
				foreach(TreeNode trGetNSubAxis in trGetNOneAxis.AxisFormat.Children)
				{
					if( trGetNSubAxis.GetNodeCount() > 0 ) // is branch
					{
						if( nBranchIndex == nSubAxisIndex )
							break;
						nBranchIndex++;
					}					
				}
				
				if( trGetNSubAxis )
				{
					TreeNode trThemeAxisShow = trThemeTickBranch.GetNode("Show");
					TreeNode trGetNAxisShow = trGetNSubAxis.GetNode("Show");
					if( trThemeAxisShow && trGetNAxisShow )
						trGetNAxisShow.nVal = trThemeAxisShow.nVal;
				}
				*/
				int nShowNodeID = (0 == nSubAxisIndex) ? ID_AXIS_FIRST_SHOW : ID_AXIS_SECOND_SHOW;
				/// Iris 8/08/2012 ORG-6463-S3 ADD_AXIS_SHOW_PROPERTY_IN_AXIS_ROOT_BRANCH
				//TreeNode trGetNAxisShow = _get_GetN_node_by_id(trGetNOneAxis.AxisFormat, nShowNodeID, true);				
				//TreeNode trGetNAxisShow = GetPropertyBranchShowNode(trGetNOneAxis.AxisFormat, nAxis, 0 == nSubAxisIndex, nShowNodeID, true);
				TreeNode trGetNAxisShow = GetPropertyBranchShowNode(trGetNOneAxis.AxisFormat, nAxis, GetPrimarySecondaryAxisIndex(nAxis, true) == nSubAxisIndex, nShowNodeID, true);
				///End ADD_AXIS_SHOW_PROPERTY_IN_AXIS_ROOT_BRANCH
				TreeNode trThemeAxisShow = trThemeTickBranch.GetNode("Show");
				ASSERT( trGetNAxisShow );
				if( trThemeAxisShow && trGetNAxisShow )
					trGetNAxisShow.nVal = trThemeAxisShow.nVal;
				///End FIX_SEL_BOTH_XY_AXES_CANNOT_DISPLAY_UNDEFINE_STATUS
			}
			else
			{
				break;	
			}
				
			nSubAxisIndex++;
		}
	}	
	
	// copy the settings of Tick Type (By Increment/Count/Dataset) from theme Scale branch to GetN "Major Ticks" and "Minor Ticks" branch
	/// Iris 6/13/2012 ORG-5991 MOVE_TICKS_AND_LINE_BRANCH_INTO_AXIS_FORMAT_BRANCH
	//foreach(TreeNode trSubTicks in trGetNOneAxis.Ticks.Children)
	//foreach(TreeNode trSubTicks in trGetNOneAxis.Scale.Children)
	//{
		//if( trSubTicks.GetNodeCount() > 0 ) // Major Ticks or Minor Ticks branch
		//{
			//copyValuesFromThemeScaleToGetNTicks(trThemeOneAxis.Scale, trSubTicks.MajorTicks, true);
			//copyValuesFromThemeScaleToGetNTicks(trThemeOneAxis.Scale, trSubTicks.MinorTicks, false);			
			tree_copy_values_by_id(trThemeOneAxis.Scale, trGetNOneAxis.Scale.MajorTicks);
			tree_copy_values_by_id(trThemeOneAxis.Scale, trGetNOneAxis.Scale.MinorTicks);						
		//}
	//}		
	
	// to show/hide DateFormat, MonthForamt, etc. nodes refer to display Type
	foreach(TreeNode trSubAxis in trGetNOneAxis.Labels.Children) // trSubAxis is Bottom, Top, Left, Right...
	{
		foreach(TreeNode trSubBranch in trSubAxis.Children) // Major / Minor
		{				
			TreeNode trGetNLabelType = _get_GetN_node_by_id(trSubBranch, OTID_AXIS_LABEL_TYPE, true);
			if( trGetNLabelType )
			{				
				_ticklabel_type_event(trSubBranch, trGetNLabelType);
			}				
		}					
	}	
	
	int nSubLabelBranchIndex = 0;
	foreach(TreeNode trGetNSubLabelBranch in trGetNOneAxis.Labels.Children)
	{
		if( trGetNSubLabelBranch.GetNodeCount() > 0 )
		{
			/// Iris 7/13/2012 ORG-5991-P9 FIX_PROPERTY_IN_YAXIS_NOT_BE_CHANGED_WHEN_APPLY_CHANGES_WITH_SELECT_OTHERS
			//TreeNode trThemeTick = _get_theme_node_by_id(trThemeOneAxis.Ticks, GetColletionMemberBranchNode(OTID_AXIS_TICK, _CHECK_CONVERT_SUB_AXIS_INDEX(nSubLabelBranchIndex), nAxis), false);
			TreeNode trThemeTick = _get_theme_node_by_id(trThemeOneAxis.Ticks, GetColletionMemberBranchNode(OTID_AXIS_TICK, _CHECK_CONVERT_SUB_AXIS_INDEX(nAxis, nSubLabelBranchIndex), nAxis), false);
			///End FIX_PROPERTY_IN_YAXIS_NOT_BE_CHANGED_WHEN_APPLY_CHANGES_WITH_SELECT_OTHERS
			if( trThemeTick )
			{
				_set_label_auto_color_by_line_color(trThemeTick.Color, trGetNSubLabelBranch.Format.Color);
			}
			
			/// Iris 6/21/2012 ORG-5991-S4 MOVE_SPECIAL_TICK_LABEL_OUTSIDE_LABELS_BRANCH
			/*
			if( trGetNSubLabelBranch.SpecialLabels )
			{
				TreeNode trThemeSubLabel = _get_theme_node_by_id(trThemeOneAxis.Labels, GetColletionMemberBranchNode(OTID_AXIS_LABEL, nSubLabelBranchIndex, nAxis), false);
				_copy_special_tick_label_settings_from_theme_to_GetN(trThemeSubLabel.SpecialTicks, trGetNSubLabelBranch.SpecialLabels);
				_special_tick_label_type_list_event(trGetNSubLabelBranch.SpecialLabels);
			}
			*/
			///End MOVE_SPECIAL_TICK_LABEL_OUTSIDE_LABELS_BRANCH
			
			/// Iris 6/27/2012 ORG-5528 ADD_ACTUAL_FONT_SIZE_IN_AXES_DLG
			TreeNode trFontSize = trGetNSubLabelBranch.Format.Font.Size;
			TreeNode trActualSize = trGetNSubLabelBranch.Format.Font.ActualSize;
			if( trFontSize && trActualSize )				
				_update_tick_label_actual_size(m_gl, trFontSize, trActualSize);
			///End ADD_ACTUAL_FONT_SIZE_IN_AXES_DLG
				
			nSubLabelBranchIndex++;
		}
	}	
	
	/// Iris 6/21/2012 ORG-5991-S4 MOVE_SPECIAL_TICK_LABEL_OUTSIDE_LABELS_BRANCH
	nSubLabelBranchIndex = 0;
	foreach(TreeNode trGetNSubSpecialLabelBranch in trGetNOneAxis.SpecialLabels.Children)
	{
		if( trGetNSubSpecialLabelBranch.GetNodeCount() > 0 )
		{
			/// Iris 7/13/2012 ORG-5991-P9 FIX_PROPERTY_IN_YAXIS_NOT_BE_CHANGED_WHEN_APPLY_CHANGES_WITH_SELECT_OTHERS
			//TreeNode trThemeSubLabel = _get_theme_node_by_id(trThemeOneAxis.Labels, GetColletionMemberBranchNode(OTID_AXIS_LABEL, _CHECK_CONVERT_SUB_AXIS_INDEX(nSubLabelBranchIndex), nAxis), false);
			TreeNode trThemeSubLabel = _get_theme_node_by_id(trThemeOneAxis.Labels, GetColletionMemberBranchNode(OTID_AXIS_LABEL, _CHECK_CONVERT_SUB_AXIS_INDEX(nAxis, nSubLabelBranchIndex), nAxis), false);
			///End FIX_PROPERTY_IN_YAXIS_NOT_BE_CHANGED_WHEN_APPLY_CHANGES_WITH_SELECT_OTHERS
			_copy_special_tick_label_settings_from_theme_to_GetN(trThemeSubLabel.SpecialTicks, trGetNSubSpecialLabelBranch);
			_special_tick_label_type_list_event(trGetNSubSpecialLabelBranch);
			nSubLabelBranchIndex++;
		}		
	}
	///End MOVE_SPECIAL_TICK_LABEL_OUTSIDE_LABELS_BRANCH
	
	/// Iris 8/22/2012 CHECK_CREATE_TITLE_OBJ
	for(int nSubAxis = 0; nSubAxis < SUB_AXIS_COUNT; ++nSubAxis)
	{
		AxisObject ao;				
		if( _get_axis_object(ao, m_gl, nAxis, 0 == nSubAxis ? AXISOBJPOS_AXIS_FIRST : AXISOBJPOS_AXIS_SECOND) && ao )
		{
			GraphObject goTitle = ao.GetTitleObject();
			if( !goTitle )
			{
				TreeNode trGetNSubTitle = _get_GetN_node_by_id(trGetNOneAxis.Titles, GetColletionMemberBranchNode(OTID_AXIS_TITLE, _CHECK_CONVERT_SUB_AXIS_INDEX(nAxis, nSubAxis), nAxis), false);
				if( trGetNSubTitle )
				{
					TreeNode trTitleShow = trGetNSubTitle.GetNode("Show");
					if( trTitleShow && 1 == trTitleShow.nVal ) 
					{
						trTitleShow.nVal = 0;
					}
				}
			}
		}
	}
	///End CHECK_CREATE_TITLE_OBJ
}

void GeneralPlotAxesControlSplitter::onAxisShowChange(TreeNode& trEditNode)
{
	bool bIsPrimary = ID_SHOW_PRIMARY_AXIS == trEditNode.DataID;
	for(int nn = 0; nn < m_vnChangedAxes.GetSize(); nn++)
	{
		int nAxis = m_vnChangedAxes[nn];			
		TreeNode trGetNAxis = GetGetNAxisNode(nAxis);			
		
		// udpate this checkbox checked status for each GetN axis node
		const int nCheck = trEditNode.nVal;
		TreeNode trGetNAxisShow = _get_GetN_node_by_id(trGetNAxis, bIsPrimary ? ID_SHOW_PRIMARY_AXIS : ID_SHOW_SECONDARY_AXIS, false);
		if( trGetNAxisShow )
			trGetNAxisShow.nVal = nCheck;
		
		UpdatePropertyBranchShowNodeFromAxisBranch(trGetNAxis, nAxis, bIsPrimary, nCheck, true);
	}	
}

void GeneralPlotAxesControlSplitter::setSecondAxisShowOnFirst(TreeNode& trEditBranch)
{
	TreeNode trSameForBoth = _get_GetN_node_by_id(trEditBranch, ID_SAME_FOR_BOTTOM_AND_TOP);	
	TreeNode trPrimaryShow = _get_GetN_node_by_id(trEditBranch, ID_SHOW_PRIMARY_AXIS);
	TreeNode trSecondaryShow = _get_GetN_node_by_id(trEditBranch, ID_SHOW_SECONDARY_AXIS);
	
	if( trSameForBoth && trSameForBoth.nVal && trPrimaryShow && trSecondaryShow && trPrimaryShow.nVal != trSecondaryShow.nVal )
	{
		TreeNode trBottomShow, trTopShow;				
		
		if( trPrimaryShow.NextNode && trPrimaryShow.NextNode.DataID == ID_SHOW_SECONDARY_AXIS )
		{
			trBottomShow = trPrimaryShow;
			trTopShow = trSecondaryShow;
		}
		else
		{
			trBottomShow = trSecondaryShow;
			trTopShow = trPrimaryShow;
		}				
		
		trTopShow.nVal = trBottomShow.nVal;		
		onAxisShowChange(trTopShow);					
	}
}

void GeneralPlotAxesControlSplitter::onPropertyShowChange(TreeNode& trEditNode)
{
	TreeNode trEditBranch = trEditNode.Parent();
	
	for(int nn = 0; nn < m_vnChangedAxes.GetSize(); nn++)
	{	
		// to update theme tree according to GUI change
		int nAxis = m_vnChangedAxes[nn];				
		TreeNode trThemeAxis = GetThemeAxisNode(nAxis);		
		
		TreeNode trPropertyBranch;
		int nGetNBranchID = _get_base_id(trEditBranch.DataID);
		int nThemeBranchID = nGetNBranchID;
		if( ID_AXIS_FORMATS == nGetNBranchID )
			nThemeBranchID = OTID_AXIS_TICKS;
					
		TreeNode trThemeProperty = _get_theme_node_by_id(trThemeAxis, THEME_COLL_BRANCH(nThemeBranchID), false);
		ASSERT( trThemeProperty );
		
		int nThemeShowID;
		bool bRet = trEditNode.GetAttribute(STR_ORIGINAL_SHOW_NODE_ID_ATTRIB, nThemeShowID);
		ASSERT( bRet );
		
		if( ID_AXIS_FORMATS == nGetNBranchID )
			nThemeShowID = OTID_AXIS_TICK_SHOW;
		bool bIsPrimary = ID_PRIMARY_SHOW == trEditNode.DataID || ID_PRIMARY_MINOR_SHOW == trEditNode.DataID;
		
		TreeNode trThemeShow = GetPropertyBranchShowNode(trThemeProperty, nAxis, bIsPrimary, nThemeShowID, false);
		ASSERT( trThemeShow );
		
		if( trThemeShow )
		{
			_set_value_with_change_bit(trThemeShow, trEditNode.nVal);
		}
		
		// if show both primary and secondary axes, we need update the check/uncheck/undefined status for Show checkbox in Axis branch refer to the two nodes
		if( !IsShowPrimaryAxesOnly() ) 
		{
			TreeNode trGetNAxis = GetGetNAxisNode(nAxis);
			UpdateAxisBranchShowNodeFromPropertyBranch(trGetNAxis, nAxis, bIsPrimary);
			
			/// Iris 9/14/2012 ORG-6837-P1 TO_DISABLE_SUB_PROPERTIES_NODES_WHEN_SHOW_IS_UNCHECKED
			// to enable/disable Bottom/Top branch refer to the Show check/uncheck status
			TreeNode trGetNProperty = _get_GetN_node_by_id(trGetNAxis, THEME_COLL_BRANCH(nGetNBranchID), false);
			ASSERT(trGetNProperty);
			if( trGetNProperty )
			{
				/// Iris 9/20/2012 ORG-6892-P1 IMPROVE_DISABLE_SUB_AXIS_BRANCH_CODES
				/*
				string strName = getAxisSubBranchName(nAxis, bIsPrimary ? 0 : 1);
				TreeNode trSubAxisBranch = trGetNProperty.GetNode(strName);
				TreeNode trGetNShow = _get_GetN_node_by_id(trGetNProperty, trEditNode.DataID, false);
				if( trSubAxisBranch && trGetNShow ) // some branch not sub axis, ex. Grids
				{
					_set_enable_attribute_by_show_node(trSubAxisBranch, trGetNShow, false, false);
				}		
				*/
				TreeNode trGetNShow = _get_GetN_node_by_id(trGetNProperty, trEditNode.DataID, false);
				DisableSubAxisBranchWhenShowNodeUnchecked(trGetNProperty, trGetNShow, nAxis, bIsPrimary);
				///End IMPROVE_DISABLE_SUB_AXIS_BRANCH_CODES
			}
			///End TO_DISABLE_SUB_PROPERTIES_NODES_WHEN_SHOW_IS_UNCHECKED		
			
		}		
		
		// set minor show enable status refer to major check status
		if( ID_PRIMARY_SHOW == trEditNode.DataID || ID_SECONDARY_SHOW == trEditNode.DataID )
		{
			int nMinorNodeID = ID_PRIMARY_SHOW == trEditNode.DataID ? ID_PRIMARY_MINOR_SHOW : ID_SECONDARY_MINOR_SHOW;
			TreeNode trMinorShow = _get_GetN_node_by_id( trEditBranch, nMinorNodeID );
			if( trMinorShow )
			{
				trMinorShow.Enable = trEditNode.nVal;				
			}
		}		
		
		/// Iris 9/14/2012 ORG-6837-P1 TO_DISABLE_SUB_PROPERTIES_NODES_WHEN_SHOW_IS_UNCHECKED
		// to move the calling outside of the function else will cause unlimit loop, since the function below called the current function.
		/*
		// to set same Show check/uncheck status for secondary axis refer to primary axis 
		setSecondPropertyShowOnFirst(trEditBranch);
		*/
		///End TO_DISABLE_SUB_PROPERTIES_NODES_WHEN_SHOW_IS_UNCHECKED
	}	
}

void GeneralPlotAxesControlSplitter::setSecondPropertyShowOnFirst(TreeNode& trEditBranch)
{
	TreeNode trSameForBoth = _get_GetN_node_by_id(trEditBranch, ID_SAME_FOR_BOTTOM_AND_TOP);	
	if( !trSameForBoth || 0 == trSameForBoth.nVal )
		return;
	
	TreeNode trSep = trEditBranch.FindNodeByAttribute(STR_ID_ATTRIB, ONODETYPE_SEPARATOR);
	//---- Iris 9/24/2012 there is not separator line in special labels branch, so comment out
	//ASSERT( trSep ); // if has Use Same for Both checkbox, should has separtor line under it.
	//----
	if( !trSep )
		return;
	
	TreeNode trFirstShow = trSep.NextNode;
	ASSERT( trFirstShow );
	if( !trFirstShow )
		return;
	
	TreeNode trSecondShow = trFirstShow.NextNode;
	if( trSecondShow.DataID == ID_PRIMARY_MINOR_SHOW || trSecondShow.DataID == ID_SECONDARY_MINOR_SHOW ) // if has minor show checkbox
	{
		TreeNode trFirstMinorShow = trFirstShow.NextNode;			
		if( trFirstMinorShow )
		{
			TreeNode trSecondShow = trFirstMinorShow.NextNode;
			if( trSecondShow )
			{
				if( trSecondShow.nVal != trFirstShow.nVal )
				{
					_set_value_with_change_bit(trSecondShow, trFirstShow.nVal);
					onPropertyShowChange(trSecondShow);
				}
			
				TreeNode trSecondMinorShow = trSecondShow.NextNode;
				if( trSecondMinorShow && trSecondMinorShow.nVal != trFirstMinorShow.nVal ) // minor
				{
					_set_value_with_change_bit(trSecondMinorShow, trFirstMinorShow.nVal);
					onPropertyShowChange(trSecondMinorShow);
				}
			}
		}
	}	
	else
	{
		if( trSecondShow.nVal != trFirstShow.nVal )
		{
			_set_value_with_change_bit(trSecondShow, trFirstShow.nVal);
			onPropertyShowChange(trSecondShow);
		}
	}
}

// virtual
void GeneralPlotAxesControlSplitter::UpdateOnAfterValueChange(int nRow, ThemeUpdateInfo& stThemeUpdateInfo)
{
	AxesControlSplitter::UpdateOnAfterValueChange(nRow, stThemeUpdateInfo);
	if( !stThemeUpdateInfo.trEditNode || (stThemeUpdateInfo.trEditNode.DataID <= 0 && stThemeUpdateInfo.trEditBranch.DataID <= 0) )
		return;
	
	bool bNeedToUpdateThemeEx = true;
	bool bUpdatedGUIEx = false;	
	TreeNode trEditNode = stThemeUpdateInfo.trEditNode;
	TreeNode trEditBranch = stThemeUpdateInfo.trEditBranch;		
	int nEditNodeDataID = trEditNode.DataID;
	int nEditBranchDataID = trEditBranch.DataID;	
		
	switch( nEditNodeDataID )
	{		
	case OTID_AXIS_SCALE_INCBY:	
	case ID_AXIS_MINOR_TICKS_INCBY:
		{
			bool bMajor = (OTID_AXIS_SCALE_INCBY == nEditNodeDataID);
			bool bDataset = bMajor ? SET_MAJOR_TICKS_BY_DATASET == trEditNode.nVal : SET_MINOR_TICKS_BY_DATASET == trEditNode.nVal;
			
			for(int nn = 0; nn < m_vnChangedAxes.GetSize(); nn++)
			{	
				int nAxis = m_vnChangedAxes[nn];				
				TreeNode trThemeAxis = GetThemeAxisNode(nAxis);
				TreeNode trThemeTicksDataset = _get_theme_node_by_id(trThemeAxis.Scale, bMajor ? OTID_AXIS_SCALE_USER_MAJOR_TICKS : OTID_AXIS_SCALE_USER_MINOR_TICKS);
				if( !bDataset && !trThemeTicksDataset.strVal.IsEmpty() )
				{					
					trThemeTicksDataset.Reset(true);					
					_set_change_bit(trThemeTicksDataset);
					bNeedToUpdateThemeEx = false;
				}
			}
		}
		break;	
			
	case OTID_AXIS_ADDITIONAL_ZERO_LINE:
	case OTID_AXIS_ADDITIONAL_OPPOSITE_LINE:
		{
			for(int nn = 0; nn < m_vnChangedAxes.GetSize(); nn++)
			{	
				int nAxis = m_vnChangedAxes[nn];
				TreeNode trThemeAxis = GetThemeAxisNode(nAxis);
				TreeNode trGetNAxis = GetGetNAxisNode(nAxis);
				
				//_copy_changed_node(trGetNAxis.Grids.Additional, trThemeAxis.Additional);
				Tree trJunk;
				_copy_changed_nodes(trGetNAxis.Grids.Additional, trThemeAxis.Additional, trJunk);
			}
			bNeedToUpdateThemeEx = false;
		}
		break;
	
	case ID_SAME_FOR_BOTTOM_AND_TOP:
		{
			bNeedToUpdateThemeEx = false;	
			bUpdatedGUIEx = true; // will update the enable status of Show Secondary Axis below
				
			if( _is_axis_branch_node(trEditBranch) )
			{
				int nAxis = GetAxisIndex(trEditNode);
				TreeNode trGetNAxis = GetGetNAxisNode(nAxis);
				CheckSetBranchEnableStatusOnUseSameOptionsForBoth(nAxis, trGetNAxis, trEditBranch, trEditNode.nVal);
				
				setSecondAxisShowOnFirst(trEditBranch);
			}
			else
			{			
				for(int nn = 0; nn < m_vnChangedAxes.GetSize(); nn++)
				{	
					int nAxis = m_vnChangedAxes[nn];				
					TreeNode trGetNAxis = GetGetNAxisNode(nAxis);						
											
					CheckSetBranchEnableStatusOnUseSameOptionsForBoth(nAxis, trGetNAxis, trEditBranch, trEditNode.nVal);				
					
					setSecondPropertyShowOnFirst(trEditBranch);
				}
			}
			
			/// Iris 7/20/2012 ORG-6270-S1 IMPROVE_TICK_LABELS_BRANCH_SPEED
			UpdateTreeViewEnableSettings(GetListTree());
			///End IMPROVE_TICK_LABELS_BRANCH_SPEED
		}
		break;
	
	// fail to setup break properties when apply format with theme tree without Break.Enable node
	case OTID_AXIS_BREAK_REGION_FROM:
	case OTID_AXIS_BREAK_REGION_TO:
	case OTID_AXIS_BREAK_POSITION:
	case OTID_AXIS_BREAK_LOG_SCALE_AFTER:
	case OTID_AXIS_BREAK_SCALE_INC_BEFORE:
	case OTID_AXIS_BREAK_SCALE_INC_AFTER:
	case OTID_AXIS_BREAK_NUM_TICKS_BEFORE:
	case OTID_AXIS_BREAK_NUM_TICKS_AFTER:
		for(int nn = 0; nn < m_vnChangedAxes.GetSize(); nn++)
		{	
			int nAxis = m_vnChangedAxes[nn];
			TreeNode trThemeAxis = GetThemeAxisNode(nAxis);				
			TreeNode trBreakEnable = _get_theme_node_by_id(trThemeAxis, OTID_AXIS_BREAK_ENABLE, true);
			_set_change_bit(trBreakEnable);				
		}		
		break;
	
	/// Iris 8/06/2012 ORG-6463-S1 ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX	
	///// Iris 5/22/2012 ORG-5528-S3 ADD_AUTO_SHOWHIDE_CHECKBOX
	//case OTID_AXIS_AUTO_HIDE:		
		//UpdateShowEnableStatusOnAutoShowHide();
		//break;
	/////End ADD_AUTO_SHOWHIDE_CHECKBOX	
	///End ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
	
	/// Iris 6/06/2012 ORG-5528-P17 SUPPORT_CUSTOM_DECIMAL_IN_3DGL_GRAPH
	case OTID_AXIS_LABEL_MANUAL_DEC:
		for(int nn = 0; nn < m_vnChangedAxes.GetSize(); nn++)
		{	
			int nAxis = m_vnChangedAxes[nn];
			int nCollBranchBaseID;
			int nSubAxisIndex = GetSubAxisIndex(trEditNode, &nCollBranchBaseID);
			int nSubAxisBranchOrder = GetSubAxisBranchOrder(trEditNode); /// Iris 7/13/2012 ORG-5991-P9 FIX_PROPERTY_IN_YAXIS_NOT_BE_CHANGED_WHEN_APPLY_CHANGES_WITH_SELECT_OTHERS			
			/// Iris 7/23/2012 ORG-6319-P1 FIX_AXES_DLG_RUNTIME_ERROR_IN_JOS
			//bool bMajor = IsMajor(trEditBranch);
			TreeNode trThemeAxis = GetThemeAxisNode(nAxis);
			///End FIX_AXES_DLG_RUNTIME_ERROR_IN_JOS
			TreeNode trGetNAxis = GetGetNAxisNode(nAxis);
			/// Iris 7/23/2012 ORG-6319-P1 FIX_AXES_DLG_RUNTIME_ERROR_IN_JOS
			/// Iris 8/06/2012 ORG-6463-S1 ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
			// comment out since assert failed, bMajor is unmeaning here because Manual Decimal is worked for both major and minor tick label
			//bool bMajor = IsMajor(trEditBranch, nCollBranchBaseID);
			///End ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
			///End FIX_AXES_DLG_RUNTIME_ERROR_IN_JOS
			
			/// Iris 7/13/2012 ORG-5991-P9 FIX_PROPERTY_IN_YAXIS_NOT_BE_CHANGED_WHEN_APPLY_CHANGES_WITH_SELECT_OTHERS
			//int nCollBranchDataID = GetColletionMemberBranchNode(nCollBranchBaseID, nSubAxisIndex, nAxis);
			int nCollBranchDataID = GetColletionMemberBranchNode(nCollBranchBaseID, _CHECK_CONVERT_SUB_AXIS_INDEX(nAxis, nSubAxisBranchOrder), nAxis);
			///End FIX_PROPERTY_IN_YAXIS_NOT_BE_CHANGED_WHEN_APPLY_CHANGES_WITH_SELECT_OTHERS
			TreeNode trThemeCollBranch = _get_theme_node_by_id(trThemeAxis, nCollBranchDataID, true);
			TreeNode trGetNCollBranch = _get_GetN_node_by_id(trGetNAxis, nCollBranchDataID, true);			

			/// Iris 8/01/2012 ORG-5991-P14 IMPORVE_CUSTOM_DECIMAL_CONTROL_DISPLAY
			int nCheck;
			TreeNode trGetNCustomDecimal = trGetNCollBranch.MajorLabels.CustomDecimal;
			TreeNode trGetNDecimalHits = trGetNCollBranch.MajorLabels.hits;
			if( trGetNCustomDecimal && trGetNCustomDecimal.GetAttribute(STR_ATTRIB_DYNACONTROL_USE_CHECK, nCheck) && trGetNDecimalHits && trEditBranch.hits )
			{
				trGetNDecimalHits.Show = 
				trEditBranch.hits.Show = 
				nCheck;
				bUpdatedGUIEx = true;
			}
			/// Iris 9/27/2012 ORG-6996-P1 FIX_CUSTOM_FORMAT_MISSED_AFTER_SHOW_MINRO_LABEL
			if( trGetNCustomDecimal )
				trGetNCustomDecimal.RemoveAttribute(STR_CHANGED_ATTRIB); // remove changed attribute from GUI tree to avoid apply the change in next time				
			///End FIX_CUSTOM_FORMAT_MISSED_AFTER_SHOW_MINRO_LABEL
			///End IMPORVE_CUSTOM_DECIMAL_CONTROL_DISPLAY
			
			/// Iris 7/12/2012 ORG-6198-P1 FIX_CUSTOM_DECIMAL_CANNOT_USE_SAME_OPTIONS_FOR_BOTTOM_AND_TOP_TO_SET_BOTH
			/*
			TreeNode trGetNCustomDecimal = bMajor ? trGetNCollBranch.MajorLabels.CustomDecimal : trGetNCollBranch.MinorLabels.CustomDecimal;
			if( trGetNCollBranch && trGetNCustomDecimal )
			{			
				int nCheck = -1;
				if( trGetNCustomDecimal.GetAttribute(STR_ATTRIB_DYNACONTROL_USE_CHECK, nCheck) )
				{
					if( nCheck != trGetNCustomDecimal.nVal )
					{
						// CustomDecimal node						
						_set_value_with_change_bit(trThemeCollBranch.CustomDecimal, nCheck);					
						
					}
					
					// CustomFormat node
					TreeNode trThemeCustomFormat = trThemeCollBranch.CustomFormat;
					if( !trThemeCustomFormat )
					{
						trThemeCollBranch.CustomFormat.ID = OTID_AXIS_LABEL_CUSTOM_FORMAT;
						trThemeCustomFormat = trThemeCollBranch.CustomFormat;						
						_set_value_with_change_bit(trThemeCustomFormat, trGetNCustomDecimal.strVal);
					}				
					else
					{
						if( trThemeCustomFormat.strVal != trGetNCustomDecimal.strVal )
						{							
							_set_value_with_change_bit(trThemeCustomFormat, trGetNCustomDecimal.strVal);
						}
					}
					if( trThemeCustomFormat.strVal.Find(',') >= 0 )
						trThemeCustomFormat.strVal.Replace(',', '.'); 					
				}
				bNeedToUpdateThemeEx = false;
			}
			*/
			_copy_custom_decimal_from_GetN_to_theme(trGetNCollBranch, trThemeCollBranch);
			bNeedToUpdateThemeEx = false;
			///End FIX_CUSTOM_DECIMAL_CANNOT_USE_SAME_OPTIONS_FOR_BOTTOM_AND_TOP_TO_SET_BOTH
		}
		/// Iris 9/27/2012 ORG-6996-P1 FIX_CUSTOM_FORMAT_MISSED_AFTER_SHOW_MINRO_LABEL
		trEditNode.RemoveAttribute(STR_CHANGED_ATTRIB); // remove changed attribute from GUI tree to avoid apply the change in next time				
		///End FIX_CUSTOM_FORMAT_MISSED_AFTER_SHOW_MINRO_LABEL
		break;
	///End SUPPORT_CUSTOM_DECIMAL_IN_3DGL_GRAPH
		
	case OTID_AXIS_TICK_MAJOR:
	case OTID_AXIS_TICK_MINOR:
	case OTID_AXIS_TICK_LENGTH:
	case OTID_AXIS_TICK_MINOR_LENGTH:
		/// Iris 7/13/2012 ORG-5991-P9 FIX_PROPERTY_IN_YAXIS_NOT_BE_CHANGED_WHEN_APPLY_CHANGES_WITH_SELECT_OTHERS
		// use the same codes for the cases below.
		//for(int nn = 0; nn < m_vnChangedAxes.GetSize(); nn++)
		//{
			//int nAxis = m_vnChangedAxes[nn];
			//TreeNode trThemeAxis = GetThemeAxisNode(nAxis);
			//TreeNode trGetNAxis = GetGetNAxisNode(nAxis);
			//int nSubAxisIndex = GetSubAxisIndex(trEditNode);			
			//
			//int nTickBranchDataID = GetColletionMemberBranchNode(OTID_AXIS_TICK, nSubAxisIndex, nAxis);
			//TreeNode trThemeTick = _get_theme_node_by_id(trThemeAxis.Ticks, nTickBranchDataID, false);			
			//
			//Tree trJunk;
			//_copy_changed_nodes(trEditBranch, trThemeTick, trJunk);
			//bNeedToUpdateThemeEx = false;
		//}
		//break;			
		///End FIX_PROPERTY_IN_YAXIS_NOT_BE_CHANGED_WHEN_APPLY_CHANGES_WITH_SELECT_OTHERS
	case OTID_AXIS_TICK_COLOR:	
	case OTID_AXIS_TICK_WIDTH:
	case OTID_AXIS_TICK_POSITION:
	case OTID_AXIS_TICK_OFFSET:
	/// Iris 7/26/2012 ORG-6424-P4 FIX_DATE_TYPE_POSSION_OFFSET_NOT_WORK
	case ID_AXIS_POSITION_DATE_TYPE_OFFSET:
	case ID_AXIS_POSITION_TIME_TYPE_OFFSET:	
		// need convert date or time type offset to Offset node, and also need to convert back		
		if( ID_AXIS_POSITION_DATE_TYPE_OFFSET == nEditNodeDataID || ID_AXIS_POSITION_TIME_TYPE_OFFSET == nEditNodeDataID ) // date or time type
		{								
			_set_value_with_change_bit(trEditBranch.Offset, trEditNode.dVal);
		}
	///End FIX_DATE_TYPE_POSSION_OFFSET_NOT_WORK		
		
		// need to convert the value of Offset when switch Position type in TICK_POS_PRECENT and TICK_POS_AT_VAL
		if( OTID_AXIS_TICK_POSITION == nEditNodeDataID && m_vnChangedAxes.GetSize() > 0 )
		{			
			int nSubAxis = GetSubAxisIndex(trEditNode);		
			/// Iris 9/21/2012 ORG-6771-P2 FIX_WRONG_TICK_LABEL_TYPE_WHEN_SELECTED_AT_POSITION
			//int nReferAxis = m_vnChangedAxes[0]; // we display GUI for the first selection when selected multi axes 
			int nReferAxis = GetAxisIndex(trEditNode);
			///End FIX_WRONG_TICK_LABEL_TYPE_WHEN_SELECTED_AT_POSITION
			AxisObject ao;				
			bool bRet = _get_axis_object(ao, m_gl, nReferAxis, 0 == nSubAxis ? AXISOBJPOS_AXIS_FIRST : AXISOBJPOS_AXIS_SECOND);
			ASSERT(bRet);
			
			if( ao )
			{						
				int nOldPosType = -1;
				/// Iris 7/26/2012 ORG-6424-P4 FIX_DATE_TYPE_POSSION_OFFSET_NOT_WORK
				int nNewPosType = trEditNode.nVal;						
				//if( TICK_POS_NORMAL != trEditNode.nVal 
					//&& trEditBranch.Offset.GetAttribute(STR_POSITION_TYPE_ATTRIB, nOldPosType) 
					//&& TICK_POS_NORMAL != nOldPosType									
				if( trEditBranch.Offset.GetAttribute(STR_POSITION_TYPE_ATTRIB, nOldPosType)
					&& nOldPosType != nNewPosType							
				///End FIX_DATE_TYPE_POSSION_OFFSET_NOT_WORK
				)
				{					
					double dOffset = trEditBranch.Offset.dVal;								
					/// Iris 8/22/2012 ORG-6463-P6 IMPROVE_AXIS_POSITION_REFER_AXIS
					//ao.ConvertPosition(nOldPosType, nNewPosType, &dOffset);
					ao.ConvertPosition(nOldPosType, nNewPosType, &dOffset, GetAutoHideStatus());
					///End IMPROVE_AXIS_POSITION_REFER_AXIS
					_set_value_with_change_bit(trEditBranch.Offset, dOffset);
					
					/// Iris 7/26/2012 ORG-6424-P4 FIX_DATE_TYPE_POSSION_OFFSET_NOT_WORK
					if( trEditBranch.DateOffset )
						_set_value_with_change_bit(trEditBranch.DateOffset, dOffset);
					if( trEditBranch.TimeOffset )
						_set_value_with_change_bit(trEditBranch.TimeOffset, dOffset);						
					///End FIX_DATE_TYPE_POSSION_OFFSET_NOT_WORK
				}				
										
				// show/hide Offset and DateOffset node by Position type
				/// Iris 8/22/2012 ORG-6463-P6 IMPROVE_AXIS_POSITION_REFER_AXIS
				//_update_position_offset_show_hide(trEditBranch, m_gl, ao);
				_update_position_offset_show_hide(trEditBranch, m_gl, ao, GetAutoHideStatus());
				///End IMPROVE_AXIS_POSITION_REFER_AXIS
				
				bUpdatedGUIEx = true;
			}
			
			trEditBranch.Offset.SetAttribute(STR_POSITION_TYPE_ATTRIB, trEditNode.nVal);
		}
		
		// to update theme tree according to GUI change
		/// Iris 9/26/2012 ORG-6771-P2 SET_AXIS_POSITION_OFFSET_EVENT_ONLY_EFFECT_THE_CURRENT_SEL_ROWS
		/*
		for(int nn = 0; nn < m_vnChangedAxes.GetSize(); nn++)
		{
			int nAxis = m_vnChangedAxes[nn];
		*/
		vector<uint> vnRows;
		m_AxesGridTree.GetSelRows(vnRows);
		for(int index = 0; index < vnRows.GetSize(); ++index)
		{			
			int nRow = vnRows[index];
			TreeNode trRow = GetTreeNode(nRow);
			int nAxis = GetAxisIndex(trRow);
		///End SET_AXIS_POSITION_OFFSET_EVENT_ONLY_EFFECT_THE_CURRENT_SEL_ROWS
			TreeNode trThemeAxis = GetThemeAxisNode(nAxis);
			TreeNode trGetNAxis = GetGetNAxisNode(nAxis);			
				
			// copy changes from GetN to theme tree
			int nSubAxisBranchOrder = GetSubAxisBranchOrder(trEditNode);
			int nTickBranchDataID = GetColletionMemberBranchNode(OTID_AXIS_TICK, _CHECK_CONVERT_SUB_AXIS_INDEX(nAxis, nSubAxisBranchOrder), nAxis);			
			TreeNode trThemeTick = _get_theme_node_by_id(trThemeAxis.Ticks, nTickBranchDataID, false);
			
			Tree trJunk;
			_copy_changed_nodes(trEditBranch, trThemeTick, trJunk);
			bNeedToUpdateThemeEx = false;
		}
		
		// set Label Auto color refer to the color of axis line 
		if( OTID_AXIS_TICK_COLOR == nEditNodeDataID )
		{			
			int nAxis = GetAxisIndex(trEditNode);
			TreeNode trAxis = GetGetNAxisNode(nAxis);
			ASSERT(trAxis);
			
			foreach(TreeNode trSubBranch in trAxis.Labels.Children)
			{
				if( trSubBranch.GetNodeCount() > 0 && trSubBranch.Format.Color )
				{
					_set_label_auto_color_by_line_color(trEditNode, trSubBranch.Format.Color);
				}
			}
		}
		break;
	
	/// Iris 6/25/2012 ORG-5991-P7 FIX_SEL_BOTH_XY_AXES_CANNOT_DISPLAY_UNDEFINE_STATUS
	case ID_AXIS_FIRST_SHOW:
	case ID_AXIS_SECOND_SHOW:
		for(int nn = 0; nn < m_vnChangedAxes.GetSize(); nn++)
		{
			int nAxis = m_vnChangedAxes[nn];
			TreeNode trThemeAxis = GetThemeAxisNode(nAxis);
			TreeNode trGetNAxis = GetGetNAxisNode(nAxis);
			/// Iris 6/28/2012 to fix AxisFormat.Right.Show and .Left.Show not work, since there is no repeatID in the parent node of trEditNode
			// , then returned nSubAxisIndex always be 0. Line and Ticks branch has the same RepearID with Show node, so input any sub node in Line branch below to replace input Show.
			//int nSubAxisIndex = GetSubAxisIndex(trEditNode);
			/// Iris 8/08/2012 ORG-6463-S3 ADD_AXIS_SHOW_PROPERTY_IN_AXIS_ROOT_BRANCH
			//ASSERT( trEditBranch.Line.FirstNode );
			///End ADD_AXIS_SHOW_PROPERTY_IN_AXIS_ROOT_BRANCH
			
			/// Iris 7/13/2012 ORG-5991-P9 FIX_PROPERTY_IN_YAXIS_NOT_BE_CHANGED_WHEN_APPLY_CHANGES_WITH_SELECT_OTHERS
			/*
			int nSubAxisIndex = GetSubAxisIndex(trEditBranch.Line.FirstNode);
			
			int nTickBranchDataID = GetColletionMemberBranchNode(OTID_AXIS_TICK, nSubAxisIndex, nAxis);
			*/
			/// Iris 7/17/2012 ORG-5991-P11 FIX_SHOW_PROPERTY_OF_TOP_AXIS_NOT_WORK
			//int nSubAxisBranchOrder = GetSubAxisBranchOrder(trEditNode);
			/// Iris 8/08/2012 ORG-6463-S3 ADD_AXIS_SHOW_PROPERTY_IN_AXIS_ROOT_BRANCH
			//int nSubAxisBranchOrder = GetSubAxisBranchOrder(trEditBranch.Line.FirstNode);			
			int nSubAxisBranchOrder = ID_AXIS_FIRST_SHOW == nEditNodeDataID ? 0 : 1;			
			///End ADD_AXIS_SHOW_PROPERTY_IN_AXIS_ROOT_BRANCH
			///End FIX_SHOW_PROPERTY_OF_TOP_AXIS_NOT_WORK
			
			int nTickBranchDataID = GetColletionMemberBranchNode(OTID_AXIS_TICK, _CHECK_CONVERT_SUB_AXIS_INDEX(nAxis, nSubAxisBranchOrder), nAxis);
			///End FIX_PROPERTY_IN_YAXIS_NOT_BE_CHANGED_WHEN_APPLY_CHANGES_WITH_SELECT_OTHERS
			
			TreeNode trThemeTick = _get_theme_node_by_id(trThemeAxis.Ticks, nTickBranchDataID, false);
			TreeNode trThemeAxisShow = trThemeTick.GetNode("Show");
			if( trThemeAxisShow && 0 == trThemeAxisShow.GetNodeCount() )
			{
				_set_value_with_change_bit(trThemeAxisShow, trEditNode.nVal);
				bNeedToUpdateThemeEx = false;
			}	
			
			/// Iris 8/08/2012 ORG-6463-S3 ADD_AXIS_SHOW_PROPERTY_IN_AXIS_ROOT_BRANCH			
			bool bIsPrimary = 0 == nSubAxisBranchOrder;
			UpdateAxisBranchShowNodeFromPropertyBranch(trGetNAxis, nAxis, bIsPrimary);			
			///End ADD_AXIS_SHOW_PROPERTY_IN_AXIS_ROOT_BRANCH
		}
		
		/// Iris 9/14/2012 ORG-6837-P1 TO_DISABLE_SUB_PROPERTIES_NODES_WHEN_SHOW_IS_UNCHECKED
		DisablePropertiesNodeWhenShowNodeUnchecked(GetTree(), nEditNodeDataID);
		bUpdatedGUIEx = true;
		///End TO_DISABLE_SUB_PROPERTIES_NODES_WHEN_SHOW_IS_UNCHECKED
		break;
	///End FIX_SEL_BOTH_XY_AXES_CANNOT_DISPLAY_UNDEFINE_STATUS
		
	/// Iris 6/27/2012 ORG-5528 ADD_ACTUAL_FONT_SIZE_IN_AXES_DLG
	case OTID_AXIS_LABEL_FONT_SIZE:				
		_update_tick_label_actual_size(m_gl, trEditNode, trEditBranch.ActualSize);		
		bUpdatedGUIEx = true;
		break;
	///End ADD_ACTUAL_FONT_SIZE_IN_AXES_DLG
	
	/// Iris 8/08/2012 ORG-6463-S3 ADD_AXIS_SHOW_PROPERTY_IN_AXIS_ROOT_BRANCH
	case ID_SHOW_PRIMARY_AXIS:
	case ID_SHOW_SECONDARY_AXIS:
		{			
			onAxisShowChange(trEditNode);			
				
			// set the second Show same as the first Show checkbox if Use Same is checked.
			setSecondAxisShowOnFirst(trEditBranch);
			
			/// Iris 9/20/2012 ORG-6892-P1 IMPROVE_DISABLE_SUB_AXIS_BRANCH_CODES
			UpdateTreeViewEnableSettings(GetListTree());
			///End IMPROVE_DISABLE_SUB_AXIS_BRANCH_CODES
			
			bUpdatedGUIEx = true;
			bNeedToUpdateThemeEx = false;
		}
		break;		
	
	case OTID_LABEL_SHOW:
	case OTID_AXIS_LABEL_SHOW:	
		{
			for(int nn = 0; nn < m_vnChangedAxes.GetSize(); nn++)
			{
				int nAxis = m_vnChangedAxes[nn];				
				TreeNode trGetNAxis = GetGetNAxisNode(nAxis);
				
				int nSubAxisBranchOrder = GetSubAxisBranchOrder(trEditNode);				
				bool bIsPrimary = 0 == nSubAxisBranchOrder;
				UpdateAxisBranchShowNodeFromPropertyBranch(trGetNAxis, nAxis, bIsPrimary);
			}
			
			/// Iris 9/14/2012 ORG-6837-P1 TO_DISABLE_SUB_PROPERTIES_NODES_WHEN_SHOW_IS_UNCHECKED
			DisablePropertiesNodeWhenShowNodeUnchecked(GetTree(), nEditNodeDataID);
			bUpdatedGUIEx = true;
			///End TO_DISABLE_SUB_PROPERTIES_NODES_WHEN_SHOW_IS_UNCHECKED
		}
		break;
	///End ADD_AXIS_SHOW_PROPERTY_IN_AXIS_ROOT_BRANCH
		
	/// Iris 8/10/2012 ORG-6463-S3 MOVE_PRIMARY_AND_SECONDARY_SHOW_PROPERTY_TO_PROPERTY_BRANCH	
	case ID_PRIMARY_SHOW:
	case ID_SECONDARY_SHOW:	
	case ID_PRIMARY_MINOR_SHOW:
	case ID_SECONDARY_MINOR_SHOW:
		{
			onPropertyShowChange(trEditNode);
			
			/// Iris 9/14/2012 ORG-6837-P1 TO_DISABLE_SUB_PROPERTIES_NODES_WHEN_SHOW_IS_UNCHECKED
			if( ID_SECONDARY_SHOW == nEditNodeDataID 
				|| ID_SECONDARY_MINOR_SHOW == nEditNodeDataID)
			{
				// to set same Show check/uncheck status for secondary axis refer to primary axis 
				setSecondPropertyShowOnFirst(trEditBranch);
			}
			///End TO_DISABLE_SUB_PROPERTIES_NODES_WHEN_SHOW_IS_UNCHECKED
			
			bUpdatedGUIEx = true;
			bNeedToUpdateThemeEx = false;
			/// Iris 9/14/2012 ORG-6837-P1 TO_DISABLE_SUB_PROPERTIES_NODES_WHEN_SHOW_IS_UNCHECKED
			UpdateTreeViewEnableSettings(GetListTree());
			///End TO_DISABLE_SUB_PROPERTIES_NODES_WHEN_SHOW_IS_UNCHECKED
		}
		break;
	///End MOVE_PRIMARY_AND_SECONDARY_SHOW_PROPERTY_TO_PROPERTY_BRANCH
		
	default:		
		break;
	}		
	
	// for Ticks and Tick Labels branch, there is NOT Major/Minor branch in theme tree, but the two branchs under GetN tree. 
	// So need copy from subbranch to top level branch.	
	if( ID_SAME_FOR_BOTTOM_AND_TOP != nEditNodeDataID 
		&& OTID_AXIS_LABEL_MANUAL_DEC != nEditNodeDataID  /// Iris 6/06/2012 ORG-5528-P17 SUPPORT_CUSTOM_DECIMAL_IN_3DGL_GRAPH		
		&& OTID_AXIS_SPECIALTICKS != nEditBranchDataID
		)
	{
		TreeNode trPropertyBranch = GetTree();
		int nPropertyBranchBaseID = _get_base_id(trPropertyBranch.DataID);		
		if( OTID_AXIS_TICKS == nPropertyBranchBaseID || OTID_AXIS_LINE == nPropertyBranchBaseID || OTID_AXIS_LABELS == nPropertyBranchBaseID )
		{			
			int nCollBranchBaseID;
			int nSubAxisIndex = GetSubAxisIndex(trEditNode, &nCollBranchBaseID);
			int nSubAxisBranchOrder = GetSubAxisBranchOrder(trEditNode); /// Iris 7/13/2012 ORG-5991-P9 FIX_PROPERTY_IN_YAXIS_NOT_BE_CHANGED_WHEN_APPLY_CHANGES_WITH_SELECT_OTHERS
			
			if( nCollBranchBaseID > 0 )
			{		
				for(int nn = 0; nn < m_vnChangedAxes.GetSize(); nn++)
				{	
					int nAxis = m_vnChangedAxes[nn];
					TreeNode trThemeAxis = GetThemeAxisNode(nAxis);
					TreeNode trGetNAxis = GetGetNAxisNode(nAxis);
					
					TreeNode trThemeBranch, trThemeCollBranch;
					/// Iris 7/13/2012 ORG-5991-P9 FIX_PROPERTY_IN_YAXIS_NOT_BE_CHANGED_WHEN_APPLY_CHANGES_WITH_SELECT_OTHERS
					//int nCollBranchDataID = GetColletionMemberBranchNode(nCollBranchBaseID, nSubAxisIndex, nAxis);
					int nCollBranchDataID = GetColletionMemberBranchNode(nCollBranchBaseID, _CHECK_CONVERT_SUB_AXIS_INDEX(nAxis, nSubAxisBranchOrder), nAxis);
					///End FIX_PROPERTY_IN_YAXIS_NOT_BE_CHANGED_WHEN_APPLY_CHANGES_WITH_SELECT_OTHERS
					if( isInThemeScale(nEditNodeDataID) )
					{
						trThemeBranch = trThemeCollBranch = trThemeAxis.Scale;
					}
					else
					{
						trThemeBranch = (OTID_AXIS_LABELS == nPropertyBranchBaseID) ? trThemeAxis.Labels : trThemeAxis.Ticks;						
						trThemeCollBranch = _get_theme_node_by_id(trThemeBranch, nCollBranchDataID, true);			
					}
					
					if( trThemeCollBranch )
					{
						/// Iris 5/17/2012 ORG-5719-P1 FIX_FAIL_TO_CHANGE_TICK_LABEL_TYPE
						/*
						if( octree_copy_values_by_id(&trEditBranch, &trThemeCollBranch, false, STR_DATAID_ATTRIB, STR_ID_ATTRIB) >= 0 )
						{
							octree_copy_atts_by_id(&trEditBranch, &trThemeCollBranch, STR_CHANGED_ATTRIB, STR_DATAID_ATTRIB, STR_ID_ATTRIB);					
						}	
						*/
						TreeNode trJunk;
						//_copy_sub_nodes(trEditBranch, trThemeCollBranch, trJunk);
						_copy_changed_nodes(trEditBranch, trThemeCollBranch, trJunk);
						///End FIX_FAIL_TO_CHANGE_TICK_LABEL_TYPE
					}
					else // if the branch is not existed in theme node, we need to add
					{
						TreeNode trGetNBranch = (OTID_AXIS_LABELS == nPropertyBranchBaseID) ? trGetNAxis.Labels : trGetNAxis.Ticks;
						TreeNode trGetNCollBranch = _get_GetN_node_by_id(trGetNBranch, nCollBranchDataID, true);
						TreeNode trEditNodeInOneAxis = _get_GetN_node_by_id(trGetNCollBranch, nEditNodeDataID, true);
						ASSERT(trGetNCollBranch && trEditNodeInOneAxis);
						
						if( trGetNCollBranch && trEditNodeInOneAxis)
						{							
							_set_change_bit(trGetNCollBranch);
							_set_change_bit(trEditNodeInOneAxis);
							
							TreeNode trJunk;
							//_copy_sub_nodes(trGetNBranch, trThemeBranch, trJunk);
							_copy_changed_nodes(trGetNBranch, trThemeBranch, trJunk);
						}
					}
					bNeedToUpdateThemeEx = false; // no need to copy values from GetN to theme outside again.
				}	
			}
		}
	}		
	
	/// Iris 6/21/2012 ORG-5991-S4 MOVE_SPECIAL_TICK_LABEL_OUTSIDE_LABELS_BRANCH
	/*
	switch( nEditBranchDataID )
	{
	case OTID_AXIS_SPECIALTICKS:
	*/
	switch( _get_base_id(nEditBranchDataID) )
	{	
	case ID_AXIS_SPECIALTICK:
	///End MOVE_SPECIAL_TICK_LABEL_OUTSIDE_LABELS_BRANCH
		_special_tick_label_type_list_event(trEditBranch);
		bUpdatedGUIEx = true;
		
		/// Iris 6/21/2012 ORG-5991-S4 MOVE_SPECIAL_TICK_LABEL_OUTSIDE_LABELS_BRANCH
		//int nCollBranchBaseID;
		//int nSubAxisIndex = GetSubAxisIndex(trEditNode, &nCollBranchBaseID);
		/// Iris 7/13/2012 ORG-5991-P9 FIX_PROPERTY_IN_YAXIS_NOT_BE_CHANGED_WHEN_APPLY_CHANGES_WITH_SELECT_OTHERS
		//int nSubAxisIndex = GetSubAxisIndex(trEditNode);
		int nSubAxisBranchOrder = GetSubAxisBranchOrder(trEditNode);
		///End FIX_PROPERTY_IN_YAXIS_NOT_BE_CHANGED_WHEN_APPLY_CHANGES_WITH_SELECT_OTHERS
		///End MOVE_SPECIAL_TICK_LABEL_OUTSIDE_LABELS_BRANCH
		for(int nn = 0; nn < m_vnChangedAxes.GetSize(); nn++)
		{	
			int nAxis = m_vnChangedAxes[nn];
			TreeNode trThemeAxis = GetThemeAxisNode(nAxis);
			
			/// Iris 6/21/2012 ORG-5991-S4 MOVE_SPECIAL_TICK_LABEL_OUTSIDE_LABELS_BRANCH
			//int nCollBranchDataID = GetColletionMemberBranchNode(nCollBranchBaseID, nSubAxisIndex, nAxis);
			/// Iris 7/13/2012 ORG-5991-P9 FIX_PROPERTY_IN_YAXIS_NOT_BE_CHANGED_WHEN_APPLY_CHANGES_WITH_SELECT_OTHERS
			//int nCollBranchDataID = GetColletionMemberBranchNode(OTID_AXIS_LABEL, nSubAxisIndex, nAxis);
			int nCollBranchDataID = GetColletionMemberBranchNode(OTID_AXIS_LABEL, _CHECK_CONVERT_SUB_AXIS_INDEX(nAxis, nSubAxisBranchOrder), nAxis);
			///End FIX_PROPERTY_IN_YAXIS_NOT_BE_CHANGED_WHEN_APPLY_CHANGES_WITH_SELECT_OTHERS
			///End MOVE_SPECIAL_TICK_LABEL_OUTSIDE_LABELS_BRANCH
			TreeNode trThemeSubLabelBranch = _get_theme_node_by_id(trThemeAxis.Labels, nCollBranchDataID, false);
			if( trThemeSubLabelBranch )
			{
				_copy_special_tick_label_settings_from_GetN_to_theme(trEditBranch, trThemeSubLabelBranch.SpecialTicks);
			}
		}		
		bNeedToUpdateThemeEx = false;
		break;
	default:
		break;
	}
	
	stThemeUpdateInfo.bNeedToUpdateTheme = !bNeedToUpdateThemeEx ? bNeedToUpdateThemeEx : stThemeUpdateInfo.bNeedToUpdateTheme;
	stThemeUpdateInfo.bNeedToUpdateGUI = stThemeUpdateInfo.bNeedToUpdateGUI || bUpdatedGUIEx;
}

bool GeneralPlotAxesControlSplitter::GetChangedAxisIndices(TreeNode& trEditNode)
{	
	/// Iris 7/30/2012 ORG-6371-P2 FIX_CHANGED_ONE_AXIS_EFFECTED_ALL_OTHER_AXES
	/*
	/// Iris 7/25/2012 ORG-5991-P12 AXIS_AUTO_SHOWHIDE_EFFECTED_ALL_AXES
	if( OTID_AXIS_AUTO_HIDE == trEditNode.DataID )
	{
		m_vnChangedAxes.Data(0, m_nNumAxes - 1, 1);
		return false; // return true only when axis property changed
	}
	///End AXIS_AUTO_SHOWHIDE_EFFECTED_ALL_AXES
	*/
	///End FIX_CHANGED_ONE_AXIS_EFFECTED_ALL_OTHER_AXES
	
	bool bRet = AxesControlSplitter::GetChangedAxisIndices(trEditNode);
	
	if( m_vnChangedAxes.GetSize() > 0 && -1 == m_vnChangedAxes[0] )
	{
		m_vnChangedAxes.Data(0, m_nNumAxes - 1, 1);
	}		
	return bRet;
}

// virtual
TreeNode GeneralPlotAxesControlSplitter::GetGetNGridsNode(int nAxis/* = -1*/)
{
	TreeNode trAxis = GetGetNAxisNode(nAxis);
	if( trAxis )
	{
		return trAxis.Grids;
	}
}

/// Iris 6/06/2012 ORG-5528-S3 TO_DISABLE_LINE_TITLE_TICKLABEL_SHOW_WHEN_AUTO_SHOW_HIDE_SELECTED
/*
/// Iris 5/22/2012 ORG-5528-S3 ADD_AUTO_SHOWHIDE_CHECKBOX
void GeneralPlotAxesControlSplitter::updateShowEnableStatusOnAutoShowHide()
{
	TreeNode trAutoHide = GetListTree().Misc.AutoHide;
	if( !trAutoHide )
		return;
	
	for(int nAxis = 0; nAxis < m_nNumAxes; nAxis++)
	{			
		TreeNode trAxis = GetGetNAxisNode(nAxis);
		TreeNode trLine = trAxis.Line;
		
		foreach(TreeNode trBranch in trLine.Children)
		{
			if( trBranch.GetNodeCount() > 0 && OTID_AXIS_TICK == _get_base_id(trBranch.DataID) )
			{
				TreeNode trShow = tree_get_node_by_dataid(trBranch, OTID_AXIS_TICK_SHOW);
				if( trShow )
					trShow.Enable = !trAutoHide.nVal;
			}
		}		
	}	
}
///End ADD_AUTO_SHOWHIDE_CHECKBOX
*/

/// Iris 8/08/2012 ORG-6463-S3 ADD_AXIS_SHOW_PROPERTY_IN_AXIS_ROOT_BRANCH
//static void _set_enable_status_for_show_property(TreeNode &trBranch, int nSubBranchBaseID, int nShowID, bool bEnable)
//{
	//if( !trBranch )
		//return;
	//foreach(TreeNode trSubBranch in trBranch.Children)
	//{
		//if( trSubBranch.GetNodeCount() > 0 && nSubBranchBaseID == _get_base_id(trSubBranch.DataID) )
		//{
			//TreeNode trShow = tree_get_node_by_dataid(trSubBranch, nShowID, true);
			//if( trShow )
				//trShow.Enable = bEnable;
		//}
	//}	
//}
//
//void GeneralPlotAxesControlSplitter::UpdateShowEnableStatusOnAutoShowHide(TreeNode *ptrGetN/* = NULL*/)
//{	
	//TreeNode trGetN;
	//if( NULL == ptrGetN )
	//{
		//trGetN = GetListTree();
	//}
	//else
	//{
		//trGetN = *ptrGetN;
	//}
	//if( !trGetN )
		//return;
	//
	//TreeNode trAutoHide = trGetN.Misc.AutoHide;
	//if( !trAutoHide )
		//return;
	//bool bEnable = !trAutoHide.nVal;	
		//
	//for(int nAxis = 0; nAxis < m_nNumAxes; nAxis++)
	//{					
				//
		//TreeNode trAxis = GetGetNAxisNode(nAxis, ptrGetN);
		//if( trAxis )
		//{
			///// Iris 6/13/2012 ORG-5991 MOVE_TICKS_AND_LINE_BRANCH_INTO_AXIS_FORMAT_BRANCH
			////_set_enable_status_for_show_property(trAxis.Line, OTID_AXIS_TICK, OTID_AXIS_TICK_SHOW, bEnable);
			//foreach(TreeNode trSubAxis in trAxis.AxisFormat.Children)
			//{
				//if( trSubAxis.GetNodeCount() > 0 )
				//{
					///// Iris 6/25/2012 ORG-5991-P7 FIX_SEL_BOTH_XY_AXES_CANNOT_DISPLAY_UNDEFINE_STATUS
					////TreeNode trShow = _get_GetN_node_by_id(trSubAxis, OTID_AXIS_TICK_SHOW, false);
					//TreeNode trShow = _get_GetN_node_by_id(trSubAxis, ID_AXIS_FIRST_SHOW, false);
					//if( !trShow )
						//trShow = _get_GetN_node_by_id(trSubAxis, ID_AXIS_SECOND_SHOW, false);
					/////End FIX_SEL_BOTH_XY_AXES_CANNOT_DISPLAY_UNDEFINE_STATUS
					//ASSERT( trShow );
					//if( trShow )
						//trShow.Enable = bEnable;
				//}
			//}
			/////End MOVE_TICKS_AND_LINE_BRANCH_INTO_AXIS_FORMAT_BRANCH
			//_set_enable_status_for_show_property(trAxis.Titles, OTID_AXIS_TITLE, OTID_LABEL_SHOW, bEnable);
			//_set_enable_status_for_show_property(trAxis.Labels, OTID_AXIS_LABEL, OTID_AXIS_LABEL_SHOW, bEnable); // for major label
			///// Iris 6/26/2012 ORG-5991-P2 ALLOW_MINOR_LABEL_SHOW_CAN_BE_CHANGE
			////_set_enable_status_for_show_property(trAxis.Labels, OTID_AXIS_LABEL, OTID_AXIS_LABEL_SHOW_MINOR, bEnable); // for minor label
			/////End ALLOW_MINOR_LABEL_SHOW_CAN_BE_CHANGE
		//}		
	//}	
//}
/////End TO_DISABLE_LINE_TITLE_TICKLABEL_SHOW_WHEN_AUTO_SHOW_HIDE_SELECTED
TreeNode GeneralPlotAxesControlSplitter::GetPrimarySecondaryAxisNode(TreeNode& trParent, int nAxis, bool bIsPrimary, bool bIsGetN)
{
	TreeNode trSubAxis;
	if( !trParent )
		return trSubAxis;	
	
	if( bIsGetN )
	{
		/// Iris 8/14/2012 ORG-6463-S4 CHANGE_SUB_AXIS_NAMING_RULE
		//string strLabel = STR_3D_SUB_AXIS_LABELS;
		//strLabel = strLabel.GetToken(bIsPrimary ? 0 : 1, '|'); // for GetN tree, Primary axis always be the first one
		string strLabel = GetAxisSubBranchLabel(nAxis);		
		strLabel = _get_sub_label_str(strLabel, GetPrimarySecondaryAxisIndex(nAxis, bIsPrimary));
		///End CHANGE_SUB_AXIS_NAMING_RULE
		trSubAxis = trParent.FindNodeByAttribute(STR_LABEL_ATTRIB, strLabel);		
	}
	else
	{	
		int nPrimaryAxis = GetPrimarySecondaryAxisIndex(nAxis, true);		
	
		TreeNode trFirstSub = trParent.FirstNode;
		TreeNode trSecondSub = trFirstSub.NextNode;
		TreeNode trPrimary = ( 0 == nPrimaryAxis ) ? trFirstSub : trSecondSub;
		TreeNode trSecondary = ( 0 != nPrimaryAxis ) ? trFirstSub : trSecondSub;
		trSubAxis = bIsPrimary ? trPrimary : trSecondary;
	}
	
	ASSERT( trSubAxis );	
	return trSubAxis;
}

TreeNode GeneralPlotAxesControlSplitter::GetPropertyBranchShowNode(TreeNode& trBranch, int nAxis, bool bIsPrimary, int nShowID, bool bGetNTree, bool bIsMinor)
{
	TreeNode trSubAxis, trShow;		
	
	// if show both primary and secondary axis, the Show checkbox all are under Property barnach - Line and Ticks, Titles, Tick Labels.	
	if( bGetNTree )
	{	
		trSubAxis = trBranch;	
		ASSERT( trSubAxis );
		if( trSubAxis )
		{			
			int nID;
			if( bIsPrimary )
			{
				nID = bIsMinor ? ID_PRIMARY_MINOR_SHOW : ID_PRIMARY_SHOW;
			}
			else
			{
				nID = bIsMinor ? ID_SECONDARY_MINOR_SHOW : ID_SECONDARY_SHOW;
			}
			trShow = _get_GetN_node_by_id(trSubAxis, nID, false);
		}
	}
	
	if( !bGetNTree || !trShow ) // if show Primary axis only, the Show checkbox all are under Primary branch node
	{		
		trSubAxis = GetPrimarySecondaryAxisNode(trBranch, nAxis, bIsPrimary, bGetNTree);
		ASSERT( trSubAxis );
		if( trSubAxis )
		{
			trShow = tree_get_node_by_dataid(trSubAxis, nShowID, true);
		}		
	}
		
	return trShow;
}

void GeneralPlotAxesControlSplitter::UpdateSubAxisShowNodeStatus(TreeNode &trBranch, int nAxis, bool bIsPrimary, int nShowID, int nCheck, bool bGetNTree)
{
	ASSERT(trBranch);
	if( !trBranch || -1 == nCheck )
		return;
	
	TreeNode trShow = GetPropertyBranchShowNode(trBranch, nAxis, bIsPrimary, nShowID, bGetNTree);
	if( trShow )
	{				
		_set_value_with_change_bit(trShow, nCheck);
		
		/// Iris 9/20/2012 ORG-6892-P1 IMPROVE_DISABLE_SUB_AXIS_BRANCH_CODES
		// to enable/disable Bottom/Top branch refer to Show checkbox under Axis branch. 
		// Bottom/Top branch only show when Use One Axis for each director checkbox is uncheced. 
		if( bGetNTree && !IsShowPrimaryAxesOnly() ) 
		{				
			DisableSubAxisBranchWhenShowNodeUnchecked(trBranch, trShow, nAxis, bIsPrimary);
		}
		///End IMPROVE_DISABLE_SUB_AXIS_BRANCH_CODES
	}	
}

void GeneralPlotAxesControlSplitter::UpdatePropertyBranchShowNodeFromAxisBranch(TreeNode& trGetNAxis, int nAxis, bool bIsPrimary, int nCheck, bool bUpdateTheme)
{
	// update Show node status in property branch from check/uncheck status of the edited node 
	bool bGetNTree = true;	
	ASSERT(trGetNAxis);
	if( trGetNAxis )
	{
		/// Iris 8/14/2012 ORG-6463-S4 CHANGE_SUB_AXIS_NAMING_RULE
		//UpdateSubAxisShowNodeStatus(trGetNAxis.AxisFormat, nAxis, bIsPrimary, bIsPrimary ? ID_AXIS_FIRST_SHOW : ID_AXIS_SECOND_SHOW, nCheck, bGetNTree);
		UpdateSubAxisShowNodeStatus(trGetNAxis.AxisFormat, nAxis, bIsPrimary, ID_AXIS_FIRST_SHOW + GetPrimarySecondaryAxisIndex(nAxis, bIsPrimary), nCheck, bGetNTree);
		///End CHANGE_SUB_AXIS_NAMING_RULE
		UpdateSubAxisShowNodeStatus(trGetNAxis.Titles, nAxis, bIsPrimary, OTID_LABEL_SHOW, nCheck, bGetNTree);						
		UpdateSubAxisShowNodeStatus(trGetNAxis.Labels, nAxis, bIsPrimary, OTID_AXIS_LABEL_SHOW, nCheck, bGetNTree); // major tick label		
	}
	
	// apply the change to theme tree
	if( bUpdateTheme )
	{
		bGetNTree = false;
		TreeNode trThemeAxis = GetThemeAxisNode(nAxis);
		ASSERT(trThemeAxis);
		if( trThemeAxis )
		{
			UpdateSubAxisShowNodeStatus(trThemeAxis.Ticks, nAxis, bIsPrimary, OTID_AXIS_TICK_SHOW, nCheck, bGetNTree);
			UpdateSubAxisShowNodeStatus(trThemeAxis.Titles, nAxis, bIsPrimary, OTID_LABEL_SHOW, nCheck, bGetNTree);						
			UpdateSubAxisShowNodeStatus(trThemeAxis.Labels, nAxis, bIsPrimary, OTID_AXIS_LABEL_SHOW, nCheck, bGetNTree); // major tick label			
		}
	}
}

void GeneralPlotAxesControlSplitter::UpdateAxisBranchShowNodeFromPropertyBranch(TreeNode& trGetNAxis, int nAxis, bool bIsPrimary)
{
	TreeNode trAxisShow = _get_GetN_node_by_id(trGetNAxis, bIsPrimary ? ID_SHOW_PRIMARY_AXIS : ID_SHOW_SECONDARY_AXIS, false);
	ASSERT(trAxisShow);
	if( !trAxisShow )
		return;
	
	vector<string> vsBranchName = {
		"AxisFormat", 
		"Titles",
		"Labels"		
	};
	vector<int> vnShowIDs = {
		0, // assigned it below
		OTID_LABEL_SHOW,
		OTID_AXIS_LABEL_SHOW		
	};
	/// Iris 8/14/2012 ORG-6463-S4 CHANGE_SUB_AXIS_NAMING_RULE
	//vnShowIDs[0] = bIsPrimary ? ID_AXIS_FIRST_SHOW : ID_AXIS_SECOND_SHOW;
	vnShowIDs[0] = ID_AXIS_FIRST_SHOW + GetPrimarySecondaryAxisIndex(nAxis, bIsPrimary);
	///End CHANGE_SUB_AXIS_NAMING_RULE
	
	int nCheck = -2; // -1 = undefined, 0 = uncheck, 1 = check
	for(int index = 0; index < vsBranchName.GetSize(); ++index)
	{
		TreeNode trBranch = trGetNAxis.GetNode(vsBranchName[index]);
		TreeNode trShow = GetPropertyBranchShowNode(trBranch, nAxis, bIsPrimary, vnShowIDs[index], true);
		ASSERT(trShow);
		
		if( trShow )
		{
			if( nCheck < -1 )
				nCheck = trShow.nVal;
			else if( nCheck != trShow.nVal )
			{
				nCheck = -1;
				break;
			}
		}
	}
	
	trAxisShow.RemoveAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED);
	if( -1 == nCheck )
	{
		trAxisShow.SetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, 1);
	}
	else
	{		
		trAxisShow.nVal = nCheck;
	}
}
///End ADD_AXIS_SHOW_PROPERTY_IN_AXIS_ROOT_BRANCH

void GeneralPlotAxesControlSplitter::moveShowControlToPropertyBranch(TreeNode& trSubAxis, LPCSTR lpcszSubAxisShowName, TreeNode& trBranch, TreeNode& trInsertBefore, int nAxis, int nSubAxis, LPCSTR lpcszOldName, LPCSTR lpcszOldLabel, int nOldID, LPCSTR lpcszNewLabel, bool bIsPrimary, bool bIsMinor)
{		
	if( !trSubAxis || !trBranch )
		return;	
	
	TreeNode trSubAxisShow = trBranch.GetNode(lpcszSubAxisShowName);
	if( !trSubAxisShow )
	{			
		// get Show node from Primary Axis branch
		TreeNode trShow = _get_GetN_node_by_id(trSubAxis, nOldID, true);
		ASSERT( trShow );
		if( trShow )
		{
			if( 0 == nSubAxis && !bIsMinor ) // only insert Separator once time if have both Major and Minor
			{
				const string strName = "Separator";
				if( !trBranch.GetNode(strName) )
					trBranch.InsertNode(trInsertBefore, strName, ONODETYPE_SEPARATOR);				
			}
			
			// add Show node to property branch
			trSubAxisShow = trBranch.InsertNode(trInsertBefore, lpcszSubAxisShowName, TRGP_CHECK);					
			trSubAxisShow.SetAttribute(STR_ORIGINAL_SHOW_NODE_ID_ATTRIB, trShow.DataID);
			trSubAxisShow.nVal = trShow.nVal;
			if( bIsPrimary )
				trSubAxisShow.DataID = bIsMinor ? ID_PRIMARY_MINOR_SHOW : ID_PRIMARY_SHOW;			
			else
				trSubAxisShow.DataID = bIsMinor ? ID_SECONDARY_MINOR_SHOW : ID_SECONDARY_SHOW;			
			
			// set label
			TreeNode trSubAxisBranch = _get_sub_branch_by_index(trBranch, GetPrimarySecondaryAxisIndex(nAxis, bIsPrimary));					
			ASSERT( trSubAxisBranch );
			if( trSubAxisBranch )
			{
				string str;
				trSubAxisBranch.GetAttribute(STR_LABEL_ATTRIB, str);
				
				string strLabel;
				strLabel.Format(lpcszNewLabel, str);
				trSubAxisShow.SetAttribute(STR_LABEL_ATTRIB, strLabel);
			}
			
			// remove Show from Primary Axis branch			
			trShow.Remove();
		}
	}	
}

void GeneralPlotAxesControlSplitter::moveShowControlToSubAxisBranch(TreeNode& trSubAxis, LPCSTR lpcszSubAxisShowName, TreeNode& trBranch, int nAxis, LPCSTR lpcszOldName, LPCSTR lpcszOldLabel, int nOldID, bool bIsPrimary, bool bIsMinor)
{
	if( !trSubAxis || !trBranch )
		return;	
		
	TreeNode trSubAxisShow = trBranch.GetNode(lpcszSubAxisShowName);				
	if( trSubAxisShow )
	{
		TreeNode trShow = _get_GetN_node_by_id(trSubAxis, nOldID, true);
		if( !trShow ) // if Show already under Primary axis, then no need to move			
		{
			// Show check box in Primary axis branch
			TreeNode trInsertBefore = bIsMinor ? trSubAxis.FirstNode.NextNode : trSubAxis.FirstNode;
			trShow = trSubAxis.InsertNode(trInsertBefore, lpcszOldName, TRGP_CHECK);
			trShow.SetAttribute(STR_LABEL_ATTRIB, lpcszOldLabel);
			trShow.DataID = nOldID;
			trShow.nVal = trSubAxisShow.nVal;	
		}
		
		// to remove from property root branch
		trSubAxisShow.Remove();				
	}
}
	
/// Iris 8/10/2012 ORG-6463-S3 MOVE_PRIMARY_AND_SECONDARY_SHOW_PROPERTY_TO_PROPERTY_BRANCH
void GeneralPlotAxesControlSplitter::CheckMoveShowControl(TreeNode& trBranch, int nAxis, int nSubAxis, LPCSTR lpcszOldName,LPCSTR lpcszOldLabel, int nOldID, LPCSTR lpcszNewLabel, bool bIsPrimary, bool bIsMinor)
{	
	TreeNode trSubAxis = GetPrimarySecondaryAxisNode(trBranch, nAxis, bIsPrimary, true);	
	ASSERT( trSubAxis );	
	if( !trSubAxis )
		return;
	
	const string 	strPrimaryShowName = bIsMinor ? "PrimaryMinorShow" : "PrimaryShow",
					strSecondaryShowName = bIsMinor ? "SecondaryMinorShow" : "SecondaryShow";		
	string strShowName = bIsPrimary ? strPrimaryShowName : strSecondaryShowName;
	
	if( IsShowPrimaryAxesOnly() )
	{	
		moveShowControlToSubAxisBranch(trSubAxis, strShowName, trBranch, nAxis, lpcszOldName, lpcszOldLabel, nOldID, bIsPrimary, bIsMinor);
		/// Iris 9/20/2012 ORG-6892-P1 IMPROVE_DISABLE_SUB_AXIS_BRANCH_CODES
		trSubAxis.RemoveAttribute(STR_ENABLE_ATTRIB);
		///End IMPROVE_DISABLE_SUB_AXIS_BRANCH_CODES
	}
	else // move Show checkbox from property branch node to Axis branch
	{
		// add the two checkboxs before sub axis branch
		TreeNode trInsertBefore;
		foreach(TreeNode trSub in trBranch.Children)
		{
			if( trSub.GetNodeCount() > 0 )
			{
				trInsertBefore = trSub;
				break;
			}
		}
		ASSERT( trInsertBefore );		
		
		moveShowControlToPropertyBranch(trSubAxis, strShowName, trBranch, trInsertBefore, nAxis, nSubAxis, lpcszOldName, lpcszOldLabel, nOldID, lpcszNewLabel, bIsPrimary, bIsMinor);			
	}
}

void GeneralPlotAxesControlSplitter::CheckMoveShowControlForAllAxes(TreeNode* ptrGetN)// = NULL
{
	for(int nAxis = 0; nAxis < m_nNumAxes; ++nAxis)
	{
		TreeNode trGetNAxis = GetGetNAxisNode(nAxis, ptrGetN);
		
		for(int nSubAxis = 0; nSubAxis < SUB_AXIS_COUNT; ++nSubAxis)
		{
			bool bIsPrimary = nSubAxis == GetPrimarySecondaryAxisIndex(nAxis, true);
			
			CheckMoveShowControl(trGetNAxis.Labels, nAxis, nSubAxis, "ShowMajor", STR_SHOW_MAJOR_LABELS_LABEL, OTID_AXIS_LABEL_SHOW, STR_SHOW_MAJOR_LABEL_LABEL, bIsPrimary, false); // major label			
			CheckMoveShowControl(trGetNAxis.Labels, nAxis, nSubAxis, "ShowMinor", STR_SHOW_MINOR_LABELS_LABEL, OTID_AXIS_LABEL_SHOW_MINOR, STR_SHOW_MINOR_LABEL_LABEL, bIsPrimary, true); // minor label						
			CheckMoveShowControl(trGetNAxis.Titles, nAxis, nSubAxis, "Show", STR_SHOW_LABEL, OTID_LABEL_SHOW, STR_SHOW_TITLE_LABEL, bIsPrimary);	
			CheckMoveShowControl(trGetNAxis.AxisFormat, nAxis, nSubAxis, "Show", STR_SHOW_LABEL, ID_AXIS_FIRST_SHOW + nSubAxis, STR_SHOW_AXIS_LINE_LABEL, bIsPrimary);				
		}
	}
}
///End MOVE_PRIMARY_AND_SECONDARY_SHOW_PROPERTY_TO_PROPERTY_BRANCH

/// Iris 9/18/2012 ORG-6834-P2 CHANGE_TO_LOG_SCALE_TYPE_CAUSE_RUNTIME_ERROR_IN_RADAR_AXES_DLG
void GeneralPlotAxesControlSplitter::UpdateControlsByIncrementByChange(TreeNode& trBranch)
{
	/// Iris 7/23/2012 ORG-6319-P1 FIX_AXES_DLG_RUNTIME_ERROR_IN_JOS
	//bool bMajor = IsMajor(trBranch, trParent.DataID);
	TreeNode trParent = trBranch.Parent();
	bool bMajor = IsMajor(trBranch, trParent.DataID);
	///End FIX_AXES_DLG_RUNTIME_ERROR_IN_JOS
	
	TreeNode trIncBy = trBranch.IncrementBy;
	ASSERT(trIncBy);
	if( !trIncBy )
		return;
	
	int nDatasetID = bMajor ? OTID_AXIS_SCALE_USER_MAJOR_TICKS : OTID_AXIS_SCALE_USER_MINOR_TICKS;
	int nTicksCountID = bMajor ? OTID_AXIS_SCALE_MAJOR_COUNT : OTID_AXIS_SCALE_MINOR_COUNT;
	TreeNode trGetNDataset = _get_GetN_node_by_id(trBranch, nDatasetID);
	TreeNode trGetNTicksCount = _get_GetN_node_by_id(trBranch, nTicksCountID);
	
	if( trBranch.Value )
		trBranch.Value.Show = false;
	if( trGetNTicksCount )
		trGetNTicksCount.Show = false;
	if( trGetNDataset )
		trGetNDataset.Show = false;	
		
	if( bMajor )
	{
		/// Iris 7/24/2012 ORG-6243-P1 DISABLE_FIRST_TICK_WHEN_TICKS_FROM_DATASET
		bool bEnableFirstTick = true;
		/// End DISABLE_FIRST_TICK_WHEN_TICKS_FROM_DATASET
		/// Iris 9/19/2012 ORG-6837-P2 DISABLE_SCALE_TYPE_WHEN_TICKS_FROM_DATASET		
		bool bEnableScaleType = true;
		///End DISABLE_SCALE_TYPE_WHEN_TICKS_FROM_DATASET
		switch(trIncBy.nVal)
		{
		case SET_MAJOR_TICKS_BY_INCREMENT:	
			if( trBranch.Value )
				trBranch.Value.Show = true;	
			break;
			
		case SET_MAJOR_TICKS_BY_COUNT:
			if( trGetNTicksCount )
				trGetNTicksCount.Show = true;
			break;
			
		case SET_MAJOR_TICKS_BY_DATASET:
			if( trGetNDataset )
			{
				trGetNDataset.Show = true;	
				/// Iris 7/24/2012 ORG-6243-P1 DISABLE_FIRST_TICK_WHEN_TICKS_FROM_DATASET
				bEnableFirstTick = false;
				///End DISABLE_FIRST_TICK_WHEN_TICKS_FROM_DATASET
				/// Iris 9/19/2012 ORG-6837-P2 DISABLE_SCALE_TYPE_WHEN_TICKS_FROM_DATASET
				bEnableScaleType = false;
				///End DISABLE_SCALE_TYPE_WHEN_TICKS_FROM_DATASET
			}
			break;
		}
		
		/// Iris 7/24/2012 ORG-6243-P1 DISABLE_FIRST_TICK_WHEN_TICKS_FROM_DATASET
		if( trBranch.FirstTick )
			trBranch.FirstTick.Enable = bEnableFirstTick;
		///End DISABLE_FIRST_TICK_WHEN_TICKS_FROM_DATASET
		
		/// Iris 9/19/2012 ORG-6243-P2 DISABLE_SCALE_TYPE_WHEN_TICKS_FROM_DATASET
		if( trParent.Type )
			_set_enable_attribute(trParent.Type, bEnableScaleType, false);			
		///End DISABLE_SCALE_TYPE_WHEN_TICKS_FROM_DATASET
	}	
	else
	{
		switch(trIncBy.nVal)
		{			
		case SET_MINOR_TICKS_BY_COUNT:
			if( trGetNTicksCount )
				trGetNTicksCount.Show = true;
			break;
			
		case SET_MINOR_TICKS_BY_DATASET:
			if( trGetNDataset )
				trGetNDataset.Show = true;	
			break;
		}
	}
}
///End CHANGE_TO_LOG_SCALE_TYPE_CAUSE_RUNTIME_ERROR_IN_RADAR_AXES_DLG

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
////////////////// GL3DPlotAxesControlSplitter ///////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
// virtual
void GL3DPlotAxesControlSplitter::constructGetNTrees(TreeNode& trGetN, int nNumAxes)
{
	GeneralPlotAxesControlSplitter::constructGetNTrees(trGetN, nNumAxes);
	
	/// Iris 8/06/2012 ORG-6463-S1 ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
	/*
	GETN_USE(trGetN)
	
	GETN_BEGIN_BRANCH(Misc, STR_MISC_BRANCH_LABEL) GETN_ID(IDBRANCH_MISC) GETN_MARK_STOP_BRANCH
		GETN_CHECK(AutoHide, STR_AUTO_SHOW_LABEL, 1) GETN_ID(OTID_AXIS_AUTO_HIDE)
	GETN_END_BRANCH(Misc)
	*/
	///End ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
}

/// Iris 6/21/2012 ORG-5991-S2 EXCHANGE_YAXIS_LEFT_AND_RIGHT_BRANCH
// for now only need exchange the order of Left Axis and Right Axis for Y Axis
void GL3DPlotAxesControlSplitter::exchangeAxisBranchFirstAndSecondSubBranch(TreeNode& trBranch, LPCSTR lpcszSubAxisLabel)
{
	ASSERT(trBranch);
	if( !trBranch )
		return;
	
	TreeNode trFirst;
	Tree trSecond;
	string strFirst, strSecond;
	string strSubLabels(lpcszSubAxisLabel);
	strFirst = strSubLabels.GetToken(0, '|');
	strSecond = strSubLabels.GetToken(1, '|');
	
	foreach(TreeNode trSubNode in trBranch.Children)
	{
		string strLabel;
		trSubNode.GetAttribute(STR_LABEL_ATTRIB, strLabel);
		
		if( trSubNode.GetNodeCount() > 0 )
		{
			if( strLabel.Find(strFirst) >= 0 )
			{
				trFirst = trSubNode;
				trFirst.SetAttribute(STR_LABEL_ATTRIB, strSecond); /// Iris 8/02/2012 ORG-5991-S6 CHANGE_SUB_AXIS_LABEL_FOR_3DGL_GRAPH
			}
			else if( strLabel.Find(strSecond) >= 0 )
			{
				trSecond.Replace( trSubNode.Clone() );
				trSecond.SetAttribute(STR_LABEL_ATTRIB, strFirst); /// Iris 8/02/2012 ORG-5991-S6 CHANGE_SUB_AXIS_LABEL_FOR_3DGL_GRAPH
				trSubNode.Remove();
			}
		}
		/// Iris 8/02/2012 ORG-5991-S6 CHANGE_SUB_AXIS_LABEL_FOR_3DGL_GRAPH
		//else if( ID_SAME_FOR_BOTTOM_AND_TOP == trSubNode.DataID )
		//{
			//string strLabel;
			//strLabel.Format(STR_SAME_OPTIONS_FOR_BOTH, strSecond, strFirst);
			//trSubNode.SetAttribute(STR_LABEL_ATTRIB, strLabel);
		//}
		///End CHANGE_SUB_AXIS_LABEL_FOR_3DGL_GRAPH
	}
	
	if( trFirst && trSecond )
	{
		TreeNode trNew = trBranch.InsertNode(trFirst, "junk");
		trNew.Replace( trSecond.Clone() );		
	}
}

//virtual 
void GL3DPlotAxesControlSplitter::ConstructOneAxisPropertyNodes(TreeNode& trAxis, int nAxis)
{	
	GeneralPlotAxesControlSplitter::ConstructOneAxisPropertyNodes(trAxis, nAxis);
	
	/// Iris 8/08/2012 ORG-6463-S3 ADD_AXIS_SHOW_PROPERTY_IN_AXIS_ROOT_BRANCH
	TreeNode trInsertAt = trAxis.SameForBoth.NextNode;
	if( trInsertAt )
	{			
		trAxis.InsertNode(trInsertAt, "Separator", ONODETYPE_SEPARATOR);
		
		for(int nSubAxis = 0; nSubAxis < SUB_AXIS_COUNT; ++nSubAxis)
		{
			bool bIsPrimary = (nSubAxis == GetPrimarySecondaryAxisIndex(nAxis, true) );
			string strtagName = bIsPrimary ? "ShowPrimaryAxis" : "ShowSecondaryAxis";
			int nID = bIsPrimary ? ID_SHOW_PRIMARY_AXIS : ID_SHOW_SECONDARY_AXIS;
			
			TreeNode trCheck = trAxis.InsertNode(trInsertAt, strtagName, TRGP_CHECK);		
			trCheck.DataID = nID;				
		}
	}
	///End ADD_AXIS_SHOW_PROPERTY_IN_AXIS_ROOT_BRANCH
	
	/// Iris 6/26/2012 ORG-5528-P22 NOT_EXCHANGE_LEFT_RIGHT_SUBAXIS_FOR_YAXIS_IN_XYY_3DBAR_PLOT
	//if( AXIS_Y == nAxis )
	if( AXIS_Y == nAxis && IsExchangeYAxisSubAxis() )
	///End NOT_EXCHANGE_LEFT_RIGHT_SUBAXIS_FOR_YAXIS_IN_XYY_3DBAR_PLOT
	{			
		exchangeAxisBranchFirstAndSecondSubBranch(trAxis.AxisFormat, GetAxisSubBranchLabel(nAxis));	
		/// Iris 6/25/2012 ORG-5991-P7 FIX_SEL_BOTH_XY_AXES_CANNOT_DISPLAY_UNDEFINE_STATUS
		TreeNode trRightShow = trAxis.AxisFormat.Right.GetNode("Show");		
		if( trRightShow )
			trRightShow.DataID = ID_AXIS_FIRST_SHOW;
		TreeNode trLeftShow = trAxis.AxisFormat.Left.GetNode("Show");
		if( trLeftShow )
			trLeftShow.DataID = ID_AXIS_SECOND_SHOW;
		///End FIX_SEL_BOTH_XY_AXES_CANNOT_DISPLAY_UNDEFINE_STATUS
		exchangeAxisBranchFirstAndSecondSubBranch(trAxis.Titles, GetAxisSubBranchLabel(nAxis));
		exchangeAxisBranchFirstAndSecondSubBranch(trAxis.Labels, GetAxisSubBranchLabel(nAxis));
		exchangeAxisBranchFirstAndSecondSubBranch(trAxis.SpecialLabels, GetAxisSubBranchLabel(nAxis));
	}
}
///End EXCHANGE_YAXIS_LEFT_AND_RIGHT_BRANCH

/// Iris 6/26/2012 ORG-5528-P22 NOT_EXCHANGE_LEFT_RIGHT_SUBAXIS_FOR_YAXIS_IN_XYY_3DBAR_PLOT
//virtual 
bool GL3DPlotAxesControlSplitter::IsExchangeYAxisSubAxis()
{
	/// Iris 8/14/2012 ORG-6463-S4 CHANGE_SUB_AXIS_NAMING_RULE
	/*
	// default do this exchange for 3D except XYY 3DBars graph, this graph default display Y Left Axis, the other normal graph default display Right Axis.
	if( !m_gl )
		return true; 
		
	DWORD dw = m_gl.GetSystemParam(GLI_PCD_BITS);	
	if( O_GET_NBITS(dw, MASK_PCD_LAYER_BITS) == PCD_LAYER_3D_XYY )
		return false;
	
	return true;
	*/
	return false;
	///End CHANGE_SUB_AXIS_NAMING_RULE
}
///End NOT_EXCHANGE_LEFT_RIGHT_SUBAXIS_FOR_YAXIS_IN_XYY_3DBAR_PLOT

/// Iris 6/25/2012 ORG-5991-P7 FIX_SEL_BOTH_XY_AXES_CANNOT_DISPLAY_UNDEFINE_STATUS
//virtual 
static int _check_convert_sub_branch_index_to_sub_axis_index_for_3D(int nAxis, int nSubBranchIndex, bool bConvert)
{
	if( bConvert && AXIS_Y == nAxis )
	{
		if( 0 == nSubBranchIndex )
			return 1;
		else if( 1 == nSubBranchIndex )
			return 0;
	}
	return nSubBranchIndex;
}
///End FIX_SEL_BOTH_XY_AXES_CANNOT_DISPLAY_UNDEFINE_STATUS

/// Iris 8/06/2012 ORG-6463-S1 ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
//virtual
/// Iris 8/08/2012 ORG-6463-S3 ADD_AXIS_SHOW_PROPERTY_IN_AXIS_ROOT_BRANCH
//void GL3DPlotAxesControlSplitter::SetShowPrimaryAxesOnly(bool bIs, bool bUpdateTheme, bool bUpdateListTree) 
void GL3DPlotAxesControlSplitter::SetShowPrimaryAxesOnly(bool bIs, int nEvent, TreeNode* ptrGetN) 
///End ADD_AXIS_SHOW_PROPERTY_IN_AXIS_ROOT_BRANCH
{	
	m_nShowPrimaryAxesOnly = bIs ? SHOW_PRIMARY_ONLY_CHECKED : SHOW_PRIMARY_ONLY_UNCHECKED;
	
	/// Iris 8/16/2012 ORG-6463-P4 FIX_CHANGE_ANY_ONE_CAUSE_Y_TOP_AXES_HIDE
	if( SET_PRIMARY_ONLY_ON_BUTTON_EVENT == nEvent )
		m_bIsShowPrimaryAxesOnlyChanged = true;
	///End FIX_CHANGE_ANY_ONE_CAUSE_Y_TOP_AXES_HIDE
	
	bool bUpdateGetN = SET_PRIMARY_ONLY_ON_AFTER_COPY_VAL_FROM_THEME == nEvent || SET_PRIMARY_ONLY_ON_BUTTON_EVENT == nEvent;
	bool bUpdateTheme = SET_PRIMARY_ONLY_ON_BUTTON_EVENT == nEvent;
	bool bUpdateListTreeStopLevel = SET_PRIMARY_ONLY_ON_BUTTON_EVENT == nEvent;
	
	if( bUpdateGetN )
	{
		/// Iris 8/08/2012 ORG-6463-S3 ADD_AXIS_SHOW_PROPERTY_IN_AXIS_ROOT_BRANCH
		// to disable Show Secondary Axis checkbox when checkbox is checked
		for(int nAxis = 0; nAxis < m_nNumAxes; ++nAxis)
		{
			TreeNode trGetNAxis = GetGetNAxisNode(nAxis, ptrGetN);
			string strShowLabels = IsBottomTopAxis(nAxis) ? STR_SHOW_BOTTOM_TOP_AXIS_LABEL : STR_SHOW_LEFT_RIGHT_AXIS_LABEL;
			
			TreeNode trShowPrimaryAxis = trGetNAxis.ShowPrimaryAxis;
			if( trShowPrimaryAxis )
			{
				/// Iris 8/20/2012 ORG-6463-S5 IMPROVE_CONTROL_LABEL_FOR_SHOW_PRIMARY_AXIS
				//string strLabel = bIs ? STR_SHOW_PRIMARY_AXIS_LABEL : _get_sub_label_str(strShowLabels, GetPrimarySecondaryAxisIndex(nAxis, true));
				string strLabel = _get_sub_label_str(strShowLabels, GetPrimarySecondaryAxisIndex(nAxis, true));
				///End IMPROVE_CONTROL_LABEL_FOR_SHOW_PRIMARY_AXIS
				trShowPrimaryAxis.SetAttribute(STR_LABEL_ATTRIB, strLabel);					
			}
			
			TreeNode trShowSecondaryAxis = trGetNAxis.ShowSecondaryAxis;
			if( trShowSecondaryAxis )
			{
				trShowSecondaryAxis.Show = !bIs;
				
				string strLabel = bIs ? STR_SHOW_SECONDARY_AXIS_LABEL : _get_sub_label_str(strShowLabels, GetPrimarySecondaryAxisIndex(nAxis, false));
				trShowSecondaryAxis.SetAttribute(STR_LABEL_ATTRIB, strLabel);
			}
		}
		///End ADD_AXIS_SHOW_PROPERTY_IN_AXIS_ROOT_BRANCH
		
		/// Iris 8/10/2012 ORG-6463-S3 MOVE_PRIMARY_AND_SECONDARY_SHOW_PROPERTY_TO_PROPERTY_BRANCH	
		CheckMoveShowControlForAllAxes(ptrGetN);	
		///End MOVE_PRIMARY_AND_SECONDARY_SHOW_PROPERTY_TO_PROPERTY_BRANCH		
	}
	
	if( bUpdateListTreeStopLevel )
	{
		// to update left panel tree view display Stop level, 
		// "checkbox = 1" will not display Primary and Secondary branchs, "checkbox = 0" to display.	
		// get the currect axis index and dataid of sel branch		
		int nSelNodeDataID = GetRowID();
		int nSelRowAxisIndex = GetAxisIndex(NULL);		
		
		// if set primary axes show only, the original is show both axes, and the selected row might be Primary or Secondary branch, 
		// but there is not this level when convert to show primary only, so need to go to its prarent now. 
		if( bIs )
		{
			int nSelRow = GetSelectedRow();
			int nLevel = m_AxesGridTree.GetRowOutlineLevel(nSelRow);
			if( LEVEL_SUB_AXIS_BRANCH == nLevel )
			{
				TreeNode trRow = GetTreeNode(nSelRow);
				nSelNodeDataID = trRow.Parent().DataID;
			}
		}
		
		m_AxesGridTree.SetReady(false);
		m_AxesGridTree.ClearAll();			
		DWORD dwCntrl = GetListTreeDisplayCtrl();
		SetListDisplayAttribute(dwCntrl);		
		m_AxesGridTree.AddTreeNodes(GetListTree(), dwCntrl, STR_SPECIALVALS_ATTRIB);				
		m_AxesGridTree.SetReady(true);
		
		// set back row select by axis index and branch id
		SetRowSelection(nSelNodeDataID, nSelRowAxisIndex);						
		if( !IsShowPrimaryAxesOnly() )
		{
			UpdateTreeViewEnableSettings(GetListTree());
		}
	}		
	
	if( bUpdateTheme )
	{
		// to set AutoHide in theme tree 		
		/// Iris 8/14/2012 ORG-6463-P2 IMPROVE_SHOW_PRIMARY_AXES_ONLY
		/*
		Tree trTheme;
		trTheme.Root.Axes.X.AutoHide.nVal = bIs;
		bool bRet = ApplyThemeTree(trTheme, true);
		ASSERT(bRet);		
		*/
		_set_value_with_change_bit(m_trTheme.Root.Axes.X.AutoHide, bIs);
		_set_value_with_change_bit(m_trTheme.Root.Axes.X.ShareFirstAxis, bIs);
		///End IMPROVE_SHOW_PRIMARY_AXES_ONLY
	}	
	
}
///End ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
	
// virtual
void GL3DPlotAxesControlSplitter::GetAxisPropertyCustomOptions()
{
	GeneralPlotAxesControlSplitter::GetAxisPropertyCustomOptions();
	
	m_stOptions.bIncAdditionalLines = false;
	m_stOptions.bIncBreak = false;
}
///End AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH

/// Iris 8/06/2012 ORG-6463-S1 ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
/*
/// Iris 5/22/2012 ORG-5528-S3 ADD_AUTO_SHOWHIDE_CHECKBOX
// virtual 
void GL3DPlotAxesControlSplitter::ApplyOtherPropertiesToThemeTree(TreeNode& trEditNode, TreeNode& trListTreeSelectedNode)
{				
	if( trListTreeSelectedNode.DataID == IDBRANCH_MISC)
	{
		if( OTID_AXIS_AUTO_HIDE == trEditNode.DataID )
		{
			for(int nAxis = 0; nAxis < m_nNumAxes; nAxis++)
			{
				TreeNode trThemeAxis = GetThemeAxisNode(nAxis);
				if( trThemeAxis.AutoHide )
				{					
					_set_value_with_change_bit(trThemeAxis.AutoHide, trEditNode.nVal);
				}
			}
		}
	}	
}
*/
///End ADD_AUTO_SHOWHIDE_CHECKBOX

void GL3DPlotAxesControlSplitter::CopyValuesFromThemeToGetNForOneAxis(TreeNode& trGetN, int nAxis, TreeNode& trThemeOneAxis, TreeNode& trGetNOneAxis)
{	
	GeneralPlotAxesControlSplitter::CopyValuesFromThemeToGetNForOneAxis(trGetN, nAxis, trThemeOneAxis, trGetNOneAxis);
	
	/// Iris 8/08/2012 ORG-6463-S3 ADD_AXIS_SHOW_PROPERTY_IN_AXIS_ROOT_BRANCH
	// according to the Show of Titles, Tick Labels, Line and Ticks branch to set the Show of Axis branch is checked, unchecked or undefined status.
	UpdateAxisBranchShowNodeFromPropertyBranch(trGetNOneAxis, nAxis, true);
	UpdateAxisBranchShowNodeFromPropertyBranch(trGetNOneAxis, nAxis, false);
	
	// According to ShowPrimaryAxis and ShowSecondaryAxis to decide if display the Show checkbox under property branch
	TreeNode trParimaryShow = trGetNOneAxis.ShowPrimaryAxis;
	if( trParimaryShow )
	{
		int nVal;
		int nCheck = trParimaryShow.GetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, nVal) ? -1 : trParimaryShow.nVal;
		UpdatePropertyBranchShowNodeFromAxisBranch(trGetNOneAxis, nAxis, true, nCheck, false);
	}
	TreeNode trSecondaryShow = trGetNOneAxis.ShowSecondaryAxis;
	if( trSecondaryShow )
	{
		int nVal;
		int nCheck = trSecondaryShow.GetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, nVal) ? -1 : trSecondaryShow.nVal;
		UpdatePropertyBranchShowNodeFromAxisBranch(trGetNOneAxis, nAxis, false, nCheck, false);
	}
	///End ADD_AXIS_SHOW_PROPERTY_IN_AXIS_ROOT_BRANCH	
}

//virtual 
void GL3DPlotAxesControlSplitter::CopyValuesFromThemeToGetN(TreeNode& trThemeAxes, TreeNode& trGetN)
{		
	/// Iris 9/10/2012 ORG-6771-P1 FIX_OFFSET_VALUE_NOT_DISPLAY_AS_DATE_TYPE
	// need to set the value of m_nShowPrimaryAxesOnly before GeneralPlotAxesControlSplitter::CopyValuesFromThemeToGetN
	// since in this function need the correct status of the date member. 
	if( trThemeAxes.X.AutoHide )
	{		
		m_nShowPrimaryAxesOnly = 1 == trThemeAxes.X.AutoHide.nVal ? SHOW_PRIMARY_ONLY_CHECKED : SHOW_PRIMARY_ONLY_UNCHECKED;
	}
	///End FIX_OFFSET_VALUE_NOT_DISPLAY_AS_DATE_TYPE
	
	GeneralPlotAxesControlSplitter::CopyValuesFromThemeToGetN(trThemeAxes, trGetN);	
	
	/// Iris 8/06/2012 ORG-6463-S1 ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
	/*
	ASSERT(trThemeAxes.X.AutoHide);
	if( trThemeAxes.X.AutoHide && trGetN.Misc.AutoHide )
	{
		trGetN.Misc.AutoHide.nVal = trThemeAxes.X.AutoHide.nVal;		
		UpdateShowEnableStatusOnAutoShowHide(&trGetN); /// Iris 6/06/2012 ORG-5528-S3 TO_DISABLE_LINE_TITLE_TICKLABEL_SHOW_WHEN_AUTO_SHOW_HIDE_SELECTED		
	}	
	*/
	// set show primary axis only will move Show checkbox, 
	// need to copy values from theme to GetN for Show nodes under each property branch - Titles, Labels, Ticks, 
	// then do the relative GUI change. 	
	bool bShowPrimaryOnly = trThemeAxes.X.AutoHide && trThemeAxes.X.AutoHide.nVal;
	SetShowPrimaryAxesOnly(bShowPrimaryOnly, SET_PRIMARY_ONLY_ON_AFTER_COPY_VAL_FROM_THEME, &trGetN);	
	///End ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX	
}
///End ADD_AUTO_SHOWHIDE_CHECKBOX

/// Iris 8/14/2012 ORG-6463-S4 CHANGE_SUB_AXIS_NAMING_RULE
// virtual
bool GL3DPlotAxesControlSplitter::IsBottomTopAxis(int nAxis)
{	
	int nLeftRightAxis = IsXYY3DBarGraph() ? AXIS_Y : AXIS_Z;
	return (nLeftRightAxis != nAxis);
}
///End CHANGE_SUB_AXIS_NAMING_RULE

/// Iris 8/02/2012 ORG-5991-S6 CHANGE_SUB_AXIS_LABEL_FOR_3DGL_GRAPH
string GL3DPlotAxesControlSplitter::getAxisSubBranchName(int nAxis, int nSubAxis/* = -1*/, bool bLabel/* = false*/)
{
	if( bLabel )
	{
		/// Iris 8/14/2012 ORG-6463-S4 CHANGE_SUB_AXIS_NAMING_RULE		
		//string str = STR_3D_SUB_AXIS_LABELS;
		string str = IsBottomTopAxis(nAxis) ? STR_3D_BOTTOM_TOP_SUB_AXIS_LABELS : STR_3D_LEFT_RIGHT_SUB_AXIS_LABELS;
		///End CHANGE_SUB_AXIS_NAMING_RULE
		
		if( nSubAxis >= 0 )
			return str.GetToken(nSubAxis, '|');
		return str;		
	}
	else
	{
		return GeneralPlotAxesControlSplitter::getAxisSubBranchName(nAxis, nSubAxis, bLabel);
	}
}
///End CHANGE_SUB_AXIS_LABEL_FOR_3DGL_GRAPH

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////// Axes Dialog /////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
BOOL AxesDlg::OnInitDialog()
{
	if( NULL == m_pSplitter )
		return false;
	
	/// Iris 6/04/2012 ORG-5528-S4 SET_3DGL_AXES_DLG_DEFAULT_LAYOUT
	//ResizeDialog::OnInitDialog(IDC_AXES_TREE_CONTROL, STR_AXES_DLG_NAME);
	ResizeDialog::OnInitDialog(IDC_AXES_TREE_CONTROL, m_pSplitter->GetDlgName());
	///End SET_3DGL_AXES_DLG_DEFAULT_LAYOUT
	
	/// Iris 8/14/2012 ORG-6463-P2 IMPROVE_SHOW_PRIMARY_AXES_ONLY
	//GetItem(IDC_APPLY).Enable = false;
	enableApplyButton(false);
	///End IMPROVE_SHOW_PRIMARY_AXES_ONLY
	
	Button btnHideLeft = GetItem(IDC_BTN_SHOW_LEFT_PANEL);
	if( btnHideLeft )
		btnHideLeft.Visible = false;	
	
	/// Iris 5/21/2012 ORG-5528-S6 REMOVE_SAME_OPTIONS_FOR_ALL_BUTTON_FOR_2D_AND_3DGL_GRAPH
	/*
	BOOL bAllAxes = LoadSetting(STR_REG_IS_USE_SAME_OPTIONS_FOR_ALL_AXES, 1, STR_AXES_DLG_NAME);	

	Button btnForAllAxes = GetItem(IDC_CHECK_IS_FOR_ALL_AXES);
	btnForAllAxes.Value = bAllAxes;
	*/
	string strDlgName = m_pSplitter->GetDlgName();
	Button btnForAllAxes = GetItem(IDC_CHECK_IS_FOR_ALL_AXES);
	BOOL bAllAxes = FALSE;
	if( m_pSplitter->IsEnableForAll() )
	{
		/// Iris 6/04/2012 ORG-5528-S4 SET_3DGL_AXES_DLG_DEFAULT_LAYOUT
		//bAllAxes = LoadSetting(STR_REG_IS_USE_SAME_OPTIONS_FOR_ALL_AXES, 1, STR_AXES_DLG_NAME);			
		bAllAxes = LoadSetting(STR_REG_IS_USE_SAME_OPTIONS_FOR_ALL_AXES, 1, strDlgName);			
		///End SET_3DGL_AXES_DLG_DEFAULT_LAYOUT
	}
	else
	{
		btnForAllAxes.Visible = false;
	}
	btnForAllAxes.Value = bAllAxes;
	///End REMOVE_SAME_OPTIONS_FOR_ALL_BUTTON_FOR_2D_AND_3DGL_GRAPH	
	
	/// Iris 6/13/2012 ORG-5930-P3 NOT_USE_LAST_TIME_SELECTED_OBJ_FOR_3D_GRAPH
	if( m_pSplitter->IsUseLastTimeSelected() )
	///End NOT_USE_LAST_TIME_SELECTED_OBJ_FOR_3D_GRAPH
	{
		BOOL bLoad = false;
		/// Iris 6/04/2012 ORG-5528-S4 SET_3DGL_AXES_DLG_DEFAULT_LAYOUT
		//DWORD dwDataID = LoadSetting(STR_REG_SELECTED_OBJ_DATAID, 0, STR_AXES_DLG_NAME, &bLoad);
		DWORD dwDataID = LoadSetting(STR_REG_SELECTED_OBJ_DATAID, 0, strDlgName, &bLoad);
		///End SET_3DGL_AXES_DLG_DEFAULT_LAYOUT
		if( bLoad )
			m_pSplitter->SetLastTimeSelectedObjectDataID((int)dwDataID);
	}
	
	m_pSplitter->SetIsControlForAllAxes(btnForAllAxes.Value);
	
	/// Iris 6/07/2012 ORG-5528-P10 SAVE_SAME_OPTIONS_FOR_BOTH_DIRECTIONS_TO_REGISTRY
	/// Iris 7/19/2012 ORG-5991-P13 SAVE_SAME_OPTIONS_TO_GRAPH_NOT_REGISTRY
	//string strSettings;
	//if( LoadSetting(STR_REG_IS_USE_SAME_OPTIONS_FOR_BOTH_DIRECTIONS_3DGL, strSettings, strDlgName) )
	//{
		//m_pSplitter->SetIsUseSameOptionsForBothDirectionsSettings(strSettings);	
	//}
	///End SAVE_SAME_OPTIONS_TO_GRAPH_NOT_REGISTRY
	///End SAVE_SAME_OPTIONS_FOR_BOTH_DIRECTIONS_TO_REGISTRY
	
	/// Iris 6/04/2012 ORG-5528-S4 SET_3DGL_AXES_DLG_DEFAULT_LAYOUT
	//m_pSplitter->Init(IDC_AXES_TREE_CONTROL, *this, 0, STR_AXES_DLG_NAME);
	m_pSplitter->Init(IDC_AXES_TREE_CONTROL, *this, 0, m_pSplitter->GetDlgName());
	///End SET_3DGL_AXES_DLG_DEFAULT_LAYOUT	
	
	///Jasmine 09/13/2011 ORG-3297 SELECT_RELATIVE_NODES_TO_APPLY_SETTINGS_TO_MULTIP_AXES
	Control btnSel = GetItem(IDC_SEL_RELATIVE_BTN);
	if(btnSel)
	{
		btnSel.SetToolTip( _L("You can apply settings to more than one axis by selection") );
	}
	///End SELECT_RELATIVE_NODES_TO_APPLY_SETTINGS_TO_MULTIP_AXES
	//---- CPY 10/04/2011 ORG-3732-s1 SPIDER_INDIVIDUAL_SCALE_SHOULD_BE_INSIDE_TREE
	/*
	/// RVD 9/21/2011 ORG-3732-s1 SPIDER_INDIVIDUAL_SCALE
	Button btnAutoscaleIndependently = GetItem(IDC_CHECK_AUTOSCALE_INDEPENDENTLY);
	btnAutoscaleIndependently.Visible = !bAllAxes;
	btnAutoscaleIndependently.Value = m_pSplitter->IsAutoscaleAxesIndependently();
	/// end SPIDER_INDIVIDUAL_SCALE
	*/
	//---- end SPIDER_INDIVIDUAL_SCALE_SHOULD_BE_INSIDE_TREE
	/// Iris 8/06/2012 ORG-6463-S1 ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
	m_btnShowPrimaryAxesOnly = GetItem(IDC_CHECK_SHOW_PRIMARY_ONLY);
	if( m_btnShowPrimaryAxesOnly )
	{
		m_btnShowPrimaryAxesOnly.Visible = m_pSplitter->HasShowPrimaryOnlyCheckbox();
		if( m_btnShowPrimaryAxesOnly.Visible )
		{			
			m_btnShowPrimaryAxesOnly.Check = m_pSplitter->IsShowPrimaryAxesOnly();			
		}
	}
	///End ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
	return true;
}

BOOL AxesDlg::OnReady()
{
	if( NULL == m_pSplitter )
		return false;
	
	/// Iris 6/04/2012 ORG-5528-S4 SET_3DGL_AXES_DLG_DEFAULT_LAYOUT
	//m_pSplitter->SetTreeEditPaneSize(60);
	m_pSplitter->SetTreeEditPaneSize(67);
	///End SET_3DGL_AXES_DLG_DEFAULT_LAYOUT

	SetInitReady(true);
	return true;
}

BOOL AxesDlg::OnDlgResize(int nType, int cx, int cy)
{	
	if(!IsInitReady())
		return true;
	
	MoveControlsHelper	_temp(this);
	int nGap = GetControlGap();
	
	RECT rrOK;
	Button btnOK = GetItem(IDOK);
	GetControlClientRect(IDOK, rrOK);
	int nButtonHeight = RECT_HEIGHT(rrOK);
	int nButtonWidth = RECT_WIDTH(rrOK);	
	
	RECT rSplitter, rForAllAxes;
	GetControlClientRect(IDC_CHECK_IS_FOR_ALL_AXES, rForAllAxes);
	rSplitter.left = nGap;
	rSplitter.top = rForAllAxes.bottom + nGap;
	rSplitter.right = cx - nGap;
	rSplitter.bottom = cy - 2 * nGap - nButtonHeight;
	
	Control ctrlSplitter = GetItem(IDC_AXES_TREE_CONTROL);
	MoveControl(ctrlSplitter, rSplitter);
	
	RECT rrApply, rrCancel;
	rrApply.right = cx - nGap;
	rrApply.left = rrApply.right - nButtonWidth;
	rrApply.bottom = cy - nGap;
	rrApply.top = rrApply.bottom - nButtonHeight;
	MoveControl(GetItem(IDC_APPLY), rrApply);
	
	rrCancel = rrApply;
	rrCancel.right = rrApply.left - nGap;
	rrCancel.left = rrCancel.right - nButtonWidth;
	MoveControl(GetItem(IDCANCEL), rrCancel);
	
	rrOK = rrApply;
	rrOK.right = rrCancel.left - nGap;
	rrOK.left = rrOK.right - nButtonWidth;
	MoveControl(GetItem(IDOK), rrOK);	
	
	///Jasmine 09/13/2011 ORG-3297 SELECT_RELATIVE_NODES_TO_APPLY_SETTINGS_TO_MULTIP_AXES
	RECT rrSel;
	GetControlClientRect(IDC_SEL_RELATIVE_BTN, rrSel);
	nButtonHeight 	= RECT_HEIGHT(rrSel);
	nButtonWidth	= RECT_WIDTH(rrSel);	
	
	rrSel.right 	= cx - nGap;	//rrSel.bottom = rForAllAxes.bottom;
	rrSel.left 		= rrSel.right - nButtonWidth;
	MoveControl(GetItem(IDC_SEL_RELATIVE_BTN), rrSel);	
	///End SELECT_RELATIVE_NODES_TO_APPLY_SETTINGS_TO_MULTIP_AXES	
	
	/// Iris 8/06/2012 ORG-6463-S1 ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX	
	if( m_btnShowPrimaryAxesOnly && m_btnShowPrimaryAxesOnly.Visible )
	{
		RECT rrShowPrimaryOnly;
		GetControlClientRect(IDC_CHECK_SHOW_PRIMARY_ONLY, rrShowPrimaryOnly);
		nButtonHeight 	= RECT_HEIGHT(rrShowPrimaryOnly);
		nButtonWidth	= RECT_WIDTH(rrShowPrimaryOnly);	
		
		rrShowPrimaryOnly.bottom		= rSplitter.top - nGap; 
		rrShowPrimaryOnly.top 			= rrShowPrimaryOnly.bottom - nButtonHeight;	
		rrShowPrimaryOnly.left 			= rSplitter.left;
		rrShowPrimaryOnly.right 		= rrShowPrimaryOnly.left + nButtonWidth;	
		MoveControl(m_btnShowPrimaryAxesOnly, rrShowPrimaryOnly);
	}
	///End ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
	return true;
}

/// Iris 6/04/2012 ORG-5528-S4 SET_3DGL_AXES_DLG_DEFAULT_LAYOUT
BOOL AxesDlg::OnRestoreSize(ODWP dwSizeInfo)
{
	void * p = (void*)dwSizeInfo;
	DLGSIZEINFO *pSz = (DLGSIZEINFO*)p;
	
	/// Iris 6/04/2012 ORG-5528-S4 SET_3DGL_AXES_DLG_DEFAULT_LAYOUT
	//lstrcpyn(pSz->szDialogName, STR_AXES_DLG_NAME, MAXLINE);
	lstrcpyn(pSz->szDialogName, m_pSplitter->GetDlgName(), MAXLINE);
	///End SET_3DGL_AXES_DLG_DEFAULT_LAYOUT	
	
	SIZE sz;
	GetDlgOptimalSize(sz);
	pSz->top = -1;
	pSz->left = -1;
	pSz->width = 600;//sz.cx, hard code, temp
	pSz->height = 480;//sz.cy
	return TRUE;	
}
///End SET_3DGL_AXES_DLG_DEFAULT_LAYOUT

BOOL AxesDlg::OnApplyForAllCheck(Control ctrl)
{
	Button btn = GetItem(IDC_CHECK_IS_FOR_ALL_AXES);
	
	if( m_pSplitter->IsEditTreeChanged() )
	{
		if( IDNO == MessageBox(GetSafeHwnd(), _L("Edit tree already be modified, do you want to continue without apply?"), _L("Attention"), MB_YESNO) )
		{
			btn.Check = !btn.Check; // change back
			return false;
		}
	}	
	
	m_pSplitter->SetIsControlForAllAxes(btn.Value);
	m_pSplitter->UpdateOnApplyForAllChanged();	
	//--- CPY 10/04/2011 ORG-3732-s1 SPIDER_INDIVIDUAL_SCALE_SHOULD_BE_INSIDE_TREE
	/*
	/// RVD 9/21/2011 ORG-3732-s1 SPIDER_INDIVIDUAL_SCALE	
	Button btnAutoscaleIndependently = GetItem(IDC_CHECK_AUTOSCALE_INDEPENDENTLY);
	btnAutoscaleIndependently.Visible = !btn.Value;
	/// end SPIDER_INDIVIDUAL_SCALE	
	*/
	//--- end SPIDER_INDIVIDUAL_SCALE_SHOULD_BE_INSIDE_TREE
	return true;	
}
//--- CPY 10/04/2011 ORG-3732-s1 SPIDER_INDIVIDUAL_SCALE_SHOULD_BE_INSIDE_TREE
/*
/// RVD 9/21/2011 ORG-3732-s1 SPIDER_INDIVIDUAL_SCALE	
BOOL AxesDlg::OnApplyAutoscaleIndependently(Control ctrl)
{
	Button btn = GetItem(IDC_CHECK_AUTOSCALE_INDEPENDENTLY);
	m_pSplitter->SetAutoscaleAxesIndependently(btn.Value);
	Button btnApply = GetItem(IDC_APPLY);
	if( !btnApply.Enable )
		btnApply.Enable = true;	
	return TRUE;
}
/// end SPIDER_INDIVIDUAL_SCALE	
*/
//--- end SPIDER_INDIVIDUAL_SCALE_SHOULD_BE_INSIDE_TREE

void AxesDlg::OnEditTreeChanged(DWORD wParam, DWORD lParam)
{
	/// Iris 8/14/2012 ORG-6463-P2 IMPROVE_SHOW_PRIMARY_AXES_ONLY
	/*
	Button btnApply = GetItem(IDC_APPLY);
	if( !btnApply.Enable )
		btnApply.Enable = true;	
	*/
	enableApplyButton();
	///End IMPROVE_SHOW_PRIMARY_AXES_ONLY
}

/// Iris 8/14/2012 ORG-6463-P2 IMPROVE_SHOW_PRIMARY_AXES_ONLY
void AxesDlg::enableApplyButton(bool bEnable) // = true
{
	Button btnApply = GetItem(IDC_APPLY);
	if( bEnable != btnApply.Enable )
		btnApply.Enable = bEnable;	
}
///End IMPROVE_SHOW_PRIMARY_AXES_ONLY

///Jasmine 09/13/2011 ORG-3297 SELECT_RELATIVE_NODES_TO_APPLY_SETTINGS_TO_MULTIP_AXES	
void AxesDlg::OnTreeViewSelectChanged(DWORD wParam, DWORD lParam)
{
	Control btn = GetItem(IDC_SEL_RELATIVE_BTN);
	if(btn)
		btn.Enable = m_pSplitter->IsSelectAxisSubNode();
}

BOOL AxesDlg::OnSelRelative(Control ctrl)
{
	if( m_pSplitter->IsSelectAxisSubNode() )
		m_pSplitter->SelectRelativeNodes();
		
	return TRUE;
}
///End SELECT_RELATIVE_NODES_TO_APPLY_SETTINGS_TO_MULTIP_AXES

/// Iris 8/06/2012 ORG-6463-S1 ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX
BOOL AxesDlg::OnShowPrimaryAxesOnlyCheck(Control ctrl)
{
	if( m_pSplitter->HasShowPrimaryOnlyCheckbox() ) // if checkbox is valid (visible)
	{
		/// Iris 8/14/2012 ORG-6463-P2 IMPROVE_SHOW_PRIMARY_AXES_ONLY
		m_pSplitter->SetEditTreeChange();
		///End IMPROVE_SHOW_PRIMARY_AXES_ONLY
		
		/// Iris 8/08/2012 ORG-6463-S3 ADD_AXIS_SHOW_PROPERTY_IN_AXIS_ROOT_BRANCH
		//m_pSplitter->SetShowPrimaryAxesOnly(m_btnShowPrimaryAxesOnly.Check, true, true);
		m_pSplitter->SetShowPrimaryAxesOnly(m_btnShowPrimaryAxesOnly.Check, SET_PRIMARY_ONLY_ON_BUTTON_EVENT);
		///End ADD_AXIS_SHOW_PROPERTY_IN_AXIS_ROOT_BRANCH
		
		/// Iris 8/14/2012 ORG-6463-P2 IMPROVE_SHOW_PRIMARY_AXES_ONLY
		enableApplyButton();
		///End IMPROVE_SHOW_PRIMARY_AXES_ONLY
	}
	return TRUE;
}
///End ADD_SHOW_PRIMARY_AXES_ONLY_CHECKBOX

BOOL AxesDlg::OnDestroy()
{
	if( NULL == m_pSplitter )
		return false;
	
	// save the current selected object ID to registry
	string strDlgName = m_pSplitter->GetDlgName();
	DWORD dw = m_pSplitter->GetRowID();
	/// Iris 6/04/2012 ORG-5528-S4 SET_3DGL_AXES_DLG_DEFAULT_LAYOUT
	//SaveSetting(STR_REG_SELECTED_OBJ_DATAID, dw, STR_AXES_DLG_NAME);
	SaveSetting(STR_REG_SELECTED_OBJ_DATAID, dw, strDlgName);
	///End SET_3DGL_AXES_DLG_DEFAULT_LAYOUT
	
	// // save the current select all status to registry
	Button btnApplyForAll = GetItem(IDC_CHECK_IS_FOR_ALL_AXES);
	/// Iris 5/21/2012 ORG-5528-S6 REMOVE_SAME_OPTIONS_FOR_ALL_BUTTON_FOR_2D_AND_3DGL_GRAPH
	if( btnApplyForAll.Visible )
	///End REMOVE_SAME_OPTIONS_FOR_ALL_BUTTON_FOR_2D_AND_3DGL_GRAPH
	{
		dw = btnApplyForAll.Value;
		/// Iris 6/04/2012 ORG-5528-S4 SET_3DGL_AXES_DLG_DEFAULT_LAYOUT
		//SaveSetting(STR_REG_IS_USE_SAME_OPTIONS_FOR_ALL_AXES, dw, STR_AXES_DLG_NAME);
		SaveSetting(STR_REG_IS_USE_SAME_OPTIONS_FOR_ALL_AXES, dw, strDlgName);
		///End SET_3DGL_AXES_DLG_DEFAULT_LAYOUT
	}
	
	/// Iris 6/07/2012 ORG-5528-P10 SAVE_SAME_OPTIONS_FOR_BOTH_DIRECTIONS_TO_REGISTRY
	// save the value of "Use same options for Bottom and Top" to registry
	/// Iris 7/19/2012 ORG-5991-P13 SAVE_SAME_OPTIONS_TO_GRAPH_NOT_REGISTRY
	//string strSameSettings = m_pSplitter->CheckGetIsUseSameOptionsForBothDirectionsSettings();
	//if( !strSameSettings.IsEmpty() )
	//	SaveSetting(STR_REG_IS_USE_SAME_OPTIONS_FOR_BOTH_DIRECTIONS_3DGL, strSameSettings, strDlgName);
	m_pSplitter->SaveSettingsBeforeDialogClose();
	///End SAVE_SAME_OPTIONS_TO_GRAPH_NOT_REGISTRY
	///End SAVE_SAME_OPTIONS_FOR_BOTH_DIRECTIONS_TO_REGISTRY
	
	return true;
}

BOOL AxesDlg::OnApply(Control ctrl)
{	
	if( m_pSplitter->Apply(true) )
	{
		/// Iris 8/14/2012 ORG-6463-P2 IMPROVE_SHOW_PRIMARY_AXES_ONLY
		//GetItem(IDC_APPLY).Enable = false;
		enableApplyButton(false);
		///End IMPROVE_SHOW_PRIMARY_AXES_ONLY
		return true;
	}
	return false;
}

BOOL AxesDlg::OnOK()
{
	bool bRet = m_pSplitter->Apply(false);
	return TRUE;
}

AxesControlSplitter*	AxesDlg::getSplitterPointer()
{
	if( m_pSplitter != NULL )
		return m_pSplitter;
		
	switch(m_nLayerType)
	{
	case OKAXISDLGLAYERTYPE_SPIDER:
		m_pSplitter = new SpiderPlotAxesControlSplitter;
		break;
		
	case OKAXISDLGLAYERTYPE_GENERAL:		
		m_pSplitter = new GeneralPlotAxesControlSplitter;
		break;
		
	case OKAXISDLGLAYERTYPE_3DGL:		
		m_pSplitter = new GL3DPlotAxesControlSplitter;
		break;
	}
	
	ASSERT(NULL != m_pSplitter);
	return m_pSplitter;
}

///------ Folger 09/19/2012 QA-1291-P2 NEW_AXES_DLG_SHOULD_OPEN_CORRECT_HELP
BOOL AxesDlg::OnHelp(int &nHelpID, int nIdCtrlFocus)
{
	switch ( m_nLayerType )
	{
	case OKAXISDLGLAYERTYPE_SPIDER:
		nHelpID = IDD_AXES_DLG;
		break;

	case OKAXISDLGLAYERTYPE_3DGL:
		nHelpID = IDD_AXES_DLG_3DGL;
		break;

	case OKAXISDLGLAYERTYPE_GENERAL:		
	default:
		ASSERT(FALSE);
		return FALSE;
	}

	return TRUE;
}
///------ End NEW_AXES_DLG_SHOULD_OPEN_CORRECT_HELP

///------ Folger 06/07/2012 ORG-5930-P2 OPEN_AXIS_DIALOG_WHEN_SELECT_FROM_FORMAT_AXIS_TITLE
//void openAxesDlg(int nAxisIndex = 0, int nObjectType = -1, int nLayerType = OKAXISDLGLAYERTYPE_SPIDER)
/// Iris 9/13/2012 ORG-6821 FIX_DBCLICK_ON_AXES_TO_OPEN_AXES_DLG_GO_TO_INCORRECT_AXIS_BRANCH
//void openAxesDlg(int nAxisIndex = 0, int nObjectType = -1, int nLayerType = OKAXISDLGLAYERTYPE_SPIDER, DWORD dwCntrl = 0)
void openAxesDlg(int nDim, int nAxisIndex = 0, int nObjectType = -1, int nLayerType = OKAXISDLGLAYERTYPE_SPIDER, DWORD dwCntrl = 0)
///End FIX_DBCLICK_ON_AXES_TO_OPEN_AXES_DLG_GO_TO_INCORRECT_AXIS_BRANCH
///------ End OPEN_AXIS_DIALOG_WHEN_SELECT_FROM_FORMAT_AXIS_TITLE
{	
	/// Iris 4/27/2012 ORG-5528-S1 AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
	//AxesDlg mydlg(nAxisIndex, nObjectType);
	/// Iris 6/08/2012 ORG-5930-P2 OPEN_AXIS_DIALOG_WHEN_SELECT_FROM_FORMAT_AXIS_TITLE
	//AxesDlg mydlg(nAxisIndex, nObjectType, nLayerType);
	/// Iris 9/13/2012 ORG-6821 FIX_DBCLICK_ON_AXES_TO_OPEN_AXES_DLG_GO_TO_INCORRECT_AXIS_BRANCH
	//AxesDlg mydlg(nAxisIndex, nObjectType, nLayerType, dwCntrl);
	AxesDlg mydlg(nDim, nAxisIndex, nObjectType, nLayerType, dwCntrl);
	///End FIX_DBCLICK_ON_AXES_TO_OPEN_AXES_DLG_GO_TO_INCORRECT_AXIS_BRANCH
	///End OPEN_AXIS_DIALOG_WHEN_SELECT_FROM_FORMAT_AXIS_TITLE
	///End AXESDLG_NEED_TO_SUPPORT_2D_3D_GRAPH
	mydlg.DoModalEx();
}
