/*------------------------------------------------------------------------------*
 * File Name:ANOVATwoWayRM.h													*
 * Creation:  																	*
 * Purpose:Two Way ANOVA Repeated Measure operation							 	*
 * Copyright (c) Originlab Corp. 2006											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Echo 2/25/07 ADD_ERROR_REPORT												*
 *	Arvin 10/17/07 CLEAN_ANOVA_TOOLS_CODE										*
 *	ML 4/27/2012 PREVENT_MULTIPLE_INCLUSION_O8dlg_h								*
 *	Folger 05/29/2012 ORG-5592-S1 SHOW_DATA_IDENTIFIER_FOR_FLAT_SHEET			*
 *	Folger 06/06/2012 ORG-5906-P1 NORMALITY_TEST_TOO_SLOW_FOR_LARGE_DATA		*
 *------------------------------------------------------------------------------*/
/// ML 4/27/2012 PREVENT_MULTIPLE_INCLUSION_O8dlg_h
// #include <o8dlg.h>
/// end PREVENT_MULTIPLE_INCLUSION_O8dlg_h
#ifndef _ANOVATWOWAY_RM_H
#define	_ANOVATWOWAY_RM_H
class OC_REGISTERED ANOVATwoWayRM : public ANOVARMReportOperation
{
///Echo 2/25/07 ADD_ERROR_REPORT
public:
	PEVENT_GETN GetNewEventFunction();
///end ADD_ERROR_REPORT
	
	///Arvin 06/29/07 v8.652 XOP_NEED_SUPPORT_NLFIT
	///Arvin 10/17/07 CLEAN_ANOVA_TOOLS_CODE
	/*
	int OnInitOperationTreeFromOCLT(TreeNode &trOp, TreeNode& trOCLT,  bool bInitTree = true)
	{
		int nRet;
		TreeNode trOutGUI = trOCLT.GetNode("GUI");
		TreeNode trInputData = trOutGUI.InputData;
		if(!trInputData)
			return OP_INVALID_INPUT_DATA_NODE;
			
		if(ANOVA_INDEXED_DATA == trInputData.Use)
		{
			nRet = okutil_anova_switch_to_indexed_data(&trInputData, true, true);			
		}
		else
		{
			 nRet = okutil_anova_switch_to_raw_data(&trInputData, true, true);
		}
		
		return nRet;
	}
	*/
	///end CLEAN_ANOVA_TOOLS_CODE
	///END XOP_NEED_SUPPORT_NLFIT
	///Arvin 09/26/07 QA70-10421 WRONG_REPEAT_FACTOR_IN_REPORT_TABLE
	bool	GetFactors(TreeNode &trOp, int index = 0, const vector<string> &vstrFactors = NULL);
	///END WRONG_REPEAT_FACTOR_IN_REPORT_TABLE
protected:
	virtual bool	IsRM()		{return true;}	
	virtual bool	IsOneWay()	{return false;}	
	virtual void 	UpdateReportingTables(TreeNode &trOperation, int nTotalNumData, int nExeMode);
	virtual void 	ConstructOutputTable(TreeNode& trOperation);
	bool	CalcOneData(TreeNode &trOp, int nSizeSubject, int nSizeFactor, int& nSizeFactor2 = NULL);
	int     ExtractIndexedData(TreeNode &trOp, DataRange& dr, matrix& mData, int& nSizeSubject, int& nSizeFactor, int& nSizeFactor2);
	int     ExtractRawData(TreeNode &trOp, DataRange& dr, matrix& mData, int& nSizeSubject, int& nSizeFactor, int& nSizeFactor2 = NULL);
	string 	GetClassName();
	
	///Cheney 2007-9-28 MODIFY_TITLE_AS_MAX_SAID
	//virtual
	string	GetDlgDescription(int nOption);
	///end MODIFY_TITLE_AS_MAX_SAID
	///Cheney 2007-10-25 ANOVA_TOOLS_HANDLE_AUTO_WRONG
	//virtual
	bool GetAnovaToolsOption(bool bRow, int& nOption);
	///end ANOVA_TOOLS_HANDLE_AUTO_WRONG
	
	//virtual
	// fisher 11/16/2007 ADD_MAP_ID_TO_CHM
	int GetHelpID()	{return IDD_XF_AnovaTwoWayRM;}
	//virtual
	string 	GetResultBookName(TreeNode& trGUI);

	///------ Folger 05/29/2012 ORG-5592-S1 SHOW_DATA_IDENTIFIER_FOR_FLAT_SHEET
	virtual DWORD GetOutputOptions(const TreeNode& trOp);
	///------ End SHOW_DATA_IDENTIFIER_FOR_FLAT_SHEET

	///------ Folger 06/06/2012 ORG-5906-P1 NORMALITY_TEST_TOO_SLOW_FOR_LARGE_DATA
	virtual void GetCalcMoment(TreeNode& trOp, DescStatOptions& opMoments);
	///------ End NORMALITY_TEST_TOO_SLOW_FOR_LARGE_DATA

private:
	bool    getData(TreeNode &trOp, matrix &matData, vector<int> &vData, vector<int> &vNonRVData);

	
private:
	vector<int>		m_vNonRVData;
	int				m_nRV; //the repeated format
	int				m_nGroupSize; 
};
#endif //_ANOVATWOWAYRM_H
