 /*-----------------------------------------------------------------------------*
 * File Name: xfutils.h				 											*
 * Creation: Yuri																*
 * Purpose: declarations of VC (OKXF) implemented OC functions					*
 * Copyright (c) Originlab Corp.	2006										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	CPY 7/6/06 QA70-8088 CENTRALIZED_ERR_MSG_DLL								*
 *	ML 7/17/2006 GETTING_INPUT_DATA_DESCRIPTION_FROM_WITHIN_XFUNCTION_EXECUTION	*
 *	Sim 08-22-2006 WARNING_MESSAGE_OUTPUT										*
 *	ML 8/29/2006 EXTRACTING_WEIGHTING_INFO_OUT_OF_FITTER_INPUT					*
 *	ML 12/7/2006 ADDING_INPUT_TABLE_FROM_WITHIN_XF								*
 *	Jasmine 02/03/07 ENABLE_CUSTOM_BUTTONS_SEPARATELY							*
 *	CPY 4/4/2007 CHANGE_PARAMETER_SHOULD_NOT_SUPPORT_THEME_AND_AUTOUPDATE_MODE	*
 *	Jasmine 04/13/07 PRINT_XF_MSG_TO_SCRIPT_WINDOW								*
 *	Jasmine QA70-9623 REPLACE_BY_OKOC_OUT_MSG									*
 *	CPY 5/8/2007 QA70-9566 OUTPUT_TO_RESULTS_LOG_CHECKBOX_IN_GETN				*
 *	Sim 07-12-2007 EXTEND_UPDATE_GRAPH_CONTROL_VALUE							*
 *	Sim 07-27-2007 IMPLEMENT_APPLY_AND_UNDO_MECHANISM							*
 *	ML 1/9/2008 QA70-10917 MAKE_XFVERSION_USED_WHEN_XFOP_WAS_RUN_LAST_TIME_AVAILABLE_TO_ORIGINC
 *	Hong 10/29/08 QA80-11005 ALLOW_ACCESS_DWORD_FOR_ADVANCE_PROGRAMMING			*
 *	CPY 07/26/08 QA70-11868 CHANGE_BACK_TO_USE_CRLF_TO_SEP_LN_COMMENT			*
 *	YuI 10/31/08 QA70-12503 EXPAND_D_OPTION_STRING_TO_SUPPORT_ARBITRARY_NAMES	*
 *	YuI 04/09/09 QA70-13435 OPTION_TO_SUPPRESS_LT_ERROR_FOR_XF_INVOCATION		*
 *	Folger 04/14/09 QA80-12786-P3 PREVIEW_GETN_FAILS_TO_SHOW_DATA_TIME_FORMAT_AFTER_CHANGED
 *	Folger 08/12/09 QA80-14112 NEED_OPTION_STRING_TO_HIDE_XF_VARIABLE_FROM_LT	*
 *	Sim 08-20-2009 QA81-14175 SUPPORT_GET_GETN_TREE_ON_XF_BODY					*
 *	Folger 09/02/09 SUPPORT_GETTING_AUTO_UPDATE_INFO_FROM_XF_BODY				*
 *	Folger 12/29/09 QA81-14832 SET_GET_QUICK_FIT_SOURCE_PLOT_UID				*
 *	Folger 03/01/10 QA81-15106-P3 OP_CHANGE_SUPPORT_CHANGE_INPUT_DATA			*
 *	Folger 06/25/10 ORG-122-P9 SUPPORT_ALWAYS_GENERATE_XF_LT_SCRIPT				*
 *	Folger 09/21/2010 ORG-1121-S1 SUPPORT_GET_VAR_NEW_CREATED_INFO_IN_XF_BODY	*
 *	Sim 2011-2-24 ORG-2294-S2 SUPPORT_LOG_XY									*
 *	Folger 08/24/2011 ORG-3609-P1 RECALCULATE_FAILED_TO_TRIGGERED_IF_INPUT_CHNAGED_BY_XF_OUTPUT_AS_INPUT
 *	Kyle 09/05/2011 ORG-3676-P1 XF_OUTPUT_ALLOW_SUB_OPERATION					*
 *	Folger 12/01/2011 ORG-4492-P1 SOURCE_SHEET_IS_ACTIVATED_AFTER_CHANGE_PARAM_FROM_ONE_WAY_ANOVA
 *	Sim 2011-11-29 ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT						*
 *------------------------------------------------------------------------------*/

#ifndef _XFUTILS_H
#define _XFUTILS_H

#ifdef __AFX_H__
	#ifdef OKXF_DLL
		#define OKXF_API __declspec(dllexport)
	#else
		#define OKXF_API __declspec(dllimport)
	#endif

	#define XYRange		CScriptMocaObject
	#define DataRange	CScriptMocaObject
	#define	vectorbase	CScriptMocaObject
	/// YuI 07/13/06 RESOLUTION_OF_ORIGIN_OBJECT_IN_XF_EVENT
	#define	OriginObject	CScriptMocaObject
	/// end RESOLUTION_OF_ORIGIN_OBJECT_IN_XF_EVENT
	///------ Folger 12/29/09 QA81-14832 SET_GET_QUICK_FIT_SOURCE_PLOT_UID
	#define GraphLayer		CScriptMocaObject
	///------ End SET_GET_QUICK_FIT_SOURCE_PLOT_UID
	//--------- CPY 5/17/07 QA70-9794 XF_SEPARATE_INTO_TWO_CLASSES_AND_CACHE
	//class OCXFunction;
	//#define XFBase	OCXFunction
	class OCXF
	#define XFBase OCXF
	//---------
#else
//------ CPY 7/6/06 QA70-8088 CENTRALIZED_ERR_MSG_DLL
	#include <ocu.h>
//------
	#define	STR_DLG_OPTIONS_ATTRIB "DlgOptions"  //--- Iris 10/26/06 CORRECT_NEW_SAVE_AS_DLG_LOGIC
	#define OKXF_API
#endif//__AFX_H__

#define XFERR_NPARAM_UNUSED 123456789	//CPY 7/6/06 QA70-8088 CENTRALIZED_ERR_MSG_DLL

#ifndef __AFX_H__
int xf_throw_exception(int nLineNumber, int nCode);
int xf_throw_exception(int nLineNumber, LPCSTR lpcszMessage);
int xf_throw_exception_ex(int nLineNumber, LPCSTR lpcszMessage, int nAuxCode);
///---Sim 11-15-2006 SUPPORT_MORE_ERROR_HANDLING
int xf_throw_exception_ex(int nLineNumber, LPCSTR lpcszMessage, LPCSTR lpcszParam);
///---END SUPPORT_MORE_ERROR_HANDLING
//---- CPY 7/6/06 QA70-8088 CENTRALIZED_ERR_MSG_DLL
int xf_throw_exception_ex(int nLineNumber, int nCode, int nParam);
int xf_throw_exception_ex(int nLineNumber, int nCode, LPCSTR lpcszParam);
int xf_throw_exception_ex(int nLineNumber, int nErrCode, LPCSTR lpcszParam, int nParam);
int xf_throw_exception_ex(int nLineNumber, int nErrCode, int nParam, LPCSTR lpcszParam);
///Arvin 04/04/07 v8.0596 SUPPORT_THROW_TWO_DOUBLE_VALUE
int xf_throw_exception_ex(int nLineNumber, int nErrCode, int nParam1, int nParam2);
///EMD SUPPORT_THROW_TWO_DOUBLE_VALUE
///---Sim 2011-2-24 ORG-2294-S2 SUPPORT_LOG_XY
int xf_throw_exception_ex(int nLineNumber, int nErrCode, LPCSTR lpcszParam1, LPCSTR lpcszParam2);
///---END ORG-2294-S2 SUPPORT_LOG_XY
///---Sim 08-22-2006 WARNING_MESSAGE_OUTPUT
void xf_warning_exception(LPCSTR lpcszMessage);
void xf_warning_exception_ex(LPCSTR lpcszMessage, int nParam);
void xf_warning_exception_ex(LPCSTR lpcszMessage, LPCSTR lpcszParam);
void xf_warning_exception(int nErrCode);
void xf_warning_exception_ex(int nErrCode, int nParam);
void xf_warning_exception_ex(int nErrCode, LPCSTR lpcszParam);
void xf_warning_exception_ex(int nErrCode, LPCSTR lpcszParam, int nParam);
void xf_warning_exception_ex(int nErrCode, int nParam, LPCSTR lpcszParam);
///---END WARNING_MESSAGE_OUTPUT

///Sophy Folger 9/20/2012 ORG-6029-P1 NORMALIZE_COLUMN_FAILED_FOR_WHOLE_SHEET_SELECTION
void xf_check_update_input_range(TreeNode& trRange);
///end NORMALIZE_COLUMN_FAILED_FOR_WHOLE_SHEET_SELECTION
/// YuI 04/09/09 QA70-13435 OPTION_TO_SUPPRESS_LT_ERROR_FOR_XF_INVOCATION
int		xf_get_last_error_code();
string	xf_get_last_error_message();
/// end OPTION_TO_SUPPRESS_LT_ERROR_FOR_XF_INVOCATION

//----
//void xf_print_msg(LPCSTR lpcstr, bool bRestrict = true, int nDestination = WRITE_SCRIPT_WINDOW);	///Jasmine 04/13/07 PRINT_XF_MSG_TO_SCRIPT_WINDOW	///Jasmine QA70-9623 REPLACE_BY_OKOC_OUT_MSG
///---Sim 11-15-2006 WARNING_MESSAGE_OUTPUT

/// YuI 11/22/06 need to change exception to throw error code
//#define	XF_THROW(_ERRCODE)					{xf_throw_exception(__LINE__, _ERRCODE); throw(XFERR_RUNTIME_EXCEPTION)}
//#define	XF_THROW_EX(_ERRCODE, _AUXCODE)	{xf_throw_exception_ex(__LINE__, _ERRCODE, _AUXCODE); throw(XFERR_RUNTIME_EXCEPTION)}
//#define	XF_THROW_EX2(_ERRCODE, _AUX1, _AUX2)	{xf_throw_exception_ex(__LINE__, _ERRCODE, _AUX1, _AUX2); throw(XFERR_RUNTIME_EXCEPTION)}
#define	XF_THROW(_ERRCODE)						{throw(xf_throw_exception(__LINE__, _ERRCODE));}
#define	XF_THROW_EX(_ERRCODE, _AUXCODE)			{throw(xf_throw_exception_ex(__LINE__, _ERRCODE, _AUXCODE));}
#define	XF_THROW_EX2(_ERRCODE, _AUX1, _AUX2)	{throw(xf_throw_exception_ex(__LINE__, _ERRCODE, _AUX1, _AUX2));}
/// end YuI 11/22/06

///---END WARNING_MESSAGE_OUTPUT
///---Sim 08-22-2006 WARNING_MESSAGE_OUTPUT
#define	XF_WARN(_ERRCODE)					{xf_warning_exception(_ERRCODE);}
#define	XF_WARN_EX(_ERRCODE, _AUXCODE)		{xf_warning_exception_ex(_ERRCODE, _AUXCODE);}
#define	XF_WARN_EX2(_ERRCODE, _AUX1, _AUX2)	{xf_warning_exception_ex(_ERRCODE, _AUX1, _AUX2);}
///---END WARNING_MESSAGE_OUTPUT
#define	XF_TRACE	okxf_notification_message
#define xf_error_out XF_THROW//---- CPY 5/4/2006 MOVE_XF_ERR_TO_THROW_MACRO

#endif //__AFX_H__

//////////////////////////////////////////////
/// exported function prototypes here
//////////////////////////////////////////////
#ifdef __AFX_H__
	extern "C" {
#else

	/// ML 7/17/2006 GETTING_INPUT_DATA_DESCRIPTION_FROM_WITHIN_XFUNCTION_EXECUTION
	///////////
	// Comments last updated by Iris on 03/12/2007
	/**$
	*/
	class XFExeContext
	{
	public:
		int			GetCountGraphs();
		GraphPage	GetGraph(int index);
		GraphPage	RemoveGraph(int index);
	
		/**$
		Parameters:
			gpg=the graph to set
			index=the index to set to. If negative, it will append.
		Returns:
			the count after appending.
		*/
		int			SetGraph(GraphPage &gpg, int index = -1);
		
		bool		IsAddPlots();
		void		SetAddPlots(bool bSet);
		
		BOOL		GetArgDescription(string &strDesc, LPCSTR lpcszArgName);

		/// ML 12/7/2006 ADDING_INPUT_TABLE_FROM_WITHIN_XF
		/**$
			Adds entires for the input table based on the argument name.
		Parameters:
			tr=If bCreateTable, the parent of the table to be created, otherwise the table itself (the function will only
					add entries to it).
			lpcszArgName=the xfunction argument name.
			lpcszTableTitle=[optional]it sets the title of the table if bCreateTable. If not supplied, then
							the variable name is used for the title. Not used if !bCreateTable.
			trTbl=[output]If bCreateTable, it receive the created table, otherwise the same as the argument tr.
			bCreateTable=if TRUE, the table will be created (tr will be used as its parent). Otherwise tr will be assumed to
						be the table and only entries will be added to it.
		Returns:
			TRUE if success, othewise FALSE.
		*/
		BOOL		AddInputToTree(TreeNode &tr, LPCTSTR lpcszArgName, LPCTSTR lpcszTableTitle = NULL, TreeNode &trTbl = NULL, BOOL bCreateTable = TRUE);
		/// end ADDING_INPUT_TABLE_FROM_WITHIN_XF

		/// ML 1/9/2008 QA70-10917 MAKE_XFVERSION_USED_WHEN_XFOP_WAS_RUN_LAST_TIME_AVAILABLE_TO_ORIGINC
		/**$
			Gets the xfunction version used when the analysis operation was last time run. Its value is equal to the deafult value DEFAULT_XFVERSION_LAST_TIME_RUN
			when the analysis is run for the first time.
		*/
		double		GetXFVersionLastTime();
		/// end MAKE_XFVERSION_USED_WHEN_XFOP_WAS_RUN_LAST_TIME_AVAILABLE_TO_ORIGINC

		///---Sim 08-20-2009 QA81-14175 SUPPORT_GET_GETN_TREE_ON_XF_BODY
		/**$
			refer to XFBase::GetGUI()
		*/
		BOOL GetGUI(Tree& trRoot, TreeNode& trGetN, int nAddRecalculate = XFGETN_EX_FOLLOW_XF, int nAddResultsLogOutput = XFGETN_EX_FOLLOW_XF, DWORD dwCntrl = 0);
		///---END QA81-14175 SUPPORT_GET_GETN_TREE_ON_XF_BODY

		///------ Folger 09/02/09 SUPPORT_GETTING_AUTO_UPDATE_INFO_FROM_XF_BODY
		BOOL	IsEvaluateFromAutoUpdate();
		///------ End SUPPORT_GETTING_AUTO_UPDATE_INFO_FROM_XF_BODY

		///------ Folger 09/21/2010 ORG-1121-S1 SUPPORT_GET_VAR_NEW_CREATED_INFO_IN_XF_BODY
		BOOL	IsOrgObjNewCreated(LPCSTR lpcszName);
		///------ End SUPPORT_GET_VAR_NEW_CREATED_INFO_IN_XF_BODY
		
		///Kyle 09/05/2011 ORG-3676-P1 XF_OUTPUT_ALLOW_SUB_OPERATION
		BOOL	SetOutputSubOperation(LPCSTR lpcszOutputs);
		///End XF_OUTPUT_ALLOW_SUB_OPERATION
	};
	
	// Comments last updated by Iris on 03/12/2007
	/**$
	*/
	class XFPushPopGetNTree
	{
	public:
		XFPushPopGetNTree(TreeNode &trGetN);
		~XFPushPopGetNTree();
	};
	/// end GETTING_INPUT_DATA_DESCRIPTION_FROM_WITHIN_XFUNCTION_EXECUTION
	
	#pragma dll(okxf.dll)
#endif

#ifdef _COMPILEDBASE_H_ //__AFX_H__	 CPY 3/22/07 replace __AFX_H__ with _COMPILEDBASE_H_ after seeing compile err with ac_utils
/// TD 6-2-06 QA70-8708 CALLING_BEFORE_EXECUTE_EVENT
CLTFunction *okxf_get_simple_event(TreeNode* trXF, int nEvent, BOOL bInternal = FALSE);
CLTFunction *okxf_get_event(TreeNode* trXF, int nEvent, BOOL bInternal = FALSE);
/// end CALLING_BEFORE_EXECUTE_EVENT
#endif // _COMPILEDBASE_H_

/// ML 8/29/2006 EXTRACTING_WEIGHTING_INFO_OUT_OF_FITTER_INPUT
//OKXF_API BOOL okxf_resolve_composite_range_tree(TreeNode* trDest, TreeNode* trSource);
///---Sim 2011-11-29 ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
//OKXF_API BOOL okxf_resolve_composite_range_tree(TreeNode* trDest, TreeNode* trSource, IntArray *vnWeightMethods = NULL, DoubleArray *pvAs = NULL, DoubleArray *pvBs = NULL, DoubleArray *pvCs = NULL);
OKXF_API BOOL okxf_resolve_composite_range_tree(TreeNode* trDest, TreeNode* trSource);
OKXF_API BOOL okxf_get_weight_dependent(TreeNode* trInput, IntArray *pvnWeightMethods = NULL, DoubleArray *pvAs = NULL, DoubleArray *pvBs = NULL, DoubleArray *pvCs = NULL);
OKXF_API BOOL okxf_get_weight_independent(TreeNode* trInput, IntArray *pvnWeightMethods = NULL, DoubleArray *pvAs = NULL, DoubleArray *pvBs = NULL, DoubleArray *pvCs = NULL);
///---END ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
/// end EXTRACTING_WEIGHTING_INFO_OUT_OF_FITTER_INPUT
OKXF_API BOOL okxf_is_variable_input(TreeNode* trVar, bool bExcludeOutput);
OKXF_API BOOL okxf_is_variable_output(TreeNode* trVar, bool bExcludeInput);
OKXF_API int  okxf_get_variable_type(TreeNode* trVar);
//----- CPY 7/12/06 QA70-8731 AUTO_UPDATE_LOST_FROM_GUI
//OKXF_API BOOL okxf_open_XF_getn_dialog(TreeNode* trXF, XFBase *pxf, BOOL bExecute, BOOL bCheckUseAutoUpdate, BOOL bUpdateLastUsed);
/// YuI 07/24/06 QA70-8847 COLUMN_FORMULA_FROM_ORIGIN_C_REVAMP
// moved to OC_const.h
/*
enum {
	AU_ON_COMMAND,
	AU_AUTO,
	AU_NONE, // no operation will be created as a result
};
*/
/// end COLUMN_FORMULA_FROM_ORIGIN_C_REVAMP
//----- end

///---Sim 08-20-2009 QA81-14175 SUPPORT_GET_GETN_TREE_ON_XF_BODY
// moved to OC_const.h
/*
//----- CPY 5/8/2007 QA70-9566 OUTPUT_TO_RESULTS_LOG_CHECKBOX_IN_GETN
enum {
	XFGETN_EX_FOLLOW_XF = -2,
	XFGETN_EX_NONE = -1,
	XFGETN_EX_UNCHECK = 0,
	XFGETN_EX_CHECK,
};
//----
*/
///---END QA81-14175 SUPPORT_GET_GETN_TREE_ON_XF_BODY

// these functions are capable of resolving runtime information
// so that range string may have <active> or omitted parts
OKXF_API BOOL okxf_resolve_tree_construct_range(TreeNode* pTr, DataRange* pDr);
OKXF_API BOOL okxf_resolve_tree_get_data_into_vector(TreeNode* pTr, vectorbase* pV, vectorbase* pVx = NULL);
OKXF_API BOOL okxf_init_range_from_string(DataRange* dr, LPCSTR lpcsz);
///

/// YuI 07/13/06 RESOLUTION_OF_ORIGIN_OBJECT_IN_XF_EVENT
OKXF_API BOOL okxf_resolve_string_get_origin_object(LPCSTR lpcsz, OriginObject* pObj);
/// end RESOLUTION_OF_ORIGIN_OBJECT_IN_XF_EVENT

OKXF_API BOOL okxf_get_help_node(TreeNode* trHelp, TreeNode* trXF, int nNodeID = IDV_HELP_SUMMARY, int nLanguage = IDRS_HELP_E);
//---- CPY 7/6/06 QA70-8088 CENTRALIZED_ERR_MSG_DLL, added nParam and lpcszParam
//OKXF_API BOOL okxf_add_predefined_exception_to_error_log(int nCode, int nParam, LPCSTR lpcszParam, int nLineNumber);
//OKXF_API BOOL okxf_add_runtime_exception_to_error_log(LPCSTR lpcszMessage, int nLineNumber);
//OKXF_API BOOL okxf_add_runtime_exception_to_error_log_ex(LPCSTR lpcszMessage, int nAuxCode, int nLineNumber);
OKXF_API BOOL okxf_add_runtime_exception_to_error_log(int nCode, LPCSTR lpcszMessage, int nParam, LPCSTR lpcszParam, int nLineNumber);
//----
OKXF_API void okxf_notification_message(LPCSTR lpcszMessage, ...);


/// ML 7/17/2006 GETTING_INPUT_DATA_DESCRIPTION_FROM_WITHIN_XFUNCTION_EXECUTION
OKXF_API	int	okxf_push_getntree(TreeNode *ptrGetN);
OKXF_API	int	okxf_pop_getntree();
/// end GETTING_INPUT_DATA_DESCRIPTION_FROM_WITHIN_XFUNCTION_EXECUTION

/// YuI 08/18/06 RANGE_TO_TREE_UPDATE_FOR_OPERATIONS
/// YuI 10/31/08 QA70-12503 EXPAND_D_OPTION_STRING_TO_SUPPORT_ARBITRARY_NAMES
//	OKXF_API	BOOL	okxf_update_tree_from_ranges(TreeNode* pTr, int nInputUID, IntArray* vOutputs);
OKXF_API	BOOL	okxf_update_tree_from_ranges(TreeNode* pTr, int nInputUID, IntArray* vOutputs, BOOL bKeepRangeNames = FALSE);
/// end EXPAND_D_OPTION_STRING_TO_SUPPORT_ARBITRARY_NAMES
/// end RANGE_TO_TREE_UPDATE_FOR_OPERATIONS

///------ Folger 03/01/10 QA81-15106-P3 OP_CHANGE_SUPPORT_CHANGE_INPUT_DATA
OKXF_API	BOOL	okxf_init_input_ranges_from_tree(DataRange* pDr, TreeNode* pTr);
///------ End OP_CHANGE_SUPPORT_CHANGE_INPUT_DATA

OKXF_API void okxf_on_xf_file_save(LPCSTR lpcszXFName); //----CPY 5/17/07 QA70-9794 XF_SEPARATE_INTO_TWO_CLASSES_AND_CACHE

///Joseph 03/20/2007 MOVE_CODES_FROM_OC_TO_WITHOUT_ANY_CHANGING

#define CMDKEY_OPEN_AUTO_COMPLETE ((UINT)-1)
OKXF_API void okxf_ac_init();

OKXF_API bool okxf_ac_get_helpinfo(LPCSTR strCmd, int nIconID, LPCSTR lpcszSrc, string * strDisplay);

OKXF_API bool okxf_ac_done_replacesel(UINT nCharCmd);

OKXF_API int okxf_ac_on_key(LPCSTR strCmd, UINT nCharCmd, bool*  bAutoCompleteBackSpace,int nCurrent,int nPromptPosition, int* nAutoCompleteStart, StringArray* saNames, IntArray* viAttributes, bool* bVariableListShow);
///End MOVE_CODES_FROM_OC_TO_WITHOUT_ANY_CHANGING

OKXF_API	BOOL	okxf_is_xf_variable_LT_accessible(TreeNode* ptrVar);		///------ Folger 08/12/09 QA80-14112 NEED_OPTION_STRING_TO_HIDE_XF_VARIABLE_FROM_LT

///------ Folger 06/25/10 ORG-122-P9 SUPPORT_ALWAYS_GENERATE_XF_LT_SCRIPT
OKXF_API	BOOL	okxf_is_xf_var_always_generate_LT_script(TreeNode* ptrVar);
///------ End SUPPORT_ALWAYS_GENERATE_XF_LT_SCRIPT

///------ Folger 12/29/09 QA81-14832 SET_GET_QUICK_FIT_SOURCE_PLOT_UID
OKXF_API	int		okxf_quick_fit_source_plot_uid_access(GraphLayer* gl, int nUID = 0, BOOL bGet = TRUE);
///------ End SET_GET_QUICK_FIT_SOURCE_PLOT_UID

///------ Folger 08/24/2011 ORG-3609-P1 RECALCULATE_FAILED_TO_TRIGGERED_IF_INPUT_CHNAGED_BY_XF_OUTPUT_AS_INPUT
OKXF_API	BOOL	okxf_clear_autoupdate_dirtiness(DataRange* pDr);
///------ End RECALCULATE_FAILED_TO_TRIGGERED_IF_INPUT_CHNAGED_BY_XF_OUTPUT_AS_INPUT


#ifdef __AFX_H__
	}
#endif	//__AFX_H__


///Jasmine 02/03/07 ENABLE_CUSTOM_BUTTONS_SEPARATELY
#ifndef __AFX_H__

#pragma dll()	// clear okxf.dll as we are now back to OC functions/class

// Comments last updated by Iris on 03/12/2007
/**$
*/
class XFDLGButtonEnables
{
public:
	XFDLGButtonEnables(DWORD* pdwEnable)
	{
		m_pdwEnable = pdwEnable;
		if(m_pdwEnable)
		{
			///---Sim 07-27-2007 IMPLEMENT_APPLY_AND_UNDO_MECHANISM
			m_bApplyEnable = (*m_pdwEnable & GETNGEVT_APPLY_ENABLE);
			m_bUndoEnable = (*m_pdwEnable & GETNGEVT_UNDO_ENABLE);
			///---END IMPLEMENT_APPLY_AND_UNDO_MECHANISM
			m_bOKEnable = (*m_pdwEnable & GETNGEVT_OK_ENABLE);
			m_bBTN1Enable = (*m_pdwEnable & GETNGEVT_ENABLE_CUSTOM_BUTTON1);
			m_bBTN2Enable = (*m_pdwEnable & GETNGEVT_ENABLE_CUSTOM_BUTTON2);
			m_bBTN3Enable = (*m_pdwEnable & GETNGEVT_ENABLE_CUSTOM_BUTTON3);
			///Sandy 2007-2-25 EXPAND_TO_4_CUSTOM_BUTTON
			m_bBTN4Enable = (*m_pdwEnable & GETNGEVT_ENABLE_CUSTOM_BUTTON4);
			///End EXPAND_TO_4_CUSTOM_BUTTON
			/// Hong 10/29/08 QA80-11005 ALLOW_ACCESS_DWORD_FOR_ADVANCE_PROGRAMMING
			m_dwOriginEnable = *m_pdwEnable;
			/// end ALLOW_ACCESS_DWORD_FOR_ADVANCE_PROGRAMMING
		}
	}
	~XFDLGButtonEnables()
	{				
		if ( m_dwOriginEnable == *m_pdwEnable ) /// Hong 10/29/08 QA80-11005 ALLOW_ACCESS_DWORD_FOR_ADVANCE_PROGRAMMING			
		{		
			*m_pdwEnable = 0;
			///---Sim 07-27-2007 IMPLEMENT_APPLY_AND_UNDO_MECHANISM
			if(m_bApplyEnable)
				*m_pdwEnable |= GETNGEVT_APPLY_ENABLE;
			if(m_bUndoEnable)
				*m_pdwEnable |= GETNGEVT_UNDO_ENABLE;
			///---END IMPLEMENT_APPLY_AND_UNDO_MECHANISM
			if(m_bOKEnable)
				*m_pdwEnable |= GETNGEVT_OK_ENABLE;
			if(m_bBTN1Enable)
				*m_pdwEnable |= GETNGEVT_ENABLE_CUSTOM_BUTTON1;
			if(m_bBTN2Enable)
				*m_pdwEnable |= GETNGEVT_ENABLE_CUSTOM_BUTTON2;
			if(m_bBTN3Enable)
				*m_pdwEnable |= GETNGEVT_ENABLE_CUSTOM_BUTTON3;
			///Sandy 2007-2-25 EXPAND_TO_4_CUSTOM_BUTTON
			if(m_bBTN4Enable)
				*m_pdwEnable |= GETNGEVT_ENABLE_CUSTOM_BUTTON4;
			///End EXPAND_TO_4_CUSTOM_BUTTON
		}
	}
private:
	DWORD* 	m_pdwEnable;
	/// Hong 10/29/08 QA80-11005 ALLOW_ACCESS_DWORD_FOR_ADVANCE_PROGRAMMING
	// backup m_pdwEnable, if m_pdwEnable changed, member data of bool will be ignored
	// that is say, m_pdwEnable is priority to bool
	DWORD 	m_dwOriginEnable; 
	/// end ALLOW_ACCESS_DWORD_FOR_ADVANCE_PROGRAMMING
public:
	///---Sim 07-27-2007 IMPLEMENT_APPLY_AND_UNDO_MECHANISM
	bool 	m_bApplyEnable;
	bool 	m_bUndoEnable;
	///---END IMPLEMENT_APPLY_AND_UNDO_MECHANISM
	bool 	m_bOKEnable;
	bool 	m_bBTN1Enable;
	bool 	m_bBTN2Enable;
	bool 	m_bBTN3Enable;
	///add Sandy 2007-2-25 EXPAND_TO_4_CUSTOM_BUTTON
	bool 	m_bBTN4Enable;
	
};

///------ Folger 04/14/09 QA80-12786-P3 PREVIEW_GETN_FAILS_TO_SHOW_DATA_TIME_FORMAT_AFTER_CHANGED
#include	<Array.h>

/// doing something similar as COKUGetNTreeChanges in VC
class	PreviewGetNTreeChangesHelper
{
public:
	PreviewGetNTreeChangesHelper(TreeNode& trGetN)
	{
		vector<string>	vsAttributes = {STR_COMBO_ATTRIB, STR_LABEL_ATTRIB, STR_ATTRIB_NUMFMT, STR_ATTRIB_BRANCH_COMBO};
		m_vsAttributes = vsAttributes;
				
		m_arrAttributeValues.SetAsOwner(true);
		for ( int ii=0; ii<m_vsAttributes.GetSize(); ++ii )
		{
			vector<string>*	pvs;
			pvs = new vector<string>;
			octree_get_attributes(&trGetN, pvs, m_vsAttributes[ii]);
			m_arrAttributeValues.Add(*pvs);
		}
	}
	
	bool	IsGUINeedReset(TreeNode& trGetN)
	{
		for ( int ii=0; ii<m_vsAttributes.GetSize(); ++ii )
		{
			vector<string>		vsNew;
			octree_get_attributes(&trGetN, &vsNew, m_vsAttributes[ii]);
			vector<string>&		vsOld = m_arrAttributeValues.GetAt(ii);
			if ( ocget_changed(&vsNew, &vsOld) >= 0 )
				return true;
		}
		
		return false;
	}
	
private:
	vector<string>					m_vsAttributes;
	Array<vector<string>&>			m_arrAttributeValues;
};
///------ End PREVIEW_GETN_FAILS_TO_SHOW_DATA_TIME_FORMAT_AFTER_CHANGED

///------ Folger 12/01/2011 ORG-4492-P1 SOURCE_SHEET_IS_ACTIVATED_AFTER_CHANGE_PARAM_FROM_ONE_WAY_ANOVA
struct  PageActiveLayer
{
	Page		pg;
	int			m_nActiveLayer;
};

class	PageActiveLayerRestore
{
public:
	PageActiveLayerRestore()
	{
		m_arr.SetAsOwner(TRUE);
	}
	
	void	Add(const Page& pg)
	{
		PageActiveLayer*	pp = new PageActiveLayer;
		
		pp->pg = pg;
		Worksheet			wks = pg.Layers();
		pp->m_nActiveLayer = wks ? wks.GetIndex() : -1;
		
		m_arr.Add(*pp);
	}
	
	void	Begin()
	{
		m_arr.SetSize(0);
	}
	
	void	End()
	{
		int		nSize = m_arr.GetSize();
		for ( int ii=0; ii<nSize; ++ii )
		{
			PageActiveLayer&	pal = m_arr.GetAt(ii);
			if ( pal.pg )
			{
				if ( pal.m_nActiveLayer >= 0 )
					page_set_active_layer(pal.pg, pal.m_nActiveLayer);
			}
		}
	}
	
private:
	Array<PageActiveLayer&>		m_arr;
};
///------ End SOURCE_SHEET_IS_ACTIVATED_AFTER_CHANGE_PARAM_FROM_ONE_WAY_ANOVA

///Sandy 2007-2-25 EXPAND_TO_4_CUSTOM_BUTTON
/*
#define DECLARE_BUTTON_ENABLES	XFDLGButtonEnables _BE(&dwEnables);\
bool& bOKEnable = _BE.m_bOKEnable;	bool& bBTN1Enable = _BE.m_bBTN1Enable;\
bool& bBTN2Enable = _BE.m_bBTN2Enable; bool& bBTN3Enable = _BE.m_bBTN3Enable;
*/
///---Sim 07-27-2007 IMPLEMENT_APPLY_AND_UNDO_MECHANISM
/*
#define DECLARE_BUTTON_ENABLES	XFDLGButtonEnables _BE(&dwEnables);\
bool& bOKEnable = _BE.m_bOKEnable;	bool& bBTN1Enable = _BE.m_bBTN1Enable;\
bool& bBTN2Enable = _BE.m_bBTN2Enable; bool& bBTN3Enable = _BE.m_bBTN3Enable;\
bool& bBTN4Enable = _BE.m_bBTN4Enable;
*/
#define DECLARE_BUTTON_ENABLES	XFDLGButtonEnables _BE(&dwEnables);\
bool& bApplyEnable = _BE.m_bApplyEnable;	bool& bUndoEnable = _BE.m_bUndoEnable;\
bool& bOKEnable = _BE.m_bOKEnable;	bool& bBTN1Enable = _BE.m_bBTN1Enable;\
bool& bBTN2Enable = _BE.m_bBTN2Enable; bool& bBTN3Enable = _BE.m_bBTN3Enable;\
bool& bBTN4Enable = _BE.m_bBTN4Enable;
///---END IMPLEMENT_APPLY_AND_UNDO_MECHANISM
//end EXPAND_TO_4_CUSTOM_BUTTON

///---Sim 07-12-2007 EXTEND_UPDATE_GRAPH_CONTROL_VALUE
#define DECLARE_UPDATE_GRAPH	DWORD& bUpdateGraph = dwUpdateGraph;

enum{
	//UPDATE_GRAPH_NO_CHANGED 	= 0,
	UPDATE_GRAPH_CHANGED 		= 0x0001,
	UPDATE_GRAPH_INVALID		= 0x0002,
};
///---END EXTEND_UPDATE_GRAPH_CONTROL_VALUE

///------ Folger 04/14/09 QA80-12786-P3 PREVIEW_GETN_FAILS_TO_SHOW_DATA_TIME_FORMAT_AFTER_CHANGED
#define DECLARE_UPDATE_GRID		DWORD& bUpdateGrid = dwUpdateGrid;

enum
{
	/// UPDATE_GRID_NO_NEED,
	UPDATE_GRID_SIMPLE			= 0x00000001,
	UPDATE_GRID_RESET			= 0x00000002,	/// used when trNode's combo value, numeric format, label etc changed. Then SetTree() will be called inside UpdateDynaControl()
};
///------ End PREVIEW_GETN_FAILS_TO_SHOW_DATA_TIME_FORMAT_AFTER_CHANGED

#endif //__AFX_H__
///End ENABLE_CUSTOM_BUTTONS_SEPARATELY

#endif //_XFUTILS_H
