/*------------------------------------------------------------------------------*
 * File Name: vsFlexGrid.h														*
 * Creation: CPY 1/12/2003														*
 * Purpose: Origin C header file for the vsFlexGrid ActiveX control				*
 * Copyright (c) OriginLab Corp.	2003 - 2007									*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Kyle 09/15/2009 ADD_ON_GRID_BEFORE_COLLAPSE									*
 * Jasmine 12/08/09 QA81-8980 MORE_CONFIGURATION_FOR_INFO_TABLE					*
 * Jasmine 01/15/10 UPDATE_LIST_WITH_SORT_ORDER 								*
 *	Hong QA80-15357 03/31/10 REPLACE_VSFLEX_WITH_64_MP_COMPATIABLE_WXGRID		*
 *	Bill 12/22/2010 SUPPORT_BEFORE_SEL_CHANGE_EVENT_FOR_LAYCONTENT				*
 *	Bill 01/072011 SUPPORT_MOVE_COLUMNS_AND_ROWS								*
 *	Bill 01/11/2011 SUPPORT_MOUSE_UP_EVENT										*
 *	Bill 11/24/2011 ORG-4440-S1 SUPPORT_DND										*
 *------------------------------------------------------------------------------*/
#pragma PCH //CPY 10/19/2007 QA70-10528 NEED_TO_HIDE_VSFLEX_HEADER

#ifndef _VSFLEXGRID_H
#define _VSFLEXGRID_H

#include <MsgMap.h> //CPY 10/19/2007 QA70-10528 NEED_TO_HIDE_VSFLEX_HEADER

//***************************************************
//
//
// vsFlex Consts from vsflex8l.tlh
//
//
//***************************************************
enum TextStyleSettings
{
    flexTextFlat = 0,
    flexTextRaised = 1,
    flexTextInset = 2,
    flexTextRaisedLight = 3,
    flexTextInsetLight = 4
};

enum FocusRectSettings
{
    flexFocusNone = 0,
    flexFocusLight = 1,
    flexFocusHeavy = 2,
    flexFocusSolid = 3,
    flexFocusRaised = 4,
    flexFocusInset = 5
};

enum ShowSelSettings
{
    flexHighlightNever = 0,
    flexHighlightAlways = 1,
    flexHighlightWithFocus = 2
};

enum RedrawSettings
{
    flexRDNone = 0,
    flexRDDirect = 1,
    flexRDBuffered = 2
};

enum ScrollBarsSettings
{
    flexScrollBarNone = 0,
    flexScrollBarHorizontal = 1,
    flexScrollBarVertical = 2,
    flexScrollBarBoth = 3
};

enum FillStyleSettings
{
    flexFillSingle = 0,
    flexFillRepeat = 1
};

enum GridStyleSettings
{
    flexGridNone = 0,
    flexGridFlat = 1,
    flexGridInset = 2,
    flexGridRaised = 3,
    flexGridFlatHorz = 4,
    flexGridInsetHorz = 5,
    flexGridRaisedHorz = 6,
    flexGridSkipHorz = 7,
    flexGridFlatVert = 8,
    flexGridInsetVert = 9,
    flexGridRaisedVert = 10,
    flexGridSkipVert = 11,
    flexGridExplorer = 12,
    flexGridExcel = 13,
    flexGridDataGrid = 14
};

enum AlignmentSettings
{
    flexAlignLeftTop = 0,
    flexAlignLeftCenter = 1,
    flexAlignLeftBottom = 2,
    flexAlignCenterTop = 3,
    flexAlignCenterCenter = 4,
    flexAlignCenterBottom = 5,
    flexAlignRightTop = 6,
    flexAlignRightCenter = 7,
    flexAlignRightBottom = 8,
    flexAlignGeneral = 9
};

enum PictureAlignmentSettings
{
    flexPicAlignLeftTop = 0,
    flexPicAlignLeftCenter = 1,
    flexPicAlignLeftBottom = 2,
    flexPicAlignCenterTop = 3,
    flexPicAlignCenterCenter = 4,
    flexPicAlignCenterBottom = 5,
    flexPicAlignRightTop = 6,
    flexPicAlignRightCenter = 7,
    flexPicAlignRightBottom = 8,
    flexPicAlignStretch = 9,
    flexPicAlignTile = 10
};

enum SortSettings
{
    flexSortNone = 0,
    flexSortGenericAscending = 1,
    flexSortGenericDescending = 2,
    flexSortNumericAscending = 3,
    flexSortNumericDescending = 4,
    flexSortStringNoCaseAscending = 5,
    flexSortStringNoCaseDescending = 6,
    flexSortStringAscending = 7,
    flexSortStringDescending = 8,
    flexSortCustom = 9,
    flexSortUseColSort = 10
};

enum SelModeSettings
{
    flexSelectionFree = 0,
    flexSelectionByRow = 1,
    flexSelectionByColumn = 2,
    flexSelectionListBox = 3
};

enum MergeSettings
{
    flexMergeNever = 0,
    flexMergeFree = 1,
    flexMergeRestrictRows = 2,
    flexMergeRestrictColumns = 3,
    flexMergeRestrictAll = 4,
    flexMergeFixedOnly = 5,
    flexMergeSpill = 6,
    flexMergeOutline = 7
};

enum PictureTypeSettings
{
    flexPictureColor = 0,
    flexPictureMonochrome = 1
};

enum AllowUserResizeSettings
{
    flexResizeNone = 0,
    flexResizeColumns = 1,
    flexResizeRows = 2,
    flexResizeBoth = 3,
    flexResizeBothUniform = 4
};

enum MousePointerSettings
{
    flexDefault = 0,
    flexArrow = 1,
    flexCross = 2,
    flexIBeam = 3,
    flexIcon = 4,
    flexSize = 5,
    flexSizeNESW = 6,
    flexSizeNS = 7,
    flexSizeNWSE = 8,
    flexSizeEW = 9,
    flexUpArrow = 10,
    flexHourglass = 11,
    flexNoDrop = 12,
    flexArrowHourGlass = 13,
    flexArrowQuestion = 14,
    flexSizeAll = 15,
    flexPointerCopy = 50,
    flexPointerMove = 51,
    flexSizeHorz = 52,
    flexSizeVert = 53,
    flexHand = 54,
    flexCustom = 99
};

enum EditableSettings
{
    flexEDNone = 0,
    flexEDKbd = 1,
    flexEDKbdMouse = 2
};

enum SubtotalPositionSettings
{
    flexSTBelow = 0,
    flexSTAbove = 1
};

enum BorderStyleSettings
{
    flexBorderNone = 0,
    flexBorderFlat = 1
};

enum AppearanceSettings
{
    flexFlat = 0,
    flex3D = 1,
    flex3DLight = 2
};

enum OutlineBarSettings
{
    flexOutlineBarNone = 0,
    flexOutlineBarComplete = 1,
    flexOutlineBarSimple = 2,
    flexOutlineBarSymbols = 3,
    flexOutlineBarCompleteLeaf = 4,
    flexOutlineBarSimpleLeaf = 5,
    flexOutlineBarSymbolsLeaf = 6
};

enum AutoSizeSettings
{
    flexAutoSizeColWidth = 0,
    flexAutoSizeRowHeight = 1,
	flexAutoSizeNoFixed = 0x10000000,	/// Bill 05/18/2011 ORG-2614-S2 SUPPORT_FIXED_ROWCOL_FOR_AUTOSIZE
};

enum OwnerDrawSettings
{
    flexODNone = 0,
    flexODOver = 1,
    flexODContent = 2,
    flexODComplete = 3,
    flexODOverFixed = 4,
    flexODContentFixed = 5,
    flexODCompleteFixed = 6
};

enum DataModeSettings
{
    flexDMFree = 0,
    flexDMBound = 1,
    flexDMBoundBatch = 2,
    flexDMBoundImmediate = 3,
    flexDMBoundNoRowCount = 4
};

enum OLEDragModeSettings
{
    flexOLEDragManual = 0,
    flexOLEDragAutomatic = 1
};

enum OLEDropModeSettings
{
    flexOLEDropNone = 0,
    flexOLEDropManual = 1,
    flexOLEDropAutomatic = 2
};

enum TabBehaviorSettings
{
    flexTabControls = 0,
    flexTabCells = 1
};

enum CellCheckedSettings
{
    flexNoCheckbox = 0,
    flexChecked = 1,
    flexUnchecked = 2,
    flexTSChecked = 3,
    flexTSUnchecked = 4,
    flexTSGrayed = 5
};

enum MergeCompareSettings
{
    flexMCExact = 0,
    flexMCNoCase = 1,
    flexMCTrimNoCase = 2
};

enum EllipsisSettings
{
    flexNoEllipsis = 0,
    flexEllipsisEnd = 1,
    flexEllipsisPath = 2
};

enum AutoSearchSettings
{
    flexSearchNone = 0,
    flexSearchFromTop = 1,
    flexSearchFromCursor = 2
};

enum ExplorerBarSettings
{
    flexExNone = 0,
    flexExSort = 1,
    flexExMove = 2,
    flexExSortAndMove = 3,
    flexExSortShow = 5,
    flexExSortShowAndMove = 7,
    flexExMoveRows = 8,
	flexExMoveColsAndRows = 10, /// Bill 01/072011 SUPPORT_MOVE_COLUMNS_AND_ROWS
};

enum SubtotalSettings
{
    flexSTNone = 0,
    flexSTClear = 1,
    flexSTSum = 2,
    flexSTPercent = 3,
    flexSTCount = 4,
    flexSTAverage = 5,
    flexSTMax = 6,
    flexSTMin = 7,
    flexSTStd = 8,
    flexSTVar = 9,
    flexSTStdPop = 10,
    flexSTVarPop = 11
};

enum CollapsedSettings
{
    flexOutlineExpanded = 0,
    flexOutlineSubtotals = 1,
    flexOutlineCollapsed = 2
};

enum SaveLoadSettings
{
    flexFileAll = 0,
    flexFileData = 1,
    flexFileFormat = 2,
    flexFileCommaText = 3,
    flexFileTabText = 4,
    flexFileCustomText = 5,
    flexFileExcel = 6
};

enum ArchiveSettings
{
    arcAdd = 0,
    arcStore = 1,
    arcExtract = 2,
    arcDelete = 3
};

enum ArchiveInfoSettings
{
    arcFileCount = 0,
    ArcFileName = 1,
    arcFileSize = 2,
    arcFileCompressedSize = 3,
    arcFileDate = 4
};

enum DataTypeSettings
{
    flexDTEmpty = 0,
    flexDTNull = 1,
    flexDTShort = 2,
    flexDTLong = 3,
    flexDTSingle = 4,
    flexDTDouble = 5,
    flexDTCurrency = 6,
    flexDTDate = 7,
    flexDTString = 8,
    flexDTDispatch = 9,
    flexDTError = 10,
    flexDTBoolean = 11,
    flexDTVariant = 12,
    flexDTUnknown = 13,
    flexDTDecimal = 14,
    flexDTLong8 = 20,
    flexDTStringC = 30,
    flexDTStringW = 31
};

enum CellPropertySettings
{
    flexcpText = 0,
    flexcpTextStyle = 1,
    flexcpAlignment = 2,
    flexcpPicture = 3,
    flexcpPictureAlignment = 4,
    flexcpChecked = 5,
    flexcpBackColor = 6,
    flexcpForeColor = 7,
    flexcpFloodPercent = 8,
    flexcpFloodColor = 9,
    flexcpFont = 10,
    flexcpFontName = 11,
    flexcpFontSize = 12,
    flexcpFontBold = 13,
    flexcpFontItalic = 14,
    flexcpFontUnderline = 15,
    flexcpFontStrikethru = 16,
    flexcpFontWidth = 17,
    flexcpValue = 18,
    flexcpTextDisplay = 19,
    flexcpData = 20,
    flexcpCustomFormat = 21,
    flexcpLeft = 22,
    flexcpTop = 23,
    flexcpWidth = 24,
    flexcpHeight = 25,
    flexcpVariantValue = 26,
    flexcpRefresh = 27,
    flexcpSort = 28,
    flexcpDataType = 29,	///Sophy 7/24/2012 ORG-6324-S1 GRID_CELL_NEED_OPTION_TO_ALLOW_NUMERIC_ONLY
};

///Sophy 7/24/2012 ORG-6324-S1 GRID_CELL_NEED_OPTION_TO_ALLOW_NUMERIC_ONLY
enum CellDataTypeSettings {
	CellDataType_None = 0,
	CellDataType_Double = 1,
	CellDataType_Integer = 2,
	CellDataType_Signed_Double = 3,
	CellDataType_Signed_Integer = 4,
};
///end GRID_CELL_NEED_OPTION_TO_ALLOW_NUMERIC_ONLY

enum RowStatusSettings
{
    flexrsNew = 0,
    flexrsUpdated = 1,
    flexrsModified = 2,
    flexrsDeleted = 3
};

enum ShowButtonSettings
{
    flexSBEditing = 0,
    flexSBFocus = 1,
    flexSBAlways = 2
};

enum ComboSearchSettings
{
    flexCmbSearchNone = 0,
    flexCmbSearchLists = 1,
    flexCmbSearchCombos = 2,
    flexCmbSearchAll = 3
};

enum AllowUserFreezeSettings
{
    flexFreezeNone = 0,
    flexFreezeColumns = 1,
    flexFreezeRows = 2,
    flexFreezeBoth = 3
};

#ifndef VTS_NONE
	#define VTS_NONE
#endif

//**************************************************************
//
//
// vsFlex events and handling macros, suitable only for Origin C
//
//
//**************************************************************

// prototype as:
// static void OnBeforeEdit(Control cntrl, int nRow, int nCol, BOOL* pCancel)
#define	ON_GRID_BEFORE_EDIT(_idCntl, _ocFunc)	ON_ACTIVEX_EVENT(21, _idCntl, _ocFunc, VTS_CTRL VTS_I4 VTS_I4 VTS_PBOOL)

// static void OnStartEdit(Control cntrl, int nRow, int nCol, BOOL* pCancel)
#define ON_GRID_START_EDIT(_idCntl, _ocFunc)	ON_ACTIVEX_EVENT(22, _idCntl, _ocFunc, VTS_CTRL VTS_I4 VTS_I4 VTS_PBOOL)

// static void OnCellButtonClick(Control cntrl, int nRow, int nCol)
#define ON_GRID_BUTTON_CLICK(_idCntl, _ocFunc)	ON_ACTIVEX_EVENT(34, _idCntl, _ocFunc, VTS_CTRL VTS_I4 VTS_I4)

// nButton = MK_LBUTTON	etc
// nShift = 1 if shift, 0 if not
// static void OnBeforeMouseDown(Control cntrl, short nButton, short nShift, float X, float Y, BOOL* pCancel)
#define ON_GRID_BEFORE_MOUSE_DOWN(_idCntl, _ocFunc)	ON_ACTIVEX_EVENT(5, _idCntl, _ocFunc, VTS_CTRL VTS_I2 VTS_I2 VTS_R4 VTS_R4 VTS_PBOOL)

// static void OnMouseMove(Control cntrl, short nButton, short nShift, float X, float Y)
#define ON_GRID_MOUSE_MOVE(_idCntl, _ocFunc)	ON_ACTIVEX_EVENT(-606, _idCntl, _ocFunc, VTS_CTRL VTS_I2 VTS_I2 VTS_R4 VTS_R4)

// static void OnRowColChange(Control cntrl) 	
#define ON_GRID_ROW_COL_CHANGE(_idCntl, _ocFunc)	ON_ACTIVEX_EVENT(2, _idCntl, _ocFunc, VTS_CTRL VTS_NONE)

// static void OnValidateEdit(Control cntrl, int nRow, int nCol, BOOL* pCancel)
#define ON_GRID_VALIDATE_EDIT(_idCntl, _ocFunc)		ON_ACTIVEX_EVENT(23, _idCntl, _ocFunc, VTS_CTRL VTS_I4 VTS_I4 VTS_PBOOL)

// static void OnSelChange(Control cntrl)
#define ON_GRID_SEL_CHANGE(_idCntl, _ocFunc)		ON_ACTIVEX_EVENT(1, _idCntl, _ocFunc, VTS_CTRL)

// static void OnAfterSelChange(Control cntrl int nOldRowSel, int nOldColSel, int nNewRowSel, int nNewColSel)
#define ON_GRID_AFTER_SEL_CHANGE(_idCntl, _ocFunc)		ON_ACTIVEX_EVENT(9, _idCntl, _ocFunc, VTS_CTRL VTS_I4 VTS_I4 VTS_I4 VTS_I4)

///Kyle 09/15/2009 ADD_ON_GRID_BEFORE_COLLAPSE
// static void OnBeforeCollapse(Control cntrl, int nRow, short nState, BOOL* pCancel)
#define ON_GRID_BEFORE_COLLAPSE(_idCntl, _ocFunc) ON_ACTIVEX_EVENT(19, _idCntl, _ocFunc, VTS_CTRL VTS_I4 VTS_I2 VTS_PBOOL)
///End ADD_ON_GRID_BEFORE_COLLAPSE

//static void OnAfterCollapse(Control cntrl, int nRow, short nState)
#define ON_GRID_AFTER_COLLAPSE(_idCntl, _ocFunc) ON_ACTIVEX_EVENT(20, _idCntl, _ocFunc, VTS_CTRL VTS_I4 VTS_I2)

// static void OnAfterEdit(Control cntrl, int nRow, int nCol)
#define ON_GRID_AFTER_EDIT(_idCntl, _ocFunc)		ON_ACTIVEX_EVENT(24, _idCntl, _ocFunc, VTS_CTRL VTS_I4 VTS_I4)

// static void OnChangeEdit(Control cntrl)
#define ON_GRID_CHANGE_EDIT(_idCntl, _ocFunc)		ON_ACTIVEX_EVENT(28, _idCntl, _ocFunc, VTS_CTRL)


//static void OnDrawCell(Control cntrl, UINT hDC, int nRow, int nCol, int nLeft, int nTop, int nRight, int nBottom, BOOL* pDone)
#define ON_GRID_DRAW_CELL(_idCntl, _ocFunc)		ON_ACTIVEX_EVENT(32, _idCntl, _ocFunc, VTS_CTRL VTS_I4 VTS_I4 VTS_I4 VTS_I4 VTS_I4 VTS_I4 VTS_I4 VTS_PBOOL)

// static void OnCellChange(Control cntrl, int Row, int Col)
#define ON_GRID_CELL_CHANGE(_idCntl, _ocFunc)		ON_ACTIVEX_EVENT(43, _idCntl, _ocFunc, VTS_CTRL VTS_I4 VTS_I4)

// static void OnComboDropDown(Control cntrl, int nRow, int nCol)
#define ON_GRID_COMBO_DROPDOWN(_idCntl, _ocFunc)		ON_ACTIVEX_EVENT(49, _idCntl, _ocFunc, VTS_CTRL VTS_I4 VTS_I4)

// static void OnComboCloseUp(Control cntrl, int nRow, int nCol, BOOL* pFinishEdit)
#define ON_GRID_COMBO_CLOSEUP(_idCntl, _ocFunc)		ON_ACTIVEX_EVENT(50, _idCntl, _ocFunc, VTS_CTRL VTS_I4 VTS_I4 VTS_PBOOL)

// static void OnBeforeUserResize(Control cntrl, int nRow, int nCol, BOOL *pCancel)
#define ON_GRID_BEFORE_USER_RESIZE(_idCntl, _ocFunc) ON_ACTIVEX_EVENT(17, _idCntl, _ocFunc, VTS_CTRL VTS_I4 VTS_I4 VTS_PBOOL)
	
// static void OnAfterUserResize(Control cntrl, int nRow, int nCol)
#define ON_GRID_AFTER_USER_RESIZE(_idCntl, _ocFunc) ON_ACTIVEX_EVENT(18, _idCntl, _ocFunc, VTS_CTRL VTS_I4 VTS_I4)

// static void OnEnterCell(Control cntrl)
#define ON_GRID_ENTER_CELL(_idCntl, _ocFunc) ON_ACTIVEX_EVENT(3, _idCntl, _ocFunc, VTS_CTRL VTS_NONE)

// static void OnClick(Control cntrl)
#define ON_GRID_CLICK(_idCntl, _ocFunc) ON_ACTIVEX_EVENT(-600, _idCntl, _ocFunc, VTS_CTRL VTS_NONE)

// static void OnDblClick(Control cntrl)
#define ON_GRID_DBLCLICK(_idCntl, _ocFunc) ON_ACTIVEX_EVENT(-601, _idCntl, _ocFunc, VTS_CTRL VTS_NONE)

/// Bill 11/24/2011 ORG-4440-S1 SUPPORT_DND
//#define ON_GRID_START_DRAG(_idCntl, _ocFunc)	ON_ACTIVEX_EVENT(37, _idCntl, _ocFunc, VTS_CTRL VTS_PDISPATCH VTS_PI4)
#define ON_GRID_START_DRAG(_idCntl, _ocFunc)	ON_ACTIVEX_EVENT(37, _idCntl, _ocFunc, VTS_CTRL VTS_PI4 VTS_PI4 VTS_PI4 VTS_PI4 VTS_PI4)
#define ON_GRID_COMPLETE_DRAG(_idCntl, _ocFunc) ON_ACTIVEX_EVENT(40, _idCntl, _ocFunc, VTS_CTRL VTS_PI4)
/// End SUPPORT_DND
#define ON_GRID_DRAG_OVER(_idCntl, _ocFunc)		ON_ACTIVEX_EVENT(41, _idCntl, _ocFunc, VTS_CTRL VTS_PDISPATCH VTS_PI4 VTS_I2 VTS_I2 VTS_R4 VTS_R4 VTS_PI2)
#define ON_GRID_DRAG_DROP(_idCntl, _ocFunc)		ON_ACTIVEX_EVENT(42, _idCntl, _ocFunc, VTS_CTRL VTS_PDISPATCH VTS_PI4 VTS_I2 VTS_I2 VTS_R4 VTS_R4)

#define ON_GRID_BEFORE_MOVE_ROWS(_idCntl, _ocFunc)		ON_ACTIVEX_EVENT(44, _idCntl, _ocFunc, VTS_CTRL VTS_I4 VTS_PI4 )
#define ON_GRID_AFTER_MOVE_ROWS(_idCntl, _ocFunc)		ON_ACTIVEX_EVENT(45, _idCntl, _ocFunc, VTS_CTRL VTS_I4 VTS_PI4 )

///Jasmine 12/08/09 QA81-8980 MORE_CONFIGURATION_FOR_INFO_TABLE
#define ON_GRID_BEFORE_MOVE_COLUMNS(_idCntl, _ocFunc)		ON_ACTIVEX_EVENT(15, _idCntl, _ocFunc, VTS_CTRL VTS_I4 VTS_PI4 )
#define ON_GRID_AFTER_MOVE_COLUMNS(_idCntl, _ocFunc)		ON_ACTIVEX_EVENT(16, _idCntl, _ocFunc, VTS_CTRL VTS_I4 VTS_PI4 )
///End MORE_CONFIGURATION_FOR_INFO_TABLE
///Jasmine 01/15/10 UPDATE_LIST_WITH_SORT_ORDER 
#define ON_GRID_BEFORE_SORT(_idCntl, _ocFunc)				ON_ACTIVEX_EVENT(13, _idCntl, _ocFunc, VTS_CTRL VTS_I4 VTS_PI2 )
#define ON_GRID_AFTER_SORT(_idCntl, _ocFunc)				ON_ACTIVEX_EVENT(14, _idCntl, _ocFunc, VTS_CTRL VTS_I4 VTS_PI2 )
///End UPDATE_LIST_WITH_SORT_ORDER

/// Bill 12/22/2010 SUPPORT_BEFORE_SEL_CHANGE_EVENT_FOR_LAYCONTENT
#define ON_GRID_BEFORE_SEL_CHANGE(_idCntl, _ocFunc)			ON_ACTIVEX_EVENT(8, _idCntl, _ocFunc, VTS_CTRL VTS_I4 VTS_I4 VTS_I4 VTS_I4 VTS_PBOOL)
#define ON_GRID_BEFORE_ROW_COL_CHANGE(_idCntl, _ocFunc) 	ON_ACTIVEX_EVENT(6, _idCntl, _ocFunc, VTS_CTRL VTS_I4 VTS_I4 VTS_I4 VTS_I4 VTS_PBOOL)
/// End SUPPORT_BEFORE_SEL_CHANGE_EVENT_FOR_LAYCONTENT

/// Bill 01/11/2011 SUPPORT_MOUSE_UP_EVENT
// static void OnMouseUp(Control cntrl, short nButton, short nShift, float X, float Y)
#define ON_GRID_MOUSE_UP(_idCntl, _ocFunc)	ON_ACTIVEX_EVENT(-607, _idCntl, _ocFunc, VTS_CTRL VTS_I2 VTS_I2 VTS_R4 VTS_R4)
/// End SUPPORT_MOUSE_UP_EVENT 
///Sophy 7/17/2012 ORG-6216-S2 OWXGRID_ON_KEY_MESSAGE_FOR_OC
// static void OnKeyInfo(Control cntrl, UNIT nMsg, UINT wParam, UINT lParam)	
#define	ON_GRID_KEY(_idCntl, _ocFunc)		ON_ACTIVEX_EVENT(52, _idCntl, _ocFunc, VTS_CTRL VTS_I4 VTS_I4 VTS_I4)
///end OWXGRID_ON_KEY_MESSAGE_FOR_OC
/// Hong QA80-15357 03/31/10 REPLACE_VSFLEX_WITH_64_MP_COMPATIABLE_WXGRID
#ifdef		__REPLACE_VSFLEX_WITH_64_MP_WXGRID__

#define NM_FIRST                (0)       // generic to all controls
#define		WM_GRID_EVENT_BASE				(NM_FIRST + 1)
#define		WM_GRID_AFTER_SEL_CHANGE		(WM_GRID_EVENT_BASE)

// Hong, to do, right now, origin do NOT pass LPNMHDR into origin, need to improve it
#define ON_WXGRID_AFTER_SEL_CHANGE(_idCntrl, _ocHandler) 	ON_EVENT_EX(WM_GRID_AFTER_SEL_CHANGE, _idCntrl, _ocHandler, VTS_CTRL)

#endif		//__REPLACE_VSFLEX_WITH_64_MP_WXGRID__
/// end REPLACE_VSFLEX_WITH_64_MP_COMPATIABLE_WXGRID

#endif //_VSFLEXGRID_H

