/*------------------------------------------------------------------------------*
 * File Name: vector.h															*
 * Creation: TD 4-16-03															*
 * Purpose: Origin C header file for Origin basic Data Vector types				*
 * Copyright (c) OriginLab Corp.	2002 - 2007									*
 * All Rights Reserved															*
 * Modifications:																*
 *	Cheney 2007-3-10 MAKE_AVERAGE_IS_SAME_WITH_ADJECENT_SMOOTH					*
 *	Sim 07-05-2007 SHOULD_RETURN_NUMBER_AS_INT_BECAUSE_UNSIGNED_INT_0_MINUS_1_IS_NOT_EQUAL_-1
 *	Hong 12/06/07 v8.0762 PFW_NEED_MORE_HINT_FOR_CURRENT_POINTS_IN_TOTAL		*
 *	YuI 07/18/08 QA70-11868 AUTOMATIC_GENERATION_OF_COMMENTS_FOR_XF_OUTPUTS		*
 *	Kyle 10/21/08 QA80-12415 P1 ADD_OVERROAD_FUNCTION_FIND_TO_VECTORBASE		*
 *	Kyle 10/22/08 QA80-12415 P3  ADD_OVERLOAD_FUNCTION_REPLACE_TO_VECTORBASE	*
 *	Kyle 10/23/08 QA80-12415 P5 UPDATE_ROW_COL_RECT_ARRAYS						*
 *	Kyle 11/07/08 QA70-12544 ADD_METHOD_INSERTVALUE_IN_VECTOR					*
 *	ML 12/19/2008 VECTOR_ABS_VALUE_METHOD										*
 *	Kyle 03/02/2009 QA70-13202 ADD_OVERLOADING_METHOD_REMOVEAT_WITH_VECTOR_ARGUMENT
 * Kenny 06/22/2009 QA80-12415-S1 FUNC_FIND_DUPLICATES_ADD_SUPPORT_COUNTING_OCCURRENCES*
 *	YuI 11/23/09 QA70-13806 VIRTUAL_MATRIX_IMPLEMENTATION						*
 *	Kyle 05/20/2010 ORG-154 GET_SUB_VECTOR_BY_INDICES							*
 *	Folger 12/15/2010 ORG-1733 GETSUBVECTOR_NOT_WORK_FOR_VECTOR_STRING			*
 *	Folger 07/13/2011 ORG-3247-S1 OC_ACCESS_ABOUT_LOOSE_DATASET_LABELS			*
 *	Folger 12/07/2011 ORG-4545 OC_CATEGORICALMAP_INIT_FROM_DATASET				*
 *	Folger 02/28/2012 ORG-5114-P1 VECTORBASE_SORT_FAILED_ON_MIXED_COLUMN_WITH_TEXT
 *------------------------------------------------------------------------------*/
#ifndef _VECTOR_H
#define _VECTOR_H

#include <common.h>

#ifndef _STRING_H
#include <string.h>		// Most likely will need strings
#endif // _STRING_H

#include <OC_types.h>	// Structures used in Origin internal functions

#ifndef _WKSHEET_H
#include <Wksheet.h>
#endif // _WKSHEET_H


//Comments last updated by ER on 12/15/04
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetUpperIndex
*/
#define  GetUpperIndex	   GetUpperBound

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetLowerIndex
*/
#define  GetLowerIndex	   GetLowerBound

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:SetUpperIndex
*/
#define  SetUpperIndex	   SetUpperBound

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:SetLowerIndex
*/
#define	 SetLowerIndex	   SetLowerBound

///Cheney 2007-3-10 MAKE_AVERAGE_IS_SAME_WITH_ADJECENT_SMOOTH
//// Comments last updated by ER on 12/15/04
///**
		//Denotes rectangular window type to be applied on data
		//for operations such as moving average
		//Keywords:
			//moving average; window			
//*/
//enum {
	//RECT_WINDOW = 0
//};
//should move it to oc_const later, VC and OC could share it
//wait smooth algorithm modification finish
enum {
	EDGEPAD_NAN = 0
};
///end MAKE_AVERAGE_IS_SAME_WITH_ADJECENT_SMOOTH


// Comments last updated by Joseph on 04/14/07
/**+
http://ocwiki.originlab.com/index.php?title=Category:vectorbase_(class)
*/
class vectorbase
{

protected:

	/**# 
			Objects of type vectorbase can not be constructed in Origin C. vectorbase is an      
			abstract class used for polymorphic handling of vector and Dataset template class    
			types which inherit vectorbase class methods.
	*/
	vectorbase(); // Vectorbase default constructor. For internal use only.
	
public:

	// Comments last updated by ER on 12/14/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:vectorbase-SetSize
	*/
	BOOL	SetSize(UINT nSize, int nGrowBy = -1); // Set the size of the vector

	// Comments last updated by Joseph on 04/14/07
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:vectorbase-GetSize
	*/
	///---Sim 07-05-2007 SHOULD_RETURN_NUMBER_AS_INT_BECAUSE_UNSIGNED_INT_0_MINUS_1_IS_NOT_EQUAL_-1
	//UINT	GetSize() const; // Get the size of a vector
	int		GetSize() const; // Get the size of a vector
	///---END SHOULD_RETURN_NUMBER_AS_INT_BECAUSE_UNSIGNED_INT_0_MINUS_1_IS_NOT_EQUAL_-1

	// Comments last updated by Joseph on 04/14/07
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:vectorbase-GetUpperBound
	*/
	int 	GetUpperBound(); // Get the upper index of the Dataset display range.

	// Comments last updated by Joseph on 04/14/07
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:vectorbase-GetLowerBound
	*/
	int 	GetLowerBound(); // Get the lower index of the Dataset display range.

	// Comments last updated by CPY on 6/27/05
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:vectorbase-Sort
	*/
	/// YuI 03/12/09 QA70-13274 STABLE_SORTING_FOR_VECTORS
	//	BOOL Sort(int wOption = SORT_ASCENDING, BOOL bMissingValuesSmall = TRUE, vector<uint>& vnIndeces = NULL); // Sort elements of the vector
	///------ Folger 02/28/2012 ORG-5114-P1 VECTORBASE_SORT_FAILED_ON_MIXED_COLUMN_WITH_TEXT
	//BOOL Sort(int wOption = SORT_ASCENDING, BOOL bMissingValuesSmall = TRUE, vector<uint>& vnIndeces = NULL, BOOL bUseStableAlgorithm = FALSE); // Sort elements of the vector
	BOOL Sort(int wOption = SORT_ASCENDING, BOOL bMissingValuesSmall = TRUE, vector<uint>& vnIndeces = NULL, SORTCNTRL cntrl = 0);
	///------ End VECTORBASE_SORT_FAILED_ON_MIXED_COLUMN_WITH_TEXT
	/// end STABLE_SORTING_FOR_VECTORS
	
	///Comments last updated by Joseph on 2007-4-14
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:vectorbase-Reorder
	*/
	BOOL Reorder(const vector<uint>& vnIndeces); // Reorder elements of the vector
	
	// Comments last updated by ER on 12/16/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:vectorbase-Difference
	*/
	BOOL	Difference(vectorbase &vecDiff ); // Get difference between successive elements of the vector

	// Comments last updated by ER on 12/17/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:vectorbase-Append
	*/
	BOOL	Append(vectorbase &vv); // Append data to a vector

	// Comments last updated by ER on 12/17/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:vectorbase-Sum
	*/
	int		Sum(int & nSum); // Compute the sum of all elements of the vector

	// Comments last updated by ER on 12/17/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:vectorbase-Sum
	*/
	int		Sum(double & dSum); // Compute the sum of all elements of the vector

	// Comments last updated by ER on 12/17/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:vectorbase-Sum
	*/
	int		Sum(complex & cxSum); // Compute the sum of all elements of the vector

	// Comments last updated by Joseph on 01/04/06
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:vectorbase-GetMinMax
	*/
	int		GetMinMax(double& min, double& max, int* pIndexMin = NULL, int* pIndexMax = NULL); // Get min and max values and their indices from the vector

	// Comments last updated by ER on 12/28/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:vectorbase-FrequencyCount
	*/
	int     FrequencyCount(double dMin, double dMax, double dInc, vector<int>&  vCounts, int wIncludeOutliers = FAB_NOT_INCLUDE_OUTLIERS); // Compute the frequency count of elements in a vector.

	// Comments last upated by ER on 12/20/04		
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:vectorbase-GetBytes
	*/
 	int     GetBytes(vector<byte>& vStream); // Copy the elements of this vector into an internal buffer.

	// Comments last updated by ER on 12/20/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:vectorbase-SetBytes
	*/
 	int     SetBytes(vector<byte>& vStream); // Set the elements of this vector from an internal buffer.

	// Comments last updated by ER on 12/20/05
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:vectorbase-GetLabTalkVectorValue
	*/
	BOOL	GetLabTalkVectorValue(LPCTSTR lpcszLabTalkVector); // Assigns a LabTalk vector to an Origin C vector.

	// Comments last updated by ER on 12/20/05
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:vectorbase-SetLabTalkVectorValue
	*/
	BOOL	SetLabTalkVectorValue(LPCTSTR lpcszLabTalkVector); // Assigns an Origin C vector to a LabTalk vector.

	/// Fisher 10/22/2008 QA80-12415 VECTOR_STRINGS_FIND_DUPLICATES 
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:vectorbase-FindDuplicates
	*/
	///Kenny 06/22/2009 QA80-12415-S1 FUNC_FIND_DUPLICATES_ADD_SUPPORT_COUNTING_OCCURRENCES
	//int  FindDuplicates(vector<int>& vnMapIndices, vector<uint>& vnR1s, BOOL bCaseSensitive = false);
	int  FindDuplicates(vector<int>& vnMapIndices, vector<uint>& vnR1s, BOOL bCaseSensitive = false, vector<uint>& vnOccurences = NULL);
	///End QA80-12415-S1 FUNC_FIND_DUPLICATES_ADD_SUPPORT_COUNTING_OCCURRENCES
	/// end VECTOR_STRINGS_FIND_DUPLICATES
	
	/// ML 12/19/2008 VECTOR_ABS_VALUE_METHOD
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:vectorbase-Abs
	*/
	int		Abs();
	/// end VECTOR_ABS_VALUE_METHOD


#ifdef	ORIGIN_COM_SUPPORT

	// Comments last updated by ER on 12/20/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:vectorbase-Append
	*/
	BOOL	Append(_VARIANT& var); // Append a COM object of type _VARIANT to a vector or Dataset.

	// Comments last updated by ER on 12/20/05
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:vectorbase-GetDataAsOneDimensionalArray
	*/
	_VARIANT	GetDataAsOneDimensionalArray(int lowerBound = 0); // Return a copy of a vector or Dataset as a one dimensional array of type _VARIANT.

	// Comments last updated by Joseph on 07/25/07
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:vectorbase-GetAs1DArray
	*/
	_VARIANT	GetAs1DArray(); // Return a copy of a vector or Dataset as a one dimensional array of type _VARIANT.

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:vectorbase-GetAs2DArray
	*/
	_VARIANT	GetAs2DArray(int numColumns, BOOL bArrayOfVariants = TRUE);


#endif //#ifdef	ORIGIN_COM_SUPPORT

	// Comments last updated by ER on 12/20/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:vectorbase-GetInternalDataType
	*/
	int 	GetInternalDataType(); // Get the internal or underlying base data type of a vectorbase derived object.


	// Comments last updated by ER on 12/28/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:vectorbase-Data
	*/
	BOOL	Data(double dStartVal, double dEndVal, double dIncVal = 1.0); // Fill vector with data

#if _OC_VER >= 0x0800
	// Comments last updated by ER on 12/28/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:vectorbase-Data
	*/
	BOOL    Data(int nStartVal, int nEndVal, int nIncVal = 1); // Fill vector with integer data
#endif //_OC_VER >= 0x0800
	
#if  _OC_VER > 0x0703
	// Comments last updated by ER on 12/28/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:vectorbase-Uniform
	*/
	BOOL Uniform(int nSize, int nSeed = 0); // Fill vector with pseudorandom numbers between 0 and 1
	
	// Comments last updated by ER on 12/28/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:vectorbase-Normal
	*/
	BOOL Normal(int nSize, int nSeed = 0); // Fill vector with pseudorandom numbers from a normal distribution
#endif //_OC_VER > 0x0703

	// Comments last updated by ER on 12/28/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:vectorbase-Wrap
	*/
	BOOL Wrap(int nNum =0); // Wrap around elements of the vector

	// Comments last updated by ER on 12/28/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:vectorbase-GetReal
	*/
	int	GetReal( vector & vReal ); // Get the real part of a complex vector.
	
	// Comments last updated by ER on 12/28/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:vectorbase-GetImaginary
	*/
	int	GetImaginary( vector & vImag ); // Get the imaginary part of a complex vector. 
	
	// Comments last updated by ER on 12/28/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:vectorbase-GetAmplitude
	*/
	int	GetAmplitude( vector & vAmplitude ); // Get the amplitude (modulus) of the complex vector.

	// Comments last updated by ER on 12/28/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:vectorbase-GetPhase
	*/
	int	GetPhase( vector & vPhase ); // Get the phase angle of the complex vector.
	
	// Comments last updated by ER on 12/29/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:vectorbase-Conjugate
	*/
	int		Conjugate(); // Replace vector with the conjugate of the vector.

	// Comments last updated by ER on 12/29/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:vectorbase-MakeComplex
	*/
	int		MakeComplex(vectorbase & vbReal, vectorbase & vbImag); // Create a complex vector from two real vectors.

#if  _OC_VER > 0x0703
	// Comments last updated by ER on 12/29/04			
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:vectorbase-GetSubVector
	*/
	int	GetSubVector(vectorbase& vbTarget, int c1 = 0, int c2 = -1); // Get a subset of the vector.
	
	///Kyle 05/20/2010 ORG-154 GET_SUB_VECTOR_BY_INDICES
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:vectorbase-GetSubVector
	*/
	int	GetSubVector(vectorbase& vbTarget, const vector<uint>& vnIndices);
	///End GET_SUB_VECTOR_BY_INDICES

	// Comments last updated by ER on 12/29/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:vectorbase-SetSubVector
	*/
	int	SetSubVector(vectorbase& vbSource, int c1 = 0); // Set a subset of the vector.
	
	// Comments last updated by Cheney on 03/11/07
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:vectorbase-Average
	*/
	///Cheney 2007-3-10 MAKE_AVERAGE_IS_SAME_WITH_ADJECENT_SMOOTH 
	//void Average(vectorbase &vSource, int nLength, int nMethod = RECT_WINDOW); // Compute moving average
	void Average(vectorbase &vSource, int nLength, int nOption = EDGEPAD_NAN); // Compute moving average
	///end MAKE_AVERAGE_IS_SAME_WITH_ADJECENT_SMOOTH	

	// Comments last updated by Frank on 12/08/05
	///The return value not follow the code, I check the code, should return 0 if not found and return -1 if invalid case.
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:vectorbase-Find
	*/
	int Find(vector<uint>& vecIndex, double dLower, double dUpper = _ONAN, int nPrecision = 8, int iBegin = 0, int iEnd = -1); // Find indices of specified values in vector
	
		// Comments last updated by ER on 12/29/04
		/**+
		http://ocwiki.originlab.com/index.php?title=OriginC:vectorbase-Trim
		*/
	bool Trim(); // Remove all missing values from the vector.


	// Comments last updated by Joseph on 01/04/06
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:vectorbase-TrimLeft
	*/
 	int		TrimLeft(BOOL bShiftLeft = FALSE); // TrimLeft removes elements having the value NANUM from the left end of a Dataset.

 	// Comments last updated by Joseph on 01/04/06
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:vectorbase-TrimRight
	*/
 	int		TrimRight(BOOL bDelExtra = FALSE); // TrimRight removes elements having the value NANUM from the right end of a Dataset.
#endif // _OC_VER > 0x0703
	// Comments last updated by Frank on 04/30/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:vectorbase-RemoveAll
	*/
	void RemoveAll();
#if _OC_VER >= 0x0800
	// Comments last updated by Frank on 04/30/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:vectorbase-Replace
	*/
	BOOL	Replace( double dThresholdVal, double dReplaceVal = 0, uint wBitwiseOption = 0 );
#endif //_OC_VER >= 0x0800

	///Kyle 10/22/08 QA80-12415 P3  ADD_OVERLOAD_FUNCTION_REPLACE_TO_VECTORBASE
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:vectorbase-Replace
	*/
	int Replace(vector<uint>& vn, double dVal);
	///End ADD_OVERLOAD_FUNCTION_REPLACE_TO_VECTORBASE

	///Kyle 10/21/08 QA80-12415 P1 ADD_OVERROAD_FUNCTION_FIND_TO_VECTORBASE
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:vectorbase-Find
	*/
	int Find(uint wBitwiseOption, double dTestVal, vector<uint>& vn, int iBegin = 0, int iEnd = -1, double dTol = 0);
	///End ADD_OVERROAD_FUNCTION_FIND_TO_VECTORBASE

	/// YuI 07/18/08 QA70-11868 AUTOMATIC_GENERATION_OF_COMMENTS_FOR_XF_OUTPUTS
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:vectorbase-GetSourceDataRange
	*/
	DataRange	GetSourceDataRange();
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:vectorbase-GetOutputComment
	*/
	string		GetOutputComment();
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:vectorbase-SetOutputComment
	*/
	void		SetOutputComment(LPCSTR lpcszComment);
	/// end AUTOMATIC_GENERATION_OF_COMMENTS_FOR_XF_OUTPUTS
};

// Comments last updated by Joseph on 04/14/07
/**+
http://ocwiki.originlab.com/index.php?title=Category:vector_(class)
*/
class vector : public vectorbase
{

public:

	// Comments last updated by Frank on 04/30/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:vector-vector
	*/
	vector(); // Default constructor for vector class.
	
	// Comments last updated by Frank on 04/30/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:vector-vector
	*/
	vector(UINT nSize); // Constructor to create a vector having size nSize.

	// Comments last updated by Frank on 04/30/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:vector-vector
	*/
	vector(Dataset &ds, BOOL bRemoveMissingValues = FALSE); // Constructor to create a vector copy of an Origin Dataset.
	
#if  _OC_VER > 0x0703
	// Comments last updated by Frank on 04/30/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:vector-vector
	*/
	vector(Column& cc, int nLowerIndex = -1, int nUpperIndex = -1, int nWriteback = WRITEBACK_NO);
#endif //#if  _OC_VER > 0x0703

	// Comments last updated by Frank on 08/08/05
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:vector-vector
	*/
	vector(vector &vR, vector &vI); // Complex vector constructor.


	// Comments last updated by Frank on 04/30/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:vector-Add
	*/
	int Add(_TemplType element);
	
	// Comments last updated by Frank on 04/30/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:vector-SetAtGrow
	*/
	BOOL SetAtGrow(int nIndex, _TemplType element);

	// Comments last updated by Frank on 04/30/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:vector-InsertAt
	*/
	BOOL InsertAt(int nIndex, _TemplType element, int nCount = 1);

	// Comments last updated by Frank on 04/30/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:vector-RemoveAt
	*/
	BOOL RemoveAt( int nIndex, int nCount = 1 );
	
	///Kyle 03/02/2009 QA70-13202 ADD_OVERLOADING_METHOD_REMOVEAT_WITH_VECTOR_ARGUMENT
	/**$
	
	*/
	BOOL RemoveAt(const vector<int>& vnIndices);
	///End ADD_OVERLOADING_METHOD_REMOVEAT_WITH_VECTOR_ARGUMENT

	// Comments last updated by Frank on 04/30/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:vector-Find
	*/
	int Find(LPCSTR lpcsz, int nStartRow = 0, BOOL bCaseSensitive = false, BOOL bFullMatch = true, int nEndRow = -1);
	
	///Kyle 10/23/08 QA80-12415 P5 UPDATE_ROW_COL_RECT_ARRAYS
	/**$
		Update the current selected row indices with column from nColBegin to nColEnd to the vector ranges.
	Parameters:
		vnRowBegin=[output]vector of indices of the first rows in the selection
		vnColBegin=[output]vector of indices of the first columns in the selection
		vnRowEnd=[output]vector of indices of the last rows in the selection
		vnColEnd=[output]vector of indices of the last columns in the selection
		nColBegin=[input]the first column selected
		nColEnd=[input]the last column selected
	Returns:
		0 if OK, otherwise a negative value.
	*/
	int  UpdateRowColRanges(vector<int>& vnRowBegin,vector<int>& vnColBegin,vector<int>& vnRowEnd,vector<int>& vnColEnd, int nColBegin, int nColEnd);
	///End UPDATE_ROW_COL_RECT_ARRAYS

	///Kyle 11/07/08 QA70-12544 ADD_METHOD_INSERTVALUE_IN_VECTOR
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:vector-InsertValue
	*/
	int    InsertValue(vector<int> &vnIndices, double rValue);
	///End ADD_METHOD_INSERTVALUE_IN_VECTOR
	
#if  _OC_VER > 0x0703
	// Comments last updated by Joseph on 04/30/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:vector-GetSourceRange
	*/
	bool	GetSourceRange(int &nLower, int &nUpper);
#endif //#if  _OC_VER > 0x0703

///------ Folger 12/15/2010 ORG-1733 GETSUBVECTOR_NOT_WORK_FOR_VECTOR_STRING
#if		_OC_VER >= 0x0851
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:vector-GetSubVector
	*/
	int	GetSubVector(vector<string>& vsTarget, int c1 = 0, int c2 = -1);

	int	GetSubVector(vector<string>& vsTarget, const vector<uint>& vnIndices);
#endif	/// _OC_VER >= 0x0851
///------ End GETSUBVECTOR_NOT_WORK_FOR_VECTOR_STRING
};

// For testing files that are also compiled in MFC
// Comments last updated by Frank on 04/30/04
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:INTVEC
*/
#define INTVEC vector<int>
// Comments last updated by Frank on 04/30/04
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:REALVEC
*/
#define REALVEC	vector<double>
	

// Comments last updated by Joseph on 04/14/07
/**+
http://ocwiki.originlab.com/index.php?title=Category:Dataset_(class)
*/
class Dataset : public vector
{

public:
	
	// Comments last updated by Frank on 05/08/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Dataset-Dataset
	*/
	Dataset(); // Default constructor for Dataset class.
	
	// Comments last updated by Frank on 05/08/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Dataset-Dataset
	*/
	Dataset(LPCSTR lpcszDatasetName); // Constructor to create a Dataset from data set name.
	
	// Comments last updated by Frank on 05/08/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Dataset-Dataset
	*/
	Dataset(LPCSTR lpcszWksName, int nCol); // Constructor to create a Dataset from worksheet name and column number.

	// Comments last updated by Frank on 05/08/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Dataset-Dataset
	*/
	Dataset(Dataset dsOriginal); // Copy constructor for Dataset class.
	
	// Comments last updated by Frank on 05/08/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Dataset-Dataset
	*/
	Dataset(Worksheet &wks, int nCol); // Constructor to create a Dataset from worksheet object and column number.

	// Comments last updated by Frank on 05/08/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Dataset-Dataset
	*/
	Dataset(Column & col); // Constructor to create a Dataset from a Column object.

	/// YuI 11/23/09 QA70-13806 VIRTUAL_MATRIX_IMPLEMENTATION
#ifdef __VIRTUAL_MATRIX__
	Dataset(const DataRange& range);
#endif // __VIRTUAL_MATRIX__	
	/// end VIRTUAL_MATRIX_IMPLEMENTATION
	
	// Comments last updated by Frank on 05/08/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Dataset-Attach
	*/
	BOOL	Attach(LPCSTR lpcszDatasetName); // Attach Dataset object to an Origin data set identified by name.

	// Comments last updated by Frank on 05/08/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Dataset-Attach
	*/
	BOOL	Attach(LPCSTR lpcszWksName, int nCol); // Attach a Dataset object a worksheet column identified by worksheet name and column number.

	// Comments last updated by Frank on 05/08/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Dataset-Attach
	*/
	BOOL	Attach(Worksheet &wks, int nCol); // Attach a Dataset object to a worksheet column identified by Worksheet object and column number.

	// Comments last updated by Frank on 05/08/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Dataset-Attach
	*/
	BOOL	Attach(Column & col); // Attach a Dataset object to a worksheet column identified by a Column object.

	// Comments last updated by Frank on 05/08/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Dataset-Create
	*/
	BOOL	Create(int Size, UINT Option = 0, LPCSTR lpcszNamePrefix = NULL); // Create an internal Origin data set (may or may not be temporary).

	// Comments last updated by Frank on 05/08/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Dataset-Destroy
	*/
	void 	Destroy(); // Detach the Origin C Dataset object and Destroy (delete) the internal Origin data set.

	// Comments last updated by Frank on 05/08/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Dataset-Detach
	*/
	BOOL	Detach(); // Detach the Dataset object from an internal Origin data set.

	// Comments last updated by Frank on 05/08/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Dataset-SetText
	*/
	BOOL	SetText(int nRow, LPCSTR lpcszTextValue); // Set the text value of a cell in an Origin data set of type Text & Numeric.

	// Comments last updated by Frank on 05/08/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Dataset-GetText
	*/
	BOOL	GetText(int nRow, string& strTextVal); // Get the text value of a cell in an Origin data set of type Text & Numeric.

	// Comments last updated by Frank on 05/08/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Dataset-GetStringArray
	*/
	BOOL GetStringArray(vector<string>& as, int nRow1=0, int nRow2=-1); // Copy the contents of a Text Dataset into a StringArray.

	// Comments last updated by Frank on 05/08/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Dataset-PutStringArray
	*/
	BOOL PutStringArray(vector<string>& as, int nRow1=0); // Put (copy) the contents of a StringArray to a Text Dataset.

	// Comments last updated by Frank on 05/08/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Dataset-SetUpperBound
	*/
	BOOL 	SetUpperBound(int nUpper); // Set the upper display index of the Dataset.

	// Comments last updated by Frank on 05/08/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Dataset-SetLowerBound
	*/
	BOOL 	SetLowerBound(int nLower); // Set the lower display index of the Dataset.

	// Comments last updated by Frank on 05/08/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Dataset-GetName
	*/
	BOOL	GetName(string& strName); // Get the name of an internal Origin data set.

	// Comments last updated by Frank on 05/08/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Dataset-GetName
	*/
	string  GetName(); // Get the name of an internal Origin data set.

	// Comments last updated by Frank on 05/08/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Dataset-IsValid
	*/
	BOOL	IsValid(); // Checks the validity of an Origin C Dataset object.
	
	// Comments last updated by Frank on 05/08/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Dataset-Update
	*/
	void	Update(BOOL bFromOrigin, int mode = -1); // Update an Origin C Dataset object from an Origin data set or vice-versa. 

#ifdef _POST_ORIGIN7_
	/**#
	*/
	BOOL	Append(vectorbase& v, int iMode);
#else
	// Comments last updated by Frank on 05/08/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Dataset-Append
	*/
	BOOL	Append(vector& v, int iMode = REDRAW_NONE); // Append data from a vector or Dataset object to this Origin C Dataset object.
#endif //!_POST_ORIGIN7_

#if  !(_OC_VER > 0x0703)
 	// Comments last updated by Frank on 05/08/04
	/**#
			TrimLeft removes elements having the value NANUM from the left end or beginning  
			of the Dataset by advancing the lower index to the first valid numeric value. If 
			bShiftLeft is TRUE cells containing NANUM are deleted from the Dataset and a     
			lower index value of 0 is returned shifting numeric values left to the beginning 
			of the Dataset. When bShiftLeft is TRUE TrimLeft of Curve objects causes both X  
			and Y Datasets to be trimmed.
		Keywords:
			Dataset Missing value
		Example1:
			void Dataset_TrimLeft_ex1()
			{
				// a Worksheet with 2 columns must exist prior to execution
				Worksheet wks=Project.ActiveLayer();
				if (wks)
				{ 	
					string strWksname = wks.GetPage().GetName();
					Dataset	dsA(strWksname,0);
					dsA.TrimLeft(TRUE);

					string strWksColAname = wks.Columns(0).GetName();
					strWksColAname = wks.GetPage().GetName() + "_" + strWksColAname;
					
					string strWksColBname = wks.Columns(1).GetName();
					strWksColBname = wks.GetPage().GetName() + "_" + strWksColBname;
					
					Curve crvAxBy(strWksColAname,strWksColBname);
					crvAxBy.TrimLeft(TRUE);
					LT_execute("doc -uw");
				}
			}
		Parameters:
			bShiftLeft=[input] TRUE will delete cells on the left of (before) the first valid
				numeric value, FASLE will cause the lower bound or index to be adjusted      
				upward but no cells are deleted.
		Returns:
			Returns -1 on error, 0 on success, and N > 0 for number of cells deleted.
		SeeAlso:
			Dataset::TrimRight, vectorbase::GetLowerBound, vector::vector
	*/
 	int		TrimLeft(BOOL bShiftLeft = FALSE); // TrimLeft removes elements having the value NANUM from the left end of a Dataset.

	// Comments last updated by Frank on 05/08/04
 	/**#
			TrimRight removes elements having the value NANUM from the right end or bottom   
			of the Dataset by retarding the upper index to the last valid numeric value. If  
			bDelExtra is set to TRUE cells containing NANUM are deleted from the Dataset.    
			When bDelExtra is TRUE TrimRight of Curve objects causes both X and Y Datasets to
			be trimmed.
		Keywords:
			Dataset Missing Value
		Example1:
			void Dataset_TrimRight_ex1()
			{
				// a Worksheet with 2 columns must exist prior to execution
				Worksheet wks=Project.ActiveLayer();
				if (wks)
				{ 	
					string strWksname = wks.GetPage().GetName();			    
					Dataset	dsA(strWksname,0);
					dsA.TrimRight(TRUE);
					
					string strWksColAname = wks.Columns(0).GetName();
					strWksColAname = wks.GetPage().GetName() + "_" + strWksColAname;
					
					string strWksColBname = wks.Columns(1).GetName();
					strWksColBname = wks.GetPage().GetName() + "_" + strWksColBname;
					
					Curve crvAxBy(strWksColAname,strWksColBname);
					crvAxBy.TrimRight(TRUE);
					LT_execute("doc -uw");
				}
			}
		Parameters:
			bDelExtra=[input] TRUE will delete cells on the right of (after) the last 
			         valid numeric value, FASLE will cause the upper bound or index to be 
					 adjusted downward but no cells are deleted.
		Returns:
			Returns -1 on error, 0 on success, and N > 0 for number of cells deleted.
		SeeAlso:
			Dataset::TrimLeft, vectorbase::GetUpperBound, vectorbase::GetSize, vector::vector
	*/
 	int		TrimRight(BOOL bDelExtra = FALSE); // TrimRight removes elements having the value NANUM from the right end of a Dataset.

	/**$
	*/
	BOOL	PushUndo(int i1 = 0, int i2 = -1);
#endif  //!(_OC_VER > 0x0703)
};

// Comments last updated by Frank on 05/08/04
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:OVector
*/
#define  OVector Dataset

// Comments last updated by Joseph on 04/14/07
/**+
http://ocwiki.originlab.com/index.php?title=Category:CategoricalMap_(class)
*/
class CategoricalMap 
{
	
public:

	// Comments last updated by Frank on 05/08/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:CategoricalMap-CategoricalMap
	*/
	CategoricalMap();
	
 	// Comments last updated by Frank on 05/08/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:CategoricalMap-CategoricalMap
	*/
	CategoricalMap(CategoricalMap& cmMap);

	///------ Folger 12/07/2011 ORG-4545 OC_CATEGORICALMAP_INIT_FROM_DATASET
	/**$
	*/
	CategoricalMap(LPCSTR lpcszDataset, int nType = CMT_ORDINAL);
	///------ End OC_CATEGORICALMAP_INIT_FROM_DATASET
	
	// Comments last updated by Frank on 05/08/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:CategoricalMap-GetMapType
	*/
	int		GetMapType();

	///------ Folger 12/07/2011 ORG-4545 OC_CATEGORICALMAP_INIT_FROM_DATASET
	/**$
	*/
	int		GetValue(int nIndex);
	///------ End OC_CATEGORICALMAP_INIT_FROM_DATASET

	/**#
			Currently not supported.
	*/
	BOOL	SetAt(LPCSTR lpcszCategory, int iValue = 0);

	// Comments last updated by Frank on 05/08/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:CategoricalMap-ArrangeAZ
	*/
	void	ArrangeAZ(); // Sort this CategoricalMap in ascending order.

	// Comments last updated by Frank on 05/08/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:CategoricalMap-ArrangeZA
	*/
	void	ArrangeZA(); // Sort this CategoricalMap in descending order.

	// Comments last updated by Frank on 05/08/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:CategoricalMap-LookUp
	*/
	int		LookUp(LPCSTR lpcszCategory); // Look up a category in this CategoricalMap and return its index.

	// Comments last updated by Frank on 05/08/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:CategoricalMap-ReverseLookUp
	*/
	string	ReverseLookUp(int iVal); // Reverse look up an index in this CategoricalMap and return its category.
};

// Comments last updated by Joseph on 04/14/07
/**+
http://ocwiki.originlab.com/index.php?title=Category:CategoricalData_(class)
*/
class CategoricalData : public Dataset<int>
{

public:
	
	// Comments last updated by Frank on 05/08/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:CategoricalData-CategoricalData
	*/
	CategoricalData(); // Default constructor to create a CategoricalData object.

	// Comments last updated by Frank on 05/08/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:CategoricalData-CategoricalData
	*/
	CategoricalData(LPCSTR lpcszDatasetName, UINT wType = CMT_ORDINAL); // Constructor to create a CategoricalData object by data set name.

 	// Comments last updated by Frank on 05/08/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:CategoricalData-CategoricalData
	*/
	CategoricalData(LPCSTR lpcszWksName, UINT wColumnNumber, UINT wType); // Constructor to create a CategoricalData object by worksheet name and column number.

	// Comments last updated by Frank on 05/08/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:CategoricalData-Attach
	*/
	BOOL Attach(LPCSTR lpcszDatasetName, UINT wType); // Attach a CategoricalData object to an internal Origin data set

 	// Comments last updated by Frank on 05/08/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:CategoricalData-Attach
	*/
	BOOL Attach(LPCSTR lpcszWksName, UINT wColumnNumber, UINT wType); // Attach a CategoricalData object to an internal Origin data set by worksheet name and column number.

	// Comments last updated by Frank on 05/08/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:CategoricalData-Map
	*/
	CategoricalMap Map;

	// Comments last updated by Frank on 05/08/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:CategoricalData-Group
	*/
	int Group( vector& vIn, matrix& mOut, vector<int>& vColumnSize ); // Sort an input vector into columns in a matrix by this CategoricalData set.
};




/// TD 11-23-05 QA70-8321 SCREENPTS_CLASS_IN_OC
// Comments last updated by Joseph on 04/14/07
/**+
http://ocwiki.originlab.com/index.php?title=Category:GetGraphPoints_(class)
*/
class GetGraphPoints
{
public:
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GetGraphPoints-GetGraphPoints
	*/
	GetGraphPoints();

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GetGraphPoints-GetPoints
	*/
	BOOL GetPoints(int nPts, GraphLayer &gl = NULL, LPCSTR lpcszLTvarName = NULL);
	
	/// Hong 12/06/07 v8.0762 PFW_NEED_MORE_HINT_FOR_CURRENT_POINTS_IN_TOTAL
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GetGraphPoints-GetTotalPoints
	*/
	int GetTotalPoints();
	/// end PFW_NEED_MORE_HINT_FOR_CURRENT_POINTS_IN_TOTAL
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GetGraphPoints-SetFollowData
	*/
	BOOL SetFollowData(BOOL bFollow, int nPlot = -1);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GetGraphPoints-IsFollowData
	*/
	BOOL IsFollowData(DataPlot& dp); // if true, also return data plot
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GetGraphPoints-SetCursorPos
	*/
	BOOL SetCursorPos(double x, double y); 
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GetGraphPoints-GetCursorPos
	*/
	BOOL GetCursorPos(double& x, double& y, int* pnIndex=NULL);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GetGraphPoints-SetCursor
	*/
	BOOL SetCursor(int nType); 

	// property
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GetGraphPoints-bVertical
	*/
	BOOL bVertical; 
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GetGraphPoints-bHorizontal
	*/
	BOOL bHorizontal; 

	//results
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GetGraphPoints-GetData
	*/
	int GetData(vector& vx, vector& vy = NULL, vector<int>& vnDatapointIndices = NULL, vector<int>& vnDataplotIndices = NULL);

	
	// overridable
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GetGraphPoints-OnStart
	*/
	virtual void OnStart();

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GetGraphPoints-OnFinish
	*/
	virtual void OnFinish();


	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GetGraphPoints-OnNewPoint
	*/
	virtual void OnNewPoint(int nPoint);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GetGraphPoints-OnDisplay
	*/
	virtual void OnDisplay(string& str, int nPoint);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GetGraphPoints-OnCancel
	*/
	virtual void OnCancel();
};
/// end SCREENPTS_CLASS_IN_OC
#endif //_VECTOR_H
