/*------------------------------------------------------------------------------*
 * File Name: Tree_utils.h														*
 * Creation: CPY 3/17/03														*
 * Purpose: Origin C header for Tree and vsFlexGrid utilities that are 		 	*
 *	implemented in GetNBox.c													*
 * Copyright (c) OriginLab Corp.2003											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	RVD 9/3/2003 QA70-5078 v7.0682 PLOT_RANGE_APPLY								*
 *	CPY 10/21/03 QA70-4680 v7.5727 TREE_BRANCHESOPEN_CLOSE_REMEMBERED			*
 *	CPY v7.5785 12/19/03 QA70-5738 GETN_BOX_COMBO_CHANGE_NEEDED					*
 *  EJP 06-07-2004 v8.0853 QA70-6472 FILE_INFO_IN_PAGE							*
 *	Frank 06/16/04	v8.0890	TREE_SET_VALUE_FROM_VECTOR							*
 *	CPY SY 07/07/2004 QA70-6641 MOVE_OC_TREE_UTILITY_TO_VC_LEVEL				*
 *  Danice 9/24/04 QA70-6891 v8.0139 ADD_BRANCH_CONTROL							*
 *	YuI 10/03/04 QA70-4387 GETN_PICTURE_IMPLEMENTATION							*
 *	CPY 10/7/04 CHANGE_STR_LIST_TO_ENUM_LIST									*
 *	Frank 11/1/04	v8.0157	GET_NUMERICA_VECTOR_OR_MATRIX_FROM_TREENODE			*
 *  Danice 11/15/04 QA70-7169 v8.0163 TREE_ROW_SHOW_ALTERNATE_COLORS			*
 *  Danice 12/1/04 QA70-6891 v8.0168 GET_TREENODE_STOP_ATTRIBUTE_OPTION			*
 *  Frank 12/14/04 AUTO_SET_MULTILINE_EDIT_SHOW_RANGE							*
 *  Frank 12/15/04 TREE_GET_NODE_BY_NODEID_OR_DATAID							*
 *	CPY 1/7/05 DERIVED_PARAMETERS_READ_SAVE_PROBLEM								*
 *	YuI 01/03/2005 v7.5183 QA70-7253 VECTORIAL_NUMERIC_FUNCTIONS				*
 *  Forest 03/02/05 QA70-7456	COPY_TREE_USING_FILTER							*
 *  Frank 03/14/05 QA70-7470	REMOVE_ARGUMET_NOT_SECTION_IN_PAGE_INFO			*
 *  DG 3/17/05 v8.0206 CLEAN_DOUBLE_STORAGE										*
 *  DG 3/30/05 v8.0212 GETN_ADVANCED_SHOWN_IN_TREE								*
 * 	Frank 3/31/05 TREE_MOVE_NODE_TO_POSITION									*
 *	EJP 2005-03-31 v8.0214 QA70-6816 SHOW_IMPORT_FILE_INFO_IN_USER_VAR_DLG		*
 *  DG 4/1/05 v8.0213 ATTRIBUTE_EXIST_IN_TREE_NODE								*
 *  Forest 4/1/05 TREE_FILTER_BY_ATTRIB_MATCH									*
 *	Frank 4/5/05 GUI_ADVANCED_SETTING_FROM_FILE									*
 *	ML 4/15/2005 XVAR_DATA_CHANGE_ATT											*
 *  DG 4/20/05 v8.0223 REWRITE_TREE_GET_NODE									*
 *	Jasmine 09/17/05 v8.0308 SET_AND_GET_THEME_FILE_NAME						*
 *	Frank 10/17/05 ADD_DOUBLE_OUTPUR_FORMAT_IN_TREE_OUT							*
 *	Frank 11/05/05 GET_NODE_BY_ATTRIBUTE_OF_ROW									*
 *	Frank 11/21/05 HIDE_NODE_NAME_OUTPUT_TO_STR									*
 *	Kevin 11/24/05	ADD_TREE_FIND_MAX_DATA_ID_FUNCTION							*
 *	YuI 11/09/05 QA70-8279 REPORT_TREE_AND_REPORT_DATA_XVARIABLES				*
 *	ML 1/13/2006 XVARIABLEBASE_TO_VC											*
 *	ML 2/10/2006 QA70-8490 NEW_VC_TREE_CONTROL									*
 *	EJP 2006-07-07 v8.0440 QA70-8697 XFUNC_BASED_IMPORT							*
 *  Joe  7/17/06 HIDE_EMPTY_TABLE                                               *
 *  Hong 7/18/06 FIX_RETURN_ERROR												*
 *	Jasmine 01/17/07 GET_TREE_NODE_PATH											*
 *	Jasmine 01/17/07 QA70-9273 SHOW_USER_TREE_INFO_IN_USER_VAR_DLG				*
 *	EJP 2007-05-31 v8.0631 LOAD_REG_VALUE_NEED_DEFAULT							*
 *	Sim 06-07-2007 SUPPORT_RENAME_TREE_TAGNAME									*
 *	Hong 06/18/07 v8.0643 FIX_XF_SHOW_HELP_BY_LT_ERROR_SHOW_HIDDEN_NODE			*
 *	Jake 06/26/07 SUPPORT_COMBO_LIST_FOR_PATH									*
 *	Hong 09/08/07 v8.0699 MORE_OPTION_TO_DUMP_MAP_INFO_FOR_COMBO_NODE			*
 *	Arvin 01/07/08 QA70-10903 ADD_CHECK_ALL_BOX_FOR_BRANCH						*
 *	Folger 03/05/08 QA80-11192 CENTRALIZE_THEME_TREE_SETTING_KNOWLEDGE			*
 *	Hong 10/24/08 v8.0960b FIX_NEW_NLFIT_FUNCTION_LIST_LOST_ITEM_NEW_DOT_DOT_DOT*
 *	Kyle 10/31/08 QA80-12452  SUPPORT_INPUT_DATA_FORM_OPTION_FOR_NPH_TESTS		*
 *	Hong 11/14/08 v8.0971b DISABLE_OPTIONS_INSTEAD_OF_HIDDEN_IT_FOR_BASELINE_OUTPUT_OPTIONS
 *	Sim 12-23-2008 QA80-12836 SUPPORT_FILE_BROWSER_BUTTON						*
 *	Folger 03/18/09 QA80-13261-P2 NEW_ADDED_AUTO_FOR_XF_VARIABLE_FAILS_TO_COMPATIBLE_WITH_OLD_THEME
 *	Kyle 03/31/2009 QA80-3224 NEW_OPTION_TO_SUPPORT_LINEAR_FIT_WITH_ERROR_BAR	*
 *	Folger 04/15/09 QA80-13454 SPECIAL_ATTRIBUTES_SHOULD_BE_CORRECTLY_UPDATED_WHEN_USE_OLD_THEME_AND_OP
 *	Kenny 04/30/2009 ADD_OPTION_TO_OUT_TREE_TO_SUPPORT_MORE_OUTPUT_STYLE		*
 *	Sophy 8/7/2009 QA80-14101 SET_GETN_NODES_AS_UNDEFINED_WHEN_SEL_MULTI_COLS_WITH_DIFF_PROPERTY
 *	Kyle 08/26/2009 QA80-14190 DEFINE_VARIABLE_FROM_COLUMN_LABELS_IN_SCV_DB		*
 *	Kenny 12/22/2009 QA81-14748-P2 INSERT_USER_VAR_DLG_FAILS_TO_SHOW_MULTILINE_NODE*
 *	Kyle 02/04/2010 READ_SHEET_INPORT_FILE_INFO									*
 *	Kyle 01/17/2011 ORG-1941-P3 MORE_WORK_FOR_MOVING_HISTOGRAM_TO_VC			*
 *	Kyle 08/09/2011 ORG-3103-S1  SUPPORT_INPUT_DATA_FORM_OPTION_FOR_NPH_TESTS	*
 *	Hong 08/24/11 ORG-1864 FIX_PA_FAIL_APPLY_X_RANGE							*
 *	Bill 09/08/2011 ORG-3395 CUSTOMIZE_IMPORT_MENU_DIALOG						*
 *	Sim 2011-10-18 ORG-3798 FIX_REIMPORT_DATA_WHEN_TURN_ON_STRUCTURE_ONLY		*
 *	Sim 2011-11-04 ORG-4179-P2 DISABLE_TDM_REIMPORT_OPTIONS						*
 *	Folger 03/06/2012 ORG-4118 TREE_SWAP_NODE									*
 *	Folger 05/03/2012 ORG-5592-S1 ADD_DATA_IDENTIFIER_FOR_FITTING_TOOLS			*
 *------------------------------------------------------------------------------*/

#ifndef _TREE_UTILS.H
#define _TREE_UTILS.H

#include <Tree.h>
#include <settings.h>
#include <storage.h>

//----- CPY SY 07/07/2004 QA70-6641 MOVE_OC_TREE_UTILITY_TO_VC_LEVEL
#if _OC_VER >= 0x0800
	#define _TREE_UTILS_FROM_DLL
	#include <ocTreeUtils.h>
#else
enum {TREE_COPY_SKIP_HIDDEN = 0x0001, TREE_COPY_ATTRIB_ENABLE = 0x0002};
#endif //_OC_VER >= 0x0800
//----- end	MOVE_OC_TREE_UTILITY_TO_VC_LEVEL

/// ML 4/18/2005 XFUNCTION_TREE_MANIPULATION_IN_VC
/*
// const used in GetNBox for general purpose data type const
#define	TRGP_CHECK 		ONODETYPE_CHECKBOX
//---- CPY 10/7/04 CHANGE_STR_LIST_TO_ENUM_LIST, this seems very confusing with TRGP_STR_LIST used in GET_LIST, but we have a separate GET_STR_LIST
//#define TRGP_ENUM_COMBO	ONODETYPE_DROPDOWN_NUMERIC_FLOAT
//#define TRGP_STR_LIST	ONODETYPE_DROPLIST_STRINGS
#define TRGP_NUMERIC_LIST	ONODETYPE_DROPDOWN_NUMERIC_FLOAT
#define TRGP_ENUM_LIST		ONODETYPE_DROPLIST_STRINGS
// followings are kept in case users have harded these in their code
#define TRGP_ENUM_COMBO	TRGP_NUMERIC_LIST
#define TRGP_STR_LIST	TRGP_ENUM_LIST
//---- end CHANGE_STR_LIST_TO_ENUM_LIST
#define TRGP_STR		ONODETYPE_EDIT_BOX_ONELINE_TEXT
#define TRGP_DOUBLE		ONODETYPE_EDIT_BOX_NUMERIC_FLOAT
#define TRGP_COLOR		ONODETYPE_DROPLIST_COLORS
#define TRGP_RANGE		ONODETYPE_EDIT_RANGE
#define TRGP_BRANCH		ONODETYPE_BRANCH
#define	TRGP_INTERACTIVE	ONODETYPE_EDIT_BOX_INTERACTIVE
#define	TRGP_SLIDER		ONODETYPE_SLIDER
#define	TRGP_SLIDEREDIT	ONODETYPE_EDITSLIDER
#define	TRGP_DATA_RANGE	ONODETYPE_DATA_RANGE
#define	TRGP_MULTILINE_TEXT	ONODETYPE_MULTILINE_TEXT
#define TRGP_ORIGIN_TEXT	ONODETYPE_ORIGIN_TEXT

#define TRGP_SYSTEM_EVENTS			-100		///DG 3/30/05 GETN_ADVANCED_SHOWN_IN_TREE

/// YuI 01/03/2005 v7.5183 QA70-7253 VECTORIAL_NUMERIC_FUNCTIONS
#define	TRGP_XY_DATA_RANGE	ONODETYPE_XY_DATA_RANGE
/// end VECTORIAL_NUMERIC_FUNCTIONS
*/
/// end XFUNCTION_TREE_MANIPULATION_IN_VC

//------ Folger 03/05/08 QA80-11192 CENTRALIZE_THEME_TREE_SETTING_KNOWLEDGE
//move to oUtils.h
//#define THEME_TREE_SETTINGS		"Settings"
//------

///Frank 3/30/05	TREE_EDIT_SUPPORT_MOVE_ROWS
#define TEC_MOVE_ROWS_EDITABLE_ATTRIB		"MoveRows"
//End	TREE_EDIT_SUPPORT_MOVE_ROWS

#define STR_COMPLEX_ININAME_ATTRIBUTE		"ComplexIniName" ///Alex/Iris 11/10/06 FIX_COLOR_TRANSLATION_FOR_PDF
//#define AUTO_SET_TERM_MULTILINE_EDIT_RANGE			"AutoSet" //Frank 12/14/04 AUTO_SET_MULTILINE_EDIT_SHOW_RANGE
/// ML 4/18/2005 XFUNCTION_TREE_MANIPULATION_IN_VC
//#define STR_ATTRIB_MULTILINE_EDIT_DISPLAY_ROW_HEIGHT_RANGE		"RowHeightRange" //Frank v78.0 11/14/04 GETNBOX_JUSTIFICATION_AND_ENABLE_EDIT
/// end XFUNCTION_TREE_MANIPULATION_IN_VC

///------------- SY 03/25/2004 move to OCTreeUtils.h
///	#define	STR_REPEAT_ID_ATTRIB		"RepeatID"   ///Iris 03/02/05 QA70-7455
///	#define STR_THEME_TYPE_ATTRIB		"ThemeType"	 ///Iris 03/07/05 QA70-7345 ADD_FB_FILTER_THEME
///------------- 
/// YuI 10/03/04 QA70-4387 GETN_PICTURE_IMPLEMENTATION
#define TRGP_PICTURE	ONODETYPE_PICTURE_HOLDER
/// end GETN_PICTURE_IMPLEMENTATION
/// ML 1/13/2006 XVARIABLEBASE_TO_VC
//#define	STR_XF_VAR_IO_ATTRIB		"_XF_VAR_IO"		///----Frank 11/18/05 move to XFunction.h
//
//#define	STR_HIDE_NODE_NAME_ATTRIB		"HideNodeName"		///----Frank 11/21/05 HIDE_NODE_NAME_OUTPUT_TO_STR
/// end XVARIABLEBASE_TO_VC

/// Kenny 12/22/2009 QA81-14748-P2 INSERT_USER_VAR_DLG_FAILS_TO_SHOW_MULTILINE_NODE
#define IS_TEXT_NODE_ID(_nID)		\
			(TRGP_STR == (_nID) \
			|| ONODETYPE_EDIT_BOX_MULTILINE_TEXT == (_nID)	\
			|| ONODETYPE_MULTILINE_TEXT == (_nID)	\
			)
/// End QA81-14748-P2 INSERT_USER_VAR_DLG_FAILS_TO_SHOW_MULTILINE_NODE

///DG REWRITE_TREE_GET_NODE : use the same rule for adding tree node and getting tree node, work with a attribute string
enum TREENODEAddGetRules{
	///---this two options work with attribute, only one can be used at the same time
	//ATRN_SKIP_SUBNODE_WITH_MARKED  = 0x0,   	//default, meet node with attribute marked, stop go through it's subnode
	ATRN_LOOP_MARDED_NODE_ONLY   = 0x00010000, 	//only go through node with attribute marked
	///---
	ATRN_SKIP_LEAFS      = 0x00020000, 			//don't go through leafs
	ATRN_STOP_LEVEL      = 0x00040000, 			//use lobyte to indicate level to stop, stop level should >= 0, 0 = show up to 1st child branch
	ATRN_LAST_ENTRY,
};
///end REWRITE_TREE_GET_NODE

// Comments last updated by Kenny on 04/30/2009
// Comments last updated by Hong on 04/14/07
// Comments last updated by Frank on 03/17/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:out_tree_(global_function)
*/
///Kenny 04/30/2009 ADD_OPTION_TO_OUT_TREE_TO_SUPPORT_MORE_OUTPUT_STYLE
//bool out_tree(TreeNode& tr, int nLevel = 0);
bool out_tree(TreeNode& tr, bool bShowLine = true, bool bAlwaysShowTagName = false, string* pstrOut = NULL);
///End ADD_OPTION_TO_OUT_TREE_TO_SUPPORT_MORE_OUTPUT_STYLE

// Comments last updated by Hong on 04/14/07
// Comments last updated by Frank on 03/17/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tree_count_items_(global_function)
*/
int tree_count_items(TreeNode& tr, int* lpnSections = NULL);

// Comments last updated by Hong on 04/14/07
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tree_count_items_by_attribute_(global_function)
*/
/// Hong 05/26/07 v8.0870 IRIS_REQUIRE_VERSION_NO_RECURSIVE
//int tree_count_items_by_attribute(TreeNode& tr, LPCSTR lpcszAttribute = NULL, LPCSTR lpcszValue = NULL, bool bMissingIsMatch = true);
int tree_count_items_by_attribute(TreeNode& tr, LPCSTR lpcszAttribute = NULL, LPCSTR lpcszValue = NULL, bool bMissingIsMatch = true, bool bRecursive = true);
/// end IRIS_REQUIRE_VERSION_NO_RECURSIVE

// Comments last updated by Frank on 03/17/2005
/** >Tree
		Get TreeNode by provided Row and search stop level. Find TreeNode from 0 level.
	Parameters:
		trRoot=[Input]TreeNode to be searched
		nRow=[Input]to find the nRow TreeNode from up to down, 0 based offset
		nStopLevel=[Input]specify the stop level in TreeNode to search
		lpcszSkipSubTreeAttrib = [input] if no NULL, skip the arrribute of sub tree, If NULl, do nothing
		nCurrentLevel = [input] middle variable, unmeaning for user
		lpInc = [input]	middle variable, unmeaning for user
	Example1:
		void tree_get_node_ex1()
		{
			Tree tr;
			tr.Math.Score.dVal = 90.5;
			tr.Math.Score.Grade.strVal = "Good";	
			tr.Math.Bookname.strVal = "Advanced Math";
			tr.English.Score.dVal = 95.5;
			tr.English.Score.SetAttribute(STR_STOP_ATTRIB, "stop");
			tr.English.Bookname.strVal = "English 1";
			
			TreeNode trNode = tree_get_node(tr, 2); //trNode is Math.Score.Grade
			printf("%s = %s\n", trNode.tagName, trNode.strVal);
			
			trNode = tree_get_node(tr, 2, 1); //trNode is Math.Bookname
			printf("%s = %s\n", trNode.tagName, trNode.strVal);
			
			trNode = tree_get_node(tr, 5, 2, false); //trNode is English.Score
			printf("%s = %s\n", trNode.tagName, trNode.strVal);
			
			trNode = tree_get_node(tr, 5, 2, true); //trNode is English.Bookname since English.Score node have Stop attribute
			printf("%s = %s\n", trNode.tagName, trNode.strVal);
		}
	Return:
		found TreeNode, invalid if not found	
*/
//TreeNode tree_get_node(TreeNode& trRoot, int nRow, int nStopLevel = -1, int nCurrentLevel = 0, int* lpInc = NULL);	///Danice GET_TREENODE_STOP_ATTRIBUTE_OPTION
//TreeNode tree_get_node(TreeNode& trRoot, int nRow, int nStopLevel = -1, bool bCheckSkipSubTreeAttrib=false, LPCSTR lpcstrSkipSubTreeAttrib=NULL, int nCurrentLevel = 0, int* lpInc = NULL); //DG change lpcstrStopAttribute to lpcstrSkipSubTreeAttrib ///DG CLEAN_DOUBLE_STORAGE
//TreeNode tree_get_node(TreeNode& trRoot, int nRow, int nStopLevel = -1, LPCSTR lpcszSkipSubTreeAttrib=NULL, int nCurrentLevel = 0, int* lpInc = NULL);	///DG 3/18/05 CLEAN_DOUBLE_STORAGE

/** >Tree
		Get TreeNode by provided Row and search stop level. Find TreeNode from 0 level.
	Parameters:
		trRoot=[Input]TreeNode to be searched
		nRow=[Input]to find the nRow TreeNode from up to down, 0 based offset
		nStopLevel=[Input]specify the stop level in TreeNode to search
		lpcszStopAttribute = [input] if NULL(or Empty), do nothing, if not NULL(and not Empty), work with bStopAtLastBranch
		bStopAtLastBranch = [input] work with lpcszStopAttribute
		if bStopAtLastBranch is false and lpcszStopAttribute is not NULL(and not Empty), don't go through the subnode of this branch
		if bStopAtLastBranch is true and lpcszStopAttribute is not NULL(and not Empty), go through the node with this attribute
		if bStopAtLastBranch is true and lpcszStopAttribute is NULL(or Empty), will only go through branch node, skip leaf
		nCurrentLevel = [input] middle variable, unmeaning for user
		lpInc = [input]	middle variable, unmeaning for user
	Example1:
		void tree_get_node_ex1()
		{
			Tree tr;
			tr.Math.Score.dVal = 90.5;
			tr.Math.Score.Grade.strVal = "Good";	
			tr.Math.Bookname.strVal = "Advanced Math";
			tr.English.Score.dVal = 95.5;
			tr.English.Score.SetAttribute(STR_STOP_ATTRIB, "stop");
			tr.English.Bookname.strVal = "English 1";
			
			TreeNode trNode = tree_get_node(tr, 2); //trNode is Math.Score.Grade
			printf("%s = %s\n", trNode.tagName, trNode.strVal);
			
			trNode = tree_get_node(tr, 2, 1); //trNode is Math.Bookname
			printf("%s = %s\n", trNode.tagName, trNode.strVal);
			
			trNode = tree_get_node(tr, 5, 2, NULL); //trNode is English.Score
			printf("%s = %s\n", trNode.tagName, trNode.strVal);
			
			trNode = tree_get_node(tr, 5, 2, NULL); //trNode is English.Bookname since English.Score node have Stop attribute
			printf("%s = %s\n", trNode.tagName, trNode.strVal);
		}
	Return:
		found TreeNode, invalid if not found	
*/
//TreeNode tree_get_node(TreeNode& trRoot, int nRow, int nStopLevel=-1, LPCSTR lpcszStopAttribute = NULL, bool bStopAtLastBranch = false, int nCurrentLevel = 0, int* lpInc = NULL);

///DG REWRITE_TREE_GET_NODE
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tree_get_node_(global_function)
*/
TreeNode tree_get_node(TreeNode& trRoot, int nRow, DWORD dwCntrl=0, LPCSTR lpcszAttribute=NULL);
///end REWRITE_TREE_GET_NODE

// Comments last updated by Frank on 03/17/2005
//------ CPY 5/24/04 CHANGE_PARAM_NEED_REUSE_TREE
// call this function to get a node and it will add if not present
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tree_check_get_node_(global_function)
*/
TreeNode tree_check_get_node(TreeNode& tr, LPCSTR lpcszTag, int nID = 0, LPCSTR lpcszAttribName = NULL, LPCSTR lpcszAttribVal = NULL);
//------

///Sophy 10/18/2010 ORG-1277 ADO_DATABASEIMPORT_NEED_GET_NODE_BY_LABEL
/**$
	This function is for interal use.
*/
TreeNode tree_check_get_node_by_label(TreeNode& tr, LPCSTR lpcszLabel, BOOL bCaseSensitive = FALSE);
///end ADO_DATABASEIMPORT_NEED_GET_NODE_BY_LABEL

// Comments last updated by Hong on 04/14/07
// Comments last updated by Hong on 12/30/06
///Alex 08/23/06 ADD_FIND_ADN_CREATE_TREE_BY_DATAID
// call this function to get a node and it will add if not present
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tree_check_get_node_by_dataid_(global_function)
*/
TreeNode tree_check_get_node_by_dataid(TreeNode& trParent, LPCSTR lpcszTag, int nDataID, LPCSTR lpcszLableAttrib = NULL, LPCSTR lpcszAttribVal = NULL); 
/// SY 07/15/2004 QA70-6641 MOVE_OC_TREE_UTILITY_TO_VC_LEVEL
// move to ocTreeUtils.h
//enum {TREE_COPY_SKIP_HIDDEN = 0x0001, TREE_COPY_ATTRIB_ENABLE = 0x0002};
/// end MOVE_OC_TREE_UTILITY_TO_VC_LEVEL

// Comments last updated by Hong on 04/14/07
// Comments last updated by Iris on 01/05/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tree_copy_values_(global_function)
*/
int tree_copy_values(const TreeNode& trSrc, TreeNode& trDest, WORD wOptions = TREE_COPY_SKIP_HIDDEN | TREE_COPY_ATTRIB_ENABLE);

// Comments last updated by Iris on 01/05/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tree_node_copy_attribute_(global_function)
*/
bool tree_node_copy_attribute(const TreeNode& trSrc, TreeNode& trDest, LPCSTR lpcszAttribute);

// Comments last updated by Iris on 01/05/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tree_remove_attribute_(global_function)
*/
int tree_remove_attribute(TreeNode& tr, LPCSTR lpcszAttribute);

//#define STR_ENABLE_ATTRIB		"Enable"
//#define	STR_SHOW_ATTRIB		"Show"
//#define STR_CHANGED_ATTRIB	"OldValue"
/// RVD 9/3/2003 QA70-5078 v7.0682 PLOT_RANGE_APPLY
#define	STR_PLOT_VIEW		"View"
#define	STR_PLOT_SETUP_DLG	"PlotSetupDlg"
/// end PLOT_RANGE_APPLY

/// ML 2/10/2006 QA70-8490 NEW_VC_TREE_CONTROL
//#define STR_COMBO_CHANGED	"ComboChanged" //---- CPY v7.5785 12/19/03 QA70-5738 GETN_BOX_COMBO_CHANGE_NEEDED
/// end NEW_VC_TREE_CONTROL

// Comments last updated by Iris on 01/05/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tree_node_changed_(global_function)
*/
bool tree_node_changed(TreeNode& trNode, bool bSet = false, LPCSTR lpcszOldValue = NULL);

// Comments last updated by Iris on 01/05/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tree_update_changes_(global_function)
*/
int tree_update_changes(TreeNode& tr, const vector<string>& vs);

// Comments last updated by Iris on 01/05/2005
/** >Tree
		Set numeric value as well as putting a descriptive string to the node
	Parameters:
		tr=[Input]TreeNode to set
		dVal=[Input]a numerical value to set
		lpcszLabel=[Input]a text label to associate
	Example1:
		tree_node_set_value(trCalculation.t, tvalue, "t-Value");	
	Return:
		false if tr is invalid
*/
//bool tree_node_set_double(TreeNode& tr, double dVal, LPCSTR lpcszLabel);

// Comments last updated by Hong on 04/14/07
// Comments last updated by Iris on 01/05/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tree_node_get_int_(global_function)
*/
int tree_node_get_int(TreeNode& tr, int nDefault = 0);

// Comments last updated by Iris on 01/05/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tree_get_node_names_(global_function)
*/
void tree_get_node_names(TreeNode& tr, vector<string>& vs, bool bSubNodeOnly=false);

// Comments last updated by Iris on 01/05/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tree_get_values_(global_function)
*/
void tree_get_values(TreeNode& tr, vector<string>& vs, bool bSubNodeOnly=false);

// Comments last updated by Iris on 01/07/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tree_get_attributes_(global_function)
*/
void tree_get_attributes(TreeNode& tr, vector<string>& vs, LPCSTR lpcszAttribute, bool bSubNodeOnly=false);

// Comments last updated by Iris on 01/07/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tree_get_project_folders_and_pages_(global_function)
*/
bool tree_get_project_folders_and_pages(TreeNode &tr, DWORD dwPageTypeFilter = 0);
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tree_get_folders_and_pages_(global_function)
*/
//bool tree_get_folders_and_pages(TreeNode& trParent, Folder& fldFolder, DWORD dwPageTypeFilter = 0);
int tree_get_folders_and_pages(Folder& fldFolder, TreeNode& trParent, TreeNode &trNewFolder, DWORD dwPageTypeFilter = 0);

// Comments last updated by Iris on 01/07/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tree_clear_all_value_(global_function)
*/
void tree_clear_all_value(TreeNode& tr);

// Comments last updated by Iris on 02/25/2005
/**$ >Tree
		Get TreeNode by attribute and its value. Once TreeNode found, it returns.
	Parameters:
		tr=[input]TreeNode to walk
		lpcszAttribute=[input]attribute to be used
		lpcszAttribVal=[input]attribute value to match
		bRecursive=[input]true, go through all the tree node in tr;
					false, just go through the Children of tr
		bCaseSensitive=[input]true, compare the attribute value case sensitive, false, not case sensitive
	Return:
		Return the TreeNode be found,  invalid tree node if not found.	
	SeeAlso:
		tree_get_node_by_id
*/

/// YuI 11/01/04 VC_IMPLEMENTED_FindNodeByAttribute_NEED_RECURSION
// this function is obsolete
// use member unfction of TreeNode FindNodeByAttribute instead
//	TreeNode tree_get_node_by_attributes(TreeNode tr, LPCSTR lpcszAttribute, LPCSTR lpcszAttributeVal, bool bRecursive = true, bool bCaseSensitive = false);
/// end VC_IMPLEMENTED_FindNodeByAttribute_NEED_RECURSION

///DG ATTRIBUTE_EXIST_IN_TREE_NODE
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tree_check_attribute_value_exist_(global_function)
*/
bool tree_check_attribute_value_exist(const TreeNode& tr, LPCSTR lpcszVal, LPCSTR lpcszAttrib, bool bCaseSensitive=false, bool bRecursive=false);
///end ATTRIBUTE_EXIST_IN_TREE_NODE

// Comments last updated by Hong on 04/14/07
// Comments last updated by Iris on 01/07/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tree_get_node_by_id_(global_function)
*/
TreeNode tree_get_node_by_id(const TreeNode& tr, int nID, bool bRecursive = false);

//CPY 7/12/04 QA70-6641 this function was replaced by internal VC function, so need to check if Auto testing included this
// Comments last updated by Iris on 02/25/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tree_copy_values_to_attributes_(global_function)
*/
bool tree_copy_values_to_attributes(TreeNode& trSrc, TreeNode& trDest, LPCSTR lpcsz2ndAttributeToTransfer = NULL, LPCSTR lpcszDestAttribute = NULL, LPCSTR lpcszAttributeToMatch = NULL, bool bRecursive = true, bool bAllMatched = true, bool bCaseSensitive = false);

// Comments last updated by Iris on 01/07/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tree_set_attributes_(global_function)
*/
bool tree_set_attributes(TreeNode& trDest, const vector<int>& vnAttributeVals, LPCSTR lpcszValToCopy, LPCSTR lpcszDestAttribute = NULL, LPCSTR lpcszAttributeToMatch = NULL, bool bRecursive = true);

// Comments last updated by Hong on 04/14/07
// Comments last updated by CPY 4/22/05 QA70-7651 DESC_STATS_ON_ROWS_CLEAN
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tree_GETN_reset_hidden_values_(global_function)
*/
int tree_GETN_reset_hidden_values(TreeNode& tr, const vector<int>& vnDataIDsToReset, bool bRecursive = true);

// Comments last updated by Hong on 04/14/07
// Comments last updated by Iris on 02/25/2005
//----- CPY 6/16/04 QA70-6294 OC_INPUT_DATA_NODE_CLEANUP
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tree_set_attribute_to_all_nodes_(global_function)
*/
//void tree_set_attribute_to_all_nodes(TreeNode& tr, LPCSTR lpcszAttrib, LPCSTR lpcszAttribVal, bool b1stLevelChildrenOnly = false)		///Danice 9/24/04 ADD_BRANCH_CONTROL
void tree_set_attribute_to_all_nodes(TreeNode& tr, LPCSTR lpcszAttrib, LPCSTR lpcszAttribVal, bool b1stLevelChildrenOnly = false, bool bBranchOnly = false);
//-----
#ifdef _ORGOBJ_H

// Comments last updated by Iris on 02/25/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Tree_add_info_(global_function)
*/
bool tree_add_info(TreeNode& trNode, const OriginObject& orgObj, LPCSTR lpcszObjName = NULL, LPCSTR lpcszObjLabel = NULL, int nObjIndex = -1);
#define NPLOT_FOR_WKS 100000	// a large enough number that is impossible for plot index

#endif //_ORGOBJ_H

// For reading/writing to/from ini files
#define SZ_TREE_INI_SECTION_NODE_PREFIX "section"
#define SZ_TREE_INI_KEY_NODE_PREFIX "key"

// Comments last updated by Iris on 02/25/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tree_get_ini_section_(global_function)
*/
TreeNode tree_get_ini_section(TreeNode &trIni, LPCSTR lpcszSection);

// Comments last updated by Iris on 02/25/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tree_read_ini_(global_function)
*/
bool tree_read_ini(TreeNode &trIni, LPCSTR lpcszFile);

// Comments last updated by Iris on 02/25/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tree_read_ini_(global_function)
*/
bool tree_read_ini(TreeNode &trIni, INIFile &iniFile);

// Comments last updated by Iris on 02/25/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tree_read_ini_section_(global_function)
*/
bool tree_read_ini_section(TreeNode &trIni, LPCSTR lpcszFile, LPCSTR lpcszSection);

// Comments last updated by Iris on 02/25/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tree_read_ini_section_(global_function)
*/
bool tree_read_ini_section(TreeNode &trIni, INIFile &iniFile, LPCSTR lpcszSection);

// Comments last updated by Iris on 02/25/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tree_write_ini_(global_function)
*/
bool tree_write_ini(TreeNode &trIni, LPCSTR lpcszFile, bool bClearSections=false, bool bLabelAsKey = true);

// Comments last updated by Iris on 02/25/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tree_write_ini_(global_function)
*/
bool tree_write_ini(TreeNode &trIni, INIFile &iniFile, bool bClearSections=false, bool bLabelAsKey = true);

// Comments last updated by Iris on 02/25/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tree_write_ini_section_(global_function)
*/
bool tree_write_ini_section(TreeNode &trIniSection, INIFile &iniFile, bool bClearSection=false, bool bLabelAsKey = true);

// Comments last updated by Iris on 02/25/2005
/// EJP 06-07-2004 v8.0853 QA70-6472 FILE_INFO_IN_PAGE
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tree_get_binary_storage_(global_function)
*/
bool tree_get_binary_storage(TreeNode& trn, OriginObject& ObjSource, LPCSTR lpcszName);

// Comments last updated by Iris on 02/25/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tree_put_binary_storage_(global_function)
*/
bool tree_put_binary_storage(TreeNode& trn, OriginObject& ObjTarget, LPCSTR lpcszName);
/// end FILE_INFO_IN_PAGE

// Comments last updated by Iris on 02/25/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tree_read_image_export_settings_(global_function)
*/
bool tree_read_image_export_settings(TreeNode &trSettings, LPCSTR lpcszFormat);

// Comments last updated by Iris on 02/25/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tree_write_image_export_settings_(global_function)
*/
bool tree_write_image_export_settings(TreeNode &trSettings, LPCSTR lpcszFormat, bool bClearSections=false);

// Comments last updated by Iris on 02/25/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tree_get_page_image_export_settings_(global_function)
*/
bool tree_get_page_image_export_settings(TreeNode &trSettings, Page &pg, LPCSTR lpcszFormat);

// Comments last updated by Iris on 02/25/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tree_set_page_image_export_settings_(global_function)
*/
///Frank 03/14/05 QA70-7470	REMOVE_ARGUMET_NOT_SECTION_IN_PAGE_INFO	
//bool tree_set_page_image_export_settings(TreeNode &trSettings, Page &pg, LPCSTR lpcszFormat, bool bClearSection=false);
bool tree_set_page_image_export_settings(TreeNode &trSettings, Page &pg, LPCSTR lpcszFormat);
///End	REMOVE_ARGUMET_NOT_SECTION_IN_PAGE_INFO	
// Comments last updated by Iris on 02/25/2005
/**$
		It dumps into the appropriate output (output log and/or note window) according to the
		settings in the tree the trRep.Contents.Header.Table branch.
	Paratemers:
		trRep = [input]the Reporting branch
	Return:
		true if OK, otherwise false.
*/
bool	tree_header_table_report(TreeNode &trRep);


// Comments last updated by Iris on 02/25/2005
/**$
		It retrieves the information from trRep.Settings about where the report should go
		(output log and/or a Note window) and how, and creates, if needed, the Note window
		for output.
	Paramaters:
		trRep = [input]the Reporting branch.
		dwTarget = [output] it receives the information about where the report should go as a
					combination of bits:
					enum {
						TYPETARGET_NAMED_WINDOW			= 0x00000002UL,		// to the particular Notes window
						TYPETARGET_OUTPUTLOG			= 0x00000004UL,		// to output log
					};
		strNoteWnd = [input]the name of the note window
		pbAppendToNote = [output]the address of a BOOL to optionally return the information whether the report should
						be appended to the note window or the current contents of the note window should be replaced.
	Return:
		true if OK, otherwise false.

*/
bool	tree_reporting_prepare_targets(TreeNode &trRep, DWORD &dwTarget, string &strNoteWnd, BOOL *pbAppendToNote = NULL);

enum {SETTINGS_MAIN, SETTINGS_GUI};

/**$ >Operation
*/
void 	save_default_settings(TreeNode& tr, LPCSTR lpcszClassName, int nCategory = SETTINGS_MAIN);


// Comments last updated by Iris on 02/25/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:save_default_checkboxes_(global_function)
*/
bool save_default_checkboxes(LPCSTR lpcszDlgName, const vector<byte>& vbValues, LPCSTR lpcszKey = NULL);

// Comments last updated by Iris on 02/25/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:load_default_checkboxes_(global_function)
*/
bool load_default_checkboxes(LPCSTR lpcszDlgName, vector<byte>& vbValues, LPCSTR lpcszValName = NULL);

/**$
*/
bool dlg_save_to_registry(LPCSTR lpcszSecName, LPCSTR lpcszValName, DWORD dwVal);
/**$
*/
/// EJP 2007-05-31 v8.0631 LOAD_REG_VALUE_NEED_DEFAULT
///bool dlg_load_registry(LPCSTR lpcszSecName, LPCSTR lpcszValName, DWORD& dwVal);
bool dlg_load_registry(LPCSTR lpcszSecName, LPCSTR lpcszValName, DWORD& dwVal, DWORD dwDefault = 0);
/// end LOAD_REG_VALUE_NEED_DEFAULT

///Frank 11/10/04 v8.0160 QA70-6086   REMEMBER_LAST_USE_FUNCTION
/**$
*/
bool dlg_save_to_registry(LPCSTR lpcszSecName, LPCSTR lpcszValName, LPCSTR lpcszVal);

/**$
*/
/// EJP 2007-05-31 v8.0631 LOAD_REG_VALUE_NEED_DEFAULT
///bool dlg_load_registry(LPCSTR lpcszSecName, LPCSTR lpcszValName, string& strVal);
bool dlg_load_registry(LPCSTR lpcszSecName, LPCSTR lpcszValName, string& strVal, LPCSTR lpcszDefault = NULL);
/// end LOAD_REG_VALUE_NEED_DEFAULT
///End  REMEMBER_LAST_USE_FUNCTION

// Comments last updated by Joseph on 08/1/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tree_get_values_with_ids_(global_function)
*/
int tree_get_values_with_ids(const TreeNode& trSetting, vector<int>& vnIDs, vector<string>& vsValues, bool bIncludeSub = true
#ifdef  _TREE_UTILS_FROM_DLL
 		///Frank 3/2/05 QA70-7455	COPY_TREE_SUPPORT_DUPLICATE_ID_WITH_REPEAT_ATTRIB
 		//,bool bCheckChange = false);
 		,bool bCheckChange = false, int nRepeatBranchID =0);
 		///End	COPY_TREE_SUPPORT_DUPLICATE_ID_WITH_REPEAT_ATTRIB
#else  //_TREE_UTILS_FROM_DLL
		///Frank 3/2/05 QA70-7455	COPY_TREE_SUPPORT_DUPLICATE_ID_WITH_REPEAT_ATTRIB
		//);
		, int nRepeatBranchID =0);
		///End	COPY_TREE_SUPPORT_DUPLICATE_ID_WITH_REPEAT_ATTRIB
#endif//  _TREE_UTILS_FROM_DLL


/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tree_get_values_with_ids_and_labels_(global_function)
*/
int tree_get_values_with_ids_and_labels(const TreeNode& trSetting, vector<int>& vnIDs, vector<string>& vsValues, vector<string>& vsLabels, bool bIncludeSub = true, bool bCheckChange = false, int nRepeatBranchID =0);

// Comments last updated by Hong on 04/14/07
// Comments last updated by Frank on 03/2/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tree_set_values_by_ids_(global_function)
*/
///Frank 3/2/05 QA70-7455	COPY_TREE_SUPPORT_DUPLICATE_ID_WITH_REPEAT_ATTRIB
//int tree_set_values_by_ids(TreeNode& trSetting, const vector<int>& vnIDs, const vector<string>& vsValues);
///------ Folger 03/18/09 QA80-13261-P2 NEW_ADDED_AUTO_FOR_XF_VARIABLE_FAILS_TO_COMPATIBLE_WITH_OLD_THEME
//int tree_set_values_by_ids(TreeNode& trSetting, const vector<int>& vnIDs, const vector<string>& vsValues, int nRepeatBranchID = 0, int* pnDuplicateID = NULL);
///------ Folger 04/15/09 QA80-13454 SPECIAL_ATTRIBUTES_SHOULD_BE_CORRECTLY_UPDATED_WHEN_USE_OLD_THEME_AND_OP
//int tree_set_values_by_ids(TreeNode& trSetting, const vector<int>& vnIDs, const vector<string>& vsValues, int nRepeatBranchID = 0, int* pnDuplicateID = NULL, BOOL bResetAutoIfNeeded = FALSE);
int tree_set_values_by_ids(TreeNode& trSetting, const vector<int>& vnIDs, const vector<string>& vsValues, int nRepeatBranchID = 0, int* pnDuplicateID = NULL, DWORD dwCntrl = 0);
///------ End SPECIAL_ATTRIBUTES_SHOULD_BE_CORRECTLY_UPDATED_WHEN_USE_OLD_THEME_AND_OP
///------ End NEW_ADDED_AUTO_FOR_XF_VARIABLE_FAILS_TO_COMPATIBLE_WITH_OLD_THEME
///End	COPY_TREE_SUPPORT_DUPLICATE_ID_WITH_REPEAT_ATTRIB

// Comments last updated by Iris on 02/25/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tree_copy_values_by_id_(global_function)
*/
int tree_copy_values_by_id(const TreeNode& trSrc, TreeNode& trDest);

// Comments last updated by Joseph on 06/19/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tree_save_values_with_ids_(global_function)
*/
/// TD 5-4-07 QA80-9724 THEME_TREE_WITH_LABELS_FOR_READABILITY
//bool tree_save_values_with_ids(LPCSTR lpcszFilename, const vector<int> vnIDs, const vector<string>& vsValues, LPCSTR lpcszTreeNodeComment = NULL);
bool tree_save_values_with_ids(LPCSTR lpcszFilename, const vector<int> vnIDs, const vector<string>& vsValues, const vector<string>& vsLabels, LPCSTR lpcszTreeNodeComment = NULL);
/// end THEME_TREE_WITH_LABELS_FOR_READABILITY

// Comments last updated by Iris on 02/25/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tree_read_values_with_ids_(global_function)
*/
bool tree_read_values_with_ids(LPCSTR lpcszFilename, vector<int>& vnIDs, vector<string>& vsValues,string &strComment = NULL);


//---- end TREE_BRANCHESOPEN_CLOSE_REMEMBERED

//---- CPY 10/21/03 QA70-4680 v7.5727 TREE_BRANCHESOPEN_CLOSE_REMEMBERED
// following class written by Xuan Sun

/**+
http://ocwiki.originlab.com/index.php?title=Category:BitsHex_(class)
*/
class BitsHex
{
public:
	// Comments last updated by Iris on 04/07/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:BitsHex-BitsToHexStr
	*/
	bool BitsToHexStr(const vector<byte>& vn, string& strHex)
	{
		byte bb=0;
		byte bTemp=0;
		int jj=0;
		strHex.Empty();
		for(int ii=0;ii<vn.GetSize();ii++)
		{
			bTemp=vn[ii];
			bTemp<<=(7-jj);
			bb=bb|bTemp;
			jj+=1;
			
			//Convert every 4 bytes to one hex char
			if(jj>=4 || ii==(vn.GetSize()-1))
			{
				strHex += byteToHex(bb);
				jj=0;
				bb=0;
			}
		}
		
		return true;
	}
	
	// Comments last updated by Iris on 04/07/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:BitsHex-HexStrToBits
	*/
	bool HexStrToBits(const string& strHex, vector<byte>& vn)
	{	
		int nHex;
		char cHex;
		byte bTest;
		vn.SetSize(0);
		for(int ii=0; ii<strHex.GetLength(); ii++)
		{
			cHex = strHex[ii];
			
			// convert the hex to int first
			nHex = hexToInt(cHex);
			
			if (nHex<0)
				return false;
			
			bTest=1;
			bTest<<=3;
			for(int jj=0; jj<4; jj++)
			{
				//put 1's and 0's in the vector
				vn.Add((nHex&bTest)?1:0);
				bTest>>=1;
				//printf("%d",vn[vn.GetSize()-1]);
			}
		}
		//printf("\n");
		return true;
	}

	// Comments last updated by Iris on 04/07/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:BitsHex-vector_out
	*/
	void vector_out(const vector<byte>& vn)
	{
		for(int ii = 0; ii < vn.GetSize(); ii++)
			printf("%d", vn[ii]);
		printf("\n");
	}
private:

	// Comments last updated by Iris on 04/07/2005
	/**
		convert a hex to an int(0 to 15) 
	Parameters:
		cHex = [input]a hex char
	Return:
		an integer from 0 to 15, if error return -1
	*/
	int hexToInt(char cHex)
	{
		int nInt;
		if(cHex>='0' && cHex<='9')
			nInt = cHex - '0';
		
		else if(cHex>='a' && cHex<='z')
			nInt = cHex - 'a' + 10;
		
		else if(cHex>='A' && cHex<='Z')
			nInt = cHex - 'A' + 10;
		
		else
			return -1;
		
		return nInt;
	}

	// Comments last updated by Iris on 04/07/2005
	/**
		use the high four bits to convert to a hex char
	Parameters:
		bb = [input]a byte value
	Return:
		a hex char
	*/
	char byteToHex(byte bb)
	{
		char cHex;
		byte bTest = 1;
		bTest<<=4;
		int nConvert=0;
		
		for(int ii=0; ii<4; ii++)
		{
			if(bTest&bb)
			{
				// convert byte to int first
				nConvert += 1<<ii;
			}
			
			bTest<<=1;
		}
		
		if(nConvert<=9)
		{
			cHex = '0'+ nConvert;
		} 
		else
		{
			cHex = 'A'+ (nConvert-10);
		}
		
		return cHex;
	}

};
// Comments last updated by Hong on 04/14/07
// Comments last updated by Iris on 02/25/2005
//----------- CPY 6/15/04 QA70-6294 OC_DATA_PLOT_SEL_INFO_CONSOLIDATION
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tree_get_next_enum_tag_name_(global_function)
*/
int tree_get_next_enum_tag_name(const TreeNode& tr, string& strTag = NULL);
//------------

// Comments last updated by Iris on 02/25/2005
//------- CPY 8/30/04 QA70-6667 RESULT_SHEET_QUERY
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tree_append_children_(global_function)
*/
int tree_append_children(TreeNode& tr1, const TreeNode& tr2, LPCSTR lpcszPrefix);

// Comments last updated by Iris on 02/25/2005
/** >Tree
		Output contents of tree to a string
	Parameters:
		tr = [input] the tree need output
		str = [output] the output string
		bSkipHidden = [input] not include hidden tree node
		bSimpleTypesOnly = [input] middle variable, unmeaning for user
		bCheckUseLabel = [input] middle variable, unmeaning for user
	Return:
		number of output tree node
*/
///Kevin 10/10/05 MERGE_TREE_TO_STR_FUNCTION
//int tree_to_str(const TreeNode& tr, string& str, bool bSkipHidden = true, bool bSimpleTypesOnly = true, bool bCheckUseLabel = true);
///End MERGE_TREE_TO_STR_FUNCTION

// Comments last updated by Iris on 02/25/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tree_one_treetable_to_str_(global_function)
*/
//string	tree_to_treetable_str(TreeNode &trNode, int nXoffset= 0 ,int nExtraSpace = 1, bool bLev1AsCols = true , string strDoubleValueFormat = "*" , int nDisplayFormat = DISPLAY_LEFT	 );
//string	tree_to_treetable_str(TreeNode &trNode, vector<int> &vnDisplayFormat,bool bSkipHidden,bool bTranspose = true,  int nXoffset= 0 ,int nExtraSpace = 1, bool bLev1AsCols = true , string strDoubleValueFormat = "*" );
string	tree_one_treetable_to_str(TreeNode &trNode, vector<int> &vnDisplayFormat,bool bSkipHidden,bool bTranspose = true,  int nXoffset= 0 ,int nExtraSpace = 1, bool bLev1AsCols = true , string strDoubleValueFormat = "*" );

// Comments last updated by Hong on 09/10/07
// Comments last updated by Hong on 12/30/06
// Comments last updated by Frank on 03/1/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tree_to_str_(global_function)
*/
//int tree_to_str(const TreeNode& tr, string& str, vector<int> &vnDisplayFormat, bool bSkipHidden = true, bool bSimpleTypesOnly = true, bool bCheckUseLabel = true);
///Frank 10/17/05 ADD_DOUBLE_OUTPUR_FORMAT_IN_TREE_OUT
//int tree_to_str(const TreeNode& tr, string& str, vector<int> &vnDisplayFormat = NULL, bool bSkipHidden = true, bool bSimpleTypesOnly = true, bool bCheckUseLabel = true, bool bIncludeParentNamePrefix  = false);
/// ML 1/13/2006 XVARIABLEBASE_TO_VC
//int tree_to_str(const TreeNode& tr, string& str, vector<int> &vnDisplayFormat = NULL, bool bSkipHidden = true, bool bSimpleTypesOnly = true, bool bCheckUseLabel = true, bool bIncludeParentNamePrefix  = false, string strDoubleValueFormat = "*",  bool bIncludeAuxDisplayInfo = false);
/// Hong 09/08/07 v8.0699 MORE_OPTION_TO_DUMP_MAP_INFO_FOR_COMBO_NODE
//int tree_to_str(const TreeNode& tr, string& str, vector<int> &vnDisplayFormat = NULL, bool bSkipHidden = true, bool bSimpleTypesOnly = true, bool bCheckUseLabel = true, bool bIncludeParentNamePrefix  = false, LPCSTR lpcszDoubleValueFormat = NULL,  bool bIncludeAuxDisplayInfo = false);
int tree_to_str(const TreeNode& tr, string& str, vector<int> &vnDisplayFormat = NULL, DWORD dwCtrl = TREE2STR_DEFAULT, LPCSTR lpcszDoubleValueFormat = NULL);
/// end MORE_OPTION_TO_DUMP_MAP_INFO_FOR_COMBO_NODE
/// end XVARIABLEBASE_TO_VC
///End ADD_DOUBLE_OUTPUR_FORMAT_IN_TREE_OUT
// Comments last updated by Iris on 02/25/2005
///Frank 11/23/04 v8.0167 			CHECK_TREE_TABLE_TYPE_VISIABLE
/**$ >Tree
		Output the tree table type
	Parameters:
		trTable = [input]the input table tree
	Return:
		tree table type, the one of 
		enum {TREENODE_DATA_TYPE_NORMAL, TREENODE_DATA_TYPE_VECTOR,TREENODE_DATA_TYPE_MATRIX};
*/
int check_tree_table_type(TreeNode &trTable);

///If return false mean unable disaply table as text.
//bool can_show_tree_table(TreeNode &trTable);
///End		CHECK_TREE_TABLE_TYPE_VISIABLE	
//-------

// Comments last updated by Iris on 02/25/2005
///---Frank v8.0147	10/14/04			CENTRALIZE_FO_FUNCTION_TO_TREE_UTLIS
//Update NLSF file on user folder
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:update_ini_line_(global_function)
*/
bool update_ini_line(INIFile &iniFile, LPCSTR lpcszSectionName, LPCSTR lpcszKeyName, LPCSTR lpcszValue);
//void get_ini_keys_and_values(INIFile &iniNLSF,LPCSTR lpcszSection, StringArray &saKeys, StringArray &saValues  );
///---End			CENTRALIZE_FO_FUNCTION_TO_TREE_UTLIS
///Frank 11/1/04	v8.0157	GET_NUMERICA_VECTOR_OR_MATRIX_FROM_TREENODE	

// Comments last updated by Iris on 02/25/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:get_numerica_vector_treenode_(global_function)
*/
bool	get_numerica_vector_treenode(TreeNode &tr, vector<double> &vd);

// Comments last updated by Iris on 02/25/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:get_numerica_matrix_treenode_(global_function)
*/
bool	get_numerica_matrix_treenode( TreeNode &tr, matrixbase &matNum);

///Frank 12/15/04 TREE_GET_NODE_BY_NODEID_OR_DATAID	

// Comments last updated by DSC on 09/02/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tree_get_node_by_dataid_(global_function)
*/
TreeNode tree_get_node_by_dataid(TreeNode& tr, int nDataID, bool bRecursive = false,  int nSearchLevel = 0); 

// Comments last updated by Hong on 04/14/07
///DSC 8/25/05 TREENODE_FIND_NODE_BY_DATAID
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tree_find_node_by_dataID_(global_function)
*/
TreeNode tree_find_node_by_dataID(TreeNode tr, int nID, int nIDParent = 0, int nParentRepeatID = -1, int nIDGrandParent = 0, int nGrandParentRepeatID = -1);

///end TREENODE_FIND_NODE_BY_DATAID

// Comments last updated by Iris on 02/25/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tree_get_node_by_nodeid_(global_function)
*/
TreeNode tree_get_node_by_nodeid(TreeNode& trSource, int nNodeD, int nSeacherLevel =0);

// Comments last updated by Iris on 02/25/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tree_set_values_by_nodeids_(global_function)
*/
int tree_set_values_by_nodeids(TreeNode& trSetting, const vector<int>& vnNodeIDs, const vector<string>& vsValues);
///End 	TREE_GET_NODE_BY_NODEID_OR_DATAID	

///END	GET_NUMERICA_VECTOR_OR_MATRIX_FROM_TREENODE	

// Comments last updated by Hong on 04/14/07
// return total number of nodes set to be hidden
// Comments last updated by Iris on 02/25/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tree_hide_empty_nodes_(global_function)
*/
/// Hong 06/18/07 v8.0643 FIX_XF_SHOW_HELP_BY_LT_ERROR_SHOW_HIDDEN_NODE
//int tree_hide_empty_nodes(TreeNode tr, bool bRecursive = true);
int tree_hide_empty_nodes(TreeNode tr, bool bRecursive = true, bool bRemoveShowAttrib = true);
/// end FIX_XF_SHOW_HELP_BY_LT_ERROR_SHOW_HIDDEN_NODE

///Danice 11/15/04 QA70-7169 TREE_ROW_SHOW_ALTERNATE_COLORS
///Jasmine 01/17/07 GET_TREE_NODE_PATH
// Comments last updated by Jasmine on 01/17/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tree_get_level_(global_function)
*/
int tree_get_level(const TreeNode &trNode, string* pstrPath = NULL);
///end
///End GET_TREE_NODE_PATH
///Danice TREE_ROW_SHOW_ALTERNATE_COLORS
// Comments last updated by Iris on 02/25/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:get_GetN_background_colors_(global_function)
*/
string get_GetN_background_colors(uint& nLeafFirstColor, uint& nLeafSecondColor, vector<uint>& vnBranchColors);
///end


// Comments last updated by Iris on 02/25/2005
/** >Tree
		Scan all child nodes and see if any not empty, then set the specified bit in the given attribute
	Parameters:
		tr = [modify]tree node to set the attribute
		lpcszAttribute = [input]attribute to set
		dwBit = [input]the specify bit(s) to turn on if any child node not empty
		bRecursive = [input]true will walk the entire tree, false will only the current tree node
	Return:
		true if attribute modified by this function
*/
///Hong 7/18/06 FIX_RETURN_ERROR  
//bool tree_set_attribute_bit_if_not_empty(TreeNode& tr, LPCSTR lpcszAttribute, DWORD dwBit, bool bRecursive = true);	//---- CPY 12/17/04 SHOW_MISSING_MASED_TABLES_IF_NOT_EMPTY
//bool tree_set_attribute_bit_if_not_empty(TreeNode& tr, LPCSTR lpcszAttribute, DWORD dwBit, bool bRecursive = true, int& nCount = 0); 
///end FIX_RETURN_ERROR
//------ CPY 1/7/05 DERIVED_PARAMETERS_READ_SAVE_PROBLEM
// Comments last updated by Iris on 02/25/2005
/**$ >Tree
*/
bool tree_key_value_pairs_str_to_branch(TreeNode& tr, LPCSTR lpcszMultiline, char cKVSep = '=', char cLineSep = '\n');
// Comments last updated by Iris on 02/25/2005
/**$ >Tree
*/
//bool tree_branch_to_key_value_pairs_str(const TreeNode& tr, string& strMultiline, string strKVSep = " = ", string strLineSep =  "\n");
//------
// Comments last updated by Hong on 04/14/07
///Frank 1/21/05 MOVE_GET_LABEL_FUNCTION_FROM_STATIC
// Comments last updated by Iris on 02/25/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:get_node_label_(global_function)
*/
//string get_node_label(const TreeNode& tr, bool bCheckUseLabel);
string get_node_label(const TreeNode& tr, bool bGetLabelFirst = true);
///End MOVE_GET_LABEL_FUNCTION_FROM_STATIC

///Jasmine 09/17/05 v8.0308 SET_AND_GET_THEME_FILE_NAME
// Comments last updated by Jasmine on 01/03/07
/**$ 
	To set theme file name in the ThemeFile attribute of the given TreeNode
	Parameters:
		tr = [input] the TreeNode to set theme file name
		lpcszFileName = [input] file name string
	Return:
		returns false if the TreeNode is invalid, else return true
*/
bool tree_set_theme_file_name(TreeNode &tr, LPCSTR lpcszFileName);

/**$ 
	To get theme file name from the ThemeFile attribute of the given TreeNode
	Parameters:
		tr = [input] the TreeNode to set theme file name
		strFileName = [output] file name string
	Return:
		returns true if get the file name successfully, else return false
*/
bool tree_get_theme_file_name(TreeNode &tr, string &strFileName);

///End SET_AND_GET_THEME_FILE_NAME

// Comments last updated by Iris on 04/07/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tree_set_or_remove_attribute_(global_function)
*/
bool tree_set_or_remove_attribute(TreeNode &tr, LPCSTR lpcszAttribute = NULL,  bool bAdd = false, LPCSTR lpcszAttribValue = NULL);///Frank 1/26/05	GETN_DLG_ADVANCED_CHECK_SAVE

// Comments last updated by Frank on 03/17/2005
///Forest 03/02/05 QA70-7456	COPY_TREE_USING_FILTER
/**$ >Tree
	filter tree.
Parameters:
	trDest = [output]destination tree
	trSrc = [input]source tree
	nUnitNodeID = [input] DataID of unit tree node, filter is done on each unit
	nIncludeMode = [input] include mode, the value is enum{TCF_INCLUDE_ALL, TCF_INCLUDE_ANY}
	nIncludeNodeID = [input] DataID of tree node for include condition
	vsIncludeValues = [input]given values for include condition
	nExcludeMode = [input] exclude mode, the value is enum{TCF_EXCLUDE_ALL_NOT_INCLUDE, TCF_EXCLUDE_ANY, TCF_EXCLUDE_ALL}
	nExcludeNodeID = [input] DataID of tree node for exclude condition
	vsExcludeValues = [input]given values for exclude condition
Example1:
	//get functions with int and double arguments, and returns int, but not include matrix or vector arguments
	void tree_copy_by_filter_ex1(const TreeNode& trInput, TreeNode& trOutput)
	{
		Tree trFilterArgu;
		vector<string> vsIncludedArguTypes = {"int", "double"};
		vector<string> vsExcludedArguTypes = {"matrix", "vector"};
		tree_copy_by_filter(trFilterArgu, trInput, ID_FB_FUNCTION,
					TCF_INCLUDE_ALL, ID_FB_ARGU_TYPE, vsIncludedArguTypes,
					TCF_EXCLUDE_ANY, ID_FB_ARGU_TYPE, vsExcludedArguTypes);						
		vector<string> vsReturnTypes = {"int"};
		vector<string> vsTemp;
		tree_copy_by_filter(trOutput, trFilterArgu, ID_FB_FUNCTION,
					TCF_INCLUDE_ANY, ID_FB_RETURN_TYPE, vsReturnTypes,
					TCF_EXCLUDE_ALL_NOT_INCLUDE, ID_FB_RETURN_TYPE, vsTemp);
	}
Example2:
	//get functions returns double, and all arguments are double
	void tree_copy_by_filter_ex2(const TreeNode& trInput, TreeNode& trOutput)
	{
		Tree trFilterArgu;
		vector<string> vsIncludedArguTypes = {"double"};
		vector<string> vsTemp;
		tree_copy_by_filter(trFilterArgu, trInput, ID_FB_FUNCTION,
					TCF_INCLUDE_ALL, ID_FB_ARGU_TYPE, vsIncludedArguTypes,
					TCF_EXCLUDE_ALL_NOT_INCLUDE, ID_FB_ARGU_TYPE, vsTemp);						
		vector<string> vsReturnTypes = {"double"};
		tree_copy_by_filter(trOutput, trFilterArgu, ID_FB_FUNCTION,
					TCF_INCLUDE_ANY, ID_FB_RETURN_TYPE, vsReturnTypes,
					TCF_EXCLUDE_ALL_NOT_INCLUDE, ID_FB_RETURN_TYPE, vsTemp);
	}
	Return:
	Returns true on success, returns false on failure
*/
bool tree_copy_by_filter(TreeNode& trDest, const TreeNode& trSrc, int nUnitNodeID, int nIncludeMode, int nIncludeNodeID, const vector<string>& vsIncludeValues,	int nExcludeMode, int nExcludeNodeID, const vector<string>& vsExcludeValues);
///End COPY_TREE_USING_FILTER


// Comments last updated by Iris on 04/07/2005
/**$ >Tree
	To get theme type, type should be the one of the following 
	THTYPE_UNDEF = 0,
	THTYPE_GRAPH = 1,
	THTYPE_WORKSHEET,
	THTYPE_MATRIX,
	THTYPE_ANALYSIS,
	THTYPE_DIALOG,
	THTYPE_REPORT_TABLE,
	THTYPE_FB_FILTER,
	THTYPE_CUSTOM,
	THTYPE_EVENT_ORGANIZER
Parameters:
	tr = [input] the tree to get theme type
Return:
	returns theme type
*/
int tree_get_theme_type(TreeNode& tr);
///Frank 3/31/05 TREE_MOVE_NODE_TO_POSITION
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tree_move_node_(global_function)
*/
//bool tree_move_node(TreeNode &tr, int nRow, int nPosition = -1, int nStopLevel=-1, LPCSTR lpcszStopAttribute = NULL, bool bStopAtLastBranch = false, int nCurrentLevel = 0 );	///DG 4/20/05 REWRITE_TREE_GET_NODE
bool tree_move_node(TreeNode &tr, int nRow, int nPosition = -1, DWORD dwCntrl = 0, LPCSTR lpcszAttribute = NULL);
///End TREE_MOVE_NODE_TO_POSITION

// Comments last updated by Hong on 04/14/07
// Comments last updated by Hong on 01/04/06
///DG 4/7/05 : move from FO
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tree_get_enum_node_name_(global_function)
*/
string tree_get_enum_node_name(TreeNode &trNode, string strPrefix);
// Comments last updated by Hong on 01/04/06
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tree_get_enum_attribute_value_(global_function)
*/
///Hong 8/01/06 ADD_POSTFIX_SUPPORT
//string tree_get_enum_attribute_value(TreeNode &trNode, string strAttribute, string strPrefix);
string tree_get_enum_attribute_value(TreeNode &trNode, string strAttribute, string strPrefix, string strPostfix = "");
///end ADD_POSTFIX_SUPPORT
///end

/// EJP 2005-03-31 v8.0214 QA70-6816 SHOW_IMPORT_FILE_INFO_IN_USER_VAR_DLG
// Comments last updated by Iris on 04/07/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tree_add_import_file_info_(global_function)
*/
int tree_add_import_file_info(TreeNode& tnTarget, Page& pgSource, int nSrc = 0);

int tree_add_obj_import_file_info(const OriginObject& obj, TreeNode& tr);		///Kyle 02/04/2010 READ_SHEET_INPORT_FILE_INFO
/**$ >Tree
*/
int tree_set_import_file_node_data_attrib(TreeNode& tnParent, int nFile, LPCSTR lpcszPrefix = NULL, int nSrc = 0);
/// end SHOW_IMPORT_FILE_INFO_IN_USER_VAR_DLG
///Jasmine 01/17/07 QA70-9273 SHOW_USER_TREE_INFO_IN_USER_VAR_DLG
/**$
*/
int tree_add_user_tree_info(TreeNode& tr, OriginObject& obj);
///End SHOW_USER_TREE_INFO_IN_USER_VAR_DLG

///Kyle 08/26/2009 QA80-14190 DEFINE_VARIABLE_FROM_COLUMN_LABELS_IN_SCV_DB
int tree_add_column_labels_info(TreeNode& tr, const Column& col);
///End DEFINE_VARIABLE_FROM_COLUMN_LABELS_IN_SCV_DB

///Forest 4/1/05 TREE_FILTER_BY_ATTRIB_MATCH
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tree_filter_by_attrib_match_(global_function)
*/
bool	tree_filter_by_attrib_match(TreeNode& tr, int iUnitNodeID, LPCSTR lpcstrAttrib, LPCSTR lpcstrPattern, bool bCaseSensitive = false);

// Comments last updated by Frank on 05/31/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tree_filter_by_attrib_find_(global_function)
*/
bool	tree_filter_by_attrib_find(TreeNode& tr, int iUnitNodeID, LPCSTR lpcstrAttrib, LPCSTR lpcstrSub, bool bCaseSensitive = false, bool bMustBeginWith = false);
///End TREE_FILTER_BY_ATTRIB_MATCH

///Sophy 8/7/2009 QA80-14101 SET_GETN_NODES_AS_UNDEFINED_WHEN_SEL_MULTI_COLS_WITH_DIFF_PROPERTY
/**$
	This function remove all the children with specified attribute name and value
	Parameters:
		tr = [input] the tree to remove its children
		lpcszAttrib = [input] the specified attribute name
		nAttribVal = [input] the value of the specified attribute
		bRecursive = [input] whether to find and remove subnode recursively
	Return:
		return the number of subnodes removed, return -1 if tr is invalid.
*/
int		tree_remove_children_by_attrib(TreeNode& tr, LPCSTR lpcszAttrib, int nAttribVal, bool bRecursive = true);
///end SET_GETN_NODES_AS_UNDEFINED_WHEN_SEL_MULTI_COLS_WITH_DIFF_PROPERTY
///Frank 4/5/05 GUI_ADVANCED_SETTING_FROM_FILE
/**$
	set the GUI's advenced setting file to attribute
*/
bool tree_set_advanced_settings_file(TreeNode &trGUI, string strFileName);
/**$
	get the GUI's advenced setting file to attribute
*/
string tree_get_advanced_settings_file(TreeNode &trGUI);
// Comments last updated by Hong on 01/04/06
///Iris 4/06/05 FIT_REGRESSION_PLOTS
/**$
	to check if the id of input tree node is in Range
Parameters:
	trNode = [input]input tree node to check id
	nBeginID = [input]the begin id
	nEndID = [input]the end id
	nOffset = [input] the offset of id
Return:
	Returns true if id is in ids range, else false.
Example1:
	void is_in_ids_range_ex1()
	{
		Tree tr;
		tr.AddTextNode("temp", "A", 1);
		tr.AddTextNode("temp", "B", 2);
		TreeNode trTest = tr.AddTextNode("temp", "C", 3);
		bool bRet = is_in_ids_range(trTest, 3, 5);	
	}
*/
bool 	is_in_ids_range(TreeNode &trNode, int nBeginID, int nEndID, int nOffset = 0);
///End GUI_ADVANCED_SETTING_FROM_FILE


/// ML 4/15/2005 XVAR_DATA_CHANGE_ATT
/**$
		It gets or sets or both gets and clears the boolean Data Change att.
	Parameters:
		tn=[modify]the tree node whose Data Change att is to be handled.
		nValue=[input]If nValue > 0, the value is set to true.
				If nValue == 0, the value is returned and, if present, cleared at the same time.
				If nValue < 0, the value is only returned.
	Returns:
		If nValue > 0, returns true.
		If nValue <= 0, it returns the value at the time the function is called.
*/
bool	tree_changed_data(TreeNode &tn, int nValue = -1);
/// end XVAR_DATA_CHANGE_ATT

/// Iris 12/14/05 INIT_CONTROL_LEVEL_LIST_ON_LEVEL_NAME_CHANGE
//Comments last updated by Iris 7/29/2008, added #
/**#
		It gets the root of input treenode
	Parameters:
		tr=[input]the tree node whose need to find the root

	Returns:
		the root treenode if success, fail will return an invalid treenode
*/
TreeNode tree_get_root_node(TreeNode& tr);
///End INIT_CONTROL_LEVEL_LIST_ON_LEVEL_NAME_CHANGE

//Comments last updated by Iris 7/29/2008, added $
/**$
		To check if foot node or not
	Parameters:
		trN=[input]the tree node to check
	Return:
		If trN is foot node, returns true.	
*/
bool tree_is_foot_node(const TreeNode &trN);


/// YuI 04/17/06 CENTRALIZATION_STATS_INPUT_DATA_TREE_CONVERTING
typedef	enum	tagSTATSINPUTDATATREETYPE
{
	SIDT_INVAR,
	SIDT_INGROUP,
}	STATSINPUTDATATREETYPE;
// Comments last updated by Hong on 01/04/06
/**$
*/
///Kyle 08/09/2011 ORG-3103-S1  SUPPORT_INPUT_DATA_FORM_OPTION_FOR_NPH_TESTS
//BOOL	tree_stats_convert_input_data(TreeNode& tr, int nType);
BOOL	tree_stats_convert_input_data(TreeNode& tr, int nType, bool bTwoLevels = true, bool bWithSubject = false);
///End SUPPORT_INPUT_DATA_FORM_OPTION_FOR_NPH_TESTS
/// end CENTRALIZATION_STATS_INPUT_DATA_TREE_CONVERTING

///Kyle 10/31/08 QA80-12452  SUPPORT_INPUT_DATA_FORM_OPTION_FOR_NPH_TESTS
BOOL	tree_stats_convert_input_data_indexed_raw(TreeNode& tr, int nType);
///End SUPPORT_INPUT_DATA_FORM_OPTION_FOR_NPH_TESTS

/// YuI 08/15/06 MORE_WORK_ON_STATISTICAL_PLOTS
// Comments last updated by Hong on 04/14/07
/**$
*/
TreeNode	tree_stats_get_boxchart_box_node(TreeNode& trStats);
// Comments last updated by Hong on 04/14/07
/**$
*/
TreeNode	tree_stats_get_boxchart_whisker_node(TreeNode& trStats);
// Comments last updated by Hong on 04/14/07
/**$
*/
void	tree_stats_get_set_stats_results(TreeNode& trStats, DescStatResults& dsr, double& dMin, double& dMax, BOOL bGet = TRUE);
// Comments last updated by Hong on 04/14/07
/**$
*/
void	tree_stats_get_set_counts(TreeNode& trStats, vector& vCounts, BOOL bGet = TRUE);
// Comments last updated by Hong on 04/14/07
/**$
*/
void	tree_stats_get_set_percentiles(TreeNode& trStats, vector& vPercentiles, BOOL bGet = TRUE);
// Comments last updated by Hong on 04/14/07
/**$
*/
void	tree_stats_get_set_bin_info(TreeNode& trStats, double& dMin, double& dMax, double& dSize, BOOL bGet = TRUE);

///Kyle 01/17/2011 ORG-1941-P3 MORE_WORK_FOR_MOVING_HISTOGRAM_TO_VC
void	tree_stats_get_set_bin_intervals(TreeNode& trStats, double& dMin, double& dMax, int& nIntervals, BOOL bGet = TRUE);
///End MORE_WORK_FOR_MOVING_HISTOGRAM_TO_VC

// Comments last updated by Hong on 04/14/07
/**$
*/
void	tree_stats_get_set_box_info(TreeNode& trStats, double& dTop, double& dTopX, double& dBottom, double& dBottomX, double& dCenter, BOOL bGet = TRUE);
// Comments last updated by Hong on 04/14/07
/**$
*/
void	tree_stats_get_set_whisker_info(TreeNode& trStats, double& dTop, double& dBottom, BOOL bGet = TRUE);
/// end MORE_WORK_ON_STATISTICAL_PLOTS

/// Iris 5/30/06 EXPORT_PAGE_XF
// Comments last updated by Sandy on 08/23/07
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tree_get_node_by_tagname_(global_function)
*/
TreeNode tree_get_node_by_tagname(const TreeNode& tr, LPCSTR lpcszTagName, bool bRecursive = false, bool bCaseSensitive = false, bool bSkipBranch = false);

// Comments last updated by Hong on 04/14/07
/**$
*/
int tree_copy_ids_by_tagname(const TreeNode& trSrc, TreeNode& trDest, bool bSkipBranch = false);
///End EXPORT_PAGE_XF


///Joe  7/17/06 HIDE_EMPTY_TABLE
//void tree_hide_empty_table(TreeNode &tr, bool bRecursive = true);
///End HIDE_EMPTY_TABLE


/**$
	To return the attirbute value of the tree nodes found by node id.
	Parameters:
		tr = [input]the tree node to check
		nID = [input] node id
		lpcszAttibute = [input]the atrribute name
		vnAttribVals = [output] the array of the values of attribute
	Return:
		Returns the number of TreeNodes found.
*/
int  tree_find_attributes_by_ID(const TreeNode& tr, DWORD nID, LPCSTR lpcszAttibute, vector<int>& vnAttribVals, bool bRecursive = false);

/**$
*/
void tree_dump_vec_node(LPCSTR lpcsz, TreeNode& tr); //CPY 7/18/06 for debugging

/// Hong 9/14/06 REMOVE_IMPORT_RELATED_TO_FU_UTILS
/*
/// EJP 2006-07-07 v8.0440 QA70-8697 XFUNC_BASED_IMPORT, Move code to here from FileImport.c
#if _OC_VER >= 0x0800
bool impinfo_InitTree(Page& pgTarget, int nImportMode);
bool impinfo_GetLastFileNode(Page& pgSource, TreeNode& trTarget);
bool impinfo_SetLastFileNode(Page& pgTarget, TreeNode& trFile);
bool impinfo_FilterNameToLastFileNode(Page& pgTarget, LPCSTR lpcszFilterFile);
*/
/// end REMOVE_IMPORT_RELATED_TO_FU_UTILS
///---Sim 02-06-2007 ADD_RANGE_INFO_TO_BASE_INFO
//bool impinfo_FileInfoToFileNode(TreeNode& trFile, LPCSTR lpcszDataFile, int nFileType = 0);
/**$
*/
bool impinfo_FileInfoToFileNode(TreeNode& trFile, LPCSTR lpcszDataFile, int nFileType = 0, const TreeNode& trRange = NULL);
///---END ADD_RANGE_INFO_TO_BASE_INFO
/// Hong 9/14/06 REMOVE_IMPORT_RELATED_TO_FU_UTILS
/*
int impinfo_HeaderVariablesToFileNode(TreeNode& tnFile, const StringArray& saVarNames, const StringArray& saVarValues);
int impinfo_FileNameVariablesToFileNode(TreeNode& tnFile, const StringArray& saVarNames, const StringArray& saVarValues);
///Hong 8/04/06 ADD_FILTER_INFO
//bool impinfo_AddFile(Layer& lyTarget, LPCSTR lpcszDataFile, TreeNode& tnInfo, int nImportMode, int nImportType);
bool impinfo_AddFile(Layer& lyTarget, LPCSTR lpcszDataFile, TreeNode& tnInfo, int nImportMode, int nImportType, TreeNode& trFilter = NULL);
///end ADD_FILTER_INFO
#endif // _OC_VER >= 0x0800
/// end XFUNC_BASED_IMPORT
*/
/// end REMOVE_IMPORT_RELATED_TO_FU_UTILS

///---Sim 08-29-2006 SUPPORT_GET_VALUE_USE_REFERENCE
/*
///Hong 8/24/06 MOVE_OFILTER_UTILS_TO_TREE_UTILS
int tree_get_int_value_by_id(const TreeNode& tr, int nID, int nDefault = 0);
bool tree_set_int_value_by_id(TreeNode& tr, int nID, int nVal);

double tree_get_double_value_by_id(const TreeNode& tr, int nID, double dDefault = 0.0);
bool tree_set_double_value_by_id(TreeNode& tr, int nID, double dVal);

bool tree_get_string_value_by_id(const TreeNode& tr, int nID, string& strVal);
bool tree_set_string_value_by_id(TreeNode& tr, int nID, LPCSTR szVal);

BOOL tree_get_flag_value_by_id(const TreeNode& tr, DWORD dwFlag, BOOL bDefault = FALSE); // = 0
bool tree_set_flag_value_by_id(TreeNode& tr, DWORD dwFlag, BOOL bSet = TRUE);
///end MOVE_OFILTER_UTILS_TO_TREE_UTILS
*/
// Comments last updated by Hong on 01/04/06
/**$
*/
bool tree_getr_int_value_by_id(const TreeNode &tr, int nID, int &nVal);
// Comments last updated by Hong on 01/04/06
/**$
*/
int tree_get_int_value_by_id(const TreeNode &tr, int nID, int nDefault = 0);
// Comments last updated by Hong on 01/04/06
/**$
*/
bool tree_set_int_value_by_id(TreeNode &tr, int nID, int nVal);
// Comments last updated by Hong on 01/04/06
/**$
*/
bool tree_getr_double_value_by_id(const TreeNode &tr, int nID, double &dVal);
// Comments last updated by Hong on 01/04/06
/**$
*/
double tree_get_double_value_by_id(const TreeNode &tr, int nID, double dDefault = 0.0);
// Comments last updated by Hong on 01/04/06
/**$
*/
bool tree_set_double_value_by_id(TreeNode &tr, int nID, double dVal);
// Comments last updated by Hong on 01/04/06
/**$
*/
bool tree_getr_string_value_by_id(const TreeNode &tr, int nID, string &strVal);
// Comments last updated by Hong on 01/04/06
/**$
*/
string tree_get_string_value_by_id(const TreeNode &tr, int nID, string strDefault = "");
// Comments last updated by Hong on 01/04/06
/**$
*/
bool tree_set_string_value_by_id(TreeNode &tr, int nID, LPCSTR szVal);
// Comments last updated by Hong on 01/04/06
/**$
*/
bool tree_getr_flag_value_by_id(const TreeNode &tr, DWORD dwFlag, BOOL &bSet);
// Comments last updated by Hong on 01/04/06
/**$
*/
BOOL tree_get_flag_value_by_id(const TreeNode &tr, DWORD dwFlag, BOOL bDefault = FALSE);
// Comments last updated by Hong on 01/04/06
/**$
*/
bool tree_set_flag_value_by_id(TreeNode &tr, DWORD dwFlag, BOOL bSet = TRUE);
///---END SUPPORT_GET_VALUE_USE_REFERENCE
// Comments last updated by Hong on 04/14/07
/**$
*/
int		tree_get_oper_multidata_modes(TreeNode &trGUI, int *pnOutMode = NULL); /// ML 10/7/2004 MULTIPLE_DATASET_OPER_TREATMENT

/**$
*/
bool tree_is_true(const TreeNode& tr, LPCSTR lpcszTag = NULL); /// Iris 01/25/2007 v8.0547 CLEANUP_CHECK_TREE_TRUE_CODES

///Joseph 03/01/07 GET_SUBNODE_INDEX_FROM_TAGNAME
/**$
*/
int tree_get_subnode_index(TreeNode& trParent, LPCSTR lpcszName);
///End GET_SUBNODE_INDEX_FROM_TAGNAME


///Sandy 2007-3-12 move from xfgraph_utils.h
// Comments last updated by Hong on 04/14/07
/**$
*/
bool tree_check_get_node_by_dataid(TreeNode& trParent,TreeNode& trNew, LPCSTR lpcszTag, int nDataID, int nID = 0, LPCSTR lpcszLableAttrib = NULL); // = 0 = NULL = NULL

//-------- CPY 5/7/07 AUTO_TO_USE_IN_GENERAL_GETN
//Comments last updated by Iris 7/29/2008, added $
/**$
	check given treenode to see if it has an Auto checkbox, and to replace the double value if it is Auto
	Parameters:
		tr = [input/output] treenode to check and update
		dValToReplace = [input] double value to replace tree node
	Return:
		1 = tr has Auto checkbox and is checked, tr value is updated to dValToReplace
		0 = tr does not have Auto checkbox, pdValToReplace is ignored
		-1= tr has Auto checkbox but is unchecked, tr value is not changed
*/
int tree_check_replace_auto(TreeNode& tr, double dValToReplace);
//-------

//----- Iris 06/01/2007 v8.0631 want to use them in xf, so moved function body from wksOperation.c to tree_utils.c
/**$
	add more label attributes to a tree node
*/
void	tree_add_more_labels(TreeNode &trParent, vector<string> &vstrFactors, int nStartIndex = 0, LPCSTR lpcszLastLabel = NULL);

/**$
*/
void	tree_add_one_label(TreeNode &trParent, LPCTSTR lpcszLabel, int index = -1);
//-----

///---Sim 06-07-2007 SUPPORT_RENAME_TREE_TAGNAME
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tree_rename_tags_(global_function)
*/
bool tree_rename_tags(TreeNode& trRoot, const StringArray& saOldTagNames, const StringArray& saNewTagNames);
///---END SUPPORT_RENAME_TREE_TAGNAME

/// Iris 07/03/2007 v8.0654 USAGE_OF_BROWSER_COMBO_NOT_CONSISTENT_IN_FILE_AND_PATH_CONTROL
////----Jake 06/26/07 SUPPORT_COMBO_LIST_FOR_PATH
//bool tree_set_browse_combo_attrib(TreeNode trNode, LPCSTR lpcszClassName = NULL, bool bOnlyRecent = false);
////----end SUPPORT_COMBO_LIST_FOR_PATH
/**$
*/
#define STR_ATTR_BROWSE_COMBO_LIST_DELIMITER "|:|"
/**$
*/
/// Hong 10/26/07 QA80-10364 PATH_CTRL_SHOULD_NOT_APEEND_FILENAME
//bool tree_set_browse_combo_attrib(TreeNode trNode, LPCSTR lpcszClassName = NULL, bool bIncSpecialFolder = true);
bool tree_set_browse_combo_attrib(TreeNode trNode, LPCSTR lpcszClassName = NULL, bool bIncSpecialFolder = true, bool bAppendFilename = true);
/// end PATH_CTRL_SHOULD_NOT_APEEND_FILENAME
///end USAGE_OF_BROWSER_COMBO_NOT_CONSISTENT_IN_FILE_AND_PATH_CONTROL

///---Sim 12-23-2008 QA80-12836 SUPPORT_FILE_BROWSER_BUTTON
#define STR_ATTR_FILE_EXT_GROUP_DELIMITER ":"
bool tree_set_file_browse_combo_attrib(TreeNode trNode, const vector<string>& vsFiles);
bool tree_set_file_browse_combo_more_attrib(TreeNode trNode, LPCSTR lpcszPath, LPCSTR lpcszFileFilter);
///---END QA80-12836 SUPPORT_FILE_BROWSER_BUTTON

//----Jake 06/28/07 MOVE_CODE_FROM_EXPORT_XFS
/**$
*/
void tree_set_only_file_name_attrib(TreeNode& trPath, LPCSTR lpcszFileName);
/**$
*/
bool tree_check_set_real_path(TreeNode& trPath);
//----end MOVE_CODE_FROM_EXPORT_XFS

///Arvin 01/07/08 QA70-10903 ADD_CHECK_ALL_BOX_FOR_BRANCH
bool tree_set_branch_attribute_for_branch(TreeNode& trBranch, int dwBranchAttr = GETNBRANCH_CHECK_CONTROL | GETNBRANCH_CHECK_CONTROL_ONE_EVENT);
///end ADD_CHECK_ALL_BOX_FOR_BRANCH

/// Iris 4/23/2008 NOT_GENERAGE_TABLE_IF_NOT_REPORT_TO_IMPROVE_NLSF_SPEED
//Comments last updated by Iris 7/29/2008, added $
/**$
	If trBranch has Use Attribute and not checked, directly return true without go on to check children, else check all children is unchecked, 
	once one node is checked, return false.
	Parameters:
		trBranch = [input] the treenode to check
	Return:
		return ture if trBranch is uncheck or all children are uncheck.
*/
bool	tree_GUI_are_all_uncheck(const TreeNode& trBranch);
///end NOT_GENERAGE_TABLE_IF_NOT_REPORT_TO_IMPROVE_NLSF_SPEED

/// Hong 10/24/08 v8.0960b FIX_NEW_NLFIT_FUNCTION_LIST_LOST_ITEM_NEW_DOT_DOT_DOT
bool	tree_is_editable(const TreeNode& trNode);
/// end FIX_NEW_NLFIT_FUNCTION_LIST_LOST_ITEM_NEW_DOT_DOT_DOT

/// Hong 11/14/08 v8.0971b DISABLE_OPTIONS_INSTEAD_OF_HIDDEN_IT_FOR_BASELINE_OUTPUT_OPTIONS
bool	tree_is_visible(const TreeNode& trNode);
/// end DISABLE_OPTIONS_INSTEAD_OF_HIDDEN_IT_FOR_BASELINE_OUTPUT_OPTIONS

///Kyle 03/31/2009 QA80-3224 NEW_OPTION_TO_SUPPORT_LINEAR_FIT_WITH_ERROR_BAR
void tree_uncheck_all_hidden_check_boxes(TreeNode tr, bool bIsParentHidden = false);
///End NEW_OPTION_TO_SUPPORT_LINEAR_FIT_WITH_ERROR_BAR

/// Iris 3/18/2011 ORG-2427 STATS_ON_COLS_SUPPORT_FLAT_SHEET_REPORT
bool tree_set_value(TreeNode& tr, int nVal); 
///End STATS_ON_COLS_SUPPORT_FLAT_SHEET_REPORT

/// Hong 08/24/11 ORG-1864 FIX_PA_FAIL_APPLY_X_RANGE
bool tree_get_getn_range_input_tree_node(TreeNode& trGetN, TreeNode& trInput);
/// end FIX_PA_FAIL_APPLY_X_RANGE

/// Bill 09/08/2011 ORG-3395 CUSTOMIZE_IMPORT_MENU_DIALOG
bool tree_sort_children_by_int_attribute(TreeNode& trTable, LPCSTR lpcszAttributeName, BOOL bAscending = TRUE);
/// End CUSTOMIZE_IMPORT_MENU_DIALOG

///---Sim 2011-10-18 ORG-3798 FIX_REIMPORT_DATA_WHEN_TURN_ON_STRUCTURE_ONLY
void tree_copy_value_by_visible_and_editable(TreeNode &trDest, TreeNode &trSource);
///---END ORG-3798 FIX_REIMPORT_DATA_WHEN_TURN_ON_STRUCTURE_ONLY
///---Sim 2011-11-04 ORG-4179-P2 DISABLE_TDM_REIMPORT_OPTIONS
bool tree_is_usable(const TreeNode& trNode);
///---END ORG-4179-P2 DISABLE_TDM_REIMPORT_OPTIONS

enum {
	TNSWAP_GROUP_ATTRIB		= 0x0001,
	TNSWAP_BRANCH_ATTRIB	= 0x0002,
};
bool tree_swap_node(TreeNode& tr, LPCSTR lpcszNode1, LPCSTR lpcszNode2, DWORD dwCtrl = 0);		///------ Folger 03/06/2012 ORG-4118 TREE_SWAP_NODE

///------ Folger 05/03/2012 ORG-5592-S1 ADD_DATA_IDENTIFIER_FOR_FITTING_TOOLS
int tree_get_node_row(const TreeNode& trRoot, const TreeNode& trNode);
///------ End ADD_DATA_IDENTIFIER_FOR_FITTING_TOOLS

/// Iris 7/04/2012 ORG-6033-P1 TO_PREVENT_GETN_AUTO_SAVE_BRANCH_OPEN_STATUS_TO_REG
void tree_set_branch_open_status_auto_save(TreeNode& tr);
///End TO_PREVENT_GETN_AUTO_SAVE_BRANCH_OPEN_STATUS_TO_REG

#endif //_TREE_UTILS.H
