/*------------------------------------------------------------------------------*
 * File Name: spcdata.h															*
 * Creation: SY 05-09-2003														*
 * Purpose: Origin C header	for SPC data class									*
 * Copyright (c) OriginLab Corp.2003											*
 * All Rights Reserved															*
 *	Hong 09/04/07 QA80-10263 TAKE_BACK_OC_EXPORT_SPC_CLASS_INTO_80_WITH_START_COL
 *	Hong 07/02/08 QA80-11784 BRING_BACK_SPC_COLUMN_CORNER_INFO					*
 *------------------------------------------------------------------------------*/

/**
	This header file is used for exporting SPC. The following example show you how to export SPC file. 

	// Assume you have the data in worksheet.
	// If you want to export data start from second column, you need to write a function like wtest()
	// to create the corner object information and then export SPC.

	#include <spcdata.h>
	void wtest()
	{
		// Put the data into worksheet
		Worksheet wks("Data1");
		if ( !wks )
			return ;
		
		SPCData myData(wks, 1); // Start exporting from second column(which index is 1).
		ASSERT( myData.IsValid() );
		
		// Fill in the SPC additional information
		// Set text log
		string strLog = "Tester = OriginLab";
		myData.SetSPCTextLog(strLog);
		
		// MUST provide SPC main header and subfile header information
		OSPCMAINHEADER mySPCmainHd = {0};
		OSPCSUBHEADER mySPCsubHd = {0};
		
		mySPCmainHd.ftflgs = 0; // MUST set the correct SPC file type, 
								// spcFileTypeEven = 0, spcFileTypeXYY = 1, spcFileTypeXYXY = 2
		mySPCmainHd.ffirst = 1;
		mySPCmainHd.flast = 30;
		mySPCmainHd.fnsub =1;
		mySPCmainHd.fnpts = 30;
		Column cc(wks, 1);
		string strSName = cc.GetName();
		strncpy(mySPCmainHd.fcatyt , strSName, 30); // specift the custom X axis label, this can be imported as short name by improt SPC(notice only one version for all X axis)
		myData.SetSPCMainHeader(&mySPCmainHd);
		
		// Must specify the subfile
		myData.SetSPCSubHeader(&mySPCsubHd, 1);	// subfile index from 1

		myData.SetSPCSubHeader(&mySPCsubHd, 2);
		
		myData.SetSPCSubHeader(&mySPCsubHd, 3);

		myData.SetSPCSubHeader(&mySPCsubHd, 4);

		myData.SaveAsSPC("D:\\test.spc");
	}
*/

class SPCData
{
public:

	SPCData(Worksheet &wks, int nStartCol = 0);

	BOOL IsValid();

	int GetStartCol();
	
	/**
		return old start column index
	*/
	int SetStartCol(int nNewStartCol);
	
	/// Hong 07/02/08 QA80-11784 BRING_BACK_SPC_COLUMN_CORNER_INFO
	BOOL SetFileName(LPCSTR lpszFileName);	
	/// end BRING_BACK_SPC_COLUMN_CORNER_INFO

	int SaveAsSPC(LPCSTR lpcszFileName);

	int SetSPCMainHeader(OSPCMAINHeader *lpSPCMainHeader);

	int GetSPCMainHeader(OSPCMAINHeader *lpSPCMainHeader);

	int SetSPCSubHeader(OSPCSUBHeader *lpSPCSubHeader, int nIndex);

	int GetSPCSubHeader(OSPCSUBHeader *lpSPCSubHeader, int nIndex);

	int GetSPCTextLog(string &strLog);

	int SetSPCTextLog(string strLog);

	int GetSPCBinLog(_VARIANT &varBin);

	int SetSPCBinLog(_VARIANT varBin);
};

