/*------------------------------------------------------------------------------*
 * File Name: pro_image_utils.h													*
 * Creation: 2005-07-20															*
 * Purpose: header for OriginPro image utility functions						*
 * Copyright (c) OriginLab Corp. 2010											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Derek 03/25/2010 ADD_A_FUNCTION_FOR_FINDING_OBJECT_IN_BINARY_MATRIX          * 
 *------------------------------------------------------------------------------*/

#ifndef _PRO_IMAGE_UTILS_H
#define _PRO_IMAGE_UTILS_H

#include <Origin.h>

// Comments last updated by Derek on 4/2/2010
// Derek 03/25/2010 ADD_A_FUNCTION_FOR_FINDING_OBJECT_IN_BINARY_MATRIX  
/** >Image

	Parameters:
		im = [input] binary matrix, all cells with values >0 are considered as object pixels, so will count based on 0 and >0
		ov = [output] vector containing the number of objects with area within the range [minObjPixels, maxObjPixels].
		              the vector size is (maxObjPixels-minObjPixels+1), ov[0] represents the number of objects with area "minObjPixels",
					  and ov[maxObjPixels-minObjPixels] represents "maxObjPixels"
		minObjPixels = [intput] optional lower limit on the object size, in number of pixels
		maxObjPixels = [input] optional upper object size limit, use -1 to indicate no upper limit

	Return:
		number of objects found, and <0 for error codes	
	SeeAlso:
	Keywords:
		
	Example1:
		#include <pro_image_utils.h>
		// prepare a matrix book with UINT type of data
		void count_obj(string strMBook = "MBook1")
		{
			MatrixLayer ml(strMBook);
			MatrixObject mo = ml.MatrixObjects();
			matrix<uint> mm(mo);	
			vector<uint> ov;
			int nRet = find_objects_in_binary_matrix(mm, ov);  
			for(int ii = 0; ii < ov.GetSize(); ii ++)
			{
				printf("%d\n", ov[ii]);
			}
			printf("total number of objects = %d\n", nRet);
		}
**/
int find_objects_in_binary_matrix(const matrix<uint>& im, vector<uint>& ov, int minObjPixels = 1, int maxObjPixels = -1);


int particle_analysis_instance(const matrix<double>& mSrcImage, matrix<uint>& mSegmLabels, matrix<uint>& mObjectLabels);

// END ADD_A_FUNCTION_FOR_FINDING_OBJECT_IN_BINARY_MATRIX

#endif _PRO_IMAGE_UTILS_H