/*------------------------------------------------------------------------------*
 *	File Name: 	oExtFile.h														*
 *	Purpose:																	*
 *																				*
 *	Author:		SY																*
 *  Creation:																	*
 *  	Copyright (c) OriginLab Inc. 2000, 2001, 2002, 2003, 2004, 2005, 2006	*
 *																				*
 *	Modification log                                                        	*
 *	ML 10/13/2006 QA70-9053 PASSING_file_OBJECT_FROM_OC_TO_VC_FUNCS_BY_PTR		*
 *	Cheney 2006-10-17  HANDLE_QUOTE_FOR_CSV_FORMAT_FILE							*
 *	Cheney 2006-10-24 HANDLE_FEED_LINE_FOR_CSV_FORMAT_FILE						*
 *	Joseph 11/15/06 EXPORT_DATA_FROM_MATRIX										*
 *	Cheney 2006-12-20 SUPPORT_IMPORT_JCAMP_FILE									*
 *	Cheney 2006-12-26 SUPPORT_IMPORT_DIADEM_DAT_FILE							*
 *	Cheney 2007-2-10 SUPPORT_EXPORT_SAMPLE_INTERVAL_AS_NEW_COL					*
 *	Hong 07/24/08 QA80-10707 USING_NO_DIMENSION_FOUND_FOR_SCRLAR_VARIABLE		*
 *	Hong 07/01/09 QA80-13858 FAIL_IMPORT_JCAMP_FILE_WHICH_USE_COMMA_AS_DECIMAL	*
 *	Hong 11/24/09 QA80-14724 EXP_CSV_NEED_SUBFIX_FOR_PHONE_AND_ZIP_CODE			*
 *	Sophy 3/15/2011 ORG-2433-S1 SUPPORT_READ_MULTI_DIMENSION_TEXT_WAVE_INTO_WORKSHEET
 *------------------------------------------------------------------------------*/


#ifndef _OEXTFILE_H
#define _OEXTFILE_H

#ifdef __AFX_H__
	#ifndef _OEXT_FILE_
		#pragma message("$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$we are NOT in oExtFile dll, but some other DLL")
	#else
		#pragma message("$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$we are in oExtFile dll")
	#endif

	#ifdef _OEXT_FILE_
		#define OC_API __declspec(dllexport)
	#else
		#define OC_API __declspec(dllimport)
	#endif
	//----- CPY 11/13/06 QA70-9126 TEST_GET_STRINGS_FROM_MAT
	//#define uint UINT
	//#define TreeNode	OCXmlWrapperBase
	//#define	string		CString
	/// ML 10/13/2006 QA70-9053 PASSING_file_OBJECT_FROM_OC_TO_VC_FUNCS_BY_PTR
	////#define file		CScriptMocaObject
	//#define file		CFile
	/// end PASSING_file_OBJECT_FROM_OC_TO_VC_FUNCS_BY_PTR
	#include "OCtoVC.h"
	//------
	extern "C" {
		#pragma message("$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$ extern C in oExtFile.h")
#else
	#define OC_API
	#pragma dll(oExtFile)	// Associate all functions below to oExtFile.dll which must be in the Origin EXE folder
#endif	//__AFX_H__


#define IMPTREE_NODE_DIMS 		"Dimensions"
#define IMPTREE_NODE_VARS 		"Variables"
#define IMPTREE_NODE_1D			"Var1D"
#define IMPTREE_NODE_2D			"Var2D"
#define IMPTREE_NODE_3D			"Var3D"
#define IMPTREE_NODE_4D			"Var4D"
#define IMPTREE_NODE_GATTS		"GlobalAttributes"
#define IMPTREE_NODE_VARDIMS	"VarDims"
#define IMPTREE_NODE_VARTYPE	"VarType"


enum {
	EXT_CONVERT_DOUBLE = 0x00000001,	// convert filling and missing value of netcdf file into Origin missing value
};

#define EXT_NOERR	0
#define EXT_NETCDF_ERR_BEGIN 100

enum {
	EXT_NETCDF_NOERR	= EXT_NOERR,
	EXT_NETCDF_ERR_DIM	= EXT_NETCDF_ERR_BEGIN,
	EXT_NETCDF_ERR_MEMORY,
	EXT_NETCDF_ERR_VAR,
	EXT_NETCDF_ERR_TYPE,
};

///---Sim 10-10-2006 FORMULA_ID
enum{
	MDF_FM_PARALINE = 0,
	MDF_FM_TABINTERP,
	MDF_FM_TAB,
	MDF_FM_POLYFUNC = 6,
	MDF_FM_EXPFUNC,
	MDF_FM_LOGFUNC,
	MDF_FM_ASAP2RCF,
	MDF_FM_ASAMMCD2TF,
	MDF_FM_ASAMMCD2TT,
	MDF_FM_ASAMMCD2TRT,
	MDF_FM_DATE = 132,
	MDF_FM_TIME = 133,
	MDF_FM_NONE = 65535,
};
///---END FORMULA_ID

#define STR_NETCDF_SCALAR_VARAILBE_DIMENSION_LABEL		"No Dimensions Found" /// Hong 07/24/08 QA80-10707 USING_NO_DIMENSION_FOUND_FOR_SCRLAR_VARIABLE

/**$ >Netcdf
		Open a netcdf file. If ptrNCHeader is present, put all dimensions, variables and global attributes into tree.
		Need to call netcdf_close function to close nc file.
	Parameters:
		lpcszNCFile = [Input]netcdf file name
		ptrNCHeader = [Output]netcdf file dimensions, variables and global attributes info tree
	Example1:
		void test_netcdf(string strFileName)
		{
			// Open file first
			int ncid = netcdf_open(strFileName);
			if( ncid < 0 )
			{
				out_int("failed to open, err = ", ncid);
				return ;
			}
			
			Tree trVars;
			netcdf_get_vars_info(&trVars);
			
			// Close netcdf file
			netcdf_close();
		}
	Return:
		return file id, NC_BAD(-1) if failed
*/
OC_API int netcdf_open(LPCSTR lpcszNCFile, TreeNode* ptrNCHeader = NULL);

/**$ >Netcdf
		Get all variable's info into a tree. Variable will be put into different branch according its dimension.
		The netcdf file must be opened first.
	Parameters:
		ptrVars = [Input]netcdf file variables info tree
	Example1:
		void test_netcdf(string strFileName)
		{
			// Open file first
			int ncid = netcdf_open(strFileName);
			if( ncid < 0 )
			{
				out_int("failed to open, err = ", ncid);
				return ;
			}
			
			Tree trVars;
			netcdf_get_vars_info(&trVars);
			
			// Close netcdf file
			netcdf_close();
		}
	Return:
		return file id, NC_BAD(-1) if failed
*/
OC_API int netcdf_get_vars_info(TreeNode* ptrVars);

/**$ >Netcdf
		Close netcdf file opened before. It frees the global variable list on the stack.
	Parameters:
	Example1:
		void test_netcdf(string strFileName)
		{
			// Open file first
			int ncid = netcdf_open(strFileName);
			if( ncid < 0 )
			{
				out_int("failed to open, err = ", ncid);
				return ;
			}
			
			Tree trVars;
			netcdf_get_vars_info(&trVars);
			
			// Close netcdf file
			netcdf_close();
		}
	Return:
		return file id, NC_BAD(-1) if failed
*/
OC_API int netcdf_close();

/**$ >Netcdf
		Get netcdf variable data into Origin range no matter how many dimensions variable has. 
	Parameters:
		lpcszVar = [Input]var name
		lpcszRange = [Input]Origin range, like "[Book1]Data1!B", "[MBook1]1!1"
		dwCtrl = [Input]flags
	Example1:
		int GetVarData(string str, string strRange = "[Book1]Data1!B")
		{
			return netcdf_get_vector(str, strRange);
		}
	Return:
		return EXT_NETCDF_NOERR if succeed.
*/
OC_API int netcdf_get_vector(LPCSTR lpcszVar, LPCSTR lpcszRange, DWORD dwCtrl = EXT_CONVERT_DOUBLE);

/**$ >Netcdf
		Get variables's type and dimension info, pDim's size should be set. 
	Parameters:
		lpcszVar = [Input]var name
		pDim = [Output]var dimension array, size should be set 
		pnDataType = [Output]var data type
		pstrUnit = [Output]var Unit attribute
		pstrLongName = [Output]var LongName attribute
		pstrComments = [Output]var Comments attribute
	Example1:
		void GetVarInfo(LPCSTR lpcszVar)
		{
			string strUnit, strLongName, strComments;
			int nType;	
			vector<int> vnDim(NC_MAX_VAR_DIMS);
			vnDim = 0;
			netcdf_get_var_info(lpcszVar, vnDim, &nType, &strUnit, &strLongName, &strComments);
		}
	Return:
		return the number of variable dimensions.
*/
OC_API int netcdf_get_var_info(LPCSTR lpcszVar, int* pDim, int* pnDataType, string *pstrUnit = NULL, string *pstrLongName = NULL, string *pstrComments = NULL, byte* lpbuff = NULL);

/**$ >Netcdf
		Get nc variable data into oc vector/mat. 
	Parameters:
		pData = [Output]data buffer
		lpcszVar = [Input]var name
		pDim = [Input]pDim is refer dim and must be zero terminated
Example1:
		// Refer dim must be zero terminated, for example:
		//  vector<int> vnRef = {1, 1, 0};
		//  vector<int> vnRef = {1, 4, 0};
		//  vector<int> vnRef = {1, 1, 2, 0}; 
		int GetVarVec(LPCSTR lpcszVar, Worksheet &wks, int nIndex, vector<int> &vnRef, int nType, int nSize)
		{
			int nRet = 0;
			Column col = wks.Columns(nIndex);
			if( col.IsValid() )
			{
				col.SetInternalData(nType);
				
				switch( nType )
				{
				case FSI_REAL:
					Dataset<float> ds(wks, nIndex);
					ds.SetSize(nSize);
					nRet = netcdf_get_f_vec(ds, lpcszVar, vnRef);
					break;
					
				case FSI_DOUBLE:
					Dataset<double> ds(wks, nIndex);
					ds.SetSize(nSize);
					nRet = netcdf_get_d_vec(ds, lpcszVar, vnRef);
					break;
					
				case FSI_LONG:
					Dataset<int> ds(wks, nIndex);
					ds.SetSize(nSize);
					nRet = netcdf_get_i_vec(ds, lpcszVar, vnRef);
					break;
					
				case FSI_SHORT:
					Dataset<short> ds(wks, nIndex);
					ds.SetSize(nSize);
					nRet = netcdf_get_s_vec(ds, lpcszVar, vnRef);
					break;
					
				default:
					break;
				}
			}
			return nRet;
		}
	Return:
		return EXT_NETCDF_NOERR if succeed.
*/
OC_API int netcdf_get_f_vec(float* pData, LPCSTR lpcszVar, int* pDim); 
OC_API int netcdf_get_d_vec(double* pData, LPCSTR lpcszVar, int* pDim);
OC_API int netcdf_get_i_vec(int* pData, LPCSTR lpcszVar, int* pDim); 
OC_API int netcdf_get_s_vec(short* pData, LPCSTR lpcszVar, int* pDim);
OC_API int netcdf_get_b_vec(BYTE* pData, LPCSTR lpcszVar, int* pDim);

/**$ >Netcdf
		Get nc variable data into oc vector/mat. 
	Parameters:
		pData = [Output]data buffer
		lpcszVar = [Input]var name
		pDim = [Input]pDim is refer dim and must be zero terminated
Example1:
		// Refer dim must be zero terminated, for example:
		//  vector<int> vnRef = {1, 0, 0}; // will read the 1st 2 dim data of 3D netcdf var
		//  vector<int> vnRef = {4, 0, 0}; // will read the 4th 2 dim data of 3D netcdf var
		//  vector<int> vnRef = {1, 2, 0, 0}; // will read the 2nd 2 dim data of 4D netcdf var
		// MatrixLayer matl need to be set with number of matrix object and size (row and col).
		int GetVarMat(LPCSTR lpcszVar, MatrixLayer &matl, int nIndex, vector<int> &vnRef, int nType)
		{
			int nRet = 0;
			switch( nType )
			{
			case FSI_REAL:
				Matrix<float> mm(matl, nIndex);
				nRet = netcdf_get_f_mat(mm, lpcszVar, vnRef);
				break;
				
			case FSI_DOUBLE:
				Matrix<double> mm(matl, nIndex);
				nRet = netcdf_get_d_mat(mm, lpcszVar, vnRef);
				break;
				
			case FSI_LONG:
				Matrix<int> mm(matl, nIndex);
				nRet = netcdf_get_i_mat(mm, lpcszVar, vnRef);
				break;
				
			case FSI_SHORT:
				Matrix<short> mm(matl, nIndex);
				nRet = netcdf_get_s_mat(mm, lpcszVar, vnRef);
				break;
				
			default:
				break;
			}
			
			return nRet;
		}
	Return:
		return EXT_NETCDF_NOERR if succeed.
*/
OC_API int netcdf_get_f_mat(float* pData, LPCSTR lpcszVar, int* pDim); 
OC_API int netcdf_get_d_mat(double* pData, LPCSTR lpcszVar, int* pDim);
OC_API int netcdf_get_i_mat(int* pData, LPCSTR lpcszVar, int* pDim); 
OC_API int netcdf_get_s_mat(short* pData, LPCSTR lpcszVar, int* pDim); 
OC_API int netcdf_get_b_mat(BYTE* pData, LPCSTR lpcszVar, int* pDim); 

/**$ >Netcdf
		Get dimension variables's scale. 
	Parameters:
		lpcszVar = [Input]var name
		nDim = [Input]the i-th dimension of variable 
		pDimName = [Output]dimension variable name
		pBeg = [Output]dimension var scale first value
		pEnd = [Output]dimension var scale last value
		pInc = [Output]dimension var scale increasement
	Example1:
		void GetVarInfo(LPCSTR lpcszVar)
		{
			string strName;
			double dBeg, dEnd, dInc;
			dBeg = dEnd = dInc = 0.0;
			for( int ii = 1; ii <=3; ii++ )
			{
				netcdf_get_var_dim_scale(lpcszVar, ii, &strName, &dBeg, &dEnd, &dInc);
			}		
		}
	Return:
		return false if data in that dim scale is not equal spaced. 
		if returns false, then caller needs to call netcdf_get_d_vec(vDim, strDimName, NULL); // NULL to get Dim variable
*/
OC_API BOOL netcdf_get_var_dim_scale(LPCSTR lpcszVar, int nDim, string* pDimName, double* pBeg, double* pEnd, double* pInc);

/// Hong 10/9/06 IMPORT_MDF_INTO_ORIGIN
/**$
*/
OC_API BOOL mdf_put_float_point_data_to_range(LPCSTR lpcszRange, int nNumRecords, int nRecordSize, BYTE* lpData, int nDataType);
/**$
*/
OC_API BOOL mdf_put_text_data_to_range(LPCSTR lpcszRange, int nNumRecords, int nRecordSize, BYTE* lpData, int nTextCellSize);
//OC_API BOOL mdf_put_bits_data_to_range(LPCSTR lpcszRange, int nNumRecords, int nRecordSize, BYTE* lpData, int nSkipNumBits, int nNumberBits);
/**$
*/
OC_API BOOL mdf_put_integer_data_to_range(LPCSTR lpcszRange, int nNumRecords, int nRecordSize, BYTE* lpData, int nSignalType, int nSkipNumBits, int nNumberBits);
/**$
*/
OC_API BOOL mdf_put_data_to_range(LPCSTR lpcszRange, int nNumRecords, int nRecordSize, BYTE* lpData, int nSignalType, int nSkipNumBits, int nNumberBits);
/// end IMPORT_MDF_INTO_ORIGIN

///---Sim 10-10-2006 MDF_COL_APPLY_FORMULA
/**$
*/
OC_API BOOL mdf_apply_formula(double* pData, uint nSize, TreeNode* pTrInfo);
///---END MDF_COL_APPLY_FORMULA

//---------------- CPY 10/13/06 QA70-9050 DATA_ACCESS_AS_TEXT
// this is currrnetly not shared between VC and OC, later if we need to add
// more options we will need to move this into oc_const.h, see utilsdk.h
/*enum {   //-----Cheney redefinition, move this to oc_const.h
	GDAT_FULL_PRECISION = 0x0001,
	GDAT_MISSING_AS_DASHDASH = 0x0002,
};*/

///Cheney 2007-2-10 SUPPORT_EXPORT_SAMPLE_INTERVAL_AS_NEW_COL
//OC_API int export_ascii_data(file* pOCfile, LPCSTR lpcszBook, LPCSTR lpcszSheet, uint nRSize, int* pR1, int* pR2, uint nCSize, int* pC1, int* pC2, LPCSTR lpcszSep, BOOL bCheckAddQuotes = FALSE, BOOL bLabel = FALSE, DWORD dwCntrl = GDAT_FULL_PRECISION);
//pAddXCol is for export sampling interval as new col
//pAddXCol's size will be export wks's column or select column number,
//if pAddXCol[ii] == 0, no sampling interval in this column, if pAddXCol[ii] == 1, has it.
//pX0 and pXInc is sampling interval's start and increment
//those two arrays' size is equal to how many "1" in pAddXCol
//e.g, if pAddXCol = {1, 0 ,0, 1}
//maybe pX0 could be {0, 1},  pXInc could be {0.5, 0.5}
//means, column 1 has sampleing interval: 0/0.5, column 4 is 1/0.5
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Export_ascii_data_(global_function)
*/
/// Hong 10/16/09 QA80-13230-P5 EXPORT_ASCII_FAIL_WITH_SHEET_NAME_ALL_NUMERIC
//OC_API int export_ascii_data(file* pf, LPCSTR lpcszBook, LPCSTR lpcszSheet, uint nRSize, 
//							 int* pR1, int* pR2, uint nCSize, int* pC1, int* pC2, LPCSTR lpcszSep, 
//							 BOOL bCheckAddQuotes = FALSE, BOOL bLabel = FALSE, int* pAddXCol = NULL, double* pX0 = NULL, double* pXInc = NULL, DWORD dwCntrl = GDAT_FULL_PRECISION);
/// Hong 11/24/09 QA80-14724 EXP_CSV_NEED_SUBFIX_FOR_PHONE_AND_ZIP_CODE
//OC_API int export_ascii_data(file* pf, LPCTSTR lpcszWksRange, uint nRSize, 
//							 int* pR1, int* pR2, uint nCSize, int* pC1, int* pC2, LPCSTR lpcszSep, 
//							 BOOL bCheckAddQuotes = FALSE, BOOL bLabel = FALSE, int* pAddXCol = NULL, double* pX0 = NULL, double* pXInc = NULL, DWORD dwCntrl = GDAT_FULL_PRECISION);
//OC_API int export_ascii_data(file* pf, LPCTSTR lpcszWksRange, uint nRSize, 
//							 int* pR1, int* pR2, uint nCSize, int* pC1, int* pC2, LPCSTR lpcszSep, 
//							 BOOL bCheckAddQuotes = FALSE, BOOL bLabel = FALSE, int* pAddXCol = NULL, double* pX0 = NULL, double* pXInc = NULL, DWORD dwCntrl = GDAT_FULL_PRECISION);
OC_API int export_ascii_data(file* pf, LPCTSTR lpcszWksRange, uint nRSize, 
							 int* pR1, int* pR2, uint nCSize, int* pC1, int* pC2, LPCSTR lpcszSep, 
							 BOOL bCheckAddQuotes = FALSE, BOOL bLabel = FALSE, int* pAddXCol = NULL, double* pX0 = NULL, double* pXInc = NULL, DWORD dwCntrl = GDAT_FULL_PRECISION, LPCSTR lpcszSubfix = NULL);
/// end EXP_CSV_NEED_SUBFIX_FOR_PHONE_AND_ZIP_CODE
/// end EXPORT_ASCII_FAIL_WITH_SHEET_NAME_ALL_NUMERIC
///end 	SUPPORT_EXPORT_SAMPLE_INTERVAL_AS_NEW_COL

///Joseph 11/15/06 EXPORT_DATA_FROM_MATRIX
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Export_matrix_ascii_data_(global_function)
*/
/// Hong 10/16/09 QA80-13230-P5 EXPORT_ASCII_FAIL_WITH_SHEET_NAME_ALL_NUMERIC
//OC_API int export_matrix_ascii_data(file* pf, LPCSTR lpcszBook, LPCSTR lpcszSheet, uint nRSize, uint nCSize, LPCSTR lpcszSep, StringArray* vsXCorrid = NULL, StringArray* vsYCoorid = NULL, DWORD dwCntrl = GDAT_FULL_PRECISION);
OC_API int export_matrix_ascii_data(file* pf, LPCTSTR lpcszWksRange, uint nRSize, uint nCSize, LPCSTR lpcszSep, StringArray* vsXCorrid = NULL, StringArray* vsYCoorid = NULL, DWORD dwCntrl = GDAT_FULL_PRECISION);
/// end EXPORT_ASCII_FAIL_WITH_SHEET_NAME_ALL_NUMERIC
///End 	EXPORT_DATA_FROM_MATRIX

///Cheney 2006-10-17  HANDLE_QUOTE_FOR_CSV_FORMAT_FILE
/**$
		This function check to add double quote for string if file is csv format.
		1.if string has quote, this quote should be change to double quotes.
		  and this string should be double quoted.	
		2.if string has "\n",  it should be double quoted
		3.if string has ",",  it should be double quoted
	return:
		if add quote, return TRUE; else return FALSE.
*/
///Sophy 11/21/2011 ORG-3418-P1 FLEXIBLE_SEPARATOR_FOR_CSV_EXPORT
//OC_API BOOL check_to_add_quote_for_csv(string* pstr);
OC_API BOOL check_to_add_quote_for_csv(string* pstr, LPCSTR lpcszSep = NULL);
///end FLEXIBLE_SEPARATOR_FOR_CSV_EXPORT
/**$
		This function check to replace line feed("\r\n" or "\n") by space for string if file is 
		not csv format.
	return:
		if repleace, return TRUE; else return FALSE.
*/
OC_API BOOL check_to_replace_line_feed_by_space(string* pstr);
///end 	HANDLE_QUOTE_FOR_CSV_FORMAT_FILE

///Cheney 2006-10-24 HANDLE_FEED_LINE_FOR_CSV_FORMAT_FILE
/**$
		This function check to replace carriage return and line feed pair("\r\n") by line 
		feed("\n") for string if file is csv format.
	return:
		if repleace, return TRUE; else return FALSE.
*/
OC_API BOOL check_to_replace_crlf_by_lf(string* pstr);
///end HANDLE_FEED_LINE_FOR_CSV_FORMAT_FILE

//----------------
//----- CPY 11/13/06 QA70-9126 TEST_GET_STRINGS_FROM_MAT
/**$
*/
/// Hong 10/16/09 QA80-13230-P5 EXPORT_ASCII_FAIL_WITH_SHEET_NAME_ALL_NUMERIC
//OC_API int get_data_as_text(StringArray* pocsa, LPCSTR lpcszBook, LPCSTR lpcszSheet, int nCol, int nR1, int nR2, DWORD dwCntrl);
OC_API int get_data_as_text(StringArray* pocsa, LPCSTR lpcszWksRange, int nCol, int nR1, int nR2, DWORD dwCntrl);
/// end EXPORT_ASCII_FAIL_WITH_SHEET_NAME_ALL_NUMERIC
//-----

///Cheney 2006-12-20 SUPPORT_IMPORT_JCAMP_FILE
/**$
		This function is used to read jcamp file data.
	return:
		return 0 if succeed.
*/
OC_API int jcamp_read_data(LPCSTR lpcszfname, int nPostion, int nCurrentVarType, int nCurrentDataType, LPCSTR lpcszXColRange, LPCSTR lpcszYColRange, double dDeltaX, int* pArraySize, DWORD dwOption = 0);
/**$
		This function is used to get deltaX when data var type is JCAMP_VAR_XYYY, 
		JCAMP_VAR_XRRR or JCAMP_VAR_XIII and file doesn't exist lable "DELTAX"
	return:
		return 0 if succeed.
*/
OC_API double jcamp_get_deltaX(LPCSTR lpcszfname, int nPostion, int nCurrentDataType);
/**$
		This function is used to get data type when data var type is JCAMP_VAR_XYYY, 
		JCAMP_VAR_XRRR or JCAMP_VAR_XIII: check it if is compress or not
	return:
		return 0 if succeed.
*/
OC_API int jcamp_get_data_type(LPCSTR lpcszfname, int nPostion);
///end SUPPORT_IMPORT_JCAMP_FILE

/// Hong 07/01/09 QA80-13858 FAIL_IMPORT_JCAMP_FILE_WHICH_USE_COMMA_AS_DECIMAL
/**$
*/
OC_API int jcamp_check_convert_comma_decimal_to_dot(LPSTR lpstr, BOOL* pbCheck);
/// end FAIL_IMPORT_JCAMP_FILE_WHICH_USE_COMMA_AS_DECIMAL

///Cheney 2006-12-26 SUPPORT_IMPORT_DIADEM_DAT_FILE
/**$
		This function is used to read channel or block data to buffer when data is explicit stored
	return:
		return 0 if succeed.
*/
OC_API int diadem_read_explicit_data(void* pData, LONG nBufLength, LPCSTR lpcszDataFileName, LONG nFileOffset, 
				int nStoreMethod, int nChannelDatatype, DWORD dwDataSize);
/**$
		This function is used to get one column data from buffer when data is explicit stored
		and block-wise for all data type except ASC
	return:
		return 0 if succeed.
*/
OC_API int diadem_get_explicit_data_block(LPCSTR lpcszColRange, void* pData, LONG nBufLength, LONG nColLength, 
									int nChannelDatatype, DWORD dwDataSize, double dFactor, double dOffset, 
									int nBlockChannels, int nBlockChannelIndex, bool bLittleEndian = false);
/**$
		This function is used to get one column data from buffer when data is explicit stored
		and channel-wise for all data type except ASC
	return:
		return 0 if succeed.
*/
OC_API int diadem_get_explicit_data_channel(LPCSTR lpcszColRange, void* pData, LONG nBufLength, LONG nColLength, 
									int nChannelDatatype, DWORD dwDataSize, double dFactor, double dOffset, 
									bool bLittleEndian = false);
/**$
		This function is used to get one column data from file when channel store and ASC type
		bReadChannel for channel select
		bCommaDecimal for decimal is comma
		bReadAsBinary for ASCII file's string is binary sting, like "100",
			if true, will read as 100, else will convert to 4 
		bDateData and lpcszDateFmt is for convert date data string to double
	 return:
		return 0 if succeed.
*/
OC_API int diadem_get_asc_data(LPCSTR lpcszColRange, LONG nColLength, LPCSTR lpcszDataFileName, int* pCurrentPos,  
							   bool bReadChannel = true, bool bCommaDecimal = false, bool bBinaryString = false, 
							   bool bReadAsBinary = false, bool bDateData = true, LPCSTR lpcszDateFmt = NULL);
///end SUPPORT_IMPORT_DIADEM_DAT_FILE

/**$
		This function is used to get one column data from file when channel store and ASC type
		just read as string, not convert to double
	 return:
		return 0 if succeed.
*/
OC_API int diadem_get_asc_data_as_string(StringArray* saArray, LPCSTR lpcszDataFileName, int* pCurrentPos);


/**$
		This function is used to read a 1-dimenstion wave (d2, d3, d4) in a IgorPro wave file into a worksheet range
	 return:
		return 0 if succeed.
*/
OC_API int igp_read_data(LPCSTR lpcszRange, file *fin, int BaseOffset, void *pInfo, int d2, int d3, int d4, int nMode);


///Sophy 3/15/2011 ORG-2433-S1 SUPPORT_READ_MULTI_DIMENSION_TEXT_WAVE_INTO_WORKSHEET
/**$
		This function is used to read a multi-dimension wave in a IgorPro wave file into string array
*/
OC_API int igp_read_data_text(StringArray* pArr, file* fin, int BaseOffset, void* pInfo, int nMode);
///end SUPPORT_READ_MULTI_DIMENSION_TEXT_WAVE_INTO_WORKSHEET

/**$
		This function is used to read a 2-dimension wave (d3, d4) in a IgorPro wave file into a matrix
	 return:
		return 0 if succeed.
*/
OC_API int igp_read_data_m(void *pWave, file *fin, int BaseOffset, void *pInfo, int d3, int d4, int nMode);

/**$
		This function is used to read the wave header in a IgorPro file into *pInfo
	 return:
		return 0 if succeed.
*/
OC_API int igp_read_header(file *fin, int BaseOffset, void *pInfo, int nMode);

/**$
		This function is used to read the structure (tree-type) of a IgorPro packed file 
	 return:
		return 0 if succeed.
*/
OC_API int igp_construct_pxp_tree(file *fin, int depth, TreeNode *tr, int nPlatform = 2);

/**$
		This function is used to read the variables in a IgorPro packed file 
	 return:
		return 0 if succeed.
*/
OC_API int igp_get_variables(file *pfin, int BaseOffset, TreeNode *ptr);



OC_API int heka_read_pulse(file *pfin, int nOffset, TreeNode *ptrPul, short nVer);

OC_API int heka_read_stim(file *pfin, int nOffset, TreeNode *ptrStim, short nVer);

OC_API int heka_read_bundle_header(file *pfin, TreeNode *ptrPul, TreeNode *ptrStim);

OC_API int heka_read_zerotrace(LPCSTR lpcszRange, file *pfin, int nOffset, int nSize, int nFormat, int nType, double nScaler, double ZeroData);

OC_API int heka_read_leaktrace(LPCSTR lpcszRange, file *pfin, int nOffset, int nSize, int nFormat, int nType, double nScaler, double ZeroData, int nLeakCount);

/// Hong 02/10/10 QA80-15094 HEKA_SUPPORT_BIGENDIAN_FILE_CREATED_IN_MAC
//OC_API int heka_read_parameter(file *fin, int nOffset, int nType, void *pParam);
OC_API int heka_read_parameter(file *fin, int nOffset, int nType, void *pParam, BOOL bNeedReverse = FALSE);
/// end HEKA_SUPPORT_BIGENDIAN_FILE_CREATED_IN_MAC

#ifdef __AFX_H__
	}
#endif	//__AFX_H__

#endif //_OEXTFILE_H
