/*------------------------------------------------------------------------------*
 * File Name: matrix.h															*
 * Creation: TCZ 07/22/2001														*
 * Purpose: Origin C internal utility classes									*
 * Copyright (c) OriginLab Corp.2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007	*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * ER 01/29/03 QA70_3802	ADD_VECTOR_FFT_IFFT									*
 * Ryan Tan 07/07/04 QA70_5528 ADD_REPLACE_MISSING_VALUE						*
 * Sandy 7/12/06 MOVE_FFT_RELATIVE_FUNCIONS_BACK_TO_FFT_UTILS					*
 * Justin 2007-04-04 MODIFY FUNCTION CATEGORY									*
 *------------------------------------------------------------------------------*/

#ifndef _MATRIX_H
#define _MATRIX_H

///Sandy 2006-11-23 MATRIX_COLS_LIMIT

// CPY 11/23/2006 the reason for this limit is for making image plot from a data matrix
// there is a limitation for showing image in the reverse Y direction that is typical of image
// plot where Ys positive direction is up while image coordinates typically is to start from
// top-left and positive is going down. When the number of pixels per scan line is greater then
// range for short int(32767), Window seems to have trouble drawing the image when the scan lines (Y) is flipped.
// until MS fixes this bug (StretchDIBits), we have to limit the matrix output
#define MAX_OUTPUT_MATRIX_COLS 32767 //65536

///end
/*
//////////////////////////////////////////////////////////////////////////////////////
This header file will contain some matrix related global functions implemented in originC level.
We already have some functions implemented as member functions of the matrix class internally. 
To complement those functions, we add some necessary but not as basic as the member functions here.
*/


//  	This function will take a matrix and set the result matrix accoring to the parameter values.
//	in other words, it will do the neccessory padding with zero or truncting.
// Comments last updated by  Arvin on 2007-04-14
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:set_matrix_with_padding_truncting_(global_function)
*/
int set_matrix_with_padding_truncting(matrix & matSource, matrix & matResult, int nRowProcess , int nColProcess);


//   This function will take care of the complex data matrix and sperate it into two double matrix.
// Comments last updated by  Arvin on 2007-04-14
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:seperate_complex_mat_to_real_and_imag_mat_(global_function)
*/
int seperate_complex_mat_to_real_and_imag_mat(matrix<complex>& matSource, matrix& matReal, matrix&  matImag, int nRowProcess, int nColProcess);

// Comments last updated by  Arvin on 2007-04-14
//Category last updated by Justin on 2007-04-04
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:SVD_(global_function)
*/
int SVD(matrix<complex>& matSource, matrix& matS, matrix<complex>& matU, matrix<complex>& matV);

// Comments last updated by  Arvin on 2007-04-14
//Category last updated by Justin on 2007-04-04
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:SVD_(global_function)
*/
int SVD(matrix<complex>& matSource, matrix& matS); 

// Comments last updated by  Arvin on 2007-04-14
//Category last updated by Justin on 2007-04-04
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:SVD_(global_function)
*/
int SVD(matrix& matSource, matrix& matS);
// Comments last updated by  Arvin on 2007-04-14
//Category last updated by Justin on 2007-04-04
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:SVD_(global_function)
*/
int SVD(matrix& matSource, matrix& matS, matrix& matU, matrix& matV);

// Comments last updated by  Arvin on 2007-04-14
// Comments last updated by LAS on 02/25/2005
//Category last updated by Justin on 2007-04-04
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Trace_(global_function)
*/
int Trace(matrix<short> & matSource, int & nSum);

//Category last updated by Justin on 2007-04-04
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Trace_(global_function)
*/
int Trace(matrix<int> & matSource, int & nSum);

//Category last updated by Justin on 2007-04-04
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Trace_(global_function)
*/
int Trace(matrix<double> & matSource, double & dSum);

//Category last updated by Justin on 2007-04-04
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Trace_(global_function)
*/
int Trace(matrix<complex> & matSource, complex & cSum);


//define a structure here to hold the summary results
typedef struct tagMatrixStats
{
	int nMissingValue; //hold the number of missing value
	double dMean;//hold the mean value;
	double dSD; //hold the standard deviation
	double dMax; //hold the maximun value;
	double dMin; //hold the minimum value;
	double dMedian;//hold the median value
	double dLowHinge; //hold the lower hinge
	double dUpHinge; //hold the upper hinge
	double dWSum; //hold the sum of the weights
	
}MatrixStats;
#define MAT_ERR_WEIGHTS_DATA_SIZE_NOT_MATCH (-5)
// Comments last updated by LAS on 02/25/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MatrixBasicStats_(global_function)
*/
int MatrixBasicStats(matrix & mData, MatrixStats & sMatStatsSum, matrix * mpWeights = NULL);

#if _OC_VER >= 0x0800
// Comments last updated by  Arvin on 2007-04-14
// Comments last updated by LAS on 02/28/2005
//Ryan Tan 07/07/04 QA70_5528 ADD_REPLACE_MISSING_VALUE
/**#
	Remark:
		Replace missing values in matrix with the nearest real numbers
	Keywords:
		matrix,replace missing values; Matrix,replace missing values; replace missing values
 	Example1:
 		int replace_missing_value_ex1()
 		{
			matrix matSource = {{1,2,3},{5,6,7},{9,10,11}};
			printf("the source matrix\n");
			int ii, jj;
			int nNumCols = matSource.GetNumCols();
			int nNumRows = matSource.GetNumRows();
			for(ii = 0; ii < nNumRows; ii++)
			{
				for(jj = 0; jj < nNumCols; jj++)
					printf("%f  ",matSource[ii][jj]);
				printf("\n");	
			}
		
			if(!replace_missing_value(matSource, true, false ))
				return -1;
			
			printf("The Result Matrix:\n");
			for(ii = 0; ii < nNumRows; ii++)
			{
				for(jj = 0; jj < nNumCols; jj++)
					printf("%f  ",matSource[ii][jj]);
				printf("\n");	
			}
			
			return 0;
 		}
	Parameters:
		mData =[input]a matrix of data.
		bIsRowWise =[input]if true, replace with row-wise; if false, with column-wise.
		bIncludeEdge =[input]missing values at both edges are replaced with the nearest real number, if true.
	Return:
		if succeed, return 1, otherwise, return 0.
	SeeAlso:
	
 */
int replace_missing_value( matrix& mData, bool bIsRowWise = true, bool bIncludeEdge = false );
#endif //_OC_VER >= 0x0800

#endif //_MATRIX_H























 



