/*

This file is used to specify the version of LEADTools that Origin should use.
This file is needed to avoid having to make multiple changes whenever we want
to change the version of LEADTools.

There are currently 3 places where this file is included:
	\c\vc32\okern96\OKImgFil.h
	\c\module\oimg\lead.h
	\c\module\oimglt\lead.h

*/
//--------------------------------------------------------------------------
// Modification Log:
// EJP 2006-07-26 v8.0451 QA70-8860 LEADTOOLS_UNICODE
// EJP 2010-09-11 ORG-164 UPGRADE_LEADTOOLS_TO_VER_17
// ML 1/3/2011 LEADTOOLS_64bit
/// ML 6/23/2011 LEADTOOLS_O9_PROPER_VERSION_IN_OC
/// RVD 7/6/2011 OIMG_LINK_ERROR
//--------------------------------------------------------------------------

#ifndef _LT_VER_H
#define _LT_VER_H

/// ML 1/3/2011 LEADTOOLS_64bit
#ifdef		__NOT32
	#define		__LEADTOOLS_64bit__		// 64bit
#endif		// __NOT32

/// ML 6/23/2011 LEADTOOLS_O9_PROPER_VERSION_IN_OC
//#ifdef		__DLL_NAMES_ORIGIN_9_OR_LATER__			// 64bit
//
//	#define LEADTOOLS_VER		17 // per Eric Parent: we want to use ver 17 for O9.
//
//#else		// !__DLL_NAMES_ORIGIN_9_OR_LATER__
///// end LEADTOOLS_64bit
#if			defined(_ORIGIN_VER_9_0_) && !defined(_VC6_COMPILER_)			// O9 ir later

	#define LEADTOOLS_VER		17 // per Eric Parent: we want to use ver 17 for O9.

#else		// !(defined(_ORIGIN_VER_9_0_) && !defined(_VC6_COMPILER_))
/// end LEADTOOLS_64bit
/// end LEADTOOLS_O9_PROPER_VERSION_IN_OC

/// EJP 2010-09-11 ORG-164 UPGRADE_LEADTOOLS_TO_VER_17, preparing for LeadTools 17
//////#define LEADTOOLS_VER		12
///#define LEADTOOLS_VER		14
///#define LEADTOOLS_VER_STR	"14"
/// RVD 7/6/2011 OIMG_LINK_ERROR
//#define LEADTOOLS_VER		14 // set this value to 14 or 17
#define LEADTOOLS_VER		17
/// end OIMG_LINK_ERROR
/// end UPGRADE_LEADTOOLS_TO_VER_17

/// ML 1/3/2011 LEADTOOLS_64bit
#endif		// !(defined(_ORIGIN_VER_9_0_) && !defined(_VC6_COMPILER_))
/// end LEADTOOLS_64bit


/// EJP 2006-07-26 v8.0451 QA70-8860 LEADTOOLS_UNICODE
// Define LEADTOOLS_UNICODE to use the Unicode build of LeadTools DLLs
//#define LEADTOOLS_UNICODE
/// end LEADTOOLS_UNICODE


/// EJP 2010-09-11 ORG-164 UPGRADE_LEADTOOLS_TO_VER_17
#if LEADTOOLS_VER == 17
#	define LTV17_CONFIG			// used in LeadTools header files
#	define LEADTOOLS_VER_STR	"17"
/// ML 1/3/2011 LEADTOOLS_64bit
/*
#ifdef		__LEADTOOLS_64bit__
#	define LEAD_LIB_SUFFIX		"_x.lib"
#	define LEAD_DLL_SUFFIX		"x.dll"
#else		// !__LEADTOOLS_64bit__
/// end LEADTOOLS_64bit
#	define LEAD_LIB_SUFFIX		"_u.lib"
#	define LEAD_DLL_SUFFIX		"u.dll"
/// ML 1/3/2011 LEADTOOLS_64bit
#endif		// !__LEADTOOLS_64bit__
*/

#define		LEAD_LIB_DLL_NAME_ENDING_32					"u"
#define		LEAD_LIB_DLL_NAME_ENDING_UPPER_CASE_32		"U"

#ifdef		__LEADTOOLS_64bit__
	#define		LEAD_LIB_DLL_NAME_ENDING				"x"
#else		// !__LEADTOOLS_64bit__
	#define		LEAD_LIB_DLL_NAME_ENDING	LEAD_LIB_DLL_NAME_ENDING_32
#endif		// !__LEADTOOLS_64bit__

#define			LEAD_EXT_LIB	".lib"
#define			LEAD_EXT_DLL	".dll"

#	define LEAD_LIB_SUFFIX		"_" LEAD_LIB_DLL_NAME_ENDING	LEAD_EXT_LIB
#	define LEAD_DLL_SUFFIX		LEAD_LIB_DLL_NAME_ENDING		LEAD_EXT_DLL

/// end LEADTOOLS_64bit
#	define L_FAR
#	define L_HUGE
#else
#	define LEADTOOLS_VER_STR	"14"
#	ifdef LEADTOOLS_UNICODE
#		define LEAD_LIB_SUFFIX		"_nu.lib"
#	else // !LEADTOOLS_UNICODE
#		define LEAD_LIB_SUFFIX		"_n.lib"
#	endif // !LEADTOOLS_UNICODE
#	define LEAD_DLL_SUFFIX			LEADTOOLS_VER_STR"n.dll"
#endif // !LEADTOOLS_VER == 17

/// ML 1/3/2011 LEADTOOLS_64bit
//#define LEAD_LIB_LTDIS		"ltdis"		LEAD_LIB_SUFFIX
//#define LEAD_LIB_LTDLGFILE	"ltdlgfile"	LEAD_LIB_SUFFIX
//#define LEAD_LIB_LTDLGKRN	"ltdlgkrn"	LEAD_LIB_SUFFIX
//#define LEAD_LIB_LTFIL		"ltfil"		LEAD_LIB_SUFFIX
//#define LEAD_LIB_LTIMG		"ltimg"		LEAD_LIB_SUFFIX
//#define LEAD_LIB_LTIMGCLR	"ltimgclr"	LEAD_LIB_SUFFIX
//#define LEAD_LIB_LTKRN		"ltkrn"		LEAD_LIB_SUFFIX
//#define LEAD_LIB_LVKRN		"lvkrn"		LEAD_LIB_SUFFIX
//
// Must be uppercased because of the table in okuUpdateSystemDllVersionNumbers():
#define	LEAD_NAME_LTDIS			"LTDIS"
#define	LEAD_NAME_LTDLGFILE		"LTDLGFILE"
#define	LEAD_NAME_LTDLGKRN		"LTDLGKRN"
#define	LEAD_NAME_LTFIL			"LTFIL"
#define	LEAD_NAME_LTKRN			"LTKRN"
#define	LEAD_NAME_LTIMGCLR		"LTIMGCLR"

#define LEAD_LIB_LTDIS		LEAD_NAME_LTDIS			LEAD_LIB_SUFFIX
#define LEAD_LIB_LTDLGFILE	LEAD_NAME_LTDLGFILE		LEAD_LIB_SUFFIX
#define LEAD_LIB_LTDLGKRN	LEAD_NAME_LTDLGKRN		LEAD_LIB_SUFFIX
#define LEAD_LIB_LTFIL		LEAD_NAME_LTFIL			LEAD_LIB_SUFFIX
#define LEAD_LIB_LTIMG		"ltimg"		LEAD_LIB_SUFFIX
#define LEAD_LIB_LTIMGCLR	LEAD_NAME_LTIMGCLR		LEAD_LIB_SUFFIX
#define LEAD_LIB_LTKRN		LEAD_NAME_LTKRN			LEAD_LIB_SUFFIX
#define LEAD_LIB_LVKRN		"lvkrn"		LEAD_LIB_SUFFIX
/// end UPGRADE_LEADTOOLS_TO_VER_17


#endif // !_LT_VER_H
