/*------------------------------------------------------------------------------*
 * File Name: common.h															*
 * Creation: CPY 7/14/2001														*
 * Purpose: OriginC header with common typedef and macros, must be included		*
 * Copyright (c) OriginLab Corp.	2001										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * EJP 02-25-2004 v7.5827 FEEDBACK_MACROS_FOR_LOCAL_DEBUGGING					*
 *	Hong 08/28/07 QA80-10310 MORE_VARIABLE_INFO_FOR_XF2GUI						*
 *	CPY 10/8/2007 QA70-10486 DEBUG_SHOULD_NOT_BE_DEFINED_AND_SHOULD_HAVE_NO_ASSERT
 *	Max 12/3/07 ADD_ENGLISH_GUI_FILE											*
 *	CPY 4/3/08 PA_FIT_CNTRL_OPEN_EMPTY_NO_ERR_MSG								*
 *	Sim 05-12-2009 QA80-13594 MAKE_USER_IMPORT_OC_CODE_COMPATIBLE				*
 *	Hong 06/01/09 REMOVE_BINARY_STORAGE_AFTER_EXPGRAPH_WHICH_IS_NOT_USED_ANYMORE*
 *	Hong 06/01/09 FIX_MR_FAIL_CHECK_ERROR_IF_INDEP_NOT_SPECIFIED				*
 *	Hong 06/02/09 QA80-12755 EXTRACT_WKS_ADD_START_COL_SUPPORT					*
 *	Folger 06/03/09 QA80-13713 GROBJ_NUMERIC_VARS_STORAGE_SUPPORT				*
 *	Sim 06-02-2009 QA80-4584 EXTRACT_WKS_SUPPORT_AUTO_UPDATE					*
 *	Fisher 06/05/09 QA80-13487  ADV_DIGITAL_FILTERING 							*
 *	Sophy 6/12/2009 IMPROVE_RISETIME_TOOL_FOR_OSCILLOSCOPE_SIGNAL_PROCESSING	*
 *	Hong 06/16/09 QA80-8061 SIMPE_PROJECT_OPENING_PASSWORD_PROTECTION_SUPPORT	*
 *	Folger 06/16/09 QA80-13787 XF_XYRANGE_OUTPUT_FAILS_TO_SET_EVEN_SAMPLING_WHEN_INPUT_X_USED_PARTIAL_ROW_NUMBER
 *	Sim 06-17-2009 QA80-13786-P2-P4 SPEEP_UP_LINEAR_FIT_WITHOUT_REPORT_TABLE	*
 *	Hong 06/17/09 QA80-13280 EXPORT_MULTI_PAGES_PDF_MORE_PRINT_OPTIONS			*
 *	Sim 06-18-2009 QA80-13403-P1 FIX_HISTOGRAMS_BIN_SETTINGS_ERROR_WHEN_LOAD_SR4_OPJ
 *	Kyle 06/19/2009 QA70-13423 SUPORT_GET_MENU_TEXT_FROM_OC						*
 *	Hong 06/18/09 QA80-8091-S2 ADD_PROJECT_AUDIT_LOG							*
 *	Hong 06/19/09 QA80-13790 FIX_HEADER_LINE_SETTING_BY_USER_NOT_USED_FOR_DETECT_NUM_COLS_IF_NULL_FILTER
 *	Sim 06-23-2009 NANOSIZER_WIZ_AUTO_UPDATE_SUPPORT							*
 *	Folger 06/25/09 NANOSIZER_DO_NOT_NEED_TO_SUPPORT_SWITCH_PEAK_LABEL_FOR_SR6	*
 *	Hong 06/26/09 QA80-13841 FIX_SMALL_VALID_FILE_IS_CONSIDER_AS_INVALID_FILE	*
 *	Folger 07/01/09 QA80-13774-P1 COMPARE_MODELS_FOR_FITTING_WITH_WEIGHT_FAILS_WHEN_NOT_OUTPUT_FIT_STATISTICS_TABLE
 *	Folger 07/02/09 SUPPORT_OMC_FILE_PUBLISH_IN_GROUP_FOLDER_MANAGER			*
 *	Hong 07/03/09 QA80-12534-P1 FIX_IMPWIZ_FAIL_PREVIEW_UNICODE_HEADLINES		*
 *	Kenny 07/06/2009 QA80-13879 SUPPORT_RETRIEVING_INFO_OF_HIGHLIGHTED_CELL		*
 *	Folger 07/03/09 QA80-13876 FIND_AND_REPLACE_IMPROVEMENT_IN_DATARANGE		*
 *	Hong 06/07/09 QA80-13865 FIX_INDPES_DEPS_FUNC_CONTAIN_REDUNDENT_MISSING_ROW_IN_REPORT_TABLE
 *	Hong 08/07/09 QA80-13894 FIX_ORIGIN_CRASH_DUE_TO_TOO_LESS_DATA_PTS_OF_ELLIPSE
 *	Sim 07-09-2009 QA80-13891 EXPORT_FILE_SUPPRESS_FILE_EXIST_PROMPT			*
 *	Kyle 07/09/2009 QA80-13908-S1 COLUMN_SUPPORT_SET_AS_CATEGORICAL_FROM_OC		*
 *	Sophy 7/13/2009 v8.1063 QA80-13880 MORE_CHECK_ON_SET_COLUMN_SHORT_NAME_FROM_CELL_VALUES
 *	Sim 07-13-2009 QA81-13923 FIX_EXP_GRAPH_FAILED_WHEN_LONG_NAME_CONTAIN_ONLY_ONE_DOUBLE_QUOTATION_MARK
 *	Sim 07-14-2009 QA81-13935-P1 SUPPORT_EXPORT_ALL_SHORTCUT_PAGE_IN_FOLDER		*
 *	Kyle 07/14/2009 QA80-13746 SHOWING_BOTH_LN_AND_SN_WITH_STANDARD_NOTATION_IN_THE_MENU_OF_SET_COLUMN_VALUE_DLG
 *	Fisher 7/16/2009 QA80-13897 NEW_METHOD_FOR_SET_COLORMAP_USING_OC			*
 *	Kenny 07/17/2009 QA80-13966-P2 ENABLE_DISABLE_GRAPH_BROWSER_OK_BTN_CORRECTLY*
 *	Folger 07/17/09 QA80-13969 WORKBOOK_ORGANISZER_FAILS_TO_UPDATE_LIST_TREE_AFTER_PAGE_RENAME
 *	Kenny 07/20/2009 QA80-13978 PUT_PREVIEW_BTN_ON_THE_LEFTMOST_OF_GETN_DLG		*
 *	Kenny 07/21/2009 QA80-13980 CLEAN_UP_AND_IMPROVE_XF_IMP_IMAGE_TO_TWO_SEPARATE_XF*
 *	Kyle 07/22/2009 QA80-12339-P1 WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS
 *	Kenny 07/27/2009 QA80-14019 SUPPORT_ACCESS_AXIS_TITLE_OBJECT_IN_OC			*
 *	Sophy 7/27/2009 SUPPORT_IMPORTING_INTO_WKS_USING_ODBC_IN_QUERY_BUILDER		*
 *	Folger 07/29/09 QA80-14035 SHOW_ERROR_WHEN_CHANGE_PARAM_OF_NONE_AUTO_GETN_DIALOG_XF
 *	Kyle 07/29/2009 QA80-14030 USE_STANDARD_NOTATION_FOR_VARIABLE_NAMES_OF_FUNCTION_MENU_IN_SET_COLUMN_VALUES
 *	Hong 07/31/09 QA80-13590-P7 ACTIVE_MSG_TAB_IF_SIGNIFICANT_MSG_EXCEPT_FITTED_CURVE_ACTIVE
 *	Sim 2009-08-04 QA81-14036 FIX_LOST_FOCUS_ON_COMMAND_WINDOW_WHEN_SHOW_WB_ORGANIZER
 *	Hong 08/13/09 QA80-14138 REDUCE_OPERATION_SIZE_OF_STATS_ON_COLS				*
 *	YuI 08/19/09 QA70-14170 EXPOSE_MARKER_OBJECT_TO_ORIGINC						*
 *	Sim 09-23-2009 NOT_SUPPORT_NA_AUTOUPDATE_FOR_81								*
 *	YuI 09/22/09 QA70-14358 VC_BASED_PASSWORD_DIALOG							*
 *	Sim 10-12-2009 QA81-14388 IMPROVE_SPEED_OF_PA_FIT							*
 *	YuI 10/12/09 QA70-14205 X_RANGE_POLYRANGE_SUPPORT							*
 *	Folger 10/29/09 DEFINE_LPDOUBLE_IN_OC										*
 *	Hong 10/29/09 QA80-12798 SHOW_THEME_CTRL_IN_CHANGE_PARAMETER_DLG_FOR_81		*
 *	Folger 11/03/09 ADD_BITS_OPERATION_MACRO_TO_OC								*
 *	Kyle 11/04/2009 QA80-14584 SCV_ADD_FITTING_FUNCTIONS						*
 *	YuI 11/23/09 QA70-13806 VIRTUAL_MATRIX_IMPLEMENTATION						*
 *	Sim 12-07-2009 QA81-14641 LT_GETN_SUPPORT_DATE_TIME_PICKER					*
 *	Hong 01/04/10 QA80-14907-P1 TAKE_BACK_SCRIPT_BEFORE_FITTING					*
 *	Hong 02/02/10 QA80-15051 IMPRORT_SUPPORT_PROGRESSBAR						*
 *	Hong 02/09/10 QA80-14079-P6 FIX_IMPASC_SINGLE_CHAR_IN_DELIMITERS_FAIL_TO_WORK
 *	Hong 03/01/10 QA80-10136 GROUP_FITTED_CURVE_IN_SRC_GRAPH_AS_SRC_PLOT		*
 *	Folger 04/16/10 QA81-15311 GR_BUTTON_OBJ_RECT_SHADOW_REMAINED_AFTER_DESTROY	*
 *	Hong QA80-15357 03/31/10 REPLACE_VSFLEX_WITH_64_MP_COMPATIABLE_WXGRID		*
 *	Jasmine 05/26/10 NANOSIZER_NOT_SUPPORT_RECALCULATE_FOR_NOW					*
 *	Folger 06/01/10 ORG-120 DATA_DISPLAY_DIALOG_IMPROVEMENT						*
 *	Jasmine 06/17/10 ORG-2 TURN_ON_FITTING_FUNCTION_WIZARD_IN_85_BETA			*					
 *	Folger 08/05/10 ORG-702-P1 CLEAR_OUTPUT_DATA_WITHOUT_ERROR_FOR_XF_OPERATION_RECALCULATE_IF_INPUT_IS_EMPTY
 *	Folger 09/27/2010 ORG-1151-P1 SAVE_AS_ANALYSIS_TEMPLATE_FAILED_TO_CLEAN_GRAPHS_EMEBEDED_IN_WKS
 *	Kit 10/21/2010 RSRCH-29	REMOVE_TEXT_AT_BOTTOM_OF_IMAGE						*
 *	TD ML 11-02-2010 OC_64BIT													*
 *	Folger 11/09/2010 ORG-1169-S1 ADD_INPUT_DATA_RANGE_IN_NLFIT_PARAMETER_TABLE	*
 *	Folger 11/10/2010 ORG-27 NEW_DIGITIZER_GADGET								*
 *	Jasmine 11/29/11 ORG-1552 ADD_GRAPH_TO_WKS									*
 *	Hong 01/30/11 ORG-2161 DELAY_X_RANGE_GUI_TO_NEXT_RELASE						*
 *	Folger 03/16/2011 ORG-2434-S2 CNTRL_ENTER_TO_DONE_GET_POINTS_DLG			*
 *	Sim 2011-3-15 ORG-2376 ASCII_IMPORT_SUPPORT_NEW_BOOK_FOR_NON_NUMERIC_DATA	*
 *	Folger 03/18/2011 ORG-2486-P1 QUICKFIT_BAD_INIT_ROI_POSITION_FOR_NONLINEAR_SCALE
 *	Bill 03/16/2011 ORG-2083 LT_FAST_STRING_FUNCTION_ACCESS						*
 *  Iris 3/18/2011 ORG-2427 STATS_ON_COLS_SUPPORT_FLAT_SHEET_REPORT				*
 *  Iris 3/30/2011 ORG-2550-S1 STILL_OUTPUT_REPORT_WHEN_PA_NOT_FOUND_PEAK		*
 *	Folger 04/06/2011 ORG-2581-S1 UNSTACK_COLUMN_SUPPORT_PUT_GROUP_INFO_INTO_CUSTOM_LABELS
 *	Bill 04/27/2011 ORG-2473 SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE		*
 *  Iris 05/05/2011 MOVE_852_BUG_FIX_TO_851SR1									*
 *	Folger 05/19/2011 ORG-1649-P1 USER_DEFINED_FDF_WITHOUT_INIT_CODE_FAILED_IN_QUICKFIT
 *	Folger 05/19/2011 ORG-2898-P1 NLFIT_POOR_INIT_PARAMS_FOR_MULTIPLE_NEGATIVE_PEAKS
 *	Sophy 6/1/2011 ORG-2950 NEW_3D_OPENGL_LIGHTING_CONTROL_DLG					*
 *	Kit 06/07/2011 TURN_OFF_GR_OBJ_3D_FOR_OC_BEFORE_90							*
 *	TD ML 06-06-2011 ORG-2956 ASSIGNING_EDIT_AS_BUDDY_TO_SPINBUTTON_IN_OC		*
 *	Folger 06/17/2011 ORG-2097-S1 STANDARD_ERROR_FOR_DERIVED_PARAMS				*
 *	Kenny 08/17/2011 ORG-3537 NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP*
 * Iris 8/22/2011 ORG-2427-S4 QUANTITIES_BOOKSHEET_BRANCH_REPLACE_CHECKBOX		*
 *	Kit 10/24/2011 ORG-4157-P1 DISABLE_SOME_IMPORT_MENU_ITEM_WHEN_WKS_REPORT_ACTIVE
 *	Folger 10/31/2011 ORG-1220-S2 HIDE_ADD_GRAPH_TO_WKS_GUI_FOR_86				*
 *	Kenny 11/22/2011 ORG-4177-P1 REDUCE_FLICKERING_WHEN_RESIZING_PA_WIZARD_DLG	*
 *	Folger 12/07/2011 ORG-3537 MORE_ON_NAMED_RANGE_SUPPORT_IN_LAYER_CONTENT_AND_PLOT_SETUP
 *	Folger 12/09/2011 ORG-4566-P1 BATCH_PROCESS_FAILED_WHEN_COPY_COL_SOURCE_SAME_AS_DEST
 *	Folger 12/21/2011 ORG-4312-S2 COLUMN_STR_FROM_BROWSER_SHOULD_CHECK_PREFER_LONG_NAME
 *	Folger 02/13/2012 ORG-5038-P1 COMMAND_WINDOW_FAILED_TO_RUN_SCRIPT_BEGIN_WITH_COMMENTS
 *	Sim 2012-02-20 SRVC-79 SUPPORT_ADJUST_VERTICAL_AND_HORIZONTAL_PROFILE_BANDS	*
 *	Folger 05/04/2012 ORG-5592-S1 ADD_DATA_IDENTIFIER_FOR_FITTING_TOOLS			*
 *	Folger 05/17/2012 ORG-5592-P2 PROPER_UDPATE_DATA_IDENTIFIER_ON_REPORT_CONTEXT_MENU
 *	Folger 05/29/2012 ORG-5592-S1 SHOW_DATA_IDENTIFIER_FOR_FLAT_SHEET			*
 *	Tony 07/23/2012 ORG-6293-P1 HIDE_SCOPE_FOR_90								*
 *	Philip 08/22/2012 ORG-6527-S1 TEMPORARILY_DISABLE_ODR_ALGORITHM_IN_NLFIT_DIALOG
 *	Folger 09/17/2012 ORG-6848-P1 BETTER_OUTPUT_COLUMNS_FILTERING_FOR_INPUT_COLUMN_BROWSER
 *	Folger 10/18/2012 ORG-7211-P1 LOCALIZE_SAMPLE_OPJS_SHOWN_IN_MENU			*
 *------------------------------------------------------------------------------*/
#ifndef _OC_COMMON_H
#define _OC_COMMON_H

/////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////
///////// Version Sepecific define //////////////////////////////////
/////////////////////////////////////////////////////////////////////
#define NLFTI_PARAMETERS_MANAGER		//CPY 9/12/08 for SR5 and 81 builds to make this visible in OC


/////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////

#ifdef _OWIN64
typedef __int64 size_t;   /// TD seems to be used in many places already, hopefully used properly by the respective DLL's
typedef __int64 ptrdiff_t;		/// TD ML 06-10-2011 ORG-2987 NAG_HEADERS_OC_COMPILE
#else //_OWIN64
typedef unsigned int size_t;
typedef unsigned int ptrdiff_t;		/// TD ML 06-10-2011 ORG-2987 NAG_HEADERS_OC_COMPILE
#endif// _OWIN64

typedef int BOOL;
//Comments last updated by Sophy on 6/24/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:LPVOID
*/
typedef void* LPVOID;

//Comments last updated by Sophy on 6/24/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:LPCVOID
*/
typedef const void* LPCVOID;

//Comments last updated by Sophy on 6/24/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:LPCSTR
*/
typedef const char* LPCSTR;

//Comments last updated by Sophy on 6/24/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:LPCTSTR
*/
#define LPCTSTR	LPCSTR

///------ Folger 10/29/09 DEFINE_LPDOUBLE_IN_OC
/**
*/
typedef double* LPDOUBLE;
///------ End DEFINE_LPDOUBLE_IN_OC

///------ Folger 04/06/2011 ORG-2581-S1 UNSTACK_COLUMN_SUPPORT_PUT_GROUP_INFO_INTO_CUSTOM_LABELS
/**
*/
typedef int*	LPINT;
///------ End UNSTACK_COLUMN_SUPPORT_PUT_GROUP_INFO_INTO_CUSTOM_LABELS

//Comments last updated by Sophy on 6/24/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:LPSTR
*/
typedef char* LPSTR;
typedef short SHORT;

///---------------------------- TD 8-15-01 
//typedef unsigned int UINT;
//#define DWORD	UINT
//#define	USHORT	WORD
#define DWORD	uint
#define	USHORT	ushort
#define WORD	ushort
#define BYTE	byte
#define String  string
//#define Vector  vector
//#define Matrix	matrix
#define UINT	uint
#define Application		Project
///------------------------ end TD 8-15-01 
typedef int LONG;
typedef int long;
typedef DWORD  *LPDWORD;

typedef unsigned long ULONG;		///------ Folger 12/09/2011 ORG-4566-P1 BATCH_PROCESS_FAILED_WHEN_COPY_COL_SOURCE_SAME_AS_DEST

///------ Folger 08/05/10 ORG-702-P1 CLEAR_OUTPUT_DATA_WITHOUT_ERROR_FOR_XF_OPERATION_RECALCULATE_IF_INPUT_IS_EMPTY
typedef DWORD  OUID;
///------ End CLEAR_OUTPUT_DATA_WITHOUT_ERROR_FOR_XF_OPERATION_RECALCULATE_IF_INPUT_IS_EMPTY
/// TD ML 11-02-2010 OC_64BIT
#ifdef _OWIN64

#define		INT_PTR		__int64
#define		UINT_PTR	__int64
#define		ULONG_PTR	__int64
#define		DWORD_PTR	__int64
#define		LONG_PTR	__int64

#define		VTS_OIP			"\x14"		
#define		VTS_OUIP		"\x15"	
#define		VTS_ROIP		"\x34"		
#define		VTS_ROUIP		"\x35"		
#define		VTS_POIP		"\x54"		
#define		VTS_POUIP		"\x55"

#define		atoOIP			_atoi64


#else // _OWIN64

#define		INT_PTR		int
#define		UINT_PTR	uint
#define		ULONG_PTR	uint
#define		DWORD_PTR	uint
#define		LONG_PTR	int

#define		VTS_OIP			VTS_I4		
#define		VTS_OUIP		VTS_OIP	
#define		VTS_ROIP		VTS_RI4		
#define		VTS_ROUIP		VTS_ROIP		
#define		VTS_POIP		VTS_PI4		
#define		VTS_POUIP		VTS_POIP

#define		atoOIP			atoi

#endif // _OWIN64

#define		OIP			INT_PTR
#define		OUIP		UINT_PTR
#define		OULP		ULONG_PTR
#define		ODWP		DWORD_PTR
#define		OLP			LONG_PTR
#define		WPARAM		OUIP
#define		LPARAM		OUIP
#define		LRESULT		OUIP
/// end OC_64BIT

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:OCOLOR
*/

#define SEEK_CUR    1
#define SEEK_END    2
#define SEEK_SET    0

//------ CPY Roman 1/5/07 LT based gr axis scale slider
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:FRECT
*/
typedef struct tagFRECT
{
	double	left;
	double	top;
	double	right;
	double	bottom;
}FRECT;

typedef struct tagFPOINT
{
	double	x;
	double	y;
}FPOINT;
//--------

#define HWND		LPVOID
#define	HANDLE		LPVOID
#define HBITMAP 	LPVOID
#define HMETAFILE 	LPVOID
#define	HICON		LPVOID
#define HINSTANCE	LPVOID
#define HDIB		LPVOID
#define HGDIOBJ		LPVOID
#define HENHMETAFILE LPVOID
#define HMENU		LPVOID
#define HMODULE		LPVOID /// Bill 07/19/2011 ADD_FOR_LOADLIBRARY

#define WINAPI      __stdcall

#define TRUE 	1
#define FALSE 	0

///---Sim 03-24-2009 QA70-13034 CUSTOM_XF_DIALOGS_FOR_81
#if _OC_VER >= 0x0810
	#define	CUSTOM_XF_DIALOG
	#define INSERT_NEW_REPORT_ENTRY_IN_OLD_OPJ_WHEN_RECALCULATE /// Iris 4/29/2009 QA80-12017 NEED_ADD_NEW_REPORT_ITEM_WHEN_RECALCULATE_ON_OLD_OPJ
	#define ADD_WEIGHT_METHOD_FOR_DESC_STATS_ON_COLS /// Iris 5/04/2009 QA80-11982 STATS_ON_COL_ADD_WEIGHT_METHOD
	#define NEW_FEATURE_VERTICAL_CURSOR				///Kenny 05/06/2009 NEW_FEATURE_VERTICAL_CURSOR
	#define WKS_MORE_EXCEL_INFO_ACCESS	// Hong 05/08/09 ADD_IFDEF_FOR_SR6
	#define MORE_WKS_DATA_MANIPULATION_CAPABILITIES /// Hong 04/27/09 QA80-8454 SUPPORT_MORE_WKS_DATA_MANIPULATION_CAPABILITIES
	#define __XF_BASED_PLOTTING_MECHANISM__			///------ Folger 04/20/09 QA80-13420 MORE_WORK_ON_GENERAL_XF_BASED_PLOTTING_MECHANISM
	#define TERNARY_CONTOUR_PLOT_81					/// Fisher 04/28/2009 QA80-2935 ADD_TERNARY_CONTOUR_PLOT
	#define FIX_SET_OPERATION_TREE_AFTER_CHANGE		///Jasmine 05/05/09 OPENRATION_TREE_IS_CHANGED_AND_SHOULD_SET_IN_OPENRATION
	#define NO_LONGER_SUPPORT_80_USER_OC_TRICK_IMPORT_CODE ///---Sim 05-12-2009 QA80-13594 MAKE_USER_IMPORT_OC_CODE_COMPATIBLE
	#define CLEAR_IMPORT_CODE_81 ///---Sim 05-12-2009 QA80-13594 MAKE_USER_IMPORT_OC_CODE_COMPATIBLE
	#define NEW_STRUCTURE_OF_SET_COL_VAL_F_X_POLL_DOWN_MENU		///Kyle 05/21/2009 NEW_STRUCTURE_OF_SET_COLUMN_VALUES_DIALOG_F_X_PULL_DOWN_MENU
	#define SET_VALUES_SUPPORT_DEFINE_VARIBLE					///Kyle 04/30/2009 SUPPORT_DEFINING_VARIABLES_IN_SET_VALUES_DIALOG
	#define	MORE_REASONAL_LEGEND_FOR_STATS_ON_COL				///Sophy 2/26/2009 MORE_REASONABLE_LEGEND_FOR_REPORT_GRAPH_WHEN_MULTIPLE_GROUPS_EXIST_IN_STATS_ON_COLUMN
	#define REMOVE_EXPGRAPH_NOT_USED_BINARY_STORAGE				/// Hong 06/01/09 REMOVE_BINARY_STORAGE_AFTER_EXPGRAPH_WHICH_IS_NOT_USED_ANYMORE
	#define IMPROVE_MR_INPUT_RANGE_ERROR_CHECKING 				/// Hong 06/01/09 FIX_MR_FAIL_CHECK_ERROR_IF_INDEP_NOT_SPECIFIED
	#define _NEW_WKS_EXTRACT_NOT_WIPE_OUT_OPERATIONS_			/// Hong 06/02/09 QA80-12755 EXTRACT_WKS_ADD_START_COL_SUPPORT
	#define		__GROBJ_NUMERIC_VARS_STORAGE__					///------ Folger 06/03/09 QA80-13713 GROBJ_NUMERIC_VARS_STORAGE_SUPPORT
	#define	EXTEND_INTERFACES_OF_NLFITSESSION	///Sophy 6/5/2009 MORE_SUPPORT_ON_NLFITSESSION_CUSTOMIZATION
	#define EXTRACT_WKS_SUPPORT_AUTO_UPDATE		///---Sim 06-02-2009 QA80-4584 EXTRACT_WKS_SUPPORT_AUTO_UPDATE
	#define __ADV_DIGITAL_FILTERING__			/// Fisher 04/24/09 QA80-13487  ADV_DIGITAL_FILTERING
	#define FIX_LIST_XF_BUG_FOR_81				/// Iris 6/10/2009 QA80-13741 REMOVE_AND_OP_IN_LIST_XF_RESULT
	#define	IMPROVE_RISETIME_TOOL				///Sophy 6/12/2009 IMPROVE_RISETIME_TOOL_FOR_OSCILLOSCOPE_SIGNAL_PROCESSING
	#define PLOT_ELEMENT_SUPPORT			/// YuI 06/12/09 QA70-13595 SUPPORT_FOR_DATA_PLOT_ELEMENTS_ACCESS
	#define __EXTRACTING_CONTOUR_LINES__		/// Fisher 06/16/09 QA80-13487  EXTRACTING_CONTOUR_LINES
	/// YuI 09/22/09 QA70-14358 VC_BASED_PASSWORD_DIALOG
	//	#define	_PROJECT_OPENING_PASSWORD_PROTECTION_OC_ACCESS_	/// Hong 06/16/09 QA80-8061 SIMPE_PROJECT_OPENING_PASSWORD_PROTECTION_SUPPORT
	/// end VC_BASED_PASSWORD_DIALOG
	#define __XF_XYRANGE_OUTPUT_FAILS_TO_SET_EVEN_SAMPLING__	///------ Folger 06/16/09 QA80-13787 XF_XYRANGE_OUTPUT_FAILS_TO_SET_EVEN_SAMPLING_WHEN_INPUT_X_USED_PARTIAL_ROW_NUMBER
	#define __SPEED_UP_FIT_WITHOUT_REPORT_TABLE__ ///---Sim 06-17-2009 QA80-13786-P2-P4 SPEEP_UP_LINEAR_FIT_WITHOUT_REPORT_TABLE
	#define SUPPORT_EXPORT_MULTI_PAGES_PDF /// Hong 06/17/09 QA80-13280 EXPORT_MULTI_PAGES_PDF_MORE_PRINT_OPTIONS
	#define __FIX_STATS_COLUMN_HISTOGRAMS_BIN_SETTINGS_WHEN_LOAD_SR4_OPJ ///---Sim 06-18-2009 QA80-13403-P1 FIX_HISTOGRAMS_BIN_SETTINGS_ERROR_WHEN_LOAD_SR4_OPJ
	#define __CUSTOM_MENU_CONSTRUCTION__				///Kyle 06/19/2009 QA70-13423 SUPORT_GET_MENU_TEXT_FROM_OC
	/// YuI 09/22/09 QA70-14358 VC_BASED_PASSWORD_DIALOG
	//	#define	__ADD_PROJECT_AUDIT_LOG_OC_ACCESS__					/// Hong 06/18/09 QA80-8091-S2 ADD_PROJECT_AUDIT_LOG
	/// end VC_BASED_PASSWORD_DIALOG
	#define	__FIX_HEADER_LINE_SETTING_NOT_USED_FOR_AUTO_DETECT__	/// Hong 06/19/09 QA80-13790 FIX_HEADER_LINE_SETTING_BY_USER_NOT_USED_FOR_DETECT_NUM_COLS_IF_NULL_FILTER
	#define		__NEW_XYZ_EXAMINE_METHOD__				    /// Will  6/19/2009  QA80-13783 CHANGE_PROTOTYPE_AND_ALGORITHM_FOR_EXAMINATION
	#define		__NEW_XYZ_REMOVE_DUPLICATES_METHOD__	   	/// Will  6/19/2009	 QA80-13783 PROTOTYPE_WITH_TWO_PRECISION_FOR_XYZ_REMOVE_DUPLICATE
	#define IMPROVE_ERROR_CHECK_FOR_USER_DEFINE_LABEL_NAME	/// Iris 6/23/2009 QA80-13756-P1 IMPROVE_ERROR_CHECK_FOR_USER_DEFINE_LABEL_NAME
	///---Sim 09-23-2009 NOT_SUPPORT_NA_AUTOUPDATE_FOR_81
	//#define __NANOSIZER_WIZ_AUTO_UPDATE_SUPPORT__ ///---Sim 06-23-2009 NANOSIZER_WIZ_AUTO_UPDATE_SUPPORT
	///---END NOT_SUPPORT_NA_AUTOUPDATE_FOR_81
	#define __SHOW_PEAK_LABEL_SWITCH_BUTTON_FOR_NANOSIZER__		///------ Folger 06/25/09 NANOSIZER_DO_NOT_NEED_TO_SUPPORT_SWITCH_PEAK_LABEL_FOR_SR6
	#define __FIX_KGRAPH_SMALL_VALID_FAIL_FAIL_IMPORT__			/// Hong 06/26/09 QA80-13841 FIX_SMALL_VALID_FILE_IS_CONSIDER_AS_INVALID_FILE
	#define	__UPDATE_IRL_ORL_ON_RESIDUAL_GRAPH__	///Sophy 6/30/2009 QA80-13178 UPDATE_FITCURVE_RESIDUAL_PLOTS_SETTINGS_FOR_UPDATE_3D_RESIDUAL_PREVIEW
	#define __FIT_COMPARE_MODEL_IMPROVEMENT__		///------- Folger 07/01/09 QA80-13774-P1 COMPARE_MODELS_FOR_FITTING_WITH_WEIGHT_FAILS_WHEN_NOT_OUTPUT_FIT_STATISTICS_TABLE
	#define	__SUPPORT_OMC_FILE_PUBLISH_IN_GROUP_FOLDER_MANAGER__		///------ Folger 07/02/09 SUPPORT_OMC_FILE_PUBLISH_IN_GROUP_FOLDER_MANAGER
	#define ASCIMP_SUPPORT_UNICODE				/// Hong 07/03/09 QA80-12534-P1 FIX_IMPWIZ_FAIL_PREVIEW_UNICODE_HEADLINES
	#define	__SUPPORT_DATARANGE_FIND_ALL_AND_FIND_NEXT__		///------ Folger 07/03/09 QA80-13876 FIND_AND_REPLACE_IMPROVEMENT_IN_DATARANGE
	#define __FIX_INDPES_DEPS_FUNC_REDUNDENT_MISSING_ROW_IN_REPORT_TABLE__ /// Hong 06/07/09 QA80-13865 FIX_INDPES_DEPS_FUNC_CONTAIN_REDUNDENT_MISSING_ROW_IN_REPORT_TABLE
	#define	__UPDATE_REPORT_COLUMN_FORMAT_IN_3D_FITTING__	///Sophy 7/7/2009 v8.1058 QA80-12613-P6 FITCURVE_Y_COLUMN_FORMAT_MUST_BE_CONSISTENT_WITH_SOURCE_DATA_IN_3D_FITTING
	#define __FIX_FITLINEAR_CRASH_WHEN_TOO_LESS_ELLIPSE_DATA_PITS__ /// Hong 08/07/09 QA80-13894 FIX_ORIGIN_CRASH_DUE_TO_TOO_LESS_DATA_PTS_OF_ELLIPSE
	#define __EXPORT_FILE_SUPPRESS_FILE_EXIST_PROMPT__				///---Sim 07-09-2009 QA80-13891 EXPORT_FILE_SUPPRESS_FILE_EXIST_PROMPT
	#define	__FIX_SHEET_LEVEL_ENABLED_IF_CANCEL_CUSTOMISING_BOOK__	///Sophy 7/9/2009 QA80-13910-P1 FIX_SHEEL_LEVEL_ENABLED_WHEN_CANCEL_CUSTOMIZING_BOOKNAME
	#define	__NLFIT_DLG_BECOME_MODELESS__							///Sophy 7/9/2009 QA80-13910-P2 NLFIT_DLG_BECOME_MODELESS_AFTER_CUSTOMIZING_BOOK_SHEET_NAME
	#define __SET_COLUMN_AS_CATEGORICAL_FROM_OC__					///Kyle 07/09/2009 QA80-13908-S1 COLUMN_SUPPORT_SET_AS_CATEGORICAL_FROM_OC
	#define	__CHECK_ERROR_ON_SET_SHORTNAMES__						///Sophy 7/13/2009 v8.1063 QA80-13880 MORE_CHECK_ON_SET_COLUMN_SHORT_NAME_FROM_CELL_VALUES
	#define	__FIX_EXP_GRAPH_FAILED_WHEN_LONG_NAME_CONTAIN_ONLY_ONE_DOUBLE_QUOTATION_MARK__ ///---Sim 07-13-2009 QA81-13923 FIX_EXP_GRAPH_FAILED_WHEN_LONG_NAME_CONTAIN_ONLY_ONE_DOUBLE_QUOTATION_MARK
	#define	__SUPPORT_EXPORT_ALL_SHORTCUT_PAGE_IN_FOLDER__ ///---Sim 07-14-2009 QA81-13935-P1 SUPPORT_EXPORT_ALL_SHORTCUT_PAGE_IN_FOLDER
	#define __COLORMAP_IMPROVEMENTS__					 /// Fisher 7/16/2009 QA80-13897 NEW_METHOD_FOR_SET_COLORMAP_USING_OC	
	#define __ENABLE_DISABLE_GRAPH_BROWSER_OK_BTN_CORRECTLY		/// Kenny 07/17/2009 QA80-13966-P2 ENABLE_DISABLE_GRAPH_BROWSER_OK_BTN_CORRECTLY
	#define __PUT_PREVIEW_BTN_ON_THE_LEFTMOST_OF_GETN_DLG			/// Kenny 07/20/2009 QA80-13978 PUT_PREVIEW_BTN_ON_THE_LEFTMOST_OF_GETN_DLG
	#define __CLEAN_UP_AND_IMPROVE_XF_IMP_IMAGE_TO_TWO_SEPARATE_XF	/// Kenny 07/21/2009 QA80-13980 CLEAN_UP_AND_IMPROVE_XF_IMP_IMAGE_TO_TWO_SEPARATE_XF
	#define __WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS__		///Kyle 07/22/2009 QA80-12339-P1 WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS
	#define __SUPPORT_ACCESS_AXIS_TITLE_OBJECT_IN_OC				/// Kenny 07/27/2009 QA80-14019 SUPPORT_ACCESS_AXIS_TITLE_OBJECT_IN_OC
	#define	__SUPPORT_IMPORT_DATA_BY_ODBC_IN_QUERY_BUILDER__		///Sophy 7/27/2009 SUPPORT_IMPORTING_INTO_WKS_USING_ODBC_IN_QUERY_BUILDER
	#define	__NOT_ALLOW_CHANGE_PARAM_FOR_NONE_AUTO_GETN_DIALOG__	///------ Folger 07/29/09 QA80-14035 SHOW_ERROR_WHEN_CHANGE_PARAM_OF_NONE_AUTO_GETN_DIALOG_XF
	#define __STANDARD_NOTATION_FOR_VARIVABLE_NAMES__				///Kyle 07/29/2009 QA80-14030 USE_STANDARD_NOTATION_FOR_VARIABLE_NAMES_OF_FUNCTION_MENU_IN_SET_COLUMN_VALUES
	#define	__ACTIVE_MSG_TAB_IF_SIGNIFICANT_MSG_EXCEPT_FITTED_CURVE_TAB_ACTIVE__	/// Hong 07/31/09 QA80-13590-P7 ACTIVE_MSG_TAB_IF_SIGNIFICANT_MSG_EXCEPT_FITTED_CURVE_ACTIVE
	#define	__FIX_LOST_FOCUS_ON_COMMAND_WINDOW__ ///---Sim 2009-08-04 QA81-14036 FIX_LOST_FOCUS_ON_COMMAND_WINDOW_WHEN_SHOW_WB_ORGANIZER
	#define	__REDUCE_STATS_ON_COLS_OP_MEM_CONSUME__	/// Hong 08/13/09 QA80-14138 REDUCE_OPERATION_SIZE_OF_STATS_ON_COLS
	#define __MARKER_GRAPHIC_OBJECT__				/// YuI 08/19/09 QA70-14170 EXPOSE_MARKER_OBJECT_TO_ORIGINC
	#define	_CHANGE_PARAMS_SUPPORT_LAODING_THEME_AND_COMPARING_THEME /// Hong 10/29/09 QA80-12798 SHOW_THEME_CTRL_IN_CHANGE_PARAMETER_DLG_FOR_81
	#define __IMPROVE_PA_FIT_SPEED__ ///---Sim 10-12-2009 QA81-14388 IMPROVE_SPEED_OF_PA_FIT
	#define _ADD_FITTING_FUNCTIONS_TO_SCV								///Kyle 11/04/2009 QA80-14584 SCV_ADD_FITTING_FUNCTIONS
	#define ALLOW_SCRIPT_BEFORE_AFTER_FITTING			/// Hong 01/04/10 QA80-14907-P1 TAKE_BACK_SCRIPT_BEFORE_FITTING
	#define __EXTEND_POSITION_FOR_GROBJ_CONNECT__		///Sophy 2/11/2010 QA81-15107 SUPPORT_EXTEND_POSITION_FOR_GRAPHOBJECT_CONNECT
#endif
///---END QA70-13034 CUSTOM_XF_DIALOGS_FOR_81

///---Sim 09-23-2009 NOT_SUPPORT_NA_AUTOUPDATE_FOR_81
#if _OC_VER >= 0x0820
	///Jasmine 05/26/10 NANOSIZER_NOT_SUPPORT_RECALCULATE_FOR_NOW
	//#define __NANOSIZER_WIZ_AUTO_UPDATE_SUPPORT__ ///---Sim 06-23-2009 NANOSIZER_WIZ_AUTO_UPDATE_SUPPORT
	///End NANOSIZER_NOT_SUPPORT_RECALCULATE_FOR_NOW
	#define	__X_RANGE_POLYRANGE_SUPPORT__ /// YuI 10/12/09 QA70-14205 X_RANGE_POLYRANGE_SUPPORT
	#define	__VIRTUAL_MATRIX__ /// YuI 11/23/09 QA70-13806 VIRTUAL_MATRIX_IMPLEMENTATION
	#define	__FIX_DELIMITERS_FAIL_WORK_WHEN_SIGNLE_CHAR__ /// Hong 02/09/10 QA80-14079-P6 FIX_IMPASC_SINGLE_CHAR_IN_DELIMITERS_FAIL_TO_WORK
	///------ Folger 04/16/10 QA81-15311 GR_BUTTON_OBJ_RECT_SHADOW_REMAINED_AFTER_DESTROY
	#define	__ENLARGE_GR_OBJ_ERASE_INFLATE_SIZE__
	///------ End GR_BUTTON_OBJ_RECT_SHADOW_REMAINED_AFTER_DESTROY
	///------ Folger 06/02/10 ORG-120 DATA_DISPLAY_DIALOG_IMPROVEMENT
	#define		__DATA_DISPLAY_DIALOG_IMPROVEMENT__
	///------ End DATA_DISPLAY_DIALOG_IMPROVEMENT	
	///Jasmine 06/17/10 ORG-2 TURN_ON_FITTING_FUNCTION_WIZARD_IN_85_BETA								
	#define		__NEW_FITTING_FUNCTION_WIZARD__
	///End TURN_ON_FITTING_FUNCTION_WIZARD_IN_85_BETA
#endif
///---END NOT_SUPPORT_NA_AUTOUPDATE_FOR_81

#if _OC_VER >= 0x0851   //CPY 9/3/2010
	#define	__REPLACE_VSFLEX_WITH_64_MP_WXGRID__ /// Hong QA80-15357 03/31/10 REPLACE_VSFLEX_WITH_64_MP_COMPATIABLE_WXGRID
	#define	__OC_COLUMN_REVERSE__	///Sophy 9/9/2010 ORG-1014 XF_SUPPORT_REVERSE_COLUMN_DATA
	#define	__SAVE_AS_ANALYSIS_TEMPLATE_FAILED_TO_CLEAN_GRAPHS_EMEBEDED_IN_WKS__		///------ Folger 09/27/2010 ORG-1151-P1 SAVE_AS_ANALYSIS_TEMPLATE_FAILED_TO_CLEAN_GRAPHS_EMEBEDED_IN_WKS
	#define	_ADO_SET_COLUMN_DATE_FORMAT_	///Sophy 9/26/2010 ORG-1142 ADO_IMPORT_SHOULD_ALLOW_SET_COL_FORMAT_FOR_DATE_FIELD
	#define	__IMGFILE_XF_NEW_DLG__			///Sophy 9/30/2010 ORG-150-P2 IMGFILE_XF_USE_NEW_IMAGE_DIALOG
	#define __ADD_CTRL_BIT_FOR_POLYPOLYLINE_DRAWING__ ///-----Kit 10/21/2010 RSRCH-29	REMOVE_TEXT_AT_BOTTOM_OF_IMAGE
	#define	__NEW_DATABASEIMPORTDLG__	///Sophy 10/28/2010 ORG-1179 NEW_DATABASEIMPORT_DLG
	#define	2D_FIT_SUPPORT_REPLICA		///Sophy 11/10/2010 ORG-1479 OPEN_2D_SURFACE_FITTING_FOR_ORIGIN_PRO
	/// Iris 05/05/2011 MOVE_852_BUG_FIX_TO_851SR1
	#define __FIX_STATS_ON_COLS_BOXCHART_PLOT_IN_ONE_GRAPH_ISSUE__ /// Iris 3/25/2011 ORG-2528-P1 FIX_BOXCHART_PLOT_IN_ONE_GRAPH_ISSUE_IN_STATS_ON_COLS
	#define __PA_WANT_REPORT_EMPTY_REPORT_TABLE_EVEN_NO_PEAK_FOUND__ /// Iris 3/30/2011 ORG-2550-S1 STILL_OUTPUT_REPORT_WHEN_PA_NOT_FOUND_PEAK
	///End MOVE_852_BUG_FIX_TO_851SR1
#endif //_OC_VER >= 0x0851

/// Hong 01/30/11 ORG-2161 DELAY_X_RANGE_GUI_TO_NEXT_RELASE
#if _OC_VER >= 0x0852
	#define	__X_RANGE_SUPPORT_GUI_ACCESS__
	/// Iris 8/22/2011 ORG-2427-S4 QUANTITIES_BOOKSHEET_BRANCH_REPLACE_CHECKBOX
	//#define __STATS_ON_COLS_SUPPORT_FLAT_SHEET_REPORT__ /// Iris 3/18/2011 ORG-2427 STATS_ON_COLS_SUPPORT_FLAT_SHEET_REPORT
	///End QUANTITIES_BOOKSHEET_BRANCH_REPLACE_CHECKBOX
	#define __LT_FAST_STRING_FUNCTION_ASSESS__ /// Bill 03/16/2011 ORG-2083 LT_FAST_STRING_FUNCTION_ACCESS
	/// Iris 05/05/2011 MOVE_852_BUG_FIX_TO_851SR1
	//#define __FIX_STATS_ON_COLS_BOXCHART_PLOT_IN_ONE_GRAPH_ISSUE__ /// Iris 3/25/2011 ORG-2528-P1 FIX_BOXCHART_PLOT_IN_ONE_GRAPH_ISSUE_IN_STATS_ON_COLS
	//#define __PA_WANT_REPORT_EMPTY_REPORT_TABLE_EVEN_NO_PEAK_FOUND__ /// Iris 3/30/2011 ORG-2550-S1 STILL_OUTPUT_REPORT_WHEN_PA_NOT_FOUND_PEAK
	///End MOVE_852_BUG_FIX_TO_851SR1
#endif //_OC_VER >= 0x0852
/// end DELAY_X_RANGE_GUI_TO_NEXT_RELASE

#if	_OC_VER >= 0x0860
	#define __STATS_ON_COLS_SUPPORT_QUANTITIES_OUTPUT_BRANCH	/// Iris 8/22/2011 ORG-2427-S4 QUANTITIES_BOOKSHEET_BRANCH_REPLACE_CHECKBOX
	#define __RICHEDIT_GETSELTEXT_RETURN_CR_ONLY_FROM_VERSION2__	///------ Folger 02/13/2012 ORG-5038-P1 COMMAND_WINDOW_FAILED_TO_RUN_SCRIPT_BEGIN_WITH_COMMENTS
#endif //_OC_VER >= 0x0860


/// Hong QA80-15357 03/31/10 REPLACE_VSFLEX_WITH_64_MP_COMPATIABLE_WXGRID
#if	_OC_VER >= 0x0900
	#define	__ZERROR_DESIG_IN_PLOT_SETUP_DLG__	///Sophy 9/10/2010 ORG-789 CREATE_3D_SCATTER_WITH_ERR_BAR_OR_VECTOR_IN_PLOT_SETUP_DIALOG
	#define	__FITTED_CURVE_SUPPORT_GROUP_AS_SRC__	/// Hong 03/01/10 QA80-10136 GROUP_FITTED_CURVE_IN_SRC_GRAPH_AS_SRC_PLOT
	#define __MORE_SET_COLUMN_VALUE_DLG_FUNCTION__	/// Bill 03/23/2011 ADD_MORE_FUNCTION_FOR_SET_COLUMN_VALUE_DLG
	#define __SUPPORT_PARAMETER_TAB_DRAGGABLE__ /// Bill 04/27/2011 ORG-2473 SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE
	#define	__PROPER_DELAY_RESCALE_FOR_CALC__	///Sophy 5/18/2011 ORG-2888-P1 FITTED_CURVE_NOT_DRAW_PROPERLY_WHEN_UPDATE_SOURCE_DATA_WITH_SCALE_CHANGED
	#define	__PROPER_UPDATE_PREVIEW_OBJECT_FOR_QUICK_PEAKS__	///Sophy 5/18/2011 PROPER_UPDATE_PREVIEW_OBJECT_WHEN_NO_PEAKS_FOUND
	#define	__USER_DEFINED_FUNC_NO_PARAM_INIT_FAILED_IN_QUICKFIT__	///------ Folger 05/19/2011 ORG-1649-P1 USER_DEFINED_FDF_WITHOUT_INIT_CODE_FAILED_IN_QUICKFIT
	#define	__NLFIT_POOR_INIT_PARAMS_FOR_MULTIPLE_NEGATIVE_PEAKS__	///------ Folger 05/19/2011 ORG-2898-P1 NLFIT_POOR_INIT_PARAMS_FOR_MULTIPLE_NEGATIVE_PEAKS
	#define	__AUTO_ADJUST_COL_WIDTH_FOR_IMPORTING__		///Sophy 5/23/2011 ORG-1344-P1 SUPPORT_AUTO_ADJUST_COLUMN_WIDTH_AFTER_IMPORTING
	///Sophy 6/1/2011 ORG-2950 NEW_3D_OPENGL_LIGHTING_CONTROL_DLG
	#define	_2D_SLIDER_CONTROL	//same in ocnfig.h in VC
	#define	COLORWELL_IN_OC_DLG
	///end NEW_3D_OPENGL_LIGHTING_CONTROL_DLG
	#define SPINBUTTON_BUDDY_IN_OC	/// TD ML 06-06-2011 ORG-2956 ASSIGNING_EDIT_AS_BUDDY_TO_SPINBUTTON_IN_OC
	#define __USING_O3DGL_GR_OBJ_3D__	///-----Kit 06/07/2011 TURN_OFF_GR_OBJ_3D_FOR_OC_BEFORE_90
	#define __ASCII_IMPORT_NON_NUMERIC_DATA_SUPPORT_NEW_BOOK__ ///---Sim 2011-3-15 ORG-2376 ASCII_IMPORT_SUPPORT_NEW_BOOK_FOR_NON_NUMERIC_DATA
	#define __ERROR_OF_DERIVED_PARAMS__		///------ Folger 06/17/2011 ORG-2097-S1 STANDARD_ERROR_FOR_DERIVED_PARAMS
	//#define NEW_NAMED_RANGE_FEATURE			/// Kenny 08/17/2011 ORG-3537 NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP	turn off by now
	#define __PA_FLICKER_FREE						/// Kenny 11/22/2011 ORG-4177-P1 REDUCE_FLICKERING_WHEN_RESIZING_PA_WIZARD_DLG
	///------ Tony 07/23/2012 ORG-6293-P1 HIDE_SCOPE_FOR_90
	//#define	NEW_NAMED_RANGE_FEATURE				///------ Folger 12/07/2011 ORG-3537 MORE_ON_NAMED_RANGE_SUPPORT_IN_LAYER_CONTENT_AND_PLOT_SETUP
	///------ End HIDE_SCOPE_FOR_90
	#define __ADD_GRAPH_TO_WKS__					//---- CPY 12/8/2011 TURN_ON_ADD_GRAPH_TO_WKS_GUI
	#define __IMAGE_PROFILE_SUPPORT_FOR_CMA_OPD__	///---Sim 2012-02-20 SRVC-79 SUPPORT_ADJUST_VERTICAL_AND_HORIZONTAL_PROFILE_BANDS
#endif	//_OC_VER >= 0x0900

///------ Folger 10/31/2011 ORG-1220-S2 HIDE_ADD_GRAPH_TO_WKS_GUI_FOR_86
/// since 86 is acctually defined as 90, so anything not belong to 86 should be added here
#if		_OC_VER >= 0x0910
	//---- CPY 12/8/2011 TURN_ON_ADD_GRAPH_TO_WKS_GUI
	//#define __ADD_GRAPH_TO_WKS__					///Jasmine 11/29/11 ORG-1552 ADD_GRAPH_TO_WKS
	//----	
	///Philip 08/22/2012 ORG-6527-S1 TEMPORARILY_DISABLE_ODR_ALGORITHM_IN_NLFIT_DIALOG
	//#define __ODR_ALGORITHM_USEABLE_IN_NLFIT_DIALOG__
	///end TEMPORARILY_DISABLE_ODR_ALGORITHM_IN_NLFIT_DIALOG
#endif	/// _OC_VER >= 0x0910
///------ End HIDE_ADD_GRAPH_TO_WKS_GUI_FOR_86


////////////////////////////////      For SR6      ////////////////////////////////
#define CHECK_EXCEED_FILE_PATH_LENGTH_LIMITATION ///---Sim 05-07-2009 QA80-13571 FIX_CRASH_WHEN_FILE_PATH_LENGTH_IS_TOO_LONG
////////////////////////////////      End SR6      ////////////////////////////////

//-----------------------------------------------------
// the following should be defined only for debug build
//---- CPY 10/8/2007 QA70-10486 DEBUG_SHOULD_NOT_BE_DEFINED_AND_SHOULD_HAVE_NO_ASSERT
//#define _DEBUG // this is usful during development, should be turned off when we release software
//----
//
#ifdef _DEBUG
	#define	DEBUG_MSG(str)	str.WriteLine(WRITE_COMPILER_OUTPUT)
	#define OUT(str)		str.WriteLine(WRITE_SCRIPT_WINDOW)
#else
	#define OUT(str)
	#define	DEBUG_MSG(str)	//str.Write(WRITE_MESSAGE_BOX)
#endif

//------ CPY 4/3/08 PA_FIT_CNTRL_OPEN_EMPTY_NO_ERR_MSG
// I have search for all ASSERT and seems like we don't have wrong usage (VERIFY) anymore, so I have restored release to use empty
/*
#ifdef _DEBUG
	#define ASSERT(_f)	do { if (!(_f) ) OCAssertLine(__FILE__, __LINE__, 1);  } while (0)
#else
	//---- CPY 10/8/2007 QA70-10486 DEBUG_SHOULD_NOT_BE_DEFINED_AND_SHOULD_HAVE_NO_ASSERT
	// I cannot remove this as it seems we have codes that count on ASSERT being there, sort of VERIFY/ASSERT bug
	// until those are fixed, I will keep this for now
	//#define ASSERT(_f)
	#define ASSERT(_f)	do { if (!(_f) ) OCAssertLine(__FILE__, __LINE__, 0);  } while (0)
	//----
#endif
*/
#ifdef _DEBUG // this is turned on with @OCDB = 1, and default true for Developer Kit being installed
	// BOOL_ERR is for low level functions that usually do not need to show err msg, so in release, this is the same as false
	// for higher level functions, like those inside an XF, better directly use error_report
	#define BOOL_ERR(_STR)	error_report(_STR)
#else
	#define BOOL_ERR(_STR)	false
#endif

/// Iris 11/08/2010 ORG-1446-P1 STILL_NO_ERR_MSG_SHOW_WHEN_FAIL_TO_READ_FDFFILE
#define BOOL_SHOW_ERR(_STR) okoc_out_msg(_STR, 'E');
///End STILL_NO_ERR_MSG_SHOW_WHEN_FAIL_TO_READ_FDFFILE

#ifdef _DEBUG
	#define ASSERT(_f)	do { if (!(_f) ) OCAssertLine(__FILE__, __LINE__, 1);  } while (0)
#else
	#define ASSERT(_f)
#endif
//------ end PA_FIT_CNTRL_OPEN_EMPTY_NO_ERR_MSG

#define		O_A_FAIL		ASSERT(FALSE)
#define		O_A(_f)			ASSERT(_f)

/// ML 12/7/2006 COLUMN_LABELS_STRINGS
#define	_OL(_STR)	GetLocalized(_STR)
/// end COLUMN_LABELS_STRINGS

///------ Folger 10/18/2012 ORG-7211-P1 LOCALIZE_SAMPLE_OPJS_SHOWN_IN_MENU
#define	_OLC(_STR, _CAT)	GetLocalized(_STR, _CAT)
///------ End LOCALIZE_SAMPLE_OPJS_SHOWN_IN_MENU

///------ Folger 11/03/09 ADD_BITS_OPERATION_MACRO_TO_OC
#define		O_ADD_BIT(var, theBit)					(var |= (theBit))
#define		O_REMOVE_BIT(var, theBit)				(var &= ~(theBit))
#define		O_SET_BIT(var, theBit, bSet)			( (bSet) ? O_ADD_BIT(var, (theBit)) : O_REMOVE_BIT(var, (theBit)) )
#define		O_QUERY_BOOL(var, theBit)				( ((theBit) & (var)) ? TRUE : FALSE )
#define		O_TOGGLE_BIT(var, theBit)				(O_QUERY_BOOL((var), (theBit)) ? O_REMOVE_BIT((var), (theBit)) : O_ADD_BIT((var), (theBit))) 

#define		O_GET_NBITS(mask, nVal)					((mask) & (nVal))
#define		O_SET_NBITS(var, mask, nVal)			(var = O_GET_NBITS(~(mask), var) | O_GET_NBITS(mask, nVal))
///------ End ADD_BITS_OPERATION_MACRO_TO_OC

///------ Folger 03/18/2011 ORG-2486-P1 QUICKFIT_BAD_INIT_ROI_POSITION_FOR_NONLINEAR_SCALE
#define		O_QUERY_BOOL_EX(var, val, mask)		( O_GET_NBITS(mask, var) == val )
///------ End ORG-2486-P1 QUICKFIT_BAD_INIT_ROI_POSITION_FOR_NONLINEAR_SCALE

/// Hong 02/02/10 QA80-15051 IMPRORT_SUPPORT_PROGRESSBAR
#define		NICE_SAFE_REMOVAL(p)		{if (p){ delete p; p = NULL; }}
/// end IMPRORT_SUPPORT_PROGRESSBAR

///-----Kit 10/24/2011 ORG-4157-P1 DISABLE_SOME_IMPORT_MENU_ITEM_WHEN_WKS_REPORT_ACTIVE
#define		ARRAY_SIZE(_arr)			(sizeof(_arr)/sizeof(_arr[0]))
///-----End DISABLE_SOME_IMPORT_MENU_ITEM_WHEN_WKS_REPORT_ACTIVE

#define ERR_MSG(str)	{string _junk(str); OUT(_junk);}
//------------------------------------------------------

/// EJP 02-25-2004 v7.5827 FEEDBACK_MACROS_FOR_LOCAL_DEBUGGING
// These macros are for allowing feed back that is independent from debug settings.
// Debug messages are shown when debug is turned on.  There are times when you want
// to add output messages similar to debug messages but do not want to turn debug on.
// In this case you should add feed back messages to your code and then define _FEEDBACK
// at the top of your C/CPP file.
#ifdef _FEEDBACK
	#pragma message("FEEDBACK macros in Common.h defined")
	#define FEEDBACK_STR(str)		{string _str(str); _str.WriteLine(WRITE_COMPILER_OUTPUT);}
	#define FEEDBACK_INT(n)			{string _str; _str.Format("%d", n); _str.WriteLine(WRITE_COMPILER_OUTPUT);}
	#define FEEDBACK_DBL(d)			{string _str; _str.Format("%f", d); _str.WriteLine(WRITE_COMPILER_OUTPUT);}
	#define FEEDBACK_STRSTR(sz,str)	{string _str; _str.Format("%s = %s", sz, str); _str.WriteLine(WRITE_COMPILER_OUTPUT);}
	#define FEEDBACK_STRINT(sz,n)	{string _str; _str.Format("%s = %d", sz, n); _str.WriteLine(WRITE_COMPILER_OUTPUT);}
	#define FEEDBACK_STRDBL(sz,d)	{string _str; _str.Format("%s = %f", sz, d); _str.WriteLine(WRITE_COMPILER_OUTPUT);}
#else // !_FEEDBACK
	///#pragma message("FEEDBACK macros in Common.h not defined")
	#define FEEDBACK_STR(str)
	#define FEEDBACK_INT(n)
	#define FEEDBACK_DBL(d)
	#define FEEDBACK_STRSTR(sz,str)
	#define FEEDBACK_STRINT(sz,n)
	#define FEEDBACK_STRDBL(sz,d)
#endif // !_FEEDBACK
/// end FEEDBACK_MACROS_FOR_LOCAL_DEBUGGING

#define	_ONAN		(-1.23456789E-300)

#define WM_USER		0x0400

#define	SHIFT_DOWN	(GetKeyState(VK_SHIFT) < 0 )
#define CNTRL_DOWN	(GetKeyState(VK_CONTROL) < 0 ) 
#define ALTER_DOWN	(GetKeyState(VK_MENU) < 0 )	
///------ Folger 03/16/2011 ORG-2434-S2 CNTRL_ENTER_TO_DONE_GET_POINTS_DLG
#define	ENTER_DOWN	(GetKeyState(VK_RETURN) < 0 )
///------ End CNTRL_ENTER_TO_DONE_GET_POINTS_DLG

typedef BOOL (*BOOL_FUNC)( ); //CPY 9/30/04 USE_FIND_FUNC_TO_LOAD_WKBOOKSPLITTER
typedef BOOL (*BOOL_FUNC_INT)(int nn); 
typedef int (*FUNC_INT_DWORD) (int nMsg, DWORD dwCntrl);
typedef int (*FUNC_INT_DWORD_LPVOID) (int nMsg, DWORD dwCntrl, LPVOID lpData);
typedef void (*FUNC_STR)(LPCSTR lpcszHandlerName);

typedef BOOL (*FUNC_STR_DWORD_HWND_TREENODE) (string& strResult, DWORD dwCntrl, HWND hParent, TreeNode& trChangedFDFs);	///Frank 11/22/05 USE_TO_LOAD_PROJECT_BROWSER	///Jasmine 06/08/07 INTERACTIVE_CHANGE_SAVING_BETWEEN_FO_AND_NLFIT
/// YuI 12/08/06 QA70-9150 EXTENDED_GUI_FOR_INTERCATIVE_CONTROL
typedef BOOL (*FUNC_STR_DWORD_HWND_LPCSTR) (string& strResult, DWORD dwCntrl, HWND hParent, LPCSTR lpcszDefault);
/// end EXTENDED_GUI_FOR_INTERCATIVE_CONTROL
typedef BOOL (*FUNC_STR_INT_HWND) 	(string& str, int nInt, HWND hWnd);	/// YuI 12/08/06 QA70-9150 EXTENDED_GUI_FOR_INTERCATIVE_CONTROL

typedef BOOL (*FUNC_VECTOR_STR_DWORD_HWND) (vector<string>& strResults, DWORD dwCntrl, HWND hParent);	///Frank 11/23/05 USE_TO_LOAD_PROJECT_BROWSER
typedef BOOL (*FUNC_STR_DWORD_HWND_BOOL) (string& strResult, DWORD dwCntrl, HWND hParent, bool bWks);	/// Iris 9/06/06 SURFACE_FIT_REPORT_MAT_FIT_DATA

typedef BOOL (*FUNC_STR_VECTOR_STR_HWND) (string strDlgName, vector<string>& strResults, HWND hParent);	///Jasmine 11/25/05 QA70-8352 v8.0340 OPEN_PAGE_PREVIEW_LIST_DLG

typedef BOOL (*FUNC_TREENODE_TREENODE_DWORD_HWND) (TreeNode &trFun, TreeNode &trPeakFunc, DWORD dwOption, HWND hParent); ///Frank 12/02/05 QA70-8307 OPEN_FO_PARAM_BOUND_SETTING_DLG	///Jasmine 07/08/08 QA80-9434 DEFINE_PEAK_FUNC_IN_FO
typedef BOOL (*FUNC_STR_STR_BOOL_INT_HWND) (string& strFullPath, LPCSTR lpcszDefault, bool bShowPlotButton, int nPageType, HWND hParent);	///Jasmine 12/05/27 QA70-8347 v8.0349 CALLED_BY_FINDFUNCTION

///------ Folger 06/01/10 ORG-120 DATA_DISPLAY_DIALOG_IMPROVEMENT
///------ Folger 09/17/2012 ORG-6848-P1 BETTER_OUTPUT_COLUMNS_FILTERING_FOR_INPUT_COLUMN_BROWSER
//typedef BOOL (*FUNC_RANGE_BROWSER) (vector<string>& vsResult, HWND hParent, int nPageType, bool bXYRange = false, bool bMultipleSelect = true, DWORD dwFilter = 0, LPCSTR lpcszDlg = NULL, UINT nSelectedColUID = 0, LPCSTR lpcszBookSheetSpecified = NULL);
typedef BOOL (*FUNC_RANGE_BROWSER) (vector<string>& vsResult, HWND hParent, int nPageType, bool bXYRange = false, bool bMultipleSelect = true, DWORD dwFilter = 0, LPCSTR lpcszDlg = NULL, UINT nSelectedColUID = 0, void* pMore = NULL);
///------ End BETTER_OUTPUT_COLUMNS_FILTERING_FOR_INPUT_COLUMN_BROWSER
///------ End DATA_DISPLAY_DIALOG_IMPROVEMENT

///------ Folger 11/10/2010 ORG-27 NEW_DIGITIZER_GADGET
//typedef BOOL (*FUNC_GET_POINTS_CALLBACK)(double x, double y, string* pstr = NULL);	///Jasmine 03/09/11 ORG-2286 OPTIMIZE_PICKED_POINT
typedef BOOL (*FUNC_GET_POINTS_CALLBACK)(double& x, double& y, string* pstr = NULL);
///------ End NEW_DIGITIZER_GADGET

///------ Folger 12/21/2011 ORG-4312-S2 COLUMN_STR_FROM_BROWSER_SHOULD_CHECK_PREFER_LONG_NAME
typedef BOOL (*PFN_OPEN_COLUMN_BROWSER) (string& strSel, int nType, bool bName, HWND hParent, LPCSTR lpcszWks, BOOL bPreferLongName = TRUE);
///------ End COLUMN_STR_FROM_BROWSER_SHOULD_CHECK_PREFER_LONG_NAME

///------ Folger 05/04/2012 ORG-5592-S1 ADD_DATA_IDENTIFIER_FOR_FITTING_TOOLS
typedef int (*PFN_batch_get_label_type_by_name)(Datasheet& ds, LPCSTR lpcszLabel);
typedef void (*PFN_batch_update_data_indentifiers_ex)(TreeNode& trDataId, TreeNode& trRange, DWORD dwCntrl, LPCSTR lpcszDefault, int nRangeOption);
///------ End ADD_DATA_IDENTIFIER_FOR_FITTING_TOOLS
///------ Folger 05/17/2012 ORG-5592-P2 PROPER_UDPATE_DATA_IDENTIFIER_ON_REPORT_CONTEXT_MENU
typedef bool (*PFN_batch_get_data_identifiers)(vector<string>& vsIDs, DataRange& rng, DWORD dwCntrl = 0);
///------ End PROPER_UDPATE_DATA_IDENTIFIER_ON_REPORT_CONTEXT_MENU
///------ Folger 05/29/2012 ORG-5592-S1 SHOW_DATA_IDENTIFIER_FOR_FLAT_SHEET
typedef void (*PFN_check_show_data_identifier_label_row)(Worksheet& wks, bool bShow);
///------ End SHOW_DATA_IDENTIFIER_FOR_FLAT_SHEET

#pragma dll(@OK)

/**#
*/
void	OCAssertLine(LPCSTR lpcszFile, int nLineNumber, BOOL bDbg);

#pragma dll(msvcrt, system)

__int64 _atoi64(LPCSTR lpcsz);  //Converts string to an integer.

#endif //_OC_COMMON_H


