/*------------------------------------------------------------------------------*
 * File Name: xfgraph_utils.h													*
 * Creation: CPY 11/13/05														*
 * Purpose: support utility functions for all graph based interactive XF		*
 * Copyright (c) OriginLab Corp.2005											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Leo 2005-11-18 ADD_ON_SNAP													*
 *	Kevin 11/18/05 GETN_SAVE_TO_PAGE_SUPPORT									*
 *	Leo 2005-11-29 MOVE_GETNTREE_FUNCTIONS_TO_PLOTMARKER						*
 *	Leo 2005-11-29 CHANGE_THE_FUNCTION_OF_CHECKSETTINGS							*
 *  Sandy 2008-10-13 QA80-12366 ADD_USER_INFO_TREE_ON_EDIT						*
 *------------------------------------------------------------------------------*/

#ifndef _XFGRAPH_UTILS_H
#define _XFGRAPH_UTILS_H
#include <xfutils.h>
//#include <..\Originlab\xfgraph_ID.h>

/**
	calculate the distance between two anchor objects. When glyForCvtTransient provided, using the moving obj2's current position, and can also set obj1 = obj2
*/
bool get_distance(LineInfo& obj2, LineInfo& obj1, int nIndex, double* px, double* py = NULL, GraphLayer& glyForCvtTransient=NULL);

bool get_plot_data_xy(DataPlot& dp, vector& vx, vector& vy, int i1 = 0, int i2 = -1, bool bRemoveMissing = true );

// the followings are related to communication between an XF and the docked dialog in a graph
#define STR_HWND_ATTRIB "GETNDLG_HWND"
#define WM_USER_NOTIFY_STORED_GETN_CHANGED	WM_USER+448	  //CPY, I decided on this value after seeing WM_USER_AUTOCOMPLETE_ON_REPLACE_SEL being 446
#define WM_USER_SHOW_PEAKS_PLOTS			WM_USER+450   //Sandy 2006-3-15
#define STR_STORAGE_NAME	"GetNToGraph"

/**
	save a GetN tree to a page storage and also save the corresponding dialog's hWnd as DWORD attribute STR_HWND_ATTRIB
	Example:
	string strname = "BaselineGetNTree";
	Tree tr;
	HWND hWnd;
	if(load_GetN_from_page(pg, tr, hwnd, strname))
	{
		// make some changes
		tr.Polynomial.p1.dVal += 1;

		// check if hwnd is good
		Window wnd(hwnd);
		if(wnd)
		{
			if(save_GetN_to_page(pg, tr, hwnd, strname)
				wnd.PostMessage(WM_USER_NOTIFY_STORED_GETN_CHANGED);
		}
	}
*/
bool save_GetN_to_page(Page& pg, TreeNode& trGetN, HWND hWndDialog, LPCSTR lpcszStorageName);
/**
	load a saved GetN tree and its associated dialog hWnd
*/
bool load_GetN_from_page(Page& pg, TreeNode& trGetN, HWND& hWndDialog, LPCSTR lpcszStorageName);

// convert beween a polynomial coefficient vector and a GetN tree, this function will assume the
// GetN tree to have branch like trGetN.polynomial.a0, a1 etc
// bTreeToVec = ture, will found number of nodes (visible) in trGetN.polynomial and call vCoeff.SetSize
// bTreeToVec = false, will set trGetN.polynomial.an.Show according to size in vCoeff
// 
//bool convert_polynomial_params(TreeNode& trGetN, vector& vCoeff, bool bTreeToVec);

//bool convert_functional_params(TreeNode& trGetN, vector& vParams, bool bTreeToVec);

bool set_data_plot(const DataPlot& dp, TreeNode& trGetN);
bool get_data_plot(DataPlot& dp, const TreeNode& trGetN);
//Sandy 2006-1-3 MODIFY_FUNCTION_NAME
//void init_vxMarkers(DataPlot dp, int nPoint, vector& vxMI,vector& vyMI);
//bool average_dataplot_markers_by_point(DataPlot dp, vector& vxMI, vector& vyMI, int nPoint);
bool equably_divide_markers_in_dataplot(DataPlot dp, vector& vxMI, vector& vyMI, int nPoint);

///Sandy 2007-3-12 move to tree_utils.h
////Sandy 2006-1-9 Move_From_PFM_UTILS_FOR_USE_IN_O8
////Frank add to check node by dataid, will move to tree.h later or else
//bool tree_check_get_node_by_dataid(TreeNode& trParent,TreeNode& trNew, LPCSTR lpcszTag, int nDataID, int nID = 0, LPCSTR lpcszLableAttrib = NULL); // = 0 = NULL = NULL


///////////////////////////////////////////
class PlotMarkers
{
public:
	PlotMarkers(MarkerInfo& mi)
	{
		TreeNode tr = mi;
		m_trMI = tr;
		m_strStorageName = STR_STORAGE_NAME;	///Leo 2005-11-29 MOVE_GETNTREE_FUNCTIONS_TO_PLOTMARKER
		if(mi.GetParent(m_dp))
		{
			m_idMI = mi.GetID();
			
			TreeNode tr1 = mi.GetUserData();			
			// CheckSettings(tr1);	///Leo 2005-11-29 CHANGE_THE_FUNCTION_OF_CHECKSETTINGS
			m_trUserData = tr1;
		}
		else
			m_idMI = -1;
	}
	virtual	int ProcessEvents(const EventInfo& ei, MarkerInfo& mi) {return false;}
protected:
	bool IsValid()
	{
		if(m_dp && m_trMI.IsValid()) 
			return true;
		else
			return false;
	} 
	int GetID() {return m_idMI;}
	TreeNode GetUserData() {return m_trUserData;}
	bool InitXY(MarkerInfo& mi, const vector& vxMI, const vector& vyMI);
	virtual bool OnInit(MarkerInfo& mi) {return false;}
	
	///Sandy 2008-10-13 QA80-12366 ADD_USER_INFO_TREE_ON_EDIT
	//virtual bool OnEdit(int nMkIndex, MarkerInfo& mi) {return false;}
	virtual bool OnEdit(int nMkIndex, TreeNode& trUserInfo, MarkerInfo& mi) {return false;}
	
	virtual bool OnDelPart(int nMkIndex, TreeNode& trUserInfo, MarkerInfo& mi) {return false;}///Sandy 2008-4-3 ADD_AFTER_ROMAN_IMPLEMENT_11338
	///Leo 2005-12-01 ADD_SAVE_SETTINGS
	// virtual void CheckSettings(TreeNode& trUserData) {}
	//Sandy 2006-1-9 DELETE_USER_DATA 
	//virtual bool CheckSettings(TreeNode& trUserData) {return false;}	//return true, GetN tree is ready; otherwise, false
	//virtual void SaveSettings(TreeNode& trUserData) {}
	virtual bool GetSettings() {return false;}	//return true, GetN tree is ready; otherwise, false
	virtual void SaveSettings() {}
	
	virtual bool OnSnap(MarkerInfo& mi) {return false;}	///Leo 2005-11-18 ADD_ON_SNAP
	virtual bool OnUpdate(int nMkIndex, MarkerInfo& mi) {return false;}		///Kevin 11/19/05 ADD_ON_UPDATE
	virtual bool OnSelect(int nMkIndex, MarkerInfo& mi) {return false;}		///Sandy 2006-4-18 ADD_ON_SELECT
	///Leo 2005-11-29 MOVE_GETNTREE_FUNCTIONS_TO_PLOTMARKER
	bool GetGetNTree(TreeNode& trGetN, LPCSTR lpcszStorageName = NULL);	///Kevin 11/19/05 GETN_SAVE_TO_PAGE_SUPPORT
	bool SetGetNTree(TreeNode& trGetN, LPCSTR lpcszStorageName = NULL);	///Kevin 11/19/05 GETN_SAVE_TO_PAGE_SUPPORT
	///End MOVE_GETNTREE_FUNCTIONS_TO_PLOTMARKER
	////Sandy ADD_MEMBER_FUNC_TO_SAVE_SOURCE_DATA_PLOT_ID
	//bool SetDataPlotID(int nDataPlotID, int nTreeNodeDataID);
	//bool GetDataPlotID(int& nDataPlotID, int nTreeNodeDataID);
	////end ADD_MEMBER_FUNC_TO_SAVE_SOURCE_DATA_PLOT_ID

	DataPlot	m_dp;
	TreeNode	m_trMI;
	
	GraphPage	m_gp;		///Kevin 11/19/05 GETN_SAVE_TO_PAGE_SUPPORT
	
	////Sandy 2005-12-29 ADD_DATA_PLOT_ID
	//int         m_srcDataPlotID;
	//int         m_baselinePlotID;
	////end ADD_DATA_PLOT_ID

private:
		
	TreeNode	m_trUserData;

	int			m_idMI;
	///Leo 2005-11-29 MOVE_GETNTREE_FUNCTIONS_TO_PLOTMARKER	
	HWND		m_hwnd;
	string		m_strStorageName;
	///End MOVE_GETNTREE_FUNCTIONS_TO_PLOTMARKER
};

class CurveMarkers : public PlotMarkers
{
public:
	CurveMarkers(MarkerInfo& mi) : PlotMarkers(mi)
	{
		///Leo 2005-11-29 MOVE_GETNTREE_FUNCTIONS_TO_PLOTMARKER
		// m_strStorageName = STR_STORAGE_NAME;
	}
	//virtual	
	int ProcessEvents(const EventInfo& ei, MarkerInfo& mi);
	
	///Leo 2005-11-29 MOVE_GETNTREE_FUNCTIONS_TO_PLOTMARKER
	// bool GetGetNTree(TreeNode& trGetN, LPCSTR lpcszStorageName = NULL);	///Kevin 11/19/05 GETN_SAVE_TO_PAGE_SUPPORT
	// bool SetGetNTree(TreeNode& trGetN, LPCSTR lpcszStorageName = NULL);	///Kevin 11/19/05 GETN_SAVE_TO_PAGE_SUPPORT

// private:
	// HWND		m_hwnd;	///Kevin 11/18/05 GETN_SAVE_TO_PAGE_SUPPORT
	// string		m_strStorageName;
	//End MOVE_GETNTREE_FUNCTIONS_TO_PLOTMARKER
};

//Sandy 2006-2-9 ADD_TO_STANDARDIZE_SAVE_OR_GET_DATAPLOT_FROM_TREE
bool dataplot_save_to_tree(TreeNode& trN, DataPlot& dp);
bool dataplot_read_from_tree(GraphLayer& gl, TreeNode& trN, DataPlot& dp);	

	




///Sandy 2007-3-31 add
/// Hong 11/22/07 v8.0753 CLEAN_CODE_ALLOW_LT_ACCESS_WITHOUT_DATAPLOT_DEPENDENCE
//bool get_gl_from_xyrange_plot(GraphLayer& gl, XYRange& xyr);
bool get_gl_from_xyrange_plot(GraphLayer& gl, XYRange& xyr, DataPlot* pdp = NULL);
/// end CLEAN_CODE_ALLOW_LT_ACCESS_WITHOUT_DATAPLOT_DEPENDENCE
/// YuI 12/17/07 VISUAL_FEEDBACK_FOR_INTEGRATION
//	bool get_gl_from_xyr_treenode(GraphLayer& gl, TreeNode& tr);
bool get_gl_from_xyr_treenode(GraphLayer& gl, TreeNode& tr, DataPlot& dp = NULL);
/// end VISUAL_FEEDBACK_FOR_INTEGRATION

#endif //_XFGRAPH_UTILS_H

