/*------------------------------------------------------------------------------*
 * File Name: TreeEditor.h	 													*
 * Creation: TD, CPY															*
 * Purpose: OriginC Header for OTreeEditor DLL implemented control for			*
 *			XML based Tree editing												*
 * Copyright (c) Originlab Corp.	2002, 2003, 2004, 2005, 2006, 2007			*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	ML 4/12/2007 QA70-6961 PS_PLOT_RANGE_REMEMBERED_ON_REPLACE					*
 *	ML 10/10/2008 QA70-11938 GETTING_COLUMN_HEADINGS_FOR_PS						*
 *	Hong QA80-15357 03/31/10 REPLACE_VSFLEX_WITH_64_MP_COMPATIABLE_WXGRID		*
 *	Kenny 04/27/2010 QA80-15357 REPLACE_VSFLEX_WITH_64_MP_COMPATIABLE_WXGRID	*
 *	Kenny 06/13/2010 ORG-305-P2 GRIDCONTROL_IS_COLLAPSED_FUNCTION_RETURN_WRONG_VALUE*
 *	Bill 11/16/2010 ORG-1520 ADD_INTERFACE_TO_SET_A_COLUMN_COULD_HIGHLIGHT_OR_NOT*
 *	Bill 12/06/2010 ORG-1646 ADD_INTERFACE_TO_ADD_COLUMN_ITEM					*
 *	Bill 12/22/2010 ADD_INTERFACE_TO_SET_CELL_COMBOLIST							*
 *	Bill 12/22/2010 ADD_INTERFACE_TO_SET_ROW_IS_SELECT							*
 *	Bill 12/27/2010 ORG-1851 SUPPORT_NESTED_COL_SORT							*
 *	Bill 01/12/2011 ORG-1997-S6 DRAW_MARKER_FOR_THE_HIDEED_COLUMN				*
 *	Bill 02/15/2011 ORG-2217-S1 SUPPORT_SCRIPT_IN_WXGRID						*
 *	Bill 09/23/2011 ORG-3602-S1 SUPPORT_KEYBOARD_NAVIGATION_FOR_WXGRID			*
 *	Bill 09/28/2011 ORG-3616-S3 SUPPORT_DRAG_AND_DROP_ON_MULTIPLE_SELECTIONS_FOR_OC
 *	Bill 11/24/2011 ORG-4440-S1 SUPPORT_DND										*
 *	Bill 11/25/2011 ORG-4440-S2 SUPPORT_HIGHTLIGHT_COLUMN_HEADER				*
 *	Folger 12/21/2011 ORG-4508 MOVE_TIME_CONSUMING_OC_FUNCTION_TO_VC			*
 *	Folger 02/29/2012 ORG-5108-S3 SUPPORT_AUTO_COLUMN_WIDTH_IN_DATA_INFO		*
 *	Folger 05/07/2012 ORG-5627-P3 ORIGIN_CRASH_IF_WXGRID_TREE_WITH_MANY_ICONS	*
 *------------------------------------------------------------------------------*/

#ifndef _TREEEDITOR_H_
#define _TREEEDITOR_H_

//#include <Control.h>
//#include <tree.h>

#pragma dll(OTreeEditor.dll)

/// Hong QA80-15357 03/31/10 REPLACE_VSFLEX_WITH_64_MP_COMPATIABLE_WXGRID
#ifdef		__REPLACE_VSFLEX_WITH_64_MP_WXGRID__

class wxGirdInterface
: public OriginObject
{
public:
	wxGirdInterface();
	
	int			AllowSelection;
	int			AllowUserResizing;
	int			AutoSizeMode;
	int			Col;
	int			Cols;
	int			ColWidthMax;
	int			ColWidthMin;
	int			ComboIndex;
	string		ComboList;
	int			Editable;
	int			Ellipsis;
	int			Enabled;
	int			ExplorerBar;
	int			ExtendLastCol;
	int			FixedCols;
	int			FixedRows;
	int			FocusRect;
	string		FormatString;
	COLORREF	GridColor;
	int			GridLines;
	int			GridLineWidth;
	int			HighLight;
	int			MergeCells;
	int			MouseCol;
	int			MouseRow;
	int			OutlineBar;
	int			OutlineCol;
	int			OwnerDraw;
	int			Redraw;
	int			Row;
	int			Rows;
	int			RowSel;
	int			SelectedRows;
	int			SelectionMode;
	string		Text;
////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////Begin Unimplemented Property///////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////
/*Hong, !!!Notice:
	when u r in need to used property below, plx go to OCTreeGridControl.cpp, find the implementation of this property,
	change WARN_NEW_INTERFACE_NOT_IMPLEMENTED to WARN_OLD_INTERFACE_NOT_IMPLEMENTED and notice Hong about it,
	or better that u can implement it yourself.
*/
	string		AccessibleDescription;
	string		AccessibleName;
	int			AccessibleRole;
	string		AccessibleValue;
	int			AllowBigSelection;
	int			AllowUserFreezing;
	int			Appearance;
	int			AutoResize;
	int			AutoSearch;
	int			AutoSearchDelay;
	int			AutoSizeMouse;
	COLORREF	BackColor;
	COLORREF	BackColorAlternate;
	COLORREF	BackColorBkg;
	COLORREF	BackColorFixed;
	COLORREF	BackColorFrozen;
	COLORREF	BackColorSel;
	int			BottomRow;
	int			CellAlignment;
	COLORREF	CellBackColor;
	int			CellButtonPicture;
	int			CellChecked;
	COLORREF	CellFloodColor;
	int			CellFloodPercent;
	int			CellFontBold;
	int			CellFontItalic;
	string		CellFontName;
	int			CellFontSize;
	int			CellFontStrikethru;
	int			CellFontUnderline;
	int			CellFontWidth;
	COLORREF	CellForeColor;
	int			CellHeight;
	int			CellLeft;
	int			CellPicture;
	int			CellPictureAlignment;
	int			CellTextStyle;
	int			CellTop;
	int			CellWidth;
	int			ClientHeight;
	int			ClientWidth;
	string		Clip;
	string		ClipSeparators;
	int			ColSel;
	int			ComboCount;
	int			ComboSearch;
	string		DataMember;
	int			DataMode;
	int			DataSource;
	int			DragMode;
	string		EditMask;
	int			EditMaxLength;
	int			EditSelLength;
	int			EditSelStart;
	string		EditSelText;
	string		EditText;
	int			EditWindow;
	int			FillStyle;
	int			Flags;
	int			FlexDataSource;
	COLORREF	FloodColor;
	int			FontBold;
	int			FontItalic;
	string		FontName;
	int			FontSize;
	int			FontStrikethru;
	int			FontUnderline;
	int			FontWidth;
	COLORREF	ForeColor;
	COLORREF	ForeColorFixed;
	COLORREF	ForeColorFrozen;
	COLORREF	ForeColorSel;
	int			FrozenCols;
	int			FrozenRows;
	COLORREF	GridColorFixed;
	int			GridLinesFixed;
	int			GroupCompare;
	int			IsSearching;
	int			LeftCol;
	int			MergeCellsFixed;
	int			MergeCompare;
	int			MultiTotals;
	int			NodeClosedPicture;
	int			NodeOpenPicture;
	int			OLEDragMode;
	int			OLEDropMode;
	int			Picture;
	int			PicturesOver;
	int			PictureType;
	int			RightCol;
	int			RightToLeft;
	int			RowHeightMax;
	int			RowHeightMin;
	int			ScrollBars;
	int			ScrollTips;
	string		ScrollTipText;
	int			ScrollTrack;
	COLORREF	SheetBorder;
	int			ShowComboButton;
	int			Sort;
	int			SortAscendingPicture;
	int			SortDescendingPicture;
	int			SubtotalPosition;
	int			TabBehavior;
	int			TextStyle;
	int			TextStyleFixed;
	int			TopRow;
	COLORREF	TreeColor;
	double		Value;
	int			Version;
	int			VirtualData;
	int			WallPaper;
	int			WallPaperAlignment;
	int			WordWrap;
////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////End Unimplemented Property//////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////
	
public:
	
	BOOL		AddItem(string strVals, long Row = -1);
	BOOL		RemoveItem(long Row = -1);

	void		SetCell(_VARIANT var, int setting, long r1 = -1, long c1 = -1, long r2 = -1, long c2 = -1);
	_VARIANT	GetCell(int setting, long r1, long c1, long r2 = -1, long c2 = -1);
	string		GetTextMatrix(long Row, long Col);
	void		SetTextMatrix(long Row, long Col, string strVal);

	//---	Jacky 09/03/10 IMPLEMENT_WXGRID
	string		GetColComboList(long Col);
	//---	end IMPLEMENT_WXGRID
	void		SetColComboList(long Col, string strCombo);
	
	//---	Jacky 09/03/10 IMPLEMENT_WXGRID
	//void		SetComboItem(long index, string strVal);
	//---	end IMPLEMENT_WXGRID
	string		GetComboItem(long index);

	_VARIANT	GetRowData(long Row);
	void		SetRowData(long Row, _VARIANT var);

	bool		GetIsSelected(long Row);
	void		SetIsSelected(long Row, bool bSel);

	long		FindRow(_VARIANT item, long Row = -1, long Col = -1, bool bCaseSensitive = true, bool bFullMatch = true);

	int			GetColDataType(long Col);
	void		SetColDataType(long Col, int nType);
////////////////////////////////////////////////////////////////////////////////////////
	void		ShowCell(long Row, long Col);
	void		AutoSize(long Col1, long Col2, bool bAllSameWidth = false, int nExtraSpace = 0);

	bool		GetIsSubtotal(long Row);
	void		SetIsSubtotal(long Row, bool bVal);
	long		GetRowOutlineLevel(long Row);
	void		SetRowOutlineLevel(long Row, long nLevel);

	long		GetSelectedRow(long index);

	void		SetColWidth(long Col, int nWidth);
	int			GetColWidth(long Col);
	int			GetRowHeight(long Row);
	void		SetRowHeight(long Row, int nHeight);

	bool		GetIsRowHidden(long Row);
	void		SetIsRowHidden(long Row, bool bVal);
	bool		GetIsColHidden(long Col);
	void		SetIsColHidden(long Col, bool bVal);


	void		FinishEditing(bool bFinish);

	void		SetMergeRow(long Row, bool bMerge);
	void		SetMergeCol(long Col, bool bMerge);

	void		SetColAlignment(long Col, int nMode);
	int			GetColAlignment(long Col);
	void		SetFixedAlignment(long Col, int nMode);
	int			GetFixedAlignment(long Col);
////////////////////////////////////////////////////////////////////////////////////////

	/// Kenny 04/27/2010 QA80-15357 REPLACE_VSFLEX_WITH_64_MP_COMPATIABLE_WXGRID
	void		Select(long Row, long Col, long RowSel = -1, long ColSel = -1);
	void		EditCell();
	void		Outline(int nLevel);

	/// Kenny 06/13/2010 ORG-305-P2 GRIDCONTROL_IS_COLLAPSED_FUNCTION_RETURN_WRONG_VALUE
// 	bool		GetIsCollapsed(long Row);
// 	void		SetIsCollapsed(long Row, bool bSel);
	int			GetIsCollapsed(long Row);
	void		SetIsCollapsed(long Row, int nVal);
	/// End ORG-305-P2 GRIDCONTROL_IS_COLLAPSED_FUNCTION_RETURN_WRONG_VALUE

	int			GetColFormat(long Col);
	void		SetColFormat(long Col, string strFormat);
	/// End QA80-15357 REPLACE_VSFLEX_WITH_64_MP_COMPATIABLE_WXGRID

	BOOL		SetColPosition(int nCol, int nPos);
	BOOL		SetRowPosition(int nRow, int nPos);

	/// Bill 11/16/2010 ORG-1520 ADD_INTERFACE_TO_SET_A_COLUMN_COULD_HIGHLIGHT_OR_NOT
	BOOL		SetColHighlight(int nCol, bool bHighlightOn);
	/// End ADD_INTERFACE_TO_SET_A_COLUMN_COULD_HIGHLIGHT_OR_NOT
	
	/// Bill 12/06/2010 ORG-1646 ADD_INTERFACE_TO_ADD_COLUMN_ITEM
	BOOL		SetTableValue(vector<string> * pvsItems, int nNumRow, int nNumCol, int nStartRow, int nStartCol, bool bByRow);
	/// End ADD_INTERFACE_TO_ADD_COLUMN_ITEM
	
	/// Bill 12/22/2010 ADD_INTERFACE_TO_SET_CELL_COMBOLIST
	void		SetCellComboList(int nRow, int nCol, LPCSTR	lpcszComboList);
	/// End ADD_INTERFACE_TO_SET_CELL_COMBOLIST
	
	/// Bill 12/22/2010 ADD_INTERFACE_TO_SET_ROW_IS_SELECT
	void		SetRowAlwaySelected(int nRow, bool bSel);
	/// End ADD_INTERFACE_TO_SET_ROW_IS_SELECT
	
	/// Bill 12/27/2010 ORG-1851 SUPPORT_NESTED_COL_SORT
	void		SetNestedColSort(vector<int> & vCols);
	/// End SUPPORT_NESTED_COL_SORT
	
	/// Bill 01/12/2011 ORG-1997-S6 DRAW_MARKER_FOR_THE_HIDEED_COLUMN
	bool		GetDrawHidedColMarker();
	void		SetDrawHidedColMarker(bool bDraw);
	/// End DRAW_MARKER_FOR_THE_HIDEED_COLUMN
	
	/// Bill 02/15/2011 ORG-2217-S1 SUPPORT_SCRIPT_IN_WXGRID
	void		EnableScript(bool bEnable);
	bool		IsEnableScript();
	/// End SUPPORT_SCRIPT_IN_WXGRID
	
	/// Bill 09/23/2011 ORG-3602-S1 SUPPORT_KEYBOARD_NAVIGATION_FOR_WXGRID
	void		EnableNavigation(bool bEnable);
	void		SetNavigationCol(long nCol);
	/// End SUPPORT_KEYBOARD_NAVIGATION_FOR_WXGRID
	
	/// Bill 09/28/2011 ORG-3616-S3 SUPPORT_DRAG_AND_DROP_ON_MULTIPLE_SELECTIONS_FOR_OC
	void		EnableMultiRowMove(bool bEnable);
	bool		IsEnableMultiRowMove();
	/// End SUPPORT_DRAG_AND_DROP_ON_MULTIPLE_SELECTIONS_FOR_OC
	
	void		OLEDrag(); /// Bill 11/24/2011 ORG-4440-S1 SUPPORT_DND

	void		EnableHightlightColHeader(bool bEnable); /// Bill 11/25/2011 ORG-4440-S2 SUPPORT_HIGHTLIGHT_COLUMN_HEADER

	///------ Folger 12/21/2011 ORG-4508 MOVE_TIME_CONSUMING_OC_FUNCTION_TO_VC
	BOOL		GetRowValues(int nRow, vector<string>* pvsVals, int nCol1 = 0);
	BOOL		GetColValues(int nCol, vector<string>* pvsVals, int nRow1 = 0);
	///------ End MOVE_TIME_CONSUMING_OC_FUNCTION_TO_VC

	void		SetCellEditMask(long nRow, long nCol, LPCSTR lpcszEditMask);		///------ Folger 02/29/2012 ORG-5108-S3 SUPPORT_AUTO_COLUMN_WIDTH_IN_DATA_INFO

	_VARIANT	GetCachedImage(int nResID, int nResIDToSuperimpose, HINSTANCE hInst = NULL, int nSize = 0); ///------ Folger 05/07/2012 ORG-5627-P3 ORIGIN_CRASH_IF_WXGRID_TREE_WITH_MANY_ICONS
};


class TreeGridControl : public Control
{
public:
	TreeGridControl();
	TreeGridControl(Control& ctrl);
	TreeGridControl(Window& wnd);
	
	wxGirdInterface GetGridCtrlInterface();
};


#endif		//__REPLACE_VSFLEX_WITH_64_MP_WXGRID__
/// end REPLACE_VSFLEX_WITH_64_MP_COMPATIABLE_WXGRID

/**#
	Notice:
	1. When use TreeEditor attach to the Control, you need to add a string table in rc file, or it can't create correctly.
		Example: 
		uMainDlgID	= IDD_SEL_COLS_PLOTTING , uCtrlID = IDC_SELCOLS_PLOTS
		uMainDlgID	= "SCPLC" , uCtrlID	= "SCPLC.DataPlots -C(OTreeEditor)"
		In uCtriID string table, 'DataPlots' is a Control Type. More detail in OTreeEditorDll.cpp
	2. The uMainDlgID range is [100, 500], uCtrlID range need to be [6000, 12000]. For more details, see IntTree.h
*/
class TreeEditor
: public Control
{
public:
	TreeEditor();
	TreeEditor(Control& ctrl);
	TreeEditor(Window& wnd);
	
	BOOL Load(LPCSTR lpcszXMLFile);
	/**#
	Example:
		OTreeEditor	te = dlg.GetDlgItem(IDC_TREE_EDITOR);
		te.Save(GetAppPath() + "theme.xml");
	*/
	BOOL Save(LPCSTR lpcszFilename, BOOL bSelectedOnly=FALSE, BOOL bVisibleOnly=FALSE);
	
	BOOL Build(BOOL bBegin);
	
	int	AddItem(UINT nNodeType, LPCTSTR lpcszNodeLabel, LPCTSTR lpcsz=NULL, DWORD dwParam1=0L, UINT nNodeID = 0);
	BOOL SetValue(int nValue);
	BOOL SetValue(double fValue);
	BOOL SetValue(LPCSTR lpcszValue);
	
#if _OC_VER > 0x0703
	/**
			Adding or replacing a treenode inside the editor
		Parameters:
			tr = a node to be added or to be used to replace an existing node
			bReplace = ture will replace or to add depending on nRowLocation and whether the node already existed, see Remarks.
			nRowLocation = if bReplace is false, or if it is negative, then ignore, otherwise to specified the location to replace
		Remark:
			For the case where bReplace is true but nRowLocation < 0, then this function will do the following
			1. If the node does not already existed, based on a case by case condition in the nature of the tree, the node is simply added to the end
			2. If the node already existed, then we will replace it with the new node
			For the case where bReplace is true and nRowLocation is also specified, the
			1. If the node does not already existed, we simply replace the specifed row with the new node
			2. If the node already existed and is at the same row as the specified row, then we also just replace it
			3. If the node already existed but is at a different node then the specified row, we will need to first replace the specified row, then remove the conflicting one
		//------------------------
			On return *parrLayerRows receives the indices of the rows containing the layer branches of the layers
			inside which adding (or replacement) happened.
	*/
	BOOL	Add(const TreeNode &tr, BOOL bReplace, vector<uint> *parrLayerRows = NULL);
	BOOL	Add(const TreeNode &tr, vector<uint> &vPlotTypes, vector<uint> *parrLayerRows = NULL);
	
	/**#
	*/
	BOOL	GetTreeNode(TreeNode &tr, LONG nRow);
	
	/**#
	*/
	BOOL	SetTreeNode(TreeNode &tr, LONG nRow);
	
	/**#
	*/
	/// ML 10/10/2008 QA70-11938 GETTING_COLUMN_HEADINGS_FOR_PS
	///// ML 4/12/2007 QA70-6961 PS_PLOT_RANGE_REMEMBERED_ON_REPLACE
	////BOOL	BeginRowEdit(string &strGraphLayerName, string &strGraphGroupName, string &strWksPageName, string &strWksLayerName, vector<uint> &vnColDesignations, vector<string> &vstrColNames, int &nPlotType, DWORD &dwAuxTypeInfo, DWORD &dwLTPlotInfo, string &strColPattern);
	//BOOL	BeginRowEdit(string &strGraphLayerName, string &strGraphGroupName, string &strWksPageName, string &strWksLayerName, vector<uint> &vnColDesignations, vector<string> &vstrColNames, int &nPlotType, DWORD &dwAuxTypeInfo, DWORD &dwLTPlotInfo, string &strColPattern, int *pnRangeRows = NULL);
	///// end PS_PLOT_RANGE_REMEMBERED_ON_REPLACE
	BOOL	BeginRowEdit(string &strGraphLayerName, string &strGraphGroupName, string &strWksPageName, string &strWksLayerName, vector<uint> &vnColDesignations, vector<string> &vstrColNames, int &nPlotType, DWORD &dwAuxTypeInfo, DWORD &dwLTPlotInfo, string &strColPattern, int *pnRangeRows = NULL, vector<string> &vstrColHeadings = NULL);
	/// end GETTING_COLUMN_HEADINGS_FOR_PS
	
	/**#
	*/
	BOOL	EndRowEdit();
	
	/**#
			Returns the information about the tree. The information depends on the type of the tree editor.
		Parameters:
			dwOptions = optional description of what kind of information is needed.
	*/
	DWORD	GetInfo(DWORD dwOptions = 0);
	
	/**#
	*/
	DWORD	GetRowInfo(int nRow, UINT &lParam, UINT &wParam);

	
#endif	// _OC_VER > 0x0703

	/**#
	*/
	int GetSelectedRows(vector<uint> *parrRows = NULL, BOOL bExcludeBranchNodes = FALSE);

	//properties
	DWORD 		View;
	
	TreeNode	Root;

	/**#
	get the internal property object, to be used in EditorManager class
	*/
	ODWP		GetProperty(uint nRow);	/// TD ML 11-09-2010 NEW_TYPES

#ifdef	ORIGIN_COM_SUPPORT
	/**#
	*/
	_VARIANT GetActiveXControl();
#endif //#ifdef	ORIGIN_COM_SUPPORT

	/// Hong QA80-15357 03/31/10 REPLACE_VSFLEX_WITH_64_MP_COMPATIABLE_WXGRID
#ifdef		__REPLACE_VSFLEX_WITH_64_MP_WXGRID__
	wxGirdInterface GetGridCtrlInterface();
#endif		//__REPLACE_VSFLEX_WITH_64_MP_WXGRID__
	/// end REPLACE_VSFLEX_WITH_64_MP_COMPATIABLE_WXGRID
};

#endif //!_TREEEDITOR_H_

