/*------------------------------------------------------------------------------*
 *	File Name: 	Stat.h	     													*
 *	Purpose:	Stat function prototypes for calling statistical functions		*
 *	Creation:	April 11, 2001 by GJL											* 
 *	Copyright (c) OriginLab Corp. 2001, 2002, 2003, 2004						*
 *	All Rights Reserved															*
 *	Modification log                                                        	*
 *	CPY 4/2/04 share this file to ocMath to be called from internal DLLs		*
 *------------------------------------------------------------------------------*/  

#ifndef _STAT_H
#define _STAT_H

#ifdef _MSC_VER	   //VC
	#ifdef OUTIL_EXPORTS
		#define OUTIL_API __declspec(dllexport)
	#else
		#define OUTIL_API __declspec(dllimport)
	#endif
	#ifdef __cplusplus
		extern "C" {
	#endif	// __cplusplus 
#else //_MSC_VER
	#define OUTIL_API
	// Origin C specific command to include an external DLL
	// All function declarations will be for the importdll
	// until another importdll is specified or when the end
	// of the header file is reached
	#pragma dll(@OUTL)
#endif	//!_MSC_VER

// Existing Statistical Distribution Functions

// Category last updated by Echo on 03/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tTable_(global_function)
*/
OUTIL_API double	tTable(double dP, int nDof); // Student's t distribution.	///Leo 2005-9-19 QA70-2677

// Category last updated by Echo on 03/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:invt_(global_function)
*/
OUTIL_API double	invt(double dt, int nDof); // Student's inverse t distribution.

// Category last updated by Echo on 03/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Ftable_(global_function)
*/
OUTIL_API double	Ftable(double dP, UINT nNumDof, UINT nDenDof); // F distribution.

// Category last updated by Echo on 03/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:invf_(global_function)
*/
OUTIL_API double	invf(double dF, int nNumDof, int nDenDof); // Inverse F distribution.	///Leo 2005-9-19 QA70-2675

/** >Statistics>Distribution Functions
		Error function (or normal error integral).
	Example1:
		void erf_ex1()
		{
			double dy,dx=1;
			dy=erf(dx); // results in dy==0.8427008
		}
	Parameters:
		dx=Upper limit (dx is any Real) of the definite integral in the erf function.
	Return:
		erf(x)=2/sqrt(pi)*(definite integral of exp(-u^2)du from 0 to +x).
	SeeAlso:
		inverf
*/
//----CPY 2/21/2008 v8.0808 QA70-6197 ERFC_IN_OC_MOVE_ERF_TO_USE_OCMATH
//OUTIL_API double	erf(double dx); // Error function.
//
//----
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:inverf_(global_function)
*/
OUTIL_API double	inverf(double dy); // Inverse error function.

// Category last updated by Echo on 03/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:prob_(global_function)
*/
OUTIL_API double	prob(double dz); // Probability density for a normal distribution.

// Category last updated by Echo on 03/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:invprob_(global_function)
*/
OUTIL_API double	invprob(double dA); // Inverse probability density for a normal distribution.

// Category last updated by Echo on 03/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:invncp_(global_function)
*/
OUTIL_API double invncp(double dA);

/**#
Example1:
	void invncp1_ex1()
	{
		double dz,dA=0.8413447;
		dz=invncp1(dA); // results in dz==1   

		out_double("The value is ",dz);
	}
*/
OUTIL_API double invncp1(double x);  // different algorithm, does not work as well in small x
/**#
Example1:
	void invncp2_ex1()
	{
			double dz,dA=0.8413447;
			dz=invncp2(dA); // results in dz==1   
	
			out_double("The value is ",dz);
	}
*/
OUTIL_API double invncp2(double x);  // different algorithm, does not work as well in small x

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:QCD2_(global_function)
*/
OUTIL_API double	QCD2(UINT nn); // Quality Control D2 Factor.

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:QCD3_(global_function)
*/
OUTIL_API double	QCD3(UINT nn); // Quality Control D3 Factor.

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:QCD4_(global_function)
*/
OUTIL_API double	QCD4(UINT nn); // Quality Control D4 Factor.

// New Statistical Functions
// Category last updated by Echo on 03/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:probt_(global_function)
*/
OUTIL_API double	probt(double dt, UINT nDof); // Student's inverse t distribution.

//Comment last updated by Joseph 09/11/07
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:incbeta_(global_function)
*/
OUTIL_API	double incbeta( double x, double a, double b );

// Comments last updated by Frank on 08/09/05
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:incgamma_(global_function)
*/
OUTIL_API double incgamma( double x, double a );


// Category last updated by Echo on 03/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ChisqDist_(global_function)
*/
OUTIL_API	double	ChisqDist( double dp, UINT nDof);


// Category last updated by Echo on 03/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:invchisq_(global_function)
*/
OUTIL_API double invchisq(double dChiSq, UINT nDOF);


// Comments last updated by Frank on 08/29/05
/**$ >Statistics>Distribution Functions
		It finds a bin index based on the value, the starting value, and the increment. It evaluates
		the integral part of (rValue - rStart) / rInc by properly checking for floating point errors.
	Example1:
		void nice_bin_index_ex1()
		{
			double dValue, dStart, dInc;
			dValue = 100;
			dStart = 1;
			dInc = 3.4;
			
			LONG lBIndex  = nice_bin_index(dValue, dStart, dInc);
			//lBIndex should equal to 29
		}
	Paramater:
		rValue=the value for which a bin index is saught.
		rStart=the starting value
		rInc=increment
	Return:
		the bin index.
*/
OUTIL_API	LONG	nice_bin_index(double rValue, double rStart, double rInc);




#ifdef __cplusplus
	}
#endif	//__cplusplus

#endif  //_STAT_H
