/*------------------------------------------------------------------------------*
 * File Name: Settigns.h														*
 * Creation: YuI 12/20/2002														*
 * Purpose: Origin C OriginSettings Class Header								*
 * Copyright (c) OriginLab Corp.2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007	*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * EJP 2007-04-11 v8.0599 QA70-8786 GET_STR_AND_DOUBLE_SETTINGS					*
 * Sim 03-11-2008 QA80-11240 INI_FILE_SUPPORT_READ_WRITE_DOUBLE					*
 *	Sophy 1/30/2011 ORG-2131-P2 IMPROVE_LOAD_DIALOG_DATA_WHEN_FROM_NETWORK_UFF	*
 *	Sophy 4/2/2011 ORG-2568-P1 PROPER_ACCESS_REGISTRY_ON_WIN64_PLATFORM			*
 *------------------------------------------------------------------------------*/
#ifndef _SETTINGS_H
#define _SETTINGS_H

///Comments last updated by Cloud on 03/15/2007
/**# >Internal Origin Objects
 		The OriginSettings class provides methods and properties to access different 
 		customizable settings of Origin.
	Example:
		// get types of file that can be imported into the active page
		// and bring up "Open File" dialog box
		void test()
		{
			StringArray saTypes;
			PageBase pg = Project.Pages();
			Project.Settings.GetUserTypes(saTypes, pg.GetType());
			string strPath = GetOpenBox(saTypes);
			printf("File name is \"%s\"", strPath);
		}
		
*/
class	OriginSettings
{
public:
	OriginSettings();
	
public:
	void	GetUserTypes(StringArray& saTypes, int nGroup);
	
	int		GetPercentileInterpolateMethod();

	/// EJP 2006-06-27 v8.0433 QA70-8786 GET_INT_LABTALK_VAR
	BOOL GetValue(LPCSTR lpcszProp, int& nVal);
	BOOL SetValue(LPCSTR lpcszProp, int nVal);
	/// end GET_INT_LABTALK_VAR

	/// EJP 2007-04-11 v8.0599 QA70-8786 GET_STR_AND_DOUBLE_SETTINGS
	BOOL GetValue(LPCSTR lpcszProp, double& dVal);
	BOOL SetValue(LPCSTR lpcszProp, double dVal);
	BOOL GetValue(LPCSTR lpcszProp, string& strVal);
	BOOL SetValue(LPCSTR lpcszProp, LPCSTR lpcszVal);
	/// end GET_STR_AND_DOUBLE_SETTINGS
};


/**+
http://ocwiki.originlab.com/index.php?title=Category:INIFile_(class)
*/
class INIFile
{
public:
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:INIFile-INIFile
	*/
	///Sophy 1/30/2011 ORG-2131-P2 IMPROVE_LOAD_DIALOG_DATA_WHEN_FROM_NETWORK_UFF
	//INIFile(LPCSTR lpcszFilename = NULL, BOOL bUseIniPath = TRUE);
	INIFile(LPCSTR lpcszFilename = NULL, BOOL bUseIniPath = TRUE, BOOL bCopyFileIfNetworkPath = FALSE);
	///end IMPROVE_LOAD_DIALOG_DATA_WHEN_FROM_NETWORK_UFF

public:
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:INIFile-GetSectionNames
	*/
	int GetSectionNames(StringArray &saSections);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:INIFile-GetKeyNames
	*/
	int GetKeyNames(StringArray &saKeys, LPCSTR lpcszSection);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:INIFile-ReadInt
	*/
	int		ReadInt(LPCSTR lpcszSection, LPCSTR lpcszKey, int nDefault);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:INIFile-WriteInt
	*/
	void	WriteInt(LPCSTR lpcszSection, LPCSTR lpcszKey, int nValue);
		
	///---Sim 03-11-2008 QA80-11240 INI_FILE_SUPPORT_READ_WRITE_DOUBLE
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:INIFile-ReadDouble
	*/
	double	ReadDouble(LPCSTR lpcszSection, LPCSTR lpcszKey, double dDefault);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:INIFile-WriteDouble
	*/
	void	WriteDouble(LPCSTR lpcszSection, LPCSTR lpcszKey, double dValue);
	///---END QA80-11240 INI_FILE_SUPPORT_READ_WRITE_DOUBLE
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:INIFile-ReadString
	*/
	string	ReadString(LPCSTR lpcszSection, LPCSTR lpcszKey, LPCSTR lpcszDefault = NULL);
	
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:INIFile-WriteString
	*/
	void	WriteString(LPCSTR lpcszSection, LPCSTR lpcszKey, LPCSTR lpcszValue);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:INIFile-SetFileName
	*/
	void	SetFileName(LPCSTR lpcszSection);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:INIFile-GetFileName
	*/
	string	GetFileName();
	
	/**# CP
	
	*/
	//void	SetUseIniPath(BOOL bOn = TRUE);
	
	/**# CP
	
	*/
	//BOOL	GetUseIniPath();
};

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:LPBYTE
*/
typedef byte* LPBYTE;
typedef uint* LPDWORD;
//
// Reserved Key Handles.
//
#define HKEY_CLASSES_ROOT           ( 0x80000000 )
#define HKEY_CURRENT_USER           ( 0x80000001 )
#define HKEY_LOCAL_MACHINE          ( 0x80000002 )
#define HKEY_USERS                  ( 0x80000003 )
#define HKEY_PERFORMANCE_DATA       ( 0x80000004 )
#define HKEY_CURRENT_CONFIG         ( 0x80000005 )
#define HKEY_DYN_DATA               ( 0x80000006 )

//
// Predefined Value Types.
//
#define REG_NONE                    ( 0 )   // No value type
#define REG_SZ                      ( 1 )   // Unicode nul terminated string
#define REG_EXPAND_SZ               ( 2 )   // Unicode nul terminated string
                                            // (with environment variable references)
#define REG_BINARY                  ( 3 )   // Free form binary
#define REG_DWORD                   ( 4 )   // 32-bit number
#define REG_DWORD_LITTLE_ENDIAN     ( 4 )   // 32-bit number (same as REG_DWORD)
#define REG_DWORD_BIG_ENDIAN        ( 5 )   // 32-bit number
#define REG_LINK                    ( 6 )   // Symbolic Link (unicode)
#define REG_MULTI_SZ                ( 7 )   // Multiple Unicode strings
#define REG_RESOURCE_LIST           ( 8 )   // Resource list in the resource map
#define REG_FULL_RESOURCE_DESCRIPTOR ( 9 )  // Resource list in the hardware description
#define REG_RESOURCE_REQUIREMENTS_LIST ( 10 )

/**+
http://ocwiki.originlab.com/index.php?title=Category:Registry_(class)
*/
class Registry
{
public:
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Registry-Registry
	*/
	///Sophy 4/2/2011 ORG-2568-P1 PROPER_ACCESS_REGISTRY_ON_WIN64_PLATFORM
	//Registry(DWORD hParentKey);
	Registry(DWORD hParentKey, DWORD dwCtrl = REGKEY_ACCESS_AUTO);
	///end PROPER_ACCESS_REGISTRY_ON_WIN64_PLATFORM

public:
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Registry-HasKey
	*/
	BOOL HasKey(LPCSTR lpSubKey);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Registry-DelValue
	*/
	BOOL DelValue(LPCSTR lpSubKey, LPCSTR lpValueName = NULL);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Registry-DelKey
	*/
	BOOL DelKey(LPCSTR lpSubKey);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Registry-GetValue
	*/
	BOOL GetValue(LPCSTR lpSubKey, LPCSTR lpValueName, DWORD &dwValue);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Registry-GetValue
	*/
	BOOL GetValue(LPCSTR lpSubKey, LPCSTR lpValueName, string &strValue);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Registry-GetValue
	*/
	BOOL GetValue(LPCSTR lpSubKey, LPCSTR lpValueName, LPBYTE lpData, LPDWORD lpcbData, LPDWORD lpType = NULL);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Registry-SetValue
	*/
	void SetValue(LPCSTR lpSubKey, LPCSTR lpValueName, LPCSTR lpValue);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Registry-SetValue
	*/
	void SetValue(LPCSTR lpSubKey, LPCSTR lpValueName, DWORD dwValue);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Registry-SetValue
	*/
	void SetValue(LPCSTR lpSubKey, LPCSTR lpValueName, LPBYTE lpData, DWORD dwType, DWORD dwcbData);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Registry-EnumKey
	*/
	int EnumKey(StringArray &keys, LPCSTR lpKey);
};


#define     KEY_OCDLGBAR		"OCDialogBars"
#endif // _SETTINGS_H
