/*------------------------------------------------------------------------------*
 * File Name: Selection.h														*
 * Creation: YuI 12/18/2002													    *
 * Purpose: Selection class														*
 * Copyright (c) OriginLab Corp.2001, 2002										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	RVD 1/23/2009 QA80-13011 PA_MARKER_ACTIVATION								*
 *	Kenny 02/20/2010 QA81-15133 OC_RETRIEVE_OBJECT_SELECTION_STATE				*
 *	Folger 01/12/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH	*
 *------------------------------------------------------------------------------*/
#ifndef	_SELECTION_H
#define _SELECTION_H

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Selection_(class)
*/
class Selection
{
public:	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Selection-Selection
	*/
	Selection();
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Selection-~Selection
	*/
	~Selection();
public:
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Selection-Reset
	*/
	void	Reset(BOOL bPost = FALSE);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Selection-Add
	*/
	BOOL	Add(OriginObject& obj);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Selection-Remove
	*/
	BOOL	Remove(OriginObject& obj);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Selection-Objects
	*/
	OriginObject	Objects(int nIndex = 0);
	

	/// RVD 1/23/2009 QA80-13011 PA_MARKER_ACTIVATION
	/**$
		Example: dm.oxf
	*/
	BOOL	SelectAnchorSetHandle(OriginObject& objParent, int nAnchorID, int nHandle=0);
	/// end PA_MARKER_ACTIVATION

	/// Kenny 02/20/2010 QA81-15133 OC_RETRIEVE_OBJECT_SELECTION_STATE
	// Comments last updated by Kenny on 02/20/2010
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Selection-IsSelected
	*/
	BOOL	IsSelected(OriginObject& obj);
	/// End QA81-15133 OC_RETRIEVE_OBJECT_SELECTION_STATE

	///------ Folger 01/12/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
	/**$
	*/
	int		GetHandle();
	///------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Selection-Objects
	*/
	Collection<OriginObject>	Objects;
};

#endif// _SELECTION_H
