/*------------------------------------------------------------------------------*
 * File Name: OperationBase.h													*
 * Creation: CPY 10/14/06													    *
 * Purpose: Origin C header	for Operation base class 							*
 * Copyright (c) OriginLab Corp.	2006										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	CPY 10/14/06 SEPARATE_OUT_OPERATION_BASE_INTO_SEPARATE_HEADER				*
 *	CPY 11/10/06 NLFIT_NEW_CODE_RUNTIME_ERR_ON_CANCEL_BUTTON					*
 *	ML 3/13/2007 QA70-9477 PROPER_OCOPERATION_CLEANUP_AFTER_EXEC				*
 *	ML 3/15/2007 PROPER_CALLING_TO_UPDATE_EXE_INFO								*
 *	Cheney 2007-6-19 ALWAYS_FIND_XY_FROM_CUMULATIVE_FIT_CURVE_IF_PEAK_FIT		*
 *	ML 9/4/2007 QA70-10332 OPERATION_STATUS_UPDATE_ON_CHANGE_PARAMS				*
 *	Folger 01/19/08 QA70-10929 ADD_LINK_LABTALK_TREE							*
 *	ML 1/25/2008 QA70-10929 CACHING_INFO_ABOUT_LINKED_OPERATION_TREE			*
 *	Sim 09-10-2008 NLFIT_LABTALK_TREE_ACCESS									*
 *	YuI 12/15/08 QA70-12780 PROGRAMMATIC_SILENT_CHANGE_PARAM_FOR_OPERATION		*
 *	Folger 07/31/09 QA80-13998 DESTROY_OPERATION_AND_ALL_RELATED_OUTPUTS		*
 *	Hong 12/24/09 QA80-14832 NLFIT_OPEN_BY_HOTKEY_SOPPORT_APPLY_SETTING_FROM_QUICKFIT_WITHOUT_ANY_THEME
 *	Folger 12/28/09 QA81-14630 GENERATE_SCRIPT_FOR_XF_OEPRATION					*
 *	Sim 12-30-2009 QA81-14898 SHOW_GUI_SETTINGS_FOR_XFWIZ_OPERATION				*
 *	Sophy 1/11/2010 SUPPORT_OPEN_NLFIT_FROM_QUICKFIT_CONTEXT_MENU				*
 *	Folger 02/25/10 QA81-15106-P2 OP_CHANGE_SUPPORT_CHANGE_OPERATION_MODE		*
 *	Kit 01/10/2010 ORG-1532	CREATE_NEW_MULTI_PEAK_FIT_XF						*
 *	Folger 04/28/2011 ORG-2240-S1 REMOVE_FIT_RESULT_TABLE_ON_GRAPH_AFTER_DELETE_ANALYSIS
 *	Folger 05/17/2011 ORG-2881-P1 TOO_SLOW_WHEN_SET_RECALCULATE_TO_NONE			*
 *	Folger 06/01/2011 ORG-2858 SUPPORT_DUPLICATE_ANALYSIS_OPERATION				*
 *	Folger 08/24/2011 ORG-3609-P1 RECALCULATE_FAILED_TO_TRIGGERED_IF_INPUT_CHNAGED_BY_XF_OUTPUT_AS_INPUT
 *	Kyle 09/05/2011 ORG-3676-P1 XF_OUTPUT_ALLOW_SUB_OPERATION					*
 *	Folger 01/29/2012 ORG-4914-P1 SUPPORT_ONLY_ONE_DATALOCK_ON_GRAPHPAGE_FOR_EACH_OPERATION
 *	Folger 05/15/2012 ORG-5661-P1 OGW_WITH_OPERATIONS_BECAME_TOO_LARGE_EVEN_CLEAR_INPUT_DATA
 *	Zech 08/22/2012 ORG-5703-P1 OPERATION_SUPPORT_IGNORE_HIDDEN_ROW				*
 *	Folger 08/24/2012 ORG-6311-P1 UPDATE_DATASET_INDENTIFIER_FOR_FLAT_SHEET_FROM_CONTEXT_MENU
 *------------------------------------------------------------------------------*/
#ifndef _OPERATION_BASE_H
#define _OPERATION_BASE_H

enum {GUI_OP_TRY, GUI_OP_NEW, GUI_OP_CHANGE_PARAMS, GUI_OP_NEW_NO_EDIT};

class	OperationBase : public OriginObject
{
public:
	/**
	*/
	virtual void	GetTree(TreeNode& tr);

	/**
	*/
	virtual void	SetTree(TreeNode& tr);

	/**
	*/
	BOOL			Run();
	
	/**
	*/
	void			SetModified(DWORD dwChangeBits = OAM_FORMULA);
	
	//------ Folger 01/19/08 QA70-10929 ADD_LINK_LABTALK_TREE
	// last update by Sim, ///---Sim 09-28-2008 FIX_OP_DESTROY_INTERNAL_CAUSE_OC_RUN_TIME_ERROR
	/**
	Parameters:
		lpcszName = [input] name of labtalk tree, NULL means release linker
	Remarks:
		Once attach tree linker for operation, must forcibly release tree linker before destory operation
	Return:
		Returns 0 if success.
	*/
	int				LinkLabTalkTree(LPCSTR lpcszName, DWORD dwOption = 0);
	//------

	/// ML 1/25/2008 QA70-10929 CACHING_INFO_ABOUT_LINKED_OPERATION_TREE
	/**$
	*/
	void			ResetLinkedOperationTreeInfo();
	/// end CACHING_INFO_ABOUT_LINKED_OPERATION_TREE

	
	/**
	*/
	void			GetCreationInfo(double& dTime, string& strUserName, string& strCompanyName);
	
	/**
	*/
	void			GetExecutionInfo(double& dTime, string& strUserName, string& strCompanyName, DWORD& dwDuration = NULL);
	
	/**
	Parameters:
		szUser: execute user name
		szCompany: excute company name	
		dTime: execute time
		dwDuration: execute time
		nState: can be 	OPERSTATE_VALID_CLEAN, OPERSTATE_VALID_DIRTY, OPERSTATE_INVALID;
		nRecalcMode: 	AU_NONE, AU_AUTO, AU_ON_COMMAND;

	*/
	BOOL			GetInfo(OPERATIONINFO *pstInfo);
	/**
		Get inputs data range string
	Parameters:
		lpcszSep: can be like "\r\n"
	*/
	void			GetInputsInfo(string& strInputs, LPCSTR lpcszSep = NULL, LPCSTR lpcszPref = NULL, int nMaxLines = 0, DWORD dwOption = 0); 
	/**
		Get outpus data range string
	Parameters:
		lpcszSep: can be like "\r\n"
	*/
	void			GetOutputsInfo(string& strOutputs, LPCSTR lpcszSep = NULL, LPCSTR lpcszPref = NULL, int nMaxLines = 0, DWORD dwOption = 0); 
	/**
		Get operation name.
	*/
	string			GetName();

	/**
	*/
	virtual string	GetDescription(int nOptions);
	/**
	*/
	virtual string	GetClassName();
	/**
	*/
	virtual string	GetInputDisplay(bool bLongForm = true);

	/// ML 7/10/2006 QA70-8768 KEEPING_TRACK_OF_GRAPHS_CREATED_FROM_OPERATION
	/**$
		It sets an ID-UID pair into an internal map, where ID, made up of dwIDType and dwIDValue, serves as a key to the map.
		The enumaration OPERIDTOUIDTYPE_ should be used for dwIDType.
	*/
	void			SetIdUIDtoMap(DWORD dwIDType, DWORD dwIDValue, DWORD uid);

	/**$
		It retrives a UID given an ID, from the internal map (the value was set using SetIdUIDtoMap()).
	*/
	BOOL			GetUIDFromIdMap(DWORD dwIDType, DWORD dwIDValue, DWORD &uid);


	/// ML 7/12/2006 REPORT_DATA_WITH_XF_WORKSHEET_GRAPHS_HANDLING
	/**$
		It retrives the whole ID-to_UID map as one flat array of triplets: dwIDType, dwIDValue, uid.  
	*/
	BOOL			GetIdsToUIDsMap(vector<uint> &vMap);

	/**$
		It sets the ID-to_UID map from one flat array of triplets: dwIDType, dwIDValue, uid. 
	*/
	BOOL			SetIdsToUIDsMap(vector<uint> &vMap, BOOL bAppend = FALSE);
	/// end REPORT_DATA_WITH_XF_WORKSHEET_GRAPHS_HANDLING

	/// end KEEPING_TRACK_OF_GRAPHS_CREATED_FROM_OPERATION

	/// ML 3/13/2007 QA70-9477 PROPER_OCOPERATION_CLEANUP_AFTER_EXEC
	BOOL			Detach();
	/// end PROPER_OCOPERATION_CLEANUP_AFTER_EXEC
	
	///Kyle 09/05/2011 ORG-3676-P1 XF_OUTPUT_ALLOW_SUB_OPERATION
	BOOL			SetOutputSubOperation(LPCSTR lpcszOutputs);
	///End XF_OUTPUT_ALLOW_SUB_OPERATION

	
	/**
		given vector of X, compute all the Ys
	Parameters:
		vx = [in] vector to provide x values for finding corresponding y values
		vy = [out] vector to receive y values from the fit curve, calculated by the Operation class
		nOuputIndex = index returned from GetIncomingOperation to identify a particular analysis in the collection inside the operation. 
		If the operation has only one input dataset and produce only one fit, then this value should be 0, but if the operation involves multiple dataset and thus producing multiple fit curves, 
		then this value will represent the index of each of these fits.
	Return:
		true for success
	Example:
		// this code print the Y fit curve values from all the fits in the layer
		// for the given x
		#include <operation.h> // this file may not be included by origin.h
		void y_from_x_all_fits(double x)
		{
			GraphLayer gl = Project.ActiveLayer();
			if(gl)
			{
				printf("Operation\tIndex\tDescription\tFit Y[0]\n");
				foreach(DataPlot dp in gl.DataPlots)
				{
					int nIndex;
					double y1 = -500;// just some value to show not found, could have used NANUM
					OperationBase& op = dp.GetIncomingOperation(false, nIndex);
					if(op)
					{
						string strClassName = op.GetClassName();
						vector vx, vy;
						vx.Data(1,10); vx[0] = x;
						vy.SetSize(10);
						if(op.GetYFromX(vx, vy, nIndex))
						{
							y1 = vy[0];
						}
						printf("%s\t%d\t%s\t%f\n", strClassName, nIndex, op.GetDescription(1), y1); 
					}
				}
			}
		}
	See Also
		GetIncomingOperation, GetXFromY, GetFitCurve	
	*/
	///Echo 4/8/05 MR_NEEDED
	//virtual bool GetYFromX(const vector& vx, vector& vy, int nOuputIndex = 0, TreeNode& trOp = NULL);
	///Cheney 2007-6-19 ALWAYS_FIND_XY_FROM_CUMULATIVE_FIT_CURVE_IF_PEAK_FIT
	//virtual bool GetYFromX(const vector& vx, vector& vy, int nOuputIndex = 0, TreeNode& trOp = NULL, const matrix& mXs = NULL);
	virtual bool GetYFromX(const vector& vx, vector& vy, int nOuputIndex = 0, TreeNode& trOp = NULL, const matrix& mXs = NULL, int nPeaks = 1, vector& vParams = NULL);
	///end ALWAYS_FIND_XY_FROM_CUMULATIVE_FIT_CURVE_IF_PEAK_FIT
	/**
		this will allow some class to directly inverse the function to get X from Y
	Parameters:
		vx = [out] vector to receive x values from the fit curve, calculated by the Operation class if supported
		vy = [int] vector to provide y values for finding corresponding x values
		nOuputIndex = index returned from GetIncomingOperation to identify a particular analysis in the collection inside the operation. 
		If the operation has only one input dataset and produce only one fit, then this value should be 0, but if the operation involves multiple dataset and thus producing multiple fit curves, 
		then this value will represent the index of each of these fits.
	Return:
		true for success
	Example:
		// this code print the X fit curve values from all the fits in the layer
		// for the given Y
		// Try a graph with one LR fit and a Polynomial fit, only LR fit supports x from y
		#include <operation.h> // this file may not be included by origin.h
		void x_from_y_all_fits(double y)
		{
			GraphLayer gl = Project.ActiveLayer();
			if(gl)
			{
				printf("Operation\tIndex\tDescription\tFit X\n");
				foreach(DataPlot dp in gl.DataPlots)
				{
					int nIndexInOp;
					OperationBase& op = dp.GetIncomingOperation(false, nIndexInOp);
					if(op)
					{
						string strClassName = op.GetClassName();
						vector vx, vy;
						vy.Data(1,10); vy[0] = y;
						vx.SetSize(10);
						if(op.GetXFromY(vx, vy, nIndexInOp))
							printf("%s\t%d\t%s\t%f\n", strClassName, nIndexInOp, op.GetDescription(1), vx[0]);
						else
							printf("%s\t%d\t%s\tNot Supported\n", strClassName, nIndexInOp, op.GetDescription(1)); 
					}
				}
			}
		}

	See Also:
		GetIncomingOperation, GetYFromX, GetFitCurve	
	*/
	virtual bool GetXFromY(vector& vx, const vector& vy, int nOuputIndex = 0, TreeNode& trOp = NULL);
	
	/// ML 7/20/2006 QA70-4434 CUSTOM_TABLES_FOR_FIND_XY
	/**$
	*/
	virtual	bool	GetXFromYorYFromX(bool bXfromY, DataRange &src, DataRange &dest, int nID);
	/// end CUSTOM_TABLES_FOR_FIND_XY
	
	/// Iris 8/09/06 FIND_XY_FOR_PR
	/**$
	*/
	virtual bool GetXFromY(matrix& mx, const vector& vy, int nOuputIndex = 0, TreeNode& trOp = NULL);
	/// end FIND_XY_FOR_PR

	
	/**
		Get the generated fit curve during operation update
		this will allow caller to do interpolation if Operation are not able to provide GetYfromX etc.
	Parameters:
		vx = vector to receive x values of the fit curve
		vy = vector to receive y values of the fit curve
		nOuputIndex = index returned from GetIncomingOperation to identify a particular analysis in the collection inside the operation. 
		If the operation has only one input dataset and produce only one fit, then this value should be 0, but if the operation involves multiple dataset and thus producing multiple fit curves, 
		then this value will represent the index of each of these fits.
	See Also:
		GetIncomingOperation, GetYFromX, GetXFromY	
	*/
	///Joseph 09/27/06 FINDXY_TO_SEPERATE_SHEET
	//virtual bool GetFitCurve(vector& vx, vector& vy, int nOuputIndex = 0); 
	///Cheney 2007-6-19 ALWAYS_FIND_XY_FROM_CUMULATIVE_FIT_CURVE_IF_PEAK_FIT
	//virtual bool GetFitCurve(TreeNode& trOp, vector& vx, vector& vy, int nOuputIndex = 0);  
	virtual bool GetFitCurve(TreeNode& trOp, vector& vx, vector& vy, int& nPeaks, int nIndex = 0);  
	///end ALWAYS_FIND_XY_FROM_CUMULATIVE_FIT_CURVE_IF_PEAK_FIT
	///End FINDXY_TO_SEPERATE_SHEET  	

//-------------- CPY 8/10/04 QA70-6784 v8.0115 GET_INCOMING_OPERATION_CHANGE
// followings are no longer used
#ifdef OLD_OPERATION_METHODS
	void			SetShowPageInfoHeader(int nPosition = DBAR_TOP);
	BOOL			SetCurveInput(curvebase& cb, int nIndex = 0);
	curvebase&		GetCurveInput(int nIndex = 0);
	virtual	BOOL	UpdateHeaderInfo(); 
	virtual	BOOL	EditReportingSettings(HWND hWndPage);
	virtual BOOL	InitReportingSettings(TreeNode& tr);
	BOOL			GetDefault(TreeNode& tr = NULL, int nOption = -1, int nSearchOption = OPATH_INI_THEN_EXE);
	virtual int		GetResultInidicator();
#endif //OLD_OPERATION_METHODS
//-------------- end CPY 8/10/04 QA70-6784 v8.0115 GET_INCOMING_OPERATION_CHANGE

	/**
	*/
	void			SetAutoUpdateMode(int nMode);
	
	/**
	*/
	int				GetAutoUpdateMode();
	
	
	//virtual string	GetDescription(TreeNode& trOP = NULL);

	/**
	*/
	void			ResetAuxArray(UINT nAuxType);

	/**
	*/
	int				AddAuxObject(UINT nAuxType, OriginObject& obj);

	/**
	*/
	int				GetCountAuxObjects(UINT nAuxType);

	/**
	*/
	BOOL			GetAuxObject(UINT nAuxType, int nIndex, OriginObject& obj);
	///////////////////////////////////////////////////////
	// virtual overrides
public:
	/**
	*/
	virtual	BOOL	Execute(int nExeMode = OEXEM_ON_CREATE, DWORD dwExecCntrl = 0);	//CPY 2/24/08 SPFW_NEED_BETTER_OP_EXEC_CNTRL, added dwExecCntrl

public:
	/// ML 9/4/2007 QA70-10332 OPERATION_STATUS_UPDATE_ON_CHANGE_PARAMS
	//virtual BOOL	ChangeParam();
	virtual int		ChangeParam();
	/// end OPERATION_STATUS_UPDATE_ON_CHANGE_PARAMS
	
	/// YuI 12/15/08 QA70-12780 PROGRAMMATIC_SILENT_CHANGE_PARAM_FOR_OPERATION
	/**
		Changes operation param without dialog invocation
	Parameters:
		pvDataIDs = [input] vector of DataID's
		pvValues = [input] vector of new values
		bExecute = [input] if TRUE operation will execute, if FALSE - execution will happen by general recalculate mechanism

	Return:
		Returns 0 if success.
	*/
	virtual int		ChangeParam(const vector<int>* pvDataIDs, const vector<string>* pvValues, BOOL bExecute = TRUE);
	
	/**
		Changes operation param without dialog invocation based on XVariable name
	Parameters:
		pvVarNames = [input] vector of names of variables to be modified
		pvValues = [input] vector of new values
		bExecute = [input] if TRUE operation will execute, if FALSE - execution will happen by general recalculate mechanism
	Remarks:
		Applicable to XFunction based operations only
	Return:
		Returns 0 if success.
	*/
	virtual int		ChangeParamByVarName(const vector<string>* pvVarNames, const vector<string>* pvValues, BOOL bExecute = TRUE);
	/// end PROGRAMMATIC_SILENT_CHANGE_PARAM_FOR_OPERATION
	
	/// Hong 12/24/09 QA80-14832 NLFIT_OPEN_BY_HOTKEY_SOPPORT_APPLY_SETTING_FROM_QUICKFIT_WITHOUT_ANY_THEME
	//virtual BOOL	OperationtoGUI(TreeNode& trOperation, bool bInit, string* pstrSelectedTheme = NULL, bool bSetDefaultInputOnInit = true);
	///Sophy 1/11/2010 SUPPORT_OPEN_NLFIT_FROM_QUICKFIT_CONTEXT_MENU
	//virtual BOOL	OperationtoGUI(TreeNode& trOperation, bool bInit, string* pstrSelectedTheme = NULL, bool bSetDefaultInputOnInit = true, bool bFromHotkey = false);
	virtual BOOL	OperationtoGUI(TreeNode& trOperation, bool bInit, string* pstrSelectedTheme = NULL, bool bSetDefaultInputOnInit = true, DWORD dwExeCtrl = 0, ODWP dwParam = 0);
	///end SUPPORT_OPEN_NLFIT_FROM_QUICKFIT_CONTEXT_MENU
	/// end NLFIT_OPEN_BY_HOTKEY_SOPPORT_APPLY_SETTING_FROM_QUICKFIT_WITHOUT_ANY_THEME
	
	
	/**
	*/
	/// Hong 12/24/09 QA80-14832 NLFIT_OPEN_BY_HOTKEY_SOPPORT_APPLY_SETTING_FROM_QUICKFIT_WITHOUT_ANY_THEME
	//virtual bool	Edit(bool bChangeParams, int& nAutoUpdate, LPCSTR lpcszTheme, bool bInitFromSel = true);
	///Sophy 1/11/2010 SUPPORT_OPEN_NLFIT_FROM_QUICKFIT_CONTEXT_MENU
	//virtual bool	Edit(bool bChangeParams, int& nAutoUpdate, LPCSTR lpcszTheme, bool bInitFromSel = true, bool bFromHotkey = false);
	virtual bool	Edit(bool bChangeParams, int& nAutoUpdate, LPCSTR lpcszTheme, bool bInitFromSel = true, DWORD dwExeCtrl = 0, ODWP dwParam = 0);
	///end SUPPORT_OPEN_NLFIT_FROM_QUICKFIT_CONTEXT_MENU
	/// end NLFIT_OPEN_BY_HOTKEY_SOPPORT_APPLY_SETTING_FROM_QUICKFIT_WITHOUT_ANY_THEME
	
	/**
	*/
	virtual	BOOL	Init(int nOption = 0);

	
	/**
	*/
	virtual	BOOL	Init(const TreeNode &tr);

	//---- CPY 07/24/06 QA70-8847 COLUMN_FORMULA_FROM_ORIGIN_C_REVAMP
	//virtual void	OnNoEdit(int nOption, bool& bAutoUpdate, LPCSTR lpcszTheme, bool bSetDefaultInput = false, DWORD dwAuxData = 0); // if no GUI open and proceed directly to execute
	//-------- CPY 5/18/2007 QA70-9795 MENU_FROM_THEME_TO_OPEN_DIALOG
	//virtual void	OnNoEdit(int nOption, int& nAutoUpdate, LPCSTR lpcszTheme, bool bSetDefaultInput = false, DWORD dwAuxData = 0);
	///-----Kit 01/10/2010 ORG-1532	CREATE_NEW_MULTI_PEAK_FIT_XF
	//virtual bool	OnNoEdit(int nOption, int& nAutoUpdate, LPCSTR lpcszTheme, bool bSetDefaultInput = false, DWORD dwAuxData = 0);
	virtual bool	OnNoEdit(int nOption, int& nAutoUpdate, LPCSTR lpcszTheme, bool bSetDefaultInput = false, DWORD dwAuxData = 0, ODWP dwParam = 0 );
	///-----End CREATE_NEW_MULTI_PEAK_FIT_XF
	////----
	/**
	*/
	//virtual	BOOL	EditResultContents(HWND hWndPage);

	/**
	*/
	virtual BOOL	GUItoOperation(TreeNode& trOperation, int nFrom = GUI_OP_NEW); 
	
	/**
	*/
	void			CreateInternal();
	
	/**
	*/
	//----CPY 11/10/06 NLFIT_NEW_CODE_RUNTIME_ERR_ON_CANCEL_BUTTON
	//void			DestroyInternal();
	///------ Folger 07/31/09 QA80-13998 DESTROY_OPERATION_AND_ALL_RELATED_OUTPUTS
	//virtual void	DestroyInternal();
	virtual void	DestroyInternal(BOOL bDeleteOutputs = FALSE);
	///------ End DESTROY_OPERATION_AND_ALL_RELATED_OUTPUTS
	virtual BOOL	OnKeepOpAfterExecute();
	//----
	//----- CPY 2/6/06 MULTI_DATA_INDEPENDENT_VS_CONSOLIDATED_REPORT
	virtual	DWORD	GetDataRules(const TreeNode& trOperation, bool bIgnoreCombineInfo = false);
	//-----
	/// Zech 08/22/2012 ORG-5703-P1 OPERATION_SUPPORT_IGNORE_HIDDEN_ROW
	virtual DWORD	GetDataRules2(const TreeNode& trOperation);
	/// END OPERATION_SUPPORT_IGNORE_HIDDEN_ROW
protected:
	/**
	*/
	virtual BOOL	Construct(TreeNode& tr, int nOption = 0);

	/**
	*/
	//virtual void	OnSetTree(TreeNode& tr);

	/**
	*/
	virtual void	OnGetTree(TreeNode& tr);

	/**
	*/
	//virtual BOOL	PrepareOutput(Worksheet& wks, TreeNode& tr, LPCSTR lpcszDefaultName, bool& bNewBookCreated);
	
	/**
	*/
	//virtual BOOL	PrepareOutput(Column& col, TreeNode& tr);
		
	/**
	*/
	//virtual	DataObject	GetOutput(LPCSTR lpcszName);

	/**
	*/
	BOOL			RemoveOutput(OriginObject& obj, BOOL bTrim = TRUE);
	
	/**
	*/
	BOOL			RemoveInput(OriginObject& obj, BOOL bTrim = TRUE);

	/**
	*/
	void			ClearAllOutputUse();
	
	/**
	*/
	void			RemoveAllUnusedOutput(BOOL bTrim = TRUE);
	
	/**
	*/
	BOOL			SetUseOutput(OriginObject& obj, BOOL bSet = TRUE);
	
	/**
	*/
	BOOL			IsOutputUsed(OriginObject& obj);
	
	/// YuI 11/12/08 ADDITIONAL_CLEANUP_FOR_EXECUTE_ON_CHANGE_PARAM
	//	virtual BOOL	OnBeforeExecute();
	// virtual BOOL	OnAfterExecute();
	
	/**
	*/
	virtual BOOL	OnBeforeExecute(int nExeMode);
	
	/**
	*/
	virtual BOOL	OnAfterExecute(int nExeMode);
	/// end ADDITIONAL_CLEANUP_FOR_EXECUTE_ON_CHANGE_PARAM	
	/// ML 3/15/2007 PROPER_CALLING_TO_UPDATE_EXE_INFO
	/**$
	*/
	BOOL			UpdateExecutionInfo();
	/// end PROPER_CALLING_TO_UPDATE_EXE_INFO
	
	
	/// YuI 10/12/07 QA70-10529 DATA_MARKERS_REVAMP
	/**$
	*/
	BOOL		CreateInputDataMarkers();
	
	/**$
	*/
	BOOL		DestroyInputDataMarkers();
	/// end DATA_MARKERS_REVAMP
	
	/**
	*/
	virtual	void	OnWksHeaderTableChange(UINT wParam, HWND hWnd);

	/**
	*/
	virtual	BOOL	OnBeforeClose(BOOL bSysCommand, BOOL bAskUser, BOOL& bDelete);
	
	///---Sim 09-10-2008 NLFIT_LABTALK_TREE_ACCESS
	virtual	BOOL	LabTalkTreeAccess(LPSTR lpVar, LPSTR lpArg, LPVOID lpValue, WORD msg);
	virtual	BOOL	MakeLabTalkTree(TreeNode& trLT);
	///---END NLFIT_LABTALK_TREE_ACCESS
	
	///---Sim 12-30-2009 QA81-14898 SHOW_GUI_SETTINGS_FOR_XFWIZ_OPERATION
	virtual void	ShowDialogSettings();
	///---END QA81-14898 SHOW_GUI_SETTINGS_FOR_XFWIZ_OPERATION
protected:
	/**
	*/
	///------ Folger 08/24/2011 ORG-3609-P1 RECALCULATE_FAILED_TO_TRIGGERED_IF_INPUT_CHNAGED_BY_XF_OUTPUT_AS_INPUT
	//int				SetInput(OriginObject& obj, int nIndex = -1);
	int				SetInput(OriginObject& obj, int nIndex = -1, DWORD dwCntrl = 0);
	///------ End RECALCULATE_FAILED_TO_TRIGGERED_IF_INPUT_CHNAGED_BY_XF_OUTPUT_AS_INPUT
	
	/**
	*/
	BOOL			GetInput(OriginObject& obj, int nIndex = 0);

	/**
	*/
	int				SetInput(TreeNode& tree, int nIndex);

	/**
	*/
	int				GetInput(TreeNode& tree, int nIndex);

	/**
	*/
	int				SetOutput(OriginObject& obj, int nIndex = -1);
	
	/**
	*/
	BOOL			GetOutput(OriginObject& obj, int nIndex = 0);
	
	/**
	*/
	int				GetOutputCount();

	/**
	*/
	int				SetReportTreeToResultsLog(TreeNode &tr);
	
	/**
			It converts escaped cell strings.
		Parameters:
			str=the string to convert.
		Returns:
			TRUE if converted, FALSE if left unchanged.
	*/
	BOOL			ConvertEscapedString(string &str);

	/**
			It converts escaped strings found in values and labels in the tree.
		Parameters:
			tr=the tree to convert.
		Returns:
			the total number of converted strings.
	*/
	int				ConvertEscapedStrings(TreeNode &tr);

	/// ML 11/1/2005 QA70-8254 INVOKING_OPERATION_FROM_XFUNCTION
	/**$
	*/
	virtual	BOOL	SetInfoFromXF(int nOption, LPCSTR lpcszClass, StringArray &saOptions, StringArray &saNames, LPCSTR lpcszStr2 = NULL);			
	/// end INVOKING_OPERATION_FROM_XFUNCTION


	/// ML 2/14/2007 QA70-9374 BAD_EVENT_HANDLER_DWORDS_IN_TREENODES
	BOOL			m_bDisableSetTree;
	/// end BAD_EVENT_HANDLER_DWORDS_IN_TREENODES

	///------ Folger 02/25/10 QA81-15106-P2 OP_CHANGE_SUPPORT_CHANGE_OPERATION_MODE
	/**
		It will delete "this" ! Same result as select "Recalculate Mode : None".
	*/
	BOOL			SetAsNone(BOOL bUndo = FALSE);
	///------ End OP_CHANGE_SUPPORT_CHANGE_OPERATION_MODE

	///------ Folger 04/28/2011 ORG-2240-S1 REMOVE_FIT_RESULT_TABLE_ON_GRAPH_AFTER_DELETE_ANALYSIS
	/**#
	*/
	virtual	void	OnDestroy(BOOL bDeleteOutputs);
	///------ End REMOVE_FIT_RESULT_TABLE_ON_GRAPH_AFTER_DELETE_ANALYSIS

	///------ Folger 05/17/2011 ORG-2881-P1 TOO_SLOW_WHEN_SET_RECALCULATE_TO_NONE
	/**$
		Enumerated as CONVERT_ESCAPED_STR_FOR_FLAT_SHEET
	*/
	void			SetConvertEscapeStrForFlatSheet(DWORD dw);
	///------ End TOO_SLOW_WHEN_SET_RECALCULATE_TO_NONE

	///------ Folger 06/01/2011 ORG-2858 SUPPORT_DUPLICATE_ANALYSIS_OPERATION
	/**$
	*/
	virtual	BOOL IsAllowDuplicateAnalysis();
	/**$
	*/
	virtual	BOOL DuplicateAnalysis(BOOL bDialog);
	///------ End SUPPORT_DUPLICATE_ANALYSIS_OPERATION

	///------ Folger 01/29/2012 ORG-4914-P1 SUPPORT_ONLY_ONE_DATALOCK_ON_GRAPHPAGE_FOR_EACH_OPERATION
	/**$
	*/
	void			SetOnlyShowOneDataLockOnGraph(BOOL bOn);
	///------ End SUPPORT_ONLY_ONE_DATALOCK_ON_GRAPHPAGE_FOR_EACH_OPERATION

	///------ Folger 05/15/2012 ORG-5661-P1 OGW_WITH_OPERATIONS_BECAME_TOO_LARGE_EVEN_CLEAR_INPUT_DATA
	/**$
	*/
	virtual void	OnClearOperationData();
	///------ End OGW_WITH_OPERATIONS_BECAME_TOO_LARGE_EVEN_CLEAR_INPUT_DATA

private:
	/**
	Customizable settings of operation.
	This member may be initialized when Operation is created and used
	during Operation execution
	*/
	Tree			Settings;
};

///------ Folger 08/24/2012 ORG-6311-P1 UPDATE_DATASET_INDENTIFIER_FOR_FLAT_SHEET_FROM_CONTEXT_MENU
class OperationAccessToken
{
public:
	OperationAccessToken(OperationBase* pOperation);
};
///------ End UPDATE_DATASET_INDENTIFIER_FOR_FLAT_SHEET_FROM_CONTEXT_MENU

/**#
*/
typedef bool (* P_SHOW_OP_INFO)(OperationBase& op, HWND hWndOutput);

typedef bool (*P_REPORT_SETTINGS_DLG)(TreeNode& trReport, HWND hWndParent);

void op_destroy_on_cancel(OperationBase& op, bool bRestoreInputDataRange = true); 
OperationBase& op_create(LPCSTR lpcszClassName, bool& bInit, int nOption = 0, LPCSTR lpcszFilename = NULL);

#define STR_OP_XF_NODE "xf"
#define STR_OP_XF_EXTERNAL_NODE "xfName"

///------ Folger 12/28/09 QA81-14630 GENERATE_SCRIPT_FOR_XF_OEPRATION
///// ML 7/19/2006 REMEMBERING_SETTINGS_IN_XFOPERATION_FOR_AUTO_UPDATE
//#define STR_OP_XF_GETN_NODE "xfGetN"
///// end REMEMBERING_SETTINGS_IN_XFOPERATION_FOR_AUTO_UPDATE
///------ End GENERATE_SCRIPT_FOR_XF_OEPRATION

#pragma dll(@OK)
BOOL	do_command(LPCSTR lpcszClassname, BOOL bOpenGUI, LPCSTR lpcszFilename = NULL, int nOption = 0);
BOOL	do_run_operation(TreeNode* pTree, BOOL bCacheTree);





#endif //_OPERATION_BASE_H
