/*------------------------------------------------------------------------------*
 *	File Name: 	OCLT.h									 						*
 *	Purpose:	the functions to be accessible under the same name				*
 *				from LT and OC.													*
 *	Author:		ML, 9/20/2004													*
 *  	Copyright Originlab Corp. 2004 - 2010									*
 *																				*
 *	Modification log:															*
 *  Forest	10/09/04	QA70-6799	ADD_NAG_SPECIAL_FUNCTIONS					*
 *	Arvin 06/28/07 QA70-9982 SET_COL_VALUE_FUNCTION_LIST_SUPPORT_FOR_OC_FUNCTIONS
 *	Kyle 12/30/2008 v8.0992 OKUTIL_FIND_LT_FUNCTIONS_ADD_MATRIX_AS_RETURN_TYPE	*
 *	Folger 08/17/2011 ORG-3564-P1 FAILED_TO_SHOW_LT_FUNCTION_RETURN_COMPLEX_IN_SCV
 *------------------------------------------------------------------------------*/


#ifndef		__OCLT_H__
#define		__OCLT_H__
//////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////

#ifdef _MSC_VER	   //VC
	#ifdef OCMATH_EXPORTS
		#define OCMATHLT_API __declspec(dllexport)
	/// TD 06-19-2008 QA80-10844 TRICTR_IN_VIEWER
	#elif  defined(MIN_OK_VERSION)
		#define OCMATHLT_API
	/// end QA80-10844 TRICTR_IN_VIEWER
	#else
		#define OCMATHLT_API __declspec(dllimport)
	#endif

	OCMATHLT_API	int PASCAL ocmath_LT_functions_get_list(CStringArray* psaNames, CStringArray* psaArgs, int nCategory);//CPY 4/14/08 moved here ----- HONG 4/14/06

#ifdef __cplusplus
	extern "C" {
#endif
#else //_MSC_VER
	#define OCMATHLT_API
	#pragma dll(ocMath)	
#endif	//!_MSC_VER


OCMATHLT_API	double	ADummyFunction(double arg);

OCMATHLT_API	double	AnotherDummyFunction(double arg, double arg2, double arg3, double arg4, double arg5);


///Forest	10/09/04	QA70-6799	ADD_NAG_SPECIAL_FUNCTIONS
/**@ >Math Functions>Special Functions */

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:real_polygamma_(global_function)
*/
OCMATHLT_API	double real_polygamma(double x, int k);
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:exp_integral_(global_function)
*/
OCMATHLT_API	double exp_integral(double x);
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:cos_integral_(global_function)
*/
OCMATHLT_API	double cos_integral(double x);
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:sin_integral_(global_function)
*/
OCMATHLT_API	double sin_integral(double x);
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:gamma_(global_function)
*/
OCMATHLT_API	double gamma(double x);
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:log_gamma_(global_function)
*/
OCMATHLT_API	double log_gamma(double x);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:incomplete_gamma_(global_function)
*/
OCMATHLT_API	double incomplete_gamma(double a, double x);

// Category last updated by Iris on 07/23/2008
/**@ >Statistics>Distribution Functions*/

//----CPY 2/21/2008 v8.0808 QA70-6197 ERFC_IN_OC_MOVE_ERF_TO_USE_OCMATH
//OCMATHLT_API	double Erf(double x);
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:erf_(global_function)
*/
OCMATHLT_API	double erf(double x);
//---

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:erfcx_(global_function)
*/
OCMATHLT_API	double erfcx(double x);

/// Iris 3/14/2008 v8.0824 QA70-6197 SUPPORT_ERFINV_AND_ERFCINV_IN_LT_AND_OC

//  Category last updated by Jack 2008-7-18
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:erfcinv_(global_function)
*/
OCMATHLT_API double	erfcinv(double dy);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:erfinv_(global_function)
*/
OCMATHLT_API double	erfinv(double dy);
///end SUPPORT_ERFINV_AND_ERFCINV_IN_LT_AND_OC

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:cumul_normal_(global_function)
*/
OCMATHLT_API	double cumul_normal(double x);
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:cumul_normal_complem_(global_function)
*/
OCMATHLT_API	double cumul_normal_complem(double x);
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:erfc_(global_function)
*/
OCMATHLT_API	double erfc(double x);


//  Category last updated by Jack 2008-7-18

/**@ >Math Functions>Special Functions */

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:bessel_y0_(global_function)
*/
OCMATHLT_API	double bessel_y0(double x);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:bessel_y1_(global_function)
*/
OCMATHLT_API	double bessel_y1(double x);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:bessel_j0_(global_function)
*/
OCMATHLT_API	double bessel_j0(double x);
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:bessel_j1_(global_function)
*/
OCMATHLT_API	double bessel_j1(double x);
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:airy_ai_(global_function)
*/
OCMATHLT_API	double airy_ai(double x);
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:airy_bi_(global_function)
*/
OCMATHLT_API	double airy_bi(double x);
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:airy_ai_deriv_(global_function)
*/
OCMATHLT_API	double airy_ai_deriv(double x);
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:airy_bi_deriv_(global_function)
*/
OCMATHLT_API	double airy_bi_deriv(double x);
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:bessel_k0_(global_function)
*/
OCMATHLT_API	double bessel_k0(double x);
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:bessel_k1_(global_function)
*/
OCMATHLT_API	double bessel_k1(double x);
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:bessel_i0_(global_function)
*/
OCMATHLT_API	double bessel_i0(double x);
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:bessel_i1_(global_function)
*/
OCMATHLT_API	double bessel_i1(double x);
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:bessel_k0_scaled_(global_function)
*/
OCMATHLT_API	double bessel_k0_scaled(double x);
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:bessel_k1_scaled_(global_function)
*/
OCMATHLT_API	double bessel_k1_scaled(double x);
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:bessel_i0_scaled_(global_function)
*/
OCMATHLT_API	double bessel_i0_scaled(double x);
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:bessel_i1_scaled_(global_function)
*/
OCMATHLT_API	double bessel_i1_scaled(double x);
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:bessel_i_nu_scaled_(global_function)
*/
OCMATHLT_API	double bessel_i_nu_scaled(double x, int nu);
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:bessel_k_nu_scaled_(global_function)
*/
OCMATHLT_API	double bessel_k_nu_scaled(double x, int nu);
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:bessel_i_nu_(global_function)
*/
OCMATHLT_API	double bessel_i_nu(double x, int nu);
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:bessel_k_nu_(global_function)
*/
OCMATHLT_API	double bessel_k_nu(double x, int nu);
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:kelvin_ber_(global_function)
*/
OCMATHLT_API	double kelvin_ber(double x);
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:kelvin_bei_(global_function)
*/
OCMATHLT_API	double kelvin_bei(double x);
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:kelvin_ker_(global_function)
*/
OCMATHLT_API	double kelvin_ker(double x);
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:kelvin_kei_(global_function)
*/
OCMATHLT_API	double kelvin_kei(double x);
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:fresnel_s_(global_function)
*/
OCMATHLT_API	double fresnel_s(double x);
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:fresnel_c_(global_function)
*/
OCMATHLT_API	double fresnel_c(double x);
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:elliptic_integral_rc_(global_function)
*/
OCMATHLT_API	double elliptic_integral_rc(double x, double y);
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:elliptic_integral_rf_(global_function)
*/
OCMATHLT_API	double elliptic_integral_rf(double x, double y, double z);
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:elliptic_integral_rd_(global_function)
*/
OCMATHLT_API	double elliptic_integral_rd(double x, double y, double z);
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:elliptic_integral_rj_(global_function)
*/
OCMATHLT_API	double elliptic_integral_rj(double x, double y, double z, double r);
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:jacobian_theta_(global_function)
*/
OCMATHLT_API	double jacobian_theta(int k, double x, double q);
///End	ADD_NAG_SPECIAL_FUNCTIONS


// Comments last updated by Iris on 07/23/2008
/**@ >Math Functions>Basic*/

///Jake 04/25/07  ADD_RADIAN_AND_DEGREE_CONV
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:rad2deg_(global_function)
*/
OCMATHLT_API	double rad2deg(double r);
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:deg2rad_(global_function)
*/
OCMATHLT_API	double deg2rad(double d);

/// end  ADD_RADIAN_AND_DEGREE_CONV

/// Zachary 04/12/06    QA-8482 	ADD_CATEGORY_AND_PARAMETERS_LIST
typedef enum {
	BFC_NAG_SF,			//build in functions category, Nag special funtions.
	BFC_CDF,			//build in functions category, Cumulative Distribution Functions.
	BFC_PDF,			//build in functions category, Probability density functions.
	BFC_INV,			//build in functions category, Inverse Cumulative Distribution Functions.
	BFC_RNG,			//build in functions category, Random Number Generators.
	///Arvin 06/28/07 QA70-9982 SET_COL_VALUE_FUNCTION_LIST_SUPPORT_FOR_OC_FUNCTIONS
	BFC_OC_RETURN_NUMERIC,
	BFC_OC_RETURN_STRING,
	BFC_OC_RETURN_VECTOR,
 	BFC_OC_RETURN_MATRIX,	///Kyle 12/30/2008 v8.0992 OKUTIL_FIND_LT_FUNCTIONS_ADD_MATRIX_AS_RETURN_TYPE
	///END SET_COL_VALUE_FUNCTION_LIST_SUPPORT_FOR_OC_FUNCTIONS
	///------ Folger 08/17/2011 ORG-3564-P1 FAILED_TO_SHOW_LT_FUNCTION_RETURN_COMPLEX_IN_SCV
	BFC_OC_RETURN_COMPLEX,
	///------ End FAILED_TO_SHOW_LT_FUNCTION_RETURN_COMPLEX_IN_SCV
	BFC_OTHERS,		    //others.
} OCLTCATEGORY;
///End		 ADD_CATEGORY_AND_PARAMETERS_LIST

//////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////
#ifdef _MSC_VER
	#ifdef __cplusplus
		}
	#endif
#endif	//_MSC_VER

#endif		// __OCLT_H__
