/*------------------------------------------------------------------------------*
 * File Name: O3DGLConst.h														*
 * Creation: Kenny 07/29/2011													*
 * Purpose: Enumerations sharing between O3DGL and other modules				* 
 * All Rights Reserved															*
 *																				*
 * Modification Log:															*
 *	Kenny 09/17/2012 ORG-5953 OGL_DATA_LABEL_LEADER_LINE						*
 *	Kyle 09/28/2012 ORG-1433-S1 SHARE_O3D_ENUM_TO_OC_AND_SDK					*
 *------------------------------------------------------------------------------*/

#ifndef OKO3DGLCONST_H
#define OKO3DGLCONST_H

enum OKGLMeshGridLineCtrl
{
	GLS_GRID_NO_MINOR_LINES,
	GLS_GRID_SET_NUM_OF_MINOR_PER_MAJOR,
	GLS_GRID_SET_MAX_NUM_OF_MAJORS,
};

enum OKGLArrowHeadShape
{
	O3DAHS_FIRST,
	O3DAHS_NONE		= O3DAHS_FIRST,
	O3DAHS_FILLED,
	O3DAHS_EMPTY,
	O3DAHS_STEALTH,
	O3DAHS_FILLED_REVERSE,
	O3DAHS_EMPTY_REVERSE,
	O3DAHS_STEALTH_REVERSE,
	O3DAHS_STICK,
	O3DAHS_CROSS,
	O3DAHS_DIAMOND,
	O3DAHS_RECTANGLE,
	O3DAHS_ELLIPSE,
	O3DAHS_STICK_UP,
	O3DAHS_STICK_DOWN,

	// Do not add new entry underneath this line!
	O3DAHS_LAST,
};

enum OKGLDisplayScale
{
	SCALE_SMALL,
	SCALE_MEDIUM,
	SCALE_BIG,
	SCALE_BIGGER,
	SCALE_LAYER,
	SCALE_FULLSCALE,
	SCALE_COUNT,
};

/// Kenny 09/13/2012 ORG-5953 OGL_DATA_LABEL_LEADER_LINE
enum OKGLApproachPointCtrl
{
	O3DAPC_Direct		= 0x00,
	O3DAPC_X			= 0x01,
	O3DAPC_Y			= 0x02,
	O3DAPC_Z			= 0x04,
	O3DAPC_AxesMask		= 0x07,
};
/// End OGL_DATA_LABEL_LEADER_LINE

///Kyle 09/28/2012 ORG-1433-S1 SHARE_O3D_ENUM_TO_OC_AND_SDK, moved from O3DCore.h
typedef enum tagOITAlgorithm
{
	OITA_OFF			= 0,
	OITA_DUAL_DEPTH_PEELING,

	OITA_COUNT,
} OITAlgorithm;
///End SHARE_O3D_ENUM_TO_OC_AND_SDK

typedef enum tagO3DGLLineCylinderSimulate
{
	OGLL_CYLINDER_SIMULATE_OFF						= 0,
	OGLL_CYLINDER_SIMULATE_ONLY_NECESSARY,
	OGLL_CYLINDER_SIMULATE_ALREADY_ON,
	OGLL_CYLINDER_SIMULATE_ON_EXCEPT_BAD_QUALITY,
} O3DGLLineCylinderSimulate;


///////////////////////////////////////////////////////////////////////////////////////
//////////////////////////// End of File  /////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////
#endif // OKO3DGLCONST_H