#ifndef NAGX02
#define NAGX02
/// TD ML 06-10-2011 ORG-2987 NAG_HEADERS_OC_COMPILE
#ifndef _MSC_VER
	#pragma dll(ONAG8)
#endif // !_MSC_VER
/// end NAG_HEADERS_OC_COMPILE
#ifdef __cplusplus
extern "C"
{
#endif

/* <nagx02.h>
 *
 * Copyright 2000 Numerical Algorithms Group.
 *
 * Header file for the x02 chapter of the NAG C Library.
 * Definitions of machine-specific constants.
 *
 * This header file was generated by getcons.
 *
 * Mark 6a, 2000
 *
 *
 * X02AHC: max sine argument
 * X02AJC: machine precision
 * X02AKC: smallest positive model number
 * X02ALC: largest positive model number
 * X02AMC: real safe range number
 * X02ANC: complex safe range number
 * X02BBC: Largest representable integer
 * X02BEC: Maximum number of digits that can be represented
 * X02BHC: base
 * X02BJC: number of digits in base X02BHC
 * X02BKC: minimum exponent
 * X02BLC: maximum exponent
 * X02DAC: Switch to take precautions about underflow
 * X02DJC: Parameter 'rounds' of floating-point arithmetic
 *
 *
 * Note 
 * ==== 
 * Setting the NAG_USE_STANDARD_CONSTANTS flag will make use of C standard
 * library constants whenever possible. However, usage of this flag is not
 * currently recomanded and has not been fully tested. In particular, the 
 * machine precision is defined differently by NAG and by the C standard:
 * EPS_NAG: smallest x such that 1 + x > 1 (e.g., 2**(-53)).
 * EPS_C  : let y = smallest representable number greater than 1,
 *          machine precision is y - 1, (e.g. 2**(-52))
 * Finally note that (1+EPS_NAG)-1 = EPS_C.
 */

#ifdef NAG_USE_STANDARD_CONSTANTS
#include <float.h>
#include <limits.h>
#endif

/* Only available in NAG routines. */
#define X02AHC x02ahc()
#define X02AMC x02amc()
#define X02ANC x02anc()
extern NAG_DLL_EXPIMP double NAG_CALL x02ahc(void);
extern NAG_DLL_EXPIMP double NAG_CALL x02amc(void);
extern NAG_DLL_EXPIMP double NAG_CALL x02anc(void);
#define X02DAC Nag_FALSE

/* C alternatives available */
#ifdef NAG_USE_STANDARD_CONSTANTS
  #define X02AJC DBL_EPSILON /* Warning: DBL_EPSILON different from NAG's def.*/
  #define X02AKC DBL_MIN
  #define X02ALC DBL_MAX
  #define X02BBC INT_MAX
  #define X02BEC DBL_DIG
  #define X02BHC FLT_RADIX
  #define X02BJC DBL_MANT_DIG
  #define X02BKC (DBL_MIN_EXP) /* Brackets to allow usage of -X02BKC */
  #define X02BLC DBL_MAX_EXP
  #define X02DJC FLT_ROUNDS
#else
  #define X02AJC x02ajc()
  #define X02AKC x02akc()
  #define X02ALC x02alc()
  extern NAG_DLL_EXPIMP double NAG_CALL x02ajc(void);
  extern NAG_DLL_EXPIMP double NAG_CALL x02akc(void);
  extern NAG_DLL_EXPIMP double NAG_CALL x02alc(void);
  #define X02BBC 2147483647
  #define X02BEC 15
  #define X02BHC 2
  #define X02BJC 53
  #define X02BKC (-1021)     /* Brackets to allow usage of -X02BKC */
  #define X02BLC 1024
  #define X02DJC Nag_TRUE
#endif
  /* Routine prototyes */
extern void x02zaz(double wmach[]);

extern NAG_DLL_EXPIMP
  Integer NAG_CALL x02bbc(void);

extern NAG_DLL_EXPIMP
  Integer NAG_CALL x02bec(void); 

extern NAG_DLL_EXPIMP
  Integer NAG_CALL x02bhc(void);

extern NAG_DLL_EXPIMP
  Integer NAG_CALL x02bjc(void);

extern NAG_DLL_EXPIMP
  Integer NAG_CALL x02bkc(void);

extern NAG_DLL_EXPIMP
  Integer NAG_CALL x02blc(void);

extern NAG_DLL_EXPIMP
  Nag_Boolean NAG_CALL x02dac(void);

extern NAG_DLL_EXPIMP
  Nag_Boolean NAG_CALL x02djc(void);

#ifdef __cplusplus
}
#endif
#endif  /* not NAGX02 */
