/* <nags.h>
 *
 * Copyright 1996 Numerical Algorithms Group
 *
 * Include file for NAG C Library s Chapter
 *
 * Mark 4, revised, 1996.
 * Mark 5 revised. IER-2167 (Feb 1998).
 * Mark 6 revised. IER-3055 (July 2000).
 * Mark 9, revised, 2008.
 */
#ifndef NAGS
#define NAGS
/// TD ML 06-10-2011 ORG-2987 NAG_HEADERS_OC_COMPILE
#ifndef _MSC_VER
	#pragma dll(ONAG8)
#endif // !_MSC_VER
/// end NAG_HEADERS_OC_COMPILE
#ifdef __cplusplus
extern "C"
{
#endif
  /* begin proto */
  extern NAG_DLL_EXPIMP double NAG_CALL s01bac(double x, NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL s10aac(double x);

  extern NAG_DLL_EXPIMP double NAG_CALL s10abc(double x, NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL s10acc(double x, NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL s11aac(double x, NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL s11abc(double x);

  extern NAG_DLL_EXPIMP double NAG_CALL s11acc(double x, NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL s13aac(double x, NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL s13acc(double x, NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL s13adc(double x);

  extern NAG_DLL_EXPIMP double NAG_CALL s14aac(double x, NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL s14abc(double x, NagError *fail);


  extern NAG_DLL_EXPIMP double NAG_CALL s14acc(double x, NagError *fail);
 

  extern NAG_DLL_EXPIMP void NAG_CALL s14adc(double x, Integer n, Integer m, double ans[], NagError *fail);
 

  extern NAG_DLL_EXPIMP double NAG_CALL s14aec(double x, Integer k, NagError *fail);


  extern NAG_DLL_EXPIMP complex NAG_CALL s14afc(complex z__, Integer k, NagError *fail);

  extern NAG_DLL_EXPIMP complex NAG_CALL s14agc(complex z, NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL s14ahc(double x, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL s14bac(double a, double x, double tol, double *p, double *q, 
                                             NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL s15abc(double x);

  extern NAG_DLL_EXPIMP double NAG_CALL s15acc(double x);

  extern NAG_DLL_EXPIMP double NAG_CALL s15adc(double x);

  extern NAG_DLL_EXPIMP double NAG_CALL s15aec(double x);

  extern NAG_DLL_EXPIMP double NAG_CALL s15afc(double x);
 
  extern NAG_DLL_EXPIMP double NAG_CALL s15agc(double x, NagError *fail);

  extern NAG_DLL_EXPIMP complex NAG_CALL s15ddc(complex z, NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL s17acc(double x, NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL s17adc(double x, NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL s17aec(double x, NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL s17afc(double x, NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL s17agc(double x, NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL s17ahc(double x, NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL s17ajc(double x, NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL s17akc(double x, NagError *fail);


  extern NAG_DLL_EXPIMP void NAG_CALL s17alc (double a, Integer n, Integer mode, double rel,
                       double x[], NagError *fail);


  extern NAG_DLL_EXPIMP void NAG_CALL s17dcc(double fnu, complex z, Integer n, Nag_ScaleResType scal, complex cy[], Integer *nz, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL s17dcf_f(double fnu, complex z, Integer n, const char *scale,
		       complex cy[], Integer *nz, complex cwrk[], Integer *ifail,
		       Integer scale_len);
 

  extern NAG_DLL_EXPIMP void NAG_CALL s17dec(double fnu, complex z, Integer n, Nag_ScaleResType scal, complex cy[], Integer *nz, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL s17def_f(double fnu, complex z, Integer n, const char *scale,
		       complex cy[], Integer *nz, Integer *ifail, Integer scale_len);
 

  extern NAG_DLL_EXPIMP void NAG_CALL s17dgc(Nag_FunType deriv, complex z, Nag_ScaleResType scal, complex *ai, Integer *nz, NagError *fail);
 

  extern NAG_DLL_EXPIMP void NAG_CALL s17dhc(Nag_FunType deriv, complex z, Nag_ScaleResType scal, complex *bi, NagError *fail);
 

  extern NAG_DLL_EXPIMP void NAG_CALL s17dlc(Integer m, double fnu, complex z, Integer n, Nag_ScaleResType scal, complex cy[], Integer *nz, NagError *fail);
 

  extern NAG_DLL_EXPIMP double NAG_CALL s18acc(double x, NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL s18adc(double x, NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL s18aec(double x, NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL s18afc(double x, NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL s18ccc(double x, NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL s18cdc(double x, NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL s18cec(double x);

  extern NAG_DLL_EXPIMP double NAG_CALL s18cfc(double x);


  extern NAG_DLL_EXPIMP void NAG_CALL s18dcc(double fnu, complex z, Integer n, Nag_ScaleResType scal, complex cy[], Integer *nz, NagError *fail);



extern  NAG_DLL_EXPIMP
void NAG_CALL s18dec(double fnu, complex z, Integer n, Nag_ScaleResType scal, complex cy[], Integer *nz, NagError *fail);


extern  NAG_DLL_EXPIMP
 double NAG_CALL s18ecc (double x, Integer nu, NagError *fail);


extern  NAG_DLL_EXPIMP
 double NAG_CALL s18edc (double x, Integer nu, NagError *fail);


extern NAG_DLL_EXPIMP
 double NAG_CALL s18eec (double x, Integer nu, NagError *fail);


extern NAG_DLL_EXPIMP
 double NAG_CALL s18efc (double x, Integer nu, NagError *fail);


extern NAG_DLL_EXPIMP
 void NAG_CALL s18egc (double x, Integer ia, Integer ja, Integer nl,
	               double * b, NagError *fail);


extern NAG_DLL_EXPIMP
 void NAG_CALL s18ehc (double x, Integer ia, Integer ja, Integer nl,
	               double * b, NagError *fail);


extern NAG_DLL_EXPIMP
 void NAG_CALL s18ejc (double x, double a, Integer nl, complex b[],
	               NagError *fail);


extern NAG_DLL_EXPIMP
 void NAG_CALL s18ekc (double x, double a, Integer nl, complex b[],
	               NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL s18gkc(complex z, double a, Integer nl, complex b[], NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL s19aac(double x, NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL s19abc(double x, NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL s19acc(double x, NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL s19adc(double x, NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL s20acc(double x);

  extern NAG_DLL_EXPIMP double NAG_CALL s20adc(double x);

  extern NAG_DLL_EXPIMP double NAG_CALL s21bac(double x, double y, NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL s21bbc(double x, double y, double z, NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL s21bcc(double x, double y, double z, NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL s21bdc(double x, double y, double z, double r, NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL s21bdc(double x, double y, double z, double r, NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL s21bec(double phi, double dm, NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL s21bfc(double phi, double dm, NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL s21bgc(double dn, double phi, double dm, NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL s21bhc(double dm, NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL s21bjc(double dm, NagError *fail);


  extern NAG_DLL_EXPIMP void NAG_CALL s21cac(double u, double m, double *sn, double *cn, double *dn, NagError *fail);


extern NAG_DLL_EXPIMP
 void NAG_CALL s21cbc (complex z, double ak2, complex * sn, complex * cn,
	               complex * dn, NagError *fail);


extern NAG_DLL_EXPIMP
 double NAG_CALL s21ccc (Integer k, double x, double q, NagError *fail);


extern NAG_DLL_EXPIMP
  complex NAG_CALL s21dac (complex z, double akp, double a,
	               double b, NagError *fail);


  extern NAG_DLL_EXPIMP void NAG_CALL s22aac (Integer mode, double x, Integer m, Integer nl,double * p, NagError *fail);
 

  extern NAG_DLL_EXPIMP void NAG_CALL s23aac(complex z, complex eta, complex zlmin, Integer nl, Integer kfn, Integer mode, complex f[], complex g[], complex fp[], complex gp[], complex sig[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL s30aac(Nag_OrderType order, Nag_CallPut iput, Integer m, Integer n, const double x[], double s, const double t[], double sigma, double r, double q, double p[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL s30abc(Nag_OrderType order, Nag_CallPut iput, Integer m, Integer n, const double x[], double s, const double t[], double sigma, double r, double q, double p[], double delta[], double gamma[], double vega[], double theta[], double rho[], double crho[], double vanna[], double charm[], double speed[], double colour[], double zomma[], double vomma[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL s30bac(Nag_OrderType order, Nag_CallPut iput, Integer m, Integer n, const double sm[], double s, const double t[], double sigma, double r, double q, double p[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL s30bbc(Nag_OrderType order, Nag_CallPut iput, Integer m, Integer n, const double sm[], double s, const double t[], double sigma, double r, double q, double p[], double delta[], double gamma[], double vega[], double theta[], double rho[], double crho[], double vanna[], double charm[], double speed[], double colour[], double zomma[], double vomma[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL s30cac(Nag_OrderType order, Nag_CallPut iput, Integer m, Integer n, const double x[], double s, double k, const double t[], double sigma, double r, double q, double p[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL s30cbc(Nag_OrderType order, Nag_CallPut iput, Integer m, Integer n, const double x[], double s, double k, const double t[], double sigma, double r, double q, double p[], double delta[], double gamma[], double vega[], double theta[], double rho[], double crho[], double vanna[], double charm[], double speed[], double colour[], double zomma[], double vomma[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL s30ccc(Nag_OrderType order, Nag_CallPut iput, Integer m, Integer n, const double x[], double s, const double t[], double sigma, double r, double q, double p[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL s30cdc(Nag_OrderType order, Nag_CallPut iput, Integer m, Integer n, const double x[], double s, const double t[], double sigma, double r, double q, double p[], double delta[], double gamma[], double vega[], double theta[], double rho[], double crho[], double vanna[], double charm[], double speed[], double colour[], double zomma[], double vomma[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL s30fac(Nag_OrderType order, Nag_CallPut iput, Nag_Barrier itype, Integer m, Integer n, const double x[], double s, double h, double k, const double t[], double sigma, double r, double q, double p[], NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL s30fbc(Nag_OrderType order, Nag_CallPut iput, Nag_Barrier itype, Integer m, Integer n, const double x[], double s, double h, double k, const double t[], double sigma, double r, double q, double p[], double delta[], double gamma[], double vega[], double theta[], double rho[], double rhoq[], double vanna[], double charm[], double speed[], double colour[], double zomma[], double vomma[], NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL s30jac(Nag_OrderType order, Nag_CallPut iput, Integer m, Integer n, const double x[], double s, const double t[], double sigma, double r, double lambda, double jvol, double p[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL s30jbc(Nag_OrderType order, Nag_CallPut iput, Integer m, Integer n, const double x[], double s, const double t[], double sigma, double r, double lambda, double jvol, double p[], double delta[], double gamma[], double vega[], double theta[], double rho[], double vanna[], double charm[], double speed[], double colour[], double zomma[], double vomma[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL s30nac(Nag_OrderType order, Nag_CallPut iput, Integer m, Integer n, const double x[], double s, const double t[], double sigmav, double kappa, double corr, double var0, double eta, double gamma, double r, double q, double p[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL s30qcc(Nag_OrderType order, Nag_CallPut iput, Integer m, Integer n, const double x[], double s, const double t[], double sigma, double r, double q, double p[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL s30sac(Nag_OrderType order, Nag_CallPut iput, Integer m, Integer n, const double x[], double s, const double t[], double sigma, double r, double b, double p[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL s30sbc(Nag_OrderType order, Nag_CallPut iput, Integer m, Integer n, const double x[], double s, const double t[], double sigma, double r, double b, double p[], double delta[], double gamma[], double vega[], double theta[], double rho[], double crho[], double vanna[], double charm[], double speed[], double colour[], double zomma[], double vomma[], NagError *fail);

#ifdef NAGLIBANDSTINCLUDE
#include <nagsaux.h>
 #endif
 
  /* end proto */
#ifdef __cplusplus
}
#endif
#endif /* not NAGS */
