/* <nagg13.h>
 *
 * Copyright 1996 Numerical Algorithms Group
 *
 * Include file for NAG C Library g13 Chapter
 *
 * Mark 4, revised, 1996.
 * Mark 5 revised. IER-2162 (Feb 1998).
 * Mark 6 revised. IER-3049 (July 2000).
 */
#ifndef NAGG13
#define NAGG13
/// TD ML 06-10-2011 ORG-2987 NAG_HEADERS_OC_COMPILE
#ifndef _MSC_VER
	#pragma dll(ONAG8)
#endif // !_MSC_VER
/// end NAG_HEADERS_OC_COMPILE
#ifdef __cplusplus
extern "C"
{
#endif
  /* Message codes and extern of message list */
//the following includes used <name.h>, changed to "name.h"	/// TD ML 06-10-2011 ORG-2987 NAG_HEADERS_OC_COMPILE
#include "nag_g13mesg.h"
  /* begin proto */
  extern NAG_DLL_EXPIMP void NAG_CALL g13aac(const double x[], Integer nx, Integer d, Integer ds, Integer s,
					     double xd[], Integer *nxd, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g13abc(const double x[], Integer nx, Integer nk, double *mean, double *var,
                                             double r[], double *stat, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g13acc(double r[], Integer nk, Integer nl, double p[], double v[],
                                             double ar[], Integer *nvl, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g13amc(Nag_InitialValues mode, Nag_ExpSmoothType itype, Integer p,
                                             const double param[], Integer n, const double y[], Integer k,
                                             double init[], Integer nf, double fv[], double fse[], double yhat[],
                                             double res[], double *dv, double *ad, double r[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g13asc(Nag_ArimaOrder *arimav, Integer n, const double v[],  Integer m,
					     const double par[], Integer npar, double c[],
					     double acfvar[], Integer im, double * sum2, Integer * idf,
					     double * siglev, NagError *fail);


  extern NAG_DLL_EXPIMP void NAG_CALL g13auc(Integer n, const double z[],
                                             Integer m, Nag_RangeStat rs,
                                             double y[], double mean[],
                                             NagError *fail);


  extern NAG_DLL_EXPIMP void NAG_CALL g13bac(const double y[], Integer ny, Nag_ArimaOrder *arimaf,
                                             Nag_ArimaOrder *arimav, const double par[], Integer npar,
                                             double cy, double b[], Integer nb, NagError *fail);


  extern NAG_DLL_EXPIMP void NAG_CALL g13bbc(const double y[], Integer ny, Nag_TransfOrder *transfv, Nag_ArimaOrder *arimas, const double par[], Integer npar, double cy, double b[], Integer nb, NagError *fail);


  extern  NAG_DLL_EXPIMP void NAG_CALL g13bcc(const double x[], const double y[], Integer nxy, Integer nl, double *s, double *r0, double r[], double *stat, NagError *fail);
 

  extern  NAG_DLL_EXPIMP void NAG_CALL g13bdc(double r0, const double r[], Integer nl, Nag_TransfOrder *transfv, double s, double wds[], Integer isf[], NagError *fail);
 

  extern NAG_DLL_EXPIMP void NAG_CALL g13bec(Nag_ArimaOrder *arimav, Integer nseries, Nag_TransfOrder *transfv,
                                             double para[], Integer npara, Integer nxxy, double xxy[],
                                             Integer tdxxy, double sd[], double *rss, double *objf,
                                             double *df, Nag_G13_Opt *options, NagError *fail);


  extern NAG_DLL_EXPIMP void NAG_CALL g13bgc(Nag_ArimaOrder *arimav, Integer nser, Nag_TransfOrder *transfv, const double para[], Integer npara, Integer nnv, double xxyn[], Integer tdxxyn, Integer kzef, Nag_G13_Opt *options, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g13bjc(Nag_ArimaOrder *arimav, Integer nseries, Nag_TransfOrder *transfv,
                                             double para[], Integer npara, Integer nev, Integer nfv,
                                             double xxy[], Integer tdxxy, double rmsxy[],
                                             Integer mrx[], Integer tdmrx, double parx[], Integer ldparx,
                                             Integer tdparx, double fva[], double fsd[], Nag_G13_Opt *options,
                                             NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g13bxc(Nag_G13_Opt *options);

  extern NAG_DLL_EXPIMP void NAG_CALL g13byc(Integer nseries, Nag_TransfOrder *transfv, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g13bzc(Nag_TransfOrder *transfv);


  extern NAG_DLL_EXPIMP void NAG_CALL g13cac(Integer nx, Integer mtx, double px, Integer iw, Integer mw, Integer ic, Integer nc, double c[], Integer kc, Integer l, Nag_LoggedSpectra lg_spect, Integer nxg, double xg[], Integer *ng, double stats[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g13cbc(Integer nx, NagMeanOrTrend mt_correction,  double px,  Integer mw,
                                             double pw,  Integer l, Integer kc, Nag_LoggedSpectra lg_spect,
                                             double x[], double **g,  Integer *ng,  double stats[],
                                             NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g13ccc(Integer nxy, NagMeanOrTrend mtxy_correction, double pxy, Integer iw, Integer mw, Integer ish, Integer ic, Integer nc, double cxy[], double cyx[], Integer kc, Integer l, double xg[], double yg[], complex g[], Integer *ng, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g13cdc(Integer nxy, NagMeanOrTrend mt_correction, double pxy,  Integer mw,
                                             Integer is,  double pw,  Integer l, Integer kc,
                                             double x[], double y[],  complex **g, Integer *ng, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g13cec(double xg[], double yg[], complex xyg[],  Integer ng,
                                             double stats[], double ca[], double calw[], double caup[],
                                             double *t, double sc[], double sclw[], double scup[],
                                             NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g13cfc(double xg[], double yg[], complex xyg[], Integer ng,
                                             double stats[], double gn[], double gnlw[], double gnup[],
                                             double ph[], double phlw[], double phup[],
                                             NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g13cgc(double xg[], double yg[], complex xyg[], Integer ng,
                                             double stats[],  Integer l, Integer n,  double er[],
                                             double *erlw, double *erup, double rf[], double *rfse,
                                             NagError *fail);


  extern NAG_DLL_EXPIMP void NAG_CALL g13dbc(const double c0[], const double c[], Integer ns, Integer nl, Integer nk, double p[], double *v0, double v[], double d[], double db[], double w[], double wb[], Integer *nvp, NagError *fail);


  extern NAG_DLL_EXPIMP void NAG_CALL g13ddc(Integer k, Integer n, Integer ip, Integer iq, Nag_IncludeMean mean, double par[], Integer npar, double qq[], Integer kmax, const double w[], const Nag_Boolean parhld[], Nag_Boolean exact, Integer iprint, double cgetol, Integer maxcal, Integer ishow, const char * outfile, Integer *niter, double *rlogl, double v[], double g[], double cm[], Integer icm, NagError *fail);


  extern NAG_DLL_EXPIMP void NAG_CALL g13djc(Integer k, Integer n, const double z[], Integer kmax, const Integer tr[], const Integer id[], const double delta[], Integer ip, Integer iq, Nag_IncludeMean mean, const double par[], Integer lpar, double qq[], const double v[], Integer lmax, double predz[], double sefz[], double ref[], Integer lref, NagError *fail);


  extern NAG_DLL_EXPIMP void NAG_CALL g13dkc(Integer k, Integer lmax, Integer m, Integer *mlast, const double z[], Integer kmax, double ref[], Integer lref, double v[], double predz[], double sefz[], NagError *fail);


  extern NAG_DLL_EXPIMP void NAG_CALL g13dlc(Integer k, Integer n, const double z[], const Integer tr[], const Integer id[], const double delta[], double w[], Integer *nd, NagError *fail);


  extern NAG_DLL_EXPIMP void NAG_CALL g13dmc(Nag_CovOrCorr Nmatrix, Integer k, Integer n, Integer m, const double w[], double wmean[], double r0[], double r[], NagError *fail);
 


  extern NAG_DLL_EXPIMP void NAG_CALL g13dnc(Integer k, Integer n, Integer m, const double r0[], const double r[], Integer *maxlag, double parlag[], double x[], double pvalue[], NagError *fail);
 


  extern NAG_DLL_EXPIMP void NAG_CALL g13dpc(Integer k, Integer n, const double z[], Integer m, Integer *maxlag, double parlag[], double se[], double qq[], double x[], double pvalue[], double loglhd[], NagError *fail);
 

  extern NAG_DLL_EXPIMP void NAG_CALL g13dsc(Integer k, Integer n, const double v[], Integer kmax, Integer ip, Integer iq, Integer m, const double par[], const Nag_Boolean parhld[], double qq[], Integer ishow, const char * outfile, double r0[], double r[], double rcm[], Integer ircm, double *chi, Integer *idf, double *siglev, NagError *fail);


  extern NAG_DLL_EXPIMP void NAG_CALL g13dxc(Integer k, Integer ip, const double par[], double rr[], double ri[], double rmod[], NagError *fail);
 

  extern NAG_DLL_EXPIMP void NAG_CALL g13eac(Integer n, Integer m, Integer p, double s[], Integer tds,
                                             double a[], Integer tda, double b[], Integer tdb,
                                             double q[], Integer tdq, double c[], Integer tdc,
                                             double r[], Integer tdr, double k[], Integer tdk, 
                                             double h[], Integer tdh, double tol, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g13ebc(Integer n, Integer m, Integer p, double s[], Integer tds,
                                             double a[], Integer tda, double b[], Integer tdb, double q[],
                                             Integer tdq, double c[], Integer tdc, double r[], Integer tdr,
                                             double k[], Integer tdk, double h[], Integer tdh,
                                             double tol, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g13ecc(Integer n, Integer m, Integer p,
                                             Nag_ab_input inp_ab,double t[], Integer tdt,
                                             double ainv[], Integer tda, double b[], Integer tdb, 
                                             double rinv[], Integer tdr, double c[], Integer tdc,
                                             double qinv[], Integer tdq, double x[], double rinvy[], 
                                             double z[], double tol,
                                             NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g13edc(Integer n, Integer m, Integer p, 
                                             double t[], Integer tdt, double ainv[], Integer tda,
                                             double ainvb[], Integer tdai, double rinv[], Integer tdr,
                                             double c[], Integer tdc, double qinv[], Integer tdq, double x[],
                                             double rinvy[], double z[], double tol,  NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g13ewc(Integer n, Integer p,  Nag_ObserverForm reduceto, double a[],
                                             Integer tda, double c[], Integer tdc, double u[], Integer tdu,
                                             NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g13exc(Integer n, Integer m, Nag_ControllerForm reduceto, double a[],
                                             Integer tda, double b[], Integer tdb, double u[], Integer tdu, 
                                             NagError *fail);

  extern NAG_DLL_EXPIMP
  void NAG_CALL g13fac(const double  yt[], const double  x[], Integer ldx, Integer num,
                       Integer ip, Integer iq, Integer nreg, Integer mn,
                       Integer isym, double  theta[], double  se[], double  sc[],
                       double  covar[], Integer ldc, double  *hp, double  etm[],
                       double  htm[], double  *lgf, Nag_Garch_Stationary_Type stat_opt,
                       Nag_Garch_Est_Initial_Type est_opt, Integer maxit,
                       double  tol, NagError *ifail);

  extern NAG_DLL_EXPIMP
  void NAG_CALL g13fbc(Integer num, Integer nt, Integer ip, Integer iq,
                       const double  theta[], double  gamma, double  cvar[], const double  ht[],
                       const double  et[], NagError *ifail);

  extern NAG_DLL_EXPIMP
  void NAG_CALL g13fcc(const double yt[], const double x[], Integer ldx, Integer num,
                       Integer ip, Integer iq, Integer nreg, Integer mn,
                       double theta[], double se[], double sc[], double covar[],
                       Integer ldc, double *hp, double etm[], double htm[],
                       double *lgf, Nag_Garch_Stationary_Type stat_opt,
                       Nag_Garch_Est_Initial_Type est_opt, Integer maxit, double tol, NagError *ifail);

  extern NAG_DLL_EXPIMP
  void NAG_CALL g13fdc(Integer num, Integer nt, Integer ip, Integer iq,
                       const double theta[], double gamma, double cvar[], const double ht[],
                       const double et[], NagError *ifail);

  extern NAG_DLL_EXPIMP
  void NAG_CALL g13fec(const double yt[], const double x[], Integer ldx, Integer num,
		       Integer ip, Integer iq, Integer nreg, Integer mn,
		       double theta[], double se[], double sc[], double covar[],
		       Integer ldc, double * hp, double etm[], double htm[],
		       double * lgf, Nag_Garch_Stationary_Type stat_opt,
		       Nag_Garch_Est_Initial_Type est_opt, Integer maxit, double tol,
		       NagError *ifail);

  extern NAG_DLL_EXPIMP
  void NAG_CALL g13ffc(Integer num, Integer nt, Integer ip, Integer iq,
                       const double theta[], double gamma, double cvar[],
                       const double ht[], const double et[], NagError *ifail);

  extern NAG_DLL_EXPIMP void NAG_CALL g13xzc(Nag_G13_Opt *options);


#ifdef NAGLIBANDSTINCLUDE
#include <nagg13aux.h>
 #endif

  /* end proto */
#ifdef __cplusplus
}
#endif
#endif /* not NAGG13 */
