/* <nagg05.h>
 *
 * Copyright 1996 Numerical Algorithms Group
 *
 * Include file for NAG C Library g05 Chapter
 *
 * Mark 4, revised, 1996.
 * Mark 5 revised. IER-2157 (Feb 1998).
 * Mark 6 revised. IER-3044 (July 2000).
 */
#ifndef NAGG05
#define NAGG05
/// TD ML 06-10-2011 ORG-2987 NAG_HEADERS_OC_COMPILE
#ifndef _MSC_VER
	#pragma dll(ONAG8)
#endif // !_MSC_VER
/// end NAG_HEADERS_OC_COMPILE
#ifdef __cplusplus
extern "C"
{
#endif
  /* Note:
   * g05dgc is called by g05c{b,c,f} stringents only
   */
//the following includes used <name.h>, changed to "name.h"	/// TD ML 06-10-2011 ORG-2987 NAG_HEADERS_OC_COMPILE
#include "naglg05.h"    /* Needed for Nag_ag05ca_type etc. */
#ifdef NAG_THREAD_SAFE
#ifdef _MSC_VER	/// TD ML 06-10-2011 ORG-2987 NAG_HEADERS_OC_COMPILE
#include <pthread.h>
#endif// _MSC_VER	   /// TD ML 06-10-2011 ORG-2987 NAG_HEADERS_OC_COMPILE
#endif
  /* These functions are defined in g05czzt.c, they
   * are for use by g05c* stringents.
   */
  /* begin proto */
  extern NAG_DLL_EXPIMP double NAG_CALL g05cac(void);

 #ifdef OC2D_ARRAYS	/// TD ML 06-10-2011 ORG-2987 NAG_HEADERS_OC_COMPILE
 extern NAG_DLL_EXPIMP void NAG_CALL g05caz(Nag_Boolean *init,
                                             Nag_ag05ca_type **ag05ca,
                                             Nag_bg05ca_type **bg05ca,
                                             Nag_cg05ca_type **cg05ca,
                                             Nag_dg05ca_type **dg05ca);

  #endif// OC2D_ARRAYS	/// TD ML 06-10-2011 ORG-2987 NAG_HEADERS_OC_COMPILE
  extern NAG_DLL_EXPIMP void NAG_CALL g05cbc(Integer seed);

  extern NAG_DLL_EXPIMP void NAG_CALL g05ccc(void);

  extern NAG_DLL_EXPIMP void NAG_CALL g05cfc(Integer istate[], double xstate[]);

  extern NAG_DLL_EXPIMP void NAG_CALL g05cgc(Integer istate[], double xstate[], NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL g05dac(double mu, double sd);

  extern NAG_DLL_EXPIMP double NAG_CALL g05dbc(double mu);

  extern NAG_DLL_EXPIMP double NAG_CALL g05ddc(double mu, double sd);

  extern NAG_DLL_EXPIMP Integer NAG_CALL g05dyc(Integer m, Integer n);

  extern NAG_DLL_EXPIMP void NAG_CALL g05eac(double a[], Integer n, double c[], Integer tdc, 
                                             double eps, double **r,
                                             NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05ecc(double t, double **r, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05edc(Integer n, double p, double **r, 
                                             NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05ehc(Integer index[], Integer n, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05ejc(Integer ia[], Integer n, Integer iz[], Integer m, 
                                             NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05exc(double p[], Integer np, Integer sizep, Nag_DiscreteDistrib df, 
                                             double **r, NagError *fail);

  extern NAG_DLL_EXPIMP Integer NAG_CALL g05eyc(double r[]);

  extern NAG_DLL_EXPIMP void NAG_CALL g05ezc(double z[], double r[]);

  extern NAG_DLL_EXPIMP void NAG_CALL g05fec(double a, double b, Integer n, double x[],
                                             NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05ffc(double a, double b, Integer n, double x[],
                                             NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05hac(Nag_Boolean start, Integer p, Integer q, double phi[],
                                             double theta[], double mean, double vara, Integer n,
                                             double w[], double ref[], NagError *fail);

  extern NAG_DLL_EXPIMP
  void NAG_CALL g05hkc(Integer num, Integer ip, Integer iq, const double param[],
                       double  gamma, double  ht[], double  yt[], 
                       Nag_Garch_Fcall_Type fcall, double  rvec[],
                       NagError *ifail);

  extern NAG_DLL_EXPIMP
  void NAG_CALL g05hlc(Integer num, Integer ip, Integer iq, const double param[],
                       double gamma, double ht[], double yt[], 
                       Nag_Garch_Fcall_Type fcall, double rvec[], NagError *ifail);

  extern NAG_DLL_EXPIMP
  void NAG_CALL g05hmc(Integer num, Integer ip, Integer iq, const double param[],
              double gamma, double ht[], double yt[], 
              Nag_Garch_Fcall_Type fcall, double rvec[], NagError *ifail);


  extern NAG_DLL_EXPIMP double NAG_CALL g05kac(Integer igen, Integer iseed[]);
 
  
  extern NAG_DLL_EXPIMP void NAG_CALL g05kbc(Integer *igen, Integer iseed[]);
 

  extern NAG_DLL_EXPIMP void NAG_CALL g05kcc(Integer *igen, Integer iseed[]);


  extern NAG_DLL_EXPIMP Nag_Boolean NAG_CALL g05kec(double p, Integer igen, Integer iseed[], NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL g05kfc(Nag_BaseRNG genid, Integer subid, const Integer seed[], Integer lseed, Integer state[], Integer *lstate, NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL g05kgc(Nag_BaseRNG genid, Integer subid, Integer state[], Integer *lstate, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05khc(Integer n, Integer k, Integer state[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05kjc(Integer n, Integer state[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05lac(double xmu, double var, Integer n, double x[], Integer igen, Integer iseed[], NagError *fail);
 

  extern NAG_DLL_EXPIMP void NAG_CALL g05lbc(Integer df, Integer n, double x[], Integer igen, Integer iseed[], NagError *fail);
 

  extern NAG_DLL_EXPIMP void NAG_CALL g05lcc(Integer df, Integer n, double x[], Integer igen, Integer iseed[], NagError *fail);
 

  extern NAG_DLL_EXPIMP void NAG_CALL g05ldc(Integer df1, Integer df2, Integer n, double x[], Integer igen, Integer iseed[], NagError *fail);
 

  extern NAG_DLL_EXPIMP void NAG_CALL g05lec(double a, double b, Integer n, double x[], Integer igen, Integer iseed[], NagError *fail);
 

  extern NAG_DLL_EXPIMP void NAG_CALL g05lfc(double a, double b, Integer n, double x[], Integer igen, Integer iseed[], NagError *fail);
 

  extern NAG_DLL_EXPIMP void NAG_CALL g05lgc(double a, double b, Integer n, double x[], Integer igen, Integer iseed[], NagError *fail);
 

  extern NAG_DLL_EXPIMP void NAG_CALL g05lhc(double xmin, double xmax, double xmed, Integer n, double x[], Integer igen, Integer iseed[], NagError *fail);
 

  extern NAG_DLL_EXPIMP void NAG_CALL g05ljc(double a, Integer n, double x[], Integer igen, Integer iseed[], NagError *fail);
 

  extern NAG_DLL_EXPIMP void NAG_CALL g05lkc(double xmu, double var, Integer n, double x[], Integer igen, Integer iseed[], NagError *fail);
 

  extern NAG_DLL_EXPIMP void NAG_CALL g05llc(double xmed, double semiqr, Integer n, double x[], Integer igen, Integer iseed[], NagError *fail);
 

  extern NAG_DLL_EXPIMP void NAG_CALL g05lmc(double a, double b, Integer n, double x[], Integer igen, Integer iseed[], NagError *fail);
 

  extern NAG_DLL_EXPIMP void NAG_CALL g05lnc(double a, double b, Integer n, double x[], Integer igen, Integer iseed[], NagError *fail);
 

  extern NAG_DLL_EXPIMP void NAG_CALL g05lpc(double vk, Integer n, double x[], Integer igen, Integer iseed[], NagError *fail);
 

  extern NAG_DLL_EXPIMP void NAG_CALL g05lqc(Integer nmix, const double a[], const double wgt[], Integer n, double x[], Integer igen, Integer iseed[], NagError *fail);
 

  extern NAG_DLL_EXPIMP void NAG_CALL g05lxc(Nag_OrderType order, Integer mode, Integer df, Integer m, const double xmu[], const double c[], Integer pdc, Integer n, double x[], Integer pdx, Integer igen, Integer iseed[], double r[], Integer lr, NagError *fail);
 

  extern NAG_DLL_EXPIMP void NAG_CALL g05lyc(Nag_OrderType order, Integer mode, Integer m, const double xmu[], const double c[], Integer pdc, Integer n, double x[], Integer pdx, Integer igen, Integer iseed[], double r[], Integer lr, NagError *fail);
 

  extern NAG_DLL_EXPIMP void NAG_CALL g05lzc(Nag_OrderType order, Integer mode, Integer n, const double xmu[], const double c[], Integer ic, double x[], Integer igen, Integer iseed[], double r[], NagError *fail);
 

  extern NAG_DLL_EXPIMP void NAG_CALL g05mac(Integer a, Integer b, Integer n, Integer x[], Integer igen, Integer iseed[], NagError *fail);
 

  extern NAG_DLL_EXPIMP void NAG_CALL g05mbc(Integer mode, double p, Integer n, Integer x[], Integer igen, Integer iseed[], double r[], NagError *fail);
 

  extern NAG_DLL_EXPIMP void NAG_CALL g05mcc(Integer mode, Integer m, double p, Integer n, Integer x[], Integer igen, Integer iseed[], double r[], NagError *fail);
 

  extern NAG_DLL_EXPIMP void NAG_CALL g05mdc(Integer mode, double a, Integer n, Integer x[], Integer igen, Integer iseed[], double r[], NagError *fail);
 

  extern NAG_DLL_EXPIMP void NAG_CALL g05mec(Integer m, const double vlamda[], Integer x[], Integer igen, Integer iseed[], NagError *fail);
 

  extern NAG_DLL_EXPIMP void NAG_CALL g05mjc(Integer mode, Integer m, double p, Integer n, Integer x[], Integer igen, Integer iseed[], double r[], NagError *fail);
 

  extern NAG_DLL_EXPIMP void NAG_CALL g05mkc(Integer mode, double lambda, Integer n, Integer x[], Integer igen, Integer iseed[], double r[], NagError *fail);
 

  extern NAG_DLL_EXPIMP void NAG_CALL g05mlc(Integer mode, Integer ns, Integer np, Integer m, Integer n, Integer x[], Integer igen, Integer iseed[], double r[], NagError *fail);
 

  extern NAG_DLL_EXPIMP void NAG_CALL g05mrc(Nag_OrderType order, Integer mode, Integer m, Integer k, const double p[], Integer n, Integer x[], Integer pdx, Integer igen, Integer iseed[], double r[], NagError *fail);
 

  extern NAG_DLL_EXPIMP void NAG_CALL g05mzc(Integer mode, const double p[], Integer np, Integer ip1, Nag_ComputeType comp_type, Integer n, Integer x[], Integer igen, Integer iseed[], double r[], NagError *fail);
 

  extern NAG_DLL_EXPIMP void NAG_CALL g05nac(Integer index[], Integer n, Integer igen, Integer iseed[], NagError *fail);
 

  extern NAG_DLL_EXPIMP void NAG_CALL g05nbc(const Integer ipop[], Integer n, Integer isampl[], Integer m, Integer igen, Integer iseed[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05ncc(Integer index[], Integer n, Integer state[], NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL g05ndc(const Integer ipop[], Integer n, Integer isampl[], Integer m, Integer state[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05pac(Integer mode, double xmean, Integer p, const double phi[], Integer q, const double theta[], double avar, double *var, Integer n, double x[], Integer igen, Integer iseed[], double r[], NagError *fail);
 

  extern NAG_DLL_EXPIMP void NAG_CALL g05pcc(Nag_OrderType order, Integer mode, Integer k, const double xmean[], Integer p, const double phi[], Integer q, const double theta[], const double var[], Integer pdv, Integer n, double x[], Integer pdx, Integer igen, Integer iseed[], double r[], NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL g05pdc(Nag_ErrorDistn dist, Integer num, Integer ip, Integer iq, const double theta[], double gamma, Integer df, double ht[], double et[], Nag_Boolean fcall, double r[], Integer lr, Integer state[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05pec(Nag_ErrorDistn dist, Integer num, Integer ip, Integer iq, const double theta[], double gamma, Integer df, double ht[], double et[], Nag_Boolean fcall, double r[], Integer lr, Integer state[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05pfc(Nag_ErrorDistn dist, Integer num, Integer ip, Integer iq, const double theta[], double gamma, Integer df, double ht[], double et[], Nag_Boolean fcall, double r[], Integer lr, Integer state[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05pgc(Nag_ErrorDistn dist, Integer num, Integer p, Integer q, const double theta[], Integer df, double ht[], double et[], Nag_Boolean fcall, double r[], Integer lr, Integer state[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05phc(Nag_ModeRNG mode, Integer n, double xmean, Integer p, const double phi[], Integer q, const double theta[], double avar, double r[], Integer lr, Integer state[], double *var, double x[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05pjc(Nag_OrderType order, Nag_ModeRNG mode, Integer n, Integer k, const double xmean[], Integer p, const double phi[], Integer q, const double theta[], const double var[], Integer pdv, double r[], Integer lr, Integer state[], double x[], Integer pdx, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05pmc(Nag_InitialValues mode, Integer n, Nag_ExpSmoothType itype, Integer p, const double param[], const double init[], double var, double r[], Integer state[], const double e[], Integer en, double x[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05pxc(Nag_SideType side, Nag_InitializeA init, Integer m, Integer n, Integer state[], double a[], Integer pda, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05pxc(Nag_SideType side, Nag_InitializeA init, Integer m, Integer n, Integer state[], double a[], Integer pda, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05pyc(Integer n, const double d[], double eps, Integer state[], double c[], Integer pdc, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05pzc(Nag_ModeRNG mode, Integer nrow, Integer ncol, const Integer totr[], const Integer totc[], double r[], Integer lr, Integer state[], Integer x[], Integer pdx, NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL g05qac(Nag_OrderType order, Nag_SideType side, Nag_InitializeA init, Integer m, Integer n, double a[], Integer pda, Integer igen, Integer iseed[], NagError *fail);
 

  extern NAG_DLL_EXPIMP void NAG_CALL g05qbc(Nag_OrderType order, Integer n, const double d[], double c[], Integer pdc, double eps, Integer igen, Integer iseed[], NagError *fail);
 

  extern NAG_DLL_EXPIMP void NAG_CALL g05qdc(Nag_OrderType order, Integer mode, Integer nrow, Integer ncol, const Integer totr[], const Integer totc[], Integer x[], Integer pdx, Integer igen, Integer iseed[], double r[], Integer nr, NagError *fail);
 

  extern NAG_DLL_EXPIMP void NAG_CALL g05rac(Nag_OrderType order, Integer mode, Integer m, const double c[], Integer pdc, Integer n, double x[], Integer pdx, Integer igen, Integer iseed[], double r[], Integer lr, NagError *fail);
 

  extern NAG_DLL_EXPIMP void NAG_CALL g05rbc(Nag_OrderType order, Integer mode, Integer df, Integer m, const double c[], Integer pdc, Integer n, double x[], Integer pdx, Integer igen, Integer iseed[], double r[], Integer lr, NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL g05rcc(Nag_OrderType order, Nag_ModeRNG mode, Integer n, Integer df, Integer m, const double c[], Integer pdc, double r[], Integer lr, Integer state[], double x[], Integer pdx, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05rdc(Nag_OrderType order, Nag_ModeRNG mode, Integer n, Integer m, const double c[], Integer pdc, double r[], Integer lr, Integer state[], double x[], Integer pdx, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05rec(Nag_OrderType order, Integer state[], double theta, Integer n, double x[], Integer ldx, Integer tdx, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05rfc(Nag_OrderType order, Integer state[], double theta, Integer n, double x[], Integer ldx, Integer tdx, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05rgc(Nag_OrderType order, Integer state[], double theta, Integer n, double x[], Integer ldx, Integer tdx, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05rhc(Nag_OrderType order, Integer state[], double theta, Integer n, Integer m, double x[], Integer ldx, Integer tdx, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05rjc(Nag_OrderType order, Integer state[], double theta, Integer n, Integer m, double x[], Integer ldx, Integer tdx, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05rkc(Nag_OrderType order, Integer state[], double theta, Integer n, Integer m, double x[], Integer ldx, Integer tdx, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05ryc(Nag_OrderType order, Nag_ModeRNG mode, Integer n, Integer df, Integer m, const double xmu[], const double c[], Integer pdc, double r[], Integer lr, Integer state[], double x[], Integer pdx, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05rzc(Nag_OrderType order, Nag_ModeRNG mode, Integer n, Integer m, const double xmu[], const double c[], Integer pdc, double r[], Integer lr, Integer state[], double x[], Integer pdx, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05sac(Integer n, Integer state[], double x[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05sbc(Integer n, double a, double b, Integer state[], double x[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05scc(Integer n, double xmed, double semiqr, Integer state[], double x[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05sdc(Integer n, Integer df, Integer state[], double x[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05sec(Nag_OrderType order, Integer n, Integer m, const double a[], Integer state[], double x[], Integer pdx, NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL g05sfc(Integer n, double a, Integer state[], double x[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05sgc(Integer n, Integer nmix, const double a[], const double wgt[], Integer state[], double x[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05shc(Integer n, Integer df1, Integer df2, Integer state[], double x[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05sjc(Integer n, double a, double b, Integer state[], double x[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05skc(Integer n, double xmu, double var, Integer state[], double x[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05slc(Integer n, double a, double b, Integer state[], double x[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05smc(Integer n, double xmu, double var, Integer state[], double x[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05snc(Integer n, Integer df, Integer state[], double x[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05spc(Integer n, double xmin, double xmed, double xmax, Integer state[], double x[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05sqc(Integer n, double a, double b, Integer state[], double x[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05src(Integer n, double vk, Integer state[], double x[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05ssc(Integer n, double a, double b, Integer state[], double x[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05tac(Nag_ModeRNG mode, Integer n, Integer m, double p, double r[], Integer lr, Integer state[], Integer x[], NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL g05tbc(Integer n, double p, Integer state[], Nag_Boolean x[], NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL g05tcc(Nag_ModeRNG mode, Integer n, double p, double r[], Integer lr, Integer state[], Integer x[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05tdc(Nag_ModeRNG mode, Integer n, const double p[], Integer np, Integer ip1, Nag_DiscreteDistrib itype, double r[], Integer lr, Integer state[], Integer x[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05tec(Nag_ModeRNG mode, Integer n, Integer ns, Integer np, Integer m, double r[], Integer lr, Integer state[], Integer x[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05tfc(Nag_ModeRNG mode, Integer n, double a, double r[], Integer lr, Integer state[], Integer x[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05tgc(Nag_OrderType order, Nag_ModeRNG mode, Integer n, Integer m, Integer k, const double p[], double r[], Integer lr, Integer state[], Integer x[], Integer pdx, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05thc(Nag_ModeRNG mode, Integer n, Integer m, double p, double r[], Integer lr, Integer state[], Integer x[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05tjc(Nag_ModeRNG mode, Integer n, double lambda, double r[], Integer lr, Integer state[], Integer x[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05tkc(Integer m, const double vlamda[], Integer state[], Integer x[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05tlc(Integer n, Integer a, Integer b, Integer state[], Integer x[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05yac(Nag_QuasiRandom_State state,
              Nag_QuasiRandom_Sequence seq, Integer iskip, Integer idim, 
              double quasi[], Nag_QuasiRandom *GF, NagError *fail);


	extern NAG_DLL_EXPIMP void NAG_CALL g05ybc(Nag_QuasiRandom_State state,
     Nag_QuasiRandom_Sequence seq, Nag_Distributions dist, 
     const double mean[], const double std[], Integer iskip, Integer idim, 
     double quasi[], Nag_QuasiRandom *GF, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05ycc(Integer idim, Integer iref[],
                                             NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05ydc(Integer n, double quasi[],
                                             Integer iref[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05yec(Integer idim, Integer iref[],
                                             Integer iskip, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05yfc(Integer n, double quasi[],
                                             Integer iref[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05ygc(Integer idim, Integer iref[],
                                             Integer iskip, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05yhc(Integer n, double quasi[],
                                             Integer iref[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05yjc(Nag_OrderType order, const double xmean[],
                                             const double std[], Integer n,
                                             double quas[], Integer pdquas, Integer iref[],
                                             NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05ykc(Nag_OrderType order, const double xmean[],
                                             const double std[], Integer n,
                                             double quas[], Integer pdquas, Integer iref[],
                                             NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05ylc(Nag_QuasiRandom_Sequence genid,
                                             Integer idim, Integer iref[],
                                             Integer liref, Integer iskip,
                                             NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05ymc(Nag_OrderType order,Integer n,
                                             double quas[], Integer pdqua, 
                                             Integer iref[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g05ync(Nag_QuasiRandom_Sequence genid,
                                             Nag_QuasiRandom_Scrambling stype, Integer idim,
                                             Integer iref[], Integer liref, 
                                             Integer iskip, Integer nsdigi, 
                                             Integer state[], NagError *fail);

  extern  NAG_DLL_EXPIMP Nag_bg05ca_type NAG_CALL get_bg05ca(void);

  extern  NAG_DLL_EXPIMP Nag_dg05ca_type NAG_CALL get_dg05ca(void);


#ifdef NAGLIBANDSTINCLUDE
#include <nagg05aux.h>
 #endif
 


  /* end proto */
#ifdef __cplusplus
}
#endif
#endif /* not NAGG05 */
