/*
 * <nagg01.h>
 *
 * Copyright 1996 Numerical Algorithms Group
 *
 * Include file for NAG C Library g01 Chapter
 *
 * Mark 4, revised, 1996.
 * Mark 5 revised. IER-2155 (Feb 1998).
 * Mark 6 revised. IER-3040 (July 2000).
 * Mark 7 revised. IER-3903 (Feb 2001):
 *       "class" replaced by "class_ind" in the g01aec header,
 *       otherwise nagg01.h does not compile when used from C++.
 *
 */
#ifndef NAGG01
#define NAGG01
/// TD ML 06-10-2011 ORG-2987 NAG_HEADERS_OC_COMPILE
#ifndef _MSC_VER
	#pragma dll(ONAG8)
#endif // !_MSC_VER
/// end NAG_HEADERS_OC_COMPILE
#ifdef __cplusplus
extern "C"
{
#endif
  /* begin proto */
  extern NAG_DLL_EXPIMP
   void NAG_CALL g01aac(Integer n, const double x[], const double wt[], Integer *nvalid,
                                             double *xmean, double *xsd, double *xskew, double *xkurt,
                                             double *xmin, double *xmax, double *wsum, NagError *fail);


  extern NAG_DLL_EXPIMP void NAG_CALL g01adc(Integer k, const double x[], const Integer ifreq[], double *xmean, double *xsd, double *xskew, double *xkurt, Integer *n, NagError *fail);


  extern NAG_DLL_EXPIMP
   void NAG_CALL g01aec(Integer n, const double x[], Integer num_class, Nag_ClassBoundary class_ind,
                     double cint[], Integer ifreq[], double *xmin, double *xmax,
                     NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g01alc(Integer n,  const double x[], double res[],  NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g01amc(Integer n, double rv[], Integer nq, const double q[], double qv[], NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL g01bjc(Integer n,  double p,  Integer k,  double *plek,
                                             double *pgtk, double *peqk, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g01bkc(double rlamda,  Integer k,  double *plek,
                                             double *pgtk, double *peqk,  NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g01blc(Integer n, Integer l, Integer m, Integer k,  double *plek,
                                             double *pgtk, double *peqk,  NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL g01cec(double p, NagError *fail);


  extern NAG_DLL_EXPIMP void NAG_CALL g01dac(Integer n, double pp[], double etol, double *errest, NagError *fail);


  extern NAG_DLL_EXPIMP void NAG_CALL g01dcc(Integer n, double exp1, double exp2, double sumssq, double vec[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g01ddc(Integer n, const double x[],  Nag_Boolean calc_wts,  double a[],
                                             double *w, double *pw,  NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g01dhc(Nag_Scores scores, Nag_Ties ties, Integer n, const double x[],
                                             double r[], NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL g01eac(Nag_TailProbability tail,  double x,  NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL g01ebc(Nag_TailProbability tail, double t, double df, NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL g01ebf_f(const char *tail, double t, double df, Integer *ifail,
                         Integer tail_len);

  extern NAG_DLL_EXPIMP double NAG_CALL g01ecc(Nag_TailProbability tail, double x, double df, NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL g01edc(Nag_TailProbability tail, double f, double df1, double df2,
                                               NagError *fail);



  extern NAG_DLL_EXPIMP void NAG_CALL g01eec(double x, double a, double b, double tol, double *p,
                                             double *q, double *pdf, NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL g01efc(Nag_TailProbability tail, double g, double a, double b,
                                               NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL g01emc(double q, double v, Integer ir, NagError *fail);




  extern NAG_DLL_EXPIMP void NAG_CALL g01epc(Integer n, Integer ip, double d, double *pdl, double *pdu, NagError *fail);


  extern NAG_DLL_EXPIMP double NAG_CALL g01erc(double t, double vk, NagError *fail);


  extern NAG_DLL_EXPIMP double NAG_CALL g01etc(const double x);


  extern NAG_DLL_EXPIMP double NAG_CALL g01euc(double x, const double comm_arr[]);


  extern NAG_DLL_EXPIMP double NAG_CALL g01eyc(Integer n, double d, NagError *fail);


  extern NAG_DLL_EXPIMP double NAG_CALL g01ezc(Integer n1, Integer n2, double d, NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL g01fac(Nag_TailProbability tail,  double p,  NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL g01fbc(Nag_TailProbability tail, double p, double df, NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL g01fcc(double p, double df, NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL g01fdc(double p, double df1, double df2, NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL g01fec(double p, double a, double b, double tol, NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL g01ffc(double p, double a, double b, double tol, NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL g01fmc(double p, double v, Integer ir, NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL g01ftc(double x, NagError *fail);


  extern NAG_DLL_EXPIMP double NAG_CALL g01gbc(double t, double df, double delta, double tol,
                       Integer max_iter, NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL g01gcc(double x, double df, double lambda, double tol,
                       Integer max_iter, NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL g01gdc(double f, double df1, double df2, double lambda,
                       double tol, Integer max_iter, NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL g01gec(double x, double a, double b, double lambda,
                       double tol, Integer max_iter, NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL g01hac(double x, double y, double rho, NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL g01hbc(Nag_TailProbability tail, Integer n, const double a[], const double b[],
                       const double mean[], const double sigma[], Integer tdsig, double tol,
                       Integer maxpts,  NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g01jcc(const double a[], const Integer mult[], const double rlamda[], Integer n, double c, double *p, double *pdf, double tol, Integer maxit, NagError *fail);


  extern NAG_DLL_EXPIMP void NAG_CALL g01jdc(Nag_LCCMethod method, Integer n, const double rlam[], double d, double c, double *prob, NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL g01kac(double x, double xmean, double xvar, NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL g01kfc(double x, double a, double b, NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL g01mbc(double x);

  extern NAG_DLL_EXPIMP double NAG_CALL g01mtc(const double x);

  extern NAG_DLL_EXPIMP double NAG_CALL g01muc(double x, const double comm_arr[]);


  extern NAG_DLL_EXPIMP void NAG_CALL g01nac(Nag_OrderType order, Nag_SelectMoments mom, Nag_IncludeMean mean, Integer n, const double a[], Integer pda, const double emu[], const double sigma[], Integer pdsig, Integer l, double rkum[], double rmom[], NagError *fail);


  extern NAG_DLL_EXPIMP void NAG_CALL g01nbc(Nag_OrderType order, Nag_MomentType ratio_type, Nag_IncludeMean mean, Integer n, const double a[], Integer pda, const double b[], Integer pdb, const double c[], Integer pdc, const double ela[], const double emu[], const double sigma[], Integer pdsig, Integer l1, Integer l2, Integer *lmax, double rmom[], double *abserr, double eps, NagError *fail);


  extern NAG_DLL_EXPIMP double NAG_CALL g01ptc(double x);
 

  extern NAG_DLL_EXPIMP double NAG_CALL g01qtc(double x);
 

  extern NAG_DLL_EXPIMP double NAG_CALL g01rtc(double x);
 

  extern NAG_DLL_EXPIMP void NAG_CALL g01zuc(double rkappa, double beta2, Integer mode, double *xl, double *xu, double work[], NagError *fail);


#ifdef NAGLIBANDSTINCLUDE
#include <nagg01aux.h>
 #endif
 
  /* end proto */
#ifdef __cplusplus
}
#endif
#endif /* not NAGG01 */
