/* <nagf12.h>
 *
 * Copyright 2005 Numerical Algorithms Group
 *
 * Include file for NAG C Library f12 Chapter
 *
 * Mark 9, 2005.
 */
#ifndef NAGF12
#define NAGF12
/// TD ML 06-10-2011 ORG-2987 NAG_HEADERS_OC_COMPILE
#ifndef _MSC_VER
	#pragma dll(ONAG8)
#endif // !_MSC_VER
/// end NAG_HEADERS_OC_COMPILE
#ifdef __cplusplus
extern "C"
{
#endif
  /* begin proto */
  extern NAG_DLL_EXPIMP void NAG_CALL f12aac(Integer n, Integer nev,
                                             Integer ncv, Integer icomm[],
                                             Integer licomm, double comm[],
                                             Integer lcomm, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f12abc(Integer *irevcm, double resid[],
                                           double v[], double * *x,
                                           double * *y,
                                           double * *mx, Integer *nshift,
                                           double comm[], Integer icomm[],
                                           NagError *fail);
 

extern NAG_DLL_EXPIMP void NAG_CALL f12acc(Integer *nconv, double dr[],
                                           double di[], double z[],
                                           double sigmar, double sigmai,
                                           const double resid[], double v[],
                                           double comm[], Integer icomm[],
                                           NagError *fail);
 

extern NAG_DLL_EXPIMP void NAG_CALL f12adc(const char * str, Integer icomm[],
                                           double comm[], NagError *fail);
 

extern NAG_DLL_EXPIMP void NAG_CALL f12aec(Integer *niter, Integer *nconv,
                                           double ritzr[], double ritzi[],
                                           double rzest[], const Integer icomm[],
                                           const double comm[]);
 

extern NAG_DLL_EXPIMP void NAG_CALL f12afc(Integer n, Integer nev,
                                           Integer ncv, Integer icomm[],
                                           Integer licomm, double comm[],
                                           Integer lcomm, NagError *fail);
 

extern NAG_DLL_EXPIMP void NAG_CALL f12agc(Integer kl, Integer ku,
                                           const double ab[],
                                           const double mb[],
                                           double sigmar, double sigmai,
                                           Integer *nconv, double dr[],
                                           double di[], double z[],
                                           double resid[], double v[],
                                           double comm[], Integer icomm[],
                                           NagError *fail);
 

extern NAG_DLL_EXPIMP void NAG_CALL f12anc(Integer n, Integer nev,
                                           Integer ncv, Integer icomm[],
                                           Integer licomm, complex comm[],
                                           Integer lcomm, NagError *fail);
 

extern NAG_DLL_EXPIMP void NAG_CALL f12apc(Integer *irevcm, complex resid[],
                                           complex v[], complex * *x,
					   complex * *y,
                                           complex * *mx, Integer *nshift,
                                           complex comm[], Integer icomm[],
                                           NagError *fail);
 

extern NAG_DLL_EXPIMP void NAG_CALL f12aqc(Integer *nconv, complex d[],
                                           complex z[], complex sigma,
                                           const complex resid[], complex v[],
                                           complex comm[], Integer icomm[],
                                           NagError *fail);
 

extern NAG_DLL_EXPIMP void NAG_CALL f12arc(const char * str, Integer icomm[],
                                           complex comm[], NagError *fail);
 

extern NAG_DLL_EXPIMP void NAG_CALL f12asc(Integer *niter, Integer *nconv,
                                           complex ritz[], complex rzest[],
                                           const Integer icomm[],
                                           const complex comm[]);
 

extern NAG_DLL_EXPIMP void NAG_CALL f12fac(Integer n, Integer nev,
                                           Integer ncv, Integer icomm[],
                                           Integer licomm, double comm[],
                                           Integer lcomm, NagError *fail);
 

extern NAG_DLL_EXPIMP void NAG_CALL f12fbc(Integer *irevcm, double resid[], 
                                          double v[], double * *x,
                                           double * *y, double * *mx,
					   Integer *nshift,
                                           double comm[], Integer icomm[],
                                           NagError *fail);
 

extern NAG_DLL_EXPIMP void NAG_CALL f12fcc(Integer *nconv, double d[],
                                           double z[], double sigma,
                                           const double resid[], double v[],
                                           double comm[], Integer icomm[],
                                           NagError *fail);
 

extern NAG_DLL_EXPIMP void NAG_CALL f12fdc(const char * str, Integer icomm[],
                                           double comm[], NagError *fail);
 

extern NAG_DLL_EXPIMP void NAG_CALL f12fec(Integer *niter, Integer *nconv,
                                           double ritz[], double rzest[],
                                           const Integer icomm[],
                                           const double comm[]);
 

extern NAG_DLL_EXPIMP void NAG_CALL f12ffc(Integer n, Integer nev,
                                           Integer ncv, Integer icomm[],
                                           Integer licomm, double comm[],
                                           Integer lcomm, NagError *fail);
 

extern NAG_DLL_EXPIMP void NAG_CALL f12fgc(Integer kl, Integer ku,
                                           const double ab[],
                                           const double mb[],
                                           double sigma, Integer *nconv,
                                           double d[], double z[],
                                           double resid[], double v[],
                                           double comm[], Integer icomm[],
                                           NagError *fail);


#ifdef NAGLIBANDSTINCLUDE
#include <nagf12aux.h>
 #endif
 
  /* end proto */
#ifdef __cplusplus
}
#endif
#endif /* not NAGF12 */
