/* <nagf11.h>
 *
 * Copyright 1996 Numerical Algorithms Group
 *
 * Include file for NAG C Library f11 Chapter
 *
 * Mark 5, 1997.
 * Mark 6 revised. IER-3039 (July 2000).
 */
#ifndef NAGF11
#define NAGF11
/// TD ML 06-10-2011 ORG-2987 NAG_HEADERS_OC_COMPILE
#ifndef _MSC_VER
	#pragma dll(ONAG8)
#endif // !_MSC_VER
/// end NAG_HEADERS_OC_COMPILE
#ifdef __cplusplus
extern "C"
{
#endif
  /* begin proto */
  extern NAG_DLL_EXPIMP void NAG_CALL f11bdc(Nag_SparseNsym_Method method, Nag_SparseNsym_PrecType precon,
                                             Nag_NormType norm, Nag_SparseNsym_Weight weight, Integer iterm,
                                             Integer n, Integer m, double tol, Integer maxitn, double anorm,
                                             double sigmax, Integer monit, Integer *lwreq, double work[],
                                             Integer lwork, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f11bec(Integer *irevcm, double u[], double v[], const double wgt[],
                                             double work[], Integer lwork, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f11bfc(Integer *itn, double *stplhs, double *stprhs, double *anorm,
                                             double *sigmax, const double work[], Integer lwork,
                                             NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f11dac(Integer n, Integer nnz,  double **a,  Integer *la,
                                             Integer **irow, Integer **icol, Integer lfill,  double dtol,
                                             Nag_SparseNsym_Piv pstrat, Nag_SparseNsym_Fact milu, 
                                             Integer ipivp[], Integer ipivq[],
                                             Integer istr[], Integer idiag[], Integer *nnzc, Integer *npivm,
                                             NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f11dcc(Nag_SparseNsym_Method method,  Integer n, Integer nnz,  double a[],
                                             Integer la, Integer irow[], Integer icol[], Integer ipivp[],
                                             Integer ipivq[], Integer istr[], Integer idiag[],
                                             double b[],  Integer m,  double tol,  Integer maxitn,
                                             double x[], double *rnorm,  Integer *itn,
                                             Nag_Sparse_Comm *comm, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f11dec(Nag_SparseNsym_Method method, Nag_SparseNsym_PrecType precon,  
                                             Integer n, Integer nnz,
                                             double a[],  Integer irow[], Integer icol[],
                                             double omega, double b[],  Integer m,  double tol,
                                             Integer maxitn,  double x[], double *rnorm,
                                             Integer *itn, Nag_Sparse_Comm *comm, NagError *fail);


  extern NAG_DLL_EXPIMP void NAG_CALL f11dkc(Nag_SparseNsym_Store store, Nag_TransType trans,
                                             Nag_InitializeA init, Integer niter, Integer n, Integer nnz,
                                             const double a[], const Integer irow[], const Integer icol[],
                                             Nag_SparseNsym_CheckData check, const double b[], double x[],
                                             double diag[], NagError *fail);


  extern NAG_DLL_EXPIMP void NAG_CALL f11dnc(Integer n, Integer nnz, complex a[], Integer la, Integer irow[],
                                             Integer icol[], Integer lfill, double dtol,
                                             Nag_SparseNsym_Piv pstrat, Nag_SparseNsym_Fact milu, Integer ipivp[],
                                             Integer ipivq[], Integer istr[], Integer idiag[], Integer *nnzc,
                                             Integer *npivm, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f11dqc(Nag_SparseNsym_Method method, Integer n, Integer nnz, const complex a[],
                                             Integer la, const Integer irow[], const Integer icol[],
                                             const Integer ipivp[], const Integer ipivq[], const Integer istr[],
                                             const Integer idiag[], const complex b[], Integer m, double tol,
                                             Integer maxitn, complex x[], double *rnorm, Integer *itn, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f11dsc(Nag_SparseNsym_Method method, Nag_SparseNsym_PrecType precon, Integer n,
                                             Integer nnz, const complex a[], const Integer irow[], const Integer icol[],
                                             double omega, const complex b[], Integer m, double tol, Integer maxitn,
                                             complex x[], double *rnorm, Integer *itn, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f11dxc(Nag_SparseNsym_Store store, Nag_TransType trans, Nag_InitializeA init,
                                             Integer niter, Integer n, Integer nnz, const complex a[],
                                             const Integer irow[], const Integer icol[], Nag_SparseSym_CheckData check,
                                             const complex b[], complex x[], complex diag[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f11gdc(Nag_SparseNsym_Method method, Nag_SparseNsym_PrecType precon,
                                             Nag_SparseSym_Bisection sigcmp, Nag_NormType norm,
                                             Nag_SparseSym_Weight weight, Integer iterm, Integer n, double tol,
                                             Integer maxitn, double anorm, double sigmax, double sigtol, Integer maxits,
                                             Integer monit, Integer *lwreq, double work[], Integer lwork, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f11gec(Integer *irevcm, double u[], double v[], const double wgt[], double work[],
                                             Integer lwork, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f11gfc(Integer *itn, double *stplhs, double *stprhs, double *anorm, double *sigmax,
                                             Integer *its, double *sigerr, const double work[], Integer lwork,
                                             NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f11jac(Integer n, Integer nnz,  double **a,  Integer *la,
                                             Integer **irow, Integer **icol, Integer lfill,  double dtol,
                                             Nag_SparseSym_Fact mic,  double dscale,  Nag_SparseSym_Piv pstrat,
                                             Integer ipiv[], Integer istr[], Integer *nnzc, Integer *npivm,
                                             Nag_Sparse_Comm *comm, NagError *fail);


  extern NAG_DLL_EXPIMP void NAG_CALL f11jcc(Nag_SparseSym_Method method,  Integer n, Integer nnz,  double a[],
                                             Integer la, Integer irow[], Integer icol[], Integer ipiv[],
                                             Integer istr[],  double b[], double tol,
                                             Integer maxitn,  double x[], double *rnorm,
                                             Integer *itn, Nag_Sparse_Comm *comm, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f11jdc(Integer n, Integer nnz,  double a[],  Integer irow[],
                                             Integer icol[],  double rdiag[], double omega,
                                             Nag_SparseSym_CheckData check,  double y[], double x[],  Integer iwork[],
                                             NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f11jec(Nag_SparseSym_Method method, Nag_SparseSym_PrecType precon, 
                                             Integer n, Integer nnz,
                                             double a[],  Integer irow[], Integer icol[],
                                             double omega, double b[], double tol,
                                             Integer maxitn,  double x[], double *rnorm,
                                             Integer *itn, Nag_Sparse_Comm *comm, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f11jnc(Integer n, Integer nnz, complex a[], Integer la, Integer irow[],
                                             Integer icol[], Integer lfill, double dtol, Nag_SparseNsym_Fact mic,
                                             double dscale, Nag_SparseNsym_Piv pstrat, Integer ipiv[], Integer istr[],
                                             Integer *nnzc, Integer *npivm, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f11jqc(Nag_SparseNsym_Method method, Integer n, Integer nnz, const complex a[],
                                             Integer la, const Integer irow[], const Integer icol[], const Integer ipiv[],
                                             const Integer istr[], const complex b[], double tol, Integer maxitn,
                                             complex x[], double *rnorm, Integer *itn, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f11jsc(Nag_SparseNsym_Method method, Nag_SparseNsym_PrecType precon, Integer n,
                                             Integer nnz, const complex a[], const Integer irow[], const Integer icol[],
                                             double omega, const complex b[], double tol, Integer maxitn, complex x[],
                                             double *rnorm, Integer *itn, double rdiag[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f11mdc(Nag_ColumnPermutationType spec, 
					     Integer n, 
					     const Integer icolzp[], 
					     const Integer irowix[], 
					     Integer iprm[], 
					     NagError *fail);
 

  extern NAG_DLL_EXPIMP void NAG_CALL f11mec(Integer n, 
					     const Integer irowix[], 
					     const double a[], 
					     Integer iprm[], 
					     double thresh, 
					     Integer nzlmx, 
					     Integer *nzlumx, 
					     Integer nzumx, 
					     Integer il[], 
					     double lval[], 
					     Integer iu[], 
					     double uval[], 
					     Integer *nnzl, 
					     Integer *nnzu, 
					     double *flop, 
					     NagError *fail);
 

  extern NAG_DLL_EXPIMP void NAG_CALL f11mfc(Nag_OrderType order, 
					     Nag_TransType trans, 
					     Integer n, 
					     const Integer iprm[], 
					     const Integer il[], 
					     const double lval[], 
					     const Integer iu[], 
					     const double uval[], 
					     Integer nrhs, 
					     double b[], 
					     Integer pdb, 
					     NagError *fail);
 

  extern NAG_DLL_EXPIMP void NAG_CALL f11mgc(Nag_NormType norm, 
					     Integer n, 
					     const Integer il[], 
					     const double lval[], 
					     const Integer iu[], 
					     const double uval[], 
					     double anorm, 
					     double *rcond, 
					     NagError *fail);
 

  extern NAG_DLL_EXPIMP void NAG_CALL f11mhc(Nag_OrderType order, 
					     Nag_TransType trans, 
					     Integer n, 
					     const Integer icolzp[], 
					     const Integer irowix[], 
					     const double a[], 
					     const Integer iprm[], 
					     const Integer il[], 
					     const double lval[], 
					     const Integer iu[], 
					     const double uval[], 
					     Integer nrhs, 
					     const double b[], 
					     Integer pdb, 
					     double x[], 
					     Integer pdx, 
					     double ferr[], 
					     double berr[], 
					     NagError *fail);
 

  extern NAG_DLL_EXPIMP void NAG_CALL f11mkc(Nag_OrderType order, 
					     Nag_TransType trans, 
					     Integer n, 
					     Integer m, 
					     double alpha, 
					     const Integer icolzp[], 
					     const Integer irowix[], 
					     const double a[], 
					     const double b[], 
					     Integer pdb, 
					     double beta, 
					     double c[], 
					     Integer pdc, 
					     NagError *fail);
 

  extern NAG_DLL_EXPIMP void NAG_CALL f11mlc(Nag_NormType norm, 
					     double *anorm, 
					     Integer n, 
					     const Integer icolzp[], 
					     const Integer irowix[], 
					     const double a[], 
					     NagError *fail);
 

  extern NAG_DLL_EXPIMP void NAG_CALL f11mmc(Integer n, 
					     const Integer icolzp[], 
					     const double a[], 
					     const Integer iprm[], 
					     const Integer il[], 
					     const double lval[], 
					     const Integer iu[], 
					     const double uval[], 
					     double *rpg, 
					     NagError *fail);


  extern NAG_DLL_EXPIMP void NAG_CALL f11zac(Integer n, Integer *nnz,  double a[],  Integer irow[],
                                             Integer icol[],  Nag_SparseNsym_Dups dup,
                                             Nag_SparseNsym_Zeros zero,  Integer istr[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f11zbc(Integer n, Integer *nnz,  double a[],  Integer irow[],
                                             Integer icol[],  Nag_SparseSym_Dups dup, Nag_SparseSym_Zeros zero, Integer istr[],
                                             NagError *fail);


  extern NAG_DLL_EXPIMP void NAG_CALL f11znc(Integer n, Integer *nnz, complex a[], Integer irow[], Integer icol[],
                                             Nag_SparseNsym_Dups dup, Nag_SparseNsym_Zeros zero, Integer istr[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f11zpc(Integer n, Integer *nnz, complex a[], Integer irow[], Integer icol[],
                                             Nag_SparseNsym_Dups dup, Nag_SparseNsym_Zeros zero, Integer istr[], NagError *fail);

#ifdef NAGLIBANDSTINCLUDE
#include <nagf11aux.h>
 #endif

  /* end proto */
#ifdef __cplusplus
}
#endif
#endif /* not NAGF11 */
