/* <nagf08.h>
 *
 * Copyright 1996 Numerical Algorithms Group
 *
 * Include file for NAG C Library f08 Chapter
 *
 * Mark 5, 1997.
 * Mark 6 revised. IER-3038 (July 2000).
 */
#ifndef NAGF08
#define NAGF08
/// TD ML 06-10-2011 ORG-2987 NAG_HEADERS_OC_COMPILE
#ifndef _MSC_VER
	#pragma dll(ONAG8)
#endif // !_MSC_VER
/// end NAG_HEADERS_OC_COMPILE
#ifdef __cplusplus
extern "C"
{
#endif
  /* begin proto */
  extern NAG_DLL_EXPIMP void NAG_CALL f08aac(Nag_OrderType order, Nag_TransType trans, Integer m, Integer n, Integer nrhs, double a[], Integer pda, double b[], Integer pdb, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08aec(Nag_OrderType order, Integer m, Integer n, double a[], Integer pda, double tau[], NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08afc(Nag_OrderType order, Integer m, Integer n, Integer k, double a[], Integer pda, const double tau[], NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08agc(Nag_OrderType order, Nag_SideType side, Nag_TransType trans, Integer m, Integer n, Integer k, const double a[], Integer pda, const double tau[], double c[], Integer pdc, NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08ahc(Nag_OrderType order, Integer m, Integer n, double a[], Integer pda, double tau[], NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08ajc(Nag_OrderType order, Integer m, Integer n, Integer k, double a[], Integer pda, const double tau[], NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08akc(Nag_OrderType order, Nag_SideType side, Nag_TransType trans, Integer m, Integer n, Integer k, const double a[], Integer pda, const double tau[], double c[], Integer pdc, NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08anc(Nag_OrderType order, Nag_TransType trans, Integer m, Integer n, Integer nrhs, complex a[], Integer pda, complex b[], Integer pdb, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08asc(Nag_OrderType order, Integer m, Integer n, complex a[], Integer pda, complex tau[], NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08atc(Nag_OrderType order, Integer m, Integer n, Integer k, complex a[], Integer pda, const complex tau[], NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08auc(Nag_OrderType order, Nag_SideType side, Nag_TransType trans, Integer m, Integer n, Integer k, const complex a[], Integer pda, const complex tau[], complex c[], Integer pdc, NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08avc(Nag_OrderType order, Integer m, Integer n, complex a[], Integer pda, complex tau[], NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08awc(Nag_OrderType order, Integer m, Integer n, Integer k, complex a[], Integer pda, const complex tau[], NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08axc(Nag_OrderType order, Nag_SideType side, Nag_TransType trans, Integer m, Integer n, Integer k, const complex a[], Integer pda, const complex tau[], complex c[], Integer pdc, NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08bac(Nag_OrderType order, Integer m, Integer n, Integer nrhs, double a[], Integer pda, double b[], Integer pdb, Integer jpvt[], double rcond, Integer *rank, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08bec(Nag_OrderType order, Integer m, Integer n, double a[], Integer pda, Integer jpvt[], double tau[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08bfc(Nag_OrderType order, Integer m, Integer n, double a[], Integer pda, Integer jpvt[], double tau[], NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08bhc(Nag_OrderType order, Integer m, Integer n, double a[], Integer pda, double tau[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08bkc(Nag_OrderType order, Nag_SideType side, Nag_TransType trans, Integer m, Integer n, Integer k, Integer l, const double a[], Integer pda, const double tau[], double c[], Integer pdc, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08bnc(Nag_OrderType order, Integer m, Integer n, Integer nrhs, complex a[], Integer pda, complex b[], Integer pdb, Integer jpvt[], double rcond, Integer *rank, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08bsc(Nag_OrderType order, Integer m, Integer n, complex a[], Integer pda, Integer jpvt[], complex tau[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08btc(Nag_OrderType order, Integer m, Integer n, complex a[], Integer pda, Integer jpvt[], complex tau[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08bvc(Nag_OrderType order, Integer m, Integer n, complex a[], Integer pda, complex tau[], NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL f08bxc(Nag_OrderType order, Nag_SideType side, Nag_TransType trans, Integer m, Integer n, Integer k, Integer l, const complex a[], Integer pda, const complex tau[], complex c[], Integer pdc, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08cec(Nag_OrderType order, Integer m, Integer n, double a[], Integer pda, double tau[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08cfc(Nag_OrderType order, Integer m, Integer n, Integer k, double a[], Integer pda, const double tau[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08cgc(Nag_OrderType order, Nag_SideType side, Nag_TransType trans, Integer m, Integer n, Integer k, const double a[], Integer pda, const double tau[], double c[], Integer pdc, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08chc(Nag_OrderType order, Integer m, Integer n, double a[], Integer pda, double tau[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08cjc(Nag_OrderType order, Integer m, Integer n, Integer k, double a[], Integer pda, const double tau[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08ckc(Nag_OrderType order, Nag_SideType side, Nag_TransType trans, Integer m, Integer n, Integer k, double a[], Integer pda, const double tau[], double c[], Integer pdc, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08csc(Nag_OrderType order, Integer m, Integer n, complex a[], Integer pda, complex tau[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08ctc(Nag_OrderType order, Integer m, Integer n, Integer k, complex a[], Integer pda, const complex tau[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08cuc(Nag_OrderType order, Nag_SideType side, Nag_TransType trans, Integer m, Integer n, Integer k, const complex a[], Integer pda, const complex tau[], complex c[], Integer pdc, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08cvc(Nag_OrderType order, Integer m, Integer n, complex a[], Integer pda, complex tau[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08cwc(Nag_OrderType order, Integer m, Integer n, Integer k, complex a[], Integer pda, const complex tau[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08cxc(Nag_OrderType order, Nag_SideType side, Nag_TransType trans, Integer m, Integer n, Integer k, complex a[], Integer pda, const complex tau[], complex c[], Integer pdc, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08fac(Nag_OrderType order, Nag_JobType job, Nag_UploType uplo, Integer n, double a[], Integer pda, double w[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08fbc(Nag_OrderType order, Nag_JobType job, Nag_RangeType range, Nag_UploType uplo, Integer n, double a[], Integer pda, double vl, double vu, Integer il, Integer iu, double abstol, Integer *m, double w[], double z[], Integer pdz, Integer jfail[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08fcc(Nag_OrderType order, Nag_JobType job, Nag_UploType uplo, Integer n, double a[], Integer pda, double w[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08fdc(Nag_OrderType order, Nag_JobType job, Nag_RangeType range, Nag_UploType uplo, Integer n, double a[], Integer pda, double vl, double vu, Integer il, Integer iu, double abstol, Integer *m, double w[], double z[], Integer pdz, Integer isuppz[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08fec(Nag_OrderType order, Nag_UploType uplo, Integer n, double a[], Integer pda, double d[], double e[], double tau[], NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08ffc(Nag_OrderType order, Nag_UploType uplo, Integer n, double a[], Integer pda, const double tau[], NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08fgc(Nag_OrderType order, Nag_SideType side, Nag_UploType uplo, Nag_TransType trans, Integer m, Integer n, double a[], Integer pda, const double tau[], double c[], Integer pdc, NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08flc(Nag_JobType job, Integer m, Integer n, const double d[], double sep[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08fnc(Nag_OrderType order, Nag_JobType job, Nag_UploType uplo, Integer n, complex a[], Integer pda, double w[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08fpc(Nag_OrderType order, Nag_JobType job, Nag_RangeType range, Nag_UploType uplo, Integer n, complex a[], Integer pda, double vl, double vu, Integer il, Integer iu, double abstol, Integer *m, double w[], complex z[], Integer pdz, Integer jfail[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08fqc(Nag_OrderType order, Nag_JobType job, Nag_UploType uplo, Integer n, complex a[], Integer pda, double w[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08frc(Nag_OrderType order, Nag_JobType job, Nag_RangeType range, Nag_UploType uplo, Integer n, complex a[], Integer pda, double vl, double vu, Integer il, Integer iu, double abstol, Integer *m, double w[], complex z[], Integer pdz, Integer isuppz[], NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08fsc(Nag_OrderType order, Nag_UploType uplo, Integer n, complex a[], Integer pda, double d[], double e[], complex tau[], NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08ftc(Nag_OrderType order, Nag_UploType uplo, Integer n, complex a[], Integer pda, const complex tau[], NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08fuc(Nag_OrderType order, Nag_SideType side, Nag_UploType uplo, Nag_TransType trans, Integer m, Integer n, complex a[], Integer pda, const complex tau[], complex c[], Integer pdc, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08gac(Nag_OrderType order, Nag_JobType job, Nag_UploType uplo, Integer n, double ap[], double w[], double z[], Integer pdz, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08gbc(Nag_OrderType order, Nag_JobType job, Nag_RangeType range, Nag_UploType uplo, Integer n, double ap[], double vl, double vu, Integer il, Integer iu, double abstol, Integer *m, double w[], double z[], Integer pdz, Integer jfail[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08gcc(Nag_OrderType order, Nag_JobType job, Nag_UploType uplo, Integer n, double ap[], double w[], double z[], Integer pdz, NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08gec(Nag_OrderType order, Nag_UploType uplo, Integer n, double ap[], double d[], double e[], double tau[], NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08gfc(Nag_OrderType order, Nag_UploType uplo, Integer n, const double ap[], const double tau[], double q[], Integer pdq, NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08ggc(Nag_OrderType order, Nag_SideType side, Nag_UploType uplo, Nag_TransType trans, Integer m, Integer n, double ap[], const double tau[], double c[], Integer pdc, NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08gnc(Nag_OrderType order, Nag_JobType job, Nag_UploType uplo, Integer n, complex ap[], double w[], complex z[], Integer pdz, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08gpc(Nag_OrderType order, Nag_JobType job, Nag_RangeType range, Nag_UploType uplo, Integer n, complex ap[], double vl, double vu, Integer il, Integer iu, double abstol, Integer *m, double w[], complex z[], Integer pdz, Integer jfail[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08gqc(Nag_OrderType order, Nag_JobType job, Nag_UploType uplo, Integer n, complex ap[], double w[], complex z[], Integer pdz, NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08gsc(Nag_OrderType order, Nag_UploType uplo, Integer n, complex ap[], double d[], double e[], complex tau[], NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08gtc(Nag_OrderType order, Nag_UploType uplo, Integer n, const complex ap[], const complex tau[], complex q[], Integer pdq, NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08guc(Nag_OrderType order, Nag_SideType side, Nag_UploType uplo, Nag_TransType trans, Integer m, Integer n, complex ap[], const complex tau[], complex c[], Integer pdc, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08hac(Nag_OrderType order, Nag_JobType job, Nag_UploType uplo, Integer n, Integer kd, double ab[], Integer pdab, double w[], double z[], Integer pdz, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08hbc(Nag_OrderType order, Nag_JobType job, Nag_RangeType range, Nag_UploType uplo, Integer n, Integer kd, double ab[], Integer pdab, double q[], Integer pdq, double vl, double vu, Integer il, Integer iu, double abstol, Integer *m, double w[], double z[], Integer pdz, Integer jfail[], NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL f08hcc(Nag_OrderType order, Nag_JobType job, Nag_UploType uplo, Integer n, Integer kd, double ab[], Integer pdab, double w[], double z[], Integer pdz, NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08hec(Nag_OrderType order, Nag_VectType vect, Nag_UploType uplo, Integer n, Integer kd, double ab[], Integer pdab, double d[], double e[], double q[], Integer pdq, NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08hnc(Nag_OrderType order, Nag_JobType job, Nag_UploType uplo, Integer n, Integer kd, complex ab[], Integer pdab, double w[], complex z[], Integer pdz, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08hpc(Nag_OrderType order, Nag_JobType job, Nag_RangeType range, Nag_UploType uplo, Integer n, Integer kd, complex ab[], Integer pdab, complex q[], Integer pdq, double vl, double vu, Integer il, Integer iu, double abstol, Integer *m, double w[], complex z[], Integer pdz, Integer jfail[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08hqc(Nag_OrderType order, Nag_JobType job, Nag_UploType uplo, Integer n, Integer kd, complex ab[], Integer pdab, double w[], complex z[], Integer pdz, NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08hsc(Nag_OrderType order, Nag_VectType vect, Nag_UploType uplo, Integer n, Integer kd, complex ab[], Integer pdab, double d[], double e[], complex q[], Integer pdq, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08jac(Nag_OrderType order, Nag_JobType job, Integer n, double d[], double e[], double z[], Integer pdz, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08jbc(Nag_OrderType order, Nag_JobType job, Nag_RangeType range, Integer n, double d[], double e[], double vl, double vu, Integer il, Integer iu, double abstol, Integer *m, double w[], double z[], Integer pdz, Integer jfail[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08jcc(Nag_OrderType order, Nag_JobType job, Integer n, double d[], double e[], double z[], Integer pdz, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08jdc(Nag_OrderType order, Nag_JobType job, Nag_RangeType range, Integer n, double d[], double e[], double vl, double vu, Integer il, Integer iu, double abstol, Integer *m, double w[], double z[], Integer pdz, Integer isuppz[], NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08jec(Nag_OrderType order, Nag_ComputeZType compz, Integer n, double d[], double e[], double z[], Integer pdz, NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08jfc(Integer n, double d[], double e[], NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08jgc(Nag_OrderType order, Nag_ComputeZType compz, Integer n, double d[], double e[], double z[], Integer pdz, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08jhc(Nag_OrderType order, Nag_ComputeEigVecsType compz, Integer n, double d[], double e[], double z[], Integer pdz, NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL f08jjc(Nag_RangeType range, Nag_EigValRankType rank, Integer n, double vl, double vu, Integer il, Integer iu, double abstol, const double d[], const double e[], Integer *m, Integer *nsplit, double w[], Integer iblock[], Integer isplit[], NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08jkc(Nag_OrderType order, Integer n, const double d[], const double e[], Integer m, const double w[], const Integer iblock[], const Integer isplit[], double z[], Integer pdz, Integer ifailv[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08jlc(Nag_OrderType order, Nag_JobType job, Nag_RangeType range, Integer n, double d[], double e[], double vl, double vu, Integer il, Integer iu, double abstol, Integer *m, double w[], double z[], Integer pdz, Integer isuppz[], NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL f08jsc(Nag_OrderType order, Nag_ComputeZType compz, Integer n, double d[], double e[], complex z[], Integer pdz, NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08juc(Nag_OrderType order, Nag_ComputeZType compz, Integer n, double d[], double e[], complex z[], Integer pdz, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08jvc(Nag_OrderType order, Nag_ComputeEigVecsType compz, Integer n, double d[], double e[], complex z[], Integer pdz, NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08jxc(Nag_OrderType order, Integer n, const double d[], const double e[], Integer m, const double w[], const Integer iblock[], const Integer isplit[], complex z[], Integer pdz, Integer ifailv[], NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08jlc(Nag_OrderType order, Nag_JobType job, Nag_RangeType range, Integer n, double d[], double e[], double vl, double vu, Integer il, Integer iu, double abstol, Integer *m, double w[], double z[], Integer pdz, Integer isuppz[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08jyc(Nag_OrderType order, Nag_JobType job, Nag_RangeType range, Integer n, double d[], double e[], double vl, double vu, Integer il, Integer iu, double abstol, Integer *m, double w[], complex z[], Integer pdz, Integer isuppz[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08kac(Nag_OrderType order, Integer m, Integer n, Integer nrhs, double a[], Integer pda, double b[], Integer pdb, double s[], double rcond, Integer *rank, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08kbc(Nag_OrderType order, Nag_ComputeUType jobu, Nag_ComputeVTType jobvt, Integer m, Integer n, double a[], Integer pda, double s[], double u[], Integer pdu, double vt[], Integer pdvt, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08kcc(Nag_OrderType order, Integer m, Integer n, Integer nrhs, double a[], Integer pda, double b[], Integer pdb, double s[], double rcond, Integer *rank, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08kdc(Nag_OrderType order, Nag_JobType job, Integer m, Integer n, double a[], Integer pda, double s[], double u[], Integer pdu, double vt[], Integer pdvt, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08kec(Nag_OrderType order, Integer m, Integer n, double a[], Integer pda, double d[], double e[], double tauq[], double taup[], NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08kfc(Nag_OrderType order, Nag_VectType vect, Integer m, Integer n, Integer k, double a[], Integer pda, const double tau[], NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08kgc(Nag_OrderType order, Nag_VectType vect, Nag_SideType side, Nag_TransType trans, Integer m, Integer n, Integer k, const double a[], Integer pda, const double tau[], double c[], Integer pdc, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08knc(Nag_OrderType order, Integer m, Integer n, Integer nrhs, complex a[], Integer pda, complex b[], Integer pdb, double s[], double rcond, Integer *rank, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08kpc(Nag_OrderType order, Nag_ComputeUType jobu, Nag_ComputeVTType jobvt, Integer m, Integer n, complex a[], Integer pda, double s[], complex u[], Integer pdu, complex vt[], Integer pdvt, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08kqc(Nag_OrderType order, Integer m, Integer n, Integer nrhs, complex a[], Integer pda, complex b[], Integer pdb, double s[], double rcond, Integer *rank, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08krc(Nag_OrderType order, Nag_JobType job, Integer m, Integer n, complex a[], Integer pda, double s[], complex u[], Integer pdu, complex vt[], Integer pdvt, NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08ksc(Nag_OrderType order, Integer m, Integer n, complex a[], Integer pda, double d[], double e[], complex tauq[], complex taup[], NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08ktc(Nag_OrderType order, Nag_VectType vect, Integer m, Integer n, Integer k, complex a[], Integer pda, const complex tau[], NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08kuc(Nag_OrderType order, Nag_VectType vect, Nag_SideType side, Nag_TransType trans, Integer m, Integer n, Integer k, const complex a[], Integer pda, const complex tau[], complex c[], Integer pdc, NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08lec(Nag_OrderType order, Nag_VectType vect, Integer m, Integer n, Integer ncc, Integer kl, Integer ku, double ab[], Integer pdab, double d[], double e[], double q[], Integer pdq, double pt[], Integer pdpt, double c[], Integer pdc, NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08lsc(Nag_OrderType order, Nag_VectType vect, Integer m, Integer n, Integer ncc, Integer kl, Integer ku, complex ab[], Integer pdab, double d[], double e[], complex q[], Integer pdq, complex pt[], Integer pdpt, complex c[], Integer pdc, NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08mdc(Nag_OrderType order, Nag_UploType uplo, Nag_ComputeSingularVecsType compq, Integer n, double d[], double e[], double u[], Integer pdu, double vt[], Integer pdvt, double q[], Integer iq[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08mec(Nag_OrderType order, Nag_UploType uplo, Integer n, Integer ncvt, Integer nru, Integer ncc, double d[], double e[], double vt[], Integer pdvt, double u[], Integer pdu, double c[], Integer pdc, NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08msc(Nag_OrderType order, Nag_UploType uplo, Integer n, Integer ncvt, Integer nru, Integer ncc, double d[], double e[], complex vt[], Integer pdvt, complex u[], Integer pdu, complex c[], Integer pdc, NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08nac(Nag_OrderType order, Nag_LeftVecsType jobvl, Nag_RightVecsType jobvr, Integer n, double a[], Integer pda, double wr[], double wi[], double vl[], Integer pdvl, double vr[], Integer pdvr, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08nbc(Nag_OrderType order, Nag_BalanceType balanc, Nag_LeftVecsType jobvl, Nag_RightVecsType jobvr, Nag_RCondType sense, Integer n, double a[], Integer pda, double wr[], double wi[], double vl[], Integer pdvl, double vr[], Integer pdvr, Integer *ilo, Integer *ihi, double scale[], double *abnrm, double rconde[], double rcondv[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08nec(Nag_OrderType order, Integer n, Integer ilo, Integer ihi, double a[], Integer pda, double tau[], NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08nfc(Nag_OrderType order, Integer n, Integer ilo, Integer ihi, double a[], Integer pda, const double tau[], NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08ngc(Nag_OrderType order, Nag_SideType side, Nag_TransType trans, Integer m, Integer n, Integer ilo, Integer ihi, const double a[], Integer pda, const double tau[], double c[], Integer pdc, NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08nhc(Nag_OrderType order, Nag_JobType job, Integer n, double a[], Integer pda, Integer *ilo, Integer *ihi, double scale[], NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08njc(Nag_OrderType order, Nag_JobType job, Nag_SideType side, Integer n, Integer ilo, Integer ihi, const double scale[], Integer m, double v[], Integer pdv, NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08nnc(Nag_OrderType order, Nag_LeftVecsType jobvl, Nag_RightVecsType jobvr, Integer n, complex a[], Integer pda, complex w[], complex vl[], Integer pdvl, complex vr[], Integer pdvr, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08npc(Nag_OrderType order, Nag_BalanceType balanc, Nag_LeftVecsType jobvl, Nag_RightVecsType jobvr, Nag_RCondType sense, Integer n, complex a[], Integer pda, complex w[], complex vl[], Integer pdvl, complex vr[], Integer pdvr, Integer *ilo, Integer *ihi, double scale[], double *abnrm, double rconde[], double rcondv[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08nsc(Nag_OrderType order, Integer n, Integer ilo, Integer ihi, complex a[], Integer pda, complex tau[], NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08ntc(Nag_OrderType order, Integer n, Integer ilo, Integer ihi, complex a[], Integer pda, const complex tau[], NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08nuc(Nag_OrderType order, Nag_SideType side, Nag_TransType trans, Integer m, Integer n, Integer ilo, Integer ihi, const complex a[], Integer pda, const complex tau[], complex c[], Integer pdc, NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08nvc(Nag_OrderType order, Nag_JobType job, Integer n, complex a[], Integer pda, Integer *ilo, Integer *ihi, double scale[], NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08nwc(Nag_OrderType order, Nag_JobType job, Nag_SideType side, Integer n, Integer ilo, Integer ihi, const double scale[], Integer m, complex v[], Integer pdv, NagError *fail);

  /// TD ML 06-10-2011 ORG-2987 NAG_HEADERS_OC_COMPILE
  //extern NAG_DLL_EXPIMP void NAG_CALL f08pac(Nag_OrderType order, Nag_JobType job, Nag_SortEigValsType sort, Nag_Boolean (NAG_CALL *select)(const double wr, const double wi), Integer n, double a[], Integer pda, Integer *sdim, double wr[], double wi[], double vs[], Integer pdvs, NagError *fail);
  //extern NAG_DLL_EXPIMP void NAG_CALL f08pbc(Nag_OrderType order, Nag_JobType job, Nag_SortEigValsType sort, Nag_Boolean (NAG_CALL *select)(const double wr, const double wi), Nag_RCondType sense, Integer n, double a[], Integer pda, Integer *sdim, double wr[], double wi[], double vs[], Integer pdvs, double *rconde, double *rcondv, NagError *fail);
  typedef Nag_Boolean (NAG_CALL *PFN_f08pabc_select)(const double wr, const double wi);
  extern NAG_DLL_EXPIMP void NAG_CALL s(Nag_OrderType order, Nag_JobType job, Nag_SortEigValsType sort, PFN_f08pabc_select select, Integer n, double a[], Integer pda, Integer *sdim, double wr[], double wi[], double vs[], Integer pdvs, NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08pbc(Nag_OrderType order, Nag_JobType job, Nag_SortEigValsType sort, PFN_f08pabc_select select, Nag_RCondType sense, Integer n, double a[], Integer pda, Integer *sdim, double wr[], double wi[], double vs[], Integer pdvs, double *rconde, double *rcondv, NagError *fail);
  /// end NAG_HEADERS_OC_COMPILE
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08pec(Nag_OrderType order, Nag_JobType job, Nag_ComputeZType compz, Integer n, Integer ilo, Integer ihi, double h[], Integer pdh, double wr[], double wi[], double z[], Integer pdz, NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08pkc(Nag_OrderType order, Nag_SideType side, Nag_EigValsSourceType eig_source, Nag_InitVeenumtype initv, Nag_Boolean select[], Integer n, const double h[], Integer pdh, double wr[], const double wi[], double vl[], Integer pdvl, double vr[], Integer pdvr, Integer mm, Integer *m, Integer ifaill[], Integer ifailr[], NagError *fail);
 
  /// TD ML 06-10-2011 ORG-2987 NAG_HEADERS_OC_COMPILE
  //extern NAG_DLL_EXPIMP void NAG_CALL f08pnc(Nag_OrderType order, Nag_JobType job, Nag_SortEigValsType sort, Nag_Boolean (NAG_CALL *select)(const complex w), Integer n, complex a[], Integer pda, Integer *sdim, complex w[], complex vs[], Integer pdvs, NagError *fail);
  //extern NAG_DLL_EXPIMP void NAG_CALL f08ppc(Nag_OrderType order, Nag_JobType jobvs, Nag_SortEigValsType sort, Nag_Boolean (NAG_CALL *select)(const complex w), Nag_RCondType sense, Integer n, complex a[], Integer pda, Integer *sdim, complex w[], complex vs[], Integer pdvs, double *rconde, double *rcondv, NagError *fail);
  typedef Nag_Boolean (NAG_CALL *PFN_f08pnpc_select)(const complex w);
  extern NAG_DLL_EXPIMP void NAG_CALL f08pnc(Nag_OrderType order, Nag_JobType job, Nag_SortEigValsType sort, PFN_f08pnpc_select select, Integer n, complex a[], Integer pda, Integer *sdim, complex w[], complex vs[], Integer pdvs, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08ppc(Nag_OrderType order, Nag_JobType jobvs, Nag_SortEigValsType sort, PFN_f08pnpc_select select, Nag_RCondType sense, Integer n, complex a[], Integer pda, Integer *sdim, complex w[], complex vs[], Integer pdvs, double *rconde, double *rcondv, NagError *fail);
  /// end NAG_HEADERS_OC_COMPILE

  extern NAG_DLL_EXPIMP void NAG_CALL f08psc(Nag_OrderType order, Nag_JobType job, Nag_ComputeZType compz, Integer n, Integer ilo, Integer ihi, complex h[], Integer pdh, complex w[], complex z[], Integer pdz, NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08pxc(Nag_OrderType order, Nag_SideType side, Nag_EigValsSourceType eig_source, Nag_InitVeenumtype initv, const Nag_Boolean select[], Integer n, const complex h[], Integer pdh, complex w[], complex vl[], Integer pdvl, complex vr[], Integer pdvr, Integer mm, Integer *m, Integer ifaill[], Integer ifailr[], NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08qfc(Nag_OrderType order, Nag_ComputeQType compq, Integer n, double t[], Integer pdt, double q[], Integer pdq, Integer *ifst, Integer *ilst, NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08qgc(Nag_OrderType order, Nag_JobType job, Nag_ComputeQType compq, const Nag_Boolean select[], Integer n, double t[], Integer pdt, double q[], Integer pdq, double wr[], double wi[], Integer *m, double *s, double *sep, NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08qhc(Nag_OrderType order, Nag_TransType trana, Nag_TransType tranb, Nag_SignType sign, Integer m, Integer n, const double a[], Integer pda, const double b[], Integer pdb, double c[], Integer pdc, double *scale, NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08qkc(Nag_OrderType order, Nag_SideType side, Nag_HowManyType how_many, Nag_Boolean select[], Integer n, const double t[], Integer pdt, double vl[], Integer pdvl, double vr[], Integer pdvr, Integer mm, Integer *m, NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08qlc(Nag_OrderType order, Nag_JobType job, Nag_HowManyType how_many, const Nag_Boolean select[], Integer n, const double t[], Integer pdt, const double vl[], Integer pdvl, const double vr[], Integer pdvr, double s[], double sep[], Integer mm, Integer *m, NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08qtc(Nag_OrderType order, Nag_ComputeQType compq, Integer n, complex t[], Integer pdt, complex q[], Integer pdq, Integer ifst, Integer ilst, NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08quc(Nag_OrderType order, Nag_JobType job, Nag_ComputeQType compq, const Nag_Boolean select[], Integer n, complex t[], Integer pdt, complex q[], Integer pdq, complex w[], Integer *m, double *s, double *sep, NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08qvc(Nag_OrderType order, Nag_TransType trana, Nag_TransType tranb, Nag_SignType sign, Integer m, Integer n, const complex a[], Integer pda, const complex b[], Integer pdb, complex c[], Integer pdc, double *scal, NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08qxc(Nag_OrderType order, Nag_SideType side, Nag_HowManyType how_many, const Nag_Boolean select[], Integer n, complex t[], Integer pdt, complex vl[], Integer pdvl, complex vr[], Integer pdvr, Integer mm, Integer *m, NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08qyc(Nag_OrderType order, Nag_JobType job, Nag_HowManyType how_many, const Nag_Boolean select[], Integer n, const complex t[], Integer pdt, const complex vl[], Integer pdvl, const complex vr[], Integer pdvr, double s[], double sep[], Integer mm, Integer *m, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08sac(Nag_OrderType order, Integer itype, Nag_JobType job, Nag_UploType uplo, Integer n, double a[], Integer pda, double b[], Integer pdb, double w[], NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08sbc(Nag_OrderType order, Integer itype, Nag_JobType job, Nag_RangeType range, Nag_UploType uplo, Integer n, double a[], Integer pda, double b[], Integer pdb, double vl, double vu, Integer il, Integer iu, double abstol, Integer *m, double w[], double z[], Integer pdz, Integer jfail[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08scc(Nag_OrderType order, Integer itype, Nag_JobType job, Nag_UploType uplo, Integer n, double a[], Integer pda, double b[], Integer pdb, double w[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08sec(Nag_OrderType order, Nag_ComputeType comp_type, Nag_UploType uplo, Integer n, double a[], Integer pda, const double b[], Integer pdb, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08snc(Nag_OrderType order, Integer itype, Nag_JobType job, Nag_UploType uplo, Integer n, complex a[], Integer pda, complex b[], Integer pdb, double w[], NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08spc(Nag_OrderType order, Integer itype, Nag_JobType job, Nag_RangeType range, Nag_UploType uplo, Integer n, complex a[], Integer pda, complex b[], Integer pdb, double vl, double vu, Integer il, Integer iu, double abstol, Integer *m, double w[], complex z[], Integer pdz, Integer jfail[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08sqc(Nag_OrderType order, Integer itype, Nag_JobType job, Nag_UploType uplo, Integer n, complex a[], Integer pda, complex b[], Integer pdb, double w[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08ssc(Nag_OrderType order, Nag_ComputeType comp_type, Nag_UploType uplo, Integer n, complex a[], Integer pda, const complex b[], Integer pdb, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08tac(Nag_OrderType order, Integer itype, Nag_JobType job, Nag_UploType uplo, Integer n, double ap[], double bp[], double w[], double z[], Integer pdz, NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08tbc(Nag_OrderType order, Integer itype, Nag_JobType job, Nag_RangeType range, Nag_UploType uplo, Integer n, double ap[], double bp[], double vl, double vu, Integer il, Integer iu, double abstol, Integer *m, double w[], double z[], Integer pdz, Integer jfail[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08tcc(Nag_OrderType order, Integer itype, Nag_JobType job, Nag_UploType uplo, Integer n, double ap[], double bp[], double w[], double z[], Integer pdz, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08tec(Nag_OrderType order, Nag_ComputeType comp_type, Nag_UploType uplo, Integer n, double ap[], const double bp[], NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08tnc(Nag_OrderType order, Integer itype, Nag_JobType job, Nag_UploType uplo, Integer n, complex ap[], complex bp[], double w[], complex z[], Integer pdz, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08tpc(Nag_OrderType order, Integer itype, Nag_JobType job, Nag_RangeType range, Nag_UploType uplo, Integer n, complex ap[], complex bp[], double vl, double vu, Integer il, Integer iu, double abstol, Integer *m, double w[], complex z[], Integer pdz, Integer jfail[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08tqc(Nag_OrderType order, Integer itype, Nag_JobType job, Nag_UploType uplo, Integer n, complex ap[], complex bp[], double w[], complex z[], Integer pdz, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08tsc(Nag_OrderType order, Nag_ComputeType comp_type, Nag_UploType uplo, Integer n, complex ap[], const complex bp[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08ubc(Nag_OrderType order, Nag_JobType job, Nag_RangeType range, Nag_UploType uplo, Integer n, Integer ka, Integer kb, double ab[], Integer pdab, double bb[], Integer pdbb, double q[], Integer pdq, double vl, double vu, Integer il, Integer iu, double abstol, Integer *m, double w[], double z[], Integer pdz, Integer jfail[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08uac(Nag_OrderType order, Nag_JobType job, Nag_UploType uplo, Integer n, Integer ka, Integer kb, double ab[], Integer pdab, double bb[], Integer pdbb, double w[], double z[], Integer pdz, NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08ucc(Nag_OrderType order, Nag_JobType job, Nag_UploType uplo, Integer n, Integer ka, Integer kb, double ab[], Integer pdab, double bb[], Integer pdbb, double w[], double z[], Integer pdz, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08uec(Nag_OrderType order, Nag_VectType vect, Nag_UploType uplo, Integer n, Integer ka, Integer kb, double ab[], Integer pdab, const double bb[], Integer pdbb, double x[], Integer pdx, NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08ufc(Nag_OrderType order, Nag_UploType uplo, Integer n, Integer kb, double bb[], Integer pdbb, NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08unc(Nag_OrderType order, Nag_JobType job, Nag_UploType uplo, Integer n, Integer ka, Integer kb, complex ab[], Integer pdab, complex bb[], Integer pdbb, double w[], complex z[], Integer pdz, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08upc(Nag_OrderType order, Nag_JobType job, Nag_RangeType range, Nag_UploType uplo, Integer n, Integer ka, Integer kb, complex ab[], Integer pdab, complex bb[], Integer pdbb, complex q[], Integer pdq, double vl, double vu, Integer il, Integer iu, double abstol, Integer *m, double w[], complex z[], Integer pdz, Integer jfail[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08uqc(Nag_OrderType order, Nag_JobType job, Nag_UploType uplo, Integer n, Integer ka, Integer kb, complex ab[], Integer pdab, complex bb[], Integer pdbb, double w[], complex z[], Integer pdz, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08usc(Nag_OrderType order, Nag_VectType vect, Nag_UploType uplo, Integer n, Integer ka, Integer kb, complex ab[], Integer pdab, const complex bb[], Integer pdbb, complex x[], Integer pdx, NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08utc(Nag_OrderType order, Nag_UploType uplo, Integer n, Integer kb, complex bb[], Integer pdbb, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08vac(Nag_OrderType order, Nag_ComputeUType jobu, Nag_ComputeVType jobv, Nag_ComputeQType jobq, Integer m, Integer n, Integer p, Integer *k, Integer *l, double a[], Integer pda, double b[], Integer pdb, double alpha[], double beta[], double u[], Integer pdu, double v[], Integer pdv, double q[], Integer pdq, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08vec(Nag_OrderType order, Nag_ComputeUType jobu, Nag_ComputeVType jobv, Nag_ComputeQType jobq, Integer m, Integer p, Integer n, double a[], Integer pda, double b[], Integer pdb, double tola, double tolb, Integer *k, Integer *l, double u[], Integer pdu, double v[], Integer pdv, double q[], Integer pdq, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08vnc(Nag_OrderType order, Nag_ComputeUType jobu, Nag_ComputeVType jobv, Nag_ComputeQType jobq, Integer m, Integer n, Integer p, Integer *k, Integer *l, complex a[], Integer pda, complex b[], Integer pdb, double alpha[], double beta[], complex u[], Integer pdu, complex v[], Integer pdv, complex q[], Integer pdq, NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL f08vsc(Nag_OrderType order, Nag_ComputeUType jobu, Nag_ComputeVType jobv, Nag_ComputeQType jobq, Integer m, Integer p, Integer n, complex a[], Integer pda, complex b[], Integer pdb, double tola, double tolb, Integer *k, Integer *l, complex u[], Integer pdu, complex v[], Integer pdv, complex q[], Integer pdq, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08wac(Nag_OrderType order, Nag_LeftVecsType jobvl, Nag_RightVecsType jobvr, Integer n, double a[], Integer pda, double b[], Integer pdb, double alphar[], double alphai[], double beta[], double vl[], Integer pdvl, double vr[], Integer pdvr, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08wbc(Nag_OrderType order, Nag_BalanceType balanc, Nag_LeftVecsType jobvl, Nag_RightVecsType jobvr, Nag_RCondType sense, Integer n, double a[], Integer pda, double b[], Integer pdb, double alphar[], double alphai[], double beta[], double vl[], Integer pdvl, double vr[], Integer pdvr, Integer *ilo, Integer *ihi, double lscale[], double rscale[], double *abnrm, double *bbnrm, double rconde[], double rcondv[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08wec(Nag_OrderType order, Nag_ComputeQType compq, Nag_ComputeZType compz, Integer n, Integer ilo, Integer ihi, double a[], Integer pda, double b[], Integer pdb, double q[], Integer pdq, double z[], Integer pdz, NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08whc(Nag_OrderType order, Nag_JobType job, Integer n, double a[], Integer pda, double b[], Integer pdb, Integer *ilo, Integer *ihi, double lscale[], double rscale[], NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08wjc(Nag_OrderType order, Nag_JobType job, Nag_SideType side, Integer n, Integer ilo, Integer ihi, const double lscale[], const double rscale[], Integer m, double v[], Integer pdv, NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08wnc(Nag_OrderType order, Nag_LeftVecsType jobvl, Nag_RightVecsType jobvr, Integer n, complex a[], Integer pda, complex b[], Integer pdb, complex alpha[], complex beta[], complex vl[], Integer pdvl, complex vr[], Integer pdvr, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08wpc(Nag_OrderType order, Nag_BalanceType balanc, Nag_LeftVecsType jobvl, Nag_RightVecsType jobvr, Nag_RCondType sense, Integer n, complex a[], Integer pda, complex b[], Integer pdb, complex alpha[], complex beta[], complex vl[], Integer pdvl, complex vr[], Integer pdvr, Integer *ilo, Integer *ihi, double lscale[], double rscale[], double *abnrm, double *bbnrm, double rconde[], double rcondv[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08wsc(Nag_OrderType order, Nag_ComputeQType compq, Nag_ComputeZType compz, Integer n, Integer ilo, Integer ihi, complex a[], Integer pda, complex b[], Integer pdb, complex q[], Integer pdq, complex z[], Integer pdz, NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08wvc(Nag_OrderType order, Nag_JobType job, Integer n, complex a[], Integer pda, complex b[], Integer pdb, Integer *ilo, Integer *ihi, double lscale[], double rscale[], NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08wwc(Nag_OrderType order, Nag_JobType job, Nag_SideType side, Integer n, Integer ilo, Integer ihi, const double lscale[], const double rscale[], Integer m, complex v[], Integer pdv, NagError *fail);
 
  /// TD ML 06-10-2011 ORG-2987 NAG_HEADERS_OC_COMPILE
  //extern NAG_DLL_EXPIMP void NAG_CALL f08xac(Nag_OrderType order, Nag_LeftVecsType jobvsl, Nag_RightVecsType jobvsr, Nag_SortEigValsType sort, Nag_Boolean (NAG_CALL *selctg)(const double ar, const double ai, const double b), Integer n, double a[], Integer pda, double b[], Integer pdb, Integer *sdim, double alphar[], double alphai[], double beta[], double vsl[], Integer pdvsl, double vsr[], Integer pdvsr, NagError *fail);
  //extern NAG_DLL_EXPIMP void NAG_CALL f08xbc(Nag_OrderType order, Nag_LeftVecsType jobvsl, Nag_RightVecsType jobvsr, Nag_SortEigValsType sort, Nag_Boolean (NAG_CALL *selctg)(const double ar, const double ai, const double b), Nag_RCondType sense, Integer n, double a[], Integer pda, double b[], Integer pdb, Integer *sdim, double alphar[], double alphai[], double beta[], double vsl[], Integer pdvsl, double vsr[], Integer pdvsr, double rconde[], double rcondv[], NagError *fail);
  typedef Nag_Boolean (NAG_CALL *PFN_f08xabc_selctg)(const double ar, const double ai, const double b);
  extern NAG_DLL_EXPIMP void NAG_CALL f08xac(Nag_OrderType order, Nag_LeftVecsType jobvsl, Nag_RightVecsType jobvsr, Nag_SortEigValsType sort, PFN_f08xabc_selctg selctg, Integer n, double a[], Integer pda, double b[], Integer pdb, Integer *sdim, double alphar[], double alphai[], double beta[], double vsl[], Integer pdvsl, double vsr[], Integer pdvsr, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08xbc(Nag_OrderType order, Nag_LeftVecsType jobvsl, Nag_RightVecsType jobvsr, Nag_SortEigValsType sort, PFN_f08xabc_selctg selctg, Nag_RCondType sense, Integer n, double a[], Integer pda, double b[], Integer pdb, Integer *sdim, double alphar[], double alphai[], double beta[], double vsl[], Integer pdvsl, double vsr[], Integer pdvsr, double rconde[], double rcondv[], NagError *fail);
  /// end NAG_HEADERS_OC_COMPILE

  extern NAG_DLL_EXPIMP void NAG_CALL f08xec(Nag_OrderType order, Nag_JobType job, Nag_ComputeQType compq, Nag_ComputeZType compz, Integer n, Integer ilo, Integer ihi, double a[], Integer pda, double b[], Integer pdb, double alphar[], double alphai[], double beta[], double q[], Integer pdq, double z[], Integer pdz, NagError *fail);
 
  /// TD ML 06-10-2011 ORG-2987 NAG_HEADERS_OC_COMPILE
  //extern NAG_DLL_EXPIMP void NAG_CALL f08xnc(Nag_OrderType order, Nag_LeftVecsType jobvsl, Nag_RightVecsType jobvsr, Nag_SortEigValsType sort, Nag_Boolean (NAG_CALL *selctg)(const complex a, const complex b), Integer n, complex a[], Integer pda, complex b[], Integer pdb, Integer *sdim, complex alpha[], complex beta[], complex vsl[], Integer pdvsl, complex vsr[], Integer pdvsr, NagError *fail);
  //extern NAG_DLL_EXPIMP void NAG_CALL f08xpc(Nag_OrderType order, Nag_LeftVecsType jobvsl, Nag_RightVecsType jobvsr, Nag_SortEigValsType sort, Nag_Boolean (NAG_CALL *selctg)(const complex a, const complex b), Nag_RCondType sense, Integer n, complex a[], Integer pda, complex b[], Integer pdb, Integer *sdim, complex alpha[], complex beta[], complex vsl[], Integer pdvsl, complex vsr[], Integer pdvsr, double rconde[], double rcondv[], NagError *fail);
  typedef Nag_Boolean (NAG_CALL *PFN_f08xnpc_selctg)(const complex a, const complex b);
  extern NAG_DLL_EXPIMP void NAG_CALL f08xnc(Nag_OrderType order, Nag_LeftVecsType jobvsl, Nag_RightVecsType jobvsr, Nag_SortEigValsType sort, PFN_f08xnpc_selctg selctg, Integer n, complex a[], Integer pda, complex b[], Integer pdb, Integer *sdim, complex alpha[], complex beta[], complex vsl[], Integer pdvsl, complex vsr[], Integer pdvsr, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08xpc(Nag_OrderType order, Nag_LeftVecsType jobvsl, Nag_RightVecsType jobvsr, Nag_SortEigValsType sort, PFN_f08xnpc_selctg selctg, Nag_RCondType sense, Integer n, complex a[], Integer pda, complex b[], Integer pdb, Integer *sdim, complex alpha[], complex beta[], complex vsl[], Integer pdvsl, complex vsr[], Integer pdvsr, double rconde[], double rcondv[], NagError *fail);
  /// end NAG_HEADERS_OC_COMPILE

  extern NAG_DLL_EXPIMP void NAG_CALL f08xsc(Nag_OrderType order, Nag_JobType job, Nag_ComputeQType compq, Nag_ComputeZType compz, Integer n, Integer ilo, Integer ihi, complex a[], Integer pda, complex b[], Integer pdb, complex alpha[], complex beta[], complex q[], Integer pdq, complex z[], Integer pdz, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08yec(Nag_OrderType order, Nag_ComputeUType jobu, Nag_ComputeVType jobv, Nag_ComputeQType jobq, Integer m, Integer p, Integer n, Integer k, Integer l, double a[], Integer pda, double b[], Integer pdb, double tola, double tolb, double alpha[], double beta[], double u[], Integer pdu, double v[], Integer pdv, double q[], Integer pdq, Integer *ncycle, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08yfc(Nag_OrderType order, Nag_Boolean wantq, Nag_Boolean wantz, Integer n, double a[], Integer pda, double b[], Integer pdb, double q[], Integer pdq, double z[], Integer pdz, Integer *ifst, Integer *ilst, NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08ygc(Nag_OrderType order, Integer ijob, Nag_Boolean wantq, Nag_Boolean wantz, const Nag_Boolean select[], Integer n, double a[], Integer pda, double b[], Integer pdb, double alphar[], double alphai[], double beta[], double q[], Integer pdq, double z[], Integer pdz, Integer *m, double *pl, double *pr, double dif[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08yhc(Nag_OrderType order, Nag_TransType trans, Integer ijob, Integer m, Integer n, const double a[], Integer pda, const double b[], Integer pdb, double c[], Integer pdc, const double d[], Integer pdd, const double e[], Integer pde, double f[], Integer pdf, double *dif, double *scale, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08ykc(Nag_OrderType order, Nag_SideType side, Nag_HowManyType how_many, const Nag_Boolean select[], Integer n, const double a[], Integer pda, const double b[], Integer pdb, double vl[], Integer pdvl, double vr[], Integer pdvr, Integer mm, Integer *m, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08ylc(Nag_OrderType order, Nag_JobType job, Nag_HowManyType how_many, const Nag_Boolean select[], Integer n, const double a[], Integer pda, const double b[], Integer pdb, const double vl[], Integer pdvl, const double vr[], Integer pdvr, double s[], double dif[], Integer mm, Integer *m, NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL f08ysc(Nag_OrderType order, Nag_ComputeUType jobu, Nag_ComputeVType jobv, Nag_ComputeQType jobq, Integer m, Integer p, Integer n, Integer k, Integer l, complex a[], Integer pda, complex b[], Integer pdb, double tola, double tolb, double alpha[], double beta[], complex u[], Integer pdu, complex v[], Integer pdv, complex q[], Integer pdq, Integer *ncycle, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08ytc(Nag_OrderType order, Nag_Boolean wantq, Nag_Boolean wantz, Integer n, complex a[], Integer pda, complex b[], Integer pdb, complex q[], Integer pdq, complex z[], Integer pdz, Integer ifst, Integer *ilst, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08yuc(Nag_OrderType order, Integer ijob, Nag_Boolean wantq, Nag_Boolean wantz, const Nag_Boolean select[], Integer n, complex a[], Integer pda, complex b[], Integer pdb, complex alpha[], complex beta[], complex q[], Integer pdq, complex z[], Integer pdz, Integer *m, double *pr, double *pl, double dif[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08yvc(Nag_OrderType order, Nag_TransType trans, Integer ijob, Integer m, Integer n, const complex a[], Integer pda, const complex b[], Integer pdb, complex c[], Integer pdc, const complex d[], Integer pdd, const complex e[], Integer pde, complex f[], Integer pdf, double *dif, double *scale, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08yxc(Nag_OrderType order, Nag_SideType side, Nag_HowManyType how_many, const Nag_Boolean select[], Integer n, const complex a[], Integer pda, const complex b[], Integer pdb, complex vl[], Integer pdvl, complex vr[], Integer pdvr, Integer mm, Integer *m, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08yyc(Nag_OrderType order, Nag_JobType job, Nag_HowManyType how_many, const Nag_Boolean select[], Integer n, const complex a[], Integer pda, const complex b[], Integer pdb, const complex vl[], Integer pdvl, const complex vr[], Integer pdvr, double s[], double dif[], Integer mm, Integer *m, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08zac(Nag_OrderType order, Integer m, Integer n, Integer p, double a[], Integer pda, double b[], Integer pdb, double c[], double d[], double x[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08zbc(Nag_OrderType order, Integer m, Integer n, Integer p, double a[], Integer pda, double b[], Integer pdb, double d[], double x[], double y[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08zec(Nag_OrderType order, Integer n, Integer m, Integer p, double a[], Integer pda, double taua[], double b[], Integer pdb, double taub[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08zfc(Nag_OrderType order, Integer m, Integer p, Integer n, double a[], Integer pda, double taua[], double b[], Integer pdb, double taub[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08znc(Nag_OrderType order, Integer m, Integer n, Integer p, complex a[], Integer pda, complex b[], Integer pdb, complex c[], complex d[], complex x[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08zpc(Nag_OrderType order, Integer m, Integer n, Integer p, complex a[], Integer pda, complex b[], Integer pdb, complex d[], complex x[], complex y[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08zsc(Nag_OrderType order, Integer n, Integer m, Integer p, complex a[], Integer pda, complex taua[], complex b[], Integer pdb, complex taub[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f08ztc(Nag_OrderType order, Integer m, Integer p, Integer n, complex a[], Integer pda, complex taua[], complex b[], Integer pdb, complex taub[], NagError *fail);

#ifdef NAGLIBANDSTINCLUDE
#include <nagf08aux.h>
 #endif

  /* end proto */
#ifdef __cplusplus
}
#endif
#endif /* not NAGF08 */
