/* <nagf04.h>
 *
 * Copyright 1996 Numerical Algorithms Group
 *
 * Include file for NAG C Library f04 Chapter
 *
 * Mark 4, revised, 1996.
 * Mark 5 revised. IER-2152 (Feb 1998).
 * Mark 6 revised. IER-3035 (July 2000).
 */
#ifndef NAGF04
#define NAGF04
/// TD ML 06-10-2011 ORG-2987 NAG_HEADERS_OC_COMPILE
#ifndef _MSC_VER
	#pragma dll(ONAG8)
#endif // !_MSC_VER
/// end NAG_HEADERS_OC_COMPILE
#ifdef __cplusplus
extern "C"
{
#endif
  /* begin proto */
  extern NAG_DLL_EXPIMP
    void NAG_CALL f04adc(Integer n, Integer nrhs, complex *a, Integer tda, complex *b,
                         Integer tdb, complex *x, Integer tdx, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f04agc(Integer n, Integer nrhs, double *a, Integer tda, double *p, 
                                             double *b, Integer tdb, double *x, Integer tdx, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f04ajc(Integer n, Integer nrhs, double *a, 
                                             Integer tda, Integer *pivot, double *b, Integer tdb, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f04akc(Integer n, Integer nrhs, complex *a, Integer tda, Integer *pivot,
                                             complex *b, Integer tdb, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f04arc(Integer n, double *a, Integer tda, double *b, 
                                             double *x, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f04awc(Integer n, Integer nrhs, complex *a, Integer tda, double *p,
                                             complex *b, Integer tdb, complex *x, Integer tdx, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f04bac(Nag_OrderType order, Integer n, Integer nrhs, double a[], Integer pda, Integer ipiv[], double b[], Integer pdb, double *rcond, double *errbnd, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f04bbc(Nag_OrderType order, Integer n, Integer kl, Integer ku, Integer nrhs, double ab[], Integer pdab, Integer ipiv[], double b[], Integer pdb, double *rcond, double *errbnd, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f04bcc(Nag_OrderType order, Integer n, Integer nrhs, double dl[], double d[], double du[], double du2[], Integer ipiv[], double b[], Integer pdb, double *rcond, double *errbnd, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f04bdc(Nag_OrderType order, Nag_UploType uplo, Integer n, Integer nrhs, double a[], Integer pda, double b[], Integer pdb, double *rcond, double *errbnd, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f04bec(Nag_OrderType order, Nag_UploType uplo, Integer n, Integer nrhs, double ap[], double b[], Integer pdb, double *rcond, double *errbnd, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f04bfc(Nag_OrderType order, Nag_UploType uplo, Integer n, Integer kd, Integer nrhs, double ab[], Integer pdab, double b[], Integer pdb, double *rcond, double *errbnd, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f04bgc(Nag_OrderType order, Integer n, Integer nrhs, double d[], double e[], double b[], Integer pdb, double *rcond, double *errbnd, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f04bhc(Nag_OrderType order, Nag_UploType uplo, Integer n, Integer nrhs, double a[], Integer pda, Integer ipiv[], double b[], Integer pdb, double *rcond, double *errbnd, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f04bjc(Nag_OrderType order, Nag_UploType uplo, Integer n, Integer nrhs, double ap[], Integer ipiv[], double b[], Integer pdb, double *rcond, double *errbnd, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f04cac(Nag_OrderType order, Integer n, Integer nrhs, complex a[], Integer pda, Integer ipiv[], complex b[], Integer pdb, double *rcond, double *errbnd, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f04cbc(Nag_OrderType order, Integer n, Integer kl, Integer ku, Integer nrhs, complex ab[], Integer pdab, Integer ipiv[], complex b[], Integer pdb, double *rcond, double *errbnd, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f04ccc(Nag_OrderType order, Integer n, Integer nrhs, complex dl[], complex d[], complex du[], complex du2[], Integer ipiv[], complex b[], Integer pdb, double *rcond, double *errbnd, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f04cdc(Nag_OrderType order, Nag_UploType uplo, Integer n, Integer nrhs, complex a[], Integer pda, complex b[], Integer pdb, double *rcond, double *errbnd, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f04cec(Nag_OrderType order, Nag_UploType uplo, Integer n, Integer nrhs, complex ap[], complex b[], Integer pdb, double *rcond, double *errbnd, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f04cfc(Nag_OrderType order, Nag_UploType uplo, Integer n, Integer kd, Integer nrhs, complex ab[], Integer pdab, complex b[], Integer pdb, double *rcond, double *errbnd, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f04cgc(Nag_OrderType order, Integer n, Integer nrhs, double d[], complex e[], complex b[], Integer pdb, double *rcond, double *errbnd, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f04chc(Nag_OrderType order, Nag_UploType uplo, Integer n, Integer nrhs, complex a[], Integer pda, Integer ipiv[], complex b[], Integer pdb, double *rcond, double *errbnd, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f04cjc(Nag_OrderType order, Nag_UploType uplo, Integer n, Integer nrhs, complex ap[], Integer ipiv[], complex b[], Integer pdb, double *rcond, double *errbnd, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f04dhc(Nag_OrderType order, Nag_UploType uplo, Integer n, Integer nrhs, complex a[], Integer pda, Integer ipiv[], complex b[], Integer pdb, double *rcond, double *errbnd, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL f04djc(Nag_OrderType order, Nag_UploType uplo, Integer n, Integer nrhs, complex ap[], Integer ipiv[], complex b[], Integer pdb, double *rcond, double *errbnd, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL f04mcc(Nag_SolveSystem selct, Integer n, Integer nrhs, double *al, Integer lal, 
                                             double *d, Integer *row, double *b, Integer tdb, double *x, 
                                             Integer tdx, NagError *fail);


#ifdef NAGLIBANDSTINCLUDE
#include <nagf04aux.h>
 #endif

  
  /* end proto */
#ifdef __cplusplus
}
#endif
#endif /* not NAGF04 */
