/* <nage04.h>
 *
 * Copyright 1996 Numerical Algorithms Group
 *
 * Include file for NAG C Library e04 Chapter
 *
 * Mark 4 re-issue, 1996.
 * Mark 5 revised. IER-2148 (Feb 1998).
 * Mark 6 revised. IER-3030 (July 2000).
 */
#ifndef NAGE04
#define NAGE04
/// TD ML 06-10-2011 ORG-2987 NAG_HEADERS_OC_COMPILE
#ifndef _MSC_VER
	#pragma dll(ONAG8)
#endif // !_MSC_VER
/// end NAG_HEADERS_OC_COMPILE
#ifdef __cplusplus
extern "C"
{
#endif
  /* This header file uses the type FILE,  hence stdio.h has to be 
   * included.
   */
#include <stdio.h>
  /* Message codes and extern of message list */
//the following includes used <name.h>, changed to "name.h"	/// TD ML 06-10-2011 ORG-2987 NAG_HEADERS_OC_COMPILE
#include "nag_e04mesg.h"
  /* Also note that
   * a) e04uc0 is old e04ucj
   * b) e04uc1 is old e04uck
   */
  /* begin proto */
  extern NAG_DLL_EXPIMP 
  void NAG_CALL e04abc(NAG_E04ABC_FUN funct, double e1, double e2, double *a,
                       double *b, Integer max_fun, double *x,
                       double *f, Nag_Comm *comm, NagError *fail);

  extern NAG_DLL_EXPIMP 
  void NAG_CALL e04bbc(NAG_E04BBC_FUN funct, double e1, double e2, double *a,
                       double *b, Integer max_fun, double *x,
                       double *f, double *g, Nag_Comm *comm, NagError *fail);

  /// TD ML 06-10-2011 ORG-2987 NAG_HEADERS_OC_COMPILE 
  typedef void (NAG_CALL *PFN_e04cbc_funct)(Integer n, const double xc[], double *fc, Nag_Comm *comm);
  typedef void (NAG_CALL *PFN_e04cbc_monit)(double fmin, double fmax, const double sim[], Integer n, Integer ncall, double serror, double vratio, Nag_Comm *comm);
  /// end NAG_HEADERS_OC_COMPILE
  extern NAG_DLL_EXPIMP 
  void NAG_CALL e04cbc(Integer n, double x[], double *f, double tolf,
                       double tolx, 
					   /// TD ML 06-10-2011 ORG-2987 NAG_HEADERS_OC_COMPILE
                       //void (NAG_CALL *funct)(Integer n, const double xc[], double *fc, Nag_Comm *comm), 
                       //void (NAG_CALL *monit)(double fmin, double fmax, const double sim[], Integer n, Integer ncall, double serror, double vratio, Nag_Comm *comm), 
					   PFN_e04cbc_funct funct, PFN_e04cbc_monit monit,
					   /// end NAG_HEADERS_OC_COMPILE
                       Integer maxcal, Nag_Comm *comm, NagError *fail);

  extern NAG_DLL_EXPIMP 
  void NAG_CALL e04ccc(Integer n, NAG_E04CCC_FUN funct, double *x, 
                       double *fmin, Nag_E04_Opt *options,
                       Nag_Comm *user_comm, NagError *fail);

  extern NAG_DLL_EXPIMP 
  void NAG_CALL e04dgc(Integer n, NAG_E04DGC_FUN objfun, double x[], 
                       double *objf, double grad[],
                       Nag_E04_Opt *options, 
                       Nag_Comm *user_comm, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL e04fcc(Integer m, Integer n, NAG_E04FCC_FUN lsqfun,
                                             double x[], double *fsumsq, double fvec[],
                                             double fjac[], Integer tdj,
                                             Nag_E04_Opt *options, Nag_Comm *user_comm, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL e04gbc(Integer m, Integer n, NAG_E04GBC_FUN lsqfun,
                                             double x[], double *fsumsq, double fvec[], double fjac[],
                                             Integer tdj, Nag_E04_Opt *options, Nag_Comm *user_comm, NagError *fail);



  extern NAG_DLL_EXPIMP 
  void NAG_CALL e04hcc(Integer n, NAG_E04HCC_FUN sfun, double x[], 
                       double *f, double g[], 
                       Nag_Comm *user_comm, NagError *fail);

  extern NAG_DLL_EXPIMP 
  void NAG_CALL e04hdc(Integer n, NAG_E04LBC_FUN sfun, NAG_E04LBC_HESS shess,
                       double x[], double g[], double hesl[], double hesd[], 
                       Nag_Comm *user_comm, NagError *fail);

  extern NAG_DLL_EXPIMP 
  void NAG_CALL e04jbc(Integer n, NAG_E04JBC_FUN sfun, Nag_BoundType bound, 
                       double bl[], double bu[],
                       double x[], double *f, 
                       double g[], Nag_E04_Opt *options, 
                       Nag_Comm *user_comm, NagError *fail);

  extern NAG_DLL_EXPIMP 
  void NAG_CALL e04kbc(Integer n, NAG_E04KBC_FUN sfun, Nag_BoundType bound, 
                       double bl[], double bu[],
                       double x[], double *f, 
                       double g[], Nag_E04_Opt *options, 
                       Nag_Comm *user_comm, NagError *fail);

  extern NAG_DLL_EXPIMP 
  void NAG_CALL e04lbc(Integer n, NAG_E04LBC_FUN sfun, NAG_E04LBC_HESS shess,
                       Nag_BoundType bound, double bl[], double bu[], 
                       double x[], double *f, double g[], Nag_E04_Opt *options,
                       Nag_Comm *user_comm, NagError *fail);

  extern NAG_DLL_EXPIMP 
  void NAG_CALL e04mfc(Integer n, Integer nclin, double a[], 
                       Integer tda, double bl[], double bu[],
                       double cvec[], double x[],
                       double *obj, Nag_E04_Opt *options, 
                       Nag_Comm *user_comm, NagError *fail);

  extern NAG_DLL_EXPIMP 
  void NAG_CALL e04myc(double **a, Integer **ha, Integer **ka, 
                       double **bl, double **bu, double **xs);

  extern NAG_DLL_EXPIMP 
  void NAG_CALL e04mzc(const char *mps_file, Integer *n, Integer *m, Integer *nnz, 
                       Integer *iobj, double **a, Integer **ha, Integer **ka, 
                       double **bl, double **bu, double **xs,
                       Nag_E04_Opt *options, NagError *fail);

  extern NAG_DLL_EXPIMP 
  void NAG_CALL e04ncc(Integer m, Integer n, Integer nclin, 
                       double a[], Integer tda, double bl[],
                       double bu[], double cvec[], 
                       double b[], double h[], Integer tdh, 
                       Integer kx[], double x[], 
                       double *obj, Nag_E04_Opt *options, 
                       Nag_Comm *user_comm, NagError *fail);

  extern NAG_DLL_EXPIMP 
  void NAG_CALL e04nfc(Integer n, Integer nclin, double a[], 
                       Integer tda, double bl[], double bu[],
                       double cvec[], double h[], 
                       Integer tdh, NAG_E04NFC_FUN qphess_user,
                       double x[], double *obj, 
                       Nag_E04_Opt *options, Nag_Comm *comm,
                       NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL 
  e04nkc(Integer n, Integer m, Integer nnz, Integer iobj, Integer ncolh, 
         NAG_E04NKC_HESSFUN qphx, double a[], Integer ha[], Integer ka[], 
         double bl[], double bu[], double xs[], 
         Integer *ninf, double *suminf, double *obj, 
         Nag_E04_Opt *options, Nag_Comm *user_comm, NagError *fail);



  extern NAG_DLL_EXPIMP void NAG_CALL e04npc(Nag_E04State *state, NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL e04nqc(Nag_Start start,
					     NAG_E04NQC_QPHX,
					     Integer m, Integer n, Integer ne, Integer nname, Integer lenc, Integer ncolh,
					     Integer iobj, double objadd, const char * prob, const double acol[],
					     const Integer inda[], const Integer loca[], const double bl[], const double bu[],
					     const double c[], char * names[], const Integer helast[], Integer hs[],
					     double x[], double Pie[], double rc[], Integer *ns, Integer *ninf, double *sinf,
					     double *obj, Nag_E04State *state, Nag_Comm *comm, NagError *fail);
 /* CL08 */
  extern NAG_DLL_EXPIMP void NAG_CALL e04nrc(Nag_FileID fileid, Nag_E04State *state, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL e04nsc(const char * str, Nag_E04State *state, NagError *fail);

		      extern NAG_DLL_EXPIMP void NAG_CALL e04ntc(const char * str, Integer ivalue, Nag_E04State *state, NagError *fail);
 
		      extern NAG_DLL_EXPIMP void NAG_CALL e04nuc(const char * str, double rvalue, Nag_E04State *state, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL e04nxc(const char * str, Integer *ivalue, Nag_E04State *state, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL e04nyc(const char * str, double *rvalue, Nag_E04State *state, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL 
  e04ucc(Integer n, Integer nclin, Integer ncnlin, double a[], 
         Integer tda, double bl[], double bu[],
         NAG_E04UCC_FUN objfun, NAG_E04UCC_CONFUN confun,
         double x[], double *objf, double objgrad[],
         Nag_E04_Opt *options, Nag_Comm *user_comm, 
         NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL
  e04ugc (NAG_E04UGC_CONFUN confun, NAG_E04UGC_OBJFUN objfun,
          Integer n, Integer m, Integer ncnln, Integer nonln,
          Integer njnln, Integer iobj, Integer nnz, double a[],
          const Integer ha[], const Integer ka[], double bl[], double bu[],
          double xs[],Integer *ninf, double *sinf, double *obj,
          Nag_Comm * user_comm, Nag_E04_Opt *options,
          NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL 
  e04unc(Integer m, Integer n, Integer nclin, Integer ncnlin, 
         double a[], Integer tda, double bl[], 
         double bu[], double y[], NAG_E04UNC_OBJFUN objfun, 
         NAG_E04UNC_CONFUN confun, double x[], double *objf,
         double f[], double fjac[], Integer tdfju, 
         Nag_E04_Opt *options, Nag_Comm *user_comm,
         NagError *fail);


  extern NAG_DLL_EXPIMP void NAG_CALL e04vgc(Nag_E04State *state, NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL e04vhc(Nag_Start start, Integer nf, Integer n, Integer nxname,
					     Integer nfname, double objadd, Integer objrow, const char * prob,
					     NAG_E04VHC_USRFUN,
					     const Integer iafun[], const Integer javar[], const double a[], Integer lena,
					     Integer nea, const Integer igfun[], const Integer jgvar[], Integer leng,
					     Integer neg, const double xlow[], const double xupp[], char * xnames[],
					     const double flow[], const double fupp[], char * fnames[],
					     double x[], Integer xstate[], double xmul[], double f[],
					     Integer fstate[], double fmul[], Integer *ns, Integer *ninf,
					     double *sinf, Nag_E04State *state, Nag_Comm *comm, NagError *fail);
  

  extern NAG_DLL_EXPIMP void NAG_CALL e04vjc(Integer nf, Integer n, NAG_E04VJC_USRFUN, Integer iafun[], Integer javar[], double a[],
					     Integer lena, Integer *nea, Integer igfun[], Integer jgvar[], Integer leng, Integer *neg,
					     const double x[], const double xlow[], const double xupp[], Nag_E04State *state,
					     Nag_Comm *comm, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL e04vkc(Nag_FileID fileid, Nag_E04State *state, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL e04vlc(const char * str, Nag_E04State *state, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL e04vmc(const char * str, Integer ivalue, Nag_E04State *state, NagError *fail);
 
  extern NAG_DLL_EXPIMP void NAG_CALL e04vnc(const char * str, double rvalue, Nag_E04State *state, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL e04vrc(const char * str, Integer *ivalue, Nag_E04State *state, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL e04vsc(const char * str, double *rvalue, Nag_E04State *state, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL e04wcc(Nag_E04State *state, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL e04wdc(Integer n, Integer nclin, Integer ncnln, Integer pda, Integer pdcj, Integer pdh,
					     const double a[], const double bl[], const double bu[], NAG_E04WDC_CONFUN,
					     NAG_E04WDC_OBJFUN, Integer *majits, Integer istate[], double ccon[], double cjac[],
					     double clamda[], double *objf, double grad[], double hess[], double x[],
					     Nag_E04State *state, Nag_Comm *comm, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL e04wec(Nag_FileID fileid, Nag_E04State *state, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL e04wfc(const char * str, Nag_E04State *state, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL e04wgc(const char * str, Integer ivalue, Nag_E04State *state, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL e04whc(const char * str, double rvalue, Nag_E04State *state, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL e04wkc(const char * str, Integer *ivalue, Nag_E04State *state, NagError *fail);

extern NAG_DLL_EXPIMP void NAG_CALL e04wlc(const char * str, double *rvalue, Nag_E04State *state, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL 
  e04xac(Integer n, double x[], NAG_E04UCC_FUN objfun, double *objf, 
         double g[], double h_forward[], double h_central[],
         double h[], Integer tdh, Nag_DerivInfo deriv_info[],
         Nag_E04_Opt *options, Nag_Comm *comm, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL e04xxc(Nag_E04_Opt *opt);

  extern NAG_DLL_EXPIMP void NAG_CALL e04xyc(const char *name, 
                                             const char *opt_file, Nag_E04_Opt *opt,
                                             Nag_Boolean print, const char *outfile, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL e04xzc(Nag_E04_Opt *opt, const char *name, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL e04yac(Integer m, Integer n, NAG_E04YAC_FUN lsqfun,
                                             double x[], double fvec[], double fjac[], Integer tdj,
                                             Nag_Comm *user_comm, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL e04ycc(Integer job, Integer m, Integer n, double fsumsq,
                                             double cj[], Nag_E04_Opt *options, NagError *fail);


#ifdef NAGLIBANDSTINCLUDE
#include <nage04aux.h>
#endif

  /* end proto */
#ifdef __cplusplus
}
#endif
#endif /* not NAGE04 */
