/* <nagd06.h>
 *
 * Copyright 2001 Numerical Algorithms Group
 *
 * Include file for NAG C Library d06 Chapter
 *
 */
#ifndef NAGD06
#define NAGD06
/// TD ML 06-10-2011 ORG-2987 NAG_HEADERS_OC_COMPILE
#ifndef _MSC_VER
	#pragma dll(ONAG8)
#endif // !_MSC_VER
/// end NAG_HEADERS_OC_COMPILE
#ifdef __cplusplus
extern "C"
{
#endif
  /* begin proto */
  extern NAG_DLL_EXPIMP void NAG_CALL d06aac (Integer nvb, Integer nvmax,
					      Integer nedge,
					      const Integer edge[],
					      Integer * nv, Integer * nelt,
					      double coor[], Integer conn[],
					      const double bspace[],
					      Nag_Boolean smooth, double coef,
					      double power, Integer itrace,
					      const char *outfile, NagError * fail);


  extern NAG_DLL_EXPIMP void NAG_CALL d06abc (Integer nvb, Integer nvint,
					      Integer nvmax, Integer nedge,
					      const Integer edge[],
					      Integer * nv, Integer * nelt,
					      double coor[], Integer conn[],
					      const double weight[],
					      Integer npropa, Integer itrace,
					      const char *outfile, NagError * fail);


  extern NAG_DLL_EXPIMP void NAG_CALL d06acc (Integer nvb, Integer nvint,
					      Integer nvmax, Integer nedge,
					      const Integer edge[],
					      Integer * nv, Integer * nelt,
					      double coor[], Integer conn[],
					      const double weight[],
					      Integer itrace, const char *outfile, 
					      NagError * fail);


  extern NAG_DLL_EXPIMP void NAG_CALL d06bac (Integer nlines,
					      const double coorch[],
					      const Integer lined[],
					      NAG_D06BAC_FBND,
					      const double coorus[],
					      Integer nus,
					      const double rate[],
					      Integer ncomp,
					      const Integer nlcomp[],
					      const Integer lcomp[],
					      Integer nvmax, Integer nedmx,
					      Integer * nvb, double coor[],
					      Integer * nedge, Integer edge[],
					      Integer itrace, const char *outfile, 
                                              Nag_Comm * comm, NagError * fail);


  extern NAG_DLL_EXPIMP void NAG_CALL d06cac (Integer nv, Integer nelt, Integer nedge,
					      double coor[],
					      const Integer edge[],
					      const Integer conn[],
					      Integer nvfix,
					      const Integer numfix[],
					      Integer itrace, const char *outfile,
                                              Integer nqint, NagError * fail);


  extern NAG_DLL_EXPIMP void NAG_CALL d06cbc (Integer nv, Integer nelt, Integer nnzmax,
					      const Integer conn[],
					      Integer * nnz, Integer irow[],
					      Integer icol[],
					      NagError * fail);


  extern NAG_DLL_EXPIMP void NAG_CALL d06ccc (Integer nv, Integer nelt, Integer nedge,
					      Integer nnzmax, Integer * nnz,
					      double coor[], Integer edge[],
					      Integer conn[], Integer irow[],
					      Integer icol[], Integer itrace,
					      const char *outfile, NagError * fail);


  extern NAG_DLL_EXPIMP void NAG_CALL d06dac(Integer mode, Integer nv,
                                             Integer nedge, Integer nelt,
                                             Integer ntrans,
                                             const Integer comp_type[],
                                             const double trans[],
                                             double coori[],
                                             Integer edgei[],
                                             Integer conni[],
                                             double cooro[],
                                             Integer edgeo[],
                                             Integer conno[],
                                             Integer itrace, 
                                             const char *outfile, 
                                             NagError *fail);


  extern NAG_DLL_EXPIMP void NAG_CALL d06dbc (double eps, Integer nv1, 
                                              Integer nelt1,
					      Integer nedge1,
					      const double coor1[],
					      const Integer edge1[],
					      const Integer conn1[],
					      const Integer reft1[],
					      Integer nv2, Integer nelt2,
					      Integer nedge2,
					      const double coor2[],
					      const Integer edge2[],
					      const Integer conn2[],
					      const Integer reft2[],
					      Integer * nv3, Integer * nelt3,
					      Integer * nedge3,
					      double coor3[], Integer edge3[],
					      Integer conn3[],
					      Integer reft3[], Integer itrace,
					      const char *outfile, NagError * fail);


#ifdef NAGLIBANDSTINCLUDE
#include <nagd06aux.h>
 #endif


  /* end proto */
#ifdef __cplusplus
}
#endif
#endif /* not NAGD06 */
