/* <nagd03.h>
 *
 * Copyright 2001 Numerical Algorithms Group
 *
 * Include file for NAG C Library d03 Chapter
 *
 */
#ifndef NAGD03
#define NAGD03
/// TD ML 06-10-2011 ORG-2987 NAG_HEADERS_OC_COMPILE
#ifndef _MSC_VER
	#pragma dll(ONAG8)
#endif // !_MSC_VER
/// end NAG_HEADERS_OC_COMPILE
#ifdef __cplusplus
extern "C"
{
#endif

  extern NAG_DLL_EXPIMP void NAG_CALL d03ncc (Nag_OptionType kopt, double x,
					      Nag_MeshType mesh, Integer ns,
					      double s[], Integer nt,
					      double t[],
					      const Nag_Boolean tdpar[],
					      const double r[],
					      const double q[],
					      const double sigma[],
					      double alpha, Integer ntkeep,
					      double f[], double theta[],
					      double delta[], double gamma[],
					      double lambda[], double rho[],
					      NagError * fail);


  extern NAG_DLL_EXPIMP void NAG_CALL d03ndc (Nag_OptionType kopt, double x,
					      double s, double t, double tmat,
					      const Nag_Boolean tdpar[],
					      const double r[],
					      const double q[],
					      const double sigma[], double *f,
					      double *theta, double *delta,
					      double *gamma, double *lambda,
					      double *rho, NagError * fail);


  extern NAG_DLL_EXPIMP void NAG_CALL d03nec (double t0, double tmat,
					      Integer ntd, const double td[],
					      const double phid[],
					      double phiav[],
					      NagError * fail);


  extern NAG_DLL_EXPIMP void NAG_CALL d03pcc (Integer npde, Integer m,
					      double *ts, double tout,
					      NAG_D03PCC_PDEDEF,
					      NAG_D03PCC_BNDARY, double u[],
					      Integer npts, const double x[],
					      double acc, double rsave[],
					      Integer lrsave, Integer isave[],
					      Integer lisave, Integer itask,
					      Integer itrace, const char *outfile, 
                                              Integer * ind,
					      Nag_Comm * comm, 
                                              Nag_D03_Save *saved, 
                                              NagError * fail);


  /* Prototypes of library-provided callback functions */

  /* odedef in ppc */

  extern NAG_DLL_EXPIMP void NAG_CALL d03pck (Integer npde, double t,
                                              Integer ncode, const double v[],
                                              const double vdot[], Integer nxi,
                                              const double xi[],
                                              const double ucp[],
                                              const double ucpx[],
                                              const double rcp[],
                                              const double ucpt[],
                                              const double ucptx[],
                                              double f[],
                                              Integer *ires, Nag_Comm *comm);


  /* monitf in ppc */

  extern NAG_DLL_EXPIMP void NAG_CALL d03pcl (double t, Integer npts,
                                              Integer npde, const double x[],
                                              const double u[],
                                              const double r[], double fmon[],
                                              Nag_Comm *comm);


  extern NAG_DLL_EXPIMP void NAG_CALL d03pdc (Integer npde, Integer m,
					      double *ts, double tout,
					      NAG_D03PDC_PDEDEF,
					      NAG_D03PDC_BNDARY, double u[],
					      Integer nbkpts,
					      const double xbkpts[],
					      Integer npoly, Integer npts,
					      double x[], NAG_D03PDC_UINIT,
					      double acc, double rsave[],
					      Integer lrsave, Integer isave[],
					      Integer lisave, Integer itask,
					      Integer itrace, const char *outfile,
                                              Integer * ind, Nag_Comm * comm, 
                                              Nag_D03_Save *saved, 
					      NagError * fail);


  extern NAG_DLL_EXPIMP void NAG_CALL d03pec (Integer npde, double *ts,
					      double tout, NAG_D03PEC_PDEDEF,
					      NAG_D03PEC_BNDARY, double u[],
					      Integer npts, const double x[],
					      Integer nleft, double acc,
					      double rsave[], Integer lrsave,
					      Integer isave[], Integer lisave,
					      Integer itask, Integer itrace,
					      const char *outfile, Integer * ind, 
                                              Nag_Comm * comm,
                                              Nag_D03_Save *saved, 
					      NagError * fail);

  /* odedef in psc */

  extern NAG_DLL_EXPIMP void NAG_CALL d03pek (Integer npde, double t,
                                              Integer ncode, const double v[],
                                              const double vdot[], Integer nxi,
                                              const double xi[],
                                              const double ucp[],
                                              const double ucpx[],
                                              const double ucpt[], double r[],
                                              Integer *ires, Nag_Comm *comm);

  /* monitf in psc */

  extern NAG_DLL_EXPIMP void NAG_CALL d03pel (double t, Integer npts, 
                                              Integer npde, const double x[], 
                                              const double u[], double fmon[],
                                              Nag_Comm *comm);


  extern NAG_DLL_EXPIMP void NAG_CALL d03pfc (Integer npde, double *ts,
					      double tout, NAG_D03PFC_PDEDEF,
					      NAG_D03PFC_NUMFLX,
					      NAG_D03PFC_BNDARY, double u[],
					      Integer npts, const double x[],
					      const double acc[],
					      double tsmax, double rsave[],
					      Integer lrsave, Integer isave[],
					      Integer lisave, Integer itask,
					      Integer itrace, const char *outfile,
                                              Integer * ind, Nag_Comm * comm,
                                              Nag_D03_Save *saved, 
					      NagError * fail);

  /* pdedef in pfc */

  extern NAG_DLL_EXPIMP void NAG_CALL d03pfp (Integer npde, double t, double x,
                                              const double u[],
                                              const double ux[], double p[],
                                              double c[], double d[],
                                              double s[], Integer *ires,
                                              Nag_Comm *comm);


  extern NAG_DLL_EXPIMP void NAG_CALL d03phc (Integer npde, Integer m,
					      double *ts, double tout,
					      NAG_D03PHC_PDEDEF,
					      NAG_D03PHC_BNDARY, double u[],
					      Integer npts, const double x[],
					      Integer ncode,
					      NAG_D03PHC_ODEDEF, Integer nxi,
					      const double xi[], Integer neqn,
					      const double rtol[],
					      const double atol[],
					      Integer itol, Nag_NormType norm,
					      Nag_LinAlgOption laopt,
					      const double algopt[],
					      double rsave[], Integer lrsave,
					      Integer isave[], Integer lisave,
					      Integer itask, Integer itrace,
					      const char *outfile, Integer * ind, 
                                              Nag_Comm * comm,
                                              Nag_D03_Save *saved, 
					      NagError * fail);


  extern NAG_DLL_EXPIMP void NAG_CALL d03pjc (Integer npde, Integer m,
					      double *ts, double tout,
					      NAG_D03PJC_PDEDEF,
					      NAG_D03PJC_BNDARY, double u[],
					      Integer nbkpts,
					      const double xbkpts[],
					      Integer npoly, Integer npts,
					      double x[], Integer ncode,
					      NAG_D03PJC_ODEDEF, Integer nxi,
					      const double xi[], Integer neqn,
					      NAG_D03PJC_UVINIT,
					      const double rtol[],
					      const double atol[],
					      Integer itol, Nag_NormType norm,
					      Nag_LinAlgOption laopt,
					      const double algopt[],
					      double rsave[], Integer lrsave,
					      Integer isave[], Integer lisave,
					      Integer itask, Integer itrace,
					      const char *outfile, Integer * ind, 
                                              Nag_Comm * comm,
                                              Nag_D03_Save *saved, 
					      NagError * fail);


  extern NAG_DLL_EXPIMP void NAG_CALL d03pkc (Integer npde, double *ts,
					      double tout, NAG_D03PKC_PDEDEF,
					      NAG_D03PKC_BNDARY, double u[],
					      Integer npts, const double x[],
					      Integer nleft, Integer ncode,
					      NAG_D03PKC_ODEDEF, Integer nxi,
					      const double xi[], Integer neqn,
					      const double rtol[],
					      const double atol[],
					      Integer itol, Nag_NormType norm,
					      Nag_LinAlgOption laopt,
					      const double algopt[],
					      double rsave[], Integer lrsave,
					      Integer isave[], Integer lisave,
					      Integer itask, Integer itrace,
					      const char *outfile, Integer * ind, 
                                              Nag_Comm * comm,
                                              Nag_D03_Save *saved, 
					      NagError * fail);


  extern NAG_DLL_EXPIMP void NAG_CALL d03plc (Integer npde, double *ts,
					      double tout, NAG_D03PLC_PDEDEF,
					      NAG_D03PLC_NUMFLX,
					      NAG_D03PLC_BNDARY, double u[],
					      Integer npts, const double x[],
					      Integer ncode,
					      NAG_D03PLC_ODEDEF, Integer nxi,
					      const double xi[], Integer neqn,
					      const double rtol[],
					      const double atol[],
					      Integer itol, Nag_NormType norm,
					      Nag_LinAlgOption laopt,
					      const double algopt[],
					      double rsave[], Integer lrsave,
					      Integer isave[], Integer lisave,
					      Integer itask, Integer itrace,
					      const char *outfile, Integer * ind, 
                                              Nag_Comm * comm,
                                              Nag_D03_Save *saved, 
					      NagError * fail);

  /* pdedef in psc */

  extern NAG_DLL_EXPIMP void NAG_CALL d03plp (Integer npde, double t, double x,
                                              const double u[],
                                              const double ux[], Integer ncode,
                                              const double v[],
                                              const double vdot[], double p[],
                                              double c[], double d[],
                                              double s[], Integer *ires,
                                              Nag_Comm *comm);


  extern NAG_DLL_EXPIMP void NAG_CALL d03ppc (Integer npde, Integer m,
					      double *ts, double tout,
					      NAG_D03PPC_PDEDEF,
					      NAG_D03PPC_BNDARY,
					      NAG_D03PPC_UVINIT, double u[],
					      Integer npts, double x[],
					      Integer ncode,
					      NAG_D03PPC_ODEDEF, Integer nxi,
					      const double xi[], Integer neqn,
					      const double rtol[],
					      const double atol[],
					      Integer itol, Nag_NormType norm,
					      Nag_LinAlgOption laopt,
					      const double algopt[],
					      Nag_Boolean remesh, Integer nxfix,
					      const double xfix[],
					      Integer nrmesh, double dxmesh,
					      double trmesh, Integer ipminf,
					      double xratio, double con,
					      NAG_D03PPC_MONITF,
					      double rsave[], Integer lrsave,
					      Integer isave[], Integer lisave,
					      Integer itask, Integer itrace,
					      const char *outfile, Integer * ind, 
                                              Nag_Comm * comm,
                                              Nag_D03_Save *saved, 
					      NagError * fail);


  extern NAG_DLL_EXPIMP void NAG_CALL d03prc (Integer npde, double *ts,
					      double tout, NAG_D03PRC_PDEDEF,
					      NAG_D03PRC_BNDARY,
					      NAG_D03PRC_UVINIT, double u[],
					      Integer npts, double x[],
					      Integer nleft, Integer ncode,
					      NAG_D03PRC_ODEDEF, Integer nxi,
					      const double xi[], Integer neqn,
					      const double rtol[],
					      const double atol[],
					      Integer itol, Nag_NormType norm,
					      Nag_LinAlgOption laopt,
					      const double algopt[],
					      Nag_Boolean remesh, Integer nxfix,
					      const double xfix[],
					      Integer nrmesh, double dxmesh,
					      double trmesh, Integer ipminf,
					      double xratio, double con,
					      NAG_D03PRC_MONITF,
					      double rsave[], Integer lrsave,
					      Integer isave[], Integer lisave,
					      Integer itask, Integer itrace,
					      const char *outfile, Integer * ind, 
                                              Nag_Comm * comm,
                                              Nag_D03_Save *saved, 
					      NagError * fail);


  extern NAG_DLL_EXPIMP void NAG_CALL d03psc (Integer npde, double *ts,
					      double tout, NAG_D03PSC_PDEDEF,
					      NAG_D03PSC_NUMFLX,
					      NAG_D03PSC_BNDARY,
					      NAG_D03PSC_UVINIT, double u[],
					      Integer npts, double x[],
					      Integer ncode,
					      NAG_D03PSC_ODEDEF, Integer nxi,
					      const double xi[], Integer neqn,
					      const double rtol[],
					      const double atol[],
					      Integer itol, Nag_NormType norm,
					      Nag_LinAlgOption laopt,
					      const double algopt[],
					      Nag_Boolean remesh, Integer nxfix,
					      const double xfix[],
					      Integer nrmesh, double dxmesh,
					      double trmesh, Integer ipminf,
					      double xratio, double con,
					      NAG_D03PSC_MONITF,
					      double rsave[], Integer lrsave,
					      Integer isave[], Integer lisave,
					      Integer itask, Integer itrace,
					      const char *outfile, Integer * ind, 
                                              Nag_Comm * comm,
                                              Nag_D03_Save *saved, 
					      NagError * fail);


  extern NAG_DLL_EXPIMP void NAG_CALL d03puc (const double uleft[],
					      const double uright[],
					      double gamma, double flux[],
                                              Nag_D03_Save *saved, 
					      NagError * fail);


  extern NAG_DLL_EXPIMP void NAG_CALL d03pvc (const double uleft[],
					      const double uright[],
					      double gamma, 
                                              Nag_OsherVersion path,
					      double flux[], 
                                              Nag_D03_Save *saved, 
					      NagError * fail);


  extern NAG_DLL_EXPIMP void NAG_CALL d03pwc (const double uleft[],
					      const double uright[],
					      double gamma, double flux[],
                                              Nag_D03_Save *saved, 
					      NagError * fail);


  extern NAG_DLL_EXPIMP void NAG_CALL d03pxc (const double uleft[],
					      const double uright[],
					      double gamma, double tol,
					      Integer niter, double flux[],
                                              Nag_D03_Save *saved, 
					      NagError * fail);


  extern NAG_DLL_EXPIMP void NAG_CALL d03pyc (Integer npde, const double u[],
					      Integer nbkpts,
					      const double xbkpts[],
					      Integer npoly, Integer npts,
					      const double xp[],
					      Integer intpts,
					      Integer itype,
					      double up[], double rsave[],
					      Integer lrsave,
					      NagError * fail);


  extern NAG_DLL_EXPIMP void NAG_CALL d03pzc (Integer npde, Integer m,
					      const double u[], Integer npts,
					      const double x[],
					      const double xp[],
					      Integer intpts,
					      Integer itype,
					      double up[], NagError * fail);


#ifdef NAGLIBANDSTINCLUDE
#include <nagd03aux.h>
 #endif


  /* end proto */
#ifdef __cplusplus
}
#endif
#endif /* not NAGD03 */
