/* <nagc05.h>
 *
 * Copyright 1996 Numerical Algorithms Group
 *
 * Include file for NAG C Library c05 Chapter
 *
 * Mark 4, revised, 1996.
 * Mark 5 revised. IER-2142 (Feb 1998).
 * Mark 6 revised. IER-3024 (July 2000).
 */
#ifndef NAGC05
#define NAGC05
/// TD ML 06-10-2011 ORG-2987 NAG_HEADERS_OC_COMPILE
#ifndef _MSC_VER
	#pragma dll(ONAG8)
#endif // !_MSC_VER
/// end NAG_HEADERS_OC_COMPILE
#ifdef __cplusplus
extern "C"
{
#endif
  /* begin proto */
  extern NAG_DLL_EXPIMP void NAG_CALL c05adc(double a, double b, double *x, 
                                             NAG_C05ADC_FUN f, double xtol, 
                                             double ftol, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL c05agc(double *x, double h, double xtol,
                                             double ftol, NAG_C05AGC_FUN f,
                                             double *a, double *b, Nag_Comm *comm,
                                             NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL c05avc(double *x, const double fx, double *h,
                                             double boundl, double boundu,
                                             double *y, double c[], Integer *ind,
                                             NagError *fail); 
  
  extern NAG_DLL_EXPIMP void NAG_CALL c05axc(double *x, const double fx,
                                             const double tol, const Nag_ErrorControl ir,
                                             const double scal, double c[],
                                             Integer *ind, NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL c05azc(double *x, double *y, const double fx,
                                             double tolx, const Nag_ErrorControl ir, double c[],
                                             Integer *ind, NagError *fail); 

  extern NAG_DLL_EXPIMP double NAG_CALL c05bac(double x, Integer branch,
                                               Nag_Boolean offset,
                                               NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL c05nbc(Integer n, double x[], double fvec[], 
                                             NAG_C05NBC_FUN f,
                                             double xtol, NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL c05nct(Integer n, double x[]);

  extern NAG_DLL_EXPIMP void NAG_CALL c05pbc( Integer n, double x[],
                                              double fvec[], double fjac[], Integer tdfjac,
                                              NAG_C05PBC_FUN f,
                                              double xtol, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL c05sdc(double a, double b, double *x, 
                                             NAG_C05SDC_FUN f, double xtol, 
                                             double ftol, Nag_User *comm, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL c05tbc(Integer n, double x[], double fvec[], 
                                             NAG_C05TBC_FUN f,
                                             double xtol, Nag_User *comm, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL c05ubc( Integer n, double x[],
                                              double fvec[], double fjac[], Integer tdfjac,
                                              NAG_C05UBC_FUN f,
                                              double xtol, Nag_User *comm, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL c05zbc( Integer n, double x[],
                                              double fvec[], double fjac[], Integer tdfjac,
                                              NAG_C05ZBC_FUN lsqfun, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL c05zcc( Integer n, double x[],
                                              double fvec[], double fjac[], Integer tdfjac,
                                              NAG_C05ZCC_FUN lsqfun, Nag_User *comm, NagError *fail);


#ifdef NAGLIBANDSTINCLUDE
#include <nagc05aux.h>
 #endif

  /* end proto */
#ifdef __cplusplus
}
#endif
#endif /* not NAGC05 */
