/* nag_wav_aux.h
 *
 * Prototypes for wavelet auxiliary functions
 *
 */
#include "nag.h"	//this include used <name.h>, changed to "name.h"	/// TD ML 06-10-2011 ORG-2987 NAG_HEADERS_OC_COMPILE

#define CONST const
#ifdef __cplusplus
extern "C"
{
#endif
/// TD ML 06-10-2011 ORG-2987 NAG_HEADERS_OC_COMPILE
#ifndef _MSC_VER
	#pragma dll(ONAG_ex.dll)
#endif // !_MSC_VER
/// end NAG_HEADERS_OC_COMPILE

#ifndef NAG_BLAS_CRAYPC /* UNIX */
/* And now for the corresponding declarations */

extern void c06pcfn_(
#ifdef __STDC__
  CONST char direct[],
  Complex x[],
  CONST Integer *n,
  Complex work[],
  char errbuf[],
  Integer *ifail,
  CONST int length_1,
  CONST int length_2
#endif
);

#else /* NAG_MSOFT_DLL */

/* And now for the corresponding declarations */

extern void __stdcall C06PCF(
  CONST char direct[], int length_direct,
  Complex x[],
  CONST int *n,
  Complex work[],
  int *ifail
);


#define c06pcfn_(DIRECT, X, N, WORK, ERRBUF, IFAIL, DIRECT_length, ERRBUF_length) \
C06PCFN(DIRECT, DIRECT_length, X, N, WORK, ERRBUF, ERRBUF_length, IFAIL)

#endif /* NAG_MSOFT_DLL */

/*
 * Filter Initialisation
 *
 */

extern void nagbiwfn(Nag_WavType wavname, Integer *nld, Integer *ldsh,
	      double ld[], Integer *nhd, Integer *hdsh, double hd[], 
	      Integer *nlr, Integer *lrsh, double lr[], Integer *nhr,
	      Integer *hrsh, double hr[], Integer *IFAIL);

extern void nagorwfn(Nag_WavType wavname, Integer *nld, Integer *ldsh,
	      double ld[], Integer *nhd, Integer *hdsh, double hd[], 
	      Integer *nlr, Integer *lrsh, double lr[], Integer *nhr,
		     Integer *hrsh, double hr[], Integer *IFAIL);

/*
 * 1D Continuous Real Wavelet Transform (CWT) 
 *
 */

  extern void nagcwin(Integer wtype, Integer wavparam, Integer n, 
		      const double x[], Integer ns, const Integer scales[],
		      Integer nwav, double xwav[], double wavsum[],
		      double lb, double ub, double coefs[], double rwork[],
		      Integer iwork[], Integer *ierror);

  extern void wavquad(Integer wtype, Integer waveparam, Integer nw,
		      double xw[], double wavsum[], Integer *ierror);

/*
 * Filter Initialisation
 *
 */

extern void nagwvfn(Nag_WavType wavname, Integer nf, double *ld, 
	     double *hd, double *lr, double *hr, Integer *IFAIL);

/*
 * 1D Discrete Wavelet Transform (DWT)
 *
 */

extern void nagdwtn(Nag_WavModeType mode, Integer n, const double x[], 
	            Integer nlo, Integer lshift, const double ld[], 
		    Integer nhi, Integer hshift, const double hd[], 
		    Integer nc, double ca[], double cd[], 
		    Integer *ierror);

/*
 * Convolution-decimation: single level
 *
 */

/* Periodic extension */
extern void perconvdec(Integer n, const double x[], Integer nf, 
		       Integer shift, const double filt[], Integer stride,
		       Integer nc, double c[], Integer *ierror);

/* Zero extension */
extern void zeroconvdec(Integer n, const double x[], Integer nf, 
			Integer shift, const double filt[], 
			Integer stride, Integer nc, double c[],
			Integer *ierror);

/* Half-point symmetric extension */
extern void hsymconvdec(Integer n, const double x[], Integer nf, 
			Integer shift, const double filt[], Integer stride,
			Integer nc, double c[], Integer *ierror);

/* Whole-point symmetric extension */
extern void wsymconvdec(Integer n, const double x[], Integer nf, 
			Integer shift, const double filt[], Integer stride,
			Integer nc, double c[], Integer *ierror);
/* 
 * 1D Inverse Discrete Wavelet Transform (IDWT)
 *
 */

extern void nagidwtn(Nag_WavModeType mode, Integer nc, const double ca[], 
		     const double cd[], Integer nlo, Integer lshift,
		     const double lr[], Integer nhi, Integer hshift,
		     const double hr[], Integer n, double y[], 
		     Integer *ierror);

/* Periodic Extension */
extern void perdilaconv(Integer nc, const double c[], Integer nf,
			Integer shift, const double filt[], Integer stride,
			double y[], Integer *ierror);

/* Zero extension */
extern void zerodilaconv(Integer nc, const double c[], Integer nf,
			 Integer shift, const double filt[], Integer stride,
			 Integer mshift, double y[], Integer *ierror);

/* Half-point symmetric extension */
extern void hsymdilaconv(Integer nc, const double c[], Integer nf,
			 Integer shift, const double filt[], Integer stride,
			 double y[], Integer *ierror);

/* Whole-point symmetric extension */
extern void wsymdilaconv(Integer nc, const double c[], Integer nf,
			 Integer shift, const double filt[], Integer stride,
			 double y[], Integer *ierror);

/*
 * 2D Discrete Wavelet Transform (DWT2)
 *
 */

extern void nagdwt2n(Nag_WavModeType mode, Integer m, Integer n,
		     const double a[], Integer nlo, Integer lshift,
		     const double ld[], Integer nhi, Integer hshift,
		     const double hd[], Integer mc, Integer nc, double ca[],
		     double ch[], double cv[], double cd[], Integer nwork,
		     double work[], Integer *IFAIL);

/*
 * 2D Inverse Discrete Wavelet Transform (IDWT2)
 *
 */

extern void nagidwt2n(Nag_WavModeType mode, Integer mc, Integer nc, 
		      const double ca[], const double ch[], 
		      const double cv[], const double cd[], Integer nlo,
		      Integer lshift, const double lr[], Integer nhi,
		      Integer hshift, const double hr[], double b[],
		      Integer nwork, double work[], Integer *IFAIL);

#ifdef __cplusplus
}
#endif
