#ifndef NAG_EXAMPLE_FILE_IO_H
#define NAG_EXAMPLE_FILE_IO_H
/* x04aect.c 
 *
 * Opens an I/O unit for a C example program.
 * Argument "flag" should be either "-data", "-results", "-options",
 * or "-nag_write". This function searches the program argument list for
 * a mention of that file flag, and if it finds it, opens the file.
 * Returns a FILE pointer, which may be stdin or stdout if
 * the file flag is not mentioned on the command line, or NULL if
 * a file that is mentioned cannot be opened for any reason.
 *
 * Copyright 2009 Numerical Algorithms Group.
 *
 * NAG C Library
 *
 * Mark 9, 2009.
 *
 */

/* Avoid Microsoft C compiler warnings about use of
   sprintf and friends in example programs */
#ifndef _CRT_SECURE_NO_WARNINGS
#define _CRT_SECURE_NO_WARNINGS
#endif
#ifndef _CRT_SECURE_NO_DEPRECATE
#define _CRT_SECURE_NO_DEPRECATE
#endif

#include <stdio.h>
#include <nag.h> 
#include <string.h>
#include <ctype.h>
#include <nag_stdlib.h>

FILE *nag_example_file_io(int argc, char *argv[], const char *flag, char **fname)
{
  const char *mode=0;
  char *optionsfile;
  char *progname;
  FILE *retval=0, *tfile;
  int len, storelen;
  int count=0;
  int dot_here=0;

  /* Results file defaults to stdout, data units to stdin*/
  if (!strcmp(flag,"-results") )
    {
      retval = stdout;
      mode = "w";
    }
  else if (!strcmp(flag,"-data"))
    {
      retval = stdin;
      mode = "r";
    }
  /* Options file defaults to example_name.opt*/
  else if (!strcmp(flag,"-options") )
    {
      /* Get the name of the executable */
      len = strlen(argv[0]);
      storelen=len;
      progname=argv[0];
      while (len > 0 && (isalnum(progname[len-1]) || progname[len-1] == '.' ))
	{
	  if (progname[len-1] == '.')
	    {
	      dot_here=count+1;
	    }
	  count++;
	  len--;
	}

      if ((optionsfile = NAG_ALLOC(count+1, char)))
        {
          strncpy(optionsfile,&progname[storelen-count],count-dot_here);
          strcpy(&optionsfile[count-dot_here], "\0");
          strcat(optionsfile, ".opt");
        }
      *fname=optionsfile;
          
    }
  else if (!strcmp(flag, "-nag_write") || !strcmp(flag, "-nag_read") )
    {
      *fname=0;
    }

  /* Search for a match of the file flag string */
  if (argc > 1)
    {
      argc--;
      argv++;
      while(argc)
	{
          if (!strcmp(*argv, flag))
            {
              if (argc > 1)
                {
                  argc--;
                  argv++;
                  if (!strcmp(flag,"-options") || !strcmp(flag, "-nag_write") || !strcmp(flag, "-nag_read") )
                    {
		      if ((*fname = NAG_ALLOC(strlen(*argv)+1, char)))
			{
			  strcpy(*fname, *argv);
			}
                    }
                  else if (!strcmp(flag,"-data") || !strcmp(flag, "-results"))
                    {
                      tfile = fopen(*argv, mode);
                      if (tfile)
                        {
			  /* if (fname)
                            *fname = *argv;
			    */
                          retval = tfile;
                        }
                      else
                        retval = NULL;
                      break;
                    }
                }
	    }
          argc--;
	  argv++;
	}
    }
  return retval;
}
#endif /* NAG_EXAMPLE_FILE_IO_H */
