#ifndef NAG_ERRLIST_H
#define NAG_ERRLIST_H

/* <nag_errlist.h> 
 *
 * Copyright 2000 Numerical Algorithms Group.
 *
 * Error Messages for the NAG C library.
 *
 * Mark 6, 2000.
 * 
 * Generated by 'errlisupdate' on Tue Oct 23 13:38:30 BST 2001.
 * 
 * Mark 6 revised. IER-3012 (July 2000).
 * Mark 6 revised. IER-3067 (September 2000).
 * Mark 7 Re-issue. October 2001.
 * Mark 8 Revised. August 2005.
 */

/* Compatibility change */
#define NE_INITIALISATION NE_INITIALIZATION 

/*Start_Error_Number_Defines*/

#define NE_NOERROR 0
#define NE_CODE_NOT_SET 1
#define NE_ERR_MSG_STRING 2
#define NE_TOO_MANY 3
#define NE_REAL_ARG_EQ 4
#define NE_REAL_ARG_LT 5
#define NE_REAL_ARG_LE 6
#define NE_REAL_ARG_GT 7
#define NE_REAL_ARG_GE 8
#define NE_REAL_ARG_CONS 9
#define NE_INT_ARG_EQ 10
#define NE_INT_ARG_LT 11
#define NE_INT_ARG_LE 12
#define NE_INT_ARG_GT 13
#define NE_INT_ARG_GE 14
#define NE_INT_ARG_CONS 15
#define NE_2_INT_ARG_EQ 16
#define NE_2_INT_ARG_LT 17
#define NE_2_INT_ARG_LE 18
#define NE_2_INT_ARG_GT 19
#define NE_2_INT_ARG_GE 20
#define NE_2_INT_ARG_ZERO 21
#define NE_2_REAL_ARG_EQ 22
#define NE_2_REAL_ARG_LT 23
#define NE_2_REAL_ARG_LE 24
#define NE_2_REAL_ARG_GT 25
#define NE_2_REAL_ARG_GE 26
#define NE_2_REAL_ARG_TOO_CLOSE 27
#define NE_2_INT_ARG_CONS 28
#define NE_3_INT_ARG_CONS 29
#define NE_4_INT_ARG_CONS 30
#define NE_2_REAL_ARG_CONS 31
#define NE_3_REAL_ARG_CONS 32
#define NE_4_REAL_ARG_CONS 33
#define NE_2_REAL_ENUM_ARG_CONS 34
#define NE_3_REAL_ENUM_ARG_CONS 35
#define NE_REAL_INT_ARG_CONS 36
#define NE_REAL_ENUM_ARG_CONS 37
#define NE_ENUM_ENUM_ARG_CONS 38
#define NE_INVALID_INT_RANGE_1 39
#define NE_INVALID_INT_RANGE_2 40
#define NE_INVALID_REAL_RANGE_E 41
#define NE_INVALID_REAL_RANGE_F 42
#define NE_INVALID_REAL_RANGE_EE 43
#define NE_INVALID_REAL_RANGE_EF 44
#define NE_INVALID_REAL_RANGE_FF 45
#define NE_INVALID_REAL_RANGE_FE 46
#define NE_INVALID_REAL_RANGE_CONS 47
#define NE_INT_RANGE_CONS 48
#define NE_INT_RANGE_CONS_2 49
#define NE_REAL_RANGE_CONS 50
#define NE_2_INT_REAL_ARG_CONS 51
#define NE_2_REAL_INT_ARG_CONS 52
#define NE_INT_ARRAY_1 53
#define NE_INT_ARRAY_2 54
#define NE_REAL_ARRAY_INPUT 55
#define NE_INT_ARRAY_VAL_1_OR_2 56
#define NE_REAL_ARRAY_CONS 57
#define NE_ARRAY_CONS 58
#define NE_ARRAY_INPUT 59
#define NE_2_REAL_ARRAYS_CONS 60
#define NE_REAL_ARRAY_ELEM_CONS 61
#define NE_NOT_INCREASING 62
#define NE_NOT_STRICTLY_INCREASING 63
#define NE_NOT_DECREASING 64
#define NE_NOT_STRICTLY_DECREASING 65
#define NE_NOT_NON_DECREASING 66
#define NE_NO_NORMALISATION 67
#define NE_USER_STOP 68
#define NE_BOOL_NOT_SET 69
#define NE_BAD_PARAM 70
#define NE_F06_BAD_PARAM 71
#define NE_ARG_INVALID 72
#define NE_ALLOC_FAIL 73
#define NE_INTERNAL_ERROR 74
#define NE_MESG_NOT_INIT 75
#define NE_NOT_READ_FILE 76
#define NE_NOT_WRITE_FILE 77
#define NE_NOT_APPEND_FILE 78
#define NE_NOT_CLOSE_FILE 79
#define NE_WRITE_ERROR 80
#define NE_STRUCT_CORRUPT 81
#define NE_NULL_ARRAY 82
#define NE_NON_MONOTONIC 83
#define NE_INT_OPT_ARG_LT 84
#define NE_INT_OPT_ARG_GT 85
#define NE_2_INT_OPT_ARG_CONS 86
#define NE_2_REAL_EE_OPT_ARG_CONS 87
#define NE_INCOMPAT_PARAM 88
#define NE_TEST_FAILED 89
#define NE_INT 90
#define NE_INT_2 91
#define NE_INT_3 92
#define NE_INT_4 93
#define NE_INT_5 94
#define NE_INT_6 95
#define NE_ENUM_INT 96
#define NE_ENUM_INT_2 97
#define NE_ENUM_INT_3 98
#define NE_ENUM_INT_4 99
#define NE_REAL 100
#define NE_REAL_2 101
#define NE_REAL_3 102
#define NE_REAL_4 103
#define NE_REAL_5 104
#define NE_REAL_6 105
#define NE_ENUM_REAL_1 106
#define NE_ENUM_REAL_2 107
#define NE_ENUM_REAL_3 108
#define NE_ENUM_REAL_4 109
#define NE_CONSTRAINT 110
#define NE_COMPLEX 111
#define NE_INT_ARRAY_CONS 112
#define NE_2_INT_ARRAY_CONS 113
#define NE_2D_INT_ARRAY_CONS 114
#define NE_2D_REAL_ARRAY_CONS 115
#define NE_2D_1D_INT_ARRAYS_CONS 116
#define NE_INT_ARG_ENUM_CONS 117
#define NE_2_INT_ARG_ENUM_CONS 118
#define NE_2_INTARR_INT 119
#define NE_INTARR 120
#define NE_INTARR_INT 121
#define NE_INTARR_2_INT 122
#define NE_INTARR_3_INT 123
#define NE_REALARR 124
#define NE_INCOMP_ARRAYS 125
#define NE_REAL_MACH_PREC 126
#define NE_REAL_INT 127
#define NE_REALARR_REAL 128
#define NW_INT 129
#define NW_2_INT 130
#define NW_REAL_REALARR 131
#define NE_INTARR_REALARR 132
#define NE_COMPLEX_ZERO 133
#define NE_POLY_NOT_CONV 134
#define NE_POLY_UNFLOW 135
#define NE_POLY_OVFLOW 136
#define NE_C02_OVERFLOW 137
#define NE_C02_NOT_CONV 138
#define NE_FUNC_END_VAL 139
#define NE_PROBABLE_POLE 140
#define NE_XTOL_TOO_SMALL 141
#define NE_TOO_MANY_FUNC_EVAL 142
#define NE_NO_IMPROVEMENT 143
#define NE_FACTOR_GT 144
#define NE_TOO_MANY_FACTORS 145
#define NE_C06_FACTOR_GT 146
#define NE_C06_TOO_MANY_FACTORS 147
#define NE_C06_NOT_TRIG 148
#define NE_C06_FACTORS 149
#define NE_QUAD_MAX_SUBDIV 150
#define NE_QUAD_BAD_SUBDIV 151
#define NE_QUAD_BAD_SUBDIV_INTS 152
#define NE_QUAD_ROUNDOFF_TOL 153
#define NE_QUAD_ROUNDOFF_ABS_TOL 154
#define NE_QUAD_ROUNDOFF_EXTRAPL 155
#define NE_QUAD_NO_CONV 156
#define NE_QUAD_BRKPTS_INVAL 157
#define NE_QUAD_BAD_SUBDIV_INT 158
#define NE_QUAD_MAX_INT 159
#define NE_QUAD_EXTRAPL_INT 160
#define NE_QUAD_MAX_SUBDIV_SPEC_INT 161
#define NE_QUAD_ROUNDOFF_TOL_SPEC_INT 162
#define NE_QUAD_NO_CONV_SPEC_INT 163
#define NE_QUAD_DIVERGENCE_SPEC_INT 164
#define NE_QUAD_BAD_SPEC_INT 165
#define NE_QUAD_GAUSS_NPTS_RULE 166
#define NE_QUAD_GAUSS_CONS 167
#define NE_QUAD_GAUSS_LAG_HER_WTS 168
#define NE_QUAD_MAX_INTEGRAND_EVAL 169
#define NE_QUAD_MAX_INTEGRAND_CONS 170
#define NE_QUAD_FIRST_TWO_PTS_EQL 171
#define NE_XSOL_NOT_RESET 172
#define NE_XSOL_SET_WRONG 173
#define NE_XSOL_INCONSIST 174
#define NE_TOL_TOO_SMALL 175
#define NE_TOL_PROGRESS 176
#define NE_NO_SIGN_CHANGE 177
#define NE_STATE 178
#define NE_NEQF_CHANGED 179
#define NE_NEQG_CHANGED 180
#define NE_VECTOL_CHANGED 181
#define NE_REAL_LT_COND 182
#define NE_NO_INTEGRATE 183
#define NE_NO_STEPS 184
#define NW_EXTRAPOLATION 185
#define NE_NWANT_GT 186
#define NE_NO_SETUP 187
#define NE_SETUP_ERROR 188
#define NE_T_SAME_TOUT 189
#define NE_T_CHANGED 190
#define NE_DIRECTION_CHANGE 191
#define NE_TOUT_TCRIT 192
#define NE_MAX_STEP 193
#define NE_ODE_TOL 194
#define NE_WEIGHT_ZERO 195
#define NE_STIFF_PROBLEM 196
#define NE_SINGULAR_POINT 197
#define NE_NO_G_FUN 198
#define NE_NEQF 199
#define NE_NEQ 200
#define NE_LF_B_VAL 201
#define NE_RT_B_VAL 202
#define NE_LFRT_B_VAL 203
#define NE_LF_B_MESH 204
#define NE_RT_B_MESH 205
#define NE_CONV_MESH 206
#define NE_CONV_MESH_INIT 207
#define NE_CONV_ROUNDOFF 208
#define NE_CONV_CONT 209
#define NE_CONV_JACOBG 210
#define NE_CONV_CONT_DEP 211
#define NE_CONV_CONT_DELEPS 212
#define NE_BOUND_COND_ROW 213
#define NE_BOUND_COND_COL 214
#define NE_BOUND_COND_MAT 215
#define NE_BOUND_COND_LC 216
#define NE_BOUND_COND_NLC 217
#define NE_INVALID_FUN_JAC 218
#define NE_INVALID_FUN_JAC_CONT 219
#define NE_INVALID_FUN_JAC_NO_CONT 220
#define NE_INVALID_FUN_NO_JAC_CONT 221
#define NE_RK_INVALID_CALL 222
#define NE_PREV_CALL 223
#define NE_PREV_CALL_INI 224
#define NE_RK_TGOT_EQ_TEND 225
#define NE_RK_TGOT_RANGE_TEND 226
#define NE_RK_TGOT_RANGE_TEND_CLOSE 227
#define NE_RK_TWANT_CLOSE_TGOT 228
#define NE_RK_PCC_METHOD 229
#define NE_RK_PDC_TEND 230
#define NE_RK_PDC_STEP 231
#define NE_RK_PDC_POINTS 232
#define NE_RK_PDC_GLOBAL_ERROR_T 233
#define NE_RK_PDC_GLOBAL_ERROR_S 234
#define NE_MISSING_CALL 235
#define NE_RK_DIRECTION_POS 236
#define NE_RK_DIRECTION_NEG 237
#define NE_RK_STEP 238
#define NE_ERRASS_REQ 239
#define NE_RK_STIFF 240
#define NE_RK_PX_METHOD 241
#define NW_RK_TOO_MANY 242
#define NE_RK_NOSTEP 243
#define NE_MEMORY_FREED 244
#define NE_NOT_MONOTONIC 245
#define NW_EXTRAPOLATE 246
#define NE_ABSCI_OUTSIDE_KNOT_INTVL 247
#define NE_KNOTS_OUTSIDE_DATA_INTVL 248
#define NE_WEIGHTS_NOT_POSITIVE 249
#define NE_SW_COND_FAIL 250
#define NW_INTERVAL_EXTRAPOLATE 251
#define NE_DATA_ILL_CONDITIONED 252
#define NE_KNOTS_DISTINCT_ABSCI_CONS 253
#define NE_ALL_DATA_COLLINEAR 254
#define NE_DATA_NOT_UNIQUE 255
#define NE_NUM_PARAM_INVALID 256
#define NE_RAD_PARAM_INVALID 257
#define NW_SPARSE_DATA_FIT 258
#define NE_TRIANG_INVALID 259
#define NW_VALUE_EXTRAPOLATED 260
#define NE_BAD_INTERPOLANT 261
#define NE_KNOTS_CONS 262
#define NE_SPLINE_COEFF_CONV 263
#define NE_END_KNOTS_CONS 264
#define NE_KNOTS_COORD_CONS 265
#define NE_POINT_OUTSIDE_RECT 266
#define NE_KNOTS_COINCIDE 267
#define NE_PANEL_ORDER 268
#define NE_ALL_ELEMENTS_EQUAL 269
#define NE_NUM_KNOTS_2D_GT_RECT 270
#define NE_NUM_KNOTS_2D_GT_SCAT 271
#define NE_NUM_COEFF_GT 272
#define NE_NUM_KNOTS_1D_GT 273
#define NE_NO_ADDITIONAL_KNOTS 274
#define NE_ENUMTYPE_WARM 275
#define NE_NUM_KNOTS_2D_LT 276
#define NE_SF_D_K_CONS 277
#define NE_SPLINE_RANGE_INVALID 278
#define NE_NON_ZERO_WEIGHTS 279
#define NE_INVALID_XCAP 280
#define NE_OPT_NOT_INIT 281
#define NE_INVALID_OPTION 282
#define NE_FIELD_UNKNOWN 283
#define NE_INVALID_OPTION_NAME 284
#define NE_INVALID_VALUE 285
#define NE_NO_VALUE 286
#define NE_UNBALANCED_COMMENT 287
#define NW_SMALL_DERIV 288
#define NE_DERIV_ERRORS 289
#define NE_GRAD_TOO_SMALL 290
#define NE_SVD_FAIL 291
#define NW_NO_IMPROVEMENT 292
#define NW_COND_MIN 293
#define NW_TOO_MANY_ITER 294
#define NW_STEP_BOUND_TOO_SMALL 295
#define NE_MISSING_DERIV 296
#define NE_INVALID_TEXT_RANGE 297
#define NE_INVALID_ENUM_RANGE 298
#define NE_NOT_FUN_NAME 299
#define NE_CHOLESKY_OVERFLOW 300
#define NW_LOCAL_SEARCH 301
#define NE_BOUND 302
#define NE_BOUND_LCON 303
#define NE_BOUND_NLCON 304
#define NE_BOUND_EQ 305
#define NE_BOUND_EQ_LCON 306
#define NE_BOUND_EQ_NLCON 307
#define NE_FD_INT 308
#define NE_HESD 309
#define NE_CANCEL_ERR 310
#define NE_INIT_MEM 311
#define NE_NO_MEM 312
#define NE_SINGULAR_VALUES 313
#define NW_LIN_DEPEND 314
#define NE_SVD_ZERO 315
#define NE_C_OVERFLOW 316
#define NW_DEAD_POINT 317
#define NW_SOLN_NOT_UNIQUE 318
#define NE_UNBOUNDED 319
#define NW_NOT_FEASIBLE 320
#define NW_LIN_NOT_FEASIBLE 321
#define NW_NONLIN_NOT_FEASIBLE 322
#define NE_HESS_TOO_BIG 323
#define NW_OVERFLOW_WARN 324
#define NE_STATE_VAL 325
#define NE_STR_UNKNOWN 326
#define NE_STOP_LT_START 327
#define NE_CHECK_LT_ONE 328
#define NE_WARM_START 329
#define NE_CVEC_NULL 330
#define NE_H_NULL 331
#define NE_H_NULL_QP 332
#define NW_NOT_CONVERGED 333
#define NW_KT_CONDITIONS 334
#define NE_INVALID_BEGIN 335
#define NW_LAGRANGE_MULT_ZERO 336
#define NE_CYCLING 337
#define NE_OBJ_BOUND 338
#define NE_DUPLICATE_ELEMENT 339
#define NE_HESS_INDEF 340
#define NE_BASIS_ILL_COND 341
#define NE_OUT_OF_WORKSPACE 342
#define NE_BASIS_SINGULAR 343
#define NE_NULL_QPHX 344
#define NE_NAME_TOO_LONG 345
#define NE_STATE_VAL_ARG 346
#define NE_NAMES_NOT_NAG_MEM 347
#define NE_NULL_ARGUMENT 348
#define NE_B_NULL 349
#define NW_MAX_FUN 350
#define NE_H_FORWARD_NULL 351
#define NW_DERIV_INFO 352
#define NE_INFEASIBLE 353
#define NE_LIN_NOT_FEASIBLE 354
#define NE_NONLIN_NOT_FEASIBLE 355
#define NE_MAYBE_UNBOUNDED 356
#define NE_TOO_MANY_ITER 357
#define NE_TOO_MANY_MAJOR_ITER 358
#define NE_TOO_MANY_MINOR_ITER 359
#define NE_SUPERBASICS_LIMIT 360
#define NE_OBJ_DERIV_ERRORS 361
#define NE_CON_DERIV_ERRORS 362
#define NE_NO_IMPROVE 363
#define NE_CANNOT_CALCULATE 364
#define NE_NOT_REQUIRED_ACC 365
#define NE_SINGULAR 366
#define NE_NOT_POS_DEF 367
#define NE_NOT_POS_DEF_FACT 368
#define NE_ZERO_DIAG 369
#define NE_NOT_UNIT_DIAG 370
#define NE_TOO_MANY_ITERATIONS 371
#define NE_TDQ_LT_M 372
#define NE_TDQ_LT_N 373
#define NE_TDP_LT_N 374
#define NE_QR_NOT_CONV 375
#define NE_RANK_LT_N 376
#define NE_RANK_LT_NOT_UNIQ 377
#define NE_ITER_FAIL_CONV 378
#define NE_DIAG_IMAG_NON_ZERO 379
#define NE_SINGULAR_DET_ZERO 380
#define NE_DET_OVERFLOW 381
#define NE_DET_UNDERFLOW 382
#define NE_ITERATIONS_QZ 383
#define NE_MATRIX_NOT_ZERO 384
#define NE_QR_FAIL_CONV 385
#define NE_MAT_SINGULAR 386
#define NE_QR_FAIL 387
#define NE_REQD_EIGVAL 388
#define NE_EIGVEC 389
#define NE_FORMAT_LEN 390
#define NE_INVALID_FORMAT 391
#define NE_COL_WIDTH 392
#define NE_EXCHANGE 393
#define NE_REORDER 394
#define NE_PERTURBED 395
#define NE_SYMM_MATRIX 396
#define NE_ZERO_DIAGONAL_ELEM 397
#define NE_PRECOND_NOT_POS_DEF 398
#define NE_COEFF_NOT_POS_DEF 399
#define NE_NOT_REQ_ACC 400
#define NE_ACC_LIMIT 401
#define NE_SYMM_MATRIX_DUP 402
#define NE_INVALID_ROW_PIVOT 403
#define NE_LA_TOO_SMALL 404
#define NE_INVALID_SCS 405
#define NE_INVALID_SCS_PRECOND 406
#define NE_NON_ZERO_DUP 407
#define NE_ZERO_COEFF 408
#define NE_INVALID_CS 409
#define NE_INVALID_CS_PRECOND 410
#define NE_INVALID_ROWCOL_PIVOT 411
#define NE_NONSYMM_MATRIX 412
#define NE_NONSYMM_MATRIX_DUP 413
#define NE_NEG_WEIGHT 414
#define NE_CASES_ZERO 415
#define NE_CASES_ONE 416
#define NE_FUN_INF 417
#define NE_GAM_NOT_CONV 418
#define NE_RES_NOT_ACC 419
#define NE_ALG_NOT_CONV 420
#define NE_SOL_CLOSE_TO_ZERO 421
#define NE_SOL_NOT_CONV 422
#define NE_ACC_IN_DOUBT 423
#define NE_PROBAB_CLOSE_TO_TAIL 424
#define NE_ARG_TOO_LARGE 425
#define NE_VARIANCE_TOO_LARGE 426
#define NE_SAMPLES_NOT_IN_ORDER 427
#define NE_SAMPLES_ARE_ALL_EQUAL 428
#define NE_NORMAL_SCORE_EST 429
#define NE_SERIES 430
#define NE_PROBABILITY 431
#define NE_POISSON_WEIGHT 432
#define NE_TERM_LARGE 433
#define NE_CHI_PROB 434
#define NE_CONV 435
#define NE_PROB_F 436
#define NE_PROB_F_INIT 437
#define NE_PROB_LIMIT 438
#define NE_PROB_B_INIT 439
#define NE_BAD_SX_OR_IP 440
#define NE_ZERO_DOF_RESID 441
#define NE_SVD_NOT_CONV 442
#define NE_MAT_NOT_UPD 443
#define NE_RSS_NOT_UPD 444
#define NE_DOF_LE_ZERO 445
#define NE_NVAR_NOT_IND 446
#define NE_ZERO_DIAG_ELEM 447
#define NE_RESID_LARG 448
#define NE_SVD_RANK_NE_IP 449
#define NE_SVD_RANK_GT_IP 450
#define NE_ILLCOND 451
#define NE_IP_INCOMP_WITH_SX 452
#define NE_MAT_NOT_FULL_RANK 453
#define NE_STDES_ZERO 454
#define NE_RANK_EQ_IP 455
#define NE_DIAG_ELEM_ZERO 456
#define NE_SW_LT_ONE 457
#define NE_VAR_EQ_ZERO 458
#define NE_NEG_SX 459
#define NE_POS_SX 460
#define NE_WT_LOW 461
#define NE_SW_LOW 462
#define NW_RSS_EQ_ZERO 463
#define NW_RMS_EQ_ZERO 464
#define NE_SOBS_LOW 465
#define NE_SVAR_LOW 466
#define NE_X_OR_Y_IDEN 467
#define NE_X_IDEN 468
#define NE_PREC_NOT_INIT 469
#define NE_STRUCT_NOT_DEFINED 470
#define NE_EX_POWER_EQ_ZERO 471
#define NE_IP_INCOMP_SX 472
#define NE_IP_GT_OBSERV 473
#define NE_VALUE_AT_BOUNDARY_A 474
#define NE_VALUE_AT_BOUNDARY_B 475
#define NE_VALUE_AT_BOUNDARY_C 476
#define NE_VALUE_AT_BOUNDARY_D 477
#define NE_LSQ_ITER_NOT_CONV 478
#define NE_RANK_CHANGED 479
#define NE_ZERO_DOF_ERROR 480
#define NE_BAD_NY_SET 481
#define NE_BAD_NX_SET 482
#define NE_VARCOV_MAT_SINGULAR 483
#define NE_SQRT_VARCOV_SINGULAR 484
#define NE_DIAG_ELEM_INVALID 485
#define NE_DIAG_EQ_ZERO 486
#define NE_ELEM_GT_ONE 487
#define NE_INVALID_HUBER_FUN 488
#define NE_INVALID_DCHI_FUN 489
#define NE_INVALID_MALLOWS_REG_C 490
#define NE_INVALID_SCHWEPPE_REG_C 491
#define NE_BAD_HAMPEL_PSI_FUN 492
#define NE_WT_ITER_EXCEEDED 493
#define NE_BETA1_ITER_EXCEEDED 494
#define NE_THETA_ITER_EXCEEDED 495
#define NE_LSQ_FAIL_CONV 496
#define NE_WT_LSQ_NOT_FULL_RANK 497
#define NE_REG_MAT_SINGULAR 498
#define NE_COV_MAT_FACTOR_ZERO 499
#define NE_VAR_THETA_LEQ_ZERO 500
#define NE_ERR_DOF_LEQ_ZERO 501
#define NE_ESTIM_SIGMA_ZERO 502
#define NE_OBS_VAR_CONST 503
#define NE_C_ITER_NOT_CONV 504
#define NE_C_ITER_UNSTABLE 505
#define NE_CPSI_NOT_SET 506
#define NE_CUCV_NOT_SET 507
#define NE_HPSI_NOT_SET 508
#define NE_DCHI_NOT_SET 509
#define NE_SUM_ZERO 510
#define NE_UCV 511
#define NE_CONST_COL 512
#define NE_COR_MAT_RANK 513
#define NE_COR_MAT_POSDEF 514
#define NE_NEG_WEIGHT_ELEMENT 515
#define NE_VAR_INCL_INDICATED 516
#define NE_VAR_INCL_COND 517
#define NE_OBSERV_LT_VAR 518
#define NE_VAR_INCL_STANDARD 519
#define NE_ZERO_EIGVALS 520
#define NE_CANON_CORR_1 521
#define NE_GROUPS 522
#define NE_RANK_ZERO 523
#define NE_MAT_RANK_ZERO 524
#define NE_WT_ARGS 525
#define NE_ACC_ITER 526
#define NE_NORM_ZERO_PTS 527
#define NE_LSQ_SCAL_ZERO_PTS 528
#define NE_MAT_RANK 529
#define NE_GROUP_OBSERV 530
#define NE_GROUP_VAR 531
#define NE_DIAG_0_COND 532
#define NE_DIAG_0_J_COND 533
#define NE_VAR_RANK 534
#define NE_GROUP_VAR_RANK 535
#define NE_GROUP_SUM 536
#define NE_PRIOR_SUM 537
#define NE_IDEN_ELEM_COND 538
#define NE_DENDROGRAM 539
#define NE_WT_ZERO 540
#define NE_CLUSTER_EMPTY 541
#define NE_DENDROGRAM_ARRAY 542
#define NE_CLUSTER 543
#define NE_NONZERO_EIGVALS 544
#define NE_EIGVAL 545
#define NE_NEG_OR_ZERO_ARRAY 546
#define NE_NEG_ELEMENT 547
#define NE_IT_ARRAY 548
#define NE_ARRAY_CONSTANT 549
#define NE_G04BB_STDERR 550
#define NE_G04BB_CONV 551
#define NE_G04BB_DESIGN 552
#define NE_G04BB_TREAT 553
#define NE_G04BB_RES_DF 554
#define NE_TOO_SMALL 555
#define NE_PLOT_TREAT 556
#define NE_G04CA_RES_DF 557
#define NE_G04BC_ST_ERR 558
#define NE_G04BC_REPS 559
#define NE_G04BC_RESD 560
#define NE_G04BC_DISCON 561
#define NE_G04EA_LEVELS 562
#define NE_G04EA_ORTHO_POLY 563
#define NE_STUDENTIZED_STAT 564
#define NE_STATE_CORRUPT 565
#define NE_REAL_ARG_NON_INTEGRAL 566
#define NE_SYSTEM_TIME 567
#define NE_NOT_POS_SEM_DEF 568
#define NE_START_P_Q 569
#define NE_REF_VEC 570
#define NE_PROB_NOT_ONE 571
#define NE_ALL_PROB_ZERO 572
#define NE_NEG_PROB 573
#define NE_STATIONARITY 574
#define NE_WINS_RES_ZERO 575
#define NE_ACC 576
#define NE_POS_DEF 577
#define NE_ROUND_OFF 578
#define NE_G08AA_NON_TIED 579
#define NE_G08AG_SAMP_IDEN 580
#define NE_G08AH_SAMP_IDEN 581
#define NE_G08CB_PARAM 582
#define NE_G08CB_DATA 583
#define NE_G08CB_SAMPLE 584
#define NE_G08CB_VARIANCE 585
#define NE_G08CB_INCOMP_GAMMA 586
#define NE_G08CD_CONV 587
#define NE_G08CG_FREQ 588
#define NE_G08CG_CLASS_VAL 589
#define NE_G08CG_CONV 590
#define NE_G08EA_TIE 591
#define NE_G08EA_RUNS_LENGTH 592
#define NE_G08EA_COVAR 593
#define NE_G08EA_RUNS 594
#define NE_G08EB_PAIRS 595
#define NE_G08EB_CELL 596
#define NE_G08EC_CELL 597
#define NE_G08EC_TRIPLETS 598
#define NE_G08ED_GAPS_ZERO 599
#define NE_G08ED_FREQ_ZERO 600
#define NE_G08ED_GAPS 601
#define NE_G08ED_FREQ_LT_ONE 602
#define NE_MANN_WHITNEY_STAT 603
#define NE_SEQUENCE_SHORT 604
#define NE_G10AC_DF_RHO 605
#define NE_G10AC_DF_TOL 606
#define NE_G10AC_ACC 607
#define NE_G10AC_CG_RHO 608
#define NE_G10BA_INIT 609
#define NE_G10BA_INTERVAL 610
#define NE_2D_INT_ARR_ELEM 611
#define NE_2D_INT_ARR_ELEMS 612
#define NE_TABLE_DEGENERATE 613
#define NE_LOW_EXPECTED_FREQ 614
#define NE_MAXT 615
#define NE_VAR_DIV 616
#define NE_G11BA_CHANGED 617
#define NE_CELL_EMPTY 618
#define NE_INVALID_CENSOR_CODE 619
#define NE_INVALID_FREQ 620
#define NE_CHAR_ARG_INVALID 621
#define NE_G12BA_SZ_IP 622
#define NE_G12BA_SZ_ISI 623
#define NE_G12BA_NDMAX 624
#define NE_G12BA_MAT_SING 625
#define NE_G12BA_OVERFLOW 626
#define NE_G12BA_CONV 627
#define NE_G12BA_DEV 628
#define NE_TIME_SERIES_IDEN 629
#define NE_INVALID_AUTOCO_COEF 630
#define NE_CORR_NOT_POS_DEF 631
#define NE_INVALID_NSER 632
#define NE_NPARA_MR_MT_INCONSIST 633
#define NE_DELTA_TEST_FAILED 634
#define NE_SOLUTION_FAIL_CONV 635
#define NE_MAT_NOT_POS_DEF 636
#define NE_ARIMA_TEST_FAILED 637
#define NE_ITER_FAIL_NIT 638
#define NE_G13_OPTIONS_NOT_INIT 639
#define NE_G13_ORDERS_NOT_INIT 640
#define NE_NSER_INCONSIST 641
#define NE_DIFORDER_LEN_INCONSIST 642
#define NE_SPECTRAL_ESTIM_NEG 643
#define NE_CONFID_LIMIT_FACT 644
#define NE_BIVAR_SPECTRAL_ESTIM_ZERO 645
#define NE_UNIVAR_SPECTRAL_ESTIM_ZERO 646
#define NE_UNIVAR_SPECTRAL_ESTIM_NEG 647
#define NE_SQUARED_FREQ_GT_ONE 648
#define NE_ARIMA_INPUT 649
#define NE_INPUT_NARMA 650
#define NE_G13AS_AR 651
#define NE_G13AS_ZERO_VAR 652
#define NE_G13AS_ITER 653
#define NE_G13AS_FACT 654
#define NE_G13AS_DIAG 655
#define NE_REQ_AVAIL 656
#define NE_MPS_USER_MEM 657
#define NE_MPS_ILLEGAL_DATA_LINE 658
#define NE_MPS_SPLIT_COL 659
#define NE_MPS_REPEAT_ROW 660
#define NE_MPS_ILLEGAL_NAME 661
#define NE_MPS_ILLEGAL_SETNAME 662
#define NE_MPS_ILLEGAL_NUMBER 663
#define NE_MPS_INVALID_INF_BOUND 664
#define NE_MPS_INVALID_BND_TYPE 665
#define NE_MPS_INVALID_ROW_TYPE 666
#define NE_MPS_INVALID_INTORG_INTEND 667
#define NE_MPS_INVALID_RANGE 668
#define NE_MPS_INVALID_BND_VAL 669
#define NE_MPS_NO_NEWLINE 670
#define NE_MPS_NO_COLS 671
#define NE_MPS_NO_OBJ 672
#define NE_MPS_NO_ROWS 673
#define NE_MPS_TOO_BIG 674
#define NE_MPS_UNKNOWN_COLNAME 675
#define NE_MPS_INVALID_INDICATOR 676
#define NE_MPS_UNKNOWN_ROWNAME 677
#define NE_MPS_PROB_NOT_FOUND 678
#define NE_MPS_RHS_RANGE_BND_NOT_FOUND 679
#define NE_MPS_OPT_NOT_INIT 680
#define NE_MPS_ENDATA_NOT_FOUND 681
#define NE_ALLOC_AFTER_MPS 682
#define NE_PRIORITY_NULL 683
#define NE_MIP_PROB_NULL 684
#define NE_MIP_PROB_NOT_INIT 685
#define NE_MIP_ROOT_UNBOUNDED 686
#define NE_MIP_ROOT_INFEAS 687
#define NE_MIP_ROOT_MAX_ITER 688
#define NW_MIP_FIRST_INT_SOL 689
#define NW_MIP_NO_INT_SOL 690
#define NW_MIP_MAX_ITER_INT_SOL 691
#define NW_MIP_MAX_ITER_NO_INT_SOL 692
#define NW_MIP_MAX_NODES_INT_SOL 693
#define NW_MIP_MAX_NODES_NO_INT_SOL 694
#define NW_MIP_MAX_DEPTH_INT_SOL 695
#define NW_MIP_MAX_DEPTH_NO_INT_SOL 696
#define NE_MIP_ROOT_HESS_TOO_BIG 697
#define NE_MIP_HESS_TOO_BIG_INT_SOL 698
#define NE_MIP_HESS_TOO_BIG_NO_INT_SOL 699
#define NE_CH_LOOP 700
#define NE_BAD_RANK 701
#define NE_REZ_OVERFLOW 702
#define NE_IMZ_OVERFLOW 703
#define NE_Z_OVERFLOW 704
#define NE_IMZ_HALF_PREC 705
#define NE_IMZ_NO_PREC 706
#define NE_REAL_ARG_TOO_SMALL 707
#define NE_REAL_ARG_NEG_INT 708
#define NE_UNDERFLOW_LIKELY 709
#define NE_OVERFLOW_LIKELY 710
#define NW_SOME_PRECISION_LOSS 711
#define NE_TOTAL_PRECISION_LOSS 712
#define NE_TERMINATION_FAILURE 713
#define NE_INFINITE 714
#define NE_S21_CONV 715
#define NE_NO_LICENCE 716
#define NE_INT_ARRAY 717
#define NE_VACUUM 718
#define NE_RESULT_NO_PRECISION 719
#define NE_RESULT_HALF_PRECISION 720
#define NE_RESULT_REAL_OVERFLOW 721
#define NE_RESULT_IMAGINARY_OVERFLOW 722
#define NE_RESULT_OVERFLOW 723
#define NE_INTERNAL_WORKSPACE 724
#define NE_TOO_CLOSE_INTEGER 725
/* #defines for Mark 8 F12 routines */
#define NE_NO_ARNOLDI_FAC 726
#define NE_NO_SHIFTS_APPLIED 727
#define NE_MAX_ITER 728
#define NE_ZERO_INIT_RESID 729
#define NE_OPT_INCOMPAT 730
#define NE_INTERNAL_EIGVAL_FAIL 731
#define NE_SCHUR_REORDER 732
#define NE_SCHUR_EIG_FAIL 733
#define NE_RITZ_COUNT 734
#define NE_ZERO_EIGS_FOUND 735
#define NE_TRANSFORM_OVFL 736
#define NE_COMP_BAND_SOL 737
#define NE_COMP_BAND_FAC 738
#define NE_REAL_BAND_SOL 739
#define NE_REAL_BAND_FAC 740
#define NE_ZERO_SHIFT 741
#define NE_NO_LANCZOS_FAC 742
#define NE_BOTH_ENDS_1 743
#define NE_INTERNAL_EIGVEC_FAIL 744

/* #defines names without a string */
#define NE_FREQ_CONS 2001
#define NE_FREQ_SUM 2002
#define NE_ACCURACY 2003
#define NE_CONVERGENCE 2004
#define NE_INIT_ESTIMATE 2005
#define NE_PROB_BOUNDARY 2006
#define NE_REAL_ARRAY_ENUM 2007
#define NE_REAL_ARRAY 2008
#define NE_SOME_MOMENTS 2009
#define NE_MOMENTS 2010
#define NE_POS_SEMI_DEF 2011
#define NE_EIGENVALUES 2012
#define NE_SUM_WEIGHT 2013
#define NE_ZERO_VARIANCE 2014
#define NE_INDEP_VARS_OBS 2015
#define NE_FREE_VARS 2016
#define NE_FULL_RANK 2017
#define NE_INT_ARRAY_ELEM_CONS 2018
#define NE_MODEL_PARAMETERS 2019
#define NE_ZERO_VARS 2020
#define NE_ZERO_DF 2022
#define NE_DENOM_ZERO 2023
#define NE_RESID_IDEN 2024
#define NE_RESID_MEAN 2025
#define NE_FUN_RET_VAL 2026
#define NE_ZERO_DIAGONAL 2027
#define NE_CONVERGENCE_THETA 2028
#define NE_CONVERGENCE_SOL 2029
#define NE_ZERO_VALUE 2030
#define NE_CHI 2031
#define NE_CORRECTION_FACTOR 2032
#define NE_ZERO_SUM 2033
#define NE_ZERO_DIAGNOL 2034
#define NE_CHARACTER 2035
#define NE_ENUM_CHARACTER 2036
#define NE_DIM_INFEASIBLE 2037
#define NE_REAL_ARRAY_SUM 2038
#define NE_STATIONARY_AR 2039
#define NE_CLOSE_TO_STATIONARITY 2040
#define NE_INVERTIBILITY 2041
#define NE_OUTSIDE_STATIONARITY 2042
#define NE_ORTHOGONAL_MATRIX 2043
#define NE_DIAG_ELEMENTS 2044
#define NE_EIGVAL_SUM 2045
#define NE_NEGATIVE_EIGVAL 2046
#define NE_REAL_ARRAYS_SUM 2047
#define NE_TOO_MANY_CALLS 2048
#define NE_INITIALIZATION 2049
#define NE_STANDARD_ERRORS 2050
#define NE_DIVERGENCE 2051
#define NE_EM_PROCESS 2052
#define NE_OBSERVATIONS 2053
#define NE_OVERFLOW 2054
#define NE_ZERO_RESID 2055
#define NE_SIGMA_NEGATIVE 2056
#define NE_SAMPLE_IDEN 2057
#define NE_SAMPLE 2058
#define NE_MAT_ILL_DEFINED 2059
#define NE_RESPONSE_LEVEL 2060
#define NE_MAT_INV 2061
#define NE_CONT_FRAC 2062
#define NE_INT_ARG 2063
#define NE_NOT_COMPLEX 2064
#define NE_INIT_FILTER 2065
#define NE_ORDERS_ARIMA 2066
#define NE_ORDERS_FILTER 2067
#define NE_ARRAY_SIZE 2068
#define NE_TIME_SERIES 2069
#define NE_MODEL_PARAMS 2070
#define MATRIX_ILL_CONDITIONED 2071
#define NE_PRIME_FACTOR 2072
#define NE_INT_REAL 2073
#define NE_CONFID_LIMITS 2074 
#define NE_SPECTRAL_ESTIMATES 2075
#define NE_TRANSFORMATION 2076
#define NE_MODEL_INFEASIBLE 2077
#define NE_OPTIMIZE 2078
#define NE_ITER_FAIL 2080
#define NE_NOT_ACC 2081
#define NE_POLE_PRESENT 2082
#define NE_DATA_COPLANAR 2083
#define NE_DUPLICATE_NODE 2084
#define NE_BAD_POINT 2085
#define NE_NON_UNIQUE 2086
#define NE_ILL_CONDITIONED 2087
#define NE_DEGENERATE 2088
#define NE_EXTRAPOLATION 2089
#define NE_ERROR_ESTIMATE 2090

#define NE_FAILED_START 2091
#define NE_SING_JAC 2092
#define NE_FAILED_DERIV 2093
#define NE_TIME_DERIV_DEP 2094
#define NE_FAILED_STEP 2095
#define NE_ZERO_WTS 2096
#define NE_REMESH_CHANGED 2097
#define NE_BAD_MONIT 2098

#define NE_MESH_ERROR 2099
#define NE_FAIL_SPARSITY 2100

/* Mark 8 */
#define NE_FAIL_TOL 2101
#define NE_ALG_FAIL 2102
#define NE_INVALID_PERM_COL 2103
#define NE_INVALID_PERM_ROW 2104
#define NE_NZLMX_TOO_SMALL 2105
#define NE_NZLUMX_TOO_SMALL 2106
#define NE_NZUMX_TOO_SMALL 2107
#define NE_SINGULAR_MATRIX 2108
#define NE_SPARSE_COL 2109
#define NE_SPARSE_ROW 2110
#define NE_RCOND 2111

/* Mark 8 e04 error codes */
#define NE_E04NPC_NOT_INIT 2112
#define NE_ALLOC_INSUFFICIENT 2113
#define NE_BASIS_FAILURE 2114
#define NE_OPTIONS_FILE_READ_FAILURE 2115
#define NE_E04_OPTION_INVALID 2116
#define NE_E04VGC_NOT_INIT 2117
#define NE_NUM_DIFFICULTIES 2118
#define NE_USRFUN_UNDEFINED 2119
#define NE_ARRAY_TOO_SMALL 2120
#define NE_JACOBIAN_STRUCTURE_FAIL 2121
#define NE_E04WCC_NOT_INIT 2122
/* G13 */
#define NE_G13D_DIAG 2123
#define NE_G13D_FACT 2124
#define NE_G13D_ITER 2125
#define NE_G13D_RES 2126
#define NE_G13D_ZERO_VAR 2127
#define NE_G13D_AR 2128
#define NE_G13D_MA 2129
#define NE_G13D_ARMA 2130
#define NE_HESS_NOT_POS_DEF 2131
#define NE_G13D_DERIV 2132
#define NE_G13D_BOUND 2133
#define NE_G13D_MAX_LOGLIK 2134
#define NE_G13D_MAXCAL 2135
#define NE_MAX_LOGLIK 2136
#define NE_G13D_GRAD 2137
#define NE_G13D_START 2138
#define NE_NEARLY_POS_DEF 2139
#define NE_OBSERV_LT_P 2140
/* e01 & e02 */
#define NE_INVALID_ARRAY 2141

/* x04 */
#define NE_READ_ERROR 2139
#define NE_NOT_CLOSE_FILEID 2140

/* Mark 9
 * Leave two codes free in case the overlap with 2139, 2140 needs to
 * be resolved */

/* C05 */
#define NW_TOO_MUCH_ACC_REQUESTED 2143
#define NE_ZERO_NOT_FOUND 2144
#define NE_NOT_SIGN_CHANGE 2145

/* E04 */
#define NW_TOO_MANY_FEVALS 2146

/* E05 */
#define NE_E05JAC_NOT_INIT 2147
#define NE_E05_OPTION_INVALID 2148
#define NE_WRONG_NUM_TOKENS 2149
#define NE_NOT_PARSED 2150
#define NE_TYPE_DISCREP 2151
#define NE_OUT_OF_RANGE 2152
#define NE_NOT_INIT 2153
#define NE_OPT_NOT_READ 2154
#define NE_NOT_ONOFF_OPTION 2155
#define NE_NOT_INT_OPTION 2156
#define NE_NOT_REAL_OPTION 2157
#define NE_MONIT_TERMIN 2158
#define NE_OBJFUN_TERMIN 2159
#define NE_TOO_MANY_FEVALS 2160
#define NE_DIV_COMPLETE 2161
#define NE_INF_INIT_LIST 2162
#define NE_N_CHANGED 2163
#define NE_LINESEARCH_ERROR 2164
#define NE_FILE_NOT_READ 2165

/* S */
#define NW_INTEGRAL_INFINITE 2166

/* X04 */
#define NE_NOT_CLOSE_OR_DEL_FILEID 2167

/* C05AX */
#define NE_CONTIN_PROB_NOT_SOLVED 2168
#define NE_CONTIN_AWAY_NOT_POSS 2169
#define NE_FINAL_PROB_NOT_SOLVED 2170
#define NE_SIGNIF_DERIVS_NOT_COMPUT 2171

#define NW_REAL 2172

/* Mark 9 */
/* F08 */
#define NE_SCHUR_REORDER_SELECT 2173
/* F07 */
#define NE_SINGULAR_WP 2174
/* G05 */
#define NE_INVALID_STATE 2175
#define NE_INVALID_SEQUENCE 2176
#define NE_INVALID_PRED 2177
/* E04 */
#define NW_LIMIT_REACHED 2178
/* F08 */
#define NE_ITERATION_QZ 2179
#define NE_SCHUR 2180
/* More E05 */
#define NE_INLIST_CLOSE 2181

/* more F07 */
#define NE_MAT_ROW_ZERO 2182
#define NE_MAT_COL_ZERO 2183

/* more F08 */
#define NE_EIGENVECTORS 2184


/* more G01 */
#define NE_STACK_OVERFLOW 2185
#define NE_Q_NOT_ASCENDING 2186
#define NE_Q_OUT_OF_RANGE 2187

/* more G01 */
#define NE_IP_G_OBSERV 2188

/* more M01 */
#define NE_CHAR_LEN_INVALID 2189

/* C09, Mark 9 */
#define NE_ARRAY_DIM_LEN 2190

/* g02, Mark 9 */
#define NE_EIGENPROBLEM 2191
#define NE_LANCZOS_ITERATION 2192

#define NE_UNDERFLOW  2193

/* S15, Mark 9 */
#define NW_HI 2194
#define NW_NEG 2195

/* G07, Mark 9 */
#define NW_PARAM_DIST_ASYM 2196
#define NW_PARAM_DIST_OBS 2197
#define NW_PARAM_DIST 2198

/* D02, Mark 9 */
#define NE_RES_FLAG 2199

/* Always at the end: */
#define NE_UNDEFINED_ERROR 9999
#define NE_UNKNOWNERROR 9999
#define NE_UNKNOWN_ERROR 9999

#ifdef __cplusplus
extern "C"
{
#endif

#ifdef NAG_ERRLIST             /* Whether we define the error message array */
NAG_DLL_EXPIMP const char *nag_errlist[] = 
{ "NE_NOERROR:\n\
  No error.",      /* Library Wide Error Messges */
  "NE_CODE_NOT_SET:\n\
  Error code has not been set by the last function called.",
  "NE_ERR_MSG_STRING:\n\
  The string \"%s\",\n\
  has not been recognised as a valid message string.",
  "NE_TOO_MANY:\n\
  Too many iterations (%"NAG_IFMT").",
  "NE_REAL_ARG_EQ:\n\
  On entry, %s must not be equal to %s: %s = %g.",
  "NE_REAL_ARG_LT:\n\
  On entry, %s must not be less than %s: %s = %g.",
  "NE_REAL_ARG_LE:\n\
  On entry, %s must not be less than or equal to %s: %s = %g.",
  "NE_REAL_ARG_GT:\n\
  On entry, %s must not be greater than %s: %s = %g.",
  "NE_REAL_ARG_GE:\n\
  On entry, %s must not be greater than or equal to %s: %s = %g.",
  "NE_REAL_ARG_CONS:\n\
  On entry, %s = %g. \n\
  This parameter must satisfy %s.",
  "NE_INT_ARG_EQ:\n\
  On entry, %s must not be equal to %s: %s = %"NAG_IFMT".",
  "NE_INT_ARG_LT:\n\
  On entry, %s must not be less than %s: %s = %"NAG_IFMT".",
  "NE_INT_ARG_LE:\n\
  On entry, %s must not be less than or equal to %s: %s = %"NAG_IFMT".",
  "NE_INT_ARG_GT:\n\
  On entry, %s must not be greater than %s: %s = %"NAG_IFMT".",
  "NE_INT_ARG_GE:\n\
  On entry, %s must not be greater than or equal to %s:%s = %"NAG_IFMT".",
  "NE_INT_ARG_CONS:\n\
  On entry, %s = %"NAG_IFMT". \n\
  This parameter must satisfy %s.",
  "NE_2_INT_ARG_EQ:\n\
  On entry, %s = %1"NAG_IFMT" while %s = %1"NAG_IFMT".\n\
  These parameters must satisfy %s != %s.",
  "NE_2_INT_ARG_LT:\n\
  On entry, %s = %2"NAG_IFMT" while %s = %2"NAG_IFMT".\n\
  These parameters must satisfy %s >= %s.",
  "NE_2_INT_ARG_LE:\n\
  On entry, %s = %2"NAG_IFMT" while %s = %2"NAG_IFMT".\n\
  These parameters must satisfy %s > %s.",
  "NE_2_INT_ARG_GT:\n\
  On entry, %s = %2"NAG_IFMT" while %s = %2"NAG_IFMT".\n\
  These parameters must satisfy %s <= %s.",
  "NE_2_INT_ARG_GE:\n\
  On entry, %s = %2"NAG_IFMT" while %s = %2"NAG_IFMT".\n\
  These parameters must satisfy %s < %s.",
  "NE_2_INT_ARG_ZERO:\n\
  On entry, %s = 0 and  %s = 0.\n\
  These parameters must not be identically zero.",
  "NE_2_REAL_ARG_EQ:\n\
  On entry, %s = %g while %s = %g.\n\
  These parameters must satisfy %s != %s.",
  "NE_2_REAL_ARG_LT:\n\
  On entry, %s = %g while %s = %g.\n\
  These parameters must satisfy %s >= %s.",
  "NE_2_REAL_ARG_LE:\n\
  On entry, %s = %g while %s = %g.\n\
  These parameters must satisfy %s > %s.",
  "NE_2_REAL_ARG_GT:\n\
  On entry, %s = %g while %s = %g.\n\
  These parameters must satisfy %s <= %s.",
  "NE_2_REAL_ARG_GE:\n\
  On entry, %s = %g while %s = %g.\n\
  These parameters must satisfy %s < %s.",
  "NE_2_REAL_ARG_TOO_CLOSE:\n\
  On entry, %s = %g while %s = %g.\n\
  These parameters must satisfy abs(%s-%s) %s %g.",
  "NE_2_INT_ARG_CONS:\n\
  On entry, %s = %1"NAG_IFMT" while %s = %1"NAG_IFMT".\n\
  These parameters must satisfy %s when %s.",
  "NE_3_INT_ARG_CONS:\n\
  On entry, %s = %"NAG_IFMT", %s = %"NAG_IFMT" and %s = %"NAG_IFMT".\n\
  These parameters must satisfy %s.",
  "NE_4_INT_ARG_CONS:\n\
  On entry, %s = %"NAG_IFMT", %s = %"NAG_IFMT", %s = %"NAG_IFMT" and %s = %"NAG_IFMT".\n\
  These parameters must satisfy %s.",
  "NE_2_REAL_ARG_CONS:\n\
  On entry, %s = %g while %s = %g.\n\
  These parameters must satisfy %s.",
  "NE_3_REAL_ARG_CONS:\n\
  On entry, %s = %g, %s = %g and %s = %g.\n\
  These parameters must satisfy %s.",
  "NE_4_REAL_ARG_CONS:\n\
  On entry, %s = %g, %s = %g, %s = %g and %s = %g.\n\
  These parameters must satisfy %s.",
  "NE_2_REAL_ENUM_ARG_CONS:\n\
  On entry, %s = %g, %s = %g and %s = %s.\n\
  These parameters must satisfy %s.",
  "NE_3_REAL_ENUM_ARG_CONS:\n\
  On entry, %s = %g, %s = %g, %s = %g and %s = %s.\n\
  These parameters must satisfy %s.",
  "NE_REAL_INT_ARG_CONS:\n\
  On entry, %s = %g and %s = %"NAG_IFMT".\n\
  These parameters must satisfy %s.",
  "NE_REAL_ENUM_ARG_CONS:\n\
  On entry, %s = %g and %s = %s.\n\
  These parameters must satisfy %s.",
  "NE_ENUM_ENUM_ARG_CONS:\n\
  On entry, %s = %s and %s = %s.\n\
  These parameters must satisfy %s.",

  "NE_INVALID_INT_RANGE_1:\n\
  Value %1"NAG_IFMT" given to %s is not valid.\n\
  Correct range is %s %1"NAG_IFMT".",
  "NE_INVALID_INT_RANGE_2:\n\
  Value %1"NAG_IFMT" given to %s is not valid.\n\
  Correct range is %1"NAG_IFMT" %s %1"NAG_IFMT".",
  "NE_INVALID_REAL_RANGE_E:\n\
  Value %g given to %s is not valid.\n\
  Correct range is %s %g.",
  "NE_INVALID_REAL_RANGE_F:\n\
  Value %g given to %s is not valid.\n\
  Correct range is %s %g.",
  "NE_INVALID_REAL_RANGE_EE:\n\
  Value %g given to %s is not valid.\n\
  Correct range is %g %s %g.",
  "NE_INVALID_REAL_RANGE_EF:\n\
  Value %g given to %s is not valid.\n\
  Correct range is %g %s %g.",
  "NE_INVALID_REAL_RANGE_FF:\n\
  Value %g given to %s is not valid.\n\
  Correct range is %g %s %g.",
  "NE_INVALID_REAL_RANGE_FE:\n\
  Value %g given to %s is not valid.\n\
  Correct range is %g %s %g.",
  "NE_INVALID_REAL_RANGE_CONS:\n\
  Value %g given to %s is not valid.\n\
  The parameter %s must satisfy %s.",

  "NE_INT_RANGE_CONS:\n\
  On entry, %s = %"NAG_IFMT" and %s = %"NAG_IFMT".\n\
  The parameter %s must satisfy %s.",
  "NE_INT_RANGE_CONS_2:\n\
  On entry, %s = %"NAG_IFMT" and %s = %"NAG_IFMT".\n\
  The parameter %s must satisfy either %s or %s.",
  "NE_REAL_RANGE_CONS:\n\
  On entry, %s = %g and %s = %g.\n\
  The parameter %s must satisfy %s.",
  "NE_2_INT_REAL_ARG_CONS:\n\
  On entry, %s = %2"NAG_IFMT" while %s = %g.\n\
  These parameters must satisfy %s %s and %s %s.",
  "NE_2_REAL_INT_ARG_CONS:\n\
  On entry, %s = %g while %s = %2"NAG_IFMT".\n\
  These parameters must satisfy %s %s and %s %s.",
  "NE_INT_ARRAY_1:\n\
  Value %1"NAG_IFMT" given to %s[%1"NAG_IFMT"] not valid.\n\
  Correct range for elements of %s is %s %1"NAG_IFMT".",
  "NE_INT_ARRAY_2:\n\
  Value %1"NAG_IFMT" given to %s[%1"NAG_IFMT"] not valid.\n\
  Correct range for elements of %s is %1"NAG_IFMT" %s %1"NAG_IFMT".",
  "NE_REAL_ARRAY_INPUT:\n\
  On entry, %s[%"NAG_IFMT"] = %g.\n\
  Constraint: %s[%"NAG_IFMT"] %s %g.",
  "NE_INT_ARRAY_VAL_1_OR_2:\n\
  On entry, %s[%"NAG_IFMT"] = %"NAG_IFMT".\n\
  Constraint: %s[%"NAG_IFMT"] = %"NAG_IFMT" or %"NAG_IFMT".",
  "NE_REAL_ARRAY_CONS:\n\
  On entry, %s[%"NAG_IFMT"] = %g.\n\
  Constraint: %s.",
  "NE_ARRAY_CONS:\n\
  The contents of array %s are not valid.\n\
  Constraint: %s.", 
  "NE_ARRAY_INPUT:\n\
  On entry, the values provided in %s are invalid.",
  "NE_2_REAL_ARRAYS_CONS:\n\
  On entry %s[%"NAG_IFMT"] = %g while  %s[%"NAG_IFMT"] = %g.\n\
  Constraint: %s.",
  "NE_REAL_ARRAY_ELEM_CONS:\n\
  On entry %s = %g.\n\
  Constraint: %s.",

 

  "NE_NOT_INCREASING:\n\
  The sequence %s is not increasing:\n\
  %s[%1"NAG_IFMT"] = %g, %s[%1"NAG_IFMT"] = %g.",
  "NE_NOT_STRICTLY_INCREASING:\n\
  The sequence %s is not strictly increasing:\n\
  %s[%1"NAG_IFMT"] = %g, %s[%1"NAG_IFMT"] = %g.",
  "NE_NOT_DECREASING:\n\
  The sequence %s is not decreasing:\n\
  %s[%1"NAG_IFMT"] = %g, %s[%1"NAG_IFMT"] = %g.",
  "NE_NOT_STRICTLY_DECREASING:\n\
  The sequence %s is not strictly decreasing:\n\
  %s[%1"NAG_IFMT"] = %g, %s[%1"NAG_IFMT"] = %g.",
  "NE_NOT_NON_DECREASING:\n\
  On entry,the sequence %s is not in non-decreasing order.",
  "NE_NO_NORMALISATION:\n\
  On entry, all the %s in the sequence %s are the same.",


  "NE_USER_STOP:\n\
  User requested termination, user flag value = %1"NAG_IFMT".",
  "NE_BOOL_NOT_SET:\n\
  The Nag_Boolean argument %s has not been set to Nag_TRUE or Nag_FALSE.",
  "NE_BAD_PARAM:\n\
  On entry, parameter %s had an illegal value.",
  "NE_F06_BAD_PARAM:\n\
  On entry, parameter number %1"NAG_IFMT" had an illegal value.",
  "NE_ARG_INVALID:\n\
  On entry, %s = %1"NAG_IFMT".\n Constraint: %s must be one of %s.",
  "NE_ALLOC_FAIL:\n\
  Memory allocation failed.",

  "NE_INTERNAL_ERROR:\n\
  An internal error has occurred in this function.\n\
  Check the function call and any array sizes. If the call is correct\n\
  then please consult NAG for assistance.",
  "NE_MESG_NOT_INIT:\n\
  mesg structure not initialized.",
  "NE_NOT_READ_FILE:\n\
  Cannot open file %s for reading.",
  "NE_NOT_WRITE_FILE:\n\
  Cannot open file %s for writing.",
  "NE_NOT_APPEND_FILE:\n\
  Cannot open file %s for appending.",
  "NE_NOT_CLOSE_FILE:\n\
  Cannot close file %s.",
  "NE_WRITE_ERROR:\n\
  Error occurred when writing to file %s.",
  "NE_STRUCT_CORRUPT:\n\
  The structure %s has been corrupted since the previous call to %s.",
  "NE_NULL_ARRAY:\n\
  Array %s has null address.",
  "NE_NON_MONOTONIC:\n\
  On entry, the sequence in array %s is non-monotonic.\n\
  First anomaly detected at %s[%1"NAG_IFMT"] = %g.",
  "NE_INT_OPT_ARG_LT:\n\
  On entry, %s = %1"NAG_IFMT".\n\
  Constraint: %s >= %s.",
  "NE_INT_OPT_ARG_GT:\n\
  On entry, %s = %1"NAG_IFMT".\n\
  Constraint: %s <= %s.",
  "NE_2_INT_OPT_ARG_CONS:\n\
  On entry, %s = %1"NAG_IFMT" while %s = %1"NAG_IFMT".\n\
  Constraint: %s %s %s.",
 "NE_2_REAL_EE_OPT_ARG_CONS:\n\
  On entry, %s = %1e while %s = %1e.\n\
  Constraint: %s %s %s.",
  "NE_INCOMPAT_PARAM:\n\
  On entry, incompatible parameter values have been detected.\n\
  Parameter %s has value %s whilst %s has value %s.",
  "NE_TEST_FAILED:\n\
  The stringent test program failed.",

  "NE_INT:\n\
  On entry, %s = %"NAG_IFMT".\n\
  Constraint: %s.",
  "NE_INT_2:\n\
  On entry, %s = %"NAG_IFMT", %s = %"NAG_IFMT".\n\
  Constraint: %s.",
  "NE_INT_3:\n\
  On entry, %s = %"NAG_IFMT", %s = %"NAG_IFMT", %s = %"NAG_IFMT".\n\
  Constraint: %s.",
  "NE_INT_4:\n\
  On entry, %s = %"NAG_IFMT", %s = %"NAG_IFMT", %s = %"NAG_IFMT", %s = %"NAG_IFMT".\n\
  Constraint: %s.",
  "NE_INT_5:\n\
  On entry, %s = %"NAG_IFMT", %s = %"NAG_IFMT", %s = %"NAG_IFMT", %s = %"NAG_IFMT", %s = %"NAG_IFMT".\n\
  Constraint: %s.",
  "NE_INT_6:\n\
  On entry, %s = %"NAG_IFMT", %s = %"NAG_IFMT", %s = %"NAG_IFMT", %s = %"NAG_IFMT", %s = %"NAG_IFMT", %s = %"NAG_IFMT".\n\
  Constraint: %s.",

  "NE_ENUM_INT:\n\
  On entry, %s = %s, %s = %"NAG_IFMT".\n\
  Constraint: %s.",
  "NE_ENUM_INT_2:\n\
  On entry, %s = %s, %s = %"NAG_IFMT", %s = %"NAG_IFMT".\n\
  Constraint: %s.",
  "NE_ENUM_INT_3:\n\
  On entry, %s = %s, %s = %"NAG_IFMT", %s = %"NAG_IFMT", %s = %"NAG_IFMT".\n\
  Constraint: %s.",
  "NE_ENUM_INT_4:\n\
  On entry, %s = %s, %s = %"NAG_IFMT", %s = %"NAG_IFMT", %s = %"NAG_IFMT", %s = %"NAG_IFMT".\n\
  Constraint: %s.",

  "NE_REAL:\n\
  On entry, %s = %g.\n\
  Constraint: %s.",
  "NE_REAL_2:\n\
  On entry, %s = %g, %s = %g.\n\
  Constraint: %s.",
  "NE_REAL_3:\n\
  On entry, %s = %g, %s = %g, %s = %g.\n\
  Constraint: %s.",
  "NE_REAL_4:\n\
  On entry, %s = %g, %s = %g, %s = %g, %s = %g.\n\
  Constraint: %s.",
  "NE_REAL_5:\n\
  On entry, %s = %g, %s = %g, %s = %g, %s = %g, %s = %g.\n\
  Constraint: %s.",
  "NE_REAL_6:\n\
  On entry, %s = %g, %s = %g, %s = %g, %s = %g, %s = %g, %s = %g.\n\
  Constraint: %s.",

  "NE_ENUM_REAL_1:\n\
  On entry, %s = %s, %s = %g.\n\
  Constraint: %s.",
  "NE_ENUM_REAL_2:\n\
  On entry, %s = %s, %s = %g, %s = %g.\n\
  Constraint: %s.",
  "NE_ENUM_REAL_3:\n\
  On entry, %s = %s, %s = %g, %s = %g, %s = %g.\n\
  Constraint: %s.",
  "NE_ENUM_REAL_4:\n\
  On entry, %s = %s, %s = %g, %s = %g, %s = %g, %s = %g.\n\
  Constraint: %s.",

  "NE_CONSTRAINT:\n\
   General constraint: %s",

  "NE_COMPLEX:\n\
  On entry, %s = ( %g, %g ).\n\
  Constraint: %s.",

  "NE_INT_ARRAY_CONS:\n\
  On entry, %s[%"NAG_IFMT"] = %"NAG_IFMT".\n\
  Constraint: %s %s[%"NAG_IFMT"] %s.", 
  "NE_2_INT_ARRAY_CONS:\n\
  On entry, %s[%"NAG_IFMT"] = %"NAG_IFMT" while %s[%"NAG_IFMT"] = %"NAG_IFMT".\n\
  Constraint: %s.", 
  "NE_2D_INT_ARRAY_CONS:\n\
  On entry, %s[%"NAG_IFMT"][%"NAG_IFMT"] = %"NAG_IFMT".\n\
  Constraint: %s.", 
  "NE_2D_REAL_ARRAY_CONS:\n\
  On entry, %s[%"NAG_IFMT"][%"NAG_IFMT"] = %g.\n\
  Constraint: %s.", 
  "NE_2D_1D_INT_ARRAYS_CONS:\n\
  On entry, %s[%"NAG_IFMT"][%"NAG_IFMT"] = %"NAG_IFMT" while %s[%"NAG_IFMT"] = %"NAG_IFMT".\n\
  Constraint: %s.", 

  "NE_INT_ARG_ENUM_CONS:\n\
  On entry, %s = %1"NAG_IFMT" while %s = %s.\n\
  These parameters must satisfy %s when %s.",
  "NE_2_INT_ARG_ENUM_CONS:\n\
  On entry, %s = %1"NAG_IFMT" while %s = %1"NAG_IFMT" and %s = %s.\n\
  These parameters must satisfy %s when %s.",
  "NE_2_INTARR_INT:\n\
  On entry, %s[%"NAG_IFMT"] = %"NAG_IFMT", while %s = %"NAG_IFMT".\n\
  Constraint: %s %s[%"NAG_IFMT"] %s.", 
  "NE_INTARR:\n\
  On entry, %s[%"NAG_IFMT"] = %"NAG_IFMT".\n\
  Constraint: %s.", 
  "NE_INTARR_INT:\n\
  On entry, %s[%"NAG_IFMT"] = %"NAG_IFMT", %s = %"NAG_IFMT".\n\
  Constraint: %s.", 
  "NE_INTARR_2_INT:\n\
  On entry, %s[%"NAG_IFMT"] = %"NAG_IFMT", %s = %"NAG_IFMT", %s = %"NAG_IFMT".\n\
  Constraint: %s.", 
  "NE_INTARR_3_INT:\n\
  On entry, %s[%"NAG_IFMT"] = %"NAG_IFMT", %s = %"NAG_IFMT", %s = %"NAG_IFMT", %s = %"NAG_IFMT".\n\
  Constraint: %s.", 
  "NE_REALARR:\n\
  On entry, %s[%"NAG_IFMT"] = %g.\n\
  Constraint: %s.", 
  "NE_INCOMP_ARRAYS:\n\
  Arrays %s and %s are not compatible.",
  "NE_REAL_MACH_PREC:\n\
  On entry, %s = %g, machine precision(X02AJC) = %g.\n\
  Constraint: %s.",
  "NE_REAL_INT:\n\
  On entry, %s = %g, %s = %"NAG_IFMT".\n\
  Constraint: %s.",
  "NE_REALARR_REAL:\n\
  On entry, %s[%"NAG_IFMT"] = %g, %s = %g.\n\
  Constraint: %s.", 
  "NW_INT:\n\
  On exit, %s = %"NAG_IFMT".\n\
  Trivial solution returned.", 
  "NW_2_INT:\n\
  On exit, %s = %"NAG_IFMT", %s = %"NAG_IFMT".\n\
  Trivial solution returned.", 
  "NW_REAL_REALARR:\n\
  On entry, %s = %g, %s[%"NAG_IFMT"] = %g.\n\
  Trivial solution returned.",
  "NE_INTARR_REALARR:\n\
  On entry, %s[%"NAG_IFMT"] = %"NAG_IFMT", %s[%"NAG_IFMT"] = %g.\n\
  Constraint: %s.",

/* C02 Chapter */
  "NE_COMPLEX_ZERO:\n\
  On entry, the complex variable %s has zero real and\n\
  imaginary parts.",
  "NE_POLY_NOT_CONV:\n\
  The iterative procedure has failed to converge.\n\
  Please contact NAG immediately, as some basic assumption for the\n\
  arithmetic has been violated.",
  "NE_POLY_UNFLOW:\n\
  The function cannot evaluate p(z) near some of its zeros\n\
  without underflow. Please contact NAG immediately.",
  "NE_POLY_OVFLOW:\n\
  The function cannot evaluate p(z) near some of its zeros\n\
  without overflow. Please contact NAG immediately.",
  "NE_C02_OVERFLOW:\n\
  The companion matrix H cannot be formed without overflow.", 
  "NE_C02_NOT_CONV:\n\
  The iterative procedure used to determine the eigenvalues has failed to converge.",

 /* C05 Errors */
  "NE_FUNC_END_VAL:\n\
  On entry, f(%s) and f(%s) have the same sign, with f(%s) != 0.0.",
  "NE_PROBABLE_POLE:\n\
  Indicates that the function values in the interval %s might\n\
  contain a pole rather than a zero. Reducing xtol may help\n\
  in distinguishing between a pole and a zero.",
  "NE_XTOL_TOO_SMALL:\n\
  No further improvement in the solution is possible.\n\
  xtol is too small: xtol = %11.5e.",
  "NE_TOO_MANY_FUNC_EVAL:\n\
  There have been at least %s evaluation of f().",
  "NE_NO_IMPROVEMENT:\n\
  The iteration is not making good progress.",

 /* C06 Errors */
  "NE_FACTOR_GT:\n\
  At least one of the prime factors of %s is greater than 19.",
  "NE_TOO_MANY_FACTORS:\n\
  %s has more than %1"NAG_IFMT" prime factors.",
  "NE_C06_FACTOR_GT:\n\
  At least one of the prime factors of n is greater than 19.",
  "NE_C06_TOO_MANY_FACTORS:\n\
  n has more than %1"NAG_IFMT" prime factors.",
  "NE_C06_NOT_TRIG:\n\
  Value of %s and %s array are incompatible\n\
  or %s array not initialized.",
  "NE_C06_FACTORS:\n\
  At least one of the prime factors of %s is greater than 19\n\
  or %s has more than %"NAG_IFMT" prime factors.",

/* D01 Errors */
  "NE_QUAD_MAX_SUBDIV:\n\
  The maximum number of subdivisions has\n\
  been reached: %s = %1"NAG_IFMT"" ,
  "NE_QUAD_BAD_SUBDIV:\n\
  Extremely bad integrand behaviour occurs around the\n\
  sub-interval (%14.7e, %14.7e ).",
  "NE_QUAD_BAD_SUBDIV_INTS:\n\
  Extremely bad integrand behaviour occurs around one of the\n\
  sub-intervals (%14.7e, %14.7e ) or (%14.7e, %14.7e ).",
  "NE_QUAD_ROUNDOFF_TOL:\n\
  Round-off error prevents the requested tolerance from\n\
  being achieved:  epsabs = %7.1e,  epsrel =  %7.1e.",
  "NE_QUAD_ROUNDOFF_ABS_TOL:\n\
  Round-off error prevents the requested tolerance from\n\
  being achieved:  epsabs = %7.1e.",
  "NE_QUAD_ROUNDOFF_EXTRAPL:\n\
  Round-off error is detected during extrapolation.",
  "NE_QUAD_NO_CONV:\n\
  The integral is probably divergent or slowly convergent.",
  "NE_QUAD_BRKPTS_INVAL:\n\
  On entry, break points outside (a, b):\n\
  a = %11.5e,  b = %11.5e.",
  "NE_QUAD_BAD_SUBDIV_INT:\n\
  Bad Integration behaviour has occured within one or more intervals.",
  "NE_QUAD_MAX_INT:\n\
  Maximum number of intervals allowed has been achieved.\n\
  Increase the value of maxintervals.",
  "NE_QUAD_EXTRAPL_INT:\n\
  The extrapolation table constructed for convergence acceleration\n\
  of the series formed by the integral contribution over the integral\n\
  does not converge.",
  "NE_QUAD_MAX_SUBDIV_SPEC_INT:\n\
  The maximum number of subdivisions has been reached,\n\
  %s = %1"NAG_IFMT" on the %1"NAG_IFMT" %s interval\n\
  interval_flag[%1"NAG_IFMT"] = %1"NAG_IFMT" over sub-interval (%14.7e, %14.7e).",
  "NE_QUAD_ROUNDOFF_TOL_SPEC_INT:\n\
  Round-off error prevents the requested tolerance from being achieved\n\
  on the %1"NAG_IFMT" %s interval interval_flag[%1"NAG_IFMT"] = %1"NAG_IFMT" over\n\
  sub-interval (%14.7e, %14.7e )" ,
  "NE_QUAD_NO_CONV_SPEC_INT:\n\
  The integral is failed to converge on the %1"NAG_IFMT" %s interval\n\
  interval_flag[%1"NAG_IFMT"] = %1"NAG_IFMT" over sub-interval (%14.7e, %14.7e).",
  "NE_QUAD_DIVERGENCE_SPEC_INT:\n\
  The integral is probably divergent on the %1"NAG_IFMT" %s interval\n\
  interval_flag[%1"NAG_IFMT"] = %1"NAG_IFMT" over sub-interval (%14.7e, %14.7e).",
  "NE_QUAD_BAD_SPEC_INT:\n\
  Bad integrand behaviour occurs at some points of %1"NAG_IFMT"%s interval\n\
  interval_flag[%1"NAG_IFMT"] = %1"NAG_IFMT" over sub-interval (%14.7e, %14.7e)" ,
  "NE_QUAD_GAUSS_NPTS_RULE:\n\
  The N-point rule is not among those stored. The answer is evaluated for %1"NAG_IFMT",\n\
  the largest possible value of npts less than the requested value, %1"NAG_IFMT".",
  "NE_QUAD_GAUSS_CONS:\n\
  Gauss-%s input is invalid with %s %5.3f. Constraint: %s.",
  "NE_QUAD_GAUSS_LAG_HER_WTS:\n\
  Laguerre and Hermite normal weights only: Underflow is occuring in\n\
  evaluating one or more weights. A smaller value of n must be used or\n\
  itype may be set to 1.",
  "NE_QUAD_MAX_INTEGRAND_EVAL:\n\
  %s was too small to obtain the required accuracy.",
  "NE_QUAD_MAX_INTEGRAND_CONS:\n\
  %s %1"NAG_IFMT".\n\
  Constraint: %s.",
  "NE_QUAD_FIRST_TWO_PTS_EQL:\n\
  The sequence %s has first two points equal:\n\
  %s[%1"NAG_IFMT"] = %g, %s[%1"NAG_IFMT"] = %g.",

 /* D02 Errors */
  "NE_XSOL_NOT_RESET:\n\
  On call %1"NAG_IFMT" to the supplied print function xsol was not reset.",
  "NE_XSOL_SET_WRONG:\n\
  xsol was set to a value behind x in the direction of integration \n\
  by the first call to the supplied print function. The integration range\n\
  is [ %12.5e, %12.5e], xsol = %12.5e.",
  "NE_XSOL_INCONSIST:\n\
  On call %1"NAG_IFMT" to the supplied print function xsol was set to a value behind\n\
  the previous value of xsol in the direction of integration.\n\
  Previous xsol = %12.5e, xend = %12.5e, new xsol = %12.5e.",
  "NE_TOL_TOO_SMALL:\n\
  The value of tol, %12.5e, is too small\n\
  for the function to take an initial step.",
  "NE_TOL_PROGRESS:\n\
  The value of tol, %12.5e, is too small for the function to make any\n\
  further progress across the integration range.\n\
  Current value of t = %12.5e.",
  "NE_NO_SIGN_CHANGE:\n\
  No change in sign of the function g(x, y) was detected in\n\
  the integration range.",
  "NE_STATE:\n\
  state not equal to Nag_NewStart on first call.",
  "NE_NEQF_CHANGED:\n\
  state = %s but neqf has been changed. neqf was %1"NAG_IFMT" but is now %1"NAG_IFMT".",
  "NE_NEQG_CHANGED:\n\
  alter_g = Nag_FALSE but neqg has been changed. neqg was %1"NAG_IFMT" but is now %1"NAG_IFMT".",
  "NE_VECTOL_CHANGED:\n\
  state = %s but vectol has been changed.\n\
  vectol was %s but is now %s.",
  "NE_REAL_LT_COND:\n\
  When %s, %s must not be less than %s.\n\
  %s = %8.4e, %s = %8.4e.", 
  "NE_NO_INTEGRATE:\n\
  The integrator function %s has not been called.",
  "NE_NO_STEPS:\n\
  No successful integration steps were taken in the call(s) to\n\
  the integration function %s.",
  "NW_EXTRAPOLATION:\n\
  Extrapolation requested, %s = %10.4e.",
  "NE_NWANT_GT:\n\
  nwant is greater than the value of neqf given to the setup function \n\
  %s. nwant = %1"NAG_IFMT", neqf = %1"NAG_IFMT".",
  "NE_NO_SETUP:\n\
  The setup function %s has not been called.",
  "NE_SETUP_ERROR:\n\
  The call to setup function %s produced an error.",
  "NE_T_SAME_TOUT:\n\
  On entry, tout = t, t is %10.4e.",
  "NE_T_CHANGED:\n\
  The value of t has been changed from %10.4e to %10.4e.\n\
  This is not permitted on a continuation call.",
  "NE_DIRECTION_CHANGE:\n\
  The value of tout, %10.4e, indicates a change in the integration\n\
  direction. This is not permitted on a continuation call.",
  "NE_TOUT_TCRIT:\n\
  tout = %10.4e but crit was set Nag_TRUE in setup call and\n\
  integration cannot be be attempted beyond tcrit = %10.4e.",
  "NE_MAX_STEP:\n\
  The maximum number of steps have been attempted.",
  "NE_ODE_TOL:\n\
  The error tolerances are too stringent. rtol and atol should\n\
  be scaled up by the factor opt.tolfac and the integration\n\
  function reentered. opt.tolfac = %10.4e.",
  "NE_WEIGHT_ZERO:\n\
  An error weight has become zero during the integration,\n\
  see nag_ode_ivp_adams_setup (d02qwc) document; atol[%1"NAG_IFMT"] was set to \n\
  0.0 but y[%1"NAG_IFMT"] is now 0.0. Integration successful as far as t = %10.4e.",
  "NE_STIFF_PROBLEM:\n\
  The problem appears to be stiff.",
  "NE_SINGULAR_POINT:\n\
  A change in sign of an event function has been detected but\n\
  the root-finding process appears to have converged to a singular\n\
  point of t rather than a root.",
  "NE_NO_G_FUN:\n\
  Root finding has been requested by setting neqg > 0, neqg = %1"NAG_IFMT",\n\
  but argument g is a null function.",
  "NE_NEQF:\n\
  The value of neqf supplied is not the same as\n\
  that given to the setup function %s.\n\
  neqf = %1"NAG_IFMT" but the value given to %s was %1"NAG_IFMT".",
  "NE_NEQ:\n\
  The value of neq supplied is not the same as\n\
  that given to the setup function %s.\n\
  neq = %1"NAG_IFMT" but the value given to %s was %1"NAG_IFMT".",
  "NE_LF_B_VAL:\n\
  The number of known left boundary values must be less than\n\
  the number of equations:\n\
  The number of known left boundary values = %1"NAG_IFMT":\n\
  The number of equations = %1"NAG_IFMT".",
  "NE_RT_B_VAL:\n\
  The number of known right boundary values must be less than\n\
  the number of equations:\n\
  The number of known right boundary values = %1"NAG_IFMT":\n\
  The number of equations = %1"NAG_IFMT".",
  "NE_LFRT_B_VAL:\n\
  The sum of known left and right boundary values must equal\n\
  the number of equations:\n\
  The number of known left boundary values = %1"NAG_IFMT":\n\
  The number of known right boundary values = %1"NAG_IFMT":\n\
  The number of equations = %1"NAG_IFMT".",
  "NE_LF_B_MESH:\n\
  On entry, the left boundary value a, has not been set to x[0]:\n\
  a = %g, x[0] = %g.",
  "NE_RT_B_MESH:\n\
  On entry, the right boundary value b, has not been set to x[np-1]:\n\
  b = %g, x[np-1] = %g.",
  "NE_CONV_MESH:\n\
  A finer mesh is required for the accuracy requested; that is mnp is\n\
  not large enough.",
  "NE_CONV_MESH_INIT:\n\
  The Newton iteration failed to converge  on the initial mesh.\n\
  This may be due to the initial mesh having too few points or the initial\n\
  approximate solution being too inaccurate. Try using \n\
  nag_ode_bvp_fd_nonlin_gen (d02rac).",
  "NE_CONV_ROUNDOFF:\n\
  Solution cannot be improved due to roundoff error. Too much accuracy might\n\
  have been requested.",
  "NE_CONV_CONT:\n\
  Convergence failure. There are a number of possible causes.\n\
  a) Faulty coding of the Jacobian calculation functions.\n\
  b) If Jacobians have not been supplied then inaccurate Jacobians have been\n\
     calculated internally(not very likely).\n\
  c) A poor choice of initial mesh or initial starting conditions either by \n\
     the user or by default. Try using the continuation facility.",
  "NE_CONV_JACOBG:\n\
  The Jacobian calculated by jacobg (or the equivalent matrix calculated by\n\
  numerical differentiation) is singular. This may be due to faulty coding\n\
  of jacobg or in some circumstances, to a zero initial choice of \n\
  approximate solution(such as is chosen when init=Nag_DefInitMesh).",
  "NE_CONV_CONT_DEP:\n\
  There is no dependence on epsilon when continuation is being used. This \n\
  may be due to faulty coding of jaceps or jacgep, or in some circumstances,\n\
  to a zero initial choice of approximate  solution(such as is chosen when\n\
  init=Nag_DefInitMesh).",
  "NE_CONV_CONT_DELEPS:\n\
  deleps is required to be less than machine precision for continuation to\n\
  proceed. It is likely that either the problem has no solution for some \n\
  value near the current value of epsilon or that the problem is so \n\
  difficult that even with continuation it is unlikely to be solved using\n\
  this function. Using more mesh points may help.",
  "NE_BOUND_COND_ROW:\n\
  Row %"NAG_IFMT" of the array c and the corrsponding row of array d is identically\n\
  zero. i.e., the boundary conditions are rank deficient.",
  "NE_BOUND_COND_COL:\n\
  More than neq columns of the neq by 2*neq matrix [C,D] are identically\n\
  zero. i.e., the boundary conditions are rank deficient. The number of \n\
  non-identically zero columns is %"NAG_IFMT".",
  "NE_BOUND_COND_MAT:\n\
  One of the matrices C or D is identically zero, i.e. the problem is of\n\
  initial value and not of the boundary type.",
  "NE_BOUND_COND_LC:\n\
  At least one row of the neq by 2*neq matrix [C,D] is a linear combination\n\
  of the other rows, i.e., the boundary conditions are rank deficient. The \n\
  index of first such row is %"NAG_IFMT".",
  "NE_BOUND_COND_NLC:\n\
  At least one row of the neq by 2*neq matrix [C,D] is a linear combination\n\
  of the other rows determined up to a numerical tolerance, i.e., the \n\
  boundary conditions are rank deficient. The index of first such row is %"NAG_IFMT".",
  "NE_INVALID_FUN_JAC:\n\
  Only one of jacobf or jacobg has been set to non-null possibly implying \n\
  user defined jacobians. Both must be non-null.",
  "NE_INVALID_FUN_JAC_CONT:\n\
  deleps has been set to %g implying continuation and both jacobf and jacobg\n\
  have been set to non-null implying user defined jacobians. Hence the \n\
  functions jaceps and jacgep must also be non-null.",
  "NE_INVALID_FUN_JAC_NO_CONT:\n\
  deleps has been set to %g implying no continuation and both jacobf and \n\
  jacobg have been set to non-null implying user defined jacobians. Hence \n\
  the functions jaceps and jacgep must be null.",
  "NE_INVALID_FUN_NO_JAC_CONT:\n\
  deleps has been set to %g implying continuation and both jacobf and \n\
  jacobg have been set to null implying no user defined jacobians. Hence \n\
  the functions jaceps and jacgep must also be null.",
  "NE_RK_INVALID_CALL:\n\
  The function to be called as specified in the setup routine \n\
  %s was %s.\n\
  However the actual call was made to %s.\n\
  This is not permitted.",
  "NE_PREV_CALL:\n\
  The previous call to a function had resulted in a severe error.\n\
  You must call %s to start another problem.",
  "NE_PREV_CALL_INI:\n\
  The previous call to the function %s had \n\
  resulted in a severe error. You must call %s\n\
  to start another problem.",
  "NE_RK_TGOT_EQ_TEND:\n\
  The call to %s has been made after reaching tend. \n\
  The previous call to %s resulted in \n\
  tgot(tstart on the first call) = tend. You must call \n\
  %s to start another problem.",
  "NE_RK_TGOT_RANGE_TEND:\n\
  The call to %s has been made with a twant \n\
  that does not lie between the previous value of tgot(tstart on the \n\
  first call) and tend. This is not permitted.",
  "NE_RK_TGOT_RANGE_TEND_CLOSE:\n\
  The call to %s has been made with a twant \n\
  that does not lie between the previous value of tgot(tstart on the \n\
  first call) and tend. This is not permitted. However twant is very \n\
  close to tend, so you may have meant it to be tend exactly. Check your \n\
  program.",
  "NE_RK_TWANT_CLOSE_TGOT:\n\
  The call to %s has been made with a twant \n\
  that is not sufficiently different from the last value of tgot(tstart \n\
  on the first call). When using method = Nag_RK_7_8, it must differ by \n\
  at least %12.5e.",
  "NE_RK_PCC_METHOD:\n\
  The efficiency of the integration has been degraded. Consider calling\n\
  the set up function nag_ode_ivp_rk_setup (d02pvc) to re-initialize the \n\
  integration at the current point with the method changed to NE_RK_4_5. \n\
  Alternatively nag_ode_ivp_rk_range (d02pcc) can be called again to \n\
  resume at the current point.",
  "NE_RK_PDC_TEND:\n\
  tend( = %12.5e ) has been reached already. To integrate further\n\
  with same problem the function nag_ode_ivp_rk_reset_tend (d02pwc) must \n\
  be called with a new value of tend.",
  "NE_RK_PDC_STEP:\n\
  In order to satisfy the error requirements %s \n\
  would have to use a step size of %12.5e at tnow = %12.5e. \n\
  This is too small for the machine precision.",
  "NE_RK_PDC_POINTS:\n\
  More than 100 output points have been obtained by integrating to tend.\n\
  They have been sufficiently close to one another that the efficiency of \n\
  the integration has been degraded. It would probably be (much) more\n\
  efficient to obtain output by interpolating with nag_ode_ivp_rk_interp \n\
  (d02pxc) (after changing to method = NE_RK_4_5 if you are using \n\
  method = NE_RK_7_8).",
  "NE_RK_PDC_GLOBAL_ERROR_T:\n\
  The global error assessment may not be reliable for t past %s.\n\
  %s = %12.5e\n.",
  "NE_RK_PDC_GLOBAL_ERROR_S:\n\
  The global error assessment algorithm failed at the start of the\n\
  integration.",
  "NE_MISSING_CALL:\n\
  Previous call to %s has not been made\n\
  hence %s must not be called.",
  "NE_RK_DIRECTION_POS:\n\
  Integration is proceeding in the positive direction with the current\n\
  value for the independent variable %s being %12.5e\n\
  However %s has been set to %12.5e. %s must be greater than %s.",
 "NE_RK_DIRECTION_NEG:\n\
  Integration is proceeding in the negative direction with the current\n\
  value for the independent variable %s being %12.5e\n\
  However %s has been set to %12.5e. %s must be less than %s.",
 "NE_RK_STEP:\n\
  The current value of the independent variable %s is %12.5e\n\
  The %s that is supplied has abs(%s-%s) = %12.5e\n\
  For the method and the precision of the computer being used,\n\
  this difference must be at least %12.5e.",
 "NE_ERRASS_REQ:\n\
  No error assessment is available as it was not requested in the call\n\
  to %s.",
 "NE_RK_STIFF:\n\
  The problem has been diagnosed as stiff. If the situation persists,\n\
  it will cost roughly %12.5e times as much to reach tend as it has cost\n\
  to reach tnow. It is probably advisable to change to a code intended for\n\
  stiff problems.",
 "NE_RK_PX_METHOD:\n\
  Interpolation is not available with method = Nag_RK_7_8. Either use \n\
  method = Nag_RK_2_3 or Nag_RK_4_5 for which interpolation is available.\n\
  Alternatively  use nag_ode_ivp_rk_reset_tend (d02pwc) to make \n\
  nag_ode_ivp_rk_onestep (d02pdc) step exactly to the points where you want \n\
  output.",
 "NW_RK_TOO_MANY:\n\
 %"NAG_IFMT" function evaluations have been used to compute the \n\
  solution since the integration started or since this message was last \n\
  printed.",
 "NE_RK_NOSTEP:\n\
  The integrator has not actually taken any successful steps. This \n\
  function must not be called in this circumstance.",
"NE_MEMORY_FREED:\n\
  Internally allocated memory has been freed by a call to \n\
  %s without a subsequent call \n\
  to the set up function %s.",

/* E01 Errors */
  "NE_NOT_MONOTONIC:\n\
  On entry, x[r-1] >= x[r] for r = %1"NAG_IFMT":\n\
  x[r-1] = %5.3f, x[r] = %5.3f.",
  "NW_EXTRAPOLATE:\n\
  Warning - some points in array px lie outside the\n\
  range x[0] .. x[n-1]. Values at these points are unreliable as\n\
  they have been computed by extrapolation.",
  "NE_ABSCI_OUTSIDE_KNOT_INTVL:\n\
  On entry, %s must satisfy\n\
  %s:\n\
  %s = %6.4f,  %s = %6.4f,  %s[%1"NAG_IFMT"] = %6.4f.",
  "NE_KNOTS_OUTSIDE_DATA_INTVL:\n\
  On entry, user-specified knots must be interior to the data interval,\n\
  %s must be greater than %s and %s must be less than %s:\n\
  %s = %6.4f %s = %6.4f %s[%1"NAG_IFMT"] = %6.4f %s[%1"NAG_IFMT"] = %6.4f.",
  "NE_WEIGHTS_NOT_POSITIVE:\n\
  On entry, the weights are not strictly positive: weights[%1"NAG_IFMT"] = %6.4f.",
  "NE_SW_COND_FAIL:\n\
  The conditions specified by Schoenberg and Whitney fail.",
  "NW_INTERVAL_EXTRAPOLATE:\n\
  On entry, limits %s, %s must not be outside interval [x[0],x[n-1]],\n\
  %s = %6.4f, %s = %6.4f, %s = %6.4f, %s[%1"NAG_IFMT"] = %6.4f.\n\
  Extrapolation was performed to compute the integral. The value\n\
  returned is therefore unreliable.",
  "NE_DATA_ILL_CONDITIONED:\n\
  An intermediate set of linear equations is singular, the data is\n\
  too ill-conditioned to compute B-spline coefficients.",
  "NE_KNOTS_DISTINCT_ABSCI_CONS:\n\
  Too many knots for the number of distinct abscissae, mdist:\n\
  %s = %1"NAG_IFMT", the number of distinct abscissae = %1"NAG_IFMT".\n\
  These must satisfy the constraint spline.n <= mdist + 4.",
  "NE_ALL_DATA_COLLINEAR:\n\
  On entry, all the (x,y) pairs are collinear. Consider specifying \n\
  method = Nag_Shep or using a  one-dimensional interpolating function\n\
  e01bac(nag_1d_spline_interpolant).",
  "NE_DATA_NOT_UNIQUE:\n\
  On entry, each data pair is not unique since data points (x[%3"NAG_IFMT"],y[%3"NAG_IFMT"])\n\
  and (x[%3"NAG_IFMT"],y[%3"NAG_IFMT"]) are identical and equal to (%g,%g).",
  "NE_NUM_PARAM_INVALID:\n\
  On entry, either or both of options.nq and options.nw are invalid,\n\
  options.nq = %"NAG_IFMT" and options.nw = %"NAG_IFMT". options.nq and options.nw must\n\
  satisfy the following constraints : 0 < options.nw <= options.nq.",
  "NE_RAD_PARAM_INVALID:\n\
  On entry, either or both of options.rnq and options.rnw are invalid,\n\
  options.rnq = %g and options.rnw = %g. options.rnq and options.rnw must\n\
  satisfy the following constraints : 0 < options.rnw <= options.rnq.",
  "NW_SPARSE_DATA_FIT:\n\
  The minimum number of data points %"NAG_IFMT" that lie within the radius\n\
  options.rnq of any node is small enough to indicate that the interpolant \n\
  may be unsatisfactory in regions where the data points are sparse.\n\
  Current values of other relevant parameters (available as members of the \n\
  structure optional, if this has been defined) are:\n  rnq = %f,\
  rnw = %f,  nq = %"NAG_IFMT",  nw = %"NAG_IFMT".",
  "NE_TRIANG_INVALID:\n\
  On entry, the triangulation information held in the array %s does not\n\
  specify a valid triangulation of the data points. %s may have been\n\
  corrupted since the call to function %s.",
  "NW_VALUE_EXTRAPOLATED:\n\
  The evaluation point, (%12.4e,%12.4e), of (px, py) lies outside the\n\
  triangulation boundary. The returned value, %12.4e, of pf was computed\n\
  by extrapolation.",
 "NE_BAD_INTERPOLANT:\n\
  On entry, the interpolant cannot be evaluated because the evaluation\n\
  point, (%13.5e,%13.5e), is outside the support region of the\n\
  input data points defined by optional.rnw = %13.5e as set in\n\
  nag_2d_scat_interpolant(e01sac).",

/* e02 errors */
  "NE_KNOTS_CONS:\n\
  On entry, the knots must satisfy the following constraints,\n\
  spline.lamda[spline.n-4] > spline.lamda[3],\n\
  spline.lamda[j] >= spline.lamda[j-1], for j = 1,2,...,spline.n-1,\n\
  with equality in the cases j = 1,2,3,spline.n-3,spline.n-2 and spline.n-1.",
  "NE_SPLINE_COEFF_CONV:\n\
  The iterative process has failed to converge.\n\
  Possibly s is too small: s = %6.4f.", 
  "NE_END_KNOTS_CONS:\n\
  On entry, the end knots must satisfy %s,\n\
  %s[%1"NAG_IFMT"] = %6.4lf, %s[%1"NAG_IFMT"] = %6.4lf.",
  "NE_KNOTS_COORD_CONS:\n\
  On entry, the end knots and coordinates must satisfy\n\
  %s and %s.\n\
  %s = %6.4lf,  %s = %6.4lf, %s[%1"NAG_IFMT"] = %6.4lf, %s[%1"NAG_IFMT"] = %6.4lf.",
  "NE_POINT_OUTSIDE_RECT:\n\
  On entry, point (%s[%1"NAG_IFMT"] = %6.4lf, %s[%1"NAG_IFMT"] = %6.4lf)\n\
  lies outside the rectangle bounded by\n\
  %s = %6.4lf, %s[%1"NAG_IFMT"] = %6.4lf,\n\
  %s = %6.4lf, %s[%1"NAG_IFMT"] = %6.4lf.",
  "NE_KNOTS_COINCIDE:\n\
  On entry, no more than four knots in array %s must\n\
  coincide at a single point.",
  "NE_PANEL_ORDER:\n\
  On entry, the data points in array %s must be in panel order.\n\
  e02zac should be called to obtain a correct order.",
  "NE_ALL_ELEMENTS_EQUAL:\n\
  On entry, all the  values in the array %s must not be equal.",
  "NE_NUM_KNOTS_2D_GT_RECT:\n\
  The number of knots  required is greater than allowed by nxest and nyest,\n\
  nxest = %1"NAG_IFMT", nyest = %1"NAG_IFMT". Possibly s is too small, especially if\n\
  nxest, nyest > %s respectively. s = %6.4f, mx = %1"NAG_IFMT", my = %1"NAG_IFMT".",
  "NE_NUM_KNOTS_2D_GT_SCAT:\n\
  The number of knots required is greater than allowed by nxest and nyest,\n\
  nxest = %1"NAG_IFMT", nyest = %1"NAG_IFMT". Possibly s is too small, especially if\n\
  nxest, nyest > %s, s = %6.4f, m = %1"NAG_IFMT".",
  "NE_NUM_COEFF_GT:\n\
  No more knots can be added because the number of B_spline coefficients\n\
  already exceeds m.\n\
  Either m or s is probably too small: m = %1"NAG_IFMT", s = %6.4f.",
  "NE_NUM_KNOTS_1D_GT:\n\
  The number of knots needed is greater than %s, %s = %1"NAG_IFMT".\n\
  If %s is already large say, %s this may indicate that\n\
  possibly %s is too small: %s = %6.4f.",
  "NE_NO_ADDITIONAL_KNOTS:\n\
  No more knots  added; the additional knot would coincide with an old one.\n\
  Possibly an inaccurate data point has too large a weight, or s is too small.\n\
  s = %7.5f.",
  "NE_ENUMTYPE_WARM:\n\
  start has been set to Nag_Warm at the first call of this function.\n\
  It must be set to Nag_Cold at the first call.",
  "NE_NUM_KNOTS_2D_LT:\n\
  On entry, either nxest < mx + 4  or  nyest < my + 4, when s = 0.0.\n\
  nxest = %1"NAG_IFMT", nyest = %1"NAG_IFMT", mx = %1"NAG_IFMT", my = %1"NAG_IFMT".",
  "NE_SF_D_K_CONS:\n\
  On entry, %s = %6.4f, %s = %1"NAG_IFMT", %s = %1"NAG_IFMT".\n\
  Constraint: %s when %s.",
  "NE_SPLINE_RANGE_INVALID:\n\
  On entry, the cubic spline range is invalid, %s = %g while\n\
  %s = %g. These must satisfy %s < %s.",
  "NE_NON_ZERO_WEIGHTS:\n\
  On entry, the number of data points with non-zero weights = %1"NAG_IFMT".\n\
  Constraint, the number of non-zero weights >= 16.",
 "NE_INVALID_XCAP:\n\
  On entry abs(xcap) > 1.0+4*eps, where eps is the machine precision.\n\
  In this case the value of p is set arbitrarily to zero.",


/* E04 Errors */
  "NE_OPT_NOT_INIT:\n\
  Options structure not initialized.",
  "NE_INVALID_OPTION: (line %1"NAG_IFMT")\n\
  %s cannot be assigned to using an options file.",
  "NE_FIELD_UNKNOWN: (line %1"NAG_IFMT")\n\
  '%s' is not a permitted structure\n\
  member or option for %s.",
  "NE_INVALID_OPTION_NAME: (line %1"NAG_IFMT")\n\
  '%s' is not a valid name for a structure\n\
  member or option.",
  "NE_INVALID_VALUE: (line %1"NAG_IFMT")\n\
  value '%s' given to %s is not\n\
  of the correct type for this option.",
  "NE_NO_VALUE: (line %1"NAG_IFMT")\n\
  no value found for option %s.",
  "NE_UNBALANCED_COMMENT:\n\
  Unbalanced comment starting on line %1"NAG_IFMT" found in options file.",
  "NW_SMALL_DERIV:\n\
  The test of the derivatives was inconclusive, this outcome usually\n\
  occurs because the derivatives are small. The test may be repeated\n\
  using a different initial point.",
  "NE_DERIV_ERRORS:\n\
  Large errors were found in the derivatives of the objective function%s.",
  "NE_GRAD_TOO_SMALL:\n\
  The gradient at the starting point is too small, rerun the problem at\n\
  a different starting point.",
  "NE_SVD_FAIL:\n\
  The computation of the singular value decomposition of the Jacobian\n\
  matrix has failed to converge in a reasonable number of sub-iterations.",
  "NW_NO_IMPROVEMENT:\n\
  A sufficient decrease in the function value could not be attained during\n\
  the final linesearch. Current point cannot be improved upon.",
  "NW_COND_MIN:\n\
  The conditions for a minimum have not all been satisfied but a lower\n\
  point could not be found.", 
  "NW_TOO_MANY_ITER:\n\
  The maximum number of iterations, %1"NAG_IFMT", have been performed.",
  "NW_STEP_BOUND_TOO_SMALL:\n\
  Computed upper-bound on step length was too small.",
  "NE_MISSING_DERIV:\n\
  One or more gradient elements not assigned by objfun().",
  "NE_INVALID_TEXT_RANGE:\n\
  Value %s given to %s not valid.",
  "NE_INVALID_ENUM_RANGE:\n\
  Enum value %s given to %s is\n\
  not valid for this function.",
  "NE_NOT_FUN_NAME:\n\
  The string, %s, supplied in the parameter name\n\
  is not the name of any C Library function with option setting facilities.",
  "NE_CHOLESKY_OVERFLOW:\n\
  An overflow would have occurred during the updating of the Cholesky\n\
  factors if the calculations had been allowed to continue.\n\
  Restart from the current point with options.init_state = Nag_Init_None.",
  "NW_LOCAL_SEARCH:\n\
  The local search has failed to find a feasible point which gives a\n\
  significant change of function value.",
  "NE_BOUND:\n\
  The lower bound for variable %1"NAG_IFMT" (array element bl[%1"NAG_IFMT"])\n\
  is greater than the upper bound.",
  "NE_BOUND_LCON:\n\
  The lower bound for linear constraint %1"NAG_IFMT" (array element bl[%1"NAG_IFMT"])\n\
  is greater than the upper bound.",
  "NE_BOUND_NLCON:\n\
  The lower bound for non-linear constraint %1"NAG_IFMT" (array element bl[%1"NAG_IFMT"])\n\
  is greater than the upper bound.",
  "NE_BOUND_EQ:\n\
  The lower bound and upper bound for variable %1"NAG_IFMT" (array\n\
  elements bl[%1"NAG_IFMT"] and bu[%1"NAG_IFMT"]) are equal but they are greater\n\
  than or equal to options.inf_bound.",
  "NE_BOUND_EQ_LCON:\n\
  The lower bound and upper bound for linear constraint %1"NAG_IFMT" (array\n\
  elements bl[%1"NAG_IFMT"] and bu[%1"NAG_IFMT"]) are equal but they are greater\n\
  than or equal to options.inf_bound.",
  "NE_BOUND_EQ_NLCON:\n\
  The lower bound and upper bound for nonlinear constraint %1"NAG_IFMT" (array\n\
  elements bl[%1"NAG_IFMT"] and bu[%1"NAG_IFMT"]) are equal but they are greater\n\
  than or equal to options.inf_bound.",
  "NE_FD_INT:\n\
  Finite difference interval for variable %1"NAG_IFMT" (array element\n\
  options.delta[%1"NAG_IFMT"]) is negative or so small that x + interval = x.",
  "NE_HESD:\n\
  The initial values of the supplied options.hesd has some value(s)\n\
  which is negative or too small or the ratio of the largest element\n\
  of hesd to the smallest is too large.",
  "NE_CANCEL_ERR:\n\
  The overall relative cancellation error in the gradient estimate, g, or\n\
  the expected search direction, p, is larger than 0.1.\n\
  The user should attempt to select another starting point.",
  "NE_INIT_MEM:\n\
  Option init_state = %s but the pointer %s\n\
  in the option structure has not been allocated memory.",
  "NE_NO_MEM:\n\
  Option init_state = %s but at least one of the pointers\n\
  %s in the option structure has not been\n\
  allocated memory.",
  "NE_SINGULAR_VALUES:\n\
  The singular values are all zero, so that at the solution the\n\
  Jacobian matrix has rank 0.",
  "NW_LIN_DEPEND:\n\
  At the solution the Jacobian matrix contains linear, or near linear,\n\
  dependencies amongst its columns. J assumed to have rank %1"NAG_IFMT".",
  "NE_SVD_ZERO:\n\
  On entry, svd = Nag_TRUE but singular value %1"NAG_IFMT",\n\
  array element s[%1"NAG_IFMT"], is zero.",
  "NE_C_OVERFLOW:\n\
  Overflow will occur in computing an element of C. The upper triangular\n\
  matrix U must be nearly singular.",
  "NW_DEAD_POINT:\n\
  Iterations terminated at a dead point (check the optimality conditions).",
  "NW_SOLN_NOT_UNIQUE:\n\
  Optimal solution is not unique.",
  "NE_UNBOUNDED:\n\
  Solution appears to be unbounded.",
  "NW_NOT_FEASIBLE:\n\
  No feasible point was found for the linear constraints.",
  "NW_LIN_NOT_FEASIBLE:\n\
  No feasible point was found for the linear constraints and bounds.",
  "NW_NONLIN_NOT_FEASIBLE:\n\
  No feasible point was found for the nonlinear constraints.",
  "NE_HESS_TOO_BIG:\n\
  Reduced Hessian exceeds assigned dimension. %s = %1"NAG_IFMT".\n",
  "NW_OVERFLOW_WARN:\n\
  Serious ill-conditioning in the working set after adding constraint %1"NAG_IFMT".\n\
  Overflow may occur in subsequent iterations.\n",
  "NE_STATE_VAL:\n\
  options.state[%1"NAG_IFMT"] is out of range. state[%1"NAG_IFMT"] = %1"NAG_IFMT".",
  "NE_STR_UNKNOWN:\n\
  string supplied, %s, does not match name of any\n\
  pointer in the options structure.\n",
  "NE_STOP_LT_START:\n\
  Value given to obj_check_stop, %1"NAG_IFMT", is less than value given\n\
  to obj_check_start, %1"NAG_IFMT".",
  "NE_CHECK_LT_ONE:\n\
  Value %1"NAG_IFMT" given to %s is less than 1.",
  "NE_WARM_START:\n\
  options.start = Nag_Warm but pointer options.state = NULL.",
  "NE_CVEC_NULL:\n\
  options.prob = %s but argument cvec = NULL.",
  "NE_H_NULL:\n\
  options.prob = %s, qphess is NULL but argument h is also NULL.\n\
  If the default function for qphess is to be used for this problem\n\
  then an array must be supplied in parameter h.",
  "NE_H_NULL_QP:\n\
  options.prob = %s but argument h = NULL.\n\
  This problem type requires an array to be supplied in parameter h.",
  "NW_NOT_CONVERGED:\n\
  Optimal solution found, but the sequence of iterates has not\n\
  converged with the requested accuracy.",
  "NW_KT_CONDITIONS:\n\
  The current point cannot be improved upon. The final point does\n\
  not satisfy the first-order Kuhn-Tucker conditions and no improved\n\
  point for the merit function could be found during the final linesearch.",
  "NE_INVALID_BEGIN:\n\
  The Begin statement occuring in the data file from which options are\n\
  being read is not valid.",
  "NW_LAGRANGE_MULT_ZERO:\n\
  All the Lagrange-multiplier estimates which are not indisputably positive\n\
  lie close to zero.",
  "NE_CYCLING:\n\
  The algorithm could be cycling since a total of 50 changes were made\
  to the working set without altering x. Check the detailed iteration\
  printout for repeated pattern of constraint deletions and additions.",
  "NE_OBJ_BOUND:\n\
  Invalid %s bound for objective row. Bound should be %s %1g.",
  "NE_DUPLICATE_ELEMENT:\n\
  Duplicate sparse matrix element found in row %1"NAG_IFMT", column %1"NAG_IFMT".",
  "NE_HESS_INDEF:\n\
  The Hessian matrix H appears to be indefinite.\n",
  "NE_BASIS_ILL_COND:\n\
  Numerical error in trying to satisfy the general constraints.\n\
  The basis is very ill-conditioned.",
  "NE_OUT_OF_WORKSPACE:\n\
  There is insufficient workspace for the basis factors, and\n\
  the maximum allowed number of reallocation attempts, as\n\
  specified by options.max_restart, has been reached.",
  "NE_BASIS_SINGULAR:\n\
  The basis is singular after %1"NAG_IFMT" attempts to factorize it.",
  "NE_NULL_QPHX:\n\
  Since argument ncolh is non-zero, the problem is assumed to be\n\
  of type QP. However, the argument qphx is a null function.\n\
  qphx must be non-null for QP problems.",
  "NE_NAME_TOO_LONG:\n\
  The string pointed to by options.crnames[%1"NAG_IFMT"]\n\
  is too long. It should be no longer than %1"NAG_IFMT" characters.",
  "NE_STATE_VAL_ARG:\n\
  state[%1"NAG_IFMT"] is out of range. state[%1"NAG_IFMT"] = %1"NAG_IFMT".",
  "NE_NAMES_NOT_NAG_MEM:\n\
  options.crnames is not null but does not point to memory allocated\n\
  by an earlier call to this function. This function does not accept\n\
  user-allocated memory assigned to crnames.",
  "NE_NULL_ARGUMENT:\n\
  Argument %s is a null pointer. It should contain the address\n\
  of a variable of type %s.",
  "NE_B_NULL:\n\
  options.prob = %s but argument b is NULL.",
  "NW_MAX_FUN:\n\
  The maximum number of function calls, %1"NAG_IFMT", have been performed.",
  "NE_H_FORWARD_NULL:\n\
  options.use_hfwd_init = Nag_TRUE but argument h_forward is NULL.",
  "NW_DERIV_INFO:\n\
  On exit, at least one element of the deriv_info array does not\n\
  contain the value Nag_Deriv_OK. This does not necessarily\n\
  represent an unsuccessful exit.",
  "NE_INFEASIBLE:\n\
  Infeasible problem, nonlinear infeasibilities minimized.\n\
  Sum of infeasibiliites: %16.7g",
  "NE_LIN_NOT_FEASIBLE:\n\
  No feasible point was found for the linear constraints.\n\
  Sum of infeasibilities: %16.7g",
  "NE_NONLIN_NOT_FEASIBLE:\n\
  No feasible point was found for the nonlinear constraints.\n\
  Sum of infeasibilities: %16.7g",
  "NE_MAYBE_UNBOUNDED:\n\
  Violation limit exceeded. The problem may be unbounded.",
  "NE_TOO_MANY_ITER:\n\
  Iteration Limit (options.iter_lim=%"NAG_IFMT") exceeded.",
  "NE_TOO_MANY_MAJOR_ITER:\n\
  Major Iteration limit (options.major_iter_lim=%"NAG_IFMT") exceeded.",
  "NE_TOO_MANY_MINOR_ITER:\n\
  Minor Iteration limit (options.minor_iter_lim=%"NAG_IFMT") exceeded.",
  "NE_SUPERBASICS_LIMIT:\n\
  Too many superbasic variables (options.max_sb=%"NAG_IFMT").",
  "NE_OBJ_DERIV_ERRORS:\n\
  Subroutine objfun appears to be giving incorrect gradients.",
  "NE_CON_DERIV_ERRORS:\n\
  Subroutine confun appears to be giving incorrect gradients.",
  "NE_NO_IMPROVE:\n\
  The current point cannot be improved on.",
  "NE_CANNOT_CALCULATE:\n\
  The objective and/or constraint functions could not be calculated.",
  "NE_NOT_REQUIRED_ACC:\n\
  Feasible solution, but required accuracy could not be achieved.",

/* F chap Errors */
  "NE_SINGULAR:\n\
  The matrix a is singular, possibly due to rounding errors.",
  "NE_NOT_POS_DEF:\n\
  The matrix is not positive-definite, possibly due to rounding errors.",
  "NE_NOT_POS_DEF_FACT:\n\
  The matrix is not positive-definite, possibly due to rounding errors.\n\
  The factorization has been completed but may be very inaccurate.",
  "NE_ZERO_DIAG:\n\
  The diagonal matrix %s is singular as it has at least one zero element.\n\
  The first zero element has been located in the array %s[%1"NAG_IFMT"].",
  "NE_NOT_UNIT_DIAG:\n\
  The lower triangular matrix %s has at least one element which is\n\
  not equal to unity. The first non-unit element has been located in\n\
  the array %s[%1"NAG_IFMT"].",
  "NE_TOO_MANY_ITERATIONS:\n\
  More than %1"NAG_IFMT" iterations are required to isolate all the eigenvalues.",
  "NE_TDQ_LT_M:\n\
  On entry, %s = %1"NAG_IFMT" while %s = %1"NAG_IFMT".\n\
  When wantq is Nag_TRUE and m < n then constraint %s >= %s applies.",
  "NE_TDQ_LT_N:\n\
  On entry, %s = %1"NAG_IFMT" while %s = %1"NAG_IFMT".\n\
  When wantq is Nag_TRUE the constraint %s >= %s applies.",
  "NE_TDP_LT_N:\n\
  On entry, %s = %1"NAG_IFMT" while %s = %1"NAG_IFMT".\n\
  When wantq and wantp are Nag_TRUE and m >= n then constraint\n\
  %s >= %s applies.",
  "NE_QR_NOT_CONV:\n\
  The QR algorithm has failed to converge in %1"NAG_IFMT" iterations.\n\
  Singular values 1, 2, ... , failinfo may not have been found \n\
  correctly and the remaining singular values may not be the smallest.",
  "NE_RANK_LT_N:\n\
  The rank of A is less than n.",
  "NE_RANK_LT_NOT_UNIQ:\n\
  The rank of A is less than n; the problem does not have a unique solution.",
  "NE_ITER_FAIL_CONV:\n\
  The iterative refinement fails to converge,\n\
  i.e. the matrix A is too ill-conditioned.",
  "NE_DIAG_IMAG_NON_ZERO:\n\
  Matrix diagonal element %s has non-zero imaginary part.",
  "NE_SINGULAR_DET_ZERO:\n\
  The matrix A is singular, possibly due to rounding errors;\n\
  det is set to zero.",
  "NE_DET_OVERFLOW:\n\
  The value of the determinant is too large to be held in the computer.",
  "NE_DET_UNDERFLOW:\n\
  The value of the determinant is too small to be held in the computer.",
  "NE_ITERATIONS_QZ:\n\
  More than n*30 iterations are required to determine all the\n\
  diagonal 1 by 1 or 2 by 2 blocks of the quasi-triangular form in\n\
  the second step of the QZ algorithm. This failure occurs at the\n\
  ith eigenvalue, i = %1"NAG_IFMT". alfa[j], beta[j] are correct for\n\
  j = i,i+1,i+2,...,n-1, but v does not contain any correct eigenvectors.",
  "NE_MATRIX_NOT_ZERO:\n\
  The matrix E is not identically zero, i.e. the matrix G is\n\
  not positive-definite. Row number %1"NAG_IFMT" required the most\n\
  perturbation when making G into the positive-definite matrix (G + E).",
  "NE_QR_FAIL_CONV:\n\
  The QR algorithm has failed to converge in %1"NAG_IFMT" iterations.\n\
  This failure can only occur when the singular value decomposition\n\
  is employed, but even then it is unlikely to occur.",
  "NE_MAT_SINGULAR:\n\
  The matrix %s is singular.",
  "NE_QR_FAIL:\n\
  The QR algorithm failed to compute all the eigenvalues. No eigenvectors have been\n\
  computed.",
  "NE_REQD_EIGVAL:\n\
  There are more than %s eigenvalues in the specified range. The actual number of\n\
  eigenvalues in the range \n\
  is returned in %s. No eigenvectors have been computed.",
  "NE_EIGVEC:\n\
  Inverse iteration failed to compute all the specified eigenvectors. If an eigenvector failed\n\
  to converge, the corresponding column of %s is set to zero.",
  /* F07/F08 LAPACK  errors */
  "NE_FORMAT_LEN:\n\
  %s has more than %1"NAG_IFMT" characters: the first 75 are\n    %.75s.",
  "NE_INVALID_FORMAT:\n\
  The string \"%s\",\n\
  has not been recognised as a valid format.",
  "NE_COL_WIDTH:\n\
  %s is not wide enough \n\
  to hold at least one matrix column:\n\
  %s = %16"NAG_IFMT", %s =%16"NAG_IFMT".",
  "NE_EXCHANGE:\n\
  Two adjacent diagonal elements or blocks could not be successfully\n\
  exchanged. This error implies that the problem is very ill-conditioned.\n\
  On exit, T may have been partially reordered, and ILST\n\
  points to the first row of the current position of the block being\n\
  moved; Q (if requested) is updated consistently with T.",
  "NE_REORDER:\n\
  The reordering of T failed because a selected eigenvalue was too\n\
  close to a non-selected eigenvalue and at least one of the eigenvalues\n\
  involved was complex; the problem is too ill-conditioned.\n\
  On exit, T may have been partially reordered, but WR, WI and Q \n\
  (if requested) are updated consistently with T; S and SEP (if requested)\n\
  are both set to zero.",
  "NE_PERTURBED:\n\
  A and B have common or close eigenvalues, perturbed values of which were\n\
  used to solve the equation.",
/* F11 errors */
  "NE_SYMM_MATRIX:\n\
  A non-zero matrix element has been supplied which does not lie in the lower\n\
  triangular  part of the matrix A, i.e., one or more of the following constraints\n\
  has been violated:\n\
  1 =< irow[i] =< n, 1 =< icol[i] =< irow[i],  for i = 0,1,...,nnz-1.",
  "NE_ZERO_DIAGONAL_ELEM:\n\
  On entry, the matrix A has a zero diagonal element. Jacobi and SSOR\n\
  preconditioners are not appropriate for this problem.",
  "NE_PRECOND_NOT_POS_DEF:\n\
  The preconditioner appears not to be positive-definite (conjugate gradient\n\
  method only).",
  "NE_COEFF_NOT_POS_DEF:\n\
  The matrix of coefficients appears not to be positive-definite.",
  "NE_NOT_REQ_ACC:\n\
  The required accuracy has not been obtained in maxitn iterations.",
  "NE_ACC_LIMIT:\n\
  The required accuracy could not be obtained. However, a reasonable\n\
  accuracy has been obtained and further iterations cannot improve the result.",
  "NE_SYMM_MATRIX_DUP:\n\
  A non-zero element has been supplied which does not lie in the lower triangular\n\
  part of the matrix A, is out of order, or has duplicate row and column indices \n\
  i.e., one or more of the following constraints has been violated:\n\
  1 <= irow[i-1] <= n, 1 <= icol[i-1] <= irow[i-1],  for i = 1,2,...,nnz-1.\n\
  irow[i-1] < irow[i], or \n\
  irow[i-1] = irow[i] and icol[i-1] < icol[i], for i = 1,2,...,nnz-1.",
  "NE_INVALID_ROW_PIVOT:\n\
  On entry, pstrat = Nag_SparseSym_UserPiv, but array ipiv does not represent a\n\
  valid permutation of integers in [1,n].\n\
  An input value of ipiv is either out of range or repeated.",
  "NE_LA_TOO_SMALL:\n\
  The value of la is too small, resulting in insufficient storage space for the\n\
  fill-in elements. The decomposition has been terminated before completion.\n\
  Either increase la or reduce the amount of fill.",
  "NE_INVALID_SCS:\n\
  The SCS representation of the matrix A is invalid. Check that the call to\n\
  nag_sparse_sym_chol_sol (f11jcc) has been preceded by a valid call to\n\
  nag_sparse_sym_chol_fac (f11jac), and that the arrays a, irow and icol\n\
  have not been corrupted between the two calls.",
  "NE_INVALID_SCS_PRECOND:\n\
  The SCS representation of the preconditioning matrix M is invalid. Check that the\n\
  call to nag_sparse_sym_chol_sol (f11jcc) has been preceded by a valid call to\n\
  nag_sparse_sym_chol_fac (f11jac), and that the arrays a, irow, icol, ipiv\n\
  and istr have not been corrupted between the two calls.",
  "NE_NON_ZERO_DUP:\n\
  Non-zero elements have been supplied which have duplicate row and column indices.",
  "NE_ZERO_COEFF:\n\
  At least one matrix element has been supplied with a zero coefficient value.",
  "NE_INVALID_CS:\n\
  On entry, the CS representation of A is invalid. Check that the call to \n\
  nag_sparse_nsym_fac_sol (f11dcc) has been preceded by a valid call to \n\
  nag_sparse_nsym_fac (f11dac), and that the arrays a, irow and icol\n\
  have not been corrupted between the two calls.",
  "NE_INVALID_CS_PRECOND:\n\
  On entry, the CS representation of the preconditioning matrix M is invalid. Check \n\
  that the call to nag_sparse_nsym_fac_solve (f11dcc) has been preceded by a valid\n\
  call to f11dac, and that the arrays a, irow, icol, ipivp, ipivq, istr and idiag\n\
  have not been corrupted between the two calls.",
  "NE_INVALID_ROWCOL_PIVOT:\n\
  On entry, pstrat = Nag_SparseNsym_UserPiv, but one or both of the arrays ipivp and\n\
  ipivq does not represent a valid permutation of the integers in [1,n]. An input\n\
  value of ipivp or ipivq is either out of range or repeated.",
  "NE_NONSYMM_MATRIX:\n\
  A non-zero matrix element has been supplied which does not lie within the\n\
  matrix A, i.e., one or more of the following constraints has been violated:\n\
  1 =< irow[i] =< n, 1 =< icol[i] =< n,  for i = 0,1,...,nnz-1.",
  "NE_NONSYMM_MATRIX_DUP:\n\
  A non-zero matrix element has been supplied which does not lie within the\n\
  matrix A, is out of order or has duplicate row and column indices, i.e., \n\
  one or more of the following constraints has been violated:\n\
  1 <= irow[i-1] <= n, 1 =< icol[i-1] <= n,  for i = 1,2,...,nnz.\n\
  irow[i-1] < irow[i], or \n\
  irow[i-1] = irow[i] and icol[i-1] < icol[i], for i = 1,2,...,nnz-1.",

/* G01 Errors */
  "NE_NEG_WEIGHT:\n\
  On entry, at least one of the weights is negative.",   
  "NE_CASES_ZERO:\n\
  Number of valid cases is 0.",
  "NE_CASES_ONE:\n\
  Number of valid cases is 1.",
  "NE_FUN_INF:\n\
  Function argument would result in the function value being infinite.",
  "NE_GAM_NOT_CONV:\n\
  The series used to calculate the gamma probabilities has failed to converge.",
  "NE_RES_NOT_ACC:\n\
  The requested accuracy has not been achieved. Use a larger value of tol.",
  "NE_ALG_NOT_CONV:\n\
  The algorithm has failed to converge in %1"NAG_IFMT" iterations.",
  "NE_SOL_CLOSE_TO_ZERO:\n\
  The solution is too close to zero to be determined accurately.",
  "NE_SOL_NOT_CONV:\n\
  The solution has failed to converge.\n\
  However, the result should be a reasonable approximation.",
  "NE_ACC_IN_DOUBT:\n\
  There is doubt concerning the accuracy of the computed result.",
  "NE_PROBAB_CLOSE_TO_TAIL:\n\
  The probability is too close to 0.0 or 1.0.",
  "NE_ARG_TOO_LARGE:\n\
  On entry, %s is too large to be represented exactly as as a real number.",
  "NE_VARIANCE_TOO_LARGE:\n\
  On entry, the variance %s exceeds 1.0e+06.",
  "NE_SAMPLES_NOT_IN_ORDER:\n\
  On entry, the elements in %s are not in ascending or descending order.",
  "NE_SAMPLES_ARE_ALL_EQUAL:\n\
  On entry, the elements in %s are all equal.",
  "NE_NORMAL_SCORE_EST:\n\
  The function was unable to estimate the scores with estimated error\n\
  less than etol = %g. The estimated maximum error, errest = %g.",
  "NE_SERIES:\n\
  One of the series has failed to converge with df = %g and\n\
  max_iter = %"NAG_IFMT". Reconsider the requested tolerance and/or the maximum \n\
  number of iterations.",
  "NE_PROBABILITY:\n\
  The probability is too small to calculate accurately.",
  "NE_POISSON_WEIGHT:\n\
  The initial value of the Poisson weight used in the summation of (1) (see the\n\
  function document, section 3) was too small to be calculated. The computed \n\
  probability is likely to be zero.",
  "NE_TERM_LARGE:\n\
  The value of a term required in (2)(see the function document, section 3) is\n\
  too large to be evaluated accurately. The most likely cause of this error is\n\
  both x and lambda are too large.",
  "NE_CHI_PROB:\n\
  The calcualations for the central chi-square probability has failed to converge.\n\
  A larger value of tol should be used.",
  "NE_CONV:\n\
  The solution has failed to converge in %"NAG_IFMT" iterations, consider increasing\n\
 %s.",
  "NE_PROB_F:\n\
  The required probability cannot be computed accurately. This may happen if the\n\
  result would be very close to zero or one. Alternatively the values of df1 and\n\
  f may be too large. In the latter case the user could try using a normal \n\
  approximation, see Abramowitz and Stegun.",
  "NE_PROB_F_INIT:\n\
  The required accuracy was not achieved when calculating the initial value\n\
  of the central F or chi-square probability. The user should try a larger\n\
  value of tol. If the chi-square approximation is being used then g01gdc\n\
  returns zero otherwise the value returned should be an approximation to\n\
  the correct value.",
  "NE_PROB_LIMIT:\n\
  The probability is too close to 0.0 or 1.0 for the algorithm to be able\n\
  to calculate the required probability. g01gec will return 0.0 or 1.0 as\n\
  appropriate. This should be a reasonable approximation.",
  "NE_PROB_B_INIT:\n\
  The required accuracy was not achieved when calculating the initial value\n\
  of the beta distribution. The user should try a larger value of tol. \n\
  The returned value will be an approximation to the correct value.",

/* G02 Errors */
  "NE_BAD_SX_OR_IP:\n\
  Either a value of sx is < 0, or ip is incompatible with\n\
  mean and sx, or ip > the effective number of observations.",
  "NE_ZERO_DOF_RESID:\n\
  The degrees of freedom for the residuals are zero, i.e. the designated\n\
  number of parameters = the effective number of observations.",
  "NE_SVD_NOT_CONV:\n\
  A singular value decomposition has failed to converge.",
  "NE_MAT_NOT_UPD:\n\
  The R matrix could not be updated: attempt to, either, delete non-existent\n\
  observation, or, add an observation to R matrix with zero diagonal element.",
  "NE_RSS_NOT_UPD:\n\
  The rss could not be updated because the input rss was less\n\
  then calculated decrease in rss when the new observation is deleted.",
  "NE_DOF_LE_ZERO:\n\
  The degrees of freedom for error are <= zero.",
  "NE_NVAR_NOT_IND:\n\
  The new independent variable is a linear combination of the\n\
  existing variables. The (ip+1)th column of q is, therefore, null.",
  "NE_ZERO_DIAG_ELEM:\n\
  On entry, a diagonal element of the independent variable r is zero.",
  "NE_RESID_LARG:\n\
  On entry, the value of a residual is too large for the\n\
  given value of rms: %s = %g, %s = %g.",
  "NE_SVD_RANK_NE_IP:\n\
  On entry, the boolean variable, svd, is Nag_FALSE and rank\n\
  must be equal to ip: rank = %1"NAG_IFMT", ip = %1"NAG_IFMT".",
  "NE_SVD_RANK_GT_IP:\n\
  On entry, the Nag_Boolean variable, svd, is Nag_TRUE and rank\n\
  must not be greater than ip: rank = %1"NAG_IFMT", ip = %1"NAG_IFMT".",
  "NE_ILLCOND:\n\
  On entry, the matrix a is too ill-conditioned to produce a\n\
  correctly rounded solution.",
  "NE_IP_INCOMP_WITH_SX:\n\
  On entry, for mean = %s, number of non-zero values of sx\n\
  must be equal to %s: number of non-zero values of sx = %1"NAG_IFMT", %s = %1"NAG_IFMT".",
  "NE_MAT_NOT_FULL_RANK:\n\
  Matrix %s does not give a model of full rank.",
  "NE_STDES_ZERO:\n\
  sestat, the standard error of the estimate of the function, se(F) = 0.0;\n\
  probably due to rounding error or due to incorrectly specified input values\n\
  of cov and f.",
  "NE_RANK_EQ_IP:\n\
  On entry, rank = ip. In this case, the boolean variable\n\
  est is returned as Nag_TRUE and all statistics are calculated.",
  "NE_DIAG_ELEM_ZERO:\n\
  On entry, a diagonal element, %s, of R is zero.",
  "NE_SW_LT_ONE:\n\
  On entry, the sum of weights is less than 1.0.",
  "NE_VAR_EQ_ZERO:\n\
  At least one variable has zero variance. In this case v and std are as \n\
  calculated, but r will contain zero for any correlation involving a \n\
  variable with zero variance.",
  "NE_NEG_SX:\n\
  On entry, at least one element of sx is negative.",
  "NE_POS_SX:\n\
  On entry, sx does not contain a positive element.",
  "NE_WT_LOW:\n\
  On entry, wt must contain 1 positive element if mean = Nag_AboutZero or at\n\
  least 2 positive elements if mean = Nag_AboutMean.",
  "NE_SW_LOW:\n\
  On entry, the sum of elements of wt must be greater than 1.0 if \n\
  mean = Nag_AboutZero or greater than 2.0 if mean = Nag_AboutMean.",
  "NW_RSS_EQ_ZERO:\n\
  Residual sum of squares is zero, i.e. a perfect fit was obtained.",
  "NW_RMS_EQ_ZERO:\n\
  Residual mean sum of squares is zero, i.e. a perfect fit was obtained.",
  "NE_SOBS_LOW:\n\
  Too few observations have been selected.\n\
  On entry, sobs must contain at least 2 positive elements.",
  "NE_SVAR_LOW:\n\
  No variables have been selected.\n\
  On entry, svar must contain at least 1 positive element.",
  "NE_X_OR_Y_IDEN:\n\
  On entry, all elements of x and/or y are equal.",
  "NE_X_IDEN:\n\
  On entry, all elements of x are equal.",

  "NE_PREC_NOT_INIT:\n\
  On entry, the structure prec is specified but has not been successfully\n\
  initialised using macro INIT_PREC(prec) before calling routine %s.",
  "NE_STRUCT_NOT_DEFINED:\n\
  On entry, the structure %s is not defined. This structure must not\n\
  be defined as a NULL pointer.",
  "NE_EX_POWER_EQ_ZERO:\n\
  On entry, if link = Nag_Expo, power must not be equal 0.0: power = 0.0.",
  "NE_IP_INCOMP_SX:\n\
  Parameter ip is incompatible with parameters mean and sx.",
  "NE_IP_GT_OBSERV:\n\
  Parameter ip is greater than the effective number of observations.",
  "NE_VALUE_AT_BOUNDARY_A:\n\
  A fitted value is at a boundary. This will only occur with link = Nag_Expo,\n\
  Nag_Log or Nag_Reci. This may occur if there are small values of y and the\n\
  model is not suitable for the data. The model should be reformulated with,\n\
  perhaps, some observations dropped.",
  "NE_VALUE_AT_BOUNDARY_B:\n\
  A fitted value is at a boundary i.e. 0.0 or 1.0. This may occur if there\n\
  are y values of 0.0 or binom_t and the model is too complex for the data.\n\
  The model should be reformulated with perhaps some observations dropped.",
  "NE_VALUE_AT_BOUNDARY_C:\n\
  A fitted value is at a boundary i.e. u_^ = 0. This may occur if there\n\
  are y values of 0.0 and the model is too complex for the data. The model\n\
  should be reformulated with, perhaps, some observations dropped.",
  "NE_VALUE_AT_BOUNDARY_D:\n\
  A fitted value is at a boundary i.e. u_^ = 0. This may occur if there\n\
  are small y values of and the model is not suitable for the data. The model\n\
  should be reformulated with, perhaps, some observations dropped.",
  "NE_LSQ_ITER_NOT_CONV:\n\
  The iterative weighted least-squares has failed to converge in \n\
  max_iter = %"NAG_IFMT" iterations. The value of max_iter could be increased \n\
  but it may be advantageous to examine the convergence using the print_iter\n\
  option. This may indicate that the convergence is slow because the\n\
  solution is at a boundary in which case it may be better to reformulate\n\
  the model.",
  "NE_RANK_CHANGED:\n\
  The rank of the model has changed during the weighted least-squares\n\
  iterations. The estimate for beta returned may be reasonable, but the\n\
  user should check how the deviance has changed during iterations.",
  "NE_ZERO_DOF_ERROR:\n\
  The degrees of freedom for error are 0. A saturated model has been fitted.",
  "NE_BAD_NY_SET:\n\
  On entry, ny = %"NAG_IFMT" and there are not exactly ny values of isz < 0.\n\
  Number of values of isz < 0 = %"NAG_IFMT".",
  "NE_BAD_NX_SET:\n\
  On entry, nx = %"NAG_IFMT" and there are not exactly nx values of isz < 0.",
  "NE_VARCOV_MAT_SINGULAR:\n\
  On entry, the variance-covariance/correlation matrix of the independent\n\
  variables is singular. Try removing some of the x variables by setting\n\
  the appropriate element of isz = 0.",
  "NE_SQRT_VARCOV_SINGULAR:\n\
  On entry, the square root of the variance-covariance/correlation matrix\n\
  of the variables is singular. Try removing some of the x variables by\n\
  setting the appropriate element of isz = 0.",
  "NE_DIAG_ELEM_INVALID:\n\
  At least one diagonal element of the partial variance-covariance matrix,\n\
  Sigma(y|x), is zero and a computed partial correlation coefficient is\n\
  greater than one.",
  "NE_DIAG_EQ_ZERO:\n\
  At least one diagonal element of the partial variance-covariance matrix,\n\
  Sigma(y|x), is zero. This indicates that the matrix input in r was not\n\
  positive-definite.",
  "NE_ELEM_GT_ONE:\n\
  At least one computed partial correlation coefficient is greater than one.\n\
  This indicates that the matrix input in r was not positive-definite.",
  "NE_INVALID_HUBER_FUN:\n\
  On entry, psifun = Nag_HuberFun and cpsi = %g. For this value of\n\
  psifun, cpsi must be > 0.0.",
  "NE_INVALID_DCHI_FUN:\n\
  On entry, psifun != Nag_Lsq and sigma_est = Nag_SigmaChi while dchi = %g.\n\
  For this values of psifun and sigma_est, dchi must be > 0.0.",
  "NE_INVALID_MALLOWS_REG_C:\n\
  On entry, regtype = Nag_MallowsReg and cucv = %g while m = %"NAG_IFMT". For\n\
  this value of regtype, cucv must be >= m.",
  "NE_INVALID_SCHWEPPE_REG_C:\n\
  On entry, regtype = Nag_SchweppeReg and cucv = %g while m = %"NAG_IFMT". For\n\
  this value of regtype, cucv must be > sqrt(m).",
  "NE_BAD_HAMPEL_PSI_FUN:\n\
  On entry, psifun = Nag_HampelFun and hpsi[0] = %g, hpsi[1] = %g\n\
  and hpsi[2] = %g. For this value of psifun, the elements of\n\
  hpsi must satisfy the condition 0.0 <= hpsi[0] <= \n\
  hpsi[1] <= hpsi[2] and hpsi[2] > 0.0.",
  "NE_WT_ITER_EXCEEDED:\n\
  The number of iterations required to calculate the weights exceeds\n\
  max_iter. This is only applicable if regtype != Nag_HuberReg.",
  "NE_BETA1_ITER_EXCEEDED:\n\
  The number of iterations required to calculate beta1 exceeds max_iter. \n\
  This is only applicable if regtype = Nag_MallowsReg and \n\
  sigma_est =  Nag_SigmaRes.",
  "NE_THETA_ITER_EXCEEDED:\n\
  The number of iterations required to calculate theta and sigma exceeds\n\
  max_iter. In this case, info[2] = max_iter on exit.",
  "NE_LSQ_FAIL_CONV:\n\
  The iterations to solve the weighted least-squares equations failed to\n\
  converge.",
  "NE_WT_LSQ_NOT_FULL_RANK:\n\
  The weighted least-squares equations are not of full rank.",
  "NE_REG_MAT_SINGULAR:\n\
  Failure to invert matrix while calculating covariance.",
  "NE_COV_MAT_FACTOR_ZERO:\n\
  In calculating the correlation factor for the asymptotic variance-\n\
  covariance matrix, the factor for covariance matrix = 0.",
  "NE_VAR_THETA_LEQ_ZERO:\n\
  The estimated variance for an element of theta <= 0. In this case the \n\
  diagonal element of c will contain the negative variance and the above \n\
  diagonal elements in the row and the column corresponding to the element \n\
  will be returned as zero.",
  "NE_ERR_DOF_LEQ_ZERO:\n\
  n = %"NAG_IFMT", rank of x = %"NAG_IFMT". The degrees of freedom for error,\n\
  n - (rank of x)  must be > 0.0.",
  "NE_ESTIM_SIGMA_ZERO:\n\
  The estimated value of sigma was 0.0 during an iteration.",
  "NE_OBS_VAR_CONST:\n\
  On entry, a variable has a constant value, i.e. all elements in a column\n\
  of x are identical.",
  "NE_C_ITER_NOT_CONV:\n\
  The iterative procedure to find the co-variance matrix C, has failed to \n\
  converge in max_iter iterations.",
  "NE_C_ITER_UNSTABLE:\n\
  The iterative procedure to find C has become unstable. This may happen if\n\
  the value of eps is too large.",
  "NE_CPSI_NOT_SET:\n\
  On entry, psifun equals Nag_HuberFun and cpsi has not been set.",
  "NE_CUCV_NOT_SET:\n\
  On entry, regtype is not equal to Nag_HuberReg and cucv has not been set.",
  "NE_HPSI_NOT_SET:\n\
  On entry, psifun equals Nag_HampelFun and hpsi[0], hpsi[1] and \n\
  hpsi[2] have not been set.",
  "NE_DCHI_NOT_SET:\n\
  On entry, psifun is not equal to Nag_Lsq sigtype equals Nag_SigmaChi and\n\
  dchi has not been set.",
  "NE_SUM_ZERO:\n\
  The sum of %s is zero.",
  "NE_UCV:\n\
  %s value returned by ucv < 0.0 : w(%13.5e) = %13.5e.",
  "NE_CONST_COL:\n\
  On entry, column %"NAG_IFMT" of array %s has constant value.",
  "NE_COR_MAT_RANK:\n\
  On entry, either the variance-covariance matrix or the correlation\n\
  matrix is not of full rank. Try removing some of the x variables by\n\
  setting the appropriate elements of isz to zero.",
  "NE_COR_MAT_POSDEF:\n\
  Either a diagonal element of the partial variance-covariance matrix is zero\n\
  and/or a computed partial correlation coefficient is greater than one. Both\n\
  indicate that the matrix input in r was not positive-definite.",


/* G03 Errors */

  "NE_NEG_WEIGHT_ELEMENT:\n\
  On entry, %s[%"NAG_IFMT"] = %f.\n\
  Constraint: when referenced, all elements of %s must be non-negative.",
  "NE_VAR_INCL_INDICATED:\n\
  The number of variables, %s in the analysis = %"NAG_IFMT",\n\
  while number of %s variables included in the analysis via array %s = %"NAG_IFMT".\n\
  Constraint: these two numbers must be the same.",
  "NE_VAR_INCL_COND:\n\
  The number of variables, %s in the analysis = %"NAG_IFMT",\n\
  while the number of %s variables included in the analysis via array %s = %"NAG_IFMT".\n\
  Constraint: These two numbers must be the same when %s.",
  "NE_OBSERV_LT_VAR:\n\
  With weighted data, the effective number of observations given by the \n\
  sum of weights = %f, while the number of %s variables included in the \n\
  analysis, %s = %"NAG_IFMT".\n\
  Constraint: effective number of observations >= %s + 1.",
  "NE_VAR_INCL_STANDARD:\n\
  On entry, the standardisation element %s[%"NAG_IFMT"] = %f,\n\
  while the variable to be included %s[%"NAG_IFMT"] = %"NAG_IFMT".\n\
  Constraint: when a variable is to included, the standardisation element \n\
  must be positive.",
  "NE_ZERO_EIGVALS:\n\
  All eigenvalues/singular values are zero.",
  "NE_CANON_CORR_1:\n\
  A canonical correlation is equal to one.",
  "NE_GROUPS:\n\
  Either the effective number of groups is less than two or the effective\n\
  number of groups plus the number of variables, nx is greater than the\n\
  the effective number of observations.",
  "NE_RANK_ZERO:\n\
  The rank of the variables is zero.",
  "NE_MAT_RANK_ZERO:\n\
  The rank of the %s matrix or the rank of the %s matrix is zero.",
  "NE_WT_ARGS:\n\
  The wt array argument must not be NULL when the %s argument indicates weights.",
  "NE_ACC_ITER:\n\
  The algorithm to find %s has failed to reach the required accuracy in\n\
  the given number of iterations, %"NAG_IFMT".",
  "NE_NORM_ZERO_PTS:\n\
  On entry, either x or y contains only zero-points (possibly after translation)\n\
  when normalization is to be applied.",
  "NE_LSQ_SCAL_ZERO_PTS:\n\
  The fitted matrix, y^, contains only zero-points when least-squares scaling\n\
  is applied.",
  "NE_MAT_RANK:\n\
  On entry, matrix = Nag_DataCorr or matrix = Nag_DataCovar and the data matrix is\n\
  not of full column rank, or matrix = Nag_MatCorr_Covar and the input\n\
  correlation/variance-covariance matrix is not positive-definite.",
  "NE_GROUP_OBSERV:\n\
  On entry, group %"NAG_IFMT" has %g effective observations.\n\
  Constraint: in each group the effective number of observations must be \n\
  %s %"NAG_IFMT".",
  "NE_GROUP_VAR:\n\
  On entry, group %"NAG_IFMT" has %"NAG_IFMT" members, while %s = %"NAG_IFMT".\n\
  Constraint: number of members in each group %s.", 
  "NE_DIAG_0_COND:\n\
  A diagonal element of %s is zero when %s.",
  "NE_DIAG_0_J_COND:\n\
  A diagonal element of %s is zero for some j, when %s.",
  "NE_VAR_RANK:\n\
  The variables are not of full rank.", 
  "NE_GROUP_VAR_RANK:\n\
  The variables in group %"NAG_IFMT" are not of full rank.", 
  "NE_GROUP_SUM:\n\
  On entry, the sum of nig[j-1], for j from 1 to ng = %"NAG_IFMT", ng = %"NAG_IFMT", nvar = %"NAG_IFMT".\n\
  Constraint: the sum of nig[j-1], for j from 1 to ng > ng + nvar when\n\
  equal = Nag_EqualCovar.",
  "NE_PRIOR_SUM:\n\
  On entry, the sum of prior[j-1], for j from 1 to ng = %g.\n\
  Constraint: the sum of prior[j-1], for j from 1 to ng must be within\n\
  10 * machine_precision of 1 when priors = Nag_UserPrior.",
  "NE_IDEN_ELEM_COND:\n\
  On entry, scale = Nag_VarScaleRange or scale = Nag_VarScaleStd and \n\
  x[i-1][j-1] = x[i][j-1], for i = 1,2,...,n-1, for some j with isx[i-1] > 0.",
  "NE_DENDROGRAM:\n\
  A true dendrogram cannot be formed because the distances at which clusters\n\
  have merged are not increasing for all steps, i.e., cd[i-1] < cd[i-2] for\n\
  some i=2,3,...,n-1.",
  "NE_WT_ZERO:\n\
  At least two elements of wt must be greater than zero.",
  "NE_CLUSTER_EMPTY:\n\
  At least one cluster is empty after the initial assignment.",
  "NE_DENDROGRAM_ARRAY:\n\
  On entry, %s = %"NAG_IFMT", %s[%"NAG_IFMT"] = %g.\n\
  Constraint: %s.",
  "NE_CLUSTER:\n\
  The precise number of clusters requested is not possible because of\n\
  tied clustering distances. The actual number of clusters produced is %"NAG_IFMT".",
  "NE_NONZERO_EIGVALS:\n\
  There are fewer than %s eigenvalues greater than zero.",
  "NE_EIGVAL:\n\
  The computation of eigenvalues or eigenvectors has failed.",
  "NE_NEG_OR_ZERO_ARRAY:\n\
  All the elements of array %s <= 0.0.\n\
  Constraint: At least one element of %s must be positive.",
  "NE_NEG_ELEMENT:\n\
  At least one element of the array %s < 0.0.\n\
  Constraint: d[i-1] >= 0.0, i=1,2,...,n*(n-1)/2.",


/* G04 errors */
  "NE_IT_ARRAY:\n\
  No value of it[j-1] = j for some j = 1,2,...nt.",
  "NE_ARRAY_CONSTANT:\n\
  On entry, the elements of the array %s are constant.",
  "NE_G04BB_STDERR:\n\
  A computed standard error is zero due to rounding errors.",
  "NE_G04BB_CONV:\n\
  The eigenvalue computation has failed to converge.",
  "NE_G04BB_DESIGN:\n\
  The design is disconnected; the standard errors may not be valid. \n\
  The design may be nested.",
  "NE_G04BB_TREAT:\n\
  The treatments are totally confounded with blocks, so the treatment \n\
  sum of squares and degrees of freedom are zero. The analysis of variance\n\
  table is not computed, except for block and total sums of squares and\n\
  degrees of freedom.",
  "NE_G04BB_RES_DF:\n\
  The residual degrees of freedom or the residual sum of squares are zero,\n\
  columns 3, 4 and 5 of the analysis of variance table will not be computed\n\
  and the matrix of standard errors and covariances, C, will not be scaled by\n\
  s or the square of s.",
  "NE_TOO_SMALL:\n\
  On entry, the value of %s is too small.",
  "NE_PLOT_TREAT:\n\
  The number of plots per block is not a multiple of the number of\n\
  treatment combinations.",
  "NE_G04CA_RES_DF:\n\
  There are no degrees of freedom for the residual or the residual\n\
  sum of squares is zero. In either case the standard errors and \n\
  F-statistics cannot be computed.",
  "NE_G04BC_ST_ERR:\n\
  A computed standard error is zero due to rounding errors, or the eigenvalue\n\
  computation failed to converge. Both are unlikely errors.",
  "NE_G04BC_REPS:\n\
  The treatments are totally confounded with replicates, rows and columns, so the\n\
  treatment sum of squares and degrees of freedom are zero. The analysis of variance\n\
  table is not computed, except for replicate, row, column and total sum of squares and\n\
  degrees of freedom.",
  "NE_G04BC_RESD:\n\
  The residual degrees of freedom or the residual sum of squares are zero, columns 3, 4\n\
  and 5 of the analysis of variance table will not be computed and the matrix of standard\n\
  errors and covariances, C, will not be scaled.",
  "NE_G04BC_DISCON:\n\
  The design is disconnected, the standard errors may not be valid. The design\n\
  may have a nested structure.",
  "NE_G04EA_LEVELS:\n\
  All levels are not represented in array %s.",
  "NE_G04EA_ORTHO_POLY:\n\
  An orthogonal polynomial has all values zero. This will be due to some values\n\
  of v being close together. This can only occur if type = Nag_Poly.",
  "NE_STUDENTIZED_STAT:\n\
  There has been a failure in the computation of the studentized range statisic. Try\n\
  using a smaller value of clevel.",



 
/* G05 errors */
  "NE_STATE_CORRUPT:\n\
  istate or xstate has been corrupted since the previous call to \n\
  nag_save_random_state (g05cfc).",
  "NE_REAL_ARG_NON_INTEGRAL:\n\
  %s found to be non-integral.",
  "NE_SYSTEM_TIME:\n\
  Call to system function to obtain time has failed.",
  "NE_NOT_POS_SEM_DEF:\n\
  Matrix %s is not positive semi-definite.",
  "NE_START_P_Q:\n\
  The function has been called either with start = Nag_FALSE the very first \n\
  time or at least one of p or q has been changed in a subsequent call with \n\
  start = Nag_FALSE.",
  "NE_REF_VEC:\n\
  The reference vector set up by the previous call of this function\n\
  has become corrupt.",
  "NE_PROB_NOT_ONE:\n\
  The total probability is not 1, may be due to rounding errors,\n\
  total probability = %7.5f.",
  "NE_ALL_PROB_ZERO:\n\
  All the probabilities in array %s are zero.",
  "NE_NEG_PROB:\n\
  At least one of the probabilities in array %s is negative,\n\
  %s[%1"NAG_IFMT"] = %7.5f.",
  "NE_STATIONARITY:\n\
  The input series does not constitute a stationary time-series model.",

/* G07 Errors */
  "NE_WINS_RES_ZERO:\n\
  The Winsorized residuals are zero.",
 
  /* G08 Errors */
  "NE_ACC:\n\
  The requested accuracy cannot be achieved. Try increasing %s. The returned\n\
  result is an approximation to the required result.",
  "NE_POS_DEF:\n\
  The matrix %s is not positive definite.",
  "NE_ROUND_OFF:\n\
  Round-off error prevents the requested accuracy from being achieved. \n\
  Try increasing tol. The returned result is an approximation to the required\n\
  result. This result will only occur if n = 3.",
  "NE_G08AA_NON_TIED:\n\
  On exit the number of non-tied pairs, non_tied = 0, i.e., the samples are\n\
  identical.",
  "NE_G08AG_SAMP_IDEN:\n\
  The whole sample is identical to the given median test value.",
  "NE_G08AH_SAMP_IDEN:\n\
  The pooled sample values are all the same, that is the variance of u = 0.0.",
  "NE_G08CB_PARAM:\n\
  On entry, the parameters supplied for the specified null distribution are\n\
  out of range. This error will only occur if estima = Nag_ParaSupplied.",
  "NE_G08CB_DATA:\n\
  The data supplied in x could not arise from the chosen null distribution, as\n\
  specified by the parameters dist and par.",
  "NE_G08CB_SAMPLE:\n\
  The whole sample is constant i.e. the variance is zero. This error may only\n\
  occur if (dist = Nag_Uniform, Nag_Normal, Nag_Gamma or Nag_Beta) and\n\
  estima = Nag_ParaEstimated.",
  "NE_G08CB_VARIANCE:\n\
  The variance of the binomial distribution (dist = Nag_Binomial) is too large.\n\
  That is mp(1-p) > 1000000.0.",
  "NE_G08CB_INCOMP_GAMMA:\n\
  When dist = Nag_Gamma, in the computation of the incomplete gamma function by\n\
  s14bac the convergence of the Taylor's series or Legendre continued fraction\n\
  fails within 600 iterations.",
  "NE_G08CD_CONV:\n\
  The iterative procedure used in the approximation of the probability\n\
  for large n1 and n2 did not coverge. For the two-sided test, p = 1 is\n\
  returned. For the one-sided test, p = 0.5 is returned.",
  "NE_G08CG_FREQ:\n\
  An expected frequency is equal to zero when the observed frequency is not.",
  "NE_G08CG_CLASS_VAL:\n\
  This is a warning that expected values for certain classes are less than 1.0.\n\
  This implies that one cannot be confident that the chi-square distribution is\n\
  a good approxmiation to the distribution of the test statistic.",
  "NE_G08CG_CONV:\n\
  The solution obtained when calculating the probability for a certain class for\n\
  the gamma or  chi-square distribution did not converge in 600 iterations. The\n\
  solution may be an adequate approximation.",
  "NE_G08EA_TIE:\n\
  There is a tie in the sequence of observations.",
  "NE_G08EA_RUNS_LENGTH:\n\
  The total length of the runs found is less than max_run.",
  "NE_G08EA_COVAR:\n\
  Internally computed  covariance matrix is not positive-definite.\n\
  This maybe because the value of max_run is too large relative to the\n\
  full length of the series. Thus the approximate chi-square test statistic\n\
  cannot be computed.",
  "NE_G08EA_RUNS:\n\
  The number of runs requested were not found. All statistics are stiil computed\n\
  and the information returned may still be of use.",
  "NE_G08EB_PAIRS:\n\
  No pairs were found. This will occur if the value of lag is greater than or\n\
  equal to the total number of observations.",
  "NE_G08EB_CELL:\n\
  The expected value for each cell is less than or equal to 5.0. This implies\n\
  that the chi-square distribution may not be very good approximation to the\n\
  distribution of the test statistic.",
  "NE_G08EC_CELL:\n\
  The expected value for the counts in each element of the count matrix is less\n\
  than or equal to 5.0. This implies that the chi-square distribution may not be\n\
  very good approximation to the distribution of the test statistic.",
  "NE_G08EC_TRIPLETS:\n\
  No triplets were found because less than 3 observations were provided in total.",
  "NE_G08ED_GAPS_ZERO:\n\
  No gaps were found. Try using a longer sequence or increase the size of the\n\
  interval upper-lower.",
  "NE_G08ED_FREQ_ZERO:\n\
  The expected frequency of a certain class is zero, that is e(i) = 0, for\n\
  some i=1,2,..k. For further details please refer to the document for g08edc,\n\
  section 3.",
  "NE_G08ED_GAPS:\n\
  The number of gaps requested were not found.",
  "NE_G08ED_FREQ_LT_ONE:\n\
  Some classes have expected frequencies less than 1.0. This implies that the\n\
  chi-square may not be a good approximation to the distribution of the test\n\
  statistic.",
  "NE_MANN_WHITNEY_STAT:\n\
  The computed Mann-Whitney statistic, %s = %g.\n\
  If the exact tail probability is to be computed then %s.",

/* G10 errors */
  "NE_SEQUENCE_SHORT:\n\
  On entry, sequence is too short to smooth; n should be greater than 6:\n\
  n = %"NAG_IFMT".",
  "NE_G10AC_DF_RHO:\n\
  method = Nag_Smooth_Param_DF and the required value of rho for specified\n\
  degrees of freedom > u. Try a larger value of u.",
  "NE_G10AC_DF_TOL:\n\
  method = Nag_Smooth_Param_DF and the accuracy given by tol cannot be\n\
  achieved. Try increasing the value of tol.",
  "NE_G10AC_ACC:\n\
  A solution to the accuracy given by tol has not been achieved in maxcal\n\
  iterations. Try increasing the value of tol and/or maxcal.",
  "NE_G10AC_CG_RHO:\n\
  method = Nag_SmoothParamCV or Nag_SmoothParamGCV and the optimal value of\n\
  rho > u. Try a larger value of u.",
  "NE_G10BA_INIT:\n\
  On entry, g10bac has been called with usefft = Nag_UseFFT_Y but the routine\n\
  has not been called previously with usefft = Nag_UseFFT_N or g10bac has been\n\
  called with usefft = Nag_UseFFT_Y but some of the arguments n, slo, shi, ns\n\
  have been changed since the previous call to g10bac with usefft = Nag_UseFFT_N.",
  "NE_G10BA_INTERVAL:\n\
  On entry, the interval given by slo to shi does not extend beyond three\n\
  window  widths at either extreme of the data set. This may distort the\n\
  density estimate in some cases.",


/* G11 errors */
  "NE_2D_INT_ARR_ELEM:\n\
  On entry, %s[%1"NAG_IFMT"][%1"NAG_IFMT"]=%"NAG_IFMT".\n\
  All elements of this array must be %s.",
  "NE_2D_INT_ARR_ELEMS:\n\
  On entry, all elements of the array %s are %s.\n\
  At least one element of this array must be %s.",
  "NE_TABLE_DEGENERATE:\n\
  On entry, a 2*2 table has a row or column with both elements zero\n\
  i.e., the table is degenerate.",
  "NE_LOW_EXPECTED_FREQ:\n\
  At least one cell has expected frequency <= 0.5.\n\
  The chi-square approximation may be poor.",
  "NE_MAXT:\n\
  The maximum size of the table to be computed, maxt is too small.",
  "NE_VAR_DIV:\n\
  stat = Nag_TableStatsVar and the divisor for the variance <= 0.0.",
  "NE_G11BA_CHANGED:\n\
  update = Nag_TableUpdateU and at least one of ncells, table, auxt or icount\n\
  have been changed since previous call to g11bac.",
  "NE_CELL_EMPTY:\n\
  At least one cell is empty.",

/* G12 errors */
  "NE_INVALID_CENSOR_CODE:\n\
  On entry, %s[%1"NAG_IFMT"] = %1"NAG_IFMT".\n\
  The censor code for an observation must be either 0 or 1.",
  "NE_INVALID_FREQ:\n\
  On entry, %s[%1"NAG_IFMT"] = %1"NAG_IFMT".\n\
  The value of frequency for an observation must be >= 0.",
  "NE_CHAR_ARG_INVALID:\n\
  On entry, the parameter %s has an invalid value.",
  "NE_G12BA_SZ_IP:\n\
  On entry, ip = %"NAG_IFMT" and the number of non zero values of sz = %"NAG_IFMT".\n\
  Constraint %s.",
  "NE_G12BA_SZ_ISI:\n\
  On entry, the number of values of sz[i] > 0 is %"NAG_IFMT", n = %"NAG_IFMT" and\n\
  excluded observations  with isi[i] = 0 is %"NAG_IFMT".\n\
  Constraint: the number of values of non-zero sz must be less than\n\
  n - excluded observations.",
  "NE_G12BA_NDMAX:\n\
  On entry ndmax is = %"NAG_IFMT" while the output value of nd = %"NAG_IFMT".\n\
  Constraint ndmax >= nd.",
  "NE_G12BA_MAT_SING:\n\
  The matrix of second partial derivatives is singular. Try different starting\n\
  values or include fewer covariates.",
  "NE_G12BA_OVERFLOW:\n\
  Overflow has been detected. Try different starting values.",
  "NE_G12BA_CONV:\n\
  Convergence has not been achieved in maxit iterations. The progress towards\n\
  convergence can be examined by using by setting iprint to >=1. Any\n\
  non-covergence maybe due to a linear combination of covariates being\n\
  monotonic with time. Full results are returned.",
  "NE_G12BA_DEV:\n\
  In the current iteration 10 step halvings have been performed without\n\
  decreasing the deviance from the previous iteration. Convergence is assumed.",

/* G13 errors */
  "NE_TIME_SERIES_IDEN:\n\
  On entry, all values of %s are practically identical,\n\
  giving zero variance. In this case r and stat are undefined on exit.",
  "NE_INVALID_AUTOCO_COEF:\n\
  On entry, the autocorrelation coefficient of lag 1 has an absolute\n\
  value greater than or equal to 1.0; no recursions could be performed.",
  "NE_CORR_NOT_POS_DEF:\n\
  Recursion has been prematurely terminated; the supplied autocorrelation\n\
  coefficients do not form a positive-definite sequence.",
  "NE_INVALID_NSER:\n\
  On entry, nseries = 1 and there are no parameters in the\n\
  model (p = q = P = Q = 0 and options.cfixed = Nag_TRUE).",
  "NE_NPARA_MR_MT_INCONSIST:\n\
  On entry, there is inconsistency between npara on the one hand and\n\
  the elements in the orders structures, arimav and transfv, on the other.",
  "NE_DELTA_TEST_FAILED:\n\
  On entry, or during execution, one or more sets of delta parameters\n\
  do not satisfy the stationarity or invertibility test conditions.",
  "NE_SOLUTION_FAIL_CONV:\n\
  Iterative refinement has failed to improve the solution of the equations\n\
  giving the latest estimates of the parameters. This occurred because the\n\
  matrix of the set of equations is too ill-conditioned.",
  "NE_MAT_NOT_POS_DEF:\n\
  Attempt to invert the second derivative matrix needed in the calculation\n\
  of the covariance matrix of the parameter\n\
  estimates has failed. The matrix is not positive-definite, possibly due\n\
  to rounding errors.",
  "NE_ARIMA_TEST_FAILED:\n\
  On entry, or during execution, one or more sets of the\n\
  ARIMA (phi, theta, Phi or Theta) parameters do not satisfy\n\
  the stationarity or invertibility test conditions.",
  "NE_ITER_FAIL_NIT:\n\
  The function has failed to converge after options.max_iter\n\
  iterations, where options.max_iter = %1"NAG_IFMT".",
  "NE_G13_OPTIONS_NOT_INIT:\n\
  On entry, the option structure, options, has not been initialised\n\
  using function nag_tsa_options_init (g13bxc).",
  "NE_G13_ORDERS_NOT_INIT:\n\
  On entry, the orders array structure, transfv, has not been successfully\n\
  initialised using function nag_tsa_transf_orders (g13byc).",
  "NE_NSER_INCONSIST:\n\
  Value of nseries passed to nag_tsa_transf_orders(g13byc)\n\
  was %1"NAG_IFMT" which is not equal to the value %1"NAG_IFMT" passed in this function.",
  "NE_DIFORDER_LEN_INCONSIST:\n\
  The orders of differencing specified in the structure arimav must satisfy\n\
  nxxy > arimav.d + (arimav.s * arimav.bigd), nxxy = %1"NAG_IFMT", arimav.d = %1"NAG_IFMT",\n\
  arimav.s = %1"NAG_IFMT", arimav.bigd = %1"NAG_IFMT".",
  "NE_SPECTRAL_ESTIM_NEG:\n\
  One or more spectral estimates are negative. Unlogged spectral estimates are\n\
  returned in %s and the degrees of freedom, unlogged confidence limit factors\n\
  and bandwith in %s.",
  "NE_CONFID_LIMIT_FACT:\n\
  The calculation of confidence limit factors has failed. Spectral estimates\n\
  (logged if requested) are returned in %s, and degrees of freedom and bandwith\n\
  in %s.",
  "NE_BIVAR_SPECTRAL_ESTIM_ZERO:\n\
  A bivariate spectral estimate is zero.",
  "NE_UNIVAR_SPECTRAL_ESTIM_ZERO:\n\
  A bivariate spectral estimate is zero.",
  "NE_UNIVAR_SPECTRAL_ESTIM_NEG:\n\
  A bivariate spectral estimate is negative.",
  "NE_SQUARED_FREQ_GT_ONE:\n\
  A calculated value of the squared coherency exceeds one.",
  "NE_ARIMA_INPUT:\n\
  On entry arima.p = %"NAG_IFMT", arima.d = %"NAG_IFMT", arima.q = %"NAG_IFMT",\n\
  arima.bigp = %"NAG_IFMT", arima.bigd = %"NAG_IFMT", arima.bigq = %"NAG_IFMT" and arima.s = %"NAG_IFMT".\n\
  Constraints on the members of arima are:\n\
  p, q, bigp, bigq, s >= 0,\n\
  p + q + bigp + bigq > 0,\n\
  if s = 0, then bigp = 0 and bigq = 0.",
  "NE_INPUT_NARMA:\n\
  On entry  arima.p = %"NAG_IFMT", arima.q = %"NAG_IFMT", arima.bigp = %"NAG_IFMT",arima.bigp = %"NAG_IFMT"\n\
  while narma = %"NAG_IFMT".\n\
  Constraint: narma = arima.p + arima.q + arima.bigp + arima.bigp.",
  "NE_G13AS_AR:\n\
  On entry, the autoregressive (or moving average) parameters are\n\
  extremely close to or outside the stationarity (or invertibility)\n\
  region. To proceed, the user must supply different parameter estimates\n\
  in the array par.",
  "NE_G13AS_ZERO_VAR:\n\
  On entry, the residuals are practically identical giving zero (or near\n\
  zero) variance. In this case chi is set to zero, siglev to one and all\n\
  the elements of r set to zero.",
  "NE_G13AS_ITER:\n\
  This is an unlikely exit brought about by an excessive number of\n\
  iterations being needed to evaluate the zeros of the ar or ma polynomials.\n\
  All output parameters are undefined.",
  "NE_G13AS_FACT:\n\
  On entry, one or more of the ar operators has a factor in common with\n\
  one or more of the ma operators. To proceed, this common factor must\n\
  be deleted from the model. In this case, the off-diagonal elements of\n\
  rcm are returned as zero and the diagonal elements set to 1/sqrt(n). \n\
  All other output quantities will be correct.",
  "NE_G13AS_DIAG:\n\
  This is an unlikely exit. At least one of the diagonal elements of rcm\n\
  was found to be either negative or zero. In this case all off-diagonal\n\
  elements of rcm are returned as zero and all diagonal elements of rcm set\n\
  to 1/sqrt(n).",







/* H chapter */
  "NE_REQ_AVAIL:\n\
  The relative difference between the sum of availabilities and the sum of \n\
  requirements is greater than machine precision:\n\
  relative difference = %10.5e, machine precision = %10.5e.",

  /* H02 - MPS Reading errors */

  "NE_MPS_USER_MEM:\n\
  Insufficient user-supplied memory to store problem read from MPSX file.\n\
  User allocated storage for %1"NAG_IFMT" %s but require %1"NAG_IFMT".",
  "NE_MPS_ILLEGAL_DATA_LINE:\n\
  An illegal data line has been read from the MPSX file.\n\
  This is neither a comment nor a legal data line.\n\
  Error at MPSX line %"NAG_IFMT":\n%s",
  "NE_MPS_SPLIT_COL:\n\
  Column data is not contiguous. All entries for a given column must \n\
  appear together in the COLUMNS section.\n\
  Error at MPSX line %1"NAG_IFMT":\n%s",
  "NE_MPS_REPEAT_ROW: \n\
  A row has been specified more than once.\n\
  Error at MPSX line %1"NAG_IFMT":\n%s",
  "NE_MPS_ILLEGAL_NAME:\n\
  An illegal row or column name has been detected.\n\
  Names must contain only alphanumeric characters with no leading blanks.\n\
  Error at MPSX line %1"NAG_IFMT":\n%s",
  "NE_MPS_ILLEGAL_SETNAME:\n\
  An illegal name has been detected in field 2 of the RHS, RANGES or \n\
  BOUNDS section.\n\
  Names must contain only alphanumeric characters with no leading blanks.\n\
  Error at MPSX line %1"NAG_IFMT":\n%s",
  "NE_MPS_ILLEGAL_NUMBER:\n\
  Number expected but value could not be read. Check numerical fields.\n\
  Error at MPSX line %1"NAG_IFMT":\n%s",
  "NE_MPS_INVALID_INF_BOUND:\n\
  An invalid infinite bound is specified in the BOUNDS section.\n\
  Error at MPSX line %1"NAG_IFMT":\n%s",
  "NE_MPS_INVALID_BND_TYPE:\n\
  An invalid bound type appears in the BOUNDS section.\n\
  Expect: LO, UP, FX, FR, MI, PL, BV or UI.\n\
  Error at MPSX line %1"NAG_IFMT":\n%s",
  "NE_MPS_INVALID_ROW_TYPE:\n\
  An invalid row type appears in the ROWS section.\n\
  Expect: N, G, L or E.\n\
  Error at MPSX line %1"NAG_IFMT":\n%s",
  "NE_MPS_INVALID_INTORG_INTEND:\n\
  An INTORG or INTEND marker is not correctly specified\n\
  or is unexpected (e.g., INTEND has no matching INTORG).\n\
  Error at MPSX line %1"NAG_IFMT":\n%s", 
  "NE_MPS_INVALID_RANGE:\n\
  Invalid value in RANGES section. Absolute value should be less than infinity.\n\
  Error at MPSX line %1"NAG_IFMT":\n%s",
  "NE_MPS_INVALID_BND_VAL:\n\
  Invalid numeric field in bound data.\n\
  Value expected for types: LO, UP, FX, UI.\n\
  Blank field expected for types: FR, MI, PL, BV.\n\
  Error at MPSX line %1"NAG_IFMT":\n%s",
  "NE_MPS_NO_NEWLINE:\n\
  New line expected but not found.\n\
  Last MPSX line read (%"NAG_IFMT"):\n%s",
  "NE_MPS_NO_COLS:\n\
  There were no columns specified in the COLUMNS section.\n\
  Last MPSX line read (%"NAG_IFMT"):\n%s",
  "NE_MPS_NO_OBJ:\n\
  The objective row was not found. There must be at least one row of type N\n\
  in the ROWS section and, if an objective name was specified, there must be\n\
  a type N row with this name.\n\
  Last MPSX line read (%"NAG_IFMT"):\n%s",
  "NE_MPS_NO_ROWS:\n\
  There were no rows specified in the ROWS section.\n\
  Last MPSX line read (%"NAG_IFMT"):\n%s",
  "NE_MPS_TOO_BIG:\n\
  Insufficient memory is available to read this file.\n\
  Last MPSX line read (%"NAG_IFMT"):\n%s",
  "NE_MPS_UNKNOWN_COLNAME:\n\
  An unknown column name appears in the BOUNDS section.\n\
  All the column names must be specified in the COLUMNS section.\n\
  Error at MPSX line %1"NAG_IFMT":\n%s",
  "NE_MPS_INVALID_INDICATOR:\n\
  Unknown, unexpected or invalid indicator line read.\n\
  Expect: NAME, ROWS, COLUMNS, RHS, RANGES, BOUNDS or ENDATA, starting in\n\
  column 1 of file, and in that order. RANGES and/or BOUNDS may be omitted.\n\
  Error at MPSX line %1"NAG_IFMT":\n%s",
  "NE_MPS_UNKNOWN_ROWNAME:\n\
  An unknown row name appears in the %s section.\n\
  All the row names must be specified in the ROWS section.\n\
  Error at MPSX line %1"NAG_IFMT":\n%s",
  "NE_MPS_PROB_NOT_FOUND:\n\
  The specified problem has not been found in the MPSX file.",
  "NE_MPS_RHS_RANGE_BND_NOT_FOUND:\n\
  The name of the RHS, RANGES or BOUNDS set to be used was not found in the file.",
  "NE_MPS_OPT_NOT_INIT:\n\
  MPSX options structure not initialized.",
  "NE_MPS_ENDATA_NOT_FOUND:\n\
  The file does not contain an ENDATA indicator.",
  "NE_ALLOC_AFTER_MPS:\n\
  The MPSX file has been successfully read but insufficient\n\
  memory could subsequently be allocated.",

  /* IP errors */
  "NE_PRIORITY_NULL:\n\
  options.varsel = Nag_Use_Priority but options.priority is NULL.",

  "NE_MIP_PROB_NULL:\n\
  The prob argument is a NULL pointer. A valid pointer to a\n\
  Nag_MIP_Problem structure must be passed.",
  "NE_MIP_PROB_NOT_INIT:\n\
  The Nag_MIP_Problem structure has not been initialised.\n\
  Initialise by calling h02zyc.",
  "NE_MIP_ROOT_UNBOUNDED:\n\
  The root node of the BB tree appears to be unbounded.",
  "NE_MIP_ROOT_INFEAS:\n\
  The root node of the BB tree is infeasible.",
  "NE_MIP_ROOT_MAX_ITER:\n\
  The maximum number of iterations, %1"NAG_IFMT", was performed before normal\n\
  termination occurred for the root node of the BB tree.",
  "NW_MIP_FIRST_INT_SOL:\n\
  As requested, the algorithm has terminated on finding the first IP\n\
  solution. A better IP solution might exist.",
  "NW_MIP_NO_INT_SOL:\n\
  No feasible IP solution was found, i.e., it was not possible to\n\
  satisfy all the integer variables to within optional parameter\n\
  int_tol.",
  "NW_MIP_MAX_ITER_INT_SOL:\n\
  The IP solution found may not be the optimum. The search\n\
  had to be terminated in at least one branch of the BB tree\n\
  because the iteration limit was reached.",
  "NW_MIP_MAX_ITER_NO_INT_SOL:\n\
  No IP solution was found but the search had to be terminated\n\
  in at least one branch of the BB tree because the iteration\n\
  limit was reached.",
  "NW_MIP_MAX_NODES_INT_SOL:\n\
  The IP solution found is the best for the number of nodes (as\n\
  determined by optional parameter max_nodes) investigated in \n\
  the BB tree.",
  "NW_MIP_MAX_NODES_NO_INT_SOL:\n\
  No IP solution was found for the number of nodes (as\n\
  determined by optional parameter max_nodes) investigated in\n\
  the BB tree.",
  "NW_MIP_MAX_DEPTH_INT_SOL:\n\
  An IP solution was found but the search has been terminated\n\
  because the maximum allowed tree depth (as determined by the \n\
  optional parameter max_depth) has been reached.",
  "NW_MIP_MAX_DEPTH_NO_INT_SOL:\n\
  The maximum allowed tree depth (as determined by the optional\n\
  parameter max_depth) has been reached before any integer \n\
  solution has been found.",
  "NE_MIP_ROOT_HESS_TOO_BIG:\n\
  Reduced Hessian exceeds assigned dimension at root node.\n\
  options.max_df = %1"NAG_IFMT".\n",
  "NE_MIP_HESS_TOO_BIG_INT_SOL:\n\
  Reduced Hessian exceeds assigned dimension during BB tree search.\n\
  options.max_df = %1"NAG_IFMT". An IP solution was found.\n",
  "NE_MIP_HESS_TOO_BIG_NO_INT_SOL:\n\
  Reduced Hessian exceeds assigned dimension during BB tree search.\n\
  options.max_df = %1"NAG_IFMT". No IP solution was found.\n",

/* M01 Chapter */
  "NE_CH_LOOP:\n\
  Too many elements in chain or chain in a loop.",
  "NE_BAD_RANK:\n\
  Invalid %s vector.",

/* S Chapter */
  "NE_REZ_OVERFLOW:\n\
  Argument z causes real part of result to overflow. z = (%11.5e, %11.5e).", 
  "NE_IMZ_OVERFLOW:\n\
  Argument z causes imaginary part of result to overflow.\n\
  z = (%11.5e, %11.5e).",
  "NE_Z_OVERFLOW:\n\
  Argument z causes both real and imaginary parts of result to overflow.\n\
  z = (%11.5e, %11.5e).",
  "NE_IMZ_HALF_PREC:\n\
  The imaginary part of argument z is so large that the result is\n\
  accurate to less than half precision.\n\
  z = (%11.5e, %11.5e).",
  "NE_IMZ_NO_PREC:\n\
  The imaginary part of argument z is so large that the\n\
  result has no precision. z = (%11.5e, %11.5e).",
  "NE_REAL_ARG_TOO_SMALL:\n\
  On entry, %s must be greater than %s: %s = %g.",
  "NE_REAL_ARG_NEG_INT:\n\
  On entry, %s must not be effectively a negative integer: %s = %g.",
  "NE_UNDERFLOW_LIKELY:\n\
  The evaluation has been abandoned due to the likelihood of underflow.",
  "NE_OVERFLOW_LIKELY:\n\
  The evaluation has been abandoned due to the likelihood of overflow.",
  "NW_SOME_PRECISION_LOSS:\n\
  The evaluation has been completed but some precision has been lost.",
  "NE_TOTAL_PRECISION_LOSS:\n\
   The evaluation has been abandoned due to total loss of precision.",
  "NE_TERMINATION_FAILURE:\n\
  The evaluation has been abandoned due to failure to satisfy the termination\
  condition.",
  "NE_INFINITE:\n\
  The evaluation has been abandoned because the function value is infinite.\n\
  The result is returned as the largest machine representable number (see x02alc).",
  "NE_S21_CONV:\n\
  The iterative procedure used to evaluate the integral has failed to converge",
  "NE_NO_LICENCE:\n\
  Sorry invalid usage - Have you got a valid licence? If not please contact NAG.",
  "NE_INT_ARRAY:\n\
  On entry %s[%"NAG_IFMT"] = %"NAG_IFMT".\n\
  Constraint: %s.",
  "NE_VACUUM:\n\
  A vacuum condition has been detected; check your problem formulation.",
  "NE_RESULT_NO_PRECISION:\n\
  The result returned has no precision and has been set to zero.",
  "NE_RESULT_HALF_PRECISION:\n\
  The result returned has less than half precision due to the size of an\n\
  intermediate result.",
  "NE_RESULT_REAL_OVERFLOW:\n\
  The real part of the result overflows. The imaginary part is meaningful.",
  "NE_RESULT_IMAGINARY_OVERFLOW:\n\
  The imaginary part of the result overflows. The real part is meaningful.",
  "NE_RESULT_OVERFLOW:\n\
  Both real and imaginary parts of the result overflow.",
  "NE_INTERNAL_WORKSPACE:\n\
  Computation abandoned due to lack of internal workspace.",
  "NE_TOO_CLOSE_INTEGER:\n\
  Computation abandoned because the real part of Z is too close to a\n\
  negative integer.",
  /* F12 error messages */
  "NE_NO_ARNOLDI_FAC:\n\
  Could not build an Arnoldi factorization.\n\
  The size of the current Arnoldi factorization = %s.",
  "NE_NO_SHIFTS_APPLIED:\n\
  No shifts could be applied during a cycle of the implicitly restarted Arnoldi iteration.",
  "NE_MAX_ITER:\n\
  The maximum number of iterations has been reached.\n\
  The maximum number of iterations  = %s. \n\
  The number of converged eigenvalues = %s.",
  "NE_ZERO_INIT_RESID:\n\
  The option INITIAL RESIDUAL was selected but the starting vector held in resid is zero.",
  "NE_OPT_INCOMPAT:\n\
  The options GENERALIZED and REGULAR are incompatible.",
  "NE_INTERNAL_EIGVAL_FAIL:\n\
  Error in internal call to compute eigenvalues and corresponding error \n\
  bounds of the current upper Hessenberg matrix. \n\
  Please contact NAG.",
  "NE_SCHUR_REORDER:\n\
  The computed Schur form could not be reordered by an internal call. \n\
  This routine returned with ifail = %s. \n\
  Please contact NAG.",
  "NE_SCHUR_EIG_FAIL:\n\
  During calculation of a real Schur form, there was a failure \n\
  to compute %s eigenvalues in a total of %s iterations.",
  "NE_RITZ_COUNT:\n\
  %s got a different count of the number of converged Ritz values \n\
  than the value passed to it through the parameter icomm: \n\
  number counted = %s, number expected = %s.",
  "NE_ZERO_EIGS_FOUND:\n\
  The number of eigenvalues found to sufficient accuracy prior to calling \n\
  %s, as communicated through the parameter icomm, is zero.",
  "NE_TRANSFORM_OVFL:\n\
  Overflow occurred during transformation of Ritz values to those of the original problem.",
  "NE_COMP_BAND_SOL:\n\
  Failure during internal solution of complex banded matrix. \n\
  Please contact NAG.",
  "NE_COMP_BAND_FAC:\n\
  Failure during internal factorization of complex banded matrix. \n\
  Please contact NAG.",
  "NE_REAL_BAND_SOL:\n\
  Failure during internal solution of real banded matrix. \n\
  Please contact NAG.",
  "NE_REAL_BAND_FAC:\n\
  Failure during internal factorization of real banded matrix. \n\
  Please contact NAG.",
  "NE_ZERO_SHIFT:\n\
  The option SHIFTED IMAGINARY or SHIFTED INVERSE IMAGINARY has been \n\
  selected and sigmai = zero on entry; sigmai must be non-zero \n\
  for this mode of operation.",
  "NE_NO_LANCZOS_FAC:\n\
  Could not build an Lanczos factorization. \n\
  The size of the current Lanczos factorization = %s.",
  "NE_BOTH_ENDS_1:\n\
  Eigenvalues from both ends of the spectrum were requested, \n\
  but the number of eigenvalues (nev) requested is one.",
  "NE_INTERNAL_EIGVEC_FAIL:\n\
  In calculating eigenvectors, an internal call returned with an error. \n\
  The returned ifail = %s. Please contact NAG.",
  ""
};
#else
extern NAG_DLL_EXPIMP const char *nag_errlist[];
#endif
#ifdef __cplusplus
}
#endif

#endif  /* not NAG_ERRLIST_H */
