#ifndef NAG_ENUM_TYPES
#define NAG_ENUM_TYPES

/* <nag_enum_types.h>
 *
 * Copyright 2000 Numerical Algorithms Group
 *
 * Contains #defines for the nag enum types, for potential
 * use by Visual Basic programmers.
 *
 * Mark 6.
 * Mark 7 revised. October 2001.
 */


#define   BackwardSequence                 1015
#define   BottomPivot                      1010
#define   ConjugateTranspose               1003
#define   FixedPivot                       1013
#define   ForwardSequence                  1014
#define   FrobeniusNorm                    1017
#define   General                          1020
#define   HermitianLower                   1026
#define   HermitianUpper                   1025
#define   InfinityNorm                     1019
#define   LeftSide                         1008
#define   LowerTriangle                    1005
#define   LowerTriangular                  1022
#define   MaxAbsValue                      1018
#define   Nag_1stDeriv_Small               1164
#define   Nag_2ndDeriv_Large               1163
#define   Nag_3RSSH                        1506
#define   Nag_4253H                        1505
#define   Nag_AboutMean                    1362
#define   Nag_AboutZero                    1363
#define   Nag_AboveForm                    1609
#define   Nag_Absolute                     1088
#define   Nag_AccumulateQ                  1029
#define   Nag_AccumulateZ                  1033
#define   Nag_Alg                          1072
#define   Nag_Alg_loga                     1073
#define   Nag_Alg_loga_logb                1075
#define   Nag_Alg_logb                     1074
#define   Nag_AllEigVals                   1450
#define   Nag_AllG_AllJ                    1169
#define   Nag_AllG_SomeJ                   1167
#define   Nag_AllLevels                    1461
#define   Nag_AllValues                    1054
#define   Nag_AmericanCall                 1114
#define   Nag_AmericanPut                  1116
#define   Nag_AndrewFun                    1382
#define   Nag_ApplyP                       1060
#define   Nag_ApplyQ                       1062
#define   Nag_Ascending                    1597
#define   Nag_AutoCorr                     1546
#define   Nag_AutoCov                      1545
#define   Nag_AverageTies                  1341
#define   Nag_BB_Alloc_Fail                1568
#define   Nag_BB_Internal_Error            1569
#define   Nag_BB_OK                        1567
#define   Nag_BackTransform                1038
#define   Nag_BackwardTransform            1071
#define   Nag_Bartlett                     1535
#define   Nag_Base                          151
#define   Nag_BasisFactB                   1250
#define   Nag_BasisFactBS                  1251
#define   Nag_Basis_Ill_Cond               1220
#define   Nag_Basis_Singular               1221
#define   Nag_Beta                         1488
#define   Nag_Binomial                     1490
#define   Nag_BlomScores                   1337
#define   Nag_BonferroniInterval           1463
#define   Nag_BothSides                     143
#define   Nag_BoundNotSet                  1181
#define   Nag_Bounds                       1182
#define   Nag_BoundsEqual                  1184
#define   Nag_BoundsZero                   1183
#define   Nag_BrDir_NotSet                 1586
#define   Nag_BracketForm                  1610
#define   Nag_Branch_InitX                 1589
#define   Nag_Branch_Left                  1587
#define   Nag_Branch_Right                 1588
#define   Nag_Broad_Search                 1578
#define   Nag_ByBlock                      1052
#define   Nag_CDF                          1470
#define   Nag_CE_EM                        1475
#define   Nag_CE_NR                        1476
#define   Nag_Censored                     1477
#define   Nag_Central                      1334
#define   Nag_Centroid                     1443
#define   Nag_CharacterLabels              1605
#define   Nag_CheckCon                     1140
#define   Nag_CheckObj                     1139
#define   Nag_CheckObjCon                  1141
#define   Nag_ChiSquare                    1489
#define   Nag_ChkNotSet                    1136
#define   Nag_ClassBoundaryComp            1347
#define   Nag_ClassBoundaryUser            1346
#define   Nag_ColMajor                      102
#define   Nag_Cold                         1107
#define   Nag_CompProbApprox               1468
#define   Nag_CompProbExact                1467
#define   Nag_Compl                        1373
#define   Nag_CompleteLink                 1441
#define   Nag_ComputeAll                   1037
#define   Nag_ComputeMoments               1352
#define   Nag_ComputeSelected              1039
#define   Nag_Compute_1                    1065
#define   Nag_Compute_2                    1066
#define   Nag_Compute_3                    1067
#define   Nag_ConCheck                     1153
#define   Nag_Conj                          191
#define   Nag_ConjTrans                     113
#define   Nag_Continue                     1112
#define   Nag_Convolution                  1068
#define   Nag_Correlation                  1069
#define   Nag_Cosine                       1079
#define   Nag_CovMatAve                    1389
#define   Nag_CovMatObs                    1390
#define   Nag_CovNotSet                    1388
#define   Nag_CrashNotSet                  1252
#define   Nag_CrashOnce                    1254
#define   Nag_CrashThreeTimes              1256
#define   Nag_CrashTwice                   1255
#define   Nag_CriteriaNotSet               1530
#define   Nag_CumulantsOnly                1351
#define   Nag_CustomMesh                   1118
#define   Nag_Cycling                      1215
#define   Nag_DInfo_NotSet                 1159
#define   Nag_DLTX                         1269
#define   Nag_DWant_NotSet                 1155
#define   Nag_D_Dbg                        1151
#define   Nag_D_Full                       1150
#define   Nag_D_NoPrint                    1147
#define   Nag_D_NotSet                     1146
#define   Nag_D_Print                      1148
#define   Nag_D_Sum                        1149
#define   Nag_DataCorr                     1415
#define   Nag_DataCovar                    1416
#define   Nag_Deadpoint                    1209
#define   Nag_DecreasingOrder               182
#define   Nag_DeepBroad_Search             1580
#define   Nag_DeepMinObj_Search            1581
#define   Nag_Deep_Search                  1577
#define   Nag_DefInitMesh                  1091
#define   Nag_DegenEndCycle                1241
#define   Nag_DegenInit                    1239
#define   Nag_DegenOptimal                 1240
#define   Nag_DendEast                     1448
#define   Nag_DendNorth                    1446
#define   Nag_DendSouth                    1447
#define   Nag_DendWest                     1449
#define   Nag_Der                          1100
#define   Nag_Deriv                        1170
#define   Nag_DerivNotSet                  1165
#define   Nag_Deriv_Error                  1218
#define   Nag_Deriv_OK                     1160
#define   Nag_Descending                   1598
#define   Nag_DiffInt                      1154
#define   Nag_DirectForm                   1611
#define   Nag_DirectionNotSet              1617
#define   Nag_DiscrimEstimate              1426
#define   Nag_DiscrimPredict               1427
#define   Nag_DistAbs                      1433
#define   Nag_DistEuclid                   1434
#define   Nag_DistSquared                  1435
#define   Nag_DoBoth                       1044
#define   Nag_DoNotForm                    1058
#define   Nag_DoNothing                    1046
#define   Nag_DunnInterval                 1464
#define   Nag_EigVals                      1045
#define   Nag_EigVecs                      1051
#define   Nag_ElementsIn                   1261
#define   Nag_ElementsSeparate             1262
#define   Nag_Emax                          156
#define   Nag_Emin                          155
#define   Nag_EndStateNotSet               1206
#define   Nag_Entire                       1053
#define   Nag_Eps                           157
#define   Nag_EqualCovar                   1422
#define   Nag_EqualPrior                   1428
#define   Nag_ErrorAssess_off              1097
#define   Nag_ErrorAssess_on               1098
#define   Nag_EuropeanCall                 1113
#define   Nag_EuropeanPut                  1115
#define   Nag_Exact                        1532
#define   Nag_Expo                         1366
#define   Nag_Exponential                  1491
#define   Nag_ExtraScale                   1260
#define   Nag_FP                           1188
#define   Nag_FacNoRotate                  1421
#define   Nag_FacRotate                    1420
#define   Nag_FacScoreBart                 1419
#define   Nag_FacScoreRegsn                1418
#define   Nag_Feasible                     1207
#define   Nag_FeasiblePoint                1620
#define   Nag_First                        1599
#define   Nag_FirstCall                    1364
#define   Nag_FirstCallR                   1502
#define   Nag_FirstLevel                   1459
#define   Nag_First_Int                    1583
#define   Nag_FisherInterval               1465
#define   Nag_FormBoth                     1057
#define   Nag_FormP                        1059
#define   Nag_FormQ                        1061
#define   Nag_FormX                        1064
#define   Nag_ForwardTransform             1070
#define   Nag_Freq                         1526
#define   Nag_FrobeniusNorm                 174
#define   Nag_Fun_Constant                 1161
#define   Nag_Fun_LinearOdd                1162
#define   Nag_Function                     1172
#define   Nag_Gamma                        1487
#define   Nag_Garch_Est_Initial_False      1562
#define   Nag_Garch_Est_Initial_True       1561
#define   Nag_Garch_Fcall_False            1558
#define   Nag_Garch_Fcall_True             1557
#define   Nag_Garch_Stationary_False       1560
#define   Nag_Garch_Stationary_True        1559
#define   Nag_Garch_Useht_False            1556
#define   Nag_Garch_Useht_True             1555
#define   Nag_GeneralMatrix                1606
#define   Nag_Grad_HessDiag                1156
#define   Nag_Grad_HessFull                1158
#define   Nag_GroupAverage                 1442
#define   Nag_GroupMeans                   1425
#define   Nag_GroupSizePrior               1429
#define   Nag_HSEQRSource                  1035
#define   Nag_HampelFun                    1381
#define   Nag_HashOK                       1612
#define   Nag_HashTableTooBig              1613
#define   Nag_Helmert                      1458
#define   Nag_Hermite                      1084
#define   Nag_HessFull                     1157
#define   Nag_Hess_Indefinite              1219
#define   Nag_Hess_Too_Big                 1214
#define   Nag_HessianFull                  1615
#define   Nag_HessianLimited               1616
#define   Nag_HessianNotSet                1614
#define   Nag_HighestTies                  1343
#define   Nag_Hot                          1109
#define   Nag_HuberFun                     1380
#define   Nag_HuberReg                     1375
#define   Nag_Iden                         1367
#define   Nag_Ieee                          154
#define   Nag_IgnoreTies                   1345
#define   Nag_IncSignZerosN                1484
#define   Nag_IncSignZerosY                1483
#define   Nag_IncreasingOrder               181
#define   Nag_Indices                      1056
#define   Nag_InfNorm                       175
#define   Nag_Infeasible                   1212
#define   Nag_Infinite                     1078
#define   Nag_InitNotSet                   1176
#define   Nag_InitQ                        1027
#define   Nag_InitZ                        1031
#define   Nag_Init_All                     1179
#define   Nag_Init_F_G_H                   1178
#define   Nag_Init_H_S                     1180
#define   Nag_Init_None                    1177
#define   Nag_InitializeI                  1471
#define   Nag_InputA                       1472
#define   Nag_IntegerLabels                1604
#define   Nag_IntermediateCallR            1503
#define   Nag_Interval                     1055
#define   Nag_Iter                         1128
#define   Nag_Iter_Long                    1129
#define   Nag_JrotInner                     201
#define   Nag_JrotOuter                     202
#define   Nag_JrotSorted                    203
#define   Nag_LCCDefault                   1350
#define   Nag_LCCImhof                     1349
#define   Nag_LCCPan                       1348
#define   Nag_LDLTX                        1267
#define   Nag_LDX                          1268
#define   Nag_LH_Controller                1554
#define   Nag_LH_Observer                  1552
#define   Nag_LLTX                         1270
#define   Nag_LP                           1189
#define   Nag_LS1                          1194
#define   Nag_LS2                          1195
#define   Nag_LS3                          1196
#define   Nag_LS4                          1197
#define   Nag_LTX                          1272
#define   Nag_LU_SolveB                    1248
#define   Nag_LU_SolveBt                   1249
#define   Nag_LU_SolveL                    1247
#define   Nag_LU_TypeB                     1244
#define   Nag_LU_TypeBS                    1245
#define   Nag_LU_TypeBT                    1246
#define   Nag_LX                           1271
#define   Nag_Laguerre                     1083
#define   Nag_LargeEigVals                 1451
#define   Nag_Last                         1600
#define   Nag_LastCallR                    1504
#define   Nag_LastLevel                    1460
#define   Nag_LeastSquares                 1531
#define   Nag_LeftDerivs                   1104
#define   Nag_LeftSide                      141
#define   Nag_Legendre                     1081
#define   Nag_LinAlgBand                   1120
#define   Nag_LinAlgFull                   1119
#define   Nag_LinAlgSparse                 1121
#define   Nag_LinFunNotSet                 1173
#define   Nag_Lin_Deriv                    1174
#define   Nag_Lin_NoDeriv                  1175
#define   Nag_LinearRatio                  1354
#define   Nag_Log                          1368
#define   Nag_LogNormal                    1494
#define   Nag_Logged                       1542
#define   Nag_Logistic                     1371
#define   Nag_Lower                         122
#define   Nag_LowerMatrix                  1607
#define   Nag_LowerSemiInfinite            1077
#define   Nag_LowerTail                    1329
#define   Nag_LowestTies                   1342
#define   Nag_Lsq                          1379
#define   Nag_LsqScale                     1413
#define   Nag_MILP                         1571
#define   Nag_MIP_Best_ISol                1223
#define   Nag_MIP_Big_Hess_ISol            1232
#define   Nag_MIP_Big_Hess_No_ISol         1234
#define   Nag_MIP_Max_Depth_ISol           1233
#define   Nag_MIP_Max_Depth_No_ISol        1237
#define   Nag_MIP_Max_Itn_ISol             1230
#define   Nag_MIP_Max_Itn_No_ISol          1235
#define   Nag_MIP_Max_Nodes_ISol           1231
#define   Nag_MIP_Max_Nodes_No_ISol        1236
#define   Nag_MIP_No_ISol                  1225
#define   Nag_MIP_Root_Big_Hess            1229
#define   Nag_MIP_Root_Infeasible          1227
#define   Nag_MIP_Root_Max_Itn             1228
#define   Nag_MIP_Root_Unbounded           1226
#define   Nag_MIP_Stop_First_ISol          1224
#define   Nag_MIP_TypeNotSet               1570
#define   Nag_MIP_User_Stop                1238
#define   Nag_MIQP1                        1572
#define   Nag_MIQP2                        1573
#define   Nag_MIQP3                        1574
#define   Nag_MIQP4                        1575
#define   Nag_MPS_List                     1566
#define   Nag_MPS_Summary                  1565
#define   Nag_MallowsReg                   1376
#define   Nag_ManyIterations               1086
#define   Nag_Marginal                     1533
#define   Nag_MatCorr_Covar                1417
#define   Nag_MatCorrelation               1393
#define   Nag_MatStandardised              1394
#define   Nag_MatSumSq                     1395
#define   Nag_MatUp                        1431
#define   Nag_MatVarCovar                  1396
#define   Nag_MaxNorm                       177
#define   Nag_Maximize                     1619
#define   Nag_Mean                         1539
#define   Nag_MeanInclude                  1358
#define   Nag_MeanZero                     1359
#define   Nag_Median                       1444
#define   Nag_MinObj_Search                1579
#define   Nag_MinVariance                  1445
#define   Nag_Minimize                     1618
#define   Nag_Minus                        1043
#define   Nag_Mixed                        1089
#define   Nag_NS_Bounded                   1594
#define   Nag_NS_Infeasible                1595
#define   Nag_NS_Integer                   1593
#define   Nag_NS_NotBranched               1592
#define   Nag_NS_NotSet                    1590
#define   Nag_NS_NotSolved                 1591
#define   Nag_NS_Terminated                1596
#define   Nag_Nearest_Half                 1584
#define   Nag_NewStart                     1110
#define   Nag_NoBlocks                     1454
#define   Nag_NoBounds                     1185
#define   Nag_NoBounds_One_Call            1186
#define   Nag_NoCensored                   1478
#define   Nag_NoCheck                      1137
#define   Nag_NoConj                        192
#define   Nag_NoCorrection                 1538
#define   Nag_NoCrash                      1253
#define   Nag_NoDeriv                      1171
#define   Nag_NoFreq                       1527
#define   Nag_NoLabels                     1603
#define   Nag_NoMatUp                      1432
#define   Nag_NoOutput                     1564
#define   Nag_NoPrint                      1125
#define   Nag_NoScale                      1258
#define   Nag_NoTrans                       111
#define   Nag_NoTransNorm                  1407
#define   Nag_NoVarScale                   1439
#define   Nag_NoVec                        1040
#define   Nag_NoWeights                    1401
#define   Nag_NodSel_NotSet                1576
#define   Nag_NonRefDiag                    130
#define   Nag_NonUnitDiag                   131
#define   Nag_Norm                         1410
#define   Nag_Normal                       1486
#define   Nag_NormalDistn                  1481
#define   Nag_NormalScores                 1336
#define   Nag_NotEqualCovar                1423
#define   Nag_NotKnown                     1036
#define   Nag_NotLsqScale                  1414
#define   Nag_NotQ                         1028
#define   Nag_NotSupplied                  1264
#define   Nag_NotZ                         1032
#define   Nag_Not_Converged                1216
#define   Nag_Not_Kuhn_Tucker              1217
#define   Nag_ObjCheck                     1152
#define   Nag_ObservAdd                    1360
#define   Nag_ObservDel                    1361
#define   Nag_OneIteration                 1085
#define   Nag_OneNorm                       171
#define   Nag_Optimal                      1208
#define   Nag_Orig                         1408
#define   Nag_OrigCentroid                 1409
#define   Nag_OrigNorm                     1411
#define   Nag_OrigNormCentroid             1412
#define   Nag_OsherOriginal                1122
#define   Nag_OsherPhysical                1123
#define   Nag_Out_Of_Workspace             1222
#define   Nag_OutputNotSet                 1563
#define   Nag_Overflow                      160
#define   Nag_PDF                          1469
#define   Nag_ParaEstimated                1497
#define   Nag_ParaSupplied                 1496
#define   Nag_ParallelBlocks               1456
#define   Nag_Parzen                       1537
#define   Nag_Permute                      1047
#define   Nag_Plus                         1042
#define   Nag_Poisson                      1492
#define   Nag_Poly                         1457
#define   Nag_PopVarEqual                  1473
#define   Nag_PopVarNotEqual               1474
#define   Nag_Prec                          158
#define   Nag_PrintNotSet                  1124
#define   Nag_ProbTypeNotSet               1187
#define   Nag_Probit                       1372
#define   Nag_PsiNotSet                    1378
#define   Nag_QP1                          1190
#define   Nag_QP2                          1191
#define   Nag_QP3                          1192
#define   Nag_QP4                          1193
#define   Nag_QuadRatio                    1355
#define   Nag_QuasiRandom_Cont             1622
#define   Nag_QuasiRandom_Faure            1625
#define   Nag_QuasiRandom_Finish           1623
#define   Nag_QuasiRandom_Init             1621
#define   Nag_QuasiRandom_Nied             1626
#define   Nag_QuasiRandom_Sobol            1624
#define   Nag_RC                           1102
#define   Nag_RCI_Approx                   1480
#define   Nag_RCI_Exact                    1479
#define   Nag_RK_2_3                       1094
#define   Nag_RK_4_5                       1095
#define   Nag_RK_7_8                       1096
#define   Nag_RK_onestep                   1093
#define   Nag_RK_range                     1092
#define   Nag_RandomTies                   1344
#define   Nag_RankScores                   1335
#define   Nag_RatioMoments                 1353
#define   Nag_Rational                     1082
#define   Nag_ReStart                      1111
#define   Nag_RealInfNorm                   176
#define   Nag_RealMaxNorm                   178
#define   Nag_RealOneNorm                   172
#define   Nag_Reci                         1370
#define   Nag_Rectangular                  1534
#define   Nag_RegNotSet                    1374
#define   Nag_Relative                     1087
#define   Nag_RightDerivs                  1105
#define   Nag_RightSide                     142
#define   Nag_Rnd                           153
#define   Nag_RoLoadNotStand               1406
#define   Nag_RoLoadStand                  1405
#define   Nag_RowColScale                  1259
#define   Nag_RowMajor                      101
#define   Nag_SStress                      1453
#define   Nag_SamplePoints                 1424
#define   Nag_SavageScores                 1340
#define   Nag_Scale                        1049
#define   Nag_ScaleNotSet                  1257
#define   Nag_ScaleRes                     1601
#define   Nag_ScheffeInterval              1466
#define   Nag_Schur                        1048
#define   Nag_SchweppeReg                  1377
#define   Nag_ScoresEigenval               1400
#define   Nag_ScoresNotStand               1398
#define   Nag_ScoresStand                  1397
#define   Nag_ScoresUnitVar                1399
#define   Nag_Select_Modulus               1265
#define   Nag_Select_RealPart              1266
#define   Nag_SerialBlocks                 1455
#define   Nag_Sfmin                         161
#define   Nag_Shep                         1103
#define   Nag_SigmaBypas                   1392
#define   Nag_SigmaChi                     1387
#define   Nag_SigmaConst                   1386
#define   Nag_SigmaNotSet                  1384
#define   Nag_SigmaRes                     1385
#define   Nag_SigmaSimul                   1391
#define   Nag_SimpleCheck                  1138
#define   Nag_Sine                         1080
#define   Nag_SingleCallR                  1501
#define   Nag_SingleLink                   1440
#define   Nag_SmoothFitFull                1509
#define   Nag_SmoothFitPartial             1507
#define   Nag_SmoothFitQuick               1508
#define   Nag_SmoothParamCV                1510
#define   Nag_SmoothParamDF                1512
#define   Nag_SmoothParamGCV               1511
#define   Nag_Sol                          1099
#define   Nag_SolDer                       1101
#define   Nag_Soln                         1127
#define   Nag_Soln_Iter                    1131
#define   Nag_Soln_Iter_Const              1133
#define   Nag_Soln_Iter_Diag               1134
#define   Nag_Soln_Iter_Full               1135
#define   Nag_Soln_Iter_Long               1132
#define   Nag_Soln_Root                    1126
#define   Nag_Soln_Root_Iter               1130
#define   Nag_SomeG_AllJ                   1168
#define   Nag_SomeG_SomeJ                  1166
#define   Nag_SparseFP                     1198
#define   Nag_SparseFPE                    1201
#define   Nag_SparseFPL                    1202
#define   Nag_SparseFPS                    1203
#define   Nag_SparseLP                     1199
#define   Nag_SparseNsym_BiCGSTAB          1275
#define   Nag_SparseNsym_CG                1276
#define   Nag_SparseNsym_CGS               1274
#define   Nag_SparseNsym_Check             1315
#define   Nag_SparseNsym_CompletePiv       1284
#define   Nag_SparseNsym_FailDups          1291
#define   Nag_SparseNsym_FailZeros         1288
#define   Nag_SparseNsym_JacPrec           1301
#define   Nag_SparseNsym_KeepZeros         1287
#define   Nag_SparseNsym_MarkowitzPiv      1285
#define   Nag_SparseNsym_ModFact           1279
#define   Nag_SparseNsym_NoCheck           1314
#define   Nag_SparseNsym_NoPiv             1281
#define   Nag_SparseNsym_NoPrec            1299
#define   Nag_SparseNsym_PartialPiv        1283
#define   Nag_SparseNsym_Prec              1302
#define   Nag_SparseNsym_RGMRES            1273
#define   Nag_SparseNsym_RemoveDups        1289
#define   Nag_SparseNsym_RemoveZeros       1286
#define   Nag_SparseNsym_SSORPrec          1300
#define   Nag_SparseNsym_SYMMLQ            1277
#define   Nag_SparseNsym_StoreCS           1292
#define   Nag_SparseNsym_StoreSCS          1293
#define   Nag_SparseNsym_SumDups           1290
#define   Nag_SparseNsym_TFQMR             1278
#define   Nag_SparseNsym_UnModFact         1280
#define   Nag_SparseNsym_UnWeighted        1304
#define   Nag_SparseNsym_UserPiv           1282
#define   Nag_SparseNsym_Weighted          1303
#define   Nag_SparseQP                     1200
#define   Nag_SparseQPP                    1204
#define   Nag_SparseQPS                    1205
#define   Nag_SparseSym_Bisect             1307
#define   Nag_SparseSym_CG                 1294
#define   Nag_SparseSym_Check              1317
#define   Nag_SparseSym_InfNorm            1311
#define   Nag_SparseSym_JacPrec            1324
#define   Nag_SparseSym_KeepZeros          1327
#define   Nag_SparseSym_Lanczos            1295
#define   Nag_SparseSym_MarkPiv            1319
#define   Nag_SparseSym_ModFact            1297
#define   Nag_SparseSym_NoBisect           1308
#define   Nag_SparseSym_NoCheck            1316
#define   Nag_SparseSym_NoPiv              1318
#define   Nag_SparseSym_NoPrec             1322
#define   Nag_SparseSym_OneNorm            1309
#define   Nag_SparseSym_Prec               1321
#define   Nag_SparseSym_RemoveDups         1326
#define   Nag_SparseSym_RemoveZeros        1328
#define   Nag_SparseSym_SSORPrec           1323
#define   Nag_SparseSym_SumDups            1325
#define   Nag_SparseSym_TFQMR              1296
#define   Nag_SparseSym_TermLanczos        1312
#define   Nag_SparseSym_TermLanczosCG      1313
#define   Nag_SparseSym_TwoNorm            1310
#define   Nag_SparseSym_UnModFact          1298
#define   Nag_SparseSym_UnWeighted         1306
#define   Nag_SparseSym_UserPiv            1320
#define   Nag_SparseSym_Weighted           1305
#define   Nag_Sqrt                         1369
#define   Nag_StartNotSet                  1106
#define   Nag_StatesExternal               1243
#define   Nag_StatesInternal               1242
#define   Nag_Stress                       1452
#define   Nag_StudentT                     1495
#define   Nag_Subspace                     1050
#define   Nag_Supplied                     1263
#define   Nag_T                             152
#define   Nag_TableStatsAv                 1517
#define   Nag_TableStatsLarge              1520
#define   Nag_TableStatsMedian             1518
#define   Nag_TableStatsNObs               1515
#define   Nag_TableStatsSmall              1521
#define   Nag_TableStatsTotal              1516
#define   Nag_TableStatsVar                1519
#define   Nag_TableUpdateI                 1523
#define   Nag_TableUpdateU                 1522
#define   Nag_TabulateVarCont              1525
#define   Nag_TabulateVarDiscr             1524
#define   Nag_Tdistn                       1482
#define   Nag_TestStatisticsDAbs           1498
#define   Nag_TestStatisticsDNeg           1500
#define   Nag_TestStatisticsDPos           1499
#define   Nag_Too_Many_Iter                1213
#define   Nag_Trans                         112
#define   Nag_Trend                        1540
#define   Nag_Tukey                        1536
#define   Nag_TukeyFun                     1383
#define   Nag_TukeyInterval                1462
#define   Nag_TukeyScores                  1338
#define   Nag_TwoNorm                       173
#define   Nag_TwoTail                      1333
#define   Nag_TwoTailConfid                1332
#define   Nag_TwoTailSignif                1331
#define   Nag_UH_Controller                1553
#define   Nag_UH_Observer                  1551
#define   Nag_Unbounded                    1211
#define   Nag_Underflow                     159
#define   Nag_Uniform                      1485
#define   Nag_UniformMesh                  1117
#define   Nag_UnitDiag                      132
#define   Nag_Unlogged                     1541
#define   Nag_UnscaleRes                   1602
#define   Nag_UnweightedEstimate           1357
#define   Nag_Update                       1365
#define   Nag_UpdateQ                      1063
#define   Nag_UpdateSchur                  1030
#define   Nag_UpdateZ                      1034
#define   Nag_Upper                         121
#define   Nag_UpperMatrix                  1608
#define   Nag_UpperSemiInfinite            1076
#define   Nag_UpperTail                    1330
#define   Nag_UseFFT_N                     1514
#define   Nag_UseFFT_Y                     1513
#define   Nag_UseOffset_N                  1529
#define   Nag_UseOffset_Y                  1528
#define   Nag_UseRange                     1543
#define   Nag_UseSD                        1544
#define   Nag_Use_Priority                 1585
#define   Nag_UserInitMesh                 1090
#define   Nag_UserPrior                    1430
#define   Nag_UserProb                     1493
#define   Nag_UserVec                      1041
#define   Nag_VarScaleRange                1437
#define   Nag_VarScaleStd                  1436
#define   Nag_VarScaleUser                 1438
#define   Nag_VarSel_NotSet                1582
#define   Nag_WaerdenScores                1339
#define   Nag_Warm                         1108
#define   Nag_Weakmin                      1210
#define   Nag_WeightedEstimate             1356
#define   Nag_Weights                      1402
#define   Nag_Weightsfreq                  1403
#define   Nag_Weightsvar                   1404
#define   Nag_XCheckCon                    1144
#define   Nag_XCheckObj                    1143
#define   Nag_XCheckObjCon                 1145
#define   Nag_XSimpleCheck                 1142
#define   Nag_ab_prod                      1549
#define   Nag_ab_sep                       1550
#define   Nag_curr_state                   1548
#define   Nag_next_state                   1547
#define   NoTranspose                      1001
#define   NotUnitTriangular                1007
#define   OneNorm                          1016
#define   RightSide                        1009
#define   SymmetricLower                   1024
#define   SymmetricUpper                   1023
#define   TopPivot                         1011
#define   Transpose                        1002
#define   UnitTriangular                   1006
#define   UpperTriangle                    1004
#define   UpperTriangular                  1021
#define   VariablePivot                    1012

#endif  /* not NAG_ENUM_TYPES */
