/*------------------------------------------------------------------------------*
 * File Name: GetNBox.h															*
 * Creation: CPY 1/27/03														*
 * Purpose: Origin C support for a general parameters edit box as a replacement	*
 *	of the LabTalk GetNumber dialog												*
 * Copyright (c) OriginLab Corp.2003											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	CPY 4/23/03 v7.0568 OPERATION_CLASS_NEED_TRY_AND_AUTO_UPDATE				*
 *	CPY 5/13/03 v7.0584 QA70-4467 BUTTON_IN_EDIT_TEXT							*
 *	CPY 5/15/03 v7.0585 QA70-4477 TREE_BRANCH_SUPPORT							*
 *	CPY 8/24/03 v7.5674 QA70-5061 QA70-5061 ADD_DISPLAY_OPTIONS					*
 *	CPY v7.5723 QA70-5376 GETNBOX_ADD_SIG_DIGITS_SUPPORT						*
 *	CPY v7.5763 QA70-5162 11/18/03 GETNBOX_JUSTIFICATION_AND_ENABLE_EDIT		*
 *	CPY v7.5811 1/30/04 QA70-5910 PREVIEW_GETNBOX								*
 *	YuI 3/24/04 v7.5846 QA70-6118 NEW_DATA_SELECTOR_TOOL						*
 *  Danice v8.0870 5/11/04 QA70-6222 GETNTREE_AUTO_LOAD_DEFAULT					*
 *	CPY 6/11/04 GETN_SAVE_SETTINGS_ONLY_LOAD_DEFAULT_IF_NEW						*
 *  Forest 09/10/04 QA70-6682 SETTINGS_THEME_FILE_SAVE_LOAD                     *
 *	Frank 09/13/04		MOVE_GETNBOX_JUSTIFICATION_TO_OC_CONST					*
 *	CPY 9/13/04 GETN_COMBO_FAILED_WHEN_NOT_VAL_LESS_THEN_ZERO					*
 *	Frank v78.0 11/14/04 CHECK_GETNBOX_ROW_HEIGHT_ATTRIBUTE						*
 *  Danice 11/15/04 QA70-7169 v8.0163 TREE_ROW_SHOW_ALTERNATE_COLORS			*
 *  Danice 12/2/04 v8.0169 DISABLE_ROW_WITHOUT_GRAY_COLOR						*
 * EJP 12-16-2004 QA70-6721 ASCIMP_OPTIONS_USE_GETNBOX							*
 *  DG 3/17/05 v8.0204 SUPPORT_GETN_BOX_GRIDVIEW								*
 *  DG 3/30/05 v8.0212 SUPPORT_MAX_HEIGHT_WIDTH_SETTING							*
 *	Frank 	04/05/05 GUI_ADVANCED_SETTING_FROM_FILE								*
 *	ML 4/18/2005 XFUNCTION_TREE_MANIPULATION_IN_VC								*
 *  DG 6/13/05 v8.0248 VIEW_GRAPH_GETNBOX										*
 *  SY 8/17/05 QA70-8027 v8.0290 IMPORT_WIZARD_XF								*
 *	CPY 9/12/05 GET_N_IMAGE_DIALOG												*
 *	Frank 10/16/05 COMMENT_NOT_USE_MARCO										*
 *	CPY 12/26/05 GETNGRAPH_BOX_TYPE_4											*
 *	TD 2-14-06 QA70-8490 GETN_EVENTS_IN_TREE_DLG								*
 *	ML 4/25/2006 EDIT_PROPERTY_PASSWORD											*
 *	CPY 6-30-06 QA70-8792 GETN_RESIZING_FROM_ATTRIBUTE							*
 *	CPY 7/3/06 QA70-8798 DYNABOX_BETTER_EVENTS									*
 *	CPY 10/10/06 QA70-9039 XF_WIZARD_BAR										*
 *	TD 11-06-06 COLOR_CHOICE_FOR_READONLY										*
 *	Jasmine 02/01/07 GETN_PREVIEW_DLG_NEED_MORE_BTNS							*
 *	Jasmine 02/03/07 ENABLE_CUSTOM_BUTTONS_SEPARATELY							*
 *	CPY 3/5/07 GETNN_ON_CHANGED_TO_SMALLER_NEGATIVE 							*
 *	Sim 03-28-2007 ADDITIONAL_GETN_EVENT										*
 *	Sim 04-09-2007 FIX_CUSTOM_BUTTON_ENABLE_ISSUE								*
 *	CPY TD 5/3/07 QA70-9714 WIDER_CONTROL										*
 *	Sim 05-29-2007 UPDATE_HEADER												*
 *	Sim 06-29-2007 SUPPORT_SENT_MESSAGE_FROM_EXTERNAL_WINDOW 					*
 *	Sim 07-12-2007 EXTEND_UPDATE_GRAPH_CONTROL_VALUE							*
 *	TD 7-20-07 QA80-10087  ABILITY_TO_TAB_DYNACONTROL_ROWS						*
 *	CPY 10/23/2007 QA70-10577 COMBO_STR_STAY_AS_E_INTERNALLY_IN_DYNA_CNTRL		*
 *	Hong 10/25/07 v8.0733 CENTRALIZE_CODE										*
 *	Sim 10-30-2007 NOTIFY_XF_NEED_APPLY											*
 *	Sim 11-01-2007 NOTIFY_XF_WIZ_UPDATE_PATH									*
 *	Sim 11-13-2007 GET_CREATED_OUTPUT_PAGE_INFO									*
 *	Sim 12-06-2007 IMPROVE_EVENT1_PARAM_STR_AUX									*
 *	Hong 01/17/08 v8.0787b MORE_CONVENIENT_WAY_FOR_XF_EDIT_VARIABLE				*
 *	Sim 02-28-2008 QA80-11156 XF_PANEL_APPLY_BUTTON								*
 *	Jasmine 02/29/08 QA80-11043-P2 GETN_BUTTONS_SEPARATELY_ENABLE_DISABLE		*
 *	Hong 03/19/08 8.0827 NLFIT_REMOVE_SETTINGS_ALLREADY_IN_FDF_FILE_FROM_THEME	*
 *	Folger 03/19/08 QA80-10598 NEW_GETN_LOCALIZAED_CHECK_MACRO					*
 *	Hong 03/26/08 v8.0832b PA_PEAKS_ADD_DONE_DIALOG_WHEN_MODIFY					*
 *	Sim 04-07-2008 QA80-11371 THEME_SAVING_OPTIONS								*
 *	YuI 04/09/08 QA70-11394 GETN_CONTROL_FOR_SYMBOL_WELL						*
 *	Sim 04-22-2008 QA80-11371 THEME_SAVING_OPTIONS_HINT							*
 *	Hong 06/11/08 v8.0882b FIX_NETCDF_LINKING_ERROR_CAUSE_BY_REMOVE_GETN_NEXT_PREV_DLG
 *  Iris 10/28/2008 QA80-12479 FIX_CANNOT_SHOW_APPLY_BTN_IN_SIMPLE_GETN			*
 *	Sim 10-31-2008 INDICATE_THEME_ON_PA_FIT_PARAM_CHANGE						*
 *	TD 01-14-2009 QA80-12869 COMBO_AND_EDIT_WITH_BUTTON_USING_USER_EVENTS		*
 *	Hong 04/03/09 QA80-13409 MULTI_SELECT_LISTBOX_IN_DYNACONTROL				*
 *	Folger 04/14/09 QA80-12786-P3 PREVIEW_GETN_FAILS_TO_SHOW_DATA_TIME_FORMAT_AFTER_CHANGED
 *	Folger 04/14/09 QA80-13436 IMPROVE_MECHANISM_ABOUT_XF_ERR_MSG_SHOWN_IN_BODY	*
 *	Sim 06-08-2009 CENTRALIZE_GETN_DLG_HELP_ID									*
 * Kenny 06/16/2009 QA81-13796 SUPPORT_SETTING_DYNABOX_CTRL_BITS				*
 *	Kyle 07/22/2009 QA80-12339-P1 WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS
 *	YuI 09/16/09 QA70-13696 XFUNCTION_EVENT2_IMPLEMENTATION						*
 *	Sim 11-18-2009 QA81-14641 DYNA_CTRL_SUPPORT_DATE_TIME_PICKER				*
 *	TD ML 01-18-2010 QA70-14900 WANTED_GROUPBOX_BRANCH_IN_DYNACONTROL			*
 *	Folger 03/08/10 QA81-15177 GETNBOX_SUPPORT_MOVE_FIRST_LEVEL_BRANCHES_INTO_TABS
 *	Folger 05/18/10 ORG-143 LT_GETN_HINT_TEXT_SUPPORT							*
 *	Folger 06/01/10 ORG-120 DATA_DISPLAY_DIALOG_IMPROVEMENT						*
 *	Kyle 06/17/2010 ORG-98-S40 NEW_WIDTH_CONTROL_WITHOUT_DROP_DOWN				*
 *	Folger 10/27/2010 ORG-27 NEW_DIGITIZER_GADGET								*
 *	Hong 12/29/10 ORG-1882-S2 STACK_COL_SUPPORT_MULTI_IDENTIFIER				*
 *	Folger 03/18/2011 ORG-2486-P1 QUICKFIT_BAD_INIT_ROI_POSITION_FOR_NONLINEAR_SCALE
 *	Bill 10/12/2011 ORG-3965-S2 WANT_CHECK_BOX_ON_THE_LEFT_SIDE					*
 *	Folger 07/03/2012 ORG-6076 SUPPRT_GET_SELECTION_RANGE_FROM_INTERATIVE_CONTROL_FROM_OC
 *	Folger 08/06/2012 ORG-6266-S4 SUPPORT_SPECIFY_DEFAULT_FOCUS_CONTROL_IN_DYNACTRL
 *	Folger 09/17/2012 ORG-6848-P1 BETTER_OUTPUT_COLUMNS_FILTERING_FOR_INPUT_COLUMN_BROWSER
 *	Folger 09/18/2012 ORG-6861 SUPPORT_LT_GETN_MATRIX_BROWSER					*
 *------------------------------------------------------------------------------*/

 
#ifndef _GET_N_BOX
#define _GET_N_BOX

#include <ImageControlBase.h> //---- CPY 9/12/05 GET_N_IMAGE_DIALOG
///Joseph	12/07/06	ADD_MESSAGE_BOX
#define	STR_ERRMSG_ATTRIB	"ErrMsg"
#define	STR_OK_ENABLE_TAG	"OK_Enable:"
///End	ADD_MESSAGE_BOX
#define	STR_APPLY_BUTTON_CLOSE	"APPLY_BUTTON_CLOSE"		///Joseph 01/29/07 GETN_BOX_ADD_APPLY_BUTTON
#define STR_ATTRIB_TEMPORY_TREENODE "TemporyTreeNode" ///Joseph 12/29/06 RESET_TREENODE_VARIABLE_ON_THEME_FACTORY_DEFAULT
///Joseph 01/29/07 GETN_BOX_ADD_APPLY_BUTTON
#define STR_BUTTON	"Button:"
#define	SET_APPLY_BUTTTON_TEXT(_BUTTON_TEXT, _TEXTNAME)   string _strTemp = _TEXTNAME, _strButton = STR_BUTTON; _BUTTON_TEXT = _strButton + _strTemp;
///End GETN_BOX_ADD_APPLY_BUTTON

/// Iris 02/09/2007 v8.059 SEND_GRAPH_OBJECT_EVENT_WITH_PARAMS
#define	STR_GO_MSG_INFO_1_ATTRIB		"MsgInfo1"
#define	STR_GO_MSG_INFO_2_ATTRIB		"MsgInfo2"
///END SEND_GRAPH_OBJECT_EVENT_WITH_PARAMS

///Joseph 05/16/07 ADD_HINT_TAB_TO_NLSF
#define STR_HINT_SECTION_ATTRIB		"Hint"
///End ADD_HINT_TAB_TO_NLSF

//#include <Dialog.h>
//#include <tree_utils.h>
///Joseph 02/25/07 ARGUMENTS_ORDER_NOT_RIGHT
/////Joseph 02/07/07 FIX_BUG_ON_MORE_PAGES
////int 	post_getn_dialog_message(int nMsg, uint wParam = 0, uint lParam = 0);  /// Iris 12/27/2006 v8.0533 CALL_EVENT1_ON_GRAPH_OBJ_MOVING
//int 	post_getn_dialog_message(int nMsg, uint wParam = 0, uint nPageID = 0, uint lParam = 0);
/////End FIX_BUG_ON_MORE_PAGES
/**$
*/
int 	post_getn_dialog_message(int nMsg, WPARAM wParam = 0, LPARAM lParam = 0 ,uint nPageID = 0);
///End ARGUMENTS_ORDER_NOT_RIGHT

//--- CPY 5/13/03 v7.0584 BUTTON_IN_EDIT_TEXT
//#define TRGP_STR_BUTTON	1000 CPY 9/21/05 moved to oc_const.h
//---

///Danice DISABLE_ROW_WITHOUT_GRAY_COLOR
/// ML 4/18/2005 XFUNCTION_TREE_MANIPULATION_IN_VC
//#define ENABLE_READ_ONLY		2
/// end XFUNCTION_TREE_MANIPULATION_IN_VC
///end DISABLE_ROW_WITHOUT_GRAY_COLOR

/// YuI 03/17/05: moving to GetNBox.h
/// ML 4/18/2005 XFUNCTION_TREE_MANIPULATION_IN_VC
//#define STR_XF_VARIABLE_NODE_ATTRIB							"_XFUNCTION_VAR"
//#define STR_INTERACTIVE_DROP_DOWN_BUTTON_ID_ATTRIB			"_DROP_DOWN_BUTTON_ID"
/// end XFUNCTION_TREE_MANIPULATION_IN_VC
/// end YuI 03/17/05

/// ML 3/24/2005 per CP's request:
//#define GETN_CURRENT_NODE	_tmpSubNode	//CPY 12/13/04
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_CURRENT_SUBNODE
*/
#define GETN_CURRENT_SUBNODE	_tmpSubNode	//CPY 12/13/04
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_CURRENT_NODE
*/
#define	GETN_CURRENT_NODE		_tmpNode	/// ML 3/24/2005 This should be used when passing current node tree to other functions

//--- CPY 8/26/05 ADD_HELP_TO_XF
#define TRGP_EXTERNAL_EDIT	ONODETYPE_EXTERNAL // temp, will need a a new ONODETYPE_	
//---
	
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_OLDVAL
*/
#define GETN_OLDVAL _tmpSubNode.SetAttribute(STR_CHANGED_ATTRIB,_tmpSubNode.strVal); // CPY 8/1/05

#define STR_CLASS_OPTION_NAME_ATTRIB "ClassOptionName"	//Frank 1/22/05
#define STR_SHOW_ADVANCED_ATTRIB	 "AdvancedShowOption"	//Frank 1/26/05

///Frank 	04/05/05 GUI_ADVANCED_SETTING_FROM_FILE
/**$
	This attribute is using to set GUI's advanced settings.
	Parameters:
		_ADVANCED_FILE_NAME	= [input] Theme file name...
*/
#define GETN_ADVANCED_SETTING(_ADVANCED_FILE_NAME)		_tmpSubNode.SetAttribute(STR_GUI_THEME_FILE_ATTRIB, _ADVANCED_FILE_NAME);
///End GUI_ADVANCED_SETTING_FROM_FILE

// Comments last updated by Pinky on 10/09/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:TREE_ADD_LABEL
*/
#define TREE_ADD_LABEL(_NODE_LABEL)	_tmpSubNode.SetAttribute(STR_LABEL_ATTRIB, _NODE_LABEL) 

//-------- CPY 5/7/07 AUTO_TO_USE_IN_GENERAL_GETN
// Last updated by Sim 05-29-2007 UPDATE_HEADER
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_ADD_AUTO
*/
#define GETN_ADD_AUTO(_CHECK)	_tmpSubNode.SetAttribute(STR_ATTRIB_AUTO, _CHECK?"1":"0"); 
//-------- end AUTO_TO_USE_IN_GENERAL_GETN

/// Bill 10/12/2011 ORG-3965-S2 WANT_CHECK_BOX_ON_THE_LEFT_SIDE
/**#
*/
#define GETN_ADD_LEFT_CHECK(_CHECK)	_tmpSubNode.SetAttribute(STR_ATTRIB_DYNACONTROL_USE_CHECK, _CHECK ? 1 : 0);
/// End WANT_CHECK_BOX_ON_THE_LEFT_SIDE

// declaration
// Comments last updated by Pinky on 10/09/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_NAMED_TREE
*/
#define GETN_NAMED_TREE(_TR_NAME, _NODE_NAME)	Tree GetNBoxTree_##_TR_NAME; TreeNode _TR_NAME = GetNBoxTree_##_TR_NAME.AddNode(#_NODE_NAME); TreeNode _tmpNode = _TR_NAME; TreeNode _tmpSubNode; string _strTemp;

// Comments last updated by Pinky on 10/09/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_NAMED_TREE2
*/
#define GETN_NAMED_TREE2(_TR_NAME, _NODE_NAME)	Tree GetNBoxTree_##_TR_NAME; TreeNode _TR_NAME = GetNBoxTree_##_TR_NAME.AddNode(_NODE_NAME); TreeNode _tmpNode = _TR_NAME; TreeNode _tmpSubNode; string _strTemp;

// Comments last updated by Pinky on 10/09/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_TREE
*/
#define GETN_TREE(_TR_NAME)	GETN_NAMED_TREE(_TR_NAME, GetNTree)	// for using as a tree, with tree look

// Comments last updated by Pinky on 10/09/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_BOX
*/
#define GETN_BOX(_TR_NAME)	GETN_NAMED_TREE(_TR_NAME, GetNBox) // for using as simple dialog, dialog look
// add parameter

// Comments last updated by Pinky on 10/09/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_CHECK
*/
#define GETN_CHECK(_NODE_NAME, _NODE_LABEL, _DEFAULT_VAL)  _tmpSubNode = _tmpNode.AddNumericNode((int)_DEFAULT_VAL, #_NODE_NAME, TRGP_CHECK);TREE_ADD_LABEL(_NODE_LABEL);

//------ Folger 03/19/08 QA80-10598 NEW_GETN_LOCALIZAED_CHECK_MACRO
/**$
*/
#define GETN_CHECK_L(_NODE_NAME, _NODE_LABEL, _DEFAULT_VAL)		\
	_tmpSubNode = _tmpNode.AddNumericNode((int)_DEFAULT_VAL, #_NODE_NAME, TRGP_CHECK);\
	TREE_ADD_LABEL(GetLocalized(_NODE_LABEL));\
	_tmpSubNode.SetAttribute(STR_LABEL_E_ATTRIB, _NODE_LABEL);
//------


/// YuI 04/09/08 QA70-11394 GETN_CONTROL_FOR_SYMBOL_WELL
// comments last updated by Sophy on 04/18/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_SYMBOL
*/
#define GETN_SYMBOL(_NODE_NAME, _NODE_LABEL, _DEFAULT_VAL)  _tmpSubNode = _tmpNode.AddNumericNode((int)_DEFAULT_VAL, #_NODE_NAME, TRGP_SYMBOL);TREE_ADD_LABEL(_NODE_LABEL);
/// end GETN_CONTROL_FOR_SYMBOL_WELL

//---- CPY 9/13/04 GETN_COMBO_FAILED_WHEN_NOT_VAL_LESS_THEN_ZERO
//#define GETN_COMBO(_NODE_NAME, _NODE_LABEL, _DEFAULT_VAL, _COMBO_STR) _tmpSubNode = _tmpNode.AddNumericNode((int)_DEFAULT_VAL
// change (int) below into (double)
//----
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_STR_COMBO
*/
#define GETN_STR_COMBO(_COMBO_STR) _tmpSubNode.SetAttribute(STR_COMBO_ATTRIB, _COMBO_STR);
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_BEGIN_GROUP
*/
#define GETN_BEGIN_GROUP(_BRANCH_LABEL) {string _strBranchLabel = "1 "; _strBranchLabel+= _BRANCH_LABEL; _tmpSubNode.SetAttribute(STR_GROUP_BRANCH_ATTRIB, _strBranchLabel);}
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_END_GROUP
*/
#define GETN_END_GROUP	  _tmpSubNode.SetAttribute(STR_GROUP_BRANCH_ATTRIB, "0");

// a Combo box, enum list, 0 offset
// Comments last updated by Pinky on 10/09/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_COMBO
*/
#define GETN_COMBO(_NODE_NAME, _NODE_LABEL, _DEFAULT_VAL, _COMBO_STR) _tmpSubNode = _tmpNode.AddNumericNode((double)_DEFAULT_VAL, #_NODE_NAME, TRGP_NUMERIC_LIST); \
TREE_ADD_LABEL(_NODE_LABEL);\
_tmpSubNode.SetAttribute(STR_COMBO_ATTRIB, _COMBO_STR);

// a string, edit box
// Comments last updated by Pinky on 10/09/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_STR
*/
#define GETN_STR(_NODE_NAME, _NODE_LABEL, _DEFAULT_VAL)	_tmpSubNode = _tmpNode.AddTextNode(_DEFAULT_VAL, #_NODE_NAME, TRGP_STR);TREE_ADD_LABEL(_NODE_LABEL);

// a string, list box

/// ML 4/25/2006 EDIT_PROPERTY_PASSWORD
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_PASSWORD
*/
#define GETN_PASSWORD(_NODE_NAME, _NODE_LABEL, _DEFAULT_VAL)		_tmpSubNode = _tmpNode.AddTextNode(_DEFAULT_VAL, #_NODE_NAME, ONODETYPE_EDIT_BOX_PASSWORD);TREE_ADD_LABEL(_NODE_LABEL);
/// end EDIT_PROPERTY_PASSWORD



// Comments last updated by Pinky on 10/09/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_OCNTRL_OPTION
*/
/// EJP 07-27-2004: There is a bug in _NODE_NAME being passed into a GETN_STR after passed into GETN_STRLIST
/// so I have expanded the macro here until it is fixed.
///#define GETN_STRLIST(_NODE_NAME, _NODE_LABEL, _DEFAULT_VAL, _COMBO_STR) GETN_STR(_NODE_NAME, _NODE_LABEL, _DEFAULT_VAL) _tmpSubNode.SetAttribute(STR_COMBO_ATTRIB, _COMBO_STR);
//----- CPY 10/23/2007 QA70-10577 COMBO_STR_STAY_AS_E_INTERNALLY_IN_DYNA_CNTRL
//#define GETN_STRLIST(_NODE_NAME, _NODE_LABEL, _DEFAULT_VAL, _COMBO_STR) _tmpSubNode = _tmpNode.AddTextNode(_DEFAULT_VAL, #_NODE_NAME, TRGP_STR);TREE_ADD_LABEL(_NODE_LABEL); _tmpSubNode.SetAttribute(STR_COMBO_ATTRIB, _COMBO_STR);
#define GETN_OCNTRL_OPTION(_NN)  _tmpSubNode.SetAttribute(STR_OCNTRL_OPTNS ,_NN);
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_STRLIST
*/
#define GETN_STRLIST(_NODE_NAME, _NODE_LABEL, _DEFAULT_VAL, _COMBO_STR)   _tmpSubNode = _tmpNode.AddTextNode(_DEFAULT_VAL, #_NODE_NAME, TRGP_STR);TREE_ADD_LABEL(_NODE_LABEL); _tmpSubNode.SetAttribute(STR_COMBO_ATTRIB, _COMBO_STR); GETN_OCNTRL_OPTION(OCNTRLPARAM1_NOT_LOCALIZED)
/**$
*/
#define GETN_STRLIST_L(_NODE_NAME, _NODE_LABEL, _DEFAULT_VAL, _COMBO_STR) _tmpSubNode = _tmpNode.AddTextNode(_DEFAULT_VAL, #_NODE_NAME, TRGP_STR);TREE_ADD_LABEL(_NODE_LABEL); _tmpSubNode.SetAttribute(STR_COMBO_ATTRIB, _COMBO_STR);
//-----



/// TD 6-18-07 QA80-9933 EDITABLE_COMBO_WITH_BROWSE_BUTTON
#define GETN_BROWSABLE_STRLIST(_NODE_NAME, _NODE_LABEL, _DEFAULT_VAL, _COMBO_STR) _tmpSubNode = _tmpNode.AddTextNode(_DEFAULT_VAL, #_NODE_NAME, ONODETYPE_BROWSECOMBO);TREE_ADD_LABEL(_NODE_LABEL); _tmpSubNode.SetAttribute(STR_COMBO_ATTRIB, _COMBO_STR);
/// end EDITABLE_COMBO_WITH_BROWSE_BUTTON

//--- CPY 11/19/05 QA70-8339 ROC_CURVE_NEEDS_STATE_VALUES
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_STR_GROUP
*/
#define GETN_STR_GROUP(_NODE_NAME, _NODE_LABEL, _DEFAULT_VAL, _COMBO_STR) _tmpSubNode = _tmpNode.AddTextNode(_DEFAULT_VAL, #_NODE_NAME, TRGP_STR_GROUP);\
TREE_ADD_LABEL(_NODE_LABEL); _tmpSubNode.SetAttribute(STR_COMBO_ATTRIB, _COMBO_STR);
//---

/// YuI 7/23/04 v7.5103 QA70-6582 GETN_MULTILINE_TEXT_IMPLEMENTATION

// Comments last updated by Pinky on 10/09/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_MULTILINE_TEXT
*/
#define	GETN_MULTILINE_TEXT(_NODE_NAME, _NODE_LABEL, _DEFAULT_VAL)	_tmpSubNode = _tmpNode.AddTextNode(_DEFAULT_VAL, #_NODE_NAME, TRGP_MULTILINE_TEXT);TREE_ADD_LABEL(_NODE_LABEL);
/// end GETN_MULTILINE_TEXT_IMPLEMENTATION

/// YuI 10/03/04 QA70-4387 GETN_PICTURE_IMPLEMENTATION
// Comments last updated by Frank on 10/15/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_PICTURE
*/
#define	GETN_PICTURE(_NODE_NAME, _NODE_LABEL)				_tmpSubNode = _tmpNode.AddNode(#_NODE_NAME, TRGP_PICTURE);TREE_ADD_LABEL(_NODE_LABEL);		\
																	 _tmpSubNode.strVal = "";
																	
/// end GETN_PICTURE_IMPLEMENTATION

// a numeric, just simple edit box
// Comments last updated by Pinky on 10/09/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_NUM
*/
#define GETN_NUM(_NODE_NAME, _NODE_LABEL, _DEFAULT_VAL) _tmpSubNode = _tmpNode.AddNumericNode(_DEFAULT_VAL, #_NODE_NAME, TRGP_DOUBLE);TREE_ADD_LABEL(_NODE_LABEL);

// a list of str, with numeric offset
// Comments last updated by Iris on 02/06/2006
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_LIST
*/
#define GETN_LIST(_NODE_NAME, _NODE_LABEL, _DEFAULT_VAL, _COMBO_STR)  _tmpSubNode = _tmpNode.AddNumericNode((int)_DEFAULT_VAL, #_NODE_NAME, TRGP_ENUM_LIST); \
TREE_ADD_LABEL(_NODE_LABEL);\
_tmpSubNode.SetAttribute(STR_COMBO_ATTRIB, _COMBO_STR);
/// TD 7-13-06 QA70-8795 LISTBOX_IN_DYNACONTROL
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_LISTBOX
*/
#define GETN_LISTBOX(_NODE_NAME, _NODE_LABEL, _DEFAULT_VAL, _COMBO_STR)  _tmpSubNode = _tmpNode.AddNumericNode((int)_DEFAULT_VAL, #_NODE_NAME, ONODETYPE_LISTBOX); \
TREE_ADD_LABEL(_NODE_LABEL);\
_tmpSubNode.SetAttribute(STR_COMBO_ATTRIB, _COMBO_STR);
///end LISTBOX_IN_DYNACONTROL

/// Hong 04/03/09 QA80-13409 MULTI_SELECT_LISTBOX_IN_DYNACONTROL
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_MULTISEL_LISTBOX
*/
#define GETN_MULTISEL_LISTBOX(_NODE_NAME, _NODE_LABEL, _DEFAULT_VAL, _COMBO_STR)  _tmpSubNode = _tmpNode.AddNode(#_NODE_NAME, ONODETYPE_MULTISEL_LISTBOX); \
_tmpSubNode.nVals = (int)_DEFAULT_VAL;\
TREE_ADD_LABEL(_NODE_LABEL);\
_tmpSubNode.SetAttribute(STR_COMBO_ATTRIB, _COMBO_STR);
/// end MULTI_SELECT_LISTBOX_IN_DYNACONTROL

/// Hong 12/29/10 ORG-1882-S2 STACK_COL_SUPPORT_MULTI_IDENTIFIER
#define GETN_MULTISEL_STR_LISTBOX(_NODE_NAME, _NODE_LABEL, _DEFAULT_VAL, _COMBO_STR)  _tmpSubNode = _tmpNode.AddNode(#_NODE_NAME, ONODETYPE_CTRL_STRING_ARRAY); \
_tmpSubNode.strVals = _DEFAULT_VAL;\
TREE_ADD_LABEL(_NODE_LABEL);\
_tmpSubNode.SetAttribute(STR_COMBO_ATTRIB, _COMBO_STR);
/// end STACK_COL_SUPPORT_MULTI_IDENTIFIER


/// TD 7-13-06 QA70-8795 SEPERATORS_IN_DYNACONTROL
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_SEPARATOR_LINE
*/
#define GETN_SEPARATOR_LINE  {_tmpSubNode = _tmpNode.AddTextNode("", "Separator", ONODETYPE_SEPARATOR);}  
///end SEPERATORS_IN_DYNACONTROL

// Comments last updated by Iris on 02/06/2006
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_RADIO_INDEX
*/
#define GETN_RADIO_INDEX(_NODE_NAME, _DEFAULT_VAL, _COMBO_STR)  _tmpSubNode = _tmpNode.AddNumericNode((int)_DEFAULT_VAL, #_NODE_NAME, ONODETYPE_RADIOS_BY_INDEX); \
_tmpSubNode.SetAttribute(STR_COMBO_ATTRIB, _COMBO_STR);

///Kyle 06/17/2010 ORG-98-S40 NEW_WIDTH_CONTROL_WITHOUT_DROP_DOWN
#define GETN_RADIO_INDEX_EX(_NODE_NAME, _NODE_LABEL, _DEFAULT_VAL, _COMBO_STR)		GETN_RADIO_INDEX(_NODE_NAME, _DEFAULT_VAL, _COMBO_STR)		TREE_ADD_LABEL(_NODE_LABEL);
///End NEW_WIDTH_CONTROL_WITHOUT_DROP_DOWN

// Comments last updated by Iris on 02/06/2006
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_BUTTON_GROUP
*/
#define GETN_BUTTON_GROUP(_NODE_NAME, _NODE_LABEL, _DEFAULT_VAL, _COMBO_STR)  _tmpSubNode = _tmpNode.AddNumericNode((int)_DEFAULT_VAL, #_NODE_NAME, ONODETYPE_PUSHBUTTON_GROUP); \
TREE_ADD_LABEL(_NODE_LABEL);\
_tmpSubNode.SetAttribute(STR_COMBO_ATTRIB, _COMBO_STR);
// a color, pick from a list that is the system palette
// Comments last updated by Pinky on 10/09/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_COLOR
*/
#define GETN_COLOR(_NODE_NAME, _NODE_LABEL, _DEFAULT_VAL) _tmpSubNode = _tmpNode.AddNumericNode(_DEFAULT_VAL, #_NODE_NAME, TRGP_COLOR);TREE_ADD_LABEL(_NODE_LABEL);

///Kyle 07/22/2009 QA80-12339-P1 WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS
#define GETN_FONT(_NODE_NAME, _NODE_LABEL, _DEFAULT_VAL) _tmpSubNode = _tmpNode.AddNumericNode(_DEFAULT_VAL, #_NODE_NAME, ONODETYPE_DROPLIST_FONTS);TREE_ADD_LABEL(_NODE_LABEL);
///End WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS

/// TD 5-30-07 QA80-9845 COLORWELL_OPTIONS_ATTRIBUTE
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_COLOR_CHOICE_OPTIONS
*/
#define GETN_COLOR_CHOICE_OPTIONS(_OPTIONS)						_tmpSubNode.SetAttribute(STR_ATTRIB_COLOROPTIONS, _OPTIONS);
/// end COLORWELL_OPTIONS_ATTRIBUTE
// Comments last updated by Pinky on 10/09/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_INTERACTIVE
*/
#define	GETN_INTERACTIVE(_NODE_NAME, _NODE_LABEL, _DEFAULT_VAL)		_tmpSubNode = _tmpNode.AddTextNode(_DEFAULT_VAL, #_NODE_NAME, TRGP_INTERACTIVE);TREE_ADD_LABEL(_NODE_LABEL);

/*
#define GETN_BEGIN_DATA_RANGE(_NODE_NAME, _NODE_LABEL, _DEFAULT_VAL) 	_tmpSubNode = _tmpNode.AddTextNode(_DEFAULT_VAL, #_NODE_NAME, TRGP_DATA_RANGE);TREE_ADD_LABEL(_NODE_LABEL);\
TreeNode _tmSave_##_NODE_NAME = _tmpNode; _tmpNode = _tmpSubNode;
#define GETN_END_DATA_RANGE(_NODE_NAME)					_tmpNode = _tmSave_##_NODE_NAME;
*/
/**$
	Remarks:
		The macro is used to construct DataRange branch
		
	Parameters:
		_NODE_NAME = [input] node name of the branch
		_NODE_LABEL = [input] label of the branch
		
	Example1:
		void GETN_BEGIN_DATA_RANGE_ex1()
		{
			GETN_BOX(trRoot)
			GETN_CHECK(Save, "Save Settings", false)
			GETN_BEGIN_DATA_RANGE(Input, "Input Data")
			GETN_STR(Range1, "Data1", "[Book1]Sheet1!(D1,F1)")
			GETN_STR(Range2, "Data2", "[Book1]Sheet1!(A,B)")
			GETN_END_DATA_RANGE(Input)
			if ( GetNBox(trRoot) )
				out_tree(trRoot);
			return;
		}
*/
#define GETN_BEGIN_DATA_RANGE(_NODE_NAME, _NODE_LABEL) 	_tmpSubNode = _tmpNode.AddNode(#_NODE_NAME, TRGP_DATA_RANGE);TREE_ADD_LABEL(_NODE_LABEL);\
TreeNode _tmSave_##_NODE_NAME = _tmpNode; _tmpNode = _tmpSubNode;
/**$
	Remarks:
		This macro is used with GETN_BEGIN_DATA_RANGE to construct a data range branch
		
	Parameters:
		_NODE_NAME = [input] node name of the branch
		
	Example1:
		void GETN_BEGIN_DATA_RANGE_ex1()
		{
			GETN_BOX(trRoot)
			GETN_CHECK(Save, "Save Settings", false)
			GETN_BEGIN_DATA_RANGE(Input, "Input Data")
			GETN_STR(Range1, "Data1", "[Book1]Sheet1!(D1,F1)")
			GETN_STR(Range2, "Data2", "[Book1]Sheet1!(A,B)")
			GETN_END_DATA_RANGE(Input)
			if ( GetNBox(trRoot) )
				out_tree(trRoot);
			return;
		}
*/
#define GETN_END_DATA_RANGE(_NODE_NAME)					_tmpNode = _tmSave_##_NODE_NAME;

/// YuI 02/21/06 QA70-8549 NEW_COMPLEX_RANGE_CONTROL
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_XYRANGE
*/
#define	GETN_XYRANGE(_NODE_NAME, _NODE_LABEL, _NUM_DATA, _VALUE)				octree_create_composite_range_node(&_tmpSubNode, &_tmpNode, #_NODE_NAME, _NODE_LABEL, _NUM_DATA, CRT_XYERR, _VALUE);
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_XYZRANGE
*/
#define	GETN_XYZRANGE(_NODE_NAME, _NODE_LABEL, _NUM_DATA, _VALUE)				octree_create_composite_range_node(&_tmpSubNode, &_tmpNode, #_NODE_NAME, _NODE_LABEL, _NUM_DATA, CRT_XYZ, _VALUE);
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_XYRANGE_COMPLEX
*/
#define	GETN_XYRANGE_COMPLEX(_NODE_NAME, _NODE_LABEL, _NUM_DATA, _VALUE)		octree_create_composite_range_node(&_tmpSubNode, &_tmpNode, #_NODE_NAME, _NODE_LABEL, _NUM_DATA, CRT_COMPLEX, _VALUE);
/// end NEW_COMPLEX_RANGE_CONTROL
/**#
	Remarks:
		construct range string with two value.
	Parameters:
		i1 = the begin of the range.
		i2 = the end of the range
	Return:
		the range string
	Example1:
		void range_to_str_ex1()
		{
			string str = range_to_str(1,9);
			out_str(str);
		}		
*/
string range_to_str(int i1, int i2);

/**#
	Remarks:
		separate the range string to range begin and end value
	Parameters:
		lpcszRange = [input] the input range, format as "5-10"
		i1 =[output] the begin of the range.
		i2 =[output] the end of the range
	Return:
		If the input string can separate to range value, return true; else false.
	Example1:
		void str_to_range_ex1()
		{
			int i1,i2;
			string str("5-10");
			str_to_range(str,i1,i2);
			out_int("",i1);
			out_int("",i2);
		}
*/
bool str_to_range(LPCSTR lpcszRange, int& i1, int& i2);

/**#
	Remarks:
		construct a string "min|max|steps"
	Parameters:
		min = the begin of the range.
		max = the end of the range
		nSteps = the step of the range
	Return:
		the range string
	Example1:
		void range_to_str_ex2()
		{
			string str = range_to_str(1,9,2);
			out_str(str);
		}	
*/
string range_to_str(double min, double max, int nSteps);
/**#
		from the string "min|max|steps" to return numeric values
	Parameters:
		lpcszRange = [input] the range string
		min = [output]the begin of the range.
		max = [output]the end of the range
		nSteps = [output]the step of the range
	Return:
		true if success, else false.
	Example2:
		void str_to_range_ex2(double min = 0, double max =20, int nsteps = 2 )
		{
			string str = range_to_str(min, max, nsteps);
			out_str(str);
			
			double a, b;
			int nn;
			if(str_to_range(str, a, b, nn))
				printf("It is from %f to %f and num steps = %d\n", a, b, nn);
		}
*/
bool str_to_range(LPCSTR lpcszRange, double& min, double& max, int& nSteps);

/**#
	Remarks:
		Set the rectiance's position
	Parameters:
		rect = [output] the rect of setting.
		nLeft = the rect's left position.
		nTop = top position
		nRight = right position
		nBottom = bottom position
	Return:
	Keywords:

	Example1:
		int SetRect_ex1()
		{
			RECT rect;
			SetRect( rect, 100, 200, 300, 400 );
			printf("left=%d top=%d right=%d bottom=%d\n", rect.left, rect.top, rect.right, rect.bottom);
			return 1;
		}
*/
void SetRect(RECT& rect, int nLeft, int nTop, int nRight, int nBottom);

/**#
	Remarks:
		To compare two vector.
	Parameters:
		vs1 = [input] the first vector to compare,
		vs2 = [input] the second vector compare.
		bCaseSensitive = compare with case sensitive.
	Return:
		return -2 if totally diff, no way to compare
		return -1 if same
		return 0 offset index of 1st diff string otherwise
	
	Keywords:
	
	Example1:
		void get_changed_ex1()
		{
			int nRet;
			vector<string> vec1 = {"Worksheet", "Matrix", "abc", "def"};
			vector<string> vec2 = {"Worksheet", "MATRIX", "123", "456"};
			nRet = get_changed( vec1, vec2);
			printf("nRet=%d\n", nRet);
		}
*/
int get_changed(const vector<string>& vs1, const vector<string>& vs2, bool bCaseSensitive = true);

/**#
	Remarks:
		to compare two vector are same
	Parameters:
		v1 = [input] the first vector to compare
		v2 = [input] the second vector compared
	Return:
		return true if same; else false
	Keywords:

	Example1:
		void is_same_ex1()
		{
			bool bRet;
			vector<int> vec1 = {1, 2, 3};
			vector<int> vec2 = {1, 2, 3};
			vector<int> vec3 = {2, 3, 1};
	
			bRet = is_same( vec1, vec2 );
			printf("Is the same: %d\n", bRet);
	
			bRet = is_same( vec1, vec3 );
			printf("Is the same: %d\n", bRet);
		}
*/
bool is_same(const vector<int>& v1, const vector<int>& v2);

/**#
	Remarks:
		get all treenode enable state.
	Parameters:
		tr = [input] input tree to get enables state.
		vv = [output] all treenode's enable state.
		nSetEnable =force state to all, if -1 not change; 0,1 will force all child nodes to set Enable to same	
	Return:
	Keywords:
	
	Example1:
		void tree_get_enables_ex1()
		{
			GETN_BOX( treeTest );
			GETN_NUM(decayT3, "Number", 45.6)
			GETN_STR(readOnly, "Testing item: ReadOnly", "Cann't modify")
   			GETN_READ_ONLY
   	
   			vector<int> vecEnables;
   			tree_get_enables( treeTest, vecEnables );
   			printf("Show: %d %d\n", vecEnables[0], vecEnables[1]);
		}
*/
void tree_get_enables(TreeNode& tr, vector<int>& vv, int nSetEnable = -1);

/**#
	Remarks:
		Get all node's show state.
	Parameters:
		tr = [modify] the tree will get all node state , if nSetShow not equal -1, will set the show state.
		vv = [output] all treenode show state.
		nSetShow = to set all now state, -1 if defaule, mean not to set treenode show state;
					0,1 will force all child nodes to set Show to same
	Keywords:
	Return:
	
	Example1:
		void tree_get_shows_ex1()
		{	
			GETN_BOX( treeTest );
			GETN_NUM(decayT3, "Number", 45.6)
			GETN_STR(readOnly, "Testing item: ReadOnly", "Cann't modify")
			treeTest.readOnly.Show = false;
   	
   			vector<int> vecShows;
   			tree_get_shows( treeTest, vecShows );
   			printf("Show: %d %d\n", vecShows[0], vecShows[1]);
		}
		void tree_get_shows_ex2()
		{	
			GETN_BOX( treeTest );
			GETN_NUM(decayT3, "Number", 45.6)
			GETN_STR(readOnly, "Testing item: ReadOnly", "Cann't modify")
			treeTest.readOnly.Show = false;
   	
   			vector<int> vecShows;
   			tree_get_shows( treeTest, vecShows , 1);
   			printf("Show: %d %d\n", vecShows[0], vecShows[1]);
		}
		// All tree node set to show.
*/
void tree_get_shows(TreeNode& tr, vector<int>& vv, int nSetShow = -1);

/**#
	Remarks:
		Check the treenode is numeric
	Parameters:
		trNode = [input] input treenode
	Return:
		If the node is numeric, return true; else false
	Example1:
		void is_node_need_numeric_validation_ex1()
		{
			GETN_BOX( treeTest );
			GETN_COMBO(Order,"Polynomial Order", 2, "|3|4|5|6")
			bool bRet = is_node_need_numeric_validation( treeTest.Order );
			if( bRet )
			{
				out_str("Yes, Order is numeric \n");
			}
			else
			{
				out_str("No, the value isnot numeric\n");
			};
			GETN_COMBO(Order1,"Polynomial Order1", 2, "2|3|4|5|6")
			bRet = is_node_need_numeric_validation( treeTest.Order1 );
			if( bRet )
			{
				out_str("Yes, Order is numeric \n");
			}
			else
			{
				out_str("No, the value is not numeric\n");
			};
			if( GetNBox( treeTest ))
				out_tree( treeTest );
		}
*/
bool is_node_need_numeric_validation(TreeNode& trNode);

///Jasmine 02/29/08 QA80-11043-P2 GETN_BUTTONS_SEPARATELY_ENABLE_DISABLE
/// Last update comments by Iris 07/28/2008
/**$
	Remarks:
		Diable/enable group buttons. 
	Parameters:
		vnBtns = [input] zero-offset indexes of buttons to disable, other buttons will be enable.
		trBtnGroup = [input] the group button TreeNode
	Example1:
		void disable_buttons_in_group_ex1()
		{
		   string strLabel = "some junk";
		   DWORD dwBits = DISPLAY_EDITOR_HORZ | DISPLAY_EDITOR_LEFT;
		   if(!strLabel.IsEmpty())
		       dwBits |= DISPLAY_EDITOR_NEXT_LINE;
		
		   GETN_TREE(tr)
		   
		   GETN_BUTTON_GROUP(myButton, strLabel, 0, "Button1|Button2|The 3rd Button")  GETN_OPTION_EVENT_EX(test_button)
		     GETN_OPTION_DISPLAY_FORMAT(dwBits)
		     
		   if( GetNBox(tr,"Test Check and Button","Test Check...", NULL, NULL) )
		       out_tree( tr );
		}
		
		bool test_button(TreeNode& trGUI, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg)
		{
			if(!(dwCntrl & GETNEVENT_ON_INIT))
			{
				if(trNode.tagName == "myButton")
				{
					printf("button %d is clicked\n", trNode.nVal + 1);
					
					vector<int> vn;
					vn.Add(trNode.nVal);
					
					int nOtherBtn = trNode.nVal + 1;
					if(nOtherBtn >= 3)//there're 3 buttons in group
						nOtherBtn = 0;
					vn.Add(nOtherBtn);
					
					disable_buttons_in_group(vn, trNode);
				}
				return true;
			}
			return false;
		}
*/
void disable_buttons_in_group(const vector<int>& vnBtns, TreeNode& trBtnGroup);
///End GETN_BUTTONS_SEPARATELY_ENABLE_DISABLE

/**#
	Remarks:
		Get the treenode's combo string.
	Parameters:
		trNode = [input] the treenode to get the combo string
		bMakeEmptyIfNotPipeSeparated = true will empty the combo string
	Return:
		return the combo string, if bMakeEmptyIfNotPipeSeparated = true, return empty when not a combo list
	Example:
		void get_node_combo_str_ex1()
		{
			GETN_BOX( treeTest );
			GETN_COMBO(Order,"Polynomial Order", 2, "2|3|4|5|6")
			string strRet = get_node_combo_str( treeTest.Order );
			printf("strRet=%s\n", strRet);
			if( GetNBox( treeTest ))
				out_tree( treeTest );
		}
*/
string get_node_combo_str(TreeNode& trNode, bool bMakeEmptyIfNotPipeSeparated = false);

///Danice GETNTREE_AUTO_LOAD_DEFAULT
/**$
	Remarks:
		This function will first check tr.GetAttribute(STR_THEME_FILE_ATTRIB,strThemeFile) to see if a Theme File(without path) is already defined for the GetN tree.
		If this theme file is defined, then we simply load from this file and exit, otherwise we walk through each branch and see if a default settings file is present by
		ID and if present we load that branch.
	Return:
		return true if load success, default setting is local in \Themes\(NodeID)-Default.ois
	Parameters:
		tr = [modify] the tree need to set the default settings.
*/
bool tree_load_default_setting(TreeNode& tr, bool bCheckSettingBranch = true);
///END GETNTREE_AUTO_LOAD_DEFAULT

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_RANGE
*/
#define GETN_RANGE(_NODE_NAME, _NODE_LABEL, _I0, _IMAX, _I1, _I2) _strTemp = range_to_str(_I1, _I2);_tmpSubNode = _tmpNode.AddTextNode(_strTemp, #_NODE_NAME, TRGP_RANGE);\
TREE_ADD_LABEL(_NODE_LABEL);_strTemp = (_I0);_strTemp+="|" + (_IMAX);_tmpSubNode.SetAttribute(STR_COMBO_ATTRIB, _strTemp);


///----- YuI 01/14/04 v7.5801 QA70-5799 SLIDER_CONTROL_TO_GETNBOX
// Comments last updated by Pinky on 10/09/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_SLIDER
*/
#define	GETN_SLIDER(_NODE_NAME, _NODE_LABEL, _DEFAULT_VAL, _COMBO_STR)	_strTemp = _DEFAULT_VAL; _tmpSubNode = _tmpNode.AddTextNode(_strTemp, #_NODE_NAME, TRGP_SLIDER);TREE_ADD_LABEL(_NODE_LABEL);\
TREE_ADD_LABEL(_NODE_LABEL);_tmpSubNode.SetAttribute(STR_COMBO_ATTRIB, _COMBO_STR);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_SPINNOR_DOUBLE
*/
#define		GETN_SPINNOR_DOUBLE(_NODE_NAME, _NODE_LABEL, _DEFAULT_VAL, _COMBO_STR)	_strTemp = _DEFAULT_VAL; _tmpSubNode = _tmpNode.AddTextNode(_strTemp, #_NODE_NAME, ONODETYPE_EDIT_BOX_FLOAT_SPINOR);TREE_ADD_LABEL(_NODE_LABEL);\
TREE_ADD_LABEL(_NODE_LABEL);_tmpSubNode.SetAttribute(STR_COMBO_ATTRIB, _COMBO_STR);


// Comments last updated by Pinky on 10/10/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_SLIDEREDIT
*/
#define	GETN_SLIDEREDIT(_NODE_NAME, _NODE_LABEL, _DEFAULT_VAL, _COMBO_STR)	_strTemp = _DEFAULT_VAL; _tmpSubNode = _tmpNode.AddTextNode(_strTemp, #_NODE_NAME, TRGP_SLIDEREDIT);TREE_ADD_LABEL(_NODE_LABEL);\
TREE_ADD_LABEL(_NODE_LABEL);_tmpSubNode.SetAttribute(STR_COMBO_ATTRIB, _COMBO_STR);
//------

//---- CPY 4/23/03 OPERATION_CLASS_NEED_TRY_AND_AUTO_UPDATE
#define STR_OPERATION_TRY	"Try"
#define STR_ACTIVE_CURVE	"ActiveCurve"
#define STR_CLASS_NAME		"Class"
//----- CPY 6-30-06 QA70-8792 GETN_RESIZING_FROM_ATTRIBUTE
#define STR_RESIZE_DIALOG	"ResizeDlg" 

// Comments last updated by Pinky on 10/10/2005

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_OPTION_MANUAL_RESIZE
*/
#define GETN_OPTION_MANUAL_RESIZE(_STR)		_tmpNode.SetAttribute(STR_RESIZE_DIALOG, _STR);
//----- end GETN_RESIZING_FROM_ATTRIBUTE

// Comments last updated by Pinky on 10/10/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_OPERATION
*/
#define GETN_OPERATION(_TR_NAME)		GETN_NAMED_TREE(_TR_NAME, GUI) _tmpNode.SetAttribute(STR_OPERATION_TRY, "Try");

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_CURVE_OPERATION
*/
#define GETN_CURVE_OPERATION(_TR_NAME)	GETN_OPERATION(_TR_NAME) _tmpNode.SetAttribute(STR_ACTIVE_CURVE, "Input");
//----


//--- CPY 5/13/03 v7.0584 BUTTON_IN_EDIT_TEXT
// a string in edit box with button to bring up other dialog, like a FilePath dialog

// Comments last updated by Pinky on 10/10/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_BUTTON
*/
#define GETN_BUTTON(_NODE_NAME, _NODE_LABEL, _DEFAULT_VAL) _tmpSubNode = _tmpNode.AddTextNode(_DEFAULT_VAL, #_NODE_NAME, TRGP_STR_BUTTON); \
TREE_ADD_LABEL(_NODE_LABEL);\
_tmpSubNode.SetAttribute(STR_COMBO_ATTRIB, "...");
//--- end CPY 5/13/03 v7.0584 BUTTON_IN_EDIT_TEXT


/// TD 01-14-2009 QA80-12869 COMBO_AND_EDIT_WITH_BUTTON_USING_USER_EVENTS
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_COMBO_BUTTON
*/
#define GETN_COMBO_BUTTON(_NODE_NAME, _BUTTON_NAME, _NODE_LABEL, _BUTTON_MODE, _COMBO_STR, _DEFAULT_VAL)  _tmpSubNode = _tmpNode.AddTextNode(_DEFAULT_VAL, #_NODE_NAME, ONODETYPE_BROWSECOMBO);\
TREE_ADD_LABEL(_NODE_LABEL); {string str=_BUTTON_NAME + ".."+ _BUTTON_MODE + "|:|" +_COMBO_STR;_tmpSubNode.SetAttribute(STR_COMBO_ATTRIB, str);}
/// end COMBO_AND_EDIT_WITH_BUTTON_USING_USER_EVENTS

///------ Folger 10/27/2010 ORG-27 NEW_DIGITIZER_GADGET
#define GETN_COMBO_AS_EDIT			_tmpSubNode.SetAttribute(STR_OCNTRL_OPTNS, OCNTRLPARAM1_SHOW_COMBO_AS_EDIT);
///------ End NEW_DIGITIZER_GADGET

//------- CPY 5/15/03 v7.0585 QA70-4477 TREE_BRANCH_SUPPORT
//_tmSaveNode added in GETN_NAMED_TREE as well

// Comments last updated by Pinky on 10/10/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_BEGIN_BRANCH
*/
#define GETN_BEGIN_BRANCH(_NODE_NAME, _NODE_LABEL) 	_tmpSubNode = _tmpNode.AddNode(#_NODE_NAME, TRGP_BRANCH);TREE_ADD_LABEL(_NODE_LABEL);\
TreeNode _tmSave_##_NODE_NAME = _tmpNode; _tmpNode = _tmpSubNode;
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_END_BRANCH
*/
#define GETN_END_BRANCH(_NODE_NAME)					_tmpNode = _tmSave_##_NODE_NAME;
//------- end TREE_BRANCH_SUPPORT

/// Iris 7/04/2012 ORG-6033-P1 TO_PREVENT_GETN_AUTO_SAVE_BRANCH_OPEN_STATUS_TO_REG
#define GETN_AUTO_SAVE_BRANCH_OPEN(_DWOPTN)			DWORD _DWOLD = 0; string _strOld; if( _tmpNode.GetAttribute(STR_DLG_DISPLAY_ATTRIB, _strOld) ) _DWOLD = (DWORD)atoi(_strOld);\	
	if( _DWOPTN ) { O_ADD_BIT(_DWOLD, GETN_DISPLAY_AUTO_SAVE_BRANCH_OPEN); } else { O_REMOVE_BIT(_DWOLD, GETN_DISPLAY_AUTO_SAVE_BRANCH_OPEN); }\	
	_strTemp = _DWOLD; _tmpNode.SetAttribute(STR_DLG_DISPLAY_ATTRIB, _strTemp);
///End TO_PREVENT_GETN_AUTO_SAVE_BRANCH_OPEN_STATUS_TO_REG

//----- CPY 5/17/03 ALLOW_GETN_TREE_PASSED_INTO_FUNCTION
// Comments last updated by Pinky on 10/10/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_USE
*/
#define GETN_USE(_TR_NAME)	TreeNode _tmpNode = _TR_NAME; TreeNode _tmpSubNode; string _strTemp;

/// Hong 01/17/08 v8.0787b MORE_CONVENIENT_WAY_FOR_XF_EDIT_VARIABLE
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_USE_CURR
*/
#define GETN_USE_CURR(_TR_NAME)	TreeNode _tmpNode = _TR_NAME; TreeNode _tmpSubNode = _TR_NAME; string _strTemp;
/// end MORE_CONVENIENT_WAY_FOR_XF_EDIT_VARIABLE

// Comments last updated by Frank on 10/15/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_BEGIN_USE_BRANCH
*/
#define GETN_BEGIN_USE_BRANCH(_NODE_NAME) _tmpSubNode = _tmpNode.GetNode(#_NODE_NAME);TreeNode _tmSaveUse_##_NODE_NAME = _tmpNode; _tmpNode = _tmpSubNode;
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_END_USE_BRANCH
*/
#define GETN_END_USE_BRANCH(_NODE_NAME)	_tmpNode = _tmSaveUse_##_NODE_NAME;
//-----	
/// TD 3-9-06 QA70-8490 WRAPPED_CONTROLS_JUSTIFICATION
#ifndef _OC_CONST_H
/// end WRAPPED_CONTROLS_JUSTIFICATION
//---- CPY 8/24/03 v7.5674 QA70-5061 ADD_DISPLAY_OPTIONS
/// ML 4/18/2005 XFUNCTION_TREE_MANIPULATION_IN_VC
//#define STR_ATTRIB_BRANCH			"Branch"
/// end XFUNCTION_TREE_MANIPULATION_IN_VC
#define STR_ATTRIB_VERT_GRID_LINES	"GridLines"
#define STR_ATTRIB_LABEL_COLOR		"LabelColor"
#define STR_ATTRIB_BKGRND_COLOR		"BkGrndColor"
#define STR_ATTRIB_TREE_ROW_COLOR	"RowColor"	///Danice 11/15/04 QA70-7169 TREE_ROW_SHOW_ALTERNATE_COLORS
#define STR_ATTRIB_TREE_INDICATOR_COLOR	"IndicatorColor"	///Danice 11/16/04 QA70-7169 MARK_EMPTY_GETN_STR
/// ML 4/18/2005 XFUNCTION_TREE_MANIPULATION_IN_VC
//#define STR_ATTRIB_HANDLER			"Handler"
/// end XFUNCTION_TREE_MANIPULATION_IN_VC
#define STR_ATTRIB_DISPFMT			"DispFormat" //CPY v7.5763 QA70-5162 11/18/03 GETNBOX_JUSTIFICATION_AND_ENABLE_EDIT ///Frank 10/16/05 COMMENT_NOT_USE_MARCO
#define STR_ATTRIB_EDIT				"Edit" //CPY 6/11/04 GETN_SAVE_SETTINGS_ONLY_LOAD_DEFAULT_IF_NEW
#define STR_ATTRIB_EDITCOL_ALIGN	"EditCol"
#define STR_ATTRIB_MAX_HEIGHT_WIDTH	"HeightWidth"	///DG SUPPORT_MAX_HEIGHT_WIDTH_SETTING
//#define STR_ATTRIB_MULTILINE_EDIT_DISPLAY_ROW_HEIGHT_RANGE		"RowHeightRange" //Frank v78.0 11/14/04 GETNBOX_JUSTIFICATION_AND_ENABLE_EDIT ///Frank 12/21/04 move to oc_const.h
/// TD 3-9-06 QA70-8490 WRAPPED_CONTROLS_JUSTIFICATION
#endif// _OC_CONST_H
/// end WRAPPED_CONTROLS_JUSTIFICATION

// _VGLTYPE can be one of
#ifndef _VSFLEXGRID_H
	#define	flexGridFlatVert	8
	#define	flexGridInsetVert	9
	#define flexGridRaisedVert	10
#endif //_VSFLEXGRID_H

// Comments last updated by Pinky on 10/10/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_OPTION_GRIDLINE
*/
#define GETN_OPTION_GRIDLINE(_VGLTYPE)		_strTemp = _VGLTYPE; _tmpNode.SetAttribute(STR_ATTRIB_VERT_GRID_LINES, _strTemp);

// Comments last updated by Pinky on 10/10/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_OPTION_EDIT_ALIGN
*/
#define GETN_OPTION_EDIT_ALIGN(_STR)		_strTemp = _STR; _tmpNode.SetAttribute(STR_ATTRIB_EDITCOL_ALIGN, _strTemp);


// Comments last updated by Pinky on 10/10/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_OPTION_BRANCH
*/
#define GETN_OPTION_BRANCH(_DWOPTN)			_strTemp = _DWOPTN; _tmpNode.SetAttribute(STR_ATTRIB_BRANCH, _strTemp);
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_OPTION_GROUP_BRANCH
*/
#define GETN_OPTION_GROUP_BRANCH(_DWOPTN)	_strTemp = _DWOPTN; _tmpSubNode.SetAttribute(STR_ATTRIB_BRANCH, _strTemp);
// can use RGB(r,g,b) or predefined COLOR_RED, COLOR_BLACK, COLOR_BLUE, COLOR_GREEN, COLOR_LTBLUE, COLOR_LTGREEN

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_CHECKBOX_BRANCH
*/
#define GETN_CHECKBOX_BRANCH(_CHK)	_tmpNode.Use = _CHK;
/// TD 3-1-06 QA70-8490 BRANCH_CHECK_BOX_ON_RIGHT
//#define STR_ATTRIB_BRANCH_COMBO	"BranchCombo"
/// end BRANCH_CHECK_BOX_ON_RIGHT

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_COMBO_BRANCH
*/
#define GETN_COMBO_BRANCH(_NN, _STR_COMBO) _tmpNode.Use = _NN; _tmpNode.SetAttribute(STR_ATTRIB_BRANCH_COMBO, _STR_COMBO);


/// YuI 09/22/05 MATRIX_GETN_CONTROL
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_BUTTON_BRANCH
*/
#define	GETN_BUTTON_BRANCH		_tmpNode.SetAttribute(STR_ATTRIB_BRANCH_COMBO, "...");_tmpNode.Use=1;
/// end MATRIX_GETN_CONTROL

// Comments last updated by Pinky on 10/10/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_OPTION_COLOR_LABEL
*/
#define GETN_OPTION_COLOR_LABEL(_RGB)		_strTemp = _RGB;_tmpSubNode.SetAttribute(STR_ATTRIB_LABEL_COLOR, _strTemp);

// Comments last updated by Pinky on 10/10/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_OPTION_COLOR_BACKGROUND
*/
#define GETN_OPTION_COLOR_BACKGROUND(_RGB)		_strTemp = _RGB;_tmpSubNode.SetAttribute(STR_ATTRIB_BKGRND_COLOR, _strTemp);

// Comments last updated by Pinky on 10/10/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_OPTION_EVENT
*/
#define GETN_OPTION_EVENT(_PFN)	{PEVENT_FUNC __dfn = _PFN;ODWP _dw_fn = (ODWP)__dfn;\
if(_dw_fn) {_strTemp = _dw_fn;_tmpSubNode.SetAttribute(STR_ATTRIB_HANDLER, _strTemp);}}	

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_OPTION_EVENT_EX
*/
#define GETN_OPTION_EVENT_EX(_PFN)	{PEVENT_NODE_FUNC __dfn = _PFN;ODWP _dw_fn = (ODWP)__dfn;\
if(_dw_fn) {_strTemp = _dw_fn;_tmpSubNode.SetAttribute(STR_ATTRIB_HANDLER_RC, _strTemp);}}	

/// ML 2/14/2007 QA70-9374 BAD_EVENT_HANDLER_DWORDS_IN_TREENODES
////----- CPY 11/20/05 ROC_CURVE_NEED_INPUT_DATA_CHANGE_EVENT
//#define GETN_SET_EVENT_EX_HANDLER(_TR, _PFN) {PEVENT_NODE_FUNC __dfn = _PFN;DWORD _dw_fn = (DWORD)__dfn;\
//if(_dw_fn) {string _strTemp1 = _dw_fn;_TR.SetAttribute(STR_ATTRIB_HANDLER_RC, _strTemp1);}}
////-----
/**$
	Remarks:
		This macro is used to set treenode event handler.
	Parameters:
		_TR = [input/modified] the node to set event handler.
		_PFN = [input] event handler.
		_lpcszAtt = [input] attribute where keep the event handler's address
					currently only STR_ATTRIB_HANDLER_RC available
	Example1:
		bool node_event(TreeNode& myTree, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg)
		{
			printf("row = %d, col=%d, cntrl=%X, type = %d\n", nRow, nCol, dwCntrl, nType);
			return true;
		}
		
		void GETN_SET_EVENT_EX_HANDLER_ATT_ex1()
		{
			GETN_TREE(trRoot)
			GETN_STR(STR, "Event", "Click me") //change the text will invoke event handler
			GETN_SET_EVENT_EX_HANDLER_ATT(trRoot.STR, node_event, STR_ATTRIB_HANDLER_RC)
			if ( GetNBox(trRoot) )
				out_tree(trRoot);
			return;
		}
*/
#define	GETN_SET_EVENT_EX_HANDLER_ATT(_TR, _PFN, _lpcszAtt)	{PEVENT_NODE_FUNC __dfn = _PFN;ODWP _dw_fn = (ODWP)__dfn;\
if(_dw_fn) {string _strTemp1 = _dw_fn;_TR.SetAttribute(_lpcszAtt, _strTemp1);}}

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_SET_EVENT_EX_HANDLER
*/
#define GETN_SET_EVENT_EX_HANDLER(_TR, _PFN)	GETN_SET_EVENT_EX_HANDLER_ATT(_TR, _PFN, STR_ATTRIB_HANDLER_RC)
/**$
*/
#define GETN_SET_EVENT_EX_HANDLER_G(_TR, _PFN)	GETN_SET_EVENT_EX_HANDLER_ATT(_TR, _PFN, STR_ATTRIB_HANDLER)
	
/// end BAD_EVENT_HANDLER_DWORDS_IN_TREENODES

///Arvin 05/23/07 v8.0624 ADD_MACRO_TO_SET_EVENT_HANDLER_TO_THE_NODE_AND_ALL_ITS_CHILDREN as Yuri's suggestion
/**$
*/
#define GETN_SET_EVENT_EX_HANDLER_TO_ALL_NODES(_TR, _PFN) {PEVENT_NODE_FUNC __dfn = _PFN;ODWP _dw_fn = (ODWP)__dfn;\
if(_dw_fn) {string _strTemp1 = _dw_fn; octree_set_attribute_to_all_nodes(&_TR, STR_ATTRIB_HANDLER_RC, _strTemp1)}}
///END ADD_MACRO_TO_SET_EVENT_HANDLER_TO_THE_NODE_AND_ALL_ITS_CHILDREN
// Comments last updated by Pinky on 10/10/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_OPTION_NUM_FORMAT
*/
//------- CPY 12/31/2007 QA70-10868 NUM_EDIT_FORMAT_CONTROL
//#define GETN_OPTION_NUM_FORMAT(_STRFMT)	_tmpNode.SetAttribute(STR_ATTRIB_NUMFMT, _STRFMT); //CPY v7.5723 QA70-5376 GETNBOX_ADD_SIG_DIGITS_SUPPORT
#define GETN_OPTION_NUM_FORMAT(_STRFMT)	_tmpSubNode.SetAttribute(STR_ATTRIB_NUMFMT, _STRFMT);
//-------
//---- end QA70-5061 ADD_DISPLAY_OPTIONS

//--- CPY 4/25/04 NODE_ID_FOR_GETN
//#define GETN_ID_BRANCH(_ID) _strTemp = _ID; _tmpNode.SetAttribute(STR_DATAID_ATTRIB,_strTemp);
//#define GETN_ID(_ID) _strTemp = _ID; _tmpSubNode.SetAttribute(STR_DATAID_ATTRIB,_strTemp);
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_ID_BRANCH
*/
#define GETN_ID_BRANCH(_ID) _tmpNode.DataID = _ID;
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_ID
*/
#define GETN_ID(_ID) 		_tmpSubNode.DataID = _ID;
//---

//---- CPY 3/1/05 QA70-7455 REPEAT_BRANCH_FOR_XF_VARIABLES
///Iris 03/02/05 QA70-7455
//#define GETN_ID_REPEAT_BRANCH(_NN)	_tmpNode.DataID = REPEAT_BRANCH_ID(_NN);	
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_ID_REPEAT_BRANCH
*/
#define GETN_ID_REPEAT_BRANCH(_NN)	_tmpNode.SetAttribute(STR_REPEAT_ID_ATTRIB ,_NN);	
//----

///--	Frank 09/13/04		MOVE_GETNBOX_JUSTIFICATION_TO_OC_CONST	
//----- CPY v7.5763 QA70-5162 11/18/03 GETNBOX_JUSTIFICATION_AND_ENABLE_EDIT
//enum {DISPLAY_LEFT, DISPLAY_CENTER, DISPLAY_RIGHT};
///--End	MOVE_GETNBOX_JUSTIFICATION_TO_OC_CONST	
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_OPTION_DISPLAY_FORMAT
*/
#define GETN_OPTION_DISPLAY_FORMAT(_DISPFMT)	_strTemp = _DISPFMT;_tmpSubNode.SetAttribute(STR_ATTRIB_DISPFMT, _strTemp);

//----- CPY TD 5/3/07 QA70-9714 WIDER_CONTROL
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_MUTILINE_EDIT_ROLLUP_BUTTON
*/
#define GETN_MUTILINE_EDIT_ROLLUP_BUTTON	_tmpSubNode.SetAttribute(STR_MULTI_EDT_EXPSHR_ATTRIB, 1);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_OPTION_MUTILINE_TEXT_BOX
*/
//_RANGE = "2-15" means 2 line when collapsed and 15 when expended
#define GETN_OPTION_MUTILINE_TEXT_BOX(_bREADONLY, _RANGE, _FIXED_FONT) \
_tmpSubNode.SetAttribute(STR_MULTI_EDT_EXPSHR_ATTRIB, 1); \
if(_bREADONLY) _tmpSubNode.Enable = ENABLE_READONLY_SCROLL; \
if(_FIXED_FONT)_tmpSubNode.SetAttribute(STR_ATTRIB_DISPFMT, DISPLAY_EDITOR_WRAPPED|DISPLAY_EDITOR_FIXED_FONT);\
else _tmpSubNode.SetAttribute(STR_ATTRIB_DISPFMT, DISPLAY_EDITOR_WRAPPED); \
_tmpSubNode.SetAttribute(STR_ATTRIB_MULTILINE_EDIT_DISPLAY_ROW_HEIGHT_RANGE, _RANGE);
//-----

// Comments last updated by Pinky on 10/10/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_READ_ONLY
*/
#define GETN_READ_ONLY							_tmpSubNode.Enable = false;
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_READ_ONLY_EX
*/
#define GETN_READ_ONLY_EX(_MODE)				_tmpSubNode.Enable = _MODE;
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_READ_ONLY_COLOR
*/
#define GETN_READ_ONLY_COLOR					GETN_READ_ONLY_EX(ENABLE_READ_ONLY)
/// TD 12-30-2008 QA80-12883 ALWAYS_EXPANDED_BRANCH_IN_DYNACONTROL
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:SET_BRANCH_CTRL_ATTRIBUTES
*/
#define SET_BRANCH_CTRL_ATTRIBUTES(_ATTRIB)		_tmpNode.SetAttribute(STR_BRANCH_CTRL_ATTRIBUTES, _ATTRIB);
/// end ALWAYS_EXPANDED_BRANCH_IN_DYNACONTROL

/// TD ML 01-18-2010 QA70-14900 WANTED_GROUPBOX_BRANCH_IN_DYNACONTROL
#define SET_PSEUDO_BRANCH_CTRL_ATTRIBUTES(_ATTRIB)		_tmpSubNode.SetAttribute(STR_BRANCH_CTRL_ATTRIBUTES, _ATTRIB);

#define SET_BRANCH_AS_GROUP_BOX(_GROUP_LABEL)			_tmpSubNode.SetAttribute(STR_BRANCH_GROUPBOX_ATTRIBUTES, _GROUP_LABEL);
/// end WANTED_GROUPBOX_BRANCH_IN_DYNACONTROL


/// TD 11-06-06 COLOR_CHOICE_FOR_READONLY
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_OPTION_COLOR_READONLY
*/
#define GETN_OPTION_COLOR_READONLY(_RGB)			_strTemp = _RGB;_tmpSubNode.SetAttribute(STR_ATTRIB_COLOR_READONLY_TEXT, _strTemp);
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_OPTION_COLOR_READONLY_BRANCH
*/
#define GETN_OPTION_COLOR_READONLY_BRANCH(_RGB)		_strTemp = _RGB;_tmpNode.SetAttribute(STR_ATTRIB_COLOR_READONLY_TEXT, _strTemp);
/// COLOR_CHOICE_FOR_READONLY

/// TD 7-20-07 QA80-10087  ABILITY_TO_TAB_DYNACONTROL_ROWS
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_ADDITIONAL_TAB
*/
#define GETN_ADDITIONAL_TAB(_NTAB)		_strTemp = _NTAB;_tmpSubNode.SetAttribute(STR_ATTRIB_ADDITIONAL_TAB, _strTemp);
/// end ABILITY_TO_TAB_DYNACONTROL_ROWS

/// TD 11-15-06 QA70-9127 DYNACONTROL_USE_CHECK
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_CONTROL_OPTION_BOX
*/
#define GETN_CONTROL_OPTION_BOX(BDEFAULT)			_tmpSubNode.SetAttribute(STR_ATTRIB_DYNACONTROL_USE_CHECK, BDEFAULT);
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_BRANCH_OPTION_BOX
*/
#define GETN_BRANCH_OPTION_BOX(BDEFAULT)			_tmpNode.SetAttribute(STR_ATTRIB_DYNACONTROL_USE_CHECK, BDEFAULT);
/// end DYNACONTROL_USE_CHECK

// two attributes to indicate a static control for info display
// GETN_READ_ONLY_COLOR --> tr.Enable = 2 to indicate disable (static) and color text blue
// GETN_OPTION_DISPLAY_FORMAT(DISPLAY_EDITOR_LEFT) --> DispFormat attribute = DWORD, DISPLAY_EDITOR_LEFT indicate not to show the tagName part at all
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_INFO
*/
#define GETN_INFO GETN_READ_ONLY_COLOR GETN_OPTION_DISPLAY_FORMAT(DISPLAY_EDITOR_LEFT)

///---Sim 04-22-2008 QA80-11371 THEME_SAVING_OPTIONS_HINT
///------ Folger 05/18/10 ORG-143 LT_GETN_HINT_TEXT_SUPPORT
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_HINT_EX
*/
#define GETN_HINT_EX(_bWrappedText, _bBold)	GETN_READ_ONLY_COLOR GETN_OPTION_DISPLAY_FORMAT(DISPLAY_EDITOR_USE_LABEL | (_bBold ? DISPLAY_EDITOR_BOLD_FONT : 0) | (_bWrappedText ? DISPLAY_EDITOR_NEXT_LINE | DISPLAY_EDITOR_WRAPPED : 0))
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_HINT
*/
#define GETN_HINT							GETN_HINT_EX(TRUE, TRUE)
///------ End LT_GETN_HINT_TEXT_SUPPORT
///---END QA80-11371 THEME_SAVING_OPTIONS_HINT			


//----- end GETNBOX_JUSTIFICATION_AND_ENABLE_EDIT
///Frank v78.0 11/14/04 CHECK_GETNBOX_ROW_HEIGHT_ATTRIBUTE	
//Comment last updated by Joseph 07/30/07
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_MULTILINE_EDIT_DISPLAY_ROW_HEIGHT_RANGE
*/
#define GETN_MULTILINE_EDIT_DISPLAY_ROW_HEIGHT_RANGE(_DISPFMT)	_strTemp = _DISPFMT;_tmpSubNode.SetAttribute(STR_ATTRIB_MULTILINE_EDIT_DISPLAY_ROW_HEIGHT_RANGE, _strTemp);
/// TD 7-5-06 QA70-8792 DYNACONTROL_MIN_MAX_CTRL
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_EDIT_DISPLAY_WIDTH_RANGE
*/
#define GETN_EDIT_DISPLAY_WIDTH_RANGE(_DISPFMT)	_strTemp = _DISPFMT;_tmpSubNode.SetAttribute(STR_ATTRIB_EDIT_DISPLAY_WIDTH_RANGE, _strTemp);
/// end DYNACONTROL_MIN_MAX_CTRL
// SET_EDITBOX_RESIZABLE add a small 2 state button at the lower right corner of the editbox. This button can the shrink/expan the box. 
// _STATE =  0, will intialize the button to shrink the box, non -zero will expand. 
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:SET_EDITBOX_RESIZABLE
*/
#define SET_EDITBOX_RESIZABLE(_STATE)            _tmpSubNode.SetAttribute(STR_MULTI_EDT_EXPSHR_ATTRIB, _STATE);

///End

///DG SUPPORT_MAX_HEIGHT_WIDTH_SETTING
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_MAX_HEIGHT_WIDTH
*/
#define GETN_MAX_HEIGHT_WIDTH(_STRMAXHW)	_strTemp=_STRMAXHW;_tmpNode.SetAttribute(STR_ATTRIB_MAX_HEIGHT_WIDTH, _strTemp);
///end SUPPORT_MAX_HEIGHT_WIDTH_SETTING

/// Hong 03/19/08 8.0827 NLFIT_REMOVE_SETTINGS_ALLREADY_IN_FDF_FILE_FROM_THEME
/**$
*/
#define GETN_OPTION_THEME_APPLICAPABILITY(_OPTIONS)		_tmpSubNode.SetAttribute(STR_XVARIABLE_THEME_APPLICABILITY_ATTRIB, _OPTIONS);
/**$
*/
#define GETN_BRANCH_THEME_APPLICAPABILITY(_OPTIONS)		_tmpNode.SetAttribute(STR_XVARIABLE_THEME_APPLICABILITY_ATTRIB, _OPTIONS);
/// end NLFIT_REMOVE_SETTINGS_ALLREADY_IN_FDF_FILE_FROM_THEME

///---Sim 06-08-2009 CENTRALIZE_GETN_DLG_HELP_ID
/**$
*/
#define GETN_HELPID(_ID) _tmpNode.SetAttribute(STR_HELPID_ATTRIB, _ID);
///---END CENTRALIZE_GETN_DLG_HELP_ID

///Kenny 06/16/2009 QA81-13796 SUPPORT_SETTING_DYNABOX_CTRL_BITS
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_DLG_OPTIONS
*/
#define GETN_DLG_OPTIONS(_OPTIONS)	_tmpNode.SetAttribute(STR_XF_BITS, _OPTIONS);
///End SUPPORT_SETTING_DYNABOX_CTRL_BITS

///---Sim 11-18-2009 QA81-14641 DYNA_CTRL_SUPPORT_DATE_TIME_PICKER
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_DATE
*/
#define GETN_DATE(_NODE_NAME, _NODE_LABEL, _DEFAULT_VAL) _tmpSubNode = _tmpNode.AddNumericNode(_DEFAULT_VAL, #_NODE_NAME, TRGP_DATE);TREE_ADD_LABEL(_NODE_LABEL);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_TIME
*/
#define GETN_TIME(_NODE_NAME, _NODE_LABEL, _DEFAULT_VAL) _tmpSubNode = _tmpNode.AddNumericNode(_DEFAULT_VAL, #_NODE_NAME, TRGP_TIME);TREE_ADD_LABEL(_NODE_LABEL);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_DATETIME_CUSTOM_FORMAT
*/
#define GETN_DATETIME_CUSTOM_FORMAT(_STRFMT) _tmpSubNode.SetAttribute(STR_ATTRIB_DATE_TIME_CUSTOM_FORMAT, _STRFMT);
///---END QA81-14641 DYNA_CTRL_SUPPORT_DATE_TIME_PICKER

///------ Folger 06/01/10 ORG-120 DATA_DISPLAY_DIALOG_IMPROVEMENT
#define	GETN_OPTION_INTERACTIVE_CONTROL(_DW)		_tmpSubNode.SetAttribute(STR_INTERACTIVE_CONTROL_OPTIONS_ATTRIB, _DW);
#define GETN_OPTION_BROWSE_BOOK_SHEET(_STR)			_tmpSubNode.SetAttribute(STR_BROWSE_BOOK_SHEET_ATTRIB, _STR);
///------ End DATA_DISPLAY_DIALOG_IMPROVEMENT

///------ Folger 10/28/2010 ORG-27 NEW_DIGITIZER_GADGET
#define	GETN_CUSTOM_BUTTON(_STR)					_tmpNode.SetAttribute(STR_CUSTOM_BUTTONS_ATTRIB, _STR);
///------ End NEW_DIGITIZER_GADGET

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:PAPPLY_FUNC
*/
typedef bool (* PAPPLY_FUNC)(TreeNode& tr);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:PEVENT_FUNC
*/
typedef bool (* PEVENT_FUNC)(TreeNode& tr, int nRow, int nCntrlType, Dialog& getNDlg); //CPY 5/30/03 added getNDlg

///---Sim 03-28-2007 ADDITIONAL_GETN_EVENT
#define GETNE_NOT_ACTION_MIN	-30
#define GETNE_NOT_ACTION_MAX	-10
#define IS_NO_ACTION_GETN_EVENT(_EVENTID) (GETNE_NOT_ACTION_MIN <= (_EVENTID) && (_EVENTID) <= GETNE_NOT_ACTION_MAX)
///---END ADDITIONAL_GETN_EVENT

//------- CPY 5/16/07 QA70-9659 GLOBAL_EVENTS_ALSO_NEED_ERR_MSG_TAG_NAME
#define STR_EVENT_TAG_INIT "<init>"
//-------
//------ CPY 7/3/06 QA70-8798 DYNABOX_BETTER_EVENTS
// nEvent < 0 if special events
// nEvent > 0 on change from individul control from nRow with cntrl Type in nEvent
enum {
	GETNE_ON_INIT = -100, //CPY 3/5/07 GETNN_ON_CHANGED_TO_SMALLER_NEGATIVE changed to -100 from -10 per Zach's suggestion
	GETNE_ON_THEME,  /// CPY Iris 7/20/06 v8.0447 SEPRATE_INIT_AND_THEME_EVENT
	GETNE_ON_OK,
	GETNE_ON_APPLY,
	///Joseph Add new Event
	GETNE_ON_PREVIOUS,
	GETNE_ON_NEXT,
	GETNE_ON_FINISH,
	GETNE_ON_DESTORY,
	GETNE_ON_CLOSE,
	///End Add new Event
	GETNE_ON_GRAPH_OBJECT_CHANGE,	/// Iris 12/28/2006 v8.0533 CALL_EVENT1_ON_GRAPH_OBJ_MOVING
	GETNE_ON_VALUE_CHANGE,   ///Joseph 01/29/07	ADD_OPERATION_ERRMSG_LINE
	///Joseph 02/05/07 DYNABOX_DLG_NEED_MORE_BTNS
	GETNE_ON_CUSTOM_BUTTON1,
	GETNE_ON_CUSTOM_BUTTON2,
	GETNE_ON_CUSTOM_BUTTON3,
	GETNE_ON_CUSTOM_BUTTON4,
	///End DYNABOX_DLG_NEED_MORE_BTNS
	GETNE_ON_UNDO,	///Joseph 03/05/07 XF_UNDO_EVENT_SUPPORT
	///---Sim 03-28-2007 ADDITIONAL_GETN_EVENT
	GETNE_ON_INIT_XFWIZ,
	GETNE_ON_RESTORE, ///Sim 03-30-2007 for multi xfunctions on XFBar
	GETNE_ON_EXTERNAL_MSG, ///---Sim 06-29-2007 SUPPORT_SENT_MESSAGE_FROM_EXTERNAL_WINDOW
	GETNE_GET_NEXT = GETNE_NOT_ACTION_MIN,
	GETNE_GET_WIZARD_PATH_UPDATE, ///---Sim 11-01-2007 NOTIFY_XF_WIZ_UPDATE_PATH
	///---END ADDITIONAL_GETN_EVENT
};
// return true to cause DynaControl to update
// bOKEnable = true when enter event, can set to false to disable OK/Apply buttons
// strAux added CPY 10/10/06 QA70-9039 XF_WIZARD_BAR
// strErrMsg added CPY 10/26/06 QA70-9063 DYNAMIC_ERR_MSG_IN_GETN_DIALOGS
#ifndef _CONTROL_H
///Joseph 01/29/07 GETN_BOX_ADD_APPLY_BUTTON
//typedef bool (* PEVENT_GETN)(TreeNode& tr, int nRow, int nEvent, bool& bOKEnable, LPCSTR lpcszNodeName, WndContainer& getNContainer, string& strAux, string& strErrMsg);
//typedef int (* PEVENT_GETN)(TreeNode& tr, int nRow, int nEvent, bool& bOKEnable, LPCSTR lpcszNodeName, WndContainer& getNContainer, string& strAux, string& strErrMsg);
typedef int (* PEVENT_GETN)(TreeNode& tr, int nRow, int nEvent, DWORD& dwEnables, LPCSTR lpcszNodeName, WndContainer& getNContainer, string& strAux, string& strErrMsg);
///End GETN_BOX_ADD_APPLY_BUTTON
#endif
//------
///-----Joseph 01/29/07 GETN_BOX_ADD_APPLY_BUTTON
// continue to return true(1) false(0) but allow other values:
//add more event on return
#define	PEVENT_GETN_RET_TO_CLOSE  2
//------
/// TD 2-14-06 QA70-8490 GETN_EVENTS_IN_TREE_DLG
// moved to OC_Const.h
// follow bits are defined for nEventInfo
//enum {
//	GETNEVENT_VIEW_LIST 			= 0x0001,	// in grid-list view mode, if not set, then in Tree view mode
//	///DG VIEW_GRAPH_GETNBOX
//	GETNEVENT_UPDATE_GRAPH			= 0x0002,
//	GETNEVENT_UPDATE_PREVIEW		= 0x0004,
//	GETNEVENT_UPDATE_GUI_TREE		= 0x0008,
//	///end VIEW_GRAPH_GETNBOX
//	GETNEVENT_ON_INIT 				=   0x4000,	// to indicate event is called during initialization, if not set, then event is triggered on change
//};
/// end GETN_EVENTS_IN_TREE_DLG
///DG 6/21/05 VIEW_GRAPH_GETNBOX
#define WM_USER_GETNGRAPH_CHANGED_BY_GRAPH	(WM_USER + 1002)
///end VIEW_GRAPH_GETNBOX

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:PEVENT_NODE_FUNC
*/
typedef bool (* PEVENT_NODE_FUNC)(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD nEventInfo, int nCntrlType, WndContainer& getNContainer); //CPY 5/19/05 GETN_NODE_EVENT_ROW_COL_FOR_LIST_VIEW

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetNBox_(global_function)
*/
//bool GetNBox(TreeNode& trNode, LPCSTR lpcszTitle=NULL, LPCSTR lpcszDescription=NULL, PAPPLY_FUNC pfnApply = NULL, PEVENT_FUNC pfnEvent = NULL, HWND hWndParent = NULL);	///DG SUPPORT_GETN_BOX_GRIDVIEW
bool GetNBox(TreeNode& trNode, LPCSTR lpcszTitle=NULL, LPCSTR lpcszDescription=NULL, PAPPLY_FUNC pfnApply = NULL, PEVENT_FUNC pfnEvent = NULL, HWND hWndParent = NULL, bool bSetGridView=false, bool bTranspose=false);

///Joseph 01/29/07 GETN_BOX_ADD_APPLY_BUTTON
////------ CPY 7/3/06 QA70-8798 DYNABOX_BETTER_EVENTS
//typedef	bool (*PFN_DYNABOX)(TreeNode& tr, PEVENT_GETN pfn, LPCSTR lpcszTitle, LPCSTR lpcszDescription, HWND hWndParent);
/// Iris 10/28/2008 QA80-12479 FIX_CANNOT_SHOW_APPLY_BTN_IN_SIMPLE_GETN
//typedef	int (*PFN_DYNABOX)(TreeNode& tr, PEVENT_GETN pfn, LPCSTR lpcszTitle, LPCSTR lpcszDescription, HWND hWndParent, bool bShowApplyButton);
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:PFN_DYNABOX
*/
typedef	int (*PFN_DYNABOX)(TreeNode& tr, PEVENT_GETN pfn, LPCSTR lpcszTitle, LPCSTR lpcszDescription, HWND hWndParent, bool bShowApplyButton, PAPPLY_FUNC pfnApply);
///end FIX_CANNOT_SHOW_APPLY_BTN_IN_SIMPLE_GETN
//bool GetNBox(TreeNode& trNode, PEVENT_GETN pfnEvent, LPCSTR lpcszTitle=NULL, LPCSTR lpcszDescription=NULL, HWND hWndParent = NULL);
/// Iris 10/28/2008 QA80-12479 FIX_CANNOT_SHOW_APPLY_BTN_IN_SIMPLE_GETN
//int GetNBox(TreeNode& tr, PEVENT_GETN pfnEvent, LPCSTR lpcszTitle = NULL, LPCSTR lpcszDescription = NULL, HWND hWndParent = NULL, bool bShowApplyButton = false);
int GetNBox(TreeNode& tr, PEVENT_GETN pfnEvent, LPCSTR lpcszTitle = NULL, LPCSTR lpcszDescription = NULL, HWND hWndParent = NULL, bool bShowApplyButton = false, PAPPLY_FUNC pfnApply = NULL);
///end FIX_CANNOT_SHOW_APPLY_BTN_IN_SIMPLE_GETN
///End GETN_BOX_ADD_APPLY_BUTTON
//------

////----- AW 10/02/06 QA80-9015 v8.0493 MORE_ON_ASCII_OPTION 
typedef	int (*PFN_GETNBOX3)(TreeNode& tr, LPCSTR lpcszTitle, LPCSTR lpcszTextOK, LPCSTR lpcszTextApply, LPCSTR lpcszDescription, PEVENT_FUNC pEvtFn, HWND hWndParent);
void GetNBox(int& nRefRet, TreeNode& trNode, LPCSTR lpcszTitle=NULL, LPCSTR lpcszTextOK=NULL, LPCSTR lpcszTextApply=NULL, LPCSTR lpcszDescription=NULL, PEVENT_FUNC pfnEvent = NULL, HWND hWndParent = NULL); 
////----- END MORE_ON_ASCII_OPTION 

/**#
	Remarks:
		Out the one level treenode.
	Parameters:
		trNode = [input] the treenode will output, the treenode should be only one node
	Example1:
		void out_params_ex1()
		{
			Tree     tr;
			tr.First.strVal = "First";
			tr.Second.strVal = "Second";
			tr.Third.nVal = 3;
			tr.fourth.nVal = 4;	
			out_params(tr);				
		}
*/
bool out_params(TreeNode& trNode);

/**#
*/
///Iris 4/01/05 CENTRALIZE_GET_SEL_STR_FROM_COMBOLIST CPY 8/23/2007 CHENEY_MOVED_SOME_FILES_BROKE_MDIM_XF, moved here from analysis_utils
string    get_selected_string_from_combolist(TreeNode &trList);

//#define load_default_getnbox_gui(__TR, __CLASSNAME)	load_default_settings(__TR, __CLASSNAME,SETTINGS_GUI)
///Sophy 4/9/2008 SET_STR_INSERT_COMBO_CASE_SENSITIVE_CONTROL
//bool set_str_insert_combo(TreeNode& tr, LPCSTR lpcszVal, LPCSTR lpcszValBefore); //--- CPY 11/24/05 QA70-8363 COMBO_CHANGE_IN_EVENT_NOT_PROPER_UPDATED
bool set_str_insert_combo(TreeNode& tr, LPCSTR lpcszVal, LPCSTR lpcszValBefore, bool bFullMatch = true); //--- CPY 11/24/05 QA70-8363 COMBO_CHANGE_IN_EVENT_NOT_PROPER_UPDATED
///end SET_STR_INSERT_COMBO_CASE_SENSITIVE_CONTROL
///Sophy 7/3/2008 INSERT_STR_INTO_TREENODE_COMBO_WITHOUT_UPDATE_ITS_VALUE
bool	insert_str_into_combo( TreeNode& trReport, LPCSTR lpcszVal, LPCSTR lpcszValBefore, bool bFullMatch = true);
///end INSERT_STR_INTO_TREENODE_COMBO_WITHOUT_UPDATE_ITS_VALUE
///Sophy 4/9/2008 REMOVE_STR_FROM_COMBO
bool remove_str_from_combo(TreeNode& tr, LPCSTR lpcszVal, bool bFullMatch = true);
///end REMOVE_STR_FROM_COMBO
//------------------ CPY v7.5811 1/30/04 QA70-5910 PREVIEW_GETNBOX

//typedef bool (* PVIEW_FUNC)(TreeNode& tr, int nViewState, Dialog& dlg, int nViewCntrlID);	///DG VIEW_GRAPH_GETNBOX
//typedef bool (* PGRAPH_FUNC)(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD nEventInfo, int nCntrlType, WndContainer& getNContainer, PageBase& page);	///DG 7/28/05 : we need data worksheet inside x-function to make things easy to do

///Jasmine 02/03/07 ENABLE_CUSTOM_BUTTONS_SEPARATELY
/* move to oc_sys.h
#define GETNGEVT_GRID_NEED_UPDATE 		0x0001
#define GETNGEVT_GRAPH_NEED_UPDATE 		0x0002
//bits to control buttons
#define GETNGEVT_OK_ENABLE				0x0004	//--- CPY 7/2/2006 QA70-8798 OK_BUTTON_DISABLED_BY_EVENT
#define GETNGEVT_ENABLE_CUSTOM_BUTTON1	0x0008
#define GETNGEVT_ENABLE_CUSTOM_BUTTON2	0x0010
#define GETNGEVT_ENABLE_CUSTOM_BUTTON3	0x0020
*/
///End ENABLE_CUSTOM_BUTTONS_SEPARATELY
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:PGRAPH_FUNC
*/
typedef int (* PGRAPH_FUNC)(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD nEventInfo, int nCntrlType, WndContainer& getNContainer, PageBase& page, Datasheet& wksdata, PictureControl& pict);


/**$
*/
typedef int (* PIMAGE_FUNC)(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD nEventInfo, int nCntrlType, WndContainer& getNContainer, ImageControlBase* pimgCntrl); //CPY 9/12/05 GET_N_IMAGE_DIALOG
/**$
GetNBoxEx
*/
//------ CPY 7/3/06 QA70-8798 DYNABOX_BETTER_EVENTS moved here from above
//typedef bool (* FUNC_GETNGRAPHBOX)(TreeNode& trNode, LPCSTR lpcszTitle, LPCSTR lpcszDescription, PGRAPH_FUNC pfnView, HWND hWndParent, int nEventID);
typedef bool (* FUNC_GETNGRAPHBOX)(TreeNode& trNode, PGRAPH_FUNC pfnView, LPCSTR lpcszTitle, LPCSTR lpcszDescription, HWND hWndParent, int nEventID);
//------

///Sophy 3/29/2012 ORG-4118 FILTERIIR_NEED_SHOW_MORE_TABS_ON_GETNPREVIEW_DIALOG
/**$
GetNPreviewGraph
*/
typedef bool (* FUNC_GETNPREVIEW_GRAPH)(WndContainer* pwndContainer, GraphPage& gp, Datasheet& ds, int iGraphTab = 0);
/**$
LoadEMF
*/
typedef bool (* FUNC_LOAD_EMF)(PictureControl& pict, LPCSTR lpcszEMF, int nDrawMode = PCDM_STRETCH_KEEP_ASPECT_RATIO);
///end FILTERIIR_NEED_SHOW_MORE_TABS_ON_GETNPREVIEW_DIALOG

/**$
GetNImageBox
*/
//------ CPY 7/3/06 QA70-8798 DYNABOX_BETTER_EVENTS moved here from above
//typedef bool (* FUNC_GETNIMAGEBOX)(TreeNode& tr, LPCSTR lpcszTitle, LPCSTR lpcszDescription, PIMAGE_FUNC pfn, HWND hWndParent);
typedef bool (* FUNC_GETNIMAGEBOX)(TreeNode& tr, PIMAGE_FUNC pfn, LPCSTR lpcszTitle, LPCSTR lpcszDescription, HWND hWndParent);
//------

/// YuI 01/29/09 QA70-13034 CUSTOM_XF_DIALOGS
typedef bool (* FUNC_GETNCUSTOM)(TreeNode& tr, PEVENT_FUNC pfn, LPCSTR lpcszTitle, LPCSTR lpcszDescription, HWND hWndParent);
/// end CUSTOM_XF_DIALOGS

//nViewState
//enum {GETNVIEW_ON_INIT, GETNVIEW_ON_DESTROY, GETNVIEW_ON_OPEN, GETNVIEW_ON_CLOSE, GETNVIEW_ON_SIZE, GETNVIEW_ON_UPDATE};	///DG VIEW_GRAPH_GETNBOX
//Commment last update by Joseph 03/17/07
/*
		Example:
		#include <..\OriginLab\ImagePreview.h>
		int run_getnviewbox()
		{
			//Import a image and focus on it first
			string strSourceMatName;
			MatrixLayer ml = Project.ActiveLayer();
			if(!ml)
				return -1;
			ml.GetPage().GetName( strSourceMatName );
	
			// Use GETN_TREE macro to declare a tree for a Tree style GetN dialog
			GETN_TREE( tr )
			GETN_STR( tnMatrix, "Current Image:", strSourceMatName );
			if( GetNViewBox(tr, "Testing",NULL, preview) )
				out_tree( tr );
			return 1;
		}
		// handler when "preview" pressed
		bool preview(TreeNode& tr, int nViewState, Dialog& dlg, int nViewCntrlID)
		{	
			static CPreview* s_pPreview = NULL;
	
			switch(nViewState)
			{
			case GETNVIEW_ON_INIT:
				s_pPreview = new CPreview;
				if(!s_pPreview->Init(dlg, nViewCntrlID))
					return false;
			break;
			case GETNVIEW_ON_DESTROY:
				if(s_pPreview)
					delete s_pPreview;
				s_pPreview = NULL;
				break;
			case GETNVIEW_ON_UPDATE:
				s_pPreview->Update(tr);
				break;
			}
			return true;
		}
		//create class inheriting ImagePreview
		class CPreview : public ImagePreview
		{
		protected:
			virtual bool OnUpdatePreview(TreeNode tr)
			{
				MatrixPage mp(m_strSrcMatrix);
				if(!mp)
					return false;
				Matrix<ushort> mprev(m_mlCntrl);
				mprev.Rotate();
		
				return true;
			}
		};
*/
//bool GetNViewBox(TreeNode& trNode, LPCSTR lpcszTitle=NULL, LPCSTR lpcszDescription=NULL, PVIEW_FUNC pfnView = NULL, PEVENT_FUNC pfnEvent = NULL, HWND hWndParent = NULL);	///DG VIEW_GRAPH_GETNBOX
//------------------ end CPY v7.5811 1/30/04 QA70-5910 PREVIEW_GETNBOX

/**$ >User Interface
		Opens a GetNBox with Graph to get multiple values from user
	Parameters:
		trNode =[modify] a TreeNode constructed by the GETN_BOX or GETN_TREE macro
		lpcszTitle =[input] Dialog title
		lpcszDescription =[input] a line of text above the editable list of parameters
		pfnView = [input]if specified, it will be called at the beginning with Row number = -1 for each control type, and if user change any editable parameters, the event handler will also be called
		hWndParent =[input] parent window. If NULL, Origin main window will be used, also the location of the dialog will be reset to where it was brought up the time before. 
		If hWndParent is specified, the dialog will be open at its default location, so the event handler can move the dialog to a desired location.
		nEventID =[input] can be 2 or 4 etc, the index of the ComboBox for GetNBox type
	
	Return:
		TRUE if user click OK, FALSE if user click Cancel
*/
bool GetNGraphBox(TreeNode& trNode, LPCSTR lpcszTitle=NULL, LPCSTR lpcszDescription=NULL, PGRAPH_FUNC pfnView = NULL, HWND hWndParent = NULL, int nEventID = 4);

/// SY 8/17/05 QA70-8027 v8.0290 IMPORT_WIZARD_XF
/**$ >User Interface
		Opens a GetNBox with imported file header info
	Parameters:
		tr = [modify]a TreeNode constructed by the GETN_BOX or GETN_TREE macro
		lpcszTitle = [input]Dialog title
		hWndParent = [input]parent window. If NULL, Origin main window will be used, also the location of the dialog will be reset to where it was brought up the time before. 
		If hWndParent is specified, the dialog will be open at its default location, so the event handler can move the dialog to a desired location.
		bSetGridView =[input] if false, GetNBox will show tree view
		if true, GetNBox will show grid view
		bTranspose = [input]it works only when bSetGridView is true. if true, grid column and row will be transposed, if false, will not.
	
	Return: 
		TRUE if user click Next, FALSE if user click Prev
*/
/// Hong 06/11/08 v8.0882b FIX_NETCDF_LINKING_ERROR_CAUSE_BY_REMOVE_GETN_NEXT_PREV_DLG
//bool GetNPrevNextBox(TreeNode& tr, LPCSTR lpcszTitle = NULL, HWND hWndParent = NULL, bool bSetGridView = false, bool bTranspose = false);
/// end FIX_NETCDF_LINKING_ERROR_CAUSE_BY_REMOVE_GETN_NEXT_PREV_DLG
/// end IMPORT_WIZARD_XF

//----- CPY 9/12/05 GET_N_IMAGE_DIALOG
/**$
*/
bool GetNImageBox(TreeNode& tr, LPCSTR lpcszTitle, LPCSTR lpcszDescription, PIMAGE_FUNC pfn, PEVENT_FUNC pEvtFn, HWND hWndParent);
//-----
///Joseph	12/07/06	ADD_MESSAGE_BOX
//void getn_dlg_check_show_msg(HWND hDlg, const string& strErrMsg); //---- CPY 10/26/06 QA70-9063 DYNAMIC_ERR_MSG_IN_GETN_DIALOGS
//--------- CPY 5/16/07 QA70-9659 GLOBAL_EVENTS_ALSO_NEED_ERR_MSG_TAG_NAME
//void getn_dlg_check_show_msg(HWND hDlg, const string& strErrMsg, bool bIsXF = true);
bool getn_dlg_check_show_msg(HWND hDlg, LPCSTR lpcszErrMsg, LPCSTR lpcszTag=NULL, string* pstrLastSenderName=NULL, BOOL bAutoClearMsg=true);
//---------
///End	ADD_MESSAGE_BOX

///Joseph 04/03/07 CHANGE_PARAMETER_SHOULD_NOT_SUPPORT_THEME_AND_AUTOUPDATE_MODE
bool is_theme_dialog(const TreeNode& trGetN);
///End CHANGE_PARAMETER_SHOULD_NOT_SUPPORT_THEME_AND_AUTOUPDATE_MODE

///---Sim 04-07-2008 QA80-11371 THEME_SAVING_OPTIONS
//#define TAGNAME_DS_SETTINGS_BRANCH	DialogSettings
#define STR_DS_SETTINGS_BRANCH	"DialogSettings"
///---END QA80-11371 THEME_SAVING_OPTIONS

///---Sim 11-13-2007 GET_CREATED_OUTPUT_PAGE_INFO
enum{
	EX_SETTING_BRANCH,
	EX_SETTING_EXEC_VALS,
};
TreeNode get_external_settings_branch(const TreeNode& trGetN, int nType = EX_SETTING_BRANCH, bool bCheckAddNode = false);
///---END GET_CREATED_OUTPUT_PAGE_INFO
///---Sim 12-06-2007 IMPROVE_EVENT1_PARAM_STR_AUX
void set_aux_value(string& strAux, LPCSTR lpcszSetting, bool bAdd = true);
bool is_aux_value(LPCSTR lpcszAux, LPCSTR lpcszSetting);
///---END IMPROVE_EVENT1_PARAM_STR_AUX

bool set_combo_string(TreeNode& trCombo, vector<string>& vsOps); ///---Sandy 2008-3-18 MOVE_FROM_PFM_UTILS

///------ Folger 06/01/10 ORG-120 DATA_DISPLAY_DIALOG_IMPROVEMENT
//bool open_column_browser(HWND hWndParent, vector<string>& vsSelections, bool bMultipleSelect, bool bXYRange, bool bOnlySelectableInSheet = false);
/////////////////////////////// IMPORTANT !!! ///////////////////////////////
// If open_column_browser is changed, need to update FUNC_RANGE_BROWSER in common.h
/////////////////////////////// IMPORTANT !!! ///////////////////////////////
///------ Folger 09/17/2012 ORG-6848-P1 BETTER_OUTPUT_COLUMNS_FILTERING_FOR_INPUT_COLUMN_BROWSER
//bool open_column_browser(HWND hWndParent, vector<string>& vsSelections, bool bMultipleSelect, bool bXYRange, bool bOnlySelectableInSheet = false, LPCSTR lpcszBookSheetSpecified = NULL);
bool open_column_browser(HWND hWndParent, vector<string>& vsSelections, bool bMultipleSelect, bool bXYRange, bool bOnlySelectableInSheet = false, void* pMore = NULL);
///------ End BETTER_OUTPUT_COLUMNS_FILTERING_FOR_INPUT_COLUMN_BROWSER
///------ End DATA_DISPLAY_DIALOG_IMPROVEMENT

///------ Folger 09/18/2012 ORG-6861 SUPPORT_LT_GETN_MATRIX_BROWSER
int  OnShowMatrixBrowserEx(StringArray &saSelecions, HWND hWnd, DWORD dwCtrl);
///------ End SUPPORT_LT_GETN_MATRIX_BROWSER

//------ CPY 9/25/05 QA70-8132 GETN_IMAGE_BOX_EVENTS_CLEAN
// strErrMsg added CPY 10/26/06 QA70-9063 DYNAMIC_ERR_MSG_IN_GETN_DIALOGS
typedef	void	(*PFNXFONINIT)(TreeNode& trGetN, ImageControlBase* pimgCntrl, bool& bUpdateGrid, bool& bOKEnable, string& strErrMsg);
typedef	void	(*PFNXFONCHANGE)(BITMAPHANDLE* pPreviewBitmap, TreeNode& trGetN, TreeNode& trNode, ImageControlBase* pimgCntrl, bool& bUpdatePreview, bool& bUpdateGrid, bool& bOKEnable, string& strErrMsg);
int	xf_GetNImageBox_event_handler(TreeNode& trGetN, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, 
int nType, ImageControlBase* pimgCntrl,
PFNXFONINIT pfnOnInit, PFNXFONCHANGE pfnOnChange);
///Jasmine 02/03/07 ENABLE_CUSTOM_BUTTONS_SEPARATELY
//typedef	void	(*PFNXF_G_ONINIT)(TreeNode& trGetN, PageBase& graph, Datasheet& wksData, PictureControl& pict, bool& bUpdateGrid, bool& bOKEnable, string& strErrMsg);
///---Sim 07-12-2007 EXTEND_UPDATE_GRAPH_CONTROL_VALUE
//typedef	void	(*PFNXF_G_ONINIT)(TreeNode& trGetN, PageBase& graph, Datasheet& wksData, PictureControl& pict, bool& bUpdateGrid, DWORD& dwEnables, string& strErrMsg);
///------ Folger 04/14/09 QA80-12786-P3 PREVIEW_GETN_FAILS_TO_SHOW_DATA_TIME_FORMAT_AFTER_CHANGED
//typedef	void	(*PFNXF_G_ONINIT)(TreeNode& trGetN, PageBase& graph, Datasheet& wksData, PictureControl& pict, DWORD& dwUpdateGraph, bool& bUpdateGrid, DWORD& dwEnables, string& strErrMsg);
//typedef	void	(*PFNXF_G_ONINITGRAPH)(TreeNode& trGetN, PageBase& graph, Datasheet& wksData, PictureControl& pict, bool& bUpdateGrid, DWORD& dwEnables, string& strErrMsg);
typedef	void	(*PFNXF_G_ONINIT)(TreeNode& trGetN, PageBase& graph, Datasheet& wksData, PictureControl& pict, DWORD& dwUpdateGraph, DWORD& dwUpdateGrid, DWORD& dwEnables, string& strErrMsg);
typedef	void	(*PFNXF_G_ONINITGRAPH)(TreeNode& trGetN, PageBase& graph, Datasheet& wksData, PictureControl& pict, DWORD& dwUpdateGrid, DWORD& dwEnables, string& strErrMsg);
///------ End PREVIEW_GETN_FAILS_TO_SHOW_DATA_TIME_FORMAT_AFTER_CHANGED
///---END EXTEND_UPDATE_GRAPH_CONTROL_VALUE
//typedef	void	(*PFNXF_G_ONCHANGE)(TreeNode& trGetN, TreeNode& trNode, PageBase& previewGraph, Datasheet& previewData, PictureControl& pict, bool bChangedByGraph, bool& bUpdateGraph, bool& bUpdateGrid, bool& bOKEnable, string& strErrMsg);
///---Sim 07-12-2007 EXTEND_UPDATE_GRAPH_CONTROL_VALUE
//typedef	void	(*PFNXF_G_ONCHANGE)(TreeNode& trGetN, TreeNode& trNode, PageBase& previewGraph, Datasheet& previewData, PictureControl& pict, bool bChangedByGraph, bool& bUpdateGraph, bool& bUpdateGrid, DWORD& dwEnables, string& strErrMsg);
///------ Folger 04/14/09 QA80-12786-P3 PREVIEW_GETN_FAILS_TO_SHOW_DATA_TIME_FORMAT_AFTER_CHANGED
//typedef	void	(*PFNXF_G_ONCHANGE)(TreeNode& trGetN, TreeNode& trNode, PageBase& previewGraph, Datasheet& previewData, PictureControl& pict, bool bChangedByGraph, DWORD& dwUpdateGraph, bool& bUpdateGrid, DWORD& dwEnables, string& strErrMsg);
typedef	void	(*PFNXF_G_ONCHANGE)(TreeNode& trGetN, TreeNode& trNode, PageBase& previewGraph, Datasheet& previewData, PictureControl& pict, bool bChangedByGraph, DWORD& dwUpdateGraph, DWORD& dwUpdateGrid, DWORD& dwEnables, string& strErrMsg);
///------ End PREVIEW_GETN_FAILS_TO_SHOW_DATA_TIME_FORMAT_AFTER_CHANGED
///---END EXTEND_UPDATE_GRAPH_CONTROL_VALUE
typedef	void	(*PFNXF_G_ONUPDATE)(TreeNode& trGetN, PageBase& graph, Datasheet& wksData, PictureControl& pict);
//--- CPY 5/20/06 CHANGE_GETN_PREVIEW_TO_DATASHEET_FROM_WKSHEET
typedef void (*PFNXF_G_ONSETUP)(TreeNode& trGetN, WndContainer& theDlg, DWORD& dwOptions, vector<string>& vsTabTitles);
//---
///Jasmine 02/01/07 GETN_PREVIEW_DLG_NEED_MORE_BTNS
//-------- CPY 2/24/2007 ADDING_CUSTOM_BUTTON4
//enum{CUSTOM_BUTTON1 = 1, CUSTOM_BUTTON2, CUSTOM_BUTTON3};
// CUSTOM_BUTTON = 1,2,3,4
#define GETNEVENT_TO_CUSTOM_BUTTON(_DW) (((_DW & GETNEVENT_ON_ANY) >> 8) - 0x06)
#define CUSTOM_BUTTON_TO_GETN_EVENT(_NN) ((((_NN) & 0x000F) + 0x06) << 8)
///---Sim 04-09-2007 FIX_CUSTOM_BUTTON_ENABLE_ISSUE
//#define CUSTOM_BUTTON_TO_GETN_ENABLE(_NN) ( 1 << (7+(_NN)))	
#define CUSTOM_BUTTON_TO_GETN_ENABLE(_NN) ( GETNGEVT_ENABLE_CUSTOM_BUTTON1 << (_NN-1))
///---END FIX_CUSTOM_BUTTON_ENABLE_ISSUE

//for oc
#define CUSTOM_BUTTON_TO_GETNE_EVENT(_NN) (_NN + GETNE_ON_CUSTOM_BUTTON1 - 1) ///---Joseph 04/12/07 FIX_BUG_ON_CLICK_CUSTOM_BUTTON_IN_XFBAR
//-------- end ADDING_CUSTOM_BUTTON4
//--------
//typedef	void	(*PFNXF_G_ONCUSTOMBUTTON)(TreeNode& trGetN, int nButton, PageBase& previewGraph, Datasheet& previewData, PictureControl& pict, bool bChangedByGraph, bool& bUpdateGraph, bool& bUpdateGrid, bool& bOKEnable, string& strErrMsg);
///---Sim 07-12-2007 EXTEND_UPDATE_GRAPH_CONTROL_VALUE
//typedef	void	(*PFNXF_G_ONCUSTOMBUTTON)(TreeNode& trGetN, int nButton, PageBase& previewGraph, Datasheet& previewData, PictureControl& pict, bool bChangedByGraph, bool& bUpdateGraph, bool& bUpdateGrid, DWORD& dwEnables, string& strErrMsg);
///------ Folger 04/14/09 QA80-12786-P3 PREVIEW_GETN_FAILS_TO_SHOW_DATA_TIME_FORMAT_AFTER_CHANGED
//typedef	void	(*PFNXF_G_ONCUSTOMBUTTON)(TreeNode& trGetN, int nButton, PageBase& previewGraph, Datasheet& previewData, PictureControl& pict, bool bChangedByGraph, DWORD& dwUpdateGraph, bool& bUpdateGrid, DWORD& dwEnables, string& strErrMsg);
typedef	void	(*PFNXF_G_ONCUSTOMBUTTON)(TreeNode& trGetN, int nButton, PageBase& previewGraph, Datasheet& previewData, PictureControl& pict, bool bChangedByGraph, DWORD& dwUpdateGraph, DWORD& dwUpdateGrid, DWORD& dwEnables, string& strErrMsg);
///------ End PREVIEW_GETN_FAILS_TO_SHOW_DATA_TIME_FORMAT_AFTER_CHANGED
///---END EXTEND_UPDATE_GRAPH_CONTROL_VALUE
///End GETN_PREVIEW_DLG_NEED_MORE_BTNS
///End ENABLE_CUSTOM_BUTTONS_SEPARATELY
//int	xf_GetNGraphPreviewBox_event_handler(TreeNode& trGetN, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType,
//PageBase& previewGraph, Datasheet& previewData,
//PFNXF_G_ONINIT pfnOnInitGrid, PFNXF_G_ONINIT pfnOnInitGraph, PFNXF_G_ONINIT pfnOnInitPreview, 
//PFNXF_G_ONCHANGE pfnOnChange, PFNXF_G_ONUPDATE pfnOnUpdateGraph, PFNXF_G_ONUPDATE pfnOnUpdatePreview);
//------- CPY 12/26/05 GETNGRAPH_BOX_TYPE_4
///---Sim 07-12-2007 EXTEND_UPDATE_GRAPH_CONTROL_VALUE
/*
int xf_GetNPreviewDlg_event_handler(TreeNode& trGetN, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg, 
PageBase& pgGraph, Datasheet& wksGraphData, PictureControl& pict,
PFNXF_G_ONINIT pfnOnInitGrid, PFNXF_G_ONINIT pfnOnInitGraph, 
PFNXF_G_ONCHANGE pfnOnChange, PFNXF_G_ONUPDATE pfnOnUpdateGraph, PFNXF_G_ONSETUP pfnOnDlgSetup, PFNXF_G_ONUPDATE pfnOnDestroy,
PFNXF_G_ONCUSTOMBUTTON pfnOnCustomButton);	///Jasmine 02/01/07 GETN_PREVIEW_DLG_NEED_MORE_BTNS
*/
int xf_GetNPreviewDlg_event_handler(TreeNode& trGetN, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg, 
PageBase& pgGraph, Datasheet& wksGraphData, PictureControl& pict,
PFNXF_G_ONINIT pfnOnInitGrid, PFNXF_G_ONINITGRAPH pfnOnInitGraph, 
PFNXF_G_ONCHANGE pfnOnChange, PFNXF_G_ONUPDATE pfnOnUpdateGraph, PFNXF_G_ONSETUP pfnOnDlgSetup, PFNXF_G_ONUPDATE pfnOnDestroy,
PFNXF_G_ONCUSTOMBUTTON pfnOnCustomButton);	///Jasmine 02/01/07 GETN_PREVIEW_DLG_NEED_MORE_BTNS
///---END EXTEND_UPDATE_GRAPH_CONTROL_VALUE

/// YuI 09/16/09 QA70-13696 XFUNCTION_EVENT2_IMPLEMENTATION
BOOL	xf_is_extended_event(int nEventId);
/// end XFUNCTION_EVENT2_IMPLEMENTATION

//CPY 10/24/06 XF_DLG_DESTROY_EVENT added pfnOnDestroy
//-------
#pragma dll(OTreeEditor.dll)

#define AFTER_EDIT_USE_CUSTOM_EDITOR (-1)
#define AFTER_EDIT_USE_STR			(-2)

/// Comments last updated by Cloud 03/15/2007
/**$ >
*/
class EditorManager
{
public:
	EditorManager();
	~EditorManager();
	
	/// YuI 07/21/06 CRASH_IN_F10_DIALOG_FOR_XYRANGE
	//	DWORD	New(int nType, int nRow, DWORD nID=0, LPCSTR lpcszAuxString=NULL, DWORD dwParam1=0, DWORD dwParam2=0);
	ODWP	New(int nType, int nRow, DWORD nID=0, LPCSTR lpcszAuxString=NULL, DWORD dwParam1=0, DWORD dwParam2=0, BOOL bVSFlex = TRUE);	/// TD ML 11-09-2010 NEW_TYPES
	/// end CRASH_IN_F10_DIALOG_FOR_XYRANGE

	bool	Delete(ODWP dwData);	/// TD ML 11-09-2010 NEW_TYPES
	BOOL	DrawCell(ODWP dwData, ODWP hDC, const RECT * lpcRect, BOOL bSelected);	/// TD ML 11-09-2010 NEW_TYPES
	double	GetCellHeightFactor(ODWP dwData);	/// TD ML 11-09-2010 NEW_TYPES
	ODWP	CreateEditor(ODWP dwData, const RECT * lpcRect, HWND hwndOwner, UINT nControlID=100, LPCTSTR lpcszFontName=NULL, int nFontSize=0, BOOL bGraphPage = FALSE);	/// TD ML 11-09-2010 NEW_TYPES
	bool	DestroyEditor(ODWP dwData);	/// TD ML 11-09-2010 NEW_TYPES
	bool	StartEdit(ODWP dwData, int nRow);	/// TD ML 11-09-2010 NEW_TYPES
	bool	AfterEdit(ODWP dwData, int nComboIndex = AFTER_EDIT_USE_CUSTOM_EDITOR, LPCSTR lpcszNewText = NULL);	/// TD ML 11-09-2010 NEW_TYPES
	string	GetText(ODWP dwData, BOOL bTranslate = TRUE);	/// TD ML 11-09-2010 NEW_TYPES
	bool	SetText(ODWP dwData, LPCSTR lpcsz, int nCvtText = OXVT_UINT);	/// TD ML 11-09-2010 NEW_TYPES
	int		GetEditInfo(ODWP dwData, string& strCombo, string& strEditMask);	/// TD ML 11-09-2010 NEW_TYPES
	string	GetStrData(ODWP dwData);	/// TD ML 11-09-2010 NEW_TYPES
	bool	SetStrData(DWORD dwData, LPCSTR lpcsz);
	bool	ValidateEdit(ODWP dwData, LPCSTR lpcsz);	/// TD ML 11-09-2010 NEW_TYPES
	bool	SetComboStr(ODWP dwData, LPCSTR lpcsz);	/// TD ML 11-09-2010 NEW_TYPES
	#if _OC_VER >= 0x0800
	/**#
	*/
	bool	SetEditorStr(ODWP dwData, LPCSTR lpcsz);	/// TD ML 11-09-2010 NEW_TYPES
	
	/**#
	*/
	void	SetEditorButtonID(ODWP dwData, int nID);	/// TD ML 11-09-2010 NEW_TYPES
	/**#
	*/
	string	GetEditorStr(ODWP dwData);	/// TD ML 11-09-2010 NEW_TYPES
	/**#
	*/
	BOOL	OnSelectionTrack(DWORD dwData);	/// TD ML 11-09-2010 NEW_TYPES
	/**#
	*/
	BOOL	OnSelectionChange(ODWP dwData);	/// TD ML 11-09-2010 NEW_TYPES
	/**#
	*/
	BOOL	SetTree(ODWP dwData, TreeNode& tr);	/// TD ML 11-09-2010 NEW_TYPES
	/**#
	*/
	BOOL	GetTree(ODWP dwData, TreeNode& tr);	/// TD ML 11-09-2010 NEW_TYPES
	
	BOOL	GetCompositeRangeString(TreeNode& tr, string& str);
	BOOL	SetCompositeRangeString(TreeNode& tr, LPCSTR lpcsz);
	#endif //_OC_VER >= 0x0800
};


/// EJP 12-16-2004 QA70-6721 ASCIMP_OPTIONS_USE_GETNBOX
#define GETN_OPTION_SPECIALVALS(_STR) _strTemp = _STR; _tmpSubNode.SetAttribute(STR_SPECIALVALS_ATTRIB, _strTemp);
/// end ASCIMP_OPTIONS_USE_GETNBOX

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_AMENU_CURR
*/
#define		GETN_AMENU_CURR									_tmpNode
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_AMENU_START
*/
#define		GETN_AMENU_START(_tr)							GETN_USE(_tr)
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_AMENU_CMD
*/
#define		GETN_AMENU_CMD(_nodeName, _lpszLabel, _nCmdId)	_tmpSubNode = _tmpNode.AddNode(#_nodeName, TRGP_STR); TREE_ADD_LABEL(_lpszLabel); GETN_ID(_nCmdId)
//#define		GETN_AMENU_BEGIN_BRANCH(_nodeName, _lpszLabel)	GETN_BEGIN_BRANCH(#_nodeName, _lpszLabel)
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_AMENU_BEGIN_BRANCH
*/
#define GETN_AMENU_BEGIN_BRANCH(_NODE_NAME, _NODE_LABEL) 	_tmpSubNode = _tmpNode.AddNode(#_NODE_NAME, TRGP_BRANCH);TREE_ADD_LABEL(_NODE_LABEL);\
TreeNode _tmSave_##_NODE_NAME = _tmpNode; _tmpNode = _tmpSubNode;
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_AMENU_END_BRANCH
*/
#define		GETN_AMENU_END_BRANCH(_NODE_NAME)				GETN_END_BRANCH(_NODE_NAME)

/// Iris 12/27/2006 v8.0533 CALL_EVENT1_ON_GRAPH_OBJ_MOVING
#define 	PGDM_SET_HDLG 						0 // put hDlg to wParam, so can set and clear it 
/// Hong 03/26/08 v8.0832b PA_PEAKS_ADD_DONE_DIALOG_WHEN_MODIFY
enum tagGRAPH_OBJ_CHANGE_WPARAM
{
	WPARAM_DONE_DLG_COSE = 1000, // pfw use it to separate such even send from attach XF
	WPARAM_NONE_ANCHOR   = -1    // pa_anchors.oxf use to indicate all anchors are deleted.
};
/// end PA_PEAKS_ADD_DONE_DIALOG_WHEN_MODIFY
#define 	WM_USER_ON_GRAPH_OBJECT_CHANGE		(WM_USER + 1100)
///end CALL_EVENT1_ON_GRAPH_OBJ_MOVING

/// Iris 01/04/2007 v8.0536 FIX_AFTER_SAVEAS_THEME_MOVE_GRAPH_OBJ_FAIL_TO_ENTER_EVENT1
#define		STR_ATTRIB_POST_USER_MESSAGE		"PostUserMessage" 
///end FIX_AFTER_SAVEAS_THEME_MOVE_GRAPH_OBJ_FAIL_TO_ENTER_EVENT1

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GETN_ADD_INT_MAP
*/
#define GETN_ADD_INT_MAP(_STR_INT_VALS)	_tmpSubNode.SetAttribute(STR_INTMAP_ATTRIB, _STR_INT_VALS); 

///---Sim 12-06-2007 IMPROVE_EVENT1_PARAM_STR_AUX
/*
///Joseph 02/14/07 SUPPORT_MORE_SPECAIL_EVENT
#define DLG_NEED_CHANGE_GRID "GETN_CHANGE_GRID"
#define GETN_CHANGE_GRID  strAux = DLG_NEED_CHANGE_GRID;
///End SUPPORT_MORE_SPECAIL_EVENT

///---Sim 10-30-2007 NOTIFY_XF_NEED_APPLY
#define XF_NEED_APPLY "XF_NEED_APPLY"
#define NOTIFY_XF_NEED_APPLY  strAux = XF_NEED_APPLY;
///---END NOTIFY_XF_APPLY

///---Sim 11-01-2007 NOTIFY_XF_WIZ_UPDATE_PATH
#define XF_NEED_UPDATE_PATH "XF_NEED_UPDATE_PATH"
#define NOTIFY_XF_NEED_UPDATE_PATH  strAux = XF_NEED_UPDATE_PATH;
///---END NOTIFY_XF_WIZ_UPDATE_PATH
*/

#define DLG_NEED_CHANGE_GRID "GETN_CHANGE_GRID"
#define GETN_CHANGE_GRID  set_aux_value(strAux, DLG_NEED_CHANGE_GRID);

#define XF_NEED_APPLY "XF_NEED_APPLY"
#define NOTIFY_XF_NEED_APPLY  set_aux_value(strAux, XF_NEED_APPLY);

#define XF_NEED_UPDATE_PATH "XF_NEED_UPDATE_PATH"
#define NOTIFY_XF_NEED_UPDATE_PATH  set_aux_value(strAux, XF_NEED_UPDATE_PATH);
///---END IMPROVE_EVENT1_PARAM_STR_AUX

///---Sim 10-31-2008 INDICATE_THEME_ON_PA_FIT_PARAM_CHANGE
#define DLG_NEED_INDICATE_THEME "DLG_NEED_INDICATE_THEME"
#define NOTIFY_DLG_NEED_INDICATE_THEME  set_aux_value(strAux, DLG_NEED_INDICATE_THEME);
///---END INDICATE_THEME_ON_PA_FIT_PARAM_CHANGE

///---Sim 02-28-2008 QA80-11156 XF_PANEL_APPLY_BUTTON
#define APPLY_EVENT_NO_CAUSE_CALL_BODY "APPLY_EVENT_NO_CAUSE_CALL_BODY"
#define NOTIFY_APPLY_EVENT_NO_CAUSE_CALL_BODY  set_aux_value(strAux, APPLY_EVENT_NO_CAUSE_CALL_BODY);
///---END QA80-11156 XF_PANEL_APPLY_BUTTON

#define STR_CAT_IMPORT			"Import and Export" //CPY 5/3/07 QA70-9718 RECENT_IMPORT_EXPORT_WITH_THEME

#define STR_SHOW_OPT_DLG		_L("Show Options Dialog") // Hong 10/25/07 v8.0733 CENTRALIZE_CODE


//------ Folger 03/25/08 QA80-11304 CLEAN_UP_CODE_ABOUT_FIT_PARAMETERS_CONTROL
#define 	STR_SHARE_GROUP_LIST		"|0|1|2|3|4|5|6|7|8|9" //CPY 10/20/08 moved here from  MultiFuncFitParaControl.h
//------

///------ Folger 04/14/09 QA80-13436 IMPROVE_MECHANISM_ABOUT_XF_ERR_MSG_SHOWN_IN_BODY
#define		SHOULD_WARNING_MSG_SHOW_IN_XF_BODY					_should_warning_msg_show_in_xf_body()
#define		SET_WARNING_MSG_SHOW_IN_XF_BODY(_bOn)				{ bool& _bb = SHOULD_WARNING_MSG_SHOW_IN_XF_BODY; _bb = _bOn; }

#define		IMPLEMENT_SHOULD_WARNING_MSG_SHOW_IN_XF_BODY						\
			static	bool&	SHOULD_WARNING_MSG_SHOW_IN_XF_BODY					\
			{																	\
				static	bool	l_bShouldWarningMsgShow = false;				\
				return l_bShouldWarningMsgShow;									\
			}
			
/// used in before_execute()
#define		IS_ERR_MSG_OK_TO_SHOW_IN_BODY						(0 == nGetNDialog && !(LTXF_SHOW_DIALOG & dwCntrl) && XFEVT_PROCEED_WITH_DLG != nRet)


#define		XF_GET_WARNING_MSG_ID								_xf_get_warning_msg_id()
#define		XF_SET_WARNING_MSG_ID(_nID)							{ int& _nn = XF_GET_WARNING_MSG_ID; _nn = _nID; }

#define		IMPLEMENT_XF_GET_WARNING_MSG_ID						\
			static	int&	XF_GET_WARNING_MSG_ID				\
			{													\
				static	int		l_nWarningMsgID = 0;			\
				return l_nWarningMsgID;							\
			}
			

#define	CHECK_SHOW_WARNING_MESSAGE_IN_XF_BODY			\
		if ( SHOULD_WARNING_MSG_SHOW_IN_XF_BODY )		\
		{												\
			int		nID = XF_GET_WARNING_MSG_ID;		\
			if ( 0 != nID )								\
				warning_msg_box(nID, false, 'I');		\
		}

///------ End IMPROVE_MECHANISM_ABOUT_XF_ERR_MSG_SHOWN_IN_BODY

#define GETN_UNDEFINED         _tmpSubNode.SetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, TRUE);

///------ Folger 03/08/10 QA81-15177 GETNBOX_SUPPORT_MOVE_FIRST_LEVEL_BRANCHES_INTO_TABS
#define			STR_MOVE_FIRST_SUBNODES_INTO_TABS_ATTRIB		"FirstSubnodesAsTabs"
#define			GETN_FIRST_SUBNODES_AS_TABS(_tr)				_tr.SetAttribute(STR_MOVE_FIRST_SUBNODES_INTO_TABS_ATTRIB, TRUE);
///------ End GETNBOX_SUPPORT_MOVE_FIRST_LEVEL_BRANCHES_INTO_TABS

///------ Folger 03/18/2011 ORG-2486-P1 QUICKFIT_BAD_INIT_ROI_POSITION_FOR_NONLINEAR_SCALE
#pragma dll()
class GetNOptionEventHelper
{
public:
	GetNOptionEventHelper(DWORD dwCntrl);

	BOOL	IsInit();
	BOOL	IsTheme();

private:
	DWORD	m_dwEvents;
};
///------ End QUICKFIT_BAD_INIT_ROI_POSITION_FOR_NONLINEAR_SCALE

///------ Folger 07/03/2012 ORG-6076 SUPPRT_GET_SELECTION_RANGE_FROM_INTERATIVE_CONTROL_FROM_OC
#define GETNBOX_SHOW_DIALOG_OPTIONS "GetNShowDialogOptions"
///------ End SUPPRT_GET_SELECTION_RANGE_FROM_INTERATIVE_CONTROL_FROM_OC

///------ Folger 08/06/2012 ORG-6266-S4 SUPPORT_SPECIFY_DEFAULT_FOCUS_CONTROL_IN_DYNACTRL
#define GETN_SET_DEFAULT_FOCUS {int nn = 0; _tmpSubNode.GetAttribute(STR_OCNTRL_OPTNS, nn); nn |= OCNTRLPARAM1_DEFAULT_FOCUS; _tmpSubNode.SetAttribute(STR_OCNTRL_OPTNS, nn);}
///------ End SUPPORT_SPECIFY_DEFAULT_FOCUS_CONTROL_IN_DYNACTRL

#endif //_GET_N_BOX
