/*------------------------------------------------------------------------------*
 *	File Name: 	FDFTree.h								 						*
 *	Purpose:	OC util function for FDF to Origin C tree					   	*
 *  Creation:	02/11/2004, Shulin												* 
 *				SY 02-11-2004 QA70-5970 FDF_TREE_CONVERSIONS					*
 *  	Copyright Originlab Corp. 2003, 2004,									*
 *	Modification log	                                                        *
 *	ML 5/11/2008 MOVE_TO_HEADER													*
 *	DSC 10/18/05 QA70-8167 CONSTRUCT_XF_FDF_TREE_FOR_UPDATE						*
 *	Hong 04/23/07 v8.0606 MORE_OPTION_FOR_LOAD_FDF_TO_TREE						*
 *	Hong 05/17/07 QA80-9784 FIX_FUNCTION_FORM_CONFLICT_BETWEEN_75_80			*
 *	Hong 07/25/08 QA80-11593 FIX_BUILD_IN_FDF_USER_ADDED_DERIVED_PARAMETERS_LOST_IN_FIT_REPORT
 *	Sophy 11/7/08 QA80-12442 SHOW_WARNING_WHEN_SAVE_READ_ONLY_FILE				*
 *	Kyle 11/06/2009 QA80-14584 SET_COL_VALUES_NEED_BASIC_FDF_INFO				*
 *------------------------------------------------------------------------------*/      

/// SY 02-11-2004 QA70-5970 FDF_TREE_CONVERSIONS
#ifndef _FDF_TREE_H
#define _FDF_TREE_H


/// ML 3/19/2004 MOVING_FDFTOTREE_CODE_AND_SOME_NLSF_RESOURCES_OVER
//#ifdef __AFX_H__
//	#ifdef NLSF_DLL
//		#define OC_API __declspec(dllexport)
//	#else
//		#define OC_API __declspec(dllimport)
//	#endif
//	#define TreeNode  OCXmlWrapperBase
//	extern "C" {
//#else
//	#define OC_API
//	#pragma dll(nlsf70)	// Assoicate all functions below to OCcontour.dll which must be in the Origin EXE folder
//#endif	//__AFX_H__

#ifdef __AFX_H__
	#ifdef BUILDING_NLSF8
		#define OC_API __declspec(dllexport)
	#else
		#define OC_API __declspec(dllimport)
	#endif
	#define TreeNode  OCXmlWrapperBase
	/// Hong 07/25/08 QA80-11593 FIX_BUILD_IN_FDF_USER_ADDED_DERIVED_PARAMETERS_LOST_IN_FIT_REPORT
	#define	StringArray		CScriptMocaObject
	/// end FIX_BUILD_IN_FDF_USER_ADDED_DERIVED_PARAMETERS_LOST_IN_FIT_REPORT
	/// ML 5/11/2008 MOVE_TO_HEADER
	#define FDF_SCRIPT	"Script"

	#define string CString	///Sophy 11/7/08 QA80-12442 SHOW_WARNING_WHEN_SAVE_READ_ONLY_FILE

	/// end MOVE_TO_HEADER
	extern "C" {
#else
	#define OC_API
	#pragma dll(ONLSF8)	// Associate all functions below to ONLSF8.dll which must be in the Origin EXE folder
#endif	//__AFX_H__
/// end MOVING_FDFTOTREE_CODE_AND_SOME_NLSF_RESOURCES_OVER

/// ML 3/19/2004 MOVING_FDFTOTREE_CODE_AND_SOME_NLSF_RESOURCES_OVER
//#define FDF_LINE_BUF 1024
//#define FDF_KEYS_BUF 1024
//#define FDF_VALUE_BUF 128

// Let us not be stingy:
#define FDF_LINE_BUF			(3*COM_LENGTH)
#define FDF_KEYS_BUF			FDF_LINE_BUF
#define FDF_VALUE_BUF			FDF_LINE_BUF	
/// end MOVING_FDFTOTREE_CODE_AND_SOME_NLSF_RESOURCES_OVER

/// Hong 05/17/07 QA80-9784 FIX_FUNCTION_FORM_CONFLICT_BETWEEN_75_80
#define STR_FUNCTION_FORM_ORIGIN_C		"Origin C"
#define STR_FUNCTION_FORM_EQUATIONS		"Equations"
#define STR_FUNCTION_FORM_EXPRESSION	"Expression"
#define STR_FUNCTION_FORM_Y_SCRIPT		"Y-Script"
/// end FIX_FUNCTION_FORM_CONFLICT_BETWEEN_75_80

/**#
	Load a FDF file (function definition file in NLSF) into an Origin C tree
	Example:
		string strFile = GetOpenBox("*.FDF");
		Tree trTemp;
		if(nlsf_FDF_to_tree(strFile, &trTemp))
		{
			strFile.Empty(); // test to make sure we can get this back from tree
			trTemp.GetAttribute(STR_LABEL_ATTRIB,  strFile);
			out_str(strFile);
			out_tree(trTemp);
		}
	Parameters:
		lpcszFDFname = FDF file name
		pTreeNode = a TreeNode pointer 
	Return:
		Returns TRUE if successful and FALSE if failed. If success, lpcszFDFname is stored into pTreeNode as STR_LABEL_ATTRIB attribute
*/
/// Hong 04/23/07 v8.0606 MORE_OPTION_FOR_LOAD_FDF_TO_TREE
//OC_API BOOL	nlsf_FDF_to_tree(LPCSTR lpcszFDFname, TreeNode* pTreeNode);
enum
{
	FDFT_INIT_FULL_ENTRIES  = 0x0001,	// will first init full tree before reading and will use copy-tree-by-id to fill the complete tree
										//see nlsf_create_FDF_tree
	FDFT_CONVERT_BOOL_TO_01  = 0x0002,	// will convert Yes,No, On,Off to 1 and 0
};

/// Iris 11/18/2010 ORG-1446-P1 STILL_NO_ERR_MSG_SHOW_WHEN_FAIL_TO_READ_FDFFILE
//OC_API BOOL	nlsf_FDF_to_tree(LPCSTR lpcszFDFname, TreeNode* pTreeNode, DWORD dwCtrl = 0);
enum
{
	FDFERR_OPEN_FDF_FILE_FAILED = 0, 	
	FDFERR_INVALID_INPUT_TREENODE,
	FDFERR_CREATE_EMPTY_FDF_TREE_FAILED,	
	FDFERR_READ_FDF_FILE_FAILED,


	FDFERR_NO_ERROR = 100
};
OC_API int	nlsf_FDF_to_tree(LPCSTR lpcszFDFname, TreeNode* pTreeNode, DWORD dwCtrl = 0);
///End STILL_NO_ERR_MSG_SHOW_WHEN_FAIL_TO_READ_FDFFILE
/// end MORE_OPTION_FOR_LOAD_FDF_TO_TREE

/**#
	Save an Origin C tree into a function definition file
	If pstrFileName not NULL And fail to save file, pstrFileName will store the fdf file name
	Example:
		string strFile = GetOpenBox("*.FDF");
		Tree trTemp;
		if(nlsf_FDF_to_tree(strFile, &trTemp))
			out_tree(trTemp);
		
		nlsf_tree_to_FDF("c:\\test.fdf", &trTemp);
	Parameters:
		lpcszFDFname = FDF file name
		pTreeNode = a TreeNode pointer 
		pstrFileName = Destination file name
	Return:
		Returns TRUE if successful and FALSE if:
*/
///Sophy 11/7/08 QA80-12442 SHOW_WARNING_WHEN_SAVE_READ_ONLY_FILE
//OC_API BOOL nlsf_tree_to_FDF(LPCSTR lpcszFDFname, TreeNode* pTreeNode);
OC_API BOOL nlsf_tree_to_FDF(LPCSTR lpcszFDFname, TreeNode* pTreeNode, string* pstrFileName = NULL );
///end SHOW_WARNING_WHEN_SAVE_READ_ONLY_FILE
/// Hong 07/25/08 QA80-11593 FIX_BUILD_IN_FDF_USER_ADDED_DERIVED_PARAMETERS_LOST_IN_FIT_REPORT
OC_API BOOL nlsf_reset_build_in_FDF(TreeNode* pTreeNode);
OC_API int nlsf_get_customized_build_in_FDF_function_name(StringArray* vsFuncNames);
/// end FIX_BUILD_IN_FDF_USER_ADDED_DERIVED_PARAMETERS_LOST_IN_FIT_REPORT

/**#
	Create a FDF treewith section fields
	Example:
		Tree trTemp;
		if(nlsf_create_FDF_tree(&trTemp))
			out_tree(trTemp);
		
	Parameters:
		pTreeNode = a TreeNode pointer 
	Return:
		Returns TRUE if successful and FALSE if:
*/
OC_API BOOL nlsf_create_FDF_tree(TreeNode *pTreeNode);

/**#
	Setup the needed fonts to properly display NLSF function formula using metafiles
	Example:
		string strPath = GetAppPath(TRUE);	  // need to use system (installed) path
		init_math_equ_fonts(strPath);
			
*/
OC_API BOOL nlsf_init_math_equ_fonts(LPCSTR lpcszFontFilePath, BOOL bCheckAlreadyInit = TRUE);

/// DSC 10/18/05 QA70-8167 CONSTRUCT_XF_FDF_TREE_FOR_UPDATE
OC_API int okutil_get_FDF_file_info(LPCSTR lpcszFile, TreeNode *ptrInfo);
/// end CONSTRUCT_XF_FDF_TREE_FOR_UPDATE

///Kyle 11/06/2009 QA80-14584 SET_COL_VALUES_NEED_BASIC_FDF_INFO
OC_API BOOL	nlsf_get_fit_func_info(LPCSTR lpcszName, StringArray* psaDepenVarNames, StringArray* psaIndepVarNames, StringArray* psaParamNames);
///End SET_COL_VALUES_NEED_BASIC_FDF_INFO

#ifdef __AFX_H__
	}
#endif	//__AFX_H__

#endif //_FDF_TREE_H
/// end FDF_TREE_CONVERSIONS


