/*------------------------------------------------------------------------------*
 * File Name: Operation.h														*
 * Creation: YuI 11/25/2002													    *
 * Purpose: Origin C header	for Operation class and other related functions		*
 * Copyright (c) OriginLab Corp.2002											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	CPY 10/14/06 SEPARATE_OUT_OPERATION_BASE_INTO_SEPARATE_HEADER				*
 *  Arvin 10/24/06 FITTING_HISTOGRAM_PLOT										*
 *	ML 11/10/2006 NLFIT_MODAL_CLEANUP											*
 *	ML 11/13/2006 THEME_DIGITS_PARAMETERS_TBL									*
 *	ML 1/9/2007 INPUT_DATA_TBL_MR_MULTI_INDEPS									*
 *  Iris 02/02/2007 v8.0553 NOT_DO_AUTO_SIZE_ON_FITTED_VALUES_SHEET				*
 *	Arvin 02/09/07 SET_REPORT_TREE_SHOULD_USE_DIFFERENT_VALUE_FOR_FLAT_AND_NOFLAT_SHEET
 *	Arvin 02/13/07 SET_BIN_DATA_WITH_SAME_MIN_MAX_AND_BINSIZE_WHEN_PLOT_ALL_HISTOGRAM_IN_ONE_GRAPH
 *	ML 2/14/2007 QA70-9374 BAD_EVENT_HANDLER_DWORDS_IN_TREENODES				*
 *	ML 3/1/2007 QA70-9421 UPDATE_TRGUI_TO_CURRENT_BEFORE_RUNNING				*
 *	ML 3/13/2007 QA70-9477 PROPER_OCOPERATION_CLEANUP_AFTER_EXEC				*
 *	Cheney 2007-3-21 IF_AUTO_UPDATE_SHOULD_KEEP_1ST_COL_OF_FINDXY_SHEET			*
 *	ML 3/23/2007 MUST_RESTORE_i1_i2_AS_WELL_FROM_CACHE							*
 *	Cheney 2007-3-29 SUPPORT_MATRIX_FIT_WHEN_USE_DIALOG							*
 *	Cheney 2007-4-2 FIX_ALWAYS_SHOW_LAST_DATASET_MISSING_MASKED_DATA_WHEN_MULTI_DATASET_FITTING
 *	Cheney 2007-4-2 ADD_HINTS_IN_FOOTNOTE_WHEN_EXISTS_MISSING_OR_MASKED_DATA	*
 *	Cheney 2007-4-3 REMOVE_XY_IN_INPUT_TABLE_WHEN_FIT_MATRIX					*
 *	Cheney 2007-4-9 CORRECT_LOGIC_OF_CALLING_INIT_BRANCH						*
 *	Cheney 2007-4-12 ALL_FITTING_TOOLS_NEED_FOOTNOTE_FOR_MISSING_AND_MASKED_DATA*
 *	Cheney 2007-4-13 FIX_BUG_OF_CUSTOM_TABLE_DISAPPEAR_WHEN_CONCATENATE			*
 *	YuI 04/17/07 QA70-4589 IMPROVED_ANALYSIS_MARKERS							*
 *	Cheney 2007-4-20 OVERLOAD_SHOWDLG_FOR_FIX_BUG_OF_OP_DLG_CAN_NOT_OPEN		*
 *	Cheney 2007-5-4 FITCURVE_AND_RESIDUAL_COULD_PUT_INTO_MAT_LAYER_WHEN_FIT_MAT	*
 *	Cheney 2007-5-23 QA70-9805 SPEED_UP_STATISTIC_ON_ROW						*
 *	ML 6/5/2007 QA70-9869 SPECIAL_GUI_TREE_UPDATE_BEFORE_RERUNNING				*
 *	Arvin 07/09/07 v8.0655 FITTING_ON_GRAPH_FROM_EXCEL_SHOULD_NOT_OUTPUT_TO_SOURCE
 *  Iris 07/13/2007 v8.0659 SUPPRESS_SET_COL_NAME_TO_TAGNAME					*
 *  Arvin 07/18/07 v8.0662 FIT_COMPARISION_OF_DATASETS_INCONSISTENT_BETWEEN_NLFIT_AND_LR
 *  Iris 07/31/2007 QA70-10133 CHECK_DO_RESCALE_IF_DATA_OUTSIDE					*
 *  Iris 08/13/2007 QA70-10212-P1 TO_KEEP_SOURCE_DATA_PLOT_CUSTOMIC_SETTINGS_IN_REPORT_GRAPH*
 *	Cheney 2007-8-23 QA70-10290 FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
 *	Cheney 2007-9-3 SHOULD_DESTROY_LOCK_IF_UNCHECK_FINDXY_WHEN_CHANGE_PARAM		*
 *	YuI 09/10/07 QA70-10358 ANOVA_RECALCULATE_FAILS_AFTER_RENAME				*
 *	Cheney 2007-9-21 QA70-10376 MATRIX_FTTING_SUPPORT_GET_MISSING_DATA_IN_REPORT*
 *	CPY 10/12/07 10522-P3 CLEANUP_IF_LOOSE_DATASET_SHOULD_NOT_PUT_REPORT_SHEET_TO_SOURCE
 *	Arvin 10/22/07 ADD_CHECKBOX_USE_SOURCE_GRAPH_COLOR_TO_SET_FITCURVES_COLOR	*
 * 	Arvin 11/09/07 NLFIT_REPORT_GRAPH_NEED_RESCALE_WHILE_PART_GRAPH_SELECTION_AS_INPUT
 *	Arvin 11/16/07 QA70-10676 UPDATE_MEANS_COMPARISION_PLOT_LEGENT_WITH_SIG_INFO*
 *	YuI 11/19/07 QA70-10716 GUI_LOCALIZATION_ON_CHANGE_PARAM					*
 * 	Arvin 11/20/07 QA70-10708 CHECK_AND_CONVERT_DOUBLE_VALUES_FROM_GERMAN_TO_ENGLISH
 *	ML 11/20/2007 QA70-10716 INPUT_DATA_NODE_PROPER_LANGUAGE_WHEN_LOADING_OPER	*
 *	Echo 07/11/30 QA70-10589-P3 v8.0757	FITCMP_SUPPORT_POLY_ORDER				*
 *	Folger 01/02/08 QA70-10890 SAVING_REPORT_SHEET_NAME_AFTER_FITTING			*
 *	Folger 01/04/08 QA70-10890 ALWAYS_RUN_AFTER_FIT_SCRIPT_AFTER_EXECUTE		*
 *	Arvin 01/29/08 GENERATE_REPORT_FOR_LT_NLFit									*
 *	Arvin  01/31/08 ANOVA_REPORT_DATA_SHOULD_NOT_OUTPUT_TO_SOURCE 				*
 *	Arvin 02/03/08 QA70-10970 ERORR_BAR_LOST_WHEN_FIT_FROM_GRAPH				*
 *	Arvin 02/14/08 QA70-11094 SUPPORT_PLOT_MULTI_FITTED_CURVES_IN_ONE_GRAPH_IN_LR_PR_AND_FITNL
 *	Folger 03/12/08 QA80-11244 SURFACE_FIT_REPORT_SHOULD_USE_CONTOUR_PLOTS		*
 *	ML 3/18/2008 QA70-10598 FORCE_REPORT_TO_ENGLISH								*
 *	Folger 03/19/08 QA80-10598 NEW_GETN_LOCALIZAED_CHECK_MACRO					*
 *	Sim 04-07-2008 QA80-11371 THEME_SAVING_OPTIONS								*
 *	Hong 04/10/08 v8.0840c PEAK_FIT_REPORT_PEAK_CHARACTERISTICS_TO_SEPARATE_SHEET
 *	CPY 4/14/08 PEAK_FIT_REPORT_PEAK_CHARACTERISTICS_TO_SEPARATE_SHEET_BETTER_NAME
 *	Hong 04/15/08 v8.0843 FITTED_DATA_AUTO_SHOULD_TRY_SOURCE_BEFORE_USING_NEW	*
 *	Folger 05/22/08 QA80-11574 SUPPORT_GET_ALL_OPERATION_OUTPUT_SHEET_NAME_WITH_GLOBAL_STRING_VARIABLES
 *	Hong 05/30/08 QA80-11632 FIX_SURFACE_FIT_REPORT_FIT_CURVE_FAIL_CORRECT_RESCALE
 *	Hong 08/12/08 QA80-11986 FIX_FITTED_CURVE_PLOT_FAIL_RESCALE_WHEN_SOURCE_PLOT_HAVE_ERR_BAR
 *	Kyle 09/24/08 SET_NO_NEED_TO_LOCALIZE										*
 *	Hong 11/15/08 QA80-12584 v8.0972 SBUTRACTED_DATA_IS_FIT_SRC_DATA_AND_SHOULD_REPLACE_DRAW_SRC_DATA
 *	Folger 11/18/08 QA80-12574 v8.0974 SUPPORT_RESET_ALL_GRAPHS_IN_ERPORT_SHEET	*
 *	Sophy 11/28/2008 v8.980d CHANGE_PARAM_SHOULD_KEEP_BRAHCH_ENABLE_WHEN_CURVE_NOT_REPORTED_BEFORE
 *	Sophy 12/17/2008 v8.0987d  QA80-12784 ADD_BINNING_CONTROL_FOR_HISTOGRAM_PLOT_IN_STATS_TOOLS
 *	Sophy 12/23/2008 v8.0990 QA80-12832 SUPPORT_MULTI_DATASET_FOR_MULTI_INDEPS_AND_DEPS_FITTING
 *	Sophy 1/5/2009 v8.0993d QA80-12858 GIVE_USEFUL_INFO_ON_REPORT_GRAPH_WITH_FACTOR_VALUE_FOR_STATS_COLUMN
 *	Sophy 1/21/2009 v8.0962b FIX_FAIL_TO_GET_RESIDUAL_OUTPUT_WHEN_REPORT_TO_FITTEDCURVE_SHEET
 *	Sophy 2/2/2009 v8.0969 CHANGE_PARAM_SHOULD_KEEP_BRAHCH_ENABLE_WHEN_CURVE_NOT_REPORTED_BEFORE
 *	Sophy 3/5/2009 QA80-12584 v8.0992 FIX_LOSE_SOURCE_CURVE_WHEN_FIT_FROM_GRAPH_ARRANGE_SAME_PLOTS_ON_ONE_GRAPH
 *  Iris 3/23/2009 QA80-13285-P6 CLEAN_ANOVE_REPORT_DATA_LABEL					*
 *  Iris 3/23/2009 QA80-13331-P1 CENTRILIZE_REPORT_COL_LABEL_CODES				*
 *  Iris 3/24/2009 FIX_CREATE_NEW_NLFIT_FINDXY_REPORT_WHEN_RECALCULATE			*
 *	Sophy 3/26/2009 QA80-13351 SUPPORT_ARRANGE_SAME_TYPE_PLOTS_IN_ONE_GRAPH_CONTEXT_MENU
 *	Sim 04-02-2009 QA80-13403 ADD_INDIVIDUAL_OP_VERSION_FOR_CONVERT_GUI_TREE	*
 *	Sim 06-17-2009 QA80-13786-P2-P4 SPEEP_UP_LINEAR_FIT_WITHOUT_REPORT_TABLE	*
 *	Folger 07/01/09 QA80-13774-P1 COMPARE_MODELS_FOR_FITTING_WITH_WEIGHT_FAILS_WHEN_NOT_OUTPUT_FIT_STATISTICS_TABLE
 *  Iris 7/29/2009 QA80-14029 FAIL_CHANGE_INNER_OUTTER_RESIDUAL_LIMIT_ON_CHANGE_PARAM
 *	Hong 08/13/09 QA80-14138 REDUCE_OPERATION_SIZE_OF_STATS_ON_COLS				*
 *  Iris 8/31/2009 QA80-14209 IMPROVE_CREATE_MASKED_MISSING_DATA_TABLE_SPEED	*
 *  Iris 9/10/2009 QA80-11710-P2 IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
 *  Iris 9/14/2009 QA80-11710-S1 PUT_REPORT_GRAPH_LABEL_AS_Y_AXES_TITLE			*
 *  Iris 9/27/2009 FIX_RESET_ALL_GRAPHS_WORK_FAILED								*
 *  Iris 10/16/2009 QA80-14484 BOX_HISTOGRAM_ALSO_NEED_KEEP_CUSTOMIZATION_WHEN_RECALCULATION
 *	Folger 10/28/09 QA81-14552 WRONG_REPORT_STATUS_WHEN_CHANGE_PARAM_IN_PA		*
 *  Iris 10/28/2009 QA81-14546 IMPROVE_OP_BASED_DLG_OUTPUT_SETTINGS_GUI			*
 *	Iris 10/28/2009 QA81-14546 CHANGE_GUI_REPORT_TABLE_LABEL					*
 *  Iris 11/05/2009 QA81-14599 FIX_STATS_ON_COLS_PLOT_REPORT_GRAPHS_VERY_SLOW	*
 *  Iris 11/09/2009 QA81-14599 IMPROVE_STATS_ON_COLS_CALCULATION_SPEED			*
 *  Iris 12/09/2009 QA81-3224-P6 FIX_NOT_PLOT_ERR_COL_IN_LRXERR_REPORT_GRAPH_WHEN_OPEN_DLG_FROM_GRAPH
 *	Hong 12/11/09 QA80-14138-P2 FIX_STATS_ON_COL_CHANGE_PARAM_CANNOT_ADD_BACK_MISSING_TABLE
 *	Folger 12/18/09 QA81-14860 NLFIT_RECALCULATE_FAIL_TO_GET_SOURCE_GRAPH		*
 *	Hong 12/24/09 QA80-14832 NLFIT_OPEN_BY_HOTKEY_SOPPORT_APPLY_SETTING_FROM_QUICKFIT_WITHOUT_ANY_THEME
 *	Sophy 1/11/2010 SUPPORT_OPEN_NLFIT_FROM_QUICKFIT_CONTEXT_MENU				*
 *	Hong 01/12/10 QA80-14948 NLFIT_SUPPORT_OK_BTN_WHICH_DONOT_FIT_AGAIN			*
 *  Iris 2/02/2010 QA81-14994 FIX_UNCHECK_ALL_OUTPUT_STILL_GENERATE_REPORT_SHEET*
 *	Hong 03/01/10 QA80-10136 GROUP_FITTED_CURVE_IN_SRC_GRAPH_AS_SRC_PLOT		*
 *	Folger 10/13/2010 ORG-1210-S2 CREATE_NEW_TABLE_OBJ_FOR_FITTER_OPERATION_IF_WKS_WITHIN_HAS_NO_LINK
 *  Iris 11/05/2010 ORG-1368-P1 CHANGE_DATA_MODE_IN_CHANGE_PARAM_CAUSE_REPORT_GRAPH_NOT_CORRECT
 *  Iris 12/08/2010 ORG-1621-P2 FITCURVE_PLOT_BLACK_COLOR_WHEN_MULTI_DATA_COME_FROM_DIFF_LAYERS
 *	Folger 12/24/2010 ORG-938-P3 DATA_TIME_FORMAT_FAILED_TO_APPLY_PROPERLY_WHEN_CHANGE_PARAM
 *	Folger 04/28/2011 ORG-2240-S1 REMOVE_FIT_RESULT_TABLE_ON_GRAPH_AFTER_DELETE_ANALYSIS
 *	Folger 06/02/2011 ORG-2858 SUPPORT_DUPLICATE_ANALYSIS_OPERATION				*
 *	Kyle 08/19/2011 ORG-2741-S1 SUPPORT_DUPLICATE_ANALYSIS_OPERATION_IN_WORKSHEET
 * Iris 8/22/2011 ORG-2427-S4 QUANTITIES_BOOKSHEET_BRANCH_REPLACE_CHECKBOX		*
 *	Folger 09/06/2011 ORG-3706-P1 SUPPRT_SHOW_XERROR_IN_MASKED_DATA_AND_BAD_DATA_REPORT_TABLE
 *	Folger 10/26/2011 ORG-4204-P1 SOURCE_DATA_PLOT_MISSING_AFTER_PA_CHANGE_PARAM_NO_SUBTRACT_BASELINE
 *	Zech 11/07/2011 ORG-3228-P11 PUT_NORMALITY_TEST_DATA_WORKSHEET_INTO_THE_SAME_PAGE
 *	Folger 01/12/2012 ORG-4492-P2 NORMALITY_TEST_SHOULD_NOT_ACTIVE_SOURCE_SHEET_AFTER_CHANGE_PARAM
 *  Iris 4/19/2012 ORG-5481-S1 SURFACE_FIT_FITTED_CURVE_SUPPORT_XYZ_SURFACE_PLOT*
 *	Folger 05/04/2012 ORG-5592-S1 ADD_DATA_IDENTIFIER_FOR_FITTING_TOOLS			*
 *	Folger 05/15/2012 ORG-5661-P1 OGW_WITH_OPERATIONS_BECAME_TOO_LARGE_EVEN_CLEAR_INPUT_DATA
 *	Folger 05/17/2012 ORG-5592-P1 ONLY_SET_REPORT_TREE_WHEN_CHANGE_DATA_IDENTIFIER
 *	Folger 05/29/2012 ORG-4908-P8 IMPLICIT_FITTING_FAILED_TO_SET_FITTED_CURVE_COLUMN_DESIGNATION
 *	Folger 06/01/2012 ORG-5592-S1 SHOW_DATA_IDENTIFIER_FOR_FLAT_SHEET			*
 *	Philip 08/22/2012 ORG-6527-S4 NOTES_TABLE_ADD_ITERATION_ALGORITHM			*
 *	Zech 08/22/2012 ORG-5703-P1 OPERATION_SUPPORT_IGNORE_HIDDEN_ROW				*
 *	Folger 09/17/2012 ORG-6829-P1 FAILED_TO_SHOW_SUB_DATA_INDEX_IN_STATS_ON_COLUMN_REPORT_SHEET
 *------------------------------------------------------------------------------*/
#pragma PCH //CPY 12/9/04

#ifndef _WKSOPERATION_H
#define _WKSOPERATION_H
#include <operation.h> 
#include <xfutils.h>		///------ Folger 01/12/2012 ORG-4492-P2 NORMALITY_TEST_SHOULD_NOT_ACTIVE_SOURCE_SHEET_AFTER_CHANGE_PARAM

/// ML 6/30/2006 QA70-8768 BUTTONS_IN_PLACE_OF_GRAPHS_IN_REPORTS
#define		__BUTTONS_INSTEAD_OF_GRAPHS_IN_REPORT__
/// end BUTTONS_IN_PLACE_OF_GRAPHS_IN_REPORTS

/// Iris 10/16/2009 QA80-14484 BOX_HISTOGRAM_ALSO_NEED_KEEP_CUSTOMIZATION_WHEN_RECALCULATION, this fix for O8.1SR1, so open it.
#define BOX_HISTOGRAM_ALSO_NEED_KEEP_CUSTOMIZATION_WHEN_RECALCULATION
///end BOX_HISTOGRAM_ALSO_NEED_KEEP_CUSTOMIZATION_WHEN_RECALCULATION

///Iris 10/20/05 MOVE_ALL_FITTING_RELATED_TO_FITTER_OPERATION
//#define FIT_CURVES_BRANCH(_TROP) _TROP.Calculation.FitCurves
//#define STR_RESIDUALS_SCATTER_TABLE			"ResidualsScatter"
//#define STR_RESIDUALS_HISTOGRAM_TABLE			"ResidualsHistogram"
//#define STR_RESIDUALS_FIT_GRAPH_TABLE 		"ResidualsFit"
//#define STR_RESIDUALS_ORDER_GRAPH_TABLE 	"ResidualsOrder"
//#define NUM_FIT_CURVES						4
///End MOVE_ALL_FITTING_RELATED_TO_FITTER_OPERATION

//#define FIT_CURVES_BRANCH(_TRCALC) _TRCALC
//#define REPORT_ONE_MORE_LEVEL
//---

//#include <mswin.h>           // for HWND in UpdateHeaderInfo for Operation class
//#include <tree.h>
//#include <GetNBox.h>
//#include <TreeEditor.h>
//#include <Settings.h>
//#include <analysis_utils.h> //curve_update
/// ML 3/3/2004 RANGE_BASED_REGRESSIONS
/// end RANGE_BASED_REGRESSIONS

#pragma message("including wksOperationb.h")

/// ML temp
//#include	<tree_utils.h>

#include "..\Originlab\DataIDs.h" //CPY 3/24/04

#define STR_INPUT_WKS_ATTRIB	"InputWks"

/// Iris 2/15/2011 ORG-402 PLOT_SURFACE_FIT_DATA_FROM_VIRTUAL_MATRIX, moved from wksOperation.c
#define		STR_RESET_GRAPH_ATTRIB			"ResetGraph" /// Iris 11/25/2010 ORG-1530 REMOVE_DISABLE_RESTRICTION_ON_PLOT_IN_ONE_GRAPH_CHECKBOX_IN_CHANGE_PARAM
///End PLOT_SURFACE_FIT_DATA_FROM_VIRTUAL_MATRIX

/// end RESULT_COLUMNS_ADDED_TO_SOURCE_SHEET

///Cheney 2007-8-23 QA70-10290 FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
//#define	STR_REPORT_MATRIX_DATA		"ReportMatrixData"  /// Iris 9/06/06 SURFACE_FIT_REPORT_MAT_FIT_DATA
///end FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK

#define STR_XYMAP_ATTRIB  		"XYMap" ///Arvin 11/20/06 SURFACE_FIT_SET_XY_MAP
#define	STR_REPORT_DESTINATION_TYPE_ATTRIB	"ReportType"

typedef	bool (*PFN_tree_header_table_report)(TreeNode &trRep);
//typedef bool (* PAPPLY_FUNC)(TreeNode& tr);
//typedef bool (* PEVENT_FUNC)(TreeNode& tr, int nRow, int nCntrlType, Dialog& getNDlg); //CPY 5/30/03 added getNDlg
//---- CPY 9/22/05 QA70-8015-P15 USE_SET_REPORT_TREE_TO_INTERNALLY_PUT_TREE_INTO_FLAT_SHEET
#define SEPARATE_RESULT_CURVES_FROM_CALCULATION_BRANCH
#ifdef SEPARATE_RESULT_CURVES_FROM_CALCULATION_BRANCH
	#define RESULT_CURVE_BRANCH(_TROP)	_TROP.ResultCurves
	#define RESIDUAL_CURVE_BRANCH(_TROP)	_TROP.ResidualCurves
	#define CALIBRATION_CURVE_BRANCH_1(_TROP)	_TROP.Calibration1 
	#define CALIBRATION_CURVE_BRANCH_2(_TROP)	_TROP.Calibration2 
	#define RESULT_CURVE_DATA_SET_PREFIX	"Data"
	/// Hong 04/10/08 v8.0840c PEAK_FIT_REPORT_PEAK_CHARACTERISTICS_TO_SEPARATE_SHEET
	#define PEAK_CHARACTER_CURVE_BRANCH(_TROP)			_TROP.Calculation.PFM
	/// end PEAK_FIT_REPORT_PEAK_CHARACTERISTICS_TO_SEPARATE_SHEET
	/// Iris 11/12/2008 v8.0969 QA80-12584 OUTPUT_BASELINE_AND_SUBTRACTED_DATA_IN_FIT_PEAK_OP
	#define SUBTRACTED_DATA_CURVE_BRANCH(_TROP)			_TROP.SubtractedData
	#define BASELINE_DATA_CURVE_BRANCH(_TROP)			_TROP.BaselineData
	///end OUTPUT_BASELINE_AND_SUBTRACTED_DATA_IN_FIT_PEAK_OP
#else
	#define RESULT_CURVE_BRANCH(_TROP)	_TROP.Calculation
#endif
///#define STR_FIT_CURVES_TABLE	"FitCurves"  ///Iris 10/20/05 MOVE_ALL_FITTING_RELATED_TO_FITTER_OPERATION
//----

#define		STR_REPORT_SHEET_TEMPLATE		"ReportSheet"
///CPY, this will allow break point in header, so insert _BK into anywhere you need a break point
#define _BK			//_debug_break();

//#define	DBG_TREE_OUT(_tr, _lpcsMsg)		tree_dump(_tr, _lpcsMsg, 4);
#define PAGE_INFO_EXPORT		"Export"

//-------- CPY 8/8/04 BETTER_RESCALE_ON_FIT_GRAPHS
typedef struct tagXYScaleRange {
	double xMin;
	double xMax;
	double yMin;
	double yMax;
} XYScaleRange;
#define STR_PARENT_PLOT_Y_RANGE_ATTRIB "ParentPlotYRange"

//-------- end BETTER_RESCALE_ON_FIT_GRAPHS

///Cheney 2007-3-21 IF_AUTO_UPDATE_SHOULD_KEEP_1ST_COL_OF_FINDXY_SHEET
#define STR_Y_FROM_X	"YfromX"
#define STR_X_FROM_Y	"XfromY"
///end IF_AUTO_UPDATE_SHOULD_KEEP_1ST_COL_OF_FINDXY_SHEET


//----- CPY 4/14/08 PEAK_FIT_REPORT_PEAK_CHARACTERISTICS_TO_SEPARATE_SHEET_BETTER_NAME
/// Sophy 5/05/2008 GIVE_A_MORE_DESCRIPTIVE_NODE_LABEL_AND_OUTPUT_SHEET_NAME
//#define STR_PEAK_CHARACTERISTICS_REPORT		_L("Peaks")
//#define STR_PEAK_CHARACTER_SHEET			_L("Peaks1")

///Sandy 2008-7-10 clean-up PA GUI poor English as Deanna Suggested
//#define STR_PEAK_CHARACTERISTICS_REPORT		_L("Peaks Properties")
//#define STR_PEAK_CHARACTER_SHEET			_L("PeaksProperties1")
#define STR_PEAK_CHARACTERISTICS_REPORT		_L("Peak Properties")
#define STR_PEAK_CHARACTER_SHEET			_L("PeakProperties1")

/// End GIVE_A_MORE_DESCRIPTIVE_NODE_LABEL_AND_OUTPUT_SHEET_NAME
/// Iris 4/16/2008 OUTPUT_ALL_NEED_CENTRALIZE
//#define STR_OUTPUT_PEAKS_TABLE_TO 			_L("Output Peaks Table To")
#define STR_OUTPUT_PEAKS_TABLE_TO 			_L("Peaks Table")
//end OUTPUT_ALL_NEED_CENTRALIZE

///Sandy 2008-7-10 clean-up PA GUI poor English as Deanna Suggested
//#define STR_PEAK_CHARACTERISTICS_FIELDS 	_L("Peaks Report Fields")
#define STR_PEAK_CHARACTERISTICS_FIELDS 	_L("Peak Report Fields")

#define STR_PEAK_CHARACTER_BOOK_LONG_NAME	_L("Peak Characteristics")
//-----

/// Iris 4/115/2008 OUTPUT_BOOK_SHEET_NAME_NEED_CENTRALIZE
// Book Long Name for Result Curve
#define	STR_RESULT_CURVE_BOOK_LONG_NAME				_L("Fitted Data")
#define STR_RESIDUAL_CURVE_BOOK_LONG_NAME			_L("Residual Data")
#define STR_FINDXY_CURVE_BOOK_LONG_NAME				_L("FindXY")
#define STR_FINDZ_CURVE_BOOK_LONG_NAME				_L("FindZ")
/// Iris 11/12/2008 v8.0969 QA80-12584 OUTPUT_BASELINE_AND_SUBTRACTED_DATA_IN_FIT_PEAK_OP
#define STR_SUBTRACTED_DATA_BOOK_LONG_NAME			_L("Subtracted Data")
#define STR_BASELINE_DATA_BOOK_LONG_NAME			_L("Baseline Data")
///end OUTPUT_BASELINE_AND_SUBTRACTED_DATA_IN_FIT_PEAK_OP

//Book Short Name for Report Table
#define	E_STR_NL_FIT_REPORT_TABLE_BOOK_SHORT_NAME		"NLFit1"
#define	E_STR_XYZ_FIT_REPORT_TABLE_BOOK_SHORT_NAME		"SurfaceFit1"
#define	E_STR_MATRIX_FIT_REPORT_TABLE_BOOK_SHORT_NAME	"MatrixFit1"
#define	E_STR_PEAK_FIT_REPORT_TABLE_BOOK_SHORT_NAME		"PeakFit1"
#define	E_STR_LR_REPORT_TABLE_BOOK_SHORT_NAME			"LinearFit1"
#define	E_STR_PR_REPORT_TABLE_BOOK_SHORT_NAME			"PolyFit1"
#define	E_STR_MR_REPORT_TABLE_BOOK_SHORT_NAME			"MultiReg1"
#define	E_STR_ROC_REPORT_TABLE_BOOK_SHORT_NAME			"ROC1"
#define	E_STR_NORMALITY_TEST_REPORT_TABLE_BOOK_SHORT_NAME			"NormTest1"
#define	E_STR_ANOVA_1_WAY_REPORT_TABLE_BOOK_SHORT_NAME			"ANOVAOneWay1"
#define	E_STR_ANOVA_2_WAY_REPORT_TABLE_BOOK_SHORT_NAME			"ANOVATwoWay1"
#define	E_STR_ANOVA_1_WAY_RM_REPORT_TABLE_BOOK_SHORT_NAME		"ANOVAOneWayRM1"
#define	E_STR_ANOVA_2_WAY_RM_REPORT_TABLE_BOOK_SHORT_NAME		"ANOVATwoWayRM1"
#define	E_STR_XYZ2MAT_REPORT_TABLE_BOOK_SHORT_NAME				"XYZGriding1"

// Book Short Name for Result Curve
#define	E_STR_RESULT_CURVE_BOOK_SHORT_NAME			"FitCurve1"
#define	E_STR_RESIDUAL_CURVE_BOOK_SHORT_NAME		"Residual1"
#define	E_STR_FIND_X_CURVE_BOOK_SHORT_NAME			"FindXY1"
#define	E_STR_FIND_Y_CURVE_BOOK_SHORT_NAME			"FindYX1"
#define	E_STR_FIND_Z_CURVE_BOOK_SHORT_NAME			"FindZ1"
#define E_STR_MR_PARTIAL_CURVE_BOOK_SHORT_NAME		"Partial1"
#define E_STR_PEAK_CHARACTER_BOOK_SHORT_NAME		"PeakChar1"
#define E_STR_ANOVA_BOOK_SHORT_NAME					"Means1"
#define E_STR_ROC_BOOK_SHORT_NAME					"Coordinates1"
/// Iris 11/12/2008 v8.0969 QA80-12584 OUTPUT_BASELINE_AND_SUBTRACTED_DATA_IN_FIT_PEAK_OP
#define	E_STR_SUBTRACTED_DATA_BOOK_SHORT_NAME		"Subtracted1"
#define	E_STR_BASELINE_DATA_BOOK_SHORT_NAME			"Baseline1"
///end OUTPUT_BASELINE_AND_SUBTRACTED_DATA_IN_FIT_PEAK_OP

// Sheet Name for Report Table
///Kyle 09/24/08 SET_NO_NEED_TO_LOCALIZE
//#define	STR_NL_FIT_REPORT_TABLE_SHEET_NAME			_L("FitNL1")
//#define	STR_XYZ_FIT_REPORT_TABLE_SHEET_NAME			_L("FitSurface1")
//#define	STR_MATRIX_FIT_REPORT_TABLE_SHEET_NAME		_L("FitMatrix1")
//#define	STR_ANOVA_1_WAY_REPORT_TABLE_SHEET_NAME   	_L("ANOVA1Way1")
//#define	STR_ANOVA_2_WAY_REPORT_TABLE_SHEET_NAME  	_L("ANOVA2Way1")
//#define	STR_ROC_REPORT_TABLE_SHEET_NAME				_L("ROC Curve1")  
//#define STR_PEAK_FIT_REPORT_TABLE_SHEET_NAME		_L("FitPeaks1")
#define	STR_NL_FIT_REPORT_TABLE_SHEET_NAME			"FitNL1"
#define	STR_XYZ_FIT_REPORT_TABLE_SHEET_NAME			"FitSurface1"
#define	STR_MATRIX_FIT_REPORT_TABLE_SHEET_NAME		"FitMatrix1"
#define	STR_ANOVA_1_WAY_REPORT_TABLE_SHEET_NAME   	"ANOVA1Way1"
#define	STR_ANOVA_2_WAY_REPORT_TABLE_SHEET_NAME  	"ANOVA2Way1"
#define	STR_ROC_REPORT_TABLE_SHEET_NAME				"ROC Curve1"
#define STR_PEAK_FIT_REPORT_TABLE_SHEET_NAME		"FitPeaks1"
///End SET_NO_NEED_TO_LOCALIZE
/// Iris 11/12/2008 v8.0969 QA80-12584 OUTPUT_BASELINE_AND_SUBTRACTED_DATA_IN_FIT_PEAK_OP
#define STR_SUBTRACTED_DATA_SHEET					"SubtractedData1"
#define STR_BASELINE_DATA_SHEET						"BaselineData1"
///end OUTPUT_BASELINE_AND_SUBTRACTED_DATA_IN_FIT_PEAK_OP

// Sheet Name for Result Curve -- will append "1" in WksReportOperation::GetResultCurveSheetFullName
#define	E_STR_RESULT_CURVE_SHEET_NAME				"Curve"
#define	E_STR_RESIDUAL_CURVE_SHEET_NAME				"Residuals"
#define	E_STR_FINDX_CURVE_SHEET_NAME				"FindXfromY"
#define	E_STR_FINDY_CURVE_SHEET_NAME				"FindYfromX"
#define	E_STR_FINDZ_CURVE_SHEET_NAME				"FindZfromXY"
#define E_STR_PEAK_CHARACTER_SHEET_NAME				"Peaks"
#define E_STR_MR_PARTIAL_SHEET_NAME					"PartialLeverageValues"
#define E_STR_ANOVA_CURVE_SHEET_NAME				"Plots"
#define E_STR_DEST_STATS_CURVE_SHEET_NAME			"DescStatsCurves1" /// Iris 5/26/2008 WRONG_RESULT_CURVE_SHEET_NAME_SAME_AS_REPORT_SHEET
///end OUTPUT_BOOK_SHEET_NAME_NEED_CENTRALIZE

/// Iris 8/22/2011 ORG-2427-S4 QUANTITIES_BOOKSHEET_BRANCH_REPLACE_CHECKBOX
#ifdef __STATS_ON_COLS_SUPPORT_QUANTITIES_OUTPUT_BRANCH
#define E_STR_DEST_STATS_FLAT_SHEET_NAME			"DescStatsFlatOut1"
#endif //__STATS_ON_COLS_SUPPORT_QUANTITIES_OUTPUT_BRANCH

/// Iris 4/16/2008 OUTPUT_ALL_NEED_CENTRALIZE
///Sophy 12/17/2008 v8.0987d  QA80-12784 ADD_BINNING_CONTROL_FOR_HISTOGRAM_PLOT_IN_STATS_TOOLS to Max's suggestion
//#define STR_OUTPUT_BRANCH								_L("Output Reports To")
//---- Iris 01/22/2009 change output label accroding to Easwar's mail
//#define STR_OUTPUT_BRANCH								_L("Output Reports Configuration")
//-------Iris 9/14/2009 change output label accroding to Easwar & Max's mail
//#define STR_OUTPUT_BRANCH								_L("Output Reports To")
#ifndef OP_DLG_TOTALLY_NEW_STRUCTURE
#define STR_OUTPUT_BRANCH								_L("Output Settings")
#else //OP_DLG_TOTALLY_NEW_STRUCTURE
#define STR_OUTPUT_BRANCH								_L("Output Tables To")
#endif //OP_DLG_TOTALLY_NEW_STRUCTURE

//-------
//----
///end ADD_BINNING_CONTROL_FOR_HISTOGRAM_PLOT_IN_STATS_TOOLS

#ifndef OP_DLG_TOTALLY_NEW_STRUCTURE
#define STR_OUTPUT_GRAPH_ARRANGMENT						_L("Graph Arrangement")
#else
#define STR_REPORT_GRAPH_SETTINGS						_L("Graphs in Result Sheet")
#define STR_OUTPUT_GRAPH_ARRANGMENT						_L("Graph Arrangement in Result Sheet")
#endif //OP_DLG_TOTALLY_NEW_STRUCTURE

#ifndef OP_DLG_TOTALLY_NEW_STRUCTURE
#define STR_OUTPUT_REPORT_TABLES						_L("Report Tables")
#else //OP_DLG_TOTALLY_NEW_STRUCTURE
#define STR_OUTPUT_REPORT_TABLES						_L("Result Sheet")
#endif //OP_DLG_TOTALLY_NEW_STRUCTURE


/// Iris 4/17/2008 OUTPUT_ALL_NEED_CENTRALIZE_AGAIN
//#define STR_OUTPUT_RESULT_CURVE_TABLES					_L("Fitted Values")
//#define STR_OUTPUT_RESIDUAL_CURVES_TABLES				_L("Residual Values")
/// Iris 10/28/2009 QA81-14546 CHANGE_GUI_REPORT_TABLE_LABEL
/*
#define STR_OUTPUT_DESC_STATS_REPORT_TABLE				_L("Descriptive Statistics Tables")
#define STR_OUTPUT_NORMALITY_TEST_REPORT_TABLE			_L("Normality Test Tables")
#define STR_OUTPUT_ROC_REPORT_TABLE						_L("ROC Tables")
#define STR_OUTPUT_ANOVA_REPORT_TABLE					_L("ANOVA Tables")
#define STR_OUTPUT_LR_FIT_REPORT_TABLE					_L("Linear Fit Tables")
#define STR_OUTPUT_PR_FIT_REPORT_TABLE					_L("Polynomial Fit Tables")
///Sophy 5/28/2008 QA80-10934-P9 CORRECT_MR_REPORT_TABLE_NAME
//#define STR_OUTPUT_MR_FIT_REPORT_TABLE					_L("Multiple Regression Fit Tables")
#define STR_OUTPUT_MR_FIT_REPORT_TABLE					_L("Multiple Regression Tables")
///end CORRECT_MR_REPORT_TABLE_NAME
#define STR_OUTPUT_PEAK_FIT_REPORT_TABLE				_L("Peak Fit Tables")


#define STR_OUTPUT_NL_FIT_REPORT_TABLE					_L("NLFit Tables")
#define STR_OUTPUT_XYZ_FIT_REPORT_TABLE					_L("Surface Fit Tables")
#define STR_OUTPUT_MATRIX_FIT_REPORT_TABLE				_L("Matrix Fit Tables")
*/
///end CHANGE_GUI_REPORT_TABLE_LABEL

#define STR_OUTPUT_FIT_RESULT_CURVE_TABLES				_L("Fitted Curves")
#define STR_OUTPUT_STATS_RESULT_CURVE_TABLES			_L("Plot Data")
#define STR_OUTPUT_ANOVA_RESULT_CURVE_TABLES			STR_OUTPUT_STATS_RESULT_CURVE_TABLES
#define STR_OUTPUT_ROC_RESULT_CURVE_TABLES				STR_OUTPUT_STATS_RESULT_CURVE_TABLES

#define STR_OUTPUT_RESIDUAL_CURVES_TABLES				_L("Fit Residuals")
///end OUTPUT_ALL_NEED_CENTRALIZE_AGAIN
#define STR_OUTPUT_MR_PARTIAL_LEVERAGE_CURVE_TABLES		_L("Partial Leverage Values")
#define STR_OUTPUT_FINDXY_TABLES						_L("Find Specific X/Y Tables")
#define STR_OUTPUT_OPTIONAL_TABLES						_L("Optional Report Tables")
///end OUTPUT_ALL_NEED_CENTRALIZE

/// Iris 11/12/2008 v8.0969 QA80-12584 OUTPUT_BASELINE_AND_SUBTRACTED_DATA_IN_FIT_PEAK_OP
#define STR_OUTPUT_SUBTRACTED_DATA_TABLES				_L("Subtracted Data")
#define STR_OUTPUT_BASELINE_DATA_TABLES					_L("Baseline Data")
///end OUTPUT_BASELINE_AND_SUBTRACTED_DATA_IN_FIT_PEAK_OP

//--- Iris 3/16/2009 QA80-13285-P2 CLEANUP_FIT_TOOLS_REPORT_DATA_COLUMN_LABELS
// here want to hide empty column parameters label in result curve report sheet
// Once find label string is empty, will NOT set Label attribute to result curve sub table tree, so the column Parameters label of report sheet will be empty and not show.
#define STR_REPORT_FIT_CURVE_SUB_TABLE_LABEL			"" 
#define STR_REPORT_RESIDUAL_TABLE_LABEL					""
#define STR_REPORT_RESIDUAL_TABLE_SUB_LABEL				""
#define STR_REPORT_X_COL_LONG_NAME						_L("Independent Variable")
//---CLEANUP_FIT_TOOLS_REPORT_DATA_COLUMN_LABELS

/// Iris 3/23/2009 QA80-13285-P6 CLEAN_ANOVE_REPORT_DATA_LABEL
#define	STR_REPORT_ANOVE_PLOTS_DATA_LABEL				_L("ANOVA Plots")
#define	STR_REPORT_ANOVE_X_DATA_LABEL					_L("Factor")
#define	STR_REPORT_ANOVE_MEAN_DATA_LABEL				_L("Mean")
#define	STR_REPORT_ANOVE_SD_DATA_LABEL					_L("SD")
#define	STR_REPORT_ANOVE_SEM_DATA_LABEL					_L("SEM")
#define	STR_REPORT_ANOVE_MEAN_DIFF_DATA_LABEL			_L("MeanDiff")
#define	STR_REPORT_ANOVE_MEANDIFF_ERROR_DATA_LABEL		_L("Error")
#define	STR_REPORT_ANOVE_SIG_DATA_LABEL					_L("Sig")
///end CLEAN_ANOVE_REPORT_DATA_LABEL


#define	STR_ERRINFO_OF_REPORT_GRAPH_FAILURE				_L("Attention: No plot due to compution error")

#define	OUT_WND_WKS						EXIST_WKS
#define	OUT_WND_MATRIX					EXIST_MATRIX

#define STR_GRAPH_INTO_NUM_COLS	 						_L("Columns of graphs arrangement")

/// Iris 9/14/2009 QA80-14279 ADD_NOTES_TEXT_FOR_EMPTY_MISSING_MASKED_DATA_TABLE
#define STR_NO_MISSING_DATA								_L("No Missing Data")
#define STR_NO_MASKED_DATA								_L("No Masked Data")
#define STR_NOTES										_L("Notes")
///end ADD_NOTES_TEXT_FOR_EMPTY_MISSING_MASKED_DATA_TABLE

/// Zech 11/07/2011 ORG-3228-P11 PUT_NORMALITY_TEST_DATA_WORKSHEET_INTO_THE_SAME_PAGE
#define E_STR_NORMALITY_TEST_DATA_SHEET_NAME			"NormalityPlotData"		
/// END PUT_NORMALITY_TEST_DATA_WORKSHEET_INTO_THE_SAME_PAGE

enum
{
	OPAUXOBJ_GRAPHPAGE = 0,
};

/// Iris 3/24/2009 FIX_CREATE_NEW_NLFIT_FINDXY_REPORT_WHEN_RECALCULATE
enum
{
	REPORT_INVALID = -1,
	REPORT_NOT_CREATE,
	REPORT_CREATE,
};
///end FIX_CREATE_NEW_NLFIT_FINDXY_REPORT_WHEN_RECALCULATE

//#define	WKSH_OPERATION_INFO_OPERATION_DESCRIPTION			"Operation Description"
//#define	WKSH_OPERATION_INFO_DATA_SOURCE						"Input Data Source"
//#define	WKSH_OPERATION_INFO_EXECUTION_TIME					"Operation Time"
//#define	WKSH_OPERATION_INFO_USER_NAME						"User Name"

typedef	BOOL	(*PFNwks_report)(Worksheet& wksOutput, TreeNode &trRep, BOOL bBatchProcessing);

int GetTableStringGraphs(bool bTranspose = false, bool bHideRowLabel = true, bool bHideColLabel = true);


///Arvin 11/15/07 ADD_CHECKBOX_USE_SOURCE_GRAPH_COLOR_TO_SET_FITCURVES_COLOR
bool get_graph_page_names_by_plot_id(const vector<uint>& vPlotUID, vector<string>& vGPNames);
bool has_two_same_strings(const vector<string>& vString, bool bCaseSensitive = false);
///end ADD_CHECKBOX_USE_SOURCE_GRAPH_COLOR_TO_SET_FITCURVES_COLOR

/// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
OutputGUIManagerBase*	get_output_GUI_manager_pointer(const TreeNode& trGUI);
///end CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS

/// ML 11/20/2007 QA70-10716 INPUT_DATA_NODE_PROPER_LANGUAGE_WHEN_LOADING_OPER
// Returned by getLocUpdateInputDataStringsMode():
enum LUIDMODE {
	LUIDMODE_DEFAULT				= 0,
	LUIDMODE_FIXED_STRUCTURE,		// STR_LABEL_ATTRIB will be construted by the same code that constructs the tree in InitInputdataBranchFromSelection
	LUIDMODE_CUSTOM,
};
/// end INPUT_DATA_NODE_PROPER_LANGUAGE_WHEN_LOADING_OPER



// Operation that requires a worksheet as result and need reporting
class WksReportOperation : public Operation
{
public:	
	//---------------------------------------------------------------
	//virtual
	BOOL			Execute(int nExeMode = OEXEM_ON_CREATE, DWORD dwExecCntrl = 0);	//CPY 2/24/08 SPFW_NEED_BETTER_OP_EXEC_CNTRL, added dwExecCntrl
	/// YuI 11/12/08 ADDITIONAL_CLEANUP_FOR_EXECUTE_ON_CHANGE_PARAM
	//	virtual	BOOL	OnAfterExecute();///Folger 01/04/08 QA70-10890 ALWAYS_RUN_AFTER_FIT_SCRIPT_AFTER_EXECUTE
	virtual	BOOL	OnAfterExecute(int nExeMode);
	/// end ADDITIONAL_CLEANUP_FOR_EXECUTE_ON_CHANGE_PARAM
	
	//virtual 
	///Arvin 02/21/08 QA70-10929 NLEND_NEED_OUTPUT_REPORT_TABLES_TO_NOTES_WINDOW
	//int Calculate(DWORD dwExecCntrl = 0); // return 0 if no error
	int				Calculate(DWORD dwExecCntrl = 0, DWORD dwOutputCntrl = OP_OUTPUT_NONE); // return 0 if no error
	///end NLEND_NEED_OUTPUT_REPORT_TABLES_TO_NOTES_WINDOW
	//virtual 
	/// Hong 12/24/09 QA80-14832 NLFIT_OPEN_BY_HOTKEY_SOPPORT_APPLY_SETTING_FROM_QUICKFIT_WITHOUT_ANY_THEME
	//bool			Edit(bool bChangeParams, int& nAutoUpdate, LPCSTR lpcszTheme, bool bInitFromSel = true); //--CPY 10/18/06 moved from operation.h
	///Sophy 1/11/2010 SUPPORT_OPEN_NLFIT_FROM_QUICKFIT_CONTEXT_MENU
	//bool			Edit(bool bChangeParams, int& nAutoUpdate, LPCSTR lpcszTheme, bool bInitFromSel = true, bool bFromHotkey = false);
	bool			Edit(bool bChangeParams, int& nAutoUpdate, LPCSTR lpcszTheme, bool bInitFromSel = true, DWORD dwExeCtrl = 0, ODWP dwParam = 0);
	///end SUPPORT_OPEN_NLFIT_FROM_QUICKFIT_CONTEXT_MENU
	/// end NLFIT_OPEN_BY_HOTKEY_SOPPORT_APPLY_SETTING_FROM_QUICKFIT_WITHOUT_ANY_THEME
	virtual	int		OnInitOperationTreeFromOCLT(TreeNode &trOp, TreeNode& trOCLT,  bool bInitTree = true);	///Arvin 06/29/07 v8.652 XOP_NEED_SUPPORT_NLFIT

	///------ Folger 04/28/2011 ORG-2240-S1 REMOVE_FIT_RESULT_TABLE_ON_GRAPH_AFTER_DELETE_ANALYSIS
	virtual void	OnDestroy(BOOL bDeleteOutputs);
	///------ End REMOVE_FIT_RESULT_TABLE_ON_GRAPH_AFTER_DELETE_ANALYSIS
	
	/// Hong 04/14/08 v8.0842 GET_REAL_BOOK_SHEET_NAME_FROM_AUTO_TYPE
	///Cheney 2007-10-15 QA70-10522-P4 CLEAN_CODE_AND_ADD_AUTO_FOR_OUTPUT_SETTING 
	virtual	 int	GetReportOutPutDestination(const TreeNode& trInput);
	/// Hong 04/15/08 v8.0843 FITTED_DATA_AUTO_SHOULD_TRY_SOURCE_BEFORE_USING_NEW
	//virtual	 int	GetDataOutPutDestination(const TreeNode& trOutput, string& strReportBook, Worksheet* pwksReport);
	///Sophy 6/2/2008 ADD_SOURCE_BOOK_FOR_PLOT_DATA_REDISUAL_ON_MATRIX_FIT
	//virtual	 int	GetDataOutPutDestination(const TreeNode& trOutput, const TreeNode& trInput, string& strReportBook, Worksheet* pwksReport);
	virtual	 int	GetDataOutPutDestination(  TreeNode& trOp, const TreeNode& trOutput, const TreeNode& trInput, string& strReportBook, Worksheet* pwksReport);
	///end ADD_SOURCE_BOOK_FOR_PLOT_DATA_REDISUAL_ON_MATRIX_FIT
	/// end FITTED_DATA_AUTO_SHOULD_TRY_SOURCE_BEFORE_USING_NEW
	///end CLEAN_CODE_AND_ADD_AUTO_FOR_OUTPUT_SETTING
	/// end GET_REAL_BOOK_SHEET_NAME_FROM_AUTO_TYPE
	
	virtual int		GetOutputWindowType() { return OUT_WND_WKS; }
	///Sophy 7/9/2008 CLEAN_CODE_FIX_FAIL_TO_GET_INPUT_OUT_DATA_NODE_IN_OUTPUTGUIMANAGER
	virtual TreeNode	GetInputDataNode( const TreeNode& trGUI );
	virtual TreeNode	GetOutputNode( const TreeNode& trGUI );
	///end  CLEAN_CODE_FIX_FAIL_TO_GET_INPUT_OUT_DATA_NODE_IN_OUTPUTGUIMANAGER
	
	///Sophy CLEAN_CODE moved to private
	//virtual void	FilterReportForStrDump(TreeNode& trOperation); //CPY 9/2/04
	//virtual void FilterReportForStrDump(TreeNode& trOp, int nTotalNumData = 1); ///Iris 4/14/05
	///end Sophy CLEAN_CODE
	//virtual	
	BOOL			GetCustomTableThemeClassName(string &strThemeName, int nCustomIndex = 0);	
	/// YuI 10/11/06 USE_CLONE_OF_CALCULATIONS_TO_GENERATE_REPORT
	//	void FilterReport(TreeNode& trOp);//---- CPY 9/22/05 QA70-8015-P15 USE_SET_REPORT_TREE_TO_INTERNALLY_PUT_TREE_INTO_FLAT_SHEET
	///Arvin 02/09/07 SET_REPORT_TREE_SHOULD_USE_DIFFERENT_VALUE_FOR_FLAT_AND_NOFLAT_SHEET
	//DWORD 	FilterAndGenerateReport(Datasheet& ds, TreeNode& trReport, int nNumInHeading = 0, BOOL bCheckIDRange = TRUE);
	
	///Sophy CLEAN_CODE moved to private
	//------ Folger 05/22/08 QA80-11574 SUPPORT_GET_ALL_OPERATION_OUTPUT_SHEET_NAME_WITH_GLOBAL_STRING_VARIABLES
	//DWORD 	FilterAndGenerateReport(Datasheet& ds, TreeNode& trReport, int nNumInHeading = 0, BOOL bCheckIDRange = TRUE, BOOL bHierarchy = FALSE);
	//DWORD 	FilterAndGenerateReport(Datasheet& ds, TreeNode& trReport, int nNumInHeading = 0, BOOL bCheckIDRange = TRUE, BOOL bHierarchy = FALSE, int nOuputOption = OUTPUT_PARTIAL_REGRESSION_CURVES_SHEET);
	//------
	///end Sophy CLEAN_CODE

	///END 		SET_REPORT_TREE_SHOULD_USE_DIFFERENT_VALUE_FOR_FLAT_AND_NOFLAT_SHEET
	///Sophy CLEAN_CODE moved to private
	//void 	FilterReport(TreeNode& trReport, BOOL bCheckIDRange = TRUE);//---- CPY 9/22/05 QA70-8015-P15 USE_SET_REPORT_TREE_TO_INTERNALLY_PUT_TREE_INTO_FLAT_SHEET
	///end Sophy CLEAN_CODE
	/// end USE_CLONE_OF_CALCULATIONS_TO_GENERATE_REPORT
	//virtual
	void			FilterReportForExternal(TreeNode& trOp); ///----- CPY 3/31/2007 NLFIT_REPORT_FROM_OC
	//virtual 
	/// Hong 12/24/09 QA80-14832 NLFIT_OPEN_BY_HOTKEY_SOPPORT_APPLY_SETTING_FROM_QUICKFIT_WITHOUT_ANY_THEME
	//BOOL			OperationtoGUI(TreeNode& trOperation, bool bInit, string* pstrSelectedTheme = NULL, bool bSetDefaultInputOnInit = true);
	///Sophy 1/11/2010 SUPPORT_OPEN_NLFIT_FROM_QUICKFIT_CONTEXT_MENU
	//BOOL			OperationtoGUI(TreeNode& trOperation, bool bInit, string* pstrSelectedTheme = NULL, bool bSetDefaultInputOnInit = true, bool bFromHotkey = false);
	BOOL			OperationtoGUI(TreeNode& trOperation, bool bInit, string* pstrSelectedTheme = NULL, bool bSetDefaultInputOnInit = true, DWORD dwExeCtrl = 0, ODWP dwParam = 0);
	///end SUPPORT_OPEN_NLFIT_FROM_QUICKFIT_CONTEXT_MENU
	/// end NLFIT_OPEN_BY_HOTKEY_SOPPORT_APPLY_SETTING_FROM_QUICKFIT_WITHOUT_ANY_THEME
	//virtual 
	BOOL			GUItoOperation(TreeNode& trOperation, int nFrom = GUI_OP_NEW);

	///Sophy CLEAN_CODE moved to private
	///Arvin 08/28/07 QA70-10073 ALWAYS_REPLOT_HISTOGRAM_AND_BOXCHART_IF_PLOT_IN_ONE_GRAPH_NODE_VALID
	//bool IsTreeNodePlotInOneGraphValid(TreeNode& trOperation);
	///end ALWAYS_REPLOT_HISTOGRAM_AND_BOXCHART_IF_PLOT_IN_ONE_GRAPH_NODE_VALID
	///end Sophy CLEAN_CODE
	///Arvin 10/24/06 FITTING_HISTOGRAM_PLOT
	///Sophy CLEAN_CODE moved to private
	/// Iris 01/08/2007 v8.0538 REPORT_GRAPHS_ARRANGEMENT
	//virtual bool CheckCreateImagSubNodes(TreeNode& trOp, int nGraphIndex, int nDataIndex, TreeNode& trPict, TreeNode& trPlotInfo, LPCSTR lpcszLabel);	
	//virtual bool CheckCreateImagSubNodes(TreeNode& trOp, int nGraphIndex, TreeNode& trPict, TreeNode& trPlotInfo);	
	///end REPORT_GRAPHS_ARRANGEMENT
	///end Sophy CLEAN_CODE


	///Arvin 10/16/06 MOVE_TO_OPERATION_FILE
	void			SetTree(TreeNode& trOperation);
	///end MOVE_TO_OPERATION_FILE
	/// YuI 11/08/06 OPERATION_TREE_NEED_TO_BE_UPDATED_FROM_INPUT
	virtual void	GetTree(TreeNode& trOperation);
	/// end OPERATION_TREE_NEED_TO_BE_UPDATED_FROM_INPUT
	
	///Arvin 11/30/06 CLEAN_ALL_RESULTS_CURVES_SHEETSCODE
	///Cheney 2007-5-4 FITCURVE_AND_RESIDUAL_COULD_PUT_INTO_MAT_LAYER_WHEN_FIT_MAT
	//virtual void  DoAllResultsCurveSheet(TreeNode& trOperation, int nTotalNumData, Worksheet& wksInputFirstRange, Worksheet& wksOutput,Worksheet& wksFitCurve, bool bCreateResultsCurveSheet, bool bCreateResidualCurveSheet);
	///Arvin 05/24/07 SHOULD_NOT_CREATE_NEW_SHEET_WHILE_CHANGE_PARAMETER_FROM_COMBINED_REPORT
	//virtual void  DoAllResultsCurveSheet(TreeNode& trOperation, int nTotalNumData, Datasheet& dsInputFirstRange, Worksheet& wksOutput, Datasheet& dsFitCurve, bool bCreateResultsCurveSheet, bool bCreateResidualCurveSheet);
	/// Hong 04/14/08 v8.0840c PEAK_FIT_REPORT_PEAK_CHARACTERISTICS_TO_SEPARATE_SHEET
	//virtual void  DoAllResultsCurveSheet(TreeNode& trOperation, int nTotalNumData, Datasheet& dsInputFirstRange, Worksheet& wksOutput, Datasheet& dsFitCurve, bool bCreateResultsCurveSheet, bool bCreateResidualCurveSheet, int nExeMode);
	///Sophy CLEAN_CODE moved to private
	//virtual void  DoAllResultsCurveSheet(TreeNode& trOperation, int nTotalNumData, Datasheet& dsInputFirstRange, Worksheet& wksOutput, Datasheet& dsFitCurve, bool bCreateResultsCurveSheet, bool bCreateResidualCurveSheet, bool bCreatePeakCharacterSheet, int nExeMode);
	///end Sophy CLEAN_CODE
	/// end PEAK_FIT_REPORT_PEAK_CHARACTERISTICS_TO_SEPARATE_SHEET
	///END SHOULD_NOT_CREATE_NEW_SHEET_WHILE_CHANGE_PARAMETER_FROM_COMBINED_REPORT
	///end CLEAN_ALL_RESULTS_CURVES_SHEETSCODE
	
	///Sophy CLEAN_CODE moved to private
	///Arvin 05/30/07 v8.0629 ONE_SHEET_CALL_ONE_TIME_SET_REPORT_TREE 
	//int 	GetTotalNumSeparateSheet(const TreeNode& trOp);
	///end ONE_SHEET_CALL_ONE_TIME_SET_REPORT_TREE
	///end Sophy CLEAN_CODE
	///Arvin 05/31/07 CLEAR_REPORT_DATA_BEFOR_CALC_WHEN_DO_CHANGE_PARAMS
	virtual	void	ClearOutputTables(TreeNode& trOperation);
	///end CLEAR_REPORT_DATA_BEFOR_CALC_WHEN_DO_CHANGE_PARAMS
	///Arvin 05/25/07 CLEAN_SURPLUS_REPORT_DATA_WHILE_CHANGE_PARAMETER_TO_LESS_DATASET //moved to private
	//void 	CleanAllSurplusReportData(TreeNode& trOp);
	///end CLEAN_SURPLUS_REPORT_DATA_WHILE_CHANGE_PARAMETER_TO_LESS_DATASET	
			
	///Arvin 02/22/08 QA70-11151 SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION	
#ifdef SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION
	///---Sim 04-07-2008 QA80-11371 THEME_SAVING_OPTIONS
	//virtual  bool   ConstructParamBranchByThemeTree(const TreeNode& trTheme, TreeNode& trOp, string* pstrSelectedTheme) {return false;}
	//virtual bool ApplyThemeFilterSetting(TreeNode& trGUI, const TreeNode& trThemeFilter) {return false;}
	virtual	bool	ApplyTheme(LPCSTR lpcszClassName, TreeNode& trGUI, LPCSTR lpcszThemeName, bool bLoadFactDefault = true);
	///---END QA80-11371 THEME_SAVING_OPTIONS
#endif
	///end SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION	
	///Sophy 11/28/2008 v8.980d CHANGE_PARAM_SHOULD_KEEP_BRAHCH_ENABLE_WHEN_CURVE_NOT_REPORTED_BEFORE
	bool			HasOutput(int nOutputIndex, int nDataIndex = 0);
	///end CHANGE_PARAM_SHOULD_KEEP_BRAHCH_ENABLE_WHEN_CURVE_NOT_REPORTED_BEFORE

	///------ Folger 06/02/2011 ORG-2858 SUPPORT_DUPLICATE_ANALYSIS_OPERATION
	virtual	BOOL	DuplicateAnalysis(BOOL bDialog);
	///------ End SUPPORT_DUPLICATE_ANALYSIS_OPERATION

	///Kyle 08/19/2011 ORG-2741-S1 SUPPORT_DUPLICATE_ANALYSIS_OPERATION_IN_WORKSHEET
	virtual BOOL	DuplicateWksAnalysis(BOOL bDialog);
	virtual BOOL	DuplicateGraphAnalysis(BOOL bDialog);
	///End SUPPORT_DUPLICATE_ANALYSIS_OPERATION_IN_WORKSHEET

	///------ Folger 05/15/2012 ORG-5661-P1 OGW_WITH_OPERATIONS_BECAME_TOO_LARGE_EVEN_CLEAR_INPUT_DATA
	virtual void	OnClearOperationData();
	///------ End OGW_WITH_OPERATIONS_BECAME_TOO_LARGE_EVEN_CLEAR_INPUT_DATA
	
	///Philip 08/22/2012 ORG-6527-S4 NOTES_TABLE_ADD_ITERATION_ALGORITHM
	virtual bool UpdateIterationAlgorithmNote(TreeNode& trTable, const TreeNode& trOperation);
	///end NOTES_TABLE_ADD_ITERATION_ALGORITHM
	
protected:	
	/// Iris 7/30/2012 ORG-6279-P1 IMPROVE_ODR_RESIDUAL_REPORT_DATA_LONGNAME_AND_LEGEND_OF_GRAPH
	virtual string  GetReportGraphLegendMode(TreeNode& trOp, int nGraphIndex) { return "@LG"; }
	///End IMPROVE_ODR_RESIDUAL_REPORT_DATA_LONGNAME_AND_LEGEND_OF_GRAPH
	
	/// Iris 12/16/2011 ORG-4629-P1 FIX_MEAN_COMP_PLOT_NOT_SAME_WITH_75
	virtual string 	GetReportGraphErrorMsg(TreeNode &trOp, int nGraphIndex) { return STR_ERRINFO_OF_REPORT_GRAPH_FAILURE; }
	///End FIX_MEAN_COMP_PLOT_NOT_SAME_WITH_75
	
	/// Iris 3/25/2011 ORG-2515-P2 FIX_SWITCH_XY_DATATYPE_FROM_LINEAR_TO_SAMEASINPUT_FOR_SURFACE_FIT_WITH_CONTOUR_GRAPH_CRASH
	// moved from private to protected
	void			setSourceGraphIdUIDtoMap(TreeNode &trOp, int nGraphIndex, int nPicIndex, DWORD dwGraphUID);
	bool			hasPlottedOnSourceGraph(TreeNode &trOp, int nGraphIndex, int nPicIndex, BOOL bCheckUIDOnly = FALSE);
	///End FIX_SWITCH_XY_DATATYPE_FROM_LINEAR_TO_SAMEASINPUT_FOR_SURFACE_FIT_WITH_CONTOUR_GRAPH_CRASH
	
	virtual bool	IsPlotStatsGraph(TreeNode& trOp) { return false; } /// Iris 11/09/2009 QA81-14599 IMPROVE_STATS_ON_COLS_CALCULATION_SPEED
	virtual	string	GetReportTableGUIName(TreeNode& trGUI);
	virtual string  GetResultCurveGUIName(TreeNode& trGUI);
	virtual bool	IsReportCalibrationTable() {return true;}
	virtual DWORD	GetReportDataRules(TreeNode &trOp, int nGraphIndex); /// Iris 08/09/2007 v8.0677 FIX_FAIL_REPORT_GRAPH_PLOTS_IN_ANOVA	
	virtual DWORD   GetSourceDataPlotPlottingRules(TreeNode &trOp) { return ADDPLTPFROMPLT_ERRORBAR; }
	
	/// Iris 3/23/2009 QA80-13331-P1 CENTRILIZE_REPORT_COL_LABEL_CODES
	///------ Folger 05/23/2012 ORG-5592-S1 ADD_DATA_IDENTIFIER_FOR_FITTING_TOOLS
	//string ConstructReportDataColLabel(LPCSTR lpcszAnalysis, LPCSTR lpcszData);
	string ConstructReportDataColLabel(LPCSTR lpcszAnalysis, LPCSTR lpcszData, BOOL bSimpleForm = FALSE);
	///------ End ADD_DATA_IDENTIFIER_FOR_FITTING_TOOLS
	///end CENTRILIZE_REPORT_COL_LABEL_CODES

	/// Iris 9/10/2009 QA80-11710-P2 IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
	/// Iris 10/18/2011 ORG-4125-P1 FIX_PLOT_SAME_GRAPH_IN_ONE_GRAPH_FAILED_FOR_MULTI_FACTORS_DATA
	//int 	GetNumFactors(TreeNode& trOp, int* pn2ndGroupNumFactors = NULL); 
	int 	GetNumFactors(TreeNode& trOp, bool bCheckTrimMissedGroup = true); 
	///End FIX_PLOT_SAME_GRAPH_IN_ONE_GRAPH_FAILED_FOR_MULTI_FACTORS_DATA
	int  	GetNumPlotsInOneGraph(TreeNode& trOp, int nGraphIndex = -1);
	///end IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA

	BOOL	MakeFullRangeEscapeString(string& str);
	
	///Arvin 01/29/08 GENERATE_REPORT_FOR_LT_NLFit
	/// Hong 01/12/10 QA80-14948 NLFIT_SUPPORT_OK_BTN_WHICH_DONOT_FIT_AGAIN
	//virtual BOOL 	GetExecuteCtrl(const TreeNode& trFitWorkArea, DWORD& dwExecCntrl) { return FALSE;}
	virtual BOOL 	GetExecuteCtrl(const TreeNode& trOperation, DWORD& dwExecCntrl) { return FALSE;}
	/// end NLFIT_SUPPORT_OK_BTN_WHICH_DONOT_FIT_AGAIN
	///end GENERATE_REPORT_FOR_LT_NLFit
	/// YuI 09/10/07 QA70-10358 ANOVA_RECALCULATE_FAILS_AFTER_RENAME
	virtual DWORD	GetDWCTRLForUpdateInputDataTree()	{return TREE_COPY_BY_NAME_AND_ORDER;}
	/// end ANOVA_RECALCULATE_FAILS_AFTER_RENAME
	
	/// ML 11/10/2006 NLFIT_MODAL_CLEANUP
	virtual	BOOL	PostExecute(int nExeMode, BOOL bExeRet){ return bExeRet;}
	/// end NLFIT_MODAL_CLEANUP
	//virtual 
	BOOL			Construct(TreeNode& trOperation, int nOption = 0);
	//---- CPY 9/22/05 QA70-8015-P15 USE_SET_REPORT_TREE_TO_INTERNALLY_PUT_TREE_INTO_FLAT_SHEET
	///Cheney 2007-4-2 FIX_ALWAYS_SHOW_LAST_DATASET_MISSING_MASKED_DATA_WHEN_MULTI_DATASET_FITTING
	//bool	AddRowsToMaskedOrMissingDataTable(TreeNode& trCol, const vectorbase& vData, int nBaseID, LPCSTR lpcszRowLabel);
	bool			AddRowsToMaskedOrMissingDataTable(TreeNode& trCol, const vectorbase& vData, int nBaseID, LPCSTR lpcszRowLabel, int* pRowStart = NULL);
	///end FIX_ALWAYS_SHOW_LAST_DATASET_MISSING_MASKED_DATA_WHEN_MULTI_DATASET_FITTING_
	///Cheney 2007-4-12 ALL_FITTING_TOOLS_NEED_FOOTNOTE_FOR_MISSING_AND_MASKED_DATA
	virtual bool 	AddHintsForMissingAndMasked(TreeNode& trOperation){return true;}
	///end ALL_FITTING_TOOLS_NEED_FOOTNOTE_FOR_MISSING_AND_MASKED_DATA
	
	///Cheney 2007-4-20 OVERLOAD_SHOWDLG_FOR_FIX_BUG_OF_OP_DLG_CAN_NOT_OPEN
	//virtual
	bool			ShowDlg(TreeNode& trOperation, BOOL bChangeParams);
 	///end OVERLOAD_SHOWDLG_FOR_FIX_BUG_OF_OP_DLG_CAN_NOT_OPEN

 	virtual bool	SourceRowIndicesNeeded() { return false; }
 	
 	///Cheney 2007-5-23 QA70-9805 SPEED_UP_STATISTIC_ON_ROW
 	virtual TreeNode	GetResultLogTree(TreeNode& trOp){ return trOp.Calculation;}
 	///end SPEED_UP_STATISTIC_ON_ROW
 		
	virtual void	ThemeUpdateLastUsed(LPCSTR lpcszClassName, TreeNode& tr, bool bThemesTree = false); ///Cheney 2007-8-1 CORRECT_LOGIC_OF_LOADING_THEME
	//virtual DWORD GetReportDataRules(TreeNode &trOp, int nGraphIndex); /// Iris 08/09/2007 v8.0677 FIX_FAIL_REPORT_GRAPH_PLOTS_IN_ANOVA //moved to private
	virtual BOOL	UpdateCalibrationBranch(TreeNode& trOperation){return true;}  ///Cheney 2007-9-6 FINDZ_NODE_SHOULD_PREPARED_WHEN_CHANGE_PARAM	
	///Cheney 2007-9-21 QA70-10376 MATRIX_FTTING_SUPPORT_GET_MISSING_DATA_IN_REPORT
	virtual  void	PrepareMissingOrMaskedTable(TreeNode& trTable, TreeNode& trRows, 
						LPCSTR lpcszTagRows, int idRows, TreeNode& trMain, LPCSTR lpcszTagMain, int idMain,
						LPCSTR lpcszTableLabel, TreeNode& trCols, LPCSTR lpcszTagCols, int idCols);
						
	virtual  int	GetMissingDataAndIndex(const DataRange& dr, LPCSTR lpcszXDataLabel, DWORD dwRules, int index,
						vector<int>& vintRows, vector& vMain, vector& vX, matrix& mMultiIndep, vector& vWeight, 
						vector& vYIndep, vector<int>& vintCols
						///------ Folger 09/06/2011 ORG-3706-P1 SUPPRT_SHOW_XERROR_IN_MASKED_DATA_AND_BAD_DATA_REPORT_TABLE
						, vector* pvErrIndep = NULL
						///------ End SUPPRT_SHOW_XERROR_IN_MASKED_DATA_AND_BAD_DATA_REPORT_TABLE
						/// Zech 08/22/2012 ORG-5703-P1 OPERATION_SUPPORT_IGNORE_HIDDEN_ROW
						, DWORD dwRules2 = 0
						/// END OPERATION_SUPPORT_IGNORE_HIDDEN_ROW
						);
		
	virtual	 bool	AddColsIndexToMissingDataTable(TreeNode& trCol, const vectorbase& vData, int nBaseID, LPCSTR lpcszRowLabel, int* pRowStart = NULL){return true;}
	///end MATRIX_FTTING_SUPPORT_GET_MISSING_DATA_IN_REPORT
	/// Hong 04/14/08 v8.0842 GET_REAL_BOOK_SHEET_NAME_FROM_AUTO_TYPE
	/////Cheney 2007-10-15 QA70-10522-P4 CLEAN_CODE_AND_ADD_AUTO_FOR_OUTPUT_SETTING 
	//virtual	 int	GetReportOutPutDestination(const TreeNode& trInput);
	//virtual	 int	GetDataOutPutDestination(const TreeNode& trOutput, string& strReportBook, Worksheet* pwksReport);
	/////end CLEAN_CODE_AND_ADD_AUTO_FOR_OUTPUT_SETTING
	/// end GET_REAL_BOOK_SHEET_NAME_FROM_AUTO_TYPE
		
	virtual bool	AllowReportEmptyResultCurve() { return false; } /// Iris 4/23/2008 FIX_NO_FIND_XY_REPORT
	///Arvin 01/07/08 QA70-10903 ADD_CHECK_ALL_BOX_FOR_BRANCH
	virtual bool	AddCheckAllBoxForOptionalReport(TreeNode& trOptionalReport){	return tree_set_branch_attribute_for_branch(trOptionalReport, GETNBRANCH_CHECK_CONTROL|GETNBRANCH_CHECK_CONTROL_ONE_EVENT);}
	virtual bool	AddCheckAllBoxForPlotsNode(TreeNode& trPlots) { return false; }
	///end ADD_CHECK_ALL_BOX_FOR_BRANCH

	
	///Arvin 02/13/07 SET_BIN_DATA_WITH_SAME_MIN_MAX_AND_BINSIZE_WHEN_PLOT_ALL_HISTOGRAM_IN_ONE_GRAPH
	virtual bool	GetCombinedMinMaxAndBinNumber(TreeNode & trOp, double& dMin, double& dMax){return false;}
	//void 	SetGraphLayerXScale(GraphPage& gp, int nLayerIndex, double dxMin, double dxMax); //moved to private
	///end SET_BIN_DATA_WITH_SAME_MIN_MAX_AND_BINSIZE_WHEN_PLOT_ALL_HISTOGRAM_IN_ONE_GRAPH
	
	//virtual TreeNode CopyResultCurves(TreeNode& trOperation, Tree& trCopy, int nDataIndex, int nTotalNumData);
	virtual TreeNode	GetResultCurvesBranch(TreeNode& trOp, int nDataIndex, int nTotalNumData, int nOutputRangeIndex = OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET, LPCSTR lpcszDataLabelToCreate = NULL);
	/// Iris 10/20/05 MOVE_REPORT_GRAPH_CODES_TO_BASE_CLASS
	//{
	//	TreeNode trJunk; return trJunk;
	//}
	//End MOVE_REPORT_GRAPH_CODES_TO_BASE_CLASS
	/// Sophy 5/05/2008 QA80-10934-P5 v8.0856 SUPPORT_SEPARATE_FINDXY_OUTPUT_SHEET_NAME
	virtual TreeNode	GetSheetNameNode( TreeNode& trBookSheetBranch, int nIndex = 0);
	/// End SUPPORT_SEPARATE_FINDXY_OUTPUT_SHEET_NAME
	//---- Iris 10/13/06 v8.0495 OUTPUT_FIT_CURVE_TO_SOURCE_NOT_WORK
	/*
	/// Iris 9/13/06 QA70-8973 REPORT_RESIDUAL_DATA_IN_SEP_REPORT_SHEET
	//bool GetResultCurvesDataRange(TreeNode& trOp, DataRange& dr, int nDataIndex, int nGraphTableID);
	bool GetResultCurvesDataRange(TreeNode& trOp, DataRange& dr, int nDataIndex, int nGraphTableID, int nOutputIndex = OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET);
	///End REPORT_RESIDUAL_DATA_IN_SEP_REPORT_SHEET
	*/
	bool				GetResultCurvesDataRange(TreeNode& trOp, DataRange& dr, int nDataIndex, int nGraphIndex, int nOutputIndex = OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET);
	//---- 
	
	virtual bool		IsGraphTableInsertBackToSourceType(int nGraphIndex) {return true;}
	//-----
	
	/// Iris 10/20/05 MOVE_REPORT_GRAPH_CODES_TO_BASE_CLASS
	virtual TreeNode 	GetOneResultCurvesTable(const TreeNode& trOp, int nDataIndex, int nTotalNumData, int nGraphIndex);
	///Arvin 11/16/07 QA70-10676 UPDATE_MEANS_COMPARISION_PLOT_LEGENT_WITH_SIG_INFO
	//virtual TreeNode	CheckCreateOneResultCurvesTable(TreeNode& trOp, int nDataIndex, int nTotalNumData, int nGraphIndex, LPCSTR lpcszTableName, int nTableID, LPCSTR lpcszTableLabel = NULL, LPCSTR lpcszDataLabel = NULL);
	virtual TreeNode	CheckCreateOneResultCurvesTable(TreeNode& trOp, int nDataIndex, int nTotalNumData, int nGraphIndex, LPCSTR lpcszTableName, int nTableID, LPCSTR lpcszTableLabel = NULL, LPCSTR lpcszMainTableLabel = NULL, bool bNeedMakeID = true);
	///end UPDATE_MEANS_COMPARISION_PLOT_LEGENT_WITH_SIG_INFO
	
	int 				GetOneResultCurvesTableID(int nBaseID, int nDataIndex);

	virtual string		GetOneResultCurvesTableTagName(int nGraphIndex) { string strJunk; return strJunk;}
	///End MOVE_REPORT_GRAPH_CODES_TO_BASE_CLASS
	
	virtual	int			GetResultCurvesID() { return 0;}	//---- CPY 10/17/04 SEPARATE_FIT_CURVE_INTO_SEPARATE_BRANCH
	/// Iris 9/13/06 QA70-8973 REPORT_RESIDUAL_DATA_IN_SEP_REPORT_SHEET
	//virtual
	virtual int			GetResidualCurvesID() { return 0;}
	virtual int			GetPartialCurvesID() { return 0;}
	virtual int			GetFindXYID(){ return 0;}///Jasmine 09/20/06 QA70-8973 MODIFICATION_OUTPUT_BRANCH, add FindXY output branch 
	virtual bool		IsResidualGraph(int nGraphIndex) { return false; }
	virtual int			GetOutputRangeIndex(TreeNode& trOp, int nGraphIndex = GRAPH_FIT_CURVE);
	int					GetOneSetResultCurvesID(int nGraphIndex = GRAPH_FIT_CURVE);
	virtual string		GetResultCurveSheetName(TreeNode& trOperation, int nIndex = 0, int nOption = OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET);	
	/// Sophy 5/05/2008 QA80-10934-P5 v8.0856 SUPPORT_SEPARATE_FINDXY_OUTPUT_SHEET_NAME
	//virtual void 	GetResultCurveBookSheetName(TreeNode& trOperation, string& strBookName, string& strSheetName, int nIndex = 0, int nOption = OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET, bool bSeparateSheetForDataset = false);
	virtual void		GetResultCurveBookSheetName(TreeNode& trOperation, string& strBookName, string& strSheetName, int nIndex = 0, int nOption = OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET, bool bSeparateSheetForDataset = false, int nSheetNameIndex = 0);
	/// End SUPPORT_SEPARATE_FINDXY_OUTPUT_SHEET_NAME
	///end REPORT_RESIDUAL_DATA_IN_SEP_REPORT_SHEET	

	/// Iris 05/08/2007 v8.0613 PROPER_REPORT_SHEET_NAME
	virtual string		GetResultCurveSheetFullName(TreeNode& trOperation, int nIndex = 0, int nOption = OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET);	
	///end PROPER_REPORT_SHEET_NAME	
	
	/// Iris 4/01/2008 v8.0829 QA80-10934 ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME_AFTER_CLEAN_OUTPUT_GUI_CODES
	/// Iris 4/11/2008 SET_BOTH_LONG_NAME_AND_SHORT_NAME_FOR_REPORT_BOOK
	//string	GetResultCurveBookFullName(TreeNode& trOperation, int nIndex = 0, int nOption = -1, bool bSeparateSheetForDataset = false);
	//string	GetResultCurveBookLongName(TreeNode& trOperation, int nIndex = 0, int nOption = -1, bool bSeparateSheetForDataset = false);//moved to private
	///end SET_BOTH_LONG_NAME_AND_SHORT_NAME_FOR_REPORT_BOOK
	///end ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME_AFTER_CLEAN_OUTPUT_GUI_CODES
	virtual string		GetResultCurveBookShortName(TreeNode& trOperation, int nIndex = 0, int nOption = -1);
	
	//----- CPY 6/9/04 MOVE_REPORT_BRANCH_TO_BASE_CLASS	
	// GUI tree common nodes added to the bottom
	//virtual void ConstructAddReportCommon(TreeNode& trGUI, DWORD dwOptions, int nID, bool bAddCommon = true);
	///Iris 4/06/05 INIT_GRAPH_NUMBER
	virtual void		ConstructAddReportCommon(TreeNode& trOperation, DWORD dwOptions, int nID, bool bAddCommon = true);
	
#ifdef OP_DLG_TOTALLY_NEW_STRUCTURE
	virtual void 		ConstructAddReportGraphsOptions(TreeNode& trOp, DWORD dwOptions);
#endif
	///Sophy 11/2/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
	void				UpdateReportGraphsLabels(TreeNode& trOp);
	///end OP_DLG_NEW_STRUCTURE
	
	virtual int			ConstructGraphNumber();  ///Iris 4/06/05 INIT_GRAPH_NUMBER

	///Iris 6/03/05 CENTRALIZE_TO_GET_GRAPH_GUI_NODE
	virtual TreeNode	GetGUIGraphNodes(const TreeNode& trOp, int nGraphIndex = 0); 
	///Arvin 10/22/07 ADD_CHECKBOX_USE_SOURCE_GRAPH_COLOR_TO_SET_FITCURVES_COLOR
	/// YuI 06/06/08 QA70-11619 MORE_CLEAR_WORKSHEET_PROBLEM
	virtual TreeNode	GetGUIGraphNodesEx(const TreeNode& trGUI, int nGraphIndex = 0); 
	/// end MORE_CLEAR_WORKSHEET_PROBLEM
	//virtual int GetCurveLineColor(const TreeNode& trOp, int nCurveIndex = 0); 
	virtual int			GetCurveLineColor(const TreeNode& trOp, int nCurveIndex = 0, int nDataIndex = 0, bool bIsSourceGraph = false); 
	///end ADD_CHECKBOX_USE_SOURCE_GRAPH_COLOR_TO_SET_FITCURVES_COLOR
	///end CENTRALIZE_TO_GET_GRAPH_GUI_NODE
	
	///Arvin 11/15/07 ADD_CHECKBOX_USE_SOURCE_GRAPH_COLOR_TO_SET_FITCURVES_COLOR
	//bool IsMultiPlotFit(TreeNode trGUI);//moved to private
	///end ADD_CHECKBOX_USE_SOURCE_GRAPH_COLOR_TO_SET_FITCURVES_COLOR
	
	//virtual int GetNumGraphs(TreeNode& trOp);	//-------- CPY 12/31/04 PICTURE_IN_REPORT_IN_BASE_CLASS
	virtual int			GetNumGraphs();				///Iris 6/04/05 MOVE_FITTED_CURVES_TO_ROOT_LEVEL
	
	virtual	int			PlotInputData(DataRange &rngInput, const TreeNode& trOp, GraphLayer& gl, int index, int nPlotType = IDM_PLOT_SCATTER, int iIndep = 0, int iDep = 0);/// ML 10/2/2006 NLFIT_CURVES_CLEANUP
		

	
	virtual bool		SetupPlotDetails(const TreeNode& trOp, GraphLayer& gl, int nFittedPlot, int nNumPlots = 1, int nGraphIndex = 0, int nDataIndex = 0, bool bIsSourceGraph = false, bool bUpdateExistedReportGraph = false);  /// Iris 5/19/05 QA70-6365 SETUP_FITY_CONFID_PRODI_LINE_COLOR
	
	/// Joesph/Iris 9/26/06 QA70-7120 MOVE_CUSTOM_TABLE_TO_SEPARATE_SHEET
	/*
	/// ML 6/7/2006 QA70-4434 CUSTOM_TABLES_FOR_FIND_XY
	//TreeNode addCustomTableToReport(TreeNode& trOperation, int nCustomTable = 0);	//--- CPY 11/19/04 QA70-7121 CUSTOM_REPORT_TABLES
	/// ML 7/21/2006 QA70-4434 CUSTOM_TABLES_FOR_FIND_XY_HOOKING_IMPLEMENTING_COLUMN_FORMULA
	//TreeNode addCustomTableToReport(TreeNode& trOperation, int nCustomTable = 0, bool *pbEnabled = NULL);
	TreeNode addCustomTableToReport(TreeNode& trOperation, int nCustomTable = 0, bool *pbEnabled = NULL, int nAuxIndex = -1, LPCSTR lpcszLabel = NULL, TreeNode &trParent = NULL);
	/// end CUSTOM_TABLES_FOR_FIND_XY_HOOKING_IMPLEMENTING_COLUMN_FORMULA
	/// end CUSTOM_TABLES_FOR_FIND_XY
	*/
	bool				AddCustomTableToReport(TreeNode& trOp, TreeNode &trCustom, int nCustomIndex);
	///end MOVE_CUSTOM_TABLE_TO_SEPARATE_SHEET
	
	/// YuI 08/15/06 MORE_WORK_ON_STATISTICAL_PLOTS
	void				GetDataPlotEventHandlerName(string& strName, int nDataIndex);
	/// end MORE_WORK_ON_STATISTICAL_PLOTS
	
	
	///Arvin 07/09/07 v8.0655 FITTING_ON_GRAPH_FROM_EXCEL_SHOULD_NOT_OUTPUT_TO_SOURCE
	//----- CPY 10/12/07 10522-P3 CLEANUP_IF_LOOSE_DATASET_SHOULD_NOT_PUT_REPORT_SHEET_TO_SOURCE
	//bool IsInputDataFromExcel(const TreeNode& trGUI);
	//-----
	///end FITTING_ON_GRAPH_FROM_EXCEL_SHOULD_NOT_OUTPUT_TO_SOURCE
	
	///Arvin 10/16/06 MOVE_TO_SUBCLASS
	bool				GUIPrepareOutputBranch(TreeNode& trGUI, Worksheet& wksReport = NULL);
	bool				OnBeforeCalcMultiDataLoop(TreeNode& trOp, const DataRange& drInput, int nTotalNumData, vector<int>& vFactorSizes);
	void				OnAfterCalculations(TreeNode& trOperation);	
	/// Iris 11/16/06 ADD_PARAMETER_SETTING_TO_THEME
	virtual bool		ParamsFromGUItoOperation(TreeNode& trOperation) { return false; }
	///end ADD_PARAMETER_SETTING_TO_THEME
	///Cheney 2007-3-29 SUPPORT_MATRIX_FIT_WHEN_USE_DIALOG	
	virtual bool		IsAddMaskedOrMissingDataTableForMultiIndep(vector& vX, matrix& mMultiIndep);
	///end SUPPORT_MATRIX_FIT_WHEN_USE_DIALOG
	
	///Cheney 2007-4-13 FIX_BUG_OF_CUSTOM_TABLE_DISAPPEAR_WHEN_CONCATENATE
	virtual int			GetDelColNum(TreeNode& trOp, int nGraphIndex){return -1}
	///end FIX_BUG_OF_CUSTOM_TABLE_DISAPPEAR_WHEN_CONCATENATE
	
	///Arvin  01/31/08 ANOVA_REPORT_DATA_SHOULD_NOT_OUTPUT_TO_SOURCE 
	virtual bool		IsAllowReportToSource(TreeNode& trGUI);
	///end ANOVA_REPORT_DATA_SHOULD_NOT_OUTPUT_TO_SOURCE
	
	//------ Folger 03/12/08 QA80-11244 SURFACE_FIT_REPORT_SHOULD_USE_CONTOUR_PLOTS
	/*
	virtual	bool	SetupSourceDataPlot(DataPlot &dp, vector *pZ = NULL, int nSteps = 16) { return true }
	virtual	bool	SetupFitCurvesPlot(DataPlot &dp, vector &vZ, int nColor = SYSCOLOR_RED) { return true }
	virtual bool	SetupResidualPlot(DataPlot& dp, vector& zz, double irl = 20, double orl = 5, int nInnersteps = 8, int nOutSteps = 20) { return true; }
	*/
	virtual	bool		SetupPlotsAfterRescale(GraphLayer &gl, int nGraphIndex)	{ return false; }
	//------
	
	/// Iris 7/29/2009 QA80-14029 FAIL_CHANGE_INNER_OUTTER_RESIDUAL_LIMIT_ON_CHANGE_PARAM
	virtual void		SetupPlotsOnRecalculate(GraphLayer& gl, int nGraphIndex) { }
	///end FAIL_CHANGE_INNER_OUTTER_RESIDUAL_LIMIT_ON_CHANGE_PARAM
	
	//------ Folger 03/19/08 QA80-10598 NEW_GETN_LOCALIZAED_CHECK_MACRO
	void				FilterStatsReport(const TreeNode &trQuantities, const TreeNode &trCalculation);
	//------	
	/// ML 1/26/2005 CUSTOM_TABLE_TO_GRAPH
	/// ML 4/28/2006 FRIENDLY_CUSTOM_TABLE_THEME_GENERATION
	//TreeNode getOrCreateCustomTable(TreeNode& trOp, int nCustomIndex = 0);
	/// ML 7/21/2006 QA70-4434 CUSTOM_TABLES_FOR_FIND_XY_HOOKING_IMPLEMENTING_COLUMN_FORMULA
	//TreeNode getOrCreateCustomTable(TreeNode& trOp, int nCustomIndex = 0, bool *pbEnabled = NULL, bool bHideColLabels = true);
	TreeNode			GetOrCreateCustomTable(TreeNode& trOp, int nCustomIndex = 0, bool *pbEnabled = NULL, bool bHideColLabels = true, int nAuxIndex = -1, LPCSTR lpcszLabel = NULL, TreeNode &trParent = NULL);
	bool				GetCustomTableProps(string *pstrTblDefLabel, TreeNode& trOp, int nCustomIndex, int nAuxIndex = -1, bool *pbUse = NULL, LPCSTR lpcszLabel = NULL);
	/// end CUSTOM_TABLES_FOR_FIND_XY_HOOKING_IMPLEMENTING_COLUMN_FORMULA
	/// end FRIENDLY_CUSTOM_TABLE_THEME_GENERATION
	/// ML 8/4/2006 REMOVING_CUSTOM_TABLE
	//bool	addReportTableToGraph(TreeNode& trOp, GraphLayer& gl, DataRange& rReportSheet);
	/// end REMOVING_CUSTOM_TABLE
	virtual	int			GetTableIdForGraph(string *pstr, TreeNode& trOp)
	{
		return 0;			// none by default
	}
	/// ML 8/4/2006 REMOVING_CUSTOM_TABLE
	///// ML 1/31/2006 QA70-8141 UPDATING_TABLE_OBJECTS_IN_GRAPHS_FOR_ANALYSIS
	//bool 	UpdateGraphTableObjects(GraphLayer &gl, TreeNode& trOp, const DataRange &rReportSheetOutput);
	///// end UPDATING_TABLE_OBJECTS_IN_GRAPHS_FOR_ANALYSIS
	/// end REMOVING_CUSTOM_TABLE
	
	/// ML 6/9/2005 REPEATITIVE_STYLES_IN_GRID_THEMES
	bool				SetTablePeriodicity(TreeNode &trTable, int nDim, int nPeriod, int nSize = 0, int nOffset = 0);
	/// end REPEATITIVE_STYLES_IN_GRID_THEMES

	
	/// ML 8/4/2006 REMOVING_CUSTOM_TABLE
	//BOOL	setThemeToCustomTable(TreeNode &trCustom, DataRange& rReportSheet, TreeNode& trOp, int nCustomIndex = 0);
	/// end REMOVING_CUSTOM_TABLE
	virtual	BOOL		GetCustomTableDefaultTheme(TreeNode &treeTh){ return FALSE; }
	//bool 	InsertUpdateLabelToReportGraph(TreeNode& trOp, GraphLayer& gl, const string& strLabel, LPCSTR lpcszName = NULL);	//moved to private
	/// Iris 9/17/05 QA70-8015-P15 OUTPUT_RESULT_CURVE_TO_WKS
	//bool	InsertReportToSourceWks(TreeNode& trOp, TreeNode& trReport, Worksheet& wksInput, int nInsertCol, DataRange& rngOutput);
	bool				InsertReportToWks(TreeNode& trOp, TreeNode& trReport, Worksheet& wksInput, int nInsertCol, DataRange& rngOutput);
	///End OUTPUT_RESULT_CURVE_TO_WKS
	
	/// ML 8/4/2006 REMOVING_CUSTOM_TABLE
	//virtual void FillCustomTableInReportTree(TreeNode& trCustomTable, TreeNode& trOperation, int nCustomTable = 0) {}  //--- CPY 11/19/04 QA70-7121 CUSTOM_REPORT_TABLES	
	/// end REMOVING_CUSTOM_TABLE	
	/// ML 3/3/2004 RANGE_BASED_REGRESSIONS
	
	///Jasmine 09/28/06 GET_FITCURVE_OUTPUT_BOOK_NAME
	///Jasmine 09/27/06 PREPARE_OUTPUT_FOR_RESIDUAL
	/// Iris 9/06/06 SURFACE_FIT_REPORT_MAT_FIT_DATA
	//bool	PrepareOutput(Worksheet& wksOutput, Worksheet& wksInput1stRange, TreeNode& trOperation, bool& bNewBookCreated, LPCSTR lpcszDefaultSheetName = NULL, LPCSTR lpcszDefaultBookName= NULL, Worksheet* pwksReport = NULL);
	//bool	PrepareOutput(Datasheet& wksMatLayer, Worksheet& wksInput1stRange, TreeNode& trOperation, bool& bNewBookCreated, LPCSTR lpcszDefaultSheetName = NULL, LPCSTR lpcszDefaultBookName= NULL, Worksheet* pwksReport = NULL, bool bWksLayer = true);
	//bool	PrepareOutput(Datasheet& wksMatLayer, Worksheet& wksInput1stRange, TreeNode& trOperation, bool& bNewBookCreated, int nOutputIndex = OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET, LPCSTR lpcszDefaultSheetName = NULL, LPCSTR lpcszDefaultBookName= NULL, Worksheet* pwksReport = NULL, bool bWksLayer = true);
	///Cheney 2007-5-4 FITCURVE_AND_RESIDUAL_COULD_PUT_INTO_MAT_LAYER_WHEN_FIT_MAT
	//bool	PrepareOutput(Datasheet& wksMatLayer, Worksheet& wksInput1stRange, TreeNode& trOperation, bool& bNewBookCreated, string& strSheetName, string& strBookName, bool bSeparateSheetForDataset = true, int nOutputIndex = OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET, Worksheet* pwksReport = NULL, bool bWksLayer = true, Worksheet* pWksFitCurve = NULL);
	/// Iris 4/11/2008 SET_BOTH_LONG_NAME_AND_SHORT_NAME_FOR_REPORT_BOOK
	//bool	PrepareOutput(Datasheet& wksMatLayer, Datasheet& dsInput1stRange, TreeNode& trOperation, bool& bNewBookCreated, string& strSheetName, string& strBookName, bool bSeparateSheetForDataset = true, int nOutputIndex = OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET, Worksheet* pwksReport = NULL, bool bWksLayer = true, Datasheet* pdsFitCurve = NULL);
	bool				PrepareOutput(Datasheet& wksMatLayer, Datasheet& dsInput1stRange, TreeNode& trOperation, bool& bNewBookCreated, string& strSheetName, string& strBookName, LPCSTR lpcszBookLongName = NULL, bool bSeparateSheetForDataset = true, int nOutputIndex = OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET, Worksheet* pwksReport = NULL, bool bWksLayer = true, Datasheet* pdsFitCurve = NULL);
	///end SET_BOTH_LONG_NAME_AND_SHORT_NAME_FOR_REPORT_BOOK
	///end FITCURVE_AND_RESIDUAL_COULD_PUT_INTO_MAT_LAYER_WHEN_FIT_MAT
	//End SURFACE_FIT_REPORT_MAT_FIT_DATA
	///End PREPARE_OUTPUT_FOR_RESIDUAL
	///End GET_FITCURVE_OUTPUT_BOOK_NAME
	
	///Cheney 2007-4-9 CORRECT_LOGIC_OF_CALLING_INIT_BRANCH
	virtual bool		UpdateInputBranch(TreeNode& trOp){return true;}
	///end CORRECT_LOGIC_OF_CALLING_INIT_BRANCH
	
	///------ Folger 06/01/2012 ORG-5592-S1 SHOW_DATA_IDENTIFIER_FOR_FLAT_SHEET
	//virtual bool		GetOneDataLabel(TreeNode &trOp, int index, int nRowColIndex, string& strDataLabel);
	virtual bool		GetOneDataLabel(TreeNode &trOp, int index, int nRowColIndex, string& strDataLabel, bool bGetDataIdentifier = true);
	///------ End SHOW_DATA_IDENTIFIER_FOR_FLAT_SHEET

	
	// must be overriden:
	//virtual	BOOL	CalcOneData(TreeNode &trOp, int index, LPCSTR lpcszDescriptive, const vector<int> &vFactorSizes,
	/// Iris 05/17/2007 v8.0619 GET_ROW_INDEX_FOR_STATS_EXTREME_VAL_TABLE
	//virtual	BOOL	CalcOneData(TreeNode &trOp, int index, int nTotalNumData, const vector<int> &vFactorSizes,
	//					const vector<string> &vstrFactors, vector &vY, vector &vX, matrix &mMultiIndep, vector &vWeights, DWORD dwPlotObjUID, int nRowColIndex)
	virtual	BOOL		CalcOneData(TreeNode &trOp, int index, int nTotalNumData, const vector<int> &vFactorSizes,
						const vector<string> &vstrFactors, vector &vY, vector &vX, matrix &mMultiIndep, vector &vWeights, DWORD dwPlotObjUID, int nRowColIndex, const vector<int>& vintRowsInSource = NULL)
	///end GET_ROW_INDEX_FOR_STATS_EXTREME_VAL_TABLE
	{
		ASSERT(FALSE);
		return FALSE;
	}
	

	
	/// Iris 9/11/06 SURFACE_FIT_REPORT_MAT_FIT_DATA
	//virtual	DWORD	GenerateWksReport(Worksheet& wks, TreeNode& trResult, int nNumInHeading = 0)
	///Arvin 02/09/07 SET_REPORT_TREE_SHOULD_USE_DIFFERENT_VALUE_FOR_FLAT_AND_NOFLAT_SHEET
	//virtual	DWORD	GenerateReport(Datasheet& ds, TreeNode& trResult, int nNumInHeading = 0)
	
	
	//------ Folger 05/22/08 QA80-11574 SUPPORT_GET_ALL_OPERATION_OUTPUT_SHEET_NAME_WITH_GLOBAL_STRING_VARIABLES
	/*
	/// Iris 3/26/2008 v8.0832 ROC_RESULT_DATA_COL_NEED_MORE_LABEL
	virtual void AfterDoReport(Datasheet& ds, bool bHierarchy)
	//------ End SUPPORT_GET_ALL_OPERATION_OUTPUT_SHEET_NAME_WITH_GLOBAL_STRING_VARIABLES	
	{
		//------ Folger 01/02/08 QA70-10890 SAVING_REPORT_SHEET_NAME_AFTER_FITTING
		if ( bHierarchy )
			LT_set_str(LTVAR_LAST_REPORT, ds.m_strBookSheet);
		//------
		
		ds.AutoSize(); ///Iris 02/02/2007 v8.0553 NOT_DO_AUTO_SIZE_ON_FITTED_VALUES_SHEET
	}
	///end ROC_RESULT_DATA_COL_NEED_MORE_LABEL
	*/
	virtual void		AfterDoReport(Datasheet& ds, int nOutputOption = OUTPUT_PARTIAL_REGRESSION_CURVES_SHEET);
	//------ End SUPPORT_GET_ALL_OPERATION_OUTPUT_SHEET_NAME_WITH_GLOBAL_STRING_VARIABLES
	
	virtual bool		IsAutoSizeReport(const TreeNode& trGUI) { return true; }  /// Iris 5/29/2008 STATS_ON_ROWS_2ND_REPORT_WILL_RESIZE_RESULT_COLS
	virtual bool		UpdateInsertedColumns(TreeNode& trOperation, const DataRange& rInput, int nDataIndex, int nTotalNumData, DataRange& rOutput, int nOutOption) {return false;}
	virtual bool		SetSourceDataPlot(TreeNode& trOp, vector& vY, vector& vX, int nDataIndex, int nTotalNumData, uint uPlotUID);//----- CPY 1/3/04 NLSF_SOURCE_GRAPH_NOT_UPDATED
	///--- YuI 12/07/04 v7.5172 PICTURE_IN_REPORT_IMPROVEMENT
	//	DataPlot GetSourceDataPlot(TreeNode trFit, double* pMin = NULL, double* pMax = NULL)
	DataPlot			GetSourceDataPlot(int index, TreeNode trOp, double* pMin = NULL, double* pMax = NULL);
	///---
	
	

	/**
	BOOL	OnAfterExecute()
	{

		if(!Operation::OnAfterExecute())
			return FALSE;
		
		Worksheet wksOutput;
		if ( !GetOutputWks(wksOutput) )
			return FALSE;
		
		Tree		tr;
		GetTree(tr);
		
		// For now dump the wks:
		if (tr.Reporting)
		{
			PFNwks_report	pfn = Project.FindFunction("wks_report", "Originlab\\Wks_Utils.c");
			BOOL	bBatchProcessing = Project.Operations.IsBatchProcessing();
			if (pfn)
				pfn(wksOutput, tr.Reporting, bBatchProcessing);
			else
				ASSERT(FALSE);
		}
		
		
		return TRUE;
	}
	*/
	//CPY 10/14/06 SEPARATE_OUT_OPERATION_BASE_INTO_SEPARATE_HEADER
	void				OnSetTree(TreeNode& trOperation);
	/*
	{
		Operation::OnSetTree(trOperation);
		
		TreeNode trGUI = trOperation.GUI;
		TreeNode	trInputData = trGUI.InputData;
		
		DataRange	irng;
		GetInput(irng);
		if( !irng )
		{
			irng.Create(trInputData, FALSE);
			Project.AddDataRange(irng); 
			SetInput(irng, 0); // Only one input object:
		}
		else
			irng.SetTree(trInputData, FALSE);
	}
	*/
	//------- end CPY 9/23/04 MOVE_SET_TREE_TO_OC_ONLY
	/// ML 8/15/2006 ATTACHING_GRAPHS_TO_CELLS_IN_OPERATION
	
	/// Iris 9/30/06 ONE_DATA_ONE_REPORT_BOOK, before one data one report Sheet.
	/*
	///Jasmine 09/28/06 GET_FITCURVE_OUTPUT_BOOK_NAME
	/// Iris 9/11/06 SURFACE_FIT_REPORT_MAT_FIT_DATA
	//bool	doResultsCurveSheet(TreeNode& trOperation, Worksheet& wksInput1stRange, int nTotalNumData, bool &bNewResultCurvesBookCreated, Worksheet* pwksReport = NULL);
	//bool	doResultsCurveSheet(TreeNode& trOperation, TreeNode& trCurveBranch, Worksheet& wksInput1stRange, int nTotalNumData, string& strSheetName = NULL, string& strBookName = NULL, Worksheet* pwksReport = NULL, int nOption = OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET);
	bool	doResultsCurveSheet(TreeNode& trOperation, TreeNode& trCurveBranch, Worksheet& wksInput1stRange, int nTotalNumData, string& strSheetName = NULL, string& strBookName = NULL, Worksheet* pwksReport = NULL, int nOption = OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET, Worksheet* pWksFitCurve = NULL);
	///End SURFACE_FIT_REPORT_MAT_FIT_DATA
	///End GET_FITCURVE_OUTPUT_BOOK_NAME
	*/
	///Cheney 2007-5-4 FITCURVE_AND_RESIDUAL_COULD_PUT_INTO_MAT_LAYER_WHEN_FIT_MAT
	//bool	doResultsCurveSheet(TreeNode& trOperation, TreeNode& trCurveBranch, Worksheet& wksInput1stRange, int nIndex, string& strSheetName, string& strBookName, int nOption = OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET, bool bSeparateSheetForDataset = false, Worksheet* pwksReport = NULL,  Worksheet* pWksFitCurve = NULL);
	///Arvin 05/24/07 SHOULD_NOT_CREATE_NEW_SHEET_WHILE_CHANGE_PARAMETER_FROM_COMBINED_REPORT
	//bool	doResultsCurveSheet(TreeNode& trOperation, TreeNode& trCurveBranch, const Datasheet& dsInput1stRange, int nIndex, string& strSheetName, string& strBookName, int nOption = OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET, bool bSeparateSheetForDataset = false, Worksheet* pwksReport = NULL,  Datasheet* pdsFitCurve = NULL);
	///Cheney 2007-9-3 QA70-10331 SHOULD_DESTROY_LOCK_IF_UNCHECK_FINDXY_WHEN_CHANGE_PARAM
	//bool	doResultsCurveSheet(TreeNode& trOperation, TreeNode& trCurveBranch, const Datasheet& dsInput1stRange, int nIndex, string& strSheetName, string& strBookName, int nOption = OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET, bool bSeparateSheetForDataset = false, Worksheet* pwksReport = NULL,  Datasheet* pdsFitCurve = NULL, int nExeMode = 0);
	///end SHOULD_DESTROY_LOCK_IF_UNCHECK_FINDXY_WHEN_CHANGE_PARAM
	///END SHOULD_NOT_CREATE_NEW_SHEET_WHILE_CHANGE_PARAMETER_FROM_COMBINED_REPORT
	///end FITCURVE_AND_RESIDUAL_COULD_PUT_INTO_MAT_LAYER_WHEN_FIT_MAT
	///end ONE_DATA_ONE_REPORT_BOOK

	/// end ATTACHING_GRAPHS_TO_CELLS_IN_OPERATION	
	
	// This is just a temporary helper function:
	bool			DestroyUnusedOutputColumns(Worksheet& wks);
	virtual int		GetResultIndicator(){return ORI_WORKSHEET;}
	
	//------------------------------------------------------------------------
	
	/// ML 11/13/2006 THEME_DIGITS_PARAMETERS_TBL
	////---------- CPY 5/6/04 QA70-6367 HISTOGRAM_GRAPHS
	////virtual 
	//void	OnAfterCreateReport(TreeNode &trOp, Worksheet& wksReport, DataRange& rngInput, bool bNewResultBookCreatedHidden, int nTotalNumData = 0);
	////--------- end
	void			OnAfterCreateReport(TreeNode &trOp, Worksheet& wksReport, DataRange& rngInput, DataRange &rgReportSheetOutput, int nExeMode, bool bNewResultBookCreatedHidden, int nTotalNumData = 0);
	/// end THEME_DIGITS_PARAMETERS_TBL
	
	/// SY 09/01/2004 QA70-6472 v8.0128 IMPORT_INFO_STORAGE_CLEANUP
	//remove setStyleNodeWithOneRange and setMultipleHeading after TreeNode SetRange and GetRange are removed
	
	/*
	void	setStyleNodeWithOneRange(TreeNode &trTable, LPCSTR lpcszRangeStyleName, int r1, int c1, int r2, int c2)
	{
		TreeNode		trStyle = tree_check_get_node(trTable,TREE_STYLE_NODE_NAME);
		
		TreeNode		trRangeStyle = tree_check_get_node(trStyle, MULTIPLE_HEADING_RANGE_STYLE_NODE_NAME, 0, STR_LABEL_ATTRIB, lpcszRangeStyleName);
		

		trRangeStyle.SetRange(r1, c1, r2, c2);
	}
	*/
	/**
			Sets the multiple heading style
	*/
	/*
	void	setMultipleHeading(TreeNode &trTable, int nNumInHeading, bool bTransposed = false)
	{
		int			r1 = 0, r2 = -1, c1 = 0, c2 = -1;

		if( nNumInHeading > 0 )
		{
			if (bTransposed)
				r2 = nNumInHeading - 1;
			else
				c2 = nNumInHeading - 1;
		}
		else
		{
			r1 = c1 = -1;
		}
		
		setStyleNodeWithOneRange(trTable, MULTIPLE_HEADING_RANGE_STYLE, r1, c1, r2, c2);
	}
	*/
	/// end IMPORT_INFO_STORAGE_CLEANUP
	
	
	/**
		Returns the total number of additional rows or columns for factors or multiple datasets
	*/
	virtual	int				GetNumberAdditionalRowsOrColumnsInHeading(int nNumData, int numFactors){return 0;}
	/// Hong 05/30/08 QA80-11632 FIX_SURFACE_FIT_REPORT_FIT_CURVE_FAIL_CORRECT_RESCALE
	/// Iris 2/15/2011 ORG-402 PLOT_SURFACE_FIT_DATA_FROM_VIRTUAL_MATRIX
	//virtual	bool			IsFitCurveFollowSourcePlotType() { return true; }
	/// Iris 3/05/2011 ORG-402-S6 FIX_PLOT_3D_SOURCE_PLOT_IN_REPORT_CONTOUR_GRAPH_SURFACE_FIT
	//virtual	bool			IsFitCurveFollowSourcePlotType(int nGraphIndex) { return true; }
	virtual	bool			IsFitCurveFollowSourcePlotType(const DataPlot& dpSource, int nGraphIndex) { return true; }
	///End FIX_PLOT_3D_SOURCE_PLOT_IN_REPORT_CONTOUR_GRAPH_SURFACE_FIT
	virtual bool			SetupSourceDataPlot(DataPlot& dp) { return true; }
	///End PLOT_SURFACE_FIT_DATA_FROM_VIRTUAL_MATRIX
	/// end FIX_SURFACE_FIT_REPORT_FIT_CURVE_FAIL_CORRECT_RESCALE	

	
	virtual string			GetGraphName(int nGraphIndex = 0, bool bLongName = false);// { string str = GetResultSheetName(); if(nGraphIndex) str += nGraphIndex; return str;}
	virtual string			GetGraphTemplate(int nGraphIndex = 0);// { return "Report" + GetGraphName(nGraphIndex);} /// Iris 06/21/05 rewrite this function
	/// YuI 12/03/04 v7.5170 QA70-7226 MULTIPLE_PLOTS_OF_SAME_SERIES_IN_SAME_FRAME
	//	virtual bool PlotReportGraph(int index, GraphLayer& gl, Worksheet& wksReport, DataRange& rReport, TreeNode& trOp, int nTotalNumData, int nGraphIndex = 0) {return false;}
	///Iris 9/21/06 MULTI_INDEP_PLOTS_NEED_OUT_MATRIX_GRAPH
	//bool		PlotReportGraphs(TreeNode& trPlotInfo, TreeNode& trOp, GraphLayer& gl, int nGraphIndex);
	//int			PlotReportGraph(int nDataIndex, TreeNode& trPlotInfo, TreeNode& trOp, GraphLayer& gl, int nGraphIndex = 0);
	///Sophy CLEAN_CODE moved to private
	/*
	bool		PlotReportGraphs(TreeNode& trPlotInfo, TreeNode& trOp, GraphLayer& gl, int nGraphIndex, int nPicRowIndex = 0, int nPicColIndex = 0);
	int			PlotReportGraph(int nDataIndex, TreeNode& trPlotInfo, TreeNode& trOp, GraphLayer& gl, int nGraphIndex = 0, int nPictureIndex = 0, int nPicColIndex = 0);
	*/
	///end Sophy CLEAN_CODE
	///end MULTI_INDEP_PLOTS_NEED_OUT_MATRIX_GRAPH
	/// end MULTIPLE_PLOTS_OF_SAME_SERIES_IN_SAME_FRAME
	
	/// YuI 12/07/04 v7.5172 PICTURE_IN_REPORT_IMPROVEMENT
	//virtual bool IsSourceDataPlotInReport();
	//virtual bool IsResultsPlotInReport();
	virtual bool			IsSourceDataPlotInReport(int nGraphIndex = 0);
	virtual bool			IsResultsPlotInReport(int nGraphIndex = 0);
	///Iris 9/21/06 MULTI_INDEP_PLOTS_NEED_OUT_MATRIX_GRAPH
	//bool		 PlotSourceDataInLayer(int nDataIndex, TreeNode& trPlotInfo, TreeNode& trOp, GraphLayer& gl);
	//int		 PlotResultInLayer(int nDataIndex, TreeNode& trPlotInfo, TreeNode& trOp, GraphLayer& gl, int nGraphIndex);

	/// Iris 08/01/2007 QA70-10133 ONLY_RECALCULATE_TIME_NEED_CHECK_RESCALE_IF_DATA_OUTSIDE
	//bool		PlotSourceDataInLayer(int nDataIndex, TreeNode& trPlotInfo, TreeNode& trOp, GraphLayer& gl, int nXIndex = 0, int nYIndex = 0);
	/// Iris NLF_81, NLFIT_PLOT_BY_NLFCURVE, changed to virtual
	//bool		PlotSourceDataInLayer(int nDataIndex, TreeNode& trPlotInfo, TreeNode& trOp, GraphLayer& gl, int nGraphIndex = 0, int nXIndex = 0, int nYIndex = 0);
	//virtual bool		PlotSourceDataInLayer(int nDataIndex, TreeNode& trPlotInfo, TreeNode& trOp, GraphLayer& gl, int nGraphIndex = 0, int nXIndex = 0, int nYIndex = 0);//moved to private
	///end NLFIT_PLOT_BY_NLFCURVE
	///end ONLY_RECALCULATE_TIME_NEED_CHECK_RESCALE_IF_DATA_OUTSIDE
	
	//int		 	PlotResultInLayer(int nDataIndex, TreeNode& trPlotInfo, TreeNode& trOp, GraphLayer& gl, int nGraphIndex, int nPictureIndex = 0, int nPicColIndex = 0, bool bIsSourceGraph = false);//moved to private
	///end MULTI_INDEP_PLOTS_NEED_OUT_MATRIX_GRAPH
	///Arvin    03/08/07 SHOULD_SET_AXIS_X_FROM_TO_AND_TITLE_WHEN_USE_DATARANGE_WITH_FACTOR_TO_PLOT_HISTOGRAM
	bool			HasFactor(const TreeNode& trOp, int nDataIndex = 0);
	bool 			GetDataAndFactorValues(const TreeNode& trOp, const DataRange& dr, int nDataIndex, vector& vData, vector<string>& vstrFactors);
	///END SHOULD_SET_AXIS_X_FROM_TO_AND_TITLE_WHEN_USE_DATARANGE_WITH_FACTOR_TO_PLOT_HISTOGRAM
	/// end PICTURE_IN_REPORT_IMPROVEMENT
	virtual bool	AddResultTextLabelInLayer(TreeNode& trOp, GraphLayer& gl) {return false;}
	//virtual 
	/// YuI 12/07/04 v7.5172 PICTURE_IN_REPORT_IMPROVEMENT
	//	bool OnOpenGraph(int nIndex = 0, uint nRowID = 0);
	virtual bool	OnOpenGraph(uint nGraphNodeID, int nPictureIndex = 0);
	/// end PICTURE_IN_REPORT_IMPROVEMENT

	/// ML 7/25/2006 NEW_TABLE_ON_AUTOUPDATE_BUG
	//virtual bool UpdateSourceGraphFromReport(TreeNode& trOp, const DataRange &rReportSheetOutput, int nTotalNumData);
	virtual bool	UpdateSourceGraphFromReport(TreeNode& trOp, const DataRange &rReportSheetOutput, int nTotalNumData, int nExeMode);
	/// end NEW_TABLE_ON_AUTOUPDATE_BUG
	
	virtual	bool	IsPasteCustomTableToReportGraph(int nGraphIndex)	{ return false; }  /// Iris 9/19/05 QA70-7889 PASTE_CUSTOM_TABLE_TO_FIT_CURVE_GRAPH_TABLE
	
	///Arvin 02/03/08 QA70-10970 ERORR_BAR_LOST_WHEN_FIT_FROM_GRAPH
	//virtual bool IsSourceHasErrBar(const TreeNode& trOp, int nDataIndex = 0);//moved to private
	///end ERORR_BAR_LOST_WHEN_FIT_FROM_GRAPH	
	
//-------- end BETTER_RESCALE_ON_FIT_GRAPHS
	int				GetWksCol(DataRange rReport, uint unTableID, uint unColID, Worksheet *pwks = NULL);
	
	/// YuI 06/07/06 INPUT_DATA_HAS_TO_BE_RESOLVED_BEFORE_USE
	//	virtual bool	CheckInputData(TreeNode& trGUI);/// Iris 9/30/04 BASE_CLASS_CHECK_INPUT_DATA
	//virtual bool	CheckResolveInputData(TreeNode& trGUI);//moved to private
	/// end INPUT_DATA_HAS_TO_BE_RESOLVED_BEFORE_USE
	virtual int		GetNumData(TreeNode& trOp, DataRange& dr, TreeNode &trAdditionalData = NULL, Worksheet *pwksFirstRange = NULL, vector<int> *pvFactorSizes = NULL, int *pnNumSubRanges = NULL);
	virtual bool	CalcMultiData(TreeNode& trOp, DataRange& dr, int &nTotalNumData, int nExeMode, DWORD dwExecCntrl = 0);/// YuI 8/13/04 QA70-4387 NLFITTER_OPERATION_IMPLEMENTATION
	/// Iris 9/22/2011 ORG-3208-S1 FIX_REPORT_GRAPH_ISSUE_FOR_MISSED_FACTOR_IN_MULTI_GROUPS_DATA
	virtual bool 	CheckCorrectReportGraphPicRowColIndex(int nNumPicRow, int nNumPicCols, int &nRow, int &nCol, int* pnBeforeNum = NULL) { return false; } 
	///End FIX_REPORT_GRAPH_ISSUE_FOR_MISSED_FACTOR_IN_MULTI_GROUPS_DATA
	
	//CPY 8/18/04
	//wksInputData = wks of the input data at nIndex
	virtual void	UpdateDataSourceInReportingHeader(TreeNode& trOp, vector<string>&vstrFactors, Worksheet& wksInputData, int nIndex, int numSubRanges = 0, DWORD dwRules = 0) ///Arvin 07/19/07 v8.0662 WRONG_INPUT_DATA_TABLE_FOR_ROCCURVE
	{
		//TreeNode trInp = UpdateDataSourceInReportingHeader(trOp.Calculation.Input, vstrFactors, nIndex, NULL, numSubRanges, dwRules);
		UpdateDataSourceInReportingHeader(trOp.Calculation.Input, vstrFactors, nIndex, NULL, numSubRanges, dwRules);
		/// ML10/14/2004 This does not seem to be used anywhere:
		//if(trInp)
		//	trInp.SetAttribute(STR_INPUT_WKS_ATTRIB, wks_get_book_sheet_name(wksInputData));
	}
	
	/// YuI 12/07/04 v7.5172 PICTURE_IN_REPORT_IMPROVEMENT
	virtual bool	IsCreateReportGraph(TreeNode& trOp, int nGraphIndex = -1); ///Arvin 01/24/06 REMOVE_SUB_NODES_OF_FIT_CURVE_AND_MOVE_IT_TO_QUANTITIES_BRANCH by Max's suggestion
	virtual bool	IsPlotOnSourceGraph(TreeNode& trOp, int nGraphIndex = -1) { return false;} /// Iris 5/26/2008 v8.0870 FIT_CURVE_NOT_PLOT_ON_SOURCE_IF_NOT_PLOT_IN_REPORT
	//void			PrepareGraphNodes(TreeNode& trOp, int nGraphIndex = -1);//CPY 12/31/04 PICTURE_IN_REPORT_IN_BASE_CLASS //moved to private
	
	//------ Folger 03/12/08 QA80-11244 SURFACE_FIT_REPORT_SHOULD_USE_CONTOUR_PLOTS
	//int				GetDataSourcePlotType(int nGraphIndex);
	virtual	int		GetDataSourcePlotType(int nGraphIndex);
	//------
	
	///Arvin 11/02/06 MR_DOES_NOT_PLOT_SORUCE_DATA
	/*
	///Iris 9/21/06 MULTI_INDEP_PLOTS_NEED_OUT_MATRIX_GRAPH
	/////Iris 4/14/05 UPDATE_GRAPH_LEGEND
	////int				PlotResultsTableInLayer(GraphLayer& gl, TreeNode& trPlotInfo, DataRange& drReport, int nDataIndex);
	//int				PlotResultsTableInLayer(TreeNode& trOp, GraphLayer& gl, DataPlot& dp, TreeNode& trPlotInfo, int nDataIndex, int& nPlot = NULL, int nGraphIndex = GRAPH_FIT_CURVE);
	int				PlotResultsTableInLayer(TreeNode& trOp, GraphLayer& gl, DataPlot& dp, TreeNode& trPlotInfo, int nDataIndex, int* pnPlot = NULL, int* pnNumPlots = NULL, int nGraphIndex = GRAPH_FIT_CURVE, int nPictureIndex = 0, int nPicColIndex = 0);
	///end MULTI_INDEP_PLOTS_NEED_OUT_MATRIX_GRAPH   
	*/
	/// YuI 04/17/07 QA70-4589 IMPROVED_ANALYSIS_MARKERS
	//	virtual int		PlotResultsTableInLayer(TreeNode& trOp, GraphLayer& gl, DataPlot& dp, TreeNode& trPlotInfo, int nDataIndex, int* pnPlot = NULL, int* pnNumPlots = NULL, int nGraphIndex = GRAPH_FIT_CURVE, int nPictureIndex = 0, int nPicColIndex = 0);
	/// Iris 08/06/2007 v8.0674 NOT_PLOT_AGAIN_IF_PLOTTED_FOR_REPORT_GRAPH
	//virtual int		PlotResultsTableInLayer(TreeNode& trOp, GraphLayer& gl, DataPlot& dp, TreeNode& trPlotInfo, int nDataIndex, int* pnPlot = NULL, int* pnNumPlots = NULL, int nGraphIndex = GRAPH_FIT_CURVE, int nPictureIndex = 0, int nPicColIndex = 0, BOOL bSourceGraph = FALSE);
	//virtual int		PlotResultsTableInLayer(TreeNode& trOp, GraphLayer& gl, DataPlot& dp, TreeNode& trPlotInfo, int nDataIndex, int* pnPlot = NULL, int* pnNumPlots = NULL, int nGraphIndex = GRAPH_FIT_CURVE, int nPictureIndex = 0, int nPicColIndex = 0, BOOL bSourceGraph = FALSE, bool bCheckIfHasPlot = false);//moved to private
	///end NOT_PLOT_AGAIN_IF_PLOTTED_FOR_REPORT_GRAPH
	/// end IMPROVED_ANALYSIS_MARKERS
	///end MR_DOES_NOT_PLOT_SORUCE_DATA
	
	///Arvin 12/07/06 IMPROVE_SURFACE_FIT_RESIDUAL_CONTOUR
	virtual bool	UpdateResidualContourLevels(GraphLayer& gl, int index = 0){ return false;}
	///end IMPROVE_SURFACE_FIT_RESIDUAL_CONTOUR
	
	///Arvin 12/05/07 QA70-10624 SUPPORT_POLAR_SWAPED
	//bool IsPolarSwappedSourcePlot(const TreeNode& trOp, int nDataIndex = 0);//moved to private
	///end SUPPORT_POLAR_SWAPED
	
	///Arvin 12/02/06 MR_PLOT_RESULT_TABLE
	///Cheney 2007-4-13 FIX_BUG_OF_CUSTOM_TABLE_DISAPPEAR_WHEN_CONCATENATE
	//virtual int PlotOneResultsDataRange(TreeNode& trOp, GraphLayer& gl, DataRange drTable, int nPlotType, int nGraphIndex, int nPictureIndex, int nPicColIndex);
	/// Iris 08/06/2007 v8.0674 NOT_PLOT_AGAIN_IF_PLOTTED_FOR_REPORT_GRAPH
	//virtual int PlotOneResultsDataRange(TreeNode& trOp, GraphLayer& gl, DataRange drTable, int nPlotType, int nGraphIndex, int nPictureIndex, int nPicColIndex, bool bIsSourceGraph = false);
	///Arvin 08/15/07 QA70-10212-P3 ADD_NEW_PLOT_FOR_COLUMN_TYPE_CHANGED_AND_REMOVE_REDUNDANT_PLOTS
	//virtual int PlotOneResultsDataRange(TreeNode& trOp, GraphLayer& gl, DataRange drTable, int nPlotType, int nGraphIndex, int nPictureIndex, int nPicColIndex, bool bIsSourceGraph = false, bool bCheckIfHasPlot = false);
	virtual int		PlotOneResultsDataRange(TreeNode& trOp, GraphLayer& gl, DataRange drTable, int nPlotType, int nGraphIndex, int nPictureIndex, int nPicColIndex, bool bIsSourceGraph = false, bool bCheckIfHasPlot = false, int* pStartPlotIndex = NULL);
	///end ADD_NEW_PLOT_FOR_COLUMN_TYPE_CHANGED_AND_REMOVE_REDUNDANT_PLOTS
	///end NOT_PLOT_AGAIN_IF_PLOTTED_FOR_REPORT_GRAPH
	///end FIX_BUG_OF_CUSTOM_TABLE_DISAPPEAR_WHEN_CONCATENATE
	///end MR_PLOT_RESULT_TABLE
	
	///Arvin 11/16/07 QA70-10676 UPDATE_MEANS_COMPARISION_PLOT_LEGENT_WITH_SIG_INFO
	virtual bool	AppendLegendForAddedPlot(TreeNode& trOp, GraphLayer& gl, int nPlotIndex, LPCSTR lpcszExtraFormat, int nGraphIndex, int nPictureIndex);
	///end UPDATE_MEANS_COMPARISION_PLOT_LEGENT_WITH_SIG_INFO

	///Sophy CLEAN_CODE moved to private
	//virtual bool	ApplyThemeToReportSheet(TreeNode& trOp, DataRange& rgReport, int nTotalNumData);
	//bool			ApplyThemeToResultCurveTable(TreeNode& trOp, DataRange& rgReport, int nTableID);  /// Iris 9/14/05 SEPARATE_APPLY_THEME_TO_RESULT_CURVE_TABLE_CODE
	///end Sophy CLEAN_CODE
	///Iris 4/01/05 ADD_GRAPH_INDEX
	//virtual uint	GetResultCurveTableID(TreeNode& trOp, int nDataIndex, int nTotalNumData = -1);
	virtual uint	GetResultCurveTableID(TreeNode& trOp, int nDataIndex, int nTotalNumData = -1, int nGraphIndex = 0);
	virtual int		ReportGetPicureIndexFromDataIndex(int nGraphIndex, int nDataIndex);
	virtual int		ReportGetPlotIndex(int nGraphIndex, int nPictureIndex, int nDataIndex = -1);  ///Iris 8/31/05 SUPPORT_MULTI_LAYERS_IN_ONE_GRAPH
	virtual int		ReportGetPlotTypeFromGraphIndex(int nGraphIndex);
	//virtual uint	ReportPlotTypeGrouppingMethod(int nPlotType);//moved to private
	virtual int		ReportGraphGetRescaleOption(TreeNode& trOp, int nGraphIndex = 0);  /// Iris 11/21/06 CORRECT_SPAN_AXIS_AS_FITX_WHEN_GET_INPUT_FROM_WKS
	bool			ReportHasGraph(TreeNode& trOp, int nPlotType, bool& bVisible);
	virtual bool 	GetCustomGraphTypeName(string& strName, int nGraphIndex = 0);
	int				GetTotalNumData(TreeNode& trOp);
	/// end PICTURE_IN_REPORT_IMPROVEMENT
	
	///Kevin 08/29/05 ADD_GET_COLIMN_DESIGNATION
	virtual void	GetColumnDesignation(TreeNode& trOp, int nColNum, vector<int> &vecDesignation, int nTableID = 0);
	///End ADD_GET_COLIMN_DESIGNATION

	/// Iris 7/06/05 FOR_MR_ONE_GROUP_DATA_HAS_MULTI_PARTIAL_PLOTS
	virtual int    	GetTotalNumPictureForOneGraphType(TreeNode& trOp, int nGraphIndex = -1);
	///end FOR_MR_ONE_GROUP_DATA_HAS_MULTI_PARTIAL_PLOTS	
	
	/// Iris 01/08/2007 v8.0538 REPORT_GRAPHS_ARRANGEMENT
	/*
	///Iris 9/21/06 MULTI_INDEP_PLOTS_NEED_OUT_MATRIX_GRAPH
	virtual int    	GetPictureNumForOneData(TreeNode& trOp = NULL, int nDataIndex = 0, int nGraphIndex = 0) { return 1; }
	////end MULTI_INDEP_PLOTS_NEED_OUT_MATRIX_GRAPH
	*/
	virtual int    	GetReportGraphTableRowNum(TreeNode& trOp, int nGraphIndex = 0, bool bSkipPlotInOneGraphNode = true);	
	
//	/// Iris 9/19/05 QA70-8015-P15 OUTPUT_RESULT_CURVE_TO_WKS
//	virtual bool GetReportDatasInOneTable(TreeNode& trOp, TreeNode& trTable, int nIndex, int nTotalNumData) { return false; }
//	///End OUTPUT_RESULT_CURVE_TO_WKS

	///Iris 9/21/06 MULTI_INDEP_PLOTS_NEED_OUT_MATRIX_GRAPH
	
	//	The number of columns of report graph table is equal to the number of Ys of the Input Data. 
	//	So return 1 for default.
	//	The format of report graph table is:
	//			(X1)	(X2)	(X3)	(..)	
	//	(Y1)	X1Y1	X2Y1	X3Y1
	//	(Y2) 	X1Y2	X2Y2	X3Y2
	//	(..)		
	
	/// Iris 01/08/2007 v8.0538 REPORT_GRAPHS_ARRANGEMENT
	//virtual int GetReportGraphTableColNum(TreeNode& trOp, int nGraphIndex = 0) { return 1; }  
	virtual int		GetReportGraphTableColNum(TreeNode& trOp, int nGraphIndex = 0, bool bSkipPlotInOneGraphNode = true);
	///end REPORT_GRAPHS_ARRANGEMENT
	
	/// YuI 03/05/09 QA70-13220 WHOLE_WORKSHEET_INPUT_XYRANGE
	/// Iris 9/10/2009 QA80-11710-P2 IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
	//virtual void	CheckUpdateReportGraphArrangement(TreeNode& trGUI, int nNumData);
	virtual void	CheckUpdateReportGraphArrangement(TreeNode& trOp, int nNumData);
	///end IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
	/// end WHOLE_WORKSHEET_INPUT_XYRANGE

	virtual string	GetReportGraphLabel(TreeNode& trOp, int nGraphIndex, int nPicRow, int nPicCol);
	///End MULTI_INDEP_PLOTS_NEED_OUT_MATRIX_GRAPH
	///Sophy 1/5/2009 v8.0993d QA80-12858 GIVE_USEFUL_INFO_ON_REPORT_GRAPH_WITH_FACTOR_VALUE_FOR_STATS_COLUMN
	/// Iris 9/22/2011 ORG-3208-S1 FIX_REPORT_GRAPH_ISSUE_FOR_MISSED_FACTOR_IN_MULTI_GROUPS_DATA
	//virtual	bool	UpdateReportGraphLabel(TreeNode& trOp, TreeNode& trLabel, int nGraphIndex, int nPicRow, int nPicCol, int nNumPicCols){ return true; } //will overide in stats on column
	virtual	bool	UpdateReportGraphLabel(TreeNode& trOp, TreeNode& trLabel, int nGraphIndex, int nPicRow, int nPicCol, int nNumRocRows, int nNumPicCols){ return true; } //will overide in stats on column
	///End FIX_REPORT_GRAPH_ISSUE_FOR_MISSED_FACTOR_IN_MULTI_GROUPS_DATA
	///end GIVE_USEFUL_INFO_ON_REPORT_GRAPH_WITH_FACTOR_VALUE_FOR_STATS_COLUMN
	/// Iris 02/03/2007 v8.0554 PLOT_ALL_BOX_CHART_IN_ONE_GRAPH
	virtual int		GetNumberLayersInOneGraph(TreeNode& trOp, int nGraphIndex) { return 1; }
	///end PLOT_ALL_BOX_CHART_IN_ONE_GRAPH
	
	///Arvin 10/16/06 MOVE_TO_OPERATION_FILE
	void			UpdateDataSourceInReportingHeader(TreeNode &trInputTable, const vector<string> &vstrFactors, int ii, LPCSTR lpcszXLabel = NULL, int numSubRanges = 0, DWORD dwRules = 0);
	///end MOVE_TO_OPERATION_FILE
	
	///Arvin 11/09/07 NLFIT_REPORT_GRAPH_NEED_RESCALE_WHILE_PART_GRAPH_SELECTION_AS_INPUT
	/// Hong 08/12/08 QA80-11986 FIX_FITTED_CURVE_PLOT_FAIL_RESCALE_WHEN_SOURCE_PLOT_HAVE_ERR_BAR
	//virtual void 	RescaleReportGraph(TreeNode& trOp, GraphLayer& gl, int nGraphIndex, int nPicRowIndex, int nPicColIndex);
	virtual void 	RescaleReportGraph(TreeNode& trOp, GraphLayer& gl, int nGraphIndex, int nPicRowIndex, int nPicColIndex, int nFirstFiteedPlotIndex);
	/// end FIX_FITTED_CURVE_PLOT_FAIL_RESCALE_WHEN_SOURCE_PLOT_HAVE_ERR_BAR
	///end NLFIT_REPORT_GRAPH_NEED_RESCALE_WHILE_PART_GRAPH_SELECTION_AS_INPUT
	
	///Arvin 11/16/07 QA70-10676 UPDATE_MEANS_COMPARISION_PLOT_LEGENT_WITH_SIG_INFO
	//bool		IsPlotAllPlotsInOneGraph(TreeNode& trOperation);
	///Arvin 02/14/08 QA70-11094 SUPPORT_PLOT_MULTI_FITTED_CURVES_IN_ONE_GRAPH_IN_LR_PR_AND_FITNL
	//bool		IsPlotAllPlotsInOneGraph(TreeNode& trOperation, int nGraphIndex = -1);
	virtual bool	IsPlotAllPlotsInOneGraph(TreeNode& trOperation, int nGraphIndex = -1);
	///end SUPPORT_PLOT_MULTI_FITTED_CURVES_IN_ONE_GRAPH_IN_LR_PR_AND_FITNL
	///end UPDATE_MEANS_COMPARISION_PLOT_LEGENT_WITH_SIG_INFO
	virtual void	PutTempStatsTreeNode(TreeNode& trOp, DataRange& dr, int nDataIndex, int nGraphIndex){}
	//---Iris 3/18/2009 QA80-13304 FIX_MR_RESIDUAL_PLOTS_ALL_PLOTTED_ON_FIRST_X_WITH_RESIDUAL
	//virtual void	UpdateImageNodePlottingInfo(TreeNode& trOp, TreeNode& trPlotInfo, int nGraphIndex, int nDataIndex);
	virtual void	UpdateImageNodePlottingInfo(TreeNode& trOp, TreeNode& trPlotInfo, int nGraphIndex, int nDataIndex, int nPicIndex);
	//---end FIX_MR_RESIDUAL_PLOTS_ALL_PLOTTED_ON_FIRST_X_WITH_RESIDUAL
	bool			IsSeparateSheetForDataset(const TreeNode& trOp);
	virtual void 	CheckRemoveAndDestroyOutput(TreeNode& trOperation);
	///Cheney 2007-4-12 ALL_FITTING_TOOLS_NEED_FOOTNOTE_FOR_MISSING_AND_MASKED_DATA
	bool			IsHasMissingData(){return m_bHasMissing;}
	bool			IsHasMaskedData(){return m_bHasMasked;}
	void			SetHasMissingData(bool bHasMissing){m_bHasMissing = bHasMissing;}
	void			SetHasMaskedData(bool bHasMasked){m_bHasMasked = bHasMasked;}
	///end ALL_FITTING_TOOLS_NEED_FOOTNOTE_FOR_MISSING_AND_MASKED_DATA	
//////////////////////////////////////////
// CPY 10/15/06 prototypes moved from operation class
	
	/// YuI 04/17/07 QA70-4589 IMPROVED_ANALYSIS_MARKERS
	//	BOOL    GetResultTableData(TreeNode& trOp, int nResultTableID, int nDataIndex, int nGraphIndex, DataRange& drTable);
	virtual BOOL			GetResultTableData(TreeNode& trOp, int nResultTableID, int nDataIndex, int nGraphIndex, DataRange& drTable, DataRange& drFitCurvesRange = NULL);
	/// end IMPROVED_ANALYSIS_MARKERS
	///end FITTING_HISTOGRAM_PLOT
	
	///Arvin 11/20/07 QA70-10708 CHECK_AND_CONVERT_DOUBLE_VALUES_FROM_GERMAN_TO_ENGLISH
	virtual bool	CheckLoadOperation(TreeNode& trOperation, int nCurrentOperationVersion) { return false; }
	///end CHECK_AND_CONVERT_DOUBLE_VALUES_FROM_GERMAN_TO_ENGLISH
	
	///Arvin 11/16/07 NLFIT_REPORT_GRAPH_NEED_RESCALE_WHILE_PART_GRAPH_SELECTION_AS_INPUT
	TreeNode		CheckGetPlotInfoNode(TreeNode& trOp, int nGraphIndex, int nPicRowIndex, int nPicColIndex = 0, int nPlotIndex = 0, bool bCreate = false);
	///end NLFIT_REPORT_GRAPH_NEED_RESCALE_WHILE_PART_GRAPH_SELECTION_AS_INPUT

	//virtual void	FilterReportForResultsLog(TreeNode& trOperation); //CPY 8/4/04 //moved to private
	//bool IsOutputReportSheet(const TreeNode& trGUI); //moved to private
	/// Iris 7/10/06 v8.0440 QA70-7001-P14 NOT_CREATE_RESULT_CURVE_SHEET_IF_NO_REPORT_GRAPH
	//bool IsOutputSeparateResultCurveSheet(const TreeNode& trGUI);
	virtual bool	IsOutputSeparateResultCurveSheet(const TreeNode& trOp);
	//End NOT_CREATE_RESULT_CURVE_SHEET_IF_NO_REPORT_GRAPH
	
	///Arvin 06/15/07 WRONG_HISTOGRAM_AND_BOXCHART_PLOTS_WHILE_DATA_HAVE_FACTORS
	virtual TreeNode	GetResultCuveOutputBranch(const TreeNode& trOp);
	///end WRONG_HISTOGRAM_AND_BOXCHART_PLOTS_WHILE_DATA_HAVE_FACTORS
/// Iris 8/22/2011 ORG-2427-S4 QUANTITIES_BOOKSHEET_BRANCH_REPLACE_CHECKBOX
#ifdef __STATS_ON_COLS_SUPPORT_QUANTITIES_OUTPUT_BRANCH
	virtual TreeNode	GetResidualOutputBranch(const TreeNode& trGUI)
	{
		return OP_GUI_OUTPUT_TO_RESIDUAL_BRANCH(trGUI);
	}
#endif //__STATS_ON_COLS_SUPPORT_QUANTITIES_OUTPUT_BRANCH
///End QUANTITIES_BOOKSHEET_BRANCH_REPLACE_CHECKBOX
	virtual bool IsOutputAnyTypeResidualData(const TreeNode& trOp){return false;} ///Sophy 1/21/2009 v8.0962b FIX_FAIL_TO_GET_RESIDUAL_OUTPUT_WHEN_REPORT_TO_FITTEDCURVE_SHEET
	virtual bool IsOutputAnyTypeResidualGraph(const TreeNode& trOp){return false;}	///Sophy 2/2/2009 v8.0969 CHANGE_PARAM_SHOULD_KEEP_BRAHCH_ENABLE_WHEN_CURVE_NOT_REPORTED_BEFORE
	/// Iris 9/13/06 QA70-8973 REPORT_RESIDUAL_DATA_IN_SEP_REPORT_SHEET
	virtual bool		IsOutputSeparateResidualCurveSheet(const TreeNode& trOp) { return false;}
	virtual bool		IsOutputSeparateCalibrationSheet(const TreeNode& trOp, int nXfromY = -1) { return false;}
	///end REPORT_RESIDUAL_DATA_IN_SEP_REPORT_SHEET	
	
	/// Hong 04/14/08 v8.0840c PEAK_FIT_REPORT_PEAK_CHARACTERISTICS_TO_SEPARATE_SHEET
	virtual bool		IsOutputPeakCharacterSheet(const TreeNode& trOp) { return false;}
	/// end PEAK_FIT_REPORT_PEAK_CHARACTERISTICS_TO_SEPARATE_SHEET
	
	/// Iris 11/12/2008 v8.0969 QA80-12584 OUTPUT_BASELINE_AND_SUBTRACTED_DATA_IN_FIT_PEAK_OP
	/// Iris 3/24/2009 FIX_CREATE_NEW_NLFIT_FINDXY_REPORT_WHEN_RECALCULATE
	// change return value from bool to int
	//virtual bool		IsOutputSubtractedDataSheet(const TreeNode& trOp) { return false;}
	//virtual bool		IsOutputBaselineDataSheet(const TreeNode& trOp) { return false;}
	virtual int		IsOutputSubtractedDataSheet(const TreeNode& trOp) { return REPORT_INVALID;}
	virtual int		IsOutputBaselineDataSheet(const TreeNode& trOp) { return REPORT_INVALID;}
	///end OUTPUT_BASELINE_AND_SUBTRACTED_DATA_IN_FIT_PEAK_OP
	
	//bool IsOutputInsertColsToDataSheet(const TreeNode& trGUI, bool& bInsertCurves, int nOutputIndex = OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET);//moved to private
	virtual void		FilterTreeForGUI(TreeNode& trOp); //CPY 1/3/04 NLSF_ALWAYS_SHOW_ADVANCED_GUI
	/// ML 10/20/2004 QA70-7075 MASKED_DATA_REPORTING
	/// ML 12/14/2004 QA70-7240 GETTING_MISSING_VALUES_AND_ROWS
	//bool	UpdateMaskedDataTables(TreeNode& trOp, DataRange& dr, vector<string> &vstrFactors, int index, int nNumData, int numSubRanges = 0, DWORD dwRules = 0);
	//bool	SetMaskedDataTable(DataRange &dr, TreeNode &trTable, LPCSTR lpcszDataLabel, LPCSTR lpcszXDataLabel, LPCSTR lpcszWeightLabel, int index, DWORD dwRules);
	///Cheney 2007-4-2 ADD_HINTS_IN_FOOTNOTE_WHEN_EXISTS_MISSING_OR_MASKED_DATA
	//bool	UpdateMaskedOrMissingDataTables(TreeNode& trOp, DataRange& dr, vector<string> &vstrFactors, int index, int nNumData, int numSubRanges = 0, DWORD dwRules = 0, LPCSTR lpcszDataLabel = NULL, bool bMissingData = false);
	bool				UpdateMaskedOrMissingDataTables(TreeNode& trOp, DataRange& dr, vector<string> &vstrFactors, int index, int nNumData, int numSubRanges = 0, DWORD dwRules = 0, LPCSTR lpcszDataLabel = NULL, bool bMissingData = false, bool& bHas = NULL
						/// Zech 08/22/2012 ORG-5703-P1 OPERATION_SUPPORT_IGNORE_HIDDEN_ROW
						, DWORD dwRules2 = 0
						/// END OPERATION_SUPPORT_IGNORE_HIDDEN_ROW
						);
	///end ADD_HINTS_IN_FOOTNOTE_WHEN_EXISTS_MISSING_OR_MASKED_DATA
	void 	UpdateNotesTextOnEmptyMaskedOrMissingDataTable(TreeNode& trTheTable, bool bMissingData, int index, int nNumData, bool bHas); /// Iris 9/14/2009 QA80-14279 ADD_NOTES_TEXT_FOR_EMPTY_MISSING_MASKED_DATA_TABLE

	/// ML 11/11/2005 QA70-8135 Z_IN_REPORT_TABELS
	//bool	SetMaskedOrMissingDataTable(DataRange &dr, TreeNode &trTable, LPCSTR lpcszDataLabel, LPCSTR lpcszXDataLabel, LPCSTR lpcszWeightLabel, int index, DWORD dwRules, bool bMissingData = false);
	//bool	SetMaskedOrMissingDataTable(DataRange &dr, TreeNode &trTable, LPCSTR lpcszMainLabel, LPCSTR lpcszXDataLabel, LPCSTR lpcszWeightLabel, int index, DWORD dwRules, bool bMissingData = false, LPCSTR lpcszYIndepDataLabel = NULL, LPCSTR lpcszDataLabel = NULL);//moved to private
	/// end Z_IN_REPORT_TABELS
	/// end GETTING_MISSING_VALUES_AND_ROWS
	/// end MASKED_DATA_REPORTING
	///Arvin 12/05/06 ROCCURVE_SHOULD_HAVE_SPECIAL_DATA_LABEL
	virtual void		GetMaskedOrMissingDataLabel(const TreeNode& trOp, LPCSTR &lpcszDataXLabel, LPCSTR &lpcszMainLabel, LPCSTR &lpcszDataYIndepLabel = NULL);
	///end ROCCURVE_SHOULD_HAVE_SPECIAL_DATA_LABEL
	
	///Arvin 12/07/06 ROCCURVE_NEED_MASKED_AND_MISSING_DATA_TABLE
	virtual void		UpdateMaskedAndMissingDataTables(TreeNode& trOp, TreeNode&	trAdditionalData, DataRange& dr, vector<int>& vFactorSizes, vector<string> &vstrFactors, int numSubRanges, DWORD dwRules
						/// Zech 08/22/2012 ORG-5703-P1 OPERATION_SUPPORT_IGNORE_HIDDEN_ROW
						, DWORD dwRules2 = 0
						/// END OPERATION_SUPPORT_IGNORE_HIDDEN_ROW
						);
	///end ROCCURVE_NEED_MASKED_AND_MISSING_DATA_TABLE
	
	// cType = 0 to assume 'A' to avoid 'A' to be duplicated in calls that need to specify more options
	/// ML 9/1/2006 NLFIT_MULTIDEPS_INDEPS_INPUT_DATA_TBL
	///// ML 10/26/2005 QA70-8225 ESCAPED_OPER_STRINGS_ANOVAS
	////void	getEscapedDataString(string &str, int nIndexLT, BOOL bSubRange = FALSE, char cType = 0, char cXYW = 0, int nAddtional = ESC_LABEL_ADD_NONE);
	//void	getEscapedDataString(string &str, int nIndexLT, BOOL bSubRange = FALSE, char cType = 0, char cXYW = 0, int nAddtional = ESC_LABEL_ADD_NONE, char chDataFactSubj = 0);
	///// end ESCAPED_OPER_STRINGS_ANOVAS
	///Cheney 2007-1-30 MOVE_SOME_FUNCTION_FOR_NLFIT_REPORT_TO_VC
	//void	getEscapedDataString(string &str, int nIndexLT, BOOL bSubRange = FALSE, char cType = 0, char cXYW = 0, int nAddtional = ESC_LABEL_ADD_NONE, char chDataFactSubj = 0, int nSecondNum = 0);
	///end MOVE_SOME_FUNCTION_FOR_NLFIT_REPORT_TO_VC
	/// end NLFIT_MULTIDEPS_INDEPS_INPUT_DATA_TBL
	/// ML 1/9/2007 INPUT_DATA_TBL_MR_MULTI_INDEPS
	///// ML 10/26/2005 QA70-8225 ESCAPED_OPER_STRINGS_ANOVAS
	////TreeNode	AddOneInputDataTableCell(TreeNode &trRow, LPCSTR lpcszLabel, int indexLT, BOOL bSubRange = FALSE, char cType = 'A', char cXYW = 'Y');
	//TreeNode	AddOneInputDataTableCell(TreeNode &trRow, LPCSTR lpcszLabel, int indexLT, BOOL bSubRange = FALSE, char cType = 'A', char cXYW = 'Y', char chDataFactSubj = 0);
	///// end ESCAPED_OPER_STRINGS_ANOVAS
	TreeNode			AddOneInputDataTableCell(TreeNode &trRow, LPCSTR lpcszLabel, int indexLT, BOOL bSubRange = FALSE, char cType = 'A', char cXYW = 'Y', char chDataFactSubj = 0, int nSecondNum = 0);
	virtual int			GetNumX(TreeNode& trOp) { return 1;	}	
	virtual int			GetNumY(TreeNode& trOp) { return 1;	}	
	/// end INPUT_DATA_TBL_MR_MULTI_INDEPS
	
	BOOL				AddCombinedDataSourcesToReportInputTable(TreeNode &trInputTable, const vector<string> &vstrFactors, int index, LPCSTR lpcszLabel, int numSubRanges, DWORD dwRules, LPCSTR lpcszXLabel = NULL);
	
	///Cheney 2007-4-3 REMOVE_XY_IN_INPUT_TABLE_WHEN_FIT_MATRIX
	TreeNode			AddReportInputTable(TreeNode &trInputTable, const vector<string> &vstrFactors, int index);
	TreeNode			AddXDataSourceToReportInputTable(TreeNode &trInputTable, int index, LPCSTR lpcszXLabel = NULL, char cXYMain = 0, int numSubRanges = 0, DWORD dwRules = 0);
	//TreeNode AddXDataSourceToReportInputTable(TreeNode &trInputTable, const vector<string> &vstrFactors, int index, LPCSTR lpcszXLabel = NULL, char cXYMain = 0, int numSubRanges = 0, DWORD dwRules = 0);
	///end REMOVE_XY_IN_INPUT_TABLE_WHEN_FIT_MATRIX
	//---------
	virtual void		UpdateReportingTables(TreeNode &trOperation, int nTotalNumData, int nExecMode);
	///Sophy CLEAN_CODE moved to private
	/*
	string GetReportOutputSheetName(const TreeNode& trGUI, int* pnSpecialType = NULL);
	string GetReportOutputBookName(const TreeNode& trGUI, int* pnSpecialType = NULL);
	///Jasmine 09/27/06 PREPARE_OUTPUT_FOR_RESIDUAL
	//string GetCurveOutputSheetName(const TreeNode& trGUI, int* pnSpecialType = NULL);
	string GetCurveOutputSheetName(const TreeNode& trGUI, int nOutputIndex, int* pnSpecialType = NULL);
	*/
	///end Sophy CLEAN_CODE
	//string GetCurveOutputBookName(const TreeNode& trGUI, int* pnSpecialType = NULL);   ///Iris 11/12/04 FIX_CURVE_SHEET_ALWAYS_SAME_AS_REPORT_SHEET
	//string GetCurveOutputBookName(const TreeNode& trGUI, int* pnSpecialType = NULL, Worksheet* pwksReport = NULL);
	/// Iris 5/26/2008 WRONG_RESULT_CURVE_SHEET_NAME_SAME_AS_REPORT_SHEET
	//string GetCurveOutputBookName(const TreeNode& trGUI, int nOutputIndex, int* pnSpecialType = NULL, Worksheet* pwksReport = NULL);
	virtual string		GetCurveOutputBookName(const TreeNode& trGUI, int nOutputIndex, int* pnSpecialType = NULL, Worksheet* pwksReport = NULL);
	///end WRONG_RESULT_CURVE_SHEET_NAME_SAME_AS_REPORT_SHEET
	///End PREPARE_OUTPUT_FOR_RESIDUAL
	/* see tracker 6330
	<type> is one or more of the letters:
		C - for col short name
		L - for col long name
		M - for col comments
		R - for range string (like in Excel)
		B - book name, or page long name
		N - page short name, or old page name
		S - for sheet name
		P - [Book]Sheet!LongOrShortColName
		G - [3:27]
		
		for cXYW = 0, we are getting the main, otherwise can be X for getting X range
	*/
	/// ML 9/1/2006 NLFIT_MULTIDEPS_INDEPS_INPUT_DATA_TBL
	//void	GetEscapedMainDataString(TreeNode &trOp, string &str, int indexLT, bool bInputTable = false, char cType = 0, char cXYW = 0);
	///------ Folger 05/24/2012 ORG-5577-P1 BETTER_REPORT_TABLE_TITLE_FOR_IMPLICIT_FITTING
	//virtual	void		GetEscapedMainDataString2(TreeNode &trOp, string &str, int indexLT, bool bInputTable = false, char cType = 0, char cXYW = 0);
	virtual	void		GetEscapedMainDataString2(TreeNode &trOp, string &str, int indexLT, bool bInputTable = false, char cType = 0, char cXYW = 0, int nSecondNum = 0);
	///------ End BETTER_REPORT_TABLE_TITLE_FOR_IMPLICIT_FITTING
	/// end NLFIT_MULTIDEPS_INDEPS_INPUT_DATA_TBL

	///------ Folger 05/04/2012 ORG-5592-S1 ADD_DATA_IDENTIFIER_FOR_FITTING_TOOLS
	virtual void GetEscapedMainDataString(const TreeNode &trOp, string &str, int indexLT, bool bInputTable = false, char cType = 0, char cXYW = 0, int nSecondNum = 0);
	virtual char GetEscapedLabelStringCharType(char cType) { return 'T'; }
	///------ End ADD_DATA_IDENTIFIER_FOR_FITTING_TOOLS

	///------ Folger 05/17/2012 ORG-5592-P1 ONLY_SET_REPORT_TREE_WHEN_CHANGE_DATA_IDENTIFIER
	virtual void GetInputDataTableHeaderString(string& str, int nIndexSet, int nLabelType, LPCSTR lpcszCustom);
	///------ End ONLY_SET_REPORT_TREE_WHEN_CHANGE_DATA_IDENTIFIER

	//---
	/// ML 7/21/2006 QA70-4434 CUSTOM_TABLES_FOR_FIND_XY_HOOKING_IMPLEMENTING_COLUMN_FORMULA
	///// ML 6/27/2005 STYLE_LINKS_WITH_OFFSETS
	//int		getCustomTableID(int nCustomIndex = 0);
	///// end STYLE_LINKS_WITH_OFFSETS
	int					GetCustomTableID(int nCustomIndex = 0, int nAuxIndex = 0);
	/// end CUSTOM_TABLES_FOR_FIND_XY_HOOKING_IMPLEMENTING_COLUMN_FORMULA

	/// Iris 3/21/2008 v8.0829 QA80-10934 ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME, no place used this funciton, so comment out
	//virtual string	GetResultBookName(TreeNode& trOperation, int nDataIndex = 0);	
	///end ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME
	
	///Arvin 11/07/06 STATS_ON_ROW_OUTPUT_RESULTS_TO_SHEET
	virtual bool		InsertResultToNewSheet(TreeNode& trOp, const DataRange& rngInput, int nDataIndex, int nTotalNumData, int nOutputOption = -1){ return false;}
	///end STATS_ON_ROW_OUTPUT_RESULTS_TO_SHEET
	/// ML 6/5/2007 QA70-9869 SPECIAL_GUI_TREE_UPDATE_BEFORE_RERUNNING
	/// YuI 06/06/08 QA70-11619 MORE_CLEAR_WORKSHEET_PROBLEM
	//	virtual	void	GUIOnUpdateTreeBeforeRunning(TreeNode &trGUINew, TreeNode &trGUIOriginal);
	///---Sim 04-02-2009 QA80-13403 ADD_INDIVIDUAL_OP_VERSION_FOR_CONVERT_GUI_TREE
	//virtual	void		GUIOnUpdateTreeBeforeRunning(TreeNode &trGUINew, TreeNode &trGUIOriginal, TreeNode& trOperation);
	virtual	void		GUIOnUpdateTreeBeforeRunning(const MultipleVersion& mvOld, TreeNode &trGUINew, TreeNode &trGUIOriginal, TreeNode& trOperation);
	///---END QA80-13403 ADD_INDIVIDUAL_OP_VERSION_FOR_CONVERT_GUI_TREE
	/// end MORE_CLEAR_WORKSHEET_PROBLEM
	/// end SPECIAL_GUI_TREE_UPDATE_BEFORE_RERUNNING
	
	virtual string		GetSourcePageName(TreeNode& trOp, Datasheet& ds = NULL); 	///Cheney 2007-8-23 QA70-10290 FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK

	//virtual
	bool				InitOutputGUIManagerPointer(const TreeNode& trGUI); /// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
	
	/// Iris 4/01/2008 v8.0829 QA80-10934 ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME_AFTER_CLEAN_OUTPUT_GUI_CODES
	virtual void		SetOutputBookSheetDefaultName(TreeNode& trGUI);
	/// Sophy 5/05/2008 QA80-10934-P5 v8.0856 SUPPORT_SEPARATE_FINDXY_OUTPUT_SHEET_NAME
	//void 	SetOneOutputBookSheetDefaultNameAttribute(TreeNode& trGUI, TreeNode& trBookSheetBranch, bool bIsBook, LPCSTR lpcszDefault);
	void				SetOneOutputBookSheetDefaultName(TreeNode& trGUI, TreeNode& trBookSheetBranch, bool bIsBook, LPCSTR lpcszDefault, int nIndex = 0);
	/// End SUPPORT_SEPARATE_FINDXY_OUTPUT_SHEET_NAME
	///end ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME_AFTER_CLEAN_OUTPUT_GUI_CODES
	///Sophy 5/29/2008 QA80-10934-P10 CORRECT_STATS_ON_ROWS_RESULT_BOOK_NAME moved from private
	string				GetResultBookNameFromGUI(const TreeNode& trGUI);
	string				GetResultSheetNameFromGUI(const TreeNode& trGUI);
	///end CORRECT_STATS_ON_ROWS_RESULT_BOOK_NAME
	///Arvin 12/04/06 STATS_ON_ROW_OUTPUT_RESULTS_TO_SHEET
	virtual bool		IsOutputDataResultsToNewSheet(const TreeNode& trGUI) {return false;}
	///end STATS_ON_ROW_OUTPUT_RESULTS_TO_SHEET		
	virtual bool		PlotSourceDataInLayer(int nDataIndex, TreeNode& trPlotInfo, TreeNode& trOp, GraphLayer& gl, int nGraphIndex = 0, int nXIndex = 0, int nYIndex = 0);
	
	//------ Folger 11/18/08 QA80-12574 v8.0974 SUPPORT_RESET_ALL_GRAPHS_IN_ERPORT_SHEET
	///// Hong 10/17/08 QA80-10624 NLFIT_SUPPORT_FIT_SWAPPED_POLAR_PLOT
	//virtual uint		GetPlotCtrl() { return 0; }
	///// end NLFIT_SUPPORT_FIT_SWAPPED_POLAR_PLOT
	virtual uint		GetPlotCtrl(TreeNode& trOp) { return 0; }
	//------ End SUPPORT_RESET_ALL_GRAPHS_IN_ERPORT_SHEET
		
	/// Hong 11/15/08 QA80-12584 v8.0972 SBUTRACTED_DATA_IS_FIT_SRC_DATA_AND_SHOULD_REPLACE_DRAW_SRC_DATA
	virtual bool	CheckReplaceSourceDataPlot(TreeNode& trOperation, int nTotalNumData) { return false; }	
	// Hong, move from private, and rename from getOutputSlot to GetOutputSlot
	/// Iris 9/13/06 QA70-8973 REPORT_RESIDUAL_DATA_IN_SEP_REPORT_SHEET
	//int getOutputSlot(int nDataIndex, bool bTableMustBeOutside);
	virtual int		GetOutputSlot(int nDataIndex, bool bTableMustBeOutside, int nOutputIndex = OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET);
	///end REPORT_RESIDUAL_DATA_IN_SEP_REPORT_SHEET
	/// end SBUTRACTED_DATA_IS_FIT_SRC_DATA_AND_SHOULD_REPLACE_DRAW_SRC_DATA
	///Sophy 3/5/2009 QA80-12584 v8.0992 FIX_LOSE_SOURCE_CURVE_WHEN_FIT_FROM_GRAPH_ARRANGE_SAME_PLOTS_ON_ONE_GRAPH
	//replace drInput with the nDataIndex-th dataset's input range. if drInput changed, return true, else return false.
	virtual	bool	CheckReplaceSourceRange(TreeNode& trOperation, DataRange& drInput, int nDataIndex = 0){return false;} //only need to check&replace in PA
	///end FIX_LOSE_SOURCE_CURVE_WHEN_FIT_FROM_GRAPH_ARRANGE_SAME_PLOTS_ON_ONE_GRAPH
	virtual void	FilterDataRulesForPlot(DWORD& dwDataRules){return;}///Sophy 12/23/2008 v8.0990 QA80-12832 SUPPORT_MULTI_DATASET_FOR_MULTI_INDEPS_AND_DEPS_FITTING
	
	///---Sim 06-17-2009 QA80-13786-P2-P4 SPEEP_UP_LINEAR_FIT_WITHOUT_REPORT_TABLE
#ifdef __SPEED_UP_FIT_WITHOUT_REPORT_TABLE__
	virtual bool	IsNeedReportTable(TreeNode& trOp);
#endif //__SPEED_UP_FIT_WITHOUT_REPORT_TABLE__	
	///---END QA80-13786-P2-P4 SPEEP_UP_LINEAR_FIT_WITHOUT_REPORT_TABLE

	///------ Folger 10/28/09 QA81-14552 WRONG_REPORT_STATUS_WHEN_CHANGE_PARAM_IN_PA
	virtual	string	GetAutoUpdateType(int nExecMode);
	///------ End WRONG_REPORT_STATUS_WHEN_CHANGE_PARAM_IN_PA	
	
	/// Iris 3/18/2011 ORG-2427 STATS_ON_COLS_SUPPORT_FLAT_SHEET_REPORT
	virtual bool IsReportHierarchySheet(TreeNode& trGUI) { return true; }
	///End STATS_ON_COLS_SUPPORT_FLAT_SHEET_REPORT
	
	/// Iris 3/25/2011 ORG-2528-P1 FIX_BOXCHART_PLOT_IN_ONE_GRAPH_ISSUE_IN_STATS_ON_COLS
	virtual DWORD GetInputRangeType() { return NTYPE_BOOKSHEET_XY_RANGE; }
	virtual DWORD GetAddPlotOptions() { return GAP_USE_TEMPLATE | GAP_DO_NOT_MAKE_CATEGORICAL; }
	///End FIX_BOXCHART_PLOT_IN_ONE_GRAPH_ISSUE_IN_STATS_ON_COLS

	///------ Folger 06/02/2011 ORG-2858 SUPPORT_DUPLICATE_ANALYSIS_OPERATION
	BOOL			IsInputOneData();
	virtual	BOOL	IsSkipForDuplicateAnalysis(DataRange& dr);
	virtual	BOOL	DuplicateOneAnalysis();
	///------ End SUPPORT_DUPLICATE_ANALYSIS_OPERATION

private:	
	/// Iris 9/10/2009 QA80-11710-P2 IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
	bool 	checkIfAlwaysOnlyOneGraph(TreeNode& trOp, int nGraphIndex);
	void	arrangeReportGraphLayers(TreeNode& trOp, int nGraphIndex, GraphPage& gp, int nNumLayers);
	///end IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
	
	//moved from protected
	//------ Folger 05/22/08 QA80-11574 SUPPORT_GET_ALL_OPERATION_OUTPUT_SHEET_NAME_WITH_GLOBAL_STRING_VARIABLES
	//virtual	DWORD	GenerateReport(Datasheet& ds, TreeNode& trResult, int nNumInHeading = 0, BOOL bHierarchy = FALSE)
	virtual	DWORD		generateReport(Datasheet& ds, TreeNode& trResult, int nNumInHeading = 0, BOOL bHierarchy = FALSE, int nOutputOption = OUTPUT_PARTIAL_REGRESSION_CURVES_SHEET);
	//------ End SUPPORT_GET_ALL_OPERATION_OUTPUT_SHEET_NAME_WITH_GLOBAL_STRING_VARIABLES	
	///Arvin 11/20/06 SURFACE_FIT_SET_XY_MAP
	virtual void		getXYMap(TreeNode& trResult, int& nRows, int& nCols, double& xMin, double& xMax, double& yMin, double& yMax);
	///end SURFACE_FIT_SET_XY_MAP	///Iris 9/21/06 MULTI_INDEP_PLOTS_NEED_OUT_MATRIX_GRAPH
	//------ Folger 11/18/08 QA80-12574 v8.0974 SUPPORT_RESET_ALL_GRAPHS_IN_ERPORT_SHEET
	/////// TD 8-8-06 QA70-8882 ATTACH_GRAPH_TO_WKS_CELLS
	////DWORD	 oneGraph(TreeNode& trOp, int nGraphIndex, int nPictureIndex);
	/////// end ATTACH_GRAPH_TO_WKS_CELLS
	
	/// Iris 9/10/2009 QA80-11710-P2 IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
	//DWORD				oneGraph(TreeNode& trOp, int nGraphIndex, int nPicRowIndex, int nPicColIndex = 0, bool bResetGraphs = false);
	/// Iris 12/08/2010 ORG-1621-P2 FITCURVE_PLOT_BLACK_COLOR_WHEN_MULTI_DATA_COME_FROM_DIFF_LAYERS
	//DWORD				oneGraph(TreeNode& trOp, int nGraphIndex, int nPicRowIndex, int nPicColIndex = 0, int nPlotIndex = 0, bool bResetGraphs = false);
	DWORD				oneGraph(TreeNode& trOp, int nGraphIndex, int nPicRowIndex, int nPicColIndex = 0, int nPlotIndex = 0, bool bResetGraphs = false, int nExecMode = OEXEM_ON_CREATE);
	///End FITCURVE_PLOT_BLACK_COLOR_WHEN_MULTI_DATA_COME_FROM_DIFF_LAYERS
	///end IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
	//------ End SUPPORT_RESET_ALL_GRAPHS_IN_ERPORT_SHEET
	///end MULTI_INDEP_PLOTS_NEED_OUT_MATRIX_GRAPH
	/// Iris 9/14/04 MOVE_INPUT_DATAPLOT_TO_BASE_CLASS
	//---Iris 9/21/06 MULTI_INDEP_PLOTS_NEED_OUT_MATRIX_GRAPH
	//virtual int AddWksInputDataPlot(int index, GraphLayer& gl, const TreeNode& trOp, 
	//		int PlotType = IDM_PLOT_SCATTER, bool bRescale = true)
	/// Iris 08/01/2007 QA70-10133 ONLY_RECALCULATE_TIME_NEED_CHECK_RESCALE_IF_DATA_OUTSIDE
	//virtual int AddWksInputDataPlot(int index, GraphLayer& gl, const TreeNode& trOp, 
	//		int nPlotType = IDM_PLOT_SCATTER, bool bRescale = true, int nXIndex = 0, int nYIndex = 0)
	virtual int			addWksInputDataPlot(int index, GraphLayer& gl, const TreeNode& trOp, int nGraphIndex = 0,
											int nPlotType = IDM_PLOT_SCATTER, bool bRescale = true, int nXIndex = 0, int nYIndex = 0);
	///end ONLY_RECALCULATE_TIME_NEED_CHECK_RESCALE_IF_DATA_OUTSIDE
	//---
	///End MOVE_INPUT_DATAPLOT_TO_BASE_CLASS	/// ML 5/15/2006 SPECIAL_NLFITS_CUSTOM_TABLE
	virtual	string		getClassNameForCustomTableTheme();
	/// end SPECIAL_NLFITS_CUSTOM_TABLE
	/// ML 6/7/2006 QA70-4434 CUSTOM_TABLES_FOR_FIND_XY
	/// ML 7/21/2006 QA70-4434 CUSTOM_TABLES_FOR_FIND_XY_HOOKING_IMPLEMENTING_COLUMN_FORMULA
	//virtual	bool	addAdditionalCustomTables(TreeNode &trOp)
	virtual	bool		addAdditionalCustomTables(TreeNode &trOp, int index, int nNumData)
	/// end CUSTOM_TABLES_FOR_FIND_XY_HOOKING_IMPLEMENTING_COLUMN_FORMULA
	{
		return false;
	}
	/// end CUSTOM_TABLES_FOR_FIND_XY
	BOOL	getCombinedString(string &str, DWORD dwCombined);
	string	getReportOutputSheetName(const TreeNode& trGUI, int* pnSpecialType = NULL);
	string	getReportOutputBookName(const TreeNode& trGUI, int* pnSpecialType = NULL);
	string	getCurveOutputSheetName(const TreeNode& trGUI, int nOutputIndex, int* pnSpecialType = NULL);
	/// Iris 8/31/2009 QA80-14209 IMPROVE_CREATE_MASKED_MISSING_DATA_TABLE_SPEED
	//bool	setMaskedOrMissingDataTable(DataRange &dr, TreeNode &trTable, LPCSTR lpcszMainLabel, LPCSTR lpcszXDataLabel, LPCSTR lpcszWeightLabel, int index, DWORD dwRules, bool bMissingData = false, LPCSTR lpcszYIndepDataLabel = NULL, LPCSTR lpcszDataLabel = NULL);
	bool	setMaskedOrMissingDataTable(bool bCreateTable, DataRange &dr, TreeNode &trTable, LPCSTR lpcszMainLabel, LPCSTR lpcszXDataLabel, LPCSTR lpcszWeightLabel, int index, DWORD dwRules, bool bMissingData = false, LPCSTR lpcszYIndepDataLabel = NULL, LPCSTR lpcszDataLabel = NULL
		///------ Folger 09/06/2011 ORG-3706-P1 SUPPRT_SHOW_XERROR_IN_MASKED_DATA_AND_BAD_DATA_REPORT_TABLE
		, LPCSTR lpcszXErrorLabel = NULL
		///------ End SUPPRT_SHOW_XERROR_IN_MASKED_DATA_AND_BAD_DATA_REPORT_TABLE
		/// Zech 08/22/2012 ORG-5703-P1 OPERATION_SUPPORT_IGNORE_HIDDEN_ROW
		, DWORD dwRules2 = 0
		/// END OPERATION_SUPPORT_IGNORE_HIDDEN_ROW
		);
	///end IMPROVE_CREATE_MASKED_MISSING_DATA_TABLE_SPEED 
	bool	isOutputInsertColsToDataSheet(const TreeNode& trGUI, bool& bInsertCurves, int nOutputIndex = OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET);
	bool	isOutputReportSheet(const TreeNode& trGUI); 
	virtual void	filterReportForResultsLog(TreeNode& trOperation); //CPY 8/4/04 //moved to private
	virtual uint	reportPlotTypeGrouppingMethod(int nPlotType);
	virtual bool	applyThemeToReportSheet(TreeNode& trOp, DataRange& rgReport, int nTotalNumData);
	/// Iris 3/08/2011 ORG-402-S8 IMPROVE_SURFACE_FIT_REPORT_DATA_LABEL
	//bool	applyThemeToResultCurveTable(TreeNode& trOp, DataRange& rgReport, int nTableID);  /// Iris 9/14/05 SEPARATE_APPLY_THEME_TO_RESULT_CURVE_TABLE_CODE
#ifndef __STATS_ON_COLS_SUPPORT_FLAT_SHEET_REPORT__ /// Iris 7/22/2011 ORG-2427-S3 FLAT_SHEET_IMPROVEMENT
	virtual bool	applyThemeToResultCurveTable(TreeNode& trOp) { return false; }
	/// Iris 7/22/2011 ORG-2427-S3 FLAT_SHEET_IMPROVEMENT
#else
	virtual bool	applyThemeToResultCurveTable(TreeNode& trOp, Worksheet& wksOutput) { return false; }
#endif //__STATS_ON_COLS_SUPPORT_FLAT_SHEET_REPORT__
	///End FLAT_SHEET_IMPROVEMENT
	///End IMPROVE_SURFACE_FIT_REPORT_DATA_LABEL
	bool 			isPolarSwappedSourcePlot(const TreeNode& trOp, int nDataIndex = 0);//moved from protected
	virtual int		plotResultsTableInLayer(TreeNode& trOp, GraphLayer& gl, DataPlot& dp, TreeNode& trPlotInfo, int nDataIndex, int* pnPlot = NULL, int* pnNumPlots = NULL, int nGraphIndex = GRAPH_FIT_CURVE, int nPictureIndex = 0, int nPicColIndex = 0, BOOL bSourceGraph = FALSE, bool bCheckIfHasPlot = false);//moved from protected
	int 			afterPlotResultCurve(TreeNode& trOp, GraphLayer& gl, int nDataIndex, int nGraphIndex, int nPictureIndex, int nPlotType, int nStartPlotIndex, int nEndPlotIndex = -1, bool bSourceGraph = false, DataRange* pdrFitCurvesRange = NULL); /// Iris 12/08/2008 V8.0982 QA80-12737 FIX_STATS_ON_COL_BOX_PLOT_ALL_IN_ONE_GRAPH_LEGEND_NOT_LIST_ALL_PLOTS
	///------ Folger 05/17/2012 ORG-5592-P1 ONLY_SET_REPORT_TREE_WHEN_CHANGE_DATA_IDENTIFIER
	//void			prepareGraphNodes(TreeNode& trOp, int nGraphIndex = -1);//CPY 12/31/04 PICTURE_IN_REPORT_IN_BASE_CLASS //moved from protected
	void			prepareGraphNodes(TreeNode& trOp, int nGraphIndex = -1, bool bNoResetGraph = false);
	///------ End ONLY_SET_REPORT_TREE_WHEN_CHANGE_DATA_IDENTIFIER
	/// YuI 07/10/08 this function is not needed. Commenting it out
	//	virtual bool	checkResolveInputData(TreeNode& trGUI);//moved from protected
	/// end YuI
	
	/// Iris 12/09/2009 QA81-3224-P6 FIX_NOT_PLOT_ERR_COL_IN_LRXERR_REPORT_GRAPH_WHEN_OPEN_DLG_FROM_GRAPH
	//virtual bool	isSourceHasErrBar(const TreeNode& trOp, int nDataIndex = 0);//moved from protected
	virtual bool	isSourceHasErrBar(const TreeNode& trOp, int nDataIndex = 0, Column* pcolErr = NULL, bool bIsXErr = false);
	///end FIX_NOT_PLOT_ERR_COL_IN_LRXERR_REPORT_GRAPH_WHEN_OPEN_DLG_FROM_GRAPH
	
	/// ML 7/26/2006 QA70-8856 PASTING_THEME_WITH_LINKS_OUTSIDE_OF_REPORT
	///------ Folger 10/13/2010 ORG-1210-S2 CREATE_NEW_TABLE_OBJ_FOR_FITTER_OPERATION_IF_WKS_WITHIN_HAS_NO_LINK
	//bool			addResultsTblToSourceGraph(TreeNode& trOp, GraphLayer &gl, const DataRange &rReportSheetOutput);
	bool			addResultsTblToSourceGraph(TreeNode& trOp, GraphLayer &gl, const DataRange &rReportSheetOutput, BOOL bUpdateOnlyIfNewTable);
	///------ End CREATE_NEW_TABLE_OBJ_FOR_FITTER_OPERATION_IF_WKS_WITHIN_HAS_NO_LINK
	/// end PASTING_THEME_WITH_LINKS_OUTSIDE_OF_REPORT
	/// Hong 08/12/08 QA80-11986 FIX_FITTED_CURVE_PLOT_FAIL_RESCALE_WHEN_SOURCE_PLOT_HAVE_ERR_BAR
	//int		 		plotResultInLayer(int nDataIndex, TreeNode& trPlotInfo, TreeNode& trOp, GraphLayer& gl, int nGraphIndex, int nPictureIndex = 0, int nPicColIndex = 0, bool bIsSourceGraph = false);//moved from protected
	//------ Folger 11/18/08 QA80-12574 v8.0974 SUPPORT_RESET_ALL_GRAPHS_IN_ERPORT_SHEET
	//int		 		plotResultInLayer(int nDataIndex, TreeNode& trPlotInfo, TreeNode& trOp, GraphLayer& gl, int nGraphIndex, int nPictureIndex = 0, int nPicColIndex = 0, bool bIsSourceGraph = false, int* pnFittedPlotIndex = NULL);//moved from protected
	/// Iris 12/08/2010 ORG-1621-P2 FITCURVE_PLOT_BLACK_COLOR_WHEN_MULTI_DATA_COME_FROM_DIFF_LAYERS
	//int		 		plotResultInLayer(int nDataIndex, TreeNode& trPlotInfo, TreeNode& trOp, GraphLayer& gl, int nGraphIndex, int nPictureIndex = 0, int nPicColIndex = 0, bool bIsSourceGraph = false, int* pnFittedPlotIndex = NULL, bool bResetGraphs = false);//moved from protected
	int		 		plotResultInLayer(int nDataIndex, TreeNode& trPlotInfo, TreeNode& trOp, GraphLayer& gl, int nGraphIndex, int nPictureIndex = 0, int nPicColIndex = 0, bool bIsSourceGraph = false, int* pnFittedPlotIndex = NULL, bool bResetGraphs = false, int nExecMode = OEXEM_ON_CREATE);//moved from protected
	///End FITCURVE_PLOT_BLACK_COLOR_WHEN_MULTI_DATA_COME_FROM_DIFF_LAYERS
	//------
	/// end FIX_FITTED_CURVE_PLOT_FAIL_RESCALE_WHEN_SOURCE_PLOT_HAVE_ERR_BAR
	//moved from protected
	//------ Folger 11/18/08 QA80-12574 v8.0974 SUPPORT_RESET_ALL_GRAPHS_IN_ERPORT_SHEET
	//bool			plotReportGraphs(TreeNode& trPlotInfo, TreeNode& trOp, GraphLayer& gl, int nGraphIndex, int nPicRowIndex = 0, int nPicColIndex = 0);
	/// Iris 12/08/2010 ORG-1621-P2 FITCURVE_PLOT_BLACK_COLOR_WHEN_MULTI_DATA_COME_FROM_DIFF_LAYERS
	//bool			plotReportGraphs(TreeNode& trPlotInfo, TreeNode& trOp, GraphLayer& gl, int nGraphIndex, int nPicRowIndex = 0, int nPicColIndex = 0, bool bResetGraphs = false);
	bool			plotReportGraphs(TreeNode& trPlotInfo, TreeNode& trOp, GraphLayer& gl, int nGraphIndex, int nPicRowIndex = 0, int nPicColIndex = 0, bool bResetGraphs = false, int nExecMode = OEXEM_ON_CREATE);
	///End FITCURVE_PLOT_BLACK_COLOR_WHEN_MULTI_DATA_COME_FROM_DIFF_LAYERS
	//------
	/// Hong 08/12/08 QA80-11986 FIX_FITTED_CURVE_PLOT_FAIL_RESCALE_WHEN_SOURCE_PLOT_HAVE_ERR_BAR
	//int				plotReportGraph(int nDataIndex, TreeNode& trPlotInfo, TreeNode& trOp, GraphLayer& gl, int nGraphIndex = 0, int nPictureIndex = 0, int nPicColIndex = 0);
	//------ Folger 11/18/08 QA80-12574 v8.0974 SUPPORT_RESET_ALL_GRAPHS_IN_ERPORT_SHEET
	//int				plotReportGraph(int nDataIndex, TreeNode& trPlotInfo, TreeNode& trOp, GraphLayer& gl, int nGraphIndex = 0, int nPictureIndex = 0, int nPicColIndex = 0, int* pnFittedPlotIndex = NULL);
	/// Iris 12/08/2010 ORG-1621-P2 FITCURVE_PLOT_BLACK_COLOR_WHEN_MULTI_DATA_COME_FROM_DIFF_LAYERS
	//int				plotReportGraph(int nDataIndex, TreeNode& trPlotInfo, TreeNode& trOp, GraphLayer& gl, int nGraphIndex = 0, int nPictureIndex = 0, int nPicColIndex = 0, int* pnFittedPlotIndex = NULL, bool bResetGraphs = false);
	int				plotReportGraph(int nDataIndex, TreeNode& trPlotInfo, TreeNode& trOp, GraphLayer& gl, int nGraphIndex = 0, int nPictureIndex = 0, int nPicColIndex = 0, int* pnFittedPlotIndex = NULL, bool bResetGraphs = false, int nExecMode = OEXEM_ON_CREATE);
	///End FITCURVE_PLOT_BLACK_COLOR_WHEN_MULTI_DATA_COME_FROM_DIFF_LAYERS
	//------
	/// emd FIX_FITTED_CURVE_PLOT_FAIL_RESCALE_WHEN_SOURCE_PLOT_HAVE_ERR_BAR

	///Cheney 2007-5-4 FITCURVE_AND_RESIDUAL_COULD_PUT_INTO_MAT_LAYER_WHEN_FIT_MAT
	//bool	doReportSheet(TreeNode& trOperation, bool bFirstPhase, bool bSecondPhase, int	nNumInHeading, Worksheet& wksOutput, Worksheet& wksInput1stRange,
	//			DataRange &rgReportSheetOutput, bool &bNewBookCreated);
	bool			doReportSheet(TreeNode& trOperation, bool bFirstPhase, bool bSecondPhase, int	nNumInHeading, Worksheet& wksOutput, const Datasheet& dsInput1stRange,
									/// Iris 12/08/2010 ORG-1621-P2 FITCURVE_PLOT_BLACK_COLOR_WHEN_MULTI_DATA_COME_FROM_DIFF_LAYERS
									//DataRange &rgReportSheetOutput, bool &bNewBookCreated);
									DataRange &rgReportSheetOutput, bool &bNewBookCreated, int nExecMode);
									///End FITCURVE_PLOT_BLACK_COLOR_WHEN_MULTI_DATA_COME_FROM_DIFF_LAYERS
	///end FITCURVE_AND_RESIDUAL_COULD_PUT_INTO_MAT_LAYER_WHEN_FIT_MAT

	/// Sophy 5/05/2008 QA80-10934-P5 v8.0856 SUPPORT_SEPARATE_FINDXY_OUTPUT_SHEET_NAME
	//bool	doResultsCurveSheet(TreeNode& trOperation, TreeNode& trCurveBranch, const Datasheet& dsInput1stRange, int nIndex, string& strSheetName, string& strBookName, int nOption = OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET, bool bSeparateSheetForDataset = false, Worksheet* pwksReport = NULL,  Datasheet* pdsFitCurve = NULL, int nExeMode = 0, bool bRemovePloyRange = false);	
	bool			doResultsCurveSheet(TreeNode& trOperation, TreeNode& trCurveBranch, const Datasheet& dsInput1stRange, int nIndex, string& strSheetName, string& strBookName, int nOption = OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET, bool bSeparateSheetForDataset = false, Worksheet* pwksReport = NULL,  Datasheet* pdsFitCurve = NULL, int nExeMode = 0, bool bRemovePloyRange = false, int nSheetNameIndex = 0);
	/// End SUPPORT_SEPARATE_FINDXY_OUTPUT_SHEET_NAME

	bool			insertUpdateLabelToReportGraph(TreeNode& trOp, GraphLayer& gl, const string& strLabel, LPCSTR lpcszName = NULL);	//moved from protected
	/// ML 10/13/2005 QA70-8157 SPECIAL_NAMES_STYLES_IN_FLAT_SHEETS
	BOOL			setThemeToResultsCurveSheet(Worksheet &wksFitCurves, DWORD dwResultCurvesReportID);
	/// end SPECIAL_NAMES_STYLES_IN_FLAT_SHEETS
	bool			isMultiPlotFit(TreeNode trGUI);//moved from protected
	string			getResultCurveBookLongName(TreeNode& trOperation, int nIndex = 0, int nOption = -1, bool bSeparateSheetForDataset = false);//moved from protected
	void			setGraphLayerXScale(GraphPage& gp, int nLayerIndex, double dxMin, double dxMax); //moved from protected		

	
	/// ML 2/14/2007 QA70-9374 BAD_EVENT_HANDLER_DWORDS_IN_TREENODES
	virtual	bool	updateEventHandlers(TreeNode &trOp);
	/// end BAD_EVENT_HANDLER_DWORDS_IN_TREENODES
	/// ML 3/1/2007 QA70-9421 UPDATE_TRGUI_TO_CURRENT_BEFORE_RUNNING
	/// YuI 11/19/07 QA70-10716 GUI_LOCALIZATION_ON_CHANGE_PARAM
	//	virtual	bool	updateTreeBeforeRunning(TreeNode &trOp = NULL);  
	virtual	bool	updateTreeBeforeRunning(TreeNode &trOp = NULL, BOOL bLocalize = FALSE);
	/// end GUI_LOCALIZATION_ON_CHANGE_PARAM
	/// end UPDATE_TRGUI_TO_CURRENT_BEFORE_RUNNING

	/// ML 11/20/2007 QA70-10716 INPUT_DATA_NODE_PROPER_LANGUAGE_WHEN_LOADING_OPER
	virtual	int		getLocUpdateInputDataStringsMode();
	bool			onLocUpdateInputDataStrings(TreeNode &trInputDataConstructed, TreeNode &trInputDataLoaded, TreeNode& trOp);
	virtual	bool	customLocUpdateInputDataStrings(TreeNode &trInputDataConstructed, TreeNode &trInputDataLoaded);
	/// end INPUT_DATA_NODE_PROPER_LANGUAGE_WHEN_LOADING_OPER
	int				cleanUpTempWksGraphs(TreeNode& trOp);
	
	void			constructAddOutputGraph(TreeNode& trOp, int nGraphIndex = 0);  ///Iris 01/19/05 CLEANUP_CONSTRUCT_ADD_GRAPH
	
	/// Iris 01/26/2007 v8.0548 REPORT_GRAPH_X_AXIS_TYPE_SAME_AS_SOURCE_GRAPH
	//bool applyFormatFromReportToSourcePage(GraphLayer& gl, int nDataIndex, int nGraphIndex = 0);   /// Iris 5/19/05 QA70-6365 SETUP_FITY_CONFID_PRODI_LINE_COLOR
	bool			setFormatFromSourceGraphToReport(TreeNode& trOp, GraphLayer& glReport, int nGraphIndex = 0, int nDataIndex = 0 );
	///end REPORT_GRAPH_X_AXIS_TYPE_SAME_AS_SOURCE_GRAPH

	/// Iris 08/06/2007 v8.0674 NOT_PLOT_AGAIN_IF_PLOTTED_FOR_REPORT_GRAPH
	bool			checkIfPlotAgain(TreeNode& trOp, const GraphLayer& gl, int nGraphIndex, int nDataIndex, bool bIsSourceGraph);
	///end NOT_PLOT_AGAIN_IF_PLOTTED_FOR_REPORT_GRAPH
	
	/// Iris 08/07/2007 v8.0674 NOT_PLOT_AGAIN_IF_PLOTTED_FOR_REPORT_AND_SOURCE_GRAPH
	///Sophy 12/24/2008 v8.0990 QA80-12832 SUPPORT_MULTI_DATASET_FOR_MULTI_INDEPS_AND_DEPS_FITTING	
	//void			setSourceGraphIdUIDtoMap(TreeNode &trOp, int nGraphIndex, int nDataIndex, DWORD dwGraphUID);
	//bool			getSourceGraphIdUIDtoMap(TreeNode &trOp, int nGraphIndex, int nDataIndex, DWORD &dwGraphUID);
	//bool			hasPlottedOnSourceGraph(TreeNode &trOp, int nGraphIndex, int nDataIndex);
	/// Iris 3/25/2011 ORG-2515-P2 FIX_SWITCH_XY_DATATYPE_FROM_LINEAR_TO_SAMEASINPUT_FOR_SURFACE_FIT_WITH_CONTOUR_GRAPH_CRASH
	//void			setSourceGraphIdUIDtoMap(TreeNode &trOp, int nGraphIndex, int nPicIndex, DWORD dwGraphUID);
	///End FIX_SWITCH_XY_DATATYPE_FROM_LINEAR_TO_SAMEASINPUT_FOR_SURFACE_FIT_WITH_CONTOUR_GRAPH_CRASH
	bool			getSourceGraphIdUIDtoMap(TreeNode &trOp, int nGraphIndex, int nPicIndex, DWORD &dwGraphUID);
	///------ Folger 12/18/09 QA81-14860 NLFIT_RECALCULATE_FAIL_TO_GET_SOURCE_GRAPH
	//bool			hasPlottedOnSourceGraph(TreeNode &trOp, int nGraphIndex, int nPicIndex);
	/// Iris 3/25/2011 ORG-2515-P2 FIX_SWITCH_XY_DATATYPE_FROM_LINEAR_TO_SAMEASINPUT_FOR_SURFACE_FIT_WITH_CONTOUR_GRAPH_CRASH
	//bool			hasPlottedOnSourceGraph(TreeNode &trOp, int nGraphIndex, int nPicIndex, BOOL bCheckUIDOnly = FALSE);
	///End FIX_SWITCH_XY_DATATYPE_FROM_LINEAR_TO_SAMEASINPUT_FOR_SURFACE_FIT_WITH_CONTOUR_GRAPH_CRASH
	///------ End NLFIT_RECALCULATE_FAIL_TO_GET_SOURCE_GRAPH
	///end SUPPORT_MULTI_DATASET_FOR_MULTI_INDEPS_AND_DEPS_FITTING
	////end NOT_PLOT_AGAIN_IF_PLOTTED_FOR_REPORT_AND_SOURCE_GRAPH

	/// Iris 3/25/2011 ORG-2515-P2 FIX_SWITCH_XY_DATATYPE_FROM_LINEAR_TO_SAMEASINPUT_FOR_SURFACE_FIT_WITH_CONTOUR_GRAPH_CRASH
	virtual void resetResultPlotFromSourceGraph(TreeNode& trOperation, int nTotalNumData) { return; }
	///End FIX_SWITCH_XY_DATATYPE_FROM_LINEAR_TO_SAMEASINPUT_FOR_SURFACE_FIT_WITH_CONTOUR_GRAPH_CRASH

	/// YuI 8/24/04 QA70-4387 NLFITTER_OPERATION_IMPLEMENTATION
	//	BOOL	executeWithRange();
	virtual BOOL	executeWithRange(int nExeMode = OEXEM_ON_CREATE, DWORD dwExecCntrl = 0);
	/// end NLFITTER_OPERATION_IMPLEMENTATION
	
	/// Iris 08/13/2007 v8.0680 QA70-10212-P2 FAIL_TO_REMOVE_ORIGINAL_SOURCE_DATAPLOT
	bool			isSourceDataPlot(DataPlot &dp);
	/// Hong 11/15/08 QA80-12584 v8.0972 SBUTRACTED_DATA_IS_FIT_SRC_DATA_AND_SHOULD_REPLACE_DRAW_SRC_DATA
	//void			beforePlotReportGraph(TreeNode& trOp, GraphLayer &gl);
	///------ Folger 10/26/2011 ORG-4204-P1 SOURCE_DATA_PLOT_MISSING_AFTER_PA_CHANGE_PARAM_NO_SUBTRACT_BASELINE
	//void			beforePlotReportGraph(TreeNode& trOp, GraphLayer &gl, int nDataIndex);
protected:
	virtual	void			beforePlotReportGraph(TreeNode& trOp, GraphLayer &gl, int nDataIndex);
	
	/// Iris 4/19/2012 ORG-5481-S1 SURFACE_FIT_FITTED_CURVE_SUPPORT_XYZ_SURFACE_PLOT
	bool 	GetReportGraph(GraphPage& gp, int nGraphIndex, int nPicIndex);
	///End SURFACE_FIT_FITTED_CURVE_SUPPORT_XYZ_SURFACE_PLOT
	
private:
	///------ End SOURCE_DATA_PLOT_MISSING_AFTER_PA_CHANGE_PARAM_NO_SUBTRACT_BASELINE
	/// end SBUTRACTED_DATA_IS_FIT_SRC_DATA_AND_SHOULD_REPLACE_DRAW_SRC_DATA
	///end FAIL_TO_REMOVE_ORIGINAL_SOURCE_DATAPLOT
	bool			isCalibrationPolyRangeExist(int nDataIndex, bool bFindX = true); ///Cheney 2007-9-3 QA70-10331 SHOULD_DESTROY_LOCK_IF_UNCHECK_FINDXY_WHEN_CHANGE_PARAM


	/*
		TreeNode trOut = trOperation.Calculation; // Calculation node should have already been prepared in base class
		trOut.Graphs.ID = IDST_RESULT_GRAPHS;
		//trOut.Graphs.Heading.ID = IDE_HEADING1;
		trOut.Graphs.Image.ID = IDE_IMAGE;
	*/
	//------ Folger 11/18/08 QA80-12574 v8.0974 SUPPORT_RESET_ALL_GRAPHS_IN_ERPORT_SHEET
	///// Iris 9/19/05 QA70-7889 PASTE_CUSTOM_TABLE_TO_FIT_CURVE_GRAPH_TABLE
	////bool addGraphsToReport(Worksheet& wksData, Worksheet& wksReport, DataRange& rReport, TreeNode& trOp);
	////bool addOneGraphTypeToReport(Worksheet& wksData, Worksheet& wksReport, DataRange& rReport, TreeNode& trOp, int nGraphIndex);
	/////End PASTE_CUSTOM_TABLE_TO_FIT_CURVE_GRAPH_TABLE
	/// virtual
	/// Iris 12/08/2010 ORG-1621-P2 FITCURVE_PLOT_BLACK_COLOR_WHEN_MULTI_DATA_COME_FROM_DIFF_LAYERS
	//bool			addGraphsToReport(TreeNode& trOp, Worksheet& wksReport, DataRange& rgReportSheetOutput = NULL, bool bResetGraphs = false);
	//bool			addOneGraphTypeToReport(Worksheet& wksReport, DataRange& rgReportSheetOutput, TreeNode& trOp, int nGraphIndex, bool bResetGraphs = false);
	bool			addGraphsToReport(TreeNode& trOp, Worksheet& wksReport, int nExecMode, DataRange& rgReportSheetOutput = NULL, bool bResetGraphs = false);
	bool			addOneGraphTypeToReport(Worksheet& wksReport, DataRange& rgReportSheetOutput, TreeNode& trOp, int nGraphIndex, int nExecMode, bool bResetGraphs = false);
	///End FITCURVE_PLOT_BLACK_COLOR_WHEN_MULTI_DATA_COME_FROM_DIFF_LAYERS
	//------ End SUPPORT_RESET_ALL_GRAPHS_IN_ERPORT_SHEET
	TreeNode		getOnePictureNode(TreeNode& trOp, int nGraphIndex, int nDataIndex); /// Iris 07/30/2007 QA70-10073 TO_KEEP_CUSTOMIC_SETTINGS_IN_REPORT_GRAPH
	/// Iris 08/01/2007 QA70-10073 FIND_BETTER_WAY_TO_CHECK_IF_GRAPH_EXISTS
	//bool	hasPlottedReportCurve(TreeNode& trOp, int nGraphIndex, int nDataIndex); /// Iris 08/01/2007 QA70-10133 ONLY_RECALCULATE_TIME_NEED_CHECK_RESCALE_IF_DATA_OUTSIDE
	/// Iris 08/02/2007 v8.0673 QA70-10073 FIX_JUNK_GRAPH_EXISTED_AFTER_CHANGE_REPORT_GRAPH_ARRANGEMENT
	/*
	bool	isReportGraphExisted(TreeNode& trOp, int nGraphIndex, int nDataIndex);
	bool	isReportGraphExisted(int nGraphIndex, int nPicRowIndex, int nPicColIndex);
	*/
	///Sophy 12/24/2008 v8.0990 QA80-12832 SUPPORT_MULTI_DATASET_FOR_MULTI_INDEPS_AND_DEPS_FITTING
	//bool			hasPlottedOnReportGraph(int nGraphIndex, int nDataIndex);
	bool			hasPlottedOnReportGraph(int nGraphIndex, int nPicIndex);
	///end SUPPORT_MULTI_DATASET_FOR_MULTI_INDEPS_AND_DEPS_FITTING
	///end FIX_JUNK_GRAPH_EXISTED_AFTER_CHANGE_REPORT_GRAPH_ARRANGEMENT
	///end FIND_BETTER_WAY_TO_CHECK_IF_GRAPH_EXISTS
	
	//------ Folger 11/18/08 QA80-12574 v8.0974 SUPPORT_RESET_ALL_GRAPHS_IN_ERPORT_SHEET
	//bool			addOneGraphPicture(int nCreateType, TreeNode& trOp, TreeNode& trImage, int nGraphIndex, int nPicRow, int nPicCol, DataRange& rReport, DWORD *pdwGraphUID = NULL);
	/// Iris 9/10/2009 QA80-11710-P2 IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
	//bool			addOneGraphPicture(int nCreateType, TreeNode& trOp, TreeNode& trImage, int nGraphIndex, int nPicRow, int nPicCol, DataRange& rReport, DWORD *pdwGraphUID = NULL, bool bResetGraphs = false);
	/// Iris 12/08/2010 ORG-1621-P2 FITCURVE_PLOT_BLACK_COLOR_WHEN_MULTI_DATA_COME_FROM_DIFF_LAYERS
	//bool			addOneGraphPicture(int nCreateType, TreeNode& trOp, TreeNode& trImage, int nGraphIndex, int nPicRow, int nPicCol, int nPlotIndex, DataRange& rReport, DWORD *pdwGraphUID = NULL, bool bResetGraphs = false);
	bool			addOneGraphPicture(int nCreateType, TreeNode& trOp, TreeNode& trImage, int nGraphIndex, int nPicRow, int nPicCol, int nPlotIndex, DataRange& rReport, int nExecMode, DWORD *pdwGraphUID = NULL, bool bResetGraphs = false);
	///End FITCURVE_PLOT_BLACK_COLOR_WHEN_MULTI_DATA_COME_FROM_DIFF_LAYERS
	///end IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
	//------
	
	void			setDataPlotEventHandler(DataPlot& dp, int nDataIndex);
	/// end PICTURE_IN_REPORT_IMPROVEMENT	

	//--- CPY 12/31/04 PICTURE_IN_REPORT_IN_BASE_CLASS
	/*
	/// Iris 10/27/04 PLOT_REPORT_WITHOUT_X_DATA, FreqCount need only plot on Y Column with default X Values like Row Number.
	//int PlotReportXYData(GraphLayer gl, DataRange rReport, uint unTableID, uint unXID, uint unYID, int nPlotType, XYRange* pXY = NULL, int nColor = -1)
	int PlotReportXYData(GraphLayer gl, DataRange rReport, uint unTableID, int nPlotType, uint unYID, uint unXID, XYRange* pXY = NULL, int nColor = -1)

	{
		Worksheet wks;
		/// Iris 10/27/04 PLOT_REPORT_WITHOUT_X_DATA
		int nXcol = -1; //CPY add -1
		if(0 != unXID)
		{
			nXcol = GetWksCol(rReport, unTableID, unXID, &wks);
			if(nXcol < 0)
			{
				//	return error_report("plotFitCurve found nXCol invalid");
				error_report("plotFitCurve found nXCol invalid");
				return -1;
			}
		}
		
		/// Iris 10/27/04 PLOT_REPORT_WITHOUT_X_DATA
		//int nYcol = GetWksCol(rReport, unTableID, unYID);
		int nYcol = GetWksCol(rReport, unTableID, unYID, &wks);
		if(nYcol < 0)
		{
			//	return error_report("plotFitCurve found nXCol invalid");
			error_report("plotFitCurve found nYCol invalid");
			return -1;
		}
		
		/// Iris 10/27/04 PLOT_REPORT_WITHOUT_X_DATA
		//Curve cuv(wks, nXcol, nYcol);
		Curve cuv;
		if(nXcol < 0)
			cuv.Attach(wks, nYcol);			
		else
			cuv.Attach(wks, nXcol, nYcol);
		////End  PLOT_REPORT_WITHOUT_X_DATA

		if(!cuv)
		{
			error_report("plotFitCurve found curve constructed but invalid");
			return -1;
		}
			
		if(cuv.GetUpperIndex() > 1)
		{
			int nPlot = gl.AddPlot(cuv, nPlotType);//IDM_PLOT_LINE);
			if(nPlot >= 0)
			{
				DataPlot dp = gl.DataPlots(nPlot);
				if(nColor >= 0)
					dp.SetColor(nColor);

				//-------- CPY 8/8/04 BETTER_RESCALE_ON_FIT_GRAPHS
				if(pXY)
				{
					double xmin, xmax, ymin, ymax;
					Curve_MinMax(&cuv, &xmin, &xmax, true, &ymin, &ymax);
					checkMin(xmin, pXY->xMin);
					checkMax(xmax, pXY->xMax);
					checkMin(ymin, pXY->yMin);
					//checkMax(ymin, pXY->yMax);		///Iris 12/01/04
					checkMax(ymax, pXY->yMax);
				}
				//--------
				return nPlot;
			}
		}
		// empty col, no need to plot
		//error_report("plotFitCurve cannot construct valid Curve for adding to graph");
		return -1;
	}
	*/
//-------- CPY 8/8/04 BETTER_RESCALE_ON_FIT_GRAPHS

	/*
	void checkMax(double x1, double& xRef)
	{
		if(is_missing_value(xRef) || xRef < x1)
			xRef = x1;
	}
	void checkMin(double x1, double& xRef)
	{
		if(is_missing_value(xRef) || xRef > x1)
			xRef = x1;
	}
	*/
	void 			cleanAllSurplusReportData(TreeNode& trOp);//moved from public
	int 			getTotalNumSeparateSheet(const TreeNode& trOp);//moved from private
	virtual void	doAllResultsCurveSheet(TreeNode& trOperation, int nTotalNumData, Datasheet& dsInputFirstRange, Worksheet& wksOutput, Datasheet& dsFitCurve, bool bCreateResultsCurveSheet, bool bCreateResidualCurveSheet, bool bCreatePeakCharacterSheet, int nExeMode);//moved from public
	/// Iris 01/08/2007 v8.0538 REPORT_GRAPHS_ARRANGEMENT
	//virtual bool CheckCreateImagSubNodes(TreeNode& trOp, int nGraphIndex, int nDataIndex, TreeNode& trPict, TreeNode& trPlotInfo, LPCSTR lpcszLabel);	
	///------ Folger 05/17/2012 ORG-5592-P1 ONLY_SET_REPORT_TREE_WHEN_CHANGE_DATA_IDENTIFIER
	//virtual bool	checkCreateImagSubNodes(TreeNode& trOp, int nGraphIndex, TreeNode& trPict, TreeNode& trPlotInfo);	//moved from public
	virtual bool	checkCreateImagSubNodes(TreeNode& trOp, int nGraphIndex, TreeNode& trPict, TreeNode& trPlotInfo, bool bNoResetGraph = false);
	///------ End ONLY_SET_REPORT_TREE_WHEN_CHANGE_DATA_IDENTIFIER
	///end REPORT_GRAPHS_ARRANGEMENT
	
	/// Iris 9/27/2009 FIX_RESET_ALL_GRAPHS_WORK_FAILED
	//virtual
	bool			checkCreateImagInfoSubNodes(TreeNode& trOp, int nGraphIndex, TreeNode& trPlotInfo);
	///end FIX_RESET_ALL_GRAPHS_WORK_FAILED

	///Sophy 3/26/2009 QA80-13351 SUPPORT_ARRANGE_SAME_TYPE_PLOTS_IN_ONE_GRAPH_CONTEXT_MENU
	bool			resetOneGraph(TreeNode trGraph);
	///end SUPPORT_ARRANGE_SAME_TYPE_PLOTS_IN_ONE_GRAPH_CONTEXT_MENU

	///Arvin 08/28/07 QA70-10073 ALWAYS_REPLOT_HISTOGRAM_AND_BOXCHART_IF_PLOT_IN_ONE_GRAPH_NODE_VALID
	bool			isTreeNodePlotInOneGraphValid(TreeNode& trOperation);//moved from public
	///end ALWAYS_REPLOT_HISTOGRAM_AND_BOXCHART_IF_PLOT_IN_ONE_GRAPH_NODE_VALID
	///Arvin 05/25/07 CLEAN_SURPLUS_REPORT_DATA_WHILE_CHANGE_PARAMETER_TO_LESS_DATASET
	void			cleanSurplusReportData(TreeNode& trOp, int nOption);
	///end CLEAN_SURPLUS_REPORT_DATA_WHILE_CHANGE_PARAMETER_TO_LESS_DATASET
	///Iris 9/21/06 MULTI_INDEP_PLOTS_NEED_OUT_MATRIX_GRAPH
	//TreeNode	checkGetPlotInfoNode(TreeNode& trOp, int nGraphIndex, int nPicureIndex, int nPlotIndex = 0, bool bCreate = false);
	///Arvin 11/16/07 NLFIT_REPORT_GRAPH_NEED_RESCALE_WHILE_PART_GRAPH_SELECTION_AS_INPUT
	//TreeNode	checkGetPlotInfoNode(TreeNode& trOp, int nGraphIndex, int nPicRowIndex, int nPicColIndex = 0, int nPlotIndex = 0, bool bCreate = false);
	///end NLFIT_REPORT_GRAPH_NEED_RESCALE_WHILE_PART_GRAPH_SELECTION_AS_INPUT
	///End MULTI_INDEP_PLOTS_NEED_OUT_MATRIX_GRAPH
	/// Iris 10/13/06 v8.0495 OUTPUT_FIT_CURVE_TO_SOURCE_NOT_WORK
	bool			doInsertedColumns(TreeNode& trOperation, int nIndex, int nTotalNumData, Range& rngInput, int nOutputIndex = -1);
	///end OUTPUT_FIT_CURVE_TO_SOURCE_NOT_WORK
	
	void			putGraphUIDToReportTree(TreeNode& trOnePic, DWORD dwGraphUID);
	/// Iris 9/14/2009 QA80-11710-S1 PUT_REPORT_GRAPH_LABEL_AS_Y_AXES_TITLE
	TreeNode		getReportGraphRowLabelNode(TreeNode& trGraph, int nIndex, bool bCreate);
	TreeNode		getReportGraphColLabelNode(TreeNode& trRowNode, int nIndex, bool bCreate);
	void			updateAxesTitleOnReportGraphLabel(TreeNode& trOp, int nGraphIndex, TreeNode& trGraph, int nRowIndex, int nColIndex, int nPlotIndex, DWORD dwGraphUID);
	///end PUT_REPORT_GRAPH_LABEL_AS_Y_AXES_TITLE

	///Arvin 06/08/07 CHANGE_PARAM_TO_PLOT_MULTI_PLOTS_IN_ONE_GRAPH_RUNTIME_ERROR
	//void		afterCreateReportGraph(TreeNode &trOp, int nGraphIndex, GraphPage & gp);
	///Arvin 11/09/07 KEEP_USER_INSERTED_LAYER_IN_REPORT_GRAPH_IN_FITTING
	//void		afterGetReportGraphPage(TreeNode &trOp, int nGraphIndex, GraphPage & gp, int nPicRowIndex, int nPicColIndex);
	void			checkAndArrangeReportGraphLayers(TreeNode &trOp, int nGraphIndex, GraphPage & gp, int nPicRowIndex, int nPicColIndex);
	///end KEEP_USER_INSERTED_LAYER_IN_REPORT_GRAPH_IN_FITTING
	///end CHANGE_PARAM_TO_PLOT_MULTI_PLOTS_IN_ONE_GRAPH_RUNTIME_ERROR
	///Arvin 07/09/07 v8.0655 FITTING_ON_GRAPH_FROM_EXCEL_SHOULD_NOT_OUTPUT_TO_SOURCE
	//bool setReportOutputBookName(TreeNode& trBook, const string& strBook);	//--- CPY 10/8/04 QA70-7025 v8.0147 REPORT_BOOK_INDICATE_SOURCE_BOOK 
	//bool setCurvesOutputBookSheet(TreeNode& trGUI); 

	/// Iris 3/21/2008 v8.0829 QA80-10934 ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME, changed to the proper function name
	//bool setReportOutputBookName(TreeNode& trBook, const string& strBook, bool bAllowToSource = true);	//--- CPY 10/8/04 QA70-7025 v8.0147 REPORT_BOOK_INDICATE_SOURCE_BOOK 
	/// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
	//bool 	setReportOutputBook(TreeNode& trBook, const string& strBook, bool bAllowToSource = true);
	///end CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
	///Sophy 5/29/2008 QA80-10934-P10 CORRECT_STATS_ON_ROWS_RESULT_BOOK_NAME
	/* moved to protected.
	string	getResultBookNameFromGUI(const TreeNode& trGUI);
	string	getResultSheetNameFromGUI(const TreeNode& trGUI);
	*/
	///end CORRECT_STATS_ON_ROWS_RESULT_BOOK_NAME
	///end ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME
	
	///Cheney 2007-8-23 QA70-10290 FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
	//bool setCurvesOutputBookSheet(TreeNode& trGUI, bool bAllowToSource = true); 
	bool			setCurvesOutputBookSheet(TreeNode& trGUI, bool bAllowToSource = true, LPCSTR lpcszBook = NULL); 
	///end FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
	///end FITTING_ON_GRAPH_FROM_EXCEL_SHOULD_NOT_OUTPUT_TO_SOURCE
	string			getStrCheckSpecialType(LPCSTR lpcstr, int* pnSpecialType = NULL);
	/// Iris 10/13/06 USE_CENTRILIZE_CODE_TO_GET_RESULT_CURVE_NODE
	virtual void	getGUIResultCurveNode(const TreeNode& trGUI, TreeNode& trResultCurve, int nOutputIndex = OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET);
	///end USE_CENTRILIZE_CODE_TO_GET_RESULT_CURVE_NODE
	
	///Arvin 02/21/08 QA70-10929 NLEND_NEED_OUTPUT_REPORT_TABLES_TO_NOTES_WINDOW
	//Clean code and add independent method to output report tables to script window, result log and notes window
	void 			convertReportTableToDumpString(const TreeNode& trOperation, int nTotalNumData, string& strOut);
	bool 			outputDumpStringToNotesWindow(const TreeNode& trGUI, const string& strOut);
	bool 			outputDumpStringToScriptWindow(const string& strOut);
	bool 			outputDumpStringToResultLog(const TreeNode& trOperation, const string& strOut, const DataRange& drInput);
	bool 			outputReportTablesWithoutGenerateReport(DWORD dwOutputCntrl);
	///end NLEND_NEED_OUTPUT_REPORT_TABLES_TO_NOTES_WINDOW	
	virtual void	filterReportForStrDump(TreeNode& trOp, int nTotalNumData = 1); ///Iris 4/14/05
	DWORD			filterAndGenerateReport(Datasheet& ds, TreeNode& trReport, int nNumInHeading = 0, BOOL bCheckIDRange = TRUE, BOOL bHierarchy = FALSE, int nOuputOption = OUTPUT_PARTIAL_REGRESSION_CURVES_SHEET);//moved from public
	/// Iris 9/10/2009 QA80-14279 KEEP_MISSING_DATA_TABLE_EVENT_EMPTY
	//void			filterReport(TreeNode& trReport, BOOL bCheckIDRange = TRUE);//---- CPY 9/22/05 QA70-8015-P15 USE_SET_REPORT_TREE_TO_INTERNALLY_PUT_TREE_INTO_FLAT_SHEET //moved from public
	/// Hong 12/11/09 QA80-14138-P2 FIX_STATS_ON_COL_CHANGE_PARAM_CANNOT_ADD_BACK_MISSING_TABLE
	//void			filterReport(TreeNode& trReport, BOOL bCheckIDRange = TRUE, BOOL bHierarchy = TRUE);
	void			filterReport(TreeNode& trReport, BOOL bCheckIDRange = TRUE, BOOL bHierarchy = TRUE, bool bReservedTableNode = false);
	/// end FIX_STATS_ON_COL_CHANGE_PARAM_CANNOT_ADD_BACK_MISSING_TABLE
	///end KEEP_MISSING_DATA_TABLE_EVENT_EMPTY
	
	/// Iris 2/02/2010 QA81-14994 FIX_UNCHECK_ALL_OUTPUT_STILL_GENERATE_REPORT_SHEET
	bool 			checkIfNoReportTable(TreeNode& trOperation);
	void 			filterReportEx(TreeNode& trReport, TreeNode& trReportClone, BOOL bCheckIDRange, BOOL bHierarchy);
	DWORD 			generateReportEx(Datasheet& ds, TreeNode& trReport, TreeNode& trReportClone, int nNumInHeading, bool bHierarchy, int nOutputOption);
	///End FIX_UNCHECK_ALL_OUTPUT_STILL_GENERATE_REPORT_SHEET
	
/// Hong 08/13/09 QA80-14138 REDUCE_OPERATION_SIZE_OF_STATS_ON_COLS
#ifdef		__REDUCE_STATS_ON_COLS_OP_MEM_CONSUME__
	/// Hong 12/11/09 QA80-14138-P2 FIX_STATS_ON_COL_CHANGE_PARAM_CANNOT_ADD_BACK_MISSING_TABLE
	///// Iris 9/03/2009 QA80-14138 FIX_STATS_ON_COL_CHANGE_PARAM_CANNOT_ADD_MISSING_TABLE
	virtual bool	isFilterNeedCloneTree() { return true; }
	//virtual bool	isResetHiddenTable() { return false; }
	/// end FIX_STATS_ON_COL_CHANGE_PARAM_CANNOT_ADD_BACK_MISSING_TABLE
#endif		//__REDUCE_STATS_ON_COLS_OP_MEM_CONSUME__
	/// end REDUCE_OPERATION_SIZE_OF_STATS_ON_COLS
	int				getExecMode(){ return m_nExecMode;}	
	
	//------ Folger 11/18/08 QA80-12574 v8.0974 SUPPORT_RESET_ALL_GRAPHS_IN_ERPORT_SHEET
	void			removeGraphUID(DWORD dwIDValue);
	//------
	
	bool			isAddRowNumberLimitionForMaskedMissingTable(int *pnMaskedMissingDataSize = NULL); /// Iris 9/3/2009 QA80-14209 ADD_LIMITION_FOR_LARGER_DATA_IN_MASKED_MISSING_DATA_TABLE
	
	/// Hong 03/01/10 QA80-10136 GROUP_FITTED_CURVE_IN_SRC_GRAPH_AS_SRC_PLOT
#ifdef		__FITTED_CURVE_SUPPORT_GROUP_AS_SRC__
	void			initGroupPlotAndIndex();
	bool			setupDataPlotGroup(const TreeNode& trOp, GraphLayer& gl, int nFittedPlot, int nDataIndex);
#endif		//__FITTED_CURVE_SUPPORT_GROUP_AS_SRC__

	/// Iris 11/05/2010 ORG-1368-P1 CHANGE_DATA_MODE_IN_CHANGE_PARAM_CAUSE_REPORT_GRAPH_NOT_CORRECT
	bool 			checkIfDataModeChanged(const TreeNode& trOp, bool& bIsDataModeChanged);
	///End CHANGE_DATA_MODE_IN_CHANGE_PARAM_CAUSE_REPORT_GRAPH_NOT_CORRECT

	///------ Folger 12/24/2010 ORG-938-P3 DATA_TIME_FORMAT_FAILED_TO_APPLY_PROPERLY_WHEN_CHANGE_PARAM
	virtual	BOOL	CustomizedGUI(TreeNode& trGUI)		{ return TRUE; }
	///------ End DATA_TIME_FORMAT_FAILED_TO_APPLY_PROPERLY_WHEN_CHANGE_PARAM
	
	/// Iris 2/15/2011 ORG-402 PLOT_SURFACE_FIT_DATA_FROM_VIRTUAL_MATRIX
	virtual bool	isVirtualMatrixGraph(TreeNode& trOp, int nGraphIndex) { return false; }
	///End PLOT_SURFACE_FIT_DATA_FROM_VIRTUAL_MATRIX	

	///------ Folger 05/29/2012 ORG-4908-P8 IMPLICIT_FITTING_FAILED_TO_SET_FITTED_CURVE_COLUMN_DESIGNATION
	virtual DWORD SetReportTreeMoreOptions() { return 0; }
	///------ End IMPLICIT_FITTING_FAILED_TO_SET_FITTED_CURVE_COLUMN_DESIGNATION

	///------ Folger 07/02/2012 ORG-5592-S1 SHOW_DATA_IDENTIFIER_FOR_FLAT_SHEET
	virtual DWORD GetConvertEscapeStrForFlatSheetCtrnl() { return IsOutputDataIdentifierFlatSheet() ? CONVERT_ESCAPED_STR_FOR_FLAT_SHEET__LABEL : 0; }
	///------ End SHOW_DATA_IDENTIFIER_FOR_FLAT_SHEET

	/// Zech 08/22/2012 ORG-5703-P1 OPERATION_SUPPORT_IGNORE_HIDDEN_ROW
	virtual DWORD	GetDataRules2(const TreeNode& trOperation) {return 0;}
	/// END OPERATION_SUPPORT_IGNORE_HIDDEN_ROW

	///------ Folger 09/17/2012 ORG-6829-P1 FAILED_TO_SHOW_SUB_DATA_INDEX_IN_STATS_ON_COLUMN_REPORT_SHEET
	virtual int GetEscapedMainDataStringAdditional(TreeNode& trOp, int indexLT) { return ESC_LABEL_ADD_NONE; }
	///------ End FAILED_TO_SHOW_SUB_DATA_INDEX_IN_STATS_ON_COLUMN_REPORT_SHEET
	
///Cheney 2007-4-12 ALL_FITTING_TOOLS_NEED_FOOTNOTE_FOR_MISSING_AND_MASKED_DATA
private:
	bool				m_bNoReportTable; /// Iris 2/02/2010 QA81-14994 FIX_UNCHECK_ALL_OUTPUT_STILL_GENERATE_REPORT_SHEET
	/// Iris 11/05/2009 QA81-14599 FIX_STATS_ON_COLS_PLOT_REPORT_GRAPHS_VERY_SLOW	
	int					m_nNumFactors;	
	/// Iris 10/18/2011 ORG-4125-P1 FIX_PLOT_SAME_GRAPH_IN_ONE_GRAPH_FAILED_FOR_MULTI_FACTORS_DATA
	//int				m_n2ndGroupNumFactors;
	int					m_nNumFactorsWithoutEmptyPair;
	int					m_nNumDataWithoutEmptyPair;
	///End FIX_PLOT_SAME_GRAPH_IN_ONE_GRAPH_FAILED_FOR_MULTI_FACTORS_DATA
	///end FIX_STATS_ON_COLS_PLOT_REPORT_GRAPHS_VERY_SLOW
	
	bool				m_bHasMissing;
	bool				m_bHasMasked;
	//---- CPY 5/27/08 QA70-11609 CHANGE_PARAM_SHOULD_NOT_AUTO_SIZE_COL_WIDTH
	int					m_nExecMode;

	//---- end CHANGE_PARAM_SHOULD_NOT_AUTO_SIZE_COL_WIDTH	
///end ALL_FITTING_TOOLS_NEED_FOOTNOTE_FOR_MISSING_AND_MASKED_DATA  
/// Hong 03/01/10 QA80-10136 GROUP_FITTED_CURVE_IN_SRC_GRAPH_AS_SRC_PLOT
#ifdef		__FITTED_CURVE_SUPPORT_GROUP_AS_SRC__
	int					m_nFirstPlotIndexInGroup;
	int					m_nFirstFittedPlot;
#endif		//__FITTED_CURVE_SUPPORT_GROUP_AS_SRC__	

	PageActiveLayerRestore		m_palr;		///------ Folger 01/12/2012 ORG-4492-P2 NORMALITY_TEST_SHOULD_NOT_ACTIVE_SOURCE_SHEET_AFTER_CHANGE_PARAM
};
// consts for ReportPlotTypeGrouppingMethod and other plotting related functions
enum {RP_NEED_RESCALE = 1, RP_GROUP_TABLE = 2, RP_GROUP_ALL_PLOTS = 4, RP_JUST_UPDATE_PLOT = 8};


//--- CPY 4/30/03, implemented in OriginEvents.c
bool do_operation_dlg_cancel(const TreeNode& trOperation);
bool is_dlg_ShiftShow_checked(LPCSTR lpcszDlgName, bool bDefault=false);
bool GetNBox_on_try_operation(TreeNode& trGUI);
//---

//---------- CPY 5/6/04 QA70-6367 HISTOGRAM_GRAPHS
enum {
	CREATE_GRAPH_PREPARE_TREE,
	CREATE_GRAPH_CREATE_FOR_REPORT,
	CREATE_GRAPH_CREATE_FOR_EDIT,
	
	CREATE_GRAPH_LAST_ENTRY
};


/*
class ReportCreateGraphHelper
{
public:
	
	/// YuI 12/03/04 v7.5170 QA70-7226 MULTIPLE_PLOTS_OF_SAME_SERIES_IN_SAME_FRAME
	//	ReportCreateGraphHelper(int nCreateType, TreeNode& trOp, int index, int nGraphIndex = 0, LPCSTR lpcszDataLabel = NULL, const vector<string> *pvstrFactors = NULL);
	ReportCreateGraphHelper(int nCreateType, TreeNode& trOp, int nDataPlotIndex, int nGraphIndex = 0, LPCSTR lpcszDataLabel = NULL, const vector<string> *pvstrFactors = NULL, int nPictureIndex = -1);
	/// end MULTIPLE_PLOTS_OF_SAME_SERIES_IN_SAME_FRAME
	~ReportCreateGraphHelper();
	void DestroyGraph()
	{
		if(m_gpTemp)
			m_gpTemp.Destroy();
	}
			
	bool IsCreate() {return m_bIsCreateGraph;} // we might not want to create graph, but still need to pass through the needed tree creation
	
	bool AddGraphToTreeNode();
	GraphPage GetTempGraph(LPCSTR lpcszGraphName, LPCSTR lpcszTemplate = NULL);
	string GetNodeTagName() {return m_strPictNodeName;}

private:
	//------- CPY 11/3/04	QA70-7122 ADD_BOX_CHART_TO_DESC_STATS
	string	m_strGraphNodeName; // main graph table
	string	m_strPictNodeName; // individual picture cell
	//-------
	GraphPage m_gpTemp;
	TreeNode m_trOp;
	//Worksheet m_wksTemp;
	//TreeNode m_trHeader;
	//TreeNode m_trFooter;
	TreeNode m_trImage;
	bool	m_bIsCreateGraph;
	int		m_nCreateType;
};
*/
//-------- end CPY 5/6/04 QA70-6367 HISTOGRAM_GRAPHS


//---
/// ML 10/7/2004 MULTIPLE_DATASET_OPER_TREATMENT
//int		tree_get_oper_multidata_modes(TreeNode &trGUI, int *pnOutMode = NULL); CPY moved to tree_utils since needed outside
void	tree_set_oper_multidata_modes(TreeNode &trGUI, int modeMDInput, int modeMDOut = MDOUT_INVALID);
/// Iris 4/28/2009 QA80-12784-P4 FIX_HITOGRAM_BIN_INFO_NOT_UPDATE_WHEN_CHANGE_DATA_MODE
//void	tree_oper_multidata_mode_update_rules(DWORD &dwRules, const TreeNode& trOp);
void	tree_oper_multidata_mode_update_rules(DWORD &dwRules, const TreeNode& trGUI);
///end FIX_HITOGRAM_BIN_INFO_NOT_UPDATE_WHEN_CHANGE_DATA_MODE 
void	tree_output_branch_mode(TreeNode& trGUI, int nOutMode = MDOUT_DEFAULT);
/// end MULTIPLE_DATASET_OPER_TREATMENT 



///Arvin 07/18/07 v8.0662 FIT_COMPARISION_OF_DATASETS_INCONSISTENT_BETWEEN_NLFIT_AND_LR
//bool op_fit_on_data(LPCSTR lpcszClass, const XYRange& dr, TreeNode& trResult, LPCSTR lpcszModel = NULL, LPCSTR lpcszCateg = NULL);
///Echo 07/11/30 QA70-10589-P3 v8.0757	FITCMP_SUPPORT_POLY_ORDER
//bool op_fit_on_data(LPCSTR lpcszClass, const DataRange& dr, TreeNode& trResult, LPCSTR lpcszModel = NULL, LPCSTR lpcszCateg = NULL);
///------- Folger 07/01/09 QA80-13774-P1 COMPARE_MODELS_FOR_FITTING_WITH_WEIGHT_FAILS_WHEN_NOT_OUTPUT_FIT_STATISTICS_TABLE
//bool op_fit_on_data(LPCSTR lpcszClass, const DataRange& dr, TreeNode& trResult, LPCSTR lpcszModel = NULL, LPCSTR lpcszCateg = NULL, int nOrder = 2);
bool op_fit_on_data(LPCSTR lpcszClass, const DataRange& dr, TreeNode& trResult, LPCSTR lpcszModel = NULL, LPCSTR lpcszCateg = NULL, int nOrder = 2, TreeNode& trOriginalInput = NULL);
///------- End COMPARE_MODELS_FOR_FITTING_WITH_WEIGHT_FAILS_WHEN_NOT_OUTPUT_FIT_STATISTICS_TABLE
///end FITCMP_SUPPORT_POLY_ORDER
///end FIT_COMPARISION_OF_DATASETS_INCONSISTENT_BETWEEN_NLFIT_AND_LR

#ifdef __STATS_ON_COLS_SUPPORT_QUANTITIES_OUTPUT_BRANCH
void construct_report_book_sheet_nodes(TreeNode& trReport);
#endif //__STATS_ON_COLS_SUPPORT_QUANTITIES_OUTPUT_BRANCH

///------ Folger 05/16/2012 ORG-5592-S3 ADD_DATA_IDENTIFIER_FOR_STATS_TOOLS
bool is_input_data_change(TreeNode& trRow, TreeNode& trGUI);
///------ End ADD_DATA_IDENTIFIER_FOR_STATS_TOOLS

#endif //_WKSOPERATION_H
