/*------------------------------------------------------------------------------*
 * File Name:LT_Wks.c		 													*
 * Creation: CPY July 9 2003													*
 * Purpose: OriginC Source C file												*
 * Copyright (c) Originlab Corp.	2003										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * DG 4/13/05 CHANGE_ACTIVE_PAGE_CAUSE_PAGE_CONFUSION 							*
 * DG 8/26/05 AVOID_APPLY_FORMAT_TRIGGER_LAYER_CHANGE							*
 * CPY 9/22/05 SPLITTER_INIT_SIZE_ON_READY										*
 * CPY 3/25/06 SPLITTER_INIT_SIZE_NOT_CALL										*
 * Jasmine 07/19/06 REMOVE_COLUMN_FROM_WBORG									*
 * Jasmine 10/18/06 CHANGE_TO_TREE_DYNA_SPLITTER								*
 * Jasmine 10/23/06 ADD_BINARY_STORAGES											*
 * Jasmine 10/23/06 ADD_ROW_NUM													*
 * Hong 10/30/06 	FIX_MISS_CHECK_VALID_INDEX									*
 * Jasmine 01/31/07 QA70-9287 EDIT_STORAGE										*
 * Jasmine 02/03/07 FIX_SET_NUM_ROW_BUG											*
 * Jasmine 02/12/07 QA70-9287 CLEAN_UP_EDIT_STORAGE								*
 * Jasmine 02/14/07 DELETE_IMPORTED_FILE										*
 * Jasmine 03/21/07 MODIFICATION_EDIT_USER_TREE									*
 * Jasmine 04/16/07 QA80-9418 v8.0597 ADD_REIMPORT_MENU_BY_JUSTIN_REQUIRED		*
 * Hong 04/09/07 QA80-9418 v8.0597 MORE_ADD_REIMPORT_MENU_BY_JUSTIN_REQUIRED	*
 * Folger 04/24/07 ADD_NO_INFO_MSG												*
 * Sim 05-22-2007 MAKE_FILTER_BY_IMPORT_SETTING									*
 * Folger 05/28/07 ADD_INI_BINARY_STORAGETO_MATRIX								*
 * Jasmine 05/31/07 ENABLE_REIMPORT_MENU_ON_IMPORT_TYPE							*
 * Jasmine 06/14/07 FREEZE_SELECTION											*
 * Folger 06/26/07 REFRESH_ORGANIZER											*
 * Folger 06/27/07 FIX_REFRESH_ORGANIZE											*
 * Folger 06/28/07 FIX_IMPORT_REFRESH_BUG										*
 * Folger 06/29/07 UPDATE_ACTIVE_SHEET_WHEN_VNBRANCH_EMPTY						*
 * Folger 07/19/07 FIX_BUGS_IN_RENAME_BY_AUTO_ENUM_NEXT_VALID_NAME				*
 * Sim 09-30-2007 PROPER_VAR_NAME												*
 * Folger 10/10/07 FIX_RUNTIME_ERROR_WHEN_OPEN_CONTEXT_MENU						*
 * Hong 10/24/07 v8.0732 IMPROVE_ORGANIZER_REFRESH_BY_ONIDLE					*	
 * Folger 11/15/07 WORKBOOK_ORGANIZER_MAP_HELP									*
 * Folger 01/04/07 QA70-10902 FIX_WRONG_FOCUS_AFTER_SHEET_RENAME				*
 * Max 5/23/08 v8.0869d JOE_SUGGEST_TO_USE_RE-IMPORT							*
 * Hong 08/22/08 v8.0927 FIX_RUNTIME_ERROR_WHEN_DRAG_OUT_LAST_SHEET_WITH_ORGANIZER_ACTIVE
 * Folger 09/08/08 FIX_RUNTIME_ERROR_WHEN_SHOW_MENU_WITH_NO_ITEM_SELECTED_IN_LEFT_PANE
 * EJP 2009-05-21 QA80-13573 MAKE_SHEET_AND_ORGANIZER_SELECTIONS_INDEPENDENT	*
 *	Folger 07/17/09 QA80-13969 WORKBOOK_ORGANISZER_FAILS_TO_UPDATE_LIST_TREE_AFTER_PAGE_RENAME
 * Sim 07-24-2009 QA80-13573-P2 SYNCHRONIZE_SHEET_SELECTION_WHEN_CURRENT_SELECTION_IN_DATA_SHEETS
 * Sim 07-24-2009 QA80-13573-P1 AVOID_CHANGE_LAYER_EVENT_MIX_UP_ACTIVE_SEL		*
 *	Folger 07/27/09 RUNTIME_ERROR_WHEN_DOUBLE_CLICK_ON_GRAY_AREA_OF_LEFT_PANE	*
 * Sim 07-28-2009 QA80-13916-P1 FIX_DUPLICATE_PAGE_CAUSE_RUNTIME_ERROR			*
 * Sim 2009-08-04 QA81-14036 FIX_LOST_FOCUS_ON_COMMAND_WINDOW_WHEN_SHOW_WB_ORGANIZER
 * Jasmine 11/06/09 QA80-14502 REWRITE_CODE_TO_SHARE_COL_PROP_USER_TREE_CODE	*
 *	Hong 11/13/09 QA80-14502 WBK_ORGANIZER_USER_TREE_EDIT_GUI_THE_SAME_AS_COL_PROPERTY
 * Jasmine 12/31/09 STORAGE_CODE_SHOULD_COMPATIBLE_WITH_MATRIX					*
 * Jasmine 02/03/10 SEPARATE_STORAGE_SECTION_TWO_EDITBOX_MAKE_USER_FRIENDLY		*
 * Jasmine 02/09/10 QA81-14502-P5 ADD_LABEL_TO_DYNA_TREE_TEMPORARILY			*
 *	Hong 02/25/10 QA80-15145 FIX_WKS_ORGANIZER_NOT_UPDATE_WHEN_CHANGE_USER_INFO_WITH_SHOWN
 *	Hong QA80-15357 03/31/10 REPLACE_VSFLEX_WITH_64_MP_COMPATIABLE_WXGRID		*
 *	Hong 12/13/11 ORG-4585 FIX_ORIGIN_CRASH_CHANGE_BY_AXES_DLG_WHEN_WKBOOK_ORGANIZER_SHOWN
 *------------------------------------------------------------------------------*/

#include <Origin.h>

#include "DialogEx.h"
#include <operation.h>
//----Jasmine 10/18/06 CHANGE_TO_TREE_DYNA_SPLITTER
//#include "TreeEditSplitter.h"
#include "SplitterControl.h"
//----
#include "DataObjectManager.h"
#include "UserTreeGUI.h"

#define	_DMSG(_str)  //out_str(_str);
#define _DMSG2(_str, _val) //printf(_str, _val)

#include "OriginEvents.h"
#include "wkbookInfoTree.h"
#include "DynaSplitter.h"	//----Jasmine 10/18/06 CHANGE_TO_TREE_DYNA_SPLITTER

// Hong 04/09/07 QA80-9418 v8.0597 MORE_ADD_REIMPORT_MENU_BY_JUSTIN_REQUIRED
#include <xfbase.h>
#include "fu_utils.h" 
/// end MORE_ADD_REIMPORT_MENU_BY_JUSTIN_REQUIRED

#include <Profiler.h>
#define HOUR_GLASS			waitCursor junk;
//#define _SHOW_TIME			Profiler junk;
#define PROFILE_HRGLASS		HOUR_GLASS

///---Sim 2009-08-04 QA81-14036 FIX_LOST_FOCUS_ON_COMMAND_WINDOW_WHEN_SHOW_WB_ORGANIZER
#ifndef __FIX_LOST_FOCUS_ON_COMMAND_WINDOW__
#define WKB_SPL_DYNALAYOUT_BITS 0
#else // __FIX_LOST_FOCUS_ON_COMMAND_WINDOW__
#define WKB_SPL_DYNALAYOUT_BITS ( DYNALAYOUT_NO_SET_FOCUS | DYNALAYOUT_NO_RESTORE_FOCUS )
#endif // __FIX_LOST_FOCUS_ON_COMMAND_WINDOW__
///---END QA81-14036 FIX_LOST_FOCUS_ON_COMMAND_WINDOW_WHEN_SHOW_WB_ORGANIZER

#define COL_HEADER	1
#define ROW_HEADER	1

enum {	PAGE_INFO_PAGE_SNAME,
		PAGE_INFO_PAGE_LNAME,
		PAGE_INFO_PAGE_COMMENT,
		PAGE_INFO_TITLE_SHOWN
};

///Jasmine 07/19/06 REMOVE_COLUMN_FROM_WBORG
/*
enum {	COLUMN_INFO_COL_SNAME,
		COLUMN_INFO_COL_LNAME,
		COLUMN_INFO_COL_UNIT,
		COLUMN_INFO_COL_COMMENTS,
		COLUMN_INFO_COL_FORMULA,
		COLUMN_INFO_COL_COLWIDTH,
		COLUMN_INFO_COL_PLOT_DESIGNATION,
		COLUMN_INFO_COL_FORMAT,
		COLUMN_INFO_COL_DISPLAY,
		COLUMN_INFO_COL_NUMERIC_DISPLAY,
		COLUMN_INFO_COL_INTERNAL_DATA
};
*/
///End REMOVE_COLUMN_FROM_WBORG

///Jasmine 01/29/07 QA70-9287 EDIT_STORAGE
enum{	LEVEL_ROOT, LEVEL_SECTION, LEVEL_VAR};
enum{HIDE_REIMPORT = -1, DISABLE_REIMPORT, ENABLE_REIMPORT};	///Jasmine 05/31/07 ENABLE_REIMPORT_MENU_ON_IMPORT_TYPE
enum{ WB_STORAGE_BOTH, WB_STORAGE_SECTION, WB_STORAGE_VARIABLE};

// to use this, from wks
// page -sps rr[WkbookSplitter]

//----Jasmine 10/18/06 CHANGE_TO_TREE_DYNA_SPLITTER
//class OC_REGISTERED WkbookSplitter : public ListTreeEditSplitter 
class OC_REGISTERED WkbookSplitter : public TreeDynaSplitter 
{
public:
	//----Jasmine 10/18/06 CHANGE_TO_TREE_DYNA_SPLITTER
	//WkbookSplitter() : ListTreeEditSplitter()
	WkbookSplitter()
	//----
	{
		m_wp=Project.ActiveLayer().GetPage();
		m_strName = m_wp.GetName();//Hong SHARE_WKBOOK_MATBOOK_ORGANIZER_ADD_MORE
		m_nActiveLayer = page_active_layer_index(m_wp);	///Jasmine 06/14/07 FREEZE_SELECTION
		/// Hong 10/24/07 v8.0732 IMPROVE_ORGANIZER_REFRESH_BY_ONIDLE
		m_bUpdateFromImport = false;
		m_bRefreshOnIdle = false;
		m_bNoNeedUpdateTree = false;	//------ Folger 01/04/07 QA70-10902 FIX_WRONG_FOCUS_AFTER_SHEET_RENAME
		/// end IMPROVE_ORGANIZER_REFRESH_BY_ONIDLE
	}
	
	BOOL CreateWindow(int nID, HWND hWndParent)
	{
		Window wndParent(hWndParent);
		/// TD 8-3-06 QA70-8843 DOWNCAST_BUG
		//Dialog dlgParent;
		m_dlgParent = wndParent;
		/// end DOWNCAST_BUG
		Init(nID, m_dlgParent,0, "WksInfo");
		set_organizer_handle(m_wp, GetSafeHwnd());	///Jasmine 06/25/07 UPDATE_ORGANIZER
		return TRUE;
	}



protected:
EVENTS_BEGIN
	ON_INIT(OnInitSplitter)
	ON_PAGE_SPLITTER_READY(OnReady)
	ON_DESTROY(OnDestroy)
	ON_SIZE(OnCtrlResize)
	
	ON_GRID_ROW_COL_CHANGE(GetMainPaneID(), OnListRowChange)
	ON_GETNDLG_MSGS(GetTreeEditPaneID())
	ON_USER_MSG(WM_USER_RESIZE_CONTROLS, OnInitPaneSizs)	//----- CPY 3/25/06 SPLITTER_INIT_SIZE_NOT_CALL
	ON_USER_MSG(WM_USER_TREEEDITOR_VALUE_CHANGE, OnAfterValueChange)
	ON_USER_MSG(WM_USER_ON_UPDATE_ORGANIZER, OnUpdateOrganizer)	///Jasmine 06/25/07 UPDATE_ORGANIZER
	///Folger 06/26/07 REFRESH_ORGANIZER
	ON_USER_MSG(WM_USER_ON_NOTIFY_ORGANIZER, OnNotifyOrganizer)
	//ON_USER_MSG(WM_USER_ON_REFRESH_ORGANIZER, OnRefreshOrganizer) /// Hong 10/24/07 v8.0732 IMPROVE_ORGANIZER_REFRESH_BY_ONIDLE
	///End REFRESH_ORGANIZER
	ON_OBJECT_MODIFY(OnOriginModify)		/// TD 11-8-04 Sample handling of PostMessages From Splitter window
	ON_OBJECT_INFO_MODIFY(OnInfoModify)		/// TD 11-8-04 Sample handling of PostMessages From Splitter window
	//----Jasmine 10/18/06 CHANGE_TO_TREE_DYNA_SPLITTER	
	//ON_CHANGE_LAYER( OnActiveLayerChange )  /// TD 11-8-04 Sample handling of PostMessages From Splitter window
	//ON_CHANGE_PAGE( OnActivePageChange )    /// TD 11-8-04 Sample handling of PostMessages From Splitter window
	//ON_CHANGE_DATASET( OnActiveDatasetChange )  /// TD 11-8-04 Sample handling of PostMessages From Splitter window	
	ON_CHANGE_LAYER( OnChangeLayer )  /// TD 11-8-04 Sample handling of PostMessages From Splitter window
	ON_CHANGE_PAGE( OnChangePage )    /// TD 11-8-04 Sample handling of PostMessages From Splitter window
	ON_CHANGE_DATASET( OnChangeDataset )  /// TD 11-8-04 Sample handling of PostMessages From Splitter window
	//----
	ON_GRID_DBLCLICK(GetMainPaneID(), OnDBClickList)
	ON_CONTEXTMENU(OnShowMenu)
	ON_IDLE(OnIdle)
	
	ON_HELPINFO(OnHelp)			//------ Folger 11/15/07 WORKBOOK_ORGANIZER_MAP_HELP
	
EVENTS_END	

	//------ Folger 11/15/07 WORKBOOK_ORGANIZER_MAP_HELP
	BOOL OnHelp(int &nHelpID, int nIdCtrlFocus)
	{
		nHelpID = IDD_WORKBOOK_ORGANIZER_DLG;
		return true;
	}
	//------ End WORKBOOK_ORGANIZER_MAP_HELP

	/// TD 11-8-04 Sample handling of PostMessages From Splitter window
	//----Jasmine 10/18/06 CHANGE_TO_TREE_DYNA_SPLITTER
	//BOOL OnActivePageChange()
	BOOL OnChangePage()
	//----
	{
		//out_str("OnActivePageChange");
		return TRUE;
	}
	
	//----Jasmine 10/18/06 CHANGE_TO_TREE_DYNA_SPLITTER
	//BOOL OnActiveLayerChange()
	BOOL OnChangeLayer()
	//----
	{
		///DG 8/26/05 AVOID_APPLY_FORMAT_TRIGGER_LAYER_CHANGE
		double dVal;
		if(LT_get_var(STR_LT_VAR_APPLY_FORMAT, &dVal) && 1==(int)dVal)
			return true;
		///end AVOID_APPLY_FORMAT_TRIGGER_LAYER_CHANGE
		
		//out_str("OnActiveLayerChange");
		///DG CHANGE_ACTIVE_PAGE_CAUSE_PAGE_CONFUSION
		Page wp=Project.Pages();
		//---TD Sim 07-28-2009 QA80-13916-P1 FIX_DUPLICATE_PAGE_CAUSE_RUNTIME_ERROR
		if ( !wp )
			return FALSE;
		//---END QA80-13916-P1 FIX_DUPLICATE_PAGE_CAUSE_RUNTIME_ERROR
		if(wp.GetName() != m_wp.GetName())
			return false;	//active page ignore layer event
		///end CHANGE_ACTIVE_PAGE_CAUSE_PAGE_CONFUSION
		///Jasmine 06/14/07 FREEZE_SELECTION
		int nIndex = page_active_layer_index(m_wp);
		if(m_nActiveLayer == nIndex)
			return true;
		m_nActiveLayer = nIndex;
		///End FREEZE_SELECTION

		/// EJP 2009-05-21 QA80-13573 MAKE_SHEET_AND_ORGANIZER_SELECTIONS_INDEPENDENT
		///	//-----------Folger 06/29/07 UPDATE_ACTIVE_SHEET_WHEN_VNBRANCH_EMPTY
		///	//updateShowActiveSheet();
		///	if (m_vnBranch.GetSize() == 0)
		///		updateShowActiveSheet();
		///	//-----------Folger 06/29/07 UPDATE_ACTIVE_SHEET_WHEN_VNBRANCH_EMPTY
		/// end MAKE_SHEET_AND_ORGANIZER_SELECTIONS_INDEPENDENT
		///---Sim 07-24-2009 QA80-13573-P2 SYNCHRONIZE_SHEET_SELECTION_WHEN_CURRENT_SELECTION_IN_DATA_SHEETS
		if ( m_vnBranch.GetSize() == 0 )
			updateShowActiveSheet(isSheetSelected());
		///---END QA80-13573-P2 SYNCHRONIZE_SHEET_SELECTION_WHEN_CURRENT_SELECTION_IN_DATA_SHEETS

		return TRUE;
	}
	
	//----Jasmine 10/18/06 CHANGE_TO_TREE_DYNA_SPLITTER
	//BOOL OnActiveDatasetChange()
	BOOL OnChangeDataset()
	//----
	{
		_DMSG("OnActiveDatasetChange");
		return TRUE;
	}
	
	void OnDBClickList(Control ctrl)
	{
		int nMouseRow, nMouseCol;
		m_wbkTree.GetMouseCell(nMouseRow, nMouseCol);
		TreeNode trClick=GetTreeNode(nMouseRow);
		///------ Folger 07/27/09 RUNTIME_ERROR_WHEN_DOUBLE_CLICK_ON_GRAY_AREA_OF_LEFT_PANE
		if ( !trClick )
			return;
		///------ End RUNTIME_ERROR_WHEN_DOUBLE_CLICK_ON_GRAY_AREA_OF_LEFT_PANE
		string strIndex=trClick.DataID;
		if("-1" == strIndex)
			trClick.GetAttribute(STR_RELATED_ATTRIB, strIndex);
		/// Hong 10/30/06 FIX_MISS_CHECK_VALID_INDEX
		//if(trClick.IsValid())
		if(trClick.IsValid() && strIndex != "-1")
		/// end FIX_MISS_CHECK_VALID_INDEX
		{
			string strLTCommand = "page.active="+strIndex;
			LT_execute(strLTCommand);
		}
	}
	
	///Jasmine 11/06/09 QA80-14502 REWRITE_CODE_TO_SHARE_COL_PROP_USER_TREE_CODE
	int ShowImportFileMenu(TreeNode& trFile, int nx, int ny, bool bDelete);
	int ShowINIStorageMenu(OriginObject& obj, TreeNode& trCurrent, int nx, int ny, bool bDelete, bool bSection, bool bVariable, int nItem);
	int ShowUserTreeMenu(OriginObject& obj, TreeNode& trCurrent, int nx, int ny, bool bDelete, bool bTree, bool bNode, int nItem);
	int ShowJunkMenu(int nx, int ny);
	BOOL OnShowMenu(UINT nResIDCtrl, int nx, int ny);
	///End REWRITE_CODE_TO_SHARE_COL_PROP_USER_TREE_CODE
	
	BOOL OnIdle()
	{
		///Folger 06/26/07 REFRESH_ORGANIZER
//		OUT(_L("OnIdle"));
		//if(m_bImportWaitRefresh)
		if (m_bRefreshOnIdle) /// Hong 10/24/07 v8.0732 IMPROVE_ORGANIZER_REFRESH_BY_ONIDLE
		{
			//OUT(_L("Refresh"));
			if(!IsReady())
				return false;
			UpdateList();
			
			/// Hong 10/24/07 v8.0732 IMPROVE_ORGANIZER_REFRESH_BY_ONIDLE
			if ( m_bUpdateFromImport )
			{
			/// end IMPROVE_ORGANIZER_REFRESH_BY_ONIDLE
				selectFileNodeByIndex();
			
				//for (int ii=0; ii<m_vnBranch.GetSize(); ii++)
				//{
					//printf("%d ", m_vnBranch[ii]);
				//}
				//printf("Enter\n");
				if (m_vnBranch.GetSize())
				{
					TREE_CTRL_VAR.SetCollapsed(m_vnBranch, false);			
				}
				//m_bImportWaitRefresh = false;
				m_bUpdateFromImport = false; /// Hong 10/24/07 v8.0732 IMPROVE_ORGANIZER_REFRESH_BY_ONIDLE				
				m_vnBranch.SetSize(0);		///Folger 06/27/07 FIX_REFRESH_ORGANIZE
			}
			
			m_bRefreshOnIdle = false; /// Hong 10/24/07 v8.0732 IMPROVE_ORGANIZER_REFRESH_BY_ONIDLE
		}
		///End REFRESH_ORGANIZER
		return TRUE;
	}
	/// Hong 02/25/10 QA80-15145 FIX_WKS_ORGANIZER_NOT_UPDATE_WHEN_CHANGE_USER_INFO_WITH_SHOWN
	/*
	BOOL OnInfoModify(Page pg, int nKind)
	{
		if(!IsReady())
			return TRUE;
		if(pg)
		{
			string strName;
			pg.GetName(strName);
			///Jasmine 06/14/07 FREEZE_SELECTION
			if(m_strName.CompareNoCase(strName) != 0)
				return FALSE;
			///End FREEZE_SELECTION
			_DMSG2("Info storage of Page %s has been modified\n", strName);
			///Danice 11/11/04 : Temp update all
			//UpdateList();
			m_bRefreshOnIdle = true; /// Hong 10/24/07 v8.0732 IMPROVE_ORGANIZER_REFRESH_BY_ONIDLE
			///end
		}
		_DMSG("OnInfoModify");
		return TRUE;
	}
	*/
	BOOL OnInfoModify(OriginObject obj, int nKind)
	{
		if ( !IsReady() )
			return TRUE;
		/// Hong 12/13/11 ORG-4585 FIX_ORIGIN_CRASH_CHANGE_BY_AXES_DLG_WHEN_WKBOOK_ORGANIZER_SHOWN
		Page		pg;
		pg = obj;
		Datasheet	ly;
		ly = obj;
		if ( !pg && !ly )
			return false;
		/// end FIX_ORIGIN_CRASH_CHANGE_BY_AXES_DLG_WHEN_WKBOOK_ORGANIZER_SHOWN
		if ( obj )
		{	
			string 			strRange;
			obj.GetRangeString(strRange);
			string 			strBook, strSheet;
			get_book_sheet_names(strRange, strBook, strSheet);
			if ( m_strName.CompareNoCase(strBook) != 0 )
				return FALSE;
			
			// check if Layer info change
			Datasheet		ds;
			ds = obj;
			if ( ds )
			{
				if ( m_nActiveLayer != ds.GetIndex() )
					return false;
			}
			
			if ( m_bNoNeedUpdateTree )
			{
				m_bNoNeedUpdateTree = false;
				return FALSE;
			}

			m_bRefreshOnIdle = true; /// Hong 10/24/07 v8.0732 IMPROVE_ORGANIZER_REFRESH_BY_ONIDLE
			///end
		}
		_DMSG("OnOriginModify");
		return TRUE;
	}
	/// end FIX_WKS_ORGANIZER_NOT_UPDATE_WHEN_CHANGE_USER_INFO_WITH_SHOWN
	
	///Jasmine 06/25/07 UPDATE_ORGANIZER
	void OnUpdateOrganizer(bool bParam = false, DWORD lParam = 0)
	{
		if(!IsReady())
			return;
		UpdateList();
	}
	///End UPDATE_ORGANIZER
	///Folger 06/26/07 REFRESH_ORGANIZER
	void OnNotifyOrganizer(DWORD wParam = 0, DWORD lParam = 0)
	{
		if (UPDATE_FROM_IMPORT == wParam)
		{
			m_nFileIndex = lParam;
			/// Hong 10/24/07 v8.0732 IMPROVE_ORGANIZER_REFRESH_BY_ONIDLE
			m_bRefreshOnIdle = true;
			m_bUpdateFromImport = true;
			/// end IMPROVE_ORGANIZER_REFRESH_BY_ONIDLE
		}
	}

	/// Hong 10/24/07 v8.0732 IMPROVE_ORGANIZER_REFRESH_BY_ONIDLE
	/*
	void OnRefreshOrganizer(DWORD wParam = 0, DWORD lParam = 0)
	{
		m_bImportWaitRefresh = true;
	}
	*/
	/// end IMPROVE_ORGANIZER_REFRESH_BY_ONIDLE
	///End REFRESH_ORGANIZER
	BOOL OnOriginModify(OriginObject obj, int nKind)
	{ 
		updateBranchVector();		//------Folger 06/28/07 FIX_IMPORT_REFRESH_BUG
	
		if(!IsReady())
			return TRUE;
		if(obj)
		{	
			///Jasmine 06/14/07 FREEZE_SELECTION
			/*
			///Hong 7/24/06 SHARE_WKBOOK_MATBOOK_ORGANIZER_ADD_MORE
			string str;
			str = obj.GetName();
			if(m_strName.CompareNoCase(str) != 0)
				return FALSE;
			///end SHARE_WKBOOK_MATBOOK_ORGANIZER_ADD_MORE
			_DMSG2("Worksheet %s modified, Object change", str);
			*/
			string strRange;
			obj.GetRangeString(strRange);
			string strBook, strSheet;
			get_book_sheet_names(strRange, strBook, strSheet);
			if(m_strName.CompareNoCase(strBook) != 0)
			///------ Folger 07/17/09 QA80-13969 WORKBOOK_ORGANISZER_FAILS_TO_UPDATE_LIST_TREE_AFTER_PAGE_RENAME
				//return FALSE;
			{
				if ( 0 != m_wp.GetName().CompareNoCase(strBook) )
					return FALSE;
				m_strName = strBook;
			}
			///------ End WORKBOOK_ORGANISZER_FAILS_TO_UPDATE_LIST_TREE_AFTER_PAGE_RENAME
				
			//------ Folger 01/04/07 QA70-10902 FIX_WRONG_FOCUS_AFTER_SHEET_RENAME
			if ( m_bNoNeedUpdateTree )
			{
				m_bNoNeedUpdateTree = false;
				return FALSE;
			}
			//------
			///End FREEZE_SELECTION
			///Danice 11/11/04 : Temp update all
			//UpdateList();
			m_bRefreshOnIdle = true; /// Hong 10/24/07 v8.0732 IMPROVE_ORGANIZER_REFRESH_BY_ONIDLE
			///end
		}
		_DMSG("OnOriginModify");
		return TRUE;
	}
	
	///-------
	/// TD 4-14-05
#define PAGE_NAME    "PageName"
	BOOL GetSettings(TreeNode &nodeSettings, Page &page)
	{
		if(nodeSettings)
		{
			TreeNode tn = nodeSettings.AddNode(PAGE_NAME);
			tn.strVal = m_wp.GetName();
		}
    	return TRUE;
	 }
	 
	 BOOL SetSettings(TreeNode &nodeSettings, Page &page)
	 {
	  	if(nodeSettings)
	  	{
	  		//TreeNode tn = nodeSettings.GetNode(PAGE_NAME);
	  		//if(tn)
	  		//{
		  	//	WorksheetPage wp(tn.strVal);
		  		if(page)// open project will have invalif page
		  		{
		  			m_wp = page; 
		  		}
	  		//}
	  		//else
	  		//	ASSERT(FALSE);
	  	}
	  	return TRUE;
	 }
	 ///--------
	 //------- CPY 9/22/05 SPLITTER_INIT_SIZE_ON_READY
	 BOOL OnReady()
	 {
		//----Jasmine 10/18/06 CHANGE_TO_TREE_DYNA_SPLITTER
		//ListTreeEditSplitter::OnReady();
		TreeDynaSplitter::OnReady();
		//----
		UpdateList();
		SetReady();
		//ListTreeEditSplitter::OnResize(0,0,0);// need to force resize of 1st pane
		return true;
	 }
	//--------
	BOOL OnDestroy()
	{
		set_organizer_handle(m_wp, NULL);	///Jasmine 06/25/07 UPDATE_ORGANIZER
		return TreeDynaSplitter::OnDestroy();
	}
	BOOL OnInitSplitter()
	{
		//----Jasmine 10/18/06 CHANGE_TO_TREE_DYNA_SPLITTER
		//ListTreeEditSplitter::OnInitSplitter(&m_wbkTree);
		TreeDynaSplitter::OnInitSplitter(&m_wbkTree);
		//----
		m_wbkTree.InitPage(m_wp);
		//updateShowActiveSheet();
		return true;
	}
	//virtual
	void ConstructTree(TreeNode &tr)
	{
		GETN_TREE(trTemp)
		//trTemp.AddNode(tr);
		GETN_STR(str, _L("string1"), "")
		m_paramTree = trTemp;
	}

	void OnListRowChange(Control ctrl)
	{
		/// TD 07-13-2009 QA80-13916 DYNACONTROL_DELAYED_FOCUS_INTRODUCED_ORGANIZER_SCREWUP_MDIACTIVE
		Page wp=Project.Pages();
		//---Sim 07-28-2009 QA80-13916-P1 FIX_DUPLICATE_PAGE_CAUSE_RUNTIME_ERROR
		if ( !wp )
			return;
		//---END QA80-13916-P1 FIX_DUPLICATE_PAGE_CAUSE_RUNTIME_ERROR
		if(wp.GetName() != m_wp.GetName())
			return;	//inactive page, this may lead to crash
		/// end DYNACONTROL_DELAYED_FOCUS_INTRODUCED_ORGANIZER_SCREWUP_MDIACTIVE

		PROFILE_HRGLASS
		
		int nNewSelect = m_wbkTree.GetSelectedRow();
		if(m_nSelectedRow != nNewSelect)
		{
			///Folger 06/27/07 FIX_REFRESH_ORGANIZE
			///Folger 06/26/07 REFRESH_ORGANIZER
			///End REFRESH_ORGANIZER
			///End FIX_REFRESH_ORGANIZE
			m_nSelectedRow = nNewSelect;
			m_trSel=GetTreeNode(m_nSelectedRow);
			/// Hong 10/30/06 ROLLBACK_CODE 
			/// Hong 9/15/06 INFO_NODE_SHOULD_NOT_EDITABLE
			if(m_trSel)
			///Folger 05/28/07 ADD_INI_BINARY_STORAGETO_MATRIX
			{
				string strSystem = "system";
				if (!m_trSel.tagName.Mid(0,strSystem.GetLength()).CompareNoCase(strSystem))
					m_trSel.Enable = 2;
			///End ADD_INI_BINARY_STORAGETO_MATRIX
				ShowInfo(m_trSel);
			}
			/*
			if(m_trSel)
			{
				if(m_trSel.tagName.CompareNoCase("Info") == 0)
					m_trSel.Enable = 2;
				else
				{
					TreeNode trInfo = tree_get_node_by_tagname(m_trSel, "Info", true);
					if(trInfo)
					{
						trInfo.SetAttribute(STR_ATTRIB_BRANCH, GETNBRANCH_OPEN);
						trInfo.Enable = 2;
					}
				}				
				ShowInfo(m_trSel);
			}
			/// end INFO_NODE_SHOULD_NOT_EDITABLE
			*/
			/// end ROLLBACK_CODE
		}
	}

	void OnAfterValueChange(int nRow, int nCol)
	{
		int nItem;
		//----Jasmine 10/18/06 CHANGE_TO_TREE_DYNA_SPLITTER
		//TreeNode trInfo=m_treeEditCntrl.get_tree_node(nRow, nCol);
		TreeNode trInfo = tree_get_node(m_paramTree, nRow);
		//----		
		//if(!trInfo || !m_trSel.GetAttribute(STR_DATAID_ATTRIB, nItem))
		if(!trInfo)
			return;
		m_trSel.GetAttribute(STR_TYPE_ATTRIB, nItem);
		///Jasmine 01/31/07 QA70-9287 EDIT_STORAGE
		/* //for debug
		string strDebug;
		strDebug = (string)nItem;
		OUT(strDebug);
		*/
		switch(nItem)
		{
		case TYPE_WORKBOOK:
			SetPageInfo(trInfo, nRow);
			break;
		case TYPE_DATA_SHEETS:
		case TYPE_RESULT_SHEETS:
			SetSheetName(trInfo, nRow, TYPE_DATA_SHEETS==nItem);
			break;
		case TYPE_SHEET:
			SetSheetInfo(trInfo, nRow);
			break;
		case TYPE_INI_STORAGES:	///Jasmine 01/22/07 SHOW_PAGE_INFO_ASCII_STORAGE
		case TYPE_BINARY_STORAGES:	///Jasmine 10/23/06 ADD_BINARY_STORAGES
			TreeNode trParent;
			if(TYPE_BINARY_STORAGES == nItem)
			{
				getStorageType(trInfo, trParent);
				tree_put_binary_storage(trParent, m_wp, "TREE");	
			}
			else
			{
				trParent = trInfo.Parent();
				bool bRet = info_set_section(m_wp, trParent, trParent.tagName);
			}
			break;
		case TYPE_SECTION:
			bool bRet = info_set_section(m_wp, m_paramTree, m_trSel.tagName);
			break;
		case TYPE_BRANCH:
			bool bUseLabel = copyLabelFromRoot(m_trSel, m_paramTree); ///Jasmine 02/09/10 QA81-14502-P5 ADD_LABEL_TO_DYNA_TREE_TEMPORARILY
	
			set_user_info(m_wp, m_trSel.tagName, m_paramTree);
			
			///Jasmine 02/09/10 QA81-14502-P5 ADD_LABEL_TO_DYNA_TREE_TEMPORARILY
			if(bUseLabel)
				m_paramTree.RemoveAttribute(STR_LABEL_ATTRIB);
			///End ADD_LABEL_TO_DYNA_TREE_TEMPORARILY
			break;
		///End EDIT_STORAGE
		///Jasmine 07/19/06 REMOVE_COLUMN_FROM_WBORG
		/*
		case TYPE_COLUMN:
			SetColumn(trInfo, nRow, nCol);
			break;
		*/
		///End REMOVE_COLUMN_FROM_WBORG
		case TYPE_GRAPHS:
		case TYPE_IMPORT_FILES:
		case TYPE_FILE:
			break;
		default:
			_DMSG("should never come here");
			break;
		}
	}
	
	void ShowInfo(TreeNode &tr)
	{
		int nType;
		tr.GetAttribute(STR_TYPE_ATTRIB, nType);
		switch(nType)
		{
		case TYPE_WORKBOOK:
			ShowPageInfo(tr);
			break;
		case TYPE_DATA_SHEETS:
		case TYPE_RESULT_SHEETS:
		case TYPE_IMPORT_FILES:
		case TYPE_BINARY_STORAGES:
		case TYPE_INI_STORAGES:
			ListContent(tr, TYPE_IMPORT_FILES == nType || TYPE_BINARY_STORAGES == nType || TYPE_INI_STORAGES == nType);///Jasmine 03/21/07 MODIFICATION_EDIT_USER_TREE
			break;
		///Jasmine 01/29/07 QA70-9287 EDIT_STORAGE
		case TYPE_SECTION:	///Jasmine 10/23/06 ADD_BINARY_STORAGES
			ShowSection(tr);
			break;
		case TYPE_BRANCH:	///Jasmine 01/22/07 SHOW_PAGE_INFO_ASCII_STORAGE
			ShowBranch(tr);
			//ShowStorage(tr, nType);
			break;
		///End EDIT_STORAGE
		case TYPE_GRAPHS:
			ShowGraphInfo(tr);
			break;
		case TYPE_SHEET:
			ShowSheetInfo(tr);
			break;
		//case TYPE_COLUMN:	///Jasmine 07/19/06 REMOVE_COLUMN_FROM_WBORG
		case TYPE_ANALYSIS:
			//ShowInfoInGrid(tr);
			break;			
		case TYPE_FILE:
		///Jasmine 02/07/07 MAKE_A_CLEAR_TREE_VIEW
			ShowFileInfo(tr);
			break;
		///End MAKE_A_CLEAR_TREE_VIEW
		default :
			ShowTree(tr);
			break;
		}
	}
protected :
	void UpdateList(int* pnRow = NULL)
	{
		
		//updateBranchVector();		///Folger 06/27/07 FIX_REFRESH_ORGANIZE		//------Folger 06/28/07 FIX_IMPORT_REFRESH_BUG
		
		SetReady(false);		//------Folger 06/28/07 FIX_IMPORT_REFRESH_BUG
		
		string strSel = m_wbkTree.GetCell(m_wbkTree.GetSelectedRow(), 0);//OUT(strSel);//for debug
		bool bSheetSelected = isSheetSelected();///---Sim 07-24-2009 QA80-13573-P1 AVOID_CHANGE_LAYER_EVENT_MIX_UP_ACTIVE_SEL
		TreeNode trInfo;
		trInfo=m_wbkTree.UpdateDetail();
		///DG 4/20/05 REWRITE_TREE_GET_NODE
		/*
		//Frank 3/20/05 v8.0207 APPLY_ADDTREENODES_WITH_NEW_RULE					
		//ShowList(trInfo, ATRN_CHECK_STOP_ATTRIBUTE | ATRN_STOP_LEVEL | LIST_TREE_LEVEL);
		ShowList(trInfo,NULL ,LIST_TREE_LEVEL);
		//End APPLY_ADDTREENODES_WITH_NEW_RULE					
		*/
		ShowList(trInfo, ATRN_STOP_LEVEL | LIST_TREE_LEVEL);
		///end REWRITE_TREE_GET_NODE
		int nRow = pnRow? *pnRow : m_wbkTree.FindRow(strSel);		
		m_wbkTree.SelRow(nRow);//strSel = (string)nRow;		OUT(strSel);//for debug
		///---Sim 07-24-2009 QA80-13573-P1 AVOID_CHANGE_LAYER_EVENT_MIX_UP_ACTIVE_SEL
		//if(nRow == -1)
			//updateShowActiveSheet();
		updateShowActiveSheet(bSheetSelected);
		///---END QA80-13573-P1 AVOID_CHANGE_LAYER_EVENT_MIX_UP_ACTIVE_SEL
		
		SetReady(true);		//------Folger 06/28/07 FIX_IMPORT_REFRESH_BUG
	}
	void ShowPageInfo(TreeNode &tr)
	{
		//Show Page info
		//----Jasmine 10/18/06 CHANGE_TO_TREE_DYNA_SPLITTER
		//m_treeEditCntrl.SetReady(false);
		//m_treeEditCntrl.CreateTreeView();
		SetReady(false);
		//----
		m_paramTree.Reset();
		m_wbkTree.GetPageInfo(m_paramTree, tr);
		//----Jasmine 10/18/06 CHANGE_TO_TREE_DYNA_SPLITTER		
		//m_treeEditCntrl.Update(m_paramTree, true, true);
		//m_treeEditCntrl.SetReady(true);		
		///---Sim 2009-08-04 QA81-14036 FIX_LOST_FOCUS_ON_COMMAND_WINDOW_WHEN_SHOW_WB_ORGANIZER
		//UpdateDynaControl(true, GETNEVENT_ON_INIT, false, 0, false);
		UpdateDynaControl(true, GETNEVENT_ON_INIT, false, WKB_SPL_DYNALAYOUT_BITS, false);
		///---END QA81-14036 FIX_LOST_FOCUS_ON_COMMAND_WINDOW_WHEN_SHOW_WB_ORGANIZER
		SetReady(true);
		//----
	}
	void ListContent(TreeNode &tr, bool bReadOnly = false)///Jasmine 03/21/07 MODIFICATION_EDIT_USER_TREE
	{
		//Simply list Sheets
		//----Jasmine 10/18/06 CHANGE_TO_TREE_DYNA_SPLITTER		
		//m_treeEditCntrl.SetReady(false);
		//m_treeEditCntrl.CreateTreeView();
		SetReady(false);
		//----		
		m_paramTree.Reset();
		m_wbkTree.ListContent(m_paramTree, tr);
		if(bReadOnly)///Jasmine 03/21/07 MODIFICATION_EDIT_USER_TREE
			_make_tree_node_readonly(m_paramTree);
		//----Jasmine 10/18/06 CHANGE_TO_TREE_DYNA_SPLITTER	
		//m_treeEditCntrl.Update(m_paramTree, true, true);
		//m_treeEditCntrl.SetReady(true);	
		///---Sim 2009-08-04 QA81-14036 FIX_LOST_FOCUS_ON_COMMAND_WINDOW_WHEN_SHOW_WB_ORGANIZER
		//UpdateDynaControl(true, GETNEVENT_ON_INIT, false, 0, false);
		UpdateDynaControl(true, GETNEVENT_ON_INIT, false, WKB_SPL_DYNALAYOUT_BITS, false);
		///---END QA81-14036 FIX_LOST_FOCUS_ON_COMMAND_WINDOW_WHEN_SHOW_WB_ORGANIZER
		SetReady(true);
		//----
	}
	void ShowSheetInfo(TreeNode &tr)
	{
		//----Jasmine 10/18/06 CHANGE_TO_TREE_DYNA_SPLITTER		
		//m_treeEditCntrl.SetReady(false);
		//m_treeEditCntrl.CreateTreeView();
		SetReady(false);
		//----
		m_paramTree.Reset();
		m_wbkTree.GetSheetInfo(m_paramTree, tr);
		//----Jasmine 10/18/06 CHANGE_TO_TREE_DYNA_SPLITTER		
		//m_treeEditCntrl.Update(m_paramTree, true, true);
		//m_treeEditCntrl.SetReady(true);		
		///---Sim 2009-08-04 QA81-14036 FIX_LOST_FOCUS_ON_COMMAND_WINDOW_WHEN_SHOW_WB_ORGANIZER
		//UpdateDynaControl(true, GETNEVENT_ON_INIT, false, 0, false);
		///Jasmine 10/29/09 QA80-14502 DISPLAY_LABEL_AND_TAGNAME_FOR_USER
		UpdateDynaControl(true, GETNEVENT_ON_INIT, false, WKB_SPL_DYNALAYOUT_BITS|DYNALAYOUT_TOOLTIP_TAGNAMES, false);
		///End DISPLAY_LABEL_AND_TAGNAME_FOR_USER
		///---END QA81-14036 FIX_LOST_FOCUS_ON_COMMAND_WINDOW_WHEN_SHOW_WB_ORGANIZER
		//----
		SetReady(true);
	}
	void ShowGraphInfo(TreeNode &tr)
	{
		//wait...
	}

	void ShowInfoInGrid(TreeNode &tr)
	{
		//----Jasmine 10/18/06 CHANGE_TO_TREE_DYNA_SPLITTER		
		//m_treeEditCntrl.SetReady(false);
		//m_treeEditCntrl.UpdateGrid(tr);
		//m_treeEditCntrl.SetReady(true);
		SetReady(false);
		m_paramTree = tr;
		///---Sim 2009-08-04 QA81-14036 FIX_LOST_FOCUS_ON_COMMAND_WINDOW_WHEN_SHOW_WB_ORGANIZER
		//UpdateDynaControl(true, GETNEVENT_UPDATE_GUI_TREE, false, 0, false);
		UpdateDynaControl(true, GETNEVENT_UPDATE_GUI_TREE, false, WKB_SPL_DYNALAYOUT_BITS, false);
		///---END QA81-14036 FIX_LOST_FOCUS_ON_COMMAND_WINDOW_WHEN_SHOW_WB_ORGANIZER
		SetReady(true);
		//----
	}

	void ShowTree(TreeNode &tr)
	{
		//----Jasmine 10/18/06 CHANGE_TO_TREE_DYNA_SPLITTER		
		//m_treeEditCntrl.SetReady(false);
		//m_treeEditCntrl.CreateTreeView();
		//m_treeEditCntrl.Update(tr, true, true);
		//m_treeEditCntrl.SetReady(true);
		SetReady(false);
		m_paramTree = tr;
		///---Sim 2009-08-04 QA81-14036 FIX_LOST_FOCUS_ON_COMMAND_WINDOW_WHEN_SHOW_WB_ORGANIZER
		//UpdateDynaControl(true, GETNEVENT_ON_INIT, false, 0, false);
		UpdateDynaControl(true, GETNEVENT_ON_INIT, false, WKB_SPL_DYNALAYOUT_BITS, false);
		///---END QA81-14036 FIX_LOST_FOCUS_ON_COMMAND_WINDOW_WHEN_SHOW_WB_ORGANIZER
		SetReady(true);
		//----
	}
	///Jasmine 01/29/07 QA70-9287 EDIT_STORAGE
	///Jasmine 02/07/07 MAKE_A_CLEAR_TREE_VIEW
	//void ShowStorage(TreeNode &tr, int nType)
	void ShowSection(TreeNode &tr)
	{
		SetReady(false);
		m_paramTree.Reset();
		//m_wbkTree.GetStorage(m_paramTree, tr, nType);
		m_wbkTree.GetSection(m_paramTree, tr.tagName);
		m_paramTree.Show = m_paramTree.GetNodeCount();///Jasmine 03/21/07 MODIFICATION_EDIT_USER_TREE
		///---Sim 2009-08-04 QA81-14036 FIX_LOST_FOCUS_ON_COMMAND_WINDOW_WHEN_SHOW_WB_ORGANIZER
		//UpdateDynaControl(true, GETNEVENT_ON_INIT, false, 0, false);
		UpdateDynaControl(true, GETNEVENT_ON_INIT, false, WKB_SPL_DYNALAYOUT_BITS, false);
		///---END QA81-14036 FIX_LOST_FOCUS_ON_COMMAND_WINDOW_WHEN_SHOW_WB_ORGANIZER
		SetReady(true);
	}
	///End EDIT_STORAGE
	void ShowBranch(TreeNode &tr)
	{
		SetReady(false);
		m_paramTree.Reset();
		m_wbkTree.GetBranch(m_paramTree, tr.tagName);
		m_paramTree.Show = m_paramTree.GetNodeCount();///Jasmine 03/21/07 MODIFICATION_EDIT_USER_TREE
		///---Sim 2009-08-04 QA81-14036 FIX_LOST_FOCUS_ON_COMMAND_WINDOW_WHEN_SHOW_WB_ORGANIZER
		//UpdateDynaControl(true, GETNEVENT_ON_INIT, false, 0, false);
		///Jasmine 10/29/09 QA80-14502 DISPLAY_LABEL_AND_TAGNAME_FOR_USER
		UpdateDynaControl(true, GETNEVENT_ON_INIT, false, WKB_SPL_DYNALAYOUT_BITS|DYNALAYOUT_TOOLTIP_TAGNAMES, false);
		///End DISPLAY_LABEL_AND_TAGNAME_FOR_USER
		///---END QA81-14036 FIX_LOST_FOCUS_ON_COMMAND_WINDOW_WHEN_SHOW_WB_ORGANIZER
		SetReady(true);
	}
	void ShowFileInfo(TreeNode &tr)
	{
		SetReady(false);
		m_paramTree.Reset();
		m_wbkTree.GetFileInfo(m_paramTree, tr.tagName);
		///---Sim 2009-08-04 QA81-14036 FIX_LOST_FOCUS_ON_COMMAND_WINDOW_WHEN_SHOW_WB_ORGANIZER
		//UpdateDynaControl(true, GETNEVENT_ON_INIT, false, 0, false);
		UpdateDynaControl(true, GETNEVENT_ON_INIT, false, WKB_SPL_DYNALAYOUT_BITS, false);
		///---END QA81-14036 FIX_LOST_FOCUS_ON_COMMAND_WINDOW_WHEN_SHOW_WB_ORGANIZER
		SetReady(true);		
	}
	///End MAKE_A_CLEAR_TREE_VIEW
protected :
	void SetPageInfo(TreeNode &trInfo, int nRow)
	{
		string str=trInfo.strVal;
		switch(nRow)
		{
		case PAGE_INFO_PAGE_SNAME:
			m_wp.Rename(str);
			updatePageName(str);
			break;
		case PAGE_INFO_PAGE_LNAME:
			m_wp.SetLongName(str);
			updatePageName(str);	//if short name auto change, update
			break;
		case PAGE_INFO_PAGE_COMMENT:
			m_wp.SetComments(str);
			break;
		default:	//PAGE_INFO_TITLE_SHOWN:
			m_wp.TitleShow=trInfo.nVal+1;
			break;
		}
	}
	void SetSheetName(TreeNode &trInfo, int nRow, bool bDataSheet)
	{
		//Get sheet
		//TreeNode trSheet=tree_get_node(m_trSel, nRow-1, 1, 1);
		//TreeNode trSheet=tree_get_node(m_trSel, nRow-1, 1); //CPY 3/17/05, may need to check other arg later, I was not able to compile this
		//TreeNode trSheet = tree_get_node(m_trSel, nRow-1, 0); ///DG 4/12/05 bug, stop level from select node	///DG 4/18/05 REWRITE_TREE_GET_NODE
		TreeNode trSheet = tree_get_node(m_trSel, nRow-1, ATRN_STOP_LEVEL | 0);
		
		string strOldName, strNewName=trInfo.strVal;
		trSheet.GetAttribute(STR_LABEL_ATTRIB, strOldName);
		Datasheet wks=m_wp.Layers(strOldName);
		//-------Folger 07/19/07 FIX_BUGS_IN_RENAME_BY_AUTO_ENUM_NEXT_VALID_NAME
		//if(wks.SetName(strNewName))
		if(wks.SetName(strNewName, OCD_ENUM_NEXT))
		//-------End FIX_BUGS_IN_RENAME_BY_AUTO_ENUM_NEXT_VALID_NAME
		{
			//success
			trInfo.strVal = strNewName = wks.GetName();		//sheet name may be enumerated when conflict
			trSheet.SetAttribute(STR_LABEL_ATTRIB, strNewName);
			//------ Folger 01/04/07 QA70-10902 FIX_WRONG_FOCUS_AFTER_SHEET_RENAME
			//**it seems that Datasheet has the same structure as Resultshee now, so just comment the difference
			//int nEachSheetPerRow=bDataSheet ? 2 : 1;//Each datasheet take 2 rows: Sheet name and Columns
			//int nListRow=m_nSelectedRow+nRow*nEachSheetPerRow-(int)bDataSheet;
			int nListRow = m_nSelectedRow + nRow;
			//------
			m_wbkTree.SetCell(nListRow, 0, strNewName);
			m_bNoNeedUpdateTree = true;		//------ Folger 01/04/07 QA70-10902 FIX_WRONG_FOCUS_AFTER_SHEET_RENAME
		}
		else	//fail
		{
			//m_treeEditCntrl.SetReady(false);
			//m_treeEditCntrl.SetCell(nRow, 1, strOldName);
			//m_treeEditCntrl.SetReady(true);
		}
	}
	void SetSheetInfo(TreeNode &trInfo, int nRow)
	{
		string strSheetName;
		m_trSel.GetAttribute(STR_LABEL_ATTRIB, strSheetName);
		/// TD 8-3-06 QA70-8843 DOWNCAST_BUG
		//WksAccess wksView(m_wp.Layers(strSheetName));
		Worksheet wks(m_wp.Layers(strSheetName));
		int nLevel;
		///Jasmine 10/23/06 ADD_ROW_NUM
		///Jasmine 02/03/07 FIX_SET_NUM_ROW_BUG
		if(trInfo.DataID >= BRN_WKS_VIEW && trInfo.DataID < BRN_LAST_ENTRY)
		{
			WksAccess wksView(wks);
			/// end DOWNCAST_BUG
			if(wksView.IsValid())
				wksView.SetTree(trInfo.Parent());
		}
		else if(BRN_WKS_ROWS == trInfo.DataID)
		{
			wks.SetNumRows(trInfo.nVal);
			trInfo.nVal = wks.GetNumRows();	//if trInfo.nVal is too small, SetNumRows will use a bigger number, so need to get the number after SetNumRows
		}
		///End FIX_SET_NUM_ROW_BUG
		///End ADD_ROW_NUM
		///Jasmine 01/31/07 QA70-9287 EDIT_STORAGE
		else
		{
			///Jasmine 12/31/09 STORAGE_CODE_SHOULD_COMPATIBLE_WITH_MATRIX
			Datasheet ds( m_wp.Layers(strSheetName) );
			TreeNode trParent;
			int nStorageType = getStorageType(trInfo, trParent, &nLevel);
			if(STORAGE_TYPE_INI == nStorageType)
			{
				trParent = trInfo.Parent();
				bool bRet = info_set_section(ds/*wks*/, trParent, trParent.tagName);
			}
			if(STORAGE_TYPE_BINARY == nStorageType)	
				tree_put_binary_storage(trParent, ds/*wks*/, "TREE");	
			///End STORAGE_CODE_SHOULD_COMPATIBLE_WITH_MATRIX
		}
		///End EDIT_STORAGE
	}
	///Jasmine 07/19/06 REMOVE_COLUMN_FROM_WBORG
	/*
	void SetColumn(TreeNode &trInfo, int nRow, int nCol)
	{
		TreeNode trCol=trInfo.Parent();
		ColProperties colAccess;
		getSetColumn(colAccess, trInfo, nRow - ROW_HEADER);
		if(colAccess.SetTree(trCol, trInfo))
			ShowInfoInGrid(m_trSel);
		m_wp.Refresh();
	}
private: 
	bool getSetColumn(ColProperties &col, TreeNode &trColInfo, int nColIndex)
	{
		TreeNode trSheet=trColInfo.Parent().Parent().Parent();
		string strSheetName;
		trSheet.GetAttribute(STR_LABEL_ATTRIB, strSheetName);
		Worksheet wks=m_wp.Layers(strSheetName);
		col.Attach(wks, nColIndex);
		return col.IsValid();
	}
	*/
	///End REMOVE_COLUMN_FROM_WBORG
private:
	void updatePageName(string strName)
	{
		if(m_wp.GetName() == strName)
		{
			m_trSel.SetAttribute(STR_LABEL_ATTRIB, strName);
			m_wbkTree.SetCell(0, 0, strName);
			//----Jasmine 10/18/06 CHANGE_TO_TREE_DYNA_SPLITTER
			//m_treeEditCntrl.SetCell(PAGE_INFO_PAGE_SNAME, 1, strName);
			//m_treeEditCntrl.SetCell(PAGE_INFO_PAGE_LNAME, 1, m_wp.GetLongName());
			TreeNode tr = tree_get_node(m_paramTree, PAGE_INFO_PAGE_SNAME);
			tr.strVal = strName;
			tr = tree_get_node(m_paramTree, PAGE_INFO_PAGE_LNAME);
			tr.strVal = m_wp.GetLongName();
			//----
		}
	}
	///---Sim 07-24-2009 QA80-13573-P2 SYNCHRONIZE_SHEET_SELECTION_WHEN_CURRENT_SELECTION_IN_DATA_SHEETS
	//bool updateShowActiveSheet()
	bool updateShowActiveSheet(bool bUpdateSel = true)
	///---END QA80-13573-P2 SYNCHRONIZE_SHEET_SELECTION_WHEN_CURRENT_SELECTION_IN_DATA_SHEETS
	{
		//----- CPY 7/22/06 QA70-8849 SHARE_WKBOOK_MATBOOK_ORGANIZER
		//Worksheet wksActive = m_wp.Layers();
		Datasheet wksActive = m_wp.Layers();
		//-----
		/// Hong 08/22/08 v8.0927 FIX_RUNTIME_ERROR_WHEN_DRAG_OUT_LAST_SHEET_WITH_ORGANIZER_ACTIVE
		if ( !wksActive )
			return false;
		/// end FIX_RUNTIME_ERROR_WHEN_DRAG_OUT_LAST_SHEET_WITH_ORGANIZER_ACTIVE
///Jasmine 06/14/07 FREEZE_SELECTION
		//----Jasmine 10/18/06 CHANGE_TO_TREE_DYNA_SPLITTER, temp
		int nActiveRow=MarkItemByActive(m_wbkTree.GetWksDisplayID(wksActive), STR_RELATED_ATTRIB);
		//int nActiveRow = 0;
		//----
		if ( bUpdateSel ) ///---Sim 07-24-2009 QA80-13573-P2 SYNCHRONIZE_SHEET_SELECTION_WHEN_CURRENT_SELECTION_IN_DATA_SHEETS
			m_wbkTree.SelRow(nActiveRow);
		return true;
	}
	//move from TreeEditSplitter.h
	//Related Item can be more, ',' to separate
	int MarkItemByActive(int nActiveDataID, string strRelatedAttrib="")
	{
		int nActiveRow=-1, nData;
		for(int ii=0; ii<m_wbkTree.GetRows(); ii++)
		{
			string strRelatedDataIDList;
			vector<string> vsRelatedDataIDs;
			TreeNode trNode=GetTreeNode(ii);
			trNode.GetAttribute(strRelatedAttrib, strRelatedDataIDList);
			strRelatedDataIDList.GetTokens(vsRelatedDataIDs, ',');
			if(nActiveDataID == trNode.DataID)
			{
				nData=0;
				if( -1 == nActiveRow ) //return the first row found
					nActiveRow=ii;
			}
			else if(-1 != vsRelatedDataIDs.Find((string)nActiveDataID))
			{
				if(!trNode.GetAttribute(STR_DATA_ATTRIB, nData))
					nData=0;	//no set, default bold
			}
			else
				nData = -1;
			
			markRowByData(ii, nData);	//clear
		}
		return nActiveRow;
	}	
	void markRowByData(int nRow, int nData=-1)
	{
		bool bBold = 0 == nData ? true : false;
		uint nColor = nData > 0 ? nData : 0;
		
		m_wbkTree.SetBold(nRow, LABEL_COL_INDEX, bBold);
		m_wbkTree.SetCellColor(nRow, LABEL_COL_INDEX, nColor);
	}
///End FREEZE_SELECTION
	///---Sim 07-24-2009 QA80-13573-P2 SYNCHRONIZE_SHEET_SELECTION_WHEN_CURRENT_SELECTION_IN_DATA_SHEETS
	bool isSheetSelected()
	{
		int nSelected = m_wbkTree.GetSelectedRow();
		if ( nSelected < 0 ) 
			return true;
		
		int nType;
		TreeNode trSel = GetTreeNode(nSelected);
		//---Jasmine 11/13/09 if delete last user tree, the last row becomes invalid
		//if ( trSel.GetAttribute(STR_TYPE_ATTRIB, nType) )
		if (trSel && trSel.GetAttribute(STR_TYPE_ATTRIB, nType) )
		//---End
		{
			if ( TYPE_SHEET == nType )
				return true;
		}
		
		return false;		
	}
	///---END QA80-13573-P2 SYNCHRONIZE_SHEET_SELECTION_WHEN_CURRENT_SELECTION_IN_DATA_SHEETS
	///Jasmine 01/29/07 QA70-9287 EDIT_STORAGE
	int getStorageType(const TreeNode tr, TreeNode& trRoot, int* pnLevel = NULL)
	{
		int nLevel = LEVEL_ROOT;
		for(TreeNode trParent = tr; trParent.IsValid(); trParent = trParent.Parent())
		{
			int nType;
			if(trParent.GetAttribute(STR_TYPE_ATTRIB, nType))
			{
				trRoot = trParent;
				if(TYPE_BINARY_STORAGES == nType)
				{
					if(pnLevel)
						*pnLevel = nLevel;					
					return STORAGE_TYPE_BINARY;
				}
				if(TYPE_INI_STORAGES == nType)
				{
					if(pnLevel)
						*pnLevel = nLevel;	
					return STORAGE_TYPE_INI;
				}
			}
			nLevel++;
		}
		if(pnLevel)
			*pnLevel = nLevel;
		return -1;
	}
	BOOL deleteSection(OriginObject& obj, TreeNode& trDel, string strStorageSection)
	{
		if(!obj.IsValid() || !trDel.IsValid() || 2 != strStorageSection.GetNumTokens('.'))
			return FALSE;
		string strStorage = strStorageSection.GetToken(0, '.');
		string strSection = strStorageSection.GetToken(1, '.');
		storage st;
		st = obj.GetStorage(strStorage);
		st.DeleteSection(strSection);
		return trDel.Remove();
	}
	BOOL deleteVariable(OriginObject& obj, TreeNode& trDel, string strStorageSection)
	{	///Jasmine 03/21/07 MODIFICATION_EDIT_USER_TREE
		if(!obj.IsValid() || !trDel.IsValid() || 2 != strStorageSection.GetNumTokens('.'))
			return FALSE;
		string strStorage = strStorageSection.GetToken(0, '.');
		string strSection = strStorageSection.GetToken(1, '.');
		storage st;
		st = obj.GetStorage(strStorage); 
		string strSectionVariable = strSection +"."+ trDel.tagName;
		BOOL bRet = st.DeleteValue(strSectionVariable);
		return trDel.Remove();
	}	///End MODIFICATION_EDIT_USER_TREE
	BOOL deleteBranch(OriginObject& obj, TreeNode& trDel, string strStorage)
	{
		if(!obj.IsValid() || !trDel.IsValid())
			return FALSE;
		Tree trStorage;
		///Jasmine 02/14/07 DELETE_IMPORTED_FILE
		string strBinaryStorage = strStorage;
		if(!strBinaryStorage.CompareNoCase("ImportedFiles"))
			strBinaryStorage = IFI_BINARY_STORAGE_NAME;
		tree_get_binary_storage(trStorage, obj, strBinaryStorage);
		TreeNode trBranch = tree_get_node_by_tagname(trStorage, trDel.tagName, true);
		if(trBranch.IsValid())
			trBranch.Remove();
		tree_put_binary_storage(trStorage, obj, strBinaryStorage);
		///End DELETE_IMPORTED_FILE
		return trDel.Remove();				 
	}
	BOOL deleteNode(OriginObject& obj, TreeNode& trRoot, TreeNode& trDel, string strBranch, int nItem)
	{//to delete TREE binary storage's subnode only
		if(!obj.IsValid() || !trRoot.IsValid() || !trDel.IsValid())
			return FALSE;
		trDel.Remove();				 
		if(nItem == TYPE_SHEET)
			return tree_put_binary_storage(trRoot, obj, trRoot.tagName);			
		set_user_info(obj, strBranch, trRoot);
		return TRUE;
	}
	///Jasmine 11/17/09 QA80-14502-S2 RENAME_TREE_NODE
	BOOL editBranch(OriginObject& obj, TreeNode& trParent, string strStorage, string strCurrent, string strName, string strLabel)
	{
		if(!obj.IsValid() || !trParent.IsValid())
			return FALSE;
		//update GUI
		if( !usertree_replace_node(trParent, strCurrent, strName, strLabel) )
			return FALSE;
		//update storage
		string strBinaryStorage = strStorage;
		if(!strBinaryStorage.CompareNoCase("ImportedFiles"))
			strBinaryStorage = IFI_BINARY_STORAGE_NAME;
		
		Tree trStorage;
		tree_get_binary_storage(trStorage, obj, strBinaryStorage);

		if( !usertree_replace_node(trStorage, strCurrent, strName, strLabel) )
			return FALSE;
		
		tree_put_binary_storage(trStorage, obj, strBinaryStorage);
		return TRUE;				 
	}
	BOOL editNode(OriginObject& obj, TreeNode& trRoot, TreeNode& trCurrent, int nItem, string strBranch, string strName, string strLabel)
	{
		if(!obj.IsValid() || !trRoot.IsValid() || !trCurrent.IsValid())
			return FALSE;
		
		if( !usertree_replace_node(trRoot, trCurrent.tagName, strName, strLabel) )
			return FALSE;
		
		if(nItem == TYPE_SHEET)
			return tree_put_binary_storage(trRoot, obj, trRoot.tagName);
		
		set_user_info(obj, strBranch, trRoot);
		return TRUE;
	}
	///End RENAME_TREE_NODE
	///Jasmine 03/21/07 MODIFICATION_EDIT_USER_TREE
	string getNewName(TreeNode trParent, int nType)
	{
		///Jasmine 02/03/10 SEPARATE_STORAGE_SECTION_TWO_EDITBOX_MAKE_USER_FRIENDLY
		string strLabel = WB_STORAGE_VARIABLE == nType? _L("Variable Name") : _L("Storage Name");
		
		string strHints;
		ocu_load_msg_str(CER_TAGNAME_ONLY_ALLOW_LETTER_AND_NUMBER, &strHints);
	
		GETN_TREE(trAdd)
		GETN_AUTO_SAVE_BRANCH_OPEN(1) /// Iris 7/04/2012 ORG-6033-P1 TO_PREVENT_GETN_AUTO_SAVE_BRANCH_OPEN_STATUS_TO_REG
		GETN_STR(notes, "", strHints) GETN_READ_ONLY_COLOR
		GETN_STR(name, strLabel, "")
		GETN_STR(section, _L("Section Name"), "")
		
		if(WB_STORAGE_VARIABLE == nType)			
			trAdd.section.Remove();
		
		for( ; ; )
		{
			string strName = trAdd.name.strVal;
			if(trAdd.section)
				strName += "." + trAdd.section.strVal;
			
			if((WB_STORAGE_SECTION == nType && 2 == strName.GetNumTokens('.')) || (WB_STORAGE_SECTION != nType && 1 == strName.GetNumTokens('.')))
			{
				int nErr = storage_tree_check_node_name(trParent, strName);
				if(nErr == CER_NO_ERROR)
					break;
				
				if(nErr == CER_NAME_ALREADY_EXIST)
					warning_msg_box(CER_NAME_ALREADY_EXIST, true);
			}
			if(!GetNBox(trAdd, WB_STORAGE_VARIABLE == nType? _L("Add Variable") : _L("Add Section"), NULL, NULL, NULL, GetSafeHwnd()))
				return "";
		}
		
		string strName = trAdd.name.strVal;
		if(trAdd.section)
			strName += "." + trAdd.section.strVal;
		return strName;
		///End SEPARATE_STORAGE_SECTION_TWO_EDITBOX_MAKE_USER_FRIENDLY
	}
	///End MODIFICATION_EDIT_USER_TREE
	BOOL addSection(OriginObject& obj, TreeNode& trParent, string strStorageSection)
	{
		if(!obj.IsValid() || !trParent.IsValid() || 2 != strStorageSection.GetNumTokens('.'))
			return FALSE;
		TreeNode trSection = trParent.AddNode(strStorageSection, TRGP_BRANCH);///Jasmine 03/21/07 MODIFICATION_EDIT_USER_TREE
		trSection.SetAttribute(STR_ATTRIB_BRANCH, GETNBRANCH_OPEN);

		return info_set_section(obj, trSection, strStorageSection);
	}
	BOOL addVariable(OriginObject &obj, TreeNode &trParent, string strStorageSection, string strName)
	{
		if(!obj.IsValid() || !trParent.IsValid())
			return FALSE;
		trParent.AddNode(strName);
		return info_set_section(obj, trParent, strStorageSection);		
	}
	BOOL addBranch(OriginObject& obj, TreeNode& trParent, const string& strName, const string& strLabel)
	{
		if(!obj.IsValid() || !trParent.IsValid())
			return FALSE;
		
		///Jasmine 11/06/09 QA80-14502 REWRITE_CODE_TO_SHARE_COL_PROP_USER_TREE_CODE		
		TreeNode trAdd;
		usertree_make_node(trAdd, trParent, strName, strLabel, USERTREE_BRANCH_NODE);
		if(!trAdd)
			return FALSE;
		///End REWRITE_CODE_TO_SHARE_COL_PROP_USER_TREE_CODE

		set_user_info(obj, strName, trAdd);
		return TRUE;
	}
	/// Hong 11/13/09 QA80-14502 WBK_ORGANIZER_USER_TREE_EDIT_GUI_THE_SAME_AS_COL_PROPERTY
	//BOOL addNode(OriginObject& obj, TreeNode& trRoot, TreeNode& trParent, string strBranch, string strName, int nItem, int nNodeType)
	BOOL addNode(OriginObject& obj, TreeNode& trRoot, TreeNode& trParent, string strBranch, string strName, int nItem, int nNodeType, const string& strLabel)
	/// end WBK_ORGANIZER_USER_TREE_EDIT_GUI_THE_SAME_AS_COL_PROPERTY
	{
		if(!obj.IsValid() || !trRoot.IsValid() || !trParent.IsValid())
			return FALSE;
		
		///Jasmine 11/06/09 QA80-14502 REWRITE_CODE_TO_SHARE_COL_PROP_USER_TREE_CODE		
		TreeNode trAdd;
		usertree_make_node(trAdd, trParent, strName, strLabel, nNodeType);
		if(!trAdd)
			return FALSE;
		///End REWRITE_CODE_TO_SHARE_COL_PROP_USER_TREE_CODE
		
		if(nItem == TYPE_SHEET)
			return tree_put_binary_storage(trRoot, obj, trRoot.tagName);			
		set_user_info(obj, strBranch, trRoot); 	
		return TRUE;
	}
	///End EDIT_STORAGE
	///Jasmine 02/09/10 QA81-14502-P5 ADD_LABEL_TO_DYNA_TREE_TEMPORARILY
	bool copyLabelFromRoot(const TreeNode& trRoot, TreeNode& trUserTree)
	{
		if(!trUserTree)
			return false;
		
		bool bUseLabel = false;
		
		string strLabel;
		if( trUserTree.GetAttribute(STR_LABEL_ATTRIB, strLabel) )
			ASSERT(0);
		else if(trRoot && trRoot.GetAttribute(STR_LABEL_ATTRIB, strLabel))
			bUseLabel = trUserTree.SetAttribute(STR_LABEL_ATTRIB, strLabel);
		
		return bUseLabel
	}
	///End ADD_LABEL_TO_DYNA_TREE_TEMPORARILY
	
	///Jasmine 05/31/07 ENABLE_REIMPORT_MENU_ON_IMPORT_TYPE
	bool IsReimportable(TreeNode& trImportFile)
	{
		Tree trImportInfo;
		m_wbkTree.GetFileInfo(trImportInfo, trImportFile.tagName);
		return isReimportable(trImportInfo);
	}
	///End ENABLE_REIMPORT_MENU_ON_IMPORT_TYPE
	///Jasmine 04/16/07 QA80-9418 v8.0597 ADD_REIMPORT_MENU_BY_JUSTIN_REQUIRED
	void reimport(TreeNode& trImportFile, bool bChangeOptions = false)
	{
		Tree trImportInfo;
		m_wbkTree.GetFileInfo(trImportInfo, trImportFile.tagName);
		
		//doing...
		/// Hong 04/09/07 QA80-9418 v8.0597 MORE_ADD_REIMPORT_MENU_BY_JUSTIN_REQUIRED
		DataRange dr;
		TreeNode trRange = tree_get_node_by_tagname(trImportInfo, "DataRange", true);
		dr = get_and_check_range(trRange, m_wp.GetName());
		
		XFBase xf("reimport");
		
		if (!xf)
			return ;
		
		int nShowDialog = bChangeOptions ? 1 : 0;
		//printf("%d", nShowDialog); //only for debug
		
		xf.SetArg("dialog", nShowDialog);
		xf.SetArg("orng", dr);
		
		int nErr;
		xf.ExecuteLabTalk(NULL, NULL, NULL, 0, &nErr, 0);
		/// end MORE_ADD_REIMPORT_MENU_BY_JUSTIN_REQUIRED
	}
	///End ADD_REIMPORT_MENU_BY_JUSTIN_REQUIRED
	///---Sim 05-22-2007 MAKE_FILTER_BY_IMPORT_SETTING
	void makefilter(TreeNode& trImportFile)
	{
		Tree trImportInfo;
		m_wbkTree.GetFileInfo(trImportInfo, trImportFile.tagName);
		
		TreeNode trFilter = tree_get_node_by_tagname(trImportInfo, "FilterInfo", true);
		if ( !trFilter )
		{
			warning_msg_box(_L("Not found filter info tree."), false);
			return;
		}
		
		XFBase xf("iwfilter");
		
		if (!xf)
			return ;
		
		///---Sim 09-30-2007 PROPER_VAR_NAME
		//xf.SetArg("filter", trFilter);
		xf.SetArg("ifilter", trFilter);
		///---END PROPER_VAR_NAME
		
		int nErr;
		xf.ExecuteLabTalk(NULL, NULL, NULL, 0, &nErr, LTXF_SHOW_DIALOG);
	}
	///---END MAKE_FILTER_BY_IMPORT_SETTING
	///Folger 06/26/07 REFRESH_ORGANIZER
	bool selectFileNodeByIndex()
	{
		string strFile;
		strFile.Format(IFI_FILE_NODE_ENUM_NAME, m_nFileIndex);
		for(int ii=0; ii<m_wbkTree.GetRows(); ii++)
		{
			if (GetTreeNode(ii).tagName.CompareNoCase(strFile) == 0)
			{
				m_wbkTree.SelRow(ii);
				//OUT(_L("OK"));
				return true;
			}
		}
		return false;
	}
	///End REFRESH_ORGANIZER
	///Folger 06/27/07 FIX_REFRESH_ORGANIZE
	bool updateBranchVector()
	{
		if (m_vnBranch.GetSize() == 0)
		{
			if (m_trSel)
			{				
				TreeNode trParent = m_trSel.Parent();
				//OUT(trParent.tagName);
				if (trParent && trParent.tagName.CompareNoCase("ImportedFiles") == 0)
				{
					TREE_CTRL_VAR.GetCollapsed(m_vnBranch, false);
					return true;
				}
			}
		}
		return false;
	}
	///End FIX_REFRESH_ORGANIZE
private:
//----- CPY 7/22/06 QA70-8849 SHARE_WKBOOK_MATBOOK_ORGANIZER
//	WorksheetPage	m_wp;
	Page			m_wp;
	string 			m_strName;	//Hong 7/24/06 SHARE_WKBOOK_MATBOOK_ORGANIZER_ADD_MORE
//----
	WksInfoTree		m_wbkTree;
	TreeNode		m_trSel;
	int 			m_nSelectedRow;
	int				m_nActiveLayer;	///Jasmine 06/14/07 FREEZE_SELECTION
	///Folger 06/26/07 REFRESH_ORGANIZER
	/// Hong 10/24/07 v8.0732 IMPROVE_ORGANIZER_REFRESH_BY_ONIDLE
	//bool			m_bImportWaitRefresh;
	bool			m_bUpdateFromImport;
	bool			m_bRefreshOnIdle; 
	/// end IMPROVE_ORGANIZER_REFRESH_BY_ONIDLE
	int				m_nFileIndex;
	vector<byte>	m_vnBranch;
	///End REFRESH_ORGANIZER
	/// TD 08-29-2007 QA70-8843 DOWNCAST_BUG
	Dialog m_dlgParent;
	/// end DOWNCAST_BUG
	
	//if true, indicate that need not to refresh the splitter tree ( in OnOriginModify() )
	bool			m_bNoNeedUpdateTree;		//------ Folger 01/04/07 QA70-10902 FIX_WRONG_FOCUS_AFTER_SHEET_RENAME
};


///////////////////////////////////////////////////////////////////
///Jasmine 11/06/09 QA80-14502 REWRITE_CODE_TO_SHARE_COL_PROP_USER_TREE_CODE
static bool _is_system_storage(LPCSTR lpcszStorageSection)
{
	string strStorage, strSection;
	if( get_storage_and_section_names(strStorage, strSection, lpcszStorageSection) && strStorage.CompareNoCase("system") == 0)
		return true;
	
	return false;
}

#define _NO_DELETE			( IDNO == MessageBox(GetSafeHwnd(), _L("Are you sure you want to delete?\nCannot undo operation!"), NULL, MB_YESNO) )

enum
{
	WORG_LIST_NONE = -1,
	WORG_LIST_NORMAL,
	WORG_LIST_DELETE
};
///////////////////////////////////////////////////////////////////
///////////////////////	worgImportFileMenu	///////////////////////
///////////////////////////////////////////////////////////////////
enum{
	WORG_IMPORTFILEMENU_DELETE,
		WORG_IMPORTFILEMENU_SEPARATOR1,
	WORG_IMPORTFILEMENU_REIMPORT, 
	WORG_IMPORTFILEMENU_REIMPORT_OPTIONS, 
	///---Sim 05-22-2007 MAKE_FILTER_BY_IMPORT_SETTING
		WORG_IMPORTFILEMENU_SEPARATOR2,
	WORG_IMPORTFILEMENU_MAKE_FILTER, 
	///---END MAKE_FILTER_BY_IMPORT_SETTING
	WORG_IMPORTFILEMENU_LAST_ITEM
};
///Jasmine 04/16/07 QA80-9418 v8.0597 ADD_REIMPORT_MENU_BY_JUSTIN_REQUIRED
///Jasmine 05/31/07 ENABLE_REIMPORT_MENU_ON_IMPORT_TYPE
class worgImportFileMenu : public Menu
{
public:
	worgImportFileMenu(bool bDelete, bool bReImport = false)
	{
		m_nChoice = -1;
		
		Add(_L("Delete"), OnMenuItem, bDelete? MF_ENABLED : MF_DISABLED | MF_GRAYED);
		Add(NULL, EmptySepFunc, MF_SEPARATOR);
		
		int nFlag = bReImport? MF_ENABLED : MF_DISABLED | MF_GRAYED;
		/// Max 5/23/08 v8.0869d JOE_SUGGEST_TO_USE_RE-IMPORT
		//Add(_L("Reimport directly"), OnMenuItem, nFlag);
		//Add(_L("Reimport by changing options"), OnMenuItem, nFlag);
		Add(_L("Re-Import directly"), OnMenuItem, nFlag);
		Add(_L("Re-Import by changing options"), OnMenuItem, nFlag);
		/// END JOE_SUGGEST_TO_USE_RE-IMPORT
		
		///---Sim 05-22-2007 MAKE_FILTER_BY_IMPORT_SETTING
		Add(NULL, EmptySepFunc, MF_SEPARATOR);	
		Add(_L("Make Filter"), OnMenuItem);
		///---END MAKE_FILTER_BY_IMPORT_SETTING
	}	
	void OnMenuItem(UINT nPos)
	{
		m_nChoice = nPos;
	}
	bool GetCommand(int& nChoice)
	{		
		if(m_nChoice >= WORG_IMPORTFILEMENU_DELETE && m_nChoice <= WORG_IMPORTFILEMENU_LAST_ITEM)
		{
			nChoice = m_nChoice;
			return true;
		}
		return false;
	}
	void EmptySepFunc(uint nCmd)
	{
	}
private:
	int	m_nChoice;
};
///End ADD_REIMPORT_MENU_BY_JUSTIN_REQUIRED
///End ENABLE_REIMPORT_MENU_ON_IMPORT_TYPE
int WkbookSplitter::ShowImportFileMenu(TreeNode& trFile, int nx, int ny, bool bDelete)
{
	int nRet = WORG_LIST_NONE;
	
	///Jasmine 05/31/07 ENABLE_REIMPORT_MENU_ON_IMPORT_TYPE
	//bShowReimportMenu = true;	///Jasmine 04/16/07 QA80-9418 v8.0597 ADD_REIMPORT_MENU_BY_JUSTIN_REQUIRED
	bool bReImport = IsReimportable(trFile);
	///End ENABLE_REIMPORT_MENU_ON_IMPORT_TYPE
	worgImportFileMenu myMenu(bDelete, bReImport);
	myMenu.TrackPopupMenu(0, nx, ny, GetSafeHwnd());
	
	int nCmd;
	if( !myMenu.GetCommand(nCmd) )
		return nRet;
	
	switch(nCmd)
	{
	case WORG_IMPORTFILEMENU_DELETE:
		if( _NO_DELETE )
			break;
		string strStorage = trFile.Parent()? trFile.Parent().tagName : "ImportedFiles";		
		deleteBranch(m_wp, trFile, strStorage);
		nRet = WORG_LIST_DELETE;
		break;
	case WORG_IMPORTFILEMENU_REIMPORT:
	case WORG_IMPORTFILEMENU_REIMPORT_OPTIONS:
		reimport(trFile, WORG_IMPORTFILEMENU_REIMPORT_OPTIONS == nCmd);
		nRet = WORG_LIST_NORMAL;
		break;
	///---Sim 05-22-2007 MAKE_FILTER_BY_IMPORT_SETTING
	case WORG_IMPORTFILEMENU_MAKE_FILTER:
		makefilter(trFile);
		nRet = WORG_LIST_NORMAL;
		break;
	///End MAKE_FILTER_BY_IMPORT_SETTING
	}
	
	return nRet;
}
///////////////////////////////////////////////////////////////////
////////////////////	end worgImportFileMenu	///////////////////
///////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////
///////////////////////	worgINIStorageMenu	///////////////////////
///////////////////////////////////////////////////////////////////
enum{
	WORG_INISTORAGEMENU_DELETE,
	WORG_INISTORAGEMENU_SECTION,
	WORG_INISTORAGEMENU_VARIABLE,
	WORG_INISTORAGEMENU_LAST_ITEM
};
class worgINIStorageMenu : public Menu
{
public:
	worgINIStorageMenu(bool bDelete, bool bSection, bool bVariable)
	{
		m_nChoice = -1;		
		Add(_L("Delete"), OnMenuItem, bDelete? MF_ENABLED : MF_DISABLED | MF_GRAYED);
		Add(_L("Add Section"), OnMenuItem, bSection? MF_ENABLED : MF_DISABLED | MF_GRAYED);	
		Add(_L("Add Variable"), OnMenuItem, bVariable? MF_ENABLED : MF_DISABLED | MF_GRAYED);	
	}	
	void OnMenuItem(UINT nPos)
	{
		m_nChoice = nPos;
	}
	bool GetCommand(int& nChoice)
	{		
		if(m_nChoice >= WORG_INISTORAGEMENU_DELETE && m_nChoice <= WORG_INISTORAGEMENU_LAST_ITEM)
		{
			nChoice = m_nChoice;
			return true;
		}
		return false;
	}
	void EmptySepFunc(uint nCmd)
	{
	}
private:
	int	m_nChoice;
};

int WkbookSplitter::ShowINIStorageMenu(OriginObject& obj, TreeNode& trCurrent, int nx, int ny, bool bDelete, bool bSection, bool bVariable, int nItem)
{
	int nRet = WORG_LIST_NONE;
	
	worgINIStorageMenu myMenu(bDelete, bSection, bVariable);
	myMenu.TrackPopupMenu(0, nx, ny, GetSafeHwnd());
	
	int nCmd;
	if( !myMenu.GetCommand(nCmd) )
		return nRet;
	
	TreeNode trRoot;
	int nLevel;
	int iRet = getStorageType(trCurrent, trRoot, &nLevel);
	
	switch(nCmd)
	{
	case WORG_INISTORAGEMENU_DELETE:
		if( _NO_DELETE )
			break;
		
		if(LEVEL_SECTION == nLevel)
		{
			TreeNode trParent = trCurrent.Parent();
			if(!trParent)
				return nRet;
		
			deleteSection(obj, trCurrent, trCurrent.tagName);
		
			if(!trParent.GetNodeCount())
			{
				TreeNode trNoInfo = trParent.AddTextNode(_L("No Info."), "NoInfo");
				trNoInfo.SetAttribute(STR_TYPE_ATTRIB, TYPE_SECTION);
				trNoInfo.SetAttribute(STR_LABEL_ATTRIB, "");
				trNoInfo.Enable = 2;
			}
		}
		else
		{
			///Jasmine 03/21/07 MODIFICATION_EDIT_USER_TREE
			TreeNode trParent;
			if(TYPE_SHEET == nItem)
				trParent = trCurrent.Parent();
			else
				trParent = m_trSel;
			
			deleteVariable(obj, trCurrent, trParent.tagName);

			///Folger 04/24/07 ADD_NO_INFO_MSG
			if (m_paramTree.GetNodeCount() == 0)
				set_noinfo(m_paramTree, true);
			///End ADD_NO_INFO_MSG
			///End MODIFICATION_EDIT_USER_TREE
		}
		
		nRet = WORG_LIST_DELETE;
		break;
	case WORG_INISTORAGEMENU_SECTION:
		TreeNode trParent = nLevel < LEVEL_SECTION? trCurrent : trCurrent.Parent();
		
		string strName = getNewName(trParent, WB_STORAGE_SECTION);
		if(strName.IsEmpty())
			break;				
		
		addSection(obj, trParent, strName);//"user." + strName);///Jasmine 03/21/07 MODIFICATION_EDIT_USER_TREE
		
		if(trParent.NoInfo.IsValid())
			trParent.NoInfo.Remove();
		
		nRet = WORG_LIST_NORMAL;
		break;
	case WORG_INISTORAGEMENU_VARIABLE:
		TreeNode trParent;
		string strStorageSection;
		
		if(-1 == iRet)
		{
			trParent = trCurrent.Parent();
			if(!trParent) trParent = trCurrent;
			strStorageSection = m_trSel.tagName;
		}
		else
		{
			trParent = nLevel > LEVEL_SECTION? trCurrent.Parent() : trCurrent;
			strStorageSection = trParent.tagName;
		}
		
		string strName = getNewName(trParent, WB_STORAGE_VARIABLE);
		if(strName.IsEmpty())
			break;				
				
		///Folger 04/24/07 ADD_NO_INFO_MSG
		if (m_paramTree.GetNode("NoInfo").IsValid())
			set_noinfo(m_paramTree, false);
		///End ADD_NO_INFO_MSG
		addVariable(obj, trParent, strStorageSection, strName);
		nRet = WORG_LIST_NORMAL;
	}
	
	return nRet;
}
///////////////////////////////////////////////////////////////////
////////////////////	end worgINIStorageMenu	///////////////////
///////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////
///////////////////////	worgUserTreeMenu	///////////////////////
///////////////////////////////////////////////////////////////////
int WkbookSplitter::ShowUserTreeMenu(OriginObject& obj, TreeNode& trCurrent, int nx, int ny, bool bDelete, bool bTree, bool bNode, int nItem)
{
	int nRet = WORG_LIST_NONE;
	
	UserTreeMenu myMenu(bDelete, bTree, bNode);
	myMenu.TrackPopupMenu(0, nx, ny, GetSafeHwnd());
	
	int nCmd;
	if( !myMenu.GetCommand(nCmd) )
		return nRet;
	
	TreeNode trRoot;
	int nLevel;
	getStorageType(trCurrent, trRoot, &nLevel);
	
	///Jasmine 02/09/10 QA81-14502-P5 ADD_LABEL_TO_DYNA_TREE_TEMPORARILY
	//addNode, editNode etc need a whole tree to add into the object, but when use m_paramTree,
	//root node shows on left and m_paramTree only has the other part.
	//so now temporarily set label of root node in m_paramTree
	bool bUseLabel = copyLabelFromRoot(m_trSel, m_paramTree);
	///End ADD_LABEL_TO_DYNA_TREE_TEMPORARILY
	
	switch(nCmd)
	{
	///Jasmine 11/17/09 QA80-14502-S2 RENAME_TREE_NODE
	case USERTREEMENU_EDIT:
		TreeNode trParent = trCurrent.Parent();
		
		string strName, strLabel;
		trCurrent.GetAttribute(STR_LABEL_ATTRIB, strLabel);
		bool bRet = usertree_edit_node_name(trParent, strName, strLabel, GetSafeHwnd(), 0, NULL, trCurrent.tagName, strLabel);
		if(!bRet)
			break;
		
		if(nLevel == LEVEL_SECTION)
			bRet = editBranch(obj, trParent, trParent.tagName, trCurrent.tagName, strName, strLabel);
		else
		{
			string strBranch;
			if(TYPE_SHEET == nItem)
			{
				strBranch = "";
			}
			else
			{
				trRoot = m_paramTree;
				strBranch = m_trSel.tagName;
			}
			bRet = editNode(obj, trRoot, trCurrent, nItem, strBranch, strName, strLabel);
		}
			
		nRet = bRet? WORG_LIST_NORMAL : WORG_LIST_NONE;
		break;	
	///End RENAME_TREE_NODE
	case USERTREEMENU_DELETE:
		if( _NO_DELETE )
			break;
		
		if(nLevel == LEVEL_SECTION)
		{
			TreeNode trParent = trCurrent.Parent();
			deleteBranch(obj, trCurrent, trParent.tagName);
			if(!trParent.GetNodeCount())
			{
				TreeNode trNoInfo = trParent.AddTextNode(_L("No Info."), "NoInfo");
				trNoInfo.SetAttribute(STR_TYPE_ATTRIB, TYPE_BRANCH);
				trNoInfo.SetAttribute(STR_LABEL_ATTRIB, "");
				trNoInfo.Enable = 2;
			}
		}
		else
		{
			string strBranch;
			if(TYPE_SHEET == nItem)
			{
				strBranch = "";
			}
			else
			{
				trRoot = m_paramTree;
				strBranch = m_trSel.tagName;
			}
			deleteNode(obj, trRoot, trCurrent, strBranch, nItem);			
		}
		
		///Folger 04/24/07 ADD_NO_INFO_MSG
		if (m_paramTree.GetNodeCount() == 0)
			set_noinfo(m_paramTree, true);
		///End ADD_NO_INFO_MSG
			
		nRet = WORG_LIST_DELETE;
		break;			
	case USERTREEMENU_TREE:
		TreeNode trParent = nLevel < LEVEL_SECTION? trCurrent : trCurrent.Parent();
		
		string strName, strLabel;
		int nNodeType;
		usertree_input_node_name(trParent, strName, strLabel, nNodeType, GetSafeHwnd(), USERTREE_HIDE_TYPE_NODE);
		if( strName.IsEmpty() )
			break;				
			
		addBranch(obj, trParent, strName, strLabel);
		if(trParent.NoInfo.IsValid())
			trParent.NoInfo.Remove();
		
		nRet = WORG_LIST_NORMAL;
		break;
	case USERTREEMENU_NODE:		
		TreeNode trParent = trCurrent;
	
		string strName, strLabel;
		int nNodeType;
		usertree_input_node_name(trParent, strName, strLabel, nNodeType, GetSafeHwnd());
		if(strName.IsEmpty())
			break;				
			
		///Folger 04/24/07 ADD_NO_INFO_MSG
		if (m_paramTree.GetNode("NoInfo").IsValid())
		{
			set_noinfo(m_paramTree, false);
		}
		///End ADD_NO_INFO_MSG
		
		string strStorage = nItem == TYPE_SHEET? trRoot.tagName : m_trSel.tagName;		
		addNode(obj, trRoot? trRoot : m_paramTree, trParent, strStorage, strName, nItem, nNodeType, strLabel);
		
		nRet = WORG_LIST_NORMAL;
		break;
	}

	///Jasmine 02/09/10 QA81-14502-P5 ADD_LABEL_TO_DYNA_TREE_TEMPORARILY
	if(bUseLabel)
		m_paramTree.RemoveAttribute(STR_LABEL_ATTRIB);
	///End ADD_LABEL_TO_DYNA_TREE_TEMPORARILY
	
	return nRet;
}
///////////////////////////////////////////////////////////////////
////////////////////	end worgUserTreeMenu	///////////////////
///////////////////////////////////////////////////////////////////
int WkbookSplitter::ShowJunkMenu(int nx, int ny)
{
	UINT nFlag = MF_DISABLED | MF_GRAYED;
	
	Menu junkmenu;
	junkmenu.Add(_L("Delete"), 0, nFlag);
	junkmenu.Add(_L("Add Tree"), 0, nFlag);
	junkmenu.Add(_L("Add Node"), 0, nFlag);
	
	junkmenu.TrackPopupMenu(0, nx, ny, GetSafeHwnd());
	
	return WORG_LIST_NONE;
}
///Jasmine 01/29/07 QA70-9287 EDIT_STORAGE
///Jasmine 02/12/07 QA70-9287 CLEAN_UP_EDIT_STORAGE	,WBStorageMenu
BOOL WkbookSplitter::OnShowMenu(UINT nResIDCtrl, int nx, int ny)
{
	//------ Folger 09/08/08 FIX_RUNTIME_ERROR_WHEN_SHOW_MENU_WITH_NO_ITEM_SELECTED_IN_LEFT_PANE
	if ( !m_trSel )
		return false;
	//------ End FIX_RUNTIME_ERROR_WHNE_SHOW_MENU_WITH_NO_ITEM_SELECTED_IN_LEFT_PANE
	
	int nClickRow = -1;
	int nClickCol = -1;
	int nEditRow = -1;
	
	TreeNode tnActive;
	
	if(GetMainPaneID() == nResIDCtrl)
	{
		m_wbkTree.GetMouseCell(nClickRow, nClickCol);
		if(0 <= nClickRow && m_nSelectedRow != nClickRow)
			m_wbkTree.SelRow(nClickRow);
		else if(-1 == nClickRow || -1 == nClickCol)
			return false;
	}
	else if(GetTreeEditPaneID() == nResIDCtrl)
	{
		tnActive =	m_DynaCntrl.GetActiveTreeNode(nEditRow);	
		/* for debug
		if(tnActive.IsValid())	
		{
			int nEnable = tnActive.Enable;
			OUT(_L((string)nEnable));
		}
		else
			OUT(_L("tnActive InValid"));*/
	}
	
	int nRet = WORG_LIST_NONE;
	int nItem;
	m_trSel.GetAttribute(STR_TYPE_ATTRIB, nItem);
	switch(nItem)
	{				
	case TYPE_FILE://imported file
		bool bDelete = GetMainPaneID() == nResIDCtrl;
		nRet = ShowImportFileMenu(m_trSel, nx, ny, bDelete);
		break;
	case TYPE_INI_STORAGES://page.info
		bool bDelete = false;
		bool bSection = true;
		bool bVariable = false;
		nRet = ShowINIStorageMenu(m_wp, m_trSel, nx, ny, bDelete, bSection, bVariable, nItem);
		break
	case TYPE_SECTION://section under page.info
		bool bDelete, bSection, bVariable;
		if(GetTreeEditPaneID() == nResIDCtrl)	
		{
			bDelete = tnActive.IsValid();
			bSection = false;
			bVariable = (tnActive.IsValid()?(tnActive.Enable == -1 || tnActive.Enable == 1):(m_trSel.Enable == -1 || m_trSel.Enable == 1));
			
			nRet = ShowINIStorageMenu(m_wp, tnActive.IsValid()? tnActive : m_paramTree, nx, ny, bDelete, bSection, bVariable, nItem);
		}
		else
		{
			bDelete = true;
			bSection = true;
			bVariable = false;
			
			///Folger 05/28/07 ADD_INI_BINARY_STORAGETO_MATRIX
			if( _is_system_storage(m_trSel.tagName) )
			///End ADD_INI_BINARY_STORAGETO_MATRIX
			{
				bDelete = false;
			}
			
			nRet = ShowINIStorageMenu(m_wp, m_trSel, nx, ny, bDelete, bSection, bVariable, nItem);
		}
		break
	case TYPE_BINARY_STORAGES://user tree
		nRet = ShowUserTreeMenu(m_wp, m_trSel, nx, ny, false, true, false, nItem);
		break
	case TYPE_BRANCH://branch of user tree
		if(GetTreeEditPaneID() == nResIDCtrl)	
		{
			bool bEnable = (tnActive.IsValid()?(tnActive.Enable == -1 || tnActive.Enable == 1):(m_trSel.Enable == -1 || m_trSel.Enable == 1));
			bool bDelete = bEnable && tnActive.IsValid();
			nRet = ShowUserTreeMenu(m_wp, tnActive.IsValid()? tnActive : m_paramTree, nx, ny, bDelete, false, bEnable, nItem);
		}
		else
		{
			bool bDelete = m_trSel.Enable == -1 || m_trSel.Enable == 1;
			nRet = ShowUserTreeMenu(m_wp, m_trSel, nx, ny, bDelete, true, false, nItem);
		}
		break
	case TYPE_SHEET://a data sheet can has layer info or user tree
		if( GetTreeEditPaneID() == nResIDCtrl && tnActive.IsValid() )	
		{
			string strSheetName;
			m_trSel.GetAttribute(STR_LABEL_ATTRIB, strSheetName);
			Worksheet wks(m_wp.Layers(strSheetName));
			MatrixLayer ml(m_wp.Layers(strSheetName));	///Folger 05/28/07 ADD_INI_BINARY_STORAGETO_MATRIX
			OriginObject obj;
			obj = wks;
			///Folger 05/28/07 ADD_INI_BINARY_STORAGETO_MATRIX
			if (!obj)
			{
				obj = ml;
			}
			///End ADD_INI_BINARY_STORAGETO_MATRIX
			
			TreeNode trRoot;
			int nLevel;
			int nStorageType = getStorageType(tnActive, trRoot, &nLevel);
			
			bool bEnable = tnActive.Enable == -1 || tnActive.Enable == 1;
			
			if(STORAGE_TYPE_INI == nStorageType)
			{				
				bool bDelete = nLevel < LEVEL_SECTION? false : ( _is_system_storage(tnActive.tagName)? false : bEnable);
				bool bSection = nLevel > LEVEL_SECTION? false : bEnable;
				bool bVariable = nLevel < LEVEL_SECTION? false : bEnable;
				nRet = ShowINIStorageMenu(obj, tnActive, nx, ny, bDelete, bSection, bVariable, nItem);
				break;
			}
			else if(STORAGE_TYPE_BINARY == nStorageType)
			{
				bool bDelete = nLevel < LEVEL_SECTION? false : bEnable;
				bool bTree = nLevel > LEVEL_SECTION? false : bEnable;
				bool bNode = nLevel < LEVEL_SECTION? false : bEnable;
				nRet = ShowUserTreeMenu(obj, tnActive, nx, ny, bDelete, bTree, bNode, nItem);
				break;
			}
		}
	default:	
		nRet = ShowJunkMenu(nx, ny);
		break;
	}
	
	switch(nRet)
	{
	case WORG_LIST_NONE:
		break;
	case WORG_LIST_DELETE:
		nClickRow--;
	default:
		if(GetMainPaneID() == nResIDCtrl)
		{
			UpdateList(&nClickRow);
		}
		else
		{
			///Jasmine 10/29/09 QA80-14502 DISPLAY_LABEL_AND_TAGNAME_FOR_USER
			UpdateDynaControl(false, GETNEVENT_ON_INIT, false, DYNALAYOUT_TOOLTIP_TAGNAMES, false);
			///End DISPLAY_LABEL_AND_TAGNAME_FOR_USER
		}
	}
	
	return TRUE;
}
///End REWRITE_CODE_TO_SHARE_COL_PROP_USER_TREE_CODE
///////////////////////////////////////////////////////////////////


static void out_table(TreeNode &tr)
{
	vector<int> vnTableDisplayFormat = { DISPLAY_CENTER, DISPLAY_RIGHT, DISPLAY_RIGHT};
	TreeTable tTable(tr, vnTableDisplayFormat, true, false);
	int nRows=tTable.GetNumRows(), nCols=tTable.GetNumCols();
	for(int ii=0; ii< nCols; ii++)
	{
		for(int jj=0; jj<nRows; jj++)
		{
			string strVal=tTable.GetCell(ii, jj);
			printf("%s	", strVal);
		}
		printf("\n");
	}
	printf("\n\n");
}


//---- CPY 9//30/04
// dummy function to allow this file to be compile and link from FindFunction
// this is needed until we have a better way to compile a class
BOOL test_wkbooksplitter()
{
	WkbookSplitter junk;
	return false;
}
//----
///Folger 04/24/07 ADD_NO_INFO_MSG
void set_noinfo(TreeNode &trGetN, bool bMode)
{
	if (bMode)
	{
		TreeNode trNoInfo = trGetN.AddTextNode(_L("No Info (Right-Click to Edit)"), "NoInfo");
		trNoInfo.SetAttribute(STR_LABEL_ATTRIB, "");
		trNoInfo.Enable = 2;
	}
	else
	{
		trGetN.RemoveChild("NoInfo");
	}
}
///End ADD_NO_INFO_MSG
