/*------------------------------------------------------------------------------*
 * File Name:Stats_Operations 													*
 * Creation: CPY Feb 21, 2004													*
 * Purpose: Autoupdate Operation support for stats related functions			*
 * Copyright (c) Originlab Corp.	2004, 2005									*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	ML 3/3/2004 RANGE_BASED_REGRESSIONS											*
 *	ML 5/24/2004 QA70-6376 REPORT_TABLE_MULTIHEADERS_MORE_WORK					*
 *	CPY 6/9/04 TABLE_HEADER_CLEANUP_FOR_SINGLE_OR_MULTIPLE_SETS					*
 *	ML 6/27/2005 STYLE_LINKS_WITH_OFFSETS										*
 *	Echo 8/17/07	MOVE_TO_PAGE_UTILS											*
 *	TD 10-04-2007 QA80-10478 LOCALISED_REPORTTREE_ISSUE							*
 *	Sophy 11/28/2008 v8.0980d QA80-12591-P5 ADD_AUTO_SUPPORT_FOR_LR_AND_PR_FITCURVE_XDATATYPE
 *	Sophy 12/11/2008 v8.984d NLFIT_XDATATYPE_SHOULD_BE_SOURCE_GRAPH_SCALE_TYPE_AS_LR_WHEN_DATA_FROM_GRAPH
 *------------------------------------------------------------------------------*/

#ifndef _STATS_OPERATIONS_H
#define _STATS_OPERATIONS_H

/// Iris 01/15/2007 v8.0541 REMOVE_SUB_TABLE_FROM_ANOVE_MISS_MASK_DATA_TABLE
//remove this macro to remove sub levels in ANOVA table
//#define ANOVA_IN_SEPARATE_TABLES //CPY 8/13/04
///end REMOVE_SUB_TABLE_FROM_ANOVE_MISS_MASK_DATA_TABLE
///Arvin 08/03/07 WRONG_PARAMETER_SUMARY_TABLE_WHILE_FIT_REPLICA
//TreeNode	stats_tree_add_Parameters(const string &strDataLabel, bool bDataLabelAsTableMainHeader, TreeNode &trCal, int index, const FitParameter* pFitParams, vector<string> &vstrParamNames, vector<string>& vstrParamNamesPostfix, vector<string> &vstrFactors, const FitDerivedParameter* pstDerivedParams = NULL, int nNumDerivedParams = 0, vector<bool> &vbIsDerived = NULL);
/// TD 10-04-2007 QA80-10478 LOCALISED_REPORTTREE_ISSUE
//Made a member of FitterOperation
//TreeNode	stats_tree_add_Parameters(const string &strDataLabel, bool bDataLabelAsTableMainHeader, TreeNode &trCal, int index, const FitParameter* pFitParams, vector<string> &vstrParamNames, vector<string>& vstrParamNamesPostfix, vector<string> &vstrFactors, const FitDerivedParameter* pstDerivedParams = NULL, int nNumDerivedParams = 0, vector<bool> &vbIsDerived = NULL, int nMultiplicity = 1, int nNumParamInFunc = 0, int nDupUnit = 0);
/// end LOCALISED_REPORTTREE_ISSUE
///end WRONG_PARAMETER_SUMARY_TABLE_WHILE_FIT_REPLICA
bool 	stats_tree_add_ANOVA_table(TreeNode &trOp, const string &strDataLabel, int index, int nTotalNumData, const RegANOVA& sANOVA, const vector<string> &vstrFactors);

int stats_tree_get_Parameters(const TreeNode &trCal, int index, FitParameter* pFitParams, vector<string> &vstrParamNames);
///Arvin 05/25/07 ADD_CORRECTED_TOTAL_ROW_FOR_ANOVA_TABLE_FOR_FITNL
//TreeNode	stats_tree_set_one_ANOVA_set(TreeNode &trANOVA, LPCSTR lpcszName,  LPCSTR lpcszDataLabel, int index, int nID, const RegANOVA& sANOVA, int indInStruct);
TreeNode	stats_tree_set_one_ANOVA_set(TreeNode &trANOVA, LPCSTR lpcszName,  LPCSTR lpcszDataLabel, int index, int nID, const RegANOVA& sANOVA, int indInStruct, LPCSTR lpcszLabel = NULL);
bool 		stats_tree_add_ANOVA_table(TreeNode &trOp, const string &strDataLabel, int index,  int nTotalNumData, const RegANOVA& sANOVA, vector<string> &vstrFactors, RegANOVARow& stCorrTotal);
///end ADD_CORRECTED_TOTAL_ROW_FOR_ANOVA_TABLE_FOR_FITNL
TreeNode	stats_tree_set_one_ANOVA_set(TreeNode &trANOVA, LPCSTR lpcszName, LPCSTR lpcszLabel, int nID, const RegANOVA& sANOVA, int nANOVARow);


/// ML 6/27/2005 STYLE_LINKS_WITH_OFFSETS
/**
		It creates a theme for the custom table for regressions.
	Parameters:
		treeTh=the tree to receive the theme.
		nHeadersColor=the color (as OCOLOR) for the linked table headers background, or -1 for no color
		vnStatisticsTableProps=[optional] the IDs of the properties from the Statistics table to be added
								between the Input Data linked table and the Parameters linked table.
	Returns:
		TRUE if OK.
*/
BOOL	make_regressions_custom_table_theme(TreeNode &treeTh, vector<int> &vnStatisticsTableProps = NULL, int nHeadersColor = -1, bool bBoldHeaders = true);
/// end STYLE_LINKS_WITH_OFFSETS

///Arvin 11/24/06 MULTI_DATA_NEED_MULTI_COVARIANCE_AND_CORRELATION_TABLE
bool stats_tree_add_cov_or_corr_table(TreeNode &trOp, const string& strTagName, const string& strDataLabel, int index, int nTotalNumData, int nID, const matrix& mCovOrCorr, const vector<string> &vstrParamNames);
///end MULTI_DATA_NEED_MULTI_COVARIANCE_AND_CORRELATION_TABLE

///Echo 8/17/07	MOVE_TO_PAGE_UTILS
//int find_plot_index_by_key(const GraphLayer& gl, LPCSTR lpcszKey1, LPCSTR lpcszKey2 = NULL, int nPlotFrom = -1, bool bCaseSensitive = false, DWORD dwCntrl = NTYPE_BOOKSHEET_XY_RANGE);
///END MOVE_TO_PAGE_UTILS
///Sophy 10/9/2008 QA80-10536-P12 REMOVE_FITTEDVALUE_FROM_RESIDUAL_AND_FINDXY_IF_NO_FITTED_CURVES_PLOT
int fitlinear_fitted_curves_option_changed( TreeNode& trGUI );
///end REMOVE_FITTEDVALUE_FROM_RESIDUAL_AND_FINDXY_IF_NO_FITTED_CURVES_PLOT
///Sophy 11/28/2008 v8.0980d QA80-12591-P5 ADD_AUTO_SUPPORT_FOR_LR_AND_PR_FITCURVE_XDATATYPE
bool stats_update_xdatatype_min_max_by_auto(const TreeNode& trInputData, TreeNode& trXDataType);
///end ADD_AUTO_SUPPORT_FOR_LR_AND_PR_FITCURVE_XDATATYPE

///Sophy 12/11/2008 v8.984d NLFIT_XDATATYPE_SHOULD_BE_SOURCE_GRAPH_SCALE_TYPE_AS_LR_WHEN_DATA_FROM_GRAPH
//void check_set_xdatatype_on_source_graph(TreeNode& trGUI);
///end NLFIT_XDATATYPE_SHOULD_BE_SOURCE_GRAPH_SCALE_TYPE_AS_LR_WHEN_DATA_FROM_GRAPH

#endif //_STATS_OPERATIONS_H

 
