/*------------------------------------------------------------------------------*
 * File Name: stats_guis.c														*
 * Creation: GJL 2/17/04 														*
 * Purpose: OriginC Source C file implementing Origin Statistics GUIs.			*
 * Copyright (c) OriginLab Corp.	2004, 2005, 2006, 2007, 2008, 2009			*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	ML 5/11/2004 SEPARATE_FUNCTION_FOR_COMMON_REPORT_NODES						*
 *	CPY 6/9/04 MOVE_REPORT_BRANCH_TO_BASE_CLASS									*
 *  Echo 9/12/04 ADD_OPTIONS_FOR_MONENT											*
 *  Echo 9/12/04 INTERPOLATE_TYPE_CHANGE										*
 *	Echo 11/26/04 V8.0167 QA70-7074	ADD_NEW_CONSTRAIN							*
 *	Echo 2/16/05 	ERROR_ORDER_TYPE_LIST										*
 *	Echo 3/22/05 v8.0207 QA70-6204 ADD_GSD										*
 *  Iris 4/12/05 MOVE_CURVE_OPTION_TO_EACH_GRAPH								*
 *  Iris 4/14/05 UPDATE_GRAPH_LEGEND											*
 *	Liko 6/14/2005 UPDATE_CONSTRUCT_2D_BINNING_GUI_TREE							*
 *	Kevin 08/29/05	ADD_NEW_ROC_CURVE											*
 *	Kevin 09/01/05 CHANGE_STATISTICS_NAME										*
 *	Kevin 09/06/05 ADD_MORE_GUI_OPTION_FOR_KAPLAN_MEIER_GUI_TREE				*
 *	Echo 09/06/05 CORRECT_CONF_ERROR											*
 *	DSC 9/20/05 QA70-8113 ADD_IDE_VAR_DIVISOR									*
 *  Echo 10/9/05 ADD_QUANTILE_METHOD											*
 *  Echo 10/12/05 FIT_ERROR_NAMED												*
 *  Iris 10/13/05 REMOVE_FIX_FOR_LR_PR_MR										*
 *  Iris 10/19/05 GUI_REMOVE_STATS												*
 *	ML 10/20/2005 ANOVA_INPUT_DATA_TO_DATARANGE									*
 *	Kevin 11/08/05	MODIFY_PARAMETER_NAME										*
 *  Iris 11/08/05 CHANGE_LABEL_ACORDING_TO_MAX_SUGGESTION						*
 *	Kevin 11/10/05 ADD_CONSTRUCT_ELlIPSE_GUI									*
 *	Kevin 11/10/05	CHANGE_CONFIDENCE_LEVEL_RANGE								*
 *	Echo 11/18/05 CHANGE_DS_QUANTILE_DEFAULT									*
 *	Kevin 11/21/05	USE_GETN_STR_GROUP											*
 *  Echo 11/30/05 ILL_Q1Q3_DEFINITION											*
 *	Kevin 12/01/05 QA70-3300 P3 GET_BACK_VALUE_WHEN_CONFIDEN_LEVEL_EXCEED		*
 *  Iris 12/13/05 ADD_CONTROL_LEVEL_FOR_DUNNETT_MEAN_COMP						*
 *  Iris 12/14/05 INIT_CONTROL_LEVEL_LIST_ON_LEVEL_NAME_CHANGE					*
 *  Iris 12/16/05 REMOVE_VARIANCE_POWER_FOR_RM									*
 *  Thomas 03/15/2006 UPDATE_FACTOR_LEVEL_NAME									*
 *  Jim 03/22/06 CORRECT_THE_WORD_OF_GUI                      					*
 *  Thomas 03/28/06 ADD_ONE_WAY_ANOVA_MEAN_COMP_EVENT							*
 *  Thomas 04/04/2006 ADD_FREQUENCY_COUNT_BINCENTER_AND_COUNT_EVENT				*
 *  Alex 04/17/06 ADD_DEFAULT_COMBOSTR_TO_CONTROL_LEVEL_COMBO                   *
 *	Echo 5/31/06 REORDER_DESC_STATS_RES											*
 *  Alex 06/05/06 MODIFY_DESC_STATS_DEFAULTGUI                                  *
 *  Alex 06/05/06 REORDER_DESC_STATS_NORMALITY_DEFAULTGUI                       *
 *  Alex 06/05/06 Alex 06/05/06 MODIFY_ANOVA_TWO_WAY_MAKE_INTER_CHECKED         *
 *  Alex 06/05/06 MODIFY_ANOVA_TWO_WAY_CLOSE_DESCRIPTIVE_BRANCH                 *
 *  Alex 06/05/05 MODIFY_DESC_STAT_MULTIPLE_REGRE_DEFAULTGUI                    *
 *	Thomas 06/08/06 MOVE_ANOVA_CHECK_BOX_TO_QUANTITIES_BRANCH					*
 *  Alex 06/14/06 SET_FIT_OPTIONS_TABLE_OPEN                                    *
 *  Alex 06/14/06 ADD_MCOR_AND_MCOV_CHECK_BOX_TO_QUANTITIES_BRANCH              *
 *	Echo 6/27/06 REPLACE_WITH_GLOBAL_FUNC										*
 *	Thomas 07/06/2006 MODIFY_ERR_AS_WEIGHT_EVENT								*
 *	Cheney 2006-8-30 QA70-8943 ADD_NEW_NODE_FOR_CONCATENATE 					*
 *	Jasmine 09/15/06 SET_NORMALITYTEST_METHODS_BRANCH_NAME						*
 *  Iris 11/15/06 NOT_REMEMBER_ROC_STATS_VAL_IN_THEME							*
 *  Iris 11/21/06 DEFAULT_X_SHOULD_BE_UNIFORM_LIENAR							*
 *	Joseph 12/07/06 v8.0523 SHOW_STATIC_ERR_MESSAGE_ON_BOTTOM_OF_DLG			*
 *	Max 12/21/06 CHANGE_QUANTILE_METHOD_ORDER									*
 *	Echo 1/17/07 REPORT_SSR_AS_DEFAULT											*
 *	AW 01/29/07 QA80-9310 v8.0550b AUTO_RECOGNITION_FOR_INDEX_RAW_DATA_IN_STATS_TOOL
 *	Cheney 2007-4-3 SET_CHECK_BOX_OF_NUMITER_DEFAULT_UNCHECK_BY_LARRY_SUGGEST	*
 *	Cheney 2007-4-4 SHOW_LB_UB_IN_REPORT_SHEET									*
 *	Cheney 2007-4-11 ONLY_FIT_NL_NEED_LB_UB										*
 *	Cheney 2007-4-13 FIX_BUG_OF_CUSTOM_TABLE_DISAPPEAR_WHEN_CONCATENATE			*
 *	Cheney 2007-4-27 STATAS_ON_ROW_NOT_NEED_WDF_ETC								*
 *	Cheney 2007-5-11 WHEN_SURFACE_FIT_DATA_TYPE_HAS_SOME_PROBLEM				*
 *	Cheney 2007-5-14 RENAME_FIT_TOOL_CHECK_BOX_NAME								*
 *	Arvin 05/18/07 USE_REDUCED_CHISQ_CHECKBOX_NOT_WORK							*
 *	Cheney 2007-5-23 QA70-9805 SPEED_UP_STATISTIC_ON_ROW						*
 *  Iris 06/27/2007 v8.0650 ACCESS_NODE_BY_DATAID_TO_AVOLID_RUNTIME_ERR			*
 *  Nicole 07/05/2007 v8.0655 REMOVE_SPACE_FOR_LOCATION_STRING					*
 *	Arvin 08/09/07 MODIFY_ANOVA_TWO_WAY_MAKE_INTER_UNCHECKED					*
 *	Arvin 08/10/07 QA70-10197 ADD_NONE_OPTION_FOR_ERROR_AS_WEIGHT_IN_LR_PR_AND_MR
 *	Arvin 08/22/07 REMOVE_USER_DEFINED_FROM_THRESHOLD_METHOD_OF_ROCCURVE		*
 *	YuI 09/10/07 QA70-10359 RESTRICT_ANOVA_INDEXED_DATA_TO_ONE_COLUMN			*
 *	Cheney 2007-9-18 IF_FROM_THEME_SHOULD_NOT_UPDATE_CUSTOM_RANGE				*
 *	Arvin 09/26/07 SHOULD_NOT_PLOT_CURVE_WHEN_UNCKECK_ROCCURVE					*
 *	YuI 09/26/07 QA70-10420 RESTRICT_RAW_DATA_ANOVA_CONTROLS_TO_ONE_DATA		*
 *	Arvin 09/27/07 ACTUAL_POWER_SHOULD_ALSO_SUPPORT_SIGLEVEL as Echo said		*
 *	YuI 09/28/07 A70-10436 ANOVA_DATA_SELECTTION_IN_SEPARATE_DIALOG_BROKEN		*
 *	RVD 10/2/2007 v8.0713 qa7-10446 FIX_DESC_STATS_SHEET_TO_COLS				*
 *	ML YuI 10/2/2007 QA70-10428 INCORRECT_NODE_RESETTING_ANOVA					*
 *	Arvin 10/22/07 ADD_CHECKBOX_USE_SOURCE_GRAPH_COLOR_TO_SET_FITCURVES_COLOR	*
 *	Hong 10/26/07 v8.0734 FIX_ERROR_LOCALIZE_WITH_MACRO							*
 *	Echo 10/27/07 MACRO_MOVED_TO_OERRMSG_DLL									*
 *	Folger 11/08/07 CATEGORY_NEEDED_WHEN_LOCALIZE								*
 *	Arvin 01/07/08 QA70-10903 ADD_CHECK_ALL_BOX_FOR_BRANCH						*
 *	Hong 01/21/08 QA80-10969 FITNL_SOPPURT_DO_PREVIEW_ON_SOURCE_GRAPHPAGE		*
 *	Hong 01/23/08 QA80-10969 DEFAULT_PREVIEW_IN_SOURCE_GRAPHPAGE				*
 *	Hong 01/23/08 QA80-10969 MOVE_PREVIEW_TO_HIGHER_LEVEL_IN_GUI				*
 *	Arvin 01/31/08 QA70-10948 SHOW_CORRELATION_COEFICIENT_IN_LR					*
 *	Folger 03/12/08 QA80-11244 SURFACE_FIT_REPORT_SHOULD_USE_CONTOUR_PLOTS		*
 *	Hong 13/05/08 QA80-11541 DISABLEAND_DEFAULT_CHECK_USE_REDUCED_CHISQR_IF_NO_WEIGHT
 *	Max 6/4/08 v8.0877 THIS_BRANCH_SHOULD_CLOSE_BY_DEFAULT						*
 *	Max 9/27/08 QA70-12295 v8.0948d PROPER_NOUN_NEEDS_NO_LOCALIZATION			*
 *	Hong 10/30/08 v8.0963b FIX_CHECK_UNCHECK_ALL_FAIL_FIRE_ALL_SUBNODE_EVENT	*
 *	Kyle 11/18/2008 QA80-12591 ADD_MORE_OPTION_FOR_INPUT_DATA_TYPE_IN_FITTING_TOOLS
 *	Hong 11/18/08 QA80-12603 v8.0974 PA_SUPPORT_LEGEND_UPDATE_OPTION			*
 *  Iris 11/20/2008 v8.0975d QA80-12591-P4 REMOVE_LOG_DATA_TYPE_WHEN_DATA_FROM_MATRIX*
 *	Sophy 11/28/2008 v8.0980d QA80-12591-P5 ADD_AUTO_SUPPORT_FOR_LR_AND_PR_FITCURVE_XDATATYPE
 *	Hong QA80-12866 v8.0991b FIX_ANOVA_INPUT_DATA_CHANGED_WHEN_SWITCH_THEME		*
 *	Folger 04/16/09 DO_FITLINEAR_BY_LT_XOP_TREE_CAUSE_RUNTIME_ERROR				*
 *	Kyle 08/06/2009 QA80-14077 ADD_UNIT_FOR_PARAMETER_SETTINGS					*
 *	Folger 08/07/09 UNIT_IN_PA_FITTING_PARAMETER_MAKE_OLD_THEME_FAIL_TO_APPLY_IN_81
 *	Kyle 09/03/2009 QA80-14077-P1 Unit_IS_ONLY_NEEDED_FOR_NLSF					*
 *  Iris 12/29/2009 QA81-14853 APPARENT_FIT_DEFAULT_SHOULD_BE_TURN_ON			*
 *  Iris 2/10/2010 QA81-10948 SHOW_PEARSONS_R_IN_REPORT_BY_DEFAULT				*
 *	Kyle 02/10/2010 QA80-14923 ADD_HINT_TEXT_OF_WHAT_IS_INDEX_AND_RAW_DATA		*
 *  Iris 5/31/2010 QA-14853-P1 FIX_MR_RESIDUAL_AYALYSIS_CHECKBOX_DISABLE_ISSUE	*
 *	Jasmine 06/08/10 SRVC-12-P2 FORCE_XY_DATA_TYPE_BOTH_BE_OR_NOT_BE_SAME_AS_INPUT_DATA
 *	Jacky 07/22/10 ORG-102 USER_CAN_SET_SIGNIFICANCE_LEVEL						*
 *	Folger 05/06/2011 ORG-2786-S1 MORE_POINTS_FOR_FITX_IN_NLFIT					*
 *	Sophy 6/29/2011 ORG-3133-S1 SUPPORT_POSITIVE_DIRECTION_IN_ROC_CURVE			*
 *	Folger 10/11/2011 ORG-4034-P3 CHANGE_PARAM_FAILED_FOR_TWO_WAY_ANOVA_RM_WHEN_USE_XOP
 *	Folger 12/16/2011 ORG-3035-P1 AUTO_FILL_LEVEL_NAMES_BY_DATA_IN_ANOVA		*
 *  Iris 3/16/2012 ORG-5212-P1 NEED_SET_MULTI_PLOTS_USE_SOURCE_GRAPH_COLOR_DEFAULT_AS_CHECKED
 *  Iris 5/21/2012 ORG-5218-P3 FIX_SET_FUNCTION_BY_THEME_NOT_UPDATE_INDEP_DATA_TYPE_BRANCH
 *	Folger 06/08/2012 ORG-5805-P3 HIDE_DATA_IDENTIFIER_IN_ANOVA_TOOL_IF_RAW_DATA*
 *	Folger 09/21/2012 ORG-6882-P1 SHOULD_NOT_TRANSLATE_ROC_CURVE_DATA_GROUP_LIST*
 *  Iris 9/24/2012 ORG-6855-S1 BETTER_SUPPORT_FOR_MULTIPLE_FORMULAS_IMPLICIT_FUNC_MORE
 *	Folger 09/29/2012 ORG-7031-P1 X_DATA_TYPE_NODE_MISSING_FROM_PA_FIT			*
 *------------------------------------------------------------------------------*/

#include <Origin.h>
#include "DialogEx.h"/// YuI 09/26/05 ANOVA_DATA_SELECTION_GUI (need to hind dilog in GUI event)

#pragma labtalk(0) //CPY 12/6/06 QA70-12736 LT_NEED_MORE_CNTRL_ON_ALLOWING_OC_FUNCS

#include "StatsOpCommon.h"
///------ Folger 05/06/2011 ORG-2786-S1 MORE_POINTS_FOR_FITX_IN_NLFIT
#include "StatsopBase.h"
#include <FitterOperation.h>
///------ End MORE_POINTS_FOR_FITX_IN_NLFIT
#include <GetNBox.h>
#include <event_utils.h>
#include <ocu.h>	///Joseph 12/07/06	ADD_MESSAGE_BOX
#include <..\Originlab\nlsf_utils.h> /// Iris 3/07/2012 ORG-5218-P1 NEW_GUI_OF_X_DATA_TYPE_FOR_IMPLICIT_FUNC
#define GETN_BEGIN_USE_BRANCH_L(_NODE_NAME) _tmpSubNode = _tmpNode.GetNode(cvt_str_to_tag_name(_NODE_NAME));TreeNode _tmSaveUse_##_NODE_NAME = _tmpNode; _tmpNode = _tmpSubNode;
#define GETN_END_USE_BRANCH_L(_NODE_NAME)	_tmpNode = _tmSaveUse_##_NODE_NAME;				

//------ Folger 11/08/07 CATEGORY_NEEDED_WHEN_LOCALIZE
#define STR_CAT_STATS "Statistics"
//------ End CATEGORY_NEEDED_WHEN_LOCALIZE

//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//////////                     Descriptive Statistics                   //////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////

BOOL DoDescStatsDialog(TreeNode &trGUI, BOOL bChangeParams)
{	
	tree_set_branch_open_status_auto_save(trGUI); /// Iris 7/04/2012 ORG-6033-P1 TO_PREVENT_GETN_AUTO_SAVE_BRANCH_OPEN_STATUS_TO_REG 
	BOOL bOKClicked = GetNBox(trGUI, _L("Descriptive Statistics"),
		 _L("Enter Descriptive Statistics parameters"), DescStatApplyOnClick);
	return bOKClicked;
}

bool fit_dlg_use_data_x_event(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
{
	///Iris 4/12/05 MOVE_CURVE_OPTION_TO_EACH_GRAPH
	//TreeNode trCuv = tr.Output.Data.ResultCurves; 
	TreeNode trCurrentNode = tree_get_node(tr, nRow);
	if(!trCurrentNode)
		return false;
	TreeNode trCuv = trCurrentNode.Parent();
	if(!trCuv || !trCuv.UseDataX || !trCuv.N || !trCuv.SpanXAxis || !trCuv.RangeMargin)
		return false;
	///end MOVE_CURVE_OPTION_TO_EACH_GRAPH
	bool bEnable = trCuv.UseDataX.nVal > 0? false:true;
	trCuv.N.Enable = bEnable;
	trCuv.XMin.Enable = bEnable;
	trCuv.XMax.Enable = bEnable;
	if(trCuv.SpanXAxis.nVal)
	{
		trCuv.XMin.Enable = 0;
		trCuv.XMax.Enable = 0;
	}
	trCuv.SpanXAxis.Enable = bEnable;
	trCuv.RangeMargin.Enable = bEnable;
	return true;
}

///Arvin 01/03/08 SHOULD_NOT_PLOT_ANY_RESIDUAL_GRAPH_WHEN_USER_HAVE_NOT_SELECT_ANY_TYPE_RESIDUAL
/*
bool residual_plot_event(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
{
	TreeNode trResAnalysis = tr.ResAnalysis;
	if(!trResAnalysis)
		return false;
	TreeNode trResPlots = tr.Residuals;
	if(!trResPlots)
		return false;
	
	bool bRegular, bStad, bStud, bStudDel;
	bRegular = trResAnalysis.Regular.nVal;
	bStad = trResAnalysis.Stad.nVal;
	bStud = trResAnalysis.Stud.nVal;
	bStudDel = trResAnalysis.StudDel.nVal;
	
	bool bShowResPlots = true;
	if(!bRegular && !bStad && !bStud && !bStudDel)
		bShowResPlots = false;
	trResPlots.Show = bShowResPlots;
	for(int nGraphIndex = GRAPH_RESIDUALS_SCATTER; nGraphIndex<GRAPH_FITTING_MAX_NODES_IN_REPORT; nGraphIndex++)
	{
		TreeNode 	trGraph = tree_check_get_node(trResPlots, op_get_graph_tag_name(nGraphIndex), IDE_RESULT_GRAPHS+nGraphIndex);
		if(trGraph)
		{
			if(!bShowResPlots)
			{
				//trGraph.Enable = false;
				trGraph.nVal = 0;
			}
		}
	}
	return true; 
}
*/
///end SHOULD_NOT_PLOT_ANY_RESIDUAL_GRAPH_WHEN_USER_HAVE_NOT_SELECT_ANY_TYPE_RESIDUAL

///Iris 6/11/05 support xyz data
bool fit_dlg_use_data_xy_event(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
{
	TreeNode trCurrentNode = tree_get_node(tr, nRow);
	if(!trCurrentNode)
		return false;
	TreeNode trCuv = trCurrentNode.Parent();
	if(!trCuv)
		return false;
	if( !trCuv.UseDataXY || !trCuv.NY || !trCuv.YMin || !trCuv.YMax || !trCuv.SpanYAxis)
		return false;
	
	bool bEnable = trCuv.UseDataXY.nVal > 0? false:true;
	
	trCuv.N.Enable = bEnable;
	trCuv.NY.Enable = bEnable;
	trCuv.XMin.Enable = bEnable;
	trCuv.XMax.Enable = bEnable;
	trCuv.YMin.Enable = bEnable;
	trCuv.YMax.Enable = bEnable;
	if(trCuv.SpanXAxis.nVal)
	{
		trCuv.XMin.Enable = 0;
		trCuv.XMax.Enable = 0;
		trCuv.YMin.Enable = 0;
		trCuv.YMax.Enable = 0;
	}
	trCuv.SpanXAxis.Enable = bEnable;
	trCuv.SpanYAxis.Enable = bEnable;
	trCuv.RangeMargin.Enable = bEnable;
	
	return true;
}

bool fit_curv_span_to_full_x_even(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
{
	TreeNode trSpanTo = tree_get_node(tr, nRow);
	if(!trSpanTo)
		return false;
	TreeNode trCuv = trSpanTo.Parent();
	if( !trCuv )
		return false;
	if(trCuv.UseDataX && trCuv.UseDataX.nVal)
		return false;
	if(trCuv.UseDataXY && trCuv.UseDataXY.nVal)
		return false;	

	bool bCheckedSpanTo = trSpanTo.nVal;
	
	trCuv.XMin.Enable = !bCheckedSpanTo;
	trCuv.XMax.Enable = !bCheckedSpanTo;
	
	return true;
}

bool fit_curv_span_to_full_xy_even(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
{
	TreeNode trSpanTo = tree_get_node(tr, nRow);
	if(!trSpanTo)
		return false;
	TreeNode trCuv = trSpanTo.Parent();
	if(!trCuv)
		return false;
	if(trCuv.UseDataX && trCuv.UseDataX.nVal)
		return false;
	if(trCuv.UseDataXY && trCuv.UseDataXY.nVal)
		return false;
	if( !trCuv.YMin || !trCuv.YMax)
		return false;
	
	bool bCheckedSpanTo = trSpanTo.nVal;	
	trCuv.YMin.Enable = !bCheckedSpanTo;
	trCuv.YMax.Enable = !bCheckedSpanTo;	
	
	return true;
}
///

bool fit_lr_fix_slope_event(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
{
	TreeNode trFit = tr.Fit;
	trFit.FixSlopeAt.Enable = trFit.FixSlope.nVal;
	if(trFit.FixSlope.nVal && trFit.FixIntercept.nVal)
	{
		trFit.FixIntercept.nVal = 0;
		trFit.FixInterceptAt.Enable = trFit.FixIntercept.nVal;
	}
	return true;
}

bool fit_lr_fix_intecept_event(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
{
	TreeNode trFit = tr.Fit;
	///------ Folger 04/16/09 DO_FITLINEAR_BY_LT_XOP_TREE_CAUSE_RUNTIME_ERROR
	if ( !trFit )
		return false;
	///------ End DO_FITLINEAR_BY_LT_XOP_TREE_CAUSE_RUNTIME_ERROR
	
	trFit.FixInterceptAt.Enable = trFit.FixIntercept.nVal;
	if(trFit.FixSlope.IsValid() && trFit.FixSlope.nVal && trFit.FixIntercept.nVal)
	{
		trFit.FixSlope.nVal = 0;
		trFit.FixSlopeAt.Enable = trFit.FixSlope.nVal;
	}
	return true;
}

///Arvin 06/22/07 v8.0646 APPARENT_CAN_NOT_DO_RESIDUAL_ANALYSIS
bool fit_lr_apparent_fit_event(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
{
	TreeNode trApparentFit = tr.Fit.ApparentFit;
	//----- Iris 5/31/2010 QA-14853-P1 FIX_MR_RESIDUAL_AYALYSIS_CHECKBOX_DISABLE_ISSUE
	//if(trApparentFit)
	if(trApparentFit && trApparentFit.Show)
	//-----
	{
		/// Iris 10/29/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
		//TreeNode trResAnalysis = tr.ResAnalysis;		
		//TreeNode trResType = tr.Residuals.ResType;
		TreeNode trResAnalysis = OP_GUI_RESIDUAL_ANALYSIS_BRANCH(tr);
		TreeNode trResType = OP_GUI_BRANCH_OF_RESIDUAL_PLOTS_CHECKBOX(tr).ResType;
		ASSERT(trResAnalysis);
		ASSERT(trResType);
		///end OP_DLG_NEW_STRUCTURE
		if(trApparentFit.Enable && trApparentFit.nVal)
		{
			if(trResAnalysis)
			{
				trResAnalysis.Stad.nVal = 0;
				trResAnalysis.Stad.Enable = false;
				trResAnalysis.Stud.nVal = 0;
				trResAnalysis.Stud.Enable = false;
				trResAnalysis.StudDel.nVal = 0;
				trResAnalysis.StudDel.Enable = false;
			}
			if(trResType)
			{
				trResType.nVal = 0;
				trResType.Enable = false;
			}
		}
		else
		{
			if(trResAnalysis)
			{
				trResAnalysis.Stad.Enable = true;
				trResAnalysis.Stud.Enable = true;
				trResAnalysis.StudDel.Enable = true;
			}
			if(trResType)
			{
				trResType.Enable = true;
			}
		}
	}
	return true;
}
///end APPARENT_CAN_NOT_DO_RESIDUAL_ANALYSIS

bool fit_err_as_weight_event(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
{
	TreeNode trFit = tr.Fit;
	/// Thomas 07/06/2006 MODIFY_ERR_AS_WEIGHT_EVENT
	/*
	if(trFit) 
		trFit.UseReducedChiSq.Enable = trFit.ErrBarWeight.nVal;
	*/
	if(trFit) {
		///Arvin 05/18/07 USE_REDUCED_CHISQ_CHECKBOX_NOT_WORK
		//trFit.UseReducedChiSq.Enable = trFit.ErrBarWeight.nVal;
		//if(!trFit.ErrBarWeight.nVal)
		//	trFit.UseReducedChiSq.nVal = 0;
		///Arvin 08/10/07 QA70-10197 ADD_NONE_OPTION_FOR_ERROR_AS_WEIGHT_IN_LR_PR_AND_MR
		//trFit.UseReducedChiSq.Enable = trFit.ErrBarWeight.Enable;
		//if(!trFit.ErrBarWeight.Enable)
		trFit.UseReducedChiSq.Enable = trFit.ErrBarWeight.Enable && trFit.ErrBarWeight.nVal!=ERRBARWEIGHT_NO_WEIGHTING;
		if(!trFit.UseReducedChiSq.Enable)
		///end ADD_NONE_OPTION_FOR_ERROR_AS_WEIGHT_IN_LR_PR_AND_MR
			trFit.UseReducedChiSq.nVal = 1;
		///end USE_REDUCED_CHISQ_CHECKBOX_NOT_WORK
	} 
	/// End MODIFY_ERR_AS_WEIGHT_EVENT
	return true;
}
/// Iris 06/27/06 NOT_SHOW_ERR_MESSAGE_DLG_FOR_INIT_TIME
//bool fit_conf_level_event(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
bool fit_conf_level_event(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg)
{
	/// Iris 06/27/2007 v8.0650 ACCESS_NODE_BY_DATAID_TO_AVOLID_RUNTIME_ERR
	//TreeNode trPara = tr.Quantities.Parameters;
	TreeNode trPara = tree_get_node_by_dataid(tr, IDST_FIT_PARAMS_OPTIONS, true);
	///end ACCESS_NODE_BY_DATAID_TO_AVOLID_RUNTIME_ERR
	TreeNode trConfidence = tree_get_node_by_dataid(tr, IDE_FIT_CONF_PERCENT, true);
	if( !trConfidence )
	///Jasmine 06/17/08 CONF_LEVEL_EVENT_NOT_WORK_FOR_PA_SINCE_ID_CHANGE
		//return false;
	{
		if(!trPara)
		{
			TreeNode trQuan = tree_get_node_by_tagname(tr, "Quantities", true);
			if(trQuan)
				trPara = trQuan.Parameters
		}
		if(trPara)
			trConfidence = trPara.Confidence;
		if( !trConfidence )
			return false;			
	}
	///End CONF_LEVEL_EVENT_NOT_WORK_FOR_PA_SINCE_ID_CHANGE
	trConfidence.Enable = (0 == trPara.LCL.nVal && 0 == trPara.UCL.nVal)? false : true;
	///Joseph	12/07/06	ADD_MESSAGE_BOX
	bool	bShowErrMsg = false;
	bool 	bOKEnable = true;
	///End	ADD_MESSAGE_BOX  
	if( !(dwCntrl & GETNEVENT_ON_INIT) && 0 >= trConfidence.dVal || 100 <= trConfidence.dVal)
	{
		///Joseph	12/07/06	ADD_MESSAGE_BOX
		bShowErrMsg = true;
		bOKEnable = false;
		//error_msg_box(_L(CON_LEV_VAL_ERROR_MSG));
		///End	ADD_MESSAGE_BOX  
	}
  
	/// Iris 4/30/2008 QA80-11303 KEEP_GUI_SIMPLE_JUST_CHANGE_REPORT_TABLE_TITLE
	/*
	/// Iris 4/18/2008 QA80-11303 ADD_PERCENT_AS_PREFIX_FOR_LCL_UCL_LABEL_IN_PARAM_TABLE
	string 	strLCL = "LCL", strUCL = "UCL";
	if( !bShowErrMsg ) // not error on trConfidence
	{
		int 	nConfidence =  trPara.Confidence.nVal;
		strLCL = (string) nConfidence + "% " + strLCL;
		strUCL = (string) nConfidence + "% " + strUCL;
	}
	trPara.LCL.SetAttribute(STR_LABEL_ATTRIB, strLCL);
	trPara.UCL.SetAttribute(STR_LABEL_ATTRIB, strUCL);
	
	TreeNode 	trSummary = tree_get_node_by_dataid(tr, IDE_PARAMS_SUMMARY, true);
	if(trSummary)		
	{
		if(trSummary.LCL)
			trSummary.LCL.SetAttribute(STR_LABEL_ATTRIB, strLCL);
		if(trSummary.UCL)
			trSummary.UCL.SetAttribute(STR_LABEL_ATTRIB, strUCL);
	}	
	///end ADD_PERCENT_AS_PREFIX_FOR_LCL_UCL_LABEL_IN_PARAM_TABLE
	*/
	///end KEEP_GUI_SIMPLE_JUST_CHANGE_REPORT_TABLE_TITLE
	
	/////Kevin 11/08/05 MODIFY_PARAMETER_NAME	
	//int nConfidence =  trFit.Confidence.nVal;
	//string strLCL = (string) nConfidence + "% LCL";
	//string strUCL = (string) nConfidence + "% UCL";
	//trPara.LCL.SetAttribute(STR_LABEL_ATTRIB, strLCL);
	//trPara.UCL.SetAttribute(STR_LABEL_ATTRIB, strUCL);
	/////End	MODIFY_PARAMETER_NAME
	
	///Joseph	12/07/06	ADD_MESSAGE_BOX
	//return true;
	
	///Echo 10/27/07 MACRO_MOVED_TO_OERRMSG_DLL
	//return	handle_dialog_errmsg(tr, bShowErrMsg, CON_LEV_VAL_ERROR_MSG, bOKEnable);	
	/// Iris 4/18/2008 QA80-11303 ADD_PERCENT_AS_PREFIX_FOR_LCL_UCL_LABEL_IN_PARAM_TABLE, want to refresh GUI to update LCL UCL Lable
	//return handle_dialog_errmsg(tr, bShowErrMsg, CER_INVALID_CONF_LEV, bOKEnable);
	handle_dialog_errmsg(tr, bShowErrMsg, CER_INVALID_CONF_LEV, bOKEnable);
	return true;
	///end ADD_PERCENT_AS_PREFIX_FOR_LCL_UCL_LABEL_IN_PARAM_TABLE	
	///END MACRO_MOVED_TO_OERRMSG_DLL
	////End	ADD_MESSAGE_BOX
}

///Kevin 11/10/05 ADD_CONSTRUCT_ELlIPSE_GUI
bool mean_fit_conf_level_event(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
{
	TreeNode trMean = tr.Graph1.Ellipse.Mean;

	if( !trMean.confidence )
		return false;

	if(5 > trMean.confidence.dVal || 99.9 < trMean.confidence.dVal)
	{
		///Echo 10/27/07 MACRO_MOVED_TO_OERRMSG_DLL
		/*
		/// AW 10/25/07 WRONG_LOCALIZE_MACRO
		//MessageBox(NULL, _L(ELLIPSE_CON_LEV_VAL_ERROR_MSG), _L(ERROR_TITLE), MB_OK | MB_ICONSTOP);
		MessageBox(NULL, ELLIPSE_CON_LEV_VAL_ERROR_MSG, ERROR_TITLE, MB_OK | MB_ICONSTOP);
		/// END WRONG_LOCALIZE_MACRO
		*/
		string strErrMsg;
		ocu_load_err_msg_str(CER_ELLIPSE_CON_LEV, &strErrMsg);
		MessageBox(NULL, strErrMsg, ERROR_TITLE, MB_OK | MB_ICONSTOP);
		///end MACRO_MOVED_TO_OERRMSG_DLL
		
		///Kevin 12/01/05 QA70-3300 P3 GET_BACK_VALUE_WHEN_CONFIDEN_LEVEL_EXCEED		
		trMean.confidence.dVal = 95;
		///End GET_BACK_VALUE_WHEN_CONFIDEN_LEVEL_EXCEED
	}

	return true;

}

bool predi_fit_conf_level_event(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
{
	TreeNode trPredi = tr.Graph1.Ellipse.Predi;

	if( !trPredi.confidence )
		return false;

	if(5 > trPredi.confidence.dVal || 99.9 < trPredi.confidence.dVal)
	{
		//Echo 10/27/07 MACRO_MOVED_TO_OERRMSG_DLL
		//MessageBox(NULL, ELLIPSE_CON_LEV_VAL_ERROR_MSG, ERROR_TITLE, MB_OK | MB_ICONSTOP);
		string strErrMsg;
		ocu_load_err_msg_str(CER_INVALID_CONF_LEV, &strErrMsg);
		MessageBox(NULL, strErrMsg, ERROR_TITLE, MB_OK | MB_ICONSTOP);
		///end MACRO_MOVED_TO_OERRMSG_DLL
	}


	return true;

}

void ConstructAddEllipseGUI(TreeNode& trGUI)
{
	/// Iris 10/29/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
	//TreeNode trGraph = trGUI.Graph1;
	TreeNode trGraph = OP_GUI_FITCURVE_PLOT_SETTINGS(trGUI);
	///end OP_DLG_NEW_STRUCTURE
	
	GETN_USE(trGraph)

	GETN_BEGIN_BRANCH(Ellipse, _L("Ellipse"))	GETN_CHECKBOX_BRANCH(0)				GETN_ID_BRANCH(IDE_FIT_ELLIPSE)	

		GETN_STR(DataPoints, _L("Data Points"), "50")								GETN_ID(IDE_FIT_DATAPOINT)

		GETN_BEGIN_BRANCH(Mean, _L("Mean"))		GETN_CHECKBOX_BRANCH(1)				GETN_ID_BRANCH(IDE_FIT_MEAN)
			GETN_STR(confidence, _L("Confidence Level (%)"), "95")			GETN_ID(IDE_FIT_ELLIPSE_CONFIDENCE_MEAN)		GETN_OPTION_EVENT(mean_fit_conf_level_event)
		GETN_END_BRANCH(Mean)

		GETN_BEGIN_BRANCH(Pred, _L("Prediction"))	GETN_CHECKBOX_BRANCH(1)		GETN_ID_BRANCH(IDE_FIT_PREDICTION)
			GETN_STR(confidence, _L("Confidence Level (%)"), "95")			GETN_ID(IDE_FIT_ELLIPSE_CONFIDENCE_PREDI)		GETN_OPTION_EVENT(predi_fit_conf_level_event)
		GETN_END_BRANCH(Pred)

	GETN_END_BRANCH(Ellipse)
}
///End ADD_CONSTRUCT_ELlIPSE_GUI



void ConstructAddFitLROptions(TreeNode& trGUI)
{
	GETN_USE(trGUI)
	///Cheney 2007-11-16 OUTPUT_POLYNOMIAL_ORDER_FOR_FIT_PLOYNOMIAL
	//GETN_COMBO(Order, _L("Polynomial Order"), 2, "1|2|3|4|5|6|7|8|9") GETN_ID(IDE_POLY_ORDER)
	GETN_COMBO(Order, STR_POLYNOMIAL_ORDER, 2, "1|2|3|4|5|6|7|8|9") GETN_ID(IDE_POLY_ORDER)
	///end OUTPUT_POLYNOMIAL_ORDER_FOR_FIT_PLOYNOMIAL
	//GETN_BEGIN_BRANCH(Fit, "Fit Options") GETN_ID_BRANCH(IDST_LR_OPTIONS) GETN_OPTION_BRANCH(GETNBRANCH_SAVE_SETTINGS)
	GETN_BEGIN_BRANCH(Fit, _L("Fit Options")) GETN_ID_BRANCH(IDST_LR_OPTIONS) GETN_OPTION_BRANCH(GETNBRANCH_SAVE_SETTINGS | GETNBRANCH_OPEN) ///Alex 06/14/06 SET_FIT_OPTIONS_TABLE_OPEN
		//GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
		//GETN_COMBO(Order, "Polynomial Order", 2, "1|2|3|4|5|6|7|8|9")   ///Iris 01/05/2005
		//GETN_CHECK(ThroughZero, "Through Zero", 0) GETN_ID(IDE_LR_THROUGH_ZERO)
		///Iris 5/24/05 XY_WEIGHTING
		/// Iris 05/14/2007 v8.0617 CHANGE_ERR_AS_WEIGHT_FROM_CHECKBOX_TO_COMBO
		//GETN_CHECK(ErrBarWeight, "Errors as Weight",0) GETN_ID(IDE_FIT_ERROR_BARS) GETN_OPTION_EVENT(fit_err_as_weight_event)
		///Arvin 08/10/07 QA70-10197 ADD_NONE_OPTION_FOR_ERROR_AS_WEIGHT_IN_LR_PR_AND_MR
		//GETN_LIST(ErrBarWeight, "Errors as Weight", 1, "Direct Weighting|Instrumental") GETN_ID(IDE_FIT_ERROR_BARS) GETN_OPTION_EVENT(fit_err_as_weight_event)
		GETN_LIST(ErrBarWeight, _L("Errors as Weight"), 2, _L("No Weighting|Direct Weighting|Instrumental")) GETN_ID(IDE_FIT_ERROR_BARS) GETN_OPTION_EVENT(fit_err_as_weight_event)
		///END ADD_NONE_OPTION_FOR_ERROR_AS_WEIGHT_IN_LR_PR_AND_MR
		///end CHANGE_ERR_AS_WEIGHT_FROM_CHECKBOX_TO_COMBO
		GETN_LIST(YWeight, _L("Y Weighting Method"), 0, _L("No Weighting|Instrumental|Statistical|Arbitrary Dataset|Direct Weighting"))  GETN_ID(IDE_FIT_X_WEIGHTING_METHOD)
		GETN_LIST(XWeight, _L("X Weighting Method"), 0, _L("York|Ripley|FV")) GETN_ID(IDE_FIT_Y_WEIGHTING_METHOD)		
		///end XY_WEIGHTING
		GETN_CHECK(FixIntercept, _L("Fix Intercept"), 0) GETN_ID(IDE_LR_FIX_INTCPT) GETN_OPTION_EVENT(fit_lr_fix_intecept_event)
		GETN_NUM(FixInterceptAt, _L("Fix Intercept at"), 0) GETN_ID(IDE_LR_FIX_INTCPT_AT)
		GETN_CHECK(FixSlope, _L("Fix Slope"), 0) GETN_ID(IDE_LR_FIX_SLOPE) GETN_OPTION_EVENT(fit_lr_fix_slope_event)
		GETN_NUM(FixSlopeAt, _L("Fix Slope at"), 1) GETN_ID(IDE_LR_FIX_SLOPE_AT)
		///Cheney 2007-5-14 RENAME_FIT_TOOL_CHECK_BOX_NAME
		//GETN_CHECK(UseReducedChiSq, "Use Reduced Chi-Sqr",0) GETN_ID(IDE_FIT_REDUCED_CHISQR)
		/// Hong 13/05/08 QA80-11541 DISABLEAND_DEFAULT_CHECK_USE_REDUCED_CHISQR_IF_NO_WEIGHT
		//GETN_CHECK(UseReducedChiSq, STR_FITTING_CHECKBOX_USE_RED_CHI_SQR,0) GETN_ID(IDE_FIT_REDUCED_CHISQR)
		GETN_CHECK(UseReducedChiSq, STR_FITTING_CHECKBOX_USE_RED_CHI_SQR, 1) GETN_ID(IDE_FIT_REDUCED_CHISQR)
		/// end DISABLEAND_DEFAULT_CHECK_USE_REDUCED_CHISQR_IF_NO_WEIGHT
		///end RENAME_FIT_TOOL_CHECK_BOX_NAME
		///// Iris 9/02/05 UPDATE_FITTING_OPTIONS_NAME
		////GETN_NUM(Confidence, _L("Confidence Level in %"), 95) 		GETN_ID(IDE_FIT_CONF_PERCENT)  GETN_OPTION_EVENT(fit_conf_level_event)
		//GETN_NUM(Confidence, _L("Confidence Level for Parameters(%)"), 95) 		GETN_ID(IDE_FIT_CONF_PERCENT)  GETN_OPTION_EVENT_EX(fit_conf_level_event)
		/////End UPDATE_FITTING_OPTIONS_NAME
		///Arvin 06/22/07 v8.0646 APPARENT_CAN_NOT_DO_RESIDUAL_ANALYSIS
		//GETN_CHECK(ApparentFit, "Apparent Fit", 0) GETN_ID(IDE_FIT_APPARENT_SCALE)
		/// Iris 12/29/2009 QA81-14853 APPARENT_FIT_DEFAULT_SHOULD_BE_TURN_ON
		//GETN_CHECK(ApparentFit, _L("Apparent Fit"), 0) GETN_ID(IDE_FIT_APPARENT_SCALE) GETN_OPTION_EVENT(fit_lr_apparent_fit_event)
		GETN_CHECK(ApparentFit, _L("Apparent Fit"), 1) GETN_ID(IDE_FIT_APPARENT_SCALE) GETN_OPTION_EVENT(fit_lr_apparent_fit_event)
		///End APPARENT_FIT_DEFAULT_SHOULD_BE_TURN_ON
		///END APPARENT_CAN_NOT_DO_RESIDUAL_ANALYSIS
	GETN_END_BRANCH(Fit)
}

void ConstructAddFitQuantitiesToCompute(TreeNode& trGUI)
{
	GETN_USE(trGUI);
	GETN_BEGIN_BRANCH(Quantities, STR_CALC_OPTIONS) GETN_ID_BRANCH(IDST_FIT_QUANTITIES_OPTIONS) GETN_OPTION_BRANCH(GETNBRANCH_SAVE_SETTINGS)
#ifdef OP_DLG_TOTALLY_NEW_STRUCTURE	
		DWORD dwOptions = REPORT_NOTES | REPORT_INPUT | REPORT_MASKED_DATA | REPORT_MISSING_DATA;
		tree_construct_add_common_report_table_options(_tmpSubNode, dwOptions);
#endif
		
		GETN_BEGIN_BRANCH(Parameters, _L("Fit Parameters")) GETN_ID_BRANCH(IDST_FIT_PARAMS_OPTIONS) GETN_OPTION_BRANCH(GETNBRANCH_SAVE_SETTINGS)
			///Kyle 09/03/2009 QA80-14077-P1 Unit_IS_ONLY_NEEDED_FOR_NLSF
			//GETN_CHECK_L(Unit, "Unit", false) 		GETN_ID(IDE_PARAM_UNIT)			///Kyle 08/06/2009 QA80-14077 ADD_UNIT_FOR_PARAMETER_SETTINGS
			/////------ Folger 08/07/09 UNIT_IN_PA_FITTING_PARAMETER_MAKE_OLD_THEME_FAIL_TO_APPLY_IN_81
			//GETN_CURRENT_SUBNODE.SetAttribute(STR_DELAY_DATAID_ASSIGN_ATTRIB, PA_DELAY_DATAID_ASSIGN_VER4);
			/////------ End UNIT_IN_PA_FITTING_PARAMETER_MAKE_OLD_THEME_FAIL_TO_APPLY_IN_81
			///End Unit_IS_ONLY_NEEDED_FOR_NLSF
			GETN_CHECK_L(Value, ("Value"), true) 		GETN_ID(IDE_PARAM_VALUE)
			GETN_CHECK_L(Shared, ("Shared"), false) 	GETN_ID(IDE_PARAM_SHARED) ///Jasmine 11/08/07 ADD_SHARED_TO_PARAMETER_REPORT_TABLE
			/// NLF_81 Iris refer to Cheney 2007-5-11 RESET_FIXED_LABEL_AS_MAX_SUGGEST
			//GETN_CHECK_L(Fix, ("Fixed or Vary"), false) GETN_ID(IDE_PARAM_FIX)  
			GETN_CHECK_L(Fix, ("Fixed"), false) GETN_ID(IDE_PARAM_FIX)
			///end NLF_81
		///Kevin 09/01/05 CHANGE_STATISTICS_NAME	
			//GETN_CHECK(Error, _L("Error"), true) 		GETN_ID(IDE_PARAM_ERROR)
			//GETN_CHECK(LCI, _L("LCI (Lower Confidence Interval)"), true) 		GETN_ID(IDE_PARAM_LCI)  GETN_OPTION_EVENT(fit_conf_level_event)
			//GETN_CHECK(UCI, _L("UCI (Upper confidence Interval)"), true) 		GETN_ID(IDE_PARAM_UCI)  GETN_OPTION_EVENT(fit_conf_level_event)
			GETN_CHECK_L(Error, ("Standard Error"), true) 		GETN_ID(IDE_PARAM_ERROR)
			/// TD 5-12-06 CL_TITLE_DIFFERENT_FORM_HARDCODED_ONE_AFTER_UPDATE
			//GETN_CHECK(LCL, _L("LCL for Parameters"), true) 		GETN_ID(IDE_PARAM_LCL)  GETN_OPTION_EVENT(fit_conf_level_event)
			//GETN_CHECK(UCL, _L("UCL for Parameters"), true) 		GETN_ID(IDE_PARAM_UCL)  GETN_OPTION_EVENT(fit_conf_level_event)
			/// Iris 12/20/2006 v8.0529 CORRECT_THE_METHOD_OF_COMPUTION_PARAM_CONF_LIMIT
			//not computer Parameter CL to improve speed
			//GETN_CHECK(LCL, _L("LCL"), true) 		GETN_ID(IDE_PARAM_LCL)  GETN_OPTION_EVENT_EX(fit_conf_level_event)
			//GETN_CHECK(UCL, _L("UCL"), true) 		GETN_ID(IDE_PARAM_UCL)  GETN_OPTION_EVENT_EX(fit_conf_level_event)
			GETN_CHECK_L(LCL, ("LCL"), false) 		GETN_ID(IDE_PARAM_LCL)  GETN_OPTION_EVENT_EX(fit_conf_level_event)
			GETN_CHECK_L(UCL, ("UCL"), false) 		GETN_ID(IDE_PARAM_UCL)  GETN_OPTION_EVENT_EX(fit_conf_level_event)
			///end CORRECT_THE_METHOD_OF_COMPUTION_PARAM_CONF_LIMIT
			/// Nicole 07/05/2007 v8.0655 REMOVE_SPACE_FOR_LOCATION_STRING
			//GETN_NUM(Confidence, _L("  Confidence Level for Parameters(%)"), 95) 		GETN_ID(IDE_FIT_CONF_PERCENT)  GETN_OPTION_EVENT_EX(fit_conf_level_event)
			GETN_NUM(Confidence, _L("Confidence Level for Parameters(%)"), 95) 		GETN_ID(IDE_FIT_CONF_PERCENT)  GETN_OPTION_EVENT_EX(fit_conf_level_event)
			/// END REMOVE_SPACE_FOR_LOCATION_STRING
			/// end CL_TITLE_DIFFERENT_FORM_HARDCODED_ONE_AFTER_UPDATE
		///End CHANGE_STATISTICS_NAME
			GETN_CHECK_L(tValue, ("t-Value"), false) 	GETN_ID(IDE_PARAM_TVALUE)
		///Kevin 11/08/05	MODIFY_PARAMETER_NAME	
			//GETN_CHECK(Prob, _L("Probability"), false) 					GETN_ID(IDE_PARAM_PROB)
			GETN_CHECK_L(Prob, ("Prob>|t|"), false) 					GETN_ID(IDE_PARAM_PROB)
		///End MODIFY_PARAMETER_NAME
			GETN_CHECK_L(Dependency, ("Dependency"), false) 			GETN_ID(IDE_PARAM_DEPENDENCY)
			///Iris 01/31/2007 SHOW_DEPENDENCY_IN_PARAMS_TABLE
			//trGUI.Quantities.Parameters.Dependency.Show = 0;	///Iris 11/25/04 QA70-6365 REMOVE_NOT_NEEDED_CHECK_BOX
			///end SHOW_DEPENDENCY_IN_PARAMS_TABLE
		///Kevin 09/01/05 CHANGE_STATISTICS_NAME			
			//GETN_CHECK(ConfInterval, _L("Confidence Interval"), false) 	GETN_ID(IDE_PARAM_CONF_INT)
		///Kevin 11/08/05	MODIFY_PARAMETER_NAME	
			//GETN_CHECK(ConfInterval, _L("Confidence Interval Half-Width"), false) 	GETN_ID(IDE_PARAM_CONF_INT)
			GETN_CHECK_L(ConfInterval, ("CI Half-Width"), false) 	GETN_ID(IDE_PARAM_CONF_INT)
		///End MODIFY_PARAMETER_NAME
		///Cheney 2007-4-11 ONLY_FIT_NL_NEED_LB_UB	
		///Cheney 2007-4-4 SHOW_LB_UB_IN_REPORT_SHEET
			//GETN_CHECK(LowerBound, _L("Lower Bound"), false) 	GETN_ID(IDE_PARAM_LOWER_BOUND)
			//GETN_CHECK(UpperBound, _L("Upper Bound"), false) 	GETN_ID(IDE_PARAM_UPPER_BOUND)
		///end ONLY_FIT_NL_NEED_LB_UB
		///end SHOW_LB_UB_IN_REPORT_SHEET
		///End CHANGE_STATISTICS_NAME
		GETN_END_BRANCH(Parameters)
		
		GETN_BEGIN_BRANCH(Statistics, _L("Fit Statistics")) GETN_ID_BRANCH(IDST_FIT_STATS_OPTIONS) GETN_OPTION_BRANCH(GETNBRANCH_SAVE_SETTINGS)
			GETN_CHECK_L(N, ("Number of Points"), true) GETN_ID(IDE_FIT_NUM_POINTS)
			/// Iris 11/08/05 CHANGE_LABEL_ACORDING_TO_MAX_SUGGESTION
			//GETN_CHECK(DOF, _L("Degrees of Freedom"), true) GETN_ID(IDE_FIT_DOF)
			///Jim 3/22/06 v8.0377 CORRECT_THE_WORD_OF_GUI
			//GETN_CHECK(DOF, _L("Degree of Freedom"), true) GETN_ID(IDE_FIT_DOF) 
			GETN_CHECK_L(DOF, ("Degrees of Freedom"), true) GETN_ID(IDE_FIT_DOF)
			///END CORRECT_THE_WORD_OF_GUI
			///End CHANGE_LABEL_ACORDING_TO_MAX_SUGGESTION
			GETN_CHECK_L(ReducedChiSq, ("Reduced Chi-Sqr"), true) GETN_ID(IDE_FIT_REDUCED_CHI_SQUARE)
			//----- Iris 10/16/06 REPORT_R_SQUARE_AS_DEFAULT
			//GETN_CHECK(Rvalue, _L("R Value"), true) GETN_ID(IDE_FIT_RVALUE)
			GETN_CHECK_L(Rvalue, ("R Value"), false) GETN_ID(IDE_FIT_RVALUE)
			//----- 
			//----- Echo 1/17/07 REPORT_SSR_AS_DEFAULT
			//GETN_CHECK(SSR, _L("Residual Sum of Squares"), false) GETN_ID(IDE_FIT_SSR)
			GETN_CHECK_L(SSR, ("Residual Sum of Squares"), true) GETN_ID(IDE_FIT_SSR)
			//----- 
			///Arvin 01/31/08 QA70-10948 SHOW_CORRELATION_COEFICIENT_IN_LR
			//GETN_CHECK(Correlation, _L("Correlation"), false) GETN_ID(IDE_FIT_CORRELATION)
			/// Iris 2/10/2010 QA81-10948 SHOW_PEARSONS_R_IN_REPORT_BY_DEFAULT
			//GETN_CHECK_L(Correlation, ("Pearson's r"), false) GETN_ID(IDE_FIT_CORRELATION) 
			GETN_CHECK_L(Correlation, ("Pearson's r"), true) GETN_ID(IDE_FIT_CORRELATION) 
			///End SHOW_PEARSONS_R_IN_REPORT_BY_DEFAULT
			///END SHOW_CORRELATION_COEFICIENT_IN_LR
			
			/// Iris 11/08/05 CHANGE_LABEL_ACORDING_TO_MAX_SUGGESTION
			//GETN_CHECK(RSqCOD, _L("COD(R^2)"), false) GETN_ID(IDE_FIT_RSQUARE_COD) //CPY 5/11/05, Coefficient of Determination too long, use COD for now
			GETN_CHECK_L(RSqCOD, ("R-Square(COD)"), false) GETN_ID(IDE_FIT_RSQUARE_COD)
			///End CHANGE_LABEL_ACORDING_TO_MAX_SUGGESTION			
			
			//----- Iris 10/16/06 REPORT_R_SQUARE_AS_DEFAULT
			/*
			///Echo 10/12/05 FIT_ERROR_NAMED
			//GETN_CHECK(AdjRSq, _L("Adjusted Residual Sum of Squares"), false) GETN_ID(IDE_FIT_ADJ_RSQUARE)
			/// Iris 11/08/05 CHANGE_LABEL_ACORDING_TO_MAX_SUGGESTION
			//GETN_CHECK(AdjRSq, _L("Adjusted COD"), false) GETN_ID(IDE_FIT_ADJ_RSQUARE)
			GETN_CHECK(AdjRSq, _L("Adj. R-Square"), false) GETN_ID(IDE_FIT_ADJ_RSQUARE)
			///End CHANGE_LABEL_ACORDING_TO_MAX_SUGGESTION
			//END FIT_ERROR_NAMED
			*/
			GETN_CHECK_L(AdjRSq, ("Adj. R-Square"), true) GETN_ID(IDE_FIT_ADJ_RSQUARE)
			//-----
			
			GETN_CHECK_L(RMSESD, ("Root-MSE (SD)"), false) GETN_ID(IDE_FIT_ROOT_MSE)
			GETN_CHECK_L(NormResiduals, ("Norm of Residuals"), false) GETN_ID(IDE_FIT_NORM_REDIDUALS)
			///Cheney 2007-4-3 SET_CHECK_BOX_OF_NUMITER_DEFAULT_UNCHECK_BY_LARRY_SUGGEST
			//GETN_CHECK(NumIter, _L("Number of Iterations"), true) 	GETN_ID(IDE_FIT_NUMBER_ITER)
			GETN_CHECK_L(NumIter, ("Number of Iterations"), false) 	GETN_ID(IDE_FIT_NUMBER_ITER)
			///end SET_CHECK_BOX_OF_NUMITER_DEFAULT_UNCHECK_BY_LARRY_SUGGEST
			GETN_CHECK_L(FitStatus, ("Fit Status"), true) 			GETN_ID(IDE_FIT_STATUS)
			///Cheney 2007-11-2 QA70-10626 ADD_REPLICA_INFO_IN_REPORT_TABLE
			GETN_CHECK_L(ReplicaNum, STR_NUMBER_OF_REPLICA_E, false) 			GETN_ID(IDE_REPLICA_NUM)
			GETN_CHECK_L(ParamsFromNum, STR_REPLICATE_FROM_NTH_PARAMS_E, false) 			GETN_ID(IDE_REPLICA_FROM_NTH_PARAM)
			GETN_CHECK_L(ParamsUsed, STR_NUM_OF_PARAMS_USED_IN_REPLICA_E, false) 			GETN_ID(IDE_NUM_OF_PARAMS_IN_REPLICA)
			///end ADD_REPLICA_INFO_IN_REPORT_TABLE
			
		GETN_END_BRANCH(Statistics)
		
		/// Iris 02/28/2007 v8.0572 ADD_OPTIONS_TO_CONTRL_CONTENTS_IN_SUMMARY_TABLE
		/*
		/// Iris 01/09/2007 v8.0539 ADD_PARAMTERS_SUMMARY_TABLE
		GETN_CHECK(SummaryTable, _L("Parameters Summary Table"), false)  GETN_ID(IDE_PARAMS_SUMMARY)
		///end ADD_PARAMTERS_SUMMARY_TABLE
		*/
		//----Iris 08/10/2007 v8.0680 always out Summary Table, design changed on Max's mail
		//GETN_BEGIN_BRANCH(SummaryTable, _L("Fit Summary")) GETN_ID_BRANCH(IDE_PARAMS_SUMMARY) GETN_CHECKBOX_BRANCH(0)
		GETN_BEGIN_BRANCH(SummaryTable, _L("Fit Summary")) GETN_ID_BRANCH(IDE_PARAMS_SUMMARY) GETN_CHECKBOX_BRANCH(1)
		//----
			GETN_CHECK_L(Value, ("Value"), true) 				GETN_ID(IDE_SUMMARY_PARAM_VALUE)
			GETN_CHECK_L(Error, ("Standard Error"), true) 		GETN_ID(IDE_SUMMARY_PARAM_ERROR)
			GETN_CHECK_L(LCL, ("LCL"), false) 					GETN_ID(IDE_SUMMARY_PARAM_LCL) 
			GETN_CHECK_L(UCL, ("UCL"), false) 					GETN_ID(IDE_SUMMARY_PARAM_UCL)
			GETN_CHECK_L(AdjRSq, ("Adj. R-Square"), true) 		GETN_ID(IDE_SUMMARY_STATS_ADJ_RS)
			GETN_CHECK_L(RSqCOD, ("R-Square(COD)"), false) 		GETN_ID(IDE_SUMMARY_STATS_RS)
			GETN_CHECK_L(ReducedChiSq, ("Reduced Chi-Sqr"), true) GETN_ID(IDE_SUMMARY_STATS_CHISQ)		
		GETN_END_BRANCH(SummaryTable)
		///end ADD_OPTIONS_TO_CONTRL_CONTENTS_IN_SUMMARY_TABLE
		
		/// Thomas 06/08/06 MOVE_ANOVA_CHECK_BOX_TO_QUANTITIES_BRANCH
		//GETN_CHECK(ANOVAtable, _L(STR_ANOVA_TABLE), true) GETN_ID(IDE_ANOVA_TABLE)
		GETN_CHECK_L(ANOVAtable, STR_ANOVA_TABLE_E, true) GETN_ID(IDE_ANOVA_TABLE) /// Hong 11/07/07 v.8.0742 FIX_ERROR_LOCALIZED
		/// End MOVE_ANOVA_CHECK_BOX_TO_QUANTITIES_BRANCH
		///Alex 06/14/06 ADD_MCOR_AND_MCOV_CHECK_BOX_TO_QUANTITIES_BRANCH
		/// Nicole 07/05/2007 v8.0655 REMOVE_SPACE_FOR_LOCATION_STRING
		//GETN_CHECK(mCov,_L("Covariance matrix "),false) GETN_ID(IDE_COR_MATIRX)
		GETN_CHECK_L(mCov,("Covariance matrix"),false) GETN_ID(IDE_COR_MATIRX)
		/// END REMOVE_SPACE_FOR_LOCATION_STRING
		GETN_CHECK_L(mCor,("Correlation matrix"),false) GETN_ID(IDE_CORR_MATRIX)
		///End ADD_MCOR_AND_MCOV_CHECK_BOX_TO_QUANTITIES_BRANCH
		
	GETN_END_BRANCH(Quantities)
	///Arvin 01/07/08 QA70-10903 ADD_CHECK_ALL_BOX_FOR_BRANCH
	TreeNode trParams = trGUI.Quantities.Parameters;
	if(trParams)
		/// Hong 10/30/08 v8.0963b FIX_CHECK_UNCHECK_ALL_FAIL_FIRE_ALL_SUBNODE_EVENT
		//tree_set_branch_attribute_for_branch(trParams);
		tree_set_branch_attribute_for_branch(trParams, GETNBRANCH_CHECK_CONTROL);
		/// end FIX_CHECK_UNCHECK_ALL_FAIL_FIRE_ALL_SUBNODE_EVENT
	TreeNode trStatistics = trGUI.Quantities.Statistics;
	if(trStatistics)
		tree_set_branch_attribute_for_branch(trStatistics);
	///end ADD_CHECK_ALL_BOX_FOR_BRANCH
}

///Arvin 12/08/06 ADD_RESIDUAL_ANALYSIS_FOR_FITTING
void ConstructAddResidualAnalysisGUI(TreeNode& trGUI)
{
	GETN_USE(trGUI)
	/// Max 6/4/08 v8.0877 THIS_BRANCH_SHOULD_CLOSE_BY_DEFAULT
	/////Arvin 01/03/08 SHOULD_NOT_PLOT_ANY_RESIDUAL_GRAPH_WHEN_USER_HAVE_NOT_SELECT_ANY_TYPE_RESIDUAL
	////GETN_BEGIN_BRANCH(ResAnalysis, _L("Residual Analysis")) GETN_ID_BRANCH(IDST_RESIDUAL_TYPE_OPTIONS) GETN_OPTION_BRANCH(GETNBRANCH_SAVE_SETTINGS | GETNBRANCH_OPEN) 
	//GETN_BEGIN_BRANCH(ResAnalysis, _L("Residual Analysis")) GETN_ID_BRANCH(IDST_RESIDUAL_TYPE_OPTIONS) GETN_OPTION_BRANCH(GETNBRANCH_SAVE_SETTINGS | GETNBRANCH_OPEN) //GETN_OPTION_EVENT(residual_plot_event)
	GETN_BEGIN_BRANCH(ResAnalysis, _L("Residual Analysis")) GETN_ID_BRANCH(IDST_RESIDUAL_TYPE_OPTIONS) GETN_OPTION_BRANCH(GETNBRANCH_SAVE_SETTINGS) 
	/////end 	SHOULD_NOT_PLOT_ANY_RESIDUAL_GRAPH_WHEN_USER_HAVE_NOT_SELECT_ANY_TYPE_RESIDUAL	
	/// END THIS_BRANCH_SHOULD_CLOSE_BY_DEFAULT
		/// Nicole 07/05/2007 v8.0655 REMOVE_SPACE_FOR_LOCATION_STRING
		/*
		GETN_CHECK(Regular,_L("Regular "), true) GETN_ID(IDE_RESIDUAL_REGULAR)
		GETN_CHECK(Stad,_L("Standardized "), false) GETN_ID(IDE_RESIDUAL_STANDARDIZED)
		GETN_CHECK(Stud,_L("Studentized "), false) GETN_ID(IDE_RESIDUAL_STUDENTIZED)
		GETN_CHECK(StudDel,_L("Studentized Deleted "), false) GETN_ID(IDE_RESIDUAL_STUDENTIZED_DELETED)
		*/
		//------ Folger 11/08/07 CATEGORY_NEEDED_WHEN_LOCALIZE
		//GETN_CHECK(Regular,_L("Regular"), true) GETN_ID(IDE_RESIDUAL_REGULAR)
		GETN_CHECK(Regular,_LC("Regular", STR_CAT_STATS), true) GETN_ID(IDE_RESIDUAL_REGULAR)
		//------ End CATEGORY_NEEDED_WHEN_LOCALIZE
		GETN_CHECK(Stad,_L("Standardized"), false) GETN_ID(IDE_RESIDUAL_STANDARDIZED)
		GETN_CHECK(Stud,_L("Studentized"), false) GETN_ID(IDE_RESIDUAL_STUDENTIZED)
		GETN_CHECK(StudDel,_L("Studentized Deleted"), false) GETN_ID(IDE_RESIDUAL_STUDENTIZED_DELETED)
		/// END REMOVE_SPACE_FOR_LOCATION_STRING
		
	GETN_END_BRANCH(ResAnalysis)
	
	///Arvin 01/07/08 QA70-10903 ADD_CHECK_ALL_BOX_FOR_BRANCH
	TreeNode trResAnalysis = trGUI.ResAnalysis;
	if(trResAnalysis)
		tree_set_branch_attribute_for_branch(trResAnalysis);
	///end ADD_CHECK_ALL_BOX_FOR_BRANCH
}

/// *** Event to treat the confidence value.
/// *** Confidence only active if Confidence Bands or Prediction Brands is checked. 
/// *** Bring up error message if error confidence value setting. 
/// Iris 06/27/06 NOT_SHOW_ERR_MESSAGE_DLG_FOR_INIT_TIME
//bool fit_curv_conf_event(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
bool fit_curv_conf_event(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg)
{
	///Iris 4/12/05 MOVE_CURVE_OPTION_TO_EACH_GRAPH
	//TreeNode trResCur = tr.Output.Data.ResultCurves;
	TreeNode trCurrentNode = tree_get_node(tr, nRow);
	if( !trCurrentNode )
		return false;
	TreeNode trResCur = trCurrentNode.Parent();
	if( !trResCur )
		return false;
	if( !trResCur.ConfBands || !trResCur.Confidence || !trResCur.PredBands)
		return false;
	///end MOVE_CURVE_OPTION_TO_EACH_GRAPH

	//Confidence only active if Confidence Bands or Prediction Brands is checked. 
	trResCur.Confidence.Enable = trResCur.ConfBands.nVal;
	if (trResCur.Confidence.Enable == false)
		trResCur.Confidence.Enable  = trResCur.PredBands.nVal;	
	
	///Joseph	12/07/06	ADD_MESSAGE_BOX
	bool	bShowErrMsg = false;
	bool	bOKEnable = true;
	///End	ADD_MESSAGE_BOX
	//Bring up error message if error confidence value setting. 
	if (trResCur.Confidence.Enable)
	{
		double dConfVal = trResCur.Confidence.dVal;
		if( !(dwCntrl & GETNEVENT_ON_INIT) && (dConfVal < 0 || dConfVal >= 100))
		{
			///Joseph	12/07/06	ADD_MESSAGE_BOX
			///// Iris 06/27/06 NOT_SHOW_ERR_MESSAGE_DLG_FOR_INIT_TIME
			////MessageBox(NULL, _L(CON_LEV_VAL_ERROR_MSG), _L(ERROR_TITLE), MB_OK | MB_ICONSTOP);		
			////return false;
			////return error_msg_box(_L(CON_LEV_VAL_ERROR_MSG));
			bShowErrMsg = true;
			bOKEnable = false;
			/////End NOT_SHOW_ERR_MESSAGE_DLG_FOR_INIT_TIME
			///End	ADD_MESSAGE_BOX
		}
	}//if confidence is enabled
	//Echo 10/27/07 MACRO_MOVED_TO_OERRMSG_DLL
	/*
	///Joseph	12/07/06	ADD_MESSAGE_BOX
	//return true;	
	return handle_dialog_errmsg(tr, bShowErrMsg, CON_LEV_VAL_ERROR_MSG, bOKEnable);
	///End ADD_MESSAGE_BOX
	*/
	return handle_dialog_errmsg(tr, bShowErrMsg, CER_INVALID_CONF_LEV, bOKEnable);
	///end MACRO_MOVED_TO_OERRMSG_DLL
}

///Iris 7/29/05 UPDATE_FITTED_CURVE_OPTIONS
bool fit_curv_range_update(TreeNode& trDataType)
{
	TreeNode trRange = trDataType.Range;
	if(!trRange)
		return false;
	
	int nDataType = trRange.nVal;
	
	bool bMinMax = (2 == nDataType)? 1: 0;	
	trDataType.Min.Show = bMinMax;
	trDataType.Max.Show = bMinMax;
	
	bool bMargin = (0 == nDataType)? 1: 0;
	trDataType.RangeMargin.Show = bMargin;
	return true;
	
}

bool fit_curv_range_even(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
{	
	TreeNode trRange = tree_get_node(tr, nRow);	
	TreeNode trDataType = trRange.Parent();
	if(!trRange || !trDataType)
		return false;
	
	return fit_curv_range_update(trDataType);	
}

///Jasmine 06/08/10 SRVC-12-P2 FORCE_XY_DATA_TYPE_BOTH_BE_OR_NOT_BE_SAME_AS_INPUT_DATA
static bool _is_same_as_input_data(const TreeNode& trDataType)
{
	string 		strList;
	//trDataType.GetAttribute("BranchCombo", strList);
	trDataType.GetAttribute(STR_ATTRIB_BRANCH_COMBO, strList); /// Hong 10/23/07 v8.0731 IMPORVE_AND_CENTRALIZE_CODE
	
	///Cheney 2007-5-11 WHEN_SURFACE_FIT_DATA_TYPE_HAS_SOME_PROBLEM
	vector<string> 	vsList;
	strList.GetTokens(vsList, '|');
	
	int 	nSelection = trDataType.Use;
	if( nSelection < 0 || nSelection>= vsList.GetSize() )
		return false;
	
	string strSelction = vsList[nSelection];
	/// Iris 3/07/2012 ORG-5218-P1 NEW_GUI_OF_X_DATA_TYPE_FOR_IMPLICIT_FUNC
	/*
	if(-1 != strList.Find(STR_FITTED_CURVE_DATA_TYPE_SAME_INPUT) && 0 == strSelction.Compare(STR_FITTED_CURVE_DATA_TYPE_SAME_INPUT))
		return true;
	*/
	vector<string> vsSameAsInputLabels;
	vsSameAsInputLabels.Add(STR_FITTED_CURVE_DATA_TYPE_SAME_INPUT);
	vsSameAsInputLabels.Add(STR_FITTED_CURVE_DATA_TYPE_FITTED_POINT_FOR_INPUT);
	for(int ii = 0; ii < vsSameAsInputLabels.GetSize(); ++ii)
	{
		if(-1 != strList.Find(vsSameAsInputLabels[ii]) && 0 == strSelction.Compare(vsSameAsInputLabels[ii]))
			return true;
	}
	///End NEW_GUI_OF_X_DATA_TYPE_FOR_IMPLICIT_FUNC
	return false;
}

static void _select_data_type(TreeNode& trDataType, LPCSTR lpczType)
{
	string 			strList;
	vector<string> 	vsList;
	trDataType.GetAttribute(STR_ATTRIB_BRANCH_COMBO, strList);
	strList.GetTokens(vsList, '|');
	int nFind = vsList.Find(lpczType);
	if(nFind >= 0)
	{
		trDataType.Use = nFind;
		/// Iris 3/07/2012 ORG-5218-P1 NEW_GUI_OF_X_DATA_TYPE_FOR_IMPLICIT_FUNC
		//bool bEnable = (lstrcmp(lpczType, STR_FITTED_CURVE_DATA_TYPE_SAME_INPUT) != 0);  
		string strSameAsInputLabel = STR_FITTED_CURVE_DATA_TYPE_SAME_INPUT;
		if( strList.Find(STR_FITTED_CURVE_DATA_TYPE_SAME_INPUT) < 0 )
		{
			strSameAsInputLabel = STR_FITTED_CURVE_DATA_TYPE_FITTED_POINT_FOR_INPUT;
		}
		bool bEnable = (lstrcmp(lpczType, strSameAsInputLabel) != 0);  
		///End NEW_GUI_OF_X_DATA_TYPE_FOR_IMPLICIT_FUNC
		
		foreach(TreeNode trN in trDataType.Children)
		{
			trN.Enable = bEnable;
		}	
	}
}
///End FORCE_XY_DATA_TYPE_BOTH_BE_OR_NOT_BE_SAME_AS_INPUT_DATA

bool fit_curv_data_type_even(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
{
	TreeNode trDataType = tree_get_node(tr, nRow);	
	if(!trDataType)
		return false;
	
	///Iris 8/18/05 ENABLE_DISABLE_SAME_AS_INPUT_DATA, if input data is random data, then remove "Same as Input Data" from list
	//bool bEnable = (0 == trDataType.Use)? 0 : 1;  //0: Same as Data
	bool 		bEnable = true; 
	if( _is_same_as_input_data(trDataType) )///Jasmine 06/08/10 SRVC-12-P2 FORCE_XY_DATA_TYPE_BOTH_BE_OR_NOT_BE_SAME_AS_INPUT_DATA
		bEnable = false;	
	//bool 		bEnable = true;
	//if(-1 != strList.Find(STR_FITTED_CURVE_DATA_TYPE_SAME_INPUT) && FIT_CURVE_SAME_AS_DATA == trDataType.Use)
	//	bEnable = false;
	///end WHEN_SURFACE_FIT_DATA_TYPE_HAS_SOME_PROBLEM
	///end ENABLE_DISABLE_SAME_AS_INPUT_DATA
	
	foreach(TreeNode trN in trDataType.Children)
	{
		trN.Enable = bEnable;
		///Cheney 2007-5-11 WHEN_SURFACE_FIT_DATA_TYPE_HAS_SOME_PROBLEM
		if(IDE_FIT_X_MIN == trN.DataID || IDE_FIT_X_MAX == trN.DataID
			|| IDE_FIT_Y_MIN == trN.DataID || IDE_FIT_Y_MAX == trN.DataID)
		///end WHEN_SURFACE_FIT_DATA_TYPE_HAS_SOME_PROBLEM
			fit_curv_range_update(trDataType);
	}	
	
	///Jasmine 06/08/10 SRVC-12-P2 FORCE_XY_DATA_TYPE_BOTH_BE_OR_NOT_BE_SAME_AS_INPUT_DATA	
	/// Iris 9/24/2012 ORG-6855-S1 BETTER_SUPPORT_FOR_MULTIPLE_FORMULAS_IMPLICIT_FUNC_MORE
	/*
	TreeNode trDataType2, trParent = trDataType.Parent();
	if(trParent)
	{
		if(trDataType.tagName.Compare("XDataType") == 0)
			trDataType2 = trParent.YDataType;
		else
			trDataType2 = trParent.XDataType;
	}
	if(trDataType2)
	{
		string strList, strList2;
		trDataType.GetAttribute(STR_ATTRIB_BRANCH_COMBO, strList); 
		trDataType2.GetAttribute(STR_ATTRIB_BRANCH_COMBO, strList2);
		if(strList.Compare(strList2) == 0)//must have the same dropdown list
		{
			if( _is_same_as_input_data(trDataType) && !_is_same_as_input_data(trDataType2) )
			{
				/// Iris 3/07/2012 ORG-5218-P1 NEW_GUI_OF_X_DATA_TYPE_FOR_IMPLICIT_FUNC
				//_select_data_type(trDataType2, STR_FITTED_CURVE_DATA_TYPE_SAME_INPUT);
				_select_data_type(trDataType2, strList.GetToken(trDataType.Use, '|'));
				///End NEW_GUI_OF_X_DATA_TYPE_FOR_IMPLICIT_FUNC
			}
			else if( !_is_same_as_input_data(trDataType) && _is_same_as_input_data(trDataType2) )
			{
				_select_data_type(trDataType2, STR_FITTED_CURVE_DATA_TYPE_UNIFORM_LINEAR);
			}
		}
	}
	*/
	TreeNode trParent = trDataType.Parent();
	if( trParent )
	{
		foreach(TreeNode trN in trParent.Children)
		{
			if( trN.tagName.Find("DataType") >= 0 && trN.tagName != trDataType.tagName ) // if the tagName contains "DataType" 
			{
				TreeNode trDataType2 = trN;
				
				string strList, strList2;
				trDataType.GetAttribute(STR_ATTRIB_BRANCH_COMBO, strList); 
				trDataType2.GetAttribute(STR_ATTRIB_BRANCH_COMBO, strList2);
				if(strList.Compare(strList2) == 0)//must have the same dropdown list
				{
					if( _is_same_as_input_data(trDataType) && !_is_same_as_input_data(trDataType2) )
					{						
						_select_data_type(trDataType2, strList.GetToken(trDataType.Use, '|'));						
					}
					else if( !_is_same_as_input_data(trDataType) && _is_same_as_input_data(trDataType2) )
					{
						_select_data_type(trDataType2, STR_FITTED_CURVE_DATA_TYPE_UNIFORM_LINEAR);
					}
				}
			}
		}
	}
	///End BETTER_SUPPORT_FOR_MULTIPLE_FORMULAS_IMPLICIT_FUNC_MORE
	///End FORCE_XY_DATA_TYPE_BOTH_BE_OR_NOT_BE_SAME_AS_INPUT_DATA
	
	return true;
}
///END UPDATE_FITTED_CURVE_OPTIONS

/// Iris 3/01/2011 ORG-402-S4 NO_FITCURVE_PLOT_SHOULD_DISABLE_SURFACE_PLOT_TYPE_NODE
static bool	_set_surface_plot_type_enable(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
{
	TreeNode trN = tree_get_node(tr, nRow);	
	TreeNode trFitCurve = trN.Parent();
	ASSERT(trFitCurve);
	if( !trFitCurve )
		return false;
	
	TreeNode trReportPlot = trFitCurve.DoPlot;
	TreeNode trPlotOnSource = trFitCurve.PlotFit;
	TreeNode trSurfacePlotType = trFitCurve.SurfacePlotType;
	if( trSurfacePlotType && trSurfacePlotType.Show )
	{		
		if( trPlotOnSource && trPlotOnSource.Show )
		{
			trSurfacePlotType.Enable = (1 == trReportPlot.nVal || trPlotOnSource.Enable && 0 != trPlotOnSource.nVal);
		}
		else
		{
			trSurfacePlotType.Enable = trReportPlot.nVal;
		}
		return true;
	}
	return false;
}
///End NO_FITCURVE_PLOT_SHOULD_DISABLE_SURFACE_PLOT_TYPE_NODE

bool fit_curv_plot_type(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
{
	TreeNode 	trPlotType = tree_get_node(tr, nRow);	
	if( !trPlotType )
		return false;
	
	string	str;
	if(!trPlotType.GetAttribute(STR_COMBO_ATTRIB, str))
		return false;
	
	char chSep = '|';
	str = str.GetToken(trPlotType.nVal, chSep);
	
	TreeNode 	trFitCurve = trPlotType.Parent();
	TreeNode	trPlotFit = trFitCurve.PlotFit;
	if( !trPlotFit )
		return false;
	
	string		strPlotList;
	if(!trPlotFit.GetAttribute(STR_COMBO_ATTRIB, strPlotList))
		return false;
	
	vector<string> 	vsPlotList;
	strPlotList.GetTokens(vsPlotList, chSep);
	
	if(0 == trPlotType.nVal)//0: Raw Data
	{
		if(3 == vsPlotList.GetSize())
			vsPlotList.RemoveAt(2);
		
		///Cheney 2007-4-13 FIX_BUG_OF_CUSTOM_TABLE_DISAPPEAR_WHEN_CONCATENATE
		//if Raw data, combo list only two option
		trPlotFit.nVal = trPlotFit.nVal > 1? 1 : trPlotFit.nVal;
		///end FIX_BUG_OF_CUSTOM_TABLE_DISAPPEAR_WHEN_CONCATENATE
	}
	else
	{
		vsPlotList.SetSize(3);
		vsPlotList[2] = vsPlotList[1] + " + " + str;
	}
	strPlotList.SetTokens(vsPlotList, chSep);
	trPlotFit.SetAttribute(STR_COMBO_ATTRIB, strPlotList);
	
	return true;
		
}

/// Iris 3/16/2012 ORG-5212-P1 NEED_SET_MULTI_PLOTS_USE_SOURCE_GRAPH_COLOR_DEFAULT_AS_CHECKED
static bool _fit_curv_multi_plots_use_source_color_change(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg)
{
	TreeNode 	trSetColor = tree_get_node(tr, nRow);
	if( !trSetColor )
		return false;
	
	if( dwCntrl & GETNEVENT_ON_INIT )
	{
		int nVal;
		if( !trSetColor.GetAttribute(STR_CHANGED_ATTRIB, nVal) )
			trSetColor.SetAttribute(STR_CHANGED_ATTRIB, trSetColor.nVal);
	}
	else
	{
		trSetColor.SetAttribute(STR_CHANGED_ATTRIB, trSetColor.nVal);
	}
	return true;
}
///End NEED_SET_MULTI_PLOTS_USE_SOURCE_GRAPH_COLOR_DEFAULT_AS_CHECKED

/// Iris 01/23/2007 v8.0546 TO_CONTRL_NOT_OR_HOW_PLOT_FIT_CURVE
bool fit_curv_plot_fit_curve(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
{
	TreeNode 	trPlot = tree_get_node(tr, nRow);	
	/// Hong 11/18/08 QA80-12603 v8.0974 PA_SUPPORT_LEGEND_UPDATE_OPTION
	//if(!trPlot || !trPlot.Enable)
	if(!trPlot || !trPlot.Enable || !tree_is_visible(trPlot) )
	/// end PA_SUPPORT_LEGEND_UPDATE_OPTION
		return false;
		
	/// Iris 3/01/2011 ORG-402-S4 NO_FITCURVE_PLOT_SHOULD_DISABLE_SURFACE_PLOT_TYPE_NODE
	_set_surface_plot_type_enable(tr, nRow, nType, Dlg);
	///End NO_FITCURVE_PLOT_SHOULD_DISABLE_SURFACE_PLOT_TYPE_NODE
	
	TreeNode	trUpdateLegend = trPlot.NextNode;
	if(!trUpdateLegend)
		return error_report(_L("Fail to find UpdateLegend node"));
	
	bool	bEnable = 0 == trPlot.nVal? false : true; //0: None for Plot fit curve
	trUpdateLegend.Enable = bEnable;
	
	///Cheney 2007-4-13 FIX_BUG_OF_CUSTOM_TABLE_DISAPPEAR_WHEN_CONCATENATE
	//no need to set ot 0, otherwise, if disable/enable, should set it again
	//if(!bEnable)
		//trUpdateLegend.nVal = 0;
	///end FIX_BUG_OF_CUSTOM_TABLE_DISAPPEAR_WHEN_CONCATENATE
	
	return true;
}
///end TO_CONTRL_NOT_OR_HOW_PLOT_FIT_CURVE

//void ConstructAddGraphOptionsCommon(TreeNode &trGraph)
///------ Folger 05/06/2011 ORG-2786-S1 MORE_POINTS_FOR_FITX_IN_NLFIT
//void ConstructAddFitResultsOptionsCommon(TreeNode &trGraph, int nOption)
void	FitterOperation::ConstructAddFitResultsOptionsCommon(TreeNode &trGraph, int nOption)
///------ End MORE_POINTS_FOR_FITX_IN_NLFIT
{
	TreeNode tr = trGraph.Parent();
	if( !tr )
		return;	
	string strName = trGraph.tagName;
	
	GETN_USE(tr)
	GETN_BEGIN_USE_BRANCH_L(strName)
	
		GETN_CHECK(DoPlot, _L("Plot in Report Table"), 1) GETN_ID(IDE_FIT_DO_PLOT) /// Iris 2/25/2008 v8.0811 MAKE_FIT_CURVE_PLOT_AND_DATA_HAVE_SEPARATE_CONTROL
			GETN_OPTION_EVENT(_set_surface_plot_type_enable) /// Iris 3/01/2011 ORG-402-S4 NO_FITCURVE_PLOT_SHOULD_DISABLE_SURFACE_PLOT_TYPE_NODE
	///Iris 7/29/05 UPDATE_FITTED_CURVE_OPTIONS
	/*
		//GETN_CHECK(Formula, _L("Paste Formula to Graph"), true) GETN_ID(IDE_PASTE_FORMULA_TO_GRAPH) ///Iris 7/27/05 UPDATE_FITTED_CURVE_OPTIONS
		GETN_COLOR(CurveColor, "Line Color", 1) GETN_ID(IDE_FIT_CURVE_COLOR)
		
		GETN_CHECK(UseDataX, "Same X as Data", false) GETN_ID(IDE_FIT_USE_DATA_X) GETN_OPTION_EVENT(fit_dlg_use_data_x_event)		
		if(nOption)
			GETN_CHECK(UseDataXY, "Same XY as Data", false) GETN_ID(IDE_FIT_USE_DATA_XY) GETN_OPTION_EVENT(fit_dlg_use_data_xy_event)
		
		GETN_NUM(N, "X Points", 50) GETN_ID(IDE_FIT_X_POINTS)
		if(nOption)	
			GETN_NUM(NY, "Y Points", 50) GETN_ID(IDE_FIT_Y_POINTS)
		
		GETN_NUM(XMin, "X Min", -600) GETN_ID(IDE_FIT_X_MIN)
		GETN_NUM(XMax, "X Max", 600) GETN_ID(IDE_FIT_X_MAX)		
		if(nOption)	
		{
			GETN_NUM(YMin, "Y Min", -600) GETN_ID(IDE_FIT_Y_MIN)
			GETN_NUM(YMax, "Y Max", 600) GETN_ID(IDE_FIT_Y_MAX)
		}	
		
		GETN_CHECK(SpanXAxis, "Span to Full X Axis", 0) GETN_ID(IDE_FIT_RANGE_FULL_X)  GETN_OPTION_EVENT(fit_curv_span_to_full_x_even)		
		if(nOption)	
			GETN_CHECK(SpanYAxis, "Span to Full Y Axis", 0) GETN_ID(IDE_FIT_RANGE_FULL_XY)	GETN_OPTION_EVENT(fit_curv_span_to_full_xy_even)	
		
		GETN_NUM(RangeMargin, "Range Margin(%)", 10) GETN_ID(IDE_FIT_RANGE_MARGIN)
		GETN_CHECK(ConfBands, "Confidence Bands", 0) GETN_ID(IDE_FIT_CONF_BANDS)	GETN_OPTION_EVENT(fit_curv_conf_event)			
		GETN_CHECK(PredBands, "Prediction Bands", 0) GETN_ID(IDE_FIT_PRED_BANDS)	GETN_OPTION_EVENT(fit_curv_conf_event)
		GETN_NUM(Confidence, "Confidence", 95) GETN_ID(IDE_FIT_CONF)	GETN_OPTION_EVENT(fit_curv_conf_event)
	*/
		///Cheney 2006-8-30 QA70-8943 ADD_NEW_NODE_FOR_CONCATENATE 
		GETN_LIST(PlotType, _L("Plot Type"), 0, _L("Raw Data|Mean, SD|Mean, SE"))	GETN_ID(IDE_FIT_PLOT_TYPE) GETN_OPTION_EVENT(fit_curv_plot_type)
		///end ADD_NEW_NODE_FOR_CONCATENATE
		
		/// Iris 01/23/2007 v8.0546 TO_CONTRL_NOT_OR_HOW_PLOT_FIT_CURVE
		///Arvin 10/22/07 ADD_CHECKBOX_USE_SOURCE_GRAPH_COLOR_TO_SET_FITCURVES_COLOR
		//GETN_LIST(PlotFit, "Plot on Original Graph", 1, "None|Fitted Curve|Fitted Curve + Raw Data")	GETN_ID(IDE_FIT_PLOT_FIT_CURVE) GETN_OPTION_EVENT(fit_curv_plot_fit_curve)
		//GETN_CHECK(UpdateLegend, "Update Legend on Original Graph", 1) GETN_ID(IDE_FIT_UPDATE_LEGEND)
		GETN_LIST(PlotFit, _L("Plot on Source Graph"), 1, _L("None|Fitted Curve|Fitted Curve + Raw Data"))	GETN_ID(IDE_FIT_PLOT_FIT_CURVE) GETN_OPTION_EVENT(fit_curv_plot_fit_curve)
		#ifdef	MARKER_VISIBILITY_OPTIONS
		GETN_LIST(ShowMarker , _L("Show Analysis Markers on Source Plot"), SHOW_MARKER_IF_PARTIAL_RANGE, _L("Always|Only if partial data range|Never"))	GETN_ID(IDE_FIT_SHOW_MARKER)	///Jasmine 05/30/08 QA80-11630 ADD_OPTION_FOR_SHOW_MARKER_IN_SRC_PLOT_AFTER_FIT
		#endif//	MARKER_VISIBILITY_OPTIONS
		GETN_CHECK(UpdateLegend, _L("Update Legend on Source Graph"), 1) GETN_ID(IDE_FIT_UPDATE_LEGEND)
		GETN_CHECK(SetColor, _L("Multiple Plots Use Source Graph Color"), 1) GETN_ID(IDE_FIT_SET_COLOR) 
			GETN_OPTION_EVENT_EX(_fit_curv_multi_plots_use_source_color_change) /// Iris 3/16/2012 ORG-5212-P1 NEED_SET_MULTI_PLOTS_USE_SOURCE_GRAPH_COLOR_DEFAULT_AS_CHECKED
		///end ADD_CHECKBOX_USE_SOURCE_GRAPH_COLOR_TO_SET_FITCURVES_COLOR
		///end TO_CONTRL_NOT_OR_HOW_PLOT_FIT_CURVE

		/// Iris 07/30/2007 QA70-10073 TO_KEEP_CUSTOMIC_SETTINGS_IN_REPORT_GRAPH
		//GETN_COLOR(CurveColor, "Line Color", 1) GETN_ID(IDE_FIT_CURVE_COLOR)
		///end TO_KEEP_CUSTOMIC_SETTINGS_IN_REPORT_GRAPH
		
		/// Iris 11/21/06 DEFAULT_X_SHOULD_BE_UNIFORM_LIENAR, from Easwar's email
		/*
		/// Iris 8/14/06 v8.0462 REMOVE_UNIFORM_LOG
		//string strDataType = STR_FITTED_CURVE_DATA_TYPE_SAME_INPUT + "|" + STR_FITTED_CURVE_DATA_TYPE_UNIFORM_LINEAR + "|" + STR_FITTED_CURVE_DATA_TYPE_UNIFORM_LOG; 
		string strDataType = STR_FITTED_CURVE_DATA_TYPE_SAME_INPUT + "|" + STR_FITTED_CURVE_DATA_TYPE_UNIFORM_LINEAR; 
		///end REMOVE_UNIFORM_LOG
		*/
		/// Iris 11/02/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
		/*
		/// Iris 01/25/2007 v8.0547 BACK_UNIFORM_LOG
		//string strDataType = STR_FITTED_CURVE_DATA_TYPE_UNIFORM_LINEAR + "|" + STR_FITTED_CURVE_DATA_TYPE_SAME_INPUT; 
		///Cheney 2007-10-27 CLEAN_UP_LOCALIZATION_THINGS
		//after localization, can not complie here
		//string strDataType = STR_FITTED_CURVE_DATA_TYPE_UNIFORM_LINEAR + "|" + STR_FITTED_CURVE_DATA_TYPE_UNIFORM_LOG + "|" STR_FITTED_CURVE_DATA_TYPE_SAME_INPUT; 
		string strDataType = STR_FITTED_CURVE_DATA_TYPE_UNIFORM_LINEAR + "|"; 
		strDataType += STR_FITTED_CURVE_DATA_TYPE_UNIFORM_LOG + "|";
		strDataType += STR_FITTED_CURVE_DATA_TYPE_SAME_INPUT;
		//----------- Iris 11/20/2008 v8.0975d QA80-12591-P4 REMOVE_LOG_DATA_TYPE_WHEN_DATA_FROM_MATRIX
		//  !! need check if input data from graph on input data change, should simple check active layer since we can use interactive control to choose data again.
		/////Kyle 11/18/2008 QA80-12591 ADD_MORE_OPTION_FOR_INPUT_DATA_TYPE_IN_FITTING_TOOLS
		//GraphLayer gl = Project.ActiveLayer();
		//if(gl)		// from graph
			//strDataType += "|" + STR_FITTED_CURVE_DATA_TYPE_SAME_SOURCE_GRAPH;
		/////End ADD_MORE_OPTION_FOR_INPUT_DATA_TYPE_IN_FITTING_TOOLS
		//----------- 
		///end CLEAN_UP_LOCALIZATION_THINGS
		///end BACK_UNIFORM_LOG
		///end DEFAULT_X_SHOULD_BE_UNIFORM_LIENAR
		GETN_BEGIN_BRANCH(XDataType, _L("X Data Type"))  GETN_ID(IDE_FIT_DATA_TYPE_BRANCH)  GETN_COMBO_BRANCH(FIT_CURVE_UNIFORM_LINEAR, strDataType)  GETN_OPTION_EVENT(fit_curv_data_type_even)
			GETN_OPTION_BRANCH(GETNBRANCH_OPEN)  /// Iris 06/30/06 MAKE_CHANGE_TO_FOLLOW_MAX_SUGGESTION
			GETN_NUM(N, _L("Points"), XY_FIT_DEFAULT_POINTS) GETN_ID(IDE_FIT_X_POINTS)		
			GETN_LIST(Range, _L("Range"), 0, _L("Use Input Data Range + Margin|Span to Full Axis Range|Custom"))  GETN_ID(IDE_FIT_RANGE_BRANCH) GETN_OPTION_EVENT(fit_curv_range_even)
			///Cheney 2007-9-18 IF_FROM_THEME_SHOULD_NOT_UPDATE_CUSTOM_RANGE
			//GETN_NUM(Min, "Min", -600) GETN_ID(IDE_FIT_X_MIN)
			//GETN_NUM(Max, "Max", 600) GETN_ID(IDE_FIT_X_MAX)
			///Sophy 11/28/2008 v8.0980d QA80-12591-P5 ADD_AUTO_SUPPORT_FOR_LR_AND_PR_FITCURVE_XDATATYPE
			//GETN_NUM(Min, _L("Min"), FITTING_CUSTOM_RANGE_MIN_VAL_DEFAULT) GETN_ID(IDE_FIT_X_MIN)
			//GETN_NUM(Max, _L("Max"), FITTING_CUSTOM_RANGE_MAX_VAL_DEFAULT) GETN_ID(IDE_FIT_X_MAX)
			GETN_NUM(Min, _L("Min"), FITTING_CUSTOM_RANGE_MIN_VAL_DEFAULT) GETN_ID(IDE_FIT_X_MIN) GETN_ADD_AUTO(1)
			GETN_NUM(Max, _L("Max"), FITTING_CUSTOM_RANGE_MAX_VAL_DEFAULT) GETN_ID(IDE_FIT_X_MAX) GETN_ADD_AUTO(1)
			///end ADD_AUTO_SUPPORT_FOR_LR_AND_PR_FITCURVE_XDATATYPE
			///end IF_FROM_THEME_SHOULD_NOT_UPDATE_CUSTOM_RANGE
			/// Iris 01/08/2007 v8.0538 CHNAGE_DEFAULT_FOR_RANGE_MARGIN
			//GETN_NUM(RangeMargin, "Range Margin (%)", 10) GETN_ID(IDE_FIT_RANGE_MARGIN)	
			GETN_NUM(RangeMargin, _L("Range Margin (%)"), 0) GETN_ID(IDE_FIT_RANGE_MARGIN)
			///end CHNAGE_DEFAULT_FOR_RANGE_MARGIN
		GETN_END_BRANCH(XDataType)
		*/
#ifndef OP_DLG_TOTALLY_NEW_STRUCTURE
		ConstructFitXDataBranch(trGraph);
#endif //OP_DLG_TOTALLY_NEW_STRUCTURE
		///end OP_DLG_NEW_STRUCTURE
		GETN_CHECK(ConfBands, _L("Confidence Bands"), 0) GETN_ID(IDE_FIT_CONF_BANDS)	GETN_OPTION_EVENT_EX(fit_curv_conf_event)			
		GETN_CHECK(PredBands, _L("Prediction Bands"), 0) GETN_ID(IDE_FIT_PRED_BANDS)	GETN_OPTION_EVENT_EX(fit_curv_conf_event)
	///Kevin 09/02/05 CHANGE_STATISTICS_NAME	
		//GETN_NUM(Confidence, "Confidence", 95) GETN_ID(IDE_FIT_CONF)	GETN_OPTION_EVENT(fit_curv_conf_event)	
		GETN_NUM(Confidence, _L("Confidence Level for Curves(%)"), 95) GETN_ID(IDE_FIT_CONF)	GETN_OPTION_EVENT_EX(fit_curv_conf_event)	
	///End CHANGE_STATISTICS_NAME	
	///END UPDATE_FITTED_CURVE_OPTIONS
		/// Hong 01/23/08 QA80-10969 MOVE_PREVIEW_TO_HIGHER_LEVEL_IN_GUI
		/// remove to FitNL construct for highter level
		///// Hong 01/21/08 QA80-10969 FITNL_SOPPURT_DO_PREVIEW_ON_SOURCE_GRAPHPAGE
		////GETN_CHECK(Preview, _L("Show Preview on Source Graph"), 0) GETN_ID(IDE_FIT_PREV)
		//GETN_CHECK(Preview, _L("Show Preview on Source Graph"), 1) GETN_ID(IDE_FIT_PREV) /// Hong 01/23/08 QA80-10969 DEFAULT_PREVIEW_IN_SOURCE_GRAPHPAGE
		///// end FITNL_SOPPURT_DO_PREVIEW_ON_SOURCE_GRAPHPAGE
		/// end MOVE_PREVIEW_TO_HIGHER_LEVEL_IN_GUI
	GETN_END_USE_BRANCH_L(strName)
	
}


bool DescStatsDialogOnChangeCustomPercentiles(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
{
	tr.Quantities.Quantiles.PercentileList.Enable = tr.Quantities.Quantiles.CustomPercentiles.nVal;
	//----- CPY 6/9/04 MOVE_REPORT_BRANCH_TO_BASE_CLASS	
	//tr.Report.Results.HistogramTheme.Enable = tr.Report.Results.Histogram.nVal;
	//-----
	return true; // Return true to indicate update of display is needed
}


///------ Folger 05/06/2011 ORG-2786-S1 MORE_POINTS_FOR_FITX_IN_NLFIT
////--- CPY 7/19/04 
//#define GETN_OPERATION_STYLE GETN_OPTION_GRIDLINE(flexGridFlatVert) GETN_OPTION_EDIT_ALIGN("0|0|0");
////---
///------ End MORE_POINTS_FOR_FITX_IN_NLFIT
TreeNode ConstructOperationGUITree()
{

	GETN_OPERATION(tr)
	//--- CPY 7/16/04. divider line, see if people will like this better
	GETN_OPERATION_STYLE
	//---
	
	return tr;
}

bool desc_statics_percentile_event(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
{
	TreeNode trQuant = tr.Quantities.Quantiles;
	vector vPercs;
	string strPercs = trQuant.PercentileList.strVal; 
	int nSize = strPercs.GetTokens(vPercs, ' ');//put the confidence levels in vector
	///Joseph	12/07/06	ADD_MESSAGE_BOX
	string	strErrMsg;
	bool 	bOKEnable = true;
	bool	bShowErrMsg = false;
	///End	ADD_MESSAGE_BOX
	if (trQuant.PercentileList.Enable == true)
	{
		for (int ii = 0; ii < nSize; ii++)
		{
			if (vPercs[ii] < 0 || vPercs[ii] > 100)
			{
				///Joseph	12/07/06	ADD_MESSAGE_BOX
				///Echo 09/06/05 CORRECT_CONF_ERROR
				//MessageBox(NULL, _L(CON_LEV_ERROR_MSG), _L(ERROR_TITLE), MB_OK | MB_ICONSTOP);		
				//MessageBox(NULL, _L(PERCENTILE_ERROR_MSG), _L(ERROR_TITLE), MB_OK | MB_ICONSTOP);		
				//return false;
				bOKEnable = false;	
				bShowErrMsg = true;
				break;
				///End	ADD_MESSAGE_BOX

			}//if the persentile does not fit constraints, return error
		}//loop all persentiles
	}//if persentile list is showed
	///Joseph	12/07/06	ADD_MESSAGE_BOX
	
	///Echo 10/27/07 MACRO_MOVED_TO_OERRMSG_DLL	
	//strErrMsg = PERCENTILE_ERROR_MSG;
	//return 	handle_dialog_errmsg(tr, bShowErrMsg, strErrMsg, bOKEnable); ;
	return 	handle_dialog_errmsg(tr, bShowErrMsg, CER_PERCENTILES_LIST, bOKEnable); ;
	///end MACRO_MOVED_TO_OERRMSG_DLL
	
	///End	ADD_MESSAGE_BOX
}

bool desc_stats_quantile_interpolate_event(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
{
	//if (tr.Computation.Interpolate.nVal == 5)
	if (tr.Computation.Interpolate.nVal == INTERPOLATE_TUKEY)
	{
		tr.Quantities.Quantiles.CustomPercentiles.nVal = 0; 		
		tr.Quantities.Quantiles.CustomPercentiles.Enable = 0;
		tr.Quantities.Quantiles.PercentileList.Enable = 0;
	}else
	{
		tr.Quantities.Quantiles.CustomPercentiles.Enable = 1;
	}
	return true;
}
/**
	Parameters:
		nOption=0 for stats on columns, 1 for stats on rows
*/
void ConstructDescStatGUITree(TreeNode &tr, int nOption)
{
	GETN_USE(tr)
	
	GETN_CHECK(StatsOnRows, _L("Statistics on Rows"), nOption) GETN_ID(IDE_STATS_ON_ROWS)
	//GETN_OPTION_EVENT(DescStatsDialogOnChangeByRowCol)
	tr.StatsOnRows.Show = false;// we should never need to see this in GUI
	
	tree_construct_add_input_branch(tr, nOption == 0? INPUTDATA_RANGES_CAN_COMBINE : INPUTDATA_RANGES);

	/// RVD 10/2/2007 v8.0713 qa7-10446 FIX_DESC_STATS_SHEET_TO_COLS
	if( nOption == 1 )
	{
		tr.InputData.SetAttribute(STR_INTERACTIVE_CONTROL_OPTIONS_ATTRIB, ICOPT_SHEET_TO_COLS);
	}
	/// end FIX_DESC_STATS_SHEET_TO_COLS
	
	GETN_BEGIN_BRANCH(Quantities, STR_CALC_OPTIONS) GETN_ID_BRANCH(IDST_DESC_STATS_OPTIONS) 
		GETN_OPTION_BRANCH(GETNBRANCH_OPEN | GETNBRANCH_SAVE_SETTINGS)//Alex 06/05/06 MODIFY_DESC_STATS_DEFAULTGUI		
		
#ifdef OP_DLG_TOTALLY_NEW_STRUCTURE	
		if( 0 == nOption )// stats on col
		{
			DWORD dwOptions = REPORT_NOTES | REPORT_INPUT | REPORT_MASKED_DATA | REPORT_MISSING_DATA;
			tree_construct_add_common_report_table_options(_tmpSubNode, dwOptions);
		}
#endif //OP_DLG_TOTALLY_NEW_STRUCTURE
		
		///Echo 5/31/06 REORDER_DESC_STATS_RES
		GETN_BEGIN_BRANCH(Moments, _L("Moments")) GETN_ID_BRANCH(IDST_DESC_STATS_MOMNTS_OPTNS)
		/// Max 6/4/08 v8.0877 THIS_BRANCH_SHOULD_CLOSE_BY_DEFAULT	/// previous stats on rows has few items so we can expand it, but it has many items now.
		///// Iris 06/07/2007 v8.0634 OPEN_THIS_BRANCH_FOR_STATS_ON_ROWS
		//if(1 == nOption) //is stats on rows
		//{
			//GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
		//}
		/////end OPEN_THIS_BRANCH_FOR_STATS_ON_ROWS
		/// END THIS_BRANCH_SHOULD_CLOSE_BY_DEFAULT
			///Cheney 2007-5-23 QA70-9805 SPEED_UP_STATISTIC_ON_ROW
			//GETN_CHECK(N, _L("N total"), !nOption) GETN_ID(IDE_SAMPLE_SIZE)
			//GETN_CHECK(Missing, _L("N missing"), false) GETN_ID(IDE_NUM_MISSING)
			//GETN_CHECK(Mean, _L("Mean"), true) GETN_ID(IDE_MEAN)
			//GETN_CHECK(SD, _L("Standard Deviation"), true) GETN_ID(IDE_SD)
			///// Iris 02/05/2007 v8.0575 CHANGE_DEFAULT_ON_ECHO_SUGGESTION
			////GETN_CHECK(SEM, _L("SE of mean"), !nOption)  GETN_ID(IDE_SEM)
			////GETN_CHECK(LCL, _L("Lower 95% CI of Mean"), !nOption) GETN_ID(IDE_LCL)
			////GETN_CHECK(UCL, _L("Upper 95% CI of Mean"), !nOption) GETN_ID(IDE_UCL)
			//GETN_CHECK(SEM, _L("SE of mean"), false)  GETN_ID(IDE_SEM)
			//GETN_CHECK(LCL, _L("Lower 95% CI of Mean"), false) GETN_ID(IDE_LCL)
			//GETN_CHECK(UCL, _L("Upper 95% CI of Mean"), false) GETN_ID(IDE_UCL)
			/////end CHANGE_DEFAULT_ON_ECHO_SUGGESTION
			//GETN_CHECK(Variance, _L("Variance"), false) GETN_ID(IDE_VARIANCE)
			//GETN_CHECK(Sum, _L("Sum"), !nOption) GETN_ID(IDE_SUM)  
			//GETN_CHECK(Skewness, _L("Skewness"), false) GETN_ID(IDE_SKEWNESS)
			//GETN_CHECK(Kurtosis, _L("Kurtosis"), false) GETN_ID(IDE_KURTOSIS)
			//GETN_CHECK(UncorSumSq, _L("Uncorrected Sum of Squares"), false) GETN_ID(IDE_UNCORSUMSQ)
			//GETN_CHECK(CorSumSq, _L("Corrected Sum of Squares"), false) GETN_ID(IDE_CORSUMSQ)
			//GETN_CHECK(COV, _L("Coefficient of Variation"), false) GETN_ID(IDE_COV)
			//GETN_CHECK(MAD, _L("Mean absolute Deviation"), false) GETN_ID(IDE_MAD)
			//GETN_CHECK(SDx2, _L("SD times 2"), false) GETN_ID(IDE_SD_X_2)
			//GETN_CHECK(SDx3, _L("SD times 3"), false) GETN_ID(IDE_SD_X_3)
			//GETN_CHECK(GeoMean, _L("Geometric Mean"), false) GETN_ID(IDE_GEO_MEAN)
			//GETN_CHECK(GeoSD, _L("Geometric SD"), false) GETN_ID(IDE_GEO_SD) 
			//GETN_CHECK(Mode, _L("Mode"), false) GETN_ID(IDE_MODE)
			//GETN_CHECK(WeightSum, _L("Sum of Weights"),false) GETN_ID(IDE_WEIGHTSUM)
			/// Hong 10/26/07 v8.0734 FIX_ERROR_LOCALIZE_WITH_MACRO
			/*
			GETN_CHECK(N, _L(STR_DESC_STATIS_GUI_LABEL_SAMPLE_SIZE), !nOption) GETN_ID(IDE_SAMPLE_SIZE)
			GETN_CHECK(Missing, _L(STR_DESC_STATIS_GUI_LABEL_NUM_MISSING), false) GETN_ID(IDE_NUM_MISSING)
			GETN_CHECK(Mean, _L(STR_DESC_STATIS_GUI_LABEL_MEAN), true) GETN_ID(IDE_MEAN)
			GETN_CHECK(SD, _L(STR_DESC_STATIS_GUI_LABEL_SD), true) GETN_ID(IDE_SD)
			GETN_CHECK(SEM, _L(STR_DESC_STATIS_GUI_LABEL_SEM), false)  GETN_ID(IDE_SEM)
			GETN_CHECK(LCL, _L(STR_DESC_STATIS_GUI_LABEL_LCL), false) GETN_ID(IDE_LCL)
			GETN_CHECK(UCL, _L(STR_DESC_STATIS_GUI_LABEL_UCL), false) GETN_ID(IDE_UCL)
			GETN_CHECK(Variance, _L(STR_DESC_STATIS_GUI_LABEL_VARIANCE), false) GETN_ID(IDE_VARIANCE)
			GETN_CHECK(Sum, _L(STR_DESC_STATIS_GUI_LABEL_SUM), !nOption) GETN_ID(IDE_SUM)  
			GETN_CHECK(Skewness, _L(STR_DESC_STATIS_GUI_LABEL_SKEWNESS), false) GETN_ID(IDE_SKEWNESS)
			GETN_CHECK(Kurtosis, _L(STR_DESC_STATIS_GUI_LABEL_KURTOSIS), false) GETN_ID(IDE_KURTOSIS)
			GETN_CHECK(UncorSumSq, _L(STR_DESC_STATIS_GUI_LABEL_UNCORSUMSQ), false) GETN_ID(IDE_UNCORSUMSQ)
			GETN_CHECK(CorSumSq, _L(STR_DESC_STATIS_GUI_LABEL_CORSUMSQ), false) GETN_ID(IDE_CORSUMSQ)
			GETN_CHECK(COV, _L(STR_DESC_STATIS_GUI_LABEL_COV), false) GETN_ID(IDE_COV)
			GETN_CHECK(MAD, _L(STR_DESC_STATIS_GUI_LABEL_MAD), false) GETN_ID(IDE_MAD)
			GETN_CHECK(SDx2, _L(STR_DESC_STATIS_GUI_LABEL_SD_X_2), false) GETN_ID(IDE_SD_X_2)
			GETN_CHECK(SDx3, _L(STR_DESC_STATIS_GUI_LABEL_SD_X_3), false) GETN_ID(IDE_SD_X_3)
			GETN_CHECK(GeoMean, _L(STR_DESC_STATIS_GUI_LABEL_GEO_MEAN), false) GETN_ID(IDE_GEO_MEAN)
			GETN_CHECK(GeoSD, _L(STR_DESC_STATIS_GUI_LABEL_GEO_SD), false) GETN_ID(IDE_GEO_SD) 
			GETN_CHECK(Mode, _L(STR_DESC_STATIS_GUI_LABEL_MODE), false) GETN_ID(IDE_MODE)
			GETN_CHECK(WeightSum, _L(STR_DESC_STATIS_GUI_LABEL_WEIGHTSUM),false) GETN_ID(IDE_WEIGHTSUM)
			*/
			GETN_CHECK_L(N, STR_DESC_STATIS_GUI_LABEL_SAMPLE_SIZE_E, !nOption) GETN_ID(IDE_SAMPLE_SIZE)
			GETN_CHECK_L(Missing, STR_DESC_STATIS_GUI_LABEL_NUM_MISSING_E, false) GETN_ID(IDE_NUM_MISSING)
			GETN_CHECK_L(Mean, STR_DESC_STATIS_GUI_LABEL_MEAN_E, true) GETN_ID(IDE_MEAN)
			GETN_CHECK_L(SD, STR_DESC_STATIS_GUI_LABEL_SD_E, true) GETN_ID(IDE_SD)
			GETN_CHECK_L(SEM, STR_DESC_STATIS_GUI_LABEL_SEM_E, false)  GETN_ID(IDE_SEM)
			GETN_CHECK_L(LCL, STR_DESC_STATIS_GUI_LABEL_LCL_E, false) GETN_ID(IDE_LCL)
			GETN_CHECK_L(UCL, STR_DESC_STATIS_GUI_LABEL_UCL_E, false) GETN_ID(IDE_UCL)
			GETN_CHECK_L(Variance, STR_DESC_STATIS_GUI_LABEL_VARIANCE_E, false) GETN_ID(IDE_VARIANCE)
			GETN_CHECK_L(Sum, STR_DESC_STATIS_GUI_LABEL_SUM_E, !nOption) GETN_ID(IDE_SUM)  
			GETN_CHECK_L(Skewness, STR_DESC_STATIS_GUI_LABEL_SKEWNESS_E, false) GETN_ID(IDE_SKEWNESS)
			GETN_CHECK_L(Kurtosis, STR_DESC_STATIS_GUI_LABEL_KURTOSIS_E, false) GETN_ID(IDE_KURTOSIS)
			GETN_CHECK_L(UncorSumSq, STR_DESC_STATIS_GUI_LABEL_UNCORSUMSQ_E, false) GETN_ID(IDE_UNCORSUMSQ)
			GETN_CHECK_L(CorSumSq, STR_DESC_STATIS_GUI_LABEL_CORSUMSQ_E, false) GETN_ID(IDE_CORSUMSQ)
			GETN_CHECK_L(COV, STR_DESC_STATIS_GUI_LABEL_COV_E, false) GETN_ID(IDE_COV)
			GETN_CHECK_L(MAD, STR_DESC_STATIS_GUI_LABEL_MAD_E, false) GETN_ID(IDE_MAD)
			GETN_CHECK_L(SDx2, STR_DESC_STATIS_GUI_LABEL_SD_X_2_E, false) GETN_ID(IDE_SD_X_2)
			GETN_CHECK_L(SDx3, STR_DESC_STATIS_GUI_LABEL_SD_X_3_E, false) GETN_ID(IDE_SD_X_3)
			GETN_CHECK_L(GeoMean, STR_DESC_STATIS_GUI_LABEL_GEO_MEAN_E, false) GETN_ID(IDE_GEO_MEAN)
			GETN_CHECK_L(GeoSD, STR_DESC_STATIS_GUI_LABEL_GEO_SD_E, false) GETN_ID(IDE_GEO_SD) 
			GETN_CHECK_L(Mode, STR_DESC_STATIS_GUI_LABEL_MODE_E, false) GETN_ID(IDE_MODE)
			GETN_CHECK_L(WeightSum, STR_DESC_STATIS_GUI_LABEL_WEIGHTSUM_E,false) GETN_ID(IDE_WEIGHTSUM)
			///Sophy 2/21/2011 ORG-1400-P2 REMOVE_SUM_OF_WEIGHTS_FROM_STATS_ON_ROW_GUI
			if ( nOption )
				GETN_CURRENT_SUBNODE.Remove(); //can NOT use .Show = false here, since within update_param_tree_advanced_ids it can be visible again...
			///end REMOVE_SUM_OF_WEIGHTS_FROM_STATS_ON_ROW_GUI
			/// end FIX_ERROR_LOCALIZE_WITH_MACRO
			///end SPEED_UP_STATISTIC_ON_ROW
		GETN_END_BRANCH(Moments)
		//GETN_BEGIN_BRANCH(Moments, _L("Moments")) GETN_ID_BRANCH(IDST_DESC_STATS_MOMNTS_OPTNS)
			/////Echo 9/12/04 ADD_OPTIONS_FOR_MONENT
			////GETN_LIST(Interpolate, _L("Variance Divisor"), 0, _L("DF | N | WS | WDF | WVR"))		
			/////end ADD_OPTIONS_FOR_MONENT
			////GETN_LIST(VarDivisor, _L("Variance Divisor of Moment"), 0, _L("DF | N | WS | WDF | WVR"))  /// Iris 12/01/04 MOVE_COMPUTER_CONTROL_INSIDE_QUANTITIES  ///Iris 12/20/04 MOVE_TO_COMPCONTROL_BRANCH
			//GETN_CHECK(N, _L("N total"), true) GETN_ID(IDE_SAMPLE_SIZE)
			//GETN_CHECK(Missing, _L("N missing"), false) GETN_ID(IDE_NUM_MISSING)
			//GETN_CHECK(Sum, _L("Sum"), true) GETN_ID(IDE_SUM)  
			//GETN_CHECK(Mean, _L("Mean"), true) GETN_ID(IDE_MEAN)
			//GETN_CHECK(Mode, _L("Mode"), false) GETN_ID(IDE_MODE)///Echo 11/22/05 v8.0339 ADD_MODE
			//GETN_CHECK(GeoMean, _L("Geometric Mean"), false) GETN_ID(IDE_GEO_MEAN)
			//GETN_CHECK(GeoSD, _L("Geometric SD"), false) GETN_ID(IDE_GEO_SD) ///Echo 3/22/05 v8.0207 QA70-6204 ADD_GSD
		/////Kevin 09/01/05 CHANGE_STATISTICS_NAME
			////GETN_CHECK(LCI, _L("Lower 95% Confidence Interval"), true) GETN_ID(IDE_LCI)
			////GETN_CHECK(UCI, _L("Upper 95% Confidence Interval"), true) GETN_ID(IDE_UCI)
			//GETN_CHECK(LCL, _L("Lower 95% CI of Mean"), true) GETN_ID(IDE_LCL)
			//GETN_CHECK(UCL, _L("Upper 95% CI of Mean"), true) GETN_ID(IDE_UCL)
		/////End CHANGE_STATISTICS_NAME
			//GETN_CHECK(SD, _L("Standard Deviation"), true) GETN_ID(IDE_SD)
			//GETN_CHECK(SDx2, _L("SD times 2"), false) GETN_ID(IDE_SD_X_2)
			//GETN_CHECK(SDx3, _L("SD times 3"), false) GETN_ID(IDE_SD_X_3)
			//GETN_CHECK(SEM, _L("SE of mean"), true)  GETN_ID(IDE_SEM)
			//GETN_CHECK(Variance, _L("Variance"), false) GETN_ID(IDE_VARIANCE)
			//GETN_CHECK(COV, _L("Coefficient of Variation"), false) GETN_ID(IDE_COV)
			//GETN_CHECK(Skewness, _L("Skewness"), false) GETN_ID(IDE_SKEWNESS)
			//GETN_CHECK(Kurtosis, _L("Kurtosis"), false) GETN_ID(IDE_KURTOSIS)
			//GETN_CHECK(MAD, _L("Mean absolute Deviation"), false) GETN_ID(IDE_MAD)
			//GETN_CHECK(UncorSumSq, _L("Uncorrected Sum of Squares"), false) GETN_ID(IDE_UNCORSUMSQ)
			//GETN_CHECK(CorSumSq, _L("Corrected Sum of Squares"), false) GETN_ID(IDE_CORSUMSQ)
			//GETN_CHECK(WeightSum, _L("Sum of Weights"),false) GETN_ID(IDE_WEIGHTSUM)
		//GETN_END_BRANCH(Moments)
		///END REORDER_DESC_STATS_RES
		GETN_BEGIN_BRANCH(Quantiles, _L("Quantiles")) GETN_ID_BRANCH(IDST_QUANTILE_OPTIONS)
		/// Max 6/4/08 v8.0877 THIS_BRANCH_SHOULD_CLOSE_BY_DEFAULT	/// previous stats on rows has few items so we can expand it, but it has many items now.
		///// Iris 06/07/2007 v8.0634 OPEN_THIS_BRANCH_FOR_STATS_ON_ROWS
		//if(1 == nOption) //is stats on rows
		//{
			//GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
		//}
		///end OPEN_THIS_BRANCH_FOR_STATS_ON_ROWS
		/// END THIS_BRANCH_SHOULD_CLOSE_BY_DEFAULT
			///Echo 9/12/04 INTERPOLATE_TYPE_CHANGE
			//GETN_LIST(Interpolate, _L("Interpolatation"), 0, _L("None|Weighted Average Right|Nearest Neighbor|Empirical Distribution|Weighted Average Left|Empirical Distribution with Averaging")) GETN_ID(IDE_INTERPOLATE)
			//GETN_LIST(Interpolate, _L("Interpolatation"), 0, _L("Empirical Distribution(None)|Weighted Average Right|Nearest Neighbor|Weighted Average Left|Empirical Distribution with Averaging")) GETN_ID(IDE_INTERPOLATE)
			///end INTERPOLATE_TYPE_CHANGE
			//GETN_LIST(Interpolate, _L("Interpolatation of Quantiles"), 0, _L("Empirical Distribution(None)|Weighted Average Right|Nearest Neighbor|Weighted Average Left|Empirical Distribution with Averaging")) GETN_ID(IDE_INTERPOLATE)  /// Iris 12/01/04 MOVE_COMPUTER_CONTROL_INSIDE_QUANTITIES  ///Iris 12/20/04 MOVE_TO_COMPCONTROL_BRANCH
			///Cheney 2007-5-23 QA70-9805 SPEED_UP_STATISTIC_ON_ROW
			//GETN_CHECK(Min, _L("Minimum"), !nOption) GETN_ID(IDE_MIN)				
			//GETN_CHECK(iMin, _L("Index of Minimum"), false) GETN_ID(IDE_IMIN)
			///// Iris 02/05/2007 v8.0575 CHANGE_DEFAULT_ON_ECHO_SUGGESTION
			////GETN_CHECK(Q1, _L("1st Quartile (Q1)"), !nOption) GETN_ID(IDE_P25)				
			//GETN_CHECK(Q1, _L("1st Quartile (Q1)"), false) GETN_ID(IDE_P25)				
			/////end CHANGE_DEFAULT_ON_ECHO_SUGGESTION
			//GETN_CHECK(Median, _L("Median"), !nOption) GETN_ID(IDE_MEDIAN)				
			///// Iris 02/05/2007 v8.0575 CHANGE_DEFAULT_ON_ECHO_SUGGESTION
			////GETN_CHECK(Q3, _L("3rd Quartile (Q3)"), !nOption) GETN_ID(IDE_P75)				
			//GETN_CHECK(Q3, _L("3rd Quartile (Q3)"), false) GETN_ID(IDE_P75)				
			/////end CHANGE_DEFAULT_ON_ECHO_SUGGESTION
			//GETN_CHECK(Max, _L("Maximum"), !nOption) GETN_ID(IDE_MAX)				
			//GETN_CHECK(iMax, _L("Index of Maximum"), false) GETN_ID(IDE_IMAX)
			//GETN_CHECK(IQR, _L("Interquartile Range (Q3 - Q1)"), false) GETN_ID(IDE_IQR)
			//GETN_CHECK(Range, _L("Range (Maximum - Minimum)"), false) GETN_ID(IDE_RANGE)
			//GETN_CHECK(CustomPercentiles, _L("Custom Percentile(s)"), false) GETN_ID(IDE_USE_CUSTOM_PERCENTILES)
			//GETN_OPTION_EVENT(DescStatsDialogOnChangeCustomPercentiles)
			//GETN_STR(PercentileList, _L("Percentile List"),"90 95 99") GETN_ID(IDE_CUSTOM_PERCENTILES)
			/// Hong 10/26/07 v8.0734 FIX_ERROR_LOCALIZE_WITH_MACRO
			/*
			GETN_CHECK(Min, _L(STR_DESC_STATIS_GUI_LABEL_MIN), !nOption) GETN_ID(IDE_MIN)				
			GETN_CHECK(iMin, _L(STR_DESC_STATIS_GUI_LABEL_IMIN), false) GETN_ID(IDE_IMIN)
			GETN_CHECK(Q1, _L(STR_DESC_STATIS_GUI_LABEL_P25), false) GETN_ID(IDE_P25)				
			GETN_CHECK(Median, _L(STR_DESC_STATIS_GUI_LABEL_MEDIAN), !nOption) GETN_ID(IDE_MEDIAN)				
			GETN_CHECK(Q3, _L(STR_DESC_STATIS_GUI_LABEL_P75), false) GETN_ID(IDE_P75)				
			GETN_CHECK(Max, _L(STR_DESC_STATIS_GUI_LABEL_MAX), !nOption) GETN_ID(IDE_MAX)				
			GETN_CHECK(iMax, _L(STR_DESC_STATIS_GUI_LABEL_IMAX), false) GETN_ID(IDE_IMAX)
			GETN_CHECK(IQR, _L(STR_DESC_STATIS_GUI_LABEL_IQR), false) GETN_ID(IDE_IQR)
			GETN_CHECK(Range, _L(STR_DESC_STATIS_GUI_LABEL_RANGE), false) GETN_ID(IDE_RANGE)
			GETN_CHECK(CustomPercentiles, _L(STR_DESC_STATIS_GUI_LABEL_USE_CUSTOM_PERCENTILES), false) GETN_ID(IDE_USE_CUSTOM_PERCENTILES)
			GETN_OPTION_EVENT(DescStatsDialogOnChangeCustomPercentiles)
			GETN_STR(PercentileList, _L(STR_DESC_STATIS_GUI_LABEL_CUSTOM_PERCENTILES),"90 95 99") GETN_ID(IDE_CUSTOM_PERCENTILES)
			*/
			GETN_CHECK_L(Min, STR_DESC_STATIS_GUI_LABEL_MIN_E, !nOption) GETN_ID(IDE_MIN)				
			GETN_CHECK_L(iMin, STR_DESC_STATIS_GUI_LABEL_IMIN_E, false) GETN_ID(IDE_IMIN)
			GETN_CHECK_L(Q1, STR_DESC_STATIS_GUI_LABEL_P25_E, false) GETN_ID(IDE_P25)				
			GETN_CHECK_L(Median, STR_DESC_STATIS_GUI_LABEL_MEDIAN_E, !nOption) GETN_ID(IDE_MEDIAN)				
			GETN_CHECK_L(Q3, STR_DESC_STATIS_GUI_LABEL_P75_E, false) GETN_ID(IDE_P75)				
			GETN_CHECK_L(Max, STR_DESC_STATIS_GUI_LABEL_MAX_E, !nOption) GETN_ID(IDE_MAX)				
			GETN_CHECK_L(iMax, STR_DESC_STATIS_GUI_LABEL_IMAX_E, false) GETN_ID(IDE_IMAX)
			GETN_CHECK_L(IQR, STR_DESC_STATIS_GUI_LABEL_IQR_E, false) GETN_ID(IDE_IQR)
			GETN_CHECK_L(Range, STR_DESC_STATIS_GUI_LABEL_RANGE_E, false) GETN_ID(IDE_RANGE)
			GETN_CHECK_L(CustomPercentiles, STR_DESC_STATIS_GUI_LABEL_USE_CUSTOM_PERCENTILES_E, false) GETN_ID(IDE_USE_CUSTOM_PERCENTILES)
			GETN_OPTION_EVENT(DescStatsDialogOnChangeCustomPercentiles)
			GETN_STR(PercentileList, STR_DESC_STATIS_GUI_LABEL_CUSTOM_PERCENTILES,"90 95 99") GETN_ID(IDE_CUSTOM_PERCENTILES)
			/// end FIX_ERROR_LOCALIZE_WITH_MACRO
			///end SPEED_UP_STATISTIC_ON_ROW
			GETN_OPTION_EVENT(desc_statics_percentile_event)
		GETN_END_BRANCH(Quantiles) 
		
		/// Iris 01/09/05 QA70-6367 ADD_EXTREME_VALUES
		GETN_CHECK_L(ExVal, _L("Extreme Values"), false)	GETN_ID(IDE_EXTREME_VALUES)
		if(nOption)  GETN_CURRENT_SUBNODE.Show = false; //not appear in statistics on rows
		///End ADD_EXTREME_VALUES
		
	GETN_END_BRANCH(Quantities)
	
	int nVarVal = 1 == nOption? 4 : 0;  /// Iris 06/06/06 DIFF_DEFAULT_VAL_FOR_VAR_DIV
	///Cheney 2007-4-27 STATAS_ON_ROW_NOT_NEED_WDF_ETC	
	///Cheney 2007-10-27 CLEAN_UP_LOCALIZATION_THINGS	
	//string strDivisor = 1 == nOption? "DF|N" : "DF|N|WDF|WS|WVR";
	string strDivisor = 1 == nOption? _L("DF|N") : _L("DF|N|WDF|WS|WVR");
	///end CLEAN_UP_LOCALIZATION_THINGS
	///end STATAS_ON_ROW_NOT_NEED_WDF_ETC
	GETN_BEGIN_BRANCH(Computation, _L("Computation Control")) GETN_ID(IDE_COMPUTER_CONTROL)
#ifdef ADD_WEIGHT_METHOD_FOR_DESC_STATS_ON_COLS
		GETN_LIST(WeightMethod, _L("Weight Method"), 0, _L("Direct Weight|Instrumental|Statistical")) GETN_ID(IDE_WEIGHT_METHOD) /// Iris 5/04/2009 QA80-11982 STATS_ON_COL_ADD_WEIGHT_METHOD
		///Sophy 11/8/2010 ORG-1400 REMOVE_WEIGHT_METHOD_COMBOLIST_WHEN_STATS_ON_ROW
		if ( nOption )
			GETN_CURRENT_SUBNODE.Show = false;
		///end REMOVE_WEIGHT_METHOD_COMBOLIST_WHEN_STATS_ON_ROW
#endif
		/// Iris 06/06/06 DIFF_DEFAULT_VAL_FOR_VAR_DIV
		/////Echo 2/16/05 	ERROR_ORDER_TYPE_LIST
		////GETN_LIST(VarDivisor, _L("Variance Divisor of Moment"), 0, _L("DF|N|WS|WDF|WVR"))  /// Iris 12/01/04 MOVE_COMPUTER_CONTROL_INSIDE_QUANTITIES
		//GETN_LIST(VarDivisor, _L("Variance Divisor of Moment"), 0, _L("DF|N|WDF|WS|WVR")) GETN_ID(IDE_VAR_DIVISOR)///DSC 9/20/05 QA70-8113 ADD_IDE_VAR_DIVISOR
		///Cheney 2007-4-27 STATAS_ON_ROW_NOT_NEED_WDF_ETC
		//GETN_LIST(VarDivisor, _L("Variance Divisor of Moment"), 0/*nVarVal*/, _L("DF|N|WDF|WS|WVR")) GETN_ID(IDE_VAR_DIVISOR)///DSC 9/20/05 QA70-8113 ADD_IDE_VAR_DIVISOR ///Arvin 11/10/06 CHENAGE_DEFAULT_TO_DF by max's suggestion
		///Cheney 2007-10-27 CLEAN_UP_LOCALIZATION_THINGS	
		//GETN_LIST(VarDivisor, _L("Variance Divisor of Moment"), 0/*nVarVal*/, _L(strDivisor)) GETN_ID(IDE_VAR_DIVISOR)///DSC 9/20/05 QA70-8113 ADD_IDE_VAR_DIVISOR ///Arvin 11/10/06 CHENAGE_DEFAULT_TO_DF by max's suggestion
		GETN_LIST(VarDivisor, _L("Variance Divisor of Moment"), 0/*nVarVal*/, strDivisor) GETN_ID(IDE_VAR_DIVISOR)
		///end CLEAN_UP_LOCALIZATION_THINGS
		///end STATAS_ON_ROW_NOT_NEED_WDF_ETC
		/////END ERROR_ORDER_TYPE_LIST
		
		/// Max 12/21/06 CHANGE_QUANTILE_METHOD_ORDER
		/////Echo 11/18/05 CHANGE_DS_QUANTILE_DEFAULT
		///////Echo 10/9/05 ADD_QUANTILE_METHOD
		//////GETN_LIST(Interpolate, _L("Interpolatation of Quantiles"), 0, _L("Empirical Distribution(None)|Weighted Average Right|Nearest Neighbor|Weighted Average Left|Empirical Distribution with Averaging")) GETN_ID(IDE_INTERPOLATE)  /// Iris 12/01/04 MOVE_COMPUTER_CONTROL_INSIDE_QUANTITIES
		////GETN_LIST(Interpolate, _L("Interpolatation of Quantiles"), 0, _L("Empirical Distribution(None)|Weighted Average Right|Nearest Neighbor|Weighted Average Left|Empirical Distribution with Averaging|Tukey Hinges")) GETN_ID(IDE_INTERPOLATE)
		//GETN_LIST(Interpolate, _L("Interpolatation of Quantiles"), 0, _L("Weighted Average Right|Weighted Average Left|Nearest Neighbor|Empirical Distribution(None)|Empirical Distribution with Averaging|Tukey Hinges")) GETN_ID(IDE_INTERPOLATE)
		GETN_LIST(Interpolate, _L("Interpolation of Quantiles"), 0, _L("Empirical Distribution with Averaging|Nearest Neighbor|Empirical Distribution|Weighted Average Right|Weighted Average Left|Tukey Hinges")) GETN_ID(IDE_INTERPOLATE)
		///////end ADD_QUANTILE_METHOD
		/////end CHANGE_DS_QUANTILE_DEFAULT
		/// END CHANGE_QUANTILE_METHOD_ORDER
		GETN_OPTION_EVENT(desc_stats_quantile_interpolate_event)
	GETN_END_BRANCH(Computation)
		
	/// Iris 12/01/04 MOVE_COMPUTER_CONTROL_INSIDE_QUANTITIES
	/////Echo 9/20/04 ADD_COMPUTATION_CONTROL
	//GETN_BEGIN_BRANCH(Computation, _L("Computation Control"))
		//GETN_LIST(VarDivisor, _L("Variance Divisor of Moment"), 0, _L("DF | N | WS | WDF | WVR"))
		//GETN_LIST(Interpolate, _L("Interpolatation of Quantiles"), 0, _L("Empirical Distribution(None)|Weighted Average Right|Nearest Neighbor|Weighted Average Left|Empirical Distribution with Averaging")) GETN_ID(IDE_INTERPOLATE)			
	//GETN_END_BRANCH(Computation)
	///End MOVE_COMPUTER_CONTROL_INSIDE_QUANTITIES
	
	//----- CPY 6/9/04 MOVE_REPORT_BRANCH_TO_BASE_CLASS	
	/*
	GETN_BEGIN_BRANCH(Report, _L("Report"))
		GETN_FUNC_ADD_NODES(SetupCommonReportNodes) /// ML 5/11/2004 SEPARATE_FUNCTION_FOR_COMMON_REPORT_NODES
		GETN_BEGIN_BRANCH(Results, _L("Results"))
			GETN_BUTTON(StatisticsTheme, _L("Statistics Theme"), STR_LAST_USED);
			GETN_CHECK(Histogram, _L("Histogram"), true)
			GETN_OPTION_EVENT(DescStatDialogOnChangeEvent)
			GETN_BUTTON(HistogramTheme, _L("Histogram Theme"), STR_LAST_USED);
			// GJL 5/18/04 Just 1 plot per analysis for now maybe more later
			//GETN_CHECK(BoxChart, _L("Box Chart"), true)
			//GETN_BUTTON(BoxChartTheme, _L("Box Chart Theme"), STR_LAST_USED);
		GETN_END_BRANCH(Results)
	GETN_END_BRANCH(Report)

	tr.Statistics.Quantiles.PercentileList.Enable = tr.Statistics.Quantiles.CustomPercentiles.nVal;
	tr.Report.Results.HistogramTheme.SetAttribute(STR_DEPENDS_ON, "Histogram");
	*/
	//------
	///Arvin 01/07/08 QA70-10903 ADD_CHECK_ALL_BOX_FOR_BRANCH
	TreeNode trMoments = tr.Quantities.Moments;
	if(trMoments)
		tree_set_branch_attribute_for_branch(trMoments);
	TreeNode trQuantiles = tr.Quantities.Quantiles;
	if(trQuantiles)
		tree_set_branch_attribute_for_branch(trQuantiles);
	///end ADD_CHECK_ALL_BOX_FOR_BRANCH
}

bool DescStatApplyOnClick(TreeNode& tr)
{
	//out_str("\n-----from inside function DescStatApplyOnClick\n");
	//out_tree(tr);
	//out_str("-----exit from DescStatApplyOnClick\n");
	return false;
}


//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//////////                        Frequency Count                       //////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
///Echo 10/26/07 NOT_USED_FUNCTION
///the feature has been done in XF. these code won't be used anymore
//BOOL DoFrequencyCountDialog(TreeNode &trGUI, BOOL bChangeParams)
//{
	//BOOL bOKClicked = GetNBox(trGUI, _L("Frequency Count"), _L("Enter Frequency Count parameters"));
	//return bOKClicked;
//}
//
//bool freq_counts_stepsize_event(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
//{
	//TreeNode trFreqCnts=tr.Options;
	//double dMin, dMax, dStepSize, dMaxStep;
	//dMin = trFreqCnts.FromMin.dVal;
	//dMax = trFreqCnts.ToMax.dVal;
	//dMaxStep = (dMax - dMin) / 2; 
	//dStepSize = trFreqCnts.IncrementSize.dVal;
	//
	/////Joseph	12/07/06	ADD_MESSAGE_BOX
	//string	strErrMsg;
	//bool	bShowErrMsg = false;
	//bool	bOKEnable = true;
	/////End	ADD_MESSAGE_BOX
	//
	//if (dStepSize < 0 || dStepSize > dMaxStep)
	//{
		/////Joseph	12/07/06	ADD_MESSAGE_BOX
		////MessageBox(NULL, _L(FREQ_MAX_STEP_ERROR_MSG), _L(ERROR_TITLE), MB_OK | MB_ICONSTOP);
		////return false;
		//bShowErrMsg = true;
		//bOKEnable = false;
		/////End	ADD_MESSAGE_BOX
//
	//}
	/////Joseph	12/07/06	ADD_MESSAGE_BOX
	////return true;
	//return handle_dialog_errmsg(tr, bShowErrMsg, _L(FREQ_MAX_STEP_ERROR_MSG), bOKEnable);;
	/////End	ADD_MESSAGE_BOX
//}
//
//double freq_step_size_type_num(TreeNode& tr)
//{
	//TreeNode trFreq = tr.Options;
	//double dMin, dMax, dStepSize, dStep;
	//double dNumInt = 5;
	//dMin = trFreq.FromMin.dVal;
	//dMax = trFreq.ToMax.dVal;
	//dStep = (dMax - dMin) / 5; 
	//if (trFreq.StepBy.nVal == 0)
		//return dStep;
	//else if (trFreq.StepBy.nVal == 1)
		//return dNumInt;	
//}
//
//bool freq_interval_type_event(TreeNode& tr, int nRows, int nTypes, Dialog& Dlg)
//{
	//TreeNode trFreq = tr.Options;
	//if (trFreq.StepBy.nVal == 0)
	//{
		//trFreq.IncrementSize.Show = 1;
		//trFreq.NumInterval.Show = 0;
	//}
	//else
	//{
		//trFreq.IncrementSize.Show = 0;
		//trFreq.NumInterval.Show = 1;		
	//}
	//
	//return true;
//}
//
//bool freq_num_interval_event(TreeNode& tr, int nRows, int nTypes, Dialog& Dlg)
//{
	//TreeNode trFreq = tr.Options;
	//double dNumInterval = trFreq.NumInterval.dVal;
	/////Joseph	12/07/06	ADD_MESSAGE_BOX
	//string	strErrMsg;
	//bool	bShowErrMsg = false;
	//bool	bOKEnable = true;
	/////End	ADD_MESSAGE_BOX
	//if ( dNumInterval < 0)
	//{
		/////Joseph	12/07/06	ADD_MESSAGE_BOX					
		////MessageBox(NULL, _L(FREQ_INTERVAL_NUM_ERROR_MSG), _L(ERROR_TITLE), MB_OK | MB_ICONSTOP);		
		////return false;
		//bShowErrMsg = true;
		//bOKEnable = false;
		/////End	ADD_MESSAGE_BOX
	//}
	//if ((dNumInterval - (int)dNumInterval) != 0)
	//{
		/////Joseph	12/07/06	ADD_MESSAGE_BOX					
		////MessageBox(NULL, _L(FREQ_INTERVAL_NUM_ERROR_MSG), _L(ERROR_TITLE), MB_OK | MB_ICONSTOP);		
		////return false;
		//bOKEnable = false;
		//bShowErrMsg = true;				
		/////End	ADD_MESSAGE_BOX
	//}
	/////Joseph	12/07/06	ADD_MESSAGE_BOX	
	////return true;
	//return handle_dialog_errmsg(tr, bShowErrMsg, _L(FREQ_INTERVAL_NUM_ERROR_MSG), bOKEnable);
	/////End	ADD_MESSAGE_BOX	
//}
//
///// Thomas 04/04/2006 ADD_FREQUENCY_COUNT_BINCENTER_AND_COUNT_EVENT
//bool on_frequency_count_bin_center_option_change(TreeNode& tr, int nRows, int nTypes, Dialog& Dlg)
//{
	//TreeNode tnBinCenter = tree_get_node(tr, nRows);
	//if(!tnBinCenter) return false;
	//
	//TreeNode tnCount = tree_get_node_by_id(tr, IDE_FC_COUNT, true);
	//if(!tnCount) return false;
	//
	//TreeNode tnHistogramsPlot = tree_get_node_by_id(tr, IDE_RESULT_GRAPHS, true);
	//if(!tnHistogramsPlot) return false;
	//
	//if(tnBinCenter.nVal && tnCount.nVal) 
		//tnHistogramsPlot.Enable = 1;
	//else {
		//tnHistogramsPlot.nVal = 0;
		//tnHistogramsPlot.Enable = 0;
	//}
	//
	//return true;
//}
//
//bool on_frequency_count_count_option_change(TreeNode& tr, int nRows, int nTypes, Dialog& Dlg)
//{
	//TreeNode tnCount = tree_get_node(tr, nRows);
	//if(!tnCount) return false;
	//
	//TreeNode tnBinCenter = tree_get_node_by_id(tr, IDE_FC_BIN_CENTER, true);
	//if(!tnBinCenter) return false;
	//
	//TreeNode tnHistogramsPlot = tree_get_node_by_id(tr, IDE_RESULT_GRAPHS, true);
	//if(!tnHistogramsPlot) return false;
	//
	//if(tnBinCenter.nVal && tnCount.nVal) 
		//tnHistogramsPlot.Enable = 1;
	//else {
		//tnHistogramsPlot.nVal = 0;
		//tnHistogramsPlot.Enable = 0;
	//}
	//
	//return true;
//}
///// End ADD_FREQUENCY_COUNT_BINCENTER_AND_COUNT_EVENT
//
//TreeNode ConstructFrequencyCountGUITree(TreeNode& tr, int nOption)
//{
	//GETN_USE(tr)
	//tree_construct_add_input_branch(tr, INPUTDATA_RANGES);
//
	////GETN_NAMED_TREE(tr, GUI)
	///// Iris 10/19/05 GUI_REMOVE_STATS because cannot auto update the values in stats branch according to input data
	////GETN_BEGIN_BRANCH(Stats, "Statistics")	GETN_ID_BRANCH(IDST_DESC_STATS_OPTIONS)
		////GETN_NUM(Mean, _L("Mean"), 0);	GETN_ID(IDE_MEAN)
		////GETN_NUM(SD, _L("Standard Deviation"), 0);	GETN_ID(IDE_SD)
		////GETN_NUM(N, _L("Size"), 0);	GETN_ID(IDE_SAMPLE_SIZE)
		////GETN_NUM(Median, _L("Median"), 0);	GETN_ID(IDE_MEDIAN)
	////GETN_END_BRANCH(Stats)
	/////End GUI_REMOVE_STATS
	//
	//GETN_BEGIN_BRANCH(Quantities, _L("Quantities to Compute"))	GETN_ID_BRANCH(IDST_QUANTILE_OPTIONS) 
		//GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
		//GETN_CHECK(BinCenter, _L("Bin Center"), true)	GETN_ID(IDE_FC_BIN_CENTER) GETN_OPTION_EVENT(on_frequency_count_bin_center_option_change) /// Thomas 04/04/2006 ADD_FREQUENCY_COUNT_BINCENTER_AND_COUNT_EVENT
		//GETN_CHECK(BinEnd, _L("Bin End"), true)	GETN_ID(IDE_FC_BIN_BOUND) 
		//GETN_CHECK(Count, _L("Count"), true)	GETN_ID(IDE_FC_COUNT) GETN_OPTION_EVENT(on_frequency_count_count_option_change) /// Thomas 04/04/2006 ADD_FREQUENCY_COUNT_BINCENTER_AND_COUNT_EVENT
		//GETN_CHECK(CumulaCount, _L("Cumulative Count"), true)	GETN_ID(IDE_FC_CUMUL_COUNT)
		//GETN_CHECK(RelFreq, _L("Relative Frequency"), true)	GETN_ID(IDE_FC_REL_FREQ)
		//GETN_CHECK(CumFreq, _L("Cumulative Frequency"), true)	GETN_ID(IDE_FC_CUMUL_FREQ)
	//GETN_END_BRANCH(Quantities)
		//
	//GETN_BEGIN_BRANCH(Options, _L("Computation Control"))	GETN_ID_BRANCH(IDST_FREQ_COUNT_OPTIONS)
		////GETN_INTERACTIVE(Range, "Data Range(s)", "<none>") ///Iris 11/01/04
		//GETN_NUM(FromMin, _L("From Minimum"), 0.0)	GETN_ID(IDE_FC_BIN_START)
		//GETN_NUM(ToMax, _L("To Maximum"), 1.0)	GETN_ID(IDE_FC_BIN_END)
		///// Nicole 07/05/2007 v8.0655 REMOVE_SPACE_FOR_LOCATION_STRING
		////GETN_LIST(StepBy ,_L("Step by"), 0, _L("Increment |Intervals"))	GETN_ID(IDE_FC_STEP_BY)	GETN_OPTION_EVENT(freq_interval_type_event)
		//GETN_LIST(StepBy ,_L("Step by"), 0, _L("Increment|Intervals"))	GETN_ID(IDE_FC_STEP_BY)	GETN_OPTION_EVENT(freq_interval_type_event)
		///// END REMOVE_SPACE_FOR_LOCATION_STRING
		//GETN_NUM(IncrementSize, _L("Increment Size"), freq_step_size_type_num(tr))	GETN_ID(IDE_FC_BIN_INC)	GETN_OPTION_EVENT(freq_counts_stepsize_event)
		//GETN_NUM(NumInterval, _L("Number of Intervals"), 5)	GETN_ID(IDE_FC_NUM_INTERVAL)	GETN_OPTION_EVENT(freq_num_interval_event)		
		//GETN_CHECK(IncludeLTMin, _L("Include Outliers < Minimum"), false)	GETN_ID(IDE_FC_OUTLIER_LT)
		//GETN_CHECK(IncludeGEMax, _L("Include Outliers >= Maximum"), false)	GETN_ID(IDE_FC_OUTLIER_GT)
	//GETN_END_BRANCH(Options)
	//
	//return tr;
//}
///*
//TreeNode ConstructFrequencyCountGUITree(int nOption)
//{
	//string strSelection = _L("<none>");
	//GETN_NAMED_TREE(tr, GUI)
	//GETN_INTERACTIVE(Range, "Data Range(s)", "<none>")
	//GETN_NUM(FromMin, _L("From Minimum"), 0.0)
	//GETN_NUM(ToMax, _L("To Maximum"), 1.0)
	//GETN_NUM(StepSize, _L("Step Size"), 0.05)
	//GETN_OPTION_EVENT(freq_counts_stepsize_event)
	//GETN_CHECK(IncludeLTMin, _L("Include Outliers < Minimum"), false)
	//GETN_CHECK(IncludeGEMax, _L("Include Outliers >= Maximum"), false)
	//return tr;
//}
//*/
///end NOT_USED_FUNCTION
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//////////                         Normality Test                       //////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
bool kolm_paras_events(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
{
	TreeNode trKolm = tr.OptionBranch.kolm;
	if (trKolm.Paras.nVal == 0)
	{
		trKolm.Mean.Show = 0;
		trKolm.Variance.Show = 0;
	}else
	{
		trKolm.Mean.Show = 1;
		trKolm.Variance.Show = 1;
	}
	
	return true;
}

TreeNode ConstructNormalityGUITree(TreeNode& tr, int nOption)
{
	GETN_USE(tr)
	tree_construct_add_input_branch(tr, INPUTDATA_RANGES);
	///Jasmine 09/15/06 SET_NORMALITYTEST_METHODS_BRANCH_NAME
	//as Max's require, it's suitable to be "Quantities to Compute"
	//GETN_BEGIN_BRANCH(OptionBranch, "Computation Control")	GETN_ID_BRANCH(IDST_NORM_TEST_CONTROL) GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
	GETN_BEGIN_BRANCH(OptionBranch, _L("Quantities to Compute"))	GETN_ID_BRANCH(IDST_NORM_TEST_CONTROL) GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
	///End SET_NORMALITYTEST_METHODS_BRANCH_NAME
		GETN_CHECK(shap-wilk, _L("Shapiro-Wilk"), true)		GETN_ID(IDE_NORM_SHAWILK)//Alex 06/05/06 REORDER_DESC_STATS_NORMALITY_DEFAULTGUI
		GETN_BEGIN_BRANCH(kolm,_L("Kolmogorov-Smirnov"))		GETN_CHECKBOX_BRANCH(0)	GETN_ID_BRANCH(IDST_KOLM_CONTROL)
			GETN_LIST(Paras, _L("Parameters"),0, _L("Estimated|Specified"))		GETN_ID(IDE_KOLM_PARAS)	GETN_OPTION_EVENT(kolm_paras_events)
			GETN_NUM(Mean, _L("Mean"), 0)		GETN_ID(IDE_KOLM_MEAN)	tr.OptionBranch.kolm.Mean.Show = 0;
			GETN_NUM(Variance, _L("Variance"), 1)		GETN_ID(IDE_KOLM_VAR)	tr.OptionBranch.kolm.Variance.Show = 0;
		GETN_END_BRANCH(kolm)
		GETN_CHECK(lilliefors, _L("Lilliefors"), false)		GETN_ID(IDE_NORM_LILLE)
		///Zeck 7/29/2011 ORG-3228-S4 NORMALITY_TEST_ADD_THREE_MORE_TESTS
		GETN_CHECK(Anderson, _L("Anderson-Darling"), false)	GETN_ID(IDE_NORM_ANDERSON)
		GETN_CHECK(DKsquared, _L("D'Agostino-K squared"), false)	GETN_ID(IDE_NORM_DKSQUARED)
		GETN_CHECK(Chen, _L("Chen-Shapiro"), false)		GETN_ID(IDE_NORM_CHEN)
		///END NORMALITY_TEST_ADD_THREE_MORE_TESTS
		//--- Jacky 07/22/10 ORG-102 USER_CAN_SET_SIGNIFICANCE_LEVEL
		GETN_NUM(alpha,_L("Significance Level"),0.05)	GETN_ID(IDE_TREE_ALPHA)
		//--- end USER_CAN_SET_SIGNIFICANCE_LEVEL
	//GETN_CHECK(shap-wilk, "Shapiro-Wilk", false)		GETN_ID(IDE_NORM_SHAWILK)//Alex 06/05/06 REORDER_DESC_STATS_NORMALITY_DEFAULTGUI
	GETN_END_BRANCH(OptionBranch) 	
	return tr;
}

//void GetNormalityTestParams()
//{
	//GETN_TREE(tr)
//
	//GETN_BUTTON(DataRange, "Data Range(s)", "Data1_A[1]:C[30]");
//
	//GETN_BEGIN_BRANCH(Options, "Options")
		//GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
		//GETN_CHECK(KolmogorovSmirnov, "Kolmogorov-Smirnov", false)
		//GETN_CHECK(Lilliefors, "Lilliefors", false)
		//GETN_CHECK(ShapiroWilk, "Shapiro-Wilk", false)
	//GETN_END_BRANCH(Options)
//
	//GetNBox(tr, "Normality Test", "Enter Normality Test parameters", ApplyOnClickPro);
//}


//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//////////                  One Sample t-Test for Means                 //////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
///Echo 10/26/07 NOT_USED_FUNCTION
///the feature has been done in XF. these code won't be used anymore
//
//BOOL DoOneSampletTestDialog(TreeNode &trGUI, BOOL bChangeParams)
//{
	//BOOL bOKClicked = GetNBox(trGUI, _L("One Sample t-Test"), _L("Enter One Sample t-Test parameters"));
	//return bOKClicked;
//}
//
///// *** Event to active the confidence intervals levels of mean when confidence level is check
//bool test_mean_conf_int_events(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
//{
	/////Iris 12/28/04 REMOVE_HOW_TO_COMPUTER_BRANCH
	////tr.QuanComp.ConfLevelsMean.Enable = tr.QuanComp.CalcConfInts.nVal;
	//tr.tTest.ConfLevelsMean.Enable = tr.tTest.CalcConfInts.nVal;
	/////end REMOVE_HOW_TO_COMPUTER_BRANCH
	//return true;
//}
///// *** Event to return error message if error confidence levels settings
//bool mean_conf_lev_error_msg_event(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
//{
	////TreeNode trTtest = tr.CompControl.tTest;
	/////Iris 12/28/04 REMOVE_HOW_TO_COMPUTER_BRANCH
	//TreeNode trTtest = tr.tTest;
	////int nCalcConfInts = tr.QuanComp.CalcConfInts.nVal;
	//int nCalcConfInts = trTtest.CalcConfInts.nVal;
	//vector vLevels;
	////string strLevels = trTtest.ConfLevels.strVal; 
	////string strLevels = tr.QuanComp.ConfLevelsMean.strVal;  ///Iris 12/02/04 COMBINE_QUANCOMP_AND_COMPCONTROL
	//string strLevels = trTtest.ConfLevelsMean.strVal;  ///Iris 12/28/04 REMOVE_HOW_TO_COMPUTER_BRANCH
	//
	/////Joseph	12/07/06	ADD_MESSAGE_BOX
	//bool	bShowErrMsg = false;
	//bool	bOKEnable = true;
	/////End	ADD_MESSAGE_BOX
	//
	//int nLevels = strLevels.GetTokens(vLevels, ' ');//put the confidence levels in vector
	//if (nCalcConfInts == 1)
	//{
		//for (int ii = 0; ii < nLevels; ii++)
		//{
			//if (vLevels[ii] < 0 || vLevels[ii] > 100)
			/////Joseph	12/07/06	ADD_MESSAGE_BOX
				////return error_msg_box(CER_CONF_LEVS);
			//{
				//bShowErrMsg = true;
				//bOKEnable = false;
				//break;
			//}
			/////End	ADD_MESSAGE_BOX
		//}
	//}
	/////Joseph	12/07/06	ADD_MESSAGE_BOX
	////return true;
	//return handle_dialog_errmsg(tr, bShowErrMsg, CER_INVALID_SIG_LEV, bOKEnable); ;
//}
//
///// *** Output hypothetical types list according to the hypothetical value
//string test_nullhypot_type(string strName, string strValue)
//{
	//vector<string> vHypotType(3);
	//string strOut;
	//vHypotType[0] = strName + _L(" <> ") + strValue;
	//vHypotType[1] = strName + _L(" > ") + strValue;
	//vHypotType[2] = strName + _L(" < ") + strValue;
	//strOut = vHypotType[0] + "|" + vHypotType[1] + "|" + vHypotType[2];
	//
	//return strOut;	
//}
//
///// *** Hypothetical types of mean change according to the hypothetical values 
///// *** Altnate hypothetival type of mean changes according to the null hypothetical types
//bool test_1sample_hypotmean_event(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
//{
	////Hypothetical types of mean change according to the hypothetical values
	/////Iris 12/28/04 REMOVE_HOW_TO_COMPUTER_BRANCH
	////TreeNode trHypot = tr.CompControl.tTest;
	//TreeNode trHypot = tr.tTest;
	//char szHypoValue[30];	
	//DoubleToStr(trHypot.HypotValue.dVal, szHypoValue, 30, "*");
	//string strNullHypType = test_nullhypot_type(_L("Mean"), szHypoValue);
	//trHypot.TailType.SetAttribute(STR_COMBO_ATTRIB, strNullHypType);
	//
	////Altnate hypothetival type of mean changes according to the null hypothetical types
	//if (trHypot.TailType.nVal == 0)	
		//trHypot.NulHypot.strVal = _L("Mean = ") + szHypoValue;
	//else if (trHypot.TailType.nVal == 1)	
		//trHypot.NulHypot.strVal = _L("Mean <= ") + szHypoValue;
	//else if (trHypot.TailType.nVal == 2)
		//trHypot.NulHypot.strVal = _L("Mean >= ") + szHypoValue;
	//
	//return true;
//}
//
//
///// *** Hypothetical types of variance change according to the hypothetical values 
///// *** Altnate hypothetival type of variance changes according to the null hypothetical types
//bool test_1sample_hypotvar_event(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
//{
	/////Iris 12/28/04 REMOVE_HOW_TO_COMPUTER_BRANCH	
	////TreeNode trHypot = tr.CompControl.ChiSquareTest;
	//TreeNode trHypot = tr.ChiSquareTest;
//
	////Bring up error message if the hypothetical variance value is set as 0
	//double dHypotValue = trHypot.HypotValue.dVal;
	//
	/////Joseph	12/07/06	ADD_MESSAGE_BOX
	//bool	bShowErrMsg = false;
	//bool	bOKEnable = true;
	/////End	ADD_MESSAGE_BOX
	//
	//if (dHypotValue <= 0)
	//{
		/////Joseph	12/07/06	ADD_MESSAGE_BOX
		////MessageBox(NULL, _L(CHI_SQR_HYPOT_VAL_ERROR_MSG), _L(ERROR_TITLE), MB_OK | MB_ICONSTOP);		
		////return false;
		//bShowErrMsg = true;		
		//bOKEnable = false;
		/////End	ADD_MESSAGE_BOX	
	//}
	//
	////Hypothetical types of variance change according to the hypothetical values
	//char szHypoValue[30];	
	//DoubleToStr(trHypot.HypotValue.dVal, szHypoValue, 30, "*");
	//string strNullHypType = test_nullhypot_type(_L("Variance"), szHypoValue);
	//trHypot.TailType.SetAttribute(STR_COMBO_ATTRIB, strNullHypType);
//
	////Altnate hypothetival type of variance changes according to the null hypothetical types
	//
	//
	//if (trHypot.TailType.nVal == 0)	
		//trHypot.NulHypot.strVal = _L("Variance = ") + szHypoValue;
	//else if (trHypot.TailType.nVal == 1)	
		//trHypot.NulHypot.strVal = _L("Variance <= ") + szHypoValue;
	//else if (trHypot.TailType.nVal == 2)
		//trHypot.NulHypot.strVal = _L("Variance >= ") + szHypoValue;
	//
	/////Joseph	12/07/06	ADD_MESSAGE_BOX
	////return true;
	//return handle_dialog_errmsg(tr, bShowErrMsg, _L(CHI_SQR_HYPOT_VAL_ERROR_MSG), bOKEnable); 
	/////End	ADD_MESSAGE_BOX
//}
//
///// *** Event to active the confidence intervals levels of variance when confidence level is check
//bool test_var_conf_int_events(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
//{
	/////Iris 12/28/04 REMOVE_HOW_TO_COMPUTER_BRANCH
	////tr.QuanComp.ConfLevelsVar.Enable = tr.QuanComp.ConfiInterOfVar.nVal;
	//tr.ChiSquareTest.ConfLevelsVar.Enable = tr.ChiSquareTest.ConfiInterOfVar.nVal;	
	//return true;
//}
//
///// *** Event to return error message if error confidence levels settings
//bool var_conf_lev_error_msg_event(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
//{
	/////Iris 12/28/04 REMOVE_HOW_TO_COMPUTER_BRANCH
	////int nCalcConfInts = tr.QuanComp.ConfiInterOfVar.nVal;
	//int nCalcConfInts = tr.ChiSquareTest.ConfiInterOfVar.nVal;
	//vector vLevels;
	////string strLevels = tr.CompControl.ChiSquareTest.ConfLevels.strVal; /// Iris 12/02/04 COMBINE_QUANCOMP_AND_COMPCONTROL
	////string strLevels = tr.QuanComp.ConfLevelsVar.strVal;
	//string strLevels = tr.ChiSquareTest.ConfLevelsVar.strVal;
	//int nLevels = strLevels.GetTokens(vLevels, ' ');//put the confidence levels in vector
	/////Joseph	12/07/06	ADD_MESSAGE_BOX
	//bool	bShowErrMsg = false;
	//bool	bOKEnable = true;
	/////End	ADD_MESSAGE_BOX
	//if (nCalcConfInts == 1)
	//{
		//for (int ii = 0; ii < nLevels; ii++)
		//{
			//if (vLevels[ii] < 0 || vLevels[ii] > 100)
			//{		
				/////Joseph	12/07/06	ADD_MESSAGE_BOX
				////return error_msg_box(CER_CONF_LEVS);
				//bShowErrMsg = true;
				//bOKEnable = false;
				/////End	ADD_MESSAGE_BOX			
			//}
		//}//loop all confidence levels
	//}//if confidence intervals check box is selected	
	/////Joseph	12/07/06	ADD_MESSAGE_BOX
	////return true;
	//return handle_dialog_errmsg(tr, bShowErrMsg, CER_INVALID_SIG_LEV, bOKEnable);
	/////End	ADD_MESSAGE_BOX
//}
//
//
/////Iris 12/28/04 REMOVE_HOW_TO_COMPUTER_BRANCH
///*
//// *** Show Power values input when sample size is selected
//// *** Show sample sizes input when power is selected
//bool test_power_events(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
//{
	//TreeNode trPower = tr.PowerBranch;
	//trPower.HypotSizes.Enable = trPower.CalcHypotPower.nVal; 
	//return true;	
//}
//*/
///end NOT_USED_FUNCTION
///// *** Event to return error message if error sample size settings
//bool sample_size_error_msg_event(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
bool sample_size_error_msg_event(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg)
{
	///Iris 12/28/04 REMOVE_HOW_TO_COMPUTER_BRANCH
	//bool bCalcHypotPower = tr.QuanComp.Power.HypotPower.nVal;
	bool bCalcHypotPower = tr.PowerBranch.HypotPower.nVal;
	///Joseph	12/07/06	ADD_MESSAGE_BOX
	bool	bOKEnable = true;
	bool	bShowErrMsg = false;
	///End	ADD_MESSAGE_BOX
	if (bCalcHypotPower && !(dwCntrl & GETNEVENT_ON_INIT))
	{
		///Echo 6/27/06 REPLACE_WITH_GLOBAL_FUNC
		if (!check_sample_size(tr.PowerBranch.HypotSizes.strVal))
		///Joseph	12/07/06	ADD_MESSAGE_BOX
			//return error_msg_box(CER_SAMP_SIZES)
		{
			bShowErrMsg = true;
			bOKEnable = false;
		}
		//return false;
		///End	ADD_MESSAGE_BOX
	}
		
		////string strSampSize = tr.CompControl.PowerBranch.HypotSizes.strVal; /// Iris 12/02/04 COMBINE_QUANCOMP_AND_COMPCONTROL
		////string strSampSize = tr.QuanComp.Power.HypotSizes.strVal; ///Iris 12/28/04 REMOVE_HOW_TO_COMPUTER_BRANCH
		//string strSampSize = tr.PowerBranch.HypotSizes.strVal; 
		//vector vSampSize;
		//int nSampSize = strSampSize.GetTokens(vSampSize, ' ');//put the confidence levels in vector
		//
		//for (int ii = 0; ii < nSampSize; ii++)
		//{
			//if (vSampSize[ii] < 0 || ((vSampSize[ii] - (int)vSampSize[ii]) != 0))
			//{
				//MessageBox(NULL, _L(SAMP_SIZE_ERROR_MSG), _L(ERROR_TITLE), MB_OK | MB_ICONSTOP);		
				//return false;
			//}//if the sample size does not fit constraints, return error
			/////Echo 11/26/04 V8.0167 QA70-7074	ADD_NEW_CONSTRAIN
			//if (vSampSize[ii] <= 1)
			//{
				//MessageBox(NULL, _L(SAMP_SIZE_TOO_FEW_MSG), _L(ERROR_TITLE), MB_OK | MB_ICONSTOP);		
				//return false;
			//}//if the sample size does not fit constraints, return error
			/////END	ADD_NEW_CONSTRAIN
		//}//loop all sample sizes		
	//}//if Power computation is selected
	///end REPLACE_WITH_GLOBAL_FUNC
	
	///Joseph	12/07/06	ADD_MESSAGE_BOX
	//return true;
	return handle_dialog_errmsg(tr, bShowErrMsg, CER_INVALID_SIG_LEV, bOKEnable); ;
	///End	ADD_MESSAGE_BOX
}
///Echo 10/26/07 NOT_USED_FUNCTION
///the feature has been done in XF. these code won't be used anymore
/////Iris 12/28/04 REMOVE_HOW_TO_COMPUTER_BRANCH
///*
///// *** Event to return error message if error sample size settings
//bool pow_val_error_msg_event(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
//{
	//TreeNode trTtest = tr.CompControl.PowerBranch;
	//int nCalcHypotPower = trTtest.CalcHypotPower.nVal;
	//vector vPowVal;
	//string strPowVal = trTtest.PowerValues.strVal; 
	//int nPowVal = strPowVal.GetTokens(vPowVal, ' ');//put the confidence levels in vector
	//if (nCalcHypotPower == 2)
	//{
		//for (int ii = 0; ii < nPowVal; ii++)
		//{
			//if (vPowVal[ii] < 0 || vPowVal[ii] > 1)
			//{
				//MessageBox(NULL, _L(POW_VAL_ERROR_MSG), _L(ERROR_TITLE), MB_OK | MB_ICONSTOP);		
				//return false;
			//}//if the sample size does not fit constraints, return error
		//}//loop all sample sizes
	//}//if Power computation is selected
	//
	//return true;
	//
//}
//*/
///end NOT_USED_FUNCTION
/// Iris 06/27/06 TO_NOT_ALLOW_SHOW_ERR_FOR_INIT_TIME
//bool siglevel_error_msg_event(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
bool siglevel_error_msg_event(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg)
{
	TreeNode 	trSigLevel = tree_get_node(tr, nRow);
	double 		dSigLevel = trSigLevel.dVal;
	///Joseph	12/07/06	ADD_MESSAGE_BOX
	bool	bShowErrMsg = false;
	bool	bOKEnable = true;
	///End	ADD_MESSAGE_BOX
	///Echo 7/12/06 REPLACE_WITH_GLOBAL_FUNC
	if(!(dwCntrl & GETNEVENT_ON_INIT) && !check_sig_level(dSigLevel))
	///Joseph	12/07/06	ADD_MESSAGE_BOX
		//error_msg_box(CER_INVALID_SIG_LEV);
	{
		bShowErrMsg = true;
		bOKEnable = false;
	}
	
	///End	ADD_MESSAGE_BOX
	/// Iris 06/27/06 TO_NOT_ALLOW_SHOW_ERR_FOR_INIT_TIME
	////if (dSigLevel < 0 || dSigLevel > 1) 
		////MessageBox(NULL, _L(SIG_LEV_ERROR_MSG), _L(ERROR_TITLE), MB_OK | MB_ICONSTOP);
	//if(!(dwCntrl & GETNEVENT_ON_INIT) && (dSigLevel < 0 || dSigLevel > 1))
		//error_msg_box(CER_INVALID_SIG_LEV);
	/////End TO_NOT_ALLOW_SHOW_ERR_FOR_INIT_TIME
	///END REPLACE_WITH_GLOBAL_FUNC
	///Joseph	12/07/06	ADD_MESSAGE_BOX
	//return true;
	return handle_dialog_errmsg(tr, bShowErrMsg, CER_INVALID_SIG_LEV, bOKEnable);;
	///End ADD_MESSAGE_BOX
}

///Echo 10/26/07 NOT_USED_FUNCTION
///the feature has been done in XF. these code won't be used anymore
//bool ChiSquareTest_enable_event(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
//{
	//tr.CompControl.ChiSquareTest.Show = tr.QuanComp.ChiSqrTest.nVal;
	//tr.QuanComp.ConfiInterOfVar.Enable = tr.QuanComp.ChiSqrTest.nVal;   ///Iris 11/08/04
	/////Echo 11/26/04
	//if (0 == tr.QuanComp.ChiSqrTest.nVal)
		//if (1 == tr.QuanComp.ConfiInterOfVar.nVal)
		//{
			//tr.QuanComp.ConfiInterOfVar.nVal = 0;
			//tr.QuanComp.ConfLevelsVar.Enable = tr.QuanComp.ChiSqrTest.nVal;
		//}
	//return true;	
//}
///end NOT_USED_FUNCTION
bool siglevel_enable_event(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
{	
	///Iris 12/28/04 REMOVE_HOW_TO_COMPUTER_BRANCH
	//bool bActualPower = tr.PowerBranch.ActPower.nVal; 
	bool bActualPower = tr.PowerBranch.ActualPower.nVal; ///Arvin 09/27/07 ACTUAL_POWER_SHOULD_ALSO_SUPPORT_SIGLEVEL as Echo said
	bool bHypotPower = tr.PowerBranch.HypotPower.nVal;
	bool bSigLevel = false;
	///Arvin 09/27/07 ACTUAL_POWER_SHOULD_ALSO_SUPPORT_SIGLEVEL as Echo said
	if( bActualPower || bHypotPower)  ///Iris 12/28/04 REMOVE_HOW_TO_COMPUTER_BRANCH
	//if( bHypotPower )
	///end ACTUAL_POWER_SHOULD_ALSO_SUPPORT_SIGLEVEL
	 	bSigLevel = 1;
	 tr.PowerBranch.SigLevel.Enable = bSigLevel;
	return true;	
}		

bool power_enable_event(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
{
	//tr.CompControl.PowerBranch.Show = tr.QuanComp.Power.nVal;
	//tr.CompControl.PowerBranch.Show = tr.QuanComp.Power.HypotPower.nVal;  //Iris 11/08/04
	//tr.QuanComp.Power.HypotSizes.Show = tr.QuanComp.Power.HypotPower.nVal;  /// Iris 12/02/04 COMBINE_QUANCOMP_AND_COMPCONTROL
	tr.PowerBranch.HypotSizes.Enable  = tr.PowerBranch.HypotPower.nVal;
	
	siglevel_enable_event(tr, nRow, nType, Dlg);
	
	return true;	
	
}
///Echo 10/26/07 NOT_USED_FUNCTION
///the feature has been done in XF. these code won't be used anymore
/////Iris 12/28/04 REMOVE_HOW_TO_COMPUTER_BRANCH
///*
//TreeNode ConstructOneSampletTestGUITree(TreeNode& tr, int nOption)
//{
	//GETN_USE(tr)
	//tree_construct_add_input_branch(tr, INPUTDATA_RANGES);
//
	//GETN_BEGIN_BRANCH(QuanComp, "Quantities to Compute")
		//GETN_CHECK(ChiSqrTest, "Chi-Square Test for Variance", false)
		//GETN_OPTION_EVENT(ChiSquareTest_enable_event)
		//
		//GETN_CHECK(CalcConfInts,"Confidence Intervals of Mean", false)
		//GETN_OPTION_EVENT(test_mean_conf_int_events)
		//GETN_STR(ConfLevelsMean, "Confidence Level(s) in %", "90 95 99")  GETN_READ_ONLY  /// Iris 12/02/04 COMBINE_QUANCOMP_AND_COMPCONTROL
		//GETN_OPTION_EVENT(mean_conf_lev_error_msg_event)
		//
		//GETN_CHECK(ConfiInterOfVar,"Confidence Intervals of Variance", false) GETN_READ_ONLY
		//GETN_OPTION_EVENT(test_var_conf_int_events)
		//GETN_STR(ConfLevelsVar, "Confidence Level(s) in %", "90 95 99")  /// Iris 12/02/04 COMBINE_QUANCOMP_AND_COMPCONTROL
		//GETN_OPTION_EVENT(var_conf_lev_error_msg_event)
		//
		//GETN_BEGIN_BRANCH(Power, "Power")
			//GETN_CHECK(ActPower, "Actual Power", false)
			//GETN_OPTION_EVENT(siglevel_enable_event)			
			//GETN_CHECK(HypotPower, "Powers for Hypothetical Sample Sizes", false)
			//GETN_OPTION_EVENT(power_enable_event)
			//GETN_STR(HypotSizes, "Hypothetical Sample Size(s)", "50 100 200")  /// Iris 12/02/04 COMBINE_QUANCOMP_AND_COMPCONTROL	
			//GETN_OPTION_EVENT(sample_size_error_msg_event)
		//GETN_END_BRANCH(Power)
	//GETN_END_BRANCH(QuanComp)
//
	//GETN_BEGIN_BRANCH(CompControl, "Computation Control")
	//
		//GETN_NUM(SigLevel, "Significace Level", 0.05)  GETN_READ_ONLY
		//GETN_OPTION_EVENT(siglevel_error_msg_event)
			//
		//GETN_BEGIN_BRANCH(tTest, "t-Test for Mean")
			//GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
			////tr.CompControl.tTest.Show = 0;
			//GETN_NUM(HypotValue,"Test Mean", 0)
			//GETN_OPTION_EVENT(test_1sample_hypotmean_event)
			//GETN_LIST(TailType, "Null Hypothesis",0, "Mean = 0|Mean > 0|Mean < 0")
			//GETN_OPTION_EVENT(test_1sample_hypotmean_event)
			//GETN_STR(AltHypot, "Alternate Hypothesis", "Mean <> 0")  GETN_READ_ONLY
			////GETN_CHECK(CalcConfInts, "Confidence Interval(s) of Mean" ,false)	
			////GETN_OPTION_EVENT(test_mean_conf_int_events)
			////GETN_STR(ConfLevels, "Confidence Level(s) in %", "90 95 99")  GETN_READ_ONLY  /// Iris 12/02/04 COMBINE_QUANCOMP_AND_COMPCONTROL
			////GETN_OPTION_EVENT(mean_conf_lev_error_msg_event)
		//GETN_END_BRANCH(tTest)
		//
		//GETN_BEGIN_BRANCH(ChiSquareTest, "Chi-Square Test for Variance")//	GETN_CHECKBOX_BRANCH(0)
			//GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
			//tr.CompControl.ChiSquareTest.Show = 0;
			//GETN_NUM(HypotValue, "Test Variance", 1)
			////tr.ChiSquareTest.HypotValue.Enable = 0;
			//GETN_OPTION_EVENT(test_1sample_hypotvar_event)
			//GETN_LIST(TailType, "Null Hypothesis",0, "Variance = 1|Variance > 1|Variance <1")
			//GETN_OPTION_EVENT(test_1sample_hypotvar_event)
			//GETN_STR(AltHypot, "Alternate Hypothesis", "Variance <> 1")  GETN_READ_ONLY
			////GETN_CHECK(CalcConfInts, "Confidence Interval(s) of Variance", false)
			////GETN_OPTION_EVENT(test_var_conf_int_events)
			////GETN_STR(ConfLevels, "Confidence Level(s) in %", "90 95 99")  /// Iris 12/02/04 COMBINE_QUANCOMP_AND_COMPCONTROL
			////GETN_OPTION_EVENT(var_conf_lev_error_msg_event)
		//GETN_END_BRANCH(ChiSquareTest)
	//
		///// Iris 12/02/04 COMBINE_QUANCOMP_AND_COMPCONTROL
		////GETN_BEGIN_BRANCH(PowerBranch, "Power Analysis")	//GETN_CHECKBOX_BRANCH(0)
			////GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
			////tr.CompControl.PowerBranch.Show = 0;
			//////GETN_OPTION_EVENT(power_branch_open)
			//////GETN_NUM(SigLevel, "Significace Level", 0.05)
			//////GETN_OPTION_EVENT(siglevel_error_msg_event)
			//////GETN_CHECK(CalcHypotPower, "Hypothetical Power", false)
			//////GETN_OPTION_EVENT(test_power_events)
			////GETN_STR(HypotSizes, "Hypothetical Sample Size(s)", "50 100 200")	
			////GETN_OPTION_EVENT(sample_size_error_msg_event)
		////GETN_END_BRANCH(PowerBranch)
		/////End COMBINE_QUANCOMP_AND_COMPCONTROL
		//
	//GETN_END_BRANCH(CompControl)
//
	//return tr;
//}
//*/
//TreeNode ConstructOneSampletTestGUITree(TreeNode& tr, int nOption)
//{
	//GETN_USE(tr)
	//tree_construct_add_input_branch(tr, INPUTDATA_RANGES);
//
	//GETN_BEGIN_BRANCH(tTest, _L("t-Test for Mean"))	GETN_ID_BRANCH(IDST_TTEST_CONTROL)	GETN_ID_REPEAT_BRANCH(IDRS_TTEST_CONTROL) GETN_OPTION_BRANCH(GETNBRANCH_OPEN) 
		//GETN_NUM(HypotValue,_L("Test Mean"), 0)	GETN_ID(IDE_TEST_VALUE)	GETN_OPTION_EVENT(test_1sample_hypotmean_event)
		////GETN_LIST(NullHypot, "Null Hypothesis",0, "Mean = 0|Mean > 0|Mean < 0")
		//GETN_STR(NulHypot, _L("Null Hypothesis"), _L("Mean = 0"));	GETN_ID(IDE_ALTHYPOT)	tr.tTest.NulHypot.Enable = 0;
		//GETN_LIST(TailType, _L("Alternate Hypothesis"),0, _L("Mean <> 0|Mean > 0|Mean < 0"))	GETN_ID(IDE_TAIL_TYPE)	
		//GETN_OPTION_EVENT(test_1sample_hypotmean_event)
		//GETN_CHECK(CalcConfInts, _L("Confidence Interval(s) of Mean") ,false)	GETN_ID(IDE_CONF_INTER_MEAN)	GETN_OPTION_EVENT(test_mean_conf_int_events)
		////GETN_STR(ConfLevels, "Confidence Level(s) in %", "90 95 99")	
		//GETN_STR(ConfLevelsMean, _L("Confidence Level(s) in %"), "90 95 99")	GETN_ID(IDE_CONF_LEVEL_MEAN)	GETN_OPTION_EVENT(mean_conf_lev_error_msg_event)
	//GETN_END_BRANCH(tTest)
	//
	//GETN_BEGIN_BRANCH(ChiSquareTest, _L("Chi-Square Test for Variance"))	GETN_CHECKBOX_BRANCH(0)	GETN_ID_BRANCH(IDST_CHISQ_CONTROL) GETN_ID_REPEAT_BRANCH(IDRS_CHISQ_CONTROL)
		//GETN_NUM(HypotValue, _L("Test Variance"), 1)	GETN_ID(IDE_TEST_VALUE)	GETN_OPTION_EVENT(test_1sample_hypotvar_event)
		////tr.ChiSquareTest.HypotValue.Enable = 0;	
		////GETN_LIST(NullHypot, "Null Hypothesis",0, "Variance = 1|Variance > 1|Variance <1")
		//GETN_STR(NulHypot, _L("Null Hypothesis"), _L("Variance <> 1"))	GETN_ID(IDE_ALTHYPOT)	tr.ChiSquareTest.NulHypot.Enable = 0;
		//GETN_LIST(TailType, _L("Alternate Hypothesis"),0, _L("Variance = 1|Variance > 1|Variance <1"))	GETN_ID(IDE_TAIL_TYPE)	
		//GETN_OPTION_EVENT(test_1sample_hypotvar_event)
		////GETN_CHECK(CalcConfInts, "Confidence Interval(s) of Variance", false)
		//GETN_CHECK(ConfiInterOfVar, _L("Confidence Interval(s) of Variance"), false)	GETN_ID(IDE_CONF_INTER_VAR)	GETN_OPTION_EVENT(test_var_conf_int_events)
		////GETN_STR(ConfLevels, "Confidence Level(s) in %", "90 95 99")
		//GETN_STR(ConfLevelsVar, _L("Confidence Level(s) in %"), "90 95 99")	GETN_ID(IDE_CONF_LEVEL_VAR)	GETN_OPTION_EVENT(var_conf_lev_error_msg_event)
	//GETN_END_BRANCH(ChiSquareTest)
//
	//GETN_BEGIN_BRANCH(PowerBranch, _L("Power Analysis"))	GETN_CHECKBOX_BRANCH(0)	GETN_ID_BRANCH(IDST_POWER_CONTROL)
		////GETN_CHECK(ActPower, "Actual Power", false)
		////GETN_OPTION_EVENT(siglevel_enable_event)			
		//GETN_CHECK(HypotPower, _L("Hypothetical Power"), false)	GETN_ID(IDE_POWERS_HYPOT)	GETN_OPTION_EVENT(power_enable_event)
		//GETN_NUM(SigLevel, _L("Significance Level"), 0.05)	GETN_ID(IDE_POWERS_ALPHA)	
		///// Iris 06/27/06 TO_NOT_ALLOW_SHOW_ERR_FOR_INIT_TIME
		////GETN_OPTION_EVENT(siglevel_error_msg_event) 
		//GETN_OPTION_EVENT_EX(siglevel_error_msg_event)
		/////End TO_NOT_ALLOW_SHOW_ERR_FOR_INIT_TIME
		//GETN_STR(HypotSizes, _L("Hypothetical Sample Size(s)"), "50 100 200") GETN_READ_ONLY	GETN_ID(IDE_POWERS_SAMPSIZE)	GETN_OPTION_EVENT_EX(sample_size_error_msg_event)		
	//GETN_END_BRANCH(PowerBranch)
//
	//return tr;
//}
/////end REMOVE_HOW_TO_COMPUTER_BRANCH
//
///*	
//TreeNode ConstructOneSampletTestGUITree(int nOption)
//{
////	GETN_NAMED_TREE(tr, GUI)
	//GETN_OPERATION(tr)
	//GETN_INTERACTIVE(InputDataRange, "Data Ranges(s)", "")
	//GETN_INTERACTIVE(Grouping, "Grouping", "")
//
	//GETN_BEGIN_BRANCH(tTest, "t-Test for Mean")
		//GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
		//GETN_NUM(HypotValue,"Test Mean", 0)
		//GETN_LIST(TailType, "Type of Tail", 0, "Two-tailed|Upper tailed|Lower tailed")
		//GETN_STR(NullHypot, "Null Hypothesis", "Mean   = 0")
		//GETN_STR(AltHypot, "Alternate Hypothesis", "Mean <> 0")
		//GETN_CHECK(CalcConfInts, "Confidence Interval(s)", false)
		//GETN_STR(ConfLevels, "Confidence Level(s) in %", "90 95 99")
		//GETN_NUM(SigLevel, "Significance Level", 0.05)
	//GETN_END_BRANCH(tTest)
//
	//GETN_BEGIN_BRANCH(ChiSquareTest, "Chi-Square Test for Variance")
		//GETN_CHECK(CalcVarTest, "Chi-Square Test", false)
		//GETN_NUM(HypotValue, "Test Variance", 0)
		//GETN_LIST(TailType, "Type of Tail", 0, "Two-tailed|Upper tailed|Lower tailed")
		//GETN_STR(NullHypot, "Null Hypothesis", "Variance   = 1")
		//GETN_STR(AltHypot, "Alternate Hypothesis", "Variance <> 1")
		//GETN_CHECK(CalcConfInts, "Confidence Interval(s)", false)
		//GETN_STR(ConfLevels, "Confidence Level(s) in %", "90 95 99")
		//GETN_NUM(SigLevel, "Significance Level", 0.05)
	//GETN_END_BRANCH(ChiSquareTest)
//
	//GETN_BEGIN_BRANCH(PowerBranch, "Power Analysis")
		//GETN_CHECK(CalcPower, "Actual Power", false)
		//GETN_CHECK(CalcHypotPower, "Hypothetical Power", false)
		//GETN_STR(HypotSizes, "Hypothetical Sample Size(s)", "50 100 200")
		//GETN_NUM(SigLevel, "Significace Level", 0.05)
	//GETN_END_BRANCH(PowerBranch)
//
	//return tr;
//}
//*/
///end NOT_USED_FUNCTION

//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//////////                  Two Sample t-Test for Means                 //////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
///Echo 10/26/07 NOT_USED_FUNCTION
///the feature has been done in XF. these code won't be used anymore
//BOOL DoTwoSampletTestDialog(TreeNode &trGUI, BOOL bChangeParams)
//{
	//BOOL bOKClicked = GetNBox(trGUI, _L("Two Sample t-Test"), _L("Enter Two Sample t-Test parameters"));
//
	//return bOKClicked;
//}
//
///// *** Hypothetical types of mean change according to the hypothetical values 
///// *** Altnate hypothetival type of mean changes according to the null hypothetical types
//bool test_2sample_hypotmean_event(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
//{
	/////Iris 12/28/04 REMOVE_HOW_TO_COMPUTER_BRANCH
	////TreeNode trHypot = tr.CompControl.tTest;
	//TreeNode trHypot = tr.tTest;
	//char szHypoValue[30];	
	//DoubleToStr(trHypot.HypotValue.dVal, szHypoValue, 30, "*");
	//
	//string strNullHypType = test_nullhypot_type(_L("Mean1 - Mean2"), szHypoValue);
	//trHypot.TailType.SetAttribute(STR_COMBO_ATTRIB, strNullHypType);
	//
	//if (trHypot.TailType.nVal == 0)	
		//trHypot.NulHypot.strVal = _L("Mean1 - Mean2  = ") + szHypoValue;
	//else if (trHypot.TailType.nVal == 1)	
		//trHypot.NulHypot.strVal = _L("Mean1 - Mean2 <= ") + szHypoValue;
	//else if (trHypot.TailType.nVal == 2)
		//trHypot.NulHypot.strVal = _L("Mean1 - Mean2 >= ") + szHypoValue;
	//
	//return true;
//}
//
///// *** Hypothetical types of variance change according to the hypothetical values 
///// *** Altnate hypothetival type of variance changes according to the null hypothetical types
//bool test_2sample_hypotvar_event(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
//{
	/////Iris 12/28/04 REMOVE_HOW_TO_COMPUTER_BRANCH
	////TreeNode trHypot = tr.CompControl.ChiSquareTest;
	//TreeNode trHypot = tr.ChiSquareTest;
		//
	//char szHypoValue[30];	
	//DoubleToStr(trHypot.HypotValue.dVal, szHypoValue, 30, "*");
	//if (trHypot.TailType.nVal == 0)	
		//trHypot.NulHypot.strVal = _L("Variance1 / Variance2 = ") + szHypoValue;
	//else if (trHypot.TailType.nVal == 1)	
		//trHypot.NulHypot.strVal = _L("Variance1 / Variance2 <= ") + szHypoValue;
	//else if (trHypot.TailType.nVal == 2)
		//trHypot.NulHypot.strVal = _L("Variance1 / Variance2 >= ") + szHypoValue;
	//
	//return true;
//}
//
/////Iris 12/28/04 REMOVE_HOW_TO_COMPUTER_BRANCH
///*
//TreeNode ConstructTwoSampletTestGUITree(TreeNode& tr, int nOption)
//{
	//GETN_USE(tr)
	//tree_construct_add_input_branch(tr, INPUTDATA_RANGES);
//
	//GETN_BEGIN_BRANCH(QuanComp, "Quantities to Compute")
		//GETN_CHECK(ChiSqrTest, "Chi Square Test", false)
		//GETN_OPTION_EVENT(ChiSquareTest_enable_event)
		//
		//GETN_CHECK(CalcConfInts, "Confidence Intervals for Difference of Means", false)
		//GETN_OPTION_EVENT(test_mean_conf_int_events)	
		//GETN_STR(ConfLevelsMean, "Confidence Level(s) in %", "90 95 99")  /// Iris 12/02/04 COMBINE_QUANCOMP_AND_COMPCONTROL	
		//GETN_OPTION_EVENT(mean_conf_lev_error_msg_event)
		//
		//GETN_CHECK(ConfiInterOfVar, "Confidence Intervals for Difference of Variances", false)  GETN_READ_ONLY
		//GETN_OPTION_EVENT(test_var_conf_int_events)
		//GETN_STR(ConfLevelsVar, "Confidence Level(s) in %", "90 95 99")  GETN_READ_ONLY/// Iris 12/02/04 COMBINE_QUANCOMP_AND_COMPCONTROL	
		//GETN_OPTION_EVENT(var_conf_lev_error_msg_event)
		//
		//GETN_BEGIN_BRANCH(Power, "Power")
			//GETN_CHECK(ActPower, "Actual Power", false)
			//GETN_OPTION_EVENT(siglevel_enable_event)			
			//GETN_CHECK(HypotPower, "Powers for Hypothetical Sample Sizes", false)
			//GETN_OPTION_EVENT(power_enable_event)
			//GETN_STR(HypotSizes, "Hypothetical Sample Size(s)", "50 100 200")/// Iris 12/02/04 COMBINE_QUANCOMP_AND_COMPCONTROL	 
			//GETN_OPTION_EVENT(sample_size_error_msg_event)
		//GETN_END_BRANCH(Power)
	//GETN_END_BRANCH(QuanComp)
//
	//GETN_BEGIN_BRANCH(CompControl, "Computation Control")	
		//GETN_NUM(SigLevel, "Significace Level", 0.05)  GETN_READ_ONLY
		//GETN_OPTION_EVENT(siglevel_error_msg_event)
//
		//GETN_BEGIN_BRANCH(tTest, "t-Test for Mean")
			//GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
			//GETN_LIST(TestType, "Test Type", 0, "Independent|Paired")			
			//GETN_NUM(HypotValue,"Test Difference", 0)
			//GETN_OPTION_EVENT(test_2sample_hypotmean_event)			
			//GETN_LIST(TailType, "Null Hypothesis",0, "Mean = 0|Mean > 0|Mean < 0")
			//GETN_OPTION_EVENT(test_2sample_hypotmean_event)
			//GETN_STR(AltHypot, "Alternate Hypothesis", "Mean <> 0") GETN_READ_ONLY
			////tr.CompControl.tTest.AltHypot.Enable = 0;
			////GETN_CHECK(CalcConfInts, "Confidence Interval(s) of Mean" ,false)	/// Iris 12/02/04 COMBINE_QUANCOMP_AND_COMPCONTROL	 
			////GETN_OPTION_EVENT(test_mean_conf_int_events)
		//GETN_END_BRANCH(tTest)
		//
		//GETN_BEGIN_BRANCH(ChiSquareTest, "Chi-Square Test for Variance") //	GETN_CHECKBOX_BRANCH(0)
			//GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
			//GETN_NUM(HypotValue, "Test Difference", 1)
			//GETN_OPTION_EVENT(test_2sample_hypotvar_event)
			//GETN_LIST(TailType, "Null Hypothesis",0, "Variance = 1|Variance > 1|Variance <1")
			//GETN_OPTION_EVENT(test_2sample_hypotvar_event)
			//GETN_STR(AltHypot, "Alternate Hypothesis", "Variance <> 1") GETN_READ_ONLY
			////tr.CompControl.ChiSquareTest.AltHypot.Enable = 0;
			////GETN_CHECK(CalcConfInts, "Confidence Interval(s) of Variance", false)
			////GETN_OPTION_EVENT(test_var_conf_int_events)
			////GETN_STR(ConfLevels, "Confidence Level(s) in %", "90 95 99")  /// Iris 12/02/04 COMBINE_QUANCOMP_AND_COMPCONTROL
			////GETN_OPTION_EVENT(var_conf_lev_error_msg_event)
		//GETN_END_BRANCH(ChiSquareTest)
	//
		///// Iris 12/02/04 COMBINE_QUANCOMP_AND_COMPCONTROL
		////GETN_BEGIN_BRANCH(PowerBranch, "Power Analysis")	//GETN_CHECKBOX_BRANCH(0)
			////GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
			////tr.CompControl.PowerBranch.Show = 0;
			//////GETN_OPTION_EVENT(power_branch_open)
			//////GETN_NUM(SigLevel, "Significace Level", 0.05)
			//////GETN_OPTION_EVENT(siglevel_error_msg_event)
			//////GETN_CHECK(CalcHypotPower, "Hypothetical Power", false)
			//////GETN_OPTION_EVENT(test_power_events)
			////GETN_STR(HypotSizes, "Hypothetical Sample Size(s)", "50 100 200")	
			////GETN_OPTION_EVENT(sample_size_error_msg_event)
		////GETN_END_BRANCH(PowerBranch)
		/////End COMBINE_QUANCOMP_AND_COMPCONTROL
		//
	//GETN_END_BRANCH(CompControl)
	//
	//return tr;
//}
//*/
//
//TreeNode ConstructTwoSampletTestGUITree(TreeNode& tr, int nOption)
//{
	//GETN_USE(tr)
	//tree_construct_add_input_branch(tr, INPUTDATA_RANGES);
	//
	//GETN_BEGIN_BRANCH(tTest, _L("t-Test for Difference of Means"))	GETN_ID_BRANCH(IDST_TTEST2_CONTROL)	GETN_ID_REPEAT_BRANCH(IDRS_TTEST2_CONTROL)
		//GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
		//GETN_LIST(TestType, _L("Test Type"), 0, _L("Independent|Paired"))	GETN_ID(IDE_TEST_TYPE)			
		//GETN_NUM(HypotValue,_L("Test Difference"), 0)	GETN_ID(IDE_TEST_VALUE)
		//GETN_OPTION_EVENT(test_2sample_hypotmean_event)			
		//GETN_STR(NulHypot, _L("Null Hypothesis"), _L("Mean = 0")) GETN_READ_ONLY	GETN_ID(IDE_ALTHYPOT)
		//GETN_LIST(TailType, _L("Alternate Hypothesis"),0, _L("Mean <> 0|Mean > 0|Mean < 0"))	GETN_ID(IDE_TAIL_TYPE)
		//GETN_OPTION_EVENT(test_2sample_hypotmean_event)
		//GETN_CHECK(CalcConfInts, _L("Confidence Interval(s) of Mean Difference") ,false)	GETN_ID(IDE_CONF_INTER_MEAN)	
		//GETN_OPTION_EVENT(test_mean_conf_int_events)
		//GETN_STR(ConfLevelsMean, _L("Confidence Level(s) in %"), "90 95 99")	GETN_ID(IDE_CONF_LEVEL_MEAN)
		//GETN_OPTION_EVENT(mean_conf_lev_error_msg_event)
	//GETN_END_BRANCH(tTest)
	//
	/////Jim 3/22/06 v8.0377 CORRECT_THE_WORD_OF_GUI
	////GETN_BEGIN_BRANCH(ChiSquareTest, "F Test for Difference of Variances")	GETN_CHECKBOX_BRANCH(0)		GETN_ID_BRANCH(IDST_FTEST_CONTROL)	GETN_ID_REPEAT_BRANCH(IDRS_FTEST_CONTROL)
		////GETN_STR(HypotValue, "Test Difference", "1") GETN_READ_ONLY	GETN_ID(IDE_TEST_VALUE)
	//GETN_BEGIN_BRANCH(ChiSquareTest, _L("F Test for Ratio of Variances"))	GETN_CHECKBOX_BRANCH(0)		GETN_ID_BRANCH(IDST_FTEST_CONTROL)	GETN_ID_REPEAT_BRANCH(IDRS_FTEST_CONTROL)
		//GETN_STR(HypotValue, _L("Test Ratio"), "1") GETN_READ_ONLY	GETN_ID(IDE_TEST_VALUE)	
	/////END 	CORRECT_THE_WORD_OF_GUI
		//GETN_STR(NulHypot, _L(" Null Hypothesis"), _L("Variance1 / Variance2 = 1"))  GETN_READ_ONLY	GETN_ID(IDE_ALTHYPOT)
		//GETN_LIST(TailType, _L("Alternate Hypothesis"),0, _L("Variance1 / Variance2 <> 1|Variance1 / Variance2 > 1|Variance1 / Variance2 < 1"))	GETN_ID(IDE_TAIL_TYPE)
		//GETN_OPTION_EVENT(test_2sample_hypotvar_event)
		/////Jim 3/22/06 v8.0377 CORRECT_THE_WORD_OF_GUI
		////GETN_CHECK(ConfiInterOfVar, "Confidence Interval(s) of Variance Difference", false)	GETN_ID(IDE_CONF_INTER_VAR)	
		//GETN_CHECK(ConfiInterOfVar, _L("Confidence Interval(s) of Variance Ratio"), false)	GETN_ID(IDE_CONF_INTER_VAR)
		/////END CORRECT_THE_WORD_OF_GUI
		//GETN_OPTION_EVENT(test_var_conf_int_events)
		//GETN_STR(ConfLevelsVar, _L("Confidence Level(s) in %"), "90 95 99")	GETN_ID(IDE_CONF_LEVEL_VAR)
		//GETN_OPTION_EVENT(var_conf_lev_error_msg_event)
	//GETN_END_BRANCH(ChiSquareTest)
	//
	//GETN_BEGIN_BRANCH(PowerBranch, _L("Power Analysis"))	GETN_CHECKBOX_BRANCH(0)	GETN_ID_BRANCH(IDST_POWER_CONTROL)
		////GETN_OPTION_EVENT(power_branch_open)
		//GETN_CHECK(HypotPower, _L("Hypothetical Power"), false)	GETN_ID(IDE_POWERS_HYPOT)
		//GETN_OPTION_EVENT(power_enable_event)
		//GETN_NUM(SigLevel, _L("Significance Level"), 0.05)	GETN_ID(IDE_POWERS_ALPHA)
		///// Iris 06/27/06 TO_NOT_ALLOW_SHOW_ERR_FOR_INIT_TIME
		////GETN_OPTION_EVENT(siglevel_error_msg_event)
		//GETN_OPTION_EVENT_EX(siglevel_error_msg_event)
		/////End TO_NOT_ALLOW_SHOW_ERR_FOR_INIT_TIME
		//GETN_STR(HypotSizes, _L("Hypothetical Sample Size(s)"), "50 100 200") GETN_READ_ONLY	GETN_ID(IDE_POWERS_SAMPSIZE)
		//GETN_OPTION_EVENT_EX(sample_size_error_msg_event)
	//GETN_END_BRANCH(PowerBranch)
	//
	//return tr;
//}
/////end REMOVE_HOW_TO_COMPUTER_BRANCH
//
///*
//TreeNode ConstructTwoSampletTestGUITree(int nOption)
//{
	//string strSelection = _L("<none>");
//
	//GETN_NAMED_TREE(tr, GUI)
//
	//GETN_CHECK(TestType, "Paired t-Test", false)
//
	//GETN_INTERACTIVE(Range1, "Sample1 Data", strSelection)
//
	//GETN_INTERACTIVE(Range2, "Sample2 Data", strSelection)
//
	//GETN_INTERACTIVE(Grouping, "Grouping", _L("<none>"))
//
	//GETN_BEGIN_BRANCH(tTest, "t-Test for Difference of Means")
		//GETN_NUM(HypotValue,"Test Difference", 0)
		//GETN_LIST(TailType, "Type of Tail", 0, "Two-tailed|Upper tailed|Lower tailed")
		//GETN_STR(NullHypot, "Null Hypothesis", "Mean1 - Mean2   = 0")
		//GETN_STR(AltHypot, "Alternate Hypothesis", "Mean1 - Mean2 <> 0")
		//GETN_CHECK(CalcConfInts, "Confidence Interval(s)", false)
		//GETN_STR(ConfLevels, "Confidence Level(s) in %","90 95 99")
		//GETN_NUM(SigLevel, "Significance Level", 0.05)
	//GETN_END_BRANCH(tTest)
//
	//GETN_BEGIN_BRANCH(ChiSquareTest, "Chi-Square Test for Difference of Variances")
		//GETN_CHECK(CalcVarTest, "Chi-Square Test", false)
		//GETN_NUM(HypotValue, "Test Difference", 0)
		//GETN_LIST(TailType, "Type of Tail", 0, "Two-tailed|Upper tailed|Lower tailed")
		//GETN_STR(NullHypot, "Null Hypothesis", "Variance1 - Variance2   = 1")
		//GETN_STR(AltHypot, "Alternate Hypothesis", "Variance1 - Variance2 <> 1")
		//GETN_CHECK(CalcConfInts, "Confidence Interval(s)", false)
		//GETN_STR(ConfLevels, "Confidence Level(s) in %","90 95 99")
		//GETN_NUM(SigLevel, "Significance Level", 0.05)
	//GETN_END_BRANCH(ChiSquareTest)
//
	//GETN_BEGIN_BRANCH(PowerBranch, "Power Analysis")
		//GETN_CHECK(CalcPower, "Actual Power", false)
		//GETN_CHECK(CalcHypotPower, "Hypothetical Power", false)
		//GETN_STR(HypotSizes, "Hypothetical Sample Size(s)","50 100 200")
		//GETN_NUM(SigLevel, "Significace Level", 0.05)
	//GETN_END_BRANCH(PowerBranch)
//
	//return tr;
//}
//*/
///end NOT_USED_FUNCTION
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//////////                         One-Way ANOVA                        //////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
///Iris 11/22/04 no need, can use siglevel_error_msg_event
//bool anova_siglevel_error_msg_event(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
//{
	//double dSigLevel = tr.CompControl.SigLevel.dVal;
	//if (dSigLevel < 0 || dSigLevel > 1)
		//MessageBox(NULL, _L(SIG_LEV_ERROR_MSG), _L(ERROR_TITLE), MB_OK | MB_ICONSTOP);				
		//
	//return true;
//}

bool anova_power_events(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
{
	tr.CompControl.HypotSizes.Enable = tr.QuanComp.PowerBranch.CalcHypotPower.nVal;
	
	return true;
}

bool anova_sample_size_error_msg_event(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
{
	TreeNode trTtest = tr.CompControl;
	int nCalcHypotPower = tr.QuanComp.PowerBranch.CalcHypotPower.nVal;
	///Echo 6/27/06 REPLACE_WITH_GLOBAL_FUNC
	///Joseph	12/07/06	ADD_MESSAGE_BOX
	bool	bShowErrMsg = false;
	bool	bOKEnable = true;
	///End	ADD_MESSAGE_BOX
	if (CKBOX_SELECTED == nCalcHypotPower)
	{
		if (!check_sample_size(tr.PowerBranch.HypotSizes.strVal))
		///Joseph	12/07/06	ADD_MESSAGE_BOX
		{
			bShowErrMsg = true;
			bOKEnable = false;
		}
			//return error_msg_box(CER_SAMP_SIZES)
		///End	ADD_MESSAGE_BOX
	}	
	
	//vector vSampSize;
	//string strSampSize = trTtest.HypotSizes.strVal; 
	//int nSampSize = strSampSize.GetTokens(vSampSize, ' ');//put the confidence levels in vector
	//if (nCalcHypotPower == 1)
	//{
		//for (int ii = 0; ii < nSampSize; ii++)
		//{
			//if (vSampSize[ii] < 0 || ((vSampSize[ii] - (int)vSampSize[ii]) != 0))
			//{
				//MessageBox(NULL, _L(SAMP_SIZE_ERROR_MSG), _L(ERROR_TITLE), MB_OK | MB_ICONSTOP);		
				//return false;
			//}//if the sample size does not fit constraints, return error
		//}//loop all sample sizes
	//}//if Power computation is selected
	///END REPLACE_WITH_GLOBAL_FUNC
	///Joseph	12/07/06	ADD_MESSAGE_BOX
	//return true;
	return handle_dialog_errmsg(tr, bShowErrMsg, CER_SAMP_SIZES, bOKEnable);
	///End	ADD_MESSAGE_BOX
}



//void GetOneWayANOVAParams()
//{
////	string strSelectionRange = GetSingleColumnWksSelection();
//
	//GETN_TREE(tr)
//
	//GETN_BUTTON(DataRange, "Data Range(s)", "Data1_A[1]:C[30]");
//
	//GETN_NUM(SigLevel, "Significance Level", 0.05)
//
	//GETN_BEGIN_BRANCH(MeansComp, "Means Comparison")
		//GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
		//GETN_CHECK(Bonferroni, "Bonferroni", false)
		//GETN_CHECK(Scheffe, "Scheffe'", false)
		//GETN_CHECK(Tukey, "Tukey", false)
	//GETN_END_BRANCH(MeansComp)
//
	//GETN_BEGIN_BRANCH(EqualVar, "Tests for Equal Variance")
		//GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
		//GETN_CHECK(Levene, "Levene", false)
		//GETN_CHECK(BrownForsythe, "Brown-Forsythe", false)
	//GETN_END_BRANCH(EqualVar)
//
	//GETN_BEGIN_BRANCH(Power, "Power Analysis")
		//GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
		//GETN_CHECK(Power, "Power Analysis", false)
		//GETN_NUM(SigLevel, "Significace Level", 0.05)
		//GETN_STR(SampleSizes, "Sample Size(s)","50 100 200")
	//GETN_END_BRANCH(Power)
//
	//GetNBox(tr, "One-Way ANOVA", "Enter One-Way ANOVA parameters", ApplyOnClick); //, DialogOnChangeEvent);
//}

//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//////////                         Two-Way ANOVA                        //////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////



/// YuI 09/26/05 ANOVA_DATA_SELECTION_GUI
// two way anova NON rm GUI
static int s_nCounter = 0;
#define	ANOVA_RAW_DATA_TYPE			_L("Raw")
#define	ANOVA_INDEXED_DATA_TYPE		_L("Indexed")
/// ML 10/20/2005 ANOVA_INPUT_DATA_TO_DATARANGE
//enum	{ANOVA_INDEXED_DATA, ANOVA_RAW_DATA};
/// end ANOVA_INPUT_DATA_TO_DATARANGE


#define	GETN_BEGIN_USE_BRANCH_EX(_BRANCH, _NODE_NAME)	\
		_tmpSubNode = _BRANCH; TreeNode _tmSaveUse_##_NODE_NAME = _tmpNode; _tmpNode = _tmpSubNode;	
		
#define	GETN_END_USE_BRANCH_EX(_NODE_NAME)		\
		_tmpNode = _tmSaveUse_##_NODE_NAME;

/// YuI 09/26/05 ANOVA_DATA_SELECTION_GUI
//	void	anova_construct_input_gui_tree(TreeNode& trInputData, BOOL bTwoWay)
void	anova_construct_input_gui_tree(TreeNode& trInputData, BOOL bTwoWay, BOOL bRM)
/// end ANOVA_DATA_SELECTION_GUI
{
	s_nCounter = 0;
	GETN_USE(trInputData.Parent())
	GETN_BEGIN_USE_BRANCH_EX(trInputData, InputData);
	string strComboString;
	strComboString.Format("%s|%s", ANOVA_INDEXED_DATA_TYPE, ANOVA_RAW_DATA_TYPE);
	GETN_COMBO_BRANCH(0, strComboString)
	if( bTwoWay )
	{
		if( bRM )
			//-----	CPY 5/8/2007 QA70-9740 GETN_EVENT_NEED_TO_KNOW_DLG_OPEN_MODE
			//GETN_OPTION_EVENT(two_way_anova_rm_on_change_data_type)
			GETN_OPTION_EVENT_EX(two_way_anova_rm_on_change_data_type)
			//-----
		else
			//GETN_OPTION_EVENT(two_way_anova_on_change_data_type)
			GETN_OPTION_EVENT_EX(two_way_anova_on_change_data_type)
	}
	else
	{
		if( bRM )
			//GETN_OPTION_EVENT(one_way_anova_rm_on_change_data_type)
			GETN_OPTION_EVENT_EX(one_way_anova_rm_on_change_data_type)
		else
			//GETN_OPTION_EVENT(one_way_anova_on_change_data_type)
			GETN_OPTION_EVENT_EX(one_way_anova_on_change_data_type)
	}
	GETN_END_USE_BRANCH_EX(InputData);
	
	/// Iris 05/11/2007 v8.0616 ANOVA_DEFAULT_TYPE_SHOULD_BE_INDEXED, on Echo's suggestion, no need to check if has select factor column since for now not support factor column any more
	/*
	/// AW 01/29/07 QA80-9310 v8.0550b AUTO_RECOGNITION_FOR_INDEX_RAW_DATA_IN_STATS_TOOL
	//anova_switch_to_indexed_data(trInputData, bTwoWay, bRM);
	if ( okutil_has_select_factorCol() )
		anova_switch_to_indexed_data(trInputData, bTwoWay, bRM);
	else
		anova_switch_to_raw_data(trInputData, bTwoWay, bRM);
	/// END AUTO_RECOGNITION_FOR_INDEX_RAW_DATA_IN_STATS_TOOL
	*/
	anova_switch_to_indexed_data(trInputData, bTwoWay, bRM);
	///end ANOVA_DEFAULT_TYPE_SHOULD_BE_INDEXED
}

#define		ANOVA_FACTOR_LEVEL_BASE_LABEL	_L("Level%d name")
#define		GETN_STR2(_NODE_NAME, _NODE_LABEL, _DEFAULT_VAL)	_tmpSubNode = _tmpNode.AddTextNode(_DEFAULT_VAL, _NODE_NAME, TRGP_STR); TREE_ADD_LABEL(_NODE_LABEL);
		
static void	anova_factor_add_level(TreeNode& trLevels, int nIndex, LPCSTR lpcszFactorName, BOOL bTwoWay, BOOL bRM)
{
	GETN_USE(trLevels.Parent())
	GETN_BEGIN_USE_BRANCH_EX(trLevels, Levels)
		string strLabel;
		string strName;
		string strDefault;
		string strLevel = GetLocalized(E_STR_LEVEL);
		
		strName.Format("%s%d", strLevel, nIndex);
		strLabel.Format(ANOVA_FACTOR_LEVEL_BASE_LABEL, nIndex + 1);
		if( bTwoWay )
			strDefault.Format("%s %s%d", lpcszFactorName, strLevel, nIndex + 1);
		else
			strDefault.Format("%s%d", strLevel, nIndex + 1);
		GETN_STR2(strName, strLabel, strDefault)
		if( bTwoWay )
		{
			if( bRM )
				GETN_OPTION_EVENT(two_way_anova_rm_on_change_level_name)
			else
				GETN_OPTION_EVENT(two_way_anova_on_change_level_name)
		}
		else
		{
			GETN_ADD_AUTO(1);			///------ Folger 12/16/2011 ORG-3035-P1 AUTO_FILL_LEVEL_NAMES_BY_DATA_IN_ANOVA
			if( bRM )
				GETN_OPTION_EVENT(one_way_anova_rm_on_change_level_name)
			else
				GETN_OPTION_EVENT(one_way_anova_on_change_level_name)
		}
	GETN_END_USE_BRANCH_EX(Levels)		
}

void	anova_factor_update_levels(TreeNode& trLevels, BOOL bTwoWay, BOOL bRM)
{
	TreeNode trFactor = trLevels.Parent();
	int nLevels = trLevels.Use + 2;
	int nCurrentNodeCount = trLevels.GetNodeCount();
	if( nCurrentNodeCount < nLevels )
	{
		for( int ii = nCurrentNodeCount; ii < nLevels; ii++ )
		{
			anova_factor_add_level(trLevels, ii, trFactor.Name.strVal, bTwoWay, bRM);
		}
	}
	else if( nCurrentNodeCount > nLevels )
	{
		for( int ii = nLevels; ii < nCurrentNodeCount; ii++ )
		{
			trLevels.RemoveChild(trLevels.LastNode);
		}
	}
	
	/// Iris 12/14/05 INIT_CONTROL_LEVEL_LIST_ON_LEVEL_NAME_CHANGE
	TreeNode trOperation = tree_get_root_node(trLevels);
	TreeNode trInputData = tree_get_node_by_id(trOperation, IDST_INPUT_DATA_OPTIONS, true);
	if( bTwoWay )
		two_way_anova_update_control_level_list_for_row(trInputData);
	else
		one_way_anova_update_control_level_list_for_row(trInputData);
	///End INIT_CONTROL_LEVEL_LIST_ON_LEVEL_NAME_CHANGE
}

static void	anova_add_levels_to_factor(TreeNode& trFactor, BOOL bTwoWay, BOOL bRM)
{
	GETN_USE(trFactor.Parent())
	GETN_BEGIN_USE_BRANCH_EX(trFactor, Factor)
	GETN_BEGIN_BRANCH(Levels, _L("Number of levels"))
	GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
	if( bTwoWay )
	{
		if( bRM )
			GETN_OPTION_EVENT(two_way_anova_rm_factor_on_change_number_of_levels)
		else
			GETN_OPTION_EVENT(two_way_anova_factor_on_change_number_of_levels)
	}
	else
	{
		if( bRM )
			GETN_OPTION_EVENT(one_way_anova_rm_factor_on_change_number_of_levels)
		else
			GETN_OPTION_EVENT(one_way_anova_factor_on_change_number_of_levels)
	}
	GETN_COMBO_BRANCH(1, "1|2|3|4|5|6|7|8|9|10")
	GETN_END_BRANCH(Levels)
	GETN_END_USE_BRANCH_EX(Factor)
	
	anova_factor_update_levels(trFactor.Levels, bTwoWay, bRM);
}

static void	anova_add_factor(TreeNode& trInputData, int nIndex, BOOL bTwoWay, BOOL bRM)
{
	string strNodeName;
	string strNodeLabel;
	
	strNodeName.Format("Factor%d", nIndex);
	
	///Cheney 2007-10-27 CLEAN_UP_LOCALIZATION_THINGS	
	//if( bTwoWay )
	//{
		///// YuI 09/06/06
		//// relabeling Factor1 to FactorA
		////	strNodeLabel.Format("Factor%d", nIndex + 1);
		//strNodeLabel.Format("Factor%c", 'A' + nIndex);
		///// end YuI
	//}
	//else
		//strNodeLabel = "Factor";
	strNodeLabel = _L("Factor");
	if( bTwoWay )
	{
		string strIndex;
		strIndex.Format("%c", 'A' + nIndex);
		strNodeLabel += strIndex;
	}
	///end 	CLEAN_UP_LOCALIZATION_THINGS
		
	
	TreeNode trFactor = trInputData.AddNode(strNodeName, TRGP_BRANCH);
	trFactor.SetAttribute(STR_LABEL_ATTRIB, strNodeLabel);
	GETN_USE(trFactor.Parent())
	GETN_BEGIN_USE_BRANCH_EX(trFactor, Factor)
	GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
		GETN_STR(Name, _L("Name"), strNodeLabel)
		if( bTwoWay && bRM )
			GETN_OPTION_EVENT(two_way_anova_rm_on_change_factor_name)
			
		if( bTwoWay && bRM )
		{
			GETN_CHECK(Repeat, _L("Repeat"), 1)
			GETN_OPTION_EVENT(two_way_anova_rm_on_change_repeat_factor)
		}
	GETN_END_USE_BRANCH_EX(Factor)
	
	anova_add_levels_to_factor(trFactor, bTwoWay, bRM);
}

static string one_way_anova_get_data_row_name(int nRow)
{
	string strReturn;
	strReturn.Format("Factor_%d", nRow);
	return strReturn;
}

static string two_way_anova_get_matrix_row_name(int nRow)
{
	string strReturn;
	strReturn.Format("Factor0_%d", nRow);
	return strReturn;
}

static string two_way_anova_get_matrix_col_name(int nCol)
{
	string strReturn;
	strReturn.Format("Factor1_%d", nCol);
	return strReturn;
}


static void		two_way_anova_rm_update_repeated_factor_data(TreeNode& trFactorData, TreeNode& trFactor)
{
	// if factor is repeated corresponding data must be branch
	if( trFactorData.ID != TRGP_BRANCH )
	{
		trFactorData.Reset(true);
		trFactorData.SetAttribute(STR_ID_ATTRIB, TRGP_BRANCH);
		trFactorData.SetAttribute(STR_ATTRIB_BRANCH, GETNBRANCH_OPEN);
	}
	
	trFactorData.SetAttribute(STR_LABEL_ATTRIB, trFactor.Name.strVal);
	///------ Folger 12/16/2011 ORG-3035-P1 AUTO_FILL_LEVEL_NAMES_BY_DATA_IN_ANOVA
	//anova_update_data_with_levels(trFactorData, trFactor.Levels);
	anova_update_data_with_levels(trFactorData, trFactor.Levels, TRUE, TRUE);
	///------ End AUTO_FILL_LEVEL_NAMES_BY_DATA_IN_ANOVA
	
	///Iris 1/16/06 INIT_CONTROL_LEVEL_LIST_ON_LEVEL_NAME_CHANGE
	//set event handler to update the list in "Mean Comparison -> Dunnet"
	string str = two_way_anova_get_update_control_level_list_function();
	if(!str.IsEmpty())
	{
		foreach(TreeNode trN in trFactorData.Children)
		{
			trN.SetAttribute(STR_ATTRIB_HANDLER, str);		
		}
	}
	///End INIT_CONTROL_LEVEL_LIST_ON_LEVEL_NAME_CHANGE
}

static void		two_way_anova_rm_update_non_repeated_factor_data(TreeNode& trFactorData,TreeNode& trFactor)
{
	/// ML YuI 10/2/2007 QA70-10428 INCORRECT_NODE_RESETTING_ANOVA
	//if( trFactorData.ID != TRGP_BRANCH )
	//{
	//	trFactorData.Reset(true);
	//	trFactorData.SetAttribute(STR_ID_ATTRIB, TRGP_INTERACTIVE);
	//}
	if( trFactorData.ID == TRGP_BRANCH )
		trFactorData.Reset(true);
	
	trFactorData.SetAttribute(STR_ID_ATTRIB, TRGP_INTERACTIVE);
	/// end INCORRECT_NODE_RESETTING_ANOVA
	
	trFactorData.SetAttribute(STR_LABEL_ATTRIB, trFactor.Name.strVal);
	
	/// YuI 09/26/07 QA70-10420 RESTRICT_RAW_DATA_ANOVA_CONTROLS_TO_ONE_DATA
	trFactorData.SetAttribute(STR_INTERACTIVE_CONTROL_OPTIONS_ATTRIB, ICOPT_RESTRICT_TO_ONE_DATA); 
	/// end RESTRICT_RAW_DATA_ANOVA_CONTROLS_TO_ONE_DATA

	///Iris 1/16/06 INIT_CONTROL_LEVEL_LIST_ON_LEVEL_NAME_CHANGE
	//set event handler to update the list in "Mean Comparison -> Dunnet"
	string str = two_way_anova_get_update_control_level_list_function();
	if(!str.IsEmpty())
		trFactorData.SetAttribute(STR_ATTRIB_HANDLER, str);
	///End INIT_CONTROL_LEVEL_LIST_ON_LEVEL_NAME_CHANGE

}

///Iris 12/14/05 INIT_CONTROL_LEVEL_LIST_ON_LEVEL_NAME_CHANGE
static string two_way_anova_get_update_control_level_list_function()
{
	string 		str;
	PEVENT_FUNC __dfn;
	__dfn = two_way_anova_control_level_list_on_data_change;
	ODWP _dw_fn = (ODWP)__dfn;
	if(_dw_fn)
	{
		str = _dw_fn;		
	}
	return str;	
}

static bool	two_way_anova_control_level_list_on_data_change(TreeNode& trn, int nRow, int nType, Dialog& dlg)
{
	TreeNode trInputData = tree_get_node_by_id(trn, IDST_INPUT_DATA_OPTIONS, true);
	if( !trInputData )
		return false;
	return two_way_anova_update_control_level_list_for_row(trInputData);
}
///End INIT_CONTROL_LEVEL_LIST_ON_LEVEL_NAME_CHANGE

#define	ANOVA_DATA_NODE_NAME	"Data"
void	two_way_anova_update_data(TreeNode& trInputData, BOOL bRM)
{
	// we need matrix if non-RM or RM with both repeated factors
	// otherwise need to have different structure...
	BOOL bMatrix;
	if( !bRM || (trInputData.Factor0.Repeat.nVal && trInputData.Factor1.Repeat.nVal) )
		bMatrix = TRUE;
	else
		bMatrix = FALSE;
	
	
	TreeNode trData = tree_check_get_node(trInputData, ANOVA_DATA_NODE_NAME, TRGP_BRANCH);
	// if RM and there is switch between matrix form of data and linearized 
	// we have no choice but reset trData
	BOOL bCurrentIsMatrix = false;
	TreeNode trTemp0 = trData.GetNode(two_way_anova_get_matrix_row_name(0));
	TreeNode trTemp1 = trData.GetNode(two_way_anova_get_matrix_row_name(1));
	if( trTemp0.IsValid() && trTemp1.IsValid() )
		bCurrentIsMatrix = true;
	if( (bCurrentIsMatrix && !bMatrix) || (!bCurrentIsMatrix && bMatrix) )
		trData.Reset(true);
	
	GETN_USE(trData.Parent())
	GETN_BEGIN_USE_BRANCH_EX(trData, Data)
	GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
	if( bMatrix )
	{
		GETN_BUTTON_BRANCH
	}
	else
	{
		trData.RemoveAttribute(STR_ATTRIB_BRANCH_COMBO);
		/// YuI 09/26/07 QA70-10420 RESTRICT_RAW_DATA_ANOVA_CONTROLS_TO_ONE_DATA
		// -1 in case of Use will produce checkbox in dyna control
		//	trData.Use = -1;
		trData.RemoveAttribute(STR_USE_ATTRIB);		
		/// end RESTRICT_RAW_DATA_ANOVA_CONTROLS_TO_ONE_DATA
	}
		
	GETN_END_USE_BRANCH_EX(Data)
	
	if( bMatrix )
	{
		TreeNode trLevels0 = trInputData.Factor0.Levels;
		TreeNode trLevels1 = trInputData.Factor1.Levels;
		if( !trLevels0 || !trLevels1 || !trData )
		{
			ASSERT(FALSE);
			return;
		}
		
		int nLevels0 = trLevels0.GetNodeCount();
		int nLevels1 = trLevels1.GetNodeCount();
		int nCombinationCount = nLevels0 * nLevels1;
		int nRow = 0;
		TreeNode trRow;
		foreach(TreeNode trLevel0 in trLevels0.Children)
		{
			trRow = tree_check_get_node(trData, two_way_anova_get_matrix_row_name(nRow), TRGP_BRANCH);
			trRow.SetAttribute(STR_LABEL_ATTRIB, trLevel0.strVal);
			trRow.SetAttribute(STR_ATTRIB_BRANCH, GETNBRANCH_OPEN);
			trRow.SetAttribute(STR_ATTRIB_DISPFMT, DISPLAY_LEFT);
			int nCol = 0;
			TreeNode trCol;
			foreach(TreeNode trLevel1 in trLevels1.Children)
			{
				trCol = tree_check_get_node(trRow, two_way_anova_get_matrix_col_name(nCol), TRGP_INTERACTIVE);
				trCol.SetAttribute(STR_LABEL_ATTRIB, trLevel1.strVal);
				trCol.SetAttribute(STR_ATTRIB_DISPFMT, DISPLAY_LEFT);
				/// YuI 09/26/07 QA70-10420 RESTRICT_RAW_DATA_ANOVA_CONTROLS_TO_ONE_DATA
				trCol.SetAttribute(STR_INTERACTIVE_CONTROL_OPTIONS_ATTRIB, ICOPT_RESTRICT_TO_ONE_DATA); 
				/// end RESTRICT_RAW_DATA_ANOVA_CONTROLS_TO_ONE_DATA
				nCol++;
			}
			
			//after updated all present node need to remove the rest
			if( trCol )
			{
				TreeNode trNext = trCol.NextNode;
				while( trNext )
				{
					TreeNode trTemp = trNext.NextNode;
					trRow.RemoveChild(trNext);
					trNext = trTemp;
				}
			}
			
			nRow++;
		}
		
		//after updated all present node need to remove the rest
		if( trRow ) 
		{
			TreeNode trNext = trRow.NextNode;
			while( trNext )
			{
				TreeNode trTemp = trNext.NextNode;
				trData.RemoveChild(trNext);
				trNext = trTemp;
			}
		}
		
		/// Iris 1/16/06 INIT_CONTROL_LEVEL_LIST_ON_LEVEL_NAME_CHANGE
		two_way_anova_update_control_level_list_for_row(trInputData);
		///End INIT_CONTROL_LEVEL_LIST_ON_LEVEL_NAME_CHANGE

	}
	else
	{
		ASSERT(bRM);
		TreeNode trFactor0 = trInputData.Factor0;
		TreeNode trFactor1 = trInputData.Factor1;
		if( 0 == trFactor0.Repeat.nVal && 0 == trFactor1.Repeat.nVal )
		{
			trData.Show = false; // hide data node because of user mistake
			trData.Reset(true);
		}
		else
		{
			trData.Show = true;
			TreeNode trFactor0Data = tree_check_get_node(trData, "Factor0");
			TreeNode trFactor1Data = tree_check_get_node(trData, "Factor1");
			if( trFactor0.Repeat.nVal )
			{
				two_way_anova_rm_update_repeated_factor_data(trFactor0Data, trFactor0);
				two_way_anova_rm_update_non_repeated_factor_data(trFactor1Data, trFactor1);
			}
			else
			{
				two_way_anova_rm_update_non_repeated_factor_data(trFactor0Data, trFactor0);
				two_way_anova_rm_update_repeated_factor_data(trFactor1Data, trFactor1);
			}
		}
	}
}

///------ Folger 12/16/2011 ORG-3035-P1 AUTO_FILL_LEVEL_NAMES_BY_DATA_IN_ANOVA
//static void	anova_update_data_with_levels(TreeNode& trData, TreeNode& trLevels)
static void	anova_update_data_with_levels(TreeNode& trData, TreeNode& trLevels, BOOL bTwoWay, BOOL bRM)
///------ End AUTO_FILL_LEVEL_NAMES_BY_DATA_IN_ANOVA
{
	TreeNode trRow;
	int nRow = 0;
	foreach(TreeNode trLevel in trLevels.Children)
	{
		trRow = tree_check_get_node(trData, one_way_anova_get_data_row_name(nRow), TRGP_INTERACTIVE);
		trRow.SetAttribute(STR_LABEL_ATTRIB, trLevel.strVal);
		trRow.SetAttribute(STR_ATTRIB_BRANCH, GETNBRANCH_OPEN);
		/// YuI 09/26/07 QA70-10420 RESTRICT_RAW_DATA_ANOVA_CONTROLS_TO_ONE_DATA
		trRow.SetAttribute(STR_INTERACTIVE_CONTROL_OPTIONS_ATTRIB, ICOPT_RESTRICT_TO_ONE_DATA); 
		/// end RESTRICT_RAW_DATA_ANOVA_CONTROLS_TO_ONE_DATA
		///------ Folger 12/16/2011 ORG-3035-P1 AUTO_FILL_LEVEL_NAMES_BY_DATA_IN_ANOVA
		if( bTwoWay )
		{
			if( bRM )
				trRow.SetAttribute(STR_ATTRIB_HANDLER, (ODWP)two_way_anova_rm_on_change_data);
			else
				trRow.SetAttribute(STR_ATTRIB_HANDLER, (ODWP)two_way_anova_on_change_data);
		}
		else
		{
			okutil_anova_update_level_name_from_data(&trLevel, &trRow);
			if( bRM )
				trRow.SetAttribute(STR_ATTRIB_HANDLER, (ODWP)one_way_anova_rm_on_change_data);
			else
				trRow.SetAttribute(STR_ATTRIB_HANDLER, (ODWP)one_way_anova_on_change_data);
		}
		///------ End AUTO_FILL_LEVEL_NAMES_BY_DATA_IN_ANOVA
		nRow++;
	}
	//after updated all present node need to remove the rest
	
	if( trRow ) 
	{
		TreeNode trNext = trRow.NextNode;
		while( trNext )
		{
			TreeNode trTemp = trNext.NextNode;
			trData.RemoveChild(trNext);
			trNext = trTemp;
		}
	}
}

void	one_way_anova_update_data(TreeNode& trInputData, BOOL bRM)
{
	TreeNode trLevels = trInputData.Factor0.Levels;
	TreeNode trData = tree_check_get_node(trInputData, ANOVA_DATA_NODE_NAME, TRGP_BRANCH);
	GETN_USE(trData.Parent())
	GETN_BEGIN_USE_BRANCH_EX(trData, Data)
	GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
	GETN_END_USE_BRANCH_EX(Data)
	
	if( !trLevels || !trData )
	{
		ASSERT(FALSE);
		return;
	}
	
	///------ Folger 12/16/2011 ORG-3035-P1 AUTO_FILL_LEVEL_NAMES_BY_DATA_IN_ANOVA
	//anova_update_data_with_levels(trData, trLevels);
	anova_update_data_with_levels(trData, trLevels, FALSE, bRM);
	///------ End AUTO_FILL_LEVEL_NAMES_BY_DATA_IN_ANOVA
	/// Iris 1/16/06 INIT_CONTROL_LEVEL_LIST_ON_LEVEL_NAME_CHANGE
	one_way_anova_update_control_level_list_for_row(trInputData);
	///End INIT_CONTROL_LEVEL_LIST_ON_LEVEL_NAME_CHANGE

}

static void	anova_switch_to_raw_data(TreeNode& trInputData, BOOL bTwoWay, BOOL bRM)
{
	/// AW 01/29/07 QA80-9310 v8.0550b AUTO_RECOGNITION_FOR_INDEX_RAW_DATA_IN_STATS_TOOL
	/*
	trInputData.Reset(true);
	anova_add_factor(trInputData, 0, bTwoWay, bRM);
	
	if( bTwoWay )
		anova_add_factor(trInputData, 1, bTwoWay, bRM);
	
	GETN_USE(trInputData.Parent())
	GETN_BEGIN_USE_BRANCH_EX(trInputData, InputData)
		GETN_BEGIN_BRANCH(Data, ANOVA_DATA_NODE_NAME)
		GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
		if( bTwoWay ) // no need to matrix open for one way
		{
			GETN_BUTTON_BRANCH
			GETN_OPTION_EVENT(two_way_anova_open_data_as_matrix)
		}
			
		GETN_END_BRANCH(Data)
	GETN_END_USE_BRANCH_EX(InputData)
	
	if( bTwoWay )
		two_way_anova_update_data(trInputData, bRM);
	else
		one_way_anova_update_data(trInputData, bRM);
	*/
	int nRet = okutil_anova_switch_to_raw_data(&trInputData, bTwoWay, bRM);
	/// END AUTO_RECOGNITION_FOR_INDEX_RAW_DATA_IN_STATS_TOOL
}	

static void	anova_switch_to_indexed_data(TreeNode& trInputData, BOOL bTwoWay, BOOL bRM)
{
	/// AW 01/29/07 QA80-9310 v8.0550b AUTO_RECOGNITION_FOR_INDEX_RAW_DATA_IN_STATS_TOOL
	/*
	trInputData.Reset(true);
	GETN_USE(trInputData.Parent())
	GETN_BEGIN_USE_BRANCH_EX(trInputData, InputData)
	if( bTwoWay )
	{
		GETN_INTERACTIVE(Factor0, "FactorA", "")
		GETN_OPTION_EVENT(two_way_anova_on_input_data_update) /// Iris 12/14/05 INIT_CONTROL_LEVEL_LIST_ON_LEVEL_NAME_CHANGE
		GETN_INTERACTIVE(Factor1, "FactorB", "")
		GETN_OPTION_EVENT(two_way_anova_on_input_data_update) /// Iris 12/14/05 INIT_CONTROL_LEVEL_LIST_ON_LEVEL_NAME_CHANGE
		
		/// Iris 12/14/05 INIT_CONTROL_LEVEL_LIST_ON_LEVEL_NAME_CHANGE
		GETN_INTERACTIVE(Data, "Data", "") 
		GETN_OPTION_EVENT(two_way_anova_on_input_data_update)
		///End INIT_CONTROL_LEVEL_LIST_ON_LEVEL_NAME_CHANGE
		
		
		
		
	}
	else
	{ 
		GETN_INTERACTIVE(Factor, "Factor", "")
		GETN_OPTION_EVENT(one_way_anova_on_input_data_update)
		/// Iris 12/14/05 INIT_CONTROL_LEVEL_LIST_ON_LEVEL_NAME_CHANGE
		GETN_INTERACTIVE(Data, "Data", "")  
		GETN_OPTION_EVENT(one_way_anova_on_input_data_update)
		///End INIT_CONTROL_LEVEL_LIST_ON_LEVEL_NAME_CHANGE
	}
	//GETN_INTERACTIVE(Data, "Data", "")  /// Iris 12/14/05 INIT_CONTROL_LEVEL_LIST_ON_LEVEL_NAME_CHANGE
	if( bRM )
	{
		GETN_INTERACTIVE(Subject, "Subject", "")
		/// Iris 1/13/05 INIT_CONTROL_LEVEL_LIST_ON_LEVEL_NAME_CHANGE
		if( bTwoWay )
		{
			GETN_OPTION_EVENT(two_way_anova_on_input_data_update)
		}
		else
		{
			GETN_OPTION_EVENT(one_way_anova_on_input_data_update)
		}
		///End INIT_CONTROL_LEVEL_LIST_ON_LEVEL_NAME_CHANGE
	}
	GETN_END_USE_BRANCH_EX(InputData)
	*/
	int nRet = okutil_anova_switch_to_indexed_data(&trInputData, bTwoWay, bRM);
	/// END AUTO_RECOGNITION_FOR_INDEX_RAW_DATA_IN_STATS_TOOL
}


static bool	anova_on_change_level_name(TreeNode& trn, int nRow, int nType, Dialog& dlg, BOOL bTwoWay, BOOL bRM)
{
	TreeNode trInputData = tree_get_node_by_id(trn, IDST_INPUT_DATA_OPTIONS, true);
	if( !trInputData )
		return false;

	if( bTwoWay )
		two_way_anova_update_data(trInputData, bRM);
	else
		one_way_anova_update_data(trInputData, bRM);	

	return true;
}

static bool	two_way_anova_on_change_level_name(TreeNode& trn, int nRow, int nType, Dialog& dlg)
{
	return anova_on_change_level_name(trn, nRow, nType, dlg, true, false);
}

static bool	one_way_anova_on_change_level_name(TreeNode& trn, int nRow, int nType, Dialog& dlg)
{
	return anova_on_change_level_name(trn, nRow, nType, dlg, false, false);
}

static bool	two_way_anova_rm_on_change_level_name(TreeNode& trn, int nRow, int nType, Dialog& dlg)
{
	return anova_on_change_level_name(trn, nRow, nType, dlg, true, true);
}

static bool	one_way_anova_rm_on_change_level_name(TreeNode& trn, int nRow, int nType, Dialog& dlg)
{
	return anova_on_change_level_name(trn, nRow, nType, dlg, false, true);
}

///------ Folger 12/16/2011 ORG-3035-P1 AUTO_FILL_LEVEL_NAMES_BY_DATA_IN_ANOVA
static bool	two_way_anova_on_change_data(TreeNode& trn, int nRow, int nType, Dialog& dlg)
{
	return anova_on_change_data(trn, nRow, nType, dlg, true, false);
}

static bool	one_way_anova_on_change_data(TreeNode& trn, int nRow, int nType, Dialog& dlg)
{
	return anova_on_change_data(trn, nRow, nType, dlg, false, false);
}

static bool	two_way_anova_rm_on_change_data(TreeNode& trn, int nRow, int nType, Dialog& dlg)
{
	return anova_on_change_data(trn, nRow, nType, dlg, true, true);
}

static bool	one_way_anova_rm_on_change_data(TreeNode& trn, int nRow, int nType, Dialog& dlg)
{
	return anova_on_change_data(trn, nRow, nType, dlg, false, true);
}

static bool	anova_on_change_data(TreeNode& trn, int nRow, int nType, Dialog& dlg, BOOL bTwoWay, BOOL bRM)
{
	TreeNode trInputData = tree_get_node_by_id(trn, IDST_INPUT_DATA_OPTIONS, true);
	if( !trInputData )
		return false;
	
	if( bTwoWay )
		two_way_anova_update_data(trInputData, bRM);
	else
		one_way_anova_update_data(trInputData, bRM);	
	
	return true;
}
///------ End AUTO_FILL_LEVEL_NAMES_BY_DATA_IN_ANOVA



/// Iris 12/14/05 INIT_CONTROL_LEVEL_LIST_ON_LEVEL_NAME_CHANGE
static bool anova_update_control_level_list_for_row(TreeNode& trInputData, bool bTwoWay = false, int nFactorIndex = 0)
{	
	if(!trInputData)
		return false;
	if( 0 != nFactorIndex && 1 !=nFactorIndex)
		return false;
	
	string 		str = "Factor" + nFactorIndex;	
	TreeNode 	trFactor = trInputData.GetNode(str);
	if(!trFactor)
		return false;
	TreeNode 	trLevels = trFactor.Levels;
	if(!trLevels)
		return false;
	
	//to get levels name list string
	string 		strLevels;
	/// YuI 03/13/06 non RM does not have repat node at all
	// should not attempt to get value
	//if(bTwoWay && !trFactor.Repeat.nVal)
	if(bTwoWay && (!trFactor.Repeat.IsValid() || !trFactor.Repeat.nVal) )
	/// end YuI
	{
		 get_non_repeated_factor_levels(trInputData, strLevels);
	}
	else
	{
		foreach(TreeNode trN in trLevels.Children)
		{
			insert_str_to_str_list(trN.strVal, strLevels); 
		}
	}
	
	//to update control level with list string
	TreeNode trOperation = tree_get_root_node(trInputData);
	TreeNode trDunnett = tree_get_node_by_id(trOperation, IDE_MEANCOMP_DUNNE, true);
	if(!trDunnett)
		return false;
	/// Max 10/30/07 WRONG_LOCALIZATION
	//str.Format("%s%d", _L("CtrlLevel"), ++nFactorIndex);
	str.Format("%s%d", "CtrlLevel", ++nFactorIndex);
	/// END WRONG_LOCALIZATION
	TreeNode 	trControlLevel = trDunnett.GetNode(str);
	if(!trControlLevel)
		return false;
	
	int nVal = trControlLevel.nVal;
	trControlLevel.SetAttribute(STR_COMBO_ATTRIB, strLevels);
	if(nVal<0)
		nVal = 0;
	trControlLevel.nVal = nVal;
	
	return true;
}

static bool get_non_repeated_factor_levels(const TreeNode& trInputData, string& strLevels)
{
	DataRange 	dr;
    dr.Create();
    dr.SetTree(trInputData, DRTREE_ANOVA_TWO_WAY_RAW);
    if(!dr)
    	return false;
	
    DWORD 	dwRules = DRR_NO_WEIGHTS;
	int 	nNumData = dr.GetNumData(dwRules);	
	if (nNumData <= 0)
		return false;
	
	for (int ii = 0; ii < nNumData; ii++)
	{		
		vector			vData;
		DWORD			dwPlotUID;	
		vector<string>	vstrFactors;
		int	nn = dr.GetData(dwRules, ii, &dwPlotUID, NULL, &vData, NULL, NULL, &vstrFactors);
		if(nn < 0)
			return false;
		if(vstrFactors.GetSize()!=0)
		{
			remove_repeat_item(vstrFactors);		
			insert_str_to_str_list(vstrFactors[0], strLevels);
		}
	}	
	
	return true;

}

static bool	two_way_anova_update_control_level_list_for_row(TreeNode& trInputData)
{
	if( !anova_update_control_level_list_for_row(trInputData, true, 0))
		return false;
	
	return anova_update_control_level_list_for_row(trInputData, true, 1);	

}

static bool one_way_anova_update_control_level_list_for_row(TreeNode& trInputData)
{
	return anova_update_control_level_list_for_row(trInputData);

}

static bool update_control_level_list_for_indexed(TreeNode& trInputData, bool bTwoWay = false)
{
	if(!trInputData)
		return false;
	
	//get control level tree node
	TreeNode trOperation = tree_get_root_node(trInputData);
	if(!trOperation)
		return false;
	TreeNode 	trDunnett = tree_get_node_by_id(trOperation, IDE_MEANCOMP_DUNNE, true);
	if(!trDunnett)
		return false;	

	//update control level list by factor names
	DataRange dr;
    dr.Create();
    dr.SetTree(trInputData, bTwoWay? DRTREE_ANOVA_TWO_WAY_INDEXED : DRTREE_ANOVA_ONE_WAY_INDEXED);
	
	string 	strLevels1, strLevels2;
	DWORD 	dwRules = DRR_RM_ANOVA;
	int nNumData = dr.GetNumData(dwRules);
	if(nNumData <= 0)
		return false;

	matrix			mData;
	int				nn, nOutcome, numFactorVals, numFactorVals2;
	vector<string>	vstrRepeatedFactorVals, vstrRepeatedOrNonrepeatedFactorVals;
	if(bTwoWay)
	{
		nn = dr.GetDataRMTwoWayANOVA(dwRules, nOutcome, numFactorVals, numFactorVals2, &mData, &vstrRepeatedFactorVals, &vstrRepeatedOrNonrepeatedFactorVals);
	}
	else
	{
		nn = dr.GetDataRMOneWayANOVA(dwRules, nOutcome, numFactorVals, &mData, &vstrRepeatedFactorVals);
	}
	if (nn < 0 || nOutcome < 0)	
		return false;	
	
	remove_repeat_item(vstrRepeatedFactorVals);
	strLevels1 = rollback_string_tokens(vstrRepeatedFactorVals, '|');
	trDunnett.CtrlLevel1.SetAttribute(STR_COMBO_ATTRIB, strLevels1);
	
	if(bTwoWay)
	{
		remove_repeat_item(vstrRepeatedOrNonrepeatedFactorVals);
		strLevels2 = rollback_string_tokens(vstrRepeatedOrNonrepeatedFactorVals, '|');
		trDunnett.CtrlLevel2.SetAttribute(STR_COMBO_ATTRIB, strLevels2); /// Iris 12/15/05 fail to update combo for control level 2 for indexed data with unknown reason
		
		string strTest;
		trDunnett.CtrlLevel2.GetAttribute(STR_COMBO_ATTRIB, strTest);
	}
	
	
	return true;
	
}

static bool	two_way_anova_on_input_data_update(TreeNode& trn, int nRow, int nType, Dialog& dlg)
{
	TreeNode trInputData = tree_get_node_by_id(trn, IDST_INPUT_DATA_OPTIONS, true);
	if( !trInputData )
		return false;
	
	update_control_level_list_for_indexed(trInputData, true);
	
	return true;
}

static bool	one_way_anova_on_input_data_update(TreeNode& trn, int nRow, int nType, Dialog& dlg)
{
	TreeNode trInputData = tree_get_node_by_id(trn, IDST_INPUT_DATA_OPTIONS, true);
	if( !trInputData )
		return false;

	return update_control_level_list_for_indexed(trInputData);	
}
///End INIT_CONTROL_LEVEL_LIST_ON_LEVEL_NAME_CHANGE

static bool	two_way_anova_rm_on_change_factor_name(TreeNode& trn, int nRow, int nType, Dialog& dlg)
{
	TreeNode trInputData = tree_get_node_by_id(trn, IDST_INPUT_DATA_OPTIONS, true);
	if( !trInputData )
		return false;
	
	/// Thomas 03/15/2006 UPDATE_FACTOR_LEVEL_NAME
	string strFactorName = trInputData.Factor0.Name.strVal;
	int nLevelCount = 0;
	foreach(TreeNode tnLevel in trInputData.Factor0.Levels.Children) {
		nLevelCount ++;
		tnLevel.strVal = strFactorName + " Level" + nLevelCount;
	}
		
	strFactorName = trInputData.Factor1.Name.strVal;
	nLevelCount = 0;
	foreach(tnLevel in trInputData.Factor1.Levels.Children) {
		nLevelCount ++;
		tnLevel.strVal = strFactorName + " Level" + nLevelCount;
	}
	/// End UPDATE_FACTOR_LEVEL_NAME
	
	two_way_anova_update_data(trInputData, true);
	return true;
}

static bool	two_way_anova_rm_on_change_repeat_factor(TreeNode& trn, int nRow, int nType, Dialog& dlg)
{
	TreeNode trRepeat = tree_get_node(trn, nRow);
	if( !trRepeat )
		return false;
	TreeNode trChangedFactor = trRepeat.Parent();
	if( !trChangedFactor )
		return false;

	TreeNode trInputData = tree_get_node_by_id(trn, IDST_INPUT_DATA_OPTIONS, true);
	if( !trInputData )
		return false;
	
	if( 0 == trChangedFactor.Repeat.nVal )
		trChangedFactor.Levels.Show = false;
	else
		trChangedFactor.Levels.Show = true;

	two_way_anova_update_data(trInputData, true);
	return true;
}

static bool	two_way_anova_open_data_as_matrix(TreeNode& trn, int nRow, int nType, Dialog& dlg)
{
	if( 0 == s_nCounter++ )
		return true;
	
	TreeNode trMatrixNode = tree_get_node(trn, nRow);
	GETN_TREE(trMatrix);
	GETN_AUTO_SAVE_BRANCH_OPEN(1) /// Iris 7/04/2012 ORG-6033-P1 TO_PREVENT_GETN_AUTO_SAVE_BRANCH_OPEN_STATUS_TO_REG
	trMatrix.Replace(trMatrixNode);
	

	Window wnd = dlg.GetWindow();
	wnd.ShowWindow(SW_HIDE);
	/// YuI 09/28/07 A70-10436 ANOVA_DATA_SELECTTION_IN_SEPARATE_DIALOG_BROKEN
	//	if( GetNBox(trMatrix, "Two way ANOVA Data", NULL, NULL, NULL, GetWindow(), true) )
	/// TD 11-13-2007 QA80-10436 ANOVA_FREEZES_ORIGIN
	//if( GetNBox(trMatrix, NULL, _L("Two way ANOVA Data"), NULL, GetWindow(), FALSE) )
	if( GetNBox(trMatrix, NULL, _L("Two way ANOVA Data"), NULL, wnd.GetSafeHwnd(), FALSE) )
	/// end ANOVA_FREEZES_ORIGIN
	/// end ANOVA_DATA_SELECTTION_IN_SEPARATE_DIALOG_BROKEN
		trMatrixNode.Replace(trMatrix);
	wnd.ShowWindow(SW_SHOW);
	return true;
}


static bool	anova_factor_on_change_number_of_levels(TreeNode& trn, int nRow, int nType, Dialog& dlg, BOOL bTwoWay, BOOL bRM)
{
	TreeNode trLevels = tree_get_node(trn, nRow);
	if( !trLevels )
		return false;
	
	TreeNode trInputData = tree_get_node_by_id(trn, IDST_INPUT_DATA_OPTIONS, true);
	if( !trInputData )
		return false;
	
	anova_factor_update_levels(trLevels, bTwoWay, bRM);
	if( bTwoWay )
		two_way_anova_update_data(trInputData, bRM);
	else
		one_way_anova_update_data(trInputData, bRM);
	
	return true;
}

static bool	two_way_anova_factor_on_change_number_of_levels(TreeNode& trn, int nRow, int nType, Dialog& dlg)
{
	return anova_factor_on_change_number_of_levels(trn, nRow, nType, dlg, true, false);
}

static bool	one_way_anova_factor_on_change_number_of_levels(TreeNode& trn, int nRow, int nType, Dialog& dlg)
{
	return anova_factor_on_change_number_of_levels(trn, nRow, nType, dlg, false, false);
}

static bool	two_way_anova_rm_factor_on_change_number_of_levels(TreeNode& trn, int nRow, int nType, Dialog& dlg)
{
	return anova_factor_on_change_number_of_levels(trn, nRow, nType, dlg, true, true);
}

static bool	one_way_anova_rm_factor_on_change_number_of_levels(TreeNode& trn, int nRow, int nType, Dialog& dlg)
{
	return anova_factor_on_change_number_of_levels(trn, nRow, nType, dlg, false, true);
}


//---------- CPY 5/8/2007 QA70-9740 GETN_EVENT_NEED_TO_KNOW_DLG_OPEN_MODE
/*
static bool	anova_on_change_data_type(TreeNode& trn, int nRow, int nType, Dialog& dlg, BOOL bTwoWay, BOOL bRM)
{
	TreeNode trInputData = tree_get_node(trn, nRow);

	switch( trInputData.Use )
	{
	case ANOVA_RAW_DATA:
		anova_switch_to_raw_data(trInputData, bTwoWay, bRM);
		break;
		
	case ANOVA_INDEXED_DATA:
		anova_switch_to_indexed_data(trInputData, bTwoWay, bRM);
		break;
	}
	
	return true;
}
static bool	two_way_anova_on_change_data_type(TreeNode& trn, int nRow, int nType, Dialog& dlg)
{
	return anova_on_change_data_type(trn, nRow, nType, dlg, true, false);
}

static bool	one_way_anova_on_change_data_type(TreeNode& trn, int nRow, int nType, Dialog& dlg)
{
	return anova_on_change_data_type(trn, nRow, nType, dlg, false, false);
}

static bool	two_way_anova_rm_on_change_data_type(TreeNode& trn, int nRow, int nType, Dialog& dlg)
{
	return anova_on_change_data_type(trn, nRow, nType, dlg, true, true);
}

static bool	one_way_anova_rm_on_change_data_type(TreeNode& trn, int nRow, int nType, Dialog& dlg)
{
	return anova_on_change_data_type(trn, nRow, nType, dlg, false, true);
}
/// end ANOVA_DATA_SELECTION_GUI
*/
static bool	anova_on_change_data_type(TreeNode& trGetN, TreeNode& trInputData, DWORD dwCntrl, BOOL bTwoWay, BOOL bRM)
{
	/// Hong QA80-12866 v8.0991b FIX_ANOVA_INPUT_DATA_CHANGED_WHEN_SWITCH_THEME
#define			STR_OLD_INPUT_DATA_MODE		"OldInputDataMode"
	ASSERT(trInputData);
	bool			bInputDataModeChanged = true;
	int				nOldInputDataMode;
	if ( trInputData.GetAttribute(STR_OLD_INPUT_DATA_MODE, nOldInputDataMode) && nOldInputDataMode == trInputData.Use )
		bInputDataModeChanged = false;	
	else
		trInputData.SetAttribute(STR_OLD_INPUT_DATA_MODE, trInputData.Use);
	
	///------ Folger 06/08/2012 ORG-5805-P3 HIDE_DATA_IDENTIFIER_IN_ANOVA_TOOL_IF_RAW_DATA
	TreeNode trDataIdentifierBranch =  op_find_data_identifier_branch(trGetN);
	if ( trDataIdentifierBranch )
	{
		trDataIdentifierBranch.Show = ANOVA_INDEXED_DATA == trInputData.Use;
	}
	///------ End HIDE_DATA_IDENTIFIER_IN_ANOVA_TOOL_IF_RAW_DATA
	
	if ( !bInputDataModeChanged )
		return false;
	/// end FIX_ANOVA_INPUT_DATA_CHANGED_WHEN_SWITCH_THEME
	BOOL bFromOnInit = (dwCntrl & GETNEVENT_ON_INIT)? true:false;
	int nExecMode = 0;
	trGetN.GetAttribute(STR_EXEC_MODE_ATTRIB, nExecMode);
	if(OEXEM_ON_CHANGEPARAM == nExecMode && bFromOnInit)
		return false;
	
	switch( trInputData.Use )
	{
	case ANOVA_RAW_DATA:
		anova_switch_to_raw_data(trInputData, bTwoWay, bRM);
		break;
		
	case ANOVA_INDEXED_DATA:
		anova_switch_to_indexed_data(trInputData, bTwoWay, bRM);
		break;
	}
	
	return true;
}

static bool two_way_anova_on_change_data_type(TreeNode& trn, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& dlg)
{
	return anova_on_change_data_type(trn, trNode, dwCntrl, true, false);
}
static bool	one_way_anova_on_change_data_type(TreeNode& trn, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& dlg)
{
	return anova_on_change_data_type(trn, trNode, dwCntrl, false, false);
}

static bool	two_way_anova_rm_on_change_data_type(TreeNode& trn, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& dlg)
{
	return anova_on_change_data_type(trn, trNode, dwCntrl, true, true);
}

static bool	one_way_anova_rm_on_change_data_type(TreeNode& trn, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& dlg)
{
	return anova_on_change_data_type(trn, trNode, dwCntrl, false, true);
}
//---------- end GETN_EVENT_NEED_TO_KNOW_DLG_OPEN_MODE


bool ANOVA2_interaction_event(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
{
	///Iris 12/28/04 REMOVE_HOW_TO_COMPUTER_BRANCH
	//TreeNode trQuants = tr.QuanComp;
	//trQuants.DescStats.Interaction.Enable = trQuants.Interactions.nVal;
	///------ Folger 10/11/2011 ORG-4034-P3 CHANGE_PARAM_FAILED_FOR_TWO_WAY_ANOVA_RM_WHEN_USE_XOP
	//tr.DescStats.Interaction.Enable = tr.Interactions.nVal;
	//if( !tr.Interactions.nVal && tr.DescStats.Interaction.nVal)
		//tr.DescStats.Interaction.nVal = 0;
	TreeNode	trGUI = tr.GUI ? tr.GUI : tr;
	trGUI.DescStats.Interaction.Enable = trGUI.Interactions.nVal;
	if( !trGUI.Interactions.nVal && trGUI.DescStats.Interaction.nVal)
		trGUI.DescStats.Interaction.nVal = 0;
	///------ End CHANGE_PARAM_FAILED_FOR_TWO_WAY_ANOVA_RM_WHEN_USE_XOP
	return true;
}

/// Thomas 03/28/06 ADD_ONE_WAY_ANOVA_MEAN_COMP_EVENT
static bool one_way_anova_on_change_mean_comp(TreeNode& trn, int nRow, int nType, Dialog& dlg)
{
	TreeNode tnMeanComp = tree_get_node_by_id(trn, IDST_ANOVA_MEAN_COMP, true);
	if(!tnMeanComp) 
		return false;
	
	TreeNode tnMeanCompGraph = tree_get_node_by_id(trn, IDE_RESULT_GRAPHS+4, true);//4: the index of mean comp graph in ANOVA one way
	if(!tnMeanCompGraph) 
		return false;
	
	/// Iris 7/28/06 CLEANUP_THOMAS_CODES
	bool	bHaveSel = false;
	foreach(TreeNode trSub in tnMeanComp.Children)
	{
		if(TRGP_CHECK == trSub.ID && trSub.nVal || TRGP_BRANCH == trSub.ID && trSub.Use)
			bHaveSel = true;
	}
	///end CLEANUP_THOMAS_CODES
	
	if(tnMeanComp.Use != 0 && bHaveSel) 
	{
		tnMeanCompGraph.Enable = 1;	
	}
	else 		
	{
		tnMeanCompGraph.nVal = 0;
		tnMeanCompGraph.Enable = 0;
	}
	
	return true;
}
/// End ADD_ONE_WAY_ANOVA_MEAN_COMP_EVENT

///Kyle 02/10/2010 QA80-14923 ADD_HINT_TEXT_OF_WHAT_IS_INDEX_AND_RAW_DATA
#define GETN_HINT_INDEX_RAW_DATA			\
GETN_STR(hint_indexed, _L("Indexed: factor variable and response data are stored in separate columns."), "") 					GETN_HINT	\
GETN_STR(hint_raw, _L("Raw: each column contains response data from a level of the factor variable."), "") 						GETN_HINT
///End ADD_HINT_TEXT_OF_WHAT_IS_INDEX_AND_RAW_DATA

/// YuI 09/26/05 ANOVA_DATA_SELECTION_GUI
//	TreeNode ConstructTwoWayANOVAGUITree(TreeNode& tr, int nOption)
TreeNode ConstructTwoWayANOVAGUITree(TreeNode& tr, int nOption, BOOL bRM)
/// end ANOVA_DATA_SELECTION_GUI
{
	GETN_USE(tr)
	///Kyle 02/10/2010 QA80-14923 ADD_HINT_TEXT_OF_WHAT_IS_INDEX_AND_RAW_DATA
	GETN_HINT_INDEX_RAW_DATA
	///End ADD_HINT_TEXT_OF_WHAT_IS_INDEX_AND_RAW_DATA
	tree_construct_add_input_branch(tr, INPUTDATA_RANGES);
	
	/// YuI 09/26/05 ANOVA_DATA_SELECTION_GUI
	// this node has been created in tree_construct_add_input_branch
	TreeNode trInputData = tr.InputData;
	anova_construct_input_gui_tree(trInputData, true, bRM);
	/// end ANOVA_DATA_SELECTION_GUI

	///Iris 12/28/04 REMOVE_HOW_TO_COMPUTER_BRANCH
	/*	
	//string strSelection = _L("<none>");
	GETN_BEGIN_BRANCH(QuanComp, "Quantities to Compute")	
		GETN_CHECK(Interactions, "Interactions", false)
		GETN_OPTION_EVENT(ANOVA2_interaction_event)
		GETN_BEGIN_BRANCH(DescStats, "Descriptive Statistics")
			GETN_CHECK(FactorA, "FactorA", false)
			GETN_CHECK(FactorB, "FactorB", false)
			GETN_CHECK(Overall, "Overall", false)
			GETN_CHECK(Interaction, "Interaction", false)		
		GETN_END_BRANCH(DescStats)
		
		GETN_BEGIN_BRANCH(MeansComp, "Means Comparison")
			GETN_CHECK(Bonferroni, "Bonferroni", false)
			GETN_CHECK(Scheffe, "Scheffe'", false)
			GETN_CHECK(Tukey, "Tukey", false)
			GETN_CHECK(Dunnett, "Dunnett", false)
			GETN_CHECK(FisherLSD, "Fisher LSD'", false)
			GETN_CHECK(DunnSidak, "Dunn-Sidak", false)
			GETN_CHECK(HolmBonf, "Holm-Bonferroni'", false)
			GETN_CHECK(HolmSidak, "Holm-Sidak", false)			
		GETN_END_BRANCH(MeansComp)
		
		GETN_BEGIN_BRANCH(PowerBranch, "Power")
			GETN_CHECK(ActPower, "Actual Power'", false)
			GETN_CHECK(CalcHypotPower, "Powers for Hypothetical Sample Sizes", false)					
			GETN_OPTION_EVENT(anova_power_events)
		GETN_END_BRANCH(PowerBranch)		
	GETN_END_BRANCH(QuanComp)
	
	GETN_BEGIN_BRANCH(CompControl, "Computation Control")
		GETN_NUM(SigLevel, "Significace Level", 0.05)
		GETN_OPTION_EVENT(siglevel_error_msg_event)
		GETN_STR(HypotSizes, "Hypothetical Sample Size(s)", "50 100 200")	
		GETN_OPTION_EVENT(siglevel_error_msg_event)
	GETN_END_BRANCH(CompControl)
	*/
	//GETN_CHECK(Interactions, "Interactions", false)	GETN_ID(IDE_ANOVA2_INTERACT)//Alex 06/05/06 MODIFY_ANOVA_TWO_WAY_MAKE_INTER_CHECKED
	///Arvin 08/09/07 MODIFY_ANOVA_TWO_WAY_MAKE_INTER_UNCHECKED as echo's suggestion
	//GETN_CHECK(Interactions, "Interactions", true)	GETN_ID(IDE_ANOVA2_INTERACT)
	GETN_CHECK(Interactions, _L("Interactions"), false)		GETN_ID(IDE_ANOVA2_INTERACT)
	///end MODIFY_ANOVA_TWO_WAY_MAKE_INTER_UNCHECKED
	GETN_OPTION_EVENT(ANOVA2_interaction_event)
	/// Iris 05/10/2007 v8.0615 REMOVE_BRANCH_CHECK_BOX
	//GETN_BEGIN_BRANCH(DescStats, "Descriptive Statistics")	GETN_CHECKBOX_BRANCH(1) GETN_ID_BRANCH(IDST_ANOVA_DESC_STATS)
	GETN_BEGIN_BRANCH(DescStats, _L("Descriptive Statistics"))	GETN_ID_BRANCH(IDST_ANOVA_DESC_STATS)
	///end REMOVE_BRANCH_CHECK_BOX
		GETN_OPTION_BRANCH(GETNBRANCH_KEEP_SIZE_ON_COLLAPSE) ///Iris 06/30/06 SELECTED_BUT_CLOSED
		GETN_CHECK(FactorA, _L("FactorA"), false)	GETN_ID(IDE_ANOVA2_DESC_A)
		GETN_CHECK(FactorB, _L("FactorB"), false)	GETN_ID(IDE_ANOVA2_DESC_B)
		GETN_CHECK(Overall, _L("Overall"), false)	GETN_ID(IDE_ANOVA2_DESC_ALL) 
		if(bRM) GETN_CURRENT_SUBNODE.Show = false;
		GETN_CHECK(Interaction, _L("Interaction"), false)		GETN_ID(IDE_ANOVA2_DESC_INTERACT)
	
	GETN_END_BRANCH(DescStats)
	//--- Jacky 07/22/10 ORG-102 USER_CAN_SET_SIGNIFICANCE_LEVEL
	GETN_NUM(alpha, _L("Significance Level"), 0.05)	GETN_ID(IDE_TREE_ALPHA) 
	//--- end USER_CAN_SET_SIGNIFICANCE_LEVEL
	/// Iris 05/10/2007 v8.0615 REMOVE_BRANCH_CHECK_BOX
	//GETN_BEGIN_BRANCH(MeansComp, "Means Comparison")	GETN_CHECKBOX_BRANCH(0)	GETN_ID_BRANCH(IDST_ANOVA_MEAN_COMP)
	GETN_BEGIN_BRANCH(MeansComp, _L("Means Comparison"))	GETN_ID_BRANCH(IDST_ANOVA_MEAN_COMP)
	///end REMOVE_BRANCH_CHECK_BOX
		GETN_NUM(SigLevel, _L("Significance Level"), 0.05)	GETN_ID(IDE_MEANCOMP_ALPHA) /// Iris 12/13/05
		GETN_OPTION_EVENT_EX(siglevel_error_msg_event)
		GETN_CHECK(Tukey, _L("Tukey"), false)	GETN_ID(IDE_MEANCOMP_TUKEY)
		GETN_CHECK(Bonferroni, _L("Bonferroni"), false)	GETN_ID(IDE_MEANCOMP_BONF)  ///Iris 3/22/05 ADD_MORE_MEAN_COMPARISON_CASE
		GETN_CHECK(DunnSidak, _L("Dunn-Sidak"), false)	GETN_ID(IDE_MEANCOMP_DUNNSIDAK)
		GETN_CHECK(FisherLSD, _L("Fisher LSD"), false)	GETN_ID(IDE_MEANCOMP_FISHLSD)
		GETN_CHECK(Scheffe, _L("Scheffe'"), false)	GETN_ID(IDE_MEANCOMP_SCHE)
		/// Iris 12/13/05 ADD_CONTROL_LEVEL_FOR_DUNNETT_MEAN_COMP
		//GETN_CHECK(Dunnett, "Dunnett", false)	GETN_ID(IDE_MEANCOMP_DUNNE)
		if(bRM)  /// Iris 05/08/2007 v8.0613 DUNNETT_ONLY_SHOW_FOR_RM_ANOVA, by Max suggestion
		{
			GETN_BEGIN_BRANCH(Dunnett, _L("Dunnett")) GETN_CHECKBOX_BRANCH(0) GETN_ID(IDE_MEANCOMP_DUNNE)
			///Alex 04/17/06 ADD_DEFAULT_COMBOSTR_TO_CONTROL_LEVEL_COMBO
			    //GETN_LIST(CtrlLevel1, "Control Level 1", 0, "") GETN_ID(IDE_MEANCOMP_DUNNE_LEVEL1)
				//GETN_LIST(CtrlLevel2, "Control Level 2", 0, "") GETN_ID(IDE_MEANCOMP_DUNNE_LEVEL2)
			    GETN_LIST(CtrlLevel1, _L("Control Level 1"), 0, _L("FactorA Level1|FactorA Level2")) GETN_ID(IDE_MEANCOMP_DUNNE_LEVEL1)
				GETN_LIST(CtrlLevel2, _L("Control Level 2"), 0, _L("FactorB Level1|FactorB Level2")) GETN_ID(IDE_MEANCOMP_DUNNE_LEVEL2)
			///End ADD_DEFAULT_COMBOSTR_TO_CONTROL_LEVEL_COMBO
			GETN_END_BRANCH(Dunnett)
		}
		///End ADD_CONTROL_LEVEL_FOR_DUNNETT_MEAN_COMP		
		GETN_CHECK(HolmBonf, _L("Holm-Bonferroni"), false)	GETN_ID(IDE_MEANCOMP_HOLMBONF)
		GETN_CHECK(HolmSidak, _L("Holm-Sidak"), false)		GETN_ID(IDE_MEANCOMP_HOLMSIDAK)
	GETN_END_BRANCH(MeansComp)

	if( !bRM )  /// Iris 12/16/05 REMOVE_VARIANCE_POWER_FOR_RM
	{
		/// Iris 05/10/2007 v8.0615 REMOVE_BRANCH_CHECK_BOX
		//GETN_BEGIN_BRANCH(PowerBranch, "Power Analysis")	GETN_CHECKBOX_BRANCH(0)	GETN_ID_BRANCH(IDST_POWER_CONTROL)			
		//------ Folger 11/08/07 CATEGORY_NEEDED_WHEN_LOCALIZE
		//GETN_BEGIN_BRANCH(PowerBranch, _L("Power Analysis"))	GETN_ID_BRANCH(IDST_POWER_CONTROL)
			//GETN_CHECK(ActualPower, _L("Actual Power"), false)	GETN_ID(IDE_POWERS_ACTUAL)  
		GETN_BEGIN_BRANCH(PowerBranch, _LC("Power Analysis", STR_CAT_STATS))	GETN_ID_BRANCH(IDST_POWER_CONTROL)
			GETN_CHECK(ActualPower, _LC("Actual Power", STR_CAT_STATS), false)	GETN_ID(IDE_POWERS_ACTUAL)  
		//------ End CATEGORY_NEEDED_WHEN_LOCALIZE
			GETN_OPTION_EVENT(power_enable_event) ///Arvin 09/27/07 ACTUAL_POWER_SHOULD_ALSO_SUPPORT_SIGLEVEL as Echo said
		///end REMOVE_BRANCH_CHECK_BOX
			//GETN_OPTION_EVENT(power_branch_open)
			//------ Folger 11/08/07 CATEGORY_NEEDED_WHEN_LOCALIZE
			//GETN_CHECK(HypotPower, _L("Hypothetical Power"), false)	GETN_ID(IDE_POWERS_HYPOT)
			GETN_CHECK(HypotPower, _LC("Hypothetical Power", STR_CAT_STATS), false)	GETN_ID(IDE_POWERS_HYPOT)
			//------ End CATEGORY_NEEDED_WHEN_LOCALIZE
			GETN_OPTION_EVENT(power_enable_event)
			GETN_NUM(SigLevel, _L("Significance Level"), 0.05)	GETN_ID(IDE_POWERS_ALPHA)
			/// Iris 06/27/06 TO_NOT_ALLOW_SHOW_ERR_FOR_INIT_TIME
			//GETN_OPTION_EVENT(siglevel_error_msg_event)
			GETN_OPTION_EVENT_EX(siglevel_error_msg_event)
			///End TO_NOT_ALLOW_SHOW_ERR_FOR_INIT_TIME
			GETN_STR(HypotSizes, _L("Hypothetical Sample Size(s)"), "50 100 200")	GETN_ID(IDE_POWERS_SAMPSIZE)
			GETN_OPTION_EVENT_EX(sample_size_error_msg_event)
		GETN_END_BRANCH(PowerBranch)
	}
	///end REMOVE_HOW_TO_COMPUTER_BRANCH
	
	///Arvin 01/07/08 QA70-10903 ADD_CHECK_ALL_BOX_FOR_BRANCH
	int dwBranchAttr = GETNBRANCH_CHECK_CONTROL | GETNBRANCH_CHECK_CONTROL_ONE_EVENT;				;
	TreeNode trDescStats = tr.DescStats;
	if(trDescStats)
		tree_set_branch_attribute_for_branch(trDescStats, dwBranchAttr);
	TreeNode trMeansComp = tr.MeansComp;
	if(trMeansComp)
	{
		dwBranchAttr |= GETNBRANCH_CHECK_CONTROL_SUB_BRANCH | GETNBRANCH_CHECK_CONTROL_NONRECURSIVE;
		tree_set_branch_attribute_for_branch(trMeansComp, dwBranchAttr);
	}
	///end ADD_CHECK_ALL_BOX_FOR_BRANCH

	return tr;
}


/// YuI 09/26/05 ANOVA_DATA_SELECTION_GUI
//	TreeNode ConstructOneWayANOVAGUITree(TreeNode& tr, int nOption)
TreeNode ConstructOneWayANOVAGUITree(TreeNode& tr, int nOption, BOOL bRM)
/// end ANOVA_DATA_SELECTION_GUI
{
	GETN_USE(tr)
	///Kyle 02/10/2010 QA80-14923 ADD_HINT_TEXT_OF_WHAT_IS_INDEX_AND_RAW_DATA
	GETN_HINT_INDEX_RAW_DATA
	///End ADD_HINT_TEXT_OF_WHAT_IS_INDEX_AND_RAW_DATA
	tree_construct_add_input_branch(tr, INPUTDATA_RANGES);

	/// YuI 09/26/05 ANOVA_DATA_SELECTION_GUI
	// this node has been created in tree_construct_add_input_branch
	TreeNode trInputData = tr.InputData;
	anova_construct_input_gui_tree(trInputData, false, bRM);
	/// end ANOVA_DATA_SELECTION_GUI
	
	///Arvin 08/30/07 RESTRICT_ONLY_ALLOW_ONE_COL_INPUT_DATA_IN_ONE_WAY_ANOVA as Max said
	/// YuI 09/10/07 QA70-10359 RESTRICT_ANOVA_INDEXED_DATA_TO_ONE_COLUMN
	//	if(!bRM)
	//		trInputData.SetAttribute(STR_INTERACTIVE_CONTROL_OPTIONS_ATTRIB, ICOPT_RESTRICT_TO_ONE_DATA);
	/// end RESTRICT_ANOVA_INDEXED_DATA_TO_ONE_COLUMN
	///end RESTRICT_ONLY_ALLOW_ONE_COL_INPUT_DATA
	
	///Iris 12/28/04 REMOVE_HOW_TO_COMPUTER_BRANCH
	/*
	GETN_BEGIN_BRANCH(QuanComp, "Quantities to Compute")
		GETN_CHECK(DescStats, "Descriptive Statistics", true)
		
		GETN_BEGIN_BRANCH(MeansComp, "Means Comparison")
			GETN_CHECK(Bonferroni, "Bonferroni", false)
			GETN_CHECK(Scheffe, "Scheffe'", false)
			GETN_CHECK(Tukey, "Tukey", false)
			GETN_CHECK(Dunnett, "Dunnett", false)
			GETN_CHECK(FisherLSD, "Fisher LSD'", false)
			GETN_CHECK(DunnSidak, "Dunn-Sidak", false)
			GETN_CHECK(HolmBonf, "Holm-Bonferroni'", false)
			GETN_CHECK(HolmSidak, "Holm-Sidak", false)	
		GETN_END_BRANCH(MeansComp)
	
		GETN_BEGIN_BRANCH(EqualVar, "Tests for Equal Variance")
			GETN_CHECK(Levene, "Levene   |   |", false)
			GETN_CHECK(Levene2, "Levene   (   )^2", false)
			GETN_CHECK(BrownForsythe, "Brown-Forsythe", false)		
		GETN_END_BRANCH(EqualVar)		
		
		GETN_BEGIN_BRANCH(PowerBranch, "Power")
			GETN_CHECK(ActPower, "Actual Power'", false)
			GETN_CHECK(CalcHypotPower, "Powers for Hypothetical Sample Sizes", false)					
			GETN_OPTION_EVENT(anova_power_events)
		GETN_END_BRANCH(PowerBranch)		
	GETN_END_BRANCH(QuanComp)	
	
	GETN_BEGIN_BRANCH(CompControl, "Computation Control")
		GETN_NUM(SigLevel, "Significace Level", 0.05)
		GETN_OPTION_EVENT(siglevel_error_msg_event)
		GETN_STR(HypotSizes, "Hypothetical Sample Size(s)", "50 100 200")	
		GETN_OPTION_EVENT(anova_sample_size_error_msg_event)
	GETN_END_BRANCH(CompControl)
	*/
	
	///Iris 12/28/04 REMOVE_HOW_TO_COMPUTER_BRANCH
	GETN_CHECK(DescStats, _L("Descriptive Statistics"), true)	GETN_ID(IDE_DESC_STATS)
	//--- Jacky 07/22/10 ORG-102 USER_CAN_SET_SIGNIFICANCE_LEVEL
    GETN_NUM(alpha, _L("Significance Level"), 0.05)	GETN_ID(IDE_TREE_ALPHA) 
	//--- end USER_CAN_SET_SIGNIFICANCE_LEVEL
	/// Iris 05/10/2007 v8.0615 REMOVE_BRANCH_CHECK_BOX
	//GETN_BEGIN_BRANCH(MeansComp, "Means Comparison") GETN_CHECKBOX_BRANCH(0) GETN_ID_BRANCH(IDST_ANOVA_MEAN_COMP) GETN_OPTION_EVENT(one_way_anova_on_change_mean_comp) /// Thomas 03/28/06 ADD_ONE_WAY_ANOVA_MEAN_COMP_EVENT
	GETN_BEGIN_BRANCH(MeansComp, _L("Means Comparison")) GETN_ID_BRANCH(IDST_ANOVA_MEAN_COMP) GETN_OPTION_EVENT(one_way_anova_on_change_mean_comp)
	///end REMOVE_BRANCH_CHECK_BOX
		//GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
		//GETN_NUM(SigLevel, "Significace Level", 0.05)   /// Iris 10/08/04
		GETN_NUM(SigLevel, _L("Significance Level"), 0.05)	GETN_ID(IDE_MEANCOMP_ALPHA) 
		/// Iris 06/27/06 TO_NOT_ALLOW_SHOW_ERR_FOR_INIT_TIME
		//GETN_OPTION_EVENT(siglevel_error_msg_event)
		GETN_OPTION_EVENT_EX(siglevel_error_msg_event)
		///End TO_NOT_ALLOW_SHOW_ERR_FOR_INIT_TIME
		GETN_CHECK(Tukey, _L("Tukey"), false)	GETN_ID(IDE_MEANCOMP_TUKEY) GETN_OPTION_EVENT(one_way_anova_on_change_mean_comp)
		GETN_CHECK(Bonferroni, _L("Bonferroni"), false)	GETN_ID(IDE_MEANCOMP_BONF)   GETN_OPTION_EVENT(one_way_anova_on_change_mean_comp)
		GETN_CHECK(DunnSidak, _L("Dunn-Sidak"), false)	GETN_ID(IDE_MEANCOMP_DUNNSIDAK) GETN_OPTION_EVENT(one_way_anova_on_change_mean_comp)
		GETN_CHECK(FisherLSD, _L("Fisher LSD"), false)	GETN_ID(IDE_MEANCOMP_FISHLSD) GETN_OPTION_EVENT(one_way_anova_on_change_mean_comp)
		GETN_CHECK(Scheffe, _L("Scheffe'"), false)	GETN_ID(IDE_MEANCOMP_SCHE) GETN_OPTION_EVENT(one_way_anova_on_change_mean_comp)
		/// Iris 12/13/05 ADD_CONTROL_LEVEL_FOR_DUNNETT_MEAN_COMP
		//GETN_CHECK(Dunnett, "Dunnett", false)	GETN_ID(IDE_MEANCOMP_DUNNE)	
		if(bRM)  /// Iris 05/08/2007 v8.0613 DUNNETT_ONLY_SHOW_FOR_RM_ANOVA, by Max suggestion
		{
			GETN_BEGIN_BRANCH(Dunnett, _L("Dunnett")) GETN_CHECKBOX_BRANCH(0) GETN_ID(IDE_MEANCOMP_DUNNE) GETN_OPTION_EVENT(one_way_anova_on_change_mean_comp)
			///Alex 04/17/06 ADD_DEFAULT_COMBOSTR_TO_CONTROL_LEVEL_COMBO  
			//   GETN_LIST(CtrlLevel1, "Control Level ", 0, "") GETN_ID(IDE_MEANCOMP_DUNNE_LEVEL1)
			     GETN_LIST(CtrlLevel1, _L("Control Level "), 0, _L("Level1|Level2")) GETN_ID(IDE_MEANCOMP_DUNNE_LEVEL1)
			///End  ADD_DEFAULT_COMBOSTR_TO_CONTROL_LEVEL_COMBO
			GETN_END_BRANCH(Dunnett)
		}
		///End ADD_CONTROL_LEVEL_FOR_DUNNETT_MEAN_COMP
		GETN_CHECK(HolmBonf, _L("Holm-Bonferroni"), false)	GETN_ID(IDE_MEANCOMP_HOLMBONF) GETN_OPTION_EVENT(one_way_anova_on_change_mean_comp)
		GETN_CHECK(HolmSidak, _L("Holm-Sidak"), false)		GETN_ID(IDE_MEANCOMP_HOLMSIDAK) GETN_OPTION_EVENT(one_way_anova_on_change_mean_comp)
		
	GETN_END_BRANCH(MeansComp)

	if( !bRM )  /// Iris 12/16/05 REMOVE_VARIANCE_POWER_FOR_RM
	{
		/// Iris 05/10/2007 v8.0615 REMOVE_BRANCH_CHECK_BOX
		//GETN_BEGIN_BRANCH(EqualVar, "Tests for Equal Variance") GETN_CHECKBOX_BRANCH(0)		GETN_ID_BRANCH(IDST_ANOVA_EQUA_VAR)
		GETN_BEGIN_BRANCH(EqualVar, _L("Tests for Equal Variance")) GETN_ID_BRANCH(IDST_ANOVA_EQUA_VAR)
		///end REMOVE_BRANCH_CHECK_BOX
			//GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
			//GETN_NUM(SigLevel, "Significace Level", 0.05)  /// Iris 10/08/04
			//GETN_CHECK(Levene, "Levene", false)
			//GETN_CHECK(LeveneSQ, "Levene^2", false)		
			//GETN_CHECK(BrownForsythe, "Brown-Forsythe", false)
			/// Max 9/27/08 QA70-12295 v8.0948d PROPER_NOUN_NEEDS_NO_LOCALIZATION
			/// strings like ||, ()^2 should not be included in localization too
			//GETN_CHECK(Levene, _L("Levene   |   |"), false)	GETN_ID(IDE_EQUAVAR_LEVEN)
			//GETN_CHECK(Levene2, _L("Levene   (   )^2"), false)	GETN_ID(IDE_EQUAVAR_LEVEN2)
			//GETN_CHECK(BrownForsythe, _L("Brown-Forsythe"), false)	GETN_ID(IDE_EQUAVAR_BROWNFORS)
			//--- Jacky 07/22/10 ORG-102 USER_CAN_SET_SIGNIFICANCE_LEVEL
			GETN_NUM(sigVariance, _L("Significance Level"), 0.05)	GETN_ID(IDE_EQUAVAR_ALPHA)
			//--- end USER_CAN_SET_SIGNIFICANCE_LEVEL
			GETN_CHECK(Levene, "Levene   |   |", false)	GETN_ID(IDE_EQUAVAR_LEVEN)
			GETN_CHECK(Levene2, "Levene   (   )^2", false)	GETN_ID(IDE_EQUAVAR_LEVEN2)
			GETN_CHECK(BrownForsythe, "Brown-Forsythe", false)	GETN_ID(IDE_EQUAVAR_BROWNFORS)
			/// END PROPER_NOUN_NEEDS_NO_LOCALIZATION
		GETN_END_BRANCH(EqualVar)
	
		/// Iris 05/10/2007 v8.0615 REMOVE_BRANCH_CHECK_BOX
		//GETN_BEGIN_BRANCH(PowerBranch, "Power Analysis")	GETN_CHECKBOX_BRANCH(0)	GETN_ID_BRANCH(IDST_POWER_CONTROL)
		//------ Folger 11/08/07 CATEGORY_NEEDED_WHEN_LOCALIZE
		//GETN_BEGIN_BRANCH(PowerBranch, _L("Power Analysis"))	GETN_ID_BRANCH(IDST_POWER_CONTROL)
			//GETN_CHECK(ActualPower, _L("Actual Power"), false)	GETN_ID(IDE_POWERS_ACTUAL)
		GETN_BEGIN_BRANCH(PowerBranch, _LC("Power Analysis", STR_CAT_STATS))	GETN_ID_BRANCH(IDST_POWER_CONTROL)
			GETN_CHECK(ActualPower, _LC("Actual Power", STR_CAT_STATS), false)	GETN_ID(IDE_POWERS_ACTUAL)
		//------ End CATEGORY_NEEDED_WHEN_LOCALIZE
			GETN_OPTION_EVENT(power_enable_event) ///Arvin 09/27/07 ACTUAL_POWER_SHOULD_ALSO_SUPPORT_SIGLEVEL as Echo said
		////end REMOVE_BRANCH_CHECK_BOX
			//GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
			//GETN_CHECK(CalcHypotPower, "Hypothetical Power", false)
			//------ Folger 11/08/07 CATEGORY_NEEDED_WHEN_LOCALIZE
			//GETN_CHECK(HypotPower, _L("Hypothetical Power"), false)	GETN_ID(IDE_POWERS_HYPOT)
			GETN_CHECK(HypotPower, _LC("Hypothetical Power", STR_CAT_STATS), false)	GETN_ID(IDE_POWERS_HYPOT)
			//------ End CATEGORY_NEEDED_WHEN_LOCALIZE
			//GETN_OPTION_EVENT(test_power_events)
			GETN_OPTION_EVENT(power_enable_event)
			GETN_NUM(SigLevel, _L("Significance Level"), 0.05)	GETN_ID(IDE_POWERS_ALPHA) 
			/// Iris 06/27/06 TO_NOT_ALLOW_SHOW_ERR_FOR_INIT_TIME
			//GETN_OPTION_EVENT(siglevel_error_msg_event)
			GETN_OPTION_EVENT_EX(siglevel_error_msg_event)
			///End TO_NOT_ALLOW_SHOW_ERR_FOR_INIT_TIME
			GETN_STR(HypotSizes, _L("Hypothetical Sample Size(s)"), "50 100 200")
			GETN_OPTION_EVENT_EX(sample_size_error_msg_event)	GETN_ID(IDE_POWERS_SAMPSIZE)
		GETN_END_BRANCH(PowerBranch)
	}
	
	///Arvin 01/07/08 QA70-10903 ADD_CHECK_ALL_BOX_FOR_BRANCH
	int dwBranchAttr = GETNBRANCH_CHECK_CONTROL | GETNBRANCH_CHECK_CONTROL_ONE_EVENT;	
	TreeNode trMeansComp = tr.MeansComp;
	if(trMeansComp)
	{
		dwBranchAttr |= GETNBRANCH_CHECK_CONTROL_SUB_BRANCH | GETNBRANCH_CHECK_CONTROL_NONRECURSIVE;
		tree_set_branch_attribute_for_branch(trMeansComp, dwBranchAttr);
	}
	TreeNode trEqualVar = tr.EqualVar;
	if(trEqualVar)
	{	
		tree_set_branch_attribute_for_branch(trEqualVar, dwBranchAttr);
	}
	///end ADD_CHECK_ALL_BOX_FOR_BRANCH
	return tr;
}

/*
void GetTwoWayANOVAParams()
{
	string strSelection = _L("<none>");

	GETN_TREE(tr)

	GETN_INTERACTIVE(DepVar, "Dependent Variable", strSelection)
	GETN_INTERACTIVE(FactorA, "Factor A Classification Variable", "")
	GETN_INTERACTIVE(FactorB, "Factor B Classification Variable", "")

	GETN_NUM(SigLevel, "Significance Level", 0.05)

	GETN_CHECK(Interactions, "Interactions", false)

	GETN_BEGIN_BRANCH(MeansComp, "Means Comparison")
		GETN_CHECK(Bonferroni, "Bonferroni", false)
		GETN_CHECK(Scheffe, "Scheffe'", false)
		GETN_CHECK(Tukey, "Tukey", false)
	GETN_END_BRANCH(MeansComp)

	GETN_BEGIN_BRANCH(Power, "Power Analysis")
		GETN_CHECK(Power, "Power Analysis", false)
		GETN_NUM(SigLevel, "Significace Level", 0.05)
		GETN_STR(SampleSizes, "Sample Size(s)","50 100 200")
	GETN_END_BRANCH(Power)

	GETN_BEGIN_BRANCH(Report, "Report")
		GETN_LIST(Location, "Location", 0, _L("Book|Console|None"));
		GETN_LIST(Book, "Book", 0, "Data1|<new>|Data2|Data3");
		GETN_LIST(Sheet,"Sheet", 0, "<new>|Sheet1|Sheet2|Sheet3");
		GETN_BEGIN_BRANCH(Results, "Results")
			GETN_BUTTON(ANOVATableTheme, "ANOVA Table Theme", "<last used>");
			GETN_BUTTON(MeansCompTableTheme, "Means Comparison Table Theme", "<last used>");
			GETN_BUTTON(PowerTableTheme, "Power Table Theme", "<last used>");
			GETN_CHECK(MeansPlot, "Means Plot", true)
			GETN_BUTTON(MeansPlotTheme, "Means Plot Theme", "<last used>");
			GETN_CHECK(MeansCompPlot, "Means Comparison Plot", true)
			GETN_BUTTON(MeansCompPlotTheme, "Means Comparison Theme", "<last used>");
		GETN_END_BRANCH(Results)
	GETN_END_BRANCH(Report)

	GetNBox(tr, "Two-Way ANOVA", "Enter Two-Way ANOVA parameters",
		TwoWayANOVAApplyOnClick, TwoWayANOVADialogOnChangeEvent);
}
*/
bool TwoWayANOVAApplyOnClick(TreeNode& tr)
{
//	out_str("\n-----from inside function DescStatApplyOnClick\n");
//	out_tree(tr);
//	out_str("-----exit from DescStatApplyOnClick\n");
	return false;
}

bool TwoWayANOVADialogOnChangeEvent(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
{
//	out_str("\n-----from inside function DescStatDialogOnChangeEvent\n");

	// Output GetN tree, nRow, and nType
//	out_tree(tr);
//	printf("nRow = %d  nType = %d\n\n\n", nRow, nType);

	if( TRGP_CHECK == nType ) // If checkbox node is changed
	{
		//if( tr.Statistics.Percentiles.CustomPercentiles.nVal ) // If custom percentiles wanted...
			//tr.Statistics.Percentiles.PercentileList.Enable = true; // Show percentile list
		//else
			//tr.Statistics.Percentiles.PercentileList.Enable = false; // Else do not show percentile list
		//
		//if( tr.Report.Results.StatResults.nVal ) // If statistics results wanted...
			//tr.Report.Results.StatResultsTheme.Enable = true; // Show theme for statistics results
		//else
			//tr.Report.Results.StatResultsTheme.Enable = false; // Else do not show theme for statistics results
//
		//if( tr.Report.Results.Histogram.nVal ) // If histogram wanted...
			//tr.Report.Results.HistogramTheme.Enable = true; // Show theme for histogram
		//else
			//tr.Report.Results.HistogramTheme.Enable = false; // Else do not show theme for histogram
//
		//if( tr.Report.Results.BoxChart.nVal ) // If box chart wanted...
			//tr.Report.Results.BoxChartTheme.Enable = true; // Show theme for box chart
		//else
			//tr.Report.Results.BoxChartTheme.Enable = false; // Else do not show theme for box chart
	}
//	out_str("-----exit from DescStatDialogOnChangeEvent\n");

	return true; // Return true to indicate update of display is needed
}

//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//////////                  FindXY Tool					                //////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
/*
	nOption: 0, active page is Graph; 1, active page is Worksheet
*/
/// Max 10/30/07 NOT_USED_FUNCTION
/*
TreeNode ConstructFindXYGUITree(TreeNode& tr, int nOption)
{
	GETN_USE(tr)
	tree_construct_add_input_branch(tr, INPUTDATA_SINGLE_CURVE);
	
	GETN_LIST( InterpolateOn, _L("Interplate On"), 0, _L("<Raw Data>"))
	
	GETN_LIST( InterpolateType, _L("InterpolateType"), 0, _L("Linear |Spline |B-Spline"))
	
	GETN_LIST( Find, _L("Find"), 0, _L("Y for given X |X for given Y"))
	
	GETN_LIST( InputFormat, _L("Input X/Y Format"), 0, _L("Values |DataRange"))
	GETN_OPTION_EVENT(FindXY_InputFormat_event);	
	GETN_STR( InputValue, _L("Input X/Y Values"), _L("") )	//for value
	GETN_INTERACTIVE( InputDataRange, _L("Input X/Y Data Range"), "") //for data range
	
	tr.	InputDataRange.Enable = 0;
	
	return tr;
}


bool FindXY_InputFormat_event(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
{
	int nFormat = tr.InputFormat.nVal;
	
	tr.InputValue.Enable = !nFormat;
	tr.InputDataRange.Enable = nFormat;
	
	return true;
}

TreeNode Construct2DBinningGUITree(TreeNode& tr, int nOption)
{
	GETN_USE(tr)
	tree_construct_add_input_branch(tr, INPUTDATA_SINGLE_CURVE);
	
	GETN_BEGIN_BRANCH(CompControl, _L("Computation Control")) GETN_ID_BRANCH(IDE_2DBINNING_CONTROL)	///Liko 06/20/2005 CONSTRUCT_2D_BINNING_GUI_TREE_ADD_DATAID
		GETN_BEGIN_BRANCH(X, _L("X")) GETN_ID_BRANCH(IDE_2DBINNING_X)	///Liko 06/20/2005 CONSTRUCT_2D_BINNING_GUI_TREE_ADD_DATAID
			///Liko 6/14/2005 UPDATE_CONSTRUCT_2D_BINNING_GUI_TREE
			//Same initialization as v75
			//GETN_NUM(XMin, "X Minimum", NANUM)
			//GETN_NUM(XMax, "X Maximum", NANUM)
			//GETN_NUM(XInc, "X Increment", NANUM)
			GETN_NUM(XMin, _L("X Minimum"), 0) GETN_ID(IDE_2DBINNING_XMIN)	///Liko 06/20/2005 CONSTRUCT_2D_BINNING_GUI_TREE_ADD_DATAID
			GETN_NUM(XMax, _L("X Maximum"), 51) GETN_ID(IDE_2DBINNING_XMAX)	///Liko 06/20/2005 CONSTRUCT_2D_BINNING_GUI_TREE_ADD_DATAID
			GETN_NUM(XInc, _L("X Increment"), 0.5) GETN_ID(IDE_2DBINNING_XINC)	///Liko 06/20/2005 CONSTRUCT_2D_BINNING_GUI_TREE_ADD_DATAID
			//END UPDATE_CONSTRUCT_2D_BINNING_GUI_TREE
			GETN_CHECK(IncMinOutliers, _L("Include Outliers < Minimum"), false) GETN_ID(IDE_2DBINNING_XINCMIN)	///Liko 06/20/2005 CONSTRUCT_2D_BINNING_GUI_TREE_ADD_DATAID
			GETN_CHECK(IncMaxOutliers, _L("Include Outliers >= Maximum"), false) GETN_ID(IDE_2DBINNING_XINCMAX)	///Liko 06/20/2005 CONSTRUCT_2D_BINNING_GUI_TREE_ADD_DATAID
		GETN_END_BRANCH(X)
		
		GETN_BEGIN_BRANCH(Y, _L("Y")) GETN_ID_BRANCH(IDE_2DBINNING_Y)
			///Liko 6/14/2005 UPDATE_CONSTRUCT_2D_BINNING_GUI_TREE
			//Same initialization as v75
			//GETN_NUM(YMin, "Y Minimum", NANUM)
			//GETN_NUM(YMax, "Y Maximum", NANUM)
			//GETN_NUM(YInc, "Y Increment", NANUM)
			GETN_NUM(YMin, _L("Y Minimum"), 0) GETN_ID(IDE_2DBINNING_YMIN)	///Liko 06/20/2005 CONSTRUCT_2D_BINNING_GUI_TREE_ADD_DATAID
			GETN_NUM(YMax, _L("Y Maximum"), 51) GETN_ID(IDE_2DBINNING_YMAX)	///Liko 06/20/2005 CONSTRUCT_2D_BINNING_GUI_TREE_ADD_DATAID
			GETN_NUM(YInc, _L("Y Increment"), 0.5) GETN_ID(IDE_2DBINNING_YINC)	///Liko 06/20/2005 CONSTRUCT_2D_BINNING_GUI_TREE_ADD_DATAID
			//END UPDATE_CONSTRUCT_2D_BINNING_GUI_TREE
			GETN_CHECK(IncMinOutliers, _L("Include Outliers < Minimum"), false) GETN_ID(IDE_2DBINNING_YINCMIN)	///Liko 06/20/2005 CONSTRUCT_2D_BINNING_GUI_TREE_ADD_DATAID
			GETN_CHECK(IncMaxOutliers, _L("Include Outliers >= Maximum"), false) GETN_ID(IDE_2DBINNING_YINCMAX)	///Liko 06/20/2005 CONSTRUCT_2D_BINNING_GUI_TREE_ADD_DATAID
		GETN_END_BRANCH(Y)
	GETN_END_BRANCH(CompControl)
	
	return tr;
}

TreeNode ConstructFFTFilterGUITree(TreeNode &tr, int nOption)
{
	GETN_USE(tr)
	tree_construct_add_input_branch(tr, INPUTDATA_CURVES);
	
	GETN_BEGIN_BRANCH(Options, _L("FFT Filtering Options")) GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
		GETN_LIST(Type, _L("Type"), 0, _L("Low Pass|High Pass|Band Pass|Band Reject"))
		GETN_STR(Frequency1, _L("Frequency1"), _L(""))
		GETN_STR(Frequency2, _L("Frequency2"), _L(""))
	GETN_END_BRANCH(Options)
	
	return tr;
}

TreeNode ConstructConvoluteGUITree(TreeNode &tr, int nOption)
{
	GETN_USE(tr)
	tree_construct_add_input_branch(tr, INPUTDATA_CURVES);
	
	GETN_CHECK(Deconvolute, _L("Deconvolute"), 0)
	
	return tr;
}

TreeNode ConstructCorrelateGUITree(TreeNode &tr, int nOption)
{
	GETN_USE(tr)
	tree_construct_add_input_branch(tr, INPUTDATA_CURVES);
	
	GETN_BEGIN_BRANCH(Options, _L("Options")) GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
		GETN_COMBO(Method, _L("Method"), 0, _L("Linear|Circular"))
	GETN_END_BRANCH(Options)
	
	return tr;
}

TreeNode ConstructFFTGUITree(TreeNode &tr, int nOption)
{
	GETN_USE(tr)
	tree_construct_add_input_branch(tr, INPUTDATA_CURVES);
	
	GETN_BEGIN_BRANCH(Options, _L("Options")) GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
		GETN_LIST(Direction, _L("Direction"), 0, _L("Forward|Backward"))
		GETN_LIST(Spectrum, _L("Spectrum"), 0, _L("Amplitude|Power"))
		GETN_STR(Interval, _L("Sampling Interval"), _L(""))
		GETN_LIST(Method, _L("Window Method"), 0, _L("Rectangular|Welch|Hanning|Hamming|Blackman"))
		GETN_CHECK(NormalizeAmplitude, _L("Normalize Amplitude"), 0)
		GETN_CHECK(ShiftResults, _L("Shift Results"), 0)
		GETN_CHECK(UnwrapPhase, _L("Unwrap Phase"), 0)
		GETN_LIST(ExponentialPhaseFactor, _L("Exponential Phase Factor"), 0, _L("-1 (Electrical Engineering)|+1 (Science)"))
	GETN_END_BRANCH(Options)
	
	return tr;
}
*/
/// END NOT_USED_FUNCTION

//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//////////                  Multiple Linear Regression                  //////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////

//void GetMultipleLinearRegressionParams()
//{
////	string strSelectionRange = GetSingleColumnWksSelection();
//
	//GETN_TREE(tr)
//
	//GETN_BUTTON(DepVar, "Dependent Variable", "Data1_B[1]:B[30]"); // strSelectionRange)
	//GETN_BUTTON(IndepVar, "Independent Variables", "Data1_C[1]:F[30]"); // strSelectionRange)
//
	//GetNBox(tr, "Multiple Linear Regression", "Enter Multiple Linear Regression parameters", ApplyOnClick); //, DialogOnChangeEvent);
//}

//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//////////                    Kaplan-Meier Estimator                    //////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
///Echo 10/26/07 NOT_USED_FUNCTION
///the feature has been done in XF. these code won't be used anymore
//bool sa_censor_list_event(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
//{
	//TreeNode trSA = tr.OptionBranch;
	//string strCensVal = trSA.CensVal.strVal;
	//vector<string> vCensVals;
	//strCensVal.TrimLeft();
	//int nCensVals = strCensVal.GetTokens(vCensVals, ' ');
	//for (int ii = 0; ii < nCensVals; ii++)
		//if (trSA.CensorList.strVal == vCensVals[ii])		
			//return true;
	//if (!trSA.CensVal.strVal.IsEmpty())
		//trSA.CensVal.strVal = trSA.CensVal.strVal+ ' ' + trSA.CensorList.strVal;
	//else 
	//{
		//trSA.CensVal.strVal = ' ';
		//return true;
	//}
	//trSA.CensVal.Enable = true;
	//return true;
//}
//
//TreeNode ConstructKaplanMeierGUITree(TreeNode& tr, int nOption)
//{
	//GETN_USE(tr)
	//tree_construct_add_input_branch(tr, INPUTDATA_RANGES);
	//
	//GETN_BEGIN_BRANCH(OptionBranch, _L("Computation Control"))
		//GETN_STR(CensVal, _L("Censoring Values"), _L("")) GETN_READ_ONLY	GETN_ID(IDE_KAPLAN_MEIER_CENSVAL)
		//GETN_STR(CensorList ,_L("Censor List"), "0")
		//tr.OptionBranch.CensorList.SetAttribute(STR_COMBO_ATTRIB, _L("0|1|2|3|4|5"));
		//GETN_OPTION_EVENT(sa_censor_list_event)
		//GETN_NUM(ConfLevel, _L("Confidence Level"), 0.95)	GETN_ID(IDE_KAPLAN_MEIER_CONFLEVEL)
	/////Kevin 09/06/05 ADD_MORE_GUI_OPTION_FOR_KAPLAN_MEIER_GUI_TREE
		//GETN_CHECK(ValueSummary, _L("Event and Censor Value Summary"), TRUE)	GETN_ID(IDE_KAPLAN_MEIER_SUMMARY)
		//GETN_CHECK(QuaEstimate, _L("Quartile Estimates"), TRUE)		GETN_ID(IDE_KAPLAN_MEIER_ESTIMATE)
		//GETN_CHECK(PlotInOneGraph, _L("Plot all surival curves in one graph"), TRUE)	GETN_ID(IDE_KAPLAN_MEIER_POLT)
	/////End ADD_MORE_GUI_OPTION_FOR_KAPLAN_MEIER_GUI_TREE
	//GETN_END_BRANCH(OptionBranch) 	
//
	//return tr;
//}
//
////void GetKaplanMeierEstimatorParams()
////{
//////	string strSelectionRange = GetSingleColumnWksSelection();
////
	////GETN_TREE(tr)
////
	////GETN_BUTTON(TimeVar, "Time Variable", "Data1_B[1]:B[30]"); // strSelectionRange)
	////GETN_BUTTON(CensorVar, "Censor Variable", "Data1_C[1]:C[30]"); // strSelectionRange)
	////GETN_BUTTON(GroupVars, "Grouping Variable(s)", "Data1_D[1]:D[30]"); // strSelectionRange)
////
	////GETN_NUM(CensorVal,"Censor Value", 0)
////
	////GETN_NUM(ConfLevel,"Confidence Level", 0.95)
////
	////GETN_BEGIN_BRANCH(Results, "Survival Plot")
		////GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
		////GETN_CHECK(SurvivalPlot, "Survival Plot", true)
		////GETN_CHECK(Errors, "Plot Errors", true)
		////GETN_CHECK(AsBars, "As Error Bars", false)
		////GETN_CHECK(CensoredPoints, "Indicate Censored Points", false)
		////GETN_CHECK(FailurePoints, "Indicate Failure Points", false)
		////GETN_CHECK(PercentageScale, "Use Percentage Scale", false)
	////GETN_END_BRANCH(Results)
////
	////GetNBox(tr, "Kaplan-Meier Estimator", "Enter Kaplan-Meier Estimator parameters", ApplyOnClickPro); //, DialogOnChangeEvent);
////}
///end NOT_USED_FUNCTION

//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//////////                Cox Proportional Hazards Model                //////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
///Echo 10/26/07 NOT_USED_FUNCTION
///the feature has been done in XF. these code won't be used anymore
//TreeNode ConstructCoxPHMGUITree(TreeNode& tr, int nOption)
//{
	//GETN_USE(tr)
	//tree_construct_add_input_branch(tr, INPUTDATA_RANGES);
	//
	//GETN_BEGIN_BRANCH(OptionBranch, _L("Computation Control"))
		//GETN_STR(CensVal, _L("Censoring Values"), _L("")) GETN_READ_ONLY
		//GETN_STR(CensorList ,_L("Censor List"), "0")
		//tr.OptionBranch.CensorList.SetAttribute(STR_COMBO_ATTRIB, _L("0|1|2|3|4|5"));
		//GETN_OPTION_EVENT(sa_censor_list_event)
	//GETN_END_BRANCH(OptionBranch) 	
//
	//return tr;
//}
//
////void GetCoxProportionalHazardsModelParams()
////{
//////	string strSelectionRange = GetSingleColumnWksSelection();
////
	////GETN_TREE(tr)
////
	////GETN_BUTTON(TimeVar, "Time Variable", "Data1_B[1]:B[30]"); // strSelectionRange)
	////GETN_BUTTON(CensorVar, "Censor Variable", "Data1_C[1]:C[30]"); // strSelectionRange)
	////GETN_BUTTON(Covariates, "Covariates", "Data1_D[1]:D[30]"); // strSelectionRange)
	////GETN_BUTTON(GroupVars, "Grouping Variable(s)", "Data1_E[1]:E[30]"); // strSelectionRange)
////
	////GETN_NUM(CensorVal,"Censor Value", 0)
////
	////GETN_BEGIN_BRANCH(Results, "Survival Plot")
		////GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
		////GETN_CHECK(SurvivalPlot, "Survival Plot", true)
		////GETN_CHECK(CensoredPoints, "Indicate Censored Points", false)
		////GETN_CHECK(FailurePoints, "Indicate Failure Points", false)
		////GETN_CHECK(PercentageScale, "Use Percentage Scale", false)
	////GETN_END_BRANCH(Results)
////
	////GetNBox(tr, "Cox Proportional Hazards Model", "Enter Cox Proportional Hazards Model parameters", ApplyOnClickPro); //, DialogOnChangeEvent);
////}
//
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
////////////                Cox Proportional Hazards Model                //////////
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
//
////bool ApplyOnClick(TreeNode& tr)
////{
	////out_str("\n-----from inside function ApplyOnClick");
	////out_tree(tr);
	////out_str("-----exit from ApplyOnClick\n");
	////return false;
////}
//
////
////bool DialogOnChangeEvent(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
////{
	////out_tree(tr);
	////return true;
//
////bool GetSingleColumnDataRange(TreeNode& tr, int nRow, int nCntrlType, Dialog& getNDlg)
////{
	////string str = GetSingleColumnWksSelection();
	////if( !str.IsEmpty() )
	////{
		////tr.Sample.strVal = str;
		////return true;
	////}
	////else
		////return false;
////}
////
////bool UpdateAlternateHypotheses(TreeNode& tr, int nRow, int nCntrlType, Dialog& getNDlg)
////{
	////string strAltHypots = ONE_SAMPLE_ALT_HYPOTS;
	////string strLocalizedTestMean = LocalizeDouble( tr.Hypotheses.TestMean.dVal, "%g");
	////strAltHypots.Replace("#", strLocalizedTestMean);
	////tr.Hypotheses.Alternate.SetAttribute(STR_COMBO_ATTRIB, strAltHypots);
	////return true;
////}
////
////bool EnableConfIntervals(TreeNode& tr, int nRow, int nCntrlType, Dialog& getNDlg)
////{
	////tr.ConfIntervals.Levels.Enable = tr.ConfIntervals.ConfIntervals.nVal;
	////return true;
////}
////
////bool EnablePower(TreeNode& tr, int nRow, int nCntrlType, Dialog& getNDlg)
////{
	////tr.Power.SigLevel.Enable = tr.Power.Power.nVal;
	////tr.Power.SampleSizes.Enable = tr.Power.Power.nVal;
	////return true;
////}
////
////string GetSingleColumnWksSelection()
////{
	////string strSelectedRange;
	////int iNumRanges;
////
	////if( !GetNonContiguousWksSelection(strSelectedRange, iNumRanges) ) // Get current selection range...if selection exists...
	////{
		////if( iNumRanges == 1 )                                         // If selection range is in single column...
		////{
			////string strWksName, strSheetName;
			////int iC1, iC2, iR1, iR2;
			////if( ParseWksSelection(strSelectedRange, strWksName, strSheetName, iC1, iC2, iR1, iR2) ) // Parse range into column and row indices
				////return strSelectedRange; // If parses OK return selected range
		////}
	////}
////
	////return strSelectedRange; // [Super] Else return "" on error
////}
//
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
////////////                          Old Code                            //////////
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
//
////string get_report_books_in_project(int& iActiveBook)
////{
	////string strName, strList = STR_NEW;
	////int ii = 1;	
	////iActiveBook = 0;
	////foreach( WorksheetPage wp in Project.WorksheetPages )
	////{
		////strName = wp.GetName();
		////strList = strList + STR_TOKEN_SEP + strName;
		////if( Project.Pages().GetName() == strName )
			////iActiveBook = ii;
		////ii++;
	////}
	////return strList;
////}
//
////string get_report_sheets_in_book(LPCSTR lpcszBook, int& iActiveSheet)
////{
	////string strList = STR_NEW;
	////iActiveSheet = 0; // Always default to STR_NEW
	////WorksheetPage wp(lpcszBook);
	////if( wp )
	////{
		////foreach( Layer ly in wp.Layers )
			////strList = strList + STR_TOKEN_SEP + ly.GetName();
	////}
	////return strList;
////}
///end NOT_USED_FUNCTION

////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////

//////////               	 	ROC Curve          		      //////////
////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////

///Kevin 08/29/05	ADD_NEW_ROC_CURVE
/*
bool roccurve_Thresholdmethod_events(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
{
	TreeNode trThres = tr;
	if (trThres.Thresholdmethod.nVal == 2)
	{
		trThres.Thresholds.Show = 1;
	}else
	{
		trThres.Thresholds.Show = 0;
	}
	
	return true;
}

TreeNode ConstructROCCurveGUITree(TreeNode& tr, int nOption)
{
	GETN_USE(tr)
	if(!tr)
		return tr;
	tree_construct_add_input_branch(tr, INPUTDATA_RANGES);
	
	GETN_BEGIN_BRANCH(CompControl, "Computation Control")
		GETN_COMBO(StateValue, "State Value",0, "0") GETN_ID(IDE_ROC_STATE)
		GETN_LIST(Thresholdmethod, "Threshold method",0, "Interpolation of data points|Speed Mode|User defined")		GETN_ID(IDE_ROC_THRESHOLD)	GETN_OPTION_EVENT(roccurve_Thresholdmethod_events)
				GETN_STR(Thresholds, "Thresholds", "10, 20, 50, 100")		GETN_ID(IDE_ROC_THRES)	
				tr.Thresholds.Show = 0;
		GETN_BEGIN_BRANCH(ROCCurve,"ROC Curve") GETN_ID_BRANCH(IDST_ROC_CONTROL)
			GETN_CHECK(Withdiagonalreferenceline, "With diagonal reference line", false)		GETN_ID(IDE_ROC_WITHLINE)	
		GETN_END_BRANCH(ROCCurve)
		GETN_BEGIN_BRANCH(errorandconfidence,"Standard error and confidence interval") GETN_ID_BRANCH(IDST_ROC_ERRORANDCONFIDENCE)
		GETN_STR(Confidence, "Confidence Levels in %", "95") GETN_ID(IDE_ROC_CONFIDENCE)	
		GETN_CHECK(Coordinate, "Coordinate points of the ROC curve", false) GETN_ID(IDE_ROC_COORDINATE)
	GETN_END_BRANCH(CompControl)
	if( GetNBox( tr ))
		out_tree( tr );
	
	return tr;
}
//END */

bool roccurve_threshold_method_events(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
{
	TreeNode trThres = tr.CompControl;

	if ( trThres.ThresholdMethod.nVal == 2 )
		trThres.Thresholds.Show = 1;
	else
		trThres.Thresholds.Show = 0;

	return true;
}

bool roc_curve_events(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
{
	TreeNode trGUI = tree_get_root_node(tr);
	TreeNode trGraph = tree_get_node_by_id(trGUI, IDE_RESULT_GRAPHS, true);
	///Arvin 09/26/07 SHOULD_NOT_PLOT_CURVE_WHEN_UNCKECK_ROCCURVE
	//if(trGraph)
	//{
	//	trGraph.nVal = tr.Use;
	//	return true;
	//}
	TreeNode trRocCurve = tree_get_node(tr, nRow);
	if(trGraph && trRocCurve)
	{
		trGraph.nVal = trRocCurve.Use;
		return true;
	}
	///end SHOULD_NOT_PLOT_CURVE_WHEN_UNCKECK_ROCCURVE
	return false;	
}

bool roc_curve_confidence_events(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg)
{
	TreeNode trConfidence = tree_get_node(tr, nRow);
	if(!trConfidence)
		return false;
	///Joseph	12/07/06	ADD_MESSAGE_BOX
	bool bShowMsg = false;
	string strErrMsg;
	bool bOKEnable = true;
	int nErrMsg;
	///End	ADD_MESSAGE_BOX
	if( !(dwCntrl & GETNEVENT_ON_INIT) && 0 >= trConfidence.dVal || 100 <= trConfidence.dVal)
	{
		///Echo 10/27/07 MACRO_MOVED_TO_OERRMSG_DLL
		/*
		///Joseph	12/07/06	ADD_MESSAGE_BOX
		//error_msg_box(_L(CON_LEV_VAL_ERROR_MSG));
		strErrMsg = CON_LEV_VAL_ERROR_MSG;
		*/
		ocu_load_err_msg_str(CER_INVALID_CONF_LEV, &strErrMsg);
		///end MACRO_MOVED_TO_OERRMSG_DLL
		bShowMsg = true;
		bOKEnable = false;
		///End	ADD_MESSAGE_BOX
	}	
	///Joseph	12/07/06	ADD_MESSAGE_BOX
	//return true;
	return handle_dialog_errmsg(tr, bShowMsg, strErrMsg, bOKEnable);
	///End	ADD_MESSAGE_BOX
}


TreeNode ConstructROCCurveGUITree(TreeNode& tr, int nOption)
{

	GETN_USE(tr)
 
		tree_construct_add_input_branch(tr, INPUTDATA_RANGES);

	GETN_BEGIN_BRANCH(CompControl, _L("Computation Control"))							GETN_ID_BRANCH(IDE_ROC_COMPUTATION)		GETN_OPTION_BRANCH(GETNBRANCH_OPEN)

	///Kevin 11/21/05	USE_GETN_STR_GROUP
		//GETN_STR(StateValue, "State Value", "")										GETN_ID(IDE_RCO_STATE_VALUE)		GETN_OPTION_EVENT(ROCReadStateValue)

		//GETN_COMBO(StateList, "State List", 0, "")  GETN_OPTION_EVENT(ROC_State_List)	GETN_ID(IDE_ROC_STATE_LIST)
		///Arvin 06/06/07 SHOULD_SET_DATAID_FOR_THIS_NODE_FOR_RECALCULATE
		//GETN_STR_GROUP(StateValue, "State Value", "", "|0|1")							/*GETN_ID(IDE_RCO_STATE_VALUE)*/ /// Iris 11/15/06 NOT_REMEMBER_ROC_STATS_VAL_IN_THEME, from Echo	//	GETN_OPTION_EVENT(ROCReadStateValue)
		/// Bill 08/12/2011 ORG-3133-S2 RENAME_LABEL
	    //GETN_STR_GROUP(StateValue, _L("State Value"), "", "|0|1")							GETN_ID(IDE_RCO_STATE_VALUE) 	//	GETN_OPTION_EVENT(ROCReadStateValue)
	    GETN_STR_GROUP(StateValue, _L("Positive State Value"), "", "|0|1")							GETN_ID(IDE_RCO_STATE_VALUE) 	//	GETN_OPTION_EVENT(ROCReadStateValue)
	    ///------ Folger 09/21/2012 ORG-6882-P1 SHOULD_NOT_TRANSLATE_ROC_CURVE_DATA_GROUP_LIST
	    GETN_CURRENT_SUBNODE.SetAttribute(STR_OCNTRL_OPTNS, OCNTRLPARAM1_NOT_LOCALIZED);
	    ///------ End SHOULD_NOT_TRANSLATE_ROC_CURVE_DATA_GROUP_LIST
	    /// End RENAME_LABEL
		///END SHOULD_SET_DATAID_FOR_THIS_NODE_FOR_RECALCULATE
	///End USE_GETN_STR_GROUP

		//GETN_BEGIN_BRANCH(ThresholdMethod, "Threshold method")  GETN_COMBO_BRANCH(0, "Interpolation of data points|Speed Mode|User defined")
		///Arvin 08/22/07 REMOVE_USER_DEFINED_FROM_THRESHOLD_METHOD_OF_ROCCURVE
		//GETN_LIST(ThresholdMethod, "Threshold Method", 0, _L("Interpolation of data points|Speed Mode|User defined")) GETN_ID(IDE_ROC_THRES_METHOD) GETN_OPTION_EVENT(roccurve_threshold_method_events) 
		GETN_LIST(ThresholdMethod, _L("Threshold Method"), 0, _L("Interpolation of data points|Speed Mode")) GETN_ID(IDE_ROC_THRES_METHOD) GETN_OPTION_EVENT(roccurve_threshold_method_events) 
		///END REMOVE_USER_DEFINED_FROM_THRESHOLD_METHOD_OF_ROCCURVE
		GETN_STR(Thresholds, _L("Thresholds"), "10 20 50 100")  GETN_ID(IDE_ROCCUV_THRES)

		///Sophy 6/29/2011 ORG-3133-S1 SUPPORT_POSITIVE_DIRECTION_IN_ROC_CURVE
		GETN_RADIO_INDEX_EX(TestDirection, _L("Test Direction"), 0, _L("Positive v.s. High|Positive v.s. Low"))	GETN_ID(IDE_ROCCUV_TD)
		///END SUPPORT_POSITIVE_DIRECTION_IN_ROC_CURVE
		GETN_BEGIN_BRANCH(ROCCurve, _L("ROC Curve"))									GETN_CHECKBOX_BRANCH(1)		GETN_ID_BRANCH(IDE_ROC_CURVE) GETN_OPTION_EVENT(roc_curve_events) 
			GETN_CHECK(WithLine, _L("With Diagonal Reference Line"), false)											GETN_ID(IDE_ROC_WITHLINE)
		GETN_END_BRANCH(ROCCurve)

		GETN_BEGIN_BRANCH(StdError, _L("Standard Error and Confidence Interval"))		GETN_CHECKBOX_BRANCH(1)		GETN_ID_BRANCH(IDE_ROC_STD_ERROR)
			GETN_NUM(ConfLevel, _L("Confidence Levels in %"), 95) 													GETN_ID(IDE_ROC_CONFIDENCE)  GETN_OPTION_EVENT_EX(roc_curve_confidence_events) 
		GETN_END_BRANCH(StdError)

		//GETN_CHECK(CoordinatePoint, "Coordinate points of the ROC curve", true)									GETN_ID(IDE_ROC_COORDINATE)  

	GETN_END_BRANCH(CompControl)

		return tr;
}
///End ADD_NEW_ROC_CURVE


////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
//////////               	 	Correlation        		      //////////
////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
///Echo 10/26/07 NOT_USED_FUNCTION
///the feature has been done in XF. these code won't be used anymore
//TreeNode ConstructCorrelationGUITree(TreeNode& tr, int nOption)
//{
	//GETN_USE(tr)
	//if(!tr)
		//return tr;
	//tree_construct_add_input_branch(tr, INPUTDATA_RANGES);
	//GETN_BEGIN_BRANCH(CompControl, _L("Computation Control"))	GETN_ID_BRANCH(IDST_CORRELATION_CONTROL)
		//GETN_BEGIN_BRANCH(CorrelationTypes, _L("Correlation Types"))	GETN_ID_BRANCH(IDST_CORRELATION_TYPE_CONTROL)
			//GETN_CHECK(Pearson, _L("Pearson"), true)	GETN_ID(IDE_CORRELATION_PEARSON)
			//GETN_CHECK(Spearman, _L("Spearman"), false)	GETN_ID(IDE_CORRELATION_SPEARMAN)
			//GETN_CHECK(Kendall, _L("Kendall's tau-b"), false)	GETN_ID(IDE_CORRELATION_KENDALL)
		//GETN_END_BRANCH(CorrelationTypes)
		//GETN_CHECK(Descriptive, _L("Descriptive Statistics"), true)	GETN_ID(IDE_CORRELATION_DESCRIPTIVE)
	//GETN_END_BRANCH(CompControl)
	//
	////if( GetNBox( tr ))
	////out_tree( tr );
	//
	//return tr;
//}
///end NOT_USED_FUNCTION

////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
//////////     	   		  Mann Whitney U Test     		 	  //////////
////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
///Echo 10/26/07 NOT_USED_FUNCTION
///the feature has been done in XF. these code won't be used anymore
//TreeNode ConstructMannWhitneyUTestGUITree(TreeNode& tr, int nOption)
//{
	//GETN_USE(tr)
	//if(!tr)
		//return tr;
	//tree_construct_add_input_branch(tr, INPUTDATA_RANGES);
	//GETN_BEGIN_BRANCH(CompControl, _L("Computation Control"))	GETN_ID_BRANCH(IDST_UTEST_CONTROL)
		//GETN_STR(NullHypothesis, _L("Null Hypothesis"), _L("F(x) = G(y)")) GETN_READ_ONLY	GETN_ID(IDE_UTEST_NULL)	
	/////Kevin 11/09/05 CHANGE_GUI
		////GETN_COMBO(AlternateHypothesis, "Alternate Hypothesis",0, "F(x) <> G(y)|F(x) < G(y)|F(x) > G(y)") GETN_ID(IDE_UTEST_ALTERNATE)
		//GETN_LIST(AlternateHypothesis, _L("Alternate Hypothesis"),0, _L("F(x) <> G(y)|F(x) < G(y)|F(x) > G(y)")) GETN_ID(IDE_UTEST_ALTERNATE)
	/////End CHANGE_GUI
	/////Jim 11/09/05 N1_AND_N2_NOT_NEEDED
		////GETN_STR(n1, "N1", "") GETN_READ_ONLY	GETN_ID(IDE_UTEST_N1)	
		////GETN_STR(n2, "N2", "") GETN_READ_ONLY	GETN_ID(IDE_UTEST_N2)
	/////END N1_AND_N2_NOT_NEEDED
		//GETN_CHECK(PValue, _L("Approximate P Value"), false)	GETN_ID(IDE_UTEST_PVALUE)
	//GETN_END_BRANCH(CompControl)
	//
	////if( GetNBox( tr ))
	////out_tree( tr );
	//
	//return tr;
//}
//
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
////////////     	    One Sample Wilcoxon Sign Rank test    	  //////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//string test_nullhypot_type_2(string strName, string strValue)
//{
	//vector<string> vHypotType(3);
	//string strOut;
	//vHypotType[0] = strName + " <> " + strValue;
	//vHypotType[1] = strName + " > " + strValue;
	//vHypotType[2] = strName + " < " + strValue;
	//strOut = vHypotType[0] + "|" + vHypotType[1] + "|" + vHypotType[2];
	//
	//return strOut;	
//}
//
//bool test_1sample_rank_event(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
//{
	//TreeNode trRank = tr.CompControl;
	//char szHypoValue[30];	
	//DoubleToStr(trRank.TestMedian.dVal, szHypoValue, 30, "*");
	//string strNullHypType = test_nullhypot_type_2(_L("Mean"), szHypoValue);
	//trRank.AlternateHypothesis.SetAttribute(STR_COMBO_ATTRIB, strNullHypType);
	//
	//if (trRank.AlternateHypothesis.nVal == 0)	
		//trRank.NullHypothesis.strVal = _L("Median = ") + szHypoValue;
	//else if (trRank.AlternateHypothesis.nVal == 1)	
		//trRank.NullHypothesis.strVal = _L("Median <= ") + szHypoValue;
	//else if (trRank.AlternateHypothesis.nVal == 2)
		//trRank.NullHypothesis.strVal = _L("Median >= ") + szHypoValue;
	//
	//return true;
//}
//
//TreeNode ConstructOneSampleWilcoxonSignRanktestGUITree(TreeNode& tr, int nOption)
//{
	//GETN_USE(tr)
	//if(!tr)
		//return tr;
	//tree_construct_add_input_branch(tr, INPUTDATA_RANGES);
	//GETN_BEGIN_BRANCH(CompControl, _L("Computation Control"))	GETN_ID_BRANCH(IDST_RANK_CONTROL)
		//GETN_NUM(TestMedian,_L("Test Median"), 0)	GETN_ID(IDE_RANK_MEDIAN)	GETN_OPTION_EVENT(test_1sample_rank_event)
		//GETN_STR(NullHypothesis,_L("Null Hypothesis"), _L("Mean = 0"))	GETN_ID(IDE_RANK_HYPOTHESIS)
		//tr.CompControl.NullHypothesis.Enable = 0;
		//GETN_LIST(AlternateHypothesis, _L("Alternate Hypothesis"),0, _L("Median <> 0|Median > 0|Median < 0"))	GETN_ID(IDE_RANK_ALTERNATE)	GETN_OPTION_EVENT(test_1sample_rank_event)
	//GETN_END_BRANCH(CompControl)
	//
	////if( GetNBox( tr ))
	////out_tree( tr );
	//
	//return tr;
//}
//
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
////////////     	  	 Wilcoxon Matched Pairs Test    	 	  //////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//TreeNode ConstructWilcoxonMatchedPairsTestGUITree(TreeNode& tr, int nOption)
//{
	//GETN_USE(tr)
	//if(!tr)
		//return tr;
	//
	//tree_construct_add_input_branch(tr, INPUTDATA_RANGES);
	//GETN_BEGIN_BRANCH(CompControl, _L("Computation Control"))	GETN_ID_BRANCH(IDST_PAIRS_CONTROL)
		//GETN_NUM(TestDifference,_L("Test Difference"), 0)	GETN_ID(IDE_PAIRS_DIFFERENCE)	GETN_OPTION_EVENT(test_pairs_test_event)
		//GETN_STR(NullHypothesis,_L("Null Hypothesis"), _L("Median1 - Median2 = 0"))	GETN_ID(IDE_PAIRS_HYPOTHESIS)
		//tr.CompControl.NullHypothesis.Enable = 0;
		//GETN_LIST(AlternateHypothesis, _L("Alternate Hypothesis"),0, _L("Median1 - Median2 <> 0|Median1 - Median2 > 0|Median1 - Median2 < 0"))	GETN_ID(IDE_PAIRS_ALTERNATE)	GETN_OPTION_EVENT(test_pairs_test_event)
	//GETN_END_BRANCH(CompControl)
	//
	////if( GetNBox( tr ))
	////out_tree( tr );
	//
	//return tr;
//}
//
//bool test_pairs_test_event(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
//{
	//TreeNode trPairs = tr.CompControl;
	//char szHypoValue[30];	
	//DoubleToStr(trPairs.TestDifference.dVal, szHypoValue, 30, "*");
	//string strNullHypType = test_nullhypot_type_2(_L("Median1 - Median2"), szHypoValue);
	//trPairs.AlternateHypothesis.SetAttribute(STR_COMBO_ATTRIB, strNullHypType);
	//
	//if (trPairs.AlternateHypothesis.nVal == 0)	
		//trPairs.NullHypothesis.strVal = _L("Median1 - Median2 = ") + szHypoValue;
	//else if (trPairs.AlternateHypothesis.nVal == 1)	
		//trPairs.NullHypothesis.strVal = _L("Median1 - Median2 <= ") + szHypoValue;
	//else if (trPairs.AlternateHypothesis.nVal == 2)
		//trPairs.NullHypothesis.strVal = _L("Median1 - Median2 >= ") + szHypoValue;
	//
	//return true;
//}
//
//
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
////////////     	  	 	Kruskal Wallis ANOVA	     	 	  //////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//
//TreeNode ConstructKWANOVAGUITree(TreeNode& tr, int nOption)
//{
	//GETN_USE(tr)
	//tree_construct_add_input_branch(tr, INPUTDATA_RANGES);
	//return tr;
//}
///end NOT_USED_FUNCTION

///Joseph	12/07/06	ADD_MESSAGE_BOX
//handle the operation dialog error message 
//them code 
bool handle_dialog_errmsg(TreeNode&	trGetN, bool bShowErrMsg, LPCSTR	lpcszErrMsg, bool bOKEnable)
{
	string	strErrMsg(lpcszErrMsg);
	string	strFullErrMsg;
	string 	strOKEnable;
	//get the full ErrMsg, the string is run through the all function event errmsg
	trGetN.GetAttribute(STR_ERRMSG_ATTRIB, strFullErrMsg);
	
	//no error
	if(!bShowErrMsg && strFullErrMsg.IsEmpty())
	{
		trGetN.RemoveAttribute(STR_ERRMSG_ATTRIB);
		return true;
	}
	
	//If have the current errmsg
	int nIndex = strFullErrMsg.Find(strErrMsg);
	
	if(bOKEnable)
		strOKEnable = STR_OK_ENABLE_TAG + "1";
	else
		strOKEnable = STR_OK_ENABLE_TAG + "0";
	if(nIndex >= 0)
	{
		int nOKEnableLength = lstrlen(strOKEnable);
		int nErrMsgLength = nOKEnableLength + strErrMsg.GetLength();
		int	nErrMsgIndex = nIndex - nOKEnableLength;
		if(!bShowErrMsg)
		{
			strFullErrMsg.Delete(nErrMsgIndex, nErrMsgLength);
		}
	}
	else
	{
		if(bShowErrMsg)
			strFullErrMsg += strOKEnable + strErrMsg;
	}
	trGetN.SetAttribute(STR_ERRMSG_ATTRIB, strFullErrMsg);
	
	if(bShowErrMsg)
		return false;
	
	return true;
}

//using errcode id,
//we will use this code, I will add later.
bool handle_dialog_errmsg(TreeNode&	trGetN, bool bShowErrMsg, int nErrCodeID, bool bOKEnable)
{
	string strErrMsg;
	ocu_load_err_msg_str(nErrCodeID, strErrMsg);
	return handle_dialog_errmsg(trGetN, bShowErrMsg, strErrMsg, bOKEnable);
}
///End	ADD_MESSAGE_BOX

///Cheney 2007-10-19 QA70-10536 FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
////----- CPY 10/12/07 10522-P3 CLEANUP_IF_LOOSE_DATASET_SHOULD_NOT_PUT_REPORT_SHEET_TO_SOURCE
//static bool _update_output_book_sheet_destination(TreeNode& trOutput, LPCSTR lpcszBookList = NULL, LPCSTR lpcszBookDefault = NULL, LPCSTR lpcszSheetList = NULL, LPCSTR lpcszSheetDefault = NULL)
//{
	//if(!trOutput)
		//return error_report("_update_output_book_sheet_destination found trOutput invalid");
	//
	//if(trOutput.Book)
	//{
		//if(lpcszBookList)
		//{
			//trOutput.Book.RemoveAttribute(STR_COMBO_ATTRIB);
			//trOutput.Book.SetAttribute(STR_COMBO_ATTRIB, lpcszBookList);
		//}
		//if(lpcszBookDefault)
			//trOutput.Book.strVal = lpcszBookDefault;
	//}
	//if(trOutput.Sheet)
	//{
		//if(lpcszSheetList)
		//{
			//trOutput.Sheet.RemoveAttribute(STR_COMBO_ATTRIB);
			//trOutput.Sheet.SetAttribute(STR_COMBO_ATTRIB, lpcszSheetList);
		//}
		//if(lpcszSheetDefault)
			//trOutput.Sheet.strVal = lpcszSheetDefault;
	//}
	//return true;
//}
///end FIX_EIGHT_PROBLEMS_REPORT_BY_MAX

/// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
#ifndef _MOVE_FIT_OUTPUT_TO_OC_CLASS	//----CPY 3/27/08 NLFIT_FAILED_TO_BE_COMPILED added this to bring old code back
///Cheney 2007-10-31 QA70-10536-p12 IF_NO_FIT_PLOT_SHOULD_NEW_RESIDUAL_BOOK_SHEET
bool _is_plot_fit_curve(const TreeNode& trGUI)
{
	/// Iris 10/29/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
	/*
	TreeNode trPlotFit = trGUI.Graph1;
	if(!trPlotFit)
		trPlotFit = trGUI.Parent().FittedCurve.Graph1; //m_trNFO
	*/
	TreeNode trPlotFit = OP_GUI_FITCURVE_PLOT_CHECKBOX(trGUI);
	///end OP_DLG_NEW_STRUCTURE
	
	if(!trPlotFit)
		return false;
	
	/// Iris 10/29/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
	/*
	int nUse = 0;
	if( !trPlotFit.GetAttribute( STR_USE_ATTRIB, nUse ) )
		return false;
	
	return nUse;
	*/
	return trPlotFit.nVal;
	///end OP_DLG_NEW_STRUCTURE
}
///end IF_NO_FIT_PLOT_SHOULD_NEW_RESIDUAL_BOOK_SHEET
#endif //_MOVE_FIT_OUTPUT_TO_OC_CLASS
///end CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS

/// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
#ifndef _MOVE_FIT_OUTPUT_TO_OC_CLASS	//----CPY 3/27/08 NLFIT_FAILED_TO_BE_COMPILED added this to bring old code back
///Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
//void check_update_fit_output_book_sheet_GUI(TreeNode trGUI, int nFitType, bool bSetDataOutput)
///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
//void check_update_fit_output_book_sheet_GUI(TreeNode& trGUI, const TreeNode& trInput, int nFitType, bool bSetDataOutput, LPCSTR lpcszSrcPageName)
void check_update_fit_output_book_sheet_GUI(TreeNode& trGUI, const TreeNode& trInput, int nFitType, bool bSetDataOutput, LPCSTR lpcszSrcPageName, TreeNode& trOutput)
///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
///end CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
{
	///Sophy 9/3/2008 CLEAN_OUTPUT_WND_TYPE_CODE
	/*
	//TreeNode trData = trGUI.Output.Data;
	//TreeNode trRes = trGUI.Output.Residual;
	//int nFitType = GetFitType(trOperation);
	///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
	//TreeNode trFittedOut;
	//if(bSetDataOutput)
		//trFittedOut	= trGUI.Output.Data; 
		//
	//TreeNode trResidualOut = trGUI.Output.Residual;
	//TreeNode trFindXYOut = trGUI.Output.FindXY;
	//TreeNode trReportOut = trGUI.Output.Report;
	TreeNode trOuputResults;
	if(trOutput)
		trOuputResults = trOutput;
	else
		trOuputResults = trGUI.Output;
	
	TreeNode trFittedOut;
	if(bSetDataOutput)
		trFittedOut	= trOuputResults.Data; 
		
	TreeNode trResidualOut = trOuputResults.Residual;
	TreeNode trFindXYOut = trOuputResults.FindXY;
	TreeNode trReportOut = trOuputResults.Report;
	///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
	
	bool bAllowSource = is_range_from_normal_book(trInput); ///Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING

	///Cheney 2007-10-25 QA70-10536-p11 IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME 
	int nOutputType = 0;
	if(trGUI.Output.Data)
		trGUI.Output.Data.GetAttribute(STR_OPERATION_OUTPUT_TYPE, nOutputType);
	
	///Cheney 2007-10-31 QA70-10536-p12 IF_NO_FIT_PLOT_SHOULD_NEW_RESIDUAL_BOOK_SHEET
	bool bPlotFitCurve = _is_plot_fit_curve(trGUI);
	string strResidualBookCombo, strResidualSheetCombo, strFindXYBookCombo, strFindXYSheetCombo;
	get_residual_combo(nFitType, bPlotFitCurve, strResidualBookCombo, strResidualSheetCombo);
	get_findxy_combo(nFitType, bPlotFitCurve, strFindXYBookCombo, strFindXYSheetCombo);
	///end IF_NO_FIT_PLOT_SHOULD_NEW_RESIDUAL_BOOK_SHEET
	
	if(nFitType == NLFIT_XYZ_FITTING)
	{		
		if(trResidualOut)
			///Cheney 2007-10-19 QA70-10536 FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
			//_update_output_book_sheet_destination(trResidualOut, STR_XYZFITTING_RESIDUALOUT_BOOK_COMBO, STR_REPORT, STR_XYZFITTING_RESIDUALOUT_SHEET_COMBO, STR_NEW);
			///Cheney 2007-10-25 QA70-10536-p11 IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME 
			//update_output_book_sheet_destination(trResidualOut, STR_XYZFITTING_RESIDUALOUT_BOOK_COMBO, STR_REPORT, STR_XYZFITTING_RESIDUALOUT_SHEET_COMBO, STR_NEW);
			/// Iris 3/15/2008 QA70-11244 SHOULD_NOT_OUTPUT_DATA_TO_MATRIX_FOR_XYZ_FITTING
			//update_output_book_sheet_destination(trResidualOut, STR_XYZFITTING_RESIDUALOUT_BOOK_COMBO, STR_REPORT, STR_XYZFITTING_RESIDUALOUT_SHEET_COMBO, STR_NEW, nOutputType, IDE_RESIDUAL_CURVE_BOOK, NLFIT_XYZ_FITTING);
			update_output_book_sheet_destination(trResidualOut, STR_XYZFITTING_RESIDUALOUT_BOOK_COMBO, STR_FIT_CURVE, STR_XYZFITTING_RESIDUALOUT_SHEET_COMBO, STR_FIT_CURVE, nOutputType, IDE_RESIDUAL_CURVE_BOOK, NLFIT_XYZ_FITTING);
			///end SHOULD_NOT_OUTPUT_DATA_TO_MATRIX_FOR_XYZ_FITTING
			///end FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
		if(trFindXYOut)
			///Cheney 2007-10-19 QA70-10536 FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
			//_update_output_book_sheet_destination(trFindXYOut, STR_XYZFITTING_FINDZOUT_BOOK_COMBO, STR_REPORT, STR_XYZFITTING_FINDZOUT_SHEET_COMBO, STR_NEW);
			///Cheney 2007-10-25 QA70-10536-p11 IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME 
			//update_output_book_sheet_destination(trFindXYOut, STR_XYZFITTING_FINDZOUT_BOOK_COMBO, STR_REPORT, STR_XYZFITTING_FINDZOUT_SHEET_COMBO, STR_NEW);
			/// Iris 3/15/2008 QA70-11244 SHOULD_NOT_OUTPUT_DATA_TO_MATRIX_FOR_XYZ_FITTING
			//update_output_book_sheet_destination(trFindXYOut, STR_XYZFITTING_FINDZOUT_BOOK_COMBO, STR_REPORT, STR_XYZFITTING_FINDZOUT_SHEET_COMBO, STR_NEW, nOutputType, IDE_FIND_XY_BOOK, NLFIT_XYZ_FITTING);
			update_output_book_sheet_destination(trFindXYOut, STR_XYZFITTING_FINDZOUT_BOOK_COMBO, STR_FIT_CURVE, STR_XYZFITTING_FINDZOUT_SHEET_COMBO, STR_NEW, nOutputType, IDE_FIND_XY_BOOK, NLFIT_XYZ_FITTING);
			///end SHOULD_NOT_OUTPUT_DATA_TO_MATRIX_FOR_XYZ_FITTING
			///end FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
		if(trFittedOut)
		{
			//-------- CPY 10/15/07 XYZ_FITTING_CREATED_WKS_INSTEAD_OF_MAT_BOOK
			//I didnt understand this because of original strange 1,2 when converting code, will need to clean these 1 and 2 into macros
			///Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
			//trFittedOut.SetAttribute(STR_REPORT_MATRIX_DATA, 1); 
			trFittedOut.SetAttribute(STR_OPERATION_OUTPUT_TYPE, OPERATION_OUTPUT_XYZ_FITTING); 
			///end CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
			//--------
			
			///Cheney 2007-10-15 QA70-10522-P4 CLEAN_CODE_AND_ADD_AUTO_FOR_OUTPUT_SETTING 
			//_update_output_book_sheet_destination(trFittedOut, STR_XYZFITTING_FITTEDCURVE_BOOK_COMBO, STR_NEW, NULL, STR_NEW);
			///Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
			//_update_output_book_sheet_destination(trFittedOut, STR_XYZFITTING_FITTEDCURVE_BOOK_COMBO, STR_AUTO, NULL, STR_NEW);
			///Cheney 2007-10-19 QA70-10536 FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
			//_update_output_book_sheet_destination(trFittedOut, STR_XYZFITTING_FITTEDCURVE_BOOK_COMBO, STR_AUTO, STR_XYZFITTING_FITTEDCURVE_SHEET_COMBO, STR_NEW);
			///Cheney 2007-10-25 QA70-10536-p11 IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME 
			//update_output_book_sheet_destination(trFittedOut, STR_XYZFITTING_FITTEDCURVE_BOOK_COMBO, STR_AUTO, STR_XYZFITTING_FITTEDCURVE_SHEET_COMBO, STR_NEW);
			
			/// Iris 3/15/2008 QA70-11244 SHOULD_NOT_OUTPUT_DATA_TO_MATRIX_FOR_XYZ_FITTING, the settings of XYZ same as normal XY, so no need to set again here
			//update_output_book_sheet_destination(trFittedOut, STR_XYZFITTING_FITTEDCURVE_BOOK_COMBO, STR_AUTO, STR_XYZFITTING_FITTEDCURVE_SHEET_COMBO, STR_NEW, nOutputType, IDE_RESULT_CURVE_BOOK, NLFIT_XYZ_FITTING);
			///end SHOULD_NOT_OUTPUT_DATA_TO_MATRIX_FOR_XYZ_FITTING
			
			///end IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME
			///end FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
			///end CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
			///end CLEAN_CODE_AND_ADD_AUTO_FOR_OUTPUT_SETTING
		}
		
		///Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
		if(trReportOut) 
		{
			if( bAllowSource)
				///Cheney 2007-10-19 QA70-10536 FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
				//_update_output_book_sheet_destination(trReportOut, STR_XYZFITTING_OUTPUT_REPORT_BOOK_COMBO_WITH_SOURCE(lpcszSrcPageName), NULL, NULL, NULL);
				///Cheney 2007-10-25 QA70-10536-p11 IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME 
				//update_output_book_sheet_destination(trReportOut, STR_XYZFITTING_OUTPUT_REPORT_BOOK_COMBO_WITH_SOURCE(lpcszSrcPageName), NULL, NULL, NULL);
				update_output_book_sheet_destination(trReportOut, STR_XYZFITTING_OUTPUT_REPORT_BOOK_COMBO_WITH_SOURCE(lpcszSrcPageName), NULL, NULL, NULL, nOutputType, IDE_REOPRT_BOOK, NLFIT_XYZ_FITTING);
				///end IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME
				///end FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
			else
				///Cheney 2007-10-19 QA70-10536 FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
				//_update_output_book_sheet_destination(trReportOut, STR_XYZFITTING_OUTPUT_REPORT_BOOK_COMBO, STR_AUTO, NULL, NULL);
				///Cheney 2007-10-25 QA70-10536-p11 IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME 
				//update_output_book_sheet_destination(trReportOut, STR_XYZFITTING_OUTPUT_REPORT_BOOK_COMBO, STR_AUTO, NULL, NULL);
				update_output_book_sheet_destination(trReportOut, STR_XYZFITTING_OUTPUT_REPORT_BOOK_COMBO, STR_AUTO, NULL, NULL, nOutputType, IDE_REOPRT_BOOK, NLFIT_XYZ_FITTING);
				///end IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME
				///end FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
		}		
		///end CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
	}
	else if(nFitType == NLFIT_MATRIX_FITTING)
	{
		//if(trData)
		//	trData.SetAttribute(STR_REPORT_MATRIX_DATA, 2);
		//if(trRes)
		//	trRes.SetAttribute(STR_REPORT_MATRIX_DATA, 1);
		if(trResidualOut)
		{
			///Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
			//trResidualOut.SetAttribute(STR_REPORT_MATRIX_DATA, 1); 
			trResidualOut.SetAttribute(STR_OPERATION_OUTPUT_TYPE, OPERATION_OUTPUT_MAT_FITTING); 
			///end CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
			///Cheney 2007-10-19 QA70-10536 FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
			//_update_output_book_sheet_destination(trResidualOut, STR_MATFITTING_RESIDUALOUT_BOOK_COMBO, STR_FIT_CURVE, STR_MATFITTING_RESIDUALOUT_SHEET_COMBO, STR_NEW);
			///Cheney 2007-10-25 QA70-10536-p11 IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME 			
			//update_output_book_sheet_destination(trResidualOut, STR_MATFITTING_RESIDUALOUT_BOOK_COMBO, STR_FIT_CURVE, STR_MATFITTING_RESIDUALOUT_SHEET_COMBO, STR_NEW);
			///Cheney 2007-10-31 QA70-10536-p12 IF_NO_FIT_PLOT_SHOULD_NEW_RESIDUAL_BOOK_SHEET
			//update_output_book_sheet_destination(trResidualOut, STR_MATFITTING_RESIDUALOUT_BOOK_COMBO, STR_FIT_CURVE, STR_MATFITTING_RESIDUALOUT_SHEET_COMBO, STR_NEW, nOutputType, IDE_RESIDUAL_CURVE_BOOK, NLFIT_MATRIX_FITTING);
			update_output_book_sheet_destination(trResidualOut, strResidualBookCombo, bPlotFitCurve? STR_FIT_CURVE : STR_NEW, strResidualSheetCombo, STR_NEW, nOutputType, IDE_RESIDUAL_CURVE_BOOK, NLFIT_MATRIX_FITTING);
			///end IF_NO_FIT_PLOT_SHOULD_NEW_RESIDUAL_BOOK_SHEET
			///end IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME
			///end FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
		}
		if(trFindXYOut)
			///Cheney 2007-10-19 QA70-10536 FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
			//_update_output_book_sheet_destination(trFindXYOut, STR_MATFITTING_FINDZOUT_BOOK_COMBO, STR_REPORT, STR_MATFITTING_FINDZOUT_SHEET_COMBO, STR_NEW);
			///Cheney 2007-10-25 QA70-10536-p11 IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME 			
			//update_output_book_sheet_destination(trFindXYOut, STR_MATFITTING_FINDZOUT_BOOK_COMBO, STR_REPORT, STR_MATFITTING_FINDZOUT_SHEET_COMBO, STR_NEW);
			update_output_book_sheet_destination(trFindXYOut, STR_MATFITTING_FINDZOUT_BOOK_COMBO, STR_REPORT, STR_MATFITTING_FINDZOUT_SHEET_COMBO, STR_NEW, nOutputType, IDE_FIND_XY_BOOK, NLFIT_MATRIX_FITTING);
			///end IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME
			///end FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
		///Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
		//if(trReportOut)
			//_update_output_book_sheet_destination(trReportOut, STR_MATFITTING_REPORTOUT_BOOK_COMBO, STR_NEW, STR_MATFITTING_REPORTOUT_SHEET_COMBO, STR_NEW);
		if(trReportOut) 
			///Cheney 2007-10-19 QA70-10536 FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
			//_update_output_book_sheet_destination(trReportOut, STR_MATFITTING_REPORTOUT_BOOK_COMBO, NULL, NULL, NULL);
			///Cheney 2007-10-25 QA70-10536-p11 IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME 			
			//update_output_book_sheet_destination(trReportOut, STR_MATFITTING_REPORTOUT_BOOK_COMBO, NULL, NULL, NULL);
			update_output_book_sheet_destination(trReportOut, STR_MATFITTING_REPORTOUT_BOOK_COMBO, NULL, NULL, NULL, nOutputType, IDE_REOPRT_BOOK, NLFIT_MATRIX_FITTING);
			///end IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME
			///end FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
		///end CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
			
		if(trFittedOut)
		{
			//-------- CPY 10/15/07 XYZ_FITTING_CREATED_WKS_INSTEAD_OF_MAT_BOOK
			///Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
			//trFittedOut.SetAttribute(STR_REPORT_MATRIX_DATA, 2); 
			trFittedOut.SetAttribute(STR_OPERATION_OUTPUT_TYPE, OPERATION_OUTPUT_MAT_FITTING); 
			////--------
			//string strBookCombo;
			//trFittedOut.Book.GetAttribute(STR_COMBO_ATTRIB, strBookCombo);
			//StringArray saTokens;
			//strBookCombo.GetTokens( saTokens, '|');
			//if(saTokens.GetSize() == 0)
			//	return;
			//_update_output_book_sheet_destination(trFittedOut, NULL, saTokens[0], NULL, STR_NEW);
			if(bAllowSource)
				///Cheney 2007-10-19 QA70-10536 FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
				//_update_output_book_sheet_destination(trFittedOut, STR_MATFITTING_FITTEDCURVE_BOOK_COMBO_WITH_SOURCE(lpcszSrcPageName), NULL, STR_MATFITTING_FITTEDCURVE_SHEET_COMBO, STR_NEW);
				///Cheney 2007-10-25 QA70-10536-p11 IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME 			
				//update_output_book_sheet_destination(trFittedOut, STR_MATFITTING_FITTEDCURVE_BOOK_COMBO_WITH_SOURCE(lpcszSrcPageName), NULL, STR_MATFITTING_FITTEDCURVE_SHEET_COMBO, STR_NEW);
				update_output_book_sheet_destination(trFittedOut, STR_MATFITTING_FITTEDCURVE_BOOK_COMBO_WITH_SOURCE(lpcszSrcPageName), NULL, STR_MATFITTING_FITTEDCURVE_SHEET_COMBO, STR_NEW, nOutputType, IDE_RESULT_CURVE_BOOK, NLFIT_MATRIX_FITTING);
				///end IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME
				///end FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
			else
				///Cheney 2007-10-19 QA70-10536 FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
				//_update_output_book_sheet_destination(trFittedOut, STR_MATFITTING_FITTEDCURVE_BOOK_COMBO, STR_AUTO, STR_MATFITTING_FITTEDCURVE_SHEET_COMBO, STR_NEW);
				///Cheney 2007-10-25 QA70-10536-p11 IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME 			
				//update_output_book_sheet_destination(trFittedOut, STR_MATFITTING_FITTEDCURVE_BOOK_COMBO, STR_AUTO, STR_MATFITTING_FITTEDCURVE_SHEET_COMBO, STR_NEW);
				update_output_book_sheet_destination(trFittedOut, STR_MATFITTING_FITTEDCURVE_BOOK_COMBO, STR_AUTO, STR_MATFITTING_FITTEDCURVE_SHEET_COMBO, STR_NEW, nOutputType, IDE_RESULT_CURVE_BOOK, NLFIT_MATRIX_FITTING);
				///end IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME
				///end FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
			///end CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
		}
		
	}
	///Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
	//// for any type of fit
	//if(trReportOut && !is_range_from_normal_book(trGUI.InputData)) // reset to basic new report type of combo
	else if(trReportOut) 
		/////Cheney 2007-10-15 QA70-10522-P4 CLEAN_CODE_AND_ADD_AUTO_FOR_OUTPUT_SETTING 
		////_update_output_book_sheet_destination(trReportOut, STR_OUTPUT_REPORT_BOOK_COMBO, STR_NEW, NULL, NULL);
		//_update_output_book_sheet_destination(trReportOut, STR_OUTPUT_REPORT_BOOK_COMBO, STR_AUTO, NULL, NULL);
		/////end CLEAN_CODE_AND_ADD_AUTO_FOR_OUTPUT_SETTING
	
	{
		if(bAllowSource)
			///Cheney 2007-10-19 QA70-10536 FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
			//_update_output_book_sheet_destination(trReportOut, STR_OUTPUT_BOOK_COMBO_WITH_SOURCE(lpcszSrcPageName), NULL, NULL, NULL);
			///Cheney 2007-10-25 QA70-10536-p11 IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME 			
			//update_output_book_sheet_destination(trReportOut, STR_OUTPUT_BOOK_COMBO_WITH_SOURCE(lpcszSrcPageName), NULL, NULL, NULL);
			update_output_book_sheet_destination(trReportOut, STR_OUTPUT_BOOK_COMBO_WITH_SOURCE(lpcszSrcPageName), NULL, NULL, NULL, nOutputType, IDE_REOPRT_BOOK, NLFIT_GENERAL_XY_FITTING);
			///end IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME
			///end FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
		else
			///Cheney 2007-10-19 QA70-10536 FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
			//_update_output_book_sheet_destination(trReportOut, STR_OUTPUT_REPORT_BOOK_COMBO, NULL, NULL, NULL);
			///Cheney 2007-10-25 QA70-10536-p11 IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME 			
			//update_output_book_sheet_destination(trReportOut, STR_OUTPUT_REPORT_BOOK_COMBO, NULL, NULL, NULL);
			update_output_book_sheet_destination(trReportOut, STR_OUTPUT_REPORT_BOOK_COMBO, NULL, NULL, NULL, nOutputType, IDE_REOPRT_BOOK, NLFIT_GENERAL_XY_FITTING);
			///end IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME
			///end FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
			
		///Cheney 2007-10-19 QA70-10536 FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
		///Cheney 2007-10-25 QA70-10536-p11 IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME 			
		//update_output_book_sheet_destination(trResidualOut, NULL, NULL, NULL, NULL);
		//update_output_book_sheet_destination(trFindXYOut, NULL, NULL, NULL, NULL);
		///Cheney 2007-10-31 QA70-10536-p12 IF_NO_FIT_PLOT_SHOULD_NEW_RESIDUAL_BOOK_SHEET
		//update_output_book_sheet_destination(trResidualOut, NULL, NULL, NULL, NULL, nOutputType, IDE_RESIDUAL_CURVE_BOOK, NLFIT_GENERAL_XY_FITTING);
		//update_output_book_sheet_destination(trFindXYOut, NULL, NULL, NULL, NULL, nOutputType, IDE_FIND_XY_BOOK, NLFIT_GENERAL_XY_FITTING);
		if(bPlotFitCurve)
		{
			update_output_book_sheet_destination(trResidualOut, strResidualBookCombo, NULL, strResidualSheetCombo, NULL, nOutputType, IDE_RESIDUAL_CURVE_BOOK, NLFIT_GENERAL_XY_FITTING);
			update_output_book_sheet_destination(trFindXYOut, strFindXYBookCombo, NULL, strFindXYSheetCombo, NULL, nOutputType, IDE_FIND_XY_BOOK, NLFIT_GENERAL_XY_FITTING);
		}
		else
		{
			update_output_book_sheet_destination(trResidualOut, strResidualBookCombo, STR_NEW, strResidualSheetCombo, STR_NEW, nOutputType, IDE_RESIDUAL_CURVE_BOOK, NLFIT_GENERAL_XY_FITTING);
			update_output_book_sheet_destination(trFindXYOut, strFindXYBookCombo, STR_NEW, strFindXYSheetCombo, STR_NEW, nOutputType, IDE_FIND_XY_BOOK, NLFIT_GENERAL_XY_FITTING);
		}
		///end IF_NO_FIT_PLOT_SHOULD_NEW_RESIDUAL_BOOK_SHEET
		///end IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME
		 ///end FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
	}
	///end CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
	*/
	//of no use code
	ASSERT(FALSE);
	///end CLEAN_OUTPUT_WND_TYPE_CODE
}
//----- end CLEANUP_IF_LOOSE_DATASET_SHOULD_NOT_PUT_REPORT_SHEET_TO_SOURCE
#endif //_MOVE_FIT_OUTPUT_TO_OC_CLASS	//----CPY 3/27/08 NLFIT_FAILED_TO_BE_COMPILED
///end CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS

/// Iris 11/02/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
///------ Folger 05/06/2011 ORG-2786-S1 MORE_POINTS_FOR_FITX_IN_NLFIT
//void ConstructFitXDataBranch(TreeNode& trParent)
void	FitterOperation::ConstructFitXDataBranch(TreeNode& trParent)
///------ End MORE_POINTS_FOR_FITX_IN_NLFIT
{
	string strDataType = STR_FITTED_CURVE_DATA_TYPE_UNIFORM_LINEAR + "|"; 
	strDataType += STR_FITTED_CURVE_DATA_TYPE_UNIFORM_LOG + "|";
	strDataType += STR_FITTED_CURVE_DATA_TYPE_SAME_INPUT;
	
	GETN_USE(trParent)
	
	GETN_BEGIN_BRANCH(XDataType, _L("X Data Type"))  GETN_ID(IDE_FIT_DATA_TYPE_BRANCH)  GETN_COMBO_BRANCH(FIT_CURVE_UNIFORM_LINEAR, strDataType)  GETN_OPTION_EVENT(fit_curv_data_type_even)
		GETN_OPTION_BRANCH(GETNBRANCH_OPEN)  /// Iris 06/30/06 MAKE_CHANGE_TO_FOLLOW_MAX_SUGGESTION
		///------ Folger 05/06/2011 ORG-2786-S1 MORE_POINTS_FOR_FITX_IN_NLFIT
		//GETN_NUM(N, _L("Points"), XY_FIT_DEFAULT_POINTS) GETN_ID(IDE_FIT_X_POINTS)		
		GETN_NUM(N, _L("Points"), XYFitDefaultPoints()) GETN_ID(IDE_FIT_X_POINTS)		
		///------ End MORE_POINTS_FOR_FITX_IN_NLFIT
		/// Iris 3/07/2012 ORG-5218-P1 NEW_GUI_OF_X_DATA_TYPE_FOR_IMPLICIT_FUNC
		//GETN_LIST(Range, _L("Range"), 0, _L("Use Input Data Range + Margin|Span to Full Axis Range|Custom"))  GETN_ID(IDE_FIT_RANGE_BRANCH) GETN_OPTION_EVENT(fit_curv_range_even)
		GETN_LIST(Range, _L("Range"), 0, STR_FITTED_CURVE_DATA_TYPE_RANGE_OPTIONS)  GETN_ID(IDE_FIT_RANGE_BRANCH) GETN_OPTION_EVENT(fit_curv_range_even)
		///End NEW_GUI_OF_X_DATA_TYPE_FOR_IMPLICIT_FUNC
		///Cheney 2007-9-18 IF_FROM_THEME_SHOULD_NOT_UPDATE_CUSTOM_RANGE
		//GETN_NUM(Min, "Min", -600) GETN_ID(IDE_FIT_X_MIN)
		//GETN_NUM(Max, "Max", 600) GETN_ID(IDE_FIT_X_MAX)
		///Sophy 11/28/2008 v8.0980d QA80-12591-P5 ADD_AUTO_SUPPORT_FOR_LR_AND_PR_FITCURVE_XDATATYPE
		//GETN_NUM(Min, _L("Min"), FITTING_CUSTOM_RANGE_MIN_VAL_DEFAULT) GETN_ID(IDE_FIT_X_MIN)
		//GETN_NUM(Max, _L("Max"), FITTING_CUSTOM_RANGE_MAX_VAL_DEFAULT) GETN_ID(IDE_FIT_X_MAX)		
		GETN_NUM(Min, _L("Min"), FITTING_CUSTOM_RANGE_MIN_VAL_DEFAULT) GETN_ID(IDE_FIT_X_MIN) GETN_ADD_AUTO(1)
		GETN_NUM(Max, _L("Max"), FITTING_CUSTOM_RANGE_MAX_VAL_DEFAULT) GETN_ID(IDE_FIT_X_MAX) GETN_ADD_AUTO(1)
		///end ADD_AUTO_SUPPORT_FOR_LR_AND_PR_FITCURVE_XDATATYPE
		///end IF_FROM_THEME_SHOULD_NOT_UPDATE_CUSTOM_RANGE
		/// Iris 01/08/2007 v8.0538 CHNAGE_DEFAULT_FOR_RANGE_MARGIN
		//GETN_NUM(RangeMargin, "Range Margin (%)", 10) GETN_ID(IDE_FIT_RANGE_MARGIN)	
		GETN_NUM(RangeMargin, _L("Range Margin (%)"), 0) GETN_ID(IDE_FIT_RANGE_MARGIN)
		///end CHNAGE_DEFAULT_FOR_RANGE_MARGIN
	GETN_END_BRANCH(XDataType)	
}

bool check_get_weight_data_err_msg(const TreeNode& trGUI, string& strErrMsg)
{
	int nBadDataMsg;
	int nWeightMethod = trGUI.Fit.ErrBarWeight.nVal;
	/// Iris 8/27/2010 ORG-907 LR_NEED_CHECK_ZERO_ERROR_BAR
	//if(check_bad_data_for_weight(trGUI, nBadDataMsg))
	if(check_bad_data_for_weight(trGUI, nWeightMethod, nBadDataMsg))
	///End LR_NEED_CHECK_ZERO_ERROR_BAR
	{
		/// Iris 8/27/2010 ORG-907 LR_NEED_CHECK_ZERO_ERROR_BAR
		/*
		///Arvin 08/10/07 QA70-10197 ADD_NONE_OPTION_FOR_ERROR_AS_WEIGHT_IN_LR_PR_AND_MR
		//if(nWeightMethod && (nBadDataMsg&WEIGHT_HAS_MISSING_VALUE))
		if(nWeightMethod == ERRBARWEIGHT_INSTRUMENTAL && (nBadDataMsg&WEIGHT_HAS_MISSING_VALUE))		
		///end ADD_NONE_OPTION_FOR_ERROR_AS_WEIGHT_IN_LR_PR_AND_MR
			return ocu_load_msg_str(CER_VALUE_UNCOMPATIBLE_WITH_WEIGHT_METHOD, &strErrMsg, _L("Instrumental"), NULL, _L("missing value"));
		*/
		if(nWeightMethod == ERRBARWEIGHT_INSTRUMENTAL && ((nBadDataMsg&WEIGHT_HAS_MISSING_VALUE)||(nBadDataMsg&WEIGHT_HAS_ZERO_VALUE)) )
			return ocu_load_msg_str(CER_VALUE_UNCOMPATIBLE_WITH_WEIGHT_METHOD, &strErrMsg, _L("Instrumental"), NULL, _L("missing value or zero"));
		///End LR_NEED_CHECK_ZERO_ERROR_BAR
		
		///Arvin 08/10/07 QA70-10197 ADD_NONE_OPTION_FOR_ERROR_AS_WEIGHT_IN_LR_PR_AND_MR	
		//if(!nWeightMethod && ((nBadDataMsg&WEIGHT_HAS_MISSING_VALUE)||(nBadDataMsg&WEIGHT_HAS_NAGETIVE_VALUE)))
		if(nWeightMethod == ERRBARWEIGHT_DIRECT_WEIGHTING && ((nBadDataMsg&WEIGHT_HAS_MISSING_VALUE) || (nBadDataMsg&WEIGHT_HAS_NAGETIVE_VALUE)))
		///end ADD_NONE_OPTION_FOR_ERROR_AS_WEIGHT_IN_LR_PR_AND_MR
			return ocu_load_msg_str(CER_VALUE_UNCOMPATIBLE_WITH_WEIGHT_METHOD, &strErrMsg, _L("Direct Weighting"), NULL, _L("nagetive or missing value"));
	}
	
	return false;
}

bool    check_bad_data_for_weight(const TreeNode& trGUI, int nWeightMethods, int& nBadDataMsg) 
///End LR_NEED_CHECK_ZERO_ERROR_BAR
{
	DWORD dwRules = DRR_DEPERR_TO_WEIGHT | DRR_GET_DEPENDENT | DRR_NO_FACTORS;
	if(trGUI.Fit.ApparentFit && trGUI.Fit.ApparentFit.nVal)
		dwRules |= DRR_APPARENT;
		
	DataRange drData;
	TreeNode trRange = trGUI.InputData;
	nBadDataMsg = 0;
	if(trRange)
	{
		drData.Create();
		drData.SetTree(trRange, DRTREE_DEFAULT);
		int nNumData = drData.GetNumData(dwRules);
		for(int ii = 0; ii < nNumData; ii++)
		{
 			vector  vY, vX, vWeights;
 			STGETDATAOUTPUTINFO stOutInfo;
 			int   nn = drData.GetData(dwRules, ii, NULL, NULL, &vY, &vX, NULL, NULL, &vWeights, NULL, NULL, NULL, NULL, NULL, &stOutInfo);
			if(vWeights.GetSize() <= 0)
				continue;
				
			if( !(nBadDataMsg & WEIGHT_HAS_MISSING_VALUE) )
			{		
				if(stOutInfo.nCountMissingErrorValuesFound > 0)
					nBadDataMsg |= WEIGHT_HAS_MISSING_VALUE;
			}
				
			if(!(nBadDataMsg & WEIGHT_HAS_NAGETIVE_VALUE))
			{
				if(stOutInfo.nCountNegativeErrorValuesFound > 0)
					nBadDataMsg |= WEIGHT_HAS_NAGETIVE_VALUE;
			}
			
			/// Iris 8/27/2010 ORG-907 LR_NEED_CHECK_ZERO_ERROR_BAR
			/*
			if((nBadDataMsg & WEIGHT_HAS_MISSING_VALUE) && (nBadDataMsg & WEIGHT_HAS_NAGETIVE_VALUE))
				break;
			*/
			if(!(nBadDataMsg & WEIGHT_HAS_ZERO_VALUE))
			{				
				if(stOutInfo.nCountZeroErrorValuesFound > 0)
					nBadDataMsg |= WEIGHT_HAS_ZERO_VALUE;
			}
			
			if( ERRBARWEIGHT_INSTRUMENTAL == nWeightMethods )
			{
				if((nBadDataMsg & WEIGHT_HAS_MISSING_VALUE) && (nBadDataMsg & WEIGHT_HAS_ZERO_VALUE))
					break;				
			}
			
			if( ERRBARWEIGHT_DIRECT_WEIGHTING == nWeightMethods )
			{
				if((nBadDataMsg & WEIGHT_HAS_MISSING_VALUE) && (nBadDataMsg & WEIGHT_HAS_NAGETIVE_VALUE))
					break;				
			}	
			///End LR_NEED_CHECK_ZERO_ERROR_BAR
		}
			
		return true;
	}
		
	return false;			
}

bool on_check_calibration_branch_event(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
{
#ifndef OP_DLG_TOTALLY_NEW_STRUCTURE_OUTPUT_PART		
	///---Sim 02-09-2011 ORG-2182 NLFIT_MOVE_SETTINGS_FIND_XY
	//TreeNode trCalibration, trBranch1, trBranch2;
	TreeNode trCalibration;
	///---END ORG-2182 NLFIT_MOVE_SETTINGS_FIND_XY
	trCalibration = tree_get_node(tr, nRow).Parent();
	if(trCalibration)
	{
		///---Sim 02-09-2011 ORG-2182 NLFIT_MOVE_SETTINGS_FIND_XY
		//trBranch1 = trCalibration.Custom2;
		//trBranch2 = trCalibration.Custom3;
		///---END ORG-2182 NLFIT_MOVE_SETTINGS_FIND_XY
		TreeNode trOutput =  tree_get_node_by_tagname(tr, "Output", true);
		///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
		//Need support m_trNFO
		if(!trOutput)
		{
			TreeNode trRoot = tr.Parent();
			if(trRoot)
				trOutput =  tree_get_node_by_tagname(trRoot, "Output", true);
		}
		///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
		trOutput = trOutput.FindXY;
		///---Sim 02-09-2011 ORG-2182 NLFIT_MOVE_SETTINGS_FIND_XY
		/////Arvin 01/09/06 FIND_Z_FROM_XY
		////When current operation is "Find Z from X Y", trBranch1 and trBranch2 are NULL,
		////and trCalibration should be tree_get_node(tr, nRow), and trCalibration has not sub-branch trBranch1 and trBranch2.  
		//if(!trBranch1 && !trBranch2)
		//{
		//trCalibration = tree_get_node(tr, nRow);
		//if(trCalibration.Use&& trOutput)
		//{
		//trOutput.Enable = true;
		//trOutput.SetAttribute(STR_ATTRIB_BRANCH, GETNBRANCH_OPEN);
		//}
		//else
		//{
		//trOutput.SetAttribute(STR_ATTRIB_BRANCH, GETNBRANCH_KEEP_SIZE_ON_COLLAPSE);
		//trOutput.Enable = false;	
		//}
		//return true;
		//}
		/////end FIND_Z_FROM_XY
		//if(trBranch1.Use + trBranch2.Use && trOutput)
		//{
		//trOutput.Enable = true;
		//trOutput.SetAttribute(STR_ATTRIB_BRANCH, GETNBRANCH_OPEN);
		//}
		//if(!(trBranch1.Use + trBranch2.Use) && trOutput)
		//{
		//trOutput.SetAttribute(STR_ATTRIB_BRANCH, GETNBRANCH_KEEP_SIZE_ON_COLLAPSE);
		//trOutput.Enable = false;
		//}
		check_calibration_findxy_branch(trCalibration, trOutput);
		///---END ORG-2182 NLFIT_MOVE_SETTINGS_FIND_XY
#endif //OP_DLG_TOTALLY_NEW_STRUCTURE_OUTPUT_PART
	}
	return true;
}
///end OP_DLG_NEW_STRUCTURE

bool  rescale_graph_layer_by_plot(DataPlot& dp, DataRange& drSrc, bool bFitCurvePlot, DWORD dwRules)
{
	if(!dp.IsValid())
		return false;
	
	GraphLayer gl;
	dp.GetParent(gl);
	if(!gl.IsValid())
		return false;
	
	DataRange dr;
	if(!dp.GetDataRange(dr))
		return false;
	
	/// Iris 4/14/2009 QA80-12786-P1 FIX_TOO_DENSE_TICK_LABEL_FOR_DATA_TYPE_INPUT
	//double x1, x2, y1, y2, dx, dy;
	double x1, x2, y1, y2;
	///end FIX_TOO_DENSE_TICK_LABEL_FOR_DATA_TYPE_INPUT
	if(!get_data_range_xy_scale(dr, x1, x2, y1, y2, dwRules))
		return false;
	
	//---- Iris 11/20/2008 v8.0975d QA80-12591-S1 CENTRALIZE_NEW_X_DATA_TYPE_AND_LOG_TYPE_CODES
	//dx = get_min_max_inc(x1, x2, false,0.08, 10);
	//dy = get_min_max_inc(y1, y2, false,0.08, 8);
	/// Iris 4/14/2009 QA80-12786-P1 FIX_TOO_DENSE_TICK_LABEL_FOR_DATA_TYPE_INPUT
	// no need compute increment, but need to round min and max
	//dx = get_min_max_inc(x1, x2, SCALE_TYPE_LINEAR, 0.08, 10);
	//dy = get_min_max_inc(y1, y2, SCALE_TYPE_LINEAR, 0.08, 8);
	get_min_max_inc(x1, x2, SCALE_TYPE_LINEAR, 0.08);
	get_min_max_inc(y1, y2, SCALE_TYPE_LINEAR, 0.08);
	///end FIX_TOO_DENSE_TICK_LABEL_FOR_DATA_TYPE_INPUT
	//----
	if(drSrc) 
	{
		double dx1, dx2, dy1, dy2;
		if(get_data_range_xy_scale(drSrc, dx1, dx2, dy1, dy2, dwRules))
		{
			if(dy1 < y1) { y1 = dy1;}
			if(dy2 > y2) { y2 = dy2;} 
		}
	}
	/// Iris 4/14/2009 QA80-12786-P1 FIX_TOO_DENSE_TICK_LABEL_FOR_DATA_TYPE_INPUT
	//double dxFrom, dxTo, dyFrom, dyTo, dxInc, dyInc;
	//dxInc = dx; dyInc = dy;
	double dxFrom, dxTo, dyFrom, dyTo;
	///end FIX_TOO_DENSE_TICK_LABEL_FOR_DATA_TYPE_INPUT
	if(!bFitCurvePlot)
	{
		dxFrom = gl.X.From; dxTo  = gl.X.To; 
		dyFrom = gl.Y.From; dyTo  = gl.Y.To;
		if(x1 < dxFrom)	{ dxFrom = x1;}
		if(x2 > dxTo)	{ dxTo = x2;}
		if(y1 < dyFrom)	{ dyFrom = y1;}
		if(y2 > dyTo)	{ dyTo = y2;}
	}
	else
	{
		dxFrom = x1; dxTo = x2;
		dyFrom = y1; dyTo = y2;
	}
	
	///------ Folger 04/15/10 QA81-15315 NLFIT_SHOULD_CHANGE_OUTPUT_GRAPH_AXIS_SCALE_IF_MANUAL
	//gl.X.From = dxFrom;
	//gl.X.To = dxTo;
	set_axis_scale_properties(gl.X, &dxFrom, &dxTo, NULL);
	///------ End NLFIT_SHOULD_CHANGE_OUTPUT_GRAPH_AXIS_SCALE_IF_MANUAL
	//gl.X.Inc = dxInc; /// Iris 4/14/2009 QA80-12786-P1 FIX_TOO_DENSE_TICK_LABEL_FOR_DATA_TYPE_INPUT, keep original steps just as plot line on GUI
	///------ Folger 04/15/10 QA81-15315 NLFIT_SHOULD_CHANGE_OUTPUT_GRAPH_AXIS_SCALE_IF_MANUAL
	//gl.Y.From = dyFrom;
	//gl.Y.To = dyTo;
	set_axis_scale_properties(gl.Y, &dyFrom, &dyTo, NULL);
	///------ End NLFIT_SHOULD_CHANGE_OUTPUT_GRAPH_AXIS_SCALE_IF_MANUAL
	//gl.Y.Inc = dyInc;	/// Iris 4/14/2009 QA80-12786-P1 FIX_TOO_DENSE_TICK_LABEL_FOR_DATA_TYPE_INPUT, keep original steps just as plot line on GUI
	return true;
}

/// Iris 3/07/2012 ORG-5218-P1 NEW_GUI_OF_X_DATA_TYPE_FOR_IMPLICIT_FUNC
/// Iris 5/21/2012 ORG-5218-P3 FIX_SET_FUNCTION_BY_THEME_NOT_UPDATE_INDEP_DATA_TYPE_BRANCH
//void check_update_x_data_type_branch(TreeNode& trFitCurve, TreeNode& trFF, DataRange& drInput)
void check_update_x_data_type_branch(TreeNode& trFitCurve, TreeNode& trFF, DataRange& drInput, bool bInit)
///End FIX_SET_FUNCTION_BY_THEME_NOT_UPDATE_INDEP_DATA_TYPE_BRANCH
{	
	/// Iris 5/21/2012 ORG-5218-P3 FIX_SET_FUNCTION_BY_THEME_NOT_UPDATE_INDEP_DATA_TYPE_BRANCH
	//if( !trFitCurve || !trFF )
	if( !trFitCurve )
	///End FIX_SET_FUNCTION_BY_THEME_NOT_UPDATE_INDEP_DATA_TYPE_BRANCH
		return;		
	
	bool bHasImplictAttribute = false;
	BOOL bIsImplicitFuncOld = false;	
	TreeNode trNextNodeOfXDataType;
	ASSERT( trFitCurve.XDataType );		
	if( trFitCurve.XDataType )
	{
		trNextNodeOfXDataType = trFitCurve.XDataType.NextNode;
		bHasImplictAttribute = trFitCurve.XDataType.GetAttribute(STR_IS_IMPLICT_FUNC_ATTRI, bIsImplicitFuncOld);		
	}	
	
	/// Iris 5/21/2012 ORG-5218-P3 FIX_SET_FUNCTION_BY_THEME_NOT_UPDATE_INDEP_DATA_TYPE_BRANCH
	/*
	bool bIsImplicitFuncNew = nlsf_is_implicit_func(trFF);
	if( !bIsImplicitFuncOld && !bIsImplicitFuncNew ) 
		return; // no need update	
	*/
	bool bIsImplicitFuncNew = trFF ? nlsf_is_implicit_func(trFF) : false;	
	if( !bInit && bHasImplictAttribute && trFF && !bIsImplicitFuncOld && !bIsImplicitFuncNew ) 
		return; // no need update for explicit function since only has X data branch	
	///End FIX_SET_FUNCTION_BY_THEME_NOT_UPDATE_INDEP_DATA_TYPE_BRANCH
	
	bool bSourceGraph = false;
	vector<uint> vUID;
	if( drInput.IsValid() && drInput.GetPlots( vUID ) > 0 && vUID.GetSize() > 0 )
	{
		DataPlot dp;
		dp = Project.GetObject(vUID[0]);
		if( dp )
			bSourceGraph = true;
	}
	
	vector<string> vsBranchTagName = {"XDataType", "YDataType", "ZDataType"};	
	vector<int> vnBranchID = {IDE_FIT_DATA_TYPE_BRANCH, IDE_FIT_Y_DATA_TYPE_BRANCH, IDE_FIT_INDEP_DATA_TYPE_BRANCH};
	vector<int> vnPointsNodeID = {IDE_FIT_X_POINTS, IDE_FIT_Y_POINTS, IDE_FIT_INDEP_POINTS};
	vector<int> vnRangeNodeID = {IDE_FIT_RANGE_BRANCH, IDE_FIT_Y_RANGE_BRANCH, IDE_FIT_INDEP_RANGE_BRANCH};
	vector<int> vnMinNodeID = {IDE_FIT_X_MIN, IDE_FIT_Y_MIN, IDE_FIT_INDEP_MIN};
	vector<int> vnMaxNodeID = {IDE_FIT_X_MAX, IDE_FIT_Y_MAX, IDE_FIT_INDEP_MAX};
	vector<int> vnRangeMarginNodeID = {IDE_FIT_RANGE_MARGIN, IDE_FIT_Y_RANGE_MARGIN, IDE_FIT_INDEP_RANGE_MARGIN};
	
	vector<string> vsIndepVars;	
	/// Iris 5/21/2012 ORG-5218-P3 FIX_SET_FUNCTION_BY_THEME_NOT_UPDATE_INDEP_DATA_TYPE_BRANCH
	//int nDataTypeBranchNum = nlf_get_independent_variables(trFF, &vsIndepVars);	
	vector<bool> vShows(MAX_X_DATA_TYPE_SUB_BRANCH_NUM);
	vShows = false;
	int nDataTypeBranchNum;
	///------ Folger 09/29/2012 ORG-7031-P1 X_DATA_TYPE_NODE_MISSING_FROM_PA_FIT
	//if( trFF )
	if( trFF && !trFF.IsEmpty() )
	///------ End X_DATA_TYPE_NODE_MISSING_FROM_PA_FIT
	{
		nDataTypeBranchNum = nlf_get_independent_variables(trFF, &vsIndepVars);	
		for(int nn = 0; nn < nDataTypeBranchNum; nn++)
			vShows[nn] = true;
	}
	else
	{
		nDataTypeBranchNum = MAX_X_DATA_TYPE_SUB_BRANCH_NUM;
		for(int nn = 0; nn < nDataTypeBranchNum; nn++)
			vsIndepVars.Add("var" + (nn+1));		
		vShows[0] = true;
	}
	///End FIX_SET_FUNCTION_BY_THEME_NOT_UPDATE_INDEP_DATA_TYPE_BRANCH
	
	int offset = 0;
	while ( vsBranchTagName.GetSize() < nDataTypeBranchNum )
	{
		int nBranchLTIndex = vsBranchTagName.GetSize() + 2;
		vsBranchTagName.Add( "IndepDataType" + nBranchLTIndex );
		
		offset++;
		vnBranchID.Add( IDE_FIT_INDEP_DATA_TYPE_BRANCH + offset );
		vnPointsNodeID.Add( IDE_FIT_INDEP_POINTS + offset );
		vnRangeNodeID.Add( IDE_FIT_INDEP_RANGE_BRANCH + offset );
		vnMinNodeID.Add( IDE_FIT_INDEP_MIN + offset );
		vnMaxNodeID.Add( IDE_FIT_INDEP_MAX + offset );
		vnRangeMarginNodeID.Add( IDE_FIT_INDEP_RANGE_MARGIN + offset );
	}
		
	for(int nVar = 0; nVar < nDataTypeBranchNum; ++nVar)
	{
		// Data Type branch
		TreeNode trDataTypeBranch = trFitCurve.GetNode(vsBranchTagName[nVar]);
		if( !trDataTypeBranch )
		{
			if( trNextNodeOfXDataType.IsValid() )
				trDataTypeBranch = trFitCurve.InsertNode(trNextNodeOfXDataType, vsBranchTagName[nVar], TRGP_BRANCH);
			else
				trDataTypeBranch = trFitCurve.AddNode(vsBranchTagName[nVar], TRGP_BRANCH);
			trDataTypeBranch.SetAttribute(STR_DATAID_ATTRIB, vnBranchID[nVar]);
			trDataTypeBranch.SetAttribute(STR_ATTRIB_HANDLER, (ODWP)(PEVENT_FUNC)fit_curv_data_type_even);
		}
		trDataTypeBranch.Show = vShows[nVar]; /// Iris 5/21/2012 ORG-5218-P3 FIX_SET_FUNCTION_BY_THEME_NOT_UPDATE_INDEP_DATA_TYPE_BRANCH
		if( !bInit ) // When bInit is true in this moment this function is used to construct max number branchs to apply theme. So only set this attribute in !bInit time, this time is real first time to construct this branch.
		{
			trDataTypeBranch.SetAttribute(STR_IS_IMPLICT_FUNC_ATTRI, (int)bIsImplicitFuncNew);
		}
		trDataTypeBranch.SetAttribute(STR_DATA_TYPE_BRANCH_NUM_ATTRIB, nDataTypeBranchNum);
		
		const string strDataType = _L("Data Type");
		string strBranchLabel; // set branch label with diff way for implicit function
		if( bIsImplicitFuncNew ) 
		{
			/// Iris 4/12/2012 ORG-5218-P1 NEW_GUI_OF_X_DATA_TYPE_FOR_IMPLICIT_FUNC_MORE
			//string strVarName = (nVarNum > nDataTypeBranchNum) ? _L("Independent Variables") : vsIndepVars[nVar];			
			//strBranchLabel.Format("%s of %s", strDataType, strVarName);			
			strBranchLabel.Format("%s of %s", strDataType, vsIndepVars[nVar]);	
			///End NEW_GUI_OF_X_DATA_TYPE_FOR_IMPLICIT_FUNC_MORE			
		}
		else
		{
			vsIndepVars[nVar].MakeUpper();
			string strVarName = (0 == nVar) ? "X" : vsIndepVars[nVar];
			strBranchLabel.Format("%s %s", strVarName, strDataType);
		}		
		trDataTypeBranch.SetAttribute(STR_LABEL_ATTRIB, strBranchLabel);		
		
		string strCombo =  STR_FITTED_CURVE_DATA_TYPE_UNIFORM_LINEAR + STR_TOKEN_SEP + STR_FITTED_CURVE_DATA_TYPE_UNIFORM_LOG + STR_TOKEN_SEP;
		if( bIsImplicitFuncNew )
			strCombo += STR_FITTED_CURVE_DATA_TYPE_FITTED_POINT_FOR_INPUT;
		else
			strCombo += STR_FITTED_CURVE_DATA_TYPE_SAME_INPUT;
		if( bSourceGraph )
			strCombo += STR_TOKEN_SEP + STR_FITTED_CURVE_DATA_TYPE_SAME_SOURCE_GRAPH;
		trDataTypeBranch.SetAttribute(STR_ATTRIB_BRANCH_COMBO, strCombo);
		
		int nUse;
		if( !trDataTypeBranch.GetAttribute(STR_USE_ATTRIB, nUse) )
			trDataTypeBranch.Use = FIT_CURVE_UNIFORM_LINEAR;
		
		// Points node
		TreeNode trPoints = trDataTypeBranch.GetNode("N");
		if( !trPoints )
		{			
			trPoints = trDataTypeBranch.AddNode("N", TRGP_DOUBLE);
			trPoints.SetAttribute(STR_DATAID_ATTRIB, vnPointsNodeID[nVar]);				
			/// Iris 4/12/2012 ORG-5218-P1 NEW_GUI_OF_X_DATA_TYPE_FOR_IMPLICIT_FUNC_MORE
			//trPoints.SetAttribute(STR_LABEL_ATTRIB, _L("Points"));
			///End NEW_GUI_OF_X_DATA_TYPE_FOR_IMPLICIT_FUNC_MORE
		}
		/// Iris 4/12/2012 ORG-5218-P1 NEW_GUI_OF_X_DATA_TYPE_FOR_IMPLICIT_FUNC_MORE		
		if( bIsImplicitFuncNew )
			trPoints.SetAttribute(STR_LABEL_ATTRIB, _L("Gridding Size"));
		else
			trPoints.SetAttribute(STR_LABEL_ATTRIB, _L("Points"));
		///End NEW_GUI_OF_X_DATA_TYPE_FOR_IMPLICIT_FUNC_MORE
		
		/// Iris 4/12/2012 ORG-5218-P1 NEW_GUI_OF_X_DATA_TYPE_FOR_IMPLICIT_FUNC_MORE
		if( !bInit )
		{
			if( bIsImplicitFuncNew )
				trPoints.nVal = 50;		
			else
			///End NEW_GUI_OF_X_DATA_TYPE_FOR_IMPLICIT_FUNC_MORE
				trPoints.nVal = MORE_XY_FIT_DEFAULT_POINTS;			
		}
		
		// Range
		TreeNode trRange = trDataTypeBranch.GetNode("Range");
		if( !trRange )
		{
			trRange = trDataTypeBranch.AddNode("Range", TRGP_ENUM_LIST);
			trRange.SetAttribute(STR_DATAID_ATTRIB, vnRangeNodeID[nVar]);
			trRange.SetAttribute(STR_LABEL_ATTRIB, _L("Range"));
			trRange.SetAttribute(STR_COMBO_ATTRIB, STR_FITTED_CURVE_DATA_TYPE_RANGE_OPTIONS);
			trRange.SetAttribute(STR_ATTRIB_HANDLER, (ODWP)(PEVENT_FUNC)fit_curv_range_even);
		}
		
		/// Iris 4/12/2012 ORG-5218-P1 NEW_GUI_OF_X_DATA_TYPE_FOR_IMPLICIT_FUNC_MORE
		//trRange.Show = !bIsImplicitFuncNew;
		///End NEW_GUI_OF_X_DATA_TYPE_FOR_IMPLICIT_FUNC_MORE
		if( bIsImplicitFuncNew )
		{
			if( !trRange.IsEmpty() )
				trRange.SetAttribute(STR_CHANGED_ATTRIB, trRange.nVal);
			
			/// Iris 4/12/2012 ORG-5218-P1 NEW_GUI_OF_X_DATA_TYPE_FOR_IMPLICIT_FUNC_MORE
			//trRange.nVal = FIT_CURVE_CUSTOM;
			vector<string> vsCombo;
			string strList = STR_FITTED_CURVE_DATA_TYPE_RANGE_OPTIONS;
			strList.GetTokens(vsCombo, '|');
			
			if( vsCombo.GetSize() > FIT_CURVE_SPAN_AXIS )
			{
				vsCombo.RemoveAt(FIT_CURVE_SPAN_AXIS);	
				strList.SetTokens(vsCombo, '|');
				trRange.SetAttribute(STR_COMBO_ATTRIB, strList);
				
				string strMap = (string)FIT_CURVE_RANGE_MARGIN + "|" + (string)FIT_CURVE_CUSTOM;
				trRange.SetAttribute(STR_INTMAP_ATTRIB, strMap);
			}
			///End NEW_GUI_OF_X_DATA_TYPE_FOR_IMPLICIT_FUNC_MORE
		}
		else
		{
			int nOldVal;
			if( trRange.GetAttribute(STR_CHANGED_ATTRIB, nOldVal) )
				trRange.nVal = nOldVal;	
			
			/// Iris 4/12/2012 ORG-5218-P1 NEW_GUI_OF_X_DATA_TYPE_FOR_IMPLICIT_FUNC_MORE
			trRange.SetAttribute(STR_COMBO_ATTRIB, STR_FITTED_CURVE_DATA_TYPE_RANGE_OPTIONS);
			trRange.RemoveAttribute(STR_INTMAP_ATTRIB);
			///End NEW_GUI_OF_X_DATA_TYPE_FOR_IMPLICIT_FUNC_MORE				
		}
		if( trRange.IsEmpty )
			trRange.nVal = FIT_CURVE_RANGE_MARGIN;				
		
		// Min, Max		
		TreeNode trMin = trDataTypeBranch.GetNode("Min");
		if( !trMin )
		{
			trMin = trDataTypeBranch.AddNode("Min", TRGP_DOUBLE);
			trMin.SetAttribute(STR_DATAID_ATTRIB, vnMinNodeID[nVar]);
			trMin.SetAttribute(STR_LABEL_ATTRIB, _L("Min"));
			trMin.SetAttribute(STR_ATTRIB_AUTO, 1);		
		}		
		
		TreeNode trMax = trDataTypeBranch.GetNode("Max");
		if( !trMax )
		{
			trMax = trDataTypeBranch.AddNode("Max", TRGP_DOUBLE);
			trMax.SetAttribute(STR_DATAID_ATTRIB, vnMaxNodeID[nVar]);
			trMax.SetAttribute(STR_LABEL_ATTRIB, _L("Max"));
			trMax.SetAttribute(STR_ATTRIB_AUTO, 1);		
		}				
		
		// margin of Range
		TreeNode trMargin = trDataTypeBranch.GetNode("RangeMargin");
		/// Iris 4/12/2012 ORG-5218-P1 NEW_GUI_OF_X_DATA_TYPE_FOR_IMPLICIT_FUNC_MORE
		/*
		if( trMargin )
			trMargin.Show = !bIsImplicitFuncNew;	
		*/
		if( !trMargin )
		{
			trMargin = trDataTypeBranch.AddNode("RangeMargin");
			trMargin.SetAttribute(STR_DATAID_ATTRIB, vnRangeMarginNodeID[nVar]);
			trMargin.SetAttribute(STR_LABEL_ATTRIB, _L("Range Margin (%)"));
			trMargin.nVal = 0;
		}			
		if( bIsImplicitFuncNew )
			/// Iris 4/19/2012 ORG-5218-P1 NEW_GUI_OF_X_DATA_TYPE_FOR_IMPLICIT_FUNC_EX
			//trMargin.nVal = 10;
			trMargin.nVal = 20;
			///End NEW_GUI_OF_X_DATA_TYPE_FOR_IMPLICIT_FUNC_EX
		///End NEW_GUI_OF_X_DATA_TYPE_FOR_IMPLICIT_FUNC_MORE
	}
		
	// to hide the redundant data type branch
	/// Iris 5/21/2012 ORG-5218-P3 FIX_SET_FUNCTION_BY_THEME_NOT_UPDATE_INDEP_DATA_TYPE_BRANCH
	/*
	for(int ii = 0; ii < vsBranchTagName.GetSize(); ++ii)		
	{		
		TreeNode trDataType = trFitCurve.GetNode(vsBranchTagName[ii]);
		if( trDataType )
			trDataType.Show = (ii < nDataTypeBranchNum);			
		else
			break;
	}
	*/
	offset = 0;
	for(int ii = 0; ii < MAX_X_DATA_TYPE_SUB_BRANCH_NUM; ++ii)		
	{
		int nDataID = ii < vnBranchID.GetSize() ? vnBranchID[ii] : vnBranchID[vnBranchID.GetSize() - 1] + (++offset);
		TreeNode trBranch = tree_get_node_by_dataid(trFitCurve, nDataID);
		if( trBranch )
			trBranch.Show = vShows[ii];
	}
	///End FIX_SET_FUNCTION_BY_THEME_NOT_UPDATE_INDEP_DATA_TYPE_BRANCH
}
///End NEW_GUI_OF_X_DATA_TYPE_FOR_IMPLICIT_FUNC