/*------------------------------------------------------------------------------*
 * File Name: query_utils.h	   													*
 * Creation: Sophy 10/10/2010													*
 * Purpose: Used for ADO programming for Origin DB 								*
 * Copyright (c) OriginLab Corp.	2010										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	AW 10/15/2010 ORG-1179 GET_DB_INFO_FOR_NEW_TOOL								*
 *	Sophy 11/1/2010 ORG-1336 ADO_IMPORT_WITH_SQLITE_TEXT_DATA_MAKE_GET_RECORDCOUNT_INFINITE_LOOP
 *	Folger 07/04/2012 ORG-6101-P1 WKS_IMPORT_DATA_SHOULD_CLEAR_HIDDEN_STATUS	*
 *------------------------------------------------------------------------------*/

#ifndef	_QUERY_UTILS_H_
#define	_QUERY_UTILS_H_

#define STR_DS_FILE_DIALOG				"[Data Source File (*.ODS)] *.ODS"
#define STR_QUERY_FILE_DIALOG			"[Query File (*.ODQ)] *.ODQ"

///Sophy 8/3/2009 QA80-14057 SUPPORT_IMPORTING_INTO_WKS_USING_ODBC_IN_QUERY_BUILDER
#ifdef	__SUPPORT_IMPORT_DATA_BY_ODBC_IN_QUERY_BUILDER__
#define	STR_QUERY_MODE_ODBC		"ODBC"
#define	STR_QUERY_MODE_ADO		"ADO"
#define	STR_QUERY_MODE					"UseODBC"
#endif	//__SUPPORT_IMPORT_DATA_BY_ODBC_IN_QUERY_BUILDER__
///end SUPPORT_IMPORTING_INTO_WKS_USING_ODBC_IN_QUERY_BUILDER

//Constants
#define STR_QUERY_SQL					STR_SQL
#define STR_QUERY_CONN					STR_DATA_SOURCE
#define	STR_QUERY_OPTIONS				"Options"
#define	STR_QUERY_BEFORESCRIPT			"BeforeScript"	///Sophy 1/12/2011 ORG-2000 SQL_EDIT_ADO_QUERY_ALLOW_LABTALK_VARIABLE_SUPPORT


enum
{
	ADO_ERR_CREATE_OBJ = -4,
	ADO_ERR_GET_SQL_STR = -3,
	ADO_ERROR_NONE = 0,
	ADO_ERROR_CONN_STR_CHANGED = 1,
	ADO_ERROR_CLOSE_CONN,
	ADO_ERROR_CLOSE_RECORDSET,
	ADO_ERROR_OPEN_CONN,
	ADO_ERROR_OPEN_RECORDSET,
	ADO_ERROR_RESYNC_RECORDSET,
	ADO_ERROR_RECORDSET_IS_NOT_OPEN,
	INVALID_WKS_DB_COMMAND,
	FAILED_TO_PUT_RECORD_TO_WKS,
	ADO_ERROR_EMPTY_RECORDSET,
	ADO_ERROR_CONN_ODBC_FAIL,
	ADO_ERROR_INVALID_ODBC_DSN,
	ADO_ERROR_INVALID_WORKSHEET,
	ADO_ERROR_INVALID_BEFORE_SCRIPT,
};

#define STR_ODS			"ODS"
#define STR_ODQ			"ODQ"

#define STR_PASSWORD	"Password="
#define STR_PWD			"PWD="
#define STR_CONN_DATA_SOURCE	"Data Source="
#define	STR_CONN_DSN			"DSN="
#define	STR_CONN_USER_ID		"User ID="
#define	STR_CONN_UID			"UID="

enum {
	UNKNOWN_FILE	= -1,
	ADO_NEW_FILE	= 0,
	ADO_ODQ_FILE,
	ADO_ODS_FILE,
	ADO_WKS_FILE,
};
//!!!for import options, these values might be saved in *.ODQ/*.ODS, should not be changed!!!
enum {
	OPTION_BY_ODBC				= 0x0001,
	OPTION_OVERWRITE_LONGNAME	= 0x0002,	///Sophy 11/9/2010 ORG-1179-P2 REMEMBER_AUTO_GENERATED_SQL_STATEMENT_BY_QUERYBUILDER
	OPTION_AUTORESIZE_WORKSHEET	= 0x0004,	///Sophy 11/15/2010 ORG-1179-P6 OPTION_FOR_RESIZE_WORKSHEET_COLUMNS_WHEN_IMPORT
	OPTION_LABTALK_SUPPORT		= 0x0008,	///Sophy 1/12/2011 ORG-2000 SQL_EDIT_ADO_QUERY_ALLOW_LABTALK_VARIABLE_SUPPORT
	OPTION_NO_TABLELIST			= 0x0010,	///Sophy 1/28/2011 ORG-2134 OPTOIN_FOR_SHOW_HIDE_DATABASE_TABLE_TREE
	//---- CPY 3/9/11 ORG-2000-P2 DEFAULT_SHOULD_SUBSTITUDE_INSIDE_QUOTE
	//OPTION_LTVAR_PARSE_ALL		= 0x0020,	///Sophy 2/24/2011 ORG-2000-S2 OPTION_FOR_CTRL_PARSE_LTVAR_WITHIN_SINGLE_QUOTES
	OPTION_LTPARSE_IGNORE_QUOTE	= 0x0020,
	OPTION_LT_BITS				= OPTION_LABTALK_SUPPORT | OPTION_LTPARSE_IGNORE_QUOTE,
	//----
	OPTION_UPDATE_MASK			= OPTION_LT_BITS | OPTION_BY_ODBC | OPTION_NO_TABLELIST,	///Sophy 3/11/2011 ORG-2000 CLEAN_CODE_FOR_DATABASEIMPORTDLG
};


#define	ARGC_NO_QUOTE_SUB	0x2000	///Sophy 2/17/2011 ORG-2000-P6 ARG_COPY_NEED_WAY_TO_SKIP_SUB_STRING_WITHIN_SINGLE_QUOTES this is the same as in okconst.h
//const from sqlext.h
#define	SQL_C_CHAR		1
#define	SQL_C_LONG		4
#define	SQL_C_DOUBLE	8
#define	SQL_C_DATE		9
#define	SQL_C_TIMESTAMP	11
#define	SQL_C_GUID		(-11)
#define	SQL_C_BINARY	(-2)

#define	STR_ODBC_TAG	"Provider=MSDASQL"

#define	STR_CATALOG			"Catalog"
#define	STR_SCHEMA			"Schema"
#define	STR_UNKNOWN			"Unknown"
#define	STR_TABLES			"Tables"
#define	STR_VIEWS			"Views"
#define	STR_FIELDS			"Fields"

#define	STR_TABLE_CATALOG	"TABLE_CATALOG"
#define	STR_TABLE_SCHEMA	"TABLE_SCHEMA"
#define	STR_TABLE_NAME		"TABLE_NAME"
#define	STR_TABLE_TYPE		"TABLE_TYPE"
#define	STR_DATE_CREATED	"DATE_CREATED"
#define	STR_DATE_MODIFIED	"DATE_MODIFIED"
#define	STR_COLUMN_NAME		"COLUMN_NAME"
#define	STR_DATA_TYPE		"DATA_TYPE"
#define	STR_COLUMN_DEFAULT	"COLUMN_DEFAULT"
#define	STR_ORDINAL_POSITION	"ORDINAL_POSITION"
#define	STR_IS_NULLABLE		"IS_NULLABLE"
#define	STR_DESCRIPTION		"DESCRIPTION"

#define	STR_SYSTEM_TABLE	"SYSTEM TABLE"
#define	STR_SYSTEM_VIEW		"SYSTEM VIEW"
#define	STR_TABLE			"TABLE"
#define	STR_VIEW			"VIEW"
#define	STR_ACCESS_TABLE	"ACCESS TABLE"

enum SchemaEnum {
	adSchemaAsserts				= 0,
	adSchemaCatelogs			= 1,
	adSchemaCharaterSets		= 2,
	adSchemaCollations			= 3,
	adSchemaColumns				= 4,
	adSchemaCheckConstraints	= 5,
	//...
	adSchemaSchemata			= 17,
	adSchemaSQLLanguages		= 18,
	adSchemaTables				= 20,
	adSchemaViews				= 23,
};
///Sophy 11/1/2010 ORG-1336 ADO_IMPORT_WITH_SQLITE_TEXT_DATA_MAKE_GET_RECORDCOUNT_INFINITE_LOOP
enum CursorTypeEnum {
	adOpenUnspecified			= -1,
	adOpenForwardOnly			= 0,
	adOpenKeyset				= 1,
	adOpenDynamic				= 2,
	adOpenStatic				= 3
};

enum CursorLocationEnum {
	adUseNone					= 1,
	adUseServer					= 2,
	adUseClient					= 3,
	adUseClientBatch			= 3
};
///end ADO_IMPORT_WITH_SQLITE_TEXT_DATA_MAKE_GET_RECORDCOUNT_INFINITE_LOOP

///Sophy 1/12/2011 ORG-2000 SQL_EDIT_ADO_QUERY_ALLOW_LABTALK_VARIABLE_SUPPORT
typedef	struct {
	string	strBeforeScript;
} ADOQUERYOPTION;

class	LTStackHelper
{
public:
	LTStackHelper()
	{
		okutil_LT_stack(TRUE);
	}
	~LTStackHelper()
	{
		okutil_LT_stack(FALSE);
	}
};
///end SQL_EDIT_ADO_QUERY_ALLOW_LABTALK_VARIABLE_SUPPORT
//here I try to centralize the code both for old querybuilder dialog and the new dialog
bool	get_new_filename(string& strFileName, const StringArray &saFileTypes, bool bSave = false );
///Sophy 1/12/2011 ORG-2000 SQL_EDIT_ADO_QUERY_ALLOW_LABTALK_VARIABLE_SUPPORT
//bool	access_query_file(LPCSTR lpcszFileName, string& strConnection, string& strSQL, DWORD& dwOptions, bool bSave = false);
bool	access_query_file(LPCSTR lpcszFileName, string& strConnection, string& strSQL, DWORD& dwOptions, ADOQUERYOPTION* pExtOptions = NULL, bool bSave = false);
///end SQL_EDIT_ADO_QUERY_ALLOW_LABTALK_VARIABLE_SUPPORT
int		get_file_type( LPCTSTR lpcszFileName );
bool	check_is_need_login_prompt(LPCSTR lpcszConnStr, string *pStrUerID = NULL, string *pStrDS = NULL );
///Sophy 1/12/2011 ORG-2000 SQL_EDIT_ADO_QUERY_ALLOW_LABTALK_VARIABLE_SUPPORT
//bool	load_query_from_worksheet(const Worksheet &wks, string &strConnStr, string & strSQL, DWORD& dwOptions);
//bool	save_query_to_worksheet(Worksheet& wks, LPCSTR lpcszConnStr, LPCSTR lcpszSQL, DWORD dwOptions);
bool	load_query_from_worksheet(const Worksheet &wks, string &strConnStr, string & strSQL, DWORD& dwOptions, ADOQUERYOPTION* pExtOpt = NULL);
bool	save_query_to_worksheet(Worksheet& wks, LPCSTR lpcszConnStr, LPCSTR lcpszSQL, DWORD dwOptions, ADOQUERYOPTION* pExtOpt = NULL);
///end SQL_EDIT_ADO_QUERY_ALLOW_LABTALK_VARIABLE_SUPPORT
int		import_to_worksheet(Worksheet& wks, int nStartColIndex = 0, int nPreviewLines = 0, bool bLoginPrompt = true, HWND hDlg = NULL );
bool	hide_value_by_key( LPCTSTR lpcszOldStrConn , LPCTSTR lpcszKey, string &strConn );
bool	sort_fields_by_position(TreeNode& trTable); ///Sophy 10/19/2010 SUPPORT_SORT_FIELDS_OF_TABLE_VIEW_BY_ORDINAL_POSITION
bool	add_password_to_connection_str(LPCSTR lpcszConnStr, LPCSTR lpcszUser, LPCSTR lpcszPwd, string& strConnStr);
bool	make_ODBC_connection_from_ADO_connection(const string& strADOConnStr, string& strODBCConnStr);
///Sophy 12/3/2010 ORG-1647-P1 SMART_DETECT_TARGET_WORKSHEET_FOR_DATABASE_IMPORT
bool	is_worksheet_good_for_database_import(Worksheet& wks);
///end SMART_DETECT_TARGET_WORKSHEET_FOR_DATABASE_IMPORT

int process_before_query_script(const string& strBeforeScript, string& strSQL, DWORD dwOptions); //----- CPY 3/14/2011 ORG-2000 MORE_CLEAN_CODE_FOR_DATABASEIMPORTDLG

///------ Folger 07/04/2012 ORG-6101-P1 WKS_IMPORT_DATA_SHOULD_CLEAR_HIDDEN_STATUS
void check_reset_hidden_rows_before_PutRecordset(Worksheet& wks, int nRowBegin = 0,	int nColBegin = 0);
///------ End WKS_IMPORT_DATA_SHOULD_CLEAR_HIDDEN_STATUS

///Sophy 8/13/2012 ORG-6485-P1 SHOW_ERROR_MESSAGE_WHEN_DBIMPORT_ERROR_OCCUR
int		db_cvt_err_code(int nInternalCode);
///end SHOW_ERROR_MESSAGE_WHEN_DBIMPORT_ERROR_OCCUR

///Sophy 8/16/2012 ORG-6485-P3 TRY_GET_MORE_DETAILS_INFO_WHEN_CONNECT_FAIL
bool	check_get_last_error(Object& orsconn, string& strErrMsg);
///end TRY_GET_MORE_DETAILS_INFO_WHEN_CONNECT_FAIL
#endif	//_QUERY_UTILS_H_