/*------------------------------------------------------------------------------*
 * File Name: query_utils.c	   													*
 * Creation: Sophy 10/10/2010													*
 * Purpose: Used for ADO programming for Origin DB 								*
 * Copyright (c) OriginLab Corp.	2010										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Sophy 11/1/2010 ORG-1336 ADO_IMPORT_WITH_SQLITE_TEXT_DATA_MAKE_GET_RECORDCOUNT_INFINITE_LOOP
 *	CPY 1/7/2011 ORG-1915-P2 ALLOW_COL_FORMULA_IN_DB_IMPORT						*
 *	Sophy 3/8/2011 ORG-2395-P1 IMPROVE_OKUTIL_GET_TOKENS_SUPPORTING_IGNORE_SINGLE_QUOTES
 * CPY 3/9/11 ORG-2000-P2 DEFAULT_SHOULD_SUBSTITUDE_INSIDE_QUOTE				*
 *	Folger 07/04/2012 ORG-6101-P1 WKS_IMPORT_DATA_SHOULD_CLEAR_HIDDEN_STATUS	*
 *	Sophy 8/13/2012 ORG-6485-P1 SHOW_ERROR_MESSAGE_WHEN_DBIMPORT_ERROR_OCCUR	*
 *------------------------------------------------------------------------------*/


// system header file.
#include <Origin.h>
////////////////////////////////////////////////////////////////////////////////////

//#pragma labtalk(0) // to disable OC functions for LT calling.

////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.
#include <ocu.h>
#include <GetNBox.h>
#include <..\Originlab\OODBC.h>
#include "query_utils.h"


//----- CPY 3/9/11 ORG-2000-P2 DEFAULT_SHOULD_SUBSTITUDE_INSIDE_QUOTE
#define DEFAULT_DB_LT_OPTIONS	0
//----- end DEFAULT_SHOULD_SUBSTITUDE_INSIDE_QUOTE

////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.
static void _check_add_path(string& strFile, int nPath = ORIGIN_PATH_USER)
{
	string strPath = GetFilePath(strFile);
	if(strPath.IsEmpty())
	{
		string strUserPath = okutil_get_origin_path(nPath);
		strFile = strUserPath + strFile;
	}
}

#define	STR_C_STYLE_COMMENT_BEGIN	"/*"
#define	STR_C_STYLE_COMMENT_END		"*/"
#define	STR_SQL_NEWLINE				"\r\n"
#define	STR_SQL_COMMENT_BEGIN		"--"
static	bool	_check_parse_sql_statement(string& strSQL)
{
	if ( strSQL.GetLength() == 0 )
		return false;
	int nCSCBegin = 0;
	int nCSCEnd = 0;
	nCSCBegin = strSQL.Find(STR_C_STYLE_COMMENT_BEGIN, 0);
	while ( nCSCBegin < strSQL.GetLength() && nCSCBegin >= 0 )
	{
		nCSCEnd = strSQL.Find(STR_C_STYLE_COMMENT_END, nCSCBegin + strlen(STR_C_STYLE_COMMENT_BEGIN)); //skip "/*"
		ASSERT(nCSCEnd > nCSCBegin);
		if ( nCSCEnd <= nCSCBegin )
			break;
		string strComments = strSQL.Mid(nCSCBegin, (nCSCEnd - nCSCBegin) + strlen(STR_C_STYLE_COMMENT_END));
		strSQL.Replace(strComments, STR_SQL_NEWLINE);
		nCSCBegin = strSQL.Find(STR_C_STYLE_COMMENT_BEGIN, 0);
	}
	vector<string>	vsLines;
	///Sophy 3/8/2011 ORG-2395-P1 IMPROVE_OKUTIL_GET_TOKENS_SUPPORTING_IGNORE_SINGLE_QUOTES
	//int nLines = okutil_get_tokens(strSQL, &vsLines, '\n', NULL);
	int nLines = okutil_get_tokens(strSQL, &vsLines, '\n', NULL, '"', GT_CHECK_SINGLE_QUOTES);
	///end IMPROVE_OKUTIL_GET_TOKENS_SUPPORTING_IGNORE_SINGLE_QUOTES
	for ( int iLine = 0; iLine < nLines; iLine++ )
	{
		string strLine = vsLines[iLine];
		int nCommentsPos = strLine.Find(STR_SQL_COMMENT_BEGIN, 0);
		if ( nCommentsPos >= 0 )
		{
			strLine = strLine.Left(nCommentsPos);
		}
		vsLines[iLine] = strLine;
	}
	strSQL.SetTokens(vsLines, '\n');
	strSQL.TrimRight(" ;\r\n"); //for some database(Oracle, e.g) they do NOT allow ';' at the end
	return true;
}
bool	get_new_filename(string& strFileName, const StringArray &saFileTypes, bool bSave )
{
	string strUserPath = GetAppPath();
	string strTempFileName;
	if( bSave )
		strTempFileName = GetSaveAsBox(saFileTypes, strUserPath, GetFileName(strFileName, TRUE));
	else
		strTempFileName = GetOpenBox(saFileTypes, strUserPath, GetFileName(strFileName, TRUE));

	if( !strTempFileName.IsEmpty() )
	{
		strFileName = strTempFileName;
		return true;
	}

	return false;
}


///Sophy 1/12/2011 ORG-2000 SQL_EDIT_ADO_QUERY_ALLOW_LABTALK_VARIABLE_SUPPORT
//bool	access_query_file(LPCSTR lpcszFileName, string& strConnection, string& strSQL, DWORD& dwOptions, bool bSave)
bool	access_query_file(LPCSTR lpcszFileName, string& strConnection, string& strSQL, DWORD& dwOptions, ADOQUERYOPTION* pExtOptions, bool bSave)
///end SQL_EDIT_ADO_QUERY_ALLOW_LABTALK_VARIABLE_SUPPORT
{
	///Sophy 3/16/2011 ORG-2000-P10 SAVE_CONNECTION_SETTINGS_SHOULD_NOT_RESET_OPTIONS
	//dwOptions = DEFAULT_DB_LT_OPTIONS;//----- CPY 3/9/11 ORG-2000-P2 DEFAULT_SHOULD_SUBSTITUDE_INSIDE_QUOTE
	///end SAVE_CONNECTION_SETTINGS_SHOULD_NOT_RESET_OPTIONS

	int nRet = 0;
	string strQueryFileName = lpcszFileName;
	int nFileType = get_file_type( lpcszFileName );
	if ( bSave )
	{
		_check_add_path(strQueryFileName);
		nRet = okutil_write_file_section(strQueryFileName, STR_QUERY_CONN, strConnection, "ConnectionString");
		if ( nRet < 0 )
			return false;
		
		if( nFileType == ADO_ODQ_FILE )
		{
			nRet = okutil_write_file_section(strQueryFileName, STR_QUERY_SQL, strSQL, NULL); 
			if ( nRet < 0 )
				return false;
			string strOptions = dwOptions;
			nRet = okutil_write_file_section(strQueryFileName, STR_QUERY_OPTIONS, strOptions, NULL); 
			if ( nRet < 0 )
				return false;
			///Sophy 1/12/2011 ORG-2000 SQL_EDIT_ADO_QUERY_ALLOW_LABTALK_VARIABLE_SUPPORT
			string strBeforeScript = "";
			if ( NULL != pExtOptions )
				strBeforeScript = pExtOptions->strBeforeScript;
			nRet = okutil_write_file_section(strQueryFileName, STR_QUERY_BEFORESCRIPT, strBeforeScript, NULL);
			if ( nRet < 0 )
				return false;
			///end SQL_EDIT_ADO_QUERY_ALLOW_LABTALK_VARIABLE_SUPPORT
		}
	}
	else
	{
	
		nRet = okutil_read_file_section(strQueryFileName, STR_QUERY_CONN, &strConnection, NULL);
		if ( nRet < 0 )
			return false;
	
		if( nFileType == ADO_ODQ_FILE )
		{
			nRet = okutil_read_file_section(strQueryFileName, STR_QUERY_SQL, &strSQL, NULL);
			if ( nRet < 0 )
				return false;
			string strOptions;
			nRet = okutil_read_file_section(strQueryFileName, STR_QUERY_OPTIONS, strOptions, NULL); 
			if ( nRet < 0 ) //allow error to keep backward compatibility
			{
				okutil_read_file_section(strQueryFileName, STR_QUERY_MODE, &strOptions, NULL);
				dwOptions = strOptions.CompareNoCase(STR_QUERY_MODE_ODBC) == 0 ? OPTION_BY_ODBC : 0;
				dwOptions |= DEFAULT_DB_LT_OPTIONS;	///Sophy 3/16/2011 ORG-2000-P10 SAVE_CONNECTION_SETTINGS_SHOULD_NOT_RESET_OPTIONS
			}
			else
				dwOptions = atol(strOptions);
			///Sophy 1/12/2011 ORG-2000 SQL_EDIT_ADO_QUERY_ALLOW_LABTALK_VARIABLE_SUPPORT
			if ( NULL != pExtOptions )
			{
				string strBeforeScript = "";
				okutil_read_file_section(strQueryFileName, STR_QUERY_BEFORESCRIPT, &strBeforeScript, NULL);
				pExtOptions->strBeforeScript = strBeforeScript;
			}
			///end SQL_EDIT_ADO_QUERY_ALLOW_LABTALK_VARIABLE_SUPPORT
		}
	}
	return true;
}

bool	check_is_need_login_prompt( LPCSTR lpcszConnStr, string *pStrUerID /*= NULL*/, string *pStrDS /*= NULL*/ )
{
	string strConn = lpcszConnStr;
	strConn.TrimLeft(); strConn.TrimRight();
	if(strConn.IsEmpty())
		return false;
	vector<string> vsKeys, vsValues, vsKeysLower;
	int nRet = ocu_separate_key_values(strConn, &vsKeys, &vsValues);
	vsKeysLower = vsKeys;
	
	BOOL bSecurity = false;
	BOOL bHasPW = false;
	for(int ii = 0; ii < vsKeys.GetSize(); ii++) 
	{
		string strKey = vsKeysLower[ii];
		strKey.MakeLower();
		if ( strKey.Find("security") >= 0 )
		{
			bSecurity = vsValues[ii].CompareNoCase("true") == 0 ? true: false;		
		}
		///Sophy 11/16/2010 ORG-1493 MORE_WORK_ON_CHECK_ACCESS_DATABASE_PASSWORD
		//if ( strKey.Find("password") >= 0 )
		if ( strKey.Find("password") >= 0 || strKey.Find("Jet OLEDB:Database Password") >= 0 || strKey.Find("Jet OLEDB:New Database Password") >= 0 )
		///end MORE_WORK_ON_CHECK_ACCESS_DATABASE_PASSWORD
		{
			bHasPW = true;	
		}

		if( pStrUerID != NULL && strKey.Find("user id") >= 0)
		{
			*pStrUerID = vsValues[ii];	
		}

		if( pStrDS != NULL && strKey.Find("data source") >= 0)
		{
			*pStrDS = vsValues[ii];
		}
		
	}

	if (!bSecurity) 
	{
		if ( bHasPW )
			return false;
		return true;
	}
	return false;
}
///Sophy 1/12/2011 ORG-2000 SQL_EDIT_ADO_QUERY_ALLOW_LABTALK_VARIABLE_SUPPORT
//bool	load_query_from_worksheet(const Worksheet& wks, string& strConnStr, string& strSQL, DWORD& dwOptions)
bool	load_query_from_worksheet(const Worksheet& wks, string& strConnStr, string& strSQL, DWORD& dwOptions, ADOQUERYOPTION* pExtOpt)
///end SQL_EDIT_ADO_QUERY_ALLOW_LABTALK_VARIABLE_SUPPORT
{
	dwOptions = DEFAULT_DB_LT_OPTIONS;//----- CPY 3/9/11 ORG-2000-P2 DEFAULT_SHOULD_SUBSTITUDE_INSIDE_QUOTE

	if ( !wks.IsValid() )
		return FALSE;

	vector<byte> vb;
	if(!wks.GetMemory(STR_ADO, vb))
		return false;
	
	Tree tr;
	if(!tr.XML.SetBytes(vb))
		return false;

	TreeNode trConn = tr.GetNode(STR_QUERY_CONN);
	if( trConn )
	{
		strConnStr = trConn.strVal;
	}
	
	TreeNode trSQL = tr.GetNode(STR_QUERY_SQL);
	if( trSQL )
	{
		strSQL = trSQL.strVal;
	}
	
	TreeNode trOptions = tr.GetNode(STR_QUERY_OPTIONS);
	if ( trOptions )
	{
		dwOptions = trOptions.nVal;
	}
	TreeNode trMode = tr.GetNode("UseODBC");
	if ( trMode )
	{
		dwOptions |= trMode.nVal ? OPTION_BY_ODBC : 0;
	}
	///Sophy 1/12/2011 ORG-2000 SQL_EDIT_ADO_QUERY_ALLOW_LABTALK_VARIABLE_SUPPORT
	TreeNode trBeforeScript = tr.GetNode(STR_QUERY_BEFORESCRIPT);
	if ( trBeforeScript && NULL != pExtOpt )
	{
		pExtOpt->strBeforeScript = trBeforeScript.strVal;
	}
	///end SQL_EDIT_ADO_QUERY_ALLOW_LABTALK_VARIABLE_SUPPORT
	return true;
}
///Sophy 1/12/2011 ORG-2000 SQL_EDIT_ADO_QUERY_ALLOW_LABTALK_VARIABLE_SUPPORT
//bool	save_query_to_worksheet(Worksheet& wks, LPCSTR lpcszConnStr, LPCSTR lpcszSQL, DWORD dwOptions)
bool	save_query_to_worksheet(Worksheet& wks, LPCSTR lpcszConnStr, LPCSTR lpcszSQL, DWORD dwOptions, ADOQUERYOPTION* pExtOpt)
///end SQL_EDIT_ADO_QUERY_ALLOW_LABTALK_VARIABLE_SUPPORT
{
	///Sophy 12/20/2010 ORG-1179-P16 CLEAR_SAVED_QUERY_STRING_WHEN_CHANGE_CONNECTION
	//if ( !wks || strlen(lpcszConnStr) == 0 || strlen(lpcszSQL) == 0 )
	if ( !wks || strlen(lpcszConnStr) == 0 )	
	///end CLEAR_SAVED_QUERY_STRING_WHEN_CHANGE_CONNECTION
		return false;
	Tree tr;
	tr.AddTextNode(lpcszConnStr, STR_QUERY_CONN);
	tr.AddTextNode(lpcszSQL, STR_QUERY_SQL);
	tr.AddNumericNode(dwOptions, STR_QUERY_OPTIONS);
	///Sophy 1/12/2011 ORG-2000 SQL_EDIT_ADO_QUERY_ALLOW_LABTALK_VARIABLE_SUPPORT
	if ( NULL != pExtOpt )
	{
		TreeNode trBeforeScript = tr.AddTextNode(pExtOpt->strBeforeScript, STR_QUERY_BEFORESCRIPT);
	}
	///end SQL_EDIT_ADO_QUERY_ALLOW_LABTALK_VARIABLE_SUPPORT
	string strXML = tr.XML;
	vector<byte> vb;
	if(!strXML.GetBytes(vb) || !wks.SetMemory(STR_ADO, vb))
	{
		return error_report("db_wks_set_query failed to save SQL info into wks");
	}

	return true;
}

enum {
	DB_PROVIDER_UNKNOWN,
	DB_PROVIDER_ORACLE,
	DB_PROVIDER_SQL_SERVER,
	DB_PROVIDER_MYSQL,
	DB_PROVIDER_TOTAL
};

int	get_provider( LPCSTR lpcstrConn )
{
	string strConn = lpcstrConn;
	if ( strConn.Match( "*Oracle*", false ) )
		return DB_PROVIDER_ORACLE;
	if ( strConn.Match( "*MySQL*", false ) )
		return DB_PROVIDER_MYSQL;

	if( strConn.Match( "*sqloledb*", false ) 
		|| strConn.Match( "*SQL Server*", false ) )
		return DB_PROVIDER_SQL_SERVER;

	return DB_PROVIDER_UNKNOWN;
}

static	bool _make_preview_str( string &strSQL, int nPreviewLines, int nProviderType )
{
	bool bRet = true;
	switch( nProviderType )
	{
	case DB_PROVIDER_ORACLE:
		string strTemp;
		strSQL.TrimRight(" ;");
		strTemp.Format(" WHERE ROWNUM <= %d", nPreviewLines);
		strSQL = "SELECT * FROM (" + strSQL + ") " + strTemp;
		break;
	case DB_PROVIDER_MYSQL:

		StringArray saTokens;
		///Sophy 3/8/2011 ORG-2395-P1 IMPROVE_OKUTIL_GET_TOKENS_SUPPORTING_IGNORE_SINGLE_QUOTES
		//okutil_get_tokens(strSQL, &saTokens, 0, NULL);
		okutil_get_tokens(strSQL, &saTokens, 0, NULL, '"', GT_CHECK_SINGLE_QUOTES);
		///end IMPROVE_OKUTIL_GET_TOKENS_SUPPORTING_IGNORE_SINGLE_QUOTES
		int nFromPos = saTokens.Find("from");
		int nLimitPos = saTokens.Find("Limit", nFromPos > 0 ? nFromPos : 0);
		if ( nLimitPos > nFromPos && saTokens.GetSize() > nLimitPos + 1 ) //already exist 'LIMIT' key word
		{
			int nRows = atol(saTokens[nLimitPos + 1]);
			if ( nRows < nPreviewLines )
				nPreviewLines = nRows;
			saTokens[nLimitPos + 1] = nPreviewLines;
			string strTableName = saTokens[nFromPos + 1];
			okutil_check_add_quotes(&strTableName, FALSE);
			saTokens[nFromPos + 1] = strTableName;
			strSQL.SetTokens(saTokens, ' ');
		}
		else
		{
			strSQL.TrimRight(' ;');
			strSQL = strSQL + " Limit " + nPreviewLines;
		}
		
		break;
	case DB_PROVIDER_SQL_SERVER:
		StringArray saTokens;
		///Sophy 3/8/2011 ORG-2395-P1 IMPROVE_OKUTIL_GET_TOKENS_SUPPORTING_IGNORE_SINGLE_QUOTES
		//okutil_get_tokens(strSQL, &saTokens, 0, NULL);
		okutil_get_tokens(strSQL, &saTokens, 0, NULL, '"', GT_CHECK_SINGLE_QUOTES);
		///end IMPROVE_OKUTIL_GET_TOKENS_SUPPORTING_IGNORE_SINGLE_QUOTES
		if ( saTokens.GetSize() > 0 && saTokens[0].CompareNoCase("SELECT") == 0 )
		{
			string strTemp;
			strTemp.Format(" Top %d", nPreviewLines);
			int nFromPos = saTokens.Find("From");
			if ( nFromPos > 0 && nFromPos < saTokens.GetSize() - 1 )
			{
				string strTableName = saTokens[nFromPos + 1];
				okutil_check_add_quotes(&strTableName, FALSE);
				saTokens[nFromPos + 1] = strTableName;
			}
			
			if ( saTokens[1].CompareNoCase("ALL") == 0 || saTokens[1].CompareNoCase("DISTINCT") == 0)
			{
				saTokens[1]+= strTemp;
			}
			else if ( saTokens[1].CompareNoCase("Top") == 0 && saTokens.GetSize() > 2 )
			{
				int nLines = atol(saTokens[2]);
				if (nLines < nPreviewLines)
					nPreviewLines = nLines;
				saTokens[2] = nPreviewLines;
			}
			else
			{
				saTokens[0]+= strTemp;
			}
			strSQL.SetTokens(saTokens, ' ');
		}
		break;
	default:
		bRet = false;
		break;
	}
	return bRet;
}

static bool _open_recordset(Object& ors, Object& oConn, LPCSTR lpcstrQuery, int nCursorType = adOpenForwardOnly)
{
	SetStatusBarText("DB:openning recordset...");
	try
	{
		ors.Open(lpcstrQuery, oConn, nCursorType);	
	}
	catch(int nError)
	{
		SetStatusBarText("DB: fail to open recordset!");//CPY 8/13/2012 ORG-6485-P1 SHOW_ERROR_MESSAGE_WHEN_DBIMPORT_ERROR_OCCUR
		return false;
	}

	return true;
}

bool add_password_to_connection_str(LPCSTR lpcszConnStr, LPCSTR lpcszUser, LPCSTR lpcszPwd, string& strConnStr)
{
	string strConn = lpcszConnStr;
	strConn.TrimLeft(); strConn.TrimRight();
	vector<string> vsKeys, vsValues;
	int nRet = ocu_separate_key_values(strConn, &vsKeys, &vsValues);
	///Sophy 3/15/2011 ORG-2000 MORE_CLEAN_CODE_FOR_DATABASEIMPORTDLG this code duplicate the key vector and make no sense
	//vsKeysLower = vsKeys;
	//for(int ii = 0; ii < vsKeys.GetSize(); ii++) 
		//vsKeysLower[ii].MakeLower();
	///end MORE_CLEAN_CODE_FOR_DATABASEIMPORTDLG
	
	int nn = vsValues.Find("user id", 0, false, true);
	if(nn >= 0)
		vsValues[nn] = lpcszUser;
	else
	{
		vsKeys.Add("User ID");
		vsValues.Add(lpcszUser);
	}

	nn = vsValues.Find("password", 0, false, true);
	
	if(nn >= 0)
		vsValues[nn] = lpcszPwd;
	else
	{
		vsKeys.Add("Password");
		vsValues.Add(lpcszPwd);
	}
	///Sophy 12/1/2010 ORG-1493-P3 EMPTY_KEY_NAME_VALUE_CAUSE_COM_ERROR_IN_WIN7_VISTA
	//I got COM Error : "format of the initialization string does not conform to the ole db specification" in Windows 7, but not in XP
	//in case open create in new SQL Editor, save and open in Query Builder in Win7 | Vista.
	nn = vsKeys.Find("");
	while ( nn >= 0 )
	{
		vsKeys.RemoveAt(nn);
		vsValues.RemoveAt(nn);
		nn = vsKeys.Find("");
	}
	///end EMPTY_KEY_NAME_VALUE_CAUSE_COM_ERROR_IN_WIN7_VISTA
	strConnStr.Empty();
	ocu_make_key_values_str(&strConnStr, &vsKeys, &vsValues);

	return true;
}

static bool _check_get_password(HWND hWndParent, string& strDS, string& strUser, string& strConn, LPCSTR lpcszDlgTitle, bool bAllowSavePassword = false ) //= false
{
	bool bSavePwdBackToWks = true;
	if ( check_is_need_login_prompt(strConn, &strUser, &strDS) )
	{
		GETN_TREE(tr);
		GETN_AUTO_SAVE_BRANCH_OPEN(1) /// Iris 7/04/2012 ORG-6033-P1 TO_PREVENT_GETN_AUTO_SAVE_BRANCH_OPEN_STATUS_TO_REG
		GETN_STR(user,_L("User Name"), strUser) GETN_READ_ONLY
		GETN_PASSWORD(pwd, _L("Password"), "")
		if(bAllowSavePassword)
		{
			GETN_CHECK(save,_L("Save Password"), 0)
		}
	
		string strInfo = _L("Data Source:") + " " + strDS;
	
		if( GetNBox(tr, lpcszDlgTitle, strInfo, NULL, NULL, hWndParent) )
		{
			string strNewConnStr;
			add_password_to_connection_str(strConn, tr.user.strVal, tr.pwd.strVal, strNewConnStr);
			if(bAllowSavePassword)
				bSavePwdBackToWks = tr.save.nVal;
			strConn = strNewConnStr;
		}
		else
			return false;
	}

	return bSavePwdBackToWks;
}

static int _get_cursor_type()
{
	double	dCursorType;
	LT_get_var("@ADOC", &dCursorType);
	int		nCursorType = dCursorType;
	
	return nCursorType;
}

static bool _check_recordset_for_preview(Object &ors, Object &oConn, LPCTSTR lpcstrConn, string &strSQL, int nPreviewLines, int nCursorType)
{
	string strSQLOld = strSQL;	
	int nProviderType = get_provider(lpcstrConn);

	for ( int ii = DB_PROVIDER_ORACLE; ii < DB_PROVIDER_TOTAL; ++ii )
	{
		_make_preview_str(strSQL, nPreviewLines, nProviderType == DB_PROVIDER_UNKNOWN ? ii : nProviderType);
		if( _open_recordset(ors, oConn, strSQL, nCursorType) )
		{
			return true;
		}
		strSQL = strSQLOld;
	}

	return false;
}

static bool _check_recordset(Object &ors, Object &oConn, LPCTSTR lpcstrConn, string &strSQL, int nPreviewLines)
{
	string strConn = lpcstrConn;
	_check_parse_sql_statement(strSQL);
	int nCursorType = _get_cursor_type();
	if ( strConn.Match("Provider=OraOLEDB.Oracle*", true) )
			nCursorType = adOpenKeyset;

	if ( nPreviewLines > 0 )
		return _check_recordset_for_preview(ors, oConn, lpcstrConn, strSQL, nPreviewLines, nCursorType);

	return _open_recordset(ors, oConn, strSQL, nCursorType);
}

static string _get_str_right(LPCTSTR lpcszOld, int nRightBegin)
{
	string strOld = lpcszOld;
	strOld.TrimLeft();
	string strRight = strOld.Mid(nRightBegin);
	strRight.TrimLeft();
	strRight.TrimRight();
	return strRight;
}

bool	make_ODBC_connection_from_ADO_connection(const string& strADOConnStr, string& strODBCConnStr)
{
	if ( strADOConnStr.Find(STR_ODBC_TAG) >= 0 )
	{
		vector<string> vsTokens;
		strADOConnStr.GetTokens(vsTokens, ';');
		vector<string> vsConn;

		//int nPos = vsTokens.Find("Data Source=", 0, false, false);
		int nPos = vsTokens.Find(STR_CONN_DATA_SOURCE, 0, false, false);
		if ( nPos >= 0 )
		{
			string str = _get_str_right(vsTokens[nPos], lstrlen(STR_CONN_DATA_SOURCE));
			vsConn.Add(STR_CONN_DSN + str);
		}
		
		nPos = vsTokens.Find(STR_CONN_USER_ID, 0, false, false);
		if ( nPos >= 0 )
		{
			string str = _get_str_right(vsTokens[nPos], lstrlen(STR_CONN_USER_ID));
			vsConn.Add(STR_CONN_UID + str);
		}

		nPos = vsTokens.Find(STR_PASSWORD, 0, false, false);
		if ( nPos >= 0 )
		{
			string str = _get_str_right(vsTokens[nPos], lstrlen(STR_PASSWORD));
			vsConn.Add(STR_PWD + str);
		}
		strODBCConnStr.SetTokens(vsConn, ';');
		return true;
	}
	return false;
}

static	BOOL	_db_odbc_wks_import(ODWP& dwODBC, Worksheet& wks, int nColBegin, DWORD dwOptions)
{
	int nNumFields = oodbc_get_columns_count(dwODBC);
	if ( nNumFields < 0 )
		return FALSE;
	if ( wks.GetNumCols() <= nColBegin + nNumFields )
		wks.SetSize(-1, nColBegin + nNumFields);
	
	int nErr;
	for ( int iField = 0; iField < nNumFields; iField++ )
	{
		Column colObj(wks, iField + nColBegin);
		
		int nSQLCType = oodbc_get_column_datatype(dwODBC, iField, &nErr);
		if ( nErr < 0 )
			return FALSE;
		
		switch(nSQLCType)
		{
		case SQL_C_CHAR:
		case SQL_C_GUID:
		case SQL_C_BINARY:
			///Sophy 3/4/2010 FAIL_TO_SHOW_FULL_CONTEXT_WHEN_TEXT_IS_LONG should keep Text&Numeric to allow show more characters.
			//colObj.SetInternalData(FSI_TEXT);
			colObj.SetFormat(OKCOLTYPE_TEXT_NUMERIC);
			///end FAIL_TO_SHOW_FULL_CONTEXT_WHEN_TEXT_IS_LONG
			break;
			
		case SQL_C_DATE:
		case SQL_C_TIMESTAMP:
			colObj.SetInternalData(FSI_DOUBLE);
			colObj.SetFormat(OKCOLTYPE_DATE);
			colObj.SetSubFormat(0); //yyyy-mm-dd
			break;
			
		case SQL_C_LONG:
			colObj.SetFormat(OKCOLTYPE_NUMERIC);
			colObj.SetInternalData(FSI_LONG);
			break;
			
		case SQL_C_DOUBLE:
			colObj.SetFormat(OKCOLTYPE_NUMERIC);
			colObj.SetInternalData(FSI_DOUBLE);
			break;
			
		default:
			ASSERT(FALSE);
			return FALSE;
		}
		if ( O_QUERY_BOOL(dwOptions, OPTION_OVERWRITE_LONGNAME) )
		{
			string strFieldName = oodbc_get_column_name(dwODBC, iField, &nErr);
			colObj.SetLongName(strFieldName);
		}
		string strRangeStr;
		colObj.GetRangeString(strRangeStr);
		nErr = oodbc_get_column_data(dwODBC, strRangeStr, iField);
		if ( nErr != 0 )
			return FALSE;
	}
	
	return TRUE;
}
//----- CPY 3/14/2011 ORG-2000 MORE_CLEAN_CODE_FOR_DATABASEIMPORTDLG
int process_before_query_script(const string& strBeforeScript, string& strSQL, DWORD dwOptions)
{
	LTStackHelper ltScope;
	if ( !strBeforeScript.IsEmpty() )
	{
		BOOL bRet = LT_execute(strBeforeScript);
		if ( !bRet )
		{
			error_report("Fail to execute Before Import Script!");
			return ADO_ERROR_INVALID_BEFORE_SCRIPT;
		}
	}
	USHORT usCtrl = O_QUERY_BOOL(dwOptions, OPTION_LTPARSE_IGNORE_QUOTE) ? ARGC_NO_QUOTE_SUB : 0;
	okutil_arg_copy(&strSQL, NULL, usCtrl);
	return 0;
}
//----- end MORE_CLEAN_CODE_FOR_DATABASEIMPORTDLG
int import_to_worksheet( Worksheet& wks, int nStartColIndex /*= 0*/, int nPreviewLines /*= 0*/, bool bLoginPrompt /*= true*/, HWND hDlg /*= NULL */ )
{
	if ( !wks )
		return ADO_ERROR_INVALID_WORKSHEET;
	
	waitCursor www;
	
	string strConn, strSQL;
	DWORD dwOptions = 0;
	ADOQUERYOPTION extOptions;
	if ( !load_query_from_worksheet(wks, strConn, strSQL, dwOptions, &extOptions) || strSQL.IsEmpty() )
		return ADO_ERR_GET_SQL_STR;
	///Sophy 1/12/2011 ORG-2000 SQL_EDIT_ADO_QUERY_ALLOW_LABTALK_VARIABLE_SUPPORT
	string strOriginalSQL = strSQL;
	string strOriginalConn = strConn;
	if ( O_QUERY_BOOL(dwOptions, OPTION_LABTALK_SUPPORT) )
	{
		LTStackHelper ltScope;
		string strBeforeScript = extOptions.strBeforeScript;
		//----- CPY 3/14/2011 ORG-2000 MORE_CLEAN_CODE_FOR_DATABASEIMPORTDLG
		/*
		if ( !strBeforeScript.IsEmpty() )
		{
			BOOL bRet = LT_execute(strBeforeScript);
			if ( !bRet )
			{
				error_report("Fail to execute Before Import Script!");
				return ADO_ERROR_INVALID_BEFORE_SCRIPT;
			}
		}
		///Sophy 2/17/2011 ORG-2000-P6 ARG_COPY_NEED_WAY_TO_SKIP_SUB_STRING_WITHIN_SINGLE_QUOTES
		//okutil_arg_copy(&strSQL);
		///Sophy 2/24/2011 ORG-2000-S2 OPTION_FOR_CTRL_PARSE_LTVAR_WITHIN_SINGLE_QUOTES
		//okutil_arg_copy(&strSQL, NULL, ARGC_NO_QUOTE_SUB);
		USHORT usCtrl = O_QUERY_BOOL(dwOptions, OPTION_LTPARSE_IGNORE_QUOTE) ? ARGC_NO_QUOTE_SUB : 0;
		okutil_arg_copy(&strSQL, NULL, usCtrl);
		///end OPTION_FOR_CTRL_PARSE_LTVAR_WITHIN_SINGLE_QUOTES
		///end ARG_COPY_NEED_WAY_TO_SKIP_SUB_STRING_WITHIN_SINGLE_QUOTES
		*/
		int nErr = process_before_query_script(strBeforeScript, strSQL, dwOptions);
		if(nErr != 0)
			return nErr;
		//---- end MORE_CLEAN_CODE_FOR_DATABASEIMPORTDLG
	}
	BOOL	bSaveQueryToWks= FALSE;
	///end SQL_EDIT_ADO_QUERY_ALLOW_LABTALK_VARIABLE_SUPPORT
	string strConn0 = strConn;
	bool bSavePwdBackToWks = false;
	if ( bLoginPrompt )
	{
		string strUser, strDS;
		string strTitle = _L("Importing...");
		if ( nPreviewLines > 0 )
			strTitle = _L("Preview...");	
		bSavePwdBackToWks = _check_get_password(hDlg, strDS, strUser, strConn, strTitle );
		if ( !bSavePwdBackToWks )
		{
			return ADO_ERROR_OPEN_CONN;
		}
	}

	if ( O_QUERY_BOOL(dwOptions, OPTION_BY_ODBC) == FALSE || nPreviewLines > 0 ) //ADO import
	{
		Object	oConn;
		oConn = CreateObject("ADODB.Connection");
		if(!oConn)
			return ADO_ERR_CREATE_OBJ;
		
		Object		ors;
		ors = CreateObject("ADODB.Recordset");
		if(!ors)
			return ADO_ERR_CREATE_OBJ;
		
			
		try
		{
			SetStatusBarText( _L( "DB:opening connection...") );
			oConn.Open(strConn);
		}
		catch(int nError)
		{
			SetStatusBarText( _L( "DB: fail to open connection!") );//CPY 8/13/2012 ORG-6485-P1 SHOW_ERROR_MESSAGE_WHEN_DBIMPORT_ERROR_OCCUR
			return ADO_ERROR_OPEN_CONN;
		}
		///Sophy 11/1/2010 ORG-1336 ADO_IMPORT_WITH_SQLITE_TEXT_DATA_MAKE_GET_RECORDCOUNT_INFINITE_LOOP
		ors.CursorType = adOpenKeyset;
		ors.CursorLocation = adUseClient;
		///end ADO_IMPORT_WITH_SQLITE_TEXT_DATA_MAKE_GET_RECORDCOUNT_INFINITE_LOOP
		if( !_check_recordset(ors, oConn, strConn, strSQL, nPreviewLines) )
			return ADO_ERROR_OPEN_RECORDSET;
	
		SetStatusBarText("DB:starting to import recordset...");
		//SetStatusBarText("");CPY 8/13/2012 ORG-6485-P1 SHOW_ERROR_MESSAGE_WHEN_DBIMPORT_ERROR_OCCUR, moved this to later, after success
	
		int			nErr = 0;
		///Sophy 11/10/2010 ORG-1179-P5 NEW_ADO_DLG_OPTION_TO_FORCE_UPDATE_COLUMN_LONGNAME
		int nOptions = LAYWKGETRECORDSET_SET_COLUMN_LABEL | LAYWKGETRECORDSET_BY_COLUMN_INDEX | LAYWKGETRECORDSET_CLEAR_WKS;
		if ( O_QUERY_BOOL(dwOptions, OPTION_OVERWRITE_LONGNAME) )
			nOptions |= LAYWKGETRECORDSET_OVERWRITE_LONGNAME;
		///end NEW_ADO_DLG_OPTION_TO_FORCE_UPDATE_COLUMN_LONGNAME
		///------ Folger 07/04/2012 ORG-6101-P1 WKS_IMPORT_DATA_SHOULD_CLEAR_HIDDEN_STATUS
		check_reset_hidden_rows_before_PutRecordset(wks, 0, nStartColIndex);
		///------ End WKS_IMPORT_DATA_SHOULD_CLEAR_HIDDEN_STATUS
		BOOL		bRet = wks.PutRecordset(ors, 0, -1, nStartColIndex, nOptions, &nErr);
		if (bRet)
		{
			try 
			{
		    	ors.Close();
			}
			catch(int nError)
			{
				return ADO_ERROR_CLOSE_RECORDSET;
			}
	
			try 
			{
		    	oConn.Close();
			}
			catch(int nError)
			{
				return ADO_ERROR_CLOSE_CONN;
			}
	
			bool bImport = nPreviewLines == 0 ? true : false;
			if( bSavePwdBackToWks || bImport )
			{
				if(!bSavePwdBackToWks)
					strConn = strOriginalConn;
				bSaveQueryToWks = TRUE;
			}
		}
		else
		{
			if ( PUTRSET_ERR_EMPTY_RECORDSET == nErr )
			{
				return ADO_ERROR_EMPTY_RECORDSET;
			}
		}
	}
	else //ODBC import
	{
//#ifdef	_DEBUG
		//int nStart = GetTickCount();
//#endif	//_DEBUG
		ODWP dwODBCObjPtr;
		string strODBCConnStr;
		if ( make_ODBC_connection_from_ADO_connection(strConn0, strODBCConnStr) )
		{
			dwODBCObjPtr = oodbc_connect_ex(strODBCConnStr, hDlg);
			if ( dwODBCObjPtr == 0 )
				return ADO_ERROR_CONN_ODBC_FAIL;
		}
		else
			return ADO_ERROR_INVALID_ODBC_DSN;
		
		_check_parse_sql_statement(strSQL); 
		
		if ( !oodbc_exec_select(dwODBCObjPtr, strSQL) )
			return ADO_ERROR_OPEN_RECORDSET;
		
		if ( _db_odbc_wks_import(dwODBCObjPtr, wks, nStartColIndex, dwOptions) )
		{
			if ( !bSavePwdBackToWks )
				strConn = strOriginalConn;
			bSaveQueryToWks = TRUE;
		}
		
		oodbc_disconnect(dwODBCObjPtr);
//#ifdef	_DEBUG
		//int nEnd = GetTickCount();
		//printf("Connect ODBC and execute SQL statement and read data cause %ld(ms)\n", nEnd - nStart);
//#endif	//_DEBUG
	}
	SetStatusBarText("");//---CPY 8/13/2012 ORG-6485-P1 SHOW_ERROR_MESSAGE_WHEN_DBIMPORT_ERROR_OCCUR
	if ( bSaveQueryToWks )
	{
		save_query_to_worksheet(wks, strConn, strOriginalSQL, dwOptions, &extOptions);
		if ( O_QUERY_BOOL(dwOptions, OPTION_AUTORESIZE_WORKSHEET) )
		{
			autosize_rowcol(wks, 1.5, -1, -1, -1, AS_NOHEIGHT|AS_INVALIDATE);;
		}
		return ADO_ERROR_NONE;
	}
	
	if ( nPreviewLines > 0 )
		return ADO_ERROR_NONE;
	
	return FAILED_TO_PUT_RECORD_TO_WKS;	
}

int get_file_type(LPCTSTR lpcszFileName)
{
	string strFileName = lpcszFileName;
	string strExt = strFileName.Mid(strFileName.ReverseFind('.')+1);
	if( strExt.CompareNoCase(STR_ODQ) == 0 )
	{
		return ADO_ODQ_FILE;
	}
	else if( strExt.CompareNoCase(STR_ODS) == 0 )
	{
		return ADO_ODS_FILE;
	}

	ASSERT( FALSE );
	return UNKNOWN_FILE;
}

bool hide_value_by_key(LPCTSTR lpcszOldStrConn , LPCTSTR lpcszKey, string &strConn)
{
	strConn = lpcszOldStrConn;
	int nPos = strConn.Find(lpcszKey);
	if( nPos >= 0 )
	{
		nPos += strlen(lpcszKey);
		int nPosEnd = strConn.Find(';', nPos);
		if( nPosEnd == -1 )
			nPosEnd = strConn.GetLength();

		strConn.Delete(nPos, nPosEnd - nPos);
		strConn.Insert(nPos, "***");

		return true;
	}
	return false;
}
///Sophy 10/19/2010 SUPPORT_SORT_FIELDS_OF_TABLE_VIEW_BY_ORDINAL_POSITION
//this code maybe need to be moved to tree_utils.h for general use.
static	bool	_sort_children_by_int_attribute(TreeNode& trTable, LPCSTR lpcszAttributeName, BOOL bAscending = TRUE)
{
	if ( !trTable || trTable.Children.Count() <= 1 || strlen(lpcszAttributeName) == 0 )
		return false; //not need to sort
	
	TreeNode trTheField = trTable.FirstNode;
	while(trTheField)
	{
		TreeNode trField = trTheField;
		TreeNode trOtherField = trTheField.NextNode;
		while ( trOtherField )
		{
			int nThisAttribute = 0, nThatAttribute = 0;
			if ( trField.GetAttribute(lpcszAttributeName, nThisAttribute) && trOtherField.GetAttribute(lpcszAttributeName, nThatAttribute) )
			{
				if ( (bAscending && nThisAttribute > nThatAttribute) || (!bAscending && nThisAttribute < nThatAttribute) )
				{
					TreeNode trThisClone = trField.Clone(TRUE);
					trField.Replace(trOtherField);
					trOtherField.Replace(trThisClone);
					trTheField = trField; //this important to keep the "Current" node position
				}
			}
			trOtherField = trOtherField.NextNode;
		}
		trTheField = trTheField.NextNode;
	}
	return true;
}
bool	sort_fields_by_position(TreeNode& trTable)
{
	return _sort_children_by_int_attribute(trTable, STR_ORDINAL_POSITION, TRUE);
}
///end SUPPORT_SORT_FIELDS_OF_TABLE_VIEW_BY_ORDINAL_POSITION

//---- CPY 1/7/2011 ORG-1915-P2 ALLOW_COL_FORMULA_IN_DB_IMPORT
/*
///Sophy 12/3/2010 ORG-1647-P1 SMART_DETECT_TARGET_WORKSHEET_FOR_DATABASE_IMPORT
bool	is_worksheet_good_for_database_import(Worksheet& wks)
{
	///Sophy 1/6/2011 ORG-1915 CENTRALIZE_CODE_ON_DETECT_WRITABLE_WORKSHEET
	//vector<uint> vnIDs;
	//if ( !wks.IsValid() 
		//|| (wks.GetSystemParam(0) & WP_SHEET_HIERARCHY) 
		//|| (wks.FindIncomingOperations(vnIDs) > 0) 
		//|| (wks.FindOutgoingOperations(vnIDs) > 0) )
	//{
		//return false;
	//}
	//return true;
	return (wks.IsValid() && !wks.IsWriteProtected());
	///end CENTRALIZE_CODE_ON_DETECT_WRITABLE_WORKSHEET
}
///end SMART_DETECT_TARGET_WORKSHEET_FOR_DATABASE_IMPORT
*/
bool	is_worksheet_good_for_database_import(Worksheet& wks)
{
	return wks.IsValid() && !(wks.GetSystemParam(GLI_PCD_BITS) & WP_SHEET_HIERARCHY);
}
//---- end ALLOW_COL_FORMULA_IN_DB_IMPORT

///------ Folger 07/04/2012 ORG-6101-P1 WKS_IMPORT_DATA_SHOULD_CLEAR_HIDDEN_STATUS
void check_reset_hidden_rows_before_PutRecordset(Worksheet& wks, int nRowBegin/* = 0*/,	int nColBegin/* = 0*/)
{
	int nNumRows = wks.GetNumRows();
	int nNumCols = wks.GetNumCols();

	if ( nRowBegin < nNumRows && nColBegin < nNumCols )
	{
		check_reset_hidden_rows(wks);
	}
}
///------ End WKS_IMPORT_DATA_SHOULD_CLEAR_HIDDEN_STATUS

///Sophy 8/13/2012 ORG-6485-P1 SHOW_ERROR_MESSAGE_WHEN_DBIMPORT_ERROR_OCCUR
int	db_cvt_err_code(int nInteralCode)
{
	int nErr = CER_NO_ERROR;
	switch(nInteralCode)
	{
	case ADO_ERR_CREATE_OBJ:
		nErr = OERROR_ADO_CREATE_COM_OBJ;
		break;
	case ADO_ERR_GET_SQL_STR:
		nErr = OERROR_ADO_NO_SQL_TEXT;
		break;
	case ADO_ERROR_NONE:
		nErr = CER_NO_ERROR;
		break;
	case ADO_ERROR_CONN_STR_CHANGED:
		nErr = OERROR_ADO_UPDATE_CONN_TEXT;
		break;
	case ADO_ERROR_CLOSE_CONN:
		nErr = OERROR_ADO_CLOSE_CONN;
		break;
	case ADO_ERROR_CLOSE_RECORDSET:
		nErr = OERROR_ADO_CLOSE_RECORDSET;
		break;
	case ADO_ERROR_OPEN_CONN:
		nErr = OERROR_ADO_OPEN_CONN;
		break;
	case ADO_ERROR_OPEN_RECORDSET:
		nErr = OERROR_ADO_OPEN_RECORDSET;
		break;
	case ADO_ERROR_RESYNC_RECORDSET:
		nErr = OERROR_ADO_RESYNC_RECORDSET;
		break;
	case ADO_ERROR_RECORDSET_IS_NOT_OPEN:
		nErr = OERROR_ADO_RECORDSET_CLOSED;
		break;
	case INVALID_WKS_DB_COMMAND:
		nErr = CER_UNKNOWN_ERROR;
		break;
	case FAILED_TO_PUT_RECORD_TO_WKS:
		nErr = OERROR_ADO_PUT_RECORDSET_TO_WKS;
		break;
	case ADO_ERROR_EMPTY_RECORDSET:
		nErr = OERROR_ADO_EMPTY_RECORDSET;
		break;
	case ADO_ERROR_CONN_ODBC_FAIL:
		nErr = OERROR_ADO_CREATE_ODBC_CONN;
		break;
	case ADO_ERROR_INVALID_ODBC_DSN:
		nErr = OERROR_ADO_CREATE_ODBC_CONN;
		break;
	case ADO_ERROR_INVALID_WORKSHEET:
		nErr = OERROR_ADO_INVALID_WKS;
		break;
	case ADO_ERROR_INVALID_BEFORE_SCRIPT:
		nErr = OERROR_ADO_INVALID_LT_BEFORESCRIPT;
		break;
	default:
		ASSERT(false);
		nErr = CER_UNKNOWN_ERROR;
		break;
	}
	return nErr;
}
///end SHOW_ERROR_MESSAGE_WHEN_DBIMPORT_ERROR_OCCUR

///Sophy 8/16/2012 ORG-6485-P3 TRY_GET_MORE_DETAILS_INFO_WHEN_CONNECT_FAIL
bool	check_get_last_error(Object& orsconn, string& strErrMsg)
{
	try
	{
		Object oerrs = orsconn.Errors;
		int nCount = oerrs.Count;
		if ( nCount > 0 )
		{
			Object oerr = oerrs.Item(nCount - 1);
			strErrMsg = oerr.Description;
			strErrMsg += "(SQLState = " + oerr.SQLState + ")";
		}
		else
		{
			return false; //no error
		}
	}
	catch(int nErr)
	{
		strErrMsg.Empty();
		return false;
	}
	return !strErrMsg.IsEmpty();
}
///end TRY_GET_MORE_DETAILS_INFO_WHEN_CONNECT_FAIL