/*-----------------------------------------------------------------------------*
 * File Name: pro_mat_utils.h												   *
 * Creation: Derek 07/14/2010												   *
 * Purpose: general utility functions for matrix calculation              	   *
 * Copyright (c) OriginLab Corp.2010										   *
 * All Rights Reserved														   *
 * 																			   *
 * Modification Log:														   *
 * Derek 07/14/2010 2D_FFT_FILTERING                    					   *
 * Derek 07/28/2010 ADD_2D_THRESHOLD_FILTER                                    *
 *-----------------------------------------------------------------------------*/

#ifndef   __PRO_MAT_UTILS_H__
#define   __PRO_MAT_UTILS_H__

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

#include <origin.h>

// Error code for the fft_filter_2D function
enum FFT_FILTER_2D_ERROR
{
	NO_ERROR = 0,
    INVALID_MATRIX = -1,
    MISMATCHED_SIZE = -2,
	FFT_ERROR = -3,
	FFT_SHIFT_ERROR = -4,
	MATRIX_DOT_MULTIPLY_ERROR = -5,
	IFFT_ERROR = -6,
	IFFT_SHIFT_ERROR = -7,
	GET_AMPLITUDE_ERROR = -8,
	INVALID_THRESHOLD_VALUE = -9, 
	OTHER_ERROR = -10,
};

/// Derek 07/14/2010 2D_FFT_FILTERING
/// Comments last updated by Derek on 07/14/2010
/**# >Matrix
	Remarks:
		This function performs 2D frequency-domain band filtering 		
	Keywords:		
	Example1:
		int fft_band_filter_2D_ex1( )
		{
			MatrixPage mpA("MBook1");
			MatrixLayer  mlA = mpA.Layers(0);
			MatrixObject moA = mlA.MatrixObjects(0);
			if( !moA )
				return -1;
			matrix &matA = moA.GetDataObject();

			MatrixPage mpB("MBook2");
			MatrixLayer  mlB = mpB.Layers(0);
			MatrixObject moB = mlB.MatrixObjects(0);
			if( !moB )
				return -1;
			matrix &matB = moB.GetDataObject();

			MatrixPage mpC;
			mpC.Create("Origin");  
			MatrixLayer  mlC = mpC.Layers(0);
			MatrixObject moC = mlC.MatrixObjects(0);
			if( !moC )
				return -1;
			matrix &matC = moC.GetDataObject();

			int nRet = fft_band_filter_2D(matA, matB, matC);
			if( !nRet )
				printf("success");
			else
				printf("failed, error code = %d", nRet);

			return 0;
		}

	Parameters:
		mi = [input] the input matrix 
		mf = [input] 2D frequency-domain filter 
		mo = [output] the filtered matrix	
	Return:
		return 0 on success and error code < 0 for failure
	SeeAlso:		
*/
int fft_band_filter_2D(const matrix& mi, const matrix& mf, matrix& mo);
/// End 2D_FFT_FILTERING


/// Derek 07/28/2010 ADD_2D_THRESHOLD_FILTER
/// Comments last updated by Derek on 07/28/2010
/**# >Matrix
	Remarks:
		This function performs 2D frequency-domain threshold filtering 		
	Keywords:		
	Example1:
		int fft_threshold_filter_2D_ex1(double fLowerThresh = 0, double fUpperThresh = 1)
		{
			MatrixPage mpA("MBook1");
			MatrixLayer  mlA = mpA.Layers(0);
			MatrixObject moA = mlA.MatrixObjects(0);
			if( !moA )
				return -1;
			matrix &matA = moA.GetDataObject();

			MatrixPage mpB("MBook2");
			MatrixLayer  mlB = mpB.Layers(0);
			MatrixObject moB = mlB.MatrixObjects(0);
			if( !moB )
				return -1;
			matrix &matB = moB.GetDataObject();

			int nRet = fft_band_filter_2D(matA, fLowerThresh, fUpperThresh, matB);
			if( !nRet )
				printf("success");
			else
				printf("failed, error code = %d", nRet);

			return 0;
		}

	Parameters:
		mi = [input] the input matrix 
		fLowerThresh = [input] the lower threshold, in range [0,1]
		fUpperThresh = [input] the upper threshold, in range [0,1]	
		mo = [output] the filtered matrix	
	Return:
		return 0 on success and error code < 0 for failure
	SeeAlso:		
*/
int fft_threshold_filter_2D(const matrix& mi, const double fLowerThresh, const double fUpperThresh, matrix& mo);
/// End ADD_2D_THRESHOLD_FILTER                                    *

////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////End of file////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

#endif	// __PRO_MAT_UTILS_H__