/*------------------------------------------------------------------------------*
 * File Name: palette_uitls.c				 									*
 * Creation: 2007-1-26															*
 * Purpose: Define page utility functions										*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>

////////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.
#include "palette_utils.h"

////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.

bool save_palette_to_file(string strFile, Worksheet& wks, int nRCol, int nGCol, int nBCol)
{
	
	Dataset dsR(wks, nRCol);
	Dataset dsG(wks, nGCol);
	Dataset dsB(wks, nBCol);
	vector<byte> vr(256), vg(256), vb(256);

	vr = dsR;
	vg = dsG;
	vb = dsB;
	if( 0 > okutil_palette_save(strFile, vr.GetSize(), vr, vg, vb))
		return false;
	return true;
}

bool read_palette_from_file(string strFile, vector& vr, vector& vg, vector& vb)
{
	vector<int> rgb;
   	if( okutil_palette_load(strFile, &rgb) < 0 )
   		return false;
   
   	int nSize = rgb.GetSize();
   	vr.SetSize(nSize);
   	vg.SetSize(nSize);
   	vb.SetSize(nSize);
    for( int i = 0; i < nSize; i++ )
	{
       vr[i] = GetRValue(rgb[i]);
       vg[i] = GetGValue(rgb[i]);
       vb[i] = GetBValue(rgb[i]);
	}
	
	return true;
}
