/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Iris 12/15/03 QA70-5711 FAIL_SETMEMORY_ON_NEWADDCOL							*
 * Iris 12/31/03 v8.0790 ADD_PCLAMPFILE_POINTER									*
 * Iris 01/06/04 v8.0794 ADD_HEADERINFO_ICON									*
 * EJP 2006-06-08 v8.0422 PLCAMP_IMPORT_NEED_RETURN_ERR							*
 * EJP 2006-06-09 v8.0425 PLCAMP_COL_TYPE_RUNTIME_ERR							*
 * Hong 11/1/06 QA-9073 ADD_XUNITS_AND_XLONGNAME_ARGS_TO_EVENSAMPLING           *
 * SY 2006-11-03 v8.0505 ADD_SCALER_OBJECT										*
 * AW 11/07/06 MORE_WORK_ON_SHOW_TIME_COL										*
 * Hong 11/9/06 TEMP_OPEN_SUPPORT_GAPFREE_MODE									*
 * Hong 11/9/06 FIX_ERROR_APPEND_TIME											*
 * Hong 11/9/06 FIX_SWEEP_HAVE_DIFFERENT_LENGTH									*
 * Hong 11/9/06 ADD_INFO_FOR_DIGITAL_WAVEFORM									*
 * Hong 11/10/06 MORE_ADD_TAG_TO_PLOT											*
 * Hong 11/13/06 FIX_MISS_CHECK_FILE_IS_VALID									*
 * Hong 11/17/06 FIX_ERROR_END_TIME_FOR_TWO_INTERVAL_DATA						*
 * Hong 12/08/06 UPDATE_TO_VERSION_2											*
 * Hong 12/09/06 READ_MATH_CHANNEL												*
 * Hong 12/11/06 FIX_TIME_ERROR_OFFSET											*
 * AW 03/12/07 8.0579 FIX_PLCAMP_CRASH_AT_FILENODE_CLEANUP						*
 * Sim 05-11-2007 CLEAR_REPEATING_HEADER_INFO									*
 * Hong 05/18/07 v8.0621 REMOVE_DUPLICATE_DIGITAL_WAVEFORM						*
 *	Hong 09/19/07 v8.0704 AVOID_SET_LONGNAEM_DUMP_WARNING_MESSAGE				*
 * AW 01/06/09 QA80-12413 ADD_HOLDING_DURATION_TIME_IN_PCLAMP					*
 *	Hong 01/15/09 FIX_PCLAMP_PLOT_FAIL_HANDLE_TIME_OFFSET_OF_HOLDING_DURATION	*
 *	Hong 03/05/09 QA80-13222 SWEEP_MODE_ALLOW_SHOW_TIME_COL_AS_75_ASKED_BY_USER	*
 *	Sim 02-04-2010 QA81-15063 MOVE_IMP_FILE_INFO_OUT_FROM_COL_USER_INFO_TREE	*
 *	Sim 02-05-2010 QA81-15063 ROLL_BACK_MOVE_COL_INFO_OUT_OF_USER_TREE			*
 *	Hong 11/17/10 ORG-1517 WATERFALL_PLOT_NEED_X0_AS_Z_AXIS						*
 *	Sophy 11/17/2011 ORG-4101-P1 DONOT_SET_EVEN_SAMPLING_WHEN_TIME_COLUMN_ADDED	*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.  
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
#include "pCLAMPFile.h"
#include <GetNBox.h>
#include <..\Originlab\fu_utils.h> ///---Sim 02-04-2010 QA81-15063 MOVE_IMP_FILE_INFO_OUT_FROM_COL_USER_INFO_TREE

#define FAIL_SETMEMORY_ON_NEWADDCOL
////////////////////////////////////////////////////////////////////////////////////
#define TREENODE_FILE		"File"

#define COL_NAME_FILE		"F"
#define COL_NAME_TIME		"Time"
#define COL_LABEL_TIME		"ms"
#define COL_NAME_SWEEP		"Ep"
#define COL_NAME_CHANNEL	"Ch"

#define	HEADERINFO_TAG		"ImportHeader"

#define IMPORT_FILENAME		"FileNames"
#define IMPORT_MODE			"ImportModes"
#define IMPORT_CHANNELNO	"ChannelNos"
#define IMPORT_SWEEPNO		"SweepNos"

#define DIGITAL_WAVEFORM_SCALE 5 ///Hong 11/9/06 ADD_INFO_FOR_DIGITAL_WAVEFORM
enum
{
	IMPORT_MODE_CHANNELS = 0, 
	IMPORT_MODE_SWEEPS
};

enum
{	
	CHANNEL_COL=0,
	SWEEP_COL,
	TIME_COL,
	STIMULUS_COL, //Hong 11/6/06 ADD_STIMULUR_OUTPUT_DATA
	MATH_COL	// Hong 12/09/06 READ_MATH_CHANNEL
};

////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.
///Iris 12/19/03 :the sturct not used now
//typedef struct tagFileInfo
//{ 
	//string 	strFileName;
  	//int 	nImportMode;
  	//int 	nChannelNo;
  	//int 	nSweepNo;
//}FileInfo;

////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.

/// EJP 2006-06-08 v8.0422 PLCAMP_IMPORT_NEED_RETURN_ERR
int pCLAMPImport();
/// end PLCAMP_IMPORT_NEED_RTURN_ERR

class pClampImport
{
public:	
	pClampImport()
	{
		m_nFileNum = 0;
		m_bUseHoldingDuration = false;		/// AW 01/06/09 QA80-12413 ADD_HOLDING_DURATION_TIME_IN_PCLAMP
		//m_fEndTime = 0; // Hong 11/17/06 FIX_ERROR_END_TIME_FOR_TWO_INTERVAL_DATA
		///Sophy 8/31/2012 ORG-6343-S1 MORE_WORK_ON_USE_32BIT_ABFFIO_IN_64BIT_ORIGIN
#ifdef	_OABFFIO64_USED_
		OABF_LoadCOMServer();	//init COM server
#endif	//_OABFFIO64_USED_
		///end MORE_WORK_ON_USE_32BIT_ABFFIO_IN_64BIT_ORIGIN
	}	
	
	pClampImport(const vector<string> vsFileNames)
	{
		SetFileName(vsFileNames);
		m_nFileNum = vsFileNames.GetSize();
		
		///Iris 12/31/03 v8.0790 ADD_PCLAMPFILE_POINTER
		m_vPClampFiles.SetSize(m_nFileNum);
		for(int ii=0; ii<m_nFileNum; ii++)
		{
			pCLAMPFile* pFile = new pCLAMPFile(vsFileNames[ii]);
			m_vPClampFiles[ii] = (ODWP)pFile;
		}
		///End ADD_PCLAMPFILE_POINTER
		//m_fEndTime = 0;// Hong 11/17/06 FIX_ERROR_END_TIME_FOR_TWO_INTERVAL_DATA
		m_bUseHoldingDuration = false;		/// AW 01/06/09 QA80-12413 ADD_HOLDING_DURATION_TIME_IN_PCLAMP
		///Sophy 8/31/2012 ORG-6343-S1 MORE_WORK_ON_USE_32BIT_ABFFIO_IN_64BIT_ORIGIN
#ifdef	_OABFFIO64_USED_
		OABF_LoadCOMServer();	//init COM server
#endif	//_OABFFIO64_USED_
		///end MORE_WORK_ON_USE_32BIT_ABFFIO_IN_64BIT_ORIGIN
	}	
	
	~pClampImport()
	{
		///Iris 12/31/03 v8.0790 ADD_PCLAMPFILE_POINTER
		//// AW 10/10/06 MORE_ON_XF_PCLAMP_HEADER_INFO
		/*
		for(int ii=0; ii<m_vPClampFiles.GetSize(); ii++)
		{
			pCLAMPFile* pFile = (pCLAMPFile*)m_vPClampFiles[ii];
			delete pFile;
		}
		*/
		CleanUp();
		//// END MORE_ON_XF_PCLAMP_HEADER_INFO
		///End ADD_PCLAMPFILE_POINTER
	}
	//Set pclamp file names
	void SetFileName(const vector<string> vsFileNames)
	{
		setTreeFromStringVector(vsFileNames, IMPORT_FILENAME);
		/// AW 09/18/06 ADD_PCLMAP_XF
		m_nFileNum = vsFileNames.GetSize();
		m_vPClampFiles.SetSize(m_nFileNum);
		for(int ii=0; ii<m_nFileNum; ii++)
		{
			pCLAMPFile* pFile = new pCLAMPFile(vsFileNames[ii]);
			m_vPClampFiles[ii] = (ODWP)pFile;
		}
		///End END

	}
	
	/// Fisher 01/07/09 QA80-12413 ADD_HOLDING_DURATION_TIME_IN_PCLAMP
	void UseHoldingDuration(BOOL bUseHoldingDuration = true)
	{
		m_bUseHoldingDuration = bUseHoldingDuration;
		for(int ii=0; ii<m_vPClampFiles.GetSize(); ii++)
		{
			pCLAMPFile* pFile = (pCLAMPFile*)m_vPClampFiles[ii];
			pFile->UseHoldingDuration(bUseHoldingDuration);
		}
	}
	/// End ADD_HOLDING_DURATION_TIME_IN_PCLAMP
	
	//Set Import mode Channel or Sweep
	void SetImportMode(const vector<int> vnImportMode)
	{
		setTreeFromIntVector(vnImportMode, IMPORT_MODE);
	}
	
	//Select the special channel to import
	void SetChannelNo(const vector<int> vnChannelNo)
	{
		setTreeFromIntVector(vnChannelNo, IMPORT_CHANNELNO);
	}
	
	//Select the special sweep to import	
	void SetSweepNo(const vector<int> vnSweepNo)
	{
		setTreeFromIntVector(vnSweepNo, IMPORT_SWEEPNO);
	}
	
	
	//// AW 10/10/06 MORE_ON_XF_PCLAMP_HEADER_INFO
	void CleanUp()
	{
		for(int ii=0; ii<m_vPClampFiles.GetSize(); ii++)
		{
			pCLAMPFile* pFile = (pCLAMPFile*)m_vPClampFiles[ii];
			delete pFile;
		}	
		m_vPClampFiles.SetSize(0);
		///Sophy 8/31/2012 ORG-6343-S1 MORE_WORK_ON_USE_32BIT_ABFFIO_IN_64BIT_ORIGIN
#ifdef	_OABFFIO64_USED_
		OABF_UnloadCOMServer();	//close COM server
#endif	//_OABFFIO64_USED_
		///end MORE_WORK_ON_USE_32BIT_ABFFIO_IN_64BIT_ORIGIN
	}
	//// END MORE_ON_XF_PCLAMP_HEADER_INFO
	//// AW 11/07/06 MORE_WORK_ON_SHOW_TIME_COL
	bool HasSecondSamepleInterval()
	{
		for(int ii=0; ii<m_vPClampFiles.GetSize(); ii++)
		{
			pCLAMPFile* pFile = (pCLAMPFile*)m_vPClampFiles[ii];
			if ( 0 != pFile->GetSecondSamepleInterval() )
				return true
		}	
		return false;
	}
	/// END MORE_WORK_ON_SHOW_TIME_COL
	/// Hong 11/17/06 FIX_ERROR_END_TIME_FOR_TWO_INTERVAL_DATA
	//float GetEndTime() {return m_fEndTime; }
	float GetEndTime(int nIndex, int nInputMode) //{return m_fEndTime; }
	{
		float fEndTime;
		vector<float> vtData;
		readTimeData(nIndex, vtData);
		int nSize = vtData.GetSize();
		fEndTime = vtData[nSize - 1];
		
		if( IMPORT_MODE_CHANNELS == nInputMode )
		{
			int nSweepNum = GetSweepNum(nIndex);
			fEndTime *= nSweepNum;
		}
		return fEndTime;
	}
	/// end FIX_ERROR_END_TIME_FOR_TWO_INTERVAL_DATA
	
	/// AW 09/18/06 ADD_PCLMAP_XF
	pCLAMPFile* GetpClampFile(int nIndex)
	{
		pCLAMPFile* pFile = NULL;
		if ( nIndex >= 0 && nIndex < m_vPClampFiles.GetSize() )
			pFile = (pCLAMPFile*)m_vPClampFiles[nIndex];		
		return pFile;
	}
	/*
	BOOL ImportPClamp(Worksheet&wks, TreeNode& trSetting, int nImportMode)
	{

		cleanWks(wks);
		int nFileIndex=0;
		
		foreach(TreeNode trFileNode in trSetting.Children )
		{
			int nChannelIndex = 0;
			
			foreach( TreeNode trChannel in trFileNode.Channels.Children )
			{
				if ( 1 == trChannel.nVal )
				{
					if(IMPORT_MODE_CHANNELS == nImportMode)
					{
						if(!readChannelToCol(nFileIndex, nChannelIndex))
							return false;	
					}
					else
					{
						int nSweepIndex = 0;
						readTimeDataToCol(nFileIndex);
						foreach( TreeNode trSweep in trFileNode.Sweeps.Children )
						{
							if ( 1 == trSweep.nVal )
							{
								if(!readSweepToCol(nFileIndex, nChannelIndex, nSweepIndex))
									return false;	
							}
							nSweepIndex++;
						}
					}
				}
				nChannelIndex++;
			}
			nFileIndex++;
		}
		return true;
	}
	*/
	///---Sim 11-09-2006 HANDLE_ERR_MESSAGE_USE_DLL
	//BOOL ImportOnepClampFile(Worksheet& wksTarget, int nFileIndex, TreeNode trFileNode, TreeNode& trInfo, int nInputMode, int timecol, int c1, string& strColPre)
	int ImportOnepClampFile(Worksheet& wksTarget, int nFileIndex, TreeNode trFileNode, TreeNode& trInfo, int nInputMode, int timecol, int c1, int c2, string& strColPre) ///---Sim 03-01-2007 QA80-9420 REIMPORT
	///---END HANDLE_ERR_MESSAGE_USE_DLL
	{
		/// Hong 11/6/06 CHECK_IF_SUPPORT_DATA_MODE
		pCLAMPFile* 	pFile;
		pFile = (pCLAMPFile*)m_vPClampFiles[nFileIndex];
		/// Hong 11/13/06 FIX_MISS_CHECK_FILE_IS_VALID
		//if(!pFile)
		if(!pFile || !pFile->IsValid())
		/// end FIX_MISS_CHECK_FILE_IS_VALID
			return IMPERR_INVALID_FILE;  ///---Sim 11-09-2006 HANDLE_ERR_MESSAGE_USE_DLL
		/// Hong 12/08/06 UPDATE_TO_VERSION_2
		// for version 2.0, we can support all data type of pclamp
		/*
		if(!pFile->IsSupportData())
			return IMPERR_UNSUPPORT_VERSION; ///---Sim 11-09-2006 HANDLE_ERR_MESSAGE_USE_DLL
		*/
		/// end UPDATE_TO_VERSION_2
		/// end CHECK_IF_SUPPORT_DATA_MODE
		m_wks = wksTarget;
		///---Sim 02-05-2007 HOLD_ON_ORIGINAL_COLUMNS_SETTING
		//m_wks.SetSize(-1, c1);
		m_nC1 = c1;
		m_nC2 = c2; ///---Sim 03-01-2007 QA80-9420 REIMPORT
		m_nNumCol = 0;  
		///---END HOLD_ON_ORIGINAL_COLUMNS_SETTING
		int nChannelIndex = 0;
		
		///// 11/08/06 AW MORE_WORK_IN_PCLAMP_TIME
		/// AW 01/06/09 QA80-12413 ADD_HOLDING_DURATION_TIME_IN_PCLAMP
		//if ( timecol )
		m_bUseHoldingDuration = trFileNode.bHoldingDuration.nVal;
		if ( timecol )
		/// END ADD_HOLDING_DURATION_TIME_IN_PCLAMP
		/// Hong 11/9/06 TEMP_OPEN_SUPPORT_GAPFREE_MODE 
		//readTimeDataToCol(0, nInputMode, pFile->GetSweepNumPerChannel());
		{
			///---Sim 11-09-2006 HANDLE_ERR_MESSAGE_USE_DLL
			int bRet;
			if( ABF_GAPFREEFILE == pFile->GetOperationMode() )
				bRet = readTimeDataToCol(nFileIndex, IMPORT_MODE_CHANNELS, pFile->GetSweepNumPerChannel());
			else
				bRet = readTimeDataToCol(nFileIndex, nInputMode, pFile->GetSweepNumPerChannel());
			
			if ( !bRet )
				return IMPERR_PCLAMP_FAILED_TO_READ_TIME;
			///---END HANDLE_ERR_MESSAGE_USE_DLL
		}
		/// end TEMP_OPEN_SUPPORT_GAPFREE_MODE
		//// END MORE_WORK_IN_PCLAMP_TIME
		
		foreach( TreeNode trChannel in trFileNode.Channels.Children )
		{
			if ( 1 == trChannel.nVal )
			{
				if(IMPORT_MODE_CHANNELS == nInputMode)
				{
					///Sophy 11/17/2011 ORG-4101-P1 DONOT_SET_EVEN_SAMPLING_WHEN_TIME_COLUMN_ADDED
					//if(!readChannelToCol(nFileIndex, nChannelIndex, strColPre))
					if(!readChannelToCol(nFileIndex, nChannelIndex, strColPre, timecol))
					///end DONOT_SET_EVEN_SAMPLING_WHEN_TIME_COLUMN_ADDED
						return IMPERR_PCLAMP_FAILED_TO_READ_CHANNEL; ///---Sim 11-09-2006 HANDLE_ERR_MESSAGE_USE_DLL	
				}
				else
				{
					int nSweepIndex = 0;
					///// 11/08/06 AW MORE_WORK_IN_PCLAMP_TIME
					/*
					if ( timecol )
						readTimeDataToCol(nFileIndex);
					*/
					//// END MORE_WORK_IN_PCLAMP_TIME
					foreach( TreeNode trSweep in trFileNode.Sweeps.Children )
					{
						if ( 1 == trSweep.nVal )
						{
							/// Hong 11/9/06 TEMP_OPEN_SUPPORT_GAPFREE_MODE 
							//if(!readSweepToCol(nFileIndex, nChannelIndex, nSweepIndex, strColPre, timecol))
							//	return false;
							if( ABF_GAPFREEFILE == pFile->GetOperationMode() )
							{
								///Sophy 11/17/2011 ORG-4101-P1 DONOT_SET_EVEN_SAMPLING_WHEN_TIME_COLUMN_ADDED
								//if(!readChannelToCol(nFileIndex, nChannelIndex, strColPre))
								if(!readChannelToCol(nFileIndex, nChannelIndex, strColPre, timecol))
								///end DONOT_SET_EVEN_SAMPLING_WHEN_TIME_COLUMN_ADDED
									return IMPERR_PCLAMP_FAILED_TO_READ_CHANNEL; ///---Sim 11-09-2006 HANDLE_ERR_MESSAGE_USE_DLL
							}
							else
							{
								if(!readSweepToCol(nFileIndex, nChannelIndex, nSweepIndex, strColPre, timecol))
									return IMPERR_PCLAMP_FAILED_TO_READ_SWEEP; ///---Sim 11-09-2006 HANDLE_ERR_MESSAGE_USE_DLL
							}
							/// end TEMP_OPEN_SUPPORT_GAPFREE_MODE
						}
						nSweepIndex++;
					}
				}
			}
			nChannelIndex++;
		}
		//// AW 10/10/06 MORE_ON_XF_PCLAMP_HEADER_INFO
		/*
		string strHeadInfo;
		strHeadInfo = GetHeaderInfo(nFileIndex);
		trInfo.HeaderInfo.strVal = strHeadInfo;
		*/
		/// AW 05/07/07 MORE_ON_FILE_INFO
		//trInfo.Reset();
		//TreeNode trHeader = trInfo.AddNode("HeaderInfo");
		GetHeaderInfo(trInfo, nFileIndex);
		/// END MORE_ON_FILE_INFO
		/// END MORE_ON_XF_PCLAMP_HEADER_INFO
		
		/*
		TreeNode trHeader;
		trHeader = trInfo.AddTNode("HeaderInfo");
		trHeader.strVal
		*/
		return CER_NO_ERROR; ///---Sim 11-09-2006 HANDLE_ERR_MESSAGE_USE_DLL
	}
	/// END ADD_PCLMAP_XF
	//// AW 10/10/06 MORE_ON_XF_PCLAMP_HEADER_INFO
	void GetHeaderInfo(TreeNode trInfo, int nFileIndex)
	{
		/*
		string strValue;
		TreeNode trFileProp = trHeaderInfo.AddNode("FileProp");
		trFileProp.SetAttribute(STR_LABEL_ATTRIB, "File Properties");
		TreeNode trFileNormal = trFileProp.AddNode("Normal");
		strValue = GetHeaderInfo(nFileIndex, INFO_TERSE);
		trFileNormal.strVal = strValue;
		TreeNode trFileVerbose = trFileProp.AddNode("Verbose");
		strValue = GetHeaderInfo(nFileIndex, INFO_VERBOSE);
		trFileVerbose.strVal = strValue;
		TreeNode trTags = trHeaderInfo.AddNode("Tags");
		strValue = GetTags(nFileIndex);
		trTags.strVal = strValue;
		*/
		//// AW 05/07/07 MORE_ON_FILE_INFO
		string strFileInfo = GetHeaderInfo(nFileIndex, INFO_TERSE);
		trInfo.Reset();
		{
			///---Sim 05-11-2007 CLEAR_REPEATING_HEADER_INFO
			/*
			TreeNode trDataFile =trInfo.AddNode("DataFile");
			trDataFile.SetAttribute(STR_LABEL_ATTRIB, "Data File");
			GETN_USE(trDataFile)
			GETN_MULTILINE_TEXT(DataFile, "Data File", strFileInfo) GETN_OPTION_MUTILINE_TEXT_BOX(true, "2-8", true)
			*/
			///---END CLEAR_REPEATING_HEADER_INFO
		}
		{
			TreeNode trProtocol =trInfo.AddNode("Protocol");
			trProtocol.SetAttribute(STR_LABEL_ATTRIB, "Protocol");
			GETN_USE(trProtocol)
			GETN_MULTILINE_TEXT(Protocl, "Protocol", strFileInfo) GETN_OPTION_MUTILINE_TEXT_BOX(true, "2-8", true)
		}
		{
			///---Sim 05-11-2007 CLEAR_REPEATING_HEADER_INFO
			/*
			TreeNode trAnnotations =trInfo.AddNode("Annotations");
			trAnnotations.SetAttribute(STR_LABEL_ATTRIB, "Annotations");
			GETN_USE(trAnnotations)
			strFileInfo = GetHeaderInfo(nFileIndex, INFO_VERBOSE);
			GETN_MULTILINE_TEXT(Annotations, "Annotations", strFileInfo) GETN_OPTION_MUTILINE_TEXT_BOX(true, "2-8", true)
			*/
			///---END CLEAR_REPEATING_HEADER_INFO
		}
		
		
		TreeNode trHeaderInfo = trInfo.AddNode("HeaderInfo");
		trHeaderInfo.SetAttribute(STR_LABEL_ATTRIB, "Header info");
		//// END MORE_ON_FILE_INFO

		pCLAMPFile* pFile = (pCLAMPFile*)m_vPClampFiles[nFileIndex];
		if(pFile)
		{
			/// AW 03/12/07 8.0579 FIX_PLCAMP_CRASH_AT_FILENODE_CLEANUP
			// the better way is fix it in VC level, but too many exiting codes there, so need wait TD check
			//trHeaderInfo = pFile->GetHeaderStruct();
			ABFFileHeader abdHeader;
			pFile->GetHeaderStruct(abdHeader);
			trHeaderInfo = abdHeader;
			/// END FIX_PLCAMP_CRASH_AT_FILENODE_CLEANUP
			/// Hong 01/25/07 REMOVE_SOME_PARAMETER_FROM_STRUCTURE
			// Justin insist on deleting it as have shown in column user parameter or user info
			trHeaderInfo.nADCPtoLChannelMap.Remove();
			trHeaderInfo.nADCSamplingSeq.Remove();
			trHeaderInfo.fADCProgrammableGain.Remove();
			trHeaderInfo.fInstrumentScaleFactor.Remove();
			trHeaderInfo.fInstrumentOffset.Remove();
			trHeaderInfo.fSignalGain.Remove();
			trHeaderInfo.fSignalOffset.Remove();
			trHeaderInfo.fSignalLowpassFilter.Remove();
			trHeaderInfo.fSignalHighpassFilter.Remove();
			trHeaderInfo.nLowpassFilterType.Remove();
			trHeaderInfo.nHighpassFilterType.Remove();
			trHeaderInfo.nTelegraphEnable.Remove();
			trHeaderInfo.nTelegraphInstrument.Remove();
			trHeaderInfo.fTelegraphAdditGain.Remove();	
			trHeaderInfo.fTelegraphFilter.Remove();
			trHeaderInfo.fTelegraphMembraneCap.Remove();
			trHeaderInfo.nTelegraphMode.Remove();
			trHeaderInfo.fPostProcessLowpassFilter.Remove();
			trHeaderInfo.nPostProcessLowpassFilterType.Remove();
			/// end REMOVE_SOME_PARAMETER_FROM_STRUCTURE
		}
	}
	string GetTags(int nFileIndex)
	{
		pCLAMPFile* pFile = (pCLAMPFile*)m_vPClampFiles[nFileIndex];
		if(pFile)
			return pFile->GetTags();
		return "";
	}
	//// END MORE_ON_XF_PCLAMP_HEADER_INFO
	
	/// Hong 01/15/09 FIX_PCLAMP_PLOT_FAIL_HANDLE_TIME_OFFSET_OF_HOLDING_DURATION
	double GetHoldingDuration(int nFileIndex)
	{
		pCLAMPFile* pFile = (pCLAMPFile*)m_vPClampFiles[nFileIndex];
		if ( !pFile )
			return 0.0;
		
		return pFile->GetHoldingDuration();
	}
	/// end FIX_PCLAMP_PLOT_FAIL_HANDLE_TIME_OFFSET_OF_HOLDING_DURATION
	/// Hong 10/24/06 ADD_TAG_TO_GRAPH
	double GetStartTime(int nFileIndex, int nChannel = -1 , DWORD dwEpisode = -1)
	{
		double dVal = 0.0;
		pCLAMPFile* pFile = (pCLAMPFile*)m_vPClampFiles[nFileIndex];
		if(pFile)
			pFile->GetStartTime(&dVal, nChannel, dwEpisode);
		return dVal;			
	}
	/// end ADD_TAG_TO_GRAPH

	//get channel count from pclamp file
	///Iris 12/31/03 v8.0790  ADD_PCLAMPFILE_POINTER
	/*
	int GetChannelNum(string strFileName)
	{
		pCLAMPFile pCalmpFile(strFileName);
		return pCalmpFile.GetChannelNum();
	}
	*/
	int GetChannelNum(int iIndex)
	{
		pCLAMPFile* pFile = (pCLAMPFile*)m_vPClampFiles[iIndex];
		if(pFile)			
			return pFile->GetChannelNum();
		
		return -1;
	}
	///End ADD_PCLAMPFILE_POINTER
	
	
	//get sweep count from pclamp file
	///Iris  12/31/03 v8.0790 ADD_PCLAMPFILE_POINTER
	/*
	int GetSweepNum(string strFileName)
	{
		pCLAMPFile pCalmpFile(strFileName);
		return pCalmpFile.GetSweepNumPerChannel();
	}
	*/
	int GetSweepNum(int iIndex)
	{
		pCLAMPFile* pFile = (pCLAMPFile*)m_vPClampFiles[iIndex];
		if(pFile)			
			return pFile->GetSweepNumPerChannel();
		
		return -1;
	}
	///End ADD_PCLAMPFILE_POINTER
	
	//get Sample Interval from pclamp file
	///Iris  12/31/03 v8.0790 ADD_PCLAMPFILE_POINTER
	/*
	float GetSampleInterval(string strFileName)
	{
		pCLAMPFile pCalmpFile(strFileName);
		return pCalmpFile.GetSampleInterval();
	}
	*/
	//float GetSampleInterval(int iIndex)
	double GetSampleInterval(int iIndex) // Hong 02/08/07 MORE_PRECISE
	{
		pCLAMPFile* pFile = (pCLAMPFile*)m_vPClampFiles[iIndex];
		if(pFile)			
			return pFile->GetSampleInterval();
		
		return -1;
	}	
	///End ADD_PCLAMPFILE_POINTER
	
	
	//get Sample Size from pclamp file
	///Iris  12/31/03 v8.0790 ADD_PCLAMPFILE_POINTER
	/*
	int GetSweepSize(string strFileName, int nSweepNo = -1)
	{
		pCLAMPFile pCalmpFile(strFileName);
		return pCalmpFile.GetSweepSize(nSweepNo);
	}
	*/
	int GetSweepSize(int iIndex, int nSweepNo = -1)
	{
		pCLAMPFile* pFile = (pCLAMPFile*)m_vPClampFiles[iIndex];
		if(pFile)			
			return pFile->GetSweepSize(nSweepNo);
		
		return -1;
	}	
	///End ADD_PCLAMPFILE_POINTER
	
	///Iris 12/31/03 v8.0790  ADD_PCLAMPFILE_POINTER
	//// AW 10/10/06 MORE_ON_XF_PCLAMP_HEADER_INFO
	//string GetHeaderInfo(int iIndex)
	string GetHeaderInfo(int iIndex, UINT nHeaderDisplayMode = INFO_TERSE)
	//// END MORE_ON_XF_PCLAMP_HEADER_INFO
	{
		pCLAMPFile* pFile = (pCLAMPFile*)m_vPClampFiles[iIndex];
		if(pFile)
			//// AW 10/10/06 MORE_ON_XF_PCLAMP_HEADER_INFO
			//return pFile->GetHeaderInfo();
			return pFile->GetHeaderInfo(nHeaderDisplayMode);
			//// END MORE_ON_XF_PCLAMP_HEADER_INFO
		
		return "";
	}
	///End ADD_PCLAMPFILE_POINTER
	
	bool ImportPClamp()
	{
		vector<string> 	vnFileNames;
		vector<int>		vnImportModes;
		vector<int> 	vnChannelNos;
		vector<int>     vnSweepNos;
		
		vnFileNames = m_trSetupInfo.GetNode(IMPORT_FILENAME).strVals;
		vnImportModes = m_trSetupInfo.GetNode(IMPORT_MODE).nVals;
		vnChannelNos = m_trSetupInfo.GetNode(IMPORT_CHANNELNO).nVals;
		vnSweepNos = m_trSetupInfo.GetNode(IMPORT_SWEEPNO).nVals;
		

		cleanWks();
		for(int iIndex=0; iIndex < m_nFileNum; iIndex++)
		{
			//pCLAMPFile	pClamp(vnFileNames[iIndex]);
			if(IMPORT_MODE_CHANNELS == vnImportModes[iIndex])
			{
				//m_strHeaderInfo = pClamp.GetHeaderInfo();//Iris 12/15/03 Now, just set header info when import as Channel mode
				//m_strHeaderInfo = GetHeaderInfo(iIndex);
				
				//if(!readChannelToCol(pClamp, iIndex, vnChannelNos[iIndex]))
				if(!readChannelToCol(iIndex, vnChannelNos[iIndex]))
					return false;
			}
			else
			{
				//readTimeDataToCol(pClamp,iIndex);
				readTimeDataToCol(iIndex);
				
				//if(!readSweepToCol(pClamp, iIndex, vnChannelNos[iIndex], vnSweepNos[iIndex]))
				if(!readSweepToCol(iIndex, vnChannelNos[iIndex], vnSweepNos[iIndex]))
					return false;
			}
		}		
		return true;
	}
	
	///// AW 09/22/06 ADD_PCLAMP_IMPORT_XF
	BOOL GetpClampFileName(int nIndex, string& strFileName)
	{
		pCLAMPFile* pFile = (pCLAMPFile*)m_vPClampFiles[nIndex];
		if(pFile)		
		{
			strFileName = pFile->GetFileName();
			return true;
		}
		return false;
	}
	///// END ADD_PCLAMP_IMPORT_XF

	/// SY 2006-11-03 v8.0505 ADD_SCALER_OBJECT
	BOOL GetChannelName(string& strName, int nFileIndex, int nChannel)
	{
		pCLAMPFile* pFile = (pCLAMPFile*)m_vPClampFiles[nFileIndex];
		return pFile->GetChannelName(nChannel, strName);
	}
	/// end ADD_SCALER_OBJECT
	
	/// Hong 11/6/06 ADD_STIMULUR_OUTPUT_DATA
	/// SY 2006-11-08 v8.0507 CHECK_STIMULUS
	///	int AddDACStimulurToWks(int nIndex, int nImportMode)
	//int GetDACStimulus(int nIndex, int nImportMode, bool bAddToWks = true)
	/// Hong 03/05/09 QA80-13222 SWEEP_MODE_ALLOW_SHOW_TIME_COL_AS_75_ASKED_BY_USER
	//int GetDACStimulus(int nIndex, int nImportMode, TreeNode& trSetting, bool bAddToWks = true) // Hong 02/08/07 ADD_DATA_SELECTION_SUPPORT
	int GetDACStimulus(int nIndex, int nImportMode, TreeNode& trSetting, bool bAddToWks = true, bool bAddTimeCol = false)
	/// end SWEEP_MODE_ALLOW_SHOW_TIME_COL_AS_75_ASKED_BY_USER
	/// end CHECK_STIMULUS
	{
		pCLAMPFile* 	pFile;
		pFile = (pCLAMPFile*)m_vPClampFiles[nIndex];
		if(!pFile)
			return false;
		/// Hong 01/05/06 ONLY_EPISODIC_STIMULATION_MODE_HAVE_WAVEFORM_OUTPUT
		if( ABF_WAVEFORMFILE != pFile->GetOperationMode() )
			return false;
		/// end ONLY_EPISODIC_STIMULATION_MODE_HAVE_WAVEFORM_OUTPUT
		int nColNum = 0;
		int nSweepNum = GetSweepNum(nIndex);
	/// Hong 11/8/06 MORE_ADD_STIMULUR_OUTPUT_DATA
	/*
		for(int ii=0; ii < ABF_WAVEFORMCOUNT; ii++)
		{
			if(IMPORT_MODE_CHANNELS == nImportMode)
			{
				vector<float> vData;
				if(pFile->ReadOneChannelStimulur(ii,vData))
				{
					nColNum ++;
					setupCol(vData,  "", 0, nIndex, 0, 0, STIMULUS_COL);
				}
			}
			else
			{
				for(int jj=0; jj < nSweepNum; jj++)
				{
					vector<float> vData;
					if(!pFile->AddOneSweepStimulur(ii, jj, vData))
						break;
					nColNum ++;
					setupCol(vData,  "", 0, nIndex, 0, 0, STIMULUS_COL);
				}
			}
		}
	*/
		/// Hong 01/05/06 FIX_MULTI_CHANNEL_WAVEFORM
		//string strLongName = pFile->GetActiveDACChannelName();
		//string strUnit = pFile->GetActiveDACUnit();
		string strLongName, strUnit;
		/// end FIX_MULTI_CHANNEL_WAVEFORM
		if(IMPORT_MODE_CHANNELS == nImportMode)
		{
			vector<float> vData;
			/// Hong 01/05/06 FIX_MULTI_CHANNEL_WAVEFORM
			/// Hong 02/15/07 FIX_STIMULU_HAVE_OWN_CHANNEL_INDEX
			/* roll back code
			/// Hong 02/08/07 ADD_DATA_SELECTION_SUPPORT
			for(int ii=0; ii < ABF_DACCOUNT; ii++)
			//int ii = 0;
			//foreach( TreeNode trChannel in trSetting.Channels.Children )
			
			{
				if(1 == trChannel.nVal)
				{
			/// end ADD_DATA_SELECTION_SUPPORT
			*/
			for(int ii=0; ii < ABF_DACCOUNT; ii++)
			{
			/// end FIX_STIMULU_HAVE_OWN_CHANNEL_INDEX
					strLongName = pFile->GetDACChannelName(ii);
					strUnit = pFile->GetDACUnit(ii);
					if(pFile->ReadWaveform(vData, ii))
					{
						nColNum ++;
						if( bAddToWks ) /// SY 2006-11-08 v8.0507 CHECK_STIMULUS
							/// Hong 03/05/09 QA80-13222 SWEEP_MODE_ALLOW_SHOW_TIME_COL_AS_75_ASKED_BY_USER
							//setupCol(vData,  strLongName, strLongName, strUnit, 0, nIndex, 0, ii, STIMULUS_COL);
							setupCol(vData,  strLongName, strLongName, strUnit, 0, nIndex, 0, ii, STIMULUS_COL, !bAddTimeCol);
							/// end SWEEP_MODE_ALLOW_SHOW_TIME_COL_AS_75_ASKED_BY_USER
					}
				//}
				//ii++; // Hong 02/15/07 FIX_STIMULU_HAVE_OWN_CHANNEL_INDEX
			}
			/// end FIX_MULTI_CHANNEL_WAVEFORM
		}
		else
		{
			/// Hong 01/05/06 FIX_MULTI_CHANNEL_WAVEFORM
			/// Hong 02/15/07 FIX_STIMULU_HAVE_OWN_CHANNEL_INDEX
			/* roll back code
			/// Hong 02/08/07 ADD_DATA_SELECTION_SUPPORT
			//for(int ii=0; ii < ABF_DACCOUNT; ii++)
			int ii = 0;
			foreach( TreeNode trChannel in trSetting.Channels.Children )
			{
				if(1 == trChannel.nVal)
				{
			/// end ADD_DATA_SELECTION_SUPPORT
			*/
			for(int ii=0; ii < ABF_DACCOUNT; ii++)
			{
			/// end FIX_STIMULU_HAVE_OWN_CHANNEL_INDEX
					strLongName = pFile->GetDACChannelName(ii);
					strUnit = pFile->GetDACUnit(ii);
					//string strDACChName, strDACUnits;/// SY 2006-11-08 v8.0507 CHECK_STIMULUS
					/// Hong 02/08/07 ADD_DATA_SELECTION_SUPPORT
					//for(int jj=0; jj < nSweepNum; jj++)
					int jj = 0;
					foreach( TreeNode trSweep in trSetting.Sweeps.Children )
					{
						if(1 == trSweep.nVal)
						{
					/// end 
							vector<float> vData;
							if(!pFile->ReadOneSweepWaveform(jj, vData, ii))
								break;
							nColNum ++;
							
							if( bAddToWks ) /// SY 2006-11-08 v8.0507 CHECK_STIMULUS
							{
								string strTemp;
								//strTemp.Format("%s #ep%d", strLongName, jj);
								strTemp.Format("%s #ep%d", strLongName, jj + 1); // Hong 12/19/06 SWEEP_INDEX_START_FROM_1
								/// Hong 03/05/09 QA80-13222 SWEEP_MODE_ALLOW_SHOW_TIME_COL_AS_75_ASKED_BY_USER
								//setupCol(vData,  strLongName, strTemp, strUnit, 0, nIndex, 0, jj, STIMULUS_COL);
								setupCol(vData,  strLongName, strTemp, strUnit, 0, nIndex, 0, jj, STIMULUS_COL, !bAddTimeCol);
								/// end SWEEP_MODE_ALLOW_SHOW_TIME_COL_AS_75_ASKED_BY_USER
							}
						}
						jj++;
					}
				//}
				//ii++; //Hong 02/15/07 FIX_STIMULU_HAVE_OWN_CHANNEL_INDEX
			}
			/// end FIX_MULTI_CHANNEL_WAVEFORM
		}
	/// end MORE_ADD_STIMULUR_OUTPUT_DATA
		return nColNum;
	}
	/// end ADD_STIMULUR_OUTPUT_DATA
	
	/// Hong 11/8/06 MORE_ADD_STIMULUR_OUTPUT_DATA
	/// SY 2006-11-08 v8.0507 CHECK_STIMULUS
	///	int AddDigitStimulurToWks(int nIndex, int nImportMode)
	/// Hong 03/05/09 QA80-13222 SWEEP_MODE_ALLOW_SHOW_TIME_COL_AS_75_ASKED_BY_USER
	//int GetDigitStimulus(int nIndex, int nImportMode, bool bAddToWks = true)
	int GetDigitStimulus(int nIndex, int nImportMode, bool bAddToWks = true, bool bAddTimeCol = false)
	/// end SWEEP_MODE_ALLOW_SHOW_TIME_COL_AS_75_ASKED_BY_USER
	/// end CHECK_STIMULUS
	{
		pCLAMPFile* 	pFile;
		pFile = (pCLAMPFile*)m_vPClampFiles[nIndex];
		if(!pFile)
			return 0;
		/// Hong 01/05/06 ONLY_EPISODIC_STIMULATION_MODE_HAVE_WAVEFORM_OUTPUT
		if( ABF_WAVEFORMFILE != pFile->GetOperationMode() )
			return false;
		/// end ONLY_EPISODIC_STIMULATION_MODE_HAVE_WAVEFORM_OUTPUT
		int nColNum = 0;
		int nSweepNum = GetSweepNum(nIndex);
		DWORD dwMask = 1;
		vector<DWORD> vData;
		if(!pFile->ReadDigitWaveform(vData))
			return nColNum;
		int nSize = vData.GetSize();
		string strLongName, strUint = "V";/// Hong 11/9/06 ADD_INFO_FOR_DIGITAL_WAVEFORM
		if(IMPORT_MODE_CHANNELS == nImportMode)
		{	
			for(int ii=0; ii < DIGIT_WAVEFORM_NUM; ii++)
			{
				vector<DWORD> vTemp;
				/// AW 11/12/06 SPEED_ON_STIMULUR
				/*
				vTemp.SetSize(nSize);
				for(int jj=0; jj < nSize; jj++)
				{
					vTemp[jj] = vData[jj] >> ii;
					vTemp[jj] &= dwMask;
				}
				*/
				vTemp = vData>>ii;
				vTemp = vTemp&dwMask;
				/// END SPEED_ON_STIMULUR
				nColNum ++;
				/// Hong 11/9/06 ADD_INFO_FOR_DIGITAL_WAVEFORM
				vTemp *= DIGITAL_WAVEFORM_SCALE;// can't find relate info in file,  so just make it as pclamp demo now
				strLongName.Format("D%d", ii);
				/// end ADD_INFO_FOR_DIGITAL_WAVEFORM
				if( bAddToWks ) /// SY 2006-11-08 v8.0507 CHECK_STIMULUS
				/// Hong 11/9/06 ADD_INFO_FOR_DIGITAL_WAVEFORM
				// can't find relate info in file, so just make it as pclamp demo now
				//setupCol(vTemp,  "", 0, nIndex, 0, 0, STIMULUS_COL);
					/// Hong 03/05/09 QA80-13222 SWEEP_MODE_ALLOW_SHOW_TIME_COL_AS_75_ASKED_BY_USER
					//setupCol(vTemp,  strLongName, strLongName, strUint, 0, nIndex, 0, ii, STIMULUS_COL);
					setupCol(vTemp,  strLongName, strLongName, strUint, 0, nIndex, 0, ii, STIMULUS_COL, !bAddTimeCol);
					/// end SWEEP_MODE_ALLOW_SHOW_TIME_COL_AS_75_ASKED_BY_USER
				/// end ADD_INFO_FOR_DIGITAL_WAVEFORM
			//	dwMask = dwMask << 1;    //// AW 11/08/06 FIX_STIMULUR_PLOT_ERROR
			}
		}
		else
		{	
			string strTemp;
			for(int ii=0; ii < DIGIT_WAVEFORM_NUM; ii++)
			{		
				strLongName.Format("D%d", ii);/// Hong 11/9/06 ADD_INFO_FOR_DIGITAL_WAVEFORM
				
				int nC1 = 0;
				/// Hong 05/18/07 v8.0621 REMOVE_DUPLICATE_DIGITAL_WAVEFORM
				//for(int mm = 1; mm <= nSweepNum; mm++ )
				int mm = 1;
				/// end REMOVE_DUPLICATE_DIGITAL_WAVEFORM
				{
					int uNumSamples = GetSweepSize(nIndex, mm);
					vector<DWORD> vTemp;
					//vTemp.SetSize(uNumSamples);	/// AW 11/12/06 SPEED_ON_STIMULUR
					vData.GetSubVector(vTemp, nC1, nC1 + uNumSamples - 1);
					/// AW 11/12/06 SPEED_ON_STIMULUR
					/*
					for(int jj=0; jj < vTemp.GetSize(); jj++)
					{
						vTemp[jj] >>= ii;
						vTemp[jj] &= dwMask;
					}
					*/
					vTemp = vTemp>>ii;//)&dwMask;
					vTemp = vTemp&dwMask;
					/// END SPEED_ON_STIMULUR
					nColNum ++;
					vTemp *= DIGITAL_WAVEFORM_SCALE; /// Hong 11/9/06 ADD_INFO_FOR_DIGITAL_WAVEFORM
					if( bAddToWks ) /// SY 2006-11-08 v8.0507 CHECK_STIMULUS
					/// Hong 11/9/06 ADD_INFO_FOR_DIGITAL_WAVEFORM
					// can't find relate info in file, so just make it as pclamp demo now
					//setupCol(vTemp,  "", 0, nIndex, 0, 0, STIMULUS_COL);
					{
						//strTemp.Format("%s #ep%d", strLongName, mm - 1);
						strTemp.Format("%s #ep%d", strLongName, mm); //Hong 12/19/06 SWEEP_INDEX_START_FROM_1
						/// Hong 03/05/09 QA80-13222 SWEEP_MODE_ALLOW_SHOW_TIME_COL_AS_75_ASKED_BY_USER
						//setupCol(vTemp,  strLongName, strTemp, strUint, 0, nIndex, 0, mm - 1, STIMULUS_COL);
						setupCol(vTemp,  strLongName, strTemp, strUint, 0, nIndex, 0, mm - 1, STIMULUS_COL, !bAddTimeCol);
						/// end SWEEP_MODE_ALLOW_SHOW_TIME_COL_AS_75_ASKED_BY_USER
					}
					/// end ADD_INFO_FOR_DIGITAL_WAVEFORM
					nC1 =+ uNumSamples;
				}
			//	dwMask = dwMask << 1;    //// AW 11/08/06 FIX_STIMULUR_PLOT_ERROR
			}
		}
		return nColNum;
	}
	
	/// SY 2006-11-08 v8.0507 CHECK_STIMULUS
	///	int AddStimulurToWks(int nIndex, int nImportMode) 
	//int GetStimulus(int& nDigitalCol, int nIndex, int nImportMode, bool bAddToWks = true)
	/// Hong 03/05/09 QA80-13222 SWEEP_MODE_ALLOW_SHOW_TIME_COL_AS_75_ASKED_BY_USER
	//int GetStimulus(int& nDigitalCol, int nIndex, int nImportMode, TreeNode& trSetting, bool bAddToWks = true) // Hong 02/08/07 ADD_DATA_SELECTION_SUPPORT
	int GetStimulus(int& nDigitalCol, int nIndex, int nImportMode, TreeNode& trSetting, bool bAddToWks = true, bool bAddTimeCol = false)
	/// end SWEEP_MODE_ALLOW_SHOW_TIME_COL_AS_75_ASKED_BY_USER
	/// end CHECK_STIMULUS
	{
		int nColNum;
		/// SY 2006-11-08 v8.0507 CHECK_STIMULUS
		///nColNum = AddDACStimulurToWks(nIndex, nImportMode);
		///nColNum += AddDigitStimulurToWks(nIndex, nImportMode);
		//nColNum = GetDACStimulus(nIndex, nImportMode, bAddToWks);
		/// Hong 03/05/09 QA80-13222 SWEEP_MODE_ALLOW_SHOW_TIME_COL_AS_75_ASKED_BY_USER
		//nColNum = GetDACStimulus(nIndex, nImportMode, trSetting, bAddToWks); // Hong 02/08/07 ADD_DATA_SELECTION_SUPPORT
		//nDigitalCol = GetDigitStimulus(nIndex, nImportMode, bAddToWks);;
		nColNum = GetDACStimulus(nIndex, nImportMode, trSetting, bAddToWks, bAddTimeCol);
		nDigitalCol = GetDigitStimulus(nIndex, nImportMode, bAddToWks, bAddTimeCol);
		/// end SWEEP_MODE_ALLOW_SHOW_TIME_COL_AS_75_ASKED_BY_USER
//		nColNum += nDigitalCol
		/// end CHECK_STIMULUS
		return nColNum;
	}
	/// end MORE_ADD_STIMULUR_OUTPUT_DATA
	/// Hong 11/10/06 MORE_ADD_TAG_TO_PLOT
	/// Hong 12/20/06 SAVE_INFO_AS_TREE
	//bool GetTagsToPlot(vector<string>& vstrTags, vector& vX, int nIndex, int nInputMode)
	bool GetTagsToPlot(TreeNode& trTags, int nIndex, int nInputMode)
	/// end SAVE_INFO_AS_TREE
	{
		pCLAMPFile* 	pFile;
		pFile = (pCLAMPFile*)m_vPClampFiles[nIndex];
		if(!pFile)
			return false;
		bool bSweepMode = false;
		if( IMPORT_MODE_SWEEPS == nInputMode ) 
			bSweepMode = true;
		//return pFile->GetTagsToPlot(vstrTags, vX, bSweepMode);
		return pFile->GetTagsToPlot(trTags, bSweepMode); // Hong 12/20/06 SAVE_INFO_AS_TREE
	}
	/// end MORE_ADD_TAG_TO_PLOT
	
	///Hong 12/09/06 READ_MATH_CHANNEL
	/// Hong 03/05/09 QA80-13222 SWEEP_MODE_ALLOW_SHOW_TIME_COL_AS_75_ASKED_BY_USER
	//int GetMath(TreeNode& trFileNode, int nIndex, int nImportMode)
	int GetMath(TreeNode& trFileNode, int nIndex, int nImportMode, bool bAddTimeCol = false)
	/// end SWEEP_MODE_ALLOW_SHOW_TIME_COL_AS_75_ASKED_BY_USER
	{
		pCLAMPFile* 	pFile;
		pFile = (pCLAMPFile*)m_vPClampFiles[nIndex];
		if(!pFile)
			return false;
	
		int nColNum = 0;
		int nSweepNum = GetSweepNum(nIndex);

		string strLongName, strUnit, strFormular;
		
		if( !pFile->GetMathChannelInfo(strLongName, strUnit, strFormular) )
			return nColNum;
		
		if(IMPORT_MODE_CHANNELS == nImportMode)
		{
			vector<float> vfData;
			int ii, nC1 = 0, uNumSamples = 0;
			for( ii = 1; ii <= nSweepNum; ii++ )// sweep index start from 1
			{
				uNumSamples += GetSweepSize(nIndex, ii);
			}
			vfData.SetSize(uNumSamples);
			
			vector<float> vfTemp;
			for( ii = 0; ii < nSweepNum; ii++ )
			{
				if( !pFile->ReadOneSweepMathChannel(ii, vfTemp) )
					return nColNum;

				vfData.SetSubVector(vfTemp, nC1);
				nC1 += vfTemp.GetSize();
			}
			/// Hong 03/05/09 QA80-13222 SWEEP_MODE_ALLOW_SHOW_TIME_COL_AS_75_ASKED_BY_USER
			//setupCol(vfData,  strLongName, strLongName, strUnit, 0, nIndex, 0, ii, MATH_COL);
			setupCol(vfData,  strLongName, strLongName, strUnit, 0, nIndex, 0, ii, MATH_COL, !bAddTimeCol);
			/// end SWEEP_MODE_ALLOW_SHOW_TIME_COL_AS_75_ASKED_BY_USER
			nColNum = 1;
		}
		else
		{
			string strDACChName, strDACUnits;
			/// Hong 12/19/06 MATH_CHANNEL_ALLOW_SELECTION
			/*
			for(int jj=0; jj < nSweepNum; jj++)
			{
				vector<float> vData;
				if(!pFile->ReadOneSweepMathChannel(jj, vData))
					return nColNum;
				nColNum ++;
				
				string strTemp;
				//strTemp.Format("%s #ep%d", strLongName, jj);
				strTemp.Format("%s #ep%d", strLongName, jj + 1); // Hong 12/19/06 SWEEP_INDEX_START_FROM_1
				setupCol(vData,  strLongName, strTemp, strUnit, 0, nIndex, 0, 0, MATH_COL);
			}
			*/
			int nSweepIndex = 0;
			foreach( TreeNode trSweep in trFileNode.Sweeps.Children )
			{
				if ( 1 == trSweep.nVal )
				{
					vector<float> vData;
					if(!pFile->ReadOneSweepMathChannel(nSweepIndex, vData))
						return nColNum;
					nColNum ++;
					
					string strTemp;
					strTemp.Format("%s #ep%d", strLongName, nSweepIndex + 1); // Hong 12/19/06 SWEEP_INDEX_START_FROM_1
					/// Hong 03/05/09 QA80-13222 SWEEP_MODE_ALLOW_SHOW_TIME_COL_AS_75_ASKED_BY_USER
					//setupCol(vData,  strLongName, strTemp, strUnit, 0, nIndex, 0, nSweepIndex, MATH_COL);
					setupCol(vData,  strLongName, strTemp, strUnit, 0, nIndex, 0, nSweepIndex, MATH_COL, !bAddTimeCol);
					/// end SWEEP_MODE_ALLOW_SHOW_TIME_COL_AS_75_ASKED_BY_USER
				}
				nSweepIndex++;
			}
			/// end MATH_CHANNEL_ALLOW_SELECTION
		}

		return nColNum;
	}
	/// end READ_MATH_CHANNEL

	/// Hong 12/18/06 MORE_INFO_FOR_PLOT
	bool GetSweepStartTime(vector& vdTime, int nIndex)
	{
		pCLAMPFile* 	pFile;
		pFile = (pCLAMPFile*)m_vPClampFiles[nIndex];
		if(!pFile)
			return false;
		
		vector vdTemp;
		int nSweepNum = GetSweepNum(nIndex);
		for(int ii=0; ii < nSweepNum; ii++)
		{
			double dTemp = GetStartTime(nIndex, -1, ii+1);
			vdTemp.Add(dTemp);
		}
		vdTime = vdTemp;
		
		return true;
	}
	/// end MORE_INFO_FOR_PLOT
	
	/// Hong 02/06/07 GET_MORE_SAFE_IMPORT_RANGE
	// return the currect file import data range
	void GetImportRange(int& c1, int& c2)
	{
		c1 = m_nC1;
		c2 = c1 + m_nNumCol - 1;
	}
	/// end GET_MORE_SAFE_IMPORT_RANGE
	
private:
	/// AW 09/18/06 ADD_PCLMAP_XF
	// void cleanWks(Worksheet& wks)
	//{
	//	m_wks = (Worksheet)Project.ActiveLayer();
	void cleanWks(Worksheet& wks = NULL)
	{
		m_wks = wks;
	/// END ADD_PCLMAP_XF
		if(!m_wks) 
			m_wks.Create();				
		m_wks.SetSize(-1, 0);
	}
	
	BOOL readTimeData(int nFileNo, vector<float>& vfData)
	{
		pCLAMPFile* 	pFile;
		pFile = (pCLAMPFile*)m_vPClampFiles[nFileNo];
		if(!pFile)
			return FALSE;
		
		///---Sim 11-09-2006 HANDLE_ERR_MESSAGE_USE_DLL	
		//pFile->GetTimeData(vfData);
		//return TRUE;
		/// AW 01/06/09 QA80-12413 ADD_HOLDING_DURATION_TIME_IN_PCLAMP
		//return pFile->GetTimeData(vfData);
		double fTimeOffset = 0.0;
		if ( m_bUseHoldingDuration )
		{
			fTimeOffset = -1;  // need recaculate fTimeOffset	
		}
		return pFile->GetTimeData(vfData, fTimeOffset);
		/// END ADD_HOLDING_DURATION_TIME_IN_PCLAMP

		return pFile->GetTimeData(vfData);
		///---END HANDLE_ERR_MESSAGE_USE_DLL	
	}
	//BOOL readTimeDataToCol(pCLAMPFile pClamp, int nFileNo)
	BOOL readTimeDataToCol(int nFileNo, int nInputMode = IMPORT_MODE_SWEEPS, int nSweepCount = 1)
	{
		///Iris 12/31/03 v8.0790 ADD_PCLAMPFILE_POINTER
		/*
		pCLAMPFile* 	pFile;
		pFile = (pCLAMPFile*)m_vPClampFiles[nFileNo];
		if(!pFile)
			return FALSE;
		///End ADD_PCLAMPFILE_POINTER
		
		//pClamp.GetTimeData(vfData);
		pFile->GetTimeData(vfData);
		*/
		vector<float> vfData;
		///---Sim 11-09-2006 HANDLE_ERR_MESSAGE_USE_DLL	
		//readTimeData(nFileNo, vfData);
		if ( !readTimeData(nFileNo, vfData) )
			return FALSE;		
		///---END HANDLE_ERR_MESSAGE_USE_DLL	
		
		
		/// Hong 12/11/06 FIX_TIME_ERROR_OFFSET
		/*
		///// 11/08/06 AW MORE_WORK_IN_PCLAMP_TIME
		float fTemp = vfData[0];
		vfData = vfData - fTemp;
		if ( IMPORT_MODE_CHANNELS == nInputMode )
		{
			int nSize = vfData.GetSize();
			vector<float> vfDataTemp;
			vfDataTemp = vfData;
			fTemp = vfData[nSize -1];
			/// Hong 11/9/06 FIX_ERROR_APPEND_TIME
			for (int ii = 2; ii <= nSweepCount; ii++ )//skip first sweep, sweep index start at 1
			/// end FIX_ERROR_APPEND_TIME
			{
				/// Hong 11/9/06 FIX_SWEEP_HAVE_DIFFERENT_LENGTH
				//ivfDataTemp += fTemp;
				//vfData.Append(vfDataTemp);
				int uNumSamples = GetSweepSize(nFileNo, ii);
				vector<float> vfTemp;
				vfDataTemp += fTemp;
				vfTemp = vfDataTemp;
				vfTemp.SetSize(uNumSamples);
				//vfTemp += fTemp;
				vfData.Append(vfTemp);
				/// end FIX_SWEEP_HAVE_DIFFERENT_LENGTH
			}
		}
		//// END MORE_WORK_IN_PCLAMP_TIME
		*/
		if ( IMPORT_MODE_CHANNELS == nInputMode )
		{
			vector<float> vfDataTemp;
			vfDataTemp = vfData;
			for (int ii = 2; ii <= nSweepCount; ii++ )//skip first sweep, sweep index start at 1
			{
				double dStartTime = GetStartTime(nFileNo, -1, ii);
				int uNumSamples = GetSweepSize(nFileNo, ii);
				vector<float> vfTemp;
				vfTemp = vfDataTemp;
				vfTemp += (float)dStartTime;
				vfTemp.SetSize(uNumSamples);
				vfData.Append(vfTemp);
			}
		}
		/// end FIX_TIME_ERROR_OFFSET
		//m_fEndTime = vfData[vfData.GetSize() - 1 ];// Hong 11/17/06 FIX_ERROR_END_TIME_FOR_TWO_INTERVAL_DATA
		setupCol(vfData, "", 0, nFileNo, 0, 0, TIME_COL, false);
		
		return TRUE
	}
	
	//Read a certain channel(nChannleNo>-1) or all channel(if nChannleNo==-1)and 
	//attach them to columns added to the current active worksheet.
	//BOOL readChannelToCol(pCLAMPFile pClamp, int nFileNo, int nChannelNo)
	BOOL readChannelToCol(int nFileNo, int nChannelNo)
	{	
		///Iris 12/31/03 v8.0790 ADD_PCLAMPFILE_POINTER
		pCLAMPFile* 	pFile;
		pFile = (pCLAMPFile*)m_vPClampFiles[nFileNo];
		if(!pFile)
			return FALSE;
		///End ADD_PCLAMPFILE_POINTER
		
		BOOL			bRet;
		//int 			nChannelNum = pClamp.GetChannelNum();
		int 			nChannelNum = pFile->GetChannelNum();
		
		if(-1 == nChannelNo)
		{
			bool bSetHeaderInfo = true;				
			for(int ii=0; ii < nChannelNum; ii++)
			{
				vector<float> 	vfData;
				//bRet = pClamp.ReadOneChannel(ii,vfData);
				bRet = pFile->ReadOneChannel(ii,vfData);	
				if( !bRet )
					return FALSE;
				
				setupCol(vfData, pFile->GetUnit(ii), nChannelNum, nFileNo, ii, 0, CHANNEL_COL, bSetHeaderInfo);
				bSetHeaderInfo = false;
			}
		}
		else
		{
			vector<float> 	vfData;
			//bRet = pClamp.ReadOneChannel(nChannelNo,vfData);
			bRet = pFile->ReadOneChannel(nChannelNo,vfData);
			if( !bRet)
				return FALSE;
			
			setupCol(vfData, pFile->GetUnit(nChannelNo), nChannelNum, nFileNo, nChannelNo, 0, CHANNEL_COL, true);			
		}
		return TRUE;
	}
	
	//Read one certain sweep(if nSweepNo>0) or all sweeps(if nSweepNo==-1) in a certain 
	//channel(if nChannelNo>-1) or all channel(if nChannelNo==-1)
	//BOOL readSweepToCol(pCLAMPFile pClamp, int nFileNo, int nChannelNo, int nSweepNo)
	BOOL readSweepToCol(int nFileNo, int nChannelNo, int nSweepNo)
	{
		if(-1 == nChannelNo)
		{
			//return readSweepFromAllChannelToCol(pClamp, nFileNo, nSweepNo);
			return readSweepFromAllChannelToCol(nFileNo, nSweepNo);
		}
		else
		{
			//return readSweepFromOneChannelToCol(pClamp, nFileNo, nChannelNo, nSweepNo);
			return readSweepFromOneChannelToCol(nFileNo, nChannelNo, nSweepNo);
		}		
	}
	
	//BOOL readSweepFromOneChannelToCol(pCLAMPFile pClamp, int nFileNo, int nChannelNo, int nSweepNo=-1)
	BOOL readSweepFromOneChannelToCol(int nFileNo, int nChannelNo, int nSweepNo=-1)
	{
		///Iris 12/31/03 v8.0790 ADD_PCLAMPFILE_POINTER
		pCLAMPFile* 	pFile;
		pFile = (pCLAMPFile*)m_vPClampFiles[nFileNo];
		if(!pFile)
			return FALSE;
		///End ADD_PCLAMPFILE_POINTER

		//int nChannelCount = pClamp.GetChannelNum();
		//int nSweepCount = pClamp.GetSweepNumPerChannel();
		int nChannelCount = pFile->GetChannelNum();
		int nSweepCount = pFile->GetSweepNumPerChannel();
		
		vector<float> 	vfData;
		//bool 			bSetHeaderInfo = true;			
		
		//Read all sweeps from special Channel
		BOOL			bRet;
		if(-1 == nSweepNo)
		{
			for(int Index=0; Index < nSweepCount; Index++)
			{
				//bRet = pClamp.ReadOneSweep(nChannelNo, Index, vfData);
				bRet = pFile->ReadOneSweep(nChannelNo, Index, vfData);
				if( !bRet )
					return FALSE;
				
				setupCol(vfData, pFile->GetUnit(nChannelNo), nChannelCount, nFileNo, nChannelNo, Index, SWEEP_COL, false);//Sweep mode no need import Header info to related columns
				//bSetHeaderInfo = false;
				
			}
		}
		//Read sepcial sweep from special channel
		else
		{
			//bRet = pClamp.ReadOneSweep(nChannelNo, nSweepNo, vfData);
			bRet = pFile->ReadOneSweep(nChannelNo, nSweepNo, vfData);
			if( !bRet )
				return FALSE;
			
			setupCol(vfData, pFile->GetUnit(nChannelNo), nChannelCount, nFileNo, nChannelNo, nSweepNo, SWEEP_COL, false);//Sweep mode no need import Header info to related columns	
		}
		return TRUE;
	}
	
	//BOOL readSweepFromAllChannelToCol(pCLAMPFile pClamp int nFileNo, int nSweepNo)
	BOOL readSweepFromAllChannelToCol(int nFileNo, int nSweepNo)
	{
		///Iris 12/31/03 v8.0790 ADD_PCLAMPFILE_POINTER
		pCLAMPFile* 	pFile;
		pFile = (pCLAMPFile*)m_vPClampFiles[nFileNo];
		if(!pFile)
			return FALSE;
		///End ADD_PCLAMPFILE_POINTER
		
		//int nChannelCount = pClamp.GetChannelNum();
		//int nSweepCount = pClamp.GetSweepNumPerChannel();
		int nChannelCount = pFile->GetChannelNum();
		int nSweepCount = pFile->GetSweepNumPerChannel();
		
		vector<float> 	vfData;
		//bool 			bSetHeaderInfo = true;	
		
		BOOL			bRet;
		for(int iChannelIndex=0; iChannelIndex < nChannelCount; iChannelIndex++)
		{
			//Read all sweeps from all channels
			if(-1 == nSweepNo)
			{
				for(int iSweepIndex=0; iSweepIndex < nSweepCount; iSweepIndex++)
				{
					//bRet = pClamp.ReadOneSweep(iChannelIndex, iSweepIndex, vfData);
					bRet = pFile->ReadOneSweep(iChannelIndex, iSweepIndex, vfData);
					if( !bRet )
						return FALSE;					
					
					setupCol(vfData, pFile->GetUnit(iChannelIndex), nChannelCount, nFileNo, iChannelIndex, iSweepIndex, SWEEP_COL, false);	//Sweep mode no need import Header info to related columns
				}
			}
			else//read one certain sweep from each channel
			{
				//bRet = pClamp.ReadOneSweep(iChannelIndex, nSweepNo, vfData);
				bRet = pFile->ReadOneSweep(iChannelIndex, nSweepNo, vfData);
				if( !bRet )
					return FALSE;					
				
				setupCol(vfData, pFile->GetUnit(iChannelIndex), nChannelCount, nFileNo, iChannelIndex, nSweepNo, SWEEP_COL, false);	//Sweep mode no need import Header info to related columns
			}
		}
		
		return TRUE;
	}
	
	void setColData(Column& col, vector<float> vfData)
	{
		vector<float> &vDest = col.GetDataObject();
		vDest = vfData;
		col.SetNumRows(vDest.GetSize());
	}
	
	void setColFormat(Column& col,int nColType, int nChannelNum, int nFileNo, int nChannelNo, int nSweepNo, string strLabel="")
	{
		string strName;
		string strTemp;
		string strUnits;
		
		
		//Format col name
		if(1 < m_nFileNum)
		{
			strTemp = COL_NAME_FILE + nFileNo;	
			col.SetWidth(10);
		}

		if(TIME_COL == nColType)
		{
			strName = strTemp + COL_NAME_TIME;
			//strLabel = COL_LABEL_TIME;
			strUnits = COL_LABEL_TIME;
			col.SetType(OKDATAOBJ_DESIGNATION_X);
		}
		else
			if(CHANNEL_COL == nColType)
			{
				strName = strTemp + COL_NAME_CHANNEL + nChannelNo;
				col.SetType(OKDATAOBJ_DESIGNATION_Y);
			}
			else
				if(SWEEP_COL == nColType)
				{
					if(1 < nChannelNum)
					{
						strName = strTemp + COL_NAME_CHANNEL + nChannelNo + COL_NAME_SWEEP + nSweepNo;
					}
					else
					{
						strName = strTemp + COL_NAME_SWEEP + nSweepNo;
					}						
					col.SetType(OKDATAOBJ_DESIGNATION_Y);
				}
		col.SetName(strName);
				
		//Format col Label		
		/// Hong 09/19/07 v8.0704 AVOID_SET_LONGNAEM_DUMP_WARNING_MESSAGE
		//col.SetLabel(strLabel);
		strLabel.TrimLeft();
		strLabel.TrimRight();
		col.SetLongName(strLabel);
		/// end AVOID_SET_LONGNAEM_DUMP_WARNING_MESSAGE
		col.SetUnits(strUnits);
		//m_wks.ShowLabels(true);// Hong 12/07/06 FIX_SPARKLINE_DISAPPEAR
	}
	/// Hong 01/25/07 ADD_MORE_COLUMN_INFO
	void SetColumnParameter(Column& col, int nFileNo, int nChannelNo, int nSweepNo)
	{
		string strName, strValue;
		vector<string> vsNames, vsValues;
		
		double dStartTime;
		// Hong 02/15/07 GENERAL_INDEX__OFFSET_TO_ONE
		//dStartTime = GetStartTime( nFileNo, -1, nSweepNo + 1 );
		dStartTime = GetStartTime( nFileNo, -1, nSweepNo);
		/// end GENERAL_INDEX__OFFSET_TO_ONE
		
		strName = _L("Start Time");
		strValue = ftoa(dStartTime);
		
		vsNames.Add(strName);
		vsValues.Add(strValue);
		
		set_user_parameters(col, vsNames, vsValues);
	}
	
	void SetColumnUserParameter(Column& col, int nFileNo, int nChannelNo, int nSweepNo)
	{
		Tree trUserInfo;
		pCLAMPFile* 	pFile;
		pFile = (pCLAMPFile*)m_vPClampFiles[nFileNo];
		
		pFile->GetUserInfoTree(trUserInfo, nChannelNo, nSweepNo);
		
		trUserInfo.Enable = ENABLE_READ_ONLY;
		trUserInfo.SetAttribute(STR_ATTRIB_BRANCH, GETNBRANCH_OPEN);
		string strName("ColumnInfo");
		///---Sim 02-05-2010 QA81-15063 ROLL_BACK_MOVE_COL_INFO_OUT_OF_USER_TREE
		//trUserInfo.Show = 0; ///---Sim 02-04-2010 QA81-15063 MOVE_IMP_FILE_INFO_OUT_FROM_COL_USER_INFO_TREE
		//set_user_info(col, strName, trUserInfo);
		fu_set_import_file_info(col, trUserInfo, strName, IMPORT_INFO_TO_USER_TREE);
		///---END QA81-15063 ROLL_BACK_MOVE_COL_INFO_OUT_OF_USER_TREE
		///---Sim 02-04-2010 QA81-15063 MOVE_IMP_FILE_INFO_OUT_FROM_COL_USER_INFO_TREE
		///---Sim 02-05-2010 QA81-15063 ROLL_BACK_MOVE_COL_INFO_OUT_OF_USER_TREE
		// roll back move column info out of user tree, as CP said
		//fu_set_import_file_name_info(col, pFile->GetFileName());
	//
		//trUserInfo.RemoveChild("ImportFile");
		//trUserInfo.Show = 1;
		//set_import_file_info(col, trUserInfo, "pCLAMP");
		///---END QA81-15063 ROLL_BACK_MOVE_COL_INFO_OUT_OF_USER_TREE
		///---END QA81-15063 MOVE_IMP_FILE_INFO_OUT_FROM_COL_USER_INFO_TREE
	}
	/// end ADD_MORE_COLUMN_INFO
	void setupCol(vector<float> vfData, string strLabel, int nChannelNum, int nFileNo, int nChannelNo, int nSweepNo, int nColType, bool bSetHeadInfo = true)
	{	
		nSweepNo++;// Hong 02/15/07 GENERAL_INDEX__OFFSET_TO_ONE
		///---Sim 02-05-2007 HOLD_ON_ORIGINAL_COLUMNS_SETTING
		//Column col = m_wks.Columns(m_wks.AddCol());
		m_nNumCol++;
		///---Sim 03-01-2007 QA80-9420 REIMPORT
		//if ( m_wks.GetNumCols() < m_nC1 + m_nNumCol )
			//m_wks.AddCol();
		if ( m_nC1 + m_nNumCol - 1 > m_nC2 )
		{
			string strColName;
			m_wks.InsertCol(m_nC1 + m_nNumCol - 1, NULL, strColName);
		}
		///---END QA80-9420 REIMPORT
			
		Column col = m_wks.Columns(m_nC1 + m_nNumCol - 1);
		///---END HOLD_ON_ORIGINAL_COLUMNS_SETTING
		
		col.SetInternalData(FSI_REAL); /// EJP 2006-06-09 v8.0425 PLCAMP_COL_TYPE_RUNTIME_ERR

		setColData(col, vfData);
		
		setColFormat(col, nColType, nChannelNum, nFileNo, nChannelNo, nSweepNo, strLabel);	
		/// Hong 01/25/07 ADD_MORE_COLUMN_INFO
		//SetColumnParameter(col, nFileNo, nChannelNo, nSweepNo);  // Hong 02/09/07 START_TIME_ALREADY_IN_SAMPLE_RATE
		SetColumnUserParameter(col, nFileNo, nChannelNo, nSweepNo);
		/// end ADD_MORE_COLUMN_INFO
		/// Hong 11/17/10 ORG-1517 WATERFALL_PLOT_NEED_X0_AS_Z_AXIS
		if ( !bSetHeadInfo )
			SetColumnParameter(col, nFileNo, nChannelNo, nSweepNo);
		/// end WATERFALL_PLOT_NEED_X0_AS_Z_AXIS
		/*
		///Iris 12/15/03 QA70-5711 FAIL_SETMEMORY_ON_NEWADDCOL
		#ifdef FAIL_SETMEMORY_ON_NEWADDCOL
		if(bSetHeadInfo)
		{
			setHeaderInfo(nFileNo, col);
		}	
		#endif //FAIL_SETMEMORY_ON_NEWADDCOL
		*/
		if ( bSetHeadInfo )
		{
			/// Hong 02/08/07 FIX_ERROR_START_TIEM
			//vector<float> vfData;
			//readTimeData(nFileNo, vfData);
			//float fStart = 	vfData[0];	
			//fStart = 0;   /// set start from 0
			//double dStartTime = GetStartTime(nFileNo, -1, nSweepNo + 1);
			double dStartTime = GetStartTime(nFileNo, -1, nSweepNo); // Hong 02/15/07 GENERAL_INDEX__OFFSET_TO_ONE
			/// end FIX_ERROR_START_TIEM
	
			//float fIncrement = GetSampleInterval(nFileNo); //Get Time increment
			double dIncrement = GetSampleInterval(nFileNo); // Hong 02/08/07 MORE_PRECISE
			/// Hong 11/1/06 QA-9073 ADD_XUNITS_AND_XLONGNAME_ARGS_TO_EVENSAMPLING
			//m_wks.SetEvenSampling(fStart, fIncrement, col );
			m_wks.SetEvenSampling(dStartTime, dIncrement, col, _L("ms"), _L("Time") );
			/// end ADD_XUNITS_AND_XLONGNAME_ARGS_TO_EVENSAMPLING
			
			//m_fEndTime = fIncrement * ( vfData.GetSize() - 1 );// Hong 11/17/06 FIX_ERROR_END_TIME_FOR_TWO_INTERVAL_DATA 
		}
		
		
		///End FAIL_SETMEMORY_ON_NEWADDCOL
	}

	///// AW 09/22/06 ADD_PCLAMP_IMPORT_XF
	
	BOOL readSweepFromOneChannelToCol(int nFileNo, int nChannelNo, string& strColPre, int timecol, int nSweepNo=-1)
	{
		///Iris 12/31/03 v8.0790 ADD_PCLAMPFILE_POINTER
		pCLAMPFile* 	pFile;
		pFile = (pCLAMPFile*)m_vPClampFiles[nFileNo];
		if(!pFile)
			return FALSE;
		///End ADD_PCLAMPFILE_POINTER

		//int nChannelCount = pClamp.GetChannelNum();
		//int nSweepCount = pClamp.GetSweepNumPerChannel();
		bool bSetHeaderInfo = timecol? false:true;

		int nChannelCount = pFile->GetChannelNum();
		int nSweepCount = pFile->GetSweepNumPerChannel();
		
		vector<float> 	vfData;
		//bool 			bSetHeaderInfo = true;			
		
		//Read all sweeps from special Channel
		BOOL			bRet;
		string 			strLongName, strTemp;
		
		if(-1 == nSweepNo)
		{
			for(int Index=0; Index < nSweepCount; Index++)
			{
				//bRet = pClamp.ReadOneSweep(nChannelNo, Index, vfData);
				bRet = pFile->ReadOneSweep(nChannelNo, Index, vfData);
				if( !bRet )
					return FALSE;
				
				setupCol(vfData, pFile->GetUnit(nChannelNo), nChannelCount, nFileNo, nChannelNo, Index, SWEEP_COL, bSetHeaderInfo);//Sweep mode no need import Header info to related columns
				//bSetHeaderInfo = false;
				
			}
		}
		//Read sepcial sweep from special channel
		else
		{
			//bRet = pClamp.ReadOneSweep(nChannelNo, nSweepNo, vfData);
			bRet = pFile->ReadOneSweep(nChannelNo, nSweepNo, vfData);
			if( !bRet )
				return FALSE;
			
			pFile->GetChannelName(nChannelNo, strLongName);
			//strTemp.Format("%s #ep%d", strLongName, nSweepNo);
			strTemp.Format("%s #ep%d", strLongName, nSweepNo + 1);// Hong 12/19/06 SWEEP_INDEX_START_FROM_1
			
			//setupCol(vfData, strColPre, strTemp, pFile->GetUnit(nChannelNo), nChannelCount, nFileNo, nChannelNo, nSweepNo, SWEEP_COL, bSetHeaderInfo);//Sweep mode no need import Header info to related columns	
			setupCol(vfData, strLongName, strTemp, pFile->GetUnit(nChannelNo), nChannelCount, nFileNo, nChannelNo, nSweepNo, SWEEP_COL, bSetHeaderInfo);//Sweep mode no need import Header info to related columns	
		}
		return TRUE;
	}
	
	BOOL readSweepToCol(int nFileNo, int nChannelNo, int nSweepNo, string& strColPre, int timecol)
	{
		if(-1 == nChannelNo)
		{
			//return readSweepFromAllChannelToCol(pClamp, nFileNo, nSweepNo);
			return readSweepFromAllChannelToCol(nFileNo, nSweepNo);   /// should not come here
		}
		else
		{
			//return readSweepFromOneChannelToCol(pClamp, nFileNo, nChannelNo, nSweepNo);
			return readSweepFromOneChannelToCol(nFileNo, nChannelNo, strColPre, timecol, nSweepNo);
		}		
	}
	///Sophy 11/17/2011 ORG-4101-P1 DONOT_SET_EVEN_SAMPLING_WHEN_TIME_COLUMN_ADDED
	//BOOL readChannelToCol(int nFileNo, int nChannelNo, string& strColPre)
	BOOL readChannelToCol(int nFileNo, int nChannelNo, string& strColPre, int nTimeCol)
	///end DONOT_SET_EVEN_SAMPLING_WHEN_TIME_COLUMN_ADDED
	{	
		///Iris 12/31/03 v8.0790 ADD_PCLAMPFILE_POINTER
		pCLAMPFile* 	pFile;
		pFile = (pCLAMPFile*)m_vPClampFiles[nFileNo];
		if(!pFile)
			return FALSE;
		///End ADD_PCLAMPFILE_POINTER
		
		BOOL			bRet;
		//int 			nChannelNum = pClamp.GetChannelNum();
		int 			nChannelNum = pFile->GetChannelNum();
		
		string strLongName; 
		bool bSetHeaderInfo = nTimeCol ? false : true;	///Sophy 11/17/2011 ORG-4101-P1 DONOT_SET_EVEN_SAMPLING_WHEN_TIME_COLUMN_ADDED
		if(-1 == nChannelNo)
		{
			///Sophy 11/17/2011 ORG-4101-P1 DONOT_SET_EVEN_SAMPLING_WHEN_TIME_COLUMN_ADDED
			//bool bSetHeaderInfo = true;				
			///end DONOT_SET_EVEN_SAMPLING_WHEN_TIME_COLUMN_ADDED
			for(int ii=0; ii < nChannelNum; ii++)
			{
				vector<float> 	vfData;
				//bRet = pClamp.ReadOneChannel(ii,vfData);
				bRet = pFile->ReadOneChannel(ii,vfData);	
				if( !bRet )
					return FALSE;
				
				pFile->GetChannelName(ii, strLongName); 
				setupCol(vfData, strColPre, strLongName, pFile->GetUnit(ii), nChannelNum, nFileNo, ii, 0, CHANNEL_COL, bSetHeaderInfo);
				bSetHeaderInfo = false;
			}
		}
		else
		{
			vector<float> 	vfData;
			//bRet = pClamp.ReadOneChannel(nChannelNo,vfData);
			bRet = pFile->ReadOneChannel(nChannelNo,vfData);
			if( !bRet)
				return FALSE;
			
			pFile->GetChannelName(nChannelNo, strLongName); 
			//setupCol(vfData, strColPre, strLongName, pFile->GetUnit(nChannelNo), nChannelNum, nFileNo, nChannelNo, 0, CHANNEL_COL, true);	
			///Sophy 11/17/2011 ORG-4101-P1 DONOT_SET_EVEN_SAMPLING_WHEN_TIME_COLUMN_ADDED
			//setupCol(vfData, strLongName, strLongName, pFile->GetUnit(nChannelNo), nChannelNum, nFileNo, nChannelNo, 0, CHANNEL_COL, true);			
			setupCol(vfData, strLongName, strLongName, pFile->GetUnit(nChannelNo), nChannelNum, nFileNo, nChannelNo, 0, CHANNEL_COL, bSetHeaderInfo);			
			///end DONOT_SET_EVEN_SAMPLING_WHEN_TIME_COLUMN_ADDED
		}
		return TRUE;
	}
	void setupCol(vector<float> vfData, string strName, string strLabel, string strUnit, int nChannelNum, int nFileNo, int nChannelNo, int nSweepNo, int nColType, bool bSetHeadInfo = true)
	{	
		nSweepNo++; // Hong 02/15/07 GENERAL_INDEX__OFFSET_TO_ONE
		///---Sim 02-05-2007 HOLD_ON_ORIGINAL_COLUMNS_SETTING
		//Column col = m_wks.Columns(m_wks.AddCol());
		m_nNumCol++;
		///---Sim 03-01-2007 QA80-9420 REIMPORT
		//if ( m_wks.GetNumCols() < m_nC1 + m_nNumCol )
			//m_wks.AddCol();
		if ( m_nC1 + m_nNumCol - 1 > m_nC2 )
		{
			string strColName;
			m_wks.InsertCol(m_nC1 + m_nNumCol - 1, NULL, strColName);
		}
		///---END QA80-9420 REIMPORT
		
		Column col = m_wks.Columns(m_nC1 + m_nNumCol - 1);
		///---END HOLD_ON_ORIGINAL_COLUMNS_SETTING
		
		col.SetInternalData(FSI_REAL); /// EJP 2006-06-09 v8.0425 PLCAMP_COL_TYPE_RUNTIME_ERR

		setColData(col, vfData);
		
		setColFormat(col, nColType, nChannelNum, nFileNo, nChannelNo, nSweepNo, strName, strLabel, strUnit);	

		/// Hong 01/25/07 ADD_MORE_COLUMN_INFO
		//SetColumnParameter(col, nFileNo, nChannelNo, nSweepNo); // Hong 02/09/07 START_TIME_ALREADY_IN_SAMPLE_RATE		
		SetColumnUserParameter(col, nFileNo, nChannelNo, nSweepNo);
		/// end ADD_MORE_COLUMN_INFO
		/// Hong 11/17/10 ORG-1517 WATERFALL_PLOT_NEED_X0_AS_Z_AXIS
		if ( !bSetHeadInfo )
			SetColumnParameter(col, nFileNo, nChannelNo, nSweepNo);
		/// end WATERFALL_PLOT_NEED_X0_AS_Z_AXIS
		
		///Iris 12/15/03 QA70-5711 FAIL_SETMEMORY_ON_NEWADDCOL
		#ifdef FAIL_SETMEMORY_ON_NEWADDCOL
		if(bSetHeadInfo)
		{
			//// AW 10/10/06 MORE_ON_XF_PCLAMP_HEADER_INFO 
			/// Hong 02/08/07 FIX_ERROR_START_TIEM
			//setHeaderInfo(nFileNo, col);
			//vector<float> vtData;
			//readTimeData(nFileNo, vtData);
			//float fStart = 	vtData[0];	
			//fStart = 0;  //start from 0;
			//double dStartTime = GetStartTime(nFileNo, -1, nSweepNo + 1);
			double dStartTime = GetStartTime(nFileNo, -1, nSweepNo); // Hong 02/15/07 GENERAL_INDEX__OFFSET_TO_ONE
			/// end FIX_ERROR_START_TIEM
			
			//float fIncrement = GetSampleInterval(nFileNo); //Get Time increment
			double dIncrement = GetSampleInterval(nFileNo); // Hong 02/08/07 MORE_PRECISE
			/// Hong 11/1/06 QA-9073 ADD_XUNITS_AND_XLONGNAME_ARGS_TO_EVENSAMPLING
			//m_wks.SetEvenSampling(fStart, fIncrement, col );
			m_wks.SetEvenSampling(dStartTime, dIncrement, col, _L("ms"), _L("Time") );
			/// end ADD_XUNITS_AND_XLONGNAME_ARGS_TO_EVENSAMPLING
			//// END MORE_ON_XF_PCLAMP_HEADER_INFO
			//m_fEndTime = fIncrement * ( vfData.GetSize() - 1 );// Hong 11/17/06 FIX_ERROR_END_TIME_FOR_TWO_INTERVAL_DATA 

		}	
		#endif //FAIL_SETMEMORY_ON_NEWADDCOL
		///End FAIL_SETMEMORY_ON_NEWADDCOL
	}
	
	void setColFormat(Column& col,int nColType, int nChannelNum, int nFileNo, int nChannelNo, int nSweepNo, string strFileName, string strLabel, string strUnit)
	{
		string strName;
		string strTemp;
		
		//Format col name
		if(1 < m_nFileNum)
		{
			strTemp = COL_NAME_FILE + nFileNo;	
			col.SetWidth(10);
		}

		if(TIME_COL == nColType)
		{
			strName = strTemp + COL_NAME_TIME;
			strLabel = COL_LABEL_TIME;
			col.SetType(OKDATAOBJ_DESIGNATION_X);
		}
		else
			if(CHANNEL_COL == nColType)
			{
				strName = strTemp + COL_NAME_CHANNEL + nChannelNo;
				col.SetType(OKDATAOBJ_DESIGNATION_Y);
			}
			else
				if(SWEEP_COL == nColType)
				{
					if(1 < nChannelNum)
					{
						strName = strTemp + COL_NAME_CHANNEL + nChannelNo + COL_NAME_SWEEP + nSweepNo;
					}
					else
					{
						strName = strTemp + COL_NAME_SWEEP + nSweepNo;
					}						
					col.SetType(OKDATAOBJ_DESIGNATION_Y);
				}
		col.SetName(strName);
				
		//Format col Label		
		/// Hong 09/19/07 v8.0704 AVOID_SET_LONGNAEM_DUMP_WARNING_MESSAGE
		//col.SetLabel(strLabel);
		strLabel.TrimLeft();
		strLabel.TrimRight();
		col.SetLongName(strLabel);
		/// end AVOID_SET_LONGNAEM_DUMP_WARNING_MESSAGE
		col.SetUnits(strUnit);
		col.SetComments(strFileName);
		//m_wks.ShowLabels(true);// Hong 12/07/06 FIX_SPARKLINE_DISAPPEAR
	}
	
	///// END ADD_PCLAMP_IMPORT_XF
	
	
	void setTreeFromIntVector(vector<int> vn, string strNodeName)
	{
		TreeNode trNode = m_trSetupInfo.AddNode(strNodeName);
		trNode.nVals = vn;
	}
	
	void setTreeFromStringVector(vector<string> vn, string strNodeName)
	{
		TreeNode trNode = m_trSetupInfo.AddNode(strNodeName);
		trNode.strVals = vn;
	}	
	
	bool setHeaderInfo(int nFileNo, Column& col)
	{
		bool 			bRet;
		vector<byte> 	vb;
		string 			strHeaderTag = HEADERINFO_TAG;
		string 			strHeadInfo;
		
		//Add header info icon and set EvenX start value and EvenX increment value
		vector<float> vfData;
		readTimeData(nFileNo, vfData);
		float fStart = 	vfData[0];	

		//float fIncrement = GetSampleInterval(nFileNo); //Get Time increment
		double fIncrement = GetSampleInterval(nFileNo); // Hong 02/08/07 MORE_PRECISE
		addHeaderInfoIcon(col, fStart, fIncrement);
		
		//Insert header info into col
		strHeadInfo = GetHeaderInfo(nFileNo);
		if(strHeadInfo.GetBytes(vb))
			bRet = col.SetMemory(strHeaderTag,vb);
		
		return bRet;
	}		
	
	//Iris 01/06/04 v8.0794 ADD_HEADERINFO_ICON
	bool addHeaderInfoIcon(Column col, float fStart, float fIncrement)
	{
		string strDatasetName = m_wks.GetPage().GetName() + "_"+ col.GetName();
		LT_set_str("%a", strDatasetName);
		
		string strSetStart = "set %a -f " + fStart;
		LT_execute(strSetStart);
		
		string strSetIncrement = "set %a -i " + fIncrement;
		LT_execute(strSetIncrement);
		
		return true;		
	}
	//End ADD_HEADERINFO_ICON
		
private:
	Tree 			m_trSetupInfo;
	int 			m_nFileNum;
	Worksheet 		m_wks;
	vector<ODWP> 	m_vPClampFiles;
///	vector<float>   m_vfTimeData;
	//float			m_fEndTime;// Hong 11/17/06 FIX_ERROR_END_TIME_FOR_TWO_INTERVAL_DATA
	
	///---Sim 02-05-2007 HOLD_ON_ORIGINAL_COLUMNS_SETTING
	int m_nC1;
	int m_nC2;	///---Sim 03-01-2007 QA80-9420 REIMPORT
	int m_nNumCol;
	///---END HOLD_ON_ORIGINAL_COLUMNS_SETTING
	BOOL m_bUseHoldingDuration;		/// AW 01/06/09 QA80-12413 ADD_HOLDING_DURATION_TIME_IN_PCLAMP
};
